(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1192725,      24030]
NotebookOptionsPosition[   1182101,      23865]
NotebookOutlinePosition[   1182422,      23879]
CellTagsIndexPosition[   1182379,      23876]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
PRL 103,046811 (2009); 2d qbcp; https://arxiv.org/pdf/1608.07488.pdf; 2d qbcp\
\
\>", "Section",
 CellChangeTimes->{{3.794106841704192*^9, 3.79410684679032*^9}, {
   3.794111780622961*^9, 3.7941117816131353`*^9}, {3.794305903008417*^9, 
   3.794305905996011*^9}, 
   3.795244999096024*^9},ExpressionUUID->"647b8485-6fa9-4d3c-8c7e-\
42d7a0c7ff96"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "ham", "]"}], ";", 
  RowBox[{"\[Sigma]x", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]y", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]z", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx", "=", 
   RowBox[{"2", "kx", " ", "ky"}]}], ";", " ", 
  RowBox[{"dz", "=", 
   RowBox[{
    SuperscriptBox["ky", "2"], "-", 
    SuperscriptBox["kx", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "ham", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", " ", 
   RowBox[{
    RowBox[{"\[Sigma]x", " ", "dx"}], "+", 
    RowBox[{"\[Sigma]z", " ", "dz"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", 
  RowBox[{"ham", "+", 
   RowBox[{"eV", " ", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.794107049143807*^9, 3.7941071966927843`*^9}, {
  3.794111603660844*^9, 3.794111641767564*^9}, {3.794111723686552*^9, 
  3.794111753630622*^9}, {3.7942942032101192`*^9, 3.7942942050522137`*^9}, {
  3.794304790161495*^9, 3.794304793782325*^9}, {3.794304911236301*^9, 
  3.7943049389831257`*^9}, {3.794304980010593*^9, 3.794304982696188*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"ee3ffe8b-acf3-40a7-9e18-2465e466b8fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"eV", "-", 
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ",", 
     RowBox[{"eV", "+", 
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["kx", "ky"]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["ky", "kx"], ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.794107172105233*^9, 3.794107197273172*^9}, 
   3.7941078495834503`*^9, 3.794111642482644*^9, {3.794111744131051*^9, 
   3.794111754193523*^9}, 3.794304797072895*^9, {3.794304921684972*^9, 
   3.79430494099371*^9}, {3.794304972892068*^9, 3.7943049834955997`*^9}, 
   3.794826607331348*^9, 3.794827274465499*^9, 3.794828493849428*^9, 
   3.794873099605234*^9, 3.7955195017350607`*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"fe4ecad7-2eab-46dc-96ec-ffb8fd2c0f18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ham", ",", "\[Psi]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", " ", "2"}], " ", "delx", " ", "dely", " ", "\[Sigma]x"}], 
    "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["delx", "2"], "-", 
       SuperscriptBox["dely", "2"]}], ")"}], " ", "\[Sigma]z"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "=", 
    RowBox[{"{", 
     RowBox[{"\[Psi]1", ",", "\[Psi]2"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"determining", " ", "bdy", " ", "conditions"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"ham", "+", "eV"}], ")"}], ".", "\[Psi]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.794826543815784*^9, 3.79482659674646*^9}, {
  3.7948270055277767`*^9, 3.7948270075117817`*^9}, {3.794827311709968*^9, 
  3.7948273858156157`*^9}, {3.794828453634635*^9, 3.7948284712896852`*^9}, {
  3.794828512758853*^9, 3.7948285226184196`*^9}, {3.794873645701441*^9, 
  3.794873658279049*^9}},ExpressionUUID->"619c8c89-1aee-4f2b-8b7d-\
a727c27cb655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["delx", "2"], "-", 
       SuperscriptBox["dely", "2"], "+", "eV"}], ")"}], " ", "\[Psi]1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "delx", " ", "dely"}], "+", "eV"}], ")"}], 
     " ", "\[Psi]2"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "delx", " ", "dely"}], "+", "eV"}], ")"}], 
     " ", "\[Psi]1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["delx", "2"]}], "+", 
       SuperscriptBox["dely", "2"], "+", "eV"}], ")"}], " ", "\[Psi]2"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.794826597586101*^9, 3.794826610511971*^9}, 
   3.7948272774440804`*^9, 3.7948273917664013`*^9, {3.794828476249055*^9, 
   3.794828523308407*^9}, 3.7948731023226633`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"27f8bf57-082c-4d85-b96b-e6882150f256"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ky", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["kx", "ky"]}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"kx", "  ", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["ky", "kx"], ",", "1"}], "}"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.794873087246673*^9, 3.7948730931054373`*^9}, {
  3.794873178776524*^9, 3.7948731920903893`*^9}, {3.794873333473915*^9, 
  3.794873424172042*^9}, {3.794873461753879*^9, 3.794873473747759*^9}, {
  3.794873511025516*^9, 3.794873512848662*^9}, {3.7948735725257063`*^9, 
  3.794873576738443*^9}, {3.7948736775263157`*^9, 3.794873680282065*^9}, {
  3.794874900982335*^9, 3.79487490122362*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"45a604ab-1cbc-4b49-aa46-980fef5135cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "kx"}], ",", "ky"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ky", ",", "kx"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.794873096323689*^9, 3.794873104247889*^9}, {
   3.794873181282658*^9, 3.794873193834128*^9}, {3.794873337398199*^9, 
   3.79487335631806*^9}, {3.7948733999449883`*^9, 3.7948734253747187`*^9}, {
   3.794873468148116*^9, 3.79487347437097*^9}, 3.794873515480494*^9, 
   3.794873577516451*^9, 3.7948736810666933`*^9, 3.7948749018892813`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"34d1471f-02f8-49a0-a96e-66d41677c48d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"e", ".", "g", "."}], ":", " ", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "=", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ky", ",", "kx"}], "}"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"kx", " ", "x"}], " ", "+", " ", 
         RowBox[{"ky", " ", "y"}]}], ")"}]}]]}]}], ";", " ", 
   RowBox[{
    RowBox[{"so", " ", "del_x", "  ", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], " ", "=", " ", 
    RowBox[{"\[ImaginaryI]", " ", "kx", "  ", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.794874755407489*^9, 
  3.7948749325006638`*^9}},ExpressionUUID->"11df85cd-f33a-40c7-b525-\
d8d6f3917d7e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\[Psi]", "]"}], ";", 
   RowBox[{"\[Psi]", "=", 
    RowBox[{"{", 
     RowBox[{"ky", ",", "kx"}], "}"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"conduction", " ", "band", " ", 
    RowBox[{"{", 
     RowBox[{"ky", ",", "kx"}], "}"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kx", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", 
  RowBox[{"2", "ky", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"2", "ky", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "+", 
  RowBox[{"kx", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7948998384391117`*^9, 3.794899958316153*^9}, {
   3.794900000859954*^9, 3.794900021385838*^9}, 3.7950055887343407`*^9, {
   3.795005700123839*^9, 
   3.795005703150345*^9}},ExpressionUUID->"fffce778-234b-4289-b37f-\
72ea0428cf26"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "kx"}], " ", "ky"}]], "Output",
 CellChangeTimes->{3.7949013010959063`*^9, 3.7950055959547577`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"2f456084-a225-4385-8c36-b39a8d2819fb"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["kx", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["ky", "2"]}]}]], "Output",
 CellChangeTimes->{3.7949013010959063`*^9, 3.795005595957512*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"82e21a45-55ab-4886-b993-3c5ad827638a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\[Psi]", "]"}], ";", 
   RowBox[{"\[Psi]", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "kx"}], ",", "ky"}], "}"}]}], ";"}], 
  RowBox[{"(*", "  ", 
   RowBox[{"valence", " ", "band", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "kx"}], ",", "ky"}], "}"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kx", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", 
  RowBox[{"2", "ky", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"2", "ky", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "+", 
  RowBox[{"kx", " ", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7949001820497293`*^9, 3.794900185555353*^9}, 
   3.795005592450989*^9, {3.7950056848092813`*^9, 
   3.795005688882897*^9}},ExpressionUUID->"5c6b9ace-da34-45c1-ac85-\
451d79f43785"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["kx", "2"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["ky", "2"]}]}]], "Output",
 CellChangeTimes->{3.79490130356174*^9, 3.795005593173077*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"f34139b2-d6a6-404f-90fe-91ab7e215ecb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "kx"}], " ", "ky"}]], "Output",
 CellChangeTimes->{3.79490130356174*^9, 3.7950055931765003`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"bf575a14-0956-49c8-9b68-78fe519f36f4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"valence", " ", 
    RowBox[{"band", ":", " ", "en"}]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["kx", "2"]}], "-", 
     SuperscriptBox["ky", "2"], "+", "V"}], " ", "=", 
    RowBox[{
     RowBox[{">", " ", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], " ", "-", "V"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"-", "en"}], " ", "=", 
      RowBox[{
       RowBox[{">", "  ", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"]}]}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "en"}], " ", "+", " ", 
         RowBox[{"V", "\[IndentingNewLine]", "conductance", " ", 
          RowBox[{"band", ":", " ", "en"}]}]}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", "V"}], " ", "=", 
         RowBox[{
          RowBox[{">", " ", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"]}]}], " ", "=", " ", 
          RowBox[{"en", " ", "-", " ", "V"}]}]}]}]}]}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.79551942434182*^9, 3.795519448177997*^9}, {
  3.795519609977887*^9, 
  3.79551961614003*^9}},ExpressionUUID->"799e9130-f89c-4eb3-936f-\
e69ed1588599"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["kl", "2"], "+", 
     SuperscriptBox["ky", "2"]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"en", " ", 
       RowBox[{"(", 
        RowBox[{"in", " ", "leads"}], ")"}], " ", "and", " ", 
       SuperscriptBox["kt", "2"]}], "+", 
      SuperscriptBox["ky", "2"]}], " ", "=", " ", 
     RowBox[{"en", "-", 
      RowBox[{"eV", " ", 
       RowBox[{"(", 
        RowBox[{"in", " ", "slab"}], ")"}]}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kl", "=", 
     RowBox[{
      SqrtBox["en"], " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ";", 
    RowBox[{"ky", "=", 
     RowBox[{
      SqrtBox["en"], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ";", 
    RowBox[{"kt", "=", 
     SqrtBox[
      RowBox[{"en", "-", "V", "-", 
       RowBox[{"en", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"16", " ", 
      SuperscriptBox["kl", "2"], " ", 
      SuperscriptBox["kt", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kl", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["ky", "2"]}]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kt", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["ky", "2"]}]}], ")"}], "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]], 
         " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kl", "-", "kt"}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"kl", " ", "kt"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kl", "+", "kt"}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"kl", " ", "kt"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}], "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kl", "-", "kt"}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"kl", " ", "kt"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kl", "+", "kt"}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"kl", " ", "kt"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}], "2"]}]}], ")"}]}], ")"}]}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"%", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]t", "\[Rule]", "0"}], ",", 
       RowBox[{"\[Theta]", "\[Rule]", "0"}]}], "}"}]}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"kx", ",", "ky", ",", "kl", ",", "kt"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.794877564676523*^9, 3.794877594753974*^9}, {
   3.794879250422655*^9, 3.7948792532183037`*^9}, {3.794879286119814*^9, 
   3.794879381751937*^9}, {3.794879428666168*^9, 3.7948794776587343`*^9}, {
   3.794879511519629*^9, 3.794879535763246*^9}, {3.7948795890334787`*^9, 
   3.7948796116022673`*^9}, {3.7948796509127493`*^9, 3.794879659824751*^9}, {
   3.794879698199398*^9, 3.794879710558218*^9}, {3.794901599084692*^9, 
   3.794901607430892*^9}, {3.7950058563138247`*^9, 3.795005864951294*^9}, 
   3.795005921155725*^9, {3.800982697903165*^9, 3.800982748816869*^9}, {
   3.800983377502594*^9, 3.800983378051811*^9}},
 CellLabel->
  "In[479]:=",ExpressionUUID->"eb1c8664-6395-4275-b13b-c1b508da5f72"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"16", " ", "en", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"en", "-", "V", "-", 
      RowBox[{"en", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"en", "-", "V", "+", 
       RowBox[{"en", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"en", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", "en", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], "2"]}], 
   ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "L", " ", 
         SqrtBox[
          RowBox[{"en", "-", "V", "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
          SqrtBox[
           RowBox[{"en", "-", "V", "-", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "2"],
        " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           SqrtBox[
            RowBox[{"en", "-", "V", "-", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
        "2"]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
          SqrtBox[
           RowBox[{"en", "-", "V", "-", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "2"],
        " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           SqrtBox[
            RowBox[{"en", "-", "V", "-", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
        "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "L", " ", 
         SqrtBox[
          RowBox[{"en", "-", "V", "-", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
          SqrtBox[
           RowBox[{"en", "-", "V", "-", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "2"],
        " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           SqrtBox[
            RowBox[{"en", "-", "V", "-", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
        "2"]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
          SqrtBox[
           RowBox[{"en", "-", "V", "-", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ")"}], "2"],
        " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           SqrtBox[
            RowBox[{"en", "-", "V", "-", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ")"}], 
        "2"]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.794877582951891*^9, 3.794877595852656*^9}, 
   3.794879485487952*^9, 3.794879544043666*^9, 3.794879620233603*^9, 
   3.79487966806012*^9, 3.7949016104157333`*^9, {3.795005917500074*^9, 
   3.795005921681163*^9}, {3.800982724456655*^9, 3.8009827492476273`*^9}, 
   3.800983379056176*^9},
 CellLabel->
  "Out[480]=",ExpressionUUID->"08e417b2-00af-4a04-b6d5-440b4a9f9b77"],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", " ", "en", " ", 
   RowBox[{"(", 
    RowBox[{"en", "-", "V"}], ")"}]}], 
  RowBox[{
   RowBox[{"8", " ", 
    SuperscriptBox["en", "2"]}], "-", 
   RowBox[{"8", " ", "en", " ", "V"}], "+", 
   SuperscriptBox["V", "2"], "-", 
   RowBox[{
    SuperscriptBox["V", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "L", " ", 
      SqrtBox[
       RowBox[{"en", "-", "V"}]]}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.794877582951891*^9, 3.794877595852656*^9}, 
   3.794879485487952*^9, 3.794879544043666*^9, 3.794879620233603*^9, 
   3.79487966806012*^9, 3.7949016104157333`*^9, {3.795005917500074*^9, 
   3.795005921681163*^9}, {3.800982724456655*^9, 3.8009827492476273`*^9}, 
   3.800983379060706*^9},
 CellLabel->
  "Out[481]=",ExpressionUUID->"ef9c05e0-e78d-4971-9593-aca55e6692e4"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"cc20b903-baaa-4aa8-b9a4-190f739c05e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finally", "Section",
 CellChangeTimes->{{3.795070782512372*^9, 3.7950707842252607`*^9}, {
  3.7951279777604313`*^9, 
  3.795127979215774*^9}},ExpressionUUID->"b1689f1d-4e74-4800-bb96-\
b2c76baaeaee"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[Psi]", "]"}], ";", 
  RowBox[{"\[Psi]", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]1", ",", "\[Psi]2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"idx", " ", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"ky", " ", "y"}], "]"}]}], " ", "-", 
   RowBox[{"2", 
    SuperscriptBox["\[ImaginaryI]", "2"], "ky", " ", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"[", "2", "]"}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"ky", " ", "y"}], "]"}]}]}], "/.", 
  RowBox[{"y", "\[Rule]", "0"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"2", 
    SuperscriptBox["\[ImaginaryI]", "2"], "ky", " ", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{"ky", " ", "y"}], "]"}]}], "+", 
   RowBox[{"idx", " ", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"[", "2", "]"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"ky", " ", "y"}], "]"}]}]}], "/.", 
  RowBox[{"y", "\[Rule]", "0"}]}]}], "Input",
 CellChangeTimes->{{3.7950709775006857`*^9, 3.7950710553100863`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"8ec12633-d12e-4e71-9ff3-ba99c1270717"],

Cell[BoxData[
 RowBox[{"2", " ", "ky", " ", "\[Psi]2"}]], "Output",
 CellChangeTimes->{3.795071024702722*^9, 3.795071055961254*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"a0ca4245-f1b3-4382-8d5b-11d18fc3f611"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "ky", " ", "\[Psi]1"}]], "Output",
 CellChangeTimes->{3.795071024702722*^9, 3.79507105596367*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"f63007ee-cc02-4c42-873a-1b65b73f6f3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["V>en", "Subsection",
 CellChangeTimes->{{3.795071580007374*^9, 3.795071585058373*^9}, 
   3.795131312754116*^9, 
   3.795590483693345*^9},ExpressionUUID->"9bbf910e-c3b7-438f-a91a-\
4583da140052"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"v", ",", "vs", ",", "s", ",", "sp", ",", "kl", ",", "kt"}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"V", ">", 
       RowBox[{"en", " ", 
        RowBox[{"case", ":", "\[IndentingNewLine]", " ", 
         RowBox[{"valence", " ", "band", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "kx"}], ",", "ky"}], "}"}]}], ":", " ", "en"}]}]}], 
      "=", " ", 
      RowBox[{
       RowBox[{"eV", "-", 
        SuperscriptBox["kx", "2"], "-", 
        SuperscriptBox["ky", "2"]}], " ", "=", 
       RowBox[{
        RowBox[{">", " ", 
         SuperscriptBox["kx", "2"]}], " ", "=", " ", 
        RowBox[{"eV", "-", "en", "-", 
         SuperscriptBox["ky", "2"]}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"conduction", " ", "band", " ", 
        RowBox[{"{", 
         RowBox[{"ky", ",", "kx"}], "}"}]}], ":", "  ", "en"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"eV", "+", 
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}], " ", "=", 
       RowBox[{
        RowBox[{">", " ", 
         SuperscriptBox["kx", "2"]}], " ", "=", " ", 
        RowBox[{"en", "-", "eV", "-", 
         SuperscriptBox["ky", "2"]}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"continuity", " ", "conditions", " ", "for", " ", "x"}], "-", 
      RowBox[{"transport", ":", " ", 
       RowBox[{
        RowBox[{"delx", " ", "\[Psi]1"}], " ", "-", " ", 
        RowBox[{"2", "  ", "dely", " ", "\[Psi]2"}]}]}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "and", "  ", "\[IndentingNewLine]", "2", " ", "dely", " ", "\[Psi]1"}], 
      " ", "+", "  ", 
      RowBox[{"delx", " ", "\[Psi]2", " ", "are", " ", "continuous"}]}], ";", 
     " ", 
     RowBox[{
     "let", " ", "us", " ", "consider", " ", "conduction", " ", "band", " ", 
      "wvfn", " ", "incident"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "sol", ",", "eq1", ",", "eq2", ",", "eq3", ",", "eq4", ",", "r", ",", "t", 
    ",", "rp", ",", "tp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ky", ",", "kx"}], "}"}], "+", 
       RowBox[{"r", 
        RowBox[{"{", 
         RowBox[{"ky", ",", 
          RowBox[{"-", "kx"}]}], "}"}]}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "kt"}], ",", "ky"}], "}"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"{", 
         RowBox[{"kt", ",", "ky"}], "}"}]}]}], 
      SqrtBox["vs"]]}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "kt"}], ",", "ky"}], "}"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"b", 
        RowBox[{"{", 
         RowBox[{"kt", ",", "ky"}], "}"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{"t", 
       RowBox[{"{", 
        RowBox[{"ky", ",", "kx"}], "}"}], " "}], 
      SqrtBox["v"]]}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eq1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"eq2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&&", " ", 
      RowBox[{
       RowBox[{"eq1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"eq2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "t", ",", "a", ",", "b"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rp", "=", 
  RowBox[{
   RowBox[{"r", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"tp", "=", 
  RowBox[{
   RowBox[{"t", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{
  3.7948736389775743`*^9, {3.794873700028576*^9, 3.7948737427400827`*^9}, {
   3.794873811229525*^9, 3.794873916735141*^9}, {3.794873949662161*^9, 
   3.794873959526718*^9}, {3.7948742351731987`*^9, 3.794874256906666*^9}, {
   3.7948743302518578`*^9, 3.794874370799529*^9}, {3.794874425186573*^9, 
   3.794874431362528*^9}, {3.794874468361292*^9, 3.794874484763464*^9}, {
   3.794874535020276*^9, 3.794874543183934*^9}, {3.794874578389473*^9, 
   3.794874679493874*^9}, {3.7948749373498793`*^9, 3.794875307964197*^9}, {
   3.794875346402451*^9, 3.794875466881118*^9}, {3.794875570071673*^9, 
   3.794875650920072*^9}, {3.7948757982730217`*^9, 3.794875822154565*^9}, {
   3.794875864243043*^9, 3.794875886975236*^9}, {3.7948759300300417`*^9, 
   3.794876215838956*^9}, {3.7948762560045958`*^9, 3.794876688083026*^9}, {
   3.794877002974566*^9, 3.7948771086572447`*^9}, {3.794877613561426*^9, 
   3.79487762528379*^9}, {3.7948880328721523`*^9, 3.794888035463818*^9}, {
   3.794888115296043*^9, 3.794888129097959*^9}, {3.794891771478714*^9, 
   3.794891906442079*^9}, 3.7948997902707863`*^9, {3.794900131396542*^9, 
   3.794900160553969*^9}, {3.794900201649561*^9, 3.794900298033409*^9}, 
   3.79490079886339*^9, 3.7949943647960863`*^9, {3.795001003553406*^9, 
   3.795001059786661*^9}, {3.7950011091786823`*^9, 3.7950011154617767`*^9}, {
   3.7950061028390083`*^9, 3.795006247014964*^9}, {3.795006277896366*^9, 
   3.795006307292655*^9}, 3.795007183408887*^9, {3.79507110255811*^9, 
   3.7950711784692497`*^9}, {3.795071225109119*^9, 3.7950712529109783`*^9}, 
   3.795590479329413*^9},ExpressionUUID->"6b7bceca-e0d1-41ad-a7e6-\
b9ae147a6a61"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["kt", "2"], " ", 
      SuperscriptBox["kx", "2"]}], "-", 
     SuperscriptBox["ky", "4"]}], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    SuperscriptBox["ky", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kt", "2"], " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      SuperscriptBox["ky", "4"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.795071256877323*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"dfe42b09-265a-48cd-8376-8b71e32b5051"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    SuperscriptBox["ky", "2"]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
     SuperscriptBox["ky", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["kt", "2"], " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       SuperscriptBox["ky", "4"]}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"kt", " ", "L"}], "]"}]}]}]]}]], "Output",
 CellChangeTimes->{3.795071256913466*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"3c4e1aa6-4899-492f-a980-e632f1ceebac"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"c657343a-a156-494e-9e70-1c0ead6e2f0d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"exp", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
       SuperscriptBox["ky", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
        SuperscriptBox["ky", "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kt", "2"], " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          SuperscriptBox["ky", "4"]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        RowBox[{
         SqrtBox["V"], 
         SqrtBox[
          RowBox[{"1", "-", "rat", " ", "-", 
           RowBox[{"rat", "  ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}]}], 
      "}"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "\[Phi]", ",", "L", ",", "rat"}], "}"}], 
       "\[Element]", " ", "Reals"}], " ", "&&", " ", 
      RowBox[{"V", ">", "0"}], " ", "&&", " ", 
      RowBox[{"L", ">", "0"}], " ", "&&", " ", 
      RowBox[{"rat", ">", "0"}], " ", "&&", " ", 
      RowBox[{"rat", "<", "1"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"exp1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"exp", "/.", 
     RowBox[{"rat", "\[Rule]", "1"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "L", ",", "\[Phi]"}], "}"}], "\[Element]", " ", 
       "Reals"}], " ", "&&", " ", 
      RowBox[{"V", ">", "0"}], " ", "&&", " ", 
      RowBox[{"L", ">", "0"}]}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.800986800679298*^9, 3.800986918336363*^9}, {
  3.800987007513294*^9, 3.8009870120523567`*^9}, {3.800987058197826*^9, 
  3.800987069308123*^9}, {3.800987105412877*^9, 3.8009871286064987`*^9}, {
  3.8009871616568336`*^9, 3.800987171741457*^9}, {3.8009872464699183`*^9, 
  3.800987383233886*^9}, {3.800987945048991*^9, 3.800987971852512*^9}, {
  3.800988179945702*^9, 3.800988242744452*^9}, {3.80098828926206*^9, 
  3.8009882975050793`*^9}, {3.800988340711513*^9, 3.8009883796862297`*^9}, {
  3.800988413558082*^9, 3.800988424060265*^9}, {3.800988600978656*^9, 
  3.800988622343326*^9}, {3.800988652869772*^9, 3.8009886607416477`*^9}, {
  3.800989520296751*^9, 3.800989574726555*^9}, {3.8011169858428917`*^9, 
  3.8011170802050047`*^9}, {3.801117171012273*^9, 3.8011171718009367`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"65804f9d-79af-42a2-8c43-b7f1309dc4fd"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", " ", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "rat"}], " ", "V", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "rat", "+", 
          RowBox[{"rat", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}], ")"}]}]]}], ")"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"L", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "V"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "rat", "+", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}], ")"}]}]]}], 
        "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "rat"}], " ", "V", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "rat", "+", 
           RowBox[{"rat", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}], ")"}]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["V"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"3", " ", "rat"}], "+", 
         RowBox[{"rat", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"L", " ", 
          SqrtBox[
           RowBox[{"V", " ", 
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"3", " ", "rat"}], "+", 
              RowBox[{"rat", " ", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}]}]]}], 
         SqrtBox["2"]], "]"}]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "rat", " ", 
       SqrtBox["V"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "4"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"L", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "V"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "rat", "+", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}], ")"}]}]]}], 
        "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.801117085215687*^9, 3.801117176615945*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"5e833014-4ec6-4834-aecc-7174c4a7dc5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Csc", "[", 
    RowBox[{
     RowBox[{"2", " ", "\[Phi]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "]"}]}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", "\[Phi]"}], "]"}]}]], "Output",
 CellChangeTimes->{3.801117085215687*^9, 3.801117177051756*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"d131e3a4-057e-4821-a522-180108768d19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abst", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{
       RowBox[{"2", " ", "\[Phi]"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "\[Phi]"}], "]"}], 
     RowBox[{"Csc", "[", 
      RowBox[{
       RowBox[{"2", " ", "\[Phi]"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "\[Phi]"}], "]"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "L", ",", "\[Phi]"}], "}"}], "\[Element]", " ", 
       "Reals"}], " ", "&&", " ", 
      RowBox[{"V", ">", "0"}], " ", "&&", " ", 
      RowBox[{"L", ">", "0"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.801117103835023*^9, 3.8011171455531273`*^9}, {
  3.8011171972291718`*^9, 3.801117201023861*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"dc7c60db-1e84-4962-b443-d9ed3a0898ef"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "\[Phi]"}], "]"}]}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "\[Phi]"}], "]"}], "-", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", "L", " ", 
     SqrtBox["V"], " ", 
     RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]]], "Output",
 CellChangeTimes->{{3.801117125028035*^9, 3.801117146720491*^9}, 
   3.801117202179315*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"bb1b02a5-be58-431d-86a3-8057025f3c4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "\[Phi]"}], "]"}]}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "\[Phi]"}], "]"}], "-", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "L", " ", 
       SqrtBox["V"], " ", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]], 
   RowBox[{"Cos", "[", "\[Phi]", "]"}], 
   RowBox[{"\[DifferentialD]", "\[Phi]"}]}]}]], "Input",
 CellChangeTimes->{{3.801117265649905*^9, 3.801117278665325*^9}, {
  3.801117328061491*^9, 3.80111733815668*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"ff5dbbf7-d718-439b-82e6-6fce943fc765"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.801117322118949*^9, 3.8011173809651423`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"934584cd-b001-45ea-b249-267fed4b8007"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8011174053142548`*^9, 3.801117432768762*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"10208a5a-3cec-4640-b229-4ae6fa888c78"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk4lWkfB3DUGDHZm16yvNZiZCxhMtW3qKz12iKFKGWSQpqJmiwNZY2G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       "]]},
     Annotation[#, "Charting`Private`Tag$43571#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.6480542837364232},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0.6480542837364232, 0.9999999999999998}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.801117433290818*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"088c5f33-d649-4ae8-8941-95605f8376c4"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"c66eda46-1731-40c6-9419-e8d760e57d75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"V", " ", ">", " ", 
     RowBox[{"en", " ", "case"}]}], ";", " ", 
    RowBox[{"kl", "=", 
     RowBox[{
      SqrtBox["en"], " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ";", 
    RowBox[{"ky", "=", 
     RowBox[{
      SqrtBox["en"], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"tamp", ",", "ramp"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ramp", "[", 
      RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["kt", "2"], " ", 
            SuperscriptBox["kx", "2"]}], "-", 
           SuperscriptBox["ky", "4"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kt", "2"], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "4"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"L", "\[Rule]", "1"}], ",", 
         RowBox[{"kx", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"ky", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"kt", "\[Rule]", 
          RowBox[{
           SqrtBox["V"], 
           SqrtBox[
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"rat", "-", "1"}], "]"}], "-", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}]]}]}]}], "}"}]}], 
      "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tamp", "[", 
      RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", 
           " ", 
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["kt", "2"], " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             SuperscriptBox["ky", "4"]}], ")"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"kt", " ", "L"}], "]"}]}]}]]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"L", "\[Rule]", "1"}], ",", 
         RowBox[{"kx", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"ky", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"kt", "\[Rule]", 
          RowBox[{
           SqrtBox["V"], 
           SqrtBox[
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"rat", "-", "1"}], "]"}], "-", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}]]}]}]}], "}"}]}], 
      "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage11.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage11.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.3", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.3", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.5", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.5", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.8", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.8", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.3", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.5", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.8", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage12.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage12.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.3", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.3", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.5", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.5", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "0.8", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "0.8", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.3", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.5", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "0.8", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage13.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage13.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"enL", ",", "g", ",", "VL"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.794990929199575*^9, 3.7949909424739933`*^9}, {
   3.794990982384509*^9, 3.794991139278957*^9}, {3.794991392642338*^9, 
   3.7949913943561497`*^9}, {3.7949922294622297`*^9, 3.794992249971951*^9}, {
   3.794992282826687*^9, 3.794992391006621*^9}, {3.7949924492682877`*^9, 
   3.7949924672111*^9}, {3.7949924978243647`*^9, 3.794992500850062*^9}, {
   3.794993880477866*^9, 3.79499397166394*^9}, {3.794994402845872*^9, 
   3.794994443474368*^9}, {3.794994984219358*^9, 3.794995037644314*^9}, {
   3.794995070300199*^9, 3.794995070987803*^9}, {3.794995807842152*^9, 
   3.794995849555065*^9}, {3.794995920866191*^9, 3.794995931053337*^9}, {
   3.794996084145514*^9, 3.79499611321902*^9}, {3.794999323766118*^9, 
   3.794999346310319*^9}, {3.7949994111393023`*^9, 3.794999469871377*^9}, {
   3.794999514754767*^9, 3.794999617813569*^9}, 3.795001355813862*^9, 
   3.7950064039278173`*^9, 3.795006445164651*^9, 3.795006564374877*^9, 
   3.795006668941828*^9, {3.795006802630272*^9, 3.795006819597292*^9}, {
   3.79500685762649*^9, 3.795006872777776*^9}, {3.795006998952065*^9, 
   3.795007031628867*^9}, 3.795007143557459*^9, {3.795007240855526*^9, 
   3.795007272736888*^9}, {3.795007673579121*^9, 3.7950076742154713`*^9}, {
   3.795007725242867*^9, 3.7950078480671873`*^9}, {3.795007897269895*^9, 
   3.795007924527179*^9}, {3.795008024692006*^9, 3.795008059630018*^9}, {
   3.7950713875592937`*^9, 3.795071422095038*^9}, 3.795072258086236*^9, {
   3.795072339827846*^9, 3.795072347984599*^9}, 3.795072516597661*^9, {
   3.795131319212615*^9, 3.795131325323358*^9}, {3.795131361895708*^9, 
   3.7951314363480864`*^9}, {3.795316176758428*^9, 3.795316177686542*^9}, {
   3.7953162187271767`*^9, 3.79531624217647*^9}, {3.7953162839314528`*^9, 
   3.7953163740524683`*^9}, 3.7953164327713127`*^9, {3.7953164639598503`*^9, 
   3.795316503982395*^9}, {3.795316539971538*^9, 3.7953165476762953`*^9}, {
   3.79531657879653*^9, 3.795316579561225*^9}, {3.7953166145715647`*^9, 
   3.795316619936108*^9}, {3.795316693647161*^9, 3.795316693835166*^9}, {
   3.795316727216168*^9, 3.79531681372264*^9}, {3.7953168604758368`*^9, 
   3.795316867658861*^9}, {3.795316912522963*^9, 3.79531702834694*^9}, {
   3.795317080519487*^9, 3.795317190249969*^9}, {3.795317223426475*^9, 
   3.7953173463956327`*^9}, {3.7953175373518267`*^9, 3.795317576517248*^9}, {
   3.795317610048098*^9, 3.795317659439999*^9}, {3.795317850719987*^9, 
   3.795317860029193*^9}, {3.795317930900023*^9, 3.795317931084566*^9}, {
   3.795410417094516*^9, 3.7954104411401653`*^9}, {3.795424981535676*^9, 
   3.79542499239359*^9}, {3.8009809585043163`*^9, 3.8009810449321003`*^9}, 
   3.800981099274371*^9, {3.800981179766141*^9, 3.8009812672194853`*^9}, {
   3.800981315306076*^9, 3.800981465317588*^9}, {3.800981587416443*^9, 
   3.800981589186167*^9}, {3.80098166200723*^9, 3.800981691798195*^9}, {
   3.800981796136702*^9, 3.800981896268852*^9}, {3.8009821534725018`*^9, 
   3.8009821652178583`*^9}, {3.800982233489505*^9, 3.800982295947847*^9}, {
   3.800982326369401*^9, 3.800982329724209*^9}, {3.800982526871256*^9, 
   3.800982529828299*^9}, 3.800982599095886*^9, {3.8009828146567097`*^9, 
   3.800982818928892*^9}, {3.80098287510387*^9, 3.800982906059778*^9}, {
   3.800982948051199*^9, 3.800983090755484*^9}, {3.800983136307732*^9, 
   3.80098319271378*^9}, {3.8009844136655083`*^9, 3.8009844310581007`*^9}, {
   3.800984618746749*^9, 3.8009846642054462`*^9}, {3.80098471002514*^9, 
   3.800984718211485*^9}, {3.8009847510769176`*^9, 3.800984874662521*^9}, {
   3.800986200445262*^9, 3.8009862376557693`*^9}},
 CellLabel->
  "In[1041]:=",ExpressionUUID->"813ea241-00f8-44fc-852c-346bf9b53486"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwkWHc8lmEXphRFFJLIyiqKQjLSsbJSirJHRlZSikI2GUlW9l7Ze8/b3vS+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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.8009862465515223`*^9},
 CellLabel->
  "Out[1053]=",ExpressionUUID->"dc60412a-174f-416e-8729-e2a269b025d9"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmHc81t///yMipHpbRXYIpZCGuJ5WKcmIzDJSCckom2xly04oe2bvdey9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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.800986246905923*^9},
 CellLabel->
  "Out[1055]=",ExpressionUUID->"e6294e52-88fa-4f85-b9d5-0d40d3aa966d"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwsmHc8lt//+FGpKIpEyEhKoRSy4kVkZ6QisrNC2aSibMneI2TvmT2Ovffe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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.800986247326288*^9},
 CellLabel->
  "Out[1066]=",ExpressionUUID->"3a144754-1884-4b78-abaf-1e6fec1fbd29"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkm3c419///1H23lkVQkI2Wa+HREKyswqJMpKMZGaLErIim8ge2eR17Oy9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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.800986247899055*^9},
 CellLabel->
  "Out[1068]=",ExpressionUUID->"959aca7c-5672-4206-840b-4bd94abdede1"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxsmHk41N/7/ylaZEm2SgjZEhFRKbfIrmQpFNFKZctSSFlSUpSQrQghZN+y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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.800986248552537*^9},
 CellLabel->
  "Out[1079]=",ExpressionUUID->"6742386f-7049-4d51-baf5-1944bfc61aaa"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxk23c0V2/8AHCJZItQskclGlYI942SrSJJiehry8jILCMyslc2IXtmx+ex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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.7950723493757763`*^9, 3.795072517509426*^9, 3.795072785398576*^9, 
   3.79513132619059*^9, {3.795131415254456*^9, 3.79513143746626*^9}, {
   3.795316179234893*^9, 3.795316185163436*^9}, {3.795316221230337*^9, 
   3.795316243146414*^9}, {3.795316284665001*^9, 3.795316321924121*^9}, {
   3.7953163587462606`*^9, 3.795316374804739*^9}, 3.7953164335153713`*^9, {
   3.7953164659905977`*^9, 3.795316504617971*^9}, {3.7953165403910418`*^9, 
   3.7953165483555183`*^9}, 3.795316580507131*^9, 3.7953166947818527`*^9, {
   3.79531673463841*^9, 3.795316765399665*^9}, 3.795316814465075*^9, 
   3.795316868636725*^9, 3.795317139661525*^9, {3.795317233723757*^9, 
   3.795317291368223*^9}, {3.795317330842677*^9, 3.795317347302528*^9}, {
   3.795317578815548*^9, 3.79531761738526*^9}, {3.795317650427045*^9, 
   3.7953176598761997`*^9}, 3.7953178604082117`*^9, 3.7954249932388678`*^9, 
   3.800981426229602*^9, 3.800981484917989*^9, 3.800981699864213*^9, 
   3.800981910743539*^9, 3.80098302457749*^9, 3.800983063866725*^9, 
   3.800983095342224*^9, 3.800983194875265*^9, 3.8009844333421917`*^9, 
   3.80098466901379*^9, 3.800984720982265*^9, {3.8009848189736013`*^9, 
   3.8009848766048727`*^9}, 3.8009862490146427`*^9},
 CellLabel->
  "Out[1081]=",ExpressionUUID->"b255f5e6-a894-4900-b3c2-2531929f47b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Fano", " ", "factor", " ", "for", " ", "en"}], "=", 
    RowBox[{"V", "/", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"ttdag", ",", "t", ",", "dat1", ",", "dat2", ",", "dat3"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "[", 
      RowBox[{"V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", 
           " ", 
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["kt", "2"], " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             SuperscriptBox["ky", "4"]}], ")"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"kx", " ", "\[Rule]", 
           RowBox[{
            SqrtBox[
             RowBox[{" ", "en"}]], " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
          RowBox[{"ky", "\[Rule]", " ", 
           RowBox[{
            SqrtBox["en"], " ", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
          RowBox[{"kt", "\[Rule]", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"V", "-", "en"}], ")"}], "-", 
             RowBox[{"en", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], 
       ")"}], "/.", 
      RowBox[{"en", "\[Rule]", 
       RowBox[{"V", "/", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"fn", ",", "int", ",", "dat1", ",", "dat2", ",", "dat3"}], "]"}],
     ";", 
    RowBox[{
     RowBox[{"int", "[", 
      RowBox[{"V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{"t", "[", 
      RowBox[{
       RowBox[{"V", "/", 
        SuperscriptBox["L", "2"]}], ",", "\[Theta]"}], "]"}]}], ";", 
    RowBox[{"L", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat1", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"int", "[", 
             RowBox[{"1", ",", "\[Theta]"}], "]"}], "]"}], "2"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}], ",", "0.001"}], "}"}]}], "]"}], "//", 
      "Quiet"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat2", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"int", "[", 
             RowBox[{"50", ",", "\[Theta]"}], "]"}], "]"}], "2"]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}], ",", "0.001"}], "}"}]}], "]"}], "//", 
      "Quiet"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat3", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"int", "[", 
             RowBox[{"100", ",", "\[Theta]"}], "]"}], "]"}], "2"]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"\[Pi]", "/", "2"}], ",", "0.001"}], "}"}]}], "]"}], "//", 
      "Quiet"}]}], ";"}], "\[IndentingNewLine]", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{"int", "[", 
      RowBox[{"1", ",", 
       RowBox[{"\[Pi]", "/", "4.0"}]}], "]"}], "]"}], "2"], 
   "\[IndentingNewLine]", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{"int", "[", 
      RowBox[{"50", ",", 
       RowBox[{"\[Pi]", "/", "4.0"}]}], "]"}], "]"}], "2"], 
   "\[IndentingNewLine]", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{"int", "[", 
      RowBox[{"100", ",", 
       RowBox[{"\[Pi]", "/", "4.0"}]}], "]"}], "]"}], "2"], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"V", ",", "L"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dat1", ",", "dat2", ",", "dat3"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "4"}], ",", "0", ",", 
          RowBox[{"\[Pi]", "/", "4"}], ",", " ", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", " ", "Automatic"}], 
       "}"}]}]}], 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{",", 
       RowBox[{"PlotTheme", "\[Rule]", " ", "\"\<Grid\>\""}]}], "]"}], "*)"}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{{3.795132639526732*^9, 3.795132735666053*^9}, {
  3.795132775633759*^9, 3.795132794574547*^9}, {3.795133159960595*^9, 
  3.795133190489365*^9}, {3.795133220761788*^9, 3.795133253987318*^9}, {
  3.795133362604094*^9, 3.7951334084120293`*^9}, {3.795133520630156*^9, 
  3.7951335567217093`*^9}, {3.795133739370619*^9, 3.7951337479344*^9}, {
  3.795133779208102*^9, 3.7951338446911287`*^9}, {3.795133878021369*^9, 
  3.795133931867319*^9}, {3.7951340191912622`*^9, 3.7951340413919077`*^9}},
 CellLabel->
  "In[1908]:=",ExpressionUUID->"e9df3359-01b0-4555-9289-93291a1a7610"],

Cell[BoxData["0.9999999999999998`"], "Output",
 CellChangeTimes->{{3.7951327131445417`*^9, 3.795132736289179*^9}, {
   3.795132776418398*^9, 3.795132795452485*^9}, {3.7951331919616823`*^9, 
   3.795133254982712*^9}, {3.795133374590995*^9, 3.795133409500504*^9}, 
   3.795133557718029*^9, 3.795133749086506*^9, {3.795133813374647*^9, 
   3.7951338463239326`*^9}, {3.795133888683016*^9, 3.795133932699235*^9}, {
   3.7951340201934643`*^9, 3.795134042195642*^9}},
 CellLabel->
  "Out[1914]=",ExpressionUUID->"39c8b22b-32aa-48e4-99c3-7b715360dd85"],

Cell[BoxData["0.9999999999999998`"], "Output",
 CellChangeTimes->{{3.7951327131445417`*^9, 3.795132736289179*^9}, {
   3.795132776418398*^9, 3.795132795452485*^9}, {3.7951331919616823`*^9, 
   3.795133254982712*^9}, {3.795133374590995*^9, 3.795133409500504*^9}, 
   3.795133557718029*^9, 3.795133749086506*^9, {3.795133813374647*^9, 
   3.7951338463239326`*^9}, {3.795133888683016*^9, 3.795133932699235*^9}, {
   3.7951340201934643`*^9, 3.795134042199213*^9}},
 CellLabel->
  "Out[1915]=",ExpressionUUID->"e0db45f2-d126-4acd-9395-72fa124e9b92"],

Cell[BoxData["0.9999999999999998`"], "Output",
 CellChangeTimes->{{3.7951327131445417`*^9, 3.795132736289179*^9}, {
   3.795132776418398*^9, 3.795132795452485*^9}, {3.7951331919616823`*^9, 
   3.795133254982712*^9}, {3.795133374590995*^9, 3.795133409500504*^9}, 
   3.795133557718029*^9, 3.795133749086506*^9, {3.795133813374647*^9, 
   3.7951338463239326`*^9}, {3.795133888683016*^9, 3.795133932699235*^9}, {
   3.7951340201934643`*^9, 3.795134042202117*^9}},
 CellLabel->
  "Out[1916]=",ExpressionUUID->"0dd99bb4-07ff-43f8-9237-40ae6973951c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw82Hdczf/3APAkWZEZn0JWFGWUTV5CZsjKToWskDIys5MVkYo0KCWVIm1O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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw813c8le//B3CVSlL5NJUKLZpoKBVXpaESkSJJKqRSNJSRUZQSQsqqCAkh
O4S3lb33doxjHWcf5xwafveX6/z+8ng97rfrvt7Xdd2eLplrljqmM4WEhI6J
CQn972e8VXVu75pxyFS79/OD7XNVtRSD7WUrx8H58d0TRbZfVFt55MDEZeOg
fTKFp7E5XfXugXtzAv8bh8RbLXYWdr9UhZ3+3HdeMA4PLtM3zCmpUQ3Md+u+
MW8c2BaW6cwtLaryc5ZoaM0eh79rNy1e+YCkWnjyU7rSjHFYMtbkNNuBrGrg
uXnj2r98uOwaI2u6i6JKr0nxmT3OB723Sut2ljNUny899G+Uw4d8A/+Nq85x
VFfpl99qYPBhETOK+1yRr5oQfKH55ygfyAk3Pd+a/VE91t2jFj7EhwvaO/MU
bYVQ+7o7Ce79fOgPmPPSY2QmsjLjr75P4sPVN5Kid9xmozkxLq8udvDhx9nG
l4NaIiiYupB7qIUP6vYjAf8dnY8UFYOuyTXwYUfEqfUzTRaioocbqxfV8GGv
17zkoWZxZJiecIBXzodN/0rsKt4uRszfB6K6ivkQXvWtK8N0KXJDxUuLCvhg
dOCbEJxZjla76DyNAz6s//Xy+8hpCZRU1En1+8mH0iiLGxrGq9AJ0ZsGT37w
oSThtQ7HfTXqPMMpup7MhwD9hpPs8rXovo/TrtPf+SD8vfZWnI80EmkUDd35
jQ+nOpD/pxIZ9FHivdiqr8R48+ifmkTXo12GMrYzwol+e6y1ruhvQCUhseSh
T3wIi0qoPpK4ERn17dWpCSLmr70j9PUyWcTeVJDz4z0f4Orn4KPP5dCrW5pb
Q3z5sDhVl2cjtAWtjW/1f+HFB5+1EWq73baiFKaJ8F13PiQybSyerdyOTu5h
WJ1/wQcph7IMyx87ULeNfefBZ3zwO/CfuauCAnqYNefUBkc+vEnz1d8+XxGJ
Cvmmzbfjw4eARUYZFEUUorZmPduamH/8ST35up1oj1vUm7Z7fJBhmeu8z9mF
ysp2/cm7w4eI3hOeYwm7kfFCMI++yYcqZp61bvQeNKZ9qtHblA9bRIRjMr8q
odfvGg/bXOVDwfpuvnzsXiTdahx/5TIfVCXXXMtK24fSVo+uOnGRD9+fNS83
L1ZGp40fu+04z4etUGN7oGs/6gmfyVmmzQeL49VS6PcB9GjQ0/ivBh/ilv+u
tl+rgsS2rqzsV+fDKjMV14kTqujz3QjliqN8sPYLu1n4GKG9SfKRyYf4kCx/
xYp54RCqGMtcHHyQ6G/nPJAfO4SuKR93eraPDzl2B2aHvT+MeE9qKTd386Fs
dcHhMweOIM9cQ31tBWK/OoW9lPqOoHXCQ4X7tvHhuuyetde91FD6iQeK0nJ8
6FP0Odxy8Cg68/rfx7kb+BBkGngtmHYU9VW9EqVL8aGZpzE3KfwYslm87HGT
JB/Gi81qZQyPo4UXQvuyV/DhhkOwI2PFCRQeuPXslyV8WEBtGVrffAIpd6Zl
eSziQ0/Rizn5geqoSvrI5ofz+eD0tmSk5spJZGJS+e7SXD48mcz9dWHzKTT+
VX+m2ixif52a+i9yT6E3lL67WyZ5kHtqPIlUdBptkLds/+83D96ljKQzgzRQ
5v2JE+NcHnwmP//49v4ZpJX2PIXE4sGfP/M2VZ7RRORxcZkSGg82Bpgqfdmm
hexUPnh+H+GB3kCeuc/cs0j8qezE+wEeXFSv9Ii0O4u+FCaZOfbyIFVLJeod
/Sw6IKJab9pF1N9i3L5mpo1qTpeiM208UHDrDxDv1kZmb3RjdzfxYOL4VaGI
izrod123xOo6HqwcW+cq3aSDfJbffj6rige1x14sd9c9hzYZcJkjpTwgkVIy
+xvOoayPT43qfvFgw4861916uki7R6w8I48HQlu2BTm066LBDQF7P2fzQGWW
qWLh1fPoifn6iJcZPHBUi/IVGzmPFsfGi1ul8kCjuGXFpYcX0Fe6soNeIg/6
SvK3pQjpIZVdv4ZV43hgrqKptfqNHqp7dPbCpmgerFqWtChASh+ZZ7bnL/jC
A/fLUeLbkvTR379m8mOhPDivET638/hF9PYwK7jjAw8W7pyV/b3zIpJ77iBS
GMADL8MzYtGPDFBOiYj1Nz8e3Bu83l/53yV0Tsyvx9ebByPPck6s/34JDWtJ
adp5EOshH6ERr2mIHN/GZF59yYMzY6ZrHjIM0dLmPbInXXmQGBzEt/W7jKJX
5b1VcOZBltElxV/7jRAy0hCSeMKDo7FP5S/1GaGGz80Wk495sIBCtjzsdQXd
Il9rHXjAg52RWvk5a4zRpBztWJUlD67rh7m7Wxujdxa2Sam3eZCs5U9/UWWM
tiQIS328wYOyrZ1taXJXUS77zWvX6zyg/zt+eI3rVXR+ryT/9hUe2I/R1mWT
riKKXaTJuUs8WPHm4utA1WvIOUexdr8eDyLvBPqkfryGls/MVll3jgfhGQ/0
l/67hr4dU4+Zp8WDMennCzOuXEeHX9UvZ57iwR3LG7TI/OuoqcLIpeU4D5yK
mlV7NpkgC/EROhzhgdWDTp3bHiZohq614VdVHrwyZ75SZ5sgf3+hUq/9PEgx
2HT2ySVTtK399Z5HSkT/L7TXiv4yRflrV4Rd3smDE6t3243JmyH9a2ELj+3g
gdyVL9zDH8wQ9ct2+21bePD1ZvYu9rwb6Nlw+uCSTTyYEyPULWZ7A0lsP6r7
W4YHPuIeyb7DN9C050R/nMN2Ly+Zo2nPeVCUzJvHqjJHLVOe88BzfsSJerWb
aNpzHhju9tqkkHkTTXvOA9tshyixnbfQtOc8kN5B6bT4dgvtmPKcB8vuKg7o
brqNpj3ngcUE0EvCbqNpz7lQMnhmX6W0BZr2nAu9qQsWmIVaINcpz7kQz+sp
85e5g6Y958Lbet8us4g7aNpzLvCMhH81y91F054Tz5vvzKfH30VtU55zQQV8
tBKVLLHnXFDo5KL1uZbYcy7oL/2vKmKjFfacCynV5kFLLayQwpTnXLg1Z/Wj
68lW2HMuVPaubn/72wp7Tvz+9vMaUUfvYc+5sDvi1/lwr3vYcy7I133xcGu9
hz3nwhtz1zd6G+9jz7lAX2U+Z/n9+9hzLqydxQz7Bfex51x49tpO+ubCB9hz
Llj2qxydZfQAe86FhbOtO9/HP8Cec0HkoOOvTUIPsedc2KwlRErVeYg954Ks
wiLJE5EPsedc6Dmqbdk58RB7TvSnvpFkf9Yae86FxcUl9hu/WmPPuVC80+lS
5z9r7DmxPx8ywiP1HmHPuZA6H7m6Jj7CnnPhsM35fXZij7HnXIi2pMx5bf4Y
e86FC1fyj2T+eow9J9bLM/DU/A022HMuULMvvnrqYoM958J1z8OPpPttsOdc
0LZb/I5yzBZ7zoVPMaqPBqJssedc8Lux4sfSBXbYcy5oXvwzw+6+HfacCz7O
rxeuarXDnnNBjFP7mX/IHnvOhczrDl4rY+yx58T5NF2Y6rz0CfacC5vezBfe
6fwEe84FDcM9NorUJ9hzLjwfzVztcskBe86Fm36W87eWO2DPif1Qn3Fn+0FH
7DkXdpLlbb3iHbHnXNhgMPuxzjon7DkXpFIXZjv4O2HPuTA8v1xfdK4z9pwL
0hV3yQvUnLHnXKC5xRWXOzljz4nxLCdOHc92xp4Tz2ukCpx+O2PPuUC2NvKw
2/8Ue86FLzae85XtnmLPufAjdH98duZT7DkXmlD5iOifp9hzYv3efTy0XvUZ
9nwMRtO27Jv39Bn2fAwWi2y+DoXPsOdjoKn03VB9ngv2fAzIJXqlkZou2PMx
qFEx1ev0c8Gej4Fe5kAOrd0Fez4GX7U68zrXu2LPx6Cl6eq2OAtX7PkYlJqW
N1xJc8Wej8F146ZgvtBz7PkYrJKtsLDTeI49J+rNvqkMBTzHno8BU1R70bGB
59jzMdBo+kx9u/sF9nwMLoal0JtdXmDPx2Dy1N+9SxteYM/HgHvMhnN6oxv2
fAyiKU1Gzx67Yc/HQOtebFZmmRv2fAyKA4Ov8Ne+xJ6PQd/q519UH77Eno9B
Wnka37vsJfZ8DAysJGtYMq+w52Mga3X7+w27V9hz4rmCkSy7/hX2fAxyDnc0
Buxwx56PQabuTjNDd3fs+RhE/D7qc3jQHXtO9Lf/1xqNY6+x58R6jZiSnCJe
Y8/H4AXzvyySsAf2fAxm6a0Pu2/mgT0fg0fbg32VSz2w52NgdtXgg/J2T+z5
GNjduNT5yNcTez4GvbWjz8b4nthz4v2Vo6UZxl7Y8zEYfz17srjUC3s+BjKf
Rhw37H6DPR+DqkP+afUhb7DnRH/VRf/dmeONPSf299X8LZ9UvLHnY7D0e/4D
J2tv7Dkx/v39J5bEe2PPifn9dpttOOiNPR8DhxfREoYyPtjzMTi+NJq9zNAH
zZzynNj/QFjs4e+DPR8DXrbN79x6H+w5MV+p5oM/xH2x58R53WxreU/TF3s+
BiFPcvawPHyx52OwrpN64GCFL/Z8DHRyL+3TEXuLPR8DNXMfitKZt9jzMQjz
fyhN9XqLPR+DDd2WsY9r32LPxyDBNdiydakf9nwMPOYO6i676Ic9J/ZLTU1n
xyc/7DnR/65Kc9l+P+w58T3ojUfM2voOez4GKrmwtuj+O+w5Bz7/LBm/9/Md
9pwDbMUgU9HZ77HnHFgd+eujr9Z77DkH0snLRxYEv8eec+CAWcEnp8H32HMO
HNYJWk3Z7Y8958An9T2151z8secccKrevDe7zh97zoH3DgeatqwPwJ5z4Eab
l1rowwDsOQcovA4ZmeIA7DkHzEu+yiSuCsSec+CXguUMXctA7DkHoHXAc8Gv
QPRiynMOPMzfFtYjGYQ954CWn5Bcw4Mg7DkH8rN+rxiuCMKec8DhdJntBtlg
1DHlOQfWBpiYuD8Lxp5zQDjp5L+13cHYcw78Dcx0GDj4AXvOAVV1rhw5+APa
OeU5B745Pbog9ecD9pzIVtvvBF7+iD3nQMnWwn693I/Ycw4cG2g9dmXDJ/Ry
ynMOyP53dEvKq0/Ycw70qGmpXGJ8wp5zYNNfoYMX9UOw5xxQ3mcwlpQXgj3n
QJHFmS9Ky0Ox5xxIHM/3P64Rij3nwMJ75xrnu4RizzkQF1o+8jIzFHvOAbPO
sLu5rFDsObF+zWtnpG79jD3nwKu2xxo3TT9jzznw2OGvMCnkM/acA/Y/DwxL
tn/GnhPnyUE6X2pFGPacA12vZa7TzoVhzzkgwrkW4+4Thj3nQEhNpzOvOgx7
TuyPq1vb3kXh2HMOjF22TdPUCseecyA5QkIKeYdjz4n+/0NbxOrCseccuJ1w
fTx9aQT2nAMSmwoz1PUjsOccWHXdKyLnQwT2nANv00Qn1/RGYM+J+agXrbol
9wV7zoF13OzzkZZfsOcc8PZ6tarpxxfsOQcuWbmR/ghFYs+J/XcR2bb2dCT2
nFifN0+8VN5HYs85MDr0KdKoNxJ7zoHNNuHSz+W/Ys85IL/YJC3F4Sv2nJjP
Oi95ZsVX7DkHln+puaq6Jgp7zobSG6KKoXejsOds+Pve5s2qvCjsORsuupMd
EpdGY8/ZEFzfPP/mzWjsORtOuuXpHYNo7DkbrmbLvzm1PAZ7zoaxIxO0J3dj
sOdsuG33oIBUHIM9Z4Pv1QBzu3XfsOds2J516JSm4zfsORt+6Wn1G7d/w56z
Yat5b36aciz2nA03GC7PdANjsedssFcyqFGdiMWes2Fit/4tO8M47Dkbronc
lRLLjcOesyHgVEY1f0M89pwNtfqpFsdex2PP2TD/8e1xLisee86Gn6Vh7osN
v2PP2bBJUvzEx6Lv2HM2zEvM36W5MgF7zoYZTt7BomcTsOdsqNPKefXCLQF7
zoZHg3fSCiEBe84GNHN7XzE/AXvOhjvrxdp9dyZiz9lQLZ16X+5OIvac6Ofq
05evoxKx52zoLnsjDP2J2HM20HXaWn7JJKGYKc/ZsFD+9IzwK0nYczYcC6h1
ufgpCXvOhj2Sj6xGO5Ow52zIvHW3x2htMhLa/D/PiX5jFX4nX0nGnhP97Xwx
SvucjD1ng8yHj7TF5GTsORtStFcfW785BV2Y8pwNIqfkVdffTcGeE/OVCN65
PCUFe86GBYrlzycnUrDnxP7rkL70HklFsVOes0F0Rc78gtep2HM2aLqvOBDR
mIo9Z0NQmV3+K+k07Dkbkv0vHXhskYY9Z8OZ0tWnrDLSsOdsuBUg8clm7g/s
ORto8V+Zby/8wJ6z4fDIJtGiyB/YczZ8zPv9YzH/B/acDT0H/ZscTqVjz9kQ
efOxxvxP6dhzNpw/KDsfWOnYczYYlh5c9FE9A3vOhhV5542jQzKw52ygrFr8
3xAvA3vOBsVWMXRZOxN7zobQmrrFC2Izseds0DJoht9zf2LP2ZDQbua63fQn
9pwNXSL+0ZEFP7HnLNAp3+1ye30W9pwFB5O+Wzq7ZmHPWeBePbNleCALe84C
rdEg+dhT2dhzFkiylTnl37Ox5ywIfNQcd2Z5DvacBXuVHGl7HHOw5yxQdt2k
82owB3vOgjELT0cNHcCes2DjU5H1rjmAPWfBK/GtT1Ytz8Wes8Bv2R5S4plc
7DkLFllLhou+yMWes8BMPGOHLORiz1kgK7KVOW88F3vOgqqt3w1Td+Vhz1lQ
eMR5cKtlHvacBd6rE+ZbfcvDnrOAc37yuOtQHvacBVmQtOr2pnzsOTH/c2bz
ZU3zsecssI/sDM2MyMeeE/P9WWsqR87HnhPz25U1eH9TAfacBXHJIWkfzAuw
5yxIta80ifpWgD1nwQ7xqBcB9ALsOQt+DlxLstxdiD1nwXohcFKwK8Ses4By
sdCtM7cQdU15zoKudTYmtiK/sOcsuBLyJmGO9i/sOdFvpNTcl0G/sOcskPqi
PkuI/At7zgJD8W50T6EIe86CfUriel1PirDnLHigO6v3ZFkR9pwFmuRHNmkS
xdhzFqwVM0jYZF6MPWeBuPi1NR/Ti7HnLJhVF3x2tWgJ9pyY39bx5kjDEuw5
C0Q2tKmghBLsOQv2M3xEhoRLsecsOBk+mBFuUIo9J87na9+qh4ml2HMWzNiY
lH15Xhn2nAUVwYf5xtfKsOcsWFr6Ysg5qwx7zgKnqCdMWFGOPWeBrpLyXemH
5dhzYn0SNRMjasux5yzYoiQnrKVQgT1nwZnUq5Ey3hXY8//9vmTlWmYF9pwF
C+6dCFM/V4k9Z0Fk6pja57RK7DkLvm32L9giWYU9ZwHdEG0cdK7CnhP7pUoy
ahmswp4T49s+1RM6W409Z4Hw8QcDxhnV2HMmyBurDv/9rwZ7zgSXoWfmwydq
sOdMOGH8Kf+BYw32nAnzi4LhY2oN9pwJ5u4v15hTa7DnTLDcOMO7fmMt9pwJ
bzN+AsmoFnvOhMJm8VPeAbXYcyb42DzL7a2rxZ4zIfvw4aiWBXXYcyb0yyfY
3j9Zhz1nwuHcgZCE53XYcyb0pCravM2vw54zgRbkqy0pVI89Z0LkGlULddV6
7DkTrO+uHF/lUI89Z0JcgdLKt1n12HMmfNiq3Znwpx57zoQ1LSeOPVRpwJ4z
wVc8EHU6NmDPmXByvCOKktuAPWfCXJNDp0NmNWLPmbCrY7KTd7wRe86En7J9
wmPujdhzJuQ8zNB6X92IPWfCjXtNyu1Lm7DnTAhy995cYNCEPWdCs1+u5ZnP
TdhzJmyVVjthO9SEPSdyjn3DMYVm7DkTNJ62bUiyacb3cyYsEjLZkZ3XjD0n
9nvTwWrT+S3YcyZ4bNpdGXO+BXvOhGUNlxrdQ1uw50zoyH1vLzzagj0n+r21
Z//yfa3YcyZsKPe9l+Paij1ngnF82o3fta3YcyagRX9PlEu1Yc+Z4DmYv27b
3TbsOXE+QIIqmd2GPSfGM7B3DhBrx54zQb3eNyjEsB17zoSzb/gdO+LasedM
cNIQrlT71449ZwIlObS+XasDe86E2TmyKpzPHdhzJgQfPqHszunAnjNhtRCt
LehEJ/acCd7PDkusD+7EnhPne8XHMil6J/acCbNUguI91bqw58TzwnUmNwO6
sOfE9zLmcfc7tQt7zgRxVt5uQ7Vu7DkTSOF3Z1gEdmPPmUA3QrPa6d3YcyZY
HXobqbOehD1nAnel3u0+TRL2nAna+VtyPtqRsOdM0LH94+QUScKeE9/vmXDX
F3Uk7DkDVotKvU34R8KeMyBOrMv095Ye7DkDtk2KfDPR68GeM+DPswbhEZce
7DkDrH61zHuV0IM9Z0DExN1jqLMHe86AO6lL94mK9mLPGSCyqFFvUKkXe86A
EM8f4g3Xe7HnDFBK3v2r0rsXe84AGcmEqtrsXuw5A1pE+A6dI73YcwacPFom
SVvRhz1nAHm10bDQsT7sOQOazdnSS+73Yc8ZkKtlxpUJ6cOeM2BOfLH/loo+
7DkDDraMb98y3oc9Z8DoU+3ONZv6secMuPBqf9HMc/3Ycwa8ukaa3eTUjz1n
wPz21jS/2H7sOTE+pZl5oLUfe86AA8f0qkpmk7HnDEjR1b2+bycZe86A3edm
lLgZkbHnDGDJOC5NcSdjzxnw1N3nWmYaGXvOgGjP61X+vWTsOQOWXt33+OTC
Aew5A17kbHWuUB7AnjPAZ/2o+FrTAew5A3Q/W1844D2APSf2v63cRebnANo9
5TkDnKqS6irJA9hzBmgtMHNVER/EnjPAnn+m987+Qew5Ax7EJKkamgwi9ynP
GVAiZzE222sQe84Aj2dvLMx/DGLPGbDTUWLZU9Ig9pwBPQ5vbp+ZN4RIU54z
4N7hb/wyxSHsOQPqdtK0eReHsOcMCBhWXVXzdAh7Tpy/APuZ56KHkNKU5wxw
XSlS5lAzhD1nwLKzF5Ambwh7zoCaMPND+WuGsecMsFTX/NmsNow8pjxnwNyd
gfEeN4ex58T6Xarc3O01jD1ngKpO6ZnK5GHsOQNiC2XPnG8ZRr1TnhPfFy/Q
wvrPMPacAcnj+2dtkx7BnjPgi2u73WO1Eew5A4RNjp+9YDaC9k15zgBpY4cl
xS9HsOcMOBJAu1ESM4I9Z0DB8TDhixUj2HMGiNOMUx5TR9Ca5uJO3X90mGDU
nl+/kILUjbrS1nPp8CDEt91gBwU9IHPesKh0yCs8prFGk4I+Wcy/mUemg2pp
cP7NOxRUypY54t1Jh6+O5+4gDwri2O2TvNJIhzdJu958jKEg6ZlanO2VxPhf
/jq6lFDQ6VemlX8K6SD8Rv8rg0xBj8SfRJZnEfWn0170zxxFn/19nYJS6OBv
pfjdSGoUVayN1r8ZS4c6skmR0YFRxPsCivsi6PBHVeV5/4VRtG57k+jcD3RY
Pq/wB/3eKDqTMtrX+JYO94+QDzp7jCKbA7OyI17T4bWy/Jz3kaMoPH/l+wcu
dFBb6LlCMXcUVZ1UsDxiT4ddy/680G4dReM1x9X/e0AHscsHn/CYo2iD/mUZ
0i062AQ8UVgvSkVa3Q8m4q/RIer7DFqDDBXZmbnXOxjQoUKlbNECZSr6Qg2N
1dChwym0Y0aFFhXVPPzxXPIUHeyU7FUWm1HR79+VRiOHifHEPLVI9lS0yaV/
b4YyHQLZ12uVfKhIW/S3+EtFOrzy+XF7eSQVPfH5b+TCZjqcTHVrdMqkoq8S
cgUbZeiwpTum/kEVFdWFqH7gSNBBv8NgH7uHiv5uOm9dIE6HgEzo/cehIrn4
25q+InRI1rXN8Z9LQ+f2PJO9KkQHlXTZgpyVNOSYFSCkwKfB2nAW++FWGopW
+976j06DlAviV34epKGGsl9JlYM0ePj79Jq3Z2hoUrvj9YduGpRUvdb+e5mG
trSyTG4302DZOT2533do6LzxPNX91TR49eNys6cDDTkPSq2YV0wDZsyfD2ke
NPTtrhKjOYcGReXF8CiYhprGNEoj02jg1CfuVR1NQzMcrodZx9PgiuS9y/k/
aGibsJ390UganNE95372Fw3pvfbWXfKJBnVlTo/t62jo2eKv23vf0eDrtmjP
o900FBeYPSfRkwb5ar/3x1FoqEW6odvpOQ2O6n9jpfFoaFbUSLqmAw1qbrhv
uz6LjnbIz/BdY02Dt1qBJskL6ehi2orboxY06J4Zsip6JR25quw4+tOEBk8G
cmuPbaCj74VH17gb0uD0jTXir3fQUdvpS1x9XRr0dZkb2e2jo9n196plNWiQ
3uJxYtkROlIweBnFVaMBp+ik/uXTdHSp59PTXwdo4LO7fa2uLh29ME818NtF
Az/nT1t+G9JRIr181/WtNEjamjVf15SOOh71iu1cT4MFefU6xnfoaO4/PllI
kgbXr8R4y1jT0c7ni6B6MQ1yBtvPBz6ho8timwI+iRLPG7x2lrrQ0cu3B+/d
mUmDgowtaUnudJS86typgxNU+GT1n6WeDx11fb65fj6LCtlDBiPp/nQ0b7Pz
n9ZhKiz4/Da55SMd7U543xjVQwXXPAfd9HA6urI3Lv5xKxXMaxt0L0bTkXtO
gdvxWiqMzVq6PzuejlKPtRkvK6WC2VLkRk6mI1IFQ7k/lwqi0XFZ9el0NF93
7pLkdCo8292q9yqbjpTa14w+TaAS3//2+rn5dHT12u5fZ6Oo0GHS9uVsER15
DJ/6JBVKhVRejJppGR39sLr6mOZPhXJq2+oTVXTUy3t8NvsNFYQNmR95tXS0
wMlrs4cbFQKsP8jbNNLRvjlfZl5yosLQtzdKZS10dN3zZ/vmx1TYRLu+hN5O
R15L61L4d6mQOGG7bqiLjjKChzyLzahQk9z1M62HjvrXTZq9N6LCyluKuwz7
6WhRzLJDpheogBZ4NLcO0NF+xW0rd2tSwW3PHbbCMB2Zph9hzTxOhV3c8Ipr
FDryRhfLa1WoYHBbJcKKSkc/iywjQvdQYTn7QdolOh0NnHnhYLmdCheEQ/dv
ZNLRf40fLqhupMIsvy3Xq1h0dNAwWX7BGiosm3C+rM+hoxt9pSIdS6mwWl1U
p3CMjnxvkXpixKhQOXOtyRIeHWUzuZm2wlQYlP+TeJxPR0M2C/zU/4zC029F
ulfG6WiJ0IY7KzijYJlqb2w0QUeqbvuPD1BGwSSG2Xf0Nx3dXKgtldo3CgZt
9UNL/tCR37sbfJf2UZiwDH1QQWRY7VirUz8K2y99dbH8S0cj4X4xMuWjILNL
dMk/Ii/b+s2FkT8K6jOzl9v+o6NDSXmGkDkKDkw3xx4i31Zu2eOVNAobf83b
s2+Sjt7n0hZejhmF+et+SjkSOe/E7KGtYaPww5O1NoXIo1WSeROBozAuNbyg
ncgrLuwMKvUZhaXtkM8m8pFO9QcBr0YhKeT5wkki3zG5onHj6ShcTVbJ/kvk
AIr1RiXbUbCrHnjHIHLBfY9/wvdGYdX3ZwYtRKaNhzXXm49C2JK1JalEXvk0
IyHMeBSOKbW+f0XkoyI1r+7pj8KGEIatLpEt3wxcO3R2FGr0i6RWEDlo+d8D
i9RHwduWolhH9Pfr45JlXWgUhsc3n39BZMaGLbTYvaPQX+u1eTeRJWMPFdvL
j4L/+YenOoj1Or5LL/SU7CgolXtoOhH5XuYd25VSoyCyi1q8hsgfDrvqDC0f
hdsHJY6mE+tfXBK09cfCUbC/Ok9Di8gsrUThF3NGoXb9IZM+Yv+mPaeAjmm5
mDWRpz2nQEOzbp4wkac9p8AGp23jvsT+T3tOgQOHdGWliTztOQVO2r3OjCXO
y7TnFPCLMFijTGSpKc8psJS2Nu0Xcb5OTXlOgdttywZ1iDztOQXaW80X9hDn
cdpzClg173thReRpzylwJSs6YgaRpz2ngE8f9acfl449p0D5E+1VW4g87TkF
VrUfE80nzvu058T4cRZ1hkSe9pwCy2XCUyeI72Pacwp87hNjBxN52nMK3PhP
qugQkac9p0DnZIzZMJuOPaeAGmVI5D2Rpz2ngIHLs87jRJ72nFjPCx//+0N8
j9OeE+NLkKtSiTztOQXkSt8deEjkac8pYJ3w3G4vkac9p8Cj/fLfJonve9pz
4n0xmcMVRJ72nAK/I+dqhRB52nMKRH5OYzwi8rTnFPi5ZGfPOSJPe06Bue9/
yCsRedpzCkRUGw+tIfK05yNwXWXb0vlEnvZ8BDRqZ2f8ZdCx5yPgcKu6dYzI
056PwLuNNx+xiTzt+QjMfpHxmkvkac9HwMcmdckkkac9H4Gj8uazFxDjT3s+
Ap+bJ3SliTzt+Qg83ZrF3kfkac9HYKhDtuYCkac9HwGJLmqjLZGnPR+B5S/G
qZ+JPO35CIT42vyrIvK05yOgKdI7IkSs57TnI/Af68/b/63vtOcj8EBosPk+
S+D5CMwXlfRNYgk8H4HmO4+DuSyB5yOw+OLRMlW2wHOif4Yyy50t8HwEDhi/
6G9jCzwfAbOaessdHIHnI3BFTdP4OUfg+QhkXIp26uYIPCf6Fdv07uCYwPMR
eLU3wPTDmMDzEbix0yL535jAc6KfI7Gq17kCz0egdnL2r1KuwPMRWJdUPWMn
T+D5CJz2XxAfzBN4PgyPNzx2nsMXeD4Mi/c/2X6fL/B8GDS1Tt3o4gs8H4aL
72s7T40LPB8Gv1Vlqj/GBZ4PQ11b+p71EwLPh+E7iXPba0Lg+TDM14t9yZ8Q
eD4MSz4PK1z9LfB8GLwfBMwt+S3wfBi2sNzjtv0ReD4Mq+sc87z+CDwfBmPX
dSTqH4HnwxBlviri5F+B58OwYf6cyM9/BZ4Pg9Xd50/G/go8Hwb6ddWso/8E
ng9DOLuH5/VP4PkwJDYq5tb/E3g+DPsmZ0csnhR4Tsz/qI7C6UmB58NwZdE2
xpNJgefDcGt3jcXXSYHnxPtao7aXTQo8H4ZlT8+l908KPB8GlS1fvbmTAs+H
YU5g5r7/+TTt+TDYZ4wo/JsUeD4MnbI9PNakwPNhmNEZJNo5KfB8GAqELPt/
Tgo8H4J1/csmvSYFng/BwIaEuvOTAs+HYO+fysZFkwLPh4Ce8cgh65/A8yFg
31FQufRP4PkQPMqb60b5f8+H4NWMgHKL//d8CO4bLrHr+iPwfAjWnDstdOiP
wPMh+GycUeb9W+D5EDi2uB2tmRB4Tjz/G9T8d1zg+RBwdIJGJcYFng/BNdmJ
EWm+wHOin8uzlZfxBJ4PgcKDwQNjYwLPh2BJfppeLkfg+RDUzHWiW7MFng9B
m5yG6TKWwPMh+LN3z6pPDIHnQxAIN+4uogs8HwJJrV155lSB50PgrLHsXjRF
4PkQTIr+aq8ZFng+BCWyh4y6BgWeDwFlW7NuLVng+RDo2O+XjO4TeD4Es5+4
iZn2CDwfArTygotwt8DzIbB1Kmp90SHwfAjeb3pzk9Iq8HwQvq+f76HYLPB8
ELLy1YP0GwSeDwLNXIJ6pVbg+SD8yJHsPF4l8HwQRmQa88XKBZ4PwoErP7gJ
xQLPB+FO0p7anYUCzwdBdUFDjE8uHVlPeT4IBeF7Oyqy6Ch0yvNBCMnem9NH
/D9fPuX5IJwsp0U3ptARd8rzQVDJKed/ThB4PgjNYeHC6rECzweh365Atvir
wPNB2KA3M3ttuMDzQfCKr5fS/CTwfBC+MS/G6gYKPB+Ehfq2oOgn8HwQjg+M
pPV7CTwfhEsxWkyLVwLPB+HstqNV/7sPTXs+CGzxh/ETDgLPB2HPaBz732OB
58T6HuIJNd0TeD4IK2NC9zvdFng+CI93GMyZMBF4PghRqSfKjxkJPB+E/M/L
WFf1BJ4PQvyLBeQzZwWeD8LRv1vE550UeD4IL70UenwPCzwfhPvJWcUjygLP
B0BswGiP+E6B5wMQBrEfZ24ReD4ACdJ6j/JkBJ4PwHIjtFdjpcDzARC38jAI
Exd4PgBqa3MNC+YKPB+AFRsrsuL/Ce7nA+CoJfvn+pjgfj4Al5/2fuqlCO7n
A3AoLnvrll7B/XwALBIPbtvfIrifD8DmFVnbFlcJ7ucD0PT9eVZigeB+PgDR
ouQ7EhmC+/kA/M0+0HQsXnA/HwAR52VeyuE07PkACM07qMj2p2HPB0Ans8zo
vgcNez4AJ2cfyUhzpmHPB8DKI2gAHtKw5wNwc0LP29Ochj0fgI6XwdelDGnY
8wGw26n0n7UWDXs+AP/cM894HaFhzwfg116v2lt7aNjzAVgm/FtfVI6GPR8A
w9cowmIVDXs+AC+sQx77iNGw5wPwXfVBsM0/KvZ8AHJf7O2QYVCx5wOQ0xss
6tlDxZ6ToWurz++MOir2nAxDx/VeRhVQsedk0Lzi7qWfQsWek6HDR55RGkHF
npNh54y8t3/8qNhzMihqK5swXKnYczI0uqzV/vKQij0ng/suD01JEyr2nAxm
sirndc5RsedkqDnod+3UESr2nAxLwiNsZilSsedk+M9U+ZODFBV7ToYZqh1d
6Quo2HMyGKa2n0r9PYo9J4On01ne/eFR7DkZRqXW/WM2jWLPieeloo47C0ex
52R48yQoaHfiKPacDMsvKz/hfxzFnpPhyZHNZx3dR7HnZLj/5IV60aNR7DkZ
9CpOfKi5Noo9J9bTR8Xto+Yo9pwMTpvFT23fP4o9J8Mme5UtzhtHsedk4Gcs
u/9efBR7Tgbxcz+srH5TsOfE+oqJ2i0coGDPyRClnTFgVUPBnpNBImX70oBM
CvacDK3vn5u4RlCw5/2wYpGnqpIXBXveD0FjKQviH1Ow5/0QsHXekVFjCva8
H6hLN51lnqRgz/th7sntidk7Kdjzfqh7ktGrLUnBnvdDztdas/hZFOx5P3w1
ay+op4xgz/the4iHa379CPa8HyrMOvba/xzBnhPvV2Bb/QsbwZ73w9Njq4o1
3Eew5/3w0j2m0ezeCPa8H4oDJg6c0R/BnvfD0m0aH4XQCPa8H1wp6aFPN45g
z/vB3mcts2b+CPa8H1Y9FlWhM4ex5/3Q9DJCqbN5GHveD1ejAt8GZw9jz/th
7OnsBVvDh7Hn/XCo7dIVj5fD2PN+WGigfSr3zjD2vB/kugq8i3WGsefEfM+G
8cP2DmPP++HL4oZT51YPY8/7gT4uda5VaBh73g961MWkPeQh7Hk/SMgM5N8s
HcKe94PkX5Nq67gh7Hk/tCfWtRv4DGHP+0DJpTp3pfUQ9rwPdKpVLibrD2HP
++Bmy6ZncgeHsOd9MKkXsspOagh73gcHer/Nip45hD3vg8PSG6XTyIPY8z74
PBisG1YyiD3vA1slFbe73wax532QvTItRNJrEHveB2+er3CLsRrEnvfB2IZM
2dXnBrHnfeAht+7OvT2DSGbK8z6oXtmn9m3FINKY8rwPJjJcAsvGB7DnffCY
ddWwpn0Ae94Hwp3v7bOzB7DnfWA90jbgGzKAPe+D1G23vLSfDmDP++By+dC1
iWsD2PM+KPt64rzX0QHseR9UKkVfWLhpAHveB2veHde3nzuAPe+DOx26p5uG
yNjzPhDPGZGWLiNjz/vgtPlA6cVvZOx5H7z4Wa/k6kHGnvdBcX2dXugdMva8
D15SHFd/1yRjz/vgb3Djg0R5Mva8D9Y7rdWIEidjz/tgcG+9rx+zH3veB5L9
brsf1/Vjz3tB4U/9au3kfux5L0SEH1Ba79ePPe8Fr7srb9Ee9mPPe8Hm08vQ
5PP92PNeWNGmlftAqR973gum1yri5Vf0Y897oby4U2uI14c974W/MnXPP7X0
Yc97ib+HOornMvqw570gHq2tODeoD3veC9xR7rWfdn3Y8154Z/3ms9WlPux5
L9TH2BfJHuzDnvdCHnVtdM/qPux5Lxi/q14b8rcXe94LPnbFE8ZdvdjzXni/
ZNlCOejFnveCiLSn7FhIL/a8F7zJWUtKnXux573w+m/Hh4irvdhzYn2SC91f
HunFnvfC5rHOMOv1vdjzXpCpWxllIdyLDKY87wWqB9ngLrkHe94LUgekbe2L
elDClOe9EM8Rz/H72oM974UvPpd7M1/2oDlTnvdCNWfGB9rNHuw5kXtPfFI4
3YMMpzzvhUUmEPh0Ww/2vBc0E/Ye7F3Qg5KmPO+B42HpCufoJOx5D8gkPZFq
rCEhkSnPe8DnISXOPImEPe+Bix/9HBf6kZDRlOc9QH22VbHYmoQ974EqGZdr
b/VIKGXK8x6I+eAe+0CZhD3vAct9pyLNJUlIdMrzHrj3Oa+YPNGNPe+BvW6z
qBuhGxlPed4DK8IHWnxdurHnPWDSvSpsu3o3SpvyvAf2Lbl/kSfWjT3vAb5x
9zxmbRcSm/K8B0JuPk6X9O/CnvfA+Nl7JjaGXchkyvMeEPeQmyuyrgt73gPX
H0n5lQ92oswpz3tg5teZ4wVxndjzHpCaEbeG9aATiU953gPX7Lb1X9jfiT3v
gWM+xXJsoU5kNuV5D9y1nJVfXNyBPe8ByvcY50avDpQ15XkPoOIG+TUXOrDn
RH/CNL+QNR1o8ZTnPXBDLtfyMrkde94Dbzzs7fTi2pH5lOc9kFufe9PLuh17
3gN9Ut9GZ6q2o5wpz3tgcUlbbOqcduw5CbzdnDW/VrehpVOek+Dk+ptWLQFt
2HMSRDrMiz15rQ3dmvKcBJeXv373e2sb9pwEj2ktP2ljrSh3ynMStFTGRq3P
bcWek+Bh3wdSkHsrWj7lOQk+Z23u0z3fij0nwTvPii060q3IYspzEvgXz97+
ltKCPSeBMve2gcSPFpQ/5TkJknoy1/Y+a8Gek6Cd1ktiaLYgiSnPSbDup8Ss
Y5It2HMSJFL7e7sGm9HdKc9J4HNgd2tOSjP2nAT0gBv7yU+bUeGU5ySo8zO5
oKPVjD0ngWzbF5s5a5rRqinPSTCj/vTQDEoT9pwEkze3Dx3NaEJWU56TYNXA
UFq1WxP2nAS7OjleYReaUNGU5yQ4tj8xMntjE/acBAbnbBRkxhrR6inPifUX
SzCoLGzEnpMgama7Vr5fI7o/5TkJIDdaSci0EXtOgt+s+Tvd9jSikinPSRD+
6fBVvTmN2HMSBJwf7bZqbkAH49/8jP7TDQ6m0kX1UQ3IOyvrzonRboj/Zy3n
bNeAhsqGpcjt3RCnvUrikQZR37q87ll5N6wPIYWlrm1AfoNqrtI/uyFP+Vy9
KrMeDY1ZKeXEdAPHujDhv8J6dEj409CloG647HYF7fCvR36Ly4PGX3XD+xPK
zn636tGoNF/D37YbWgaM7x1VJerlN07uvtkN6BljgeriehSgopNYp98N0SFr
NJ8O1KHR007XrdS7wcDjpOzCn3XoqEHssoX7uiHo438e/W/qUIB5a/E32W5I
OnvFQti0DjEezbE7uaIbFE7ZpN7ZT9Q/37VtcE43PFBcqCMtXoc+vDXucuV2
QZe55pbVA7WI8dnTe91AFxSHMNdfzapF6gmZR3Ibu+CV6ul1dN9a9CFnkHP5
VxfMitGfU3SzFnEqln79ndIF2ldq4smHiPr2wxcDI7ogrV+Bf0aiFoUO352/
168LKN7VWf/oNYjDC85ucOkC/sbBBl5xDdKYU2p5/0EXNB6KXK4cWoNCl3Jl
xK93wZxglQv5NjWIv259Q5xOF7yRopm+1SbqFc++OH2kC0Zrli+P3VKDIpDD
vmHFLuhzPrJHTJioPxMz8kKmCxYl3pK+8bManTVs/rDhvy7QucbpU7OsRhG3
hLXyhbrgiG33ifj11eiPjeIMY0YnaPyOaf/SUoXOuhkl/+3uhM1rE7du8apC
Ue9emwZXd4K59aG8/Uer0J/w9BXK0AnfslLWNU9UIt0kcmlTfCecOPSm/l9i
JYrKXfzk4adOONXrpZt4sxIJVaMdi706YV928XqaDFHfaUH67tAJ5GuZWSlt
FSiWEuh75k4nmGbcChD2q0BCE0VHKYadcPnBo+2dZyqQvgiH+1KjE+xltzJU
RIj65TLRmw52wvxZH3Q2FZQj4Y2alwq3doLy6h+F7xzLkf4u+wXXJDvB0Ngg
5fX+cpRwOAomRTthwTpzz7m8MiR8tvHex4kOuH+0PUMkpQwZGs3ccGCkA/bN
bf/sda8MJVjIN7W0dkCRVdW3APkyJGJv+PJRaQfEX7Q8uIlWigxfvdq/NKMD
lCU605TiSlGKf9poYlQHqFfFPym1KEUikX2ftAI6YKP+bFrntlJknCKuTXXr
gJjuDzcfUEtQSr7KrNePOyDhvy6NV/ElSKz2VqrcjQ5YME5jr7UqQcbd/jeK
LnTADMeCjF07S1A6tXClyfEOuO6xnV/EKUZif5jlM5SI8Umjc1t+FCMTUSnH
kI0d4GWXc8jMvhilS2goqCzrgKtwe9wKFSNxWdveNuEO+Hyw1Y03i6jfE+ln
w2mH/auXHR4vKUJZavXHl/e3w+kjprbWXkVIXEdoPLm+HY6vOO96W7cImRtv
/6Zd0A5+QgUpbauI+rsGl+lJ7aDuRjXM7/mFljq4LfIMa4cL8s5VMtG/kPnr
lLwtvu0wbzLEgG/1C+UG9jwoedoO3HSe9jFloj5q4Saze+1wqKRAWGTmL2SR
dqBl1tV2GO7pzEflhSi30Nz989l2UDYoaaf4FSKJ+ncH0aF2uK+Y8Wn+lUJk
0ZNP65Bvh6amCINPmwtRIZ0eaifVDue/qBuFcwqQxL/V5yQWEfUSe/grcwuQ
ldip2Wn/2mBXdvOjGR4FqHDV4x/naG0Q0Okqd1G/AK3eHHGT2dkGncPOl6Q3
EvV7ayXfVLbB8pB5RhdY+ajk2L/KbdltcJdq5DgB+Uhad6tzWWwb0D6Wi4p5
5aOH1/R3mn9oA25GnLa7YT6qsHreP9ujDaRTHT8/3ErUOyW9D7dvgxUG7epl
E3nIxrNb/fDtNrB58vq9e1keqggW+91l0AbDlq9aU4Ly0IYY5bgnp9pg6/F5
V9VvE/XpZldW7W+DSw1OT44ezEM1RW//S9/cBj+fRttHLSDqG3MLzq9sA+tu
7/gH3bnoSR/Vmi3SBn3z35l+ScxFNcxVcj78VtjbY8k86JqL5ITU23YMtYIT
80C4sh5Rv9Dao6K5FbhadhVBW3JRw+ow1VvFrUA6p+AIfwDJba1mzP3RCnB5
KGjRF0DOyn/CvkS2wjm/Yr8NmoAaTmw+r/a+FR5eslr8l5eDtl24MLfneSvk
Gb/46R+Wg5xNXDIcrVvh0b8f+9hnclDL/YTbq01bIU69eNfCiWy07Wnnmkzd
VnAo9NUbjMxGrm9Ea/SOtkJF5ZqzDrrZqOXj3mdju1rBOCagrGpmNlKINdn9
dn0rsDTNrdsSs5Brps+AwhLieeN2oZCrWaijJCegamYrSERVSkouzkIKzZRT
FqwWMLr2yO5MwU/0kizxd15vC0jd/Fq92/on6mAf+/61tgWyDuytqZb9iXbP
fHD1WF4LsJ0v7lzTnoleiocu6UtogbyqiDjJN5mItLbyl3NoC8zdKfG7VC0T
7d4+8Xitdwt0P5Bu3DSegTwOyG7JcmqBZJmPPIXvGYh0UrfjomULdF0gSw2a
ZqB9+k+9eEYtIHm6Qkx9DVFvFn/onWYLTH754qjTmI76H7azdqq2wLagk3tn
e6WjfS4iX2q2t8CuEokJoxPpyNtnj97dNS0gOjr52mgGUR9ybZ7YghaQO2+f
PDPrB/a8Gaq2Bu079fgH9rwZbFxmkHft+oE9b4ZrKnSXHHoa9rwZEjMP9g7F
pmHPm0Hq6tWqxFtp2PNmGGQ+lJDYnIY9b4bQVEXfVUOp2HMiP+EuTP+aij1v
hu5HJdfpN1Kx581wt1f3BsilYs+b4d9bFnPTSAr2vBkoeuGdG2JTsOfNECu/
bE763RTseTN03gxX71ZMwZ43Q3WAnmvgWDL2vBnKTEcCyRnJ2PMmCDtaeDvf
MRl73gSqc/517jiajD1vgk1nrjZtFk3GnjfBzD7zg0k1SdjzJhhnHhov8k/C
njdBu3Qxz+xKEva8CUr93Df4yCZhz5vgWXP5naOMROx5E7AjnhQ4ZSRiz5uA
+gmtOOKSiD1vgoLhG4buZxKx503Qm8B305NIxJ43gc+7CO+ovgTseRPIz628
++R7Ava8CVzdnq6us0/AnjfB+1bHd1HqCdjzRuCs2dH8b1kC9rwRfNNO5H0t
/o49b4QlFBXTMybfseeNsGfjopDRGd+x541wqav9kUtoPPa8EXYcXcxfdCge
e94I+8NuK3qT4rDnjeDzbXj3zGdx2PNG+BpVv8JkQxz2vBEMXyazkotjseeN
oN6s00O/HYs9bwTJDz9mLv8vFnveCEWrZWw3/PiGPW+EYHfhWyuNvmHPG0Eu
cN4/1uxv2PMGuPJvztXv8THY8wYQ6/6Xp6Efgz1vgMBNkudKZ8ZgzxtAtjL6
5Pr4aOx5A9iJruzSN4jGnjfAPFv2afO50djzBkiT7ajVSo3CnhPv++ieuMAk
CntO5Ioi+dAlUdjzBuCNm/jNLvyKPW+AiPeHtxy0/oo9bwB9MRV0RPYr9rwB
Wh33bljeFok9b4DzLmLb0zwjsecNQCv3SpA+Eok9b4DN5S4iurwv2PN6WHMm
xEcz7gv2vB7i5jl9W2jyBXteD73bI9N9Jb9gz+vhv26bta31EdjzekhO23uM
5BGBPa+Hbcq//SOPR2DP62Hl8e+uW2ZEYM/rod114ZNbWeHY83oILf/INLEJ
x57Xg5fL10sSe8Kx5/WQLrJ3lwsrDHteD1lzl3LCE8Kw5/Vg05K92tYyDHte
D4ubzXbMkA/DntfD70x67H76Z+x5HVym9q7dkPAZe14HjE7LBVn3PmPP6+CU
vpnwjN2fsed1cKhF0ZfJDcWe18Gn7oYTHpmhaPWU53UQcbo/vdoxFHteB8qx
z+wz1UKx53XE+bwkd3peKPa8DuL3qKYKhYRgz+tAv278SuK2EOx5HdRVIp8v
Pz9hz4n3Del4tZ3+hD2vg6XfLn4+0/kRe14HK3afX/nH8iP2nJjvAolTfbM+
Ys/rIGWuiodQ4AfseS1cllqroi3/AXteC4fMy3PqioKx57XgMXOmzbMrwdjz
Wkhaub7h8ngQ9rwWCihb1K75BWHPa2Gs/auyp0IQ9rwWjnolKnRUBmLPa+Hm
ItIXDYtA7Hkt+MxRk+yYH4g9r4XvbP0VL2MDsOe1EGczZ6OmZgD2vBaY3z3r
tzL9see18Mfzedrad/7Y81qQ06413bDfH3teC9J//R32k95jz2tBjXzgk5Hb
e+x5DWQe0bHwkn+PPa8BybYg7+KWd9jzGkiI4/2Y6/IOe14Db8DkrcaOd9jz
GthLoje/bfPDntfAZq8E1XY3P+x5DRzsBVdpJT/seQ0Ueijcvkp+iz2vgWDS
nB/B795iz2uARFNQrDz+FnteA10JjpFsvi/2vAbk1YIGxWJ9sec1oC4vVLrc
2Bd7XgNKRbx1i5b5Ys9r4K3761p2mQ+yMZR6fG68Gq58e5qS/9QHSdvatnu1
VIOLl+53W2UfVPOuHpX9qIYAi63Ry1neyCZpe8Rs/2pQ/FPn4f/NG8lVu4kc
flQNBTvS1CdMvVENpcfiyflqOPO3qeqgjDdyFjlY+2N3NUh6em3OzHyD5Da+
38NeUg2pdmqySbvfoJbDjMAd7CqYWTvb+3KCF3I2OvXvZl0VnDEVNknf7oUU
7COufUmsgiyJCzE5sZ6oxf9fEcm7CioOjFpZbPdEL1P0t662qgKt5c8rsr97
IIXapDd6WlXw+M2nlvhdHohEFeP47qiC6nHzHwcyXqOXojf0qxZUQdNkho/x
oddon2xe1jxqJRikTL5fWeqOSGqSMscqKuF1wa6/1865I29j6+fO3yqBVlwl
pNz9Cu1zqB7+6V4JX+Bnv7/FKzQUuFmTd7MSDkSeZtn/fom801ySdp6sBOUd
m217Xr8k/hR1Lr8rVwn/hWhUF655iYboe+2j51bCs3r62XWJbihAzLe7f6AC
zC49M+Yec0OHNo+qSRdVwMmcj2YqHS8Q49jxqEtfKsCoZ7yW/eAFCrgWKubv
WgH1nldXLF/wAqk7TVjVXa+AoFVfE0O/PkeMYN3GBWoVoK0UKOOt9hyFpscr
n1xXAYYNPCqJ5IrUG0U+uc6oAOX9N8PfOLkiPvPazFxSOXjJWzYESLmi0IXZ
Zr+hHHZoGq4cz3VBZ7euKFcKKQfuw5PicdddEP/EPfn7juUgajD/cuJcFxRl
Uv427nI5tCO56Jlxz9DZpxv5QwfLwbG0MvzjuWdI6JOT4YbV5dDHKJrh9Psp
ispszb3yuwzSVt93CI94ivSbd20MbiuDZr0fTXO1niIhjuerpowySPr6ry5q
whkliA9R/wssgwOum1Rcvjoj/e1HdM7YlIHnXTvy2/POSOTUh7SXemXwNir6
c7MwUW/GXVWoVAa2y58Evr/lhIxdzjpNLiuDbxMbvZorHZFIaEzf/rFS6BYP
HL29yxGlZwmrP2oohdDVH93PBDsg41aj2MTkUujda67+aLYDEuemi1N9S+Fc
hqc46d4TlL54ibXc/VLYcJ7a7EqyR+byd1qva5eCmkPYRyNteySuUawSolAK
eb/Zt24U2qFcc5mwtkWlsKJc7Vygsh0yf24/Zzm9BOzlJh/QEmyRRFjjLe2q
EmD2enGMt9ii3Bz5ao+4EhjsOzGH8sUGWbW/2lXiUQIq7Ev9L9bbIAl+n/8s
ixJwSCmr3xH+GJUsVf2jeroEfnXprO/c8BhZKQYY220pge2x17d6RD1C0pqs
wtR5JSDnulBTaccjVHJLYzNzqBg62/ncxlRrZOMW6bmtpBjMz2oGmyJrJB0h
xLrxtRi6uEkZ3WUPUU2uwYXwF8UgQd7Tpqr/ENl0pmR2mRbDKE3Ny2HwAZKb
WCi16lgx1AUHWb23eYBqlt90Ob+hGJaePbDRdf4D5LyrYNB7VjEIxRldPBx6
H8mdXaNR0VsEBhvMC0qU7qMWi8cJc/OLwCGvdd2y6nvI+VXtUrXPRdC/Qf2Q
zM17SCFyq62jcxFEpGhSB4XvoZb8550ZV4rg3D8XYZMwK/Syu/vwmGoRxGnc
vel92Aop/FGOVFhbBEc7GOI1hZaIJOEnavH3F4z8H093Hg7V98cBfJSkHW3a
KZVKJZWSzFtSaaW0EEISWpGkkhClUikqJUsRsmTfl2vf93039jHGzKCFIr/5
cuf359tz5sw95957XufzzHNdreLQwhk34bSTdSOgKZuw+/P+64xTN7D7lEpl
e1I2Eevxb5qt53XQbnzZtdIjm5DcvZolwbwGl+ejHpr3sonoU/YvWQrXsDvw
LOWtZjZxOZ8uWfnmKuhZ4ZfKdmcT6QJnhfIZV+DSNjN/lmg2Ye7cH5hz4AoU
/13afOh3FvG4qd0ow9cEnKXEa/uaLMIy8XJlJL8J3Hct+ZUSk0UE5brZvzQ2
hsrpW+dH3LIIEyv9FcdKjcAxLU7dYZFFbNR10m7fbQSfF+vXmKpz25fdm6Hy
9TJUguyeBMtkEbTGE/9uLbiM4ZzGvm7hLMLF/ftanceG8OnYqbZ6IJP4lZt7
78+fS1CjuETrlGUSdwvkZ+w3v4Th5QzRD2GZxN6uef2bmQYIlFN+UPUykwhq
8DwVaWwAtbNebfNuZBI25Q6WuT0XQbk1fODo8UzC1vnj10smFxH46lTQY6lM
4h+raa9dvz40QkLmZszKJBaUGXxbYKEPSr7ArTFGBvFWVN140Zgewrv0ancX
ZBB3thQL2DjpQWNKkrzFtwzicmCX+P5FehBctdAnzCmD2PhRsjjxmC7C5W/y
9xllEHaRamueml2Anka+8bpDGcTZlVattI86ELy9plh/XQYhvuhkYkSeNuJf
P9jmOS2DoKYOPe/7owW977Vv6zrTiaSunKM227QgVLjtz/ysdKJK1UTo/LXz
iO95fkHVN51It/WYdzNYE8b83RnP7NOJv8IbvUJZGhASV1yfo59OJDjWbRWQ
1UCawsfnfPvSidNex86Z2J2D8fkf7L1i6cSDbX+yc8vOQvTOidNW42mE7f15
x0QkziLNNTA+qiWNYDL06+Tun4Fp+JQV7JQ0wtxYy2przWmIFmvbbfRMIzYt
oJ/r3HEaeb2xXYbWacTPe5fSD79Xh6mA8JHPWmlEooLzipNjpyC25ur3pj1p
RORmk6G+y6eQh2wR0aVpRHqNEn1W1Ulw4qks/0GC0L3/klujnoTi4GDsigiC
2HK/9fyXeDX4bAp46HaTIJzX1yWMblUD55KWyqwtBPF+fOePQ2dUoeY1T9ie
mUp4fbf6vuDkCfjUZtYPB6USPWnGZ5TVj4MibPXlpkkqUSrvW5ukdQxqR6Su
dq9PJRyunNPVu3IU4Y9o23W6Uwj/w5tPLX54BJQUt9FKvxSi+LvUyZwPh6H3
SyX7iEEK0bH16271RBWEbx17kS6eQrwhFon50Q5ByCTi7G5aMuE4ddl579mH
oPfFcFWYVzJRpKFqsYl6EGmNS+hrdZKJqOfYtfX2AQgtLAn/tCyZKNh10v91
hDJMT9jfnd+QRFyuChuXG9qPtCeySs/ckwgzA7nkeXv2QyydMZPvXBIhlXP1
1R9HJZj+8aq8szCJuPP9lFF7zT6UbVf/xKpMJJS3Wl4Lk9oHsevTDQ3fJBI1
Hfl8R54owtY/aXOTWiJB0ZN7urMYKGu9+evUvETi1GqRJQvfUiG9RILIL04g
TvIX1fBfVoDtqbonis4JxNMq0/O12Avac2e1uCMJhM22I+G6q+Uhna24ZMuM
BGKxc46G2Zw9cPn3o80vN55YsEtXhUaRA23Xt6Blj+OJzZYPe2xHd0HRTOfW
G+V44uqrayKSlF1wCRLeO2NqPKFdtmVJ8CxZcDqy+W3T44i9z+4TrSt3QnHF
veJfD+OIDb+9936S2wGfs1veXafGEcKzrsvHaW0H51X7hc7RWGJgtUTDdEcZ
qOW/W6+VFEs8dLsUZBizDT5TjnLK78YS/cJLIwKZ0qDsHY9X2R1L7Ou4evnb
Rmmo3Y6yI37FEDkVmlftWrYg/LvREdmYGIJR6/7nlcVmUOjL5ofeiiHmn3i1
QmaxFPTEyxrXyMQQFJndOstzNiL8vIPfR040MWPObUl+uw0Qctt9XTgsmmgz
/lnpfUgSesXMnU7Xo4lhj1Uf/ZesR5rA53//NnHbs/58LPu1FkKKZ3JvM6KI
JVOWNdW0SMD07gwXZmAUMezgrHKrfA3SIlM0DIyiiIa5meF6JashxjQTb1gb
RZjJOhWcrxaH6dp1DLXOSOJcVp/0ym4xlF1oiMz9EkksFth5yZgiBjH3l/ep
+pHEEt0gV/ahlbAtV1KOWRVJBL2J0Vj8eTnKZv6eLdUSQRyUK7LMm7UM0srB
1V8+RRDjOxQWOz5ZAtsHul5LtCIIhQunNpfPFwUtdr6Ry5IIwmWcaikTvgjS
nNyt0+vCia2CQneltRfCZYP18IN34YTyoOfj04sXgHZROv3H6XCCAduEDW0i
UPzU+fTq/HBi6fMpv/YmCEMseNvXLN8wYsGcZYzl3kKgrfgoGykWRtyQyV4a
LTEPti5T8rw9vxMVbcuU5qydA8WpVzVfLP1ONNaW6V6nzgLtdiXj3vtQIjvB
eznFdAZ86PLWxgtCiU/nDKJ/xE+HopbfnLOvQ4g14iK/HogKgFIy23v/3BBi
vCh5f8ULfvgo3pbe9jyYuCb46s0m0anQi2pOXykYTBwQr7iSG8sHyrqD6rMd
gwjZRwM93cYUpLl/7xzhCyK0B/nMPLX+UfVmLbbssflGKK14uvfljFGqmM3D
6dV/A4nnfBZNuxpGqGmcHvcMq0Dijvwhcbmi31RbA7WN4T8DiNKpG6bsbvlJ
FauJT/I0DyDE1o1+apv7g0pTET/+nO1PjJx6IMvQHqTaJj1tsbrmT4S8vrhn
Ti6Hqrhl8Obl3q+EtMGI5VJ3FpXmc57v9OWvhAl/TI9RdR/VZ37mm30dfgT9
UuNTv/29VMXHmyS26vkR2fsv3rSldVMpI64xy5t9idkzPo8kfOuk+lwdPTjz
vC/RfeJL/QrPdqpey6W63zVfCOGbd4SexNOolJPFJl3qX4jL15e1pgw1U9My
d/6tKPtMhM2cKbMntYFqK+vlnHb8M5H8by7lVVEtVeybwMrvBT5Ew1blis6l
1VTaspthHod8iHpV+WrbrxVUyoowO5Gn3sQp9/D6LOMyqu0UW79+ey9ifP/9
oAsZRdS0HrXcPGtP4uKzxTmxi/KpisXiDF/LT8ScHbOe8uVlU20jB2c/NPXg
3u9zs3pKM6gU98yt5698JLQfLX5/VDKNqvjA7dTOSx8IqYCrXS7vkqhpFw1v
C11wJ8S2Z8pcvhxHpajIuvede0+I5Lru2x4TRbXdPD0p5+Q74lbS9u7HVuHU
NJG65s9H3xK34hoUs48FUxWHAykPDrgRPkGV8rev+FNtm++u0YArsbJw/t2+
XV+olMwjB7fLvSEatofIxB7ypCoGLjOZu/01QSnWPZ4g/56a9oL5vFfKhZC+
9Xxbk9QbKqX7ns7T4y+JlXNVDAr/PqdSIpb7Yp8zsWYua2HpOkeq7f1U+s8d
z4hSp4KokRMPqbYH9baESDoRdZ8XUlQ+WVIpwlMsLi5/TJRFvNILSLxJpTT5
JogKORCRch5D6+wNqbb+B8ZLptoTB3V/Dwf+0qJSJv6hzEPCLnj3w0/7TlIp
Ew+g3yfm2Cp7S7H2UykTD6DfIWZPe6tQu2gnlTLxAPotgs/ex0w/Zw2VMvED
+k3iukXiJtdZ86iUiR/QLxOlP1akLDk0qECZKNB1CPFj7mVm3XkKlAnQjxB6
M4JmTcmxUaCIvbRfE7kRQjX7TSUbKQoU0/3738SrQ47vB11/gZ8CxXnpLNM5
F6E8SG2LkWlSoFx0/fGOegVOeiGeyg/GFSjLBNgtu8zQNeWI/JSzi6mUxxkG
5mq3wbG9tK/bcBOVwrGpm2ZyF1F9fbdEQ+SpFC354x/sHqC+N/t7xfrDVNv2
v3qLim3hbGL0Lnv9GSpF9PwyvXp70E7sralO16NSjsdXf+tywMJ1gZzvaiZU
W/tFLkMDjzGaI9BXaWhOtY2zOKLwzwmrLjhobui+S6X0V/A/mfkcNTXRNv6p
dlTK6m1E2aIXGJmqOlc68wnV9tyru0vXvIKKwYHh2m2vqIo5v5ZEvneBTlz3
xdBVblRK29rfNZ6voSCqfHPamw9U27+nq/76voFwhtHKHwI+VMVFDhFiQa7g
935s8Kzel5omHfXyQLgbbhNeps9OBlJtj7ZfvRL7Fndket552YZSKZeFD79K
foc9P3QOBCdHUNNsFddFZ7zH7rd2Ya7rY6iKHjen1ue5w+yhbNrOWQlUSqwX
bazkAwaCD2lsM0+h2pYVp6yu/ogA4922RdvTqYp9ox8PNXpgLO7ykNXfTGra
NCmra22fILN/BWvJolyqrZjWmdc9nsg8XRPY+bSASpF/JhPb74W9YylBh3RK
qGlnEuY1Dnmj9PeGS7ePllPFdlv8Grf2wfCUaa9rvSqpttmzDEUonzFd3vT1
Oakaatop30qJR59RuN8W3r/rqGK0PUq7BL5gpcWmJbf5m6h61yvCDz/9Av69
75F8tpWa9sdklfZsX3yV3i6/524bleLE9/LGK1+82+cg3Hy9g6q38MOorYgf
VLOnrTN43kX1+SJ91fWtH3JTdh37XdlDpUjn1X8V/YqToTYBFYcZVMUUXZV4
j68YLy4L2stmUn2O/I4tWOkPhRuGos9z2FRa7cu1zZ/9cfVcFEXYZICqaLjO
jS0RgBX8le1yM4eotoMpU6YEBqCa8e0pJY+7fj88Y7ZgUyBENujcCvH9RRWb
09+67nsglq35p+zsNUy1/ehwQm7bNwj3Xy34mfCHmrZ+ecrR6G/gdMn+OvCb
60dM1KYLu4IwkP64jXZunKqndPSjaWIQsl/zdbuzuP6Utgs+UgjGW/vWF2eU
p4Cic+/O27RgyD513dIRyvWLIdwdsD8E8LgrPkVqGnzufDudmBMCY2KOuiXB
9W/avsyiw6EoPk5Xmm4iCMU3ddtai0JhODd5qu2GmfBZZeozoPodXtpn5cP4
ZoMWMn0ef+V3rNT9vNpokOvvHu8Hi86GocM60PHBKNfnXFmmZH0YlrwqbTMU
EobpRqPQFVvCoTVoYbRYWgRCA5Gd/jfDkbPj7btMnflIi/u3TDoiHLNr/e83
fVgAPZsj6gmD4ajxL2FWdy6E0IF3z5R2ROBSWe/TtViM8Fnt6YW3IxB540Oy
0jdR6FVsHjkdFwGLaNV4/zVLQflwV7plOAKroi7cK/q+DOG62UZGeyKh1ihY
IH10BdTWCXtz7keiTN5196mRlaD0a9fcTYlEaXGIS522GHyiAudMHY9Eotxg
ldFBcajd+6HsrBiFXHNKm7vcanAUFa0X2kdBQav/9XfZNfCZ7hzllRmFwe2z
g5gKElAsqWWsnxaNoKTRsveqa8FxW7M64mA0Qs2SXH9eXQcXrZuae5yigdHI
S8dc10NxdZJLZn40MrJKPDqyJUGjC+QdmxUD34KXllP5N8Il7NR49bEY7Etd
Lvrz+CZIW3rJ6r6MQYnhxadT/KRA28u4Ti+NgdAF8QRLgS2wnSr71Uw4Fkq7
Zlt73t4K6QK7pj+nYmFuZ5rTZiWNMpfi+Q5usVAPVDroobANtueWHJ1TE4sL
dcJ2q2fIQGylof27xXHw1/662btRBmWd4QmrNOOwtVLAUi5mO0yDRzmBH+Pw
VsX195J3OyBmriIp0xSHk5vmZJrY7ETabjfdpBXxMF4Ypn3qhiz0xlvfKevG
w8oKyWOGuyCUs6mk2CcefpvWHn9nuBvhznemnWuPR3aHNevgdTnoqWfupa1J
AJ/n1qE9D/aAsnSehYlhAug/Z6z2eiuPcNr54EH/BGg9rYr5FLsXagH+7ffp
Cfi7/7qOAU0BlBuDS6ZtTIR+Vpv8qvmAzw7qyZdXE7FG/8APm/WKUPv71Glx
aCJaDrjFLSpQBCe9mvBhJeLLEYrkDbN98HES/71BOgn1C/8Rn1YoQVH1+pYo
syQcX31pR2KJEjgLEwz3RiVhP/W+RYvDfrg08Xtm/0hCo/e8IHFFZSj6qlWd
kE3Gm3f2cp8oB0Az+TSr7k4yCmub0i/nHICLNF1JPyEZU2+2Lf/4+iCkf2+/
x/iTDPoJcV3Vi4dAS3kYcWtvCu45z6vz3q0CW4dC+uiDFFzct0jk64LDkD66
WOwxkYLilSEVVr8Oo0zY4Nw8vlRoh15ZurPlCGzrvr90V0qFg/LatT8Kj0LM
+0+2uEMqlsdQrpQRx1BmeHAsKDsVayOfe3QmHIep1JsdO6YTWDRUG3A08QTE
hpqvpqgQGFvqFi+Wroq0hA2+B58RqN/q+gFGajC1vd1QWkjg4j8D7X0DanDy
pTmFCKThcqyaq6/NSdAeP5YwW5+GwsShIxbzTkH6ilTaTpU0vLEdDU33PQWn
4xVaf4zTsJ1OnfZRXh110la/U5+mYYiSGTerVh3SC1a6PgpKw6m91UfWWp6G
7e/MLSqFaeCbt/jiT9EzqGswKZjNTIPpNBfiGXEGkqnzLpfPTofuYWL/D5Oz
sP0cw/duczpMvEL7FUXPocxBy/P8iXTu9Tve8LDgHCSN+eRW3UzHgdAZKmm2
GrA6GlDV8Sodn4+1vRKW10TZluOmgeHpkJp7S+rRiCbERIZmXS9PxzD9baxE
8nlY/XQP2DaYjl/HxbqnPdJCXh11/y+RDDx9PPZa9oQ2xJI7WxK3Z2D6h/3h
OSt0YOr97N7D0xkQCjt8NmdAB3n20ouUb2fAXoCIP1BwAaKXayIE32VAwyhj
05kAXZgetj5eHJsB2vwHr+2V9ZAmtbr3dW0G3mrXiEbF6UFUKM/h7HAGTDuu
OSpv1ofx0HWxZUsyUcj5poiv+kirmZ/cKpeJqXr9mcGrLkIoMeGc3/lMKAh6
uL/5dBHGnrpDxvczcdVMUmN0mQHibae92vwpE6GVG0MGPA0gdCl442ByJmYb
Gp64v/oS9A6dzIltzsTCoVrBL98uIX7jb/37/zLRX1Qcc2O7IQTneo5hVRbW
/GWCQRhCb0DpA79iFgbzD3xZoXoZ4VX0Hfl6WYj8cpEu3HYZgvEvy17YZUF2
j8aWsttG0PDYce3UlyxICNX46M8xRrhNw/TFmVlwU971oDTAGJSLtr6NHVlY
mu4qvOaACTQOrIMPfzYkE8uTDbtMEChZ1HBpbTb+OMSxfJyugDLb3HLDwWwY
5Y2tb9lyFWrsxSKsy9lYwn/xz7q6qwisSAmNfJKNXRYJgo4O1zAcY3D4TmA2
nh7nnz5lx3WofZjRJZ+fDQUNu8SA7uvwsQ6zpTCy8aIzfeThpxsY1j2zPHtm
DtaLpYa4nbkJlf1/455uykFGh0X3b0FT+Kz7rH7iWA5KP/lFFhubgjPjEFvk
eg7SLfbnqxWYQqWf+az2RQ52fHTY93izGdzL3qz79D0Hnkcd5G+9MQMnaneG
XmkOVNaq05aPmEHxfYvOWk4OpvnwXXTSN4f7PYeRXqFczMsK/ptYaA66zsa3
37flQn2O40DCrltQ3FcmfetULnY6dro8+3oLLhKWRbtu5cJo7klpmYUWoE9f
bjzqmouB7hdbYx9bYHdf+tT06Fz80gn4veyPBVxKjLwdq3ORSoz/Mb55G7SI
OfJHfuXik6V2zJfu29x9ZFTN3MV5+GAwFFyiawknK03zyl15GLpqdX2wwRI0
rfE57hp5aMamN/M17kAaX79p381D7tmupF21d+C0+ugB8Y954Fsn+e6ShhXq
pg3QuhLzoPRiU413oxWke99ZBzXmgWbD3MPWuwvbor2iN0fzEN8i/0KDfhd1
Ye1R21fkY4NnsXeb2T1IujqpDivkQ22miqrL2D3YWm7pS76Qj3BDdfsrz++j
TLPqsd3DfAz5f9tgucwakgr3Vh/0yYeowzrFhFBrWImJpc5Mz4dWRG2BnNID
lE3N0Sxty4e57pz6sboHEOu5+tN1SgFkf1xxmGVuA6sC4dcaawpgNmWYYzzn
IfJC46RWKBegz3rb8eXBDyH2Wiev7VIBvrrN6X271hamFlMv+TsWQD8gsK3E
0hZ5576NX/EvQMOpF7v25ttCVF7VY2tuAeL3KSxuW24H05U/ZX/0FIDu+zky
zcwOaXweFfGChSh+tGBfS64dRLsUbzzYUIgve6+M711lD+O87hlKRwqRPu/v
Vtode6QFO38VuFoIycaQpYXl9hB6JbOv8Hkh1Nmjs/k2P4KxeV3Tq5BCFAjM
PO/49BHiz9hYnS4uxE9tr/NaPY8gJCexYAmrEPt75K4/PugAveUFYc1zixAW
uvzXjAAHxI/fPPplaxGiDpzU7RV0hGDHwp7LakU4eD1OVPKaIzRykuw3mRVh
a95c9/wyR4R/01/JeV0EVgqfZrnsY1BeTE+MjiyCzF3pZiWvx9AwDT1zt7II
HTP2hohPf4JAdfUBhR9F2B9Qrm5m9gSUXSPOUxYWI3xhrNHO5idQW+otmbuz
GJpS5XZmR5wQOKac9fxsMfJt5JQ2JDhhmMbQVbtTjG/rFFX1NjyFWpbL3wXu
xTgZYX1mqcdT+ATIvq+PL8a7zfXTteY+w/CzJhmv+mJ06HitWvfoGVRu2Jdc
/FOMHTNttR+OPIPPSckr65eV4J7lN4crZs/B2VEyjSlfghsj+Zf6GM+hImrx
OVy7BOJx4mXTLjvD/e8ShdsPSnDQ+qVPSrszOC1EnZxXCV6nuMcu0n8BxQxD
i3+pJZCMsx1Z0PYC7l9nCWW2lsAs/Oi55IsvQXeKCH5CKcUavfIsoe6XULx2
7tAx8VL8uZWvsOjqK7iojrULKZVio1x9VtnAK9BlfG2qL5ZiVnTZttUKLti9
6PDSj49KsUPw8ts99i5wGWHFXPArxYXTcz5sz3MBrcnt5JrsUkxftefYvHmv
sTttT39PVylMOkbSS8++RtZJU+WzU8vgeOSv0B3v15goz+eXQc7yrfr03tcQ
3bmItlSiDNZapQH2298ga13v5gc7ynB+i9HWPps3uCaafL9Vmdu+uX7e/sI3
EJ35Kn/fmTI88bxi7izqirS/+ov9DMuw6clGh/zLrrjWv8NQwLIM6fsolqMx
rljQOj3K+HEZ5qaFWa8XcENaWQOl8F0Z/Ge3lx075wbjjNATmwPKILR2c9iN
b25YEG376VVcGYK6lmm8GnVD8ld1xkBuGeymygpFqL2F8ft1u0/XlSFnkaBY
zde3EHo64hhLL8NQ5KYqyuhbJN8rqhQdKcPgS9UH29Xf4dI1b/H7M8qRkghT
0+B33H21+c3mJeV42dk/LZH/PeJVD6RgYzl2B9/1ENF9j0v7RGd92VOO0+O7
31gnvsfs7X0a/EfLcfR1muqfRe6Il0j1v6xVjr7jTIWXFu7QW/T6R97Vcvzo
7inYU+mO2YKXlDZZl6POZJfJlO0fED0i6/LCuRytbcSrHu6WS69vRgv7Uzn4
BMsSmD8/QLC5adOp0HIcH5M0WqD5EdElYXejU8oRKDJ9uX7KR2in2ecuKuH2
/2GjfvVqDwhGnll4t6Ucflm0zFtPPRDuK2nQyCrHyWeza6gDHtB++zdcYbwc
gp+2bpE7/wn8T0r+ec+rwHvdW0aGWZ8QbvX52BSxCu6+J0I8Z6snNK5YfLwk
XQGRQw/5LnzyBL/2IXqOYgUUVsqEb53phZDjS2U3nKxA5f7+RoW7XtBA/6Pn
+hW4GBC463mvFyjb0sr7zSqg47zn/lItb4Ssdl2lZl+BJ4SeAavYG6cXXL4e
+aYC1+mddfziPqAIyCUt8K2AwcZX7+K0fBD4e9aMO1EVwALHMqH3Pjjd23K2
PrMCsi2r2cKVPhhtiPCTr6qAXriqTvK8zwgschj07KzA86P2TsLHP0Mt9Zwi
5WcF5kZm00Sef8Zo2MaXF6dVYkplSl16/mf4fR5rzFpYiRs7QrpWzfgCNdey
DevXVWKrt8XDLYe/YNjB985T2Upo5n8WYz/9Aj9Ly+y+g5U4ynfloEHhFxwz
Pjz/xLlKPKqJMnWe44thzeX64UaVuJ2xdPU1NV/4HGV/F7Gq5NaJQ61T3Xxx
TCFj1MKpEtd3nZI5U+eLH1veHql1r0Sd0Gw//RV+8BEzdpf7VomIttSMjQZ+
UBGR7/ZIqIQXqlZGfvPDj6lzd/zLr8Q/w8dHRzh++PSTZqfXwP2+3M4WPrmv
UOmJKs1gVOKFR51Zsd1XcOoer1j7txJnDDf46BR+xacCzatPZlVB97adYPRC
fygnSyX0LqvCcQPzYxV6/uCEjgsck6qCn91docQQf7h7V5z+vrcK2ir8o9dG
uO1ff/0idLwK/XEWCcyDAWDaW3HMdbifj1z7a8/bALhbHKVWX68C7cjNi5qd
AVC8vNJ5l00VxGcFRxzeEQjmuYH6Dy+rILB598c5joFwO5y1ftSrirt/e1jt
XxMIRfn3ty+EVaH7x/CqxRu+gS51JTON4H5/s5ScnvU3uK1UEF5Txm2fk9jx
qOwb9goJ6TrSqmDDr931aG0Q6HwdIT2cKox39AhcvB8El6GYP4f5qiH18NwC
sYog7O1yUgkRrkb7o/wmYkMwOmu03s1dXY0t3Y4y++2D4ZK3pdNUphrvbPn6
ghuDsTuRT6ZSqRqrvNta/u4MQWdw1cOd6tUosBzv3fE6BM6eAcXvDaqh6ni1
T6M/BLtf3Vv251Y1GhtNs02OhIJme9xE26EanqruOiaBoXA2F4tLdavGXdfg
T5rTv2PHpSF+8a/VuL8z/sZeo++gnck59SimGuseiWTOz/sOp0MffLqyq2Gq
quHctiEMO+SusQ7VVEPS81ZagHMYmjZib1B3NZolPTWMOWFwWi7ybPbvaly6
Ehb4ZmM4pOd21d6YXoOK4SNnTHXC0TQet7Z8cQ1coxK3l7iEw2Hg2a3tkjW4
27j/UGgWt32HTvrb3TVYfqPObe5IOOqqpOcNq9SgnE90zdDmCNjmTNU5r1mD
Ey/V/mgZREAqviYo2aQGWmIPJY58iEDVt2/DK+/V4KiVWmhqKbe9h/VBu2c1
SHgj/iVRIBKSL1TdOj7WoH8JRQTUSFTZrG4/EFyDM2lBc45bRsLa9OfWwKQa
NNi9Duj6zm1/Me/BzCJu+6LqoRn0SJSpexRea6rBR5cjgkniUbA+cGNJKbMG
SdIWoyNaUZDYtc9o21gN7HWcenPfRaFMckGM65xaSJdeZ6ytiILV0p4pv1bU
Iq4jadnCudGQmJ2oprGlFrorEz3eHYlG0ZizVyK1Fi+e6D4LfhINK7Yuc7lq
LQqZJ2ecyY6GWJvMnoe6tcj91ynvNjUGRRXTnNpu1mLw+JJDV5RiYJFVV73f
thb3V3ucrLOLgVhs8Bp/l1pobEt/1Joeg7wAGzPBz7V4t/H5dLspsbD4cJK4
ElGLGat9BFP3x2L5c4k5xem18Ck9Fv3eMRZ51r/Pb62oRUyAndy8vFiY3igI
fN3OPd68sry1s+KwXM/z19BgLQRTrro1nYgjPa/DtgXiZTtc40jP67AsXzNi
a10c6XkdHjxYdLNkRTzpeR3WOTD3iVyKJz2vg0XClEujQfGk53UQ3ThX+OVg
POl5HXIdTjzO25NAel6HznPPpoQ+SiA9r8PsxbNy9hYnkJ7XobzXXeTu4kTS
8zqwYLnJ4GIi6XkdTDdpnRkNTSQ9r8OItWnNgT+JpOd1WOp35JfioSTS8zqk
Hu8cY7klkZ7X4Uem+66THUmk5/X4K7iSbSyTTHpej4wwG7Nd9smk5/XYcn3+
nNSKZNLzeqw3sBb+tyaF9LweVPGPpcO3U0jP6+Gl9fhDWF4K6Xk9cNo5Y83y
VNLzegj/FvM+a5pKel4PO78Gh8PZqaTn9agLNi4YW0qQntdjuemzXAszgvS8
HoJyAtVheQTpeT0Cq1XXaQilkZ7X4+SPx1lJe9NIz+sR/W3Y/JFJGul5PbTu
d7aGvUsjPW9Ae85Qwr6sNNLzBtQt3BEuN5hGet6A2xA2dxdLJz1vwHMN1bAL
qumk5w2Qvskv+sImnfS8AXYib7QlvqeTnjdgm5/X5rUt6aTnDVCymLvXZW4G
6XkDlvuN7r6MDNLzBvSWR1UHmGaQnjfg2FP/zDNfMkjPG/DvrlG0aVUG6XkD
Qs0+a44IZJKeN6BmyTxDjlwm6Tn3+C3Nnc5ezyQ9b4T5OufbUp8zSc8bscRA
pMW8OpP0vBFZqQG3Ns7MIj1vxBmf8h51ZJGeN2KqNauPbZFFet6IFzmbto0H
ZZGeN+K2731j+7Ys0vNG2B59pnRPNBsqE543YpNU1M0e1WwMT3jeiOspP70L
nmSTnjdiZDbDXiItm/S8ESfHo3N/DmeDM+F5I5z3jy6HTA58JjxvxOY/9dJ8
13JIzxsRNbssfK9/Dul5IxbvSjo8SMuB+4TnTZAlsgNWL8+FyoTnTVBv1LQs
OZdLet4E7ez5er9cc0nPm/D2ftRcj7JcKE543oQbm+ZuSpmTB86E5004cmhc
W+doHul5E0QOaB61fppHet4ES4Eaj6V5eaBPeN6EYz0CQ7un58N9wvMmXLul
/KP2YD7peRM+pnvuG36cT3reBH+L3Psfc/PhMuF5E1bqzlQiBAugOOF5E0wL
t8kYHSkgPW9CneFd+hvnAtLzZizJvzeuVFqA3ROeN8M3eKmQlUgh6BOeNyM2
9HaEzNlC0vNm7v1QZHXrYyHpeTOop81G9rQWgjbheTN2ZoVnPZUogsuE582I
byNM9K4UkZ43wz75620ivIj0vBnJ0utuBfwugtOE5814MjOEIYpi7J7wnHs8
uTIXFzwpJj1vhvzPrTofS4tJz5uxT8paO1i0BNITnjdjxTf5lkMXS0Cb8LwZ
h+1ydExDSkjPmyF420V97e8S0vMWDOkK7TTi1oV1E563wPFAgIXsy1I4TXje
Ar3Rx3auDaWk5y34KF9kQHDruknPW1BbE37Oek8Z6XkL0l7/LLHVL4P0hOct
OO106k+RE7f9hOctSF3gL6gfXkZ63oJl03rWKXDrrEnPWyD2ZZGtPqUcZROe
tyDniYxCiWQ5bCc8b8HCk+scH50sJz1vwe1FKdZ298pJz1swPf3NwTzfclhN
eM7tT2baVI1ibvsJz7n9Ka4tk/5dTnreCpsXAfmnxCtIz1vxaku1YOrRCohN
eN6KGTus/cwtK1A24XkrTgvQwk0/V5Cet2K29zfEF1WQnrdCybtW9/BwBfIm
PG+FodL3FRISlbCa8LwVv6QD7FXUKknPW7F2u/7bWOtK0vNWOOW80rzB3beb
TnjeiuXvGaU3a7jtJzxvBb15+a/EqVWk560QDIjOUd1WRXreijw+EbktulUQ
nfC8FXLLzu47+6IKnZK7Vwfz0UA/eKosN6kK8Z/FDzfNoCH2l2WlPaMKEz+f
i9Bg+zVjx5Ml1dD77+fzpTQgJryhSqUau2e3pNxcTYOnsmTgVatqzHbM7fTZ
SMOasSvWRwOrQRsLn1UhQ8PblqnbLeqqEW35UWaqPA3TBWN9uwRr4Mx+pLlj
Pw3rH1394i1XAz3j67aGR2l4N19i/POVGuxoOxvwTp2GvLmdjkyPGgieVyzJ
1aLhq4LvP5viGtAqNvwcNqBx92/ymzXHaxB9dP7yjddo2HFCs/zetlo4ZY0q
aVnQ8KXEyL/DoBbaCt0mztY0bJn2yMD1XS12xJa6pDjQsM3TMOlpPnefszUh
juVM467fGto5o7VoCvjSsuot9/v413BUpOsQLuY87aQnDbf1R5YJX6qD04fb
UvZfaVhRdt12pXsdtEV01aNCaUj4q5tgWlQH6ecq9zpjaAg07NeZzlcPfn6Z
zwtTaTjYpk9p31mPJutleQdzaHA4JrmFwnU//Cc/+04JDQNOSTf1ferhcIO1
8FsN93iS3qtMq6mHRk/t3oYWGqSqNu3qm8V1VC/dYFYPDfzGhdEiSg3grw96
tpfN7a/BZ+d9K67LJ90irv+mQbzDW1IirAEhBQ/qvMZpMLth9Xt2dwMc9huN
l05vg1b7U4GdKxqhkay2jk+oDdfza6I9TjdCauee4zKibRjsG9ZSdG4E5fsa
CwOxNjyqX6i2OqsRdevmeLhJtuEvo7JVcbQRId6/0rOl2xBBqJ722NEEW1Ea
/dfuNsQqiAxIc9f506/z50nua4Oc6PQfFP8mSM2MktU83IaO9ltvZ7Y2gfLo
k86zk21wjWVPPy7ajKq/jg5Jmm14c0PLKvdkMwItbgYz9dvw0K5hzt3nzbDt
16hYcaUNax4U9epx173Tl5VGTpi3QXVD7nqb8WZItm4Ss73XhrWar5tL5Vow
em7hoQj7NjhfX7nsjEULqsr+XW9/1oZal2eM2WEtCDxMd5vv2gbz74vVfvW2
wDqjPEnZow39WzYdEVrbCjX5pPbbvm34fu9YuaZeKySj/WYEBHOP54hEXblH
K0alXkrXRbWhNN/66J3aVpR9vXNuRnIbylXEn/px7yu/lfo2e7LacBmZAr7r
abB+f+Tr1aI2zNup6Bx7gAY1oR1Fn6raIGZw2KGFe11LPF0xVNzUhjS3gLNL
7WkY5pu+dLyzDW3tCsYmPjSU3eMoSve3IYcxe1kh97ryG6o30v/JPV8PZUuo
zTRYXct8+WasDeLNfC2Zf2k41hUSkzmtHWmnab6aS9sgceFd04857ch8ZG45
zj1PwzUPp65b1A4pwZffos+1oUjVZOO5le2IStn/0sqyDT55p046rWuHkF23
+ZG3bbDat9cqYUs77KxFfDdEt+FY4lpvhmw7RseijRZWcsexfV7OMrTjdf2C
6XMG2/AjeJh57FA74s81Zs0TbkeRRPt8G9V2hEasaF8u3Q4fz8I9YefaIbLc
yHM79+8Wi2L0abrtMNHPlFG/0Q6VV15OwsbtmDK7oPHei3aICTqFKZm2I0gs
qPRbSDt+2JrV3LJqB+WK7P7WwnbkjZwf87PlHu+ZQeOlfe34ZK4sUePUjuAL
q8zOz+yARd/mo9NftyNSuPCp14YOqFxabL77Qzua3ja3dKl0YHkz5YPJ53as
LpX8uNW4A5wzDOLjt3Z0zrLquPekA3klld2FEe3QUvKh5fh34NOhlDljCe1Y
0OgSI5LTAdM0/x1bMrjfJ2jooNPVAWU5Fy3dgnbMCLp93Z+/E8sj79q7VLQj
IPbqK+aaTnA2GnxLb+COX0Z9+tb9ncjyPVY22N4OHf/vnGsXO+G+XPb3Gu44
ros/N/xq1wnTt6tWnhlqh3m0m02tTyeU58448PhvOwbNNqlPSeuE6JPBq3FT
O5BJtxqRaO0Ec7zxDX1WB/hFHz+m/uP2b5WdsGRBB8rqT849saIL7gPfaUeW
dyA/rcf31N4uXLviPt1aogNMwzuaR7W6oNhhtyVUqgOd4tcUd93rgqj21TMt
OzpwfKujycIPXWBWnbaep9CBa9Kszs64LqQdp/oqHuiA4CKNDL+aLrjlrC8w
O85try8ifPont38ID3w5w533FAnawPxuKMb/WVyl0wEXhjH1gUw3FmzrpE67
3IF7I357fqp1g/6t2FD2RgdGC792aNzsRvLqOGcjyw7UNGqqBLzohpuHT5S7
TQdeU5l3WoO7YbzgWUP+4w7ItbfaUQq6sffFLb6/LzsQNbbRcga9G0ICOpJS
7ztQHnrKcGRaD+g2B1V1vDvwMfGxXumaHiT/3mr5MqAD9g9S7j7b1wMX0yWe
RFgH5naWZm7Q7cGl3ilZnLgOTHny9lSIdQ/2XmQyxNM6sLicIi/8sQdCjdXC
6nkd2LJF3vVcXA861YndDmUdOKqQbm5T1cPdIwTqxtRxr6sxm0GHAW7/B948
7qZ14Mdgn9SVuXRcSr0furiXO//b11M3b6Jj9y7DKpWBDmw0mq9cfIiO2eEn
/t4d4V7Hn8wvHL5EJz3vxPSpU8J8bOmk553QvvVWs+ITnfS8E9E5Mg7N8XTS
806s/Cl1Lr2KTnreie9D1DFrDp30vBP7j/n7zpvdS3reCQtjhXtW63tJzzsR
5/Q2Klapl/S8ExX6Qo75Or2k550o1RxZF27VS3reicALXlUmrr2k551YqmZc
9DO0l/S8E/m/BlXV83pJzztxyl7Cz669l/S8E5FPlYVtR3tJz7n3xWORjuOL
GKTnnfDObTRmbGWQnnfid4XLz9OHGaTnnTDY2dDqfJFBet6Jy3FS9q/vM0jP
O3H2R9Oei24M0vNO+J6QufYvhEF63ompCnetDbMZpOedKOxbUPOumUF63gnX
LS49r38ySM874ZAauubsnD7Sc25Ov8PXIdFHet6JsXcnRnft7SM9536++5fr
afU+0nNue5b/sd1X+kjPuffx3Plh7bZ9pOedaHh5V0X9fR/peRdyP4QGPQ3t
Iz3vQou5+DXHzD7S8y7MbmavP1jfR3rehYcxnQ8KWX2k511wSnMQWcjPJD3v
wnn/Ba9WL2GSnnM/L+79eWgzk/S8C+qaf0afKDFJz7uw7VaRRutZJul5F9iH
X5mNXGGSnndht7arYI0Nk/S8C7fpfJ0Wb5ik5104vKelpPork/S8C9obBT4M
xzNJz7vwp3zb4uZCJul5F/beGlz9qIVJet4FLffwjwwOk/ScO56r3/TnT+0n
Pe9CyeE+3bEF/aTnXZByPWkfuK6f9LwLMYkPExfs7ic974LAh8Z/+w73k553
oY7/yRHp8/2k511AtIZn65V+0vMu5JlU/VW930963oU4s9U37Z73k5534b65
wDQLj37S8y5Q3apL1wf3k553oXXqte5Pif2k512orRK/VJnfT3reBdVDhHFh
XT/peTdu3TYVdezpJz3vRsb1eA/Kr37S825MTTVYReVnkZ53Y6HFvSoFERbp
eTf0PmzjjK9ikZ534+zmpmCHzSzS826s92tULtrDIj3vhgb71WjNIRbpeTeS
5h8S/XqaRXreDUd1qTZZfRbpeTcMOLJ+ztdZpOfdcH4uGul/l0V63o17kpt0
HR1ZpOfd+FB7YeqG1yzS827Mm7v+z+tPLNLzbkiHG31JC2CRnnPX8Ur9CzGR
LNLzbsyX93E1TWGRnnej0aMjaDCXRXrejXfec4X2VrBIz7tRlCAsc7yJRXre
jYOFNfbrulmk592I9ZC6k8dmkZ53Q2FL5OPtIyzS826c+Jm+yXgKm/Sc61af
dsflWWzS826kvVm4WXoBm/S8G3I9f55lLWeTnndj/95HdhJr2aTn3fi+8M57
tc1s0vNudI40njm8k0163oNCpdZD8xTYpOc9eDWY9ueLMpv0vAfMl6lj/MfY
pOc9mCP4r22nOpv0vAervlvtkT3PJj3vgbRct4eAPpv0vAdvegI+BRixSc97
4BATVbXkBpv0vAf1EQ+bdSzYpOc9iDLvP2lxj0163oPToTtLdGzZpOc9mPaj
kr30MZv0vAcSnuZnQp6zSc974Fxd4yXymtv/hOc90GgrunbiHZv0vAdqLxbo
63mwSc97QK08vvKwD5v0vAf2UV2HZnxlk573oOPAVPvP39ik5z24MfW2mch3
Nul5D+4e9UrSjmSTnvfg+lpDAbtYNul5D14qig0/TGSTnnOd3u6463wqm/S8
Bwv/vbsqlMEmPe/BzAI3ed9sNul5D7yH6Cfm57NJz3sgri56XL+ITXrOPR/F
Ec0vStmk5z0oWU8N/FDBJj3vwUlJ6dOO1WzSczre/6xyOlnHJj2noypTuf9f
A5v0nA6PXHXJl81s0nM6YPaINt7KJj2nYx5nKOl0O5v0nA73f2f0XnSySc/p
ePyryTyom016Tse2zdvcQ+hs0nM63r2/aOHGYJOe03EmtjHoIpNNek5HQN7p
lsUsNuk5HaIHc8Oj2WzSczqeeOlnyg2wSc/peI37sQGDbNJzOiitThvGh9ik
53SsmiGcpPiTTXrOHd+gj+D1X2zSczpMnNO/O/xmk57T4VDPVHEaZpOe0xHt
8MjMaoRNes7dF8VkpJ/5wyY9p+PV2sRysb9s0nM6XK4r7W7g5knP6ZB5O/TM
fpRNek7Hi7plF5aOsUnP6TAPjFX+ws2TntPR025QtvQfm/ScjrB9uq8duHnS
czrU/t1ZROPmSc/p+PJNsH/zOJv0nLvP28n2ucHNk57TUbzFMfkLN0963oul
ku55/70vYtLzXjiqXjzWw82Tnvfii8yj4mFunvS8Fy7Bw6X/vS9i0vNeGP5e
XDP6X/8TnvfiwtBjvf/eZzTpeS+CHu5kNXDzpOe9aJ92bjT5v/4nPO/FS3Ft
gff/9T/heS+ETJiOJtw86XkvTp2hDe7g5knPezF4QD5zhDveSc+5+7TPa6/G
c/Ok573In9OjbcbNk573QiaDJriWmyc978Xh/ifNldz5nfS8FwxpvUM23Dzp
eS/Ctv4Kl+DmSc97UbqpwT6Xe74mPe9Fd/THNUbcPOk593guEr+ncvOk59z5
8MzU9+Ke70nPe1F5VThDlpsnPe/FKtVRy2Lu9TLpeS9ExJObLnLzpOe9mDNi
dPw39/qa9LwXifMHxJ5z86TnvbibvCJ0JTdPet6LAlmHA5Hc63PS815wvjrK
//d+rUnPe3FgQKWlgXs9T3rOQKJvzL3/3nc06TkDDVk3tKZz86TnDPAFFed5
c++HSc8ZsElpEtzDzZOeM6Aof0q35r/3HU14zkAU7dmc29w86TkDt186nFrE
zZOeM9DWUHcl8Qeb9JwBa9c4F31unvScARWptr+zuHnScwaOL/vclsC9Xyc9
Z+DSqjyLq9w86TkDX0z9u8S4edJzBubXT7vYwL3fJz1nQDRmzUJ3bp70nAG9
+qD157l50nMGll0IJcS4edJzBr4d96IwuevHpOcMKMsenZXMzZOeM1DzqXrM
hZsnPWegSy1k6Ao3T3rOQIu3w7Qj3DzpOQPqRuqHt3DzpOfc+eU/WLGYmyc9
Z+D0mqRwgQGe5wxcvCQ/+IfD85zBPU9mn39weJ4zcMJbIue/9x9Nes6A8Bcp
w2EOz3MGYtffsJ0ywPOcgVH7skUiAzzP+9DWtVNi/QDP8z4s57v1ed8Az/M+
bLM+6KA/wPO8D/EH1IjHAzzP+5CXJKgUMcDzvA+ZIXHDtAGe533YI3216L/3
mUx6zq0LNFhfVAd5nvdBJpm48HKQ53kfyhumt5YP8jzvwwyNV+NLhnie92Hv
/Bj3y0M8z/uwc8mlh3FDPM/7sMNshuPsHzzP+xCQ8/SO4Q+e533Q48iKZ/zg
ed4Hu7PZKqt/8jzvg/LufRGOP3me90GxcupS5k+e531wux5IPfOL53kfspX5
atN+8Tzvw1qD2e+3/OZ53odOHfoWr988z/uQO5Z3ZN4wz/M+rKrue2M3zPO8
D+rZzsE/hnme9+GXZcMO4xGe531YlMsoaBzhed6HHqmwaap/eJ5zj3dZr1X6
H57nfZDVXxkt85fnORM/X7xQ+vKX5zkTg+dXB88b5XnOhI/4FdN7ozzPmbih
5yTUPsrznIk49U3TDo7xPGeCEWCb+XWM5zkT5oc3JlP+8Txn4qDGdq2z/3ie
c/tTnibo/4/nORNeS3TWsv/xPGeCNa4ovG2c5zkTO4d/Slwd53nOhGvDz+hP
4zzPmUj16hLKHud5zsT7H88fdYzzPGdCd2feqd/jPM+ZWBDzlPjPp0nPmVhk
nTvtP58mPWdi2MxKu2+c5zkTx6Y4/ywa53nORP/+jjHvcZ7nTKwPPeJpMM7z
nIl/Oha/Fo3zPGfi88yhdQn/eJ4zkeay89DhfzzPmdiu9OhKzv89Z0KOM+y1
dYznOROyGY/7H43yPGfiTidLM+Mvz3Mm7i/Jbu/9w/OcOx/yN+1GRnieM5GY
uG4jZ5jneT8MxP8WFv3med6PK5HVai9/8Tzn1nXrbTy3/+R53g8vH5/XSUM8
z/txoapq+tpBnuf9aHPyr77B4Xnej8tXvAvfs3ie94P/8KkYLybP836Ylhhp
2jN4nvfjeELI3X10nufc/kLEKxu6eJ7345rf7JXHO3ie92ON6Oy572k8z/tB
b990Kq6Z5/l/7+346xbSwPO8H/U/A61v1/I878ebgEXBQlU8z/sh83A0xbqM
53k/Zi3jV40v4nnej/S23qH0PJ7n/fic6U11z+J53o/TW8xT5NJ4nvdjBFv/
+iXxPOfO90G1h3WxPM/7sfTd2pKKCJ7n/diVzW/yJoTneT9kT98tWRjA87wf
3qV37ml95nneD71brt36HjzP+7FKU/bZ+rc8z/uxaXdTQ9BLnucsTCdUjzGe
8DxnwfA5Q63Tluc5C1+zazXf3+V5zkLPRc1aPnOe5yzcEhKSW32F5zkLD/MO
sH7p8zxnYUBI/rKNJs9zFpJplkJxajzPWbiyYYmO9yGe5yy0/9uaspPK85xb
x56b52u1g+c5C/yawfaXN/I8Z2HJlp/lY6t4nrMwW3XPDIWFPM9ZcN712Hf1
TJ7nLJy1EFgV+o9Xn3PbD5uONQzy6nPu+D5fywrq5tXnLIjS/o4tbeDV5yz8
Ue/dvbGYV5+z8FRHdkYtwavPWdAzfS4oFsmrz1mIEg6qmerHq89ZYOjQlti9
5dXnLDzhPHj47jGL9JyFgulHkpXusEjPWVBM+uPsYMQiPWdhlWho7HnuvEx6
zoLPb53pWQdZpOfc+dcxOEvsZJGes+C2udvhqASL9JyNwSnaNkYiLNJzrjtD
FDkRCov0nA19/pOxR7jX0aTn3HV0md1UoYZ+0nM2xiR/y+nn9JOes3FeLf2h
QmQ/6TkbdypnCfp59pOeszHv7tv5bk79pOdsFEuvHph9q5/0nNs+vG9sjk4/
6TnXvZx5/u8O9pOes9G/dPSS/9Z+0nM2OsRqs/dy16FJz9lo7+oy0KT0k56z
ce8xi/GXuw5Oes7Gzz/vFkuUMknP2fgyTMSVc9fhSc/ZeODbGMT/ibvuT3jO
nZ9CtCfbMUnP2ci/fUv/z2Um6TkbrZfvUFO4Lk16zsYsmxlfpkkzSc/ZuO3a
nls5n0l6zoZhAOvf+t99pOdsLFn78NuUhj7SczYip9xRuJTcR3rO3bc8N1U+
7tVHes49Pu8mrdSHfaTnbCgoL9sZr9dHes7GueMv3srv6yM9Z8NOwPvsYfE+
mC9Y/rqawsHVyELDdkofmspcJFj8HCzI/pA1ncbAwRfT4gVmcCCU+sopMZWB
8MP3jq6aw0H1S/HGv58YWP7f4+fCHPhbvxspusfAxOPnCzm4Yt6zY6sGAxOP
ny/hfj757cCanQyc/+/x8xUcNG28FxAizEDO73Spj+IcxH11bivg1hnS0bJp
kWs5SNrqp2Cb34uPpsHqhRs4GDDbeq3Erxf8m8V6OjZz8Ky5a2vcw16Y9rrd
G93GQaONmc7e871o+Dpj7kJZDky8hRt1d/RC+aLN5817OHhzXtZnzdxefF85
tOMglQPa8YUxT7l17dJGo7wLShyMvN4l45bGrcPfN2ndOchB91Y+xQMf6GCp
n2S/OsKBs4rMIm8zOjSEcuwDT3DwedPFv76H6cgq2rMo/RQHo54WymfF6djy
NOxb/VkOVrjNOB0/3AP3AxIKg+c5uBXY86GotAdTpnwom6nLQZqH/pu3/j24
kTrn0hoDDk5tjste+KAHdffsf8sbcZDrbZarqt4DpV2/n52+ykEqNXnnwQ09
CBm6uvL6TQ5uICH+779uiIbTIhxvcaB5tpLvVlU37K+dOeB1h4OZurMLv3/r
BlOyoC72Pgc9tw7XRNh042wX9VrpQw5Eaj8xbdS7kfE5arznEQcCs182i0p2
Q+qCpCvFiYNVDno29qNdeLfUc90SZw6kofkttawLlFrhxG0u3PnNmKpQ5teF
a66Pjx9x4+B7juWyRKsu1Kj+pV1052DXuPuGh8e6oDjb1OL+Jw4Onbt8YrVY
F4LyOqe7+XCQIiBr7j/UiUWOmh4hfhzo1fHZzM3thO2+ki3Zgdzx/ft+Xudj
JxhjShnNIRz0FWpw3l7vxOnEuDO/wjm4E+S5NkmxE2mWUr1zY7jH781qKZ3f
iY3bP1uvT+AgM7RtrKa7A27shUKKKRysu/JErzKhA/+Cn/lqpHNwaSyTluvc
gSvG47Jm2Rz004PV43Q7UCVhUfA0n4P3uZ1OfjIdoLbRdb4Uc8dzdOaRN9M6
EOipM5BYzoFO5OLzj+raseB8hUNlNQfafdUW94LbYbPokCiznoOS9ydO3LNp
B70iKZi/hYMtK5TfOJ5sx6lX0ljRzoFh//cOL4l2pB79WrGzmwOLTYpNeb/b
ICm49PIJBnc+SnpnCRS24U3Wy5HLLA6qtK8Na3i1YdR26ouHg9zxaTGWZ5m1
wVjBSsz9Fwel9na9hw+0oWKEGRX+h4OYnN4Mpmgb9sbqH8r/x8Hf/UunhDFp
8DevaWibMoCU+T+G3qTRILL16I0/AgPQmDVU99GNBus+gm/+rAHYmnR25hnT
0B2w4+2meQPwM/GlrlKg/a/l+o7Lqf//AM6Nm3JnFm4UStkrGqheKBpECVlR
KdSthKQISZJKymhpaUhWFBVRUYq2JJSMInucc51VRr/r+/P+8zzO9fm853k8
HxesnDLGmgxk0JDX1JnY/xVujVS7tXYwA4V9KS6xlS+h1Xx8yc5hDBrXO+RZ
e71EeEzP1qMjGMQk3apyGfkSHct9vc5qMDh+49zWtvIX2DiAUSgcw+CB7Ldp
xc4XqK12jn8ygcGjsaZvho16gVkhjVO/T2FgMjbkelNlM1JNl5T0msGgR9CM
fn18mtGve4ntKH0Gv+O4CTmazdhdpP9ppgGDyStyNJ7UPccb30v7ls5hkHk1
ht/h9xyLZ6oP+M+EwQ8/yf/Y5Oe4yUemHTRj0DbRM3xicxNGZ/WeGbeIQfDY
f0otQ5sQ5u5Xec2KQU6hQSY/uwnSeH591TIGpV8087U+N8LpnYvs7UoGs9/c
MGiNa0R1yovA32sZhHxmXSctboS+vc3QwQ4M3pn3c+jZpRHJw+9fmuLM4NK9
Z2o7sp6hzzODuWYuDNqDPwRtd34G71NX6+3dGJR1/Njc899naLHW2uyzjYGu
6nz36VVPsajP6R8ROxnMW1MxSTrwFHnlfY+d92Hgq1Wmbqv3FOqHA9SL9zKI
n90z0/rLE4Qat19vOsDAWGvVsA8pTyB0uplzhxiIOXyU2poncLzV8vyfYAbF
yoyBbMATVHrbemiGMeilellxc0UDdHUquxkdZ7C0YNnHvQENSGLmRK2IZBDb
Y+FlHaMG/HP5+vitsQymHLsyIFx6DC/X8QWHE+TzVn5++2j2Y7zSSrROSmbg
WN04Z8rWx7BoHfg27yyDuo3M4J0THiMnMcj74XkGs2arXVj/vh4j1/7q/fEy
gwEX4hZ/S6tH8JDtiX9ly+PruRiPdqoHV9+mPSyXwVj90tzf6vWwj1hTOj2f
Qfi3orJ9LY9Qblm7alEhA+luzt7U5EeYoTj/i1OxfF82N9Zt3fAICaU3/PaW
MWh6lJf5avQjKB6crBxZwUCx4PZnoa0OnkhJv1zDIDIkd2lWRh1e/Bg8u+wR
A3itPj3ArQ5meaHVL58w2F1xd9vgaXW45tnVUWpicGC4sL2Ifwi1aV58v1cM
ZhhumKyU/xBBXz4GjXvDoPK7vdYvv4dgM9YPn/eegd2YC7XHTB9i7cb6zNWf
5fdlvogs6fMQ99XNjXd8Z9B7nqwhtqEW2i9vN4RwDD7VZrf2T6xF3Glt11SJ
wa+uOj3Gba7F3yvTf936Kc+v2Nzn5bRa8pyFVeWnd5ulGvKcRbjjbSwOqyHP
WXhc227opllDnrNYluM+sOR2NXnOYsG0161WttXkOYvLcZF3+rNV5DmL79uL
r3QPqyLPWQyTytPHTKgiz/8Xr2u494NK8pxFmaPLAn5zJXnOQvX3lrjTCpXk
OYtfBRErXS5UkOcsDs0Yq7d2cQV5Ls/nnvBxG1tOnrPQrn+pei6qnDxnUYSD
234alpPnLJ4ZNu3f8vYBec6iT2J9E3/0AXnOYu6+lv6Reg/IcxaM69FzFi33
yXMWYwf/Htk/7D55zkIv6qDYNus+eS6vz0gl9cH7MvKcRb+JtbE5UWXkOYtP
ER6LLpiWkecsLlaWaqVJpeQ5C8sVY0+dOV9Knsvvv/i8S4JdKXnOwkg38GFU
/1LynMVUk8NuoaX3yHMWJ7U3zPLxvUees6iuGha/Zvo98lwer1tIx9RPJeS5
fN4/8nKFlBLynIVb6uRZ5+1KyHMW1+pN3psNKSHPWTj28hhX+6iYPGfR+jRo
o2F4MXnOYjD6K4ZZFpPnLExyvfwKexeT5/L7V1nr15TfJc9ZdP5MTL4ZfJc8
Z7Hap+v0/Qvvkufyfg/7tH6o0l3ynEX++ufJR2rukOcs7JTCvcuP3yHPWbk/
4x0aV9whz1m01Gx8lTPsDnnOIki/YK/d6yLynMWS0xElFelF5DkLi82WJp3u
ReQ5i9wLoeG8bhF5zuKfoB3+KzsLyXP5Pqmsfjv3eCF5Ln/f/URIslYhec7C
evKUop23CshzFt7Dbz3JsSkgz1l4mm6f6vD5NnnOouPjem2PwNvkOYumI+FL
Xo66TZ6zeGE4rfv5glvkubw/4tWGirW3yHP5fO+22s75mU+ey2A4W1mjW3w+
eS6Dl4HWi77IJ89liObTZzq23CTPZbjt2fadD7xJnsvQ5f7vB6UTb5LnMvSt
+Hyq9tEN8lyGKzejpvb1vUGeyzDm7HO/fZo3yHMZ/BsivYfW5pHnMkyZe1b5
5Z488lyGBFVu7f2xeeS5DHFXdjrVNeSS5zJscJpk3n4olzyX4dmc8TNm6uaS
5zIMf3JoVdi7HPJcBvUse4mLySHPZeju0LzaxTKHPJchdvzQhnddc8hzGeb7
jivfknudPJfBRUMhmXO7Tp7LMHdD9KM9mtfJcxl8uNCXv5uvkefy/nZutN4d
dY08lyF+mFPhR+tr5LkM4uZt5YuUrpHnMriWDVeLf5BNnsvwdO4hj6eB2eS5
DI+yLPx/mGST5/J+ZPmqdeueTZ7Lf/8kaOjn4izyXIZm27ErsgOyyHMZfPtY
5i9fkEWey5DZoWRU2yuLPJdBQe/E8xGVV8lzeX93d02cG36VPJehU9M5Snv5
VfJc3q8vca+/Db1KnsuwaoRJitfrK+S5DN9OxvUuOXeFPJchz8bb5rHHFfJc
hqq36rfTZ14hz2V44mFxUr/bFfJchnzNh2sUT2eS5zI0DlxRqzItkzyXz8cu
b1nY/cvkuQxmIZEP3B0uk+fy+ax3GZX14xJ5Ln/P29jbRF0iz+X7e0N22nLG
JfJchhPaU3+crrtInsvzz1XMmbn9Inkuw52e7irqAy+S5/L9afy13er6BfJc
hiVb2vSLVl4gz2XYN+Di6y2/zpPnMtTVdojWKefJcxm0FbwG/WdxnjyXYfzc
oHfZbAZ5LoNij+maY+MyyHMZFjAvoosXZJDnMuS0Thjmz54jz+XztrtzYn3i
OfKcg8rQEe22lufIcw45jW5Wm36mk+cc8j2tLh25mE6ec/L/G9en5dulk+cc
lnWcVZL6ppPnHDo6R+w3KD5LnnOYr9z0MGDXWfKcQ9phrfVVE8+S5xy6P885
OqA1jTzn0NDq89AqNo085/BZx/VCwNI08pxDzC/HjPO908hzDh80OefCe6nk
OYf2Vt2gQr9U8pzDwKTk4nSDVPKcw7x5LU8821PIcw7fXmWEa+SmkOfy58eh
967sTCHP5fno1a/6VyeFPOfQlL/cYDWfTJ5z4DstNnnkJJPnHC4bjnu10juZ
POdwepNPbr/ZyeQ5h69XrvQ69fsMec4h1U+ho+XuGfKcw4qHa2+Jh8+Q5xxC
fvwIrrU8Q55zqPoSfMFV+Qx5zsH/YaNbcVMSec6h1/B7E56mJJHnHIYq9TQ/
uyWJPOegF6s6fYJuEnnO4VrpKAenLknkOYdTdRbpCZGJ5DkH3xsjxz2alEie
c6g3+OnmUJpAnnNApt5lE/sE8pzDmHSlGd4/4slzef8LV6wRo+LJcw6mk8wi
buvEk+ccdCZPX1ZaH0eey/OdP3+60s448pyD8kLz6qOD4shzDjeWujw2vnGa
POcwaBXTa4LdafKcg3PZgJn46zR5zkEsODff91wseS4/r/1L9cWSWPKcg2J5
WJG9FEOec0gMfTKrS3IMec4h1kY5I29RDHnO4WRXJd1AKZo8l5/f2zzUOS2a
PJf3z60wwdommjznEJZbP8jsr2jynIN3LvvWJCuKPOfw90x3X5MNUeQ5B41x
722NVaLIcw5qXYZ1M7ofSZ5z0G49pzLNN5I85/B298fp/06LJM859Nxb0EfW
doo857CrbdWG/PhT5DkPt7dDfrgvP0We8xA8rC4o9jlFnvPwDhm5PKTsJHnO
A5NN3345cJI855HdLLOZYniSPOfR/Pp06qL2E+Q5j08aNW/n5Zwgz3nkX1Ca
1tfzBHnOw6Ig/vxl7RPkOY9DMY4H1Njj5DkP88rsr2uyjpPnPPzH6Og67ThO
nvP4ZpqZNkPnOHnOI/H6+5PlYgR5zmNJ9H5njfwI8pxH/M9if4P9EeQ5j/vn
jzsMNIkgz3nsD5nql6YQQZ7z2BOjtfF7TTh5zsPSTi2ViQwnz3mksgWPzq4L
J895DDgZHKU0Jpw857FutY+O6atj5DmP2OdW6lU7jpHnPLqVTXE/1+sYec5j
hIptcn1CGHnOw6zGc6Wlbhh5zqNpvPOsPjVHyXMeime4rgNdjpLnPBaJyd62
3Y+S5zxcdTftepIUSp7zqAv2bAszCiXPeTzr0+W2T3MIec6jalfPrif3hpDn
PLzShpQ9Uwshz3k4KQ3VNr0TTJ7zePyX8o6nTsHkOQ+Dxx33jygEk+c8Iop9
/Gwzj5Dn8viFBTLDFUfIcx5qf5kGz/wdRJ7zyHG+mLcgPYg859FybEcXR+sg
8pzH4WeN3w7/PEyey+//lTHq+rnD5DkPNuAvw7blh8lzHvz3qfzg7ofJcx7T
4vcpmGYHkuc8Rq7uPt9jQyB5ziMsf+++cOVA8pzH8SGq0amlh8hzHlkz7fdn
+Bwiz3ksvfZ2YtykQ+Q5D+nrvFSflgDynEdaVaPMKDqAPOfxucv1GR8WB5Dn
8v5Ly4N3/h2Adf/vOY9tXlHqrwsOkuc8Ptw8oDPO+yB5Lt83K80eC7UPkuc8
Ctx2Nht/8SfPeez9pK7cP8OfPBfgW7er1xVnf/JcgLRruoaahj95LiB83KaG
la8PkOcC9DfZxNslHSDPBcxIn/9znP0B8lxARoqXX/7IA+S5gM2TPhT2bfEj
zwVsCTBfNTrVjzwX4KldJRM2+pHnAkZuHIhD4/3IcwGTonu3xTTvJ88FmJbv
SIzatJ88F1B9KW1WJ7uPPBeg6VpmW7l/H3kuYLJ/6tkOpX3kuYB6I8+2Q/F7
yXMBR38nvXWZvJc8F3DIJfxAcpEveS7gL/8tZycs8yXPBZQd/7K464c95LmA
sfzogBH795DnAm5cMLPzH7SHPBewtXp/p2bmbvJcQMC9zPi/zXeT5wK6LLHw
HvnGhzwXMNtyePNWPx/yXIDqStUxjKoPeS5gxIA5BUm3vMlz+fNs48F71nqT
5wKC9x/M9v21izwX8Px31cjkxF3kuQDZkent7+btIs8F6Jx43mLxzos8FzC0
tvlYWagXeS7gdaBSwerpXuS5AL2gZ7pdm3aS5wIu16rW5B7cSZ4LOFn7Y+Oe
STvJc3l+y7M+mD31JM8F7B/oZaka4EmeCwh5aHGCn+pJngvYOL65tPrFDvJc
wOOPa3+nHd1Bngvo9/fK1d6GO8hzAVmqkT2Mv24nzwXoxnMzuiVtJ88FTN9g
PCZn6XbyXIBxxyjNVX9vJ8/l/VjT7Pfh5jbyXD5Po8WRTh7byHMBUW255WVa
28hzAbEH00P7vfAgzwUE9aq3MYj0IM8FDAr5nWS2xIM8F5Co9uiXtoIHeS6f
55qT7czhreS5gG5xytundrqT5wIM1E5dHO7tTp4LCNvj2jWLdSPPBfyNyGef
3N3Ic/m85oZdvvd5C3kur+9Dd8XZW7aQ5wKsF2cdMv3yH3kuomOGWkXb1v/I
cxHn37ueUOZcyXMRgz6OTK/0cSXPRVz1+NGs2NWVPBdhePu6WsURF/JcxHD9
Z+sUlF3IcxFz1oQm30ncTJ6LWGnv+PPbxM3kuYgT1yYcDc/fRJ6LUJxUdjBx
4SbyXMSEdtnwf5s3kucixiwZndK+dSN5LuLlQyt3w+4byXMRDhcrW1/FOJPn
IvTsh3q9mupMnov4x/hOqv4DJ/JcxNfzGj/fOjqR5yLu3Fuu8vbXBvJcRPMQ
/pR27AbyXIT12S5TK/Q2kOci0nKunrnQ4EieizAwXn691suRPBeR1UVrrt4Q
R/JcxM9uY8Y8v+lAnosI7Na57NY6B/JcxLYp9cX13RzIcxHvksZ6q5+3J89F
TF+TeyDZ2p48F1FRlCKkcOvJcxGjMnxV1pqtJ89FzFg38c6mhHXkuYjbny08
7gh25LmI+n9OXd5gbUeei+DzLw43v7yWPBeh8rZx6xalteS5iH3/1G27776G
PBdh3G17l5V1q8lzEUx0qNIg/dXkuYiYhRcSfiWuIs9FeH99XKmguIo8l++b
+eoSHa+V5LmISxknS3zf2JLn8nztb4xoXGZLnot4OjVxlnnZCvJcxJYzwaH3
Zq8gz0V81O9IsMhaTp6LyI7doVQ/fjl5LsLngPUhu7Rl5LkI15jj91pGLSPP
RahqZySsT7Ihz0Wcvb+QrRlpQ56LaNiwIHtKylLyXIRj8aK3u8csJc/l+7i2
Ku7SJWvyXL7fmvd+F+tYk+ciDmqcnHOz0Io8l9dbVpceutCKPBexR8VKeWvW
EvJcBBc7J9b94WLyXMT7TwqV/ThL8lzE5GiX7MVDLdHr/z2Xf58jOrxHmSwi
zyWERLRt8N+2kDyX4HUy8ZlrsgV5LkGnMcKuvsGcPJfwlW8Oz+tjTp5L8Ino
r93fwow8l3CtS8vwp0Gm5LkE2Zj35j0rFpDnEtRv2lVH91tAnkuIL2lqClw1
nzyX4BI0tKgizYQ8l/ArOuuNA29Mnkuwmfey2tjMmDyXcGzyvBFbEuaR5/J4
FuciHotzyXMJwa01P3cvm0ueS/Bun7LU9toc8lyCQXlRvPPgOeS5hHcDQ3rP
+2FEnktQDpt8SqHakDyXYCi9Dh2SbkCeS2gM9Wl0DpxNnkswCiyJfv/fLPJc
QqnKRJVo25nkuYQ5Cctq/jPXJ88l2Gnc8V4zV488l9f71ZtbB13yXMK/6zNX
uBvrkOcSnF67vTlgOYM8l5Ded87A43bTyXMJS76+DoraoU2eSxg/5/vQkGPT
yHMJ/fjYauerU8lzCZsWZ1+ZmzWFPJfwc4mJ3n9Kk8lzCZc05i2f7TmRPJew
s/R9SFrbePJcwtyptXnxTuPIcwkLA11UhnwdQ55LSNb301U4qEWeS4gZWNh7
o4YmeS5Ba9rMlxo1GuS5BLUqYZl+oDp5LiHg4yHXGLNR5LkE59owL8NBI8lz
CWUJT610X6iS5//r77G+NmeHkecSvk/a/r4w4F/yXMLxi4/Mt/gMJs8l7Cnw
sTILUCHP5feNY0tN0gaS5xLiOr+NtnnenzyX16N6Jcx5XD/yXML7Fw/ONQ9R
Is8lrGhZ2lqiqEiey/MtEv51GduTPJd/T/N8vmZv606eS2gO27UivK0reS7h
do++Oo+VOo3+eC5BaW35efu0DqM/nkuo7m3XlnRCMPrjuQS9VasdvJ6yRn88
lzB6zg3XoHdfjf54Lo+nkazzqvy90R/P23FTobCmZHWr0R/P2zEhJ89wyORm
oz+et+M+2/2Aeme90R/P2zHeIWtUnVWl0R/P23GpR/NPN5s7Rn88b8eXXdqK
h3tnGf3xXH5eY9GtEwanjf543o6LHZlHGya4G/0fy944Xg==
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw013lcTF8bAPDsIdSvsiT7muyRvRNJoVIUKUuEFpGdRItSomghlKXNTkIS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         "]]}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {}, {}, {}, {}, {}, {}, {}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-1.5697963267948967`, 1.5702036732051035`}, {
       0, 0.9999999105397013}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {{{
         NCache[Rational[-1, 2] Pi, -1.5707963267948966`], 
         FormBox[
          RowBox[{"-", 
            FractionBox["\[Pi]", "2"]}], TraditionalForm]}, {
         NCache[Rational[-1, 4] Pi, -0.7853981633974483], 
         FormBox[
          RowBox[{"-", 
            FractionBox["\[Pi]", "4"]}], TraditionalForm]}, {0, 
         FormBox["0", TraditionalForm]}, {
         NCache[Rational[1, 4] Pi, 0.7853981633974483], 
         FormBox[
          FractionBox["\[Pi]", "4"], TraditionalForm]}, {
         NCache[Rational[1, 2] Pi, 1.5707963267948966`], 
         FormBox[
          FractionBox["\[Pi]", "2"], TraditionalForm]}}, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       TagBox[
        FrameBox[
         StyleBox["1", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["2", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["3", Smaller, StripOnInput -> False]], "Placeholder"]}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm], ",", 
               TagBox[#3, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.7951327131445417`*^9, 3.795132736289179*^9}, {
   3.795132776418398*^9, 3.795132795452485*^9}, {3.7951331919616823`*^9, 
   3.795133254982712*^9}, {3.795133374590995*^9, 3.795133409500504*^9}, 
   3.795133557718029*^9, 3.795133749086506*^9, {3.795133813374647*^9, 
   3.7951338463239326`*^9}, {3.795133888683016*^9, 3.795133932699235*^9}, {
   3.7951340201934643`*^9, 3.795134042528927*^9}},
 CellLabel->
  "Out[1918]=",ExpressionUUID->"a7c6f1dd-827e-419e-8d59-169a7f031287"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Fano", " ", "factor"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"ttdag", ",", "t", ",", "dat1", ",", "dat2", ",", "dat3"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "[", 
      RowBox[{"en_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "kt", " ", "kx", " ", 
         SuperscriptBox["ky", "2"]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kt", "2"], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "4"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"kx", " ", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{" ", "en"}]], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
         RowBox[{"ky", "\[Rule]", " ", 
          RowBox[{
           SqrtBox["en"], " ", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
         RowBox[{"kt", "\[Rule]", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"V", "-", "en"}], ")"}], "-", 
            RowBox[{"en", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], "//",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"fn", ",", "int", ",", "dat1", ",", "dat2", ",", "dat3"}], "]"}],
     ";", 
    RowBox[{
     RowBox[{"int", "[", 
      RowBox[{"rat_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{"t", "[", 
      RowBox[{
       RowBox[{"rat", " ", 
        RowBox[{"V", "/", 
         SuperscriptBox["L", "2"]}]}], ",", 
       RowBox[{"V", "/", 
        SuperscriptBox["L", "2"]}], ",", "\[Theta]"}], "]"}]}], ";", 
    RowBox[{"L", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"int", "[", 
            RowBox[{"0.1", ",", "1", ",", "\[Theta]"}], "]"}], "]"}], "2"]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.001"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Print", "[", "\"\<********\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"int", "[", 
            RowBox[{"0.5", ",", "50", ",", "\[Theta]"}], "]"}], "]"}], "2"]}],
         "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Print", "[", "\"\<********\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"int", "[", 
            RowBox[{"1", ",", "100", ",", "\[Theta]"}], "]"}], "]"}], "2"]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Print", "[", "\"\<********\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"V", ",", "L"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dat1", ",", "dat2", ",", "dat3"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.79513156253222*^9, 3.7951316152964487`*^9}, {
  3.795131648972913*^9, 3.795131747051647*^9}, {3.795131781970655*^9, 
  3.7951317822662783`*^9}, {3.7951328069593*^9, 3.79513281387438*^9}, {
  3.7951328524894047`*^9, 3.795132874260009*^9}},
 CellLabel->
  "In[1652]:=",ExpressionUUID->"354a9c5a-6ca0-4c39-9ad7-ca1157260838"],

Cell[BoxData["\<\"********\"\>"], "Print",
 CellChangeTimes->{{3.7951317269499073`*^9, 3.7951317479691477`*^9}, 
   3.795131783253281*^9, 3.7951328153819532`*^9, {3.7951328584003277`*^9, 
   3.795132878842063*^9}},
 CellLabel->
  "During evaluation of \
In[1652]:=",ExpressionUUID->"ce06470c-0a60-499b-9244-c8e2550ee212"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 1656, 650, 23302736838352560751, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.795132815383699*^9, {3.7951328584016542`*^9, 3.795132878843844*^9}},
 CellLabel->
  "During evaluation of \
In[1652]:=",ExpressionUUID->"59b4248b-9bc1-4b0a-b3dc-3830e22d7f3a"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{\\\"0.`\\\", \\\" \\\", \
\\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 1656, 651, 
   23302736838352560751, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.795132815383699*^9, {3.7951328584016542`*^9, 3.795132878849985*^9}},
 CellLabel->
  "During evaluation of \
In[1652]:=",ExpressionUUID->"e6849378-a822-45a0-8848-9b3c9e3d7541"],

Cell[CellGroupData[{

Cell[BoxData["\<\"********\"\>"], "Print",
 CellChangeTimes->{{3.7951317269499073`*^9, 3.7951317479691477`*^9}, 
   3.795131783253281*^9, 3.7951328153819532`*^9, {3.7951328584003277`*^9, 
   3.795132878855714*^9}},
 CellLabel->
  "During evaluation of \
In[1652]:=",ExpressionUUID->"b256dae0-9619-4878-a93c-116068499f56"],

Cell[BoxData["\<\"********\"\>"], "Print",
 CellChangeTimes->{{3.7951317269499073`*^9, 3.7951317479691477`*^9}, 
   3.795131783253281*^9, 3.7951328153819532`*^9, {3.7951328584003277`*^9, 
   3.79513287888535*^9}},
 CellLabel->
  "During evaluation of \
In[1652]:=",ExpressionUUID->"b407d5a5-dd17-49d6-89f6-bb0400cc8eeb"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw02Hc8le//B3BpKdoULU0NaUlLuYrS0LTaksxoEaEiofKRkShNIyqSFIXC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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw11nk0ldv/B3AJJUNokqEQzaXcosn5KCoZG4xJ5kKUJHRDpluGUobQIBKZ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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwt0nc81f0bx3Ei7YzuQsgId6KMROh8LrOUmRtRyYmWjEono7IiKS0RRWQV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         "]]}}, {{
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}}, {{
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {}, {}, {}, {}, {}, {}, {}}, {{
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-1.5707963267948966`, 1.5702036732051035`}, {
       0, 0.9999997900741736}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       TagBox[
        FrameBox[
         StyleBox["1", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["2", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["3", Smaller, StripOnInput -> False]], "Placeholder"]}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm], ",", 
               TagBox[#3, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7951316261933403`*^9, 3.795131690725648*^9, {3.795131727109419*^9, 
   3.795131748159842*^9}, 3.795131783471426*^9, 3.795132815568927*^9, {
   3.7951328585682383`*^9, 3.7951328790296783`*^9}},
 CellLabel->
  "Out[1659]=",ExpressionUUID->"7bfe01fe-1a63-426d-850d-fa59cd4ad69a"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"d51a3f4f-64c1-46ae-8236-b2e6153c76eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["en > V", "Subsection",
 CellChangeTimes->{{3.795071580007374*^9, 3.795071620561736*^9}, 
   3.7955904971623983`*^9},ExpressionUUID->"28056e09-1761-410c-bc18-\
464416b4b50e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"exp", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["kx", "2"]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kx", "\[Rule]", 
        RowBox[{"en", " ", 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{"en", " ", 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"en", "-", "V", "-", 
          RowBox[{"en", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}]]}]}], "}"}]}], "//",
     "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"exp1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"exp", "/.", 
     RowBox[{"en", "\[Rule]", "V"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"V", ",", "\[Phi]"}], "}"}], "\[Element]", " ", "Reals"}], " ",
      "&&", " ", 
     RowBox[{"V", ">", "0"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     SqrtBox["V"], " ", 
     RowBox[{"Cos", "[", "\[Phi]", "]"}]}], 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"V", " ", 
         SuperscriptBox[
          RowBox[{"Cot", "[", "\[Phi]", "]"}], "2"]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]}]], 
   FractionBox[
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
     SqrtBox["V"], " ", 
     RowBox[{"Cos", "[", "\[Phi]", "]"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"V", " ", 
         SuperscriptBox[
          RowBox[{"Cot", "[", "\[Phi]", "]"}], "2"]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]}]]}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.800986800679298*^9, 3.800986918336363*^9}, {
  3.800987007513294*^9, 3.8009870120523567`*^9}, {3.800987058197826*^9, 
  3.800987069308123*^9}, {3.800987105412877*^9, 3.8009871286064987`*^9}, {
  3.8009871616568336`*^9, 3.800987171741457*^9}, {3.8009872464699183`*^9, 
  3.800987383233886*^9}, {3.800987420014488*^9, 3.800987464818307*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"740e84fc-0c4f-416f-8632-53a27b050cbb"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SqrtBox["V"], " ", 
   RowBox[{"Cos", "[", "\[Phi]", "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox["V"], " ", 
    RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"V", " ", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "\[Phi]", "]"}], "2"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.8009874655714483`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"e0dbe992-1eb1-45ec-bc93-3124d5fe6df5"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}], "2"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "V", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "V"}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "\[Phi]", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "\[Phi]", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}], "2"]}], 
    RowBox[{"16", " ", "V"}]]}]]], "Output",
 CellChangeTimes->{3.8009874671709223`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"f278c5af-5112-4321-aa66-90194d512f32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SqrtBox["V"], " ", 
   RowBox[{"Cos", "[", "\[Phi]", "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox["V"], " ", 
    RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"V", " ", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "\[Phi]", "]"}], "2"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}]}]}]]], "Input",
 CellChangeTimes->{3.800987452816483*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"22415aad-58a0-4324-98f2-1e27c0479e2f"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"L", " ", 
      SqrtBox["V"], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}], "2"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "V", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "V"}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", "\[Phi]", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "\[Phi]", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"L", " ", 
        SqrtBox["V"], " ", 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "]"}], "2"]}], 
    RowBox[{"16", " ", "V"}]]}]]], "Output",
 CellChangeTimes->{{3.8009874221011763`*^9, 3.800987439696204*^9}},
 CellLabel->"Out[28]=",ExpressionUUID->"83295806-71ca-4a96-b4fc-9e814c2a6741"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"v", ",", "vs", ",", "s", ",", "sp", ",", "kl", ",", "kt"}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"en", " ", ">", " ", 
      RowBox[{"V", " ", 
       RowBox[{"case", ":", "\[IndentingNewLine]", " ", 
        RowBox[{"valence", " ", "band", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "kx"}], ",", "ky"}], "}"}]}], ":", " ", "en"}]}]}], 
     "=", " ", 
     RowBox[{
      RowBox[{"eV", "-", 
       SuperscriptBox["kx", "2"], "-", 
       SuperscriptBox["ky", "2"]}], " ", "=", 
      RowBox[{
       RowBox[{">", " ", 
        SuperscriptBox["kx", "2"]}], " ", "=", " ", 
       RowBox[{"eV", "-", "en", "-", 
        SuperscriptBox["ky", "2"]}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"conduction", " ", "band", " ", 
       RowBox[{"{", 
        RowBox[{"ky", ",", "kx"}], "}"}]}], ":", "  ", "en"}], " ", "=", " ", 
     
     RowBox[{
      RowBox[{"eV", "+", 
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], " ", "=", 
      RowBox[{
       RowBox[{">", " ", 
        SuperscriptBox["kx", "2"]}], " ", "=", " ", 
       RowBox[{"en", "-", "eV", "-", 
        SuperscriptBox["ky", "2"]}]}]}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "sol", ",", "eq1", ",", "eq2", ",", "eq3", ",", "eq4", ",", "r", ",", "t", 
    ",", "rp", ",", "tp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ky", ",", "kx"}], "}"}], "+", 
       RowBox[{"r", 
        RowBox[{"{", 
         RowBox[{"ky", ",", 
          RowBox[{"-", "kx"}]}], "}"}]}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"{", 
         RowBox[{"ky", ",", "kt"}], "}"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"{", 
         RowBox[{"ky", ",", 
          RowBox[{"-", "kt"}]}], "}"}]}]}], 
      SqrtBox["vs"]]}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", 
        RowBox[{"{", 
         RowBox[{"ky", ",", "kt"}], "}"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"b", 
        RowBox[{"{", 
         RowBox[{"ky", ",", 
          RowBox[{"-", "kt"}]}], "}"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{"t", 
       RowBox[{"{", 
        RowBox[{"ky", ",", "kx"}], "}"}], " "}], 
      SqrtBox["v"]]}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eq1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"eq2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&&", " ", 
      RowBox[{
       RowBox[{"eq1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"eq2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "t", ",", "a", ",", "b"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rp", "=", 
  RowBox[{
   RowBox[{"r", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"tp", "=", 
  RowBox[{
   RowBox[{"t", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{
  3.7948736389775743`*^9, {3.794873700028576*^9, 3.7948737427400827`*^9}, {
   3.794873811229525*^9, 3.794873916735141*^9}, {3.794873949662161*^9, 
   3.794873959526718*^9}, {3.7948742351731987`*^9, 3.794874256906666*^9}, {
   3.7948743302518578`*^9, 3.794874370799529*^9}, {3.794874425186573*^9, 
   3.794874431362528*^9}, {3.794874468361292*^9, 3.794874484763464*^9}, {
   3.794874535020276*^9, 3.794874543183934*^9}, {3.794874578389473*^9, 
   3.794874679493874*^9}, {3.7948749373498793`*^9, 3.794875307964197*^9}, {
   3.794875346402451*^9, 3.794875466881118*^9}, {3.794875570071673*^9, 
   3.794875650920072*^9}, {3.7948757982730217`*^9, 3.794875822154565*^9}, {
   3.794875864243043*^9, 3.794875886975236*^9}, {3.7948759300300417`*^9, 
   3.794876215838956*^9}, {3.7948762560045958`*^9, 3.794876688083026*^9}, {
   3.794877002974566*^9, 3.7948771086572447`*^9}, {3.794877613561426*^9, 
   3.79487762528379*^9}, {3.7948880328721523`*^9, 3.794888035463818*^9}, {
   3.794888115296043*^9, 3.794888129097959*^9}, {3.794891771478714*^9, 
   3.794891906442079*^9}, 3.7948997902707863`*^9, {3.794900131396542*^9, 
   3.794900160553969*^9}, {3.794900201649561*^9, 3.794900298033409*^9}, 
   3.79490079886339*^9, 3.7949943647960863`*^9, {3.795001003553406*^9, 
   3.795001059786661*^9}, {3.7950011091786823`*^9, 3.7950011154617767`*^9}, {
   3.7950061028390083`*^9, 3.795006247014964*^9}, {3.795006277896366*^9, 
   3.795006307292655*^9}, 3.795007183408887*^9, {3.79507110255811*^9, 
   3.7950711784692497`*^9}, {3.795071225109119*^9, 3.7950712529109783`*^9}, {
   3.795071696002789*^9, 3.795071706556506*^9}, {3.7950718470050383`*^9, 
   3.795071859496698*^9}, {3.795129226973805*^9, 3.7951292331272593`*^9}, {
   3.795590436623043*^9, 3.795590439570814*^9}, 
   3.7955904995228043`*^9},ExpressionUUID->"a837889c-acb3-4fff-96e5-\
04e0f603e5e6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["kt", "2"]}], "+", 
     SuperscriptBox["kx", "2"]}], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      SuperscriptBox["kx", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.795071256877323*^9, 3.795071863572001*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"0e60b192-fe8c-4ad1-9edc-84deb4b66e62"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      SuperscriptBox["kx", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.795071256877323*^9, 3.795071863616001*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"461bb3e0-46d5-414e-bc42-a32a58831f17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"en", " ", ">", " ", 
    RowBox[{"V", " ", "case"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"tamp", ",", "ramp"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ramp", "[", 
      RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["kt", "2"]}], "+", 
           SuperscriptBox["kx", "2"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"L", "\[Rule]", "1"}], ",", 
         RowBox[{"kx", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"ky", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"kt", "\[Rule]", 
          RowBox[{
           SqrtBox["V"], 
           SqrtBox[
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"rat", "-", "1"}], "]"}], "-", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}]]}]}]}], "}"}]}], 
      "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tamp", "[", 
      RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"L", "\[Rule]", "1"}], ",", 
         RowBox[{"kx", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"ky", "\[Rule]", 
          RowBox[{
           SqrtBox[
            RowBox[{"rat", " ", "V"}]], " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"kt", "\[Rule]", 
          RowBox[{
           SqrtBox["V"], 
           SqrtBox[
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"rat", "-", "1"}], "]"}], "-", 
             RowBox[{"rat", " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]}]}]]}]}]}], "}"}]}], 
      "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.1", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.1", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.5", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.5", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.8", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.8", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "2.5", ",", "1"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "2.5", ",", "1"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.1", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.5", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.8", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "2.5", ",", "1"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage21.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage21.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.1", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.1", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.5", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.5", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.8", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.8", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "2.5", ",", "25"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "2.5", ",", "25"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.1", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.5", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.8", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "2.5", ",", "25"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 25.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage22.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage22.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.1", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.1", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.5", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.5", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "1.8", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "1.8", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"Chop", "[", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"tamp", "[", 
              RowBox[{"\[Phi]", ",", "2.5", ",", "50"}], "]"}], "]"}], "2"], 
           "]"}], "+", 
          RowBox[{"0", 
           RowBox[{"Chop", "[", 
            SuperscriptBox[
             RowBox[{"Abs", "[", 
              RowBox[{"ramp", "[", 
               RowBox[{"\[Phi]", ",", "2.5", ",", "50"}], "]"}], "]"}], "2"], 
            "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.1", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.5", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "1.8", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabr4", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"Chop", "[", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp", "[", 
             RowBox[{"\[Phi]", ",", "2.5", ",", "50"}], "]"}], "]"}], "2"], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "6"}]]}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], 
      ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"g1", "=", 
    RowBox[{"ListPolarPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarAxes", "\[Rule]", "True"}], ",", 
      RowBox[{"PolarTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{
              RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "3"}]}], ",", 
             RowBox[{
              RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "-", 
              RowBox[{"\[Pi]", "/", "6"}]}], ",", 
             RowBox[{
              RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "6"}], ",", 
             RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "/", "2"}], ",", 
             RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"(*", "****)"}], 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
      RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
         
         RowBox[{"Directive", "[", 
          RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "1.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 50.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Timage23.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Rimage23.jpg\>\"", ",", "gr1"}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.794990929199575*^9, 3.7949909424739933`*^9}, {
   3.794990982384509*^9, 3.794991139278957*^9}, {3.794991392642338*^9, 
   3.7949913943561497`*^9}, {3.7949922294622297`*^9, 3.794992249971951*^9}, {
   3.794992282826687*^9, 3.794992391006621*^9}, {3.7949924492682877`*^9, 
   3.7949924672111*^9}, {3.7949924978243647`*^9, 3.794992500850062*^9}, {
   3.794993880477866*^9, 3.79499397166394*^9}, {3.794994402845872*^9, 
   3.794994443474368*^9}, {3.794994984219358*^9, 3.794995037644314*^9}, {
   3.794995070300199*^9, 3.794995070987803*^9}, {3.794995807842152*^9, 
   3.794995849555065*^9}, {3.794995920866191*^9, 3.794995931053337*^9}, {
   3.794996084145514*^9, 3.79499611321902*^9}, {3.794999323766118*^9, 
   3.794999346310319*^9}, {3.7949994111393023`*^9, 3.794999469871377*^9}, {
   3.794999514754767*^9, 3.794999617813569*^9}, 3.795001355813862*^9, 
   3.7950064039278173`*^9, 3.795006445164651*^9, 3.795006564374877*^9, 
   3.795006668941828*^9, {3.795006802630272*^9, 3.795006819597292*^9}, {
   3.79500685762649*^9, 3.795006872777776*^9}, {3.795006998952065*^9, 
   3.795007031628867*^9}, 3.795007143557459*^9, {3.795007240855526*^9, 
   3.795007272736888*^9}, {3.795007673579121*^9, 3.7950076742154713`*^9}, {
   3.795007725242867*^9, 3.7950078480671873`*^9}, {3.795007897269895*^9, 
   3.795007924527179*^9}, {3.795008024692006*^9, 3.795008059630018*^9}, {
   3.7950713875592937`*^9, 3.795071422095038*^9}, {3.7950720250759287`*^9, 
   3.795072152172063*^9}, {3.7950722645153923`*^9, 3.7950723002987757`*^9}, {
   3.795131996770587*^9, 3.795132029539447*^9}, {3.795132090488356*^9, 
   3.795132130368556*^9}, {3.795132216978801*^9, 3.795132218610136*^9}, {
   3.7951322820635023`*^9, 3.7951322851695213`*^9}, {3.795317957360497*^9, 
   3.795318136882277*^9}, {3.795318172070588*^9, 3.795318190684725*^9}, {
   3.795318267199016*^9, 3.795318281973278*^9}, {3.7954161308881807`*^9, 
   3.795416131234931*^9}, {3.795424921888706*^9, 3.7954249452899218`*^9}, {
   3.800984519272874*^9, 3.8009845652788877`*^9}, {3.8009849218740873`*^9, 
   3.800985056149068*^9}, {3.80098515798734*^9, 3.80098531617596*^9}, {
   3.800985354218194*^9, 3.800985389234385*^9}, {3.800985996008985*^9, 
   3.8009860099105387`*^9}, {3.800986322408494*^9, 3.8009863240301867`*^9}},
 CellLabel->
  "In[1084]:=",ExpressionUUID->"8d7f1afb-e74f-40d6-9f6f-119bbd1eb2d9"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwkmHc81e///yUqCpWIlJ2MJFEkeookGdmjkhHRQhGVkT0qDTuRnZW953XO
cZzF4dg7e4+T3lFR/M739zn/nNvjdl3P63q9Xtd1PZ+P+yVi72rsyMzExNTP
xsT0f/8lMuWpvwjFFw39thk/OnpQKB6R9TwYSH0tApt/6Sh0Sy1U0CMGCm0U
Sun/0dF4i+OJxdTPYLw3JH5mio6emnQp7LbJBGsJzQcr7XS0WRiceOFOLjwY
OfdUoIKOPvBNERJvFIKsv+PTsBg6khl38LVNKwGdtRonIxc6Yq6g85fsKwcp
+l3VZA06iphJ/yrhUgnrr+RDow/QEZ9X3asqfDWIS/4SshtaQQ37J6Xvc9WB
a+cQ5VzqCnrhZXzWXL8Bfh9PJVy1XUHUn+32Wb4Idop/cWwTWEFZ2z8OUdox
cFzp5OcdXcvoItPlY+cHsJAtr5YoGLqMOCDaoWMQB3AMr33n7DJKfeRpZtDd
BB2nji5wji+hXX9wok+b8ZB50qrQLmIJ3SJl5x0qbIY5RQfNpFNL6O1G3hXW
twSo05z23KYtoksJd15JOhIhXqu1r8VtERl9mv7hrECCr6wSNpc4F1F/5lx4
zW8SbM/ihFJyF9D1g9VePBVkyN+5/5+o5gIKnFtPfOlMAb4Um3tsQ/PoW5Ai
KzN3CzQs1ctEPp5Hpi/PBxSUt0BG/lXZ2V3z6LxKP9dH/VZYtdhhYPBpDjkp
L94ZH2mFr0dw6r9OzSGDtF23cxypYFAr53IIN4tSvqpEHJqmwgc3lW89prNo
aFMg0fBWG+gmtZ24NzuDIpuOrb5qaQPxlMt3/zyfQaJCIiJrZ9qhOo5fsWjf
DJqoXnvRFNUOF3GeecUp0yjhq/3nk4vt8GVjr6OIwjS62hcbrihIgykrXIQo
cQq9Oa3gYqVJA92qtq7Om1Mo/5pMgqgjDfRyitIMVieRN4fX7sIgGtj8zGYt
DptEP0dfbPGn0EAkUa+fU2gSUePnhoOraPDEFt/qXzWBXORGt/ZRaTCkfjuU
32gCfXspn0IbpcHHNzJFC4vjSNmtqn6ZTgMXS2MulvBx1PA0nDnwHw0kLbsz
3Y+PI320UZq3pwNGsJF1WvgxxDUJscEHOoDp3znWEIcxpKzmOS3D1wHh5Sol
KrvGkNVVVu36ox1QkO62Z8R4FGn9PlJjKNQBa3iRb/pJ39CRh8KRO4U7YIUV
f61zbgSlcfy7vSLYAT3YwrtPlEeQrykTlzQjPkzP/7ji62H0s123oe1wB+ib
lfkJjA+hCEwC4T/G/If4ImKkVYYQz61zuCL2DrCUPj9gFzeIQglCAXzMjPGf
WZ/BrA0gCwo7p+ZvGtgdjDuiaTmAVO8aF2ou02ChyAE709CP/AzSJ2XHaVCU
oin1RaIfqYdccznUTYNHnVua3lF9KEtM3JCNQAPyHUsOmx196IPZj/ZjjO8b
eZAlU8e9F+GsT/raZ9OgoH2X3Zm5HjR8VkhxNo4GvsPhy1y2Pegji4VoXQgN
NpelLPoHu1GjvEbLkjsNiH6zogGW3cjBdAfHKzvG+MtZt7f7u9DxaMvjqQY0
yL78qET7Vhdavl5deeECDfLf3b9vMNGJeMRMqc4naCCVQHi7+0Ensr6gPnWG
mwasH+1n7q53oJW7R3t0/rXDotzr3bbBHUggm/A+qqsdJB1K7GYOdaDSvbtI
JrntkC50Xns5m4ZIrFH6qX7tMLP8YN1JjYbsWgRZXpm0Q2CwqmZ0XjtKmNyY
FZFsB+U+qWX20Ta0gHnG9+xvGzT7ul47xteGrPYKj3+itcEoutBSbEZF0fwZ
uE+ZbfB7dGsjP74VeQzHeoc8a4PW93Kv1kZakM+pqf139RjnJ47VwkOyBX0/
sKtXR7gN4l0vPuXyoiDnle8eqj+p0FC7pVhIJiN2s+a1qyQqlI2NSyoLk5GG
0nnC8yQqnPC7KhP7goRyexox/W5USF39aV/QT0Sp684KrlpUYPFg0b6nQkTy
5yJntI5QYV7GOL0khYBanx4Xc6S3QhfGMM51DwENpq5Wd+NbIZr3bvIbj2a0
IXSTJSmxFTZYu9/8mMQjbXeBn1i3VuASVY57bY5HJsHZnPrarbA2kn9Vo7UJ
2RrbeWkKtsKuqsgPO7Sa0Lu8D//lrbVAtv1mfTkGh25nydDDqS1Qas/iqQ04
9DjvZsBEVgvkd30iZGGwaE/DpFu9XwtcRtcP11/Gol9dV5QFLFvAHrWc8mrB
IP1/eLadZ1rAT/ukPN4Ug1LZpLu89rWA2W+DiyJYhE55uF3ynaVAuoJwXsxI
I+o/q4LnbaLACt8jbrTVgC5KinzQTqHAMRbLRF/xBvQzeuzLQR8KqA73cBYa
1CNObyvaCysK7DOlLZ/yrUMsx92zA5UoECwjdHu0qBb53R2IP8lLgZFqa9mU
mRrUejBx/MUaGepC0loNRGrQ2u/0T649ZPhszavfblONVrEilfsqyfCyKegW
c3oVcv5D+GsST4azjugSZbYStfou82k/J4NyC9cAm3wlsg3Pjp69SQaWM4Hv
M30rEPuT0r5zQIbE0+cc/Kjl6LG+scI5MYaOSBv0Fi5HD+/wDs7sJsOpK21M
gZ5lSDw6bEZnmQTy2zF3PdtL0cc32Ju2XSQQZuk5AjKl6BLtl4RMLQmsR/Kz
cRElyMxsVjg/jQQu3gWccwvFyPPrWa7xCBIYqwg2xxkUo9AHjVnUJyTYfGpj
++heEdLOag97fIsEs5OBGrYqhWjquLkO9QoJZE11M/u4CtCi+IbruDwJJi70
4bLm89EAt6xH4TESdFvfTk4m5iEpSSmcIjsJao1HlqNycxGz8mStxy8itI1Q
RW68y0ELXvRyl2kiOMQtGZOeZSOeNKt/ot1EMNPdp17m+AXxMj3u/9BEhBT7
X1qrZlkoZyo8sK6MCCesbCytdDLRoemC06mZRNjzYHADBxmoxsbwgHocEc4b
08/vOp+OSlOn9D6FE2Htv1OZm4pp6A/b812l3kT43XhT00chFQnFa9wKdiVC
c7eqTJPzZyS3X9j5oAMRKp3ecex1TUI7zh9Sv2VFhGoLta7g54moX6tq3e46
EYxFPSemwxKQVH/KJ7ErRIi06TWd+hjHWP+mC2lqRHhmpbNwrigGNZNo44Nn
ifBZZXszhhiFTiX7xtFOESH4padr5cR7pHiuyzZQkggzb06ZZDO9RUH1Lle+
ixJBhrdxp676K8R3sl73iCARopPOPaAEhSL+dikPpiNE+Ad3KhMogciv2BSX
zkuEp8NUMxNJPwTCp5R3HCICz/J3gUnkif7aHOkTOEiEwOXGkzEVLsg9Yk/q
j/1EqA9hHSKN2qCnDUHRIQx9yUhhrJYkivZnNZR0M7R69J3JS7I3IVA3amP0
ABHSXGN1Wm8+hN0mIY+yuYngJPYfI7E+hdrAajYZxvwn3Wqs7m74gH7OEPU+
P2N98rbLLyoEwnATT/XdY0S4mVCWub4YArpus82CjPfrfXBDeDY7AjY8d/2M
OkGEh9gT40lOkSD2/MzFJlkicE2oZHfGvgfVWOaUIkUilL9P0NV+EQV5C/lc
lqpEME0rmna3i4HpAUxY/WUiCK2OvUjVjYPUwbm/w/pE0POnJvKcTwCrhvf2
NRZEIO2/9vCodCIckorONbInAi/NsXZLMAnSRQZQ1iMivLwTsmM332f4av3j
XcVzIjRSdS5i2FPBUi6LKSCUCEsvxT8O7U0DsYanP3fHMJ4nW2uHD1c67NYU
17mWzljfjR9WJJ4MSOcS7dMuYcwv+5ZpTjATXBf+ujFhiRDr8qCLWSYL4DVm
wr2DCKLhFcqXVL7AIl5/NW2CCOtTNsdb9bLh5PYXq1c/iTCcKyFOtc+BM7Hy
tJO7STD/M+mWi08ucOUsbocfIYGBuk7i4Mc8kFyOjfh8igSs5HYTtbp84N+g
MT/SJIFgvXQpbuwroDDZtf8sSRDdQo+PZy+EFUG5kTOuJIjJTs+ZVy4CxY/q
UlKhJPDvZ8v572wxGPd/VO5NJoHi7ump0Y5i+I+D98b5ShIc5lSNMXIrAaHp
PxSjdhKo+9WfsjtQCiU9ORWC8yR4PC+deqKiFC6OXT2dspMMFt6Suo03y4Bp
zuRCpyAZOqI29gFrOUT18GAqVchgct7kEr6kHJgzed/pWpCBdIqf4GxXAcRH
rrffeZAh8+Cpbe1DlZARwkbyjyJD6E75QV9KJTz/RNAWLCHDjYELnRLBVXBl
4v35uzQy/JtK+M/mUjXUChn3mX9n6DGX0SvMNcDwiudW9lOA39e2/Q+hBv4e
dtOWPkOBhbSjH+Pf1cKxt33te0wpEKs6XAK36kBSzOtBmCcFEBtF/qBsPXhf
+R6W8ZECEc8N++SYG+BOxi37Gw0UADsd9tqhBrgr4s6SO04BNsQ+2lnTCGfv
RFx6s6sFmm/r8icnIZBVdytjOtkC7T0PDwtqYGAjV6qK2bgFapS5jt+vZug7
nvfePmuBgJtnJLTksWA/fz4jJaUFXiXTZ7FfsfC7u3RNntgCeypLYv6TxkE1
b+gXdXoLhPnMlS/n4yD3wqd8wuFWOCbxVg4v1wSqbKQvjeqtUF7+7NrryiYg
5+iMi95vBddvj/Ms1PHwO5VNezm6FS4pc5lcpOIhfeir3eHGVpCf0fxiat0M
zv/umyTOtUJSaOad4u/NYHvza4cLNxXCHptlO4URQHXhoVDkRSq8wifOvRch
wmiU/e7le1RYZd7xWwMRQcR1uicklgrrVof+xdiSIOJ9grEBlgptXZ/cP7My
6h5PZ43qMhUu/dST9Cokw3/e2Ior/G3gf2tRUekmBXbeNrGw02qDalni5vre
Foj50cEZ8LgNji++Fm3HtEAiu0bmx+Q2GP9s+Kb/eSu4RfjIfSa3we5f/cYn
lahwE8eyP2CtDQY31honf1NBPS5pSkGkHVR7/wM+1Aa0ovjAbD0Gj3DssJ+M
aAdcF32pxasdJI422BWdpEHJ5FHd9+ntwM0byNLJ8LF8P8tGJ1rbYevjKee7
OzuAtahjq3i9HRRtZwyfP+mA9/HSgf9x0eBx7163w1Md0EH6La4sToPpbZeb
+pad4NXz9q2AMoM/5tODTrR3AqfB0xtRujRo+HVfqvRqF+xpnI5+f5sGs42n
jf/gu0Bx9Wsx22Ma/Mt/Urfncjd8cj/45nsgDU6AAHWxuRtM9lHtlGJocN+4
+FXBtR7g3MlBbs+kQXSaTpBlZw+cPv6lKK+cBofz1DDrt3phd6ODWXUTDVJ2
epR+WOgFfo5E7bkOGrwP0RM8490HimdXbkkxeCjsD/uuMc5+IEqFldxbpEFU
U1VUelY/YLGxGXHrNDAfvLv5EgZgoeMmLYmpA0S/9t33HR4AqR2YA85sHaB5
2n7ys88gFC6H+Ezu74BAlxMis0JDkCCnafOHtwP4r/m9sCAMwQ6ijEa0QAfU
3klopLsOg1tk5+xHBv/QX94+WHh0BMr0/hqsMXgp60h4y9vWETAU/lLx5v90
9brOm5ffoLHGLvnKsQ4Qkb/T/vnsKJSty3Ts4e8Aq4+PzepXRmFsZvJh9cEO
eDQpJv/QbAz8eyJmzjP4KEtjenm1fAws+Vz5H28z1sOy7+EMzziwKvubXPpB
A5/Kaxfg2Tj4O3Y5RE7QwAuvYvh9aByq92SVKNFoIMZr+HNRfQKk7y9eEa1j
8EzpSK5o9gR4/MhZPZXB+P5eHDxBnJOgLyBqBeE0WGn1nPrjOQnX+/iOnr1P
g7037Gsfj01CD1V6dfUqDehLLIe7rk0ByN2nWDD2y5b/zssslVPQyBr8+8Pv
diia+nhpXmQabvFYtxumtUPYKL7izttpYFX6cL1Mox3eFvSNGG9OwxynXEjg
cBtY/LcQGO08A9OdwrURLm1QUJ2wut0zAzlR56biGOfARcl3zVVzFna6U/m8
X1DB/PCv/uriWfAtCGTd+7MVaivT7xUcm4N6VdVHQo6tsMi1l1nw1Rx4yufl
xDL8u6bF7o/9a3PAaXhBylC2BbIunevLsZ2HUwHm/84FU0C8fuuMJWUeUioD
TJU7yYw6/pi78MwCrIr82qFzmAz9s+Ybrh8XIPwky18HExIstadV2G0tgCR6
0PuOUV8HR5wStOwWQfzZ3NmeYgJYMjnVDWMXIaOlW0Wnsxm86pm0ZoWWwFLy
+9ieRTycn3OvFvdeAnuXM8Yqm01wmWVD17RrCVyTM6Q5djbBbr2rWmcll+Fk
vlp+LTMOvAzbboY9X4aCoY2BkA0M2N+dFtpLXIbrEdVHvHoQaNzbcgzcvwLl
Cj1NDtkN8PJWVXmx2QocC1w+HfugDsgBaeU341bApPR29ZBoDaQX3knV7VwB
kdvro8faKmH3OWqZLhsdtH8NhBi7lEN37q0E6Qt0eCMv0u/PUgplLOXUWic6
CGHYz/uJFUHZhSf7ut7SocpsKMb+VB5csVpNMyimg+3W7jXOk1mwbf+siaOV
DsaK5Ta/BVPh+IOIvrVxOkyJUf7pcMdBIhNv+eoqHfRb8SOptWGwyf2WtrpJ
h5SHQUGd3DdA8unK/aVtRjzv/+7r3pj9775OJu3cUfbnwXBjeFxnz186mvly
XqP0cQxUhd+rkPhOR007Dts3J3yGKXPnjPvDdBTwUzbjgVkmHO1M8VvG0JG2
OXtZnGEujLY+fNCZTEc9z25hM1QKQfHY/ICWOx19bxDgvRBeAn8e//vrc4mO
+Il2VyNny+Dw/ftSFXvoqG2n2Or0+Ur4xqEhrEBeQYG1tyc3fauhNPnzVY2g
FfTFnv9wWmkt9LfEDysoraBrX+258L318K71Ncft6WW0pSM46DbfCFnPiGIC
b5eRyJePPXMeGJj2e5JMkl9GLxqdXsc/wMIo0dGQQFtCS838v70scRA/czHq
6YMlRLT9e0/vQhM8NEu9p8y8hMr/Wyud5sYD0xHhFrfYRYTrrM4SncBD5s/V
yZfHF9GQ3u+n9KxmKByfdG8uXUB3O3yYtGwIkHi3XSlFbQFJyNK3T3AS4bSe
gqMzYR75xu9XyCklQl+DhtJz/XkkPTnwbFSP4Zdu34iU6JpDX0u/znwfJoHb
Me9ErMUcOiV2Z3j3HTL4aEpkxQ/NoiuUNH6LUTJwP2rsXb09i1Si7PoOG1Pg
65QjP8/EDNo1cm4uvI4CHacVdmo4zqDd1Q/HlwVagPzfS2r53DR68SrV4K07
g5cV9lpkPZxG/DkSq+W4FvCMypLTXp1CHYLi+4rYWoGcLvqV7DmF9DfXG1qu
tsLylukOy3+T6F6xqtNN/1ag/Jt34A+ZRAUvQoWKilvBIXCfgjznJHppF6vE
N9gK62Eth1HCBMp/RiHN/m2FjEqLC6PiE2h/iYmRCz8VBOo03PJKx9F+iYBb
m3JUIKUw3zmnMY6IWR/PjahT4aDvQUps1xg6YO2Zb6tHBScO4bj+u2NoUEu8
nWZMhes+sZp8v0fRuHNzu6cpFTp+8mE9JUaRy6PF9o9GVPi3Z5nvm+U3JJOS
TfK7RoVk043Mm+9G0MLwhyfOQIXz40obv8nDyP0c19n401SQ2DJSqd8zjAQG
pAR0BKkQYeNhl6M7hEQHzag1exjxz/e/b4gaREtcEe9Ev7dC4oNXhn9GBhBB
/rBmbXcrxHxo7jeXHUCGn9oeVFS2Qum5OO12/34kKTyidCWuFZqOSn6z6u9D
M9Jcr5LcW8Fj5PHZJYU+RGhj3TVj0Aqm+C7XF9G9aJ8ju6CBJCPfDrM6/Vrv
QWHlcqJb2y2g1ODTa3q7B8k/fm54rLcFzum6BgaRu5Efd8s0La8FdjzKvemu
3I2EPt6VU/Vrga5Iy1Tu/C7EX0lJ8jdsgQ7+7T/GIl3oqAWho0GkBRpa6hKE
PnWigSPJ1Qd+UODe7H49J75O1JpyLCYBS4Gz9uYfD3/sQDmK7w48ek+BZx+Z
aMeOdSCnAtsbObcpoJw6KeCUSUNtwyHH7U9SQNP1Y+zYKRr6FuJBKv5Dhhd9
t9NXnrWjhNBy7VwCGcifvXtPJ7ah2qg/d22iyaAixC1lj6WiJV5UPW1DBsrE
Z2XrlVa01WVboH+SDG2CeT/+Creii0+/pmX/JkGRW0XGUasWtGdkfom5mcEr
XpysCXEUdF/MauXRBxLYrZOv6g6Q0RkTiSPr1iSwadsrzi1CRncHulhzpEnA
u4rva31EQr5Wxzze/WLwnfU+ZXNERFfOm9lW4YnQcPNsaSQPEXFXA5t0FBGO
BuCMjN0ISITqsvndhghRjsb4oPZmNHdDVICHwefHilNvMSs0o5nA4oLPfwkw
1152qCgRj/q5X9jHthBArUz/3YNdeDQo7XqT6RMBboyU8R3xbEKXFSTPztwn
wF+P8S/J8zik8jyeU/8CAXIvKg4M2OJQaJDFe5V9jPr2PeNX6RAWBdsm/lc2
0gyTEx9WOW5g0QJL457GomYoGVS7RRvCoMekCDXrwGb44rroNmaLQcJrfBmx
Zs1QujuE51onQg6XPf+7L9UMYq5zV/fONyL7PUtxY//wIFVrld/N2oggbV/u
n0480GUrUr0kG1B9o+e/6hw8/NuXUkcwrEelVEtxkZd4QJ6vq2L96pBce6WL
ojkeyidintSU1KJrlU9//JTFg/5xmdndCzVoRlvurcMuPFwYyjhueaIGvTTv
WAoebYJNwXL9wHvViM69N8KipgmqXw+G2RRXodCDr4tHopsgAIe2yJuVaN11
fxifaxPkLEf1J+lWIuNQIzY23SYI4XE6XZ5Sge7b1XIVn2gCqn8s1/KvclR8
hNWIk7UJxDoknY6bliNf0UIH8Ukc/OQyZVMtL0N59leaf2BxUODyO30/XxlS
5sjqfJ6GA04+1Yqgl6WooGOjqyYAB9o8iu88F0rQsaOkP6X2OFhcT9dusSxB
zQtVNo6XcXAkh1rpQClGJSW2nB0SOOh55+QmAcVotGjp7xobDm51ynrPPypC
Baz5B7uXsXB3r/ipe3cKkSrlleSDTixI/M2/GH+7ABF0A9jrqrCQZbpyXt3m
K7oXN/ysKRkLTDKHF+Qd89Ee/SCp4GAssG3d1r3gloc2aaLkv4x6xVyvHXDS
Pxd1fdH7e9IUCzYBHK29MTno3p8g20NqWHCJvea3rzAbCXCpRpZKYOEXU9uP
1JYvyPI56dDuA1gI+5UR6LychXjqIOTAXwyYn7zurcydhSIPG93rmMXAANcZ
nlnVTDR0mlPnSjeG4YMk7uvez0Ch3Ll5rlgMiKppPVT7lI6yNU9w6xdh4J11
93Bsexp6Z86++1syhjG+k+ap3WnIIGmFXTQSA0ECJ6bHLqWiCRPhTD5fRn9P
z2cHtj+jzpETVthHGDA91PqN2T8ZBVjplwrYMPTj59EGu5IQ8eAhlRNGGJjh
5XQs/JCINgQLfSc1MRD1IeDaiMhHpBvozGGohIH+GS+T+Mp4FHl6v+9DGQw8
isQnfLwehw4rGTooC2PAoEVSNn0pBrlbsNmU8WDgk+U1TrfIaGRgnsExshcD
4cdHeZrko1CwqiVPBTMG6gX3Lt4ceI8Kw/5T9/yJwDFhYPbX7nfI5ap9w8gU
gj69/LcU+zdIdOoJe2ovAsm/ZmoVuAgU7SH1uZ6M4Hd2/7uLJ8IQx55nG2cY
xypvu0pu5V0wSq+JKWAuR+C872213t8AVCR0xVgmH0HnVsZ5Yp8fkrwm8f5r
BgJyZwbPi/rnqDxoWCA0GcEp3eIMYpYHerDDoKoqAcEY78CxyOOuaCqrWf5S
LIIPFxrKjrI6oqa1g86i0Qisaf1ZwzQzxGmWevlmFIJ9auacDpX8yPmzP1pk
6PvsPR8JH43hoqDHt64YBPO3WM3F7t2B92tT5dyM8aeuF9YPhT8CgYnBO/lJ
CISG3+xa6XWHAbsZfsayQ5phY9DG0jOgi+7knsxFMEz4Heyz2w82cx4nBJUi
yPYqEiyKDgCxveFMvvWM9xHDv2mWCIbFL88L24kIZjExG14NoaCXzHPQpxsB
m2xEjpplBFyZ884OnEBgmE7Av/31Gq7SSOuTqwiOlsaFTn16C1HqQzqGOzDw
nsaaNZz+HjwvJL69xY4BafmfZviND5B2/oXg4UOM/XF+vnPWLBo6jTxN/AUx
gF25ZxZaHgOP9JzeJEhhwLKLf2KUNw4emtSctD2LAYvnZhZnfeNB6LNAUt8l
DAxGbXmTZhNAZEjqyrYBBhKyfDiHzRPhMi9XYt8tDCwErXWVUT7BvS4RdrsH
jP39FZMdo5kMhgee7016gQHmQr7XeOxnCJh4zhPxCgO/u0JvNIumAtdl6zTJ
T4z4f9Yd8bOpoN1dIOX9FQNCx6aj/YrSoJKlQSqgEQN+XxIg5UU6nLjFdexC
B8OvzkueEtbJgPvmyC93itGfetJPUiATkFMvqfU3Bpz+/RMY+54Jiemf3LM4
GPngF6K4UrLg9NO+nwpiWKhXipbdkfMFviztRc/OY4FvYI3WGJEN3uOp6h6G
WOinGSt2u+ZAutPOSQlnLDjOY7oe3ciF151VbB/8sdDu/0O+RicPfn+wPlD2
EQuYdfOJKbV8YBXNNIgswwIu3iVaWOkrfL5wmkO4DQtXC434k88WAJ+T29sH
81jovPDg2ZvzhXCCxXaPGysOVr46fRfRLAJDqlKmrCgOIrrzd+pIFcMFKrtv
JuDA+3HQNbbyYjAqMPjcbY2D9SuaTsuXSuCAogFzow8O3jmv5RzoKoGA6uD3
tkk4GBI6xh/tVArpauMC9fU4WNsiBLzbLoUjvXRb2ggOXt0vdj/+qQzOD83u
TN7GgaF/iJ6HSjn4uSS/FRFtAqVtBbWkkXKYyjJ1sdZqgphII8PG4Ao4/9Vj
9fq9Jqhzinb7K1cJ9F38Wr8jm8BDysz1+WglzPO9fGJW1gT5WzJ7raKrwH1M
/9bdgSbwEghaR7rVcLmzok6KCQ/G39S+de2pgcn4u8c+n8CDyoubbnWUGuix
svyGvY6HkEfx9p8/1IKf8F3J6GeM/k47nmdZ18GzysoVrnQ8iAWFvtk4VQ8+
lqvzZ1vx0L/p8IHE2gCu1hdimH8x4mMDky9MNEDx2Ka4u2gz7NiXvOKPb4Tr
FvZvgg2aIRJ/7TvhKwLhvq8uCt7NQHs0lvpZHwMVFdJCPjnNMHU615qdhAE1
lt+JN3qboSuJWoO0GHVH3yWIwkIAD4yYfT8BC88GrvARFQhw2EEh20UXB2dz
78vr3iFA2OWjL5O7cHBK+qGyUTQBqDmnwvxtmsAu54tIVxMB2H9LsyrSm4Bu
te1A+cnwM2SBue5APIQPa67LSRDh/ud6kv+RZri9KqL214IIAny3580qm+GZ
Rvm+E6+IMPv93Fl3cwKwsKQmZtcT4f09Lvi9QQC8KXrqQSdC934FYM0kQsRt
U58gURKIzUftrzMiwU17bAfZjARxU9snL7CQwe8wrutCBAmCfO7kZNeR4Sa3
GBe1ngQNHQPSYs8o0GryU8HtOwlOqr2dp51vgdAgRbbD4mS4Ean8uZupFTKl
/rMptSCDgAmvrzG1FUSK51jPvCZD42dlKdcUKjznCK4KbiTDK7vNL9e92qBx
xuVAwioZuk2e6fGbtcOQ8qsAS3EKjI2P9z07SgOlXU5KJeYUcN9ro/PyAw2s
5NQPvQmnQHio8EwpWwc8ivBJ7KihwG/mc/ESIR0w+QI37LxAAX7zWcXlnZ1g
sJzzUOlIC7gT4jz5QzuhQ/OQjohOC0hItI417O2CDG2j1j1eLTBTq1GyFNMF
d3N2JrZltMDhU52kKpFueNq+I9KovQVyxdiiT5d2wwdb1SyXPy0QmGuw6HSl
B05Pda8xibYC95vb24++9YAz4U30OIP/Uqn/nTJ+0QtHeeuDZh+1gsUxjznR
I33gob/r6+z7VlAxdw1cbuiDF1PsTeUlDH4cIhxodOwHznALDSFaK4hqGaum
HBiAFyELVmuLraCqN7A7ETsAoTrJ08ysVFCJv5hV8XQQYgv6HQ4IUIG1q07p
l+wQJEtu/5yVpcKX/3gS7BaGIKxm53VdNQavPanmXssbhmHnItK/q1Qo1S0+
UeQ6AgMOojeQIRUEX71WeqX8DRookjn6DD70enla3Zd1FN7MsB5yMGHwYwst
1Lt3FF4223fU6VPh59Zh0VqzMTi6k3fnPk0q8MpdkZDCjYGjSeAomwIVXvHr
DPqeHgfZ/wxGnI9RYSyIXpOTOg6/dNTnB3dQ4ebdkcD4gxOwuvNX1v6xVjCR
d2Y5GzoByeyWlTVVreC/fp/uvDkBZ69YcIeEt0Lls5Qvh59MwqFTHY9EjFsh
QlFov+jCJBRx7k1WO9QK8IDg7HhnCirqzY9EtLWAVuW1I3UjU4DuK7wq928B
9uMrMb8tp0EGx2/yRLoFUEObLL17GoZyli55tVDgR84s80OjGXDoIV/wvkOB
tUdL00ptM1BsUPD3/A8yRLqfu35YdxbmLNgm3L3IQNTdc4NCnAWvaH7Myg8S
mPx2bdl3eQ5SzMwwng4k+I9p//E4NAfBKZtXRluIwJzC0cyvMg+iolojO6WI
YCx+/ZB22TyYv7Y8RvYmgNPfw3iy9ALcCStMOoZn5COYEbiWugB5vFIdGzua
oY5f3fIR9yJ0+mKXHM/iYS99+Ehv0CK4LFjnu91uAi5z7SXx1UW4+0eYU8WX
kd9v1rb9vrEElJLb2ysfsDBrHz9OxyzBwBmrQUoSBibPOBzKEV0GEeftDDlV
BPsVqLPo5TLsCDR0uH2yAV4+LVHp61uG4brLKz/Y66BCgSz8XnoFQh8JuQ33
V8PJqd2Yd14r0CV3HXcivhJaJp7Kv2xcYeSJdq+tK+WQFDZrt297BVjiH4Zn
zZeAqljFyoIyHeRtLkr/YioCtpWHG90P6LCVqBu1zJ8HSsL31l7H06H4V1XN
ZZEssMRrmg/U0cHULTVI6UgqiEwaXnzXT4fXIR92X9wfB+hl3K6IZToQTugs
FtaEgfWZE6X5G3RoNPJ9SeW+AWJn9TVntumgt+t/93V/z/3vvu4s3/y72GfB
kD07qmi8SUcauNOO464x0MQu5me4TEegtDM+P4rhS/azG+7vpaOPfTYaqgaZ
8EXj3MGKCjriuLi1I18jF17xPvjk+oaOtOusUYdoITyb8PT1vUFHbqs1beFP
S0Btmk1CUpiOXp758oi5tQzyO7QGm0ZWEIebSJUGdyWMF8ZGF0avID0Wy/MD
OtXQbjSON9BYQey04wovXGrh9GlXroMLy2izV/wQk3899LzGrzx4vYxWPmLt
Hvo2QuX3aPtuiWXEdiVl588zGBDXME0m1C+hAZa5N3ZHsWCS/KwB6S8hH31j
ztoNLLzq8I1TG1xEqa9u3muh4oBFTvJtg/0imovoM38a2wQO7Xc/1M0uoIzV
FY8cIzy0at4XK7m3gAJOtCs4MjdDQWRS+KH5eZTdwp5bm90M+SXmnJZ355FJ
wnWj5ksE+PDpiev8+BwKrn9PLKARIMr4jJn8rTk0nSz4LNuUCCdG7/0X1TOL
hMedzehUIpA+ODc+MJhFXSY20RRVEvSLkpS5iTNozTzxUUgaCTi32PsGYQYR
hvM2H/8lgX1X6zpHzTS6mX2Gd1afDMax52ZXz0yj0DdlBhBHhlvP7zIRCqZQ
Bf+dzb4eMiRavCI2SU0h+1GMxX4OCvSsBR0Typ5EdUT52quqFBj6tN9zl8Qk
wh1/8W38/877uViejC8TCMuUeFk1mAKy/MMm/FITyMPmWkZVMqPeCMBEeME4
uv/6+KPSYgp4sc5ycyiOIzmctVNEAwXyDNclGurHkF17i2E8ngJ91amRX7XH
UDaVK0GRQIGwN2UPe3NH0YEjz4SqcBTgcezO3Ev+hphr73A8qaWAVV694r7l
EbSdMJxdUUCBXycbhGZ4RpApVl6lPYkChDuqz9M1hxFhxHknG6P+eXy7Oqzl
OYTIC64n81wp8F0qaphWMIjEju9tXjehQComyU19YQB5Xn1HkDtLARY+MbO3
MgNI88UbgWhuCpgrFd4redyPrt1Mz79JZ9Rj9uBdn+v70GM98n0siQwvbfj1
ruzrQ6u1rg/+pDC+b96lh4m2vUifa/jH2adkyGqxWQ6v6UE+wabvvlwlQ8v7
8dkt3h6Ulpks9+wII18um1yce9aNJhxcLvQskGDbzJYmN9qFhL6FfJ2uIUFt
MEsu0ulCKw+PSLaHkUDkk5lkQHUnksx14KswJQFOTlDKWqYTKcodJFQLk8Cl
PlNUNb0D8VV4PP6zSITnYtNXdh3rQL9cdB7EVBLh22BwcsYnGqq5t3kyy58I
M13NAn+P0VCHmY6b1jUiZB157E7XbkdZ11WvRHITweVnF9u/G23ILtFONnqY
AF+V3titelBRB4faiYdZBOCmkXSSY1tRlfJyq4wLAS4Rvx3srG9BuVt/7afO
EUAkOC/DboGCpttsl75sM/xhW99rQUEK6gtPUQ0iNcOlutvcwxZktNQkyRb+
oRmszH21XeJJ6HTY0B/cjWZIYndjzRsmouPR2Gp18WZ4InB8p+MJIkpRY9nB
sYIHQ0fR3qdeBJQSKVxwphoP+8rbf5e1NqMFgi2+juELB71N2n5JNCOr9bSw
En082EXLZB0JxaNYw4e+R/nxMFCYXb0+34Tabjn6skw3QQvFSd7JuAnhfonW
uZU0wWWXf+JXEQ7VXrhLc/JrgoWclhjP0zjUpdtMoOs2wQf6xYe0LCySmaUI
cx5pAl0Pdz9FISwSCI6aIM7hwEzndlBgEgYFh89+FKnGwb6Q14c+HcOgHOYV
R6FwHHg57zRBlxH6w3VzC2+JA6J56QlHs0ZkN6NRyyONA6N7kuvLDxvQL+XA
uEN/sWBtGlYs8roerXiQLuAZfHQtmGWSXFSH+nmuspxIxwKrXkpeyWAtOnjo
4A7wxMIY9kt+1t5axKogss2hiwXJF8f2eGjUIPZa/jexwlgoTdhtvuRXjXbM
YTd61zFQIlEYO4qpQk3nlZy6qBhYVxo/IbynCv26M1X7OgsDv6Qv4QNMK9HV
rxeKmfwwgJePcx3IqkASAud7z1hg4Iqx6pN/m+WM81wULSqPAQ+JXINm83K0
7u8oTduLAdwAVzVbZRlSDdty92pDwC19IiKTvwzFHw0OoYQiUH1/qM4toBRN
1JoYflRHcEX85a1ryyWIzafs7uRmI2AMW8M5rUvQeaU26Zxqhv4VZvOJVoyu
r7N0zXg2gq32n8127WJ0x2r70edzjXDwCmWAL6QI+SG/GeqvBjj15J/lnYBC
NEH7tcujtgHK5TjkNYML0Hz7ms87vwaQKT3d4xv5FRmMXxsWvNwAUZH6doNJ
+chAd3+68N4GOGSt91qkNA+V+j5Xiu6qB/NJUswxai5yDvP56ZFcD8+8j6ol
Luegi17GonjnelB4ji1z4M5BK387/vmdrYeYSY7Xuhez0ZjPl5qMnfUQ2KqZ
L+jyBZ3IcvQ/3VUHR+6saRWlZ6E19xBPscw6qMPVktuHMlH9S8X6F551cNJJ
qdeEPxOxneN1VbxWBx0Cj07vv5mBWPKn8g2EGO0nb1QNpqYjmRd/3hHXamHj
3Zjlq4U09FAEqSRTayEG/9+uX0ppiCK1r536pRbittkL/oSnIpub9zwsAmpB
uzlPt782Bf2UuGypbF0LVgU37Y3vf0ZPrTmLXFRqQfFBQjefcDI6c0Gv4jdf
LbB32/tMDX1CCg0firt/18Az2wS8a3IimpNw+840WANsBjlxng4f0en3pu3e
9TVwmVhytfJ0AhrRsizTTK2B7CDWN8s74lFBzU4ui5AaKLy169ZwXywyL2Wx
L39QA8l2DsuapTGI367//A2TGriyozB55n00er1+74y2ag38XD4zGeYeheyv
fFl/LlEDh10U1ZasPqDBbZZLqwdqIGzgtviA5ns0sb57OH+rGuJE9/+Ssn+L
1FaL03OWqqEi0XpHm8YbZGC/4j8zVA2PjR75nJJ6hXK9tt0dWqvhCa7m9/Ch
cOTd0f5KpLEalj42OT5kDUWXzuvOHC2pBpw4Yc1tIwjty8itMcuqhlKv5h3+
/wWgkYayay2J1bBTYmTIZuwlumvE9MPnQzX4VwcdPT3mjQpSpQXuRzB0KdPh
tGkvNMbMrBUVyIi/nvN+iu6O8kdKd6z5VEPNj9IjN/+6opXj8+sfnlVD7vax
s7ZCzsgmdGnE+Wk16OQ+PauhbYv8tSqDnrtXw8/HTzT7pwzR5BYTuelJNYQM
wYEL89xoSM04XZvR7l955dZ4mx64Mm8dZmXE31RIkLm1/zZMKYhf+evF6B8j
8zB/9C5s/cu+JcuYfzsAI91c5wJzB0RSEgKqYShOJ3fPdXcYryc4XAyvBmbV
/xq5L3tBDtaUT+h9NVRqVWbS1LzhyfC80oWP1dDgzmrDofYSojpHTaMzqkG+
tbNQLy0A5ueTuCWLqiEjIas/PTsIepNvy2zUVYPjvt7UHyUhcMHunyM7pRqM
pdgDv2DCQFUpN8VqoBpG3lzhl+6OAN/pz4S5+WooqO28tLD0Gth8egarN6uh
f/ypvNnet+A7l7FM4awB9Z8R15YPv4f7GrdFhMVqIPf6QO9T2Q/g67WQU6Nc
A4RXvyp9r0RB/LouMeF6DcS/W9OFO9Fg9f14e6NTDax/GlleC4qBy3UKorIB
NTAedGpzJCcWtsYqT09/qoEuj5Q5xc44MDYcfDZXVQNxXqeNzjMlwHEJ9lDl
nhqw+ft6l4zCR9jygO+9/9WAMaVBRPdBIuQ4wc1m7lowrNE8NJzzCe7vpz5l
PVsLL/N8akSWksBNivo7waIWtuGFs93Zz5CydeNLgHctfBs7v2siOAVk86lX
sam14EIT3+f5KBVohK8lVsRaCO5dWZwSSIPT76Kr9ei1YO5ekD5JTYPKiB0q
SXx1kFogK/gxKB3+hR/mvaZZB/Jf+C7LqmWA6grIWbrWgXmD51/SRgZILGGc
SUl1oFXqqRpXnwlh3kpZSS11cOGA9wFMIIM7kv7gezfrgFfd7esT/S8w6Xg7
85lsPfC4PXo0dDQbiIYL/MG29XC0JJ0uuZoN6uy3f27E1IO6SRzPa0oOqLB8
+f2NUg+7Ssp4FHJzQb4/Z1SeuQHuOcqGmUTmgeaTHyZrKg2M/KLoKuyVD339
5+nSTxugnhhu0H73K0SoI6Xu4gY40HRLLv5WAexYf5n8Y7kBSh8mlhVbFoLG
SzWvsJONsEfXT8z8ZhFoS5ltRz9shJDbVxvtzhRDKrujIX9hI8zM+6p/qi2G
S8Z1dnyrjRArk3LH60oJsIS82Rl1FsGNxWPTvL0lsHp4eTDUG8H3T90+n+6V
QkzCK+tfOAQ3Te5Pn9hRBnkn38+ssmLALnlyajSpDMrzjPglZDDA8/u22Zxq
Ofyzfn+Sz4jBk/c2ZZ3Gy8Ff/PgU0QsDj+VmXwe9qgCWDLNRxRQMVO+MqXNU
roT425jY20QMVK5xaCgtVgJEHDa9/B0DxcKPZ0QzquCuW7byND8WrOae15na
VsNDvSw59ctYUIiSltoQrQFtJk26iSsW/BT81y8t1sDU8eD/BD9h4e6qnMmt
mlrwe0t7nkLEwsJTh/EXkXVwT1Ldp+snFtS0niCaUz1gmZO+Vovi4CM8+xB1
tQEOrnC56hnhYJR/7NW6XCNo/Qvrfu2Pg9dTxV6KggjUV8pj3ItxsGOlYwLH
hoEzl0t3M43j4EmXB+FgOAZE064KyR5sgugVLT1Jdix8LSTYrGs2AcdB6SrR
91h4nn+/39yzCTBFXDKiR3Bw5Jm5gE4uw4+dVC/WzmHMS9p9ljjcBGYrV89V
qDRB8op+BmU/Hs6dvx8X2dEEnL6VunpaeDBe8Yr9+RAPvPR7jy+/wMPaLM80
J0czow49zssrwsMOdSVx5tJmaKBZdz+dxoMHV/O3nzcJMOeguydJoBnELhq8
4dxLhD5xpbcHjZuht/FzpBciAnk0vZ0a3gxOHPxSVs9JwMH3UgeLGH71Z07I
iDIZfima+Y6uN8NBH9FMuS0yHBD/Os5/igCnHw+Ze5MpIHEtvcPWkQA3hHSU
lhNbYNu72jsjiQCU2rsfS5+0AhFDaW/vIkDJwwyfP4ZU8F5RfNjJzvDvggde
fD/bBjSc6Ku4Swy/PhVaRBBph2lWjnnWZ0QoKC3pMmOnQWO4U82eQiLYWVz7
7BRGg/aQ0NCQSSLEfr/UcHpPB9zhaRay4yNBd7uaKvlNBwQf3fD30yNBlf0+
Ph2eTii5r1/b+JIEvz9LnCCldYJKSVAfUykJnuSpbFuf6YLe0hGCyCQJHFR8
+kSIXTD0qgD+HiSDVqa7k7RtN9ANWnOcL5GB584OXOS/bsjMEt1WdSHDLIvO
SbuUHqi65l+v95EM9sqK36u1esF/dQ9yxpFh5YyadM73XvgbFS5vM08GE2G5
KPXUPkC7OJ9uMnj04/rri1Gm/UCgKe/bdZoCK6d17PM5BoDbtDL88nUGT84k
sCS0DMAMt7f38wcUGOx4UWr3dhCcrpk7OzD41DhoQIrLfAj06t43YD9S4GXB
zq0M0WG4JnyTdi2fAj/f2p4V/jkM+olT3yqqKeCYbjT2kjICS0Os/JVYCvjr
6+bWZn0Do8GA4s1mCuTMXbvdFDIKkZLfVxUY2t3wT43m2TH4w+LlxIYowLpm
felX7hg8xbzaJV5GgdOrrqNLwuMgGvjznlQaBWQ0pysOJI7DuO19/gYGn67v
5pG4zjMBWHbWMf97FGAq+xX2KmoCvmkPnuHRpICPE30s88AkWP9ay+HnocDe
G4afXkRNwvO/nSGyo2SIOtwKk4emwFnWyOJ7KhmehXOdKUmYAsWlH9nMN8gQ
+v7Ak5Jj0+D4a6F5FzsZNDkb7+RnTMOtYrmUtGISvDzT89lWega+2t8p9dYn
gXvHNulNyQxoaM5xa4wRwVhD1WdaeRbMOxdCsp2J0C84ceEIZhbelbxNc5wh
gP72qxfdV+Zg9U0t50UrAkgpnS6rap2DwDMaxE1MM8QnNcbbGc0DJuSuncex
ZtCIuWhxv3se7Pj7bkW44KHt8tN/DmYLQOuNfyhV3gRqVR+WR7sWwM/Hpcpo
BQfvL+577nh9EdadOnZzHcPBfnGLaB/iIswGNE/6qWOhaME6PffCElyTrQqm
WWKA6Mn7wDV/CeJsrQxetzZCYkECnyHvMlRRgkzvdjL8+g/jm23ey/Ak6sEK
M74Wvl7dm+wytAzlRj9MrNKrgcnWU6tacQXeS+rOh7tUwg9VI3alsBVQHuB7
0idVDqu3RbV8Olfg6GGtvKKeEnBVEroqzEuHpB0fgi7OFkKY2dn8JiM68Ms4
PM9hzwPmsOWI/SGMdi75Fwr8WcCj05lXV0QHKdkTgTm8qXA5VSkipIMOpyWH
3qxxxMEQf53KhQU6BNPL/P9Uh4HF4bfSVX/oUPzteT2Z+wZMZMdmjW/TYWas
7P/f1+XQt/7/fV1RRH9RiFcwLA5pPc39Q0cXTda6sx7EQKCIWn3ZDB0FSk52
eQV/BhlqtvEVIh29/16xHKGWCa//ZUqmf6Kj4wuBrx1Ecxl5fdlC2IGOquw1
tRoXC0BdL8H5tAgdfcIslzy+VgLoiYyCedcK2pV0Vr3pTRk432p+csJ7BcW6
+l+arq0Aw5d0AR3+FWRVzfNXvKsKvkykRD4sXEbzlfbDHN01IKlXVqJ3YRnJ
5WZ636+vA4H3B0XyMUvoka3Ho8uvG2Ahs9NaH5ZQdl7v9wlAkDchrrBRtYh0
KhdMph5iQIPOcdVLZhE9k3S+aHmSwa+7ySuhiQvIYJct/fI3LDSp5CrNsC4g
Z6mpi7WBOPjqdUNX12Uefev70zfC3wR8StUcDt1zSEUrumMuowlU547u6VGe
Q2qalIvHRfDgKSiSoJw0i3aROvCLH/DA9Ub9tuD2DDpypl4jbR0Ps7JNM+z2
M8hdtTem/HozJHhEh3o1TyMuNw7vpORm+NGr69gpNY3+zlRn94w1gz9baYHf
uykUbXJmY4yfAK3iWyPd65MouHzn7CUdAuwPTpcXs51Etnq7OX1dCRAghhUs
bJlAMgul/3gjCfBDgW2i+PwEcvozLhKdTgDvaKNDt/PGkdZQ89CTYgKwYye0
xo6No11yMhjFKgJoGG99uhEzhqS71n6bMPTJU4RH8xxjCFlEErRLCFC4ebte
i2cUJT2cPxaURQClRNOJUzzfEJv0po1HDAFiVU6ezRIYQTvlrp8I8SMAW8Of
15WSw8gv+LvkEQcCRFvgvjqrDiFxCul4tBYBrMcdL9SaDyLun//NXxMjwK9P
rvEZXgPIjK3WIv5fM2i+IeYcTulHf0qP+ZC7m8HLPvwTC7UP9dtL5cvmNgP3
gNdr0x19KEDBOn2vdzMcaqAIrVzoRcxR3UVfrjXDjYa/hyt8epAQbnFYja8Z
+moTKK+auhE3/w2BfVN4UHoxGGewvxul6H5zv1qIh8OLh699s+9CVx43npXw
wsP68bHnvHWdaCXSV6LnIh72MdV2dfJ1IhnS5ZIAVjxczXe4s+LdgeLk4nnM
WppAQ9ydpjlFQ333/sY8fd8EnbNcMQVGNBSx3y5llxnDr6iZXt8X3o4CDDb/
STL2E1024IahZxsyy373d2MYB+cIk2Ijj6go/uC/9wmpOAhg7Te/59KKnH4y
BQg44GC+Jyrtq1cL2laVCf10Age35Gq/2URQUMr1HW6nFrHAE0lUUssgI6PH
JpfnCrFwQ2zvJaZmEmKPabUeeoKFtK4D+++uEJFJCDGcTwkLYUNH9WWFiGj+
t6dg0SYGLDOuqvNaEFBYlatgAQYDKd/ogxOxzehGUNYVoVAM1FmRG8yH8OjR
0SWpA3oYmFOXV1U6gUdlupxakQcxkG/BbK37vAk9FjhyXKUMwX1ny4GbHTgU
0y2vEqWB4Muh1/wKcjgknVAocqarEUY5s08nR2GRfDR7/AnHRjB6l9HrtIlB
fNkH+vx+N4Db01d29vcwyMBoR71GZANI9oV411UjFJjQ3Ocj1gD7fxq2WOY0
Isyxx2/O1tWDto1EyeW0BlS9h0PMw7QeWr6Mi0pn1KMt3uGxi/Q6WCHybFQW
1KEDOdICn17XAfOc6NgnTC1yVsDrRErVAdf17fNvhmrQ4zPH+fjJtbB6o4/7
4lY1mpZ5+fTS/VoI2kjfd1+yGqlDRsYejlrwrKJcarGqQux6M5fdSmpgj/kP
FaGoSmT7af+95xY1cPrtZs/xjgpU1HLvo/h2NWzqGSqk8Vagsi/fJx/nMHj4
fEC6mX05eu1PnbY1qQaxMY13bOVlSAe/r+f7dhXot3W4hOwtQ1fuFkYIF1aB
oAK+INq5FL3j5Q1dsa6Cd//pf2ZqKUGn1Ga3LLmqYHJ4427imRLEsdtiwhpX
+f/audN+qN82juNSEdkiFS0iIdGiKMu/L0KhyJo2LUJSKi3KEkXWiSzJmj3S
zJgZe+jHMEOFEloksstaqaTQ5SFcD+B387x1vl7njeM8PnfeuOzW9W1LCoPI
F5/t+HOtCF3F5u33xRjEsXS1s6qqRbjV2dewUziP6H8wwfneWwgXu4l6NV46
8WLYlW/vw0KILj/hwv1HJQ7WSC5XPlSIr8obDDIWUonTb/yJ+5KFOHay7pWX
xBNiQuZddlBzATbaaagv3JBLXBYeODodVYBJ2Teak4aPCfPmtdZfrQqQ6bZB
QehsDvHLa9348WUFMHueSOO5n01s/b7Kd09bPtapN7+N5j4iNFxH9mSk5OM/
TaG+wNksYo+SiP8Fp3wQRor6yTpZxBN961M5m/IhauzjkuSXSdAmLoib/GZh
qfylZtMXGcQiilnFgWoWOjqLu65IZRDOkvspJREsmBpZ1HefTyeCHQxzfY6x
IFatHHGqNo1o2OBhmKTCQuQZp/fs9WmEjrd5pNgME8biupPNwalE2W+xureN
TARdlHzw6nMK4U63VxlOY+KlsZ9rRslDglvwRNDkGhO/yrVEG+KSCQ+9yKfj
pkysvkgZ+u2XRMSPCaW+l2NiQrdV+O3FRIJVnaMy7y8DTm9fSy47k0BYe4Z/
dmxhQKa/Tuy8Uzzx/ViQ6fw8Bh5rUk9HusYRISJDwm9DGZCq4ynS9nhAtNt5
fGhzZkApIPuVQkgscUtf0V3EiIEJ7pkw0bT7xAKbAfr59QxYBumWFTyLIfbJ
mXr+XMiAfstJiXdd0UTOu+OPDF/lYcH+L0s1BaOJ6+E5CX0xefCN0Zh6uCOK
aFzxfB3naB5ezPQmN7pEEuZxU0SHQt5cHx25FJF6j2idry+tOkGH/dFOwro4
gpAyt1v8pIqOErXl/s3q4cTQ3fMJVlF0OBRXRKiVU4jDO4ZnZB3pCNkk2LbY
JIw4FyebtESLDhMRY87fjhBiw9XBxWuW0DHJ/sWb5hlMxNTMra9DNKxppron
rQoizBxjmd4cGkKTW3kja+4Q2+LqhGrTafihszJqnXsAUcMjdmfNbRrCzwU2
/ZH3J9Z+oj7xdaChPlJfkWi/RRyW3mk4YDTXHDbTkdLxfkT/pyljSxUaRH6m
Sl3Kv0l8EtvZXyFBg0vqrYEwHW/C1s3HU3GGCp5ek6au+hvEZsqHRMogFfe3
yl5qcvAgVppILx1upSJOeod/Gc9VokvgX5cuh4rkFgUWb4Y7oSPgpEkpomK+
xJTDYpOLxEXVK/4vH1MhcCZc1GPIlUgJLLafeUjFLE9j7Y89zkRnnUHK2lgq
Dn5d9fzEk1PE/q+vzLZHUHHy8I0nKxWPEu06ldQdoVQkpS26lDprSejkYpNy
EBUch+x7Pwt3Exweo5uLA6k4104t79XiJyyiU3w+zp3/6Nk5ajXqorNoXD8h
hAq77tCx7aEW8PpNl94bToUVj7NrNfMwOoXXB/XFUBGxvaJM5OtJTF+1172c
TIU9hU+gIcwJPYWrt3/PpiI9wT7WWNUVysvr7jgUUOFuPKCR33oBG2v2h9ex
qfjr9M179W53bFsu3C7XTAUjJNNIMPUKZAcZalf6qHBtyzigzesBvySBsGdT
VHhXOT/af/YG+Ao/iy8Qo8HH77Hm5/deGAzhquxRosGvd0QyxuwmNnV+uBCq
T4OejYMJn5MfiPHg7Nf2NFwSv/F8MucWcgNMm1f50LA1QL7Z/ettzKbbKLgn
0zBlaafcoBMAFQt9/haCBqbMIgX78DuwHiwUNeqlgW3MarjZF4jNRyYX1wvS
0ZV4+1eIfjBiX/n+cdlGR+7ZFSfbs0LQ2ua7WN6ejp8//rxrEQ3DaMah1NlQ
Oo7L1Jq1+FHgLCNqOltKB77J8u6auouVYRkNisN0TFG84jxuRCB01wUpvzV5
uHroXdoPv3vobzltJmSdh+Dkmm83jSPxL93oaVNYHqyVsmIil0Vh+6GX71o5
ech8vaTj9GAUJMzeK4jOYyCG4pinRkRj1fpP1+zWMjCVIBmmkRiDs4GNH57r
MiCnkZpD876PS8e+nHQ6xUCwsZTAO4dYBHlvVN96h4H07qOUiQMPELAti6L6
mIG31uN8RgZxGDSsyLdvnJsPptF2ErviMbvXib/uBwPJRg/903clIOmkwc9z
q5hw2LeUo2OUiA1G7D8HDJkQaI6mqdokocFmaabHBSa0dVdqV7smw9tPKaw3
gQn+OObE/tCH+JNxyzaxlolQw2keWWYKmF+mi1N+MnF2hZOC8cVUnIr1df0p
zwLT3NbcRygNAylh6qk2LLRa4tNhWhqu7yrtyghi4e/KZbpLrNJx/K6E3oIy
FsYkEdg0k47yjbZKnHEWZo7fO99Iy4DNIwG3ofX56NP+dkXHIROhJt6DHsfy
ceRx0pjFmix4tca4XorNxzITYYk9nVkw1/Pmtr3Oh9vTuKW2jx5BkVhZVSxU
AGp85bayy9mQyXeVEjIpgNAttBTsyUGa6T2/j8EFoCi9j/Kf656/gpUPNjwv
gNrQyJGzC3IRZP11ZEqwEIaVfbfpo7nYXLV70tysENGss20POp7Ag64usTm6
EHrXrjdcfEfFZtmbNxM+FGJhqfWNwPc0OBbnWN2XLcLsTuc6pW468qbt7si5
FiHeYvpu7o88HOHX+GBQVIRRimfTlmAG3tRf657lLQb7v4JbzdJMtK9aNG1p
UYzR4cRrriwmxHMN9HenFYPlWO+rZM6C8ncNStP3YmhrvlDV+cZCv/bR0/8M
SzAvuqL7Q1w+KjU6eRoTSsDhyerRMCqAqYSu9q5vJfhcO+sSOlWAkxuPBx0w
LsUv+75C4fxCpPp1fFmQUYqkvQlrp92LsP5mw+jh2VI4Lr6xOVqzGAK+kfEW
R54iXs8kW5y/BKKZ06cGSp9i69ORlPKPJVD38peTli7DX6u9ca3FpRju91s4
4FWG8jiv0MzEp0gIv+Zr0lkGupQaz+WgMiwf09DSNSjHyEoRxbte5aho611Q
nVuOXG2hPr3rFfBYmF9VL16BbTuqR7p9nkH98T5LW+8KiAoea6qhEHDc8ur2
wYEKNDmI3U2xrITcNu0JrtUz3JXKU37bU4kzhN6/+KpnMHLQl1T3rELmBYvM
mi0EtrZGF45IsvHXmeOomUaAdsFqyeZiNt57hT24IjC3P1dLvtlsXw2v7N/x
XfqVsHm+z1R+cQ1canmd27wrISnF57v7WQ2qNXdRrYsrsbFnqyzXg4Mq/ksL
DL9XIop/U3z/Di6uVOd3P1StQnfqnnlds1ws2bfR29qlCsxzH9dN1NciM8CY
YZtVBcXLrKtH0+sQesN/PKarChkqKsL2vs9hrXVu7cxqNq4venpf6/QL7O2W
9/c6zMazGFloWLzE8Pyl0X9i2VAJH8qONarHCZ4P/aea2egh9rHTDRqg2O8u
kihajUfNHax000acOB57Ici0GrN/1XI6j7xC1MZtawWDqpHtqNPapPUaaVWb
CV52NYLNxJlJ9a8xpuViajZdjdGL+kNXHZowny0yxVWvwe/doYL+/5rwi+q5
0MCtBjdmZK5+SX2DPLeSkPisGqRKrlJr3NOMgr6fpnEfazCbocyy+dEMsagt
94TFOOCdXxqS8agFOZsCBtn6HExR6+Ta7FvRdjRu4c3LHMQYBJ6WXv0WO15x
g3jSOegZLDP373oLhTFWE38jBxdltkZspb7D9rubP+2b5KD9tcDfXT7v0Sbl
IRGwmouDaloibOsPOPSif8MxXS7cL2zZ36DWhuLc5AX+x7k4KjiY5Lb8I/rK
YlITPblIESsJofO2I2b7DN/eSC6Kz9v6RPxoR8u9EVP5DC6WL2X3CI1+wlL7
hITaPC5+VgpDeqQDm+YzLGqKuHAxOqGc/q0TdAlHtZy53jae9njEvvkZbsfs
sqbnetuqbF1KPX8XFK7sXrFnrrd7DLrpzdFdeD9Z6yEwd59Q379XhXLdeGD7
qI59hYsnA29yjQu6EVyd3TNuzsW5XWt/H9vbA1HdUweF5LgINEJfSUcPSoSK
3aOHODjrbeuz3KMXv696es6b6+lJ36yVqkv6sCVaTKj16Nz70N2G06l94Asa
o91byMGtQprncuN+VEW13i1Pr4HOsJ3jmv5+tKzXcx3cVoNFwc4yuv4D+M3X
nUsrqcY35229UzKDYHvLhjO3VOPd+ZmmirJB/Hc8Iig7kY1rXyx2Tth8wTO1
tnSrqSqcKy+RmRz9Ahn5mB8U4yoYC10TW+0/BL9R6nxdSiXYbStWM5YOo7cu
ZWf3bQLiE/Lbf6QNY/2aFxPebyoQa2/yVFF5BNcDRs/U8JdDIPHQuTvUEfQ0
Pit1XvcUZgUBd4yURkFxk3GyUiiB14PYdVlJozipp85hLSnCdrXSzo5FY/D0
13L+2p+PE2lmETvOjeGPqKZ+YTYTwcEeq6c5Y1hoqaLU8ISOuF+Wrnckx3Ex
arbdYOAx3F341mkfHket8+q2q3xZYLPsz8RGj+OQM83whEgq/r4PsJCvGsfp
JfOcMxbN/cuSX8WDu8ch6a1nZ1kcBEqN50vvyXGM3L/6s1LiMFQtd39++28c
pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1
pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1
pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1
pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1pF9H+nWkX0f6daRfR/p1
pF9H+nWkX0f6daRfR/p1/49f9z9848BV
     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986326069097*^9},
 CellLabel->
  "Out[1097]=",ExpressionUUID->"c5dbddae-ddcc-4cda-83a6-aaff622ce6e6"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkWnk4lV+0jpCKJCSiokgoFCLDQplFQgiZ5ReZh0rJUEhUMg8pZAiZ52mb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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 0.9999999999999999}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986326394264*^9},
 CellLabel->
  "Out[1099]=",ExpressionUUID->"a63e166d-968d-43bd-bbbb-7a84ad221132"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxsm3c41f///5GRZJRQSlllhIxSUj1KZJQ0lFKhIhWiEKGyV1ZlZa9ChOys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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986326835208*^9},
 CellLabel->
  "Out[1109]=",ExpressionUUID->"8cc89bf8-ee4c-4ca1-935c-69dde7244031"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkWHc8l2/UNuJXVERJVsgKIURGz7ETyS4ze6RFhOzslb1H2VvIpr63vfeK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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 0.9999999999999999}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 25.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986326988896*^9},
 CellLabel->
  "Out[1110]=",ExpressionUUID->"626384c0-4ae0-4aa0-94fa-0fae08b238b8"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxc23c41t//B3CjRWQkkdUiZKVEwos0SMgoZI+UhEJKGqKSsrJHiYiQLaVw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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986327666141*^9},
 CellLabel->
  "Out[1121]=",ExpressionUUID->"018d4ba9-000b-487e-b1e9-f33705403e73"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, -1}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
         0.5, -0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 0}, {
         0.8660254037844386, -0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {1, 0}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}}, {{0, 0}, {
         0.8660254037844386, 0.5}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[NCache[{{0, 0}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {0.5, 
         0.8660254037844386}}]]}, 
     {GrayLevel[0.5], Opacity[0.4], LineBox[{{0, 0}, {0, 1}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[1, 5], 0.2], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[2, 5], 0.4], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[3, 5], 0.6], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, NCache[Rational[4, 5], 0.8], 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJyEeHc40F/0v1A0iJCUFWUkKyvhnozMFCJUJJIksqkomRUykpBRSEZkb+9r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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{Scaled[{0, 0}, {0, -1}], Scaled[{0., -0.006}, {0, -1}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, -0.005196152422706632}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, -0.8660254037844386}], 
          Scaled[{0.003, -0.005196152422706632}, {
           0.5, -0.8660254037844386}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
          Scaled[{0.005196152422706632, -0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, -0.5}], 
          Scaled[{0.005196152422706632, -0.003}, {
           0.8660254037844386, -0.5}]}]],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {1, 0}], Scaled[{0.006, 0.}, {1, 0}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
          Scaled[{0.005196152422706632, 0.003}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.8660254037844386, 0.5}], 
          Scaled[{0.005196152422706632, 0.003}, {0.8660254037844386, 0.5}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[NCache[{
         Scaled[{0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
          Scaled[{0.003, 0.005196152422706632}, {
           Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}]}, {
         Scaled[{0, 0}, {0.5, 0.8660254037844386}], 
          Scaled[{0.003, 0.005196152422706632}, {0.5, 0.8660254037844386}]}]],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[LineBox[{Scaled[{0, 0}, {0, 1}], Scaled[{0., 0.006}, {0, 1}]}],
       
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0, -1}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}], 
        Offset[{4, -6.928203230275509}, {0.5, -0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}], 
        Offset[{6.928203230275509, -4}, {0.8660254037844386, -0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1, 0}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {
         Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}], 
        Offset[{6.928203230275509, 4}, {0.8660254037844386, 0.5}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}], 
        Offset[{4, 6.928203230275509}, {0.5, 0.8660254037844386}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0, 1}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {
     {GrayLevel[0.6], 
      StyleBox[LineBox[{{0., 0.}, {0., 1.}}],
       Antialiasing->False]}, {}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {}}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 50.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.7950713440409603`*^9, {3.7950713786801147`*^9, 3.795071422493129*^9}, 
   3.795071909000643*^9, 3.7950719498609667`*^9, {3.7950720303000927`*^9, 
   3.7950720775804033`*^9}, {3.795072126897153*^9, 3.7950721527852917`*^9}, 
   3.795072265520297*^9, 3.795072301107872*^9, 3.795072794749755*^9, 
   3.7951320305274773`*^9, {3.7951321165580893`*^9, 3.795132131195404*^9}, 
   3.795132219743774*^9, 3.795132286161867*^9, {3.795317983129695*^9, 
   3.79531800194916*^9}, 3.795318137471039*^9, {3.79531817584422*^9, 
   3.795318191572703*^9}, {3.795318268587084*^9, 3.795318282709783*^9}, 
   3.795424963220475*^9, 3.8009850762336884`*^9, 3.800985319791256*^9, 
   3.8009853944913483`*^9, 3.800986012875655*^9, 3.800986327818469*^9},
 CellLabel->
  "Out[1122]=",ExpressionUUID->"381d1dab-cdb3-4f65-8bad-5c136a4323e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Fano", " ", "factor"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"ttdag", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "[", 
      RowBox[{"en_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"2", "  ", "kt", " ", "kx"}], 
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]], 
       FractionBox[
        RowBox[{"2", "  ", "kt", " ", "kx"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}]]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"kx", " ", "\[Rule]", 
         RowBox[{
          SqrtBox[
           RowBox[{" ", "en"}]], " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
        RowBox[{"ky", "\[Rule]", " ", 
         RowBox[{
          SqrtBox["en"], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
        RowBox[{"kt", "\[Rule]", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "V"}], "+", 
           RowBox[{"en", " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"fn", ",", "int", ",", "dat1", ",", "dat2", ",", "dat3"}], "]"}],
     ";", 
    RowBox[{
     RowBox[{"int", "[", 
      RowBox[{"rat_", ",", "V_", ",", "\[Theta]_"}], "]"}], "=", 
     RowBox[{"t", "[", 
      RowBox[{
       RowBox[{"rat", " ", 
        RowBox[{"V", "/", 
         SuperscriptBox["L", "2"]}]}], ",", 
       RowBox[{"V", "/", 
        SuperscriptBox["L", "2"]}], ",", "\[Theta]"}], "]"}]}], ";", 
    RowBox[{"L", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{"int", "[", 
          RowBox[{"1.0", ",", "1", ",", "\[Theta]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.001"}], "}"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{"int", "[", 
          RowBox[{"1.5", ",", "50", ",", "\[Theta]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{"int", "[", 
          RowBox[{"2", ",", "100", ",", "\[Theta]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"V", ",", "L"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dat1", ",", "dat2", ",", "dat3"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.795119119854344*^9, 3.795119123596528*^9}, {
   3.7951191721161423`*^9, 3.795119265781043*^9}, {3.79511932471906*^9, 
   3.795119353568372*^9}, {3.795119389258197*^9, 3.795119491306999*^9}, {
   3.795119531801958*^9, 3.795119758298603*^9}, {3.795119854246603*^9, 
   3.795119906475195*^9}, {3.795119986495932*^9, 3.795120021574985*^9}, {
   3.795120061146966*^9, 3.795120061740101*^9}, {3.795120455763092*^9, 
   3.79512073068731*^9}, {3.795120778697257*^9, 3.795120782596369*^9}, {
   3.795120962101157*^9, 3.795121028557564*^9}, {3.795121219566338*^9, 
   3.7951212231221*^9}, {3.795121261692348*^9, 3.7951212857968283`*^9}, 
   3.795121374319318*^9, {3.795121430549168*^9, 3.79512144776952*^9}, {
   3.7951214953293037`*^9, 3.795121525078743*^9}, {3.795121665516431*^9, 
   3.7951217020190372`*^9}, {3.795121766934218*^9, 3.7951217678928947`*^9}, {
   3.7951217980836983`*^9, 3.795121824213675*^9}, {3.795122268385497*^9, 
   3.795122270446301*^9}, {3.795122420044136*^9, 3.7951224204759483`*^9}, {
   3.795124114386352*^9, 3.795124156126438*^9}, {3.795124194641893*^9, 
   3.7951242032552233`*^9}, {3.795124241851467*^9, 3.795124290399866*^9}, {
   3.795124321630988*^9, 3.7951243626546183`*^9}, {3.795124394444891*^9, 
   3.795124485468213*^9}, {3.795124518965815*^9, 3.795124520546698*^9}, 
   3.795124620511257*^9, {3.7951248026270857`*^9, 3.79512480673764*^9}, {
   3.795124873520092*^9, 3.795124926452044*^9}, {3.795124971890053*^9, 
   3.795124976118627*^9}, {3.795125065065627*^9, 3.795125146587076*^9}, {
   3.795125520387301*^9, 3.795125721167021*^9}, {3.795125752293148*^9, 
   3.795125763870047*^9}, {3.7951259278592663`*^9, 3.7951260392297163`*^9}, {
   3.7951274606863813`*^9, 3.795127462591481*^9}, 3.795129413154029*^9, {
   3.795129456142994*^9, 3.7951294646193247`*^9}, {3.7951329583435287`*^9, 
   3.795132963352813*^9}},
 CellLabel->
  "In[1684]:=",ExpressionUUID->"83952918-6f64-40ab-ab34-36ba1dc377d2"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw013dcTu//wPGQJJVk9SlJFDKKJCNckohSRhkJFYqQsndlRWSmbKFBSIW0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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwt1Hk0ldsbB3CZGgl1ZcjNfG+lUEjU+xBug5ApmpAkruFmKEMISSRDxgo5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