(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  14288339,     241770]
NotebookOptionsPosition[  14273935,     241565]
NotebookOutlinePosition[  14274256,     241579]
CellTagsIndexPosition[  14274213,     241576]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["3d qbcp", "Section",
 CellChangeTimes->{{3.7948269139390078`*^9, 
  3.794826917412561*^9}},ExpressionUUID->"f2351a50-1ba8-46cf-b205-\
608e889493c2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ham", ",", "\[Psi]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"id", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Gamma]", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]", "[", "a", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "b", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Gamma]", "[", "b", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "a", "]"}]}]}], 
     RowBox[{"2", "\[ImaginaryI]"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"dahat", "=", 
    RowBox[{"da", "/", 
     SuperscriptBox["k", "2"]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "1", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kz", " ", "ky"}]}], ";", " ", 
  RowBox[{"d1hat", "=", 
   RowBox[{"d1", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "2", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "kz"}]}], ";", " ", 
  RowBox[{"d2hat", "=", 
   RowBox[{"d2", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "3", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "ky"}]}], ";", " ", 
  RowBox[{"d3hat", "=", 
   RowBox[{"d3", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "4", "]"}], "=", 
   RowBox[{
    FractionBox[
     SqrtBox["3"], "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ")"}]}]}], ";", 
  RowBox[{"d4hat", "=", 
   RowBox[{"d4", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "5", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["kz", "2"]}], "-", 
     SuperscriptBox["kx", "2"], "-", 
     SuperscriptBox["ky", "2"]}], "2"]}], ";", 
  RowBox[{"d5hat", "=", 
   RowBox[{"d5", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "i", "]"}], 
      RowBox[{"\[Gamma]", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", "ham", "]"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6312382022915897`*^9, 3.631238225759459*^9}, {
   3.6312382600929537`*^9, 3.6312384017277803`*^9}, {3.631238501848529*^9, 
   3.631238514655388*^9}, {3.631238557337954*^9, 3.631238582703508*^9}, {
   3.631238697418057*^9, 3.6312387608920393`*^9}, {3.631238821822587*^9, 
   3.6312388336171837`*^9}, {3.6312388682255707`*^9, 3.63123894870654*^9}, 
   3.631241459271804*^9, 3.6312415058351183`*^9, {3.631242162714487*^9, 
   3.631242164860416*^9}, {3.631243821329649*^9, 3.6312438323099318`*^9}, {
   3.631243931067396*^9, 3.631243943321344*^9}, {3.631245485411551*^9, 
   3.631245507064893*^9}, {3.631245606183861*^9, 3.631245636233708*^9}, {
   3.631246369852314*^9, 3.631246410769082*^9}, {3.63124927017979*^9, 
   3.63124930420273*^9}, {3.631249422231785*^9, 3.631249432782104*^9}, {
   3.631249677286726*^9, 3.631249702711062*^9}, {3.631285101024441*^9, 
   3.631285106140984*^9}, {3.631285140088323*^9, 3.6312852358940573`*^9}, 
   3.631287438641325*^9, {3.631295671787744*^9, 3.631295675200363*^9}, {
   3.631296743735948*^9, 3.631296768464766*^9}, {3.631303956396132*^9, 
   3.6313039785131187`*^9}, {3.631363753884413*^9, 3.63136377298313*^9}, 
   3.631414086575067*^9, {3.631551950532612*^9, 3.631551957383226*^9}, 
   3.6315519991082993`*^9, {3.711821084066185*^9, 3.7118211139118958`*^9}, {
   3.711821392685665*^9, 3.71182150933855*^9}, {3.711821576479093*^9, 
   3.711821735961163*^9}, {3.7118217742380238`*^9, 3.711821848019948*^9}, {
   3.7118243385720043`*^9, 3.7118243649817753`*^9}, 3.793277445616826*^9, {
   3.794826944606303*^9, 3.794826969612651*^9}, {3.7948270440250483`*^9, 
   3.794827071360015*^9}, {3.795345678473947*^9, 3.795345684714752*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"ca5c9fa3-7f11-4ca9-83a3-4fe055f9d930"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], 
           ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["3"], " ", "kx"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"], " ", "ky"}]}], ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["kz", "2"]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7953456853892813`*^9, 3.795411286962137*^9, 3.795412740672756*^9, 
   3.795414737970853*^9, 3.7954179339035673`*^9, 3.7954183303068857`*^9, 
   3.79542858434525*^9, {3.795519241133408*^9, 3.795519241495771*^9}, 
   3.7955300454871798`*^9, 3.795534868978817*^9, 3.7955361979941*^9, 
   3.79553708986874*^9, 3.7955445298113327`*^9, 3.795544841613719*^9, 
   3.79554718504021*^9, 3.795588687775531*^9, 3.79558933204692*^9, 
   3.79562910188247*^9, 3.795636173793158*^9, 3.795637919595484*^9, {
   3.800991617010502*^9, 3.800991617325849*^9}, 3.801033367369919*^9, 
   3.801033548888126*^9, 3.801034001454775*^9, 3.801035956922987*^9, 
   3.8010664584505987`*^9, 3.8010669471343946`*^9, {3.801107370572006*^9, 
   3.801107371408258*^9}, 3.801107416357733*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"3620e24f-aa05-4e55-85b1-eee781d88841"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\[Psi]", "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"determining", " ", "bdy", " ", "conditions"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]", "=", 
   RowBox[{"{", 
    RowBox[{"\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"ham", "+", "eV"}], ")"}], ".", "\[Psi]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.794827027926633*^9, 3.794827033118905*^9}, {
  3.794902624730678*^9, 3.794902642848404*^9}, {3.794902701550852*^9, 
  3.794902701875354*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"15ae4c07-3025-435f-b4fe-5640d7619772"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], " ", "\[Psi]1"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"kx", " ", "\[Psi]2"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky", " ", "\[Psi]2"}], "+", 
          RowBox[{"2", " ", "kz", " ", "\[Psi]3"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"eV", " ", 
     RowBox[{"(", 
      RowBox[{"\[Psi]1", "+", "\[Psi]2", "+", "\[Psi]3", "+", "\[Psi]4"}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"eV", " ", 
     RowBox[{"(", 
      RowBox[{"\[Psi]1", "+", "\[Psi]2", "+", "\[Psi]3", "+", "\[Psi]4"}], 
      ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["kz", "2"]}]}], ")"}], " ", "\[Psi]2"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"kx", "-", 
              RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
           "\[Psi]1"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}],
            " ", "kz", " ", "\[Psi]4"}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"eV", "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        "kz"}]}], ")"}], " ", "\[Psi]1"}], "+", 
    RowBox[{"eV", " ", "\[Psi]2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "eV"}], "+", 
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}], ")"}], " ", "\[Psi]3"}], "+", 
    RowBox[{"eV", " ", "\[Psi]4"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
     "\[Psi]4"}]}], ",", 
   RowBox[{
    RowBox[{"eV", " ", "\[Psi]1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"eV", "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        "kz"}]}], ")"}], " ", "\[Psi]2"}], "+", 
    RowBox[{"eV", " ", "\[Psi]3"}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", "\[Psi]3"}],
     "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "eV"}], "-", 
       SuperscriptBox["kx", "2"], "-", 
       SuperscriptBox["ky", "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}], ")"}], " ", "\[Psi]4"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7948270343475237`*^9, 3.794827075518881*^9}, 
   3.794902648486661*^9, 3.794902705996623*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"16abc785-761f-4c91-9f34-451d67083566"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"ham", "+", 
   RowBox[{"V", " ", "id"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7955192336028433`*^9, 3.7955192496563396`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"0e0314f8-8b4a-401d-ba49-887fa304c2af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"], "+", "V"}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"], "+", "V"}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"], "+", "V"}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"], "+", "V"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], 
           ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["3"], " ", "kx"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"], " ", "ky"}]}], ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["kz", "2"]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.79551924892758*^9, 3.795519250707409*^9}, 
   3.801107425477689*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"0ecc0b99-ca00-42e0-9664-efa3e3799f50"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"valence", " ", 
    RowBox[{"band", ":", " ", "en"}]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["kx", "2"]}], "-", 
     SuperscriptBox["ky", "2"], "-", 
     SuperscriptBox["kz", "2"], "+", "V"}], " ", "=", 
    RowBox[{
     RowBox[{">", " ", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"], " ", "-", "V"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"-", "en"}], " ", "=", 
      RowBox[{
       RowBox[{">", "  ", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "en"}], " ", "+", " ", 
         RowBox[{"V", "\[IndentingNewLine]", "conductance", " ", 
          RowBox[{"band", ":", " ", "en"}]}]}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"], "+", "V"}], " ", "=", 
         RowBox[{
          RowBox[{">", " ", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]}], " ", "=", " ", 
          RowBox[{"en", " ", "-", " ", "V"}]}]}]}]}]}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.79551926488653*^9, 3.7955193734367733`*^9}, {
  3.7955196356932573`*^9, 
  3.795519640741414*^9}},ExpressionUUID->"5eabbceb-11b3-4fe3-9502-\
2ec4ccb449c1"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"a6fad987-1da3-454e-9d3d-23adf1d66691"]
}, Open  ]],

Cell[CellGroupData[{

Cell["using mathematica\[CloseCurlyQuote]s eigenvectors", "Section",
 CellChangeTimes->{{3.795414959290254*^9, 
  3.795414967693398*^9}},ExpressionUUID->"023f4ea0-f67b-40f0-815a-\
79965de7fcd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"en", " ", ">", " ", "V"}], ";", " ", 
    RowBox[{
     RowBox[{"mathematica", "'"}], "s", " ", "basis"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"hbar", "=", "1"}], ";", 
    RowBox[{"m", "=", "1"}], ";", 
    RowBox[{"v", "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox["hbar", "2"], 
       RowBox[{"2", "m"}]], "2", "kl"}]}], ";", 
    RowBox[{"vs", "=", "1"}], 
    RowBox[{"(*", 
     RowBox[{"=", 
      RowBox[{
       FractionBox[
        SuperscriptBox["hbar", "2"], 
        RowBox[{"2", "m"}]], "2", 
       RowBox[{"Abs", "[", "kt", "]"}]}]}], "*)"}], ";", 
    RowBox[{"Clear", "[", 
     RowBox[{
     "a1", ",", "a2", ",", "b1", ",", "b2", ",", "v", ",", "vs", ",", "t1", 
      ",", "t2", ",", "r1", ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", 
      "\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]1", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["3"], " ", "kx"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"], " ", "ky"}]}], ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "0", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]2", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["kz", "2"]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]3", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]4", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], 
           ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy1", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"\[Psi]1", "[", "kx", "]"}], "+", 
         RowBox[{"r1", " ", 
          RowBox[{"\[Psi]1", "[", 
           RowBox[{"-", "kx"}], "]"}]}], "+", 
         RowBox[{"r2", " ", 
          RowBox[{"\[Psi]2", "[", 
           RowBox[{"-", "kx"}], "]"}], "  "}]}], 
        SqrtBox["v"]], "-", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a1", " ", 
           RowBox[{"\[Psi]1", "[", "kt", "]"}]}], "+", 
          RowBox[{"a2", " ", 
           RowBox[{"\[Psi]2", "[", "kt", "]"}]}], "+", 
          RowBox[{"b1", " ", 
           RowBox[{"\[Psi]1", "[", 
            RowBox[{"-", "kt"}], "]"}]}], "+", 
          RowBox[{"b2", "  ", 
           RowBox[{"\[Psi]2", "[", 
            RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
        SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy2", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"\[Psi]1", "[", "kt", "]"}]}], "+", 
            RowBox[{"a2", " ", 
             RowBox[{"\[Psi]2", "[", "kt", "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b1", " ", 
             RowBox[{"\[Psi]1", "[", 
              RowBox[{"-", "kt"}], "]"}]}], "+", 
            RowBox[{"b2", "  ", 
             RowBox[{"\[Psi]2", "[", 
              RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
        SqrtBox["vs"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"t1", " ", 
          RowBox[{"\[Psi]1", "[", "kx", "]"}]}], "+", 
         RowBox[{"t2", " ", 
          RowBox[{"\[Psi]2", "[", "kx", "]"}], "  "}]}], 
        SqrtBox["v"]]}], "//", "Simplify"}]}], ";", 
    RowBox[{"sol", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
        "r1", ",", "r2", ",", "t1", ",", "t2", ",", "a1", ",", "a2", ",", 
         "b1", ",", "b2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"rp1", "=", 
    RowBox[{
     RowBox[{"r1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"rp2", "=", 
    RowBox[{
     RowBox[{"r2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<transmission\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"tp1", "=", 
    RowBox[{
     RowBox[{"t1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"tp2", "=", 
    RowBox[{
     RowBox[{"t2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}], "}"}]}], "//", 
     "FullSimplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.795345711778309*^9, 3.79534571771926*^9}, {
  3.7954117189360027`*^9, 3.795411750253563*^9}, {3.7954117899241962`*^9, 
  3.795411962019146*^9}, {3.795411995669647*^9, 3.7954121376450768`*^9}, {
  3.7954122123419123`*^9, 3.795412219416184*^9}, {3.795412315463717*^9, 
  3.795412345296678*^9}, {3.7954131552222033`*^9, 3.795413156056336*^9}, {
  3.795413839984623*^9, 3.795413856544154*^9}, {3.795414047428824*^9, 
  3.795414060985321*^9}, {3.79558879514885*^9, 3.79558879741628*^9}, {
  3.795588876815197*^9, 3.7955888905817747`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"22d87132-a404-4bfe-86b3-d89e89635635"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r1", "\[Rule]", 
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["v"]], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["v"]], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], 
                    SqrtBox["v"]]}], "-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["v"]]}], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"2", " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"], " ", "v"}]]}], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "v"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["vs"]], "-", 
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["vs"]]}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["v"]], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["v"]], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], 
                    SqrtBox["v"]]}], "-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["v"]]}], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"2", " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"], " ", "v"}]]}], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "v"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["vs"]], "-", 
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    SqrtBox["vs"]]}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    SqrtBox["vs"]]}], ")"}], " ", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}]}], ")"}]}]}], ",", 
            
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"b2", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]]}], "+", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 23341227954252589688, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 23341227954252589688, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 23341227954252589688, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23341227954252589688 === $SessionID, 
   Out[39], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{
  3.7954121181049747`*^9, 3.795412150026815*^9, 3.795412228679063*^9, 
   3.795412348692094*^9, 3.795412742011969*^9, {3.795412788384037*^9, 
   3.795412812598016*^9}, 3.795414018089122*^9, 3.795414092446607*^9, 
   3.795588818223545*^9, 3.795588860449942*^9, 3.7955889242959557`*^9, 
   3.800991664179344*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"74c5cb9e-874f-473e-8db5-aa02d7c0446e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"kt", "-", "kx"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"kt", "+", "kx"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"kx", " ", 
      RowBox[{"(", 
       RowBox[{"ky", "-", "kz"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"ky", "+", "kz"}], ")"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"kx", "-", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kt", "2"], "+", 
        SuperscriptBox["kx", "2"]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.7954121181049747`*^9, 3.795412150026815*^9, 3.795412228679063*^9, 
   3.795412348692094*^9, 3.795412742011969*^9, {3.795412788384037*^9, 
   3.795412812598016*^9}, 3.795414018089122*^9, 3.795414092446607*^9, 
   3.795588818223545*^9, 3.795588860449942*^9, 3.7955889242959557`*^9, 
   3.800991665564348*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"f8674560-7ccc-4ba3-a3e2-67e4ee1aab33"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SqrtBox["3"], " ", 
   RowBox[{"(", 
    RowBox[{"kt", "-", "kx"}], ")"}], " ", "kx", " ", 
   RowBox[{"(", 
    RowBox[{"kt", "+", "kx"}], ")"}], " ", 
   SuperscriptBox["ky", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"kx", "-", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kt", "2"], "+", 
        SuperscriptBox["kx", "2"]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.7954121181049747`*^9, 3.795412150026815*^9, 3.795412228679063*^9, 
   3.795412348692094*^9, 3.795412742011969*^9, {3.795412788384037*^9, 
   3.795412812598016*^9}, 3.795414018089122*^9, 3.795414092446607*^9, 
   3.795588818223545*^9, 3.795588860449942*^9, 3.7955889242959557`*^9, 
   3.800991666721527*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"7a393f92-3eba-4d06-8456-e63b62da80ee"],

Cell[BoxData["\<\"transmission\"\>"], "Print",
 CellChangeTimes->{3.795588925783442*^9, 3.8009916667250977`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"34909451-9c9e-471a-873d-164644667b62"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx"}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      SuperscriptBox["kx", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.7954121181049747`*^9, 3.795412150026815*^9, 3.795412228679063*^9, 
   3.795412348692094*^9, 3.795412742011969*^9, {3.795412788384037*^9, 
   3.795412812598016*^9}, 3.795414018089122*^9, 3.795414092446607*^9, 
   3.795588818223545*^9, 3.795588860449942*^9, 3.7955889242959557`*^9, 
   3.800991667712681*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"05da61c5-31b9-46f1-9627-516c8d12fa1c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7954121181049747`*^9, 3.795412150026815*^9, 3.795412228679063*^9, 
   3.795412348692094*^9, 3.795412742011969*^9, {3.795412788384037*^9, 
   3.795412812598016*^9}, 3.795414018089122*^9, 3.795414092446607*^9, 
   3.795588818223545*^9, 3.795588860449942*^9, 3.7955889242959557`*^9, 
   3.800991668608706*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"8b7a4d1a-f18a-47cd-b1c8-1294c9d8ba3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"en", " ", "<", " ", "V"}], ";", " ", 
    RowBox[{
     RowBox[{"mathematica", "'"}], "s", " ", "basis"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"hbar", "=", "1"}], ";", 
    RowBox[{"m", "=", "1"}], ";", 
    RowBox[{"v", "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox["hbar", "2"], 
       RowBox[{"2", "m"}]], "2", "kl"}]}], ";", 
    RowBox[{"vs", "=", "1"}], 
    RowBox[{"(*", 
     RowBox[{"=", 
      RowBox[{
       FractionBox[
        SuperscriptBox["hbar", "2"], 
        RowBox[{"2", "m"}]], "2", 
       RowBox[{"Abs", "[", "kt", "]"}]}]}], "*)"}], ";", 
    RowBox[{"Clear", "[", 
     RowBox[{
     "a1", ",", "a2", ",", "b1", ",", "b2", ",", "v", ",", "vs", ",", "t1", 
      ",", "t2", ",", "r1", ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", 
      "\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]1", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["3"], " ", "kx"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"], " ", "ky"}]}], ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "0", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]2", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["kz", "2"]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]3", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]4", "[", "kx_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], 
           ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy1", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"\[Psi]1", "[", "kx", "]"}], "+", 
         RowBox[{"r1", " ", 
          RowBox[{"\[Psi]1", "[", 
           RowBox[{"-", "kx"}], "]"}]}], "+", 
         RowBox[{"r2", " ", 
          RowBox[{"\[Psi]2", "[", 
           RowBox[{"-", "kx"}], "]"}], "  "}]}], 
        SqrtBox["v"]], "-", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a1", " ", 
           RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
          RowBox[{"a2", " ", 
           RowBox[{"\[Psi]4", "[", "kt", "]"}]}], "+", 
          RowBox[{"b1", " ", 
           RowBox[{"\[Psi]3", "[", 
            RowBox[{"-", "kt"}], "]"}]}], "+", 
          RowBox[{"b2", "  ", 
           RowBox[{"\[Psi]4", "[", 
            RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
        SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy2", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
            RowBox[{"a2", " ", 
             RowBox[{"\[Psi]4", "[", "kt", "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b1", " ", 
             RowBox[{"\[Psi]3", "[", 
              RowBox[{"-", "kt"}], "]"}]}], "+", 
            RowBox[{"b2", "  ", 
             RowBox[{"\[Psi]4", "[", 
              RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
        SqrtBox["vs"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"t1", " ", 
          RowBox[{"\[Psi]1", "[", "kx", "]"}]}], "+", 
         RowBox[{"t2", " ", 
          RowBox[{"\[Psi]2", "[", "kx", "]"}], "  "}]}], 
        SqrtBox["v"]]}], "//", "Simplify"}]}], ";", 
    RowBox[{"sol", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
        "r1", ",", "r2", ",", "t1", ",", "t2", ",", "a1", ",", "a2", ",", 
         "b1", ",", "b2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"rp1", "=", 
    RowBox[{
     RowBox[{"r1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"rp2", "=", 
    RowBox[{
     RowBox[{"r2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<transmission\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"tp1", "=", 
    RowBox[{
     RowBox[{"t1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"tp2", "=", 
    RowBox[{
     RowBox[{"t2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "sol", "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}], "}"}]}], "//", 
     "FullSimplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.795345711778309*^9, 3.79534571771926*^9}, {
  3.7954117189360027`*^9, 3.795411750253563*^9}, {3.7954117899241962`*^9, 
  3.795411962019146*^9}, {3.795411995669647*^9, 3.7954121376450768`*^9}, {
  3.7954122123419123`*^9, 3.795412219416184*^9}, {3.795412315463717*^9, 
  3.795412345296678*^9}, {3.7954131552222033`*^9, 3.795413156056336*^9}, {
  3.795413839984623*^9, 3.795413856544154*^9}, {3.795414047428824*^9, 
  3.795414060985321*^9}, {3.7954141482175303`*^9, 3.7954141756907673`*^9}, {
  3.795588899937092*^9, 3.795588900874958*^9}},
 CellLabel->
  "In[212]:=",ExpressionUUID->"51e7a834-8a15-4eff-b1b4-dc6ebd91512e"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r1", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["kt", "2"], " ", 
                  SuperscriptBox["kx", "3"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]], " ", 
                  SuperscriptBox["kt", "2"], " ", 
                  SuperscriptBox["kx", "3"]}], "+", 
                 TemplateBox[{"54"},
                  "OutputSizeLimit`Skeleton"], "+", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], "-", 
                 RowBox[{"4", " ", "\[ImaginaryI]", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]], 
                  " ", "ky", " ", 
                  SuperscriptBox["kz", "4"]}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"kx", "-", 
                   RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["kt", "2"], " ", 
                    SuperscriptBox["kx", "2"]}], "+", 
                   TemplateBox[{"25"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"2", " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"], " ", "L"}]], " ", 
                    SuperscriptBox["kz", "4"]}]}], ")"}]}]]}], "+", 
              FractionBox[
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"]]}]}], ",", 
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"b2", "\[Rule]", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{29.390625, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 218, 23305547363931551179, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{32.709374999999994`, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 218, 23305547363931551179, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{24.328125, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 218, 23305547363931551179, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{43.457812499999996`, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23305547363931551179 === $SessionID, 
   Out[218], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.795414210181383*^9, 3.7955889612345963`*^9},
 CellLabel->
  "Out[218]=",ExpressionUUID->"cf75941f-f7bc-47b2-9fb3-8edf4002f457"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
            SuperscriptBox["ky", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kt", "2"], "+", 
         SuperscriptBox["kx", "2"], "-", 
         RowBox[{"6", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["ky", "2"]}]}], ")"}], " ", 
       SuperscriptBox["kz", "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       SuperscriptBox["kz", "4"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"kx", "-", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       
       RowBox[{"Sin", "[", 
        RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.795414210181383*^9, 3.795588965915348*^9},
 CellLabel->
  "Out[219]=",ExpressionUUID->"c8848d86-46e4-4687-9563-9886a18e6e44"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
      " ", "kx", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["kt", "2"], " ", 
         SuperscriptBox["kx", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["kx", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["ky", "2"]}], "+", 
           SuperscriptBox["kz", "2"]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["ky", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
         
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["kx", "2"]}], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.795414210181383*^9, 3.795588969083353*^9},
 CellLabel->
  "Out[220]=",ExpressionUUID->"88c61c92-188a-4fa2-b3c6-e618f190a342"],

Cell[BoxData["\<\"transmission\"\>"], "Print",
 CellChangeTimes->{3.7955889690854397`*^9},
 CellLabel->
  "During evaluation of \
In[212]:=",ExpressionUUID->"15ab8942-48a4-4d4f-9f72-a1d7f9b4e786"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"12", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", "kt", " ", "kx", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
     " ", "kt", " ", "kx", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
     " ", 
     SuperscriptBox["kt", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
     " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.795414210181383*^9, 3.795588969625587*^9},
 CellLabel->
  "Out[222]=",ExpressionUUID->"05017bc7-f7dc-4a85-bfb1-d73cf66e45aa"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.795414210181383*^9, 3.795588970421625*^9},
 CellLabel->
  "Out[223]=",ExpressionUUID->"7dd14c1e-24ce-496d-bd89-bf27700b656c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{" ", 
       RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], ")"}], " ", 
   "/", "2"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8010278937190313`*^9, 3.8010279228114843`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"b6ba3c63-b16a-4412-b1ad-82d4dd0244aa"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"kt", " ", "L"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.801027903526074*^9, 3.801027923334633*^9}},
 CellLabel->"Out[56]=",ExpressionUUID->"6665eb44-c30a-4ab8-8f3f-4b03bf07d821"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{" ", 
        RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], ")"}], " ", 
    
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
             SuperscriptBox["ky", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["ky", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["kx", "2"], "-", 
          RowBox[{"6", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["ky", "2"]}]}], ")"}], " ", 
        SuperscriptBox["kz", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        SuperscriptBox["kz", "4"]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kt", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox["kx", "2"]}], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}], ")"}]}]}], 
   "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
             SuperscriptBox["ky", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["ky", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["kx", "2"], "-", 
          RowBox[{"6", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["ky", "2"]}]}], ")"}], " ", 
        SuperscriptBox["kz", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        SuperscriptBox["kz", "4"]}]}], ")"}], "/", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kt", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox["kx", "2"]}], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}], ")"}]}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.801027584964448*^9, 3.801027609026561*^9}, {
  3.801027662158609*^9, 3.801027778271483*^9}, {3.801027812049773*^9, 
  3.801027865126704*^9}, {3.801027929459641*^9, 3.8010279573612127`*^9}, {
  3.8010282633018913`*^9, 3.8010282706307783`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"af5860df-1f46-4858-9e18-063b3d31d3ab"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.801027609928873*^9, 3.801027695122097*^9, 3.8010277362933083`*^9, {
   3.801027796459186*^9, 3.801027866876399*^9}, {3.8010279309767323`*^9, 
   3.80102795903011*^9}, 3.8010282826877413`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"1d32c158-3d37-4dba-afa1-d89f01113d25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
            SuperscriptBox["ky", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["ky", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kt", "2"], "+", 
         SuperscriptBox["kx", "2"], "-", 
         RowBox[{"6", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["ky", "2"]}]}], ")"}], " ", 
       SuperscriptBox["kz", "2"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       SuperscriptBox["kz", "4"]}]}], ")"}], "/", 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
         
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["kx", "2"]}], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"kt", " ", "L"}], "]"}]}]}], ")"}]}], ")"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8010281923635178`*^9, 3.8010281954167137`*^9}, {
  3.8010283275060863`*^9, 3.8010283364441032`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"5fd6f5ae-5070-4fe1-8a25-bd22c193b1a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["kt", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["kx", "2"]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
        SuperscriptBox["ky", "2"]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["ky", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["kx", "2"]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["ky", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["kt", "2"], "+", 
     SuperscriptBox["kx", "2"], "-", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["ky", "2"]}]}], ")"}], " ", 
   SuperscriptBox["kz", "2"]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
   SuperscriptBox["kz", "4"]}]}]], "Output",
 CellChangeTimes->{
  3.801028196451878*^9, {3.8010283293128567`*^9, 3.801028337582868*^9}},
 CellLabel->"Out[63]=",ExpressionUUID->"cd7c3280-d1c8-4b73-8f51-b08508dbd28b"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"3cc35f46-4278-4132-8a61-bbc0df2373e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["using ORTHOGONAL eigenvectors", "Section",
 CellChangeTimes->{{3.79198869646707*^9, 3.7919886987400312`*^9}, {
  3.795527017643969*^9, 3.7955270233652782`*^9}, {3.795529836722404*^9, 
  3.795529840724917*^9}},ExpressionUUID->"dcd6ed1a-a2ce-430f-8d67-\
281deebb3db6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"exp1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp2", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"kz", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp4", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n1", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Norm", "[", "exp1", "]"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
        " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n2", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Norm", "[", "exp2", "]"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
        " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n3", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Norm", "[", "exp3", "]"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
        " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n4", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Norm", "[", "exp4", "]"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
        " ", "Reals"}], " ", "&&", " ", 
       RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.79552642106962*^9, 3.795526425309301*^9}, {
  3.7955266708454113`*^9, 3.795526698805237*^9}, {3.7955270381409273`*^9, 
  3.795527078756143*^9}, {3.795527141709333*^9, 3.79552718242925*^9}, {
  3.801107322408593*^9, 3.8011073334746313`*^9}, {3.801107473359651*^9, 
  3.801107473557008*^9}, {3.801107546957209*^9, 
  3.8011075775567427`*^9}},ExpressionUUID->"cbf46c75-dbd8-43a9-838c-\
576c8c3bd87c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp2", "]"}], ".", "exp3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp2", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp3", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7955264340908957`*^9, 3.7955264670475063`*^9}, {
  3.795526731519496*^9, 3.795526742098755*^9}, {3.795526787182971*^9, 
  3.7955268047562943`*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"733d0ab4-9bcb-4515-92da-94c59fbe4ce6"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.801107463052269*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"4805991f-5ee6-4ed3-9aa2-3b9f94e8edec"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.8011074631367207`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"93a478fe-412e-49b7-9d3a-691e72739ac8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.8011074632036657`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"80a35667-818b-470f-974f-005000967f7f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.801107463287284*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"2f3d4238-c7cc-45e4-a2c0-204620bfc90b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.801107463369804*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"fe06ac6b-9e18-4aaa-b22e-b7343354df9c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}, 3.801107463455689*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"a135bdbe-5af6-4d94-9dc1-b1bce4cb0a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"en", " ", "<", " ", "V"}], ";", " ", 
    RowBox[{"orthogonal", " ", "basis"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "a1", ",", "a2", ",", "b1", ",", "b2", ",", "v", ",", "vs", ",", "t1", 
      ",", "t2", ",", "r1", ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", 
      "\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4"}], "]"}], ";", 
    RowBox[{"v", "=", "1"}], ";", 
    RowBox[{"vs", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]1", "[", "kx_", "]"}], "=", "exp3"}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]2", "[", "kx_", "]"}], "=", "exp4"}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]3", "[", "kx_", "]"}], "=", "exp1"}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]4", "[", "kx_", "]"}], "=", "exp2"}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy1", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"\[Psi]1", "[", "kx", "]"}], "+", 
         RowBox[{"r1", " ", 
          RowBox[{"\[Psi]1", "[", 
           RowBox[{"-", "kx"}], "]"}]}], "+", 
         RowBox[{"r2", " ", 
          RowBox[{"\[Psi]2", "[", 
           RowBox[{"-", "kx"}], "]"}], "  "}]}], 
        SqrtBox["v"]], "-", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a1", " ", 
           RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
          RowBox[{"a2", " ", 
           RowBox[{"\[Psi]4", "[", "kt", "]"}]}], "+", 
          RowBox[{"b1", " ", 
           RowBox[{"\[Psi]3", "[", 
            RowBox[{"-", "kt"}], "]"}]}], "+", 
          RowBox[{"b2", "  ", 
           RowBox[{"\[Psi]4", "[", 
            RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
        SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy2", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
            RowBox[{"a2", " ", 
             RowBox[{"\[Psi]4", "[", "kt", "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b1", " ", 
             RowBox[{"\[Psi]3", "[", 
              RowBox[{"-", "kt"}], "]"}]}], "+", 
            RowBox[{"b2", "  ", 
             RowBox[{"\[Psi]4", "[", 
              RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
        SqrtBox["vs"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"t1", " ", 
          RowBox[{"\[Psi]1", "[", "kx", "]"}]}], "+", 
         RowBox[{"t2", " ", 
          RowBox[{"\[Psi]2", "[", "kx", "]"}], "  "}]}], 
        SqrtBox["v"]]}], "//", "Simplify"}]}], ";", 
    RowBox[{"sol", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
        "r1", ",", "r2", ",", "t1", ",", "t2", ",", "a1", ",", "a2", ",", 
         "b1", ",", "b2"}], "}"}]}], "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.795345711778309*^9, 3.79534571771926*^9}, {
  3.7954117189360027`*^9, 3.795411750253563*^9}, {3.7954117899241962`*^9, 
  3.795411962019146*^9}, {3.795411995669647*^9, 3.7954121376450768`*^9}, {
  3.7954122123419123`*^9, 3.795412219416184*^9}, {3.795412315463717*^9, 
  3.795412345296678*^9}, {3.7954131552222033`*^9, 3.795413156056336*^9}, {
  3.795413839984623*^9, 3.795413856544154*^9}, {3.795414047428824*^9, 
  3.795414060985321*^9}, {3.7954141482175303`*^9, 3.7954141756907673`*^9}, {
  3.795527198039268*^9, 3.795527244524557*^9}, {3.795527470481882*^9, 
  3.795527470734079*^9}, {3.7955283422388287`*^9, 3.7955283463804827`*^9}, {
  3.83187281794007*^9, 
  3.8318728184749527`*^9}},ExpressionUUID->"0c8f8363-d00e-4cd1-afec-\
bff91a6f6214"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r1", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", "kx", " ", "kz"}], "-", 
                 RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"kx", "-", 
                   RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]]}], "-", 
              FractionBox[
               RowBox[{"2", " ", 
                TemplateBox[{"5"},
                 "OutputSizeLimit`Skeleton"], " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"kt", "-", 
                  RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}]}]], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", "kt", " ", 
                    "L"}]], " ", 
                    TemplateBox[{"3"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], 
                    RowBox[{
                    SqrtBox["3"], " ", 
                    RowBox[{"(", 
                    RowBox[{"kx", "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], 
                    RowBox[{"kt", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], "-", 
                   FractionBox[
                    RowBox[{"2", " ", 
                    TemplateBox[{"5"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                    RowBox[{"kt", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ")"}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"kz", "+", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["kt", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], 
                    RowBox[{"kt", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], "-", 
                    FractionBox[
                    RowBox[{"kz", "+", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["kt", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], 
                    RowBox[{"kt", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["kt", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    RowBox[{"2", " ", "kz", " ", 
                    RowBox[{"(", 
                    RowBox[{"kz", "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]}], ")"}]}], 
                    RowBox[{
                    SqrtBox["3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"kt", "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], "2"]}]]}], "+", 
                    FractionBox[
                    RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], 
                    RowBox[{
                    SqrtBox["3"], " ", 
                    SuperscriptBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "2"]}]]}], ")"}]}], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"kt", "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"]}], "-", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], ")"}]}]}]}], ",", 
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"b2", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]]}], "+", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{29.390625, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 406, 23341227954252589688, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{32.709374999999994`, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 406, 23341227954252589688, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 406, 23341227954252589688, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{43.457812499999996`, {0., 5.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23341227954252589688 === $SessionID, 
   Out[406], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.7955273065401287`*^9, 3.795527525336753*^9, 
  3.7955284131760197`*^9, 3.8010302045946617`*^9, 3.801030328253524*^9},
 CellLabel->
  "Out[406]=",ExpressionUUID->"964cb94c-aa4d-46a5-92cc-bdec3875fe37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"t1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"tp2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"t2", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.7955274094093*^9, 3.795527415096715*^9}, {
  3.795527609897428*^9, 3.7955276127918262`*^9}, {3.795528199448922*^9, 
  3.7955282555021877`*^9}, {3.795528323816104*^9, 3.795528331046586*^9}, {
  3.795528426564168*^9, 3.7955284368602257`*^9}},
 CellLabel->
  "In[407]:=",ExpressionUUID->"00c401c3-5767-40a5-9431-df6295993d36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"12", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "kt"}]], " ", "kt", " ", "kx", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", "kt", 
     " ", "kx", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
     SuperscriptBox["kt", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.795527453476103*^9, 3.795527606481181*^9, 3.7955281800730257`*^9, {
   3.795528233149029*^9, 3.795528256904291*^9}, 3.7955283320043507`*^9, 
   3.7955284201303577`*^9, 3.795528636283792*^9, 3.795528870617135*^9, 
   3.801030506440864*^9},
 CellLabel->
  "Out[407]=",ExpressionUUID->"07907ddb-066b-43bc-8100-a980945e9a8a"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"", 2, 408, 2, 23341227954252589688, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7955291719043293`*^9, 3.8010308076394587`*^9},
 CellLabel->
  "During evaluation of \
In[407]:=",ExpressionUUID->"33f9ad41-a520-4667-b37f-85ab4d447c0f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.795527453476103*^9, 3.795527606481181*^9, 3.7955281800730257`*^9, {
   3.795528233149029*^9, 3.795528256904291*^9}, 3.7955283320043507`*^9, 
   3.7955284201303577`*^9, 3.795528636283792*^9, 3.795528870617135*^9, 
   3.8010309724756002`*^9},
 CellLabel->
  "Out[408]=",ExpressionUUID->"a4e016f4-e9bb-43e4-b31c-215c02d68b6a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"rp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"r1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"rp2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"r2", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.801030215482641*^9, 3.801030233865604*^9}},
 CellLabel->
  "In[409]:=",ExpressionUUID->"ee3def67-3313-4bcf-b540-be15e1e31192"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rp1", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
      FractionBox[
       RowBox[{"3", " ", "kx", " ", "kz"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]]}], 
     RowBox[{"kx", "-", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"6", " ", "kx", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"kt", " ", "kz"}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kt", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky"}], "-", 
            RowBox[{"3", " ", "kx", " ", 
             SuperscriptBox["ky", "2"]}], "-", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
            RowBox[{"kx", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kx", "2"], " ", "ky"}], "+", 
            SuperscriptBox["ky", "3"], "+", 
            RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
            RowBox[{"ky", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "-", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
         "2", " ", "\[ImaginaryI]", " ", "kt", " ", "ky", " ", "kz", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
         RowBox[{
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "-", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "kx", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
            RowBox[{"2", " ", "kx", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "5"}], " ", "kz"}], "+", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "kz"}], "+", 
               RowBox[{"2", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}], "-", 
            RowBox[{"kx", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "kz"}], "+", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["ky", "2"]}], ")"}], "2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
         RowBox[{
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "-", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8010664466079483`*^9, 3.8010664558699083`*^9}},
 CellLabel->"",ExpressionUUID->"bd7dd10e-7bdf-4f1f-a5d4-df8ee728bebe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rp2", "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"kx", "+", 
       FractionBox[
        RowBox[{"3", " ", "kx", " ", "kz"}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]]}], 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "kx", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kt", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
        "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "kz"}], "+", 
            RowBox[{"ky", " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
            RowBox[{"8", " ", "kx", " ", 
             SuperscriptBox["kz", "3"]}], "-", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
            RowBox[{"kx", " ", 
             SuperscriptBox["ky", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "8"}], " ", "kz"}], "+", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "5"}], " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
            RowBox[{"2", " ", "kx", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kz", "3"], "+", 
               RowBox[{
                SuperscriptBox["ky", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"kz", "-", 
                  RowBox[{"3", " ", 
                   SqrtBox[
                    RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["ky", "2"]}], ")"}], "2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
         RowBox[{
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "-", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"6", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"kt", " ", "kz"}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kt", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
            SuperscriptBox["ky", "2"], "-", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["kx", "2"], " ", "ky"}], "+", 
            RowBox[{"kx", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "3"], "+", 
               RowBox[{"ky", " ", "kz", " ", 
                RowBox[{"(", 
                 RowBox[{"kz", "-", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "ky", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["kx", "2"], " ", "ky"}], "-", 
            RowBox[{"2", " ", "ky", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
            RowBox[{"\[ImaginaryI]", " ", "kx", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                SuperscriptBox["ky", "2"]}], "+", 
               RowBox[{"kz", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3", " ", "kz"}], "+", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "-", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
         "2", " ", "\[ImaginaryI]", " ", "kt", " ", "ky", " ", "kz", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
         RowBox[{
          SuperscriptBox["kx", "2"], " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{"ky", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "-", 
               RowBox[{"3", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.801066468592463*^9, 3.801066474386189*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"26d827dd-a4ce-466c-a908-50f6db8a3107"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"rp1", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.801031581471187*^9, 3.8010315879016848`*^9}},
 CellLabel->
  "In[451]:=",ExpressionUUID->"aae8eaba-4a41-429a-bfb4-7d00380aa3da"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.80103190518353*^9},
 CellLabel->
  "Out[451]=",ExpressionUUID->"424b3031-3a67-44b7-affa-266d2ce310e6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"rp2", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.801031598050996*^9, 
  3.801031619828133*^9}},ExpressionUUID->"1534f966-5cba-494c-b20d-\
8ecb11f41b06"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"95d41a32-0d90-4a01-b4fa-a70df9f938bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2d Plots of T for kz=0", "Section",
 CellChangeTimes->{{3.79541585944456*^9, 3.795415862338043*^9}, {
  3.795430744961259*^9, 
  3.79543074967332*^9}},ExpressionUUID->"b94e6a26-7c80-4b04-badb-\
81322b95532a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rp1", "/.", 
   RowBox[{"kz", "\[Rule]", "0"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.801066483679192*^9, 3.801066494981373*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"9747f799-a987-460d-b5b0-5d2bd0028d96"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "ky", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox["kx", "2"], " ", 
       SuperscriptBox["ky", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["ky", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["kt", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         SuperscriptBox["ky", "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "kt", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
       SuperscriptBox["ky", "2"], " ", 
       RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kt", "2"], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          SuperscriptBox["ky", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8010664882268677`*^9, 3.801066496038145*^9}},
 CellLabel->"Out[20]=",ExpressionUUID->"484390b4-d3d2-4bae-93c7-cec1d3ce1c48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rp2", "/.", 
   RowBox[{"kz", "\[Rule]", "0"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.794990929199575*^9, 3.7949909424739933`*^9}, {
   3.794990982384509*^9, 3.794991139278957*^9}, {3.794991392642338*^9, 
   3.7949913943561497`*^9}, {3.7949922294622297`*^9, 3.794992249971951*^9}, {
   3.794992282826687*^9, 3.794992391006621*^9}, {3.7949924492682877`*^9, 
   3.7949924672111*^9}, {3.7949924978243647`*^9, 3.794992500850062*^9}, {
   3.794993880477866*^9, 3.79499397166394*^9}, {3.794994402845872*^9, 
   3.794994443474368*^9}, {3.794994984219358*^9, 3.794995037644314*^9}, {
   3.794995070300199*^9, 3.794995070987803*^9}, {3.794995807842152*^9, 
   3.794995849555065*^9}, {3.794995920866191*^9, 3.794995931053337*^9}, {
   3.794996084145514*^9, 3.79499611321902*^9}, {3.794999323766118*^9, 
   3.794999346310319*^9}, {3.7949994111393023`*^9, 3.794999469871377*^9}, {
   3.794999514754767*^9, 3.794999617813569*^9}, 3.795001355813862*^9, 
   3.7950064039278173`*^9, 3.795006445164651*^9, 3.795006564374877*^9, 
   3.795006668941828*^9, {3.795006802630272*^9, 3.795006819597292*^9}, {
   3.79500685762649*^9, 3.795006872777776*^9}, {3.795006998952065*^9, 
   3.795007031628867*^9}, 3.795007143557459*^9, {3.795007240855526*^9, 
   3.795007272736888*^9}, {3.795007673579121*^9, 3.7950076742154713`*^9}, {
   3.795007725242867*^9, 3.7950078480671873`*^9}, {3.795007897269895*^9, 
   3.795007924527179*^9}, {3.795008024692006*^9, 3.795008059630018*^9}, {
   3.7950713875592937`*^9, 3.795071422095038*^9}, {3.7950720250759287`*^9, 
   3.795072152172063*^9}, {3.7950722645153923`*^9, 3.7950723002987757`*^9}, {
   3.795131996770587*^9, 3.795132029539447*^9}, {3.795132090488356*^9, 
   3.795132130368556*^9}, {3.795132216978801*^9, 3.795132218610136*^9}, {
   3.7951322820635023`*^9, 3.7951322851695213`*^9}, {3.795317957360497*^9, 
   3.795318136882277*^9}, {3.795318172070588*^9, 3.795318190684725*^9}, {
   3.795318267199016*^9, 3.795318281973278*^9}, {3.795415928593409*^9, 
   3.795415983466795*^9}, {3.7954307023264027`*^9, 3.7954307052281017`*^9}, {
   3.795430753408766*^9, 3.7954307573201036`*^9}, {3.795537077757193*^9, 
   3.795537079921569*^9}, {3.801066560869631*^9, 3.801066564354321*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"80f19b14-e581-44f9-95bb-46dd1d4e1d44"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"kx", " ", 
    RowBox[{"(", 
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kt", "2"], " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["kt", "2"]}], "+", 
         SuperscriptBox["kx", "2"]}], ")"}], " ", 
       SuperscriptBox["ky", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "kt", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
       SuperscriptBox["ky", "2"], " ", 
       RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kt", "2"], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          SuperscriptBox["ky", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.801066565133885*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"a4a859be-bd49-4f0e-ad54-68e927e43a1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"V", " ", ">", " ", 
     RowBox[{"en", " ", "case"}]}], ";", " ", 
    FractionBox[
     RowBox[{"12", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", "kt", " ", "kx", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}]}], 
     RowBox[{
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", "kt", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", 
       SuperscriptBox["kt", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}]]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"tamp", ",", "tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ramp1", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "ky", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["kx", "2"], " ", 
          SuperscriptBox["ky", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["ky", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kt", "2"], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kt", "2"], "+", 
               SuperscriptBox["kx", "2"]}], ")"}], " ", 
             SuperscriptBox["ky", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
          RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ramp2", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"kx", " ", 
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kt", "2"], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", 
             SuperscriptBox["kt", "2"]}], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          SuperscriptBox["ky", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kt", "2"], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kt", "2"], "+", 
               SuperscriptBox["kx", "2"]}], ")"}], " ", 
             SuperscriptBox["ky", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
          RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tamp", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"12", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", "kt", " ", 
        "kx", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
          ")"}], " ", "kt", " ", "kx", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
          ")"}], " ", 
         SuperscriptBox["kt", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["kx", "2"]}], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}], 
      "}"}]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"tamp", "[", 
          RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 0.1 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"gr1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
    
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 0.1 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3dTimage11.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<3dRimage11.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "1"}], "]"}], "]"}], 
          "2"], "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1.0", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"g1", "=", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PolarAxes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"PolarTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "3"}]}], ",", 
            RowBox[{
             RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "6"}]}], ",", 
            RowBox[{
             RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "6"}], ",", 
            RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "3"}], ",", 
            RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"(*", "****)"}], 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
     RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.05"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0.8"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"gr1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
    
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3dTimage12.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<3dRimage12.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.06"}], ",", "0.62"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.65"}], ",", "0.65"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"gr1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
    
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3dTimage13.jpg\>\"", ",", "g1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3dRimage13.jpg\>\"", ",", "gr1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}]}], "Input",
 CellChangeTimes->{{3.795430800710774*^9, 3.795430822601384*^9}, {
   3.795536541874064*^9, 3.795536552149109*^9}, {3.795536620764089*^9, 
   3.795536744273285*^9}, {3.795536797270541*^9, 3.795536802699469*^9}, {
   3.79553683612189*^9, 3.795536895879795*^9}, {3.795537146916971*^9, 
   3.79553721567351*^9}, {3.79553728580947*^9, 3.795537291906273*^9}, {
   3.795537335423833*^9, 3.7955373696821203`*^9}, {3.795537426011786*^9, 
   3.795537552613689*^9}, {3.795537647471653*^9, 3.79553766345883*^9}, {
   3.7955377141074743`*^9, 3.795537759716449*^9}, {3.7955377985586767`*^9, 
   3.79553791021973*^9}, 3.79553803779771*^9, {3.795538078841715*^9, 
   3.795538145298633*^9}, {3.795538221195356*^9, 3.795538222939136*^9}, {
   3.795538334017047*^9, 3.7955383838265533`*^9}, {3.795538440952417*^9, 
   3.795538499483881*^9}, {3.795538534165786*^9, 3.795538602012644*^9}, {
   3.795538638700178*^9, 3.79553865904891*^9}, {3.795538694069201*^9, 
   3.7955387688538933`*^9}, {3.795538883948126*^9, 3.7955388851899*^9}, {
   3.795538968092092*^9, 3.7955390289951572`*^9}, {3.795539067334662*^9, 
   3.795539086888975*^9}, {3.795539127441719*^9, 3.795539128889134*^9}, {
   3.795637917023027*^9, 3.795637945259872*^9}, 3.795638045633629*^9, {
   3.795638179567995*^9, 3.795638192688788*^9}, {3.8009840842161417`*^9, 
   3.800984088459092*^9}, {3.8010289737954893`*^9, 3.801029622617062*^9}, {
   3.801029704134108*^9, 3.801029709321169*^9}, {3.801029781821578*^9, 
   3.8010297870448303`*^9}, {3.801029827155061*^9, 3.8010298444603*^9}, 
   3.801029883630678*^9, {3.801029976316733*^9, 3.8010299801280622`*^9}, {
   3.801030016443768*^9, 3.80103003370991*^9}, {3.801030067649184*^9, 
   3.801030069474721*^9}, {3.801031514894157*^9, 3.8010315390824966`*^9}, {
   3.801032148626533*^9, 3.801032288126339*^9}, {3.801032321453076*^9, 
   3.8010323289533863`*^9}, {3.801066592187776*^9, 3.801066609020876*^9}, {
   3.80106670498249*^9, 3.801066771306635*^9}, {3.801066887472427*^9, 
   3.801066912866459*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"1347133c-38d1-4dff-ab27-36653de82d2d"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9910463815706032}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4955231907853016, -0.8582713427687885}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8582713427687885, -0.4955231907853016}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9910463815706032, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8582713427687885, 0.4955231907853016}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4955231907853016, 0.8582713427687885}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9910463815706032}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.19820927631412066, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.3964185526282413, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.594627828942362, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7928371052564827, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmnc4V2/cx43MRCqlIiNJkoyMiI9VZBQhSUhGZBYSkVFWRNmjkF3JKnvc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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9910463815706032}], 
         Scaled[{0., -0.006}, {0., -0.9910463815706032}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4955231907853016, -0.8582713427687885}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.4955231907853016, -0.8582713427687885}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8582713427687885, -0.4955231907853016}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8582713427687885, -0.4955231907853016}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9910463815706032, 0.}], 
         Scaled[{0.006, 0.}, {0.9910463815706032, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8582713427687885, 0.4955231907853016}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8582713427687885, 
          0.4955231907853016}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4955231907853016, 0.8582713427687885}], 
         Scaled[{0.003, 0.005196152422706632}, {0.4955231907853016, 
          0.8582713427687885}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9910463815706032}], 
         Scaled[{0., 0.006}, {0., 0.9910463815706032}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9910463815706032}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.4955231907853016, -0.8582713427687885}], 
        Offset[{4, -6.928203230275509}, {
         0.4955231907853016, -0.8582713427687885}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8582713427687885, -0.4955231907853016}], 
        Offset[{6.928203230275509, -4}, {
         0.8582713427687885, -0.4955231907853016}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9910463815706032, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8582713427687885, 
         0.4955231907853016}], 
        Offset[{6.928203230275509, 4}, {0.8582713427687885, 
         0.4955231907853016}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.4955231907853016, 
         0.8582713427687885}], 
        Offset[{4, 6.928203230275509}, {0.4955231907853016, 
         0.8582713427687885}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9910463815706032}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9910463815706032, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 0.1 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.801066953118043*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"572b7ff1-803c-463d-ad84-0fb86f7ca010"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9999999999943573}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.49999999999717865`, -0.8660254037795518}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037795518, -0.49999999999717865`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9999999999943573, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037795518, 0.49999999999717865`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.49999999999717865`, 0.8660254037795518}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9999999999943573}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.19999999999887147, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.39999999999774294, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5999999999966144, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7999999999954859, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwkmnc819/3wJEyKg0rOxRRIpISjqSMShkRoSUjewvZO3vvvd72m7c9rr33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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9999999999943573}], 
         Scaled[{0., -0.006}, {0., -0.9999999999943573}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.49999999999717865`, -0.8660254037795518}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.49999999999717865`, -0.8660254037795518}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037795518, -0.49999999999717865`}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8660254037795518, -0.49999999999717865`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9999999999943573, 0.}], 
         Scaled[{0.006, 0.}, {0.9999999999943573, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037795518, 0.49999999999717865`}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8660254037795518, 
          0.49999999999717865`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.49999999999717865`, 0.8660254037795518}], 
         Scaled[{0.003, 0.005196152422706632}, {0.49999999999717865`, 
          0.8660254037795518}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9999999999943573}], 
         Scaled[{0., 0.006}, {0., 0.9999999999943573}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9999999999943573}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.49999999999717865`, -0.8660254037795518}], 
        Offset[{4, -6.928203230275509}, {
         0.49999999999717865`, -0.8660254037795518}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8660254037795518, -0.49999999999717865`}], 
        Offset[{6.928203230275509, -4}, {
         0.8660254037795518, -0.49999999999717865`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9999999999943573, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8660254037795518, 
         0.49999999999717865`}], 
        Offset[{6.928203230275509, 4}, {0.8660254037795518, 
         0.49999999999717865`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.49999999999717865`, 
         0.8660254037795518}], 
        Offset[{4, 6.928203230275509}, {0.49999999999717865`, 
         0.8660254037795518}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9999999999943573}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9999999999943573, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 0.1 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.8010669541631727`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"0eac016f-3f3e-47d7-8da6-75f881b4ef14"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9170266328061373}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.45851331640306864`, -0.7941683599570192}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.7941683599570192, -0.45851331640306864`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9170266328061373, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.7941683599570192, 0.45851331640306864`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.45851331640306864`, 0.7941683599570192}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9170266328061373}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.18340532656122746, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.3668106531224549, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5502159796836824, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7336213062449098, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxk2Hc8lt//B3Aqs4EolT0qUjJCifuNQkiyk+xRZpFdtoyIbJGsjGTLlmPv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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9170266328061373}], 
         Scaled[{0., -0.006}, {0., -0.9170266328061373}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.45851331640306864`, -0.7941683599570192}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.45851331640306864`, -0.7941683599570192}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.7941683599570192, -0.45851331640306864`}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.7941683599570192, -0.45851331640306864`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9170266328061373, 0.}], 
         Scaled[{0.006, 0.}, {0.9170266328061373, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.7941683599570192, 0.45851331640306864`}], 
         Scaled[{0.005196152422706632, 0.003}, {0.7941683599570192, 
          0.45851331640306864`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.45851331640306864`, 0.7941683599570192}], 
         Scaled[{0.003, 0.005196152422706632}, {0.45851331640306864`, 
          0.7941683599570192}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9170266328061373}], 
         Scaled[{0., 0.006}, {0., 0.9170266328061373}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9170266328061373}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.45851331640306864`, -0.7941683599570192}], 
        Offset[{4, -6.928203230275509}, {
         0.45851331640306864`, -0.7941683599570192}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.7941683599570192, -0.45851331640306864`}], 
        Offset[{6.928203230275509, -4}, {
         0.7941683599570192, -0.45851331640306864`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9170266328061373, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.7941683599570192, 
         0.45851331640306864`}], 
        Offset[{6.928203230275509, 4}, {0.7941683599570192, 
         0.45851331640306864`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.45851331640306864`, 
         0.7941683599570192}], 
        Offset[{4, 6.928203230275509}, {0.45851331640306864`, 
         0.7941683599570192}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9170266328061373}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9170266328061373, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.05}, {-1.1, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.8010670515753193`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"117eb8c9-87af-4dde-ae6c-1d20d70764a0"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9999999999992993}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.49999999999964967`, -0.8660254037838319}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037838319, -0.49999999999964967`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9999999999992993, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037838319, 0.49999999999964967`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.49999999999964967`, 0.8660254037838319}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9999999999992993}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.19999999999985987, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.39999999999971975, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5999999999995796, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7999999999994395, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJztu/c/1u///48Glax4IhRRIqEhmXepVEaSLTMrDaMSSUkZZSSrQUYZGdmb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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large], LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], \
{{}, {}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9999999999992993}], 
         Scaled[{0., -0.006}, {0., -0.9999999999992993}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.49999999999964967`, -0.8660254037838319}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.49999999999964967`, -0.8660254037838319}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037838319, -0.49999999999964967`}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8660254037838319, -0.49999999999964967`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9999999999992993, 0.}], 
         Scaled[{0.006, 0.}, {0.9999999999992993, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037838319, 0.49999999999964967`}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8660254037838319, 
          0.49999999999964967`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.49999999999964967`, 0.8660254037838319}], 
         Scaled[{0.003, 0.005196152422706632}, {0.49999999999964967`, 
          0.8660254037838319}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9999999999992993}], 
         Scaled[{0., 0.006}, {0., 0.9999999999992993}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9999999999992993}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.49999999999964967`, -0.8660254037838319}], 
        Offset[{4, -6.928203230275509}, {
         0.49999999999964967`, -0.8660254037838319}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8660254037838319, -0.49999999999964967`}], 
        Offset[{6.928203230275509, -4}, {
         0.8660254037838319, -0.49999999999964967`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9999999999992993, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8660254037838319, 
         0.49999999999964967`}], 
        Offset[{6.928203230275509, 4}, {0.8660254037838319, 
         0.49999999999964967`}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.49999999999964967`, 
         0.8660254037838319}], 
        Offset[{4, 6.928203230275509}, {0.49999999999964967`, 
         0.8660254037838319}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9999999999992993}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9999999999992993, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.801067052197399*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"84cd7ef0-77ec-422b-898c-6c8a705100f6"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.5252528982475994}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.2626264491237997, -0.45488235329382387`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.45488235329382387`, -0.2626264491237997}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.5252528982475994, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.45488235329382387`, 0.2626264491237997}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.2626264491237997, 0.45488235329382387`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.5252528982475994}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.10505057964951987, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.21010115929903975, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.31515173894855963, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.4202023185980795, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxk2mVUVs/XMGBAUgQUQUFQFEEQUBrJe6N0KCUgIh2CpHSXNNLS3SkdkkN3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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.5252528982475994}], 
         Scaled[{0., -0.006}, {0., -0.5252528982475994}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.2626264491237997, -0.45488235329382387`}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.2626264491237997, -0.45488235329382387`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.45488235329382387`, -0.2626264491237997}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.45488235329382387`, -0.2626264491237997}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.5252528982475994, 0.}], 
         Scaled[{0.006, 0.}, {0.5252528982475994, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.45488235329382387`, 0.2626264491237997}], 
         Scaled[{0.005196152422706632, 0.003}, {0.45488235329382387`, 
          0.2626264491237997}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.2626264491237997, 0.45488235329382387`}], 
         Scaled[{0.003, 0.005196152422706632}, {0.2626264491237997, 
          0.45488235329382387`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.5252528982475994}], 
         Scaled[{0., 0.006}, {0., 0.5252528982475994}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.5252528982475994}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.2626264491237997, -0.45488235329382387`}], 
        Offset[{4, -6.928203230275509}, {
         0.2626264491237997, -0.45488235329382387`}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.45488235329382387`, -0.2626264491237997}], 
        Offset[{6.928203230275509, -4}, {
         0.45488235329382387`, -0.2626264491237997}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.5252528982475994, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.45488235329382387`, 
         0.2626264491237997}], 
        Offset[{6.928203230275509, 4}, {0.45488235329382387`, 
         0.2626264491237997}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.2626264491237997, 
         0.45488235329382387`}], 
        Offset[{4, 6.928203230275509}, {0.2626264491237997, 
         0.45488235329382387`}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.5252528982475994}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.5252528982475994, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.5, 
       FormBox["0.5`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.06, 0.62}, {-0.65, 0.65}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.80106706633418*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"eefc87c3-7e0f-4d01-a755-b7f7a606c330"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.999999999998971}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4999999999994855, -0.8660254037835475}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037835475, -0.4999999999994855}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.999999999998971, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8660254037835475, 0.4999999999994855}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4999999999994855, 0.8660254037835475}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.999999999998971}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.19999999999979423, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.39999999999958846, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5999999999993827, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7999999999991769, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwkmnc81f/7/0VJklLvjIw0lNVSqSRXUYhQVFQoO0pWZSS7JKGyi5CRlT0y
n/Zex3bOwTnHODjjlZGV+J3P7/vX63bdXs9xva7nuO7X4/Y6YGqna8HOxsY2
uI2N7X9P3cL8+KWGHKX3MesbGxsYmrDSFQc3P8gy6t5J+4cho5e3tHxfhsGI
7a21zCUMrWoEdC6mfgO1a4r31Ris9gKG1j6Pk0B/urarfARDIT8Nq2NfpEG2
rIM4XxuGxi6FjPK7ZcGNbUWy1wsxxHdWVky0NBe2Pd3N9eQLhi4Up2+XPVUA
p2x+snu8wpDk59tJpglFoHpUsey9AYY6ptr2MLeVwJuQrXJfT2Godcm+bt26
DB46Dg2XcmKov9WC1lRVAabuH2sWB5hoOePspxrOKni+gy/AKJmJHu/je/fr
aDVc4IaojWdMdC36684p5Rqw+Pr9OHaGiZq59Q4u6tfCjLuO++UlBvJMem0T
aFkHHGdjyrcVMZC7+96C28/qYeK1rI6ZAwMlJ8ZacNg1wLOUpk4rKQay6NXZ
0HrcCH+WHGXPjNARP2Mk7ve9JpBOOlxCDaEjG5W+oJ8qzcBeG345SYmOrkg8
rNOSaAH7UTu+4BkaaknY55Ow3gK+mPrWtlAaypfUGfTqbIXcX/XB/go0xHak
7HxbZBvEbVZLoo/MoI9b/mw81W+H5ysf2qS8Z9Dd2lOrd3g7ILq2kdP+wAzS
kthP8i3vAJ+imOI5NI1+DZg3/zPphEDVsg9Uw2nkmafzuW+9E/DlhQZvl6dQ
T9QeobDrXaAqxZzkCp1CfbuIG8EhXXAj8F1juuwUyl8i2r/AdcHgxss9afVU
tGJud8ZqJw7eaREklY2pSFG4fSrgOg4CYg48KlycRLsIq3+4vHAQ9N6kVDlk
Euk+3/N8bz4OWjaVB0hLTiJncx+OSQoOxHeF/fezegKdFV6OKNrZDedkUs5w
G06gtaMHTzRd6AbxsIPzXkvjKJzjxbtHJt1wPHX7IZ2wcbTI+6Ws+W03TNQc
/5sjN44+VxrgbqWz7AmRXFL3GCrN3KOp0dYNf6aD+flfjKGHFicStjK6oWdL
nMJboTHELYn9IvH0wHi1/C6zKgpywHnrHZftgVWhf/sI1hRkvF3URUOzB5TW
Fg4J8VPQ0ShRQohNDySqDC2q1JPRg4snr9573wPSpUJSHs5kNLvZ/w9bRg84
4Y/RJmTJ6Hvubn5SWw8MGaHxsAkSamXGiWv/7oHgnBXh+AQSGvIPvxe/txdi
qvdOCZiQEEiM35C61AsG05uxrYdJKInqe+e8VS8IRfc/YPaOos8JCSeEwnrh
ovSAQNfjUdSUYxyxp64Xil6eZ+RwjKKnXvUMm6Ve0Kwq5PVLHkGb3+qtGB3v
AzdhaZMz2iPoF/1C3BHrPnjDs3M86d8w6mi98GvlRx84urRJ5OYPIz+JZhon
rQ/0D2VVH7MfRskn1iJd5PqBaH1zYkpuGDU4+NY5efTDxaaHhPS/RPQli7Zf
sLMfAmu/Rsu3ENFY4klOr8MD8NJY9qbGNyLqdIsLqfIYgKOlnstxzkQUIbiS
Mj08AJsP7KYw7hDRpuVKCU7lQegvy79IPU9EGioRf4QzBkF7bneUojgRsZHz
z8oKDYGGtf/TmO1ElKtx0+z0hyG4f0M7IH+VgJoD5PykNuNh09jX98cYBMTb
9UKX3RsPs/oCyoUUAgpmq3v8k50AJYq+gn/wBBT61OAZfwABkLinVWQfAR25
fl5Z4j8iELc9b1XtJqD/zKQkKhOJQH43YpvVRUBvyrkp1eeGYe32NXU3lv0x
WmthR9cwRA8pP9LHEZB5nFWm+9MRWOIQ/jfP6q9ackJ3gmcUqvgsBjZ6CWhO
6sQ1kdxRwB4+UJEdIKBVSd8gV1kSLARZ35UdYvn/hsdYxIcEFsuhXIUs/7ye
myPDIRJkYLq6rwkEpPyvOX6/HJl1P7qoKbFszxdKNeofyLCcmnMin9VfNYS/
upRKhlhdidjofgKycE0+rH+VAi93VHnnsvyzilZ+sp5AgXJTd5WKFgIS/EQX
+Mg2BkJV0l3e1QRksLO9aubhGGj5LeY0FBJQthZJjI7G4Lbib9G7PwhohmvT
fgfxcTD3bOX7F05Ae09ELNzxHgdVX4ZRoDcB5T3ad/wlZRxo7f2VPdYEZFSa
1ZqpMgESX0Z/Z2gTUKAMRb83aQKwaZl6+gkCGqS1sTdumYQd4unyjjsIKMIz
DBlbTkJc1rCHMBWP7K8+Mn/RMAl5V45Kt5bj0Q/8r7ZxCSpYyR6TsQrGIz5B
pfW3flSQE1ylDz7Ao/i2EB15ChUcnxqZ7ZDAo//Kz35qV5qC1MldQn+mhxCH
pMp5yS9TIFhz4KJf+hByszd9f3BhCg4PCSXkWQ6hAsHJlugb03Ag2hL3SmwI
Tag+e/w0cRpkIrw2jeIG0cH/kqXdlqehff9DvlGvQYQJBjxM0pwB4Ued3j4y
gyhno2BrR8wMGMndtejBDaAKMs8mIm0GuGruao46DSAB0XMnCs/TQLtTS6KY
bwB9f6yaoOxLg/dV247YZfQjj9vr+XatNIgcJn8Ru9KPtsgfPCnNRwfbeG40
2t2HvJPUzU1v0yH/xJWAzkd9iLS97ML2cDpwHTv8fAetF2nIrKjs66FD8LmM
K2UOveiHcmCLPy8D2g6ol64t9CDjJkqbthoDjCRvP1563oNiFMXZbF8zwK7T
82b3bDfqd89soOQwoHKEJ7XwSTfyg8wD+WQGUNpSAlooOFTs9jRmbCcTtr8o
SlPQx6Hjnf9OuV9kggvb7u0nm7sQB4/mMX9zJljaTRf0nu9CV/9xb+YLZEKD
T0Rf0o1OVOK1ISuZzQQJuaOdSYc6kPUS+xyxiwlrjvznVxfbEE3XQenKbyYM
pfePzTe0omAeX5vHOzAo7Og8OhLagsQU5DdbSWLg6xP9kt24Ge2pMo/QvYLB
udyrW39INCH3FynPrhhgUHLjWQAvrQFNHflqqmGLAVaXOOmcVY/SeU6H+3lh
sL7ZgU/Mvg6x4f0Ut37G4JbTZcq5k7VoyKT48XQCBvO2XOzLzGqkaOjWdiUH
A/W2SMqHzCrk4+rhf6QCA5dz995d6a5EP/bcms9swmD/37KQ/OvliK913nG6
G4Mmqr9IASpB2YHu1zACBn/PGdZ6nilGPPs3HnSNYbD94fV+zdQCdKxrUS52
BoO9C6UUVeE85DllmG3+G4OHkZt85YSzUbLgx43TfzDQmDr1rHU9DX1VkPLi
X8GgLyzqahg5CTkY9CTtXcNAXOUj0cs/DhnbnJs4v47BqvHwrhWNcHS+YWvW
mw0MpjR12auE3yLT+NN3WRwHxyh3hbN3aqB3QuqCP1j24k2zgd4hHxBY3rTL
ndV/bq6kb096KPBJ8im+Yo0v8HSjuXgyFqrP7PCLY80/8GKf2VW+JJiej6wh
s/zzSOctjjyeBqnaaT3nZzGI97uSekgzC8avr6VE0zBw2L59/m5+LmxZ+HR3
aZy1PrYX1FwvF8Dse4UrKsOs+FnLWOLaiqCQvFPKthdj5RuF5lMGJcCXV3/H
rIW1XmuDCpaUMvDe/bN0N8Lg0Pv0O6efVEJSBYhb5WFw+/LX7TKuVXBVZf2m
ZhIGVoIrtdVl1aBQbnI9LQyDmFd7L535VwMrhhE2Nr4YfOWNybl9qQ68PFKz
ne0xKE/dc2D2VT2QiqvHSx6w4rvt2cOeXw3gXLSVJHQNA0KwjFj1fCOM7kgs
85LFYEex2m532WZQibDeNciHwaWxlQM1pi1QG/LtJPcfJghISyVoRbSCKftp
U/Z+JhD5Vb72NbRBlDhN4GcBE/RDF6R4F9pBW7xFcvkja78L7BlMFe2E3EcS
W3psmEAemPZPP9AFvptqpo4rs87Hzbjrj/K6YNTVYtsGPxOEnXDrrZdxIKCq
UX1+mgHFMboptW04+PDiT0HPLwYE2+edE73bDZv8lueb3zBAzpebkUXshjc6
iv8J3mSw8pNMsM6jHvhe+UatQoABaw5q5f2kHjAwX7UpI9JhTUH5kqgxiysi
fXYJxNGh9UXJtX8DvUBwXvceMKbDpur1Kl3tPnBNf1DJKUIHv1cnI/5W9UHk
81z73H4aSNaXTg+c6AeX0TjyZDAN7r39cr/lSz/MjqmM/bpKgx/fehR+bRqA
C78lfl1cnoG+5KSaAPMBOESM+vMmbQY2skSVpGtZXHBhh2mOwQxUuRDOvBMd
hKgYamfflhlQ+1kXGO40CB14uz+7c6chyacmXq1+ELiFnJTf3p+GEv93jyJ3
DwH/ldMFOuzT8Ig76q73gyE4gy6mfkydAo6K6uIt8UOgOvUz64nWFEDSKytJ
0hB0HAwx3DxLBSVPh+XfwniQN4oS8wylQkZUTaqNHh7ER1Z4Np2lQtoe6/tJ
b/Hg8dKlKrtvEvy1b7zLKcRDxzYFqdwXkxA1530+mYSHs1/9rWT2svLXENC/
biXABa6ylKsFE4DTXQvKlSbASrrH6kG9CRivkzPm1CBAduwLJfrsODB8z49W
WBBA5+Pt5fqP45B2ybtq/TUB9t60UOw7MQ7HOZOa5z4TQP2FaZhS5xi4iJnW
NyQRIEEvaErCbgwKn4w+Tc8nwPy9fpusnWOg/1larwsR4FQc1Xc1hwJNguI4
22YCuDjhq2X0KJAlkzBb2kWAf/YPmkwXySA5ymE810cAZuHaFfSFDJcffdS4
NUQA0QSn7oeXyXCsqM1UgEAApc8e20ypJNY5USt8y7Lrak/cpYSQoHTS99sY
ngChqoarfy+QQMghLO85q/+DQcrfT62jkKoxm+QzQIA700yVuiOjoP1q7ZgB
a77LR0RSKt6MwC2DNMaVHgKM+j2VT58aBr7GbI1gHAECWwIk8nWGgfAmVyuI
5a+nQ338eikRmPeKnD+y7DztXTnZ0kQwlLAMnWG1J/8m8k1+I0Dld1svrJcA
kkeW/qsUIMB1UdbBYPmj9sfJ/mY4HgauRGhpkQkwpLUklCeABwntTPFbNAKs
vvyxb+HbEHxKPs93Z5kAfuZXzA7JDMGpa5HmWVxEkJEhxqmXD0JeWUpyrggR
5M5u5nmsOwhHd7xTzDtDhOfcv9W8GQPwiqd8fdMtIgyU/zgREjQAPvWbfv12
IAJXIk+hv9wA+LO9z2yNJIL78aqKB8R+2DGlune4hgjSH/9sWXrfD/p2epFP
5okwV3xl22WlfmgUSCwukRoGYXXPOYHFPvArN76xxXIYxpMGQu/n9cHmGD/G
29RhONa8aDXi2Ad45RBLh9lhkAg2jH1+rg/EP/DKzF4eAT/LRNnpjV7oHLnU
JRM5AgXSjqvsbb3g4VgSBAsjIFCbtMXvay8EHPVqVDYYhbtNnN+lnvUCid0u
UaV2FPyf1aFMlV543CDdn7iPBCQzN6gR7gUeZb0aCX0SYHuDdYUXe+CviM6d
A5EkGCmXp1p098ChMfQjEE+CXY+N92vl9MCi1fcDdw6QwZtbBeca0gMdeyfc
rJ+Q4epxv12hdj0gOr+nMfsXGb57/FepdLMHfvfDB+5tFLCJMBA9eKoHaD18
E/qGFFDaF/WUwtcDlmoNPx3yKKDp1OYhMdcNup3hZce2j8EHz5bbn3HdcER1
VNTYcgzm+2rycdndcPKB/GNc7RgkzosVB3/ohsRhnc16h8ZB7/XgA2erbjiV
FP8+w28cTq0EcFy63A3q0lbiCdRx6B5IYoTxd8PQjdqhJc0JYOu1TT4/g4NV
Zycxx9wJEB6KMZssxUG2UutOnMAkPG2qNDV5h4Ozwe7MXo9J6Asqk3DUxcGz
rXiPS5OT4EQ9mjMpiIP3tVo2LVpUSNmpnfOZ0AWdK/iYi4VUSLwm9FXnSxc8
90mIvSUyBdfu3Shdu90F7HgPcrvPFHx9l3DMc3sXCDXtFHCamoI9MsrI91Un
MEc9nmzRmoab71RHbAY6IMy7sFEjh8W1bIdE46U7QPbnzy3bd8/AvpMHC/a9
aAeTsWbRXY4zgF+J1yQWtcH1r4o3jnSx3l+yDfyNtcI6Ke24iCwNXjEs456K
t4L1rAa+5g0NRGN78p+pt0BC38IMg0gDd+2yJ6KPm1n84hzodIoOhEwfvR+e
TUDoH3GW9aWD6vu2W8ohjZAqLb46j6PDznfugjKRDfB9YZj8Q5QB30hekUmR
9XBOvNdZ0pIBj5e7HZc+1kFYeKStQQYDfklT3R18a+HlPrUWEQYDbpkFyVvY
1YCrXGuvoQwr78bz3pG6Uw3DHxTXNlkyIfqiuI7g2SpYvrAJLcUwQfGvNGX/
/krQuSf5SYbFoccv88+Sm8ugwdun5sMGE4q2KNldelICn2Rp5jwyGNhyK3v+
4ygGNYljp2N1MWjo3HVkNqwALLLILqdfYqBKLiqfEcuDt/1xf+vCMZAzfD7i
cS0b2gIbJ9RzMahQWg4OUk4H4yfS+cUsbtxWwHhTIJ8MdlKt+7cTMRgZ3zOe
digeImrHBJVY3LSkW/36Bn8EkN3u59xYxMDYRmw+pMwf7nfW7z7zD4P+na9d
Bvbch113BL3mWByXcv7Vp9cNOUq0lJSTAhsYupHFyP3vlR80y80Wn2fZHjtb
9g25hkGyc1UHZQ1DuwR7tOULvsFJrRO9/5YxJLYU3dPzIgma0hR3BMxjSK7w
jkdUSBrcjLn43JeOIYWonYPTKVnAkbv0izaGoWo3qk/icC4shlEvVw1h6N9C
biq/ZQGorjkc3WjH0MDtZHogvQgUWtSVUqowxKUlHo/sSwBXOLojPxdD3X81
sp7OlcFf7839BxMwVHo41emGQyXcGooLngvGkOS9To3Al1UwsfvHlNgrDB1n
22ZblVcNRC11nSQLDB0IC/Xcz6gB6S8Ppj20MbRXLfu6t0QdWJhLfE0/i6HB
KCGrigf1gO925jokjKEznyrPpIc0QIubcuTYOhNlrP+uEKluhK2JCY5UEhMN
4u+mT2FNkHjRK1iqmon0c5AsSbgFMBw5IymOiX7nHZ7vudoKlzbTjfTcmchN
V1Qw1KYN6sybd57UZ6Lzdvv5aR/aofq8z/azJ5mo4vTv8h8ZHfBLbsbbcCsT
PaeUSIU2dILKYl1oPJGBOugS5NJnXTDLrWr4N5uB1DV5921f7oL6tD3/LL0Z
qABPLBPxxEFI6GLG8E0GOjGc/xTH0Q2WJWY198QY6L7FBAf3225YGeHt7Jum
o8NC9WEpW1gcZ1ScdiOfjmTlXr9+69MDcd9NAkrc6Eh5yNXt3VoPyDWdFBW8
TEcRBtvRe6deoD7ck2rOQUdcFfQ9T6i9cELixf6YOhrKID1e4zToA2fFw1rl
vjQUwqBQLtb3wduq0IXayzQk9uyjFvV4P9Tv+/Y37+8MShS6IEIN64dvUaMR
7wtmEFdsd6fQUj+E6xe4aj2ZQfdsW4nGdwaA4tyzjU18BlVWtHNFZg/AprUn
Eand00jpXm5v0pZBUFUP+qzjO41W3snPP9UfBPy9N90bp6bRL9O/bf1Jg6Al
WtLaMDKFAhom+NoZg3DdU6e/IGAKadMX9JXkhqC8t89uWG4KRZXuaRR1HAKZ
822v9fFU9CtSAGf2cwhSuVqDL3lREcdI2ALv+BBsG84RzDpMRb+PfXl3mB8P
QoEcea2Nk+jJqeLgXBU8RHyxvlphPYn2cS74tz5lcV7kyNks7klkcvij+qdP
eIjd2Pq2I30CvWb418vk4aHca4SoqzGBCvm29nd04KHGsML/+fQ4IomJUUqo
rPHzhk0c3o2j69/1nc//wwNvhl5y4NFx9M/lTNn3nQRoONGfsK1xDD3iPZ9v
tJ8A+/0W7p61GkPswH+fIEsAat849oBrDDVuGnD9cp4Aduvt+9vTKWj3hJ3K
ERUCtC3dMcZrUxCn+YvYvVoE2Dmou6V/gYzEjSUkuPVZ3DZWdGt3LBm5ukqO
ZpkQ4HfwEU2SGhnFrixHFtkSwPswd2TwHxJye9q5OPSKAOZHr196nEJCAsPS
1/s+EGB4Q9Qy/z4JcTx+sMsygQC2qq+FcnaT0LJZvpF6KQEmP8bsPh47imBh
iefMIAEqjKRJJ0VHEVfpfmzoL4sTY68KFyWPoLm/ciskCSKEU36EL8qPoAAO
7g9jd4nAH8sQ3IsbRt9qIqefhhDB8V2ps+jzYVS59oC22EmEDvvhPZvFh5EF
+7vtU4LD8NMrYSS5l4hoQbadn2yGAYo5eps+EVHa/KFvJ+qH4aMYni6iT0QP
iBLck5IjwHgW5nnpMBFNSql8rAkfgcVCPY78ZQKyuDzeXLZ9FHy1yBJ/egjI
QNOfJ+/9KHTXFh60LSQgRR4r+fPbSHDt2LCaSwwBbRpR49G/RYI8inC4zTsC
kjRMWvOPJUHO63Omn1wI6Nd9b7VwBgkCsyNXzz4lIIct2StXrpAhccVaLN6U
gOa2Gq1qRJFhp8P4A8EHBCSRd1708RwZGuzXz87cJiCckpaclg4Ftsm37bLU
ISBNq5YdGVkUKE1wHKFcJ6BmrmGfk7vGgK/98nukQkBHDAe0Ap3GoMig7YC5
IgEpcM/PPB4cA9lISoXyaQLiPTGv76w0Du6u+ccHjxLQVrUOZJE8DjaHWuwy
hQiIqauxa4JnAqar5Kd1uQgo8OFet9TnExBo1eBrM49HPJ9MiBbECbDluB0R
i8ejwltWov0qk2Dz+VheQgUe7RO2dShMn4Slj+q3z8XgkcoV/s+1u6gwejfG
S+olHvUY11NrX1DhLsX9hpYmHt3uH0h5PUQFlceqht7CeCT9zoZSdnEKYp/v
M/g5OYQqLpyP0IqZAv8z5PvVmUPI4tff1C1/p0Abf8G40HYISdiHT5XqT8Mu
f//kd1Ks965cm9TzpuGs7IDUFdIgerRyzi6QewbmfixtpX0aRGZxh+2tHs3A
lG3TbKTSILI7eJVRnT8D3LvdE40nB9D7NBtLv8000NLSNbofMIC22MYPfdWl
wQfX/abpRweQb+/htOVYGvRV9bo5VPejbmKrZ/AkDbSnD3r23e1H3L7dp2/L
0kFf9/LYOrUPqWy7mKpiRwf5+U4NwRd96GdrSea9bDqMJ5DFtdd7kds3eWI4
nQ5H7rGf7fDtRcGEcdfVIwwY9b5t1LilFynTFm58MGaAjEOGqLVfD3qWP+6m
G8qASO80vbGNbpTs4fLobj0DThWNUy1cupGY7BPrxAUGZB3Y5yfOxCF785lJ
1QNM+D71SlvZBIeyWlbGdTSZcOu2ZPoKrgu91h9Z73BkgnLf0JrT5S4ktvBL
rj+SCQnDaL70Xifa0eJe4FLKhPrg0fHq4x2o6aFjVQueCYcO5N7VYWtHA2bu
tuRlJjT6qNvndbSi4qE7nt3/YZCYc7NY/ksLCjrFcaHgOAbmz7cRD5k1o8NJ
OSdiVTHIY+z6WCHVhChc58WSDDGYWMFbqTAb0BkN/5JRewwYAekNv3PqkW+5
2FtLXww4hrp71xzq0NHNxCztMNb4UcueX07VIl1OleGfiRj4DPzzW8aqkV+F
455oFmdFMuV9r/ysQjKdmP/hSgwiIhdPnu+pRBcibXzNmjFof3B2+12NcqQg
+v3y4x4MkuqfFu6rKkH5Z7w7VFgcVtFJv1NxphhNLAcvbBnHwKRWIPhZagHq
+tsoVDGDQbQF/q+BcB6qnZs99vI3a/7szg8qwtko1t4lXPEPBrOiW22619OQ
v8mIwL4VDK5RlGIjyEmoxqO9i38Ng0Oc1zb7+Mchh/aWQxfWMTi22Vfhf3qd
vFN43v/0utJc5y3/0+uOp/2fXqc//X96naVBzr7/6XUnH3QM/k+vaxh8f+l/
eh1nSNHs//Q67ntDx91Z499SWsj8NRkLq0Gi4d9Z8xu/6tBR5UuCRoMWvWmW
f7Fg8TP2eBr8t9UlTH0Wg4fbqFFymlng+aW2u4jFnYUrguJW+bnAtat3RnIC
gz1RD2uiLhdAHslD+vMwBmPc08Rt7UVQP8ZuMd6LwVePPyUfDUqg6rr2tl2t
GDxyXin8RymDW1+qFTZXsTj1hWr5vqeVcPWFMT0rH4P9/n+t+lxZHK6ntb6W
jEFv6iFcQXk1hJYlGOEjWN8rX/71zXoNPFW/fETuLQbcq6ntolAHZ5vrG5hO
GMzLHtTT8aiHDTONI6sPMZA8v3OGWtYATz8MtF7SwCCAEM2fu9QIip/MtibK
YWB42+iA/almmMQdENkjhEFP87v9k49bYNhq/onzPybs/Q+2dMW2wivj6sSS
USZQjtjXTHa2gWmo/1QtYsKa9n2b0fV2iDrSv9k7lgmO5j0WT6Q7IWJvSATR
hQk7FeUNRKS6wEs1RbH2FhOyRhV2rZR2wcuFjLqDkkw4680kxmmw6kJ+uv7M
XwZcek17MzaAg0yO2R/c7QywOvCtLdy0G3i4Ffe9/MoAB9/KZP+Zbtixk2de
3IoBm/FbXAJYdXA4+y7PTScZYGe489GT2R5oOj99cdciHfZP3HH9Z9cLCpjV
hloJHXCblGV30XphVNVRNMWVDv8iwPu5aR+03wv8IH2ODhb2/S5rfSyus1/g
GpylweHv9Y9fXeuHDSUL+YI0GnydljBuyOmHh7vuVTUa02D5+xe/AoEB4HrE
cBHjo4H+py+f97sNgOEhjZeNVTMwmjWoMD4wAFrOfsf7bGfgp2XXd8rJQQgW
I38yEpwBrPrZyLrfIIQP3zjkVjUNm0jV9gd6ByFvvY1X3XIaCMJeuHNiQwBr
ny5NbZsG830CS2fMhoDL6oKVZ8YUfD/VOM6XOATufen75TWn4NGogGLH8BBY
3O4nnZ+mQtDpn132e/Bw5ZTjzl9vqFBncvoS11U8ZPNmrFDFqVBbVeCcYYeH
HqegDraySZhNBjO3CDw8Nqj/oHR7Et5MXDP89gsPqgxJKok+AWdeR5dr9OOB
f8FUVObNBCy8MtSrwPBgXLHSYCY6ATfd0tuUthBg35nJ4N7CcfhkK7/5kAAB
XhovDjdrj7Pq2KhLzRIEOFx32/Hz1BgYicQpxpwigJlzA8XDdwz0I7LO7b5I
gKZxfx7y/jGYunT4W6YyAS5sl3yyvZICV7HuzCV1AlhzG96/aUyBcnPR1gBt
Anyb8VbetIkCQbNzGey3CRCSb5lrm0IGjaXdJ7jvE0B+N9GEok2GjBMebDos
rvscV3A2dZUEFf2UP342BDD51XmEI50Ele93y5q9ZHHbsakzp4xIsJt9/3TC
GwLYF7fctf6PBDdsXmssRxHgTWolvSBuFHZVWjYL5RLAifp7/fb+UUh7bvs9
v4MA/V2H99B+jIDtStUJmzkCcH7huf7lwghw3kpW6xchAjFWLc6udxgs43bn
+WgTYWlOT8XEhcVjF/5rnvYnQkSctZa2xDBcPHtR36mZCJNX5pjreCKYsF9q
cNwzDANJN/gloomg1pT0U8JyGD4NnHlr9JAITTTrjrzqYdjvju6fOkaEv9a2
flJHRlj749usADsRQs3f5XmHjsCFV0lHXYcJcLvwglTMtlHIfm+Mz64kAJNo
4avybhQexLl84UkmgF6wxK+IrSTIr7nhNhhCgL2Zm06sa5NgqnVwTN+DAMdd
HErFv5Dgm/gu03Y7AgRUMR6jKRI82n1E092MAGzdNothCmTwXWq+mGFAAFI2
frt+CBmaj8vdTWGt29fnOd7Fk2Tw+sZ1sfoqATo562MsLlNgMDmm0ECBANe7
Ny7tjKGAxe6/Ar3HCbAJe7huskKBCZ9A1ZQDBEj88UCOx2AMMo2ev9DeTYBd
zlhXRfEYaN6XjzFgIwD3Gq+ilOA4xG9OSjai4aH2js00h+s4CJwNMePowcPF
++E0Tvw4+Nlf1V4rwoNg4wdDTGECOPWVBLdG4sHR43aGx1eWfdNBjOmIBxP6
cofb3wk4sKFQ8VYDDw8M4kyy7k8CR7rTpxxRPJBCAlKmfk2CY5JN5m36EIxE
cnr828s6h8HNVeZFQ3DniLJGvQMVFijeWvhXQ7C1rr5RpI0KHsM7WwsVWe8z
tInjh6eA8CJo5N/yIMyJPDJmd5+CQ2La4ZU5g7CtuHjACDcFu4/yZHCZD8In
Bb+rY4enwcZ4L/H37kHYem61y/vlNOwJMr4aUjEAPslxETIN05CQttC6bjYA
oyrW9/v2zEDL8ES8IecAZEcE3nj5cAZKtRwrG5P6wdg7q2Vr2gwr/wl7P4J+
6IzeIvHm9wx0fVhVVe/vg65fqZa0szSY3FUgnGDdB6ZvrA5ccKUB7qOcXdBK
L3g7nrv0rJQGO0gW/Sfe9sJW42utgSs0iH59tC99Zy/Yyn4nhsrTIcvSMUc8
ogese5wMAxxY3PdNTD1fqAcWygIYdul0GGy8t+T7pRvES2RaNcl0eImJv8oX
7Ia5oD+ZB/gZ8GNh+4hJGA6884N+LqozIGe68XHWDhxMmmw+0+XKygvyGRHF
fl1Ad/sxmp/KgK18xcIs1oTID4Ivf/Qx4J/m3rO0wQ5Q8HLqyWFjQpB08b2G
0naYeH6X2CfFhBOT+/L+RbWBbmSsgwgrb7n7SubXO7WClGGqxfuXTPjmnSRx
S7MFphTZnCS+MFmc/eAkbn8zqE1cPDNfxoTs/R/NX8w2wt33ayIrBCb8vKDS
9qSqAaLHJ5wUV1l5UHh9hfShHghzTlo1/BhIy+KE2PTrQOtUmH/IKQw2y6py
zIvVwrr5TH0qK2/rBPLeoIxXwz6DjGe7TTEQt4QHf1KroIZ39UeXMwayItMr
Sf2VQGAU3qEGYnCE8IJ+yaAcJmTTBe5/Y3HLxVty6/0lwBm9S102GwPFCJE8
Wb1i8Ln0YPURiwN1lM0reNsLIHGzwuoqi1P2te66MHU1D4yTulvWBjCoNH8T
uPQiG14/P5jymILBbnvhrr0P0+E42cf9MouLMo8Lm2ReS4aOCxoLb+YwePol
qVFBOh7cY3ytFZYxOP0i/J3HvgjYHFDCMGZxmLKZmSux3B/er3eqLbA4LURg
8MHInvvwWXhmfpXFcV7XCv7v/7rsjf//fx1x9FWZ6is/+HDxzPhbll1fza2X
4BYGC18WI4XXMVTzNDsMX/QN6q95b6/8i6Frm4suL7okgZf568PPljGUfUFx
V2l4GgRMMytkFjAUdpG6yT83C0J0BVMXmRgy9vN8v3cyF0jKd1M7pjDU84iw
VOJYAPwTcy75ZAy1BJVYRa4XgQjbbFPSEIYWCvQUwwJKYOJHx8XvXRg6+1ok
NGJPOXDZgnVGA4Yi2WUV/WIq4Qh9mIjKMPTkfLbBgc9V8DO6d+9oNoY+UILe
PuirhuH412+5EjFUnf+QbUygFswyV0IvhmNo32+NibR7dSBmVRHu/BZDLlfy
937/Ug/+3nv7yl5iyPQcOlaBb4BqjoQPWy0xdJwY5UkXagL7rGrqvdsYCvU1
23HAoBlkZNjZ866w7ESSj2Z4Czytc5jkPY6hqTMVxw1xrfDQ8E+wnRCG/hZ5
/VXmaQf8raCxbg4MrYTwP8audQDfpo8l5xhMxOCd8bzp0Qk5foPdMX1MhNmr
Wqff74LR+9NEtgom4v1hd/bFny748J7d3jSRiaReDpp6hrDO44g0b9U7Jsrg
njJDkt2Q3yZzUNCWiSzrKu/JVHfDzyDP9cc3mSg5NIa3xKAH3q6cJObIMdFR
JgMzwnqAEps5xNjDRBucK1t3vukFzXCfFdEFBir2PbxUJdQHEZ8FD0APA2m4
dNGtfvYBd5SmgE4uA92dL4lbYt1fQc1svprBDJQ2SrpmhuuH3Kak6VM2DHTO
nhoYazIARzmjf25cZSCPAnJg1O8BsHsZzJMnxkAU7cDaax6D8Pm/dlHVJTpq
ih3cFsE9BNE/rLp+ddCR3O8BX9fwIai//GCaM5mONL73R42K4eHscvSmY250
JClfMVGUggc1Nza/o9p09DU77ARDlpUPd8lnzInTkV/KkTt2LG7wmXnp+X6O
hs5npILUGSL8iFPvnamhocYG0+4thUTQXhdU3fmZhuy4Lw8xTw/D49jGc/MP
acjP/NxiW84wnJzc1/VJloYeXnQL8pcZgbfVB5YmlmaQcv2dnM1JI2AW76s3
Uz2DWn7mc0rtGwV0uVot+v0MOut1pHggaBTk7K0x+q0ZdMT/mdbc+igMiKiK
jArMoH3X8nQy5UnQ8sBfz5o4jZ6Eixg8f0qCW4XzLX5x0yhsZk0dxZPgpuBR
S2mTabSr6sdBtx4SNJjR83UPTKOTQr9aP24mw8uEKtqf0SlEtziwwThNBv4/
n2nbY6dQd7XxhVcmZJASGTr7wWAKHS5rThIPYrW/wf/bdvcU+lAqvaW+iAxs
MSvkHy1UFOYZ911rhAzCR5RfnPSmoqfxm85846DAHaXvRf/OUtE9G67mqCMU
+JU+pb9lehKJTDkXiKpR4GJMY77il0kU4dv6crsFBYbjknuirk8ipI6lKXlR
YKn/nzPv0gSSU25mfoqiQJ/Z/KHP3yeQ+ImQ4eGfFNh9hSwreGMCHZs7vrqM
KIDYhzvC5sdRqYptVnEHBTr676mtRY2j47huTfoQBUbPPFhSVhxHXg/5BK3I
FMjiWAw2Gh5DQctKVovjFICQS1evuI8h/8lDTZYsO/4Li04Ex9Bro2k131EK
mP95I3spn4IKN9f27O2nwOWU0OPXNCnIiL2yitpIgbJjOfhFEhltIpT71hRQ
4PRf/m86z8noIG9/sj2Lk6Kk4gxvbiEjLZs2DuRBAaaWtMl6KAnpsR+y8XhA
AWkf1pUoTkKhCZrf38hR4P7OwWnJO6NoLMWWq4AVT0Wlr2y3LEZQkszv2oUO
MrwNqv3x3mEY7U+oq1QOI0N0xPKX825E1MEb7vxTjwxbAmA30ZOAKtsvNxnv
IMO8muXHfb54lDOBy0uoJsGRbU2adX5DiMNM6MKMPWt/LFO3Ed4MoiyLPJkR
YRK4LBpJRPsPoBtPXjhWvB0FIespdZfAftQZfiflMG4EtNnunjoX2ofKUygO
RKER2FKX7zsc34scZRrVX5sPw9i+Rrfyoh5U0Io3NWCdl5APW6ZtBrqR/1mt
F658RDhc+d9w6ZZuJF+qK/+VxavX8nPP/7iKQ/IeIY+5OQiQL6g1fC6yC93x
L210SsZDqu+DgQdsXUhLMw//5SkexrNXXj3f0okIT6UiVo1Z/ChJClm+3IEc
lq5U3/bBw8Mdureli9pRVrdAygUCHgQ8/PxELNvR+fJvFeFPCSAgU/+6Uqcd
TZtYWtw5RwT5kKyYfLt2VBTJu/O4wjBo5n/ADKvaUdJFf6kohxE4s3W/u5BC
B0pp3lLzb2AUik7eePSrpwNxdHwN4cknAcV0m9VO305U2YK7WRZAhl2STTdw
Yl1oRktxm98TChxpqClNdO9C7n8rTxL0xqDLJt7LoL8L0TsSkL3SOFyvrsNo
R3FIKcsp2eToBDCv37UTeYZDh9qaHhpsnwTjv7VZL1JwqFfiOF8sdRJqR8sX
NDpxqAHP7yxQSgXxHCe+ZCoOJWL20qreU0BsulcqieFQV6hE53HFaVjiCA1a
mcChkWfjbhoz03BFYse22DYcCiuK/W0fOAPRG2fyRxNx6L575Ye6/TQ4ZHan
suIpDjmyzWyP/0GDCz/2ZOlI4tAbNev6t4fo4FsUtV460IWeJ/8XIBBGhya7
Ha5HWN/X+ItjO/sqHWiHOIty+bvQE+GFb+t3GHBu0tVr5GYnilu7NdfI4r6U
4dWv1eYd6Ce7iB3/PAPGLTxlZmzakYfFxJ+Ys0zQLphO22HRhgLXZpI5HZhw
Vi3JsuR2K1r52fL8TzITTF1xr/UutqAcHQXTTX1M0B8R+iKyrxkNJh0W+7XO
BA0dDTm5uUY0v9uULfYQBl0B7Nyf6hpQ5o7c81JXMUi+erpd4HM9YsHaobZH
GFyMakoPeFCHuuyUi2iuGHwruUX8eKAW/bhs8Wc8BIOzOY93Vo9XI4dDFAee
RAzG1WLSo5Or0ATDq/b/60Pdqv07mytRyp7XG7tqMJD5t7cIp1KOiCHbJR06
MNhjq6fMX16COtGzUM4hDDyWb903kStGB+7WXmdncdv3YME34j8KENNL4l7I
NAbDG6OtP/flIXYQFu/BMLgS+hAl7ctGnJ6mwYwFDF6Tgw98Xk9DKdbGhiss
jvvYmqfoTU5Cs+1PL/CwOO7Fds9QZ/849PGa3aw8i+PMvyrWLWmEo22vOgL+
p9cRxDSnkfBb5Hz///Q6xbT/0+t0Ew9t+Z9eF/xIpO1/et1c7LckN1b/EjaT
xd3pofDqZ903J9b4tba1GTmTsbBtwTvr7Qorvq0H2s/wJUHc3oNtiX8w+JOH
H7c8ngbOkt/5in5jsPPDjpQfGlnwXNQ/InGGxdFs6l4debngHzGvrDXGim/q
bJkNFMCJhdzoYDwGukejG8ktRXAzbMrlUhcG5Vb/nIi3S2Ch5wJOqg6DNPaz
vr+JZYDZyOiJFmHAW88zEGtaCUahI7sJyRhsb3bIS3asgg+XnhzcH4pBDvXy
woG8ahjMjj307TUGTiJrR+9hNVD7xql7swUGwvx9jA6pOiDGf36/pM7yT71u
ae5RPdzcc6SVTwqDZd6qFrGwBni0Il05sZnln07P/dCaRpBrfNjyl1VHtFpl
+L+kNUHCt9EL3T+ZUKc/69u1owWIEwc4hl2ZEGLx4HyAZCv8EWlueANMYB+0
KrdQaAO17OB9susMOP2uhptTuR0GGjovHylkgOac9NGxSx0wzzbwvMaMAZMu
fze0ZDtheyvhn/o2BixzmhcXb2FxnsyTaxtJdJDw42MkPe2C17yp52VZdRyv
wmrwSHMXGM0vXRUrp4H/vFCtqggO9HQLrp2Wp0GTWJVlsSkO2k97FVISZ0Bl
ME2AOwYHJSGhFi2bZ8C2inz7UCMOfiviBysMWHWrfpbCpjEcPFmzFx+MmwLK
CZlzHUwcxEak5ofgqbD67mPT0jQO2EsNTrduo4L6rsMD6r04GKx9ff/P8UnY
6Wzkx5mFg1dvT8fuuDEBTn0j93e44IAqr3Itz2wcIHN/Je00Dj4RA56Ju47B
Xe+rr/+MdYGda6XJkY8UuMf3s10zsAsOn+Uo2PKTDPmBt7b3HesCE1dxm6u9
JMgzVnxzJb4TvAwO8tpxk+Dky6BSW2YH6CZNeCT8GAGnxBnF1JsdIB/jKqj7
eBiYX9i/nsa1Q+qR3kWcIRGSehsPOrm2g1WME4EtgABe/IdP3bzVDqWT0bZv
mCxe1PSTrTZuh7zWzNWWD3gQfx5d45XcDt6SgvtPmeChIVAt6u+RDnCR2LPb
zAoPmp8fvHWgdMBU+sdPjdF4cJwP4rzc1wnWafqwMosH6yqP4MTXXTDzBH/u
gjUBPhkuRmUexcGpE1viccsEyMq8K907gQOX0Slv0y9ESM2feL+nsBse3dNw
E1AfhphTFmlPPvfAQIhcd+PaMAgsFPuwv+qFkLlNrzYXjIDNsZRF+ad9MFc3
KyFoMwo2VpY6mWb9UMuR3r2+gwQ6JfsldB4OgOSFHeKpZiT4bieud8doEA7w
lDiIFJIgQPNUoILhEBAO7jz2cxMZXhU0dJbex8Nvs3y2UXUyWE4q97TqE4A/
8tDco/dk6DrcuBCuSwTfwHzDzQ1keCzNbmCrMQxceasrhX/JsF+u2bJVaQS+
JATMOctQwD7u3ZT6iVG4vctp0vAOBYzpviZtLL+KrnD3+bpSIE6hPr/amwQJ
dGrjfyz+E7/5xtFhngRWIjsllHJZvJd5urnTlAx8jLQguXoKvFpWje/vJEPH
ss2po70UyFiccfBToIDnzmhv3REKkNyEdQnfKUDmaztFG6PAqn3YQRLXGCw3
yzsfnaBAv2I1LfrpGPhoUl0VKRSwwP24zdcxBoPKiQwjAgVWrL+euXlsHP5s
wZoruijwQuSagsn7cWjTtNn3oYbCWvfLSToT43Bmg4OymEMBeutBrqNKE9AU
Es8jzeK/wW16EvNhE/BUt+CJjh/Lf07XajQ9ASmyvGXB1hQ4l1LzIUpxklXn
JWfsuEGB2W2veQKCJsEkq3AOY8VL5V/b+xjiJOQeH3igv40Vv0p/7hEpKhxd
5Bo2GyeDiY6hksELKlRETWacriBDHS3RZy+iAleKrd5YKBmihnWG9m+dAunu
0eagx2QYbPWjemlNwUPik7c3LpLBvPPdwpXPU3Dtu3HEOR4ybB0rnX7SNwVm
f7JzLQis/WBioLdVYBoye9q06akkuF1JMhHRn4ZJp8DC0eckKNj4TcsLnwbF
wUt8ekACIwEX++7uaYjBD3sbcJGAz0xGyId3Bgy/Jxmwx49Cy5ejFU3qMzBR
Hh9aKjsKn3yyxjK9Z+DTQvnT5aIRaFteaDhTMgNkzk3/Bln7RjFx6a4lNgM8
SdKDznXD8PmrtqLaYRp82zJyGFMbhqvnV/FEfRqYn3iYr99MBJ5nh+/IvqfB
fXPq7mZ1IhSY9QQplNHg/dX05HsNBDhZ8F6Gh8Zqnx+bL6ZMgCMfh74kC9HB
RkTAXbYcz7p/endtV6NDAttN1YgzeKjc5BZ02Yl1ry5S7J9lDIHH800j17/R
4fDzW14N4kPwWve/OOkmOmyfS5DNDhuEzLBZpcnfdKjeIvHs/NZBsAh6teEp
yIBAY7sAB5cB2Od3cnlViQFNKeH7rKf6YfIVr+B9cwb0hRTtP6bfD15xpkfj
3zGg98MIe2tdHzgN+jV3ZrDab72ZqHOqDz6JeXnQ2hmQKqdg3BjTC427U5P+
MBlwjEnlV9raC3edRdx+8zKhMN1OCdn3gILwRbGRY0zYH0rH3xnqhpvNbKFV
mky40aYezHOlG4Zb71VGP2bC4N74GMYPHNR8NH3yxI8J1nFX5th5cRC/EKV5
Lo6V19z1pe46dQG5dH1p/RcTMm2dxMjZnWCWdWyuFscEnosTukXOHbBt0ijZ
f5oJYSrzzy8ptUNrvLGVJhuLY4z1PvhztEH7ER/XXfwYOBphMsmNLXBE+PW2
QWkMZk4QXFPeN0Nv/AW5RCUM5o2J8l9vNEFj3rc1x1sYHCp6X/95RyPguG48
UjfDwP8p36mY9nowHtG4evg5BmO1kacbPtTB6Ey+51Y/DHqz9BX3a9bCuwEN
/NxnFteUPn5RyFUDFS47d1DjMdA7dK05or4KzHjqa8Z/sjjsiWhXAgeCkTK7
KHoJBkMZp6IpbuVQEN0kusHiDs8wVx/u2RJI1kntE+lkcZzxatNpy2Ioz3os
rzqIgVfA6n0XfAH80byU/oqEQeaJBNKsVh7Y6fmGVFBZ84XGvnPyzobaQq4L
PEwMfELtXnRbpENVpwbTah4DfpfP4XLXk+FUWiatawmDH6WV6fUy8cA3nmSq
9heDkFR9JzfhCDhpN+ba+g8D7pMdZtIV/vBwl52WEYvbXkYTl0f33IfkrlLm
Gst+pfd/et2Zlv/T69zP7VHWeuUHtjFH+T+xbMXxKPsytzB4YKFgfnUdQ4ct
pjrkir9B+v7VGaE1DI25Cy8buyZB5tnUDL4VDFnSry6/jUgDlxMcqTJ/MPTp
J5qYzsuCDXUVitVvDP0jsO89Sc2FX4L8Rg0zGLq8g3O7yfMCULgZLaw2jiFP
zU3YPFsxfIm7fWCGiCFsyrOl90MJrDTJOWb3Ysg3SzMMEygH01nX3ZGtGEpx
ljl+8nslOF+u5UyoxpAIl8ap6vAqKCLN6rUXYYibXWJ2aqgahF5IbQhnYCg1
aEX8jWgtHBet2xH0DUM7xFpfBT6qg7f71d+If8JQndLmzNnv9TB6z+hJvw+G
SoQPafwcbwDHsJr6LCcMmb58QMiXaALhYeUvaWYYqn91rGvVohnadmYwG3Qx
VLr428c5uQXYilAT5xUMVZnelt8/3gptNqePWx/HUOHTzj3UA+3gtxB7mLmP
9b1uXNJ1xh2gev15bjgnhoxHZJ9kfOmEzOJN+IezTHSuMLavyaYLPjqaJt4g
MJFJqHhn4VYc0Ko9dxvWMREH21UafxIOpsV5ZYMzmagr44HJJHTD7YigBUoo
EwUrzN8RI3SDfvQN+/tuTHTVtWvo14seECTaJi48ZKKVdOZU9s5eUDKY/ZR7
lYnM+J2s/6X2wlWOavgkyURGvF+lv17pg1dh1Tmh25noY3XimM9QH+xvp079
YjDQ/dOZcln2rPuoTJfO1slAcr2fvvJvHYB/L56gJ9kMdFmj6W1hzAA87uW2
WglmoAd7jl32OzUIgvnJU2m2DKTdNPDnVf0gaOt5abzWZKCXk9SicIMhKHOc
DnWSZKDYo7ccW2aGQL30dfuHzQxUH/rjz253PJjLPt/UPEpHF+PoNCseAnjD
wkXJUjoyxBkTq78S4PS9l4HpoXR0/auWlJA0EYJNTmy6+ZSOZuXneS2LidB/
7F2u4FU6Coy8+z1eZRgu+CUUbBamI+60c11VHcMQ/XriyH+zNITpcRlWGoxA
D88PKbUGGkJ/FkY+kkfg1ouusdgvNKRxYaPhhPUo3HJJ8BF8RkP9rsfvfsZG
gZ3NQ6H4Mg1pBtO79BVIcGx7h5rbbhraob7lOriTgDcKw0zGZhD3rN9vtwoS
mClf9HmWP4P2fvbZwbnOyo9XRO7F+8yg6B3zHYRLZOg3VSQs3ZxB8Dr9xpI7
GZ5/rnN/ITaDrgg6++uVkaHIKq9KiDaN/l41sKYtk0FRVEVhomgaWXzprS85
SwHeS8+DB72nUWy2w/0SBwqoSn55scAq8eqLb3aOZ1JgzI+n4sLeaXTy71yx
PJXFG7ZT6mnDU6j0rlRYmvgYGO2d2ns1eQrhFk/hzt0bg0YLnYvbn04h25Ct
rYSPY0Doo9M3Tk2hMt2J9pDGMaj8dOz1oSUqkphiF9T+NwZ7S1UeOpdRUUNY
IGGX3DgIXTaS+udBRY8Lei53W4zDw+jpiKIrVDTi2fn4Q9Q4uMjR3ydzUNH6
fLvdhZZxEDtzb3db3SQqdHKz71kdh2M9rpaybyZRpftR/9vSE3CQ6w7WdHUS
vXEw7ysymIDyo0KqSRyTqFaY9GbhzQSEvfQ5V109gXwEoru25k1AgY1Cw0HP
CSTRb7gxQ5wAB5r0sbaLE+ijfrhjFOckGLyuIlctjaPQ3RYp3Ccm4eDE3ojN
+eNopnfnecW7kzDkyHHxq+04uvMti3bUfRK+d2xnDzg6jpxTZPKa4ifhGW7/
w27SGJoZ9skWqpsE9lw5bvfoMeSppnyFf3ISEgMi2QJvjaH4z1e3lHJSYUnq
wNvN28aQxN04EtsRKtydWJNgIgrSvVbBSVWhQrjMlXytlyw77Sub9SMqvMiW
vC4lS0F9Dw4U+L6iQiDnvIY/mYwMnf2enAmnwp8pM7NnEWR0gZlHdPlJBdMA
vO+EBhkNXss9qVNHhZPMVcr8Ogm96iRzFw1RobRybDU+j4TmpyU+ZjKoIBxH
e7tgQUJHjrbYyrFNwa8VsteiIAnxxx4jqfFNwdWZuIvGkaOIoPRfCUN8CuIS
noVprY2ggwOhFhInpkDl91fNtkcj6P+1c+f/UH1/HMBFlCgqJS2WVoVWKomX
lC1CoUW0qLRYIlJoUUQ+lj4UqSgtIqHsEi5JyZZtjIx9mXsZZpT4iNL3/gnf
P+D++H7cxzln7pxzXufcX56iq4OHh7QoTIQ6/eF9bCWeNEfMtzSkcNfrXHSh
cisxvuSgqvleCtMO1O3dH9JCGN/fq9t3iALrifiDUgGHMC4mZq08ToFjqjxD
wZJD9EjwxCROU+i/+Pzoxexmgrf8ruljRwpem1af4Mg1E0k7/XO5LhQaqopa
T1z9RiQIjJp4rhQe83YFKnU2EUf9hway3CjM6zcfWanfRNSl9FB76DqDlRkU
8IpNHNhQ7lRwnoKU79Nj+2axiT8hjiWznCmsHArUiXFvJPL0UltMz1IQZvOv
XvzGInaORRr6naTwu9j4Dx8sQptno1J4hIL3hXFJuYQGIiLwEWYcpPufEWsn
ItVA+K/OKPGwoBD6qIiff6me+Kiud1HCiMLhOWqTlp11hG78yK0WHQrzwxr/
Y5nUEY0Sj/8dVacQ+SnGwTynlrC8kRB6Zg3d34Xh3opltcRST9HPOxQo6PqF
yewPryGWH3tZET6XQt8ua2nB36+EtLy//Rn6Xt90WeqWW3s14eHucJU1Ts9v
h4W5XnEVYWTorNJHz/du98p+5/hKQtHwcnBGB4k136suTwZXEJOGNwp31ZOw
dhzPnPAoJ46rTn5LLiVhGvtj4NyxL4SuyZHmiRwSG4dbxs3Myggv4+zIHUkk
Zg406iXqfCZWKCSnhsaQGHhgmOGx4RMREZMRKAgjUe0+rezNylKiXStps+cN
EtsjTP/dJ/+RGDzTfnm9Bwl+nX6O5YISQjXvXoLqaRJZViZ3EmQ+EAMNf5Mv
25DwRaCC7txiwmhK4y8lMxLGQ6ObZsoUEfH5p3009EjUpu9qH1MrJBJGLSKI
zfR4FyuKf2zJJ4wWFotXqtDv47N3HUc/jxDcs5VyUCKxj53nfeNALjGIXJVo
WRKKbXp2aU7ZxGS/s5bTLBIW5bmqm25lEkomZWd4oiSG3zjLVMalE86FIivl
J7mwnBdqoUO8JcQzFZUl/+Ni7NZWdkRRCjEmvcs+f4iLEX7hhNW0JCLk+dMp
Gjwu5GZ9bdm67yXxNmrgrA+dB+Hlixzfxj0jevqMN97r4sJ3+7ObVj2xxMaF
xUv92rnQPjrj8PKQKKLhn1UbTVq5OP3c+LvB+TBC8omfP5/DxWvHP6sDoq4T
Wrzesy50na0gP/1arB6xhfvWroKuC5rXJnzke8NN9qiYKN0+f7OYbf3CEOhW
J2kspPtXr0vwdT0eCdu16n3T6fE1JdNPjObG4FhwpEl1Lxfeo6TzvRnPIBMw
mOXQz8Umn9jg6PfxOGvfkVYl4GJtbYCjnOsrjD6b+/vPCBcaWdyUeOUU7NFZ
Ffj9N/0+417zei68xdZt668/nUpC2u99tohVOqSf5u4Rm0li0lwu+seWTLzo
NnosO5+EylJ9AV8+G9MeXjtRqUDilL6rpLp4LpptMlsWriFxmxslPz76DtcE
2jFj6vRzKZXxi9R7SIZrhdnokrgWdKqrqbUAtlJiQhqmJOw23rK2YBMYrlJP
9DlI4qr3Mv7N/iKcPaX9RukUia4Pri53eMWQd3qdK3eBxN6/5NY2/gek+w0O
WF+n18tHm2dXf5bgtU6GSFkICdai2myv3x/xs45ldvwhCT3x6yotYp+g2VJS
OieRhJKHmmXy3M/4nuswuyqLRKCI+jzB0jIcMfOM9i2h83i2PPlS/QtK9qwN
WVJL4isp/aXeqBzi5/eP3G0jcejnVH33oxWIuh1aXM8jEXqvzdX3ciUshT/V
VI6RWPzCeXj4bhW02zuEz4tS+CNjLfkxrRruQZb6SXQ+d6eyHvfUfkVMVkmc
yxIKnw/lPlnmXYN1sv4GycoUZlkqP3OWrMVr45ZYy00UCifWDXx6UosMPbG9
1tp0fvpcmr5CvQ5pTRWHnhlQuKLQdfPKlzrUOL6ZqWpOj3cxe6ToaD2MgoJX
9+yn8NCyWrZ3tB4jrlEt+XZ0fmlnVjSHNWBRTk5d4gkKak/C191dxUJShYLO
ozMU9M58TZksYqFwZE5HoBMFZzXjWTMPN+K6AUf6BJ2/wb+/B6aMNGKxEvuT
Ep3PWke+1FX/y0aFWkzMO7pew57UPKraBKFm5UZFuvZ3WZpqWtaELo7iKTO6
fYntDrb/yW+oCZw7oEn3P1/868oRoWZUSFUVcejzYzZbq++f2GY0CWUPqtpT
CJtYfGDTNg7yXQ02rjpMIS24PJ7TyMF6k3vCpfsojGselnVzb8E7IbGAKcYU
NieQ4p1SrTjuqx7ZRP9fMV+niMklt6KNNT3HYAOF5w3mlWJGbWgRXrbEeBmF
4xrb7aO72zCZGv2klc7nIzZvl+Rfa8ePuYtyhUXo8yiSOvBWsgMbFe5dyRki
oTbL9n7eoQ6cXGzyYKKFRNDPOXc8XnZgr/3T3V8/k+Bsv6/V+KMDe85f2r8p
jcQFaVc2W6cTBi93i65+QMJg1Uir2z+daLi0aFE6vX79Jl7MjGV1wnSLSk3N
SZI+76ac26fYBSe1uC+BRiTqvMa3B5/rwvr0JXOa6f21tq9bdkdmF+o07OZU
SJAo3T6jwflPFw6vawg6QudX06z2CAmDbgRx3QKjv3BRo1dZIBPWjV6x6/ZX
X3JxY2u6qD+rGx2chIzZN+n7TuwCe6vF9D1uuqaZjS0XTvJy0jfsexB0I1LT
VoMLm00S4aKJPaiI4CUtnsnFbbWxxNaBHpS+Vvsb192LuGtttqIbeiFg7cvi
5/bC6m/50GWPXiQRnWckQnuxIqu6Vz2nF60+ZZW/j/aiyYT9n8avXvw2ufmy
jG4XoeC6yGsbFxfmhXzxEO7FBxs3nwlvLh5eWzV3Wl0PPu5+5pmXR385LXBy
uBXXg91JlrEZv7h45ROfOOLcg9k6o6k9W0hUFf4usNvWg868tPsmF0k8PeIY
UCLag9Ggv85ceh5EdUeaVWu6MfzY1DWDPldD9VYFP3nQjWD1eOE0et/hPttG
yb4bJQNOya30utvftVwod3U3nnmumL81hsLW2WlKZ4e6YPav/jSigcLPNBnr
bdldCKGUTrpJ9iH1TuCSDT5d2KnUp2K2sw8nLd7370MXXvAzPK28+tBe2yMb
L9wFuTlJ7n6pfdCQ+t6vWtqJB3nbTzd39eGXfdddQUAnhmI9Xx2c349UaUvV
H4adwM/jL/4Y9WNQZmGO5vROyFn515V590PqoJRixecObDdxLXj3uh+fvQe0
Xgd0IMTF6fdXTj9e3zMsa9vVgYqb6zZJSPDgaxvveE64Azv006QdNXnoTdR1
jKfXueluKTOBAw8PnPV1tv7XhnPWt1Lu3+WhWth+XpQLvS98L/86QfCwYVdA
0OeeVmy8eU/Eqp+H4iqr6axDrTA0HX9+WmYAC/hTWZ+qWhBucT33sfYAJDwP
iMfrtsAu6veyX6cGYODyKOpSOgdD7clVnqEDYE0QBgbLOMie/yBONnMAqcOu
BQvuNkNBfU4w59sAXNhaXqNTmuHbveXah8kB2K9+38A9/w0RC4KdK5cOQkXz
07TvLU2obA02+6U/iLbc58qLjZvAfXx8gfGZQZhHa6udz2RDVDu05H3QIIyq
rAaG5NnYtf2F8d6kQeiyM+QTbzdi9IRMvHj5IOS+Hzn26DsLM9cKanqoQSSI
FW+oPcTCDOf8si4xPkSeNoyZFzfgULjlbZHlfKxZbCQsr9wAO5H3Eoa6fAhF
xNzcEVaPqBkzzVMO82H/V+d+0XAdsj4cN9vsyYe1ziPDpwfrEBpfINp1h4/O
AOWAvvxaDG+d6vY2kY9LW85veKJYCxd3fvDTIj4m8qbNK/OrwVKPqfuy2PTz
luWs+sqvSFB7WMgb5CNFYJElE16N66+rK3eJCNCuEDxhZ1WFGU9CLxXJCkDe
tM7Lm18Jh56Id0dUBPjl5kFqNJVj0bvzoQo6AthdibZrjv6C5CPhg8IWAhwc
G29NP1iGAJ5Rw/TjAlSEDM4ul/2MdqkGrQ1uArjNtwtZ01gK7WgH+Su+Avgd
Nqpou/sRH33UPfvCBLglpqL53aIEHUZXtL1iBIh0tlvrNPMDyNJwF5VXAjik
nv1x6EsR1j+mRISy6N/rkOIdJE7gzS/5sVFCgGSnejfn6/ngtkwzkC4X4EBB
gYjHT/oeoZFFmdQLkKGxaV/amRz6e/4G5xVHAIn0h2c1WzJhkLtg4ZpuAU7/
o7NT0TwdJ5VuxFX2CVDTKXZn+OYbvCld6hguEGCFuHJchkMSdr+q9rz8U4B6
wVSrRON4CIRKi26MCaBoXrLul0ocQiPzDFImBBgTsjV/tCgK7nqtYhN/BMiq
VA9VLwjExC3233N/BXA9925tx1wb9C+pX/+Hrhm/jvHrGL+O8esYv47x6xi/
jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/
jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/
jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/
jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6xi/jvHrGL+O8esYv47x6/4f
v+5/LlIGUQ==
     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.999999999998971}], 
         Scaled[{0., -0.006}, {0., -0.999999999998971}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4999999999994855, -0.8660254037835475}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.4999999999994855, -0.8660254037835475}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037835475, -0.4999999999994855}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8660254037835475, -0.4999999999994855}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.999999999998971, 0.}], 
         Scaled[{0.006, 0.}, {0.999999999998971, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8660254037835475, 0.4999999999994855}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8660254037835475, 
          0.4999999999994855}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4999999999994855, 0.8660254037835475}], 
         Scaled[{0.003, 0.005196152422706632}, {0.4999999999994855, 
          0.8660254037835475}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.999999999998971}], 
         Scaled[{0., 0.006}, {0., 0.999999999998971}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.999999999998971}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.4999999999994855, -0.8660254037835475}], 
        Offset[{4, -6.928203230275509}, {
         0.4999999999994855, -0.8660254037835475}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8660254037835475, -0.4999999999994855}], 
        Offset[{6.928203230275509, -4}, {
         0.8660254037835475, -0.4999999999994855}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.999999999998971, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8660254037835475, 
         0.4999999999994855}], 
        Offset[{6.928203230275509, 4}, {0.8660254037835475, 
         0.4999999999994855}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.4999999999994855, 
         0.8660254037835475}], 
        Offset[{4, 6.928203230275509}, {0.4999999999994855, 
         0.8660254037835475}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.999999999998971}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.999999999998971, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.795537299847313*^9, 3.795537378213553*^9, 3.795537493364236*^9, 
   3.795537556826221*^9, 3.79553766751022*^9, 3.79553773052052*^9, 
   3.7955377611802473`*^9, 3.795537808060082*^9, 3.795537878787057*^9, 
   3.7955379123446083`*^9, {3.795538090969741*^9, 3.7955381185470552`*^9}, 
   3.795538157567462*^9, 3.7955382254597807`*^9, {3.795538374145508*^9, 
   3.795538385599711*^9}, {3.7955384436265583`*^9, 3.795538501118574*^9}, 
   3.7955385426872797`*^9, {3.79553857270503*^9, 3.795538604267037*^9}, 
   3.795538660663989*^9, {3.795538702397184*^9, 3.795538770513549*^9}, 
   3.795538886768321*^9, {3.795538980087432*^9, 3.795539030541462*^9}, {
   3.7955390699104443`*^9, 3.7955390884108973`*^9}, 3.7955391304642677`*^9, {
   3.7956379211954613`*^9, 3.795637947579496*^9}, 3.795638055412286*^9, {
   3.795638182568494*^9, 3.7956381955771723`*^9}, 3.801029504131812*^9, 
   3.8010295505161858`*^9, 3.801029626271817*^9, 3.801029713404963*^9, 
   3.80102984809142*^9, 3.801029888248809*^9, 3.801029986449272*^9, 
   3.801030072800601*^9, 3.801031541642644*^9, 3.801032174680893*^9, {
   3.801032229570137*^9, 3.8010322507540407`*^9}, 3.801032294680418*^9, 
   3.801032332090818*^9, 3.801066652869112*^9, 3.801067066663249*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"6232e965-fd82-471a-8318-f9adf98ca1ec"]
}, Open  ]],

Cell[BoxData["tabr1"], "Input",
 CellChangeTimes->{{3.8010671026518373`*^9, 3.801067104324355*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"209257d9-7b83-47f8-80f2-1c4781a7d21e"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"08f28bd4-6fd1-4824-a426-92e4e4bf3343"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3d Plots of T", "Section",
 CellChangeTimes->{{3.795430731799247*^9, 
  3.7954307410983353`*^9}},ExpressionUUID->"ac7041ae-233c-4e7b-90da-\
dbdf84e81c47"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"V", " ", ">", " ", 
     RowBox[{"en", " ", "case"}]}], ";", " ", 
    FractionBox[
     RowBox[{"12", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", "kt", " ", "kx", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}]}], 
     RowBox[{
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", "kt", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", 
       SuperscriptBox["kt", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}]]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"tamp", ",", "tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ramp1", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
       FractionBox[
        RowBox[{"3", " ", "kx", " ", "kz"}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]]}], 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", " ", "kx", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], ")"}], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"kt", " ", "kz"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kt", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           "ky", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["kx", "2"], " ", "ky"}], "-", 
             RowBox[{"3", " ", "kx", " ", 
              SuperscriptBox["ky", "2"]}], "-", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
             RowBox[{"kx", " ", "kz", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "kz"}], "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
             SuperscriptBox["ky", "2"], "+", 
             RowBox[{"kz", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "kz"}], "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           "kt", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["kx", "2"], " ", "ky"}], "+", 
             SuperscriptBox["ky", "3"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "kz"}], "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
             RowBox[{"ky", " ", "kz", " ", 
              RowBox[{"(", 
               RowBox[{"kz", "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
         "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "-", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
          "2", " ", "\[ImaginaryI]", " ", "kt", " ", "ky", " ", "kz", " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kt", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           "kt", " ", "kx", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
          RowBox[{
           SuperscriptBox["kx", "2"], " ", "ky", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{"ky", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             RowBox[{"kz", " ", 
              RowBox[{"(", 
               RowBox[{"kz", "-", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "kx", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kt", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kt", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
         "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], "2"], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           "kt", " ", "kx", " ", 
           RowBox[{"(", 
            RowBox[{"kx", "-", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["kx", "2"], " ", "ky", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "kz"}], "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"kz", "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
             RowBox[{"2", " ", "kx", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "5"}], " ", "kz"}], "+", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}], "+", 
          
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
             RowBox[{"4", " ", "\[ImaginaryI]", " ", 
              SuperscriptBox["kx", "2"], " ", "ky", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "kz"}], "+", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["kx", "2"], "+", 
                  SuperscriptBox["ky", "2"], "+", 
                  SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
             RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "kz"}], "+", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}], "-", 
             RowBox[{"kx", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "kz"}], "+", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SuperscriptBox["kx", "2"], " ", "ky", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{"kx", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             RowBox[{"kz", " ", 
              RowBox[{"(", 
               RowBox[{"kz", "+", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kt", "2"], "+", 
           SuperscriptBox["ky", "2"]}], ")"}], "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           "kt", " ", "kx", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           SuperscriptBox["kt", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["kx", "2"]}], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
          RowBox[{
           SuperscriptBox["kx", "2"], " ", "ky", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{"ky", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["ky", "2"], "+", 
             RowBox[{"kz", " ", 
              RowBox[{"(", 
               RowBox[{"kz", "-", 
                RowBox[{"3", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], ")"}]}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", " ", 
      RowBox[{"kx", "\[Rule]", 
       RowBox[{
        SqrtBox[
         RowBox[{"rat", " ", "V"}]], 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
      RowBox[{"ky", "\[Rule]", 
       RowBox[{
        SqrtBox[
         RowBox[{"rat", " ", "V"}]], 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
      RowBox[{"kz", "\[Rule]", 
       RowBox[{
        SqrtBox[
         RowBox[{"rat", " ", "V"}]], 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
      RowBox[{"kt", "\[Rule]", 
       SqrtBox[
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"rat", " ", "V"}], "-", "V"}], "]"}], "-", 
         RowBox[{"rat", " ", "V", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "-", 
         RowBox[{"rat", " ", "V", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ramp2", "[", 
     RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"kx", "+", 
         FractionBox[
          RowBox[{"3", " ", "kx", " ", "kz"}], 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]]}], 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", " ", "kx", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kt", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kt", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
          "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], "2"], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["kx", "2"], " ", "ky", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "kz"}], "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "kz"}], "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
           RowBox[{"kx", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              RowBox[{"kz", " ", 
               RowBox[{"(", 
                RowBox[{"kz", "+", 
                 RowBox[{"3", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            "kt", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "kz"}], "+", 
              
              RowBox[{"ky", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["kx", "3"], " ", "kz"}], "-", 
              RowBox[{"8", " ", "kx", " ", 
               SuperscriptBox["kz", "3"]}], "-", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
               SuperscriptBox["kx", "2"], " ", "ky", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "kz"}], "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
              RowBox[{"4", " ", "\[ImaginaryI]", " ", "ky", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"kz", "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
              RowBox[{"kx", " ", 
               SuperscriptBox["ky", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "8"}], " ", "kz"}], "+", 
                 RowBox[{"3", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
               SuperscriptBox["kx", "2"], " ", "ky", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "5"}], " ", "kz"}], "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
              RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"kz", "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
              RowBox[{"2", " ", "kx", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["kz", "3"], "+", 
                 RowBox[{
                  SuperscriptBox["ky", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"kz", "-", 
                    RowBox[{"3", " ", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["ky", "2"]}], ")"}], "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            "kt", " ", "kx", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["kx", "2"]}], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
           RowBox[{
            SuperscriptBox["kx", "2"], " ", "ky", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
           RowBox[{"ky", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
           RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              RowBox[{"kz", " ", 
               RowBox[{"(", 
                RowBox[{"kz", "-", 
                 RowBox[{"3", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", " ", "kx", " ", 
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"kt", " ", "kz"}], "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kt", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["kx", "2"]}], "+", 
              RowBox[{"3", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
              
              SuperscriptBox["ky", "2"], "-", 
              RowBox[{"kz", " ", 
               RowBox[{"(", 
                RowBox[{"kz", "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            "kt", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", 
               SuperscriptBox["kx", "2"], " ", "ky"}], "+", 
              RowBox[{"kx", " ", "kz", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "kz"}], "+", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "3"], "+", 
                 RowBox[{"ky", " ", "kz", " ", 
                  RowBox[{"(", 
                   RowBox[{"kz", "-", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            "ky", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["kx", "2"], " ", "ky"}], "-", 
              RowBox[{"2", " ", "ky", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
              RowBox[{"\[ImaginaryI]", " ", "kx", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["ky", "2"]}], "+", 
                 RowBox[{"kz", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "kz"}], "+", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "-", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["ky", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
           "2", " ", "\[ImaginaryI]", " ", "kt", " ", "ky", " ", "kz", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kt", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            "kt", " ", "kx", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            SuperscriptBox["kt", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["kx", "2"]}], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
            
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["kx", "3"], " ", "kz"}], "+", 
           RowBox[{
            SuperscriptBox["kx", "2"], " ", "ky", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
           RowBox[{"ky", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}], "-", 
           RowBox[{"\[ImaginaryI]", " ", "kx", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["ky", "2"], "+", 
              RowBox[{"kz", " ", 
               RowBox[{"(", 
                RowBox[{"kz", "-", 
                 RowBox[{"3", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], ")"}]}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kz", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"rat", " ", "V"}], "-", "V"}], "]"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], 
              RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tamp", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"12", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]], " ", "kt", " ", 
         "kx", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
           ")"}], " ", "kt", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
           ")"}], " ", 
          SuperscriptBox["kt", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", "L"}]]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"L", "\[Rule]", "1"}], ",", " ", 
        RowBox[{"kx", "\[Rule]", 
         RowBox[{
          SqrtBox[
           RowBox[{"rat", " ", "V"}]], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"ky", "\[Rule]", 
         RowBox[{
          SqrtBox[
           RowBox[{"rat", " ", "V"}]], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"kz", "\[Rule]", 
         RowBox[{
          SqrtBox[
           RowBox[{"rat", " ", "V"}]], 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
        RowBox[{"kt", "\[Rule]", 
         SqrtBox[
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"rat", " ", "V"}], "-", "V"}], "]"}], "-", 
           RowBox[{"rat", " ", "V", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Sin", "[", "\[Theta]", "]"}], 
               RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "-", 
           RowBox[{"rat", " ", "V", " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], "}"}]}], 
     ")"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"tamp", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
         "]"}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"ramp1", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
          "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"ramp2", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
          "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"tamp", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]", ",", "1", ",", "1"}], "]"}], 
         "]"}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabr3", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]", ",", "1", ",", "1"}], "]"}], 
           "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]", ",", "1", ",", "1"}], "]"}], 
           "]"}], "2"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", 
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "1"}], "]"}], 
           "]"}], "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tabr2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp1", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "1"}], "]"}],
             "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"ramp2", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "1"}], "]"}],
             "]"}], "2"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"p1", "=", 
  RowBox[{"ListPlot3D", "[", 
   RowBox[{"tab1", ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<T\>\""}], 
      "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{",", 
      RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1r", "=", 
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"tabr1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<R\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", " ", 
       RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], 
     ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
     RowBox[{"(*", 
      RowBox[{",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}]}], "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"p2", "=", 
    RowBox[{"ListPlot3D", "[", 
     RowBox[{"tab2", ",", 
      RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<T\>\""}],
         "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", " ", 
        RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], 
      ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
      RowBox[{"BoxRatios", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
      RowBox[{"(*", 
       RowBox[{",", 
        RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", 
         RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2 m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.5 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}]}], "]"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"p3", "=", 
  RowBox[{"ListPlot3D", "[", 
   RowBox[{"tab3", ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<T\>\""}], 
      "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{",", 
      RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = \!\(\*SubscriptBox[\(V\), \(0\)]\)\>\
\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p3r", "=", 
  RowBox[{"ListPlot3D", "[", 
   RowBox[{"tabr3", ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<R\>\""}], 
      "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
    RowBox[{"(*", 
     RowBox[{",", 
      RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = \!\(\*SubscriptBox[\(V\), \(0\)]\)\>\
\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d1.jpg\>\"", ",", "p1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d3.jpg\>\"", ",", "p3"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d1r.jpg\>\"", ",", "p1r"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d3r.jpg\>\"", ",", "p3r"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.795421465666741*^9, 3.795421466035664*^9}, {
   3.7954215364978333`*^9, 3.795421537453836*^9}, {3.795421625984447*^9, 
   3.79542164472902*^9}, {3.795425652784513*^9, 3.795425726098669*^9}, {
   3.795425758789545*^9, 3.795425774190296*^9}, {3.7954258333647003`*^9, 
   3.7954258685311937`*^9}, {3.795425920873761*^9, 3.7954259297513447`*^9}, {
   3.795426037708872*^9, 3.795426104854391*^9}, {3.79542616329585*^9, 
   3.795426234595022*^9}, {3.795426336796217*^9, 3.795426377106432*^9}, {
   3.795426807472982*^9, 3.79542682091676*^9}, {3.795426884511804*^9, 
   3.7954269331217527`*^9}, {3.795427076232342*^9, 3.795427086538158*^9}, {
   3.79542832703578*^9, 3.795428354518651*^9}, {3.795429513366081*^9, 
   3.795429592745058*^9}, {3.7954308304701157`*^9, 3.7954308349068832`*^9}, {
   3.7954309431983*^9, 3.795430947373246*^9}, {3.79553348574975*^9, 
   3.795533522270814*^9}, {3.7955340551678267`*^9, 3.7955340561764793`*^9}, 
   3.795539325514901*^9, {3.795589157271555*^9, 3.795589169302174*^9}, {
   3.795636144165728*^9, 3.79563614512151*^9}, {3.8010323832215633`*^9, 
   3.801032546324602*^9}, {3.80103265042903*^9, 3.80103265113846*^9}, {
   3.801032717576054*^9, 3.801032719713833*^9}, {3.801032961315099*^9, 
   3.8010329622884817`*^9}, {3.8010330514588118`*^9, 
   3.8010330629662933`*^9}, {3.8010330979308853`*^9, 3.801033217443677*^9}, {
   3.8010332902265863`*^9, 3.801033356662648*^9}, {3.80103353518967*^9, 
   3.801033539918291*^9}, {3.801033595361967*^9, 3.801033598359577*^9}, {
   3.8010336651013327`*^9, 3.801033730645124*^9}, {3.801033785829723*^9, 
   3.8010337876777287`*^9}, {3.801033855587998*^9, 3.801033911760269*^9}, {
   3.801067449187317*^9, 3.801067458073296*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"176b1805-f0a3-493a-8485-4d9ea0aca0e2"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxc3Xc41f//x3FJJQ0l2lMpaatEyVE0RCKj0kAlFdGQVaRCZEWkQtk7RGS/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    "], {{
      {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1nXn8FdP/x+d+7p1z5n7mViQtJJKkkkqSJPuWRLKmJEkksu/7vmYLyS4k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           "]], Polygon3DBox[CompressedData["
1:eJw1nXf81tP7x9/3/R73ezS0pElDS0qEdhKSjKRsEaXsvffIJnsrGS0itCQZ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           "]], Polygon3DBox[CompressedData["
1:eJwV2HmczeUeB/Bj7GOaJlkKWZMlu6ZpSCIkZJnsSlLJkn0LyU1C9jWhbtdt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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0llSU1EUQNGLBgkqAmLfJkOgmEAyBGQCCQPQophAMgTKCSRDsPjyjwwB
Iip9QieNgDGCfbOO+di198d59e477+anXzx73pdSeo1LiM5jfiClIpfR1FWu
o6sb3MZY1rwH8pjQRS5jSle5jlnd4DZexryX5DEf81xGM+a5jm7Mcxtjg+Yv
m8eELnIZU7rKdczqBrexjaX+lHZ4F029x/t4oz/wAZb1IR/hrT7mj3inT/gU
7/UZf8KK7vBnrOouf8GaPucLrOuv/A0b+jv/wKb+yb+wpX/zH7T0X04ZzXO+
Y4FrmNEVLmFSFziHcZ3iWbsZjXmuoWNnFS5hURc4h1fZ3k9t2f2cXuAaZmKe
S5iMec5hPNu7AC0ajXmuoeOfV7iERV3gHJ7isfM/CeOhfhTGff0gjLv6Xhi3
9Z1w3B99Kxzv0zfDGNYjYQzpG2Fc09fDGNRXwxjQcXRHS/36SjhWlfm/3lhZ
6sv07vc/2FJbeg==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwNyFk2AgAYhuG/K6fTKmzIhR2UTEXtxRAyFTIPnTJkCIVkCjvqufjO855v
NFMcLyQiYsyaIxELyYgG06mIRX2pl3jFjG9ZX+sSbzjhW9EtvcpbZn1r+k6X
ec9J37p+0Btsc8q3qR/1Fp847dvWz7rCDmd8Vd3VO3zhrG9Xv+o9vjHnq+me
3uc7874D3deH/OCc70h/6mN+cd53or/1KX9Y8J3pgT7nL4u+C/2n6/znEPKc
NmU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAUhuHjyhOrsCEXltACFEKkRZlKhsyzuihjiCTJFDvwXpzn/c4/
kkyNjQ9ExKirD0YsJiJq7A9FVIcjLvWS7Ypp/7K+1iu84YRtVd/qAu84aSvq
hl7jPadsJf2g1/nIjG1DN/Umnzht29LPuswWZ2zb+kXvsM1Z265+1XvsMGvb
12/6gF3O2Q71uz5ij/O2Y/2hT/jJnO1Uf+kzfnPBdq5/9AX7zNsq+ldX+cd/
4o0/eA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAUhuGTqcm4BBty0RJaADsQkdTmhMiYMoVukjI04L04z/udfz2/
ldtMRMSG+0hGHKUj+uxldDZioGu2Id9tNdunPrZ9cdt/or/1KX9YsNX1SJ9x
zB3buZ7oBqfctV3oX33JPxZtVzpSEddMcM92o2f0LWe5b2vqOX3HeZZsLb2g
20zywHavU/qBaZZtjzqjn5jloe1ZL+oOl1ixvehl/coVVm1velV3ucZ/JdI2
Hw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzlk6AlAcxuF/yNRdpjInaRCxERctoQWwEENl2ldsg5AyF6+L87y/812c
5+QaJ/XjREQcOXPTEQ8zEWn2ZiM6qYh5/Whb4Kvtzraou7Yl9m33tox+smV5
6v6sl/ULV3hm6+nV/3e4xnNbX6/rATd4YXvTm/qdOTZtH3pLfzLPlu1Lb+tv
Fti2/egdPWSRl7aRLulflnllC/+u6AR3eW0b01U9zj3e2Cb0vk6yxlvbpD7Q
UzzkH1U5KFg=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyVk2AmAYx+HXjZMSITKE2gKNMs+pTEtw3WE5EtGikpUYLj0X33l+7/8r
PjzdP05ERMfbTkQkkhFb/OYoFVHSU7rMH37aKjqpq/zl2FbTKV3nH79sO3pa
N9idjNhl2r3HZ/8zel/P8oA9W0Yf6jke8cU2r4/1Ak/Yt2X1qV7kGV9tS/pc
53jBN9uyvtQrbHJgW9VXeo0tvtvyuq3X2eGHbUNf603ecGgr6Ftd5B3/AQHt
HME=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyVk2AmAYx+HXjeOwCkMyJRlCe3DTIGRMlKFiHVahJO1I2AhxjufiO8/v
/X/T1Xa+NRYRe15hImJmMiLPb75PRRT1rC7xh0Pbvp7TZY74YTvQCX3IX37a
jvS8rvCPX7ZjndQnfBqPOOWC+4zP/hf1uV7iBTu2ZV3VK7xk15bSNb3KK77Y
0vpar7HOni2jG3qdN3y1behbvck79m1b+l5n2eSbbVu39A7bHNh29YPO8ZH/
HFAk/A==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyGk2AgAUhuFb+eFkFdZhzlCSoiVYQM5RmcpQ5iJsg0wLMlT7wPPjnue9
3+TWdrmSiIiiq45HTKUjdvjLz4mImp7Wdf7xy7arZ/Qew//t9vWs7YAJ/487
1HO2BpP+gWvqedsRU/6hO9YLthOO+UfuVGdsLT75F3VbL/GMz7Zlfa5XeMG+
LasvdY5XfLGt6mud5w1fbWu6owvs8s22rm91kXd8t5V0T2/wnh+2Tf2gy3zk
P+2fKUE=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAYRuHfRTTYhA11IWPmBukmewmZ50SmyJAFidImvBffc853pgrb
07WxiMjaTjIil46oYyIT8W27fEbbw3G/bw0+q+3jhP9jB3xOO8Sk/2tHfF47
xpQ/sBO+oJ1i2h/aGV/UzjHj/9kFz2uXOOmP7IovadfY9Zd5k6/gDb5pq7zF
1/AW37V1fsc3sI0fWoHf8yI+4KdW4o+8jE/Y0zb5M69gB7+0Lf7Cq/iK/60C
Lfo=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk2AgAcRvG/N4eTKRZgQx4socekREqjPZGhkQwZC/sQoQX4PXzn3u9u
pnLb2bmI2LLT+Yj0QsQJJhYjPq3Jd7QzXPInds4z2gUu+192yXe1Fq7439bm
Wa2Dq/7Uujyn9XDN/7E+39OuMOn/2jXPawNc9//shu9rt7jhz+yOH2j32PIL
fMgP8QHbWpE/8hI+YUc74s+8jC/Y1Sr8lVdxhD2txse8jm/Y1xr8nR/jB/4D
n800hw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyEs2AgAcRvG/mZM5Ijk2ZGAJLYAtEEJ6CPvx2oF3eSXkEdIAIY7f4Dv3
fnciMzM13RcRk3bQHzGbiNjHwYGIdzvkc9oRDvkfdsyz2gkO+592yue1Kib9
rtX4gnaGI/6XnfNF7QJH/W+75DntClP+j9X5knaNY37PGnxZu8G0/2u3fEW7
w3H/z5o8r93jlr/KH3gBH3FbK/InXsIW7mhl/szX8AV3tQp/5evYxj1tg7/x
TezgP42AOvY=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyNdZAgEQhdFZ4i4gYgeiEqQYHyiBArAaMGdQCkHtRzAjeB7m+++c5uC4
P0wi4sgt0ohRJeJNd6sRG7e0x+xdm/6oRXzYJ+xT91jCvuxT9q37LMd+7DP2
qwcsz1b2OfvTFiuwtX3BNtpmRRZZxCVLtMNKLGdfsbx2WZkV7GtW1EOWspJ9
w8raYxlL7VuW6Zzd2RX7Xqv6zB7smj3RLX1hU7tuP+q2vrInu2HPdEf/ARYs
JW8=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6ggEYhuHPob+IBilDRYY0G1pGB5bQAliXJJJENoBVdR+81/Ned230
eP+wERFDy21GPCURWW2mIpJ0RN4fs4K2WIrt+c+sqG2WZvv+hJW0w7ZY2X9h
B9pl2+zQn7Ij7bEMO/ZfWUX7bIdV/TdW02u2y078GTvVG5Zldf+dnekty7Fz
f84u9I7l2aX/wRo6YAV25S9YU3/Zp9/yl9rWP/bld/xv7eo/W/k9/0f7ugYY
VhvW
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVyFk6AgAYheHfpbhOolRLiDTPRaYMS7AANhhNxsqeel2c5zvPm39+fXrZ
iYixne5GTBIRRS3vRST3I878N1bSCjtg5/47K2uVpVjFn7Kq1tghq/kzVtc6
S7OGP2dNbbAj1vIXrK1Ndsw6/pJ1tcUyrOd/sL62WZYN/E821A47YRf+F7vU
Lsuxkf/NrrTH8uza/2E32mcFduv/sjtds5U//v96rxu28R/8P33ULeRRITQ=

        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFdSAgEURcHnp8gmLFEwoYtQzEgQc0BUMM7gQg2AOa3F/rh1bvVoK60l
QxFRtvpwxGMmoqYLIxFj2Ygt/4k1dJHl2Lb/zHa0xMbZrt9je7rEJti+32cH
uszy7NAfsCNdYQV27L+wE11lk6zpv7JTXWNTrOW/sTNdZ9Ps3H9nF7rBZljb
/2AdLbNZdul/sivdZEV27X+xG62wOXbrf7M7rbJ5lvg/LNUH9ut3/T+913/R
3yak
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk2AgAYhuHfpdiEJRAhZAcuKhnDsYCcY85UpkRIK5RkjjV4Lr7zfucZ
2tzKlvoiYs52+iOeExHbmh2IGB6M2PXbbE9zbITt+y/sQPMsyQ79DivrPBtl
R/4rO9YCG2Mnfped6gJLsTP/jVV0kY2zqv/OznWJTbAL/4Nd6jKbZFf+J7vW
FZZmNf+L3egqm2J1/5vdapFNszv/hzV0jc2we7/HHnSdZdij/8uausFm2ZP/
x1r6D+DtLDI=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwVzr0uA1AcxuF/xUficzOhEaOSWKkL0IrBRE0s6MCmegHFBZReQHED5QbK
XPExWCTVGJvQwap9DCfP77zDyZndO948SkTEhpPoj/gciOjjD3dHIpK6qxfZ
cB8fjFjV01znky2ld/QK83y2ZXRRb/OCb7YDXdEF3vLddqbv9SUf+WG71q+6
xha/bHXd+X+b4T9tW1NP6G/O8Nf2pxf02FBEml3blM7qeeY4PBqxrA/1Gk85
advS53qfV5yznegbXeIdl2xl/aCrfGEPwFQrLA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzjkuBFAAxvFvYlDMBN1UtkRpSbSWA9gK3aCaapCgsxzAcgDLASwXwAXQ
i6GYRoIoJSi0/BQvv//7ipfXX1ufXyskmXNaislra1LkF2ulpE+nLRlhJzds
k7pHz/LefUgv6XGu8sE2rXf0Ag/4ZFvWJ3qLF2za9vS1PuIdn21n+lFf8o3v
thv9/f82C/72YXvRXfqTvfyx/eph3dGeTDDlpFvP6EEusmQb0yt6itus2Kp6
X9d5zAHbpj7Xu7ziqO1Q3+pTNvgHBtMpHw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0ug1Ecx/H/I/oYNCmbCc9gpE2sXi6gdOhYLExeQmxFYkUvoOUCVG8A
N4Ab8DJYmqgYJWXo6mM4+XzPbzg52eZBdT+JiIqTG47o5SJS/nBrNCLTSRpR
4hgPbct6Slc4x1Pbhl7Ue3x2X9Eneo0Nvtl29JU+YofvtnN9r1t8YtfW1q/6
lp/8sj3o3/+3OeRv37YPPa77nObAFiMRRV3gEpN8xKRe1bNcZ962oHd1mcec
sNX0hd7mJWdsdX2jz3jHeVtTP+prvvAPcCMoHQ==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+G3VdpEJdXNRA1GKrGqXkBVYkUHMTkmNq3E6nABbV2Aww2U
G8ANoINFQmOUVAejx/Dl+b3/6StsHqzuJyKi6qVTEZ/DERn+cGs0YlonRyLm
Oc5DW1lP6RXO8cRW0yW9x2Ve2I71+n+z697Rl7rOW77ZzvS9bvGJ77Zr/ao7
7PHL9qAH+plD/vZt+9B53WeBv7ZEOqKoc1xiMhsxqat6lhscsy3qXV1hgxO2
NX2ut9nmjO1I3+hT3nHB1tSP+oov/ANdMygk
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0ug2EYx+G72hKtSLCZvAxGH4m16gBexIwmTUyqBpuPxOrjAEoPoPQE
cAI4ASxdJIhR0nawuQxPrl/+9/Ik1f2NeiYiUm84F/GZjyiwx51ixIzODkYs
cpwHthWd6HXO89RW0cu6zlVe2k701n+zxiaP2GbH/Vw/6Cs+8912o9/0Hb/4
bXvUff3CnH/92D70hO5ymr+2gaGIBT3GMrMjEVN6Tc9xm6O2kt7TKY85advU
F3qX15y1HepbfcZ7Ltka+km3+Mo/odcnkA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr8ug2EYh+FHfK2hTSTYTFWDsSrpWuz+7koMpmoXW5F0RWdpOQDqBNQJ
4ATK3KQVowRDJ5fhzXXn9yxv7rC+W5uIiA0vk0SMUhFZ/vAoE7Gok3TECmd5
YlvXC3qHy2zaDvSqrnOLLdu5rvw3j3ltu9Wn+oGXfGKHrxy43+t3/cgPftqe
9a/uM+VfX7ahntPfzHNsm5yKKOoZrjHJRuT0ti5wn9O2sq7pTZ5x3ranr3SV
N1yyNXRXX7DHkq2tX/Qd3/gHnMcnmQ==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0uw2EYxuGnSf81KGmCzaIYjGhi9bGr9gBaunTSWmxaiVV1Fh+D0ccJ
qBPQnkCZJYhRgsHiMry5fs89vTO1ZrmRiohNbywd8ZZEjPOb9dGIeZ1kIgqc
5L5tQ8/qMpd4ZNvRa3qPW+zaDnX1v9ngqe1St/QdO7yyPehzPeCL+0Y/63u+
88P2qH/0kBl/+7S96in9xTn+2tIjEct6gutMshF5XdKL3GbOtqqbusg2p20V
faJ3ecEF24G+1cfsccV2pvv6mk/8A4tTKJU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr8ug2EYh+GniX4dNFEJNoMUg9GfxErNUu0BtDqZWl1sVGKlnQUdOhYn
gBPQnoA6AcQooYPBZXhz3c9vehdqjVI9FRG73tRExHs6IscfHkxGLOskidjg
LI9sO3pRl7nGM1tNb+sm99ixnerqf7PBS1tXn+h7XrBne9LXeshb9m2v+kF/
8NP9rMf6hRl/+7K96Tn9zSX+2tKZiHU9wwKTbERel/Qq9zlt29KHusgW520V
3dZ13nDFdqzv9DkfuWm70gPd54h/lQcoqw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzzsvw1Ecx+GfpO2/iS4kdJNIXIaOVGJFV0kvL6CtyaJlsbkkVmUWl8HY
6mDFGyhvAG8As0QNEk+Hk+dzvtM5s81WZWcsIjadiVTEZzpikkNuj0cs6iQT
scJp7ttKel7XuMwT25Ze13us8Nx2rBujZpsXtht9qPvs8Nb2pK/0C3vs2t71
g/7igPe2X/2qs9727f6h8/qHC/yzZZKIop7iBpNcxJyu6iU2R/+zreldXeYR
Z2x1faZbvGbBdqDv9CkfuWq71M+6yzf+A6OfKME=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+FXglbYKmWTDg6D0SHpSo0dqi5AmQyOi01JrFqzqA7GageT
BDfQ9gbKDeAGqkPjMXx5fu9/+jKlo8LhSETkvdRoxPdYxDR/eTAZsaST4xHr
nOG5bUsv6B2u8tq2rzf1Gbd5a7vSpf/mCe9sdV3WLVb4aHvXNd3lExu2T/2q
f9jms22ge3rC3774YpvVfb3IoTuRiFjTaeaYnIqY10W9wj2mbBv6VBd4yTnb
rq7qYz5w2Xahm/qGb8za7nVHN/jBP7YHKNU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzqtOAmAYx+HXzRNixFOTAhiMHjarYiN44AIQEhvOQ7GhblaR7DwEI0Ig
uak3oN6AeAPiDajFx/Dt+e0f3n3p0u5GbSAiCt7EYER/KGKSP6wmI+Z0Yjhi
mdM8sq3rrC5ykWe2il7Th9xi03aqd/6b+7y03epj3WGDd7Znfa3feM+W7UM/
6i++sGv71e96zN8++WCb0d86x9ERt2xLekrnmRiPyOhtvcAyU7ZVfaA3ecJZ
W0lf6D3ecN5W1219zieu2K70q26xxz/Hpyjl
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzzsvA1AcxuG/xCW0qxRbJ3ToWCRdXSZDo7VTpqZNisXmklhd5qYYjKWD
SVIGK76A9gvQL4DB0+Hk+eUdTs5Jb9UK1aGIWHdSwxHfIxFT/GUlEZHRE6MR
S5zmoW1Nz+lNLvDMtqtX9AGLvLKd6vKguceG7VYf6zYveGd70df6g/ds2Xq6
o/t846PtT3/qhLd98ck2o3/0PMfH3GVbHPxBr3KWr7aSzukdTiYjlvW+3uAJ
07ZtfanrvGHWdqQf9Dmfmbc19btusct/QAMp7g==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0uA2AYhuFX4idpewKtial0MFKJ1c9ikCizUFNroBYbmli1ZtF2MBZD
JwmGJp1wAjiBcgKtxGX4ct15hjff1M7BRnkkIta99GjE91hEhkOWkhE5nRyP
WGSGJ7Y1PaO3ucAL275e0ccs8MpW1Xv/zSNe21r6TD+wxlvbi27od96xbfvS
T/qHr+zYfvWHTvlbn4+2ST3Qs0xMuGXL67ReZZZd25ae10Uus2er6E19zulU
xK6u60M2OWc71ff6ks9cst3oN93mJ/8Ap8gq7w==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzjsvg2EYx+FbQjv09QXadzE6DEaHpKvDYDBUrRKHqV1KFxuaWB1moR06
lg4mCQaJGOgXwBfAF2jFZXhy/fIf7jxjG9XVylBErHiF4YjvkYiUA1ZyEVM6
yUTMs8B927Ke0Ouc5bFtRy/qOtd4bmvorf/mLi9sLX2ouzxl2/aor3SP1+zY
PvW9/uErb22/+l2P+tsX72yp7utJ5rJu2eZ0Xi9xnE+2sp7R21zgs21Pl/QR
N/liO9M13eR0EnGgb/QJH1i0Xeo33eEH/wD/0Svm
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+FX4jCo3oBWYkUvoK3EqiQGi+poQBedelhsDonVYRatwVgM
JgkdmjQkuAF6A+UGHB7Dl+eX//Dmm96orO4MRcSKlx6O+ByJmOIPK+MRGT0x
GjHPFHdty3pWl5jjka2sC7rBIs9sh3rrv1njue1S7+tbnvDK1tFN/cZrtm19
/aC/+MI7269+10l/G/Deltbfeo6JMbdseT2plzjDrm1dZ/U2F9mz1fWaPuAm
n2ynuqpb3OOz7UYf60cuJCIu9Ktu84N/SXEs0Q==
        "],
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzsmvdfze//x4skDVKUBkJpUlIR6YGMhITqTcqoFGkpIyGplJFKQlZEKtFQ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     "],
    VertexNormals->CompressedData["
1:eJwsl3c41f/7x0VpaAgRDYmilE+UkeiuiEolUiQNSkNKSZkZIZuyshJZ2ZvM
295773U2jkNGyvqd73X9zj/nul7X+7zO+7zP436+ng8hAxNNQ1YWFhbYysLC
xnz/+PWGwKlNj5FuL+sgs/kxdrjufje7xoDKjWj5yuItTokd0lcqccTNwtNV
n5jrCqIdd2cM7JBLIEAtwTQUv+s9GGtZZgDLasyTizNOSAkpzJCrTkDdSsnf
d+cYENggdkLyrBuyhTK8OQqycZ9A1kTTKAP63ZXX4p944raIGn4Bc8S7bX8/
8ZUyIP7tB2/ty97I7a/MtWdrJa6JLvwN8GEAQ5GPxb7HG2NpoyvR7nVYd+yM
Lss1BlA8kut37PFGn5bXz7fMNeOzGGnR/KUp+GRV+NH7qCeW/iL2/PepDY84
p3q6R0zBJaP7m15KuKGCm/Er89YOzDzOWN95fgrEuPd0cdx2RqvMfonB2i6s
6w7KCyPT4VKOh8nudnvMKFeK1nnUg++jTAdDAuggP9Z1mZhgjj8XZbnTA3tR
JNG41k+LDnZ+DlMnRIxwN0/uhZ0P+/Crg23irCgdONmvaevqnseSkaODeUV9
aFgfIhvFRYcnpbcTQ+z14QZr2eadqX3odbN/3/IuOuyJFDnEb/QWtP8bXTx+
qg91f3l61EjSwTpQ8wOb+weQemEqOnGtFx01hTcrPaZDpmDmjQ/PHUFt87Py
D6vduMPL1Hh3Ah24j9QccbNwgbyWJTbHK114XoUSZblKh3ua0+bile6QE9J6
6Z58B8r/EBi5eXcKBi8NiQYLecE3llv3g/pbkbvrj35V3hQ0ZIsXaj3yhtWw
KOsWxyZsuXrz6QgXA9Q/O4zXPvOGpZUqc5/ttZjVd8s54CEDXkUeDwJBL9D1
lX9YElCOch71jpnhDHit+0PV1sUd/oxyqi7nF+Kuuc+83vUMuMmbSsjM/QR/
BYJ/n7+ZiZsX70ftpzLgUmJECHufA0zrVJyYGIrFL24rtI9/GIAbsyRXbljA
rv0Hm1LaA/Du7ogvqysMuLwkYrkS/hSsCHoxkkNWCP5tR+qY3LL8/8s14t8g
cfEy3tfU015jru/MyD11fdQRp4p1KFKFb9FvwKrXibluIaB3sIz/M3brflyY
lfqMguZEtQXm/ofJLUqHJ0NR18kxKSsjDqXrP5WKMznXDXcYoe2MQgG2J4ED
33PRvG1dwq1uBkxL3fEK3xGHd4XIluuly1GtK+9NVwgDiJbixLaseCSqj2xz
t6lH+WDdwhsyDKgTeN/4aTIBX0qd33l0rRVNE2U4ouKnoPNBXdCG+gSs4LBS
Gubpwts8PrdYVuigLd/tccUxHoOn1A5taezFQL2Gm+mKdEj6dfKi2q04DGqc
5VDcOoj9LpZHdlpNgg0Pz+Zp22j8mSzskFwzjJm7+2aaiycg9FXkxIZTkbjt
6mRa6rpRhMmtW4Z2TcC7SEr7FblQTMz0l1QdHcVXkstxrz6Nw8+OWSiP88ND
D/xdlj+NIbE2hvR61zicSd55sbnQBUN1bKi3F8ZQd0ksSbCKBunxm/R/lpqg
645PJIokARNNBG/ZhtDgAoH/HSXFBK4+Pt4/L09A4/3chzL8aHAz5miea4YL
OD/Im1LfScC7zhU3pDJokND3Quz5Nz9IIY1+Ops5hlMbxw3r5mlwe9eHvQuH
Q8HzgfB9331jeG3GWNfo3jgozW/x0RONhI3DNfoktVEc7rnNhuRx4LfcZLDj
VTQEci5xyZ4ewYtqIXe+eE2AT6g9x4ZzcXB9ykpVs2wQe/n2Cy9dmYQcnZ/1
PM/jweqaxNhDpz4U3//lSQIPHXrnrPaaJiTA7gMt5LLSLixNbCUVDNAhZs9A
TUhZAhT8oGf4fm1j7m+Sx+Y3BbSMkXUWNvHw8AO5mceiAeNEiWceizEgK+/O
tuXSWGD3Xe07sFiOBoGmW+z8GJAXwJKV8PMHuCCHzXzBL1Qi+E2c6mDydpY1
zmooBHYFsVVNisejlu4j3ouzDGC9rXbKOtcLTjp9MFOu/oK75nt5KUxuV1Tl
5/d8N4cZU4GG+8ffIHn4Sur/5mKw+mRoU0UoVrX9upZJtsOYPeGCRcw8p81G
cV9h8s32trvukXQY3ij9vLSHyTmqeW3x48jGhp54x+/C2eg2Stx7soYBmgmp
Xx45FmLaJc62jg2V6PhxdJz7HnP/bV4729tKkHvM90wotmDZ19ed/UFTsL31
v/O3BcrwndJeKzHZbnzK71YUZkmHrpmdChukytBoRv3HdqVBVJNRl6LzTYLp
pmlKk24pFvbsURiDUdznwRc5FTwOFUNEAeUSxGv7o5M9DQk4tlfYrl2YBu8F
9rhZsBdi9OyWnap8JCzaJDGg0kyBltXQA5nkXBwy7wmTekzGcaXhU6cTyFCs
5Vc9GMbMnTY5z+l7FDRTq90UnEcC8183L3b7p+DzF5e9XXmo+Oahhj1xmQhj
S2wTPSsxWGSR97TLn4r8NZ+d+d4QgZetNkFpKQSr9PlOKlGp6Dl/ZNMPLiL8
7aa9XH/eCU8es3q3wkNDlb5nBV+GCKBj+mjzSowVBPV7mF7cT8PezJ1pUu0E
KFVxez9i/RVq/UdehK+n4ba6BhfdaQLYte7Yfl0mGnZAr0hbJRVlPo2XWskS
Yf8PjyvXy5NA7Gunf4keFU2h0tM+kQjksEPGpakZEBW6cHmthII7dgg+enOD
BHf9n6Rc+JsDUbXBcQ/JZAzvcT0XeJQMXhdH7G8dLIBJi8I7qYUk5GpcFB9T
oMBgzbuupoVicNz8O/LuCSKSBNmED3+iQsA0jysbZymct/HdFHR8DEM/bjfp
W6aB4+nzE+d3lEFVaOFR4RvD6D+1gdvIfQISNq3jKj5SBtubreMab/TiLoOU
a66b6dBwT91ClqcUgpzKdwnmtKHfg0s8Jtem4G1CILH1RhHkdKnXrd6oQRcO
dp3JkwwQP1n45OhKNvg89wu6xchDf77t/i9yGVBeuvGre2Q8+IrMkg44RKHP
HO1JFYMBU07tJdJKIVC/WjH78KQL2gg7eVYzOd/hVKMdJpqIJd1PLySpO6NQ
1Y1MdibnUjs8Jn+n5SKtdl1ws1oUfooNWlvrYkBv+FUfu+UKrM5851mQWoi6
omPHu/QY0Lh1rmIsvR53bPxwIra2Hs0cdyX9ejcF2p7HEo/aNOPGfxt+9Gl1
ovP5vQ95D9DBlysrOOd8C5r+UukLeTiAeKHbPMVhAlZLJlNUnjdj3eaTgT7/
jWLoPZ8os3YauD89Xi453YBn2X/OmHsT0FPn6ZUNKlQQK14YsMivRTPW8pab
OiS0dzTQmp8jw+pWuXue0lU4nmD1QjGOjHny4eKpVBLkJrvG5UWUocbquRfN
gRS0vyrrGLCPBLU+SpFissXon8Y9W3KWiuN2Jid03Imwq+H3y7LHubjpJ2F/
WToVm221CmaFiSCw/vdkfEMaLnDlu9NWqBhrJUYaGyZA9FLCl8LaaBzdu2yl
f5yGLQ9yRG5mE0B0+PSu5TefcYGaf2hUhYYZ/ANHRr8RgMvtn8M7dgf4XvZH
mnaNhm/zdg3sDCSARdFji7qWCFB5Xyg8fIGGu9tKJryZ1z9XNFDvDUuGoJeX
XPcL0/DZNoNY4VwCFAXGlvg9ygYH8X3uq8y5O3rCN92eSgB+r1/HzkgVAifH
TZ1UDyo+racMdJ8mwrTsytzOb6WQJkKXql2loOukUMSdbCKMbp2csThVCYub
pkctJCnYcX4w4t0TEmyR2pLyrqoGrsXySlpvI6Op0YqAsQ4ZrF5Mkq0EGyCc
HLzQ8J6IImeTZM77UaC2KE8oY7QJYI/5cdvrYyh73/V13S4aCBnWlJ050wLB
TlvvF/8bQuWfrm8iGsahd4N34/LmFjhY1H7hEm8PSls/kSpwn4TBRCN55bkG
WP5PrHvAvAWtP35zlOacggslf3csFVWBYc7rknOGZaj7yMnmjCgDhMN3urcm
F0Bq050o1p4kvJChUk0oY/afs92HRU1TYfqysHWLui8uUK6Q5Zhz8XH8RORd
zhwUfUoh7cpyQ81o8eihEQYcNI9fc7tSjmRVwYWXunHYu2GyojGYAcZ9UvnC
xS3YT3/KdnO6BPt11mq3MPN83lg16tCVTvwo0an+4Fszju1YVWwQpENTWOzF
vee60Q4NNt2/0Y2vMhrqcl5PQM7LHlMB0W4UoykZuVAG8WGKH3dCCw1iCrJO
tWV14mKz52azL6OoG6fWuviGCipbTmS8cG5HmlDg3xk7Aj7VkDli/YICHJI7
NfLZWtFdovCRSxcRfa680d+DZPhZPWeqPtSAyS/m655lkFB3j2L5nAEZvjZQ
5r+3V2Pjrcn95/4jY9iLtiFLVTKI29VfLd5UjkXKBrJUQzJqPnl3wUmXDCaB
lrJXdhXhl6vJH7VfkvF8wFRpvysZpIRLoDg9C/N+KYPmXTJu8JZY/sz8Xr1h
ZT/JiHiMlhWvzFIio4PDysZyOhmuNCsy7vEH4Pu92dXnZMg4QhY3imWngGGU
4XodQQeIO321e/gMGQOfHBA4y0YBv6t+B4zuRMHcVfOxJi0yXi3m7FYhkKHq
qw/MeabDeW1xjWILMq5fWb9/fzIZ3O9fX9Nl5EGc+zbZ3iAyigsIzGcYkyFM
x0Uj8F0pFLzScAj+Qcb9a4b/GiXJoDrE0b7nfBU8O87zbtmBjDMTPpFy28mQ
IB1MFVCvh4aQ7CfHDpLR/srlKHUeMpSHls2tnG+BgG0VRYHGJHwxuzlA4jYZ
jkJTt1VHG5zX+OJwRpWIBdNVeb+JZPCeNHpDEu+EsxXRX5f9xvC/+NNtv5oo
ECLvk3p4qgu2664cDjg1ghJ/PF7J8dMg0YrI99ijGybHpvJfnuzD7xtTX37K
HYcN2xdtqpW6YNvmwy5mlW34W/Xx1lrbSejZOle271EbmLKKKIZtqcJ0onRu
7eEpqEo7/5fFrBoiZQY+2e/OwGeP9UfMmT6SoHzpnLxhIbxa0ZGQ3haERnLR
gseZ3qGT8rXScBFx5paGSC7dE43TZs9xIAMWCQ+KHCLr0S+h+c2fLQn49N/W
1VXmuXO9++Ci3eluLCbv7ug9U4Yowrp7wJwOX/iufKjRHsA9Qse0HLRakFM0
W/wYM8+NZMPIrj2DmLTLsreQ+bkre821W5mcszlsNvs2MoCUCkUhsd8DeO58
obZyOBWGV52Ht7zpQ30lVROvkBFUFuJWbfhNga9hHJffnO3GLu+K7XEsY/jL
/M9GiQoKSMTufKte0I4L6w0nanLH0Ks2503EOiqc7uWfuifRgs6G73/ytIzh
J/MO+fpAKiS6Nr5L8KxFJ567UQr3xvCHnGOXkRENvBp7bw1eLcf0zDBCh/Uo
RiXQo7iZ/Xnb1gyy6M8C3DasG7RXewS/9ArwxahNgKadxptn9hm48LqQNqox
hDzpG5w3807CkbAXIy78sfiO/a3Lbv0BPL1/+7kdsZPg/LnHOFrPD8+bwVcj
1X4ULEHLxelJIH2/Och4bQwS8FRPT6kf9xMrLD7MTkKd29c/8rvCoJz8eNcx
nQHMiaJO6SRPQpN4oY5VahJEuhpoJ18dwnS3TRNiQpMg8lveV18vFzhXQ72k
9EZwku2GcozOBNAZP1ztBEqBba0jUcZnFAdiBZrePhsH1vuc8hdvV8NO9/qJ
Y0x/GeLa4FjyigYVdzJYz4g3Qb7iVmoOLwE18o79WvSkAjf979KdhDYInZp/
9OQQAT9MmcwljlJA8ZuyXwh0QfPq47ov38dQ2OFe4KNPFJC9RTpzNLQXOIRI
4yVmo5h77nzx3GcKOIfNXdJ/OAAvt309mCE2jL95wipFd1GhaPlk766FQTjB
sEx8SelFX523eX0HaTDjpJikbDwI7xc8VHyV23HXrQmeI4Xj8PjIHNvJj70Q
erpw+ltBNW5oWd6/rXgS7NMVG/SFW+GwU39brGMWigxpt1gw/b12S03LupFK
kPi0uL/GJgxX243ElZ0YEL9zV7j/40pUCVRdftDnjd/Sx090ejBggc+BP4S/
Da//Ex5efykRdZNvz76MmYJHu15JlVwaRC+BvCgbrTIsFbs0tGXXJOjlx15Z
d2wUC4XEuZV9mvG1hp0AvY0GNp/ZxL+5j+JKYFJNaHUn/nkzl5RlSgWP2N8u
er4j+Ppu1qG0j304JsYQC5plcs66SXDi6yCmuhxiV/s5iJ0X3jhnnKDCA26v
EVu+XrS1NF0QWjeMKnr+n33YaRBywWlLLFcHmt7raNC6O4QOEi2W3zXHYWnp
8FvXukYsVZRYOxHQjxdKK8XYyRMw3v5SS2GiHL98f28/UtuFlyyecEja0OHG
5WtNM5M5SLt06cgllxbcvvH24w01UzCi1FhwaDEa451Pmu/7Wo7Dpqf+uQQx
gP/bXEWpthtK8CvLUN2Tcaf5tRN5MwwYXfCoa/+lg2LVnGNsql7gyntDXZTp
WQxfhdMvIwzx5YUMU07OJAgBHcWfTF/bsD4he8bQAUdCeZZZfqSA/tUy7Y3M
fb4Pqfv6Sblg0RyhaKI3DIoEsnvlmH01cgdn5OdyY6QfldJ+4huFVis7Li78
ZcAJKocKKyMAVFZiqUd+l6CMs1v5ajYDrmorRjjtSQf7to3DknVNKL/t8+7g
5Sm4dvCJxY6aEtDO2T2iyd6Fv6/WblAtocOv4PRMrR91IKcblSx7qR/fVXzZ
mCY+CRtmzh0569MGbH2BLJM+Q2iV+fHKOfdxCBscYQvN6AZajj3hdvEw/t25
bHqMya3Ci52zl58MwI99TkciZofQfmTdqr0IFT7LWAzyio3AN+Xv6qN3B7DY
8EvlgywKrO7jEswyG4V3+Os954Ee/LJGCj8+R4FvRWR3u5hRYHXr3qtl3oaF
t0uebtpKA7M3elf/mxgGL3cGd1xmNS5cZE/22j0BkwoTl3MjukD63XD08+Bs
PBIoJBPfTAdX6Zi5Dr0mqP32tqbe4Dtej6AkynMxYGyWEMe3VIdm8bG6QsY+
aCMwendOhQG8F/B5mkwXPm46FmB4OBG16I/XmyzQwYhZhChKoxg0sGozY12K
HxqHj/wJGIdPBZrpth4EHP/39DcvTyPevVPHVXiRCuK/5E96WBJwTpVtle1r
O8advP7q4EsKxOnaQ/7iKG50uWnw+TqzBx3qnpGvYubDL4FRuRlmngo5b446
1ItRWo0PGBtpwHLi46vRJz04ULWH7efbHlS8eNJJfHocPvYpK1NLW9CJszY/
yrMDvS0vvehk9i51+mml44GlePNeWcEjyzpMcwh0eb02BRdX5zj9NoZh+pXx
U90yifju6zZXHSZvjfu4NUz04mFb6oDJd2vmOXnpEa4vZ/J8JuDQOZYc8Lv/
b3HZqwUuVT0Mb62dggVGWEGCdA40hJ1l9SV3g150wF9WbzocVL07qcqWBoLX
d3VQRgYgdMyv7IfNJPRKdEfyBQZBX8Sg2qjPMLz6G/W8q30C7lj0/Ry/449x
1wJ3820egRTOkCzd1AmItlTZ/fh6Kjpt+iZ7/ekQXB+vHT3GNwkXz7yKeHwv
F7/EPKNtf9wHw+wqdzzXMbn9QiYKuebhO7ZP9iN17XB4OkfQTGkKqg2X3TO5
M7HXUt2v/lwlEHYanTphzoBkl5r130ZtsGOxJDBY/w0G+xCXfjHn1NZPrjD+
bh68Sq6oKlqrRN/qnrOn7jFgWx/5u0hHA+huUXcMedSOfHKXywcj6RDWZTEu
pdMFxVbWKzS1HpQoCq3SNJqA5qaAglbFQTjitfPEcG8vJujli9/Wo8EHywPv
DO+OgvGGrx3X8nrwzcjKS4thCsQ+V+wUkSOA6Sb3rNTPndiwu53SfpICBWHx
jaujBHjjfXqNndiC94u5n+eGUuChRrvWudAxcPBU/Kv3vArXRF33pBrTgLWH
s2JPaT/sCmUN3W+ejY4nCnsCsieh43V/4mv3dtB7ZGWmoRWBG+5Ms78xmwJ5
do1DHootOPaGN80gwRt3M1hv0X4zvVtTxldqvhcXTE8byfXFI1nrBdH+FB00
f/03ddqIgLIzubd2ryB+/qn+nFWQBiPrLvTH3CJhHs18YF1/LWouOu0/Ok+G
YC6H/XItREzL+8/2JXcrfvpvXHCmlAypWtacTqljeP2ZjU5vTTtqNTkfuLSB
CnL/cS/8vTyEFTuJUhF7O3BLweqj3FvjMJN7wo7FrgPB2uqLWE0LBnzbue22
EB1ox0r3udaXIi1uIrW5oxS7j9qrVT9gAB/fzeJ1MpGg5Tu59ZV1NGiG5PI3
M72+u697Z8VaOegnCjl87GyEh8d3vx7NmYLKrPTpiGP1kEYXMGCL6QVlPraT
N50nwcL93Z+TwvXw98pIyMPhEXjAe8bGT2scOncX2sjeqoKarC30ffEEmBDM
1Df/ToU1s7Gbw9+K4Oueh3w/npGgEHpFXtpSILlK5GdXchxIuY2YZN0gw+Oh
E1bSzD7fZc575EZEKB5PE2ypsSWDq+GAJGcx87nxnTflks/DRjEerZo/JBgK
2BCRu40CPx1iZUurKvCIzWwffxwRvIltgs5jFFgyT6ffbqxD5aDOb+fvjUHA
oeKg/Fs04NaS2SJMakCTmb6mJ7GDEJzkqK5nPAE3Fqu8F61qsMK4bR13cDsM
hmivvu+mw01SKWro5eCsh9b8FqFC2Jf9VIeUwoAa7ZEnk35ZEHfzX1JHYQ66
nvO1Ya1kgNqfgKVL0ArK+jwn9V424Sv7tD1NA3T4CG5eT6v6YSd3bNXjf+1o
dFrxnxjHBNi59ZerN43CbpcrFQfSOjCc1enba1sq8C9eENC+TwRaaMWG5YQ2
3K4Utm+ih+lriWofL3wkwRcDHi/uwUZ896CZYGlDBm2eiUe8SUTY/23gx+fb
Fbgn7UKWIpECXRM7mvcLjkBcwYE00M3Cf6PdYo8+TQCL5OI3VewG0aBglv7/
ItDwfEZgbQYd+CzMhMra29Dm5VmevFRPfHDt1rlk/ymAjFgDr9OD+GB18UV5
dBya3dxOln41CV/u/roqvZeEmn5ZMS4KheghtfsItZYCkr+O24RHk7FxaFhA
WZPpI/wFFV9oJGiMKtCoSyRhWJOwnt7fBjxxp91R4ikZuiOXz4VUjWFU9j/v
TLkWfFdc+fRWGBX29bqGPLbrR6c0kopYeyNOffj3oX18AppkPX0Cb9Whhe1R
w/zPpXhlZ1i72zoGVLiYdE4nRkO7+ys3gZeRYD5JYfFlcu7haBN5raARzI10
vt6rawTWCLWrlnLM/I/8q2jN3QmLJs17NFd6YSTz+sfDqhOQuL/4l//GLmBt
PBmSe3gUrtjqWLAkUqFUNrs9OKQdkv+ZqM1yEsE+2qhSaoIMRrqvN75zbgLL
M28vH2cjw8y1hn3DDBII3NM4tbOhHDQrT59wkKHAjMBVuvd7ErT3RI/EH0qD
lLv7CpY7KMAZZc/z/AIJxi4HPW4SjECZvOHi/X8ooBL7odZIggRtHRsNGzaX
4Ae9wda478ye/eIaV5w0Cdh/Tvu43q3HHruJJs5CMsS/dDItMCPBsvPVa1Zu
bai8Jvxt5xESEDe+U84VIQNHkWfQ14FO1KV+PMWTOQZh32Uv7POmgLWcnbzT
6y5Utbz0w/DAEChtDTB8QqXB36TNV13utmHzqQuC02Pt0HLy6JzV2iSo8Dnr
bWRFHLlwOfTZ1kI4oSIQsvaFAU4scrQ3UiWw/C5p7ZBcDm4sXcteCmeAo4R4
sH1KN6QfSS79bVKPJtR6J0n6JHQddn7t5TwKsrPi8bfdWjBnTje8x5wGn4UM
CnxYSWBgcX9boUEz3upcOGbQTobmzedlM2PJMEB8vvVNfC16P92y90sSCR73
1X2LlCeD7EW3wPW9paj9hkOLO4AMDz5bPFZZHQUlPocT1a4Z+HaQP+CS3jgU
tgVcu/G1HwI0bf2M88LRga+ZxbN/Ekq9JMecRTvxTR6X03y0G4pXSm4clpqC
1Ityf9n/DWNQcNcEX2U0RtXt/WeUNgG80qTJg8/JqFyprR+86xfy/mrT+BxN
Bhv9p//x+FNwaVHZMjyvDO0c1gteECTBxXdtwzRRMp4Zu214Y7wau+98lz1/
jQyLWXX/bDXG8NSBn2X2IbVI0xX5zWZKgytl/pb7k7pwj/oY4zKlHLdbV17n
+0iHna83lL5/nYAlfpeHta6H4o7nvIqiv5mc+804Z5MboTzqqtD6AxWw7ap+
plPWFHjnhPufXOgF/dlNutIinVDDcZ8eenEC4ma+WVS5DAJ3qbOGWhDzfD7S
JuQsT4WQpFrFn9IDYLCj9GBQ1yg4qcUpvnAkw3+JzvdLNvfAA3fDJ0HTBAA1
vgub50jQc4hQt3axDcZuCXv/ZnKsVTZydpqf+fzDpXOSTarh7xf3s7r/SJA6
ZnNU/iMZtq56CmUZZgKX0rqkVebvd79121KylQzXzC09czgj8cOg4JLNMzIc
t4pU7mSuLyw82m6vWYZje250b2deL/L8VHoVM/e8hufXzm1rwYJFmdO+nSS4
I7nu2vW/JBAy6Qua0+7CBWHfVwENRPAodrUtDSbB00nyyTM3+lHi2HMFrY0E
aCglz1U2kmDea/bK4/lB5NNwPyFiMALHAkO0lLdSoJ7qe4U3cgDbGmYh9FIv
mIsvEQ4n06Cvps1e0KsDtztW2wFHE9Cv0vQE9Ji9q3hx6kNxMsYI7OiaNI8B
7TOLMb/HGTBedFkihKUVrsYYwZXkYlz4u+2hQdgU7Dyj+FjWfQRO8nlXPV6r
wVPZJ75MJ46DgYJMZIgiCSK2HxUc8avFdYK1Wg85KXAo/5a7ArMvh3Dx2sOb
StS3evtKWIgEvS6UnpcPKVAkx9VYoVuMR4Jshy84k8D2gEnuMTsCmGsc0Lx/
Lg1j163bw61GA9enOhe+Tw8Bb7S4/dPFUJTn7yd/W5uAdzx2RRWHu9F6+sbO
0XxnlA6JPFbQQQdz1TIiZc8o7o9szBs1icTFiJCX/22YgHjJSOkqAwpy7FW4
86siE33vnNzSkUkClk6tl01nqPj1aHpdvn4xnk1RP9/tSYQDGaJKNvfIaCt8
fNFkTznW1iY5/NYnQ9bppFtFxqO4+XZR40OtcuQR6cvMfTIOE9treOvut6CW
VFnopuYczG9Ki6hqnAKhOA/R20uFsHtrsCWBGg+HhUWOV5YwIHV2e/jF1F7I
7zRsPny7HkZkWPjd7CdhzmMxz0B4FHLdedvi9naB4Ed+3ZCfVGgUnAv9yjx/
37M16dRdGQB5qasFgkzO15E4drPfGIGlcUfWJ7ojYDmnR/Q4RIZPvFnjz//2
wcHVtcNGWaOwXoXatbLC5NnBoZo81A6/Hm7mnJEZg5b30yW/9Jj9rf+UyeWS
GqhLrNKXPzgGgsdKr0lF0uCTweIPSessCOh92PFxfBR+qjmc/fdoHI7bOJWQ
eb8j/3IotXJ6FFqWQjxIVuMgfYZ1ltOtDK1TruPA+TF4tX3rY5MhGhSX5iv3
bmlFVT+Hi3c9xiCmJFu+OIYKCuo6++uye3CshwgXNcdA6BBp145DFBju0KL7
SAyj2++VLgXVURidr2kIXGD2Ccg8S00eRb+xfzODJUOw7RVB1KCeBAyFjriC
tVHsM1j9fku1F66Ffu+1OEsB+68DRQ5ZQ1j4vDWKp64VDsRzBj2LHAe/m8/v
9HM149ZPjWIuCggl2wU3dtRPgYrja5eM7aVAoBIs+Vhi0NzwD/5LZUBHvPXc
v/FBOBF0zpwUXIoxvfaXEmYmwOXZYsnIYRJ8StPmv8BbgZqjCfeUrCng7s/7
98QUBfZ1O24RvF2KK71m5WeZ8z0/VhoiJk2FUaODcdaTvzD389Vzk+lEiHvI
O+6TQIQbqVz+yg8SsWjPZP3hB1TYtt//QNfgCLy8JqaepR+EOe7rXs9LTEDo
/L5Dnyt7MN6nIfq+iAOeTQvXOupAB6HVZwrJy6Oo//C4flBIKNpWXvWoeTsO
AVL/JQE/FT0+rgjv7U7BksB8ef4/RLARFjjglUJFv6g7GfmuuaissyIrL0qE
rLt3+nwfkdF7wubFv5NFaL9bv3bmCxl27KxvaFIawSiVGlpicgGWPqOMcmtP
QCR/bHe+BHMejI0dUiOjsZHlj0FpGIPp+yMS1pkt4Be51MC4ngNxAZI/hsqn
IO0Z0ZpAHAH/cIcw7+v10NwiQlS4Pg588/NrC9uYLBiUPKKntUN42dZMdhoZ
uMufpk9SCcB290DmuwM9UEv1O13JzPMmJasWqYRRsDUKFzLZ0Q+i+g+e6q+R
wZf3Fs96Rj/E3ua5vGX9ADxsDze4LUoDAeEsj89K7bDr47T3U2ofTJP+mA8+
moDAik36GupVwOWj0mOW0wNZCazlzsuTsLXWWFt3IB3W/RHefmK6C6wLR689
qKPDA1r7hzqzQOx32ebsltQFd4dPvPUap8OkzaTzVh1EDg6r058P9oDm0cn3
AQ/pkG1FfyGV2YyCURE/Qjz64L5u1kz2+kl46tHJr/CvB6UWjqrTdAeAN2lg
IqWdBh3yW6VaYkfw48JWsQb5ARCIMTXneEIBft2zsxEfCRihanUn5G8v/D4y
vmBZSwJxzKhvdyPietOln3S+Ljjhe8LXmdljz8rclxGkj2FqwM47cnUtsFq2
9lnqCRUCrM8lO53tReGUtxtTBMtB7VjOtmg2OuTv/v0vcfQ1srfszmvVdoUP
v49v1v2fX3cr/nr2rxee9nFuffQjBwmq3B7xe+hQuZ2lVbKbCBpl1xPVNhUj
37cs06IVClRa7rMqVqCCJZfH+vP1+ag2omaY8J0IkpvFnIrqqZD2QLotzi0T
y2vcxt7wECEgYJXnrQcJFCkJVQ6TMfiv2a5hNpwC/7mI3ZdcGoXNz27vCJPy
x58JB3+/fz8OUVnXqkeWe7Gy4XL/fREL5Hz52Jb7LB20Dtw8fD1qDK+aCXdZ
z/mhjpBl6vF145DjtJFhHUzFck4HvRcnYzGM3t918QUR1CxP9b7/R0Xxe1f9
U8fTmH3s1I02AgEqIyhEwRtkzBLh+PCkPgsPFLAe/6+ODKcu7Pc8cnAIDWJa
Y80cMlC8Z0d638FJ0DtQb6b9JREPbPC8vkR3wZDuDHvvWSb/71eF53b0wKtt
R0Vl7XMg1CFwON+JDqamK4F/Ugiwz+KtjZBtFWhXhi2/C6LC+jQ2t1gWMvR8
DXb9k9YEL5yso8KmSGC6VaZQ/wwJbO5t/ntRrw1mVAI+B+1l9jeFyOxjx8ag
7cdugtNsO1R8OvPW8yEVVvp+GX1s6wORorAw/lvtkKC/uOvQkwmYH94v3f65
BYyW97M2RbRAdW8Bi1QlnXnODr4K7CgB844HZmfC6yB+48qYxHoG+MTxS3wp
/Akpl96GxM5XwkzWRY1OGwZ0KV3uHCC7Ynd0vlEQayW8/ROeovKZAeIcfwR0
IrJRtjZOUOpgDUgN2sudV2fA6Wne7c02tZiqYW/F/qwJdo3W8H4yngIZlsfv
ZFe7UI0340Cyexv0u+9S1n40CRnbe2nPykew8rNs42GFDrgyeXrNSZ3Zt09s
LEr1IqLuQu6Gux7tICXU3DzO9O+zg1c/3DpJRkOu+Ts9/K3gH7MhoP4JCRY3
P7ZIUSWh9v2NNzp314PVG508aaYHlXHsHxLkGUHN9I9X1cxKIWLP2+jjmhMQ
TixPvGiHuKPsC4Hg8wPyVh7uv1XIABVd9z3GtE54Tdob8rE8Hp3fX00c3DAF
zT9PHfthRATdRJPGC61ZeNSP40iJPRV0qlMoPM+o4CA5eoFPKRP9NP8jHfUm
gicLZ6uEFA20rqb7HbZLwnVGypc/xRBAZrs11+FjZFBK5d4/ph6BeXdV97Bv
o8CfRyVZx9rHgGXf7/3Ccj54UoS3QneYBu1jEm68tX0oN3TQBcqNMOpPYsbf
HXQ48idrsxE3AZ1vfT6kLu6K1y7z9oWm0eAwSSiCMUnFTzqB1prMHi5QaDiX
u5UI5dxV9ZVHaHiIK//hrqVonPx2b1N+HgGyxUJfKcqSUci6121TYzy6fnkn
FvOXDDSrv89mxAZQc2igN3V/LFLLhI6OZU4CZcNv588n/OD57eSSM8fVsfTu
+irvVQZETGzK+rBtEJLqLFqiz6dBbHPC56LXk9BMMgzeaUKC+0v728+Si6An
olhM0JwCHaTxfY6nKGDMfq9aba4cSgRprwyYHipwUSTd9TcJ3iQPh+sHV0MD
t6mlkAsZtI+/DiHtGoM6vvPbpUg18HJ+J1dSHA3uxsfqVIX1wDz9j52IURVs
tpZrSGOhQ2yy8b7b1nXgc8cqZwulBK6+XJQ33sDk07pn452LOdCSXvWk6XEO
DH9XkX9RyoDJAxc9xr+Gwr7lzjexbCnwumMkYmqKASdiMle1n7/DTkWyI907
AapfHdo0wPT3owQ3qk56PGosdopttUuHAKN3bPZjDNhDr5CNri1DubWkrZnb
C+Bp/73QMQsGmM6aZj7/146+g2/leL6WQ40ad/wKyxTwja0VyUqN4M+idw9r
N9TA/Vq3/mnGOHBrcLSnzDL593pYl5NeAzLi5XOtBhR4UuX3zPcYBc/fev6C
7WIV8J9X/P1WlwSuW4WmLbLJWLplpEdVrAxWq1JtbHeRoba4VfoRjKH+vn9J
Grx50Hnsc4YD/zi81J1R4Mivw/Xn2MR4hn+AiaYue9FFBtxp2srJ/74N4rTZ
b4hSv2KbxcPbppFTcOiKqG/oGgHybjhEaf75ibvH2dWzpqjAcfGYiagNFSRf
plfOc/7EsTKN2uvMXn2koZWszPTF5E9XY5T2/0B2qU2sxfcJkPQmrW7KnwxT
os4dbhCAS7zWP+rimXPKr2Gy8pwAp3cqJ/c6OSNt7PNufxMalHpcoIaK9WNd
BJV9wPECxq8G+7X/nYToHFphjDoBWdae2rx59hpVNI+17nKigdyERXMrPw3N
TPe4Df1ywtr3v6pMegjAH+LeDUo0JLcc6ZYs/YwyC+p/bX4QoOkQpE2JkVH+
o1CKsXEAPhsqfmzITQEzzwOCfZv6UePkvJyyox/eU7/tGLo2CQfuC1v2BqXA
9sCdlqqnH2GpSJ3I7RkG1OX9NyZZMgw8jTIgdSUYhCRK/05WToBXsdPmwzpk
CF1nXJR16Cf417eWve0nA69QckFWOwVUVTU/r3uZBqJ+rQKrTE+1tWENIl8k
g7o632/BzEzIb6qV29FDhna1Kl2pgVGo9XFjlSnLgu9Sz5ObjMeBV1FyA6Gl
Cz695biwuj0D3pa920JppgNPudDyuvpK2GPEMcE1/xNGhV9nf7Rl/r/OchKs
Bcnw0ceFJaY5FOKO5toeZjDguMCU74VSd0i9WiKvwuEB2pHtRwOZc/10681P
HYxHOHFPy9QYPgLHowH3WGZPWGwJPlrw9Tte/Hw33a7UCz7bRUgqLDFA5EOs
4vODRWigncf+zDAcxmumXUWqGZAwofFRN7sVcwLGfbfcTwBWn/7j/VlTEJzy
tdaDfxgJpmy77WQz4Mvp83/Xhiegu77/+8JfIvofMM1/K5wFRk4ZZ5s3UWFQ
sGwWv1Gw+1XvfZjKgIYe6ehvzNyI55w/EvacgmoD8nHyLGmQK235d/gXCQSH
tt2JukXAR1TDvZIhcaAT8lU/w4wGL1YuKNg+akHjlKOyn30CQfJNnmzj5BQ4
7h4LXz7XAplaaq8/9Jnh5mNZ4Vdnp+CDj12vYwYBTgmEGjy77Ye3TxM+XpWh
QYJmZHmtAxVuR5Jt7+32x+S8q3WnvxBhuVnh+iVfGkxvd75y94sPtm7jC9I8
Q4Da6wcX/evJcHtlY0jUN0ecPbXi22BGBqFp6rXgcgIoHk95/WT1PW6QWxsI
PUoDot6v2QmBfpR0nrpg5aEPge3hmawrk7BlT8OC1h0CPrBbdci6YgIr5FK7
EhsaTJSt+/dcmIYzHC7ZtZxWkHfThTWtgQAp27013lyhIVfLLk9vT3vQdkpI
8g0hwEXf87IaEmRk75oUAVt7yOQap95men1mltd623X9ONrc8O7ayHNwff2g
Y5yVDuxPovzd0tOgSPS6bYuHA5J5F3SUmDlZamAfPCY8ApWhh6JNV/xwQll2
X+f3Cej6mXC8i5nfB2vMOI5PheDpnW0z17LJYB7RqDu7QIFNgyzRr9W/Y6mJ
5/y8BAm+8S+1ljwkw04/afE4+wjMeTW90NFLBvvPR9WUR0fhzGebT32Eb7gn
XeHHL+dxeDC2xbLHpQtip9ZdvvU8AD/ECdUmzjDv89+HDWKNFbCuLtdTydYF
SdNmkt6+DPDSq+5KPJoAPjJ338vQ36Jn3xZ/qXkGaKqOr3i1OEBwfdw9mxQD
nFG7dyqRyfmMQ5r+Z4IJrurny3hKm6CbvCpxhLnOH2J+v4ErHHdZzxRUKDli
i2fOF4FlBrxNzr0RuVSAhSyHb+Vu9MOR1+9VPzQyQFW6dOdppVY0IB7odvX8
hvcexT/qbJiCdz6Wdu5pQ3ju+7oV/oFIlPvmdmXjjkngnBtcXCQR0XF9544j
ipH4n94uuwimT1aOmH88G0PBZ+ovc4+9D8OnXMrpLMw+bcQlbHbbjoJ0aYlU
nh/++GDdcwO3HBLozryJI1syOTHNEpXW/IQT9ylyeo9o0KriPC4y2YKZvqkS
gXcuQon7xOjrgSmYbda1eKDZDJXS314fXnMA2/sWjO/sDGjwGdO5/5UALFzy
twzjHcHDQkCu9ioNNkXOHrhpy7yv8zHz/OtswbrLp+LdVyKkvH0z4BxAgyRX
U2NWHlMopxOi7eQIUHTBMVCjnQx9VG+nj566oGsvmmz2kgwvt1PlC8YIcHXM
3Te/ThnX/QyVOslFg5h9h6i7I/pw+95HerYhb0FRyy1Xi58OKmq/I66dIODP
wuu8rRUuoDjQtmFXKA0MauWML2yh4fX+pQjpl19hYCl99hKNAEE7zA5UAw0f
K8tOKRREgBZn38+wSAJss9IVz1MlY7HYmg1BMgqiIhc3HpomA0n5n3477wBK
0N0bxPxCwXHg38Knokkg0uSr1XUioSYz/azBWVf0+LFyJu8fA/4bPqD0PHoI
lIq0ZoO0UzG99NYlJ/ZJeOSuuarKRobiFsNru4TyMEyYy/IoGwXWVr/+PhVJ
gbyMIrbNZMT1+8Jc106RQLKii9SqQoZ1p1QGNKTKsDK98HygExm230rI2n9y
DAjLfX3L98tQ6/RGwbRxGphRHb5rLnXD9PGbOaf+FuP6vLhFCSM6pC/lfNIf
rQaSzOVXGlez0ffCkNOFmwzIFKt3uSubDht3so/Zy8VjGbuOnw2BAR/yE40J
RE+osFu89305HImJGlWvmHnemm8E4O+I4u57ff1TviHn21MTEkzO6QU8jy8Z
xyHRe6/DJ6U4bK12FJhj5kBUZPXQo/2leOQ0tUatORO7DnMUhn9jzhdUxeyr
bEO73bzkrz+LcOsMum+9PwVCh3pN5h8N49ek0DfhymXYEpVX8uXjBEy7N3OW
NBBRJpFv0dy3DAU2yB4jD1FAbY+Y1oAaBUMcXHVbH5dg62zA8UteJHDekZMa
vETG/t+bycKzefjg7/DJhxvJoFkZp+GTOYbaJq6s0rQ0rBb9IKw7SgP6v08t
dzia8IINhf3EET9skrCxiudngNuP8Euny1vgeq+T1yfeINgcKdeUNDwFqJDS
opZFgHXVealPg6LAq9XUUOQ/GtTPOnCLvKXCUBPtxg/fSFhfyK309RsR2lcf
vPVj5vHwK/Kx7L4gGBYy+554iwD9ZQ/+DiaRIf9oVQyrijv4ubwJfOTH7LfV
XAWGNQSYPBqWTaC+gVeJxxjkwzTw4ggJHvzVi6WHvQ7Gkz5ATp/uH9ZrdPij
Xhnc3TaG+ZKTfnWFfsC1oCdHHKKB78lLnscaqFgqn/nBXz4aku8GcCT+RwSH
HRukIg7QcIBbfOz152S4/Ppi/qN8AhwO0VipNybj3a6QTH6rdOjs31EqlkeG
GV8js54dQ6ha9ez4ft0kcFFuia2XnIR13DoRm75G4GoM7XrVI1Mc9TCL+8bk
xLdjJGhdYh/IB/jFZTnnYuVqhnTD9CRotNI3yuUQITJzPbdOdQV6JohwGnRS
QEX1jwx3CRlUtJ5yeF6vxzIdwd+Ob0jMfdiWGK0kEHbeGJfP0oIlOfRTUmsk
OBjwaTzNbozpyVNbvy20oHrh88zldCpIu46EOj/tA9haq8th1YyS/4qFzu2c
hB4Fj+HDQk1QMcf2KV6hFnf8o/Upm03BPYr0MGtqPrT84jOt8ylD8WuBr68z
PTc+20lcIvIbLEobHoCqQkzQpxf8qGEAx1EuiuFTP0x522PenVWA/nvq8p40
MeCgi41XAjUT76vEKSmwlqIoTXSfZjgDhI+56LPsr0aTLWcvB66vxn/71vVY
zkzBc5u/1kH2nWjyNE+0PagRDVe+RabK0iGayDqLyiPoeNNYpCWzBV+Ytr7w
vzAOOyfe3GN3ImIbOp9j6Lag47k4lb1iFPj+vSNXx46MTtelf5mHNGBmF3tX
aAgJzqz351tsIGEDed2n8U9VuOvKH/fxQjLseMBjlc0YQcNL1f52kYWYs2lU
jU4bh2S6tPAHr0osMNhxYkYyDGeTml6MuTBgieP2Hym9dshaYHfpD4kF+b8E
lhbzKdjNX1sayOz/xD8Xxpv90kHBZf6h8RgVRDM/uD+/R4XTsyybX8anwr6X
/Jw2sUS4Ku3qo3uRBp5NXFz/MmJhk8JLeOlPgP1Bj2udb5NB9/sRlzMhQXDA
a++gJZkMQ2yDswVvCXBGQ2Z30iFHcN5e5A3PaPBxw5cbck97UCX6hio5yREu
DiyqZPjTYVOeV36+4hiytl50eXIvFFRLLUsPq47DVxnXac7HVNyxvCbW0p4E
NI7nX6t/EIGxh5KsRaGi2EZD4YsG2XB4IWI5ZJwAffNm897eZEwq5tD3HMqD
6q5TCrrmZLh+oTkk//wInpRAf6J4LpgRgzW2P58AdTP5ORv5Ety54br3bQd/
uCOe465QyICwkImHAXs7wOvMz4Fzg3nYVaL4p/vUFJxMuW/r/2YM8thjFZ6N
1KF4+YuGFOZz2XA5yvDNCRJo/Tnc1eXWhoNtVz0C9pHh3NYDXKcbiCAq83Je
QaMLFUIzyrpCSXDboCudU20MuOv0n1fG9qB0+46tpRIUsPPweL353ABEZQwJ
m470YNytvv/OM/Pte+1BnwqjNujdSzhY19eFiq9Eu5NMJkGiVETuun45VKZq
nfZub8fE92cqwjZPgalejztfczxITnuTjn9pxdZBZbpz/hQIXlZULrkQjrFq
texOIq3Y9irZ5XfLFOR3512ubi3Cmx800rcmtWGOKIP9kv4UEL+rLt/MbkT+
KVPNuBedCEWfZPJO0yGQjbWj4183Xvv3JlWC0o0fJ6d354lOwIKD7Gi21Qiu
fVA92R/Yg89cvs1qO1Phvelhj6ESAuoalJ5tX9eNaXtO8ZU8JoPdlTMTjfwk
3ByOZ6xz2tH2zPddnL9JMPA1omSunoDbmiRevD3bhAK2Z2zhHwWGx8sb3HkG
cLGlQ6kirRQPyAhWND6fhCSiflHDt3Rs8IqDh91fMFzUIOzWBANcg96EBax2
AXF9YA7rtkx4azH4PqaCDoJt+TvPGRBhV5vxvUW+fHg8I/7OkZn7o5lhNudk
qIDFunU2+3Lh4ZcT/JvziOB947omfZwKJxydZqd80yDqXusJ40UC+LSxNck1
kIDzHc+Vyyw/YHv7x8P+TyiQVa5w8+DYGCwQ5WYaD3jB3t+HaoI6aDB3Wn3R
PrULD5vqrt/U6gJ72j7JOUzQoTc95pCt8SiyDRkY+V+PhBRihqV/6zisps48
8a6l4BZVHZPI4gyQzKCqpKqQQF4/34jXg4pf9ued15MpBMpA9hMreSKoO1/s
Uwsh45aHc+GMV6Wwpzz1RKA8GWpNjjplW45i65xwsChrKTwM/o0p5uNg8cb/
74hoE/pMfI7QS00DftsKzg8bGaDEJXJedLYSSPtixvaGZGI2X+I9xVcMCAll
/0AdGIT60a1iNVyNaPIx7bmb7gRU+YjKi+AYHPQW6lwld6ICgfUA/0cK3Nco
Ufi5hQANz9C7TqMfw65pNzysI4HFwPKkhfIo/Mff+1dSbBg7zmvpb1hingt3
ZIvXjg5AocC+pT/hI2hlctrzwWsKbAnaPW97qAP2NPm9MssZwXulntZf9WiQ
3xB91KCrGl4uj9FfC41glfzDzIjlcTBQ79XeS04HtXfb5jPnh5AW/Fu3bnwC
XmtoZrMa/MBY/c0Bij5DyMZl8KWSbxLeDL6rs35cho+rr0f5qA5j9MhJvZtu
E9D3IFzod2ULnnHb/bhTbgSlRP2ddzBzqVPfQqwxsQcZB+jkBZMRTOQO7Fdz
oULFcB/L75xh7P29a949chgvEKaFFfvJcFOl+c9ZlTGUt53V13MawJP3iyiT
O8hgmOn87c7kGFIVzLKMyrpx+N4uRRsqGaxuWpa8LxrBvd3zoxUKrcj957z2
wDANwh/2+wo3tWNxud9mX1IJlnQd+PDu4BQcjGzX8ddPgpSJVL5i9AWp77fe
b/zNgNmIPxFRLP1wTivfruxnEQTdkjtxsWoSqK/NBeuKiPDw3gZWpZJSeFlS
4Tc0TwHe+0W3OWcpwHNRgdc1txhabJf2Wg0TYeZlRoiYIRXC9hg/vUvJhrd2
BKVtLkSYduw9mrKRyeOeGgIxNA7eHlqw/8NFBYNsN//MHWNQUJSN+3X8IJgk
kBf9bBwc87a5dwZ3oM/tvfOvJD1gjwZPkoLaFAyUjAaz6o6gfEmMbEpkNMSk
aW9dZzUB/Il14nbTZORz2cn9YUcuBE9655UIkiFFNErccY2CmptWHM/+KAXB
KxNRZ7KIMHmAZV+3NRnnjA2ElxSqQLgukR15mP3nVOHZgXdjeKfU7ajFuWow
cSp37rVm+rWvfXNMZSfWyNYRP30pgeSI4ADuJjo8S9d/rvRRA8708Bk6dDti
dc3xh2FMT1TvMpYWGWqHvZnJI471NZjzU3f9SDUd1q53xv+8OASQ/uW/x+5d
+MNPoZPSTYMXA5oqS89HYEHyV8Vv1iHc7+Ose5GVAjIKcPtu+RCc/jY0KpU2
ijxeGntiakiwKBLn1fO7Fzh9bm3b6kBA3vE0NwozX7Zlqp8jf2iHOyF14Rqu
RGwq5P1Q8IkMISbHyjf71EDzhaKldRNEbAgs2z9gTAGf0GDe0p5M8CnjbFFh
EDEl6Pg0LzcVrG903WN0ROLsURag9BGRx8DAsvAsFXw0H8n9yyvDuzT2my/L
iPhD0aBulkSB7tMnhGRft2C4Sm5BtBUR98Y1q8Yco0DgnVsHNHd3Yzzp4ZfJ
XAK677Y81fOEDM8Iu0e0QwbwQVZr5DHmeT7apPhKg5MMStcDtjVO/B9F5x1P
9f/FcSqEpigUSRlpaFgVTkmIkBGJspKsouyRrAbZJHtl7z2Kt7333uPue10u
vlpEv/v71+M+7r2f9z3n9Xo+Xe6dR7yRjQM8k/Moq+zauZcVBLjHfK+vyWse
BfaokD5qTKLBOLOlqEESNLaIni1qmkAvty4c8tMbQJ5mL9zHH1GhRsm+eyW6
CeFz1xxeepWjS6f9DZNCaJB7tjh3kKMDLsQqWKSMlcPXNtvcU9p0f3kPc4Ts
OYjOUTx33KEVlgv6/6RHLMHlVu0Fq3Uc1JezeiqT2qCE3dJo8y0RjqXLyzUG
EOF9j0tN6INmmFQ4G+AgjIdPLDpnLmbT+8d04V+L1jdwOENOaqHn8C1p9tBG
Bhzw94Vple4ugBXF1R0LMgmuY8e+if9egFByos16cwysvYpXKOBfgnClhIrI
q0Oo5+NatEByMJw5emrPSP4K/PLaJ+++ew7J/HcML/Y2C16+O7AcdI0KAiFf
SIUdeBR9yGIv/ib9cU8vjB65TARRnjTx4atEdMlcfUVDrhU4JXg1jczxkL4c
FnyHn4CeBymwKWl0Q2GUcLEKNwEuDxTKybBjUYye1YslHjpHywVOS8eQgMu6
590czzRia1ZQrX7VBSYBLS459MeNPF3aJvmyFTkQ/HIVs6phS/lrVJkFDfIM
KG47mnXgR3nWUC5fhWrliowPZNPg+1x+wuSxEcB+SlEYChpC/W0qf7NXqJDZ
HLKn5ukkMG7WqhEaZ1Ai+4H7LIlkCMftHqvQnoSYnbauelYMCpz4S4m7SgSV
GF7+VO4xkBYZe6EQikMEq4uRgMMDK98hitKRQShW+j2hI0lATp35ZazP8CDU
xfwq/0IbaHqSj2LPERH1135UaYQH34ruY2YlpbCo664hGE9Eq2Y3DHXc8aDy
46nO34hEZNiFPeGWSkQeV8rqmkPwEPsm/UPWpwZk/NiI6Z0yEZF/R8UeCsPD
4I5IWlNrD8oaCWMtdCegVDXxiHk6v82/vmJwsHcYTV71fdHGiUcDF0b8B9bw
oGYspGMzMY7MivZdIhMwqMhjOEOBSIAYIzkmL9NJxPnO3U/h1TzaHcfXaD5A
38cez9XMmDHklbS61B00hirixMM+fV+Cdx/FEra+dyGWewqrviutKNDK4/aj
/hXQrT92QJyaCjMfBBzLPn8G/O2/vH9/04DtVJPJwexhECaENd5SbAVPjLyA
zt9lwPtrvtkuXICNm6bK4bt74TXXT3MLHQpAXxj7MAYH44VJr6859cDopM72
tQtEMCe/T307Q4CgzTNbROd2UOXmJuHp18vF/dsSn06AY0QjMa0nDZDqQrVq
lSPArgL2Ks1CDMiFSjbf2FMC9kfTrGZxdE8QtDp2/vI8eD5wvX0rJR7k212V
2pbp/bvQLTYv0I/4kr9Ii66EwO2KpVYeVhpU2lc+GWieQt54LkPlihxAds5P
Z5iWoVEfG+Mpj0PpzU1+OH4EvIfuGpW60T1RQdFu+DABTbly2dUPd8DNTA0f
SR0CXMnFSTDb4FH6Zc79GbcH4Ke+SK6pPgFW7CZE+fixKGi9yPzT1yF4ylKi
kU4iQhq27tWSwxxKbaFW/vAcggrW2pv7P1Pg2/l3CbaXhxFrnvFEyvseGGz/
HZ1ZuAxuxRuf9SsrUFkouedTahlUTDpwKnXRwOyiwMPZ3XUgR3m2/HtfA2L2
zdkQCKSBQZqmiq1pHwh/mbJv7RpBJVdsGErUloEnZOm/jsVB4PPielWPmUPX
sbqEfWEUWGeOyZ8eHoB/52mhFtsYpHFv/vKCPgm6vk8HXOHphl2BvYQtbTyK
4hzgylsgwNmapi9+x5vgadSzHK06ArKl/dk5fIAAZb+UX4xmFsEbFdneQy+J
KNY+NOltGd07WF8QWMKjkQApXe+sHxFpzDheP1dKn1vhfeqT12vR4DxO6MEO
AZ3U6j53ZTcBZH735rwsakOnMKPvNvvwKOn26euu1QTwcWKumbfqQ8f3jVO9
e7EodeEm+SOdH+ovcBu81B5EslolStX1C2iQ5SrObpoMnWH3+aytBpCc2LHo
pJYJJO/M5V2sT4UnqqLtjMxt6PTym4a0+i709fPpU9J9dK+v2lFfNA9AV23S
F84+CUAGTf85Hqf3rzNLazhVvBN8T6Z1+71vAdf3vcZf/6N7mfhTn2DxSfjm
sRhc+n0ADuZ9HJi9SoX7H1uvzpkswj0hKS77kCFwSD2RGitNht/EdolYRxy4
hIUvuZ0eBCHyhV7Hw0T4EkCVObGIh+1W70dhud0Ql5+l3qBOgJGHflpsinhw
0L9Ybb7VBF4T/AlJL4lwm+zH/IdlETSCxQ2ZLpcB199UqiCdPz8UMvQzYafh
7xaznl5+EnzUzbjysJMKFZdmFNSiO1FTcMel51shcH2X+I0GAxosUxo6C7bH
kPuP1tSLjHmg1lqtvj6wDFfkLW7h6D2aoak2a3O2ERpPuVwzWSUDX12bzScv
HDr0UCVJ50oPIPuXr7eC6P3lvf3fBRUcMrkfpIkmhmD5zKzYDSwBAhnEGNfi
MWhfoFfjEbkxiIAyqemPRJhxeGt7tmAe6fYyXNLKHIerKcRFdzEyUBrf4/Qu
TqAwEXGPNdkxILhzUcydl+B43Uki8Wgf8oxW1R48MAhZZpSB6+RlSJCs2x59
XoHsf/oGON1FENBOycvPoMEZM+Vzv3YyYdeLCDbZC8Wo7NWU0kMiDUwrfkh/
6UOgklX7KqyiH/U8cfnOh1bgyD++/EK1ZjhPaCry8p9EpQfnnnmvU8H5sd/g
1vtG4L1ivz/z0gKKvmWwEXBzCbYFTxVb8dSAXTy2KVYPgyzIT5LOsVLgpTxH
eJh1FhjzM1mzWWHRq0xPwaPPyKAQ7DE5W/keXQ97LtQaiEWL07/Oa+iRIetu
T767cAlifuBdNNGEQTeTvSczRskwWLnU8GPpO2LdIQHzzgIydo7HZc5TwPpe
T4zoVCO6eftPa4r4DBLhWF9yM6WCYYY98duBRmRwVnoPA3EYWZY6ZpBPrAD6
pFy82lCOvmOSin6gJoRV/cFu8okGn6tnDdaYP8O2G0XQzC4VpK+XKxn+oUEP
T0QVY2ALiB77dgLL3Qn3ZU7cr9hYgRxjh6PfSobhveZj6dCsYdg+0l+lM0iF
y9wTxU2cM/CpQYatYXAMvp0F8n4LCsxxMHrM6S6CYs3cz9CvY2Cx+6Dm+DMS
XBh6F3QvBAvK7Jib4YdHQJEpdrPhFhGy+07FZbriQONch0EI6ofnA/xr/spE
+BdcGfjDAQtH1FdXVbRb4YRvaNPDSRLwCGqrh3LMQaGdhdz0aDlUlPOe9hOg
gofFx6NCnBMQ86xUAqOZAivcxJ7E1GWYitMzHNjdggyvzgdNlAbDi71dVMM4
Gqgalt9s6h1Cs5zNz3ACeXDxvlj8s0B6DmwddFF0nEdqFzxzTC42QcbCzP7R
N0tw8I+Uwl99DHJ023CK2uqDXNyF/6b2kcGyTw9bHYNBthPNOl+ujkJ4/S2j
Y130PX3gyurkuIgOZO7meZ0wCQd4r8YPhxHBUtjz5znqHDp83lmv33gGhEda
XbpFSWAqFP78Yfck2np8KuDkhVloMrzKMfaUDOejS84cxw0j/vfXNWOzpuEE
+Y+C8LElsIsbu6ot0Y2OrcXiz3mNQ3dYbXLjJhVi2Z738p+uR5cx/1601Q7A
TrSY1ensFTA5ZV5MWk1H95zkel6bNoDZXrth40oaHBh7yug0HARzb0XzZdX9
kRuN+8n4Dg2e2GckbQqnA1beE1vr2YC+RerxbVbQIMc3nSPrXDocvKcnd9a2
GzmfuB5FvkEDC++52sCvnyGbvcnEpGIAHeDKPzm8uAI4q4hmuywJul8nv/tP
ahB5j4iGHRtagUuCO00uY5HIe7PvbkRkH4qeEmS8dZgGmbkNKu+5E5HWhQe/
SSz0HnA4N2ruS4ND1/Xq9YciUJpC0RT2VSnSd76zqUmmgZJAkkD1Qjg8uGRS
NbkrDzb93rvp/0eDttOvttpLyyEkKdywsb8drj271VH+gAa4r/bC9TfpvBJx
LmEwdBhMU48qOTCswGeZF1oWTQOQ1TIrEMk3CemuVkIs0lSY7D3J+nx2DFo4
ugacmWbg35POwi/PKGBRv/62xXYGuGcEiz0fz8D6j83QVgoJ1Cfsy538FqCw
bd+L/LdTsL/L9MLLHSJEg/vBBS4M8BGjIzIHxqBBWCY/q48IIhGBjMoBGHA5
qGZbmzcI6q6amuvBJFgWDrzDy7sI+UVxn1u526GlC7+hZUuBFqewIyfsJsGx
Si1iu6wCvssP7U2UW4bps6M3F3DDUCV45NlIXAoMLGWzfbVYARI59I3A0zpU
VZVY584ZBDH+p8RPdNKg/f54xvORHnQ38tqRhNkc+FvJ87hVkAb9R3w6dZ0n
UaCD3oULGk2QHFudhPtHhXuBjK3njsyjjO4zTh73BmCyen/lShMFlm3iH5jc
WEBm2habPptjwDJRp8jAQYYDu+cLoi7OI+ZODU+3ZzMgOH9c2vEwCTDB7g6i
RjNI3UeFu0dkAdpvLjh6lRPhaHKj0K6KCXRo+uNLT/1FCAj+KWGLJUL3uZM9
eVl0jjnr7SXetgg3LnDxnnxHgkf++47/8xxAgZ+1sHdcF+Hyn+jSH770fUz5
bH1uoQM5sN+3qnFegJXgr4/7ayhg6HNgq825EWlT3T9crpwF61d23McZ6X19
c5LgY1SJ3CYkp42rJyH6wWyA8LllWLKJYfFQzUFvM4zKTiWOwuSSnDsn5wrc
zC3/HSQdg84LbF+5cWYIxD1WtHsKVkD4emaoz/3XKFkoW3HvbD+UzrQIsuys
wA4+Rmb+oi/MF/v+6SzvA1Im4x6nQzT4yW3KV7oRA9BC/eTsMQDalz5EPCKv
gNbdPy557pnwO+Donl98wyC4zC1Z47MCFDdZfOR2KWzNzhVado/BvCGreVrf
MpwVqL59Oq0OnCy5T5RNTMGcd0ZVZT8VNDu0IySdWiGGUenqcOActHmGMHfE
LYF+03iH7aFeiM2+kh2fvgAtUc2TFQYUuDV4OJIvdgjUGuQul9LP37FhUHn9
BhkqHKxqWkrHgN9FOTPj3iK8tUs/YmJFguNae/7KhU/Bj4G9usoeC2C+veLt
/o8IY/z/GB+OzAJhpUSQuXkWzhBjMxe4SLDvAM+xQPw8VHJJ/JpjmgRTq23r
qSYShL8WSgybnoepSh52X/IQsB3TKpg+RgGF8qWxry9mQMj5uLEZsR1Gbv0N
YmSjgsZkXeLinRHgoQeI8ccKmNr/1D7gBj23f8hoN3P0g8nbbYttvhT4s09U
rJmZBh2k5+13u8vQ08EXyS+k3oPudODndQINKsrUXvfebEFvbu/RGTuZBcdm
Cnn1wmjQVf1NK2pyCN25luhwQ7YRRMY2dQKUVsDBqcrP5coEWpd6zUM5Sc+J
Bsn7BT5U0CZz3V1XmkJnsngiNhLHwd5wzDu1kAI+AqOrpf9NouQKn47OXXOw
/9TaNP44GdiCvcMYRCaQrPrt10SXRUjU3fWRe5XORa/brL5HjqKS4yLPDGWw
cMlql+zaFSJMxTz4uD9vCD2287StMsTBMgPTEflpAiycnDY+/KQfxQYZ8p7Y
xgFU/j7VM0EAv5Xrux4EdaKjdq9zpCXx4Mh8g72QmwjO+zZjhthaUJdPY739
cTx0Gj6miLwjwoGjryv+LNchLT11rW8dOBhqoph1spFgRz+ukqOyHJ0q5uJ1
NsBB1L7MWZNQ+t7dnWlZa85G/0m977eiYsFWB593k84qCWV7NJq3IlAJbm5L
MwkLHgZJKjxKZNBzqjhPVvSHvpanr3X9sMBicEztmhEZpDxJ6Om3dKiXWGry
T8VClfzSRqEcGcS/ejn0ZZSAwvuqG4srWKgRs/uRSCNBhsfchOOFWsgQXIv6
p4MD8iN19V3eJOD2aWw+39cIDJ0RDhslOLhjyyX1mj6HUYeU4x0328Cf6vgw
mYSDeJ3Lh6M/EEF5BXPw3qceaD2j/s5vCgdZX0PZafRz/kpezgq4PAixgT4H
hO1wkLsZ6ezARYRrziMzuFMjEKpjJC7wHguoqaLtpiIRBg+xbmZixiDwdEWg
1wEMyHy+MrPaTwRTJaviZ9z0+Watulo4Og/etbPPFJtJ4BYjaWd1aQpKa9ie
KJ2cAn6+0faLfBRgX16JC3wyCeXV++RGhIfB462+yMW2JdDh91gbahuFxhlG
mYt328Es4PhMdsAyTDiVH2Ub6YVO5glSrmA58OsZnn+8hwaCekx+EkFtkGAR
P2idmggt1wu9nDxpMCSRZvfYJQsJ+xbv/nDbFwwWcksP/aLBt/awsxuCNcg7
THfO528aXMuZDW4YokFV/pn5X0Ed6CalbNsmtQ62dtt+nxCn+2aF7JONyAH0
4Syn7XeRXvj96lOxLOsKtDoKdvTMDKGZFVv5zMdjsOGp+nLGiUr33UVOJb1h
RPkxc+a07yx8Pn9ydaWUAn1b+9nY/YfQl3dVoyEFi1A2jbX5t5sMEjITLKPU
AfRINI//AhELVnsNvFujiVDprcpWQ+pFT2P2CpH98ZDwuzfrtysBggt+VL4u
7kRndI/bSGYR4P6FwFP+eXhoSPzZ8tGxFWmJJWlSbYjgopJYZiaIh4Edd8ZH
eo3oEfsv0Fwigo8v5vCnfhwcXLX5mdBWizgL8pr9ZUgA90JLq7/iYFb6QKTw
9TKUxvU7FpmRwEXPoS05CgfG+/69yviVhZycf/n8dSIBfyLbx+ZIHKinqzLy
T0SiucwVWx4PEjCUETkgFgdxX9/0N8t4g+YNE45XLvT9qbwYEJeMg6fptXYn
G1OBWTLjiqktCRZPLSY5ZOAgSPfqXM1CEWQffYvbRffwg+UiZ0oLcHD1pqOP
qXwVYL1UtA0v0fM3nd1CH+EgXbdOPnquHi6yf3xQuUwEprvCCpU4HCgo3eCK
tW2GAo7V15i39Pnm4XX7KIaHcIWChc7wdvhUc5/l9zgBWHvP/ptJwsOJxCSC
XWc3HO1g8i2fwUOdWMfJfE0C1OtkSp7H9IOD3gE3frq/il0ZLQ1SIYKAh6+j
S/0gfAy8G6j3FgMBriqVqiEksGm8plr8dwhyV9OWDAbmYU3ZtK+bnufRm3M3
y2SGQTlxD+Wb1iS4H09l2EOfc990xtX9a3TuidwffgA7CBmUiL3DZnS/y/7+
5llUL0RX/hSOxrRAm6DPRdOSFRjaYJJRjW4GTDlj6nP7EoiWujV7j+41mnIy
M9UhdRDq61ik5RELhb60X9ltNPi4j8R62fkzyjozduLUiivdb1DIwjYNDt5o
THqfk4MGnbIUei3iQdSn40XLOg3uPMXL7VKoRc1rldXddyph2y+yIozOvYfF
MFuikU3oVOjC97T/2kB7WqHr8GkaXF5fO+8i3YZe/HYckPYbgoRrwbsHT67A
eozLbUNsO7otq10rmj4J4qnxe7PLqZAnnLUrYKQdXSlOzy3bswDbnZip4f1L
wPw7mPGxXxuK/Bn94kA2BiZ/FrFMm5LBNj9Zzde6BYVd/XjqWSUOSiKTLspN
EaFh+iTTNLERHZS7K5unQIBmhrAF608EyFB5Vzj5sh71welrIc+I4Kh7jkPw
DR4+lbMYXd6sRoW8r5Tqr5Hgae2RLbV8HGAufRiaCStDEqJt10/0kyAUddWf
O4SDh35D3t998lEPf3xHogQZdrIjrpqnYSHl7TFSA1caqotcKmJwJEOMtGrj
GyMsnHIJummqGIpIM6LcAZFkuL1KFai4hgW2n7LyvrtfA1vm5SX7z2T4afr3
2G1pLLj8rD7vej4WvJZffdHxIoOJWMNkpC4WFjnkezSJmfBQSWD6IL0/zHuT
bytFYiFkjRp1uawYLhT9vla8RII69zv2+39hYe2UULTIgUroeOwds5fumUvh
nENGATh4tHXcP9z7G4T+/GUlnkMEqzySQ60iHi79O4sIrg2QRH2xe/srvUcf
yCS+uEGAjZ/6qkU8zfCf3ZwY9x16b2IDW07aEeFn3KORn69b4RGaeFr3Cgv9
dSoO1DF6393wcJ2RbYe91WfFb9E5nZLAaCVvTQE/z3DGFfYOMG86rjFJ9wM/
Yxyj714qLJ6pC+G0aYcY483te02j8OzxjsKg/zJ0rpmwY7ZbYObF2bmz73qB
5be4Pwd9ziVPy94oKmmA0w6n6tdSGmB2RSCOwZEG3aPDlzxSK+DCyF2Oy6fz
wDkjiiA0TgO074xBWWox2KfbL3AxRkFlLcldYJkGIza+xskjHog8cFeJ6/Fz
iLo9eL/tHw2uOASUHJaLQPqTLGOer0Lgn49pQDd9L7hupIh0TaajHzaLp79y
5MI5WpK0BI0GJdNUu4vKBUhOOtpCf/930Kyv7rzYSINLo5+V3PRKEeXN7Ch3
VTsEPBWZbjCigZ/dQGdbUzk6GEIKm783CKxC0Zo7pStgFl75R3K0ArlF1Bdp
9Y/Bu9BGW+62Zah5mKQVnV+ByFLsHn1r0xAifEDodA4V3JYeuWLel6NtFw6/
e9ILcFalNzfdZQlcpyoNJApL0ScH/r0+dK8aEN18v6FGgQTJwbKRx8XIVpRR
7Ug0FjjXUveNXSPDj9w6WaWgPJR2j6GbjZ6bL6a/eXxQJ0Ei8/K5IrZMxBu/
yzKGnoPtRjPtOsH0vQka471omoIGWoI+CMgTwIrIeyV1iwCXE4RGe+9GI1VO
3ZUfGQRIu+zxq/kLAar3zKkb+Pkhgr7F/AKdz2r4Hh6VfkrvJSV5vt4+IzjP
UTx0FEuAeyFF3YaPCcCTxG1n/j0QJh7p/rz7nQCGdYILQ34EmODxtyZQv4B2
jZLKNwsC9D+sKvKj5/S3z0Oh5ZJpIOPk7Ks2jQcTJ62b+g+JMF504FrLbBZk
auhiEo7iYdmVC5PGRAI1qWeyN7QLoPyoC+nFQRyUOSa3XJslwTT5fmzl5RJQ
vD0e4f4dAzUhQl+Ep8hwfCM36+zTMniRsZEqzbUItW9Fdl/6jwKx58z0rPdX
wN5aYzYusTk4UlLbFsZDBYHGnOKW5QrwzP4wa/Z2EjB97FN1Msvwtv/uOHdT
BWRraA206IxAi7Qka4jMCry/cPmEuF45nDygaYXF9sKeO/FRmF00eCRuva0R
VwJB5hY27HHNEG9R/aEhiAYXrvEcP2CUB1d/VH47El8BwpY6qcz0OWcPXOsb
KkiFM0mndW5FpwL5vWSR8k86twerIHxWAkhJ89koMwZBUs2cCudfGlC51dxs
+tWQuGnoDS7XAnnfxgz5/38utNh9KZmuBQe07VuWlmHoCtbPulf/vxfXv4Rl
Px56jwJ4mOzbxuKg9Gxxcir9fgg/tgPN6yLQ61En9nmGYvATOmkQt0KDDUWa
G2/EF9SXaHn109h3uNNUWORB92unviNBzocSkdDGq/NvLrbB8U9/gsrf0kAl
hvqevJWM2tNTrNPoKW1z6pUlwz4aTNivU4WTU5Dp/sUdvpZhODleuPbbegWe
CvbHazuloLkgb4WSnXFQxKy8w2QsAzW7QMtPIhkZZTgrTU9O0/E/2sWmmwqC
ifOsWSYJaNg+I5lHYh4SVSyqWqhLYFMSzdNa8QV1L0pqK/5bgLdXj39j4V2C
Qzs8iTKvotDdM1jt2eMY2C6TWOAxoYDaFIM5a2goMukwlSCuY+CBuYeeQAcZ
WvlotdblAUj4j3532wcsjGIaPDf0yeAVJ6TXfsgFVV+4YRGyiIUK85y5Xxxk
uOAlrzyw6zZaPVp4nJkBB8LK2VbTmyQwTFV3fGf7Co6a8T69jMeCuXZmyplD
ZEg2fmpa+8kPhMbrC86GYSGspNbysTYZ7ipvi/MUBMP2kyN7YAcDko8djlIQ
/fnUOS2i4kh4dVKPyfYcBlgp4e8/PqDAzr1xee+LX0CwUvWM4pFFUFWd2htO
79lyqdbruscT4IK+jcFJi3nw6BXWPzq/BAEJRV2SkslgpjddZH5kBuIZxI/Y
11FhS/O9wO8vKXBHvzRfBibg86U3jXlflkFK/5O3Pj4F+G0STyztHYEje0UN
Qo1XYNilkIVokQIkoqb/cdV+aGll0zu9m/66Jyn33jmdBI/k+Mcmi9uAWbR9
I8OdBu9pwQuLhFgQiP4rJVpTB2FGLNiNVhq0vPnK9EYzCg7Hvd7hLy2GHPbb
Q2tUeq4eUN/mfBQEEjPvVapzEiCha8/Zg/T5fL732ICzjB+4PHRXVTruB8kJ
0U9U6POMzTixy/DrG8S49t/RcIM4dBrzdfYAPedDmGc8pMXj0Wc3CVPNmkxk
4NGUyvqDBqMv6iPXyz+ghLytY3bF5Uh5soQhHkfvizrG2//CMlEHHcAU7zah
/nzC2nI6Df6sTd+aowUj6jRze/H+FiS6oia0EUuDyZdb3IHluUiW+NcsSmIQ
hcmUBk60rcB9M/x6l1oIyqp6g47E96GvBU0Nrw/TgFVC7nbOeA5q3OkSerg4
gX57Vc+o2S9DptSNWln+QBSZJiZUyzuCGqyoUYkmK/DzqMRRHfMMtGlt82eA
NodKMqbMz24twaMaJBTv74s2Dh28odk1jlzPWnulli+DyyEp0UtLiUjESbJn
V8giYl7j9OKto8CehBOW+yoc0NPkznf8e6cQW8NZUsaNZRBlvndPOzgEiRbU
qwy1YhBxktmTh0wGLQYKiVVXFVY1p6UtK6fQMV/JGC3OZdj8E2j/o2GofqKl
ONFVCovsm7mlhGLIwNSsLiA/4QLBzyKY0/snkSJb/cVjKsv0ueS68fxNCFxa
LIzQJGHQLmTtsNlPhtPDEpoZNH8YU2V8G2E4jkysRw67di3DrLP174axRIiK
/XvDtX8RaVQ1c5eFU4B6fb/tZb8gcHo3ahLiNYzcyd7NvO4rcGvueBGrVgZI
jEyM2iTOIzUVjuOBXUugYDHpdPRZCJw2vsY1JtKLuI9abdWK0ACPNVFb/pYD
hy/IYaU+T6KmwxTXD3eX4US+Vmpd+icQ87ttOhjfhN6r/1QXzabB2kHXGywf
ckFwZrBbsGMQURq+SzLQ+z3+uuF11RPv4FTEXQcW/VJ02YBvwZVC98rrUyo/
IBPmj7heH2VqRk2GtoNXE2lQt8szmPbBBRh1Fpp+LEYhiqKR/NkdGvz3bPPj
B/442Hbe7Z4oko02GnZ6JTdo4OLXeOiYWzlarbaTxSmUI3vv4mNb3fS8NcvA
8Po1oI+Grry1G/3Ie6uTiq1YgTsu/3qeX25C+zb0PBuEZ9BQQIiUtAkVmCuL
kO2tBlTF9CvpwjwGCfba+LkGkIFtc+rH2JUalG7WyndsB4/+/jtMGmIhAuc/
2zUGSjH6eq4x7d8AEb3o4o95Q+dJJObPxiiViqZggXq2hYRKhgpY78riYN/k
rPWDakM0rDBhPslDRkxj3+0PTGLhSvu581/wSdDCz7vlTCah/Iai+Fp6P3ec
bv8Pu1ME6ZcCS3hPk5Dy91W33RQcuHo1iBCVqyFYV/wbcxABNU/ldW76EGCr
8s31sVYEoZoRzl9KsYhlbZP/PZHukewzNtzcTSDu56haKzWHvnDInpCcWIJ8
bbMRt84GsJ0LmH9AHERrPfGCEi9XwNKu/SLYVABfm//t58vVaM38PEbyOw1o
nsZtJJsWtMP3PNDQ5xvivv9LlsWS7k2/RaawrP3ot8JddmebETT7ptHYSmsZ
wvd2Letn9COBXEFnl/QFtJM0N8guRoGbR+VfGAd1oQ8Jj6O+kHDoVGbp7jv3
iLC9M9fp2NCMXk1mWZirE9G5Q8XOJk/wcHq5qN5zowbp6oozW78nIX93jNA/
VRxwkyTIAha56BBD7JYI/Tyl+lMjjTuwwMr+5nzKt5coPOp1/IIqGb3cyT1v
EIeFApaLxu+sM2H389vkN5JkdPbCl1/COViwvDsdUr9WBbHebOOlbSTE8itW
OZwFB74aB0If1TWBQfjI8hQiouknIQPtyzj4/ddILzS5E9y1MS7SuXikg2eJ
ysghgAUXIVlIoh8uOPq4MXUvop+f3j+wtiMDl4+vbWRVP3T2nvrKIDqO7g3+
Z6TURAWtsWx8/uU2WHM2Y2csb0T3fXN2/bpKg2vce6NOaQ4gxc0NoVv0eWRQ
mV1czV+B/Rh173/M44j9r8RgmsUY6pL1r35SsAT/LCUOn9wZRetNzsr4o4so
4A9JgbOaBHT3LKjNGER1E6lxVb44dCk6nP8mlQDRFUpY6eedaFaKUVuHlYDY
ba00xbQIcHDo5JVP1xuQ0qBcsKUNARUM+ko9cCVAr6o90r5djBriFC2+aRDQ
Pdp5ydtTBKAUTT86xOmGxLlFL+VcI6BUlSeJYUxE6BefP+ginwvRd1Q35CwI
aI3jY5JGDwFc6ve0UzTqYDVm/JVJIgE9bzMIcNMnQPjDKa0vY+0QH/ps8yj9
9gWbFx1EDhOAwSOgkUwcAKvJZ5j5M3gkd+cUKdaDALeVT9xN8RsFy83yS9gz
GMSuml5qfogEPzm87jE8H4fPysuqJWqTKHTpx8+xnxTQvSES/mVrED57m+Td
l29FL9PJ+QGwAoO1i0PB2WOo/GxWbIJ/I3JxKMqmxS1D/fmLplmFs6hNbQ61
mI6htJzbXvf3UYCkeyJTmTyFMkqY7itJLaCRrEckChcJjNTj8NOJI+ieNY0l
JgiDRiP+MWhtEOFd05Oct8Xd6Ipy6K5dfhjUs9zCMSFGhgcnafl0rUe1wUaH
59sW0A/Df3tNf1CA66ETR0xKPsIoCR95JDuL5nyPG5KeUyHm6k5GSKI3OuH2
3Hr4zjR6/+dEV8k6FT44+9476PgV1vlFBZklZxH/pPv0hAMVWJRP6WzYf4PU
5kfvTAYX0GAB7+IM4xKYCS08CffohK9z2ZZGFRh07ZZ/FYn+fJi5Rlm0w4dh
7kWLZjATFq0MMjnO9hAhQVFnfktwChSdFRI/nlhEfvJNHFr5RFBf7ZC1p8wC
tc3CreHYJDqvEiGPHpHh76avg8quSdAlHOjxJbchyU9m2hU4KuA1rAnuyTPo
Nq8og1paIyLvEXmVokwFS6LqVzufRWTZ4czVyTaKAv7y/HqVRoJPYitpX+7M
IbHSyQlzzln0Kzvt75QICT56L/wh6o8ifLDN2YjAOeR6T+BA4B4KaDmYexJZ
29Ge3V2kbu0JNOKfu9dl7zKUeD4SSDUoRA2zOXf0CzuQXMKZoM/6NCi4Tog5
nOeGxOKO3/NPCUdGJ704U+j98kw8TYi7zxld+JTOdsygADwUg80s12nAgmp5
T0q8RatsTYo55feQNZYnpI7OUQk17efaq9IhROeQccH5NkRNl5f55UUDnz8m
MkG4ZvBlr3/fVj6OvEOu8u/VWAY7LlqC3MwwKHqfTtxenEPerq0DVZIUEFZf
WtUQmoUFo0OVHu5zaFZZduMYBwkwewwEdnstQunzm2krduMovIHvlQQvCXhn
zyhFGc/DfrNk/ZGlNvST6j4xp7YEr6+/WHlCWkDNfTie1vEGFJGe/fj4OAWi
v2PXC7ywaO1TyiXZX0PIWSMx+k0gEWQSLu8PJMwjkW+3+60GJxB1x/NDVT8J
uGgcHA8qhlB2bpKAYMQoOrjHePttOp17dVX/6tYXIb6y3WGrDLVIvS3+WSed
S0ubO2ymQ0qB5OXZ43q8C84cz7zbJkf/edf9BUJdKXggb3FyzRRckmlrub9F
hVtOxzu61kyAI5nj05HheWBrk/E3bV6CVTPJQ+psZciL+WTzTu4MiB7Qqun2
pQLOXdrq/Pkq5Nsdc+fgswG4Vr/AWNO9AnvC9ryTmoyDG07j6z/4CpCuSDp5
iUYDbhdCNeblAOhSX63F546guGOf9koLL8Mxb8FHKqpzUKn4MiQnexKRDyfT
KnnIgFsYF9/UwMK/2Arzib8j6OmmuEW9AhGMGkeaLj7AwMUPhXGnKlpRVkP1
Sc4cMiQaf+oQ2YdF5xXvxQdM1aN9bc815Gz//3+7X49KY3Con2mvybfQAUQU
2q/Q0UkAYw5Vr+/Z84j521uptiMjaFHuEsMbGhkem6CvmpXtCAo4fX3nW9Hq
kF9eyK8VwLxk1br0uB6u/Hcu0UGuDf7I/yjLU6HBAddB2VzpbhhIlN2R75iD
/PLK6Q7pJciOu2TCwd8Eujc1rCZzcHC87LtK6S4SjH88LN9Z7wfDFkJWqTYE
eMOvNRAzQoCL3UlsEVcaEKtDSsXQczz0OVY+CX9JhJ0giebzX7vRsONK1hGO
RdDlmSaYnaMAs0y4a6Z9C2oW0b5kHdAPvxzmCJIxK5DMy+n28mUDcA36qYvR
e8P7rd2tj240EOiIch1XnYWaOg8j0pkRZLt2+jA1ngLiKyk4SX8c/DwTopEl
MYTIpkE9+D4CwNcLMfetcPBi0fFhf00zenArIdxfiARVit67outx6L3R+RSP
29/QY8FK1qsCJJCbePeQowePRHt7i3aEetBEthtz8UMCLG58tQ5znkVTJw5c
PvSsD91cbay5brwEoaQheY7JaOTkssStetoXmaQwGgzQfedhpPAEh+ww5J4+
VlKcPgbTKuEuux9S4ce9+pb7QSPAUR9JfsKABTBs+HgmgQhfzP0PTvt1wDrB
Yl62kgA/9wQbBZXgQZHtO+e5S2FA6SBzU6lEOCH/VtZPHg+Shzsc7u5uRQfz
RO/Z0eepbtsx5LA+HooG/oui9g2jyEQykr+Ng6d3Gd69LCOAzOtLzd03R9Gl
4/x2wDYNkkqjhQl/KXCDuGv2flwhMj+VJDZ6q4jukf8NsGNosHs136aMMAmr
T+v258X0oFuh4nck6RwbfKOeMCaDh97FSFX+wj50dfADzaqYAEfzqdFdf/Gg
K2fsaanbiPbJ7zcvHieAg8yxpPT9BLSa1j6mqlSFNl/kLO9jJILoZRfcth4B
+dc0fJy8047EmhWm950lgJP+3msHbSZR7scTbb+OtKJdqlmFl+g5TzjidVaY
sRWqND5ck+n5Dkayvis3jGigo7Wt+c5nBqAjk/MQ/bqiB6cCohTIsMWrWMKa
OglrCUy56+ewcDncv7NCnABhVtV/9aR6YVnhR0od/Xwlyo7GORsRoNT4l9C/
pmj4Yvc9rsOcADuyQ3o36BxSevczRsm8A7H0ffO8cooAA84dRt/VCCDuuupV
dmMCHcxgfnxaFAdEsd+jkmV4aBUcXmBLmEUplVoxp73nIKL+gbsS/XUrN9mW
rvUfQPeuk89HnOqApZSEQVXtFZjSKP3wXGgE9EPQpTSFRnre4hkLD62A8DHV
QNN3eGD58Gx6lKMT9fluPXAZJcAep8OkCREiROmwHjv5tg6FWTBKdbfhgflP
jy4PGxH5F6255vOVoVuRgRoXOAnwdKLCqTiegOzVOqp4U5pQjHTBVD79nD13
SV8z+DeMHLKqDsxt16CCeycXb11bgabgE+nj90fhb0VwHdm4DcpSH4+ZZy6D
/GoplTFlES4H1l/4/mwKFFxnsOvSRNCsWXfFCszCLsHc+N/SizC4mnxrhD5v
maTLedpP+sGub275kAQGggvuFhv8/3N9K2Nr5h1jQZ5vJiNzYxHcD7OFtbrR
+afC/Uy6eSfSs/xAdLfBQMIgFzbfjAxS144sPLswjepvvz65Qb/94POZDMXv
BBCskzTk66H3e06MhTPHLDRTi5OE7xAg/a662Kez00hefe8dqfk+eMRW5J+8
vATLIqZHfuh1wqg3z4nrUYXI/np46H8aNJC6WZ6r7Y+HUt2xmWdNzUgw+OK7
22JE4Ftn1rVjJMHTvU3l2XLVKIjj2OH9azjIkLjWbdVMROZlteveowVI4XhM
R4oBHvyj+/KDigkoRKXIldvvO5pW9Bs4rUKAD2oDJrtO9KA+YmpQk1MewoC2
3Oo5GmCDWz9jB+ic89GaW86nHUSifixgSpfg0O6xG+m/sPT+VA+92DgGUdbG
YbGKBAje1vnR1joHXcZp5U+rpmHcVLU5xYIEzzUijh5274XA9TC4/30SBHzC
8p8YUoEjM3qY5v8FQg9v3P8wMgZfefh3PmKWQcHvsHzV9zYkNyCaHg6TsHBq
WfDzJBW27yj8KT8/g6S57vFKmc3Aizc5+75skeB+48Zpp3EsKjL6O3GvbQIM
nT+r647hAfP22Bse10V0RqBBbeRcH4ztAUaLWjJ83tDBvMWXAvkyj0Fpoyf6
1DMj8JpMg48BHJ6xqvRz2kvbtye3Dh3Z7WNmE0uEje/DX7gTSHBR/Ejo0O4y
tKtfTb/yPg5enTwtyKlE99UP/U9euWcgk18LfuQ+HJh/Do++l0tAiTkiPsU6
5UjHx0Lz2isCNJ8S5vhPuBF9v+ynsmsjBl2Po/JMl9Fg1QKJui4tQssrR5Pt
iWboGjcQ42enQAlXk1qZOx7iomv3vLIdBDHLe/5rBwnwLaFLT8FnDmh3LlzC
pQ3DabcJ2VojCvgGdm+0MXUAw1alS9uXXiiLcsKpf1qBKym6fAcCIqATBSkX
vmmFHCnGVo1AGvyiuOOiFBvRJJVj48tKF6w+fDCws7UC3yy4QyMPTiOVvvta
BQrD0OGyj/z40RIcJMsiX06673UlP07oGoLrGyHJX8QIMPso+PLLIzh0UbDj
tlBfB3jeUA6PFCSBrvteQ1J6GgrZ3HHOnY0C8lv7rdnfNFAqCNY2/A8Ha5ea
By2zy9EsLDf17SNBW6+kXSUTGfZdDwh735CHGmUiP3HPY8Fci8CrFk9Ct3T2
X4u3jENPpyksOHsc2EnR7D/Sc8NVk1/b+VoO4orIK02NIUDupSBCSkAJ6vKe
z9Tz8kWHbL3kHak02Odn8V5sAgskNeN/Jvm1cHRPm3TaIgnM45mPqhgQIOHB
kakVlzbIHtwy3C1BAMyTPNkZ7lnQkmcNvufSDsEJ66fP4ZYgyzL6zDamEUx1
XardHb5Bofb60po3DRxX86MN5N/BZ42hKEXVfFhzUn/I8B8N3ogf8XtdWoXu
LqZcMaiooHO2sedlROdqjcyQ/1onkEOZzBdn41b4/kx/xmfPMpyzuOq7Qffq
vA9v+IZ+tAPn0Z+kzVYCOF8ocVDJwyObwRdT//oboPWHXbnYOSLMc1V9ZDpX
jzgEBDBcZXHQLF1/n6+FBkFPz8zdicOBSAtZZo2YjQ7m3v0T9pIEZlnx1xhV
yNCKffJ7MjsVnWsWLrnyGQsY+cnpk50klHJ59ffVTT/0n4jJMYosDvJaGr9O
RxDQr5EFZ5HZKJQyuO/9eh4Bbum89GDcTEYKF0yfqc85I5lWnk8LWzRQOZy9
u3EKB+U8Il4slhnwZ7o45s8NEhTz1Vjq0K/De8aYoaWoFHoF5tbf03ttYV3c
SHp4Gr7IPRWTvFQGN+ZOTGVWUcFCyiim1O0b9M4Pf3dsTYN4x6vBZ7pp8EMh
OMKj1Qmif7pqf8x4B5QaorDZ/9+nUP2+oShRgmpTN+Pzi6KBG956pS/R6Es/
MFsxN4Y6s5+zT+kUwg5uOap8eBkKPtfFCIzi0cHqZOmDXWUg2ZXWknKbCDYl
dXsXHAlI7R3hV+zfAhiz5HmtXE0APpOJu/82WtAISYfwrCIcvpzvCJUKo4F6
5IfbCw9x8Iv7v6wI90hUdc1Ira2YBMoiHF/krMgwzeuJkxkLQbr+AcXeDli4
sdAY3TpEQhfxxLwnzm7AJe773uEyDg7SdGYDvhBQaizD6WX/t5DgxVyqk02A
aW21JnfleFQd2hU/8tkd7Q545bv0lwa2KSwf9x/Ew5p1wKPGh7HID+N1sZmT
BJYxtuR1DAE0pRY6zkMKevti+1uiPgHWRaBwV940TO7eKcxDX9DvRObXihNU
GFjC2RTG1kC6G6Hk04A3Wrkot794jM5XJ5K/2xWZA/vFSjGh9edI8ECTzCr9
nD+868064VmMWJrviPr5BqG2AgnCrRUafDpraUB6MYa4k51K5VhS0GW+nbo/
/y1DP8nP2aALj7Ta181/aKegDIbIO8FWRJhNKGv+FkxAUo98rVPvR6BG/VXL
LyUEUK7hZ/57qA0Nam7UvbliBmukthjdABrw4sVs9t3CQb3E5UvmAn5wW1YH
09lKgt1cnDLVdP9YzmeNuGHsABcwlQaGL7BQVSmnWV9NQvuM7+Tmo89wziP/
gb4GDjgJp3bN5hOQ963Xo+dIaeCVLK9h94kAPn18IcUh+ej7G20BuYOv0WzS
x2RR+v5KKdtk6bvhgONnsKY4pRIx6Q3l/bAlwdCrR09sKwjAqSA78OhtI50H
rTd28ROgMMXAe6JvBiwsFp4k5zagHo/S59uKVOB7NvfPN70ejkRv6Ns4FKMH
umdvc5bTwNzl8/GkVDP40iYTK6SXhCS+Pj5sRn99vRkEbI/EVKDfuZYa868L
0Z2xMF+FERpMvx+19EsbR66hC3VJkg3Ir/aRKMVpGZRHOdPM4vGIn3ZViEZu
RAGB3371nSeCx73OGqMtPNrxFsbONVchIZmvT/0PEWGh38/Qyr0JWYk8Y6r5
8A6lWuDuF+fQYNnwmrYcfZ65XC0JV83ToR2nfy4+jwTrcrY9e3XIEKbjc8tH
8Asw5ttRLn6ie+Ob0P5ZVxK6NDH5LzspHV49O5G0FoUDGcmuKdMOAkpuUduo
ECmB28p6JTpPCNAx+8L0RXMdknfnuiTJ6gn0yAu+2UEDzdRfb/X3YCH+y/Gv
w3lNaOkw0pLSJEMd4tszz0eAx6fc738N6kMvw8rrrEfwYNQudlHQfw50M352
pd0ZQFqH5b7uUCnwjxA79LKuBcJ/Gh7M+diK1p//2m/ERwPWq3mTR5wcQYnZ
92Qa0PnnQ8r8XC8NiNf8a8AdIRH0geKc14y0LYoo//8+hR+JkX8VmiZR3GvW
qxzn+lGYL8ltjxwV7AVfv20WxiPjt4ouwa/7keGd2ioLul/8ZC1kzcrDIc9f
tdK3QltQ9VR+WPQiEfCnpWSN5srRHu7krWaTYORLuEvBYum9oMge0BCNA9sQ
2b91T0ugbCpaQ92SBJH69jJ8vHROOfuHNnkwEzjHFcKce7DwxOlg/YkDJDRy
dPnzGi0PVl+S1VZY8BBZ9eeK7ywBaf1wPK2iUwO76v/4vaHz83oOORdT0YkO
6bs77ZdPhfElM6V7ujSIamPs1fBdgN+/1p5ZJ7ejb6J8mhMtFHDdDHP//+93
HT47tokLjaJ3lcymlXRuP/mB6n7UZR6chI+49M1MoMAKN1OjVRIwaePP8HJ3
w0a57jE9qVH0+fj+aKoNPVdXzneNGwdADb718Ysng6iR9znxaM8KtHZcW/O0
a0XY0hez8pRhpCuV1BRKWwbDK/zk8hfT6KySm6uV7ATilFBT7gIKuG+Ydl0T
x6FCG/Vpju1R1CZgdrHuNn0OXp34W+uMQVVe3cbit7vR/BWPg+o3yNAfbTmf
PvgecvhV1ZWYzyEJ4yi+V/S8+nWsSHQDh4PG9B6OtqYaYBEtDP7/3wPMrn9Q
OFxHAuac8zyWJ4pho95FNPkKDu7nb2nftCei8VkOjxnhUljxbQ5ZycXDw7VZ
VrZpAhJxC0x9ydwIcTUdJL5tPEyoNkZubA4ho3DJTL6T5XCE3SaT4rgCTFFY
nJvDJPCa/3jA/KkDUWTfqgxUUqFh2Cb34W8M/FjvCg/PmkSvNo3NmB4RIHHy
TpBE3Bxs1ChRbt5aQJkML1v1lglQtC6S5HqiH742cuyU2S4gFs/jB5r0KHDY
IWr4rX04aHzv/BvdO4dWfJZNnrFTQXQUc1WV7mOiP4yPrU/OIwd/tnYM6xKs
swvyeRpNI66cofCiGwtItCuxtGqNCPt2O9m998IgBgP8v+J90+izs/x0Ab0v
3KJieJvU5hDyk/mQcL8PjWnL9qoLL8HKQPtIAGcDFE88P6b7Mw2cj6/pvayh
Afe/jWZVMTwkKk/hA1wbYYkm8zOazs9ZFRpPxq6S6Ly3jKm/WwFxWkzE/GYc
/NSdZ7GPJCDFyd/6bZqVoLyfWlzmQwDebwbWuwoJaF75zcSdvFa4upDz9QEF
D8viT50PNU2ghsHrMtrLjaCteHxvpNgy3CX95GeX6QMm//NHRYSbUfZ7R5b3
NSsgUTT7bm3/Apzbwsbi6+nXlU3dBRtEEE8eEHPomAalPVVSDeMYxLYSe+bk
IB6wcP4DeakPJKf4Cc0dOPR4z2V/bg4iZAe8OvkaHw0FKjvTEcs4JLShia++
QoI9/5YoCxsd6OSpcfUn9L2vu7vBaZNEhJ/mtbKmlyaRoo40t6M4FtnYK6rM
3COA9M+nTtZj86jl+pGB7clZlKF16F+nJRHenjkje+7YKPrvttaXJu1uZME0
HiH4YhnyBs2GvTT7IeqT7cJ/52ug45ul/Pm5FZBXwprGq+Ah+3fy7WW3NtgT
+JSt4xoR/hN6XlD9igjpWbei7ANr4fiFioZ3AXiwsFv5w/Qcj87PVnA/0K+F
pPL0B2EhRHD/E7BxXoGA5MA17ktwFwzMjFjM7iIAF/nra+KtWfSHay/33mvd
4HiO65Ff2hIMuP/3u6k9E/C3jGxtOzORZbyOSDONBosDY/K7J8eB0eB5xpui
SXSVq9ZDp40C3hJOpZUPxoGvnSlbLx2LTr9xCmayovvLa6Vg8qtu8HlqvbHe
RkCFXE0hGpZ4OLxg9ag35TPc3zjJcD6TiJDe9eLKIDwMrZ90NKa2oguFH+c2
NgjI3LTXYy4eD5e+xjjb6o8iihnblMldHHpaf++mvC4BCMMP5F99nkDDv8P2
5TXOoMpGxVfS/WQQFnX3un6iGf0lMV2Ia0dotP4HB/dTGoTb3yL6PRiD0vWI
P0dG2mDO4xOU2i+DKdmyWfsMHrYKN3leT3RDdczM90/bBEDVt33X6dcxdlPk
QUsHgrp2Z740LwJkJ+qe0ZnGolmjZsMytnoQ+Rbo+q2f7kHzYnNHffBo15Nx
xdSIfngtc0395EMCNGz6lzv/mEfAswYqn4bAgxJzJFeAAoTOiij2mUYkain1
L1S8DvqbHT2obnRPbJCy+xfdCfvk5Igu5AFUwjCufevyCtTa+PzjVBgEwfLC
n3yli+h9yH0tnutkWNcpEmg42AZTDCc2D50hoEPxR1qDXhIg/1bEIwomCsRy
1UZV3hDRRDQpIbEKD28Z1/cYazWieHbzAfwbArqT07OK6Dmw6JUon8A8gEIe
MifkFmHQU80zcmsVJAh96Pefdkwv8mk3rgPNUTSRQdAfuLkMdHB3bdfOgFTy
oa6L6Skg06X2L3SDBntWmpS72aehpKoluYB/EHRTuIf6K5bgrWd3Sl46Dp6o
7qRQawcgWy57X/4mAZjkTmmNMeGhen3mOYd1E7Sl1NdmFRKB7Fmk0Dy1iFqP
rv7dHdQAZWsZqYY3KKBSaxj76T4OaV3f46yjMAQtQafZgH4/d2RPwM8nC8hF
NOW8leU43PHQtn5D9z4Xy48O86aDSDvO7PH08yEwK7UXLzRfhuj9N59//vga
GtUJzQUpToh92oD0/+8NV48QNQngbILl2OseDj9H0fPIySd7q5bhASehQ9qz
DvKqXA9zW/+PorMOqurrwjCINAKKYoCIyk9FKRtEWAYhEnZRSikgoiCK0qWU
iIBISHcj3Sy6uztvUldFEZH47vf/nTl79t7rfZ9n5tw5k/inWG46LmgGZAYK
F7Md/ODJheMuf2yn0dl46f3kIypkZVF3X7yRj3ua375RYJjCJyX9NyWvzcCq
6sioanAlOh3LUL9ycBAXxCP4GXbPgzHLQ4OrZ5Jx/PTmRIejBTjnl7nHhM6B
t5xjOTrvNcKurRnMXJUtMGU9uC7gsQCgEZ/z9/4oeJbw0vLb+2Agbd/7Mq4Z
6Kx46siQPg37LXbplX/ohsL+HWsHFcignXy+N1dqGnZ0vbj0LrkGJL4ayeVt
p8LR65+aGvLH0Dwwe03TsRL+9W+5LVMyC7MLDmny/lP4/fDbbRGOPZDMYrU7
4TcZSv84Md/KHMc3Lyjm9mPDsHVGy+sIDwVklTPFmQ170fSUiPIa7wiUfTv+
Tip7Bj7q27Leo1Shn/adlmfT9PO6tKd+/dQCHQYdzk7teYscVqNCx63iof7F
128JyzRo5o1/dFgiFj5OsbfWJ9XhFRG9+3VvaBAj8EXt45/38MMgSvzVUgcq
aoqKOQwtwDHObRYLpCBM69XMfjPUhGZOvz+ZKNNApfTmYy5lK/wUmuxxZiYE
q9LcQ5XWaKAlYtm+LbAErJ6OtgumtsBBpcqhn+sL8Kh69/M317qgQTVSyXZi
ENI32OPcWmah/wH/ni/qoyC4adW0h3UEkuoZj9VUUkCdyzkv6r8pWHFW7FCQ
6IPt0t13/1LIMMz5Wd5oYALM1PzIfZp1cOeilrNn1AyMCHV/8WodwGCbobNP
vlSC9xOHaItj8/Az2EVS68gEmqtIsh8S7QPnRy+0D6hT4Y/Dy6wp0gi6hxo9
fB00Dt0yQirhDWT4RNBXMEzvxUdqFg1WaZOguu+o2v5HFCinPlzY+awZo4h7
2SSaJiAgwHD6js4M3GiS8t+9uwS3/s5naZIbhrGrM1+WKufAcCLU3Tw0GqHe
73xYajewG2QLGZovwJwBR5f+Fj3YyxxTLKHSDiMj3YKurDTgmvW7mx4QBRa3
n9h3xXbC6hMdSenyBRDYctVuZiMfqgtE7VXuDIBB2HHbP1bz8N6fwC43VA+x
qeUSSU/HQaf3Wk6Y7Cw8TH78ti66G4r0nzLN3p0ErdqlS8c4qMBnKSrvITUM
a4kT93ikJmD+P2G1bSwU+NTqLCJCHYeuF4/eMSkNwJFJtRqFHxQgTVY3ZP8c
hpO1ni/S9tSDOI+5RvXJOXjTf5B96kYXMlJGe197VIDX/otPP+ktgOzWstlf
HEO4EMTtMZ/TB5dUg7PaaDMwLsz1XtZ5ABU40u5rbZ4EyxBnMQExChzRUmDr
edyNv5I8fD23EyCqwKGSd5EEX7zDbLp1m3FjruDUIr03nG5+Md3FQoYH4vOC
xuMVOFT+2HuJQoDziso9z4fIoHlqMsiW9Rt2Oi3dYt5LgL1BzOFDbRSY3DV4
bUeOBT5dvIl3/aahw9O/rucGFebO+seaeKeA14/l41tqpsEvd37HE0EqDGhT
vgcWlsHfS/u+qb4hwCJXMc+L6xQQ/n1mu1FRAwQJdJToEAlwYqZdQPA5GdLF
NK5PLHSCg9VJA97TBJiQ0+6oPUBf5z7n8Nxr/VA3VurCkzIJ+7UetkQxUIDz
WrGir8AQNOuzJT9THASbV4fbSu/NAMMZq8U57V6Y+j0Z0EznkKsOQSNrMfNQ
LcX3fEt7PUrI1XjY65fC0EnJkEg5Gqzfke12De5CVc+9OismvWDI9ES6MHMO
uHb0VvlndiGR8dKxNZFJ4A8a9n+kSQXhZItnLyltKOPnLj+6jwj/HbHSKK8i
wVU7sX7bhjqUb/ZJypIkA4NyQZeeBhEsJd98HSwrw3sej53uClLg7pbAYYs8
AnxyMB5c1MjAPRdlM6TMKSAeOpaRTPfTmo9sO023v8HjRzX3DLylANvZR1so
YQQoI0nou9MSQUfB9GCkAQUYEl//8EkmQJYlg6K0QDHd1zkqt+6igNbr6sSl
VgJMesi0ixXVwMCoD7+YOhkYS09vjF0jwk2LZ67qXS1APk9M/+RGBAXOzph1
XxJMNDU16a11wpV758R4WaeA/6+SyqcRCiwV6Mge2N4NPrBnk5vJAHRpZC9x
M8xBu0bdNdKfFrgUadB760AN1NT9YS+sWgDu0lZvY7MibCnjDdlyPQ9qF4J2
zhXTIHL8WNHR+loEQcozm/hOWPMj9OxVWgAh+e6HJ0br8Yvk9djh0THgaSB1
jRvMwhkuXasdv2qQZeHqKe4zBBgI5nZhu0CB7/xN3Qd5K1DKucZ37xYyOEcc
Z1Kme3dZ8kmuPSF5SC1Ub/seRAHPO3qzJqoE2OJ5YVw/PgG9g1ak8+5T4Z2F
ZKyx7TTEcrL2kqpeoe5vXmGNQCoMrab5FktPA1PFPp5/u6Mhgnzd/KMRFTyW
A8ZuvJgGuFBydywvG34H7b9/vZgCBQKH2FjFCZDUp3rt2OkyOJ7gyWz0gAx5
b+PenQsgAg8T2XMsuxpKilWFFLsJ8NRf1qCkiQzPdh8bCTauh12PLE2ZAiaA
N1dO0L1sBiqb1WqG9tfD+OA5aSNSD+irHpti+TYPCk8nHkTdroDjq1O5ppsr
gJFjfVbYjgYm/N1wVyIW2zr/ng6aTYIISrGnx3caCMfeuRY7mYUcTyneSy51
8EImyHz1Kd030/st5ePzUOLss+CHTb2QYdUC9//Mw00/WUGZnlxcmbsVfOT2
OLybXO+VbZgFfWaNfd67stCTMuSyLjQNZyVVQqf8qBCXGcc+L5CEx44xGyer
EsHK0r/TpI8MViZuxWSNUDQs1Ozse0MCGXUv1ts1JHCMvzon3P0cZ9Q2rweM
k2DT9gu8k49IEBt4rrnbzB8WvVN2pnwhwdPNd1cykkiwM/yx8bM7cfBLx5ig
7E+El2qJmgdDyXBPi1P9FzUDns26khkSp6FAsCFdXIIKOuuL8ssdOdBv7Dty
KWgCms6riZy5MAvXOgvVmyh5kPF5789w7wEY4yCnbn42D1uCQj0iGHJBYWrH
yyfhLWDgOHp0hZ/es8vfz5dXpkCP1IiTY1surEVdS08ZpAFHcLjjTcJ7NGO/
oTXuFQL7mwSffV+lwTNd2yXdgSCsuJ67t/N8CfTdFz+o0E6D3+S4N3GWkfgv
LFuX/3ArrCk0+5SI0KBc0latzDkKb3Bxttb+7AMthX0PcobmQVGtQDlVMRzF
GxS9mo+OwWWmVW7u03Nwxyl5IofrC46zb9LmzZ6EFha2I2cTZ4A72P+Ty2Yv
nBuWqvZUngY55Y0Va08qjIcEPTpmYYIVbwV3dX2fhqGuOdtFFioQqrbnaL6x
hQWx+3F7K6aB1exAg6I4FQou7Ng/lfQJXnx4zlWVOQXbTp/c3LlMhVWWpFOK
piEQZZ5mdTJhAp66SI7Qrs/CVe/omykFkSBtNxD33/5hiAg2OHv+zxywXLw2
LNQeBXKPFewEpLshw4MhVsF5AVi8r5y7ER4OQg8vX7ArqAX+p2zMVe9oEHT1
jI0PMQCch7QlOnZ/A34mzceyCzT4m5ZVFmsbiiJ7pV2H3ifgbql6rlu/6f7u
oOmpPxCHnNyW5RqJlWjtESc+nEID7Wc5zf4XE7Fgsroren8HuhU5OdQuLMDI
6Org2UPx2LboMshc3YdBBUVZlIl52M4T7bKkF4UPrL3WvZuHsWXK8ZpF2xyo
VdmezBEJxGdRzAF6/OMYFTc2krA0C80/9JZq4lxwZruqj4jOBPa27u6yc5yF
95HpM6+ctEBiRCCg33ACh466H71i+//vNn62Zi97DzUnf2LWpXFk+HGuOH92
FrTOlRpXbAoAg2/lpJkdI3jw8zGqLc5BgtJqeVlrEIy27Dd/otSPciNphlkt
82Dzk/rgRk0wxChEHcs60ol2u52ygjoXYKdU/cK6USC8axz913ypFnuO2nkZ
fKCBfslug3enfaDfkomQwJCLiWF5YUIkGuQOJWhMuthAVEDJ4Kx/IFpmhgZs
WqdByl6tM0GrOdh25ay0J18uyl1iZP/WSgPzm7zpE9nlaOB1OO3kUBs2+En4
fKA/l4FLd9+lHRVYznjf+afzEBpJbwmeG5iDR6vKvqdMSjBnccD1uvUk5qV/
cBuk+0W2B2dymEourq2YtfKLEPD315FDUaUUqE1zmjHoTsYQ/aYip3gies9k
bxJ2JYPl2c0BVRtB+OV1Hw1vkrByTfL+9RkSWLtcVuMrugM2Ak6lEvdJqJq5
YHmIQgLTZgoTegbD68cKt9qKichVrmL00oYM5UmfXKMSE6CdoM/loEvADz+p
d5JiKRA7OSzKKZEJGp5Hm9S4pnDNW8LzhuYM0H755vcJZ0OnqYIpB/8o8oY8
b2IxnQPe8UNdu/OzYHgwLChkqhsfKj4JINxZgBcPPntpXEiFk237vDe/q8E2
3OKu4kXfTzlXGtUwDGbnCDOPOpPwW2+x89lFem6UJDzN567B571Jo78flGAf
eSb5Bj2Hc0uK+A+YtuLtUny7h70HNeROKHHY0/lE4eeMDHsrehxPfrdyagKd
m/PcWiNmYOZV+4GivHqsqjU4k61PwKfNlo0ff5BB36qiSfdMJaYZdNbwDJDw
WWTt/MQaEcav2l7PXs1DUuBxAbfTFCw5kfG6tZwAARzcA/tuxGPT41GGO7MU
jPwt2svCRoD+j+xXBnpU8LN+xlDncSo+OWXd/rV4Gg5wU1QvfIoF284d9n+3
UTEp87XrvoFpeNZyTzHfLwci2x2FEl9Q8H28d2i7CwGWWRl/q24tg+AE1SwK
IxnDTx27L/aDCKa7JAylk6ug/OUjOwllAgpLFQylXaPAPZ9z35bra4CcOBl9
4so4yp7oOUh5Ngs7M39lNftXgcB1oTLCiy48bn7p91+VBfhn5EqJup8PAV1j
iqFni7BhVdS+tJAGBu/4D5bu6MAw/lnf8ycrcOPVGNdK7gJEswz9eXywD6VE
DsgfOdmHjJNr+8uIs8D379Bjg+IefHOPNVNneQILkmNMnmyjwvrwcb5l/Q4U
ehicccqdgGMvidljB8mQKaeu4HOzHlXg8FGeOyQ0DU7vED1KggqR4wnXPMqw
QeHuyS5hMlbfZuXb0UaE709Zkt6KpaPUVGOOnTMZRSpWhVljifCFcEvpWcRz
/G+DsHKrk4yJ0yf9x3WJIG7xyXBmLAlu8PgGHthFwcSOvTfUGYhg1H37SYlT
MegcNz7wZycFawLrGba3EEBE7hzP95QayB8k+1NfkFHVceePJ6JESNEU8xVj
a4F1w3pFWgwRV9+o6Q65kGA9fjtBYawDisMKqTTaJG6pH6+8tI8K+4oCKrb2
dsAS5F73sejHfVnHsMF3DuwmjqlfaaqDSi2VcZOOSty5KQ34xGhQKHHf54Bp
Hz5vk78F9pUoqWHazZc4D7tP41R+/wieGef6z/VBH3Yv6xkcvToDT9IKjP36
B/HM/MsPXBoTWGngyutO53/uGv6YKxnduFz+ZvTCzBTufWlkHz1Chluk3omT
8U2oOpjt1Wk5jXe/m9tR31GgKf3VDd0mxKRNT7Ou4BROxF3X94miwoTa2Xsv
5zLQbbrpatDqJFpNPGPUNJqBW+jfb9LgjG4vNT9aHp3CvvfSYWl0L5AfMBXc
n5wI950jacyPplFo58xYmRkV7s0yHi4RLwN7hZrzu9oJWMPl4P+XjQJyXGGB
nQ0NYKMu68pnT8Sd020Zl6dJMKqzaWmjoROWK3QGTlcRMEI4L2A+lQQrPX4H
zvr2waKu1FQM5xTuKBrfs0wkA0ebxiNdjQGQys4nl2oPou1cU2IyzsCBPVur
Da93gR05Qd79Wi3yxe9vZjuxALOKZke89UZw5Dyx1jG6Ehtfnj8A9+bg34M1
7of/TeLn1DN/HuzvxSQ1NtgxRoG/pZ9fNr8axXCny64G70dx76+EdAtFCvz5
K63yg9iDc1UPf7p3jmM5hWnsShEVfNjuqJ9ma8Cq46i9I3MYU6yWmVil5+Cj
qrlwwLs8zHh5hjEnsxudFB/tvnt7AS4cPuXnLx6N0mon+uYfNKGXsbpuuyoN
CnhDRZ4ufcB1ShQ756kGrH/Mz6xPzzeqFI06ud0HQhL7ZosMO7HLRNe2rWkB
GlKTvOJl82DUJsz3ncMQBotV+m/bNA8f4wzcdr9sgDTRez7S3JMYQjnZ6/po
Bl7xtOL+393AMe3/ZERrCst/T/zSO0+BPE/bmwaUIWDj3Vz4YWwC124x2jlH
k6FSl8hhlzwGZ16FP/zMMIhl8+GPTx+mwrZFgYW4u4PQdL1e699CHdp+tW9h
75oDQ4Fo44zmCSw1XZ8PHKnAiRWZ+xTKDIifbtycd3Ia24/wstOEu/Hz3q13
osrJsJMrSStAexwvvzKwfmU8iAIBPezWvRTQ0y8I+vazCydXxk+Yq/aj18Lu
Eq1Lc9C6hSxT+LsAK3aH5Xc9qcO9fJp8G9o0OK9NHK58GAgvNvf5JZ7KghNe
uQe+zdKAM2SubjAgEh43l47IaLRBzT05/W18NCCXBjnszHPH+rtRIVyqXSB1
pcUxKXkBNjs7DfCeSEJb6gn5z7GNcEKRfy7mOg2UxDlye0U/YljdMwm9s4Eo
KtWhprlGA6PORCtpQYTeMvXH+vFdKKSWqSysswCG+U+4l927QWzqr9gntlHc
fi/74LHmGagNkZh9HzUKWo9X+ijd9H4UoEXECFNA+53Ynk31k6CS3GgbLd+P
B/MCTz+kkUH2qFtJaNo4nPrCfZSPXIfccy7lA6dnQZTntODUzykk8j3xTZgr
x5c+x49UOlDhxRmVMMlkAra37c93q+7AtbKvT/77RYKoYmajrwbj2G21XRhL
e/DJQZsgmKZCWuOL/JjJRgzrVX90hNaIrB484dL0fRDqu80wzpIFxZdf7VyT
L4K2Ed2ivloarIzl2ydPVIOmssN3bbMB4B257mhyZB5K1dg7mhqL4ZruooSe
1ySUX/qPtddnBpbn1kOsve7jrhDu4H/XpiHmyI9VkisV3v/eYHQVK8Hoi5zQ
ljcJeeKDtx4+n4GGmXlGh9kqtDM8ted7RD9MktN6S7TngWtN9N+yfRSm0LKG
fgpFAS0p0jzzDw0yGVWS1C+3wZDnz9cHtLrQlVntv21585Cg28fW/HYMTpvN
TerNDOA9O7FPYrJU2Omz6dfku2nwM94SI1bZg/ZfkkmnD5DBVuBftdTrKZhI
4r5SnVSLm8+T61n8qRD7JyVHmL6fBqy7DKy0SjDOQ7P9yAkKKIX1xN6KJuJf
0zPLfwJb8PfQ20n5tyRQ8CvlnbQcRVvxYU2LqnacYtl18pXyLBwy3ysbwpmC
6/ueWwn8iMPPYZy+7nQ+v1m2+2fjf+1QwH8HysS64eivkJtS7+bBTXXrxxWP
ThDVmzN77zkJpPhTLSevUoFnzAjml2og/L9CMnshEWZXApK/0fltq2qi8Y3L
DuBpEPLbRowMAx+uZCzzkqDppF/Z2T3VeFY3qf/oAxKYfS6auPmYBJbVMa2n
wzvw053R9kWPKai2eGwrS/dvnhsPg5/daUHd8Zhqx7xuGL0E5PWv8/B3qzS/
vmcB9LLtDO4Jy8ezT+yv/ldGg6ykZz8TxUfhS/2Bj3za3XhfwfE3dyOdA028
uxNTCfBOUZuHutiJMTtHTLYWkqCuepKs60YANI/5apFUjY8cT2x6zkMBe6Ej
nIv/iKhzTzH0r14BSqRL3Xm3lQymSu0cqWdJONN0+ZZdQT0mprj9/H2BBMOV
k9fXogfxWNAC4QE9B4SB3MHRMAcha5cWHitVwE134qaba/RcPLHrwmoEDZ5u
PxMkeGcQBldffWAzGASvD7nyNKcZYLMpXV+9Rb9nr51ihuengEVvz9AHJjJ0
nw/0ZP/QBGqkVRFfBhLsZdxy2F+BBG4teeDn8hHWThtujBwhw1XhyGN1fCR4
8cu/7eq+enRUuFKhQiSBVT2vjWMwEcI/FezTne5F993aPWWmBNDTu7wnlP77
p0yyVSMmAzjqfXWdmDQCQ/VJ7skTVKDwWPEurhcjY3CP8fmyAvgYXNXcnUED
YtzFjxsOg6Bmlq3Mzt6MIw3vshbpXEEKaBuTu00EC2dZhuyjbfjf756O/GgS
pKubCihsI8FfmZD0HRcq8T+Wl9sp1SR4s4msT/1HwuXZQ3o+sjlYcqrrgtcB
EpzUFrp48R2dd8/xRG3ircYN1583vc+RQIBV3aPJoAfFQxte+L4oxTWLx9kR
+xZAiZ+nRWWhC1yS63M6xWrgpaSDs+ihBXgzp5Jo+XgCov4siJ+VHoK41HMX
BA5RYLJXItHlxTD0x0QI+FZOwkKspZllBwl0pF2fsLK0gYOdyteTAdNQysfT
yCtOAalg52qJR0Eg+GLRRUmWAG+pTUWnGyiwNiKamn6zEa/giZ9A5++fsyyb
A93JEFShPJVcMYg4zGb498M0KLZrOO3qJIJcYmq2+dw48vpLc8o7jYFn3g9h
w6Nk+GDqzDx9pxu/V9RxKdk3wYjkbcZfdfOQPro3s8uhGzbunzE5FofYoTEm
kSu9ABm1viOB9PP8EXLZuMyvAXep56VxtJJAdlKV4bk0GdKS5wtu3y5Dncy7
nGz5RNhGDQw3KSTj6bsWzWl8GRjTcpDsbEQEpvv7G+eiSDhRs3soT7sML72+
whxyiwTz8sGx2fytGLsj5sn3kkzsb7SZtN1NAxnjSR3JimFI/neQU+hLHTR3
LF6YVZqDVQXxPCO+abh+ZjjM0LMf0u3SFJr66HORmmxJqhoFxRDPoLH+UQhm
CSJ0bafA3jND8nqn2yBq6dSOU4JjYLpRymlC7xEt8W2exivhcGiPwytJh1H4
F6rXoK0/B8r397P3mTTg89WTssmHJ8DP9KVt0vcZGLsv2+zDNYKnHtrY3+yY
ABnKk3vyd8nQycC9ui9qCu1XNJleCo/AQbUwrWQCndt/Mp+veTqKIkxxAuo+
7SDRK//ynPos2OjKvLKsqIfbp3uLqvKT6R5ntuv0Exo4K+XvS/QlQshlxjuf
Fasx6NSzAbVDZDAR4m8c2EKB5eTaIQPeQmT8xX0pZJoAlomP6v7KUfAswy2z
gaJ47NOfmts5QIAoPc/lwUi699rEspceysMOMROdfHo+v+upPV0nXIW7I+y7
X3NGor91flRkMg2aBH+dVRGehGrR6rXhlWpIMLkzPfppBnJ0ue76jxEgNfVv
93J9F7ytdb27pEMCLo8pQu7xMfihWrNirNMHeY/MtjuQqfAxxaS//msTGH1U
r4y37oZ/hccOVuA8KLJMF0BaONBiXZwfd3UAO4/xQaORBYi4Q1jeylaDqo+3
XxdS7YH6pKqtNQvz8PxQ12YutRFkvGfS7WQySO/VN9sCS6lgOJ9um2dMwD+3
I8ojFPqBO3q/06tiIohxKW76pzCF8juXta/GtsLk2sixpFP0nmX6d2XpVSa8
fBzsPG4tDt97JvjefaeBq+amS6vXifDwFSV6vagUE4Z33VMNJsMh9eKMP3H0
PF60H1zvzcZMXjn7cCUCXH7v0TQSSMHFWZdVF3IoCrEMXL5kTYDDG9/zNweS
UFVM5tbrnhQc6dkXpxZGgtOPFZlkduRgk4Jli+F3H5Rdvh9/m0I/X0O1naEa
0+CWwmC6/KgUvpewRHooUuGHRNh2pr9E8NnGqyLR3Qg/BD8I+NP7ascVJdbo
y6OgafPS+olMK7wQ+jCu6DwLGQteg79na+Cgcszp5U21IB0kv3Z0Pw0O64nv
LRb4AnuUWAx0kkvhKetIv38TDf6sdVZrxpWitePhdb531aDF6bbpoBl9vpoV
CI2RQ9i+cHNG5UgHHDyZzZX6axYsR6r7zpsTsWjH+X36Sx1w9uLmnF8n6PO1
3SLrTiABZypidA3d60H/0PfVXw1kCDhrGM7anoipt6cjz7OGgorGeQ77XzRI
27CzfLJEgNuGhwWPV+bg6OuKzVL0e6xYxjTtzEnnC8WeM7GGqRjG18R9dWAa
Ns4Ipp2to+CPHeP7Rlbc0HDodLXxBQLws96zM/El4V67aHy2ORiPzgRnBWeQ
QJ3KNptQGo2picvdr2fccFkusSlxhQZ1Y5ZpoZ8I///eQXbV6xQQ+ydC2fqa
Av9O/r3D8oUE3D9PlclxFEMqrLzmfk6ComdGeTv5RkCecIWkdq4crtg8T5h1
ngPOf8Is1ikIwfcfVzvUZ8OSN+3NQAoNcMuT+QhBT2jIWSeFqEaDVdOjx3n0
54ZXvbQxX83B/Tpim4oepECfXoaRwAgNrMtas0BhAGMJN/Lr3iBsfSv3adeD
eRjOXVjN6Cdi8THFjxur1SD+H2mP9wAJWLavm/EsEHFLyUqzp1I5HDXLY4pf
J8G9zkt73GoQS4vNtjpIRYC0yIOinXQO+TxyykL2KwG6GR33Zx5KxINsR5Js
X1BgtLDKmlOVCq2k2BPM6tFoJFPrH+Q/DYctjf/c7KKg2e46iW9W1vRcu3iQ
7QQBqNPn92UFkXCy6uSRNy5WcEvkJ7tBMgkGLk/nXND9ipvjqrgt1t4hXvpM
DVml+0VDilQtIxH8pUSXRmne2DjU+D71AAWSQy6/1RklwZhH4nCWqh6SX3/t
PmlAgo82P1xkvg0Dh++hZHuCH7w3r/e/MjAHR4zV8njtiuEQdxSbDV8AcBqd
+BnWRYPieSXlggZLYAt9/p+8/Etg4Uxq7dqggTbny/8u5XzD+pM9FnaCLMBy
fGbiA50ng1deKrwt6kPeI+ST97ICwMZctjaQMg+jLod4Do8Rsfp7UQFFPRGO
4Mfn+2+QoXG9fG3CkYQxx981e6cnQHuwDmkkj86HLqJj3Udr8bX1u4pnJp/h
15MmOV8fGkzzWm/2uk+AQ8d/b7Ji/oQP3lc9S8ui97va/jN5JlQoMWH4zfOE
Pu9MzEQWi2mYfmPHWl9MQcNxx1w9+AKqgiYZDGoESK/49ikkg4SXKgxPcNyJ
hixlJ+Gf3iRwYDsUThlJwad79u2Ub3FB76K07Q/pc8Q6oXH/SzIBmNpmdQ+d
yUWu4QM3W9UpcF0rPt6Dfl/+BIhdvuBWgrduup8QEyFBbNhvIWO/ETp/Wdz/
czUf5ezldzc6zsHPOwy1K7Ml0KBtsnqiPgpH3ds+5dDz4f6LIWmW8+dRO2aX
dsmmTzgSm2e5sU4DhvYT1cXyORiRMny+a3scHm1qMnWcooHbOqsAR2Ufvu4I
y4l/m433ziSVUDrnoSBQKzgsm4hfmB+XBZ/+hodih137zclwgWctBfVJuGW3
xoWIi1HI+TOwYAt93apecF8gvRbNXavc9qRbwbmpqMsBnjRwuXzHKhYIYCiy
lMXI7QUJp4LHvOso4E6Iq0gxpcI1vj9rFvJWsPkmi8PGi2n4VdHA5WhPQel0
57Jy3Vh4rb/wLdWXAGkyh3ZxtpIwl//LWIXmN7DsKOr+q0WCmJ0lS/9JlSLr
MfeuQcV7oD2mt1mijc7J7v4cd62nISRE3i8+phIzmdcqzjFRQTVZc3u9OQkm
Dvh0OHA2Y2QIy6nSZiKcb1Momr06Bh/WKvScM5vQe0T39TmDWTgdVJw58LcS
Wn89ZL4iV44KapLnpqxo0N0dvt9wwAAL21io/OVZ+K4slVF5jp5XjLUaD74X
o/v2reIObcV4rt/M5Vw8DYY2p1/uPTaAspyxs6JMdagslojX9s7DpSEtSp02
Ec8bcYreLqtF6hnWApsTZBBfvRp8P4iIXWzj/h01xej6YHhRSY8MRTtuZrN+
qEQRj5iDwGyPr3c83HiZTQOO9Nqz2ncIELBl4CftUDy4X975zT2NAvcq5SMM
Naiw7R+/ectQMFyxvbDzj980RHL6HP+wg4KyzaeXw76lgtPTy6tlGwTgUghg
7iOSUHny0qKwcyFEyFxdDqTfwwMSmdt/5DZgT2Rpbr7fVziysV94Vp8G8W/F
qPoXJqE0zDJH/0w9EhbqHlTdmIG/JrfOvHlFBJ5xxZvbkrpR0XOLEP7/exAV
O8eeJY+DsQrDyH6GPjxRkCOX4kWFLBwVMRJpAMJRZs3q/A6U6FmUVFVdgMNq
LP31CqdwaSP6tqFZA1LOp9fam9CAS+ryDqOqKjycfqKt62MLnhIvNCnrW4D/
fGjs7WxDqHk+ZsE/tgsJwXeqdubNwu4x3fwneQQkOocJ5Jl0Yp9ve/KWJhKI
5l6Y9WcjoGCE+EWKUy1a0rKW1nUoUGcfeDVZMht95zpVRGOd8c3OX94bMzQg
/La78ozeR0LnVR7Nq2fDb/5CHWETClTyLzzL3kaFdBlVllNmCTBItWmy7J0G
wenFRy02ZJQ/feZwP2s2dF6I30aJpPuuEVn+EIWET+1uZyuGVgCrQop47C8i
FE0lPX//pgsfjrfvi2DOhm3iGRUSHxdAdosZadOHYXhvdMXvzKFGnHxbzsl6
fA6MxiTUz1ZPg3F0b/PJ2AHk6evV8vpJhOTvf1ljrMZh6rPAxvX/xnD2sLBQ
zgsyJAg3KLXEt4LYpZjhuMsj2HkmPj+7dBZKWLPuBVLtYX/h6gdN2QH8xfJ3
aSJ8HiYKFXX+06hHDauOhr5fA1gsdM04cGoO0sfZbjewDqPx874e7cUhpDR/
YPHKpMLT5uB+VsdptH25MyFLvh+T9onXf/5IAsUHzGWRvpPo2+wV26bUjD35
Ig5ro1RoEiu6celiMJhlasR+ineEOaM2hldrNPhbaZ1fPEyAN77qsdp5xfC3
t6fIhZ0CIem+l/2zKdCRreptc/UbrF8a/T0uT4DkrpZ8u2gSTl2cXGc/kQ/r
XQOM7Fb03rpf9u1pJQlrwn/clDxfCyvNjOfWR4gg7MTRGnBvAMfn5ghbCiug
JZl9Rl9tHjJKXfSlcjthe+dZ981Ctbjao8P6in4PN5aCzTolJkHrFq0kxGsY
z4re0mCj+5Ku0lgjXBmFxW+DnVJ7pnDH9HMCC/0co/s5tU8FtsOJobuiXaLT
yHJjeNVWjwL5r65ey9zhD19H5wjhKlO46PrZgXBhBg4/ecD2hNiAZ2eCJV5M
TKJAuok3cysVRm1UIh9JDuHkgWVp74OTaOHA6NIZS6bPEUNEueskaoTTNjp8
h7FfXNc7dYkEjEMlub5rw8ilTPPzX2/BPHPREKvBWUg2TRhQ8K2EV+tzk6cF
kiBjjvPtI7ov7FG8P3VPgAhKDD1FrUuVUMC85xJnNBk2zj4PHfyPAkJpg19P
WeeBj2tt/6luAtTebyAw2hCR74fEld+yxfBCh5KS4EAGPtlx1WkdEkrmrb9v
F2yCVvPzf47RiNA1MBfHwzSK/RcS4Ty1EY48GH56pH4WrjVKF0/tzAeZUuer
l/mzsa/YVGS6hQYXzsn+p7s0BCKLi/kjw0P4NnE6/FIxFUIUU090mQ1Cr4rS
073e0/iAuZNyZZYIt16J3P0Y2QoJlM3GGztIqCUrSkr4TgQdEdOVgn/BEHJK
M5RBk4R/ytgZV6ZIwH/sipSNaD3yRSt+SP5ARLNpsG6kkeD7oRqlHXr9yDAd
6/Kf6TQukhr9c4JIcF8livfz2VEsVoh6Rzw0iu1DrL2zVhTQF9evmrLpQjMS
ifj3aQOyBKzeK2NegNblJfG9sh3wZHjv32OHSkHNfw+xo2IBrlMs3zYcJ8KC
1bk5w9U64GZ77pekRAaO6hHN8kdkENV3P66YXwzBp2o8T9H9fHY853XYj2m0
Sx8x114sAwu2zVJK5f9/L3H3puxEIjKMjkqKH2yHNiXzQu/zJHAhTMeNz4+j
uTVvm+p4JxwRuLKf6+IMeH1uxoPMJajf+5KWRsoFZr36PWX5NPg1UK+kWNoB
R5Vtd+0W6MFebpXHz07NA07t47jP0wMvvhYd2Zc+hdf8xBxdl8kwmiKnoCve
CBI1b8Heh4TNiaKEvnYi0BrOPRqIDoUX4Q0fxgPJGLnLYso4jAh+jx0l70E1
crnYHhtLIOHH2EO/CneQYHzLYg75ZxcavL/t8NNjGjnSWIHZhQz8h9kVbBV7
cYfo8/9qFYZwxoAspSI2C2th3d/FLpRiRozYk1NyBShptX07LZUGVXte7ZFM
6APO6J+5RiYNMK8xdHSSPr8S+wYy9jHRz//ij+ZA7RbQaRf7b3grGQ4yu/i+
vEWCH8ejls78QFDu8/+2LYAEbPdaRV/+nsTzZFTxdqmA3JUtF16KzkBqRYmm
0jsCNkr1Pb3G3QUCGiYvPvaSQMnB2Lb37QT2Hn11mKu8DxoH1zatLlHAcu3J
2s2dHZjkt93eTrcD+jh+bGEYp3sBkX+AsvoNPD8fs7oslodfp6o/dXTSIG9N
b4zZtxEKDftlWKPoedLRIi97aA7yM07S/qxWAd/jAHuvwmncfbcvfhEpMJcZ
uPN9Twgsr/rT2gOIWBcsrLcUTgaKjpeGwtcSZBxeAS43AibfebjkdJ0CH3OV
9aT7G/HGoe2Or/Un8IXcndthBTPw+itDgatWHY5b+t7/2NeB61LTkY3aCxD+
a1RHcEs2+F09JqbMlA0vW7oOXuyngbf3ziRG7mE4IrmJqZLcCZdZX2Q/C5yF
P4WP8s+9ovOzTcbG3n8dMBC9tVJzFxlIN2VOGs0Q4AizT4S0bRWM73hWvK2O
nleCP76sLY7h2/vq6+9tK0FDfND0XsosNL61UIkfmEIz6bu7Om/3wAcNpj8R
9WSoKQAbab4JVNn36ZLn5WGIiSZfYt9OAazoufV1tQeTuRKmDG4Pgfy/P0op
Z2bBpje2RfRtCb7w4RXp+9UMoSFxW0rZ6Xy77UmB7Is0uGpd/sPocxHGd8/2
XqVzcvTxrPMzm/Ngu4u+RoFEH2ZGxN/JJc3DiPI1lgObg8GUNT19xnMEK9l8
vsxHz4HvrtPS5rdT0PRTnoVD6BAGjqgXNXPPw9txTW9pzTwM1+OMUJ7pwBLe
hIZduABaF1RlL59/gQtLeYzPSK+Q71TUh06679iGFITuO9gM0id1VjCkA3Ct
WzT20ALccH8QHc4xCkO3F8ONPPuh8uC/Jd2/VEgMecqu8v//Bb43Dluu7YZe
e+4fEWZkYFKrmZblnQYhif2E8LwaoFKSvFrF6JzHS9Rq4hnEM51+61+DK6H/
+tkBKTpnPjx9h13YdQJL6/YZO/D2QU77D2L2TiqYB/iv/YoZRfE/n2ZYBMZB
dNcHl5ICMsD+/yLD//ZijaxC5GXGSUhbywlYqaeATXfr3Jf0RjwTm/OmgncM
hGM9ioNcZuF20j5nYUIWapczyKve7Qayn82bvWYLcDxdv2EHmANn11Gjxyt0
L/xuxHib7oMHliTWhg0+wdVzds3pj9/jZ6L6xCu6p5yru6tckOoMSlKHWr8+
eI7ltY0BMfR9a4tvnLg7FQXhWSuOpd/KICSSL1i2hgbmvEnBpjYVkL6l2WwH
pQvCFI7WMtD7uku6OVniZheIM7hEiYUOw3w44zNOvVn4FMcgsCdrBPzkkPw8
egTeOgz5xlVTwKVL6/7Jnkn6Pcrx/36vDx5aJBjfEKRAUeM2Jc+cCTC5vkQw
eVgHq8GBUjb0ORL+ZL3+8HMXvobtRx39KiBWei7+8L0Feg5Fp74jD6GbpIxR
UVEfBB/c/fNo4Qx4rNN4YlwHsa7C19tyagJA8aAnkYECb97EnM8804MrfOmp
XrHT0P2XWld1mAxq5z7L6tOacUnW9EopPwGicqLUByhkOPFTJGBlDbHU80Bb
UeoUmFb80OhIp8K/8q3xSreTcSL1wY2B/yZg+3exkfHPsxBSxbOgk2IERs12
m35zjYBqiGTe6eo5SHYpmBhJSoCm6ESeT1eH4VvNj/1/KXOwvn79o0hQETzz
H+zzPTkGQ27WkwuscxDebBI32lYPQVF/eaoFJ8G050KI3aMZOCB+391sowvO
c6scNydPws2plDh9+n5uybIa1FAdgi/BLUnxjyagzHCXxZAIBfj4uoilwuNw
20x81ezWALSov4lnE6dzThmDaW/sMDzt5pG/vKMekq/1Rlgoz8HAoNwz4ysN
aHpktTnZuRTMlcPm7p6lgb/QQDnTh25c7f7aSQ3tBapnEh/Ffg7u6/0nsfi9
G8/OH3c4fGoSnlma6DrRufxWH1pVxHQgX3DXOssKAeTvaYUYfiNBPqffsFlQ
A76fW/Z4kU3371R36wO59J5e210d24+oEiv+MlOADNnDpkNudUSwX5Hr6ynJ
RLZylVO3KknQG+1Rom5C77V9Dzie275Ga+tS84KjJPh3R057g48MnsNS8x/F
kyF30a9duo0IlRIbbvy69L4Xa2qwZy6FbW5FBiblRAjaN/pxy1m6X7ed5n8o
UQ9ZpKyAfHcifNglUbXvFwkWuuN9Aic7wM7jqOju5wR4vm2QxeoAGQxHWQ9f
Fe+DVf2r7wipkyDZaMqRf5kCWwlhItSzg8CVoXNF+PAgMLETgkW+zICs8xdD
FZ5eyHUNGh0zroObrJu/pGbNQ0AhVemTVDEOmuwWKnmbB+LHPIzXCmhwgjW9
UjKkHhkvRsTuZuuCxOxjCWn7F6C60EqGENeE3f2x33VDxkHmS5xg9eZZsF0W
bthoqcckDdrIQw8CfG3iD+1uJ4NVSv6pq85V6Ay5YCRJhuY/kr5Rn4jwUsx6
/Ls8PZer41rO2FNAQlSoaUyTAMxXdzTGb0pFt08PXhZuUOBsyUmORPI03Yun
v24cd8Cd8R+Uv3FSoe3VukTAzDTI5DokcjLFwZ7Hg0L7WikQkAm6hRIEUPr8
YuBhSz4ctxxN8FOgQL3y27DUZAK4vmo6GO9cBdw6f5TT5cjgdMWn5IwzEVIW
LkoIyzVBfljg8icVItwVbA19+pcEDukeX04WdsDVplUBP5wEPs8m00FlKvgG
de9UluyCtTmi3dFtA2Dz94B7u/QcVLLSNkU+b4EG+fceZ1lqgPAjoqeteQF6
eGzTJs/EoZ9LNq1JLRk09rP/DqbRoFap8DJndi5mPb0dZhNVD86NR2UX79Hg
K+OikGVRMfZ6a5wS0umH7oeDx9xD58H7WPfOuZxivEiW2aU4PAHmolieuD4D
Ge3NBsn2+djOvtfk9WsClPBwR/58QYHlEqGvnSrfsDJaQKg9jgQa32bYqW4k
2L7tNd+iQwzye/e+dOsgA3VTIt/IPSKIWvc9/Fpki4H9tX4uVyhAcxyIHO0j
wOKP4NLQ/SHQY2QQdvMkPb+E458vzxJANVpTvGchHf6LkFIK8CPD94lVvVf0
810zrBbleVwIbv4fJdRkSdAVy5sq10GCXybpXETuSnBbr1tQ6J8GMs+TPZNl
FGAo/V4Yw1YLroXdn0TrxkFQO2fQTWkW2Dpz1fYm1oKzorKC5c0e8LZQzH8+
PA99HuJebOMITEf9z46UI8w1VV72dKLBq5f/SJNhHriv4r36kmAoTN9MsS9f
pcHYPYeYHV1huLR6+7+BslIQ3+qP3xtocPypWnxrQxzyODywzLRpB3KW2Y7n
awtgSZgLenMiEc0nDwz92xiAFLmU65vM5sH9s4KKoVU89udfSnhuNAEMIuyf
fC1noat1ZCdzeRRqTTKGMwtPw4tjbD5vY+j3VFDT6NSbz8hl4bmQXEGAgUco
EfSAAizRuU0yZVY45vLr5ro1Eb5cDqqIKSaDxqs77GFx7qBrfZ2jw5AIZnuk
rO81kyHgh416tEwEtEnJNGxzJ8CSXPeHbHcKPOCPWGaISgLFyLbHbJVT0M9q
0r06SYV6C+6D2qnfoPN6yMG4hnE4zV10TDN7FgT1Gp9tGOUAy7LI+ua8fqgr
ldk9FTkPF2VuaR2IzAYW0cNHq9lbIGxm9V3bARoY3LyonbA9BZZkH3xqyM2F
O81ERfshGsQJslw/UJiAh/aY6Lx69RXrhZ5Z/ftFg0u6dQJhiaFYMyr0fa+I
I2aIrdSu0vd/60Kb1cljuTjOa2mX6JuL11Scdq8102CESyNu+U4Jfrw/bnjA
qga1nKyFVZ7Q4Pb8Q4KZSAVmhM0xD17rwEFORt7/f6fpy62oawMGlbiliuua
XHwfero3r9eFzYPR08s6vk6VeK3okKVf8AiK+STtzLw6B+N6ryvVCyqQ4uhy
I3x6ArsN+B7qDs/AM65bTaMR5WjL0TcexTKNVacLK5wsqFAiUdLwnLsEK22v
ueQUErD18/JPiUMU2KQ18OXyrgJ81St5IpWVhA/qyrkdWMnQcY6yy38pG52p
enLHNpMRTIdcp/aQ4ESOm4T753RUJKaiTxkZlxLXxh0eEcHV/vbsumI8bjzg
O3HhAgVvbnvTQe0lQLIgQ7kNfygeP7u20ySQghUizVO8bwhwozU2IeGdKxqM
r73jraag40naiKYCAbb62dEYWWwgfU/YYf0WCpoPZH9SkiGA5gm/7Sdav0BK
Qsn3gSwKPmG1IufdJcDIspjsQkgsDB6+dOOiBQXNen3cNsIJ8PbNK6U946nw
PuIixwdmClZxvAls2UqEZ95qBVM7s0F8we7R68dkVB3/4padR4Rz1XM87jL5
4PieynDAg4Qq7bwd2j4kqHfsSBuVLgYZ+YiFGU0ifnD+e2AllN5TtVc6Jqfo
3PYlZ+xMyzTWR5bmeY9QQHzj29y4RQV0jBQMpjRO4jZJx7KfyjN0b//OlfOo
EjQ/eB7x8htDjzDbI3l1s6DRlhL/zbISDj1Xuvc8cQDDhgSrh+jeanb9FeW5
XgW0dRy9ekuiCwssl5eljRcgZ4xDV257KXz5o+Pu8Lkemzd1dTtdpAHF+Lp5
J3seNG/7MPh9TxGGMjVtpJTSgK2DJSHSIQkkx1O03/fH4LLQDifeHzRwPXlM
/vNaMPSJRy0mqbxHJla5w3xrNPjhcslKQqcKlR2GGIsGE5DfslGCMZYGsvF9
z/cy5mGnrHrm3GFPLNtHfVI1TQOBEMIHph/tSKhq8SqIrMDXwYZ4NG8BVL7d
yv76qAeVZeKzfou2o67s0g2xG/MgekBL5/adPjRzFJ8L5O/Hzi/1C6bpsyCv
E5UucK0PbSTlDUmlo3joaxjvRS66390Yp/7504N57zJWR90n8bDe6eTJaApU
dMqPBhG7cIP1dXiS6zR2P9e35Pckg0nkx9xfjh3IlGYhso1CwOKXFCalehJY
SrpdKeBowYD875oSXUTkFeziGLtNgidMhueGJOrxTvZ0ebEOCS+WUHmqDpLA
5PTOTA6fKrT+vfZZP5aEe1af+XQcIMGLfwePxBmU4uQfsx3mRSTcKqvHkwck
iK9TYtGTyUUZYdrnF7kk/CFuH3DXmASPbn8pm+BMRqpa1oXGBBJOu5Ye9PlA
gsvmIpu1vD7jgIO+fn8ECZUrzqbyRpGAUb3N6/h+ZwjBI4GZcSQc4hROFQkj
wfzrfxu6W2LBW0R63q+QhHYRbZwuTiToSctzI0tngcaYxim2bhJa4MOiC7fo
62FMYtiiT+deAbHXUSQSbptxCWvbR4LpF7Evf3JWQsX0v9RrUyQsuXxgWfk3
EdwPZjw+kVEL85uyOS7mkDCD9tC/8P/vCfzbdveETxN8+1a1oaRIQgEd09zK
DSIUvnZ5uP1jO2QN3fo540zERhY+luJ7JPhGy/vxTK4Lehj2nCNqEHB0cjN3
xioJWhl49K9a98Cv4AJSh88U1mkmOQ6vkEHww/iz04J9YC399TxFeAIHx368
zL9NBU7OC58Wo/rAIq8NdZYGscH8g0z18gxc8eKd2HW9F2ojeER8nLrwVsDa
fuPCOch9MHh37V0nnLFjfiAUWouiV50Fc9UWgKlm9p/spTqQW9d2exqXha80
ttsYP6cBhzmlPb6jGFwP5rc/uBuEgn1iXc0dNFgurJT1Ve/EozXdfrt5UpEt
gDTPVr0AtHqhlRK9GpS9WHKE3/Ej0rx/7vH9QoPfNB7dwWMj6NTLp1V+qwrD
M/y7/XTmwKlpgFoROYE5OhFe6s3tyBkcmO8uOgMC2W/EF3gmkTwbepfI24eX
Y/Ok8gop8NFj4eey+AQ6OfXUzKwM4e8C8jk/fgoIknJf1zGNorCaKvfqnTE8
XJw+kHeYAgM9JU3EqgE064E5q6VxlFWzDZduowCTj/Pnvew9SLs9ILFUNI6z
p/0lr85R4fBry1EhrTb8N+xaOew9iiyc6h9BcxY+rzttddteizKDF9Zy3Adx
gUdTZnB0DkJT7z3Q4SvGx194yLsO9eDyYZXNHicWwNM2U8OuOBW33fI1POnU
grAheJzpEA0CvmZeEvAIxt/nwxtEoivxsPUFho+ZNHB+79dWa+qKIrtjCjdH
Z6O91rIjlUrPk9B9ylvRGnevvr5s9SoG8YiZnucKDR7f2vlxcpcN7p9Kzt1y
PQqHzY8Wpf2jwcKme5VXvr/Aem/nIDHtTMz2sHj/4TsNuCR9xsMGHUFk15gY
rxgii3VSf1MVDV4ruf0xIUXDXNpjSZ1HTWirH8q+VZXu15se5Fg55YJXCwju
VezGXBMNjgv0XD3ndW09am8V+LynDfmuDqCk1+olGcF52JnyRrRSvxk0upOp
sU9HMT4i4+MA3UPvRk3k7w/rgirhtZBTbBN4QDTyaeCOGbAcWH3dYdEP9ZmU
I4GPJ1DcvSiaeYgCsSbHih2nh8HzmGrd27xxHGwvOZzBSQGv+5UCHV/GYcsJ
y1x/4gg6Rpz0OddIBt5b/0YDGSahLsrL6ObbAaRa6HFUS1FgLO+piDHdV0sX
hwS+R3fh0XKNgnR9KmRJfV3bg2PQt6G7fXNJPWpI1kTqms+CzMWtQqlhvTAV
w5JRYZyHPVWvd6gyLMAztuTTmxpaoDrW2vX5UASKrbZyGB+lwX6d8Iw/rINo
1a6cWSuZggyRstdbn8xDHAwUewu245H9DS8URj7i+FSpyiN2+rwEhF3JnZ7C
0LZHsh8eVaDC9NVPE05UCGrn/tdPJOCVyCKPmrQmzIqTm9VUI8PJuT4DfTsC
tudbM1HzOvGN1Chr8wIJhrpeBZq4TuFFu+QE7rQevJIhsPb5DxmUNl3w/fp2
DD+ovn+1pN+LIucLR+RYZ4CV1uaPbr14moGHrFLWhdl2R+wL4+YgkaDPZNtb
i+ceSEgp1dTjyoR2/O0/C7C29vWr0IQLSrsN2vWbfkHJsxMa3+h9N1Wy9yLZ
txSe8D0oaCLXQMOVhvDDujRIkM+TnTpbB/3XQppvXOwF9xkNVe7UeVi8PK4y
f7ceyg5tcKXiKJxllfXAolkgXcnU2p1VDfUv1GLOT01CIFc7oybfDCjk3PBK
flwMp/KE8sXapmFUpWEFZ+g+ezAo7tVSHJjkXDEOaidArbmuxU9FCn0971j3
/wnBSudfN3k2EcGPNJpI20eBv4r2H76s5uNm3UPGQSZ0D0x2nB1+S4GUzic4
n1CF2lMhumHfp0DtW6DyWV0qXP8WT+N0r8e7pkGJx0z+R9d5R2P9/gE/JKWE
7FLJKsnMCnlHQ1RGJSRlh0oREspemdkke+8947L33nve07pJgyLP/T3P76/n
nOev+5zPuf/5XNd7vF7nvu73NQ+l7lKPEkaWAdZORTPrtiOdzNe6N8UnQDCY
6uWbtlW41ChOqzHUiC47VLwySemBz6SY980t6+CtPi7QypqGZpYCTrFZpkK4
dLiYz3dyXgcpmMQeq4MTgh56p3QakaJ1E42UDdlHTq2VbIUNgnnehGa83wDS
zbHM3X20BlIcJ8yFL02Dnnrf2XsOI2j6dfiZrfRlaL73isuzZAHe9x/90Vk6
grrK3Yz0yB6Ro00i2LFiQHE4MoPabAithD61Cdwk+50GR1IMJxacQlNCH031
Is1iXsJCKw64aQ695hbEwCu/PcXk2WaUkvPp501VAkieNHiSyzMH489kS6JS
SxGtvvzh56MrsLvRkFJdOgo+dBNSc7KJ6K+UxHoJbg3sw0Nyvp+dQ18/ntC3
yk1DqYeO5kesrQCL950qQathZJz5SM805hP6wrCVmXl/HRS+3794mAqHIugP
mu4bVyF+rsEyRUo8mLe+OFCkikejKZG3AiebkNYBfeHeZ1hg8Zu6JE2JQ0I7
BtHKrh3I/cXHMvtHOHAZHZ7ce7eIfi1KhXjUdyHmseS5YTEiMPtJUUVIj6NY
uVfv/xxpQwUm1H58x9fgzkspJpH0KkQjTMPT+q4AZZfOpki1keBFZu7G7Xut
0P/57XpyaB002f6hPK9MgsrWIi7XuFF4epE9kVl1CKoZGQIYtVfB7F9gj+vO
JFjkzcvJBU+D/BVmxH2dCJe/aV1N0pwEkUKKuMj0BQhOOxizIYOHSw4/H0Vm
j8J8Ef+vyb0lOFycJ9l+AwfWEuFs6o8GQKvvfWuOKxbskm9kOB8ne3HMtslX
tVa4q7bySeYZDvAn1RySRXHw/aVB+VmTYjh7Xm1DrAsHjZ1BL33I/JD2fGCj
pi0RwW7znAQBB76Vc/nDmjjATiex+X1tQOxM6Se4q3BAx7SlVM+Og5WI6Oq5
xF4UJ3GBkpnMN10Hk6y1BrCg/rvOskZgBOVf++bXSPb5mt63HwPasPD4EY+3
WcoEEl1QczX7vghfTfMLFA1wEJdCk9GSN4VmqAU4MJTzkF4oERRxgAAa05N3
mT5NoPwPj0P1yF657ekeKTi2DOI26pw/M/vRUhyxpfByB9Q9WnxmAOtAOCxS
H8cui0Zr01ezTzwB7e86Dbv7JNhZsGSf5B6CMMoPRxwvNiHmm9YfzS6sQ9D+
9Y/FU/PgdLvglsynLiTlqyoKGsvwzdj+kuUlLNR+uNzAb9aFJnByKQX/cFAt
QKNgI0rmXLdvdUeaW5FYJ5vS9D0s3LRQi3l+CA8504mG1w/Wo+s/UixxU1gI
2VDQyj28BIF9x9UjtgsRbrfhzQTZ308uclqE4GfgRvOhHYexOGT1HfeSVnkV
HhT9Jf7JXEBUhr8ZA7Xi0XOvJGGJnGXwah9iCr44jpSDZWTkZ9xR2pGZB4JJ
a5Ai0UpqHMEjWrUXMtl0RWjsVchamQIWCJPZimqeBOQ6s/ps42Q14iu6rPz3
HgY+ntYw5TPCoacRLLnn79Sjxkd8Cr1kjkX+Nq6CZfPoszk9c1YfQrK7q//E
DqyAyVX+lkK1dqQVW6UkRJeP9GLZJvyfkICUn/w7yqgT/CfS/bImi+GP+w/z
h1dIkJ+7zHp0aBbeMHzOfEfu25nvxW4eFV+B7mbvo9f2FiHnxDNtiaRhaOOj
TV6IwcMvNh99Hl5yHIsVWQhWTMBzWkMGOnJ8snw+/T5faAEIFYeSbaVmYGNU
QLq4FAcmomyFv5KmIF22KjRlcham6Fukz5iSOW2r3pcvZAiStB6pn42ahTzF
d3Hzustg17QhEqjTBr9+M7BpiM+Aqvn1q+fmVmDV0+t+2M9iiKLfNy/fnALr
lIyMycJVYNj49rp+KgYtLbvNNPRMQevNheDsvlVgLL2rc2W8HikpLGA+fJ8G
3Zt570RlV0EgktOa/lk/Si/98UojZRbCDxLOKs8vA5M9V7/F93GUuLgezxY4
B7wBIecoMAR4nuL777byPPKNmT98OH0WYm7YN53E4kAsuHtkemwRqWh88Cnr
mgIXDkmG3T4s4Cey2GXjlhAHoVWRXnMMBDmehNq+IfdrrIqqbsICYtlV1IXL
A/DkS5R4vQoRTFsW1DhyR9Am9en1kJkGyHvf4VHbugbxSZ8T7j/MhHYVa461
B65oaspXyfkXCbJF2VaHHKcg8+PlU+zPalDPjLCvSfEqGH0xuHT7FwZC8tZy
iSv1SHQ3/p5wLx76Qk6/peciQOzrRd7w+lrkn/p68WgRBiZwqO1MOAFCGwRK
7YLLEImv7vJlDQysT6zPH5TBQnHJtZbg7Qz04QXNxaMEPNRe7wji+LwAVY1D
mc9bIhBzjZjg0dplqJ3lYw1dXEQE25ye+OPBiOK62WmeYSIQb9M9IbyeRNdk
hzNIrDZod0U16D7vGiQUG7MOtxNQ7xdB916TJHRc0Y/NUgoDOlK2A/EsROQy
o1Qg8CUbMREL+kK7l4DY8xw7qIRD2thttYt6hWg6eJY6hrz+xruOxwg0M4jD
qPftm9RcxDqecueB/Sqw6pgKXs39hNR18yO1+d4hMVWXtEvkevLg8JaEKHYS
2OV/2BZTlIBzvQjhy8YqbHzzf01XiIEn6MyqwY1G8NZWe+b3Fw9+TNczqcnx
e+lIG1V4Xjucm5MRJRRigW7hVdeRbCxEXktQfWrYA+vXlv48J9fDt1yVIlYX
FkGEc19D0asPFj56nKziJcLLT0FXNFInQI7vi1lOdA+kdMys9T1dBWWaF3bi
73qAR/Wy7N0z7dC8oc/JFbgOj+gdMAXqNRCzI9gs97cBhqUV/D+5kIBwYf0e
29dkMFrB5uaV1ACXTd6ht50kOP6nntFh0xVdT+hpWMFUwQURtVOlIyRQaYyd
fV1ZiF5/m0z+exDBHZ8PzgeLSfCr4tqzyNYWdOSvKWT/boZZ09byG+wkeC/Z
tjKnN4LqfQ9c8b3fBeKvugXrDddgaifh1rDTPHL4+wdPe6cPcl8rcE6oLEPy
b1O/330Y9LnyeqvI0T4wdSrM2T6Mh+qfZ5Ret+IQMte62ObVBT8eH6fTNsNC
uCj7hZKTOATabrFtrK1wffVirbYDDlb/riWGaCygi1x9i7ctaiF4pW85PnMZ
Dnl4HK7abEE5Hx7X4+uT4dVnpihuNxJ8JBbJM/4dggdr3rrsFMnIITL6ioTh
OnDdVj71UIS8j0x1FMPnCtHkyTWGEkSAF4FyzXtvCeDdIeVHZZqPnngpKKYG
YkBuq/1n9iMiuCUwjdFmpaOjWtjQox+X4BnHCR3T5zgIP4A/s38lFiUdc/X2
HMFBrkVv6aMLS8A7bx9a0+SHosL0hVYTiSCmFGfq83AJXd0J5vhhxI7u3de0
cCDz/C1jQdRybgrhu+5dPTyiAs+EPZhf/V2FsK4C19EzRFS2tnjkUuNTNEAV
GfJtcAmOUcpnPlQmoucFF4wv/HqDeO/fOkeIX4IR/mdBMpdw6L517Vd1PUck
MXv9u/MJPBQyVRnHUE8hs7dXzZyVXZFuq6lXJcUaiPtcUT78rwAYzTiIwo/t
ETXbZu4siQSSv1PZaanmIY8+odlQwhQ+9Ek9KipdgbsFvHeIb3Gg3fIx+beB
F0jzJ7zX68aBAe/aiMwqHiKfoqFr0p+hReCoKQdgIcp7fGBWDwclvOx9euuR
IBuY+qhwgcwtufOnyrAL0D5AJTgbFwslGanSMR7LwFBuZuNQPAqpKw9UBd7E
AMcVzoJhwhqcEnEMi1FrgYayvvgmtjAQuVc8pBRAgl61DuaerRxYGTtszDXi
Db2bfj03t0jwStXVn03FG7C5GZGjz+whNd7F34Sc1zzi966NEC3I8ck7Jowx
gbP+goXr5Oc5SV10IyPx6KWkSsf4XxOo9L3EqrRLguRKBlvBz99Qif4fdbZa
e2jdK3tU1k0CadkXlBsuA0hEfJjZWMIHYls0Da+3rcMiF8+q4sYsagtSP5kc
EwppohcfZ1Osgs++2+d32xh0UanDnp0pCrSTpcIoBQiwx7hhqJOFR3G5Mm6K
WVGQ8hFrueWDBVYLx39x7/FIQfCTgWBpBHBqehLsv2GhV08kssdiCfnVXr7r
QxMKKdjwO0VWRHjtZ7THQeYlxvsYbIOsD2A+OuvzYdeBjXPiq/1yH/C11j3C
Kj+FIMUVQ4W9dZCvmcqxT1sCw4KnlatUb1H019fRUkpE0EdNRomuBAj6EXSs
WfQ9MhQ+pz8YjoFzw++9roQTwYpQUJjsY4+0T/xjOS+7BL37fjT+fThwpAtS
5L37Bqk+ZPonbY2Du8eamMWHlkDQ6dFEW5QFstLWtLI+QwR2XX23zzRLSJdi
6wN/ahCEqiqy/KwkQq4I7wS33CQqThNrCjnlAE8zNAoviq7BD0O3WUsSAV3v
H89iWYiH7eLLjVqHMeD1adk/W5yIjmWcOrejkw6ZQlGXpnLJnPEgfyNDB4f0
WC5H1bBlg9EDdZWBcRz0ZhbYpf6cRr9e8546czEVjgQrvpB3X4Wtl6/5I/ff
QvXHyzYmOW5I6PjM92hyPFwV4MVarE4DK+2zPY8zJWhXzIf1mM0qaCTI8y3b
YcFjQeJul2A9uhdNQTVvjAcbK5PnzDfxkME6Mdq50YxqXCsoNLSwoOTGZnyW
Ewdym3RCkrfa0e0XoVnoPg5seeSMGZ8uwpmY2FIx2Q50gYln6Bd5Hw8QYyYC
OCbgg3bUuUnfViTLyf3EErMKKX5O+sPZndBPfTwzl6EB/RPz07ClIMGA3M7r
ZaMyCKHnxEToV6CGWprxYw0ksL8rRxt4KgIuTIYHH/hViHr1xWIUV8nfr7nU
4U4VgIKKKnd/qBUi65zTKVHrJEgYil/8kZiPmIfLqOdtytDceyf+98MkqHpx
Utm8tQkVRC3JRGkhVC5WVHrnGQn+KJwfdKEYRj+Xfvs80GpBUl/PWTatrsEb
KRoTrR9zSGdEgddoo/2/+4Mk6Q+uwFHmG3y3yjDoTHx93WZXOxpTMMVaReNB
h+6O/asdHCrarCv82diCfhG/FNXEYCFsj++7nTMOZU0riL4SbECKQi/YDz/B
QXqN6benmwvIYijhxbnj5cjsh3SU/ONleN/X6n1epxN1ixiOWXBFoVYe+0tO
aiSISmQ7bIEfgKLyVX6lnESoIsnfMy1dBx9R5/mVkSXgiHsasfM8G6Jvtt+x
Pk4EKuWMS1csCSBtaPBJqDYDSji5q/4kYaBURk190IQIiasxLiyriTBpwdfy
2noJMvscaLV8cHA+lvXdk/OhMGUb7vq3AgeMJRRPHVOW4KPBCo5r2BH+Ybkd
08jepxbw9Ww3aQGV04aVXmaNB7tFl7lxp2V4PFsPq41jyNN84fFfWS8YpPjZ
/a9sDTIok98uXCQgygzKPSHaQjhaXvsFO48BNvmTeKsWArpPRXB4/70CGmT1
TM4cwUC8myRmJAyHqHUWG15BLaCowGkrQxxk9FMzdlTOo/HCP2kW12rAf2Fh
cIFxBbqqmNZanVuQSkGe9OkfyZD6++J9Om8S6OIPH/pW3Q/hkgyZ22EVCKfm
/e6/c0qOrvZe3y8swK/uDwc5G7oQ/wCd8seTy/B3dzFT+y4GDl2nmqIcGkJW
SyW95tlk7zslWHBJAAPboqrmHDLjaDDlUsW1Eix8afS+7kBagLC++8pl5L4X
oPD6HkszDtxOod6vd6bhQ8dtyhHWaeTnYlDNd5gI5lJH/OX4h0AwgBVfR5pE
Oay/hi8/XwG9mCtd/YItwJPMIUFIHEfjcGsXkf39bFPwS5tvebAjHXVNv3oU
yUTc5VKYWgMfuvnCbZtEJPD5hNea2iiK4jpkWrGzBow8t9rd1epRKyvBZctn
DP11ejX11HENGt1US3xV+9C8bwTd8dwJ9MlOcxILq/DF6o94sMY4upeD2VJ4
PIXCbGfuO1xbhq0nuvde3JpHnCGOp9SUp9CwpNnB9xt44L12pdFWZgn9LaRk
oTs5gdx+oUPP7+BgYbZg9bMaBjXYcNHSKo6gJVuzsOmHZF8Yc9uUyV9Et6l+
vapf6EMe3sdoA6oJkNfN/2b58AQaQHU3p6wa0EHuplNXuchx8npKtrE7Eh1Z
ZBQ/7fEGGfMMHsfvkeAN3jNHynMclKb35/4erYAbN+ImWF6sQZqTgGuSFwZo
L+V0FSfWgmxoZEjqTQJo/1RSbTxNAL4XiSWU21Vw0zPo3fF2sicEtdO7VxGg
/ZpPHX9YMVzhFOLwFMaAVGM48ZoHFiQevLF+cCoVrm6/hsOZeDBpNs9oD1sE
lnNBIZ16IUCfTNrFHVuGN8R3A/jZObRAaI+J9k2DKi43UlrFCgRdMnCumhxC
vA8ztfE//MHU70sBzYt1YKrBnK2KwCG39GqXaoNKMPC+93bIHgeCRlGVzA14
VHpVzy+7qRFeheueO7KKAeWIiFNpz3BIsdfHxGWoDWSuXTi3yIqDpnL8v9D0
RUTHmyZ0+XkHaJxYrL0gTYRA1dfTs+/H0NOZtSiJwiYoMZITYHmyBnynqWq2
fLLRNtWTFyEc0cDN83Cy8jsJiqpjFS/Q9kNOquG71q5mFP5gIorp0zp05TPf
kpKYgjbvXAofwxGkX6T/OmJlGQKv2Gzahs6CndhrTYOCGTRvh1k7NY+Hd+/k
p2PZZqBR9mlQXf8CSmIz+9QMOCgUeP5vpmEcFB988WYYX0KtuknTh8ewIMe9
U/oUDcJfm7RdT0Ysihm/LjkggoOCKIebA6NtZL47Vb2cikXLO+yc9T042G1g
ian1KIGG5I+3uHqwiOatyDe6u3jA0t/3uUBIRF5cWWmlDVgk/HrlxCVrPOxR
MgYUMjainEw2iiNhWEQrR8RniOPha12Ir0N8H/ryGyqIZ7AocsVB/m8JDiJu
8pcnM40iM64gkvd5DHrsyhp37iYOnh0ICCnhnkKDZgdko+wWkcH2a75QbRzo
1XxvbV2dQeIM6eeWW+YQvbzDpOlzPDQLnZ9X6plGV6XteuK8xtHy/Dn2vT4i
LFx5FRB6bwQF/Xz6vcKuB2V6IZar19fApXpcxWS6HP389/OhZmMmuine9y+N
7C8/VQzEnxC6YUbG4OhQQQ0Mtogeo/67Drlm8y0mPnOwcJLz6SNyPAjO/Ere
vrwC1v45/QXrGKjE/hbOTWsHJoPqnyzmeBByWx8laeKBr9HZcD2xGUo2pse5
7mJhXOu8yRMdPFB1/i2io64F3WHrj08isCC68AU5RC9BMvcFJZeofDBwSCMu
XiECz6csMxv/ecj1v7Th9icacgY9+W8ZrsCGRfLNweEJ9LC04fAAbTbYYgpP
uMutgdM50k8j1IO2d+cDSN+DQH/udc+3MyRgH14dV2pYQi2zRvJfNhAMcTUZ
HZ0iQHa+Ri9vARZFvHrsLJ3fASymfIzYFByE2joorvFgkV2C3AWp5X442fTv
Bb0zDkaMfKpE9hcRI8/RMe2AIVj7ybz3exAPxZTHOW60zaLXskVZrl1DEBZt
11NDrmO6tDP1GR+GkUHavNKbu/0wt7R08fTlNfigakmn6oFQzNgltdrfCErf
Mj9jJnuW3t/WxPyQQkiPLkwoMy9E7Zw2GlszJOgqLk4Gp3aQG5/21WzvR5bv
rY+431iHr2IDUgXMfeD+01pIy2AK0V+HAa/pFfAfTy6PvdELd589JBUHLKAd
Qku6XzYRvM3eTjUOtsOJxEDbRG4MctpTk41jIfNzzcHH1q31cCVDJTOsHIsc
zkY5HjyHh7Ma7N4oNw+omihp7T/gkJajcYloITk+M1nv1YmGoaeLwUMfwnGI
2+dcTiG5T51LGqwfPlyJTLMEvFcP4NAHmyUadlo8TG8oj/WUN6Ph14oCNoUY
lNu+r3JnCg8vPZ8cXHvVhbilS4lUTouIdcv4zA1JIsTwFIioOvWiTvW9u44P
ZlGw9gEhgXMrsFD+eTjkXRcqaWBWyT89gn7HfX82ZLkGktY+lT+2EDrBpuqs
xteErqel2xw1JsHKyrila2oiWPBxXfCST4OPL7m443+QINhNfu7xWDeAuLBf
hUYHpDJigwV81oHYNPqvbnMCKuHX4pXbgzDbY9VS0LEC+k4c3GPPFmAziO2y
WOQQjDcrSFw7RIT8B/M3rOUxYE4yjr82PwCvrljO8p/FA89UTOoBP7J/3H4U
4lzcDcuSaql3gnDA/O/AZ+VBDEDalEJZWBP8uPq3RKKHvM6hrGb6n+bBObC3
Ki+uBOx0b59Mub0C3QtSmKPfJ+ESlk7t6aUEsO5rT9OnXINHTh7xM7sDqLE8
unsNR+aur5TK/7LWoaFDJ5SHuglt0lr3nJcKBOu734WlUkmg4/7K4bzeLDqY
eLjsqkwjmFMyT/ztXoH4mfQWypEFZPRizCtJvQ/CThfk3SXzme0hjWNCAovI
onr/hFDACBzrizG5epQA1NURt0Y5FxB90OeH5/km4dW/lXuuOXhI8Fxi+mA7
i55Pfc3YPDsDMmxLU//F1e0rx+VOxU0gPnPMmrrcLPQdsXZ/dY4IWa9RgRrj
MFrLYj2OF56BpEQdOdWMZXiYk3u31agbJb2oTOyvmgCWs18OVb1ahUEDibzY
gw3IyOSqyFPsEIxKpz/9dHodbntSBzV+yUNO0UrJBmXtYGKZavPf+b1ZfsaX
KSL2iMFljH7EsQgOKJ6sbyRzeynvAAXHoUiY0Pf1FPuUhuQ6hjomfpGge1mk
evnBF+Bwusy+G4IQTsDmrn8dCU5PyqQlTnyGRzN28CCuBTn2eWjz+JHglh0H
B+txA9CsZvxyIqcViQXvB7h8JEEd49Z+QqkPYpz+6xZ7qAmlb3xstCav/9LS
m3vZv4KQjZSml/p4GTrYzyUvvED23y8e9LfpNBFzuqxj/Ck3sC81Lioje9PX
n5UHhaOT4duEVneSI4L9JKd8o28ksLptfUGcsQowDUw71+j6APdxfah0cR10
xraPpA+1wjtq5oG3V0fB9TQL/U27NUi15+G5zzcAjHkui0U7k3AnynBOrGoF
aK7M356YGoW0csGVVyoz4EF7wM72+DIIHLA6p8s2DYmRowIsCjNQ+sM8Z6uB
ACv5fdUPZeZB+kpSct/ZKVB/oTIqTU2Ar08DSgOKFuDJ2R/bUVfHwAzXXee6
j4dxK4VarmOLsH5T47b/8gB8ueAvqTpNgEKM2NNjYeR63uW5ZXCjDfIYIsAJ
LcPhKpEltffj8NUugZ2/oAx+Ee6edrFeg+Wy1ItRLEPAUh1kQeuVCCFZye5j
3uuwcKbyOfZOE9o9WuwbG5cOWk4fQlRjScDlod4f01GMyMw8bxTtDVMqHjPm
RBKYH4xsZqMdRM/oPouEbdZDuOUbnXzzdbBJ452QuDGGMoyzjllh+mBGIszZ
sWoVaJN8nPOfTaCckwUn3zuNQYJ2zw5+bRmsHvg75PJOoG/zibXXtmfAfEWj
0/4BEcR9eEU/25H5Z/4Oqdt1AVqX/1RHk+P/h0jRh9gDI0ihS+1HtzrZk56s
35JSxEPFeS97G8lBVK1Lcr7mjgHt0nQe134cDBicOfUjuxdFFOkoC0hgIe54
djxdGbnv6Ou5jB7tQK7hCUakj1igDCjO+DGNA4UvHg5ulU2oKLFK4qgjFsZO
tkrfl8BDl4Vb8+fQWrSWt4H1u4oFsy3Z5eQ0PIg7qVQkBZeiBxGjU/1LGKia
CnuZepIAC5jDttsVmYiGREyf98WAa6ZlhuFHAoj5Kp+T5QlDVVtB7J9uYYDB
X0yLgAhgX3Eu3e+bB0T4qB4ZIvMrM2+V29dhcpxUGPdgfVKAe7XQ+rQyBhJe
7X4KI/OuRVv0P06HImDxHM229cbAiUWfAz/fEqAup7JheqIKZrm3j42NYYA9
6YJSEgMB7pxnNpb2aYC6o/ZLD89i4TB3VXVFMh6G1usCWwJawd4s9bYDYMHU
vfLJAfJ63j5Np0q70QUGD3hN3Dix8PMJaGxS4sElzmr3fEc/jMZ7scfFYaBm
7zrW4h8OTthkal7+OgSv92WXL6QvwZipRrHdLTxonrlw8+m1UbDPFHvrf2YR
DjxeFORdxsNNIe72JJ1xsONpOjcxMQe/LU+9id8kQNTCBHP2owm45nU8dpN2
EnZs7rSVaS+D1o+nt9/bj0NK8ZR8FeUQaJ1ZPix2YBX2i3O/yq0Mg9VFCbPa
A21AF+jn1l64BmtKq07EoG6QSzRcvNFbAqZsXLc12Elw4SMvmglrgVd5t46J
n/kKjiaqW2Y+JPgtGTxCn5SJcjv1jimmxIJgsU5p7RYJGuotH1z8GIFkFujb
xbkdIHJ8JJruHwmkZC8KV1ytQosJAhS44jJQuXf0il01CT6d+qbdP9+AtDSx
/BTPW0FUm1ZmV4QEX763SOpatqCKmI6EwVODYMakktYisw55wXW7zQxt6E3H
iaFungkoOPna3XFqFZiv0d10O9aGfqjnuHV/nIP3uQNB5xVXQLst6Ah3H7lu
Ym1ts4wWgfX8HP+xeCIwDJ4XmulpQnT+D3+Z22LAr/wVF/spAnTp/+l8btyA
aH0yjuRQ44BjQu6fZS8OztzbDA6LqEULqx8ujgjjYasvpwpXh4WDdwcoGu9U
IspN4fHZQwT4+/tIdMAyBhSwCtYvjpagl3KaDRqJZM7rvHPT+Q4G+FqNwxeb
ctD0kcXEv2QffgDXtn5MLkH+aEQWe1ISKp35+SdYlQgNlhRnV0OXoJ9RhUIm
IAiFJItpqr4gwg3FX6vjVkvgN1RbMnTbBm6Oxb99Y0WE3cbNZraXS/DccbS7
1SYaGE5LhIY9JEKpFsNT1k9krg21bre8ng7qt/tyY08R4e87EVrdziU48iVc
W1G+EPRtFUti6ggQHX74to4oBtbfXjjJ8aYMbmzmlThIEsABfbp2vgEDmYYJ
+98qquH+Bb35d7Z4WG6XYULuWMjz8kjQ20PAFd5t2/ACBzR3n8tlO+JAJbEF
f8i3EX7bLGd+psFCiNF3hkxyv5YsP/Sjq7MZtA6YCXKKL8H1OaVTy4xEuF7s
kGf3sRWq3KfucUzMQ4ucuod0/DI4ud7eLlFog9j73Lqjm1PAZaZ5kUt8FYbi
Ir6KfmkFvaHTiRd0R8DvaYMQSzI5nq8dFpG/2gzND25/H17uBn/JBHmjxnWo
SMujPMBSD7GzMnlVN+ph/GekwWlnEtAtMNjeGCmFgimv3qVP2ZCmkTLXOkEC
vHO8uDFtISg8UJi8HhMGJoYEMFsngdOn9p9/vNNRtSRvuX5DLGpyWn9z4ycJ
yv43R3fi/5mju5Gl4S4tUoP+TbzRf8/WjFYf9DsGvCBBq5xSgzVrPfJv4ovK
Zu1HzxLuU/SUrQPjgLNa/JMGZC+pLX/7+SgSuDbj35+5BvG6CskcLg3o4fzD
T8KPp9GrNZmkF49XoYbb7N+Jb/Wo6cqNRp62eXRrYJ2Gktwv6IWmCon5dajP
1eZG+eoiErCxve/qSQSbcpEwLv4adM780ppZCgYJnc6/91eaAAXBHCFnxCvQ
4JIVv9BPLOqV/zZTyY6H+49Oq3Ayl6Av99K0WH7hUOzO5oMzAji4QXVXTac/
Dx1wkQ/tLMIji9shMxKvsNDvZ4LKPNPQjWdD16VkCMjuQCYfxRwGvBtcii+H
x6IS0XdaGsEExJT2pVPGBQMflLa+JHl4Iqh+9kW8noD4OhgMu8j1m2JURCT/
oAM8K2IN0+0ioJ+FshPhshiQbYgelleLhFCrY9P4EgJ6n/SCVfchBgrV/LOE
dVNgpa3oja4dAWGebFw0jMFAKI9ppH1iDgTqoN97xwiIPU9FIuEIFsIH93dY
totAeD3qjfsbPFKn69pVysHCsaF/lRc4y+FQ+dwdwUgcchbLbWlwwUHxuMug
F2c1+Icr29i+xKLnUb8qgvzxwJ4TurTcVQtbxa7CbxaXUNj1OifpLgJsOxr6
HrCoh2r2Yut/SwtozUd60UxqGd6YdDtR6TdA8PQHhhe9s2gk/uHrg+UrcPrS
I+8S2wawsBcrZiCOI07KT6fG+ddA7TgrvLWsB3rS/Bn5N4PICCfltKe/DqOf
ApToLn+Dk7x2qX7H2lH7BbVxXTkSZCpnU1NeLoOxe1+rYqer0P4sg0xfFZnD
IwktXrOZ8Gp3xYQwlYI8ISb1wgYJLK4bnm4NiIHnv8pGTu74oJOKU8+Wdkkg
+7MXf7G2AZmKF1SOcqah8w+59JezSKCZQxQ+vT+E5LKsZY986kF/x3v+1jqv
Qcb/5utK/W++7v78/52vy/8m8swp5VEUWN9wWRY3jcSf6kqyqi5DG3PHhPXx
EWQQz/BnRnAB2WgrS8TNkOPw6I6sEP0QsvYcmW2/soSMEpuElWvxYDz7DutT
0o/oTr6aYyvAoK69t+K1mzgILrjVp+DYjajkA4j2GVg0vxsX5mtH3q8vEicP
J7YhLgWBF+YKODIHFay2y/13/uWtn/tuI0oriF5YD8ChmJw7od2XcUBd175o
L1+L7GrPR/dn4dBGLfdj+Ts4KPAdIeUfLUNmrdp+v8jPX+yJ9hJf40B4p05g
JS2bLNCd44aJOLQrJxjL+xkHirvq3kIFUShWbLjf5AsOFW4r7tYm4yATg7ff
rLWD4zeuLjCn4lCkk3DEXhwOIu6Vv3/mlAR8R1hOPanGoUYcVe4OOd7szfTK
aV4WQkXgfceNMRyi5w64mKaBA+1u9XWvkEoIcnLvZSDhkEeA5L3Gk2R+a6Li
mU2oB+ETIpQZ5OdlTuZ5vqtYUHNOVHeBFqAye+443IpDOr/u/j0/hoWGzu2e
YM5OGPtbF69giEM8pRwrTStYYIkcuHv+bB9Uq+rzNWRiUfpJXTRDXjcf3MND
XkcGwZsua+KHBwZhMm1WC8bIHDhJ/Xbp7jC4pCjuew0vIr8S7s2wbjwocXra
N1ONQn9PVTG98zyS2I0U5D5LhH3PX6wqGaPQ/TOmUGdoEjn7c/fxNSzDUU7u
L1puI6DaeT+O33YI+atxOw56r8IUo9BXRBgAg1dZ5yct2xCBJpkYe2EdFOJ8
vx981gZZgqKaRm9KkaLP/bBCPTKfKMT61Kh9g39PevX3FOOQnjojIaGTBGfp
CdpSV/vRqIaAjlFoBnIq+uayurwO7IKs1nLi8yj41kyGhXAPqqKP6Vv/ugxf
XccSdm7OozjjM8fNiBPoXUryDTHN//983c0i7u503QlUGl3KEvpyDi1TlbwS
I3Ppo4bDLslFw+gSejfWZDuHStf3Yq7PE0HE5ra1cHkfKmsgpCf7zKB1p7H9
b0orIKWSUjpq3ooYvJ5QfaifQOojiUcEGlZB+sgHemuPb0i/tHRU2G8YLQY4
/9xlX4dI/k89C8cLESXrmu/5iB7k6nljJYmRBILpNPticQmoJMG9PTeqEb3f
hieX0kjgLyB5i9M8GBl0c8CthFLENL5wzgJDghfrybc+mXqhfb5entOXUhFX
Tu05sR3y98M36i5ivZBTqO1HaZUkdKsi2mP6DwnulDqfUuxzQzfNPDzFsvNQ
7IWp2LVNEujpsPNyVhnDqY/UKUz4WrSzw3Yc10YCj+wv7kEzccAyK2QsbtSB
DohtwF9dErgqe2NVLYrB1sAloa9zED29GY0pdl0Hv/WuxR+EejgYLYQXDR9H
73/UxP2+ugaXUqoCk5g6oWz/UNk/kRmkrG1mgq1cgS8MexptpAGYSVItvU09
j+4vmc04Sy7D3bgy2bH2UXCXD+V67j6PxJU6EqfWCcDFy9l5T2UK/v2OfPud
dR5FlRdGEukJIOT+Qmvp5BxsXTsfdjNlBsU9CT2QX4GH4PcVVLfm5uF37lDP
ovME+uoBd1YOEgA7I4S7fWkB3ttT+H/BDKFtOl6kfZII94uGa9Od56DK7eN7
J49OZMbwrkOUfgUExG6YM4uNgWrfQpiqYzUKCazrZ0hdg4CHzw0HTvaBaoF6
C84mFflJtr8spSJBu0KWhyRpFDWDCkfnmzR0j+V4B4yvAaFZ64KPIQb5KH6e
uj/ahhLJJdRnAw8y5gqedouLaO+meuX4tyF0P0x4vmsOD4KFEUfEro4ho5pj
Tft/BpGZUhgn9voqpPxvjm7Y/+boHvnfHN2JxoQ81+Np6AfXoGH43Wy0m37t
twKZf3zNCvg5csogN/6EVAFHPZy1fOJ0L4kEMaEVdew0zfDEFvNOcn4QwhjO
ZG4IkLmL5u9IjUErhFw/WiiZNAXL3Yfa+TRXoZVl+rfYYBPILTKxeLCR148F
12AZvQyM15OOX2T5BvJlA6qSikvgzKFexqBJhJqWt64ae1lwQF8ILXphoK7Y
ri3UhQB7CiIXZq8Eohza3FqXLQyoyH9I/C1MgGMqDHpX1UtR/aMztnGxGEg+
fOCx0GNyXy7tGW+Ob0AnRj/dum9M5k/iPPfaf/Pe+58b3OVpQ0I0XZsWFxbg
L+dMkp3RMgSoTeO2f7aj5CvEg+l3p8Dz7gMSG3ndRiQ5IpP6m5FvRdlPosUA
PKhvHAvUXQe55j3H01CEooyeNAVPlkLqeuIqxyAJKs36vGo6ygBjvCzvfOIb
KgnutCsqJIHQ8c4Ks4B+OG54oNP+Rj+apbcNCxxcA4Mz7OzPbSbBLu58difz
COIdvFVbenEFMh7TaN89sgCLso4rJKpRNGsPzy/WE6DFy2z3I9knxV+0OJZL
D6PizDQPGj48xP4cj1z4jQHdWR21ha/9aD1VoOZGCQ4Otcd+f0jmL0pa7tW4
qjYkp186NTCOB7GzTJWMrfMwwqqv99qrGnUqvpEIObYCOem8XErN4xA+aXw7
aSkdMfAbH5l1WAPGYPzmJ+ppVOnckpEUl4guP14WvVa/CusOclt+5L5lVmJQ
O6zegGKsks9f2sPCCSrNN23mS0ihWa/PoKITMUqUGyUGEOCEVmnWPelWdDln
RfD3ZAUicdR2Ozwjwd03GbuBAkOgK9N9J1uxDwp9PCVmPNYgmv0PwZp3Evzd
9VsFX82DL8ZJDstPALtZApPk2zHwvB948BvHEuxRh26Jk/sU559k3fKiQdg0
+BSHMBioTrHzmPrv92im4saNzA7InUt7f2EfC4f2N9NDHuEgd+r+jbKaKlDS
mWf/7/9Figa6V9Qtyf4urlHgx2WJKvIufWRcwoGJd3ziI30cHGk4d+hWUw0K
Kh7n757GgTuvJu+nMzjQ+2x12Ja7C92v/jOJfYODPeJ2UHMbFk5yJxQX5w8h
xe/YMy9tsRB60um28hcsXL/qv02RNI58mQSs++uWgHOMpvn0bywcLuj/SPww
hXJfGB2O4FuAB+sMl+KU8NA/oUwd920SUdlntX0em4Qnb632X3USYZuGQ95l
YQhFURdpUAb1w4unx35M3ViDE9fWNZxIJWguXnkrTqAQXFg6f1ePksAZY1n5
wq0bInmOBt/k+IYw7AdOu+yvA92qG/Vh2VlY4Eil+zXSgSIdRb0ItiuwetYH
H8OFgf7fPCW43S500yPGNZBcZxzCX8liS3Gg227U9DuyHb1VaD0QU4SFl4MK
OApBPByhd/k48q4RPWGiWBuPwILckSPVEqYYuNfd+nHHoBx5fdT40UTOa6BR
FD6qPA8JYnxw5Uoaemzb8K7XcwUmFlZsafTmEGvky8tbthEoYeNr7POlFWiq
vpwpIklA1z2N9qi4y5FW2/DNz3UYEFdlD9MpXEQHCs6ppEwjFH/UPpIjhwgP
QX19ergI1KhumNx9HAlffTVd+JZJsDkrOarqtwDGjX1CWfEDwDBIYRx9iwhq
7KRDQpULUDjHYy/hPQU0LWccJQdwMOKWP/VPZRRC/AI9TijPgqVE4MIbLBGC
xc138Sd7IGqaKUlJfwbsLZ8G2zuvgOTcxfOy/2phLvb48m+RacDVN/J3OK3C
0iHWEElsCLz9d+5t2vAUzBx1//jfuVY6pR4Op5RyxEkzL1tQNg2fsmwow+xW
4U/ubKbQQie6hssYlbOahdrszm6TRyvw+cyYwHe2UcRYdv4PW9MciFpT7Pt/
IJI/Twq8vTyLvg8+r9HymoP3X/S++prhIXmAZUubcxF5EX6buKvNwMG/Q08E
NrBA9Z2UY+29hCjmdrNtX07ANwr5G4EkLIw194XxJCyiB5cZ+Smoh4Ev6dnh
T9QEuML7aDTLeApl/+nI2DLugDu0J5ZMpFfBp9fY8ubFSiTwUKT8pV0OxNp+
EA/vI0Hou0itgtgh2D7g904ZilFwCJWypsE69Fi0PLWuWwRGJsLMFeZ6FMSA
19BKIELzNfy+EjceosBZqHgJISH3nx8UERac78X5cTsT4CJ9ypyEbBWKOPUy
ROkJBsT8GflDosi8HyH/alWuECnnce0/DsXBINdfYYaDS8Bd5tNYF5OI8gcE
1LQqiFB8XCHQ12MecV1O2H6+5458I6OOOpuvgMPVdb3rKwTkf+qG5nWy12pu
Xz2Fo8EA7aFocV3CAorCr1Tq0hSgsKt9j/7YLAOzDZ4/v7oX3rIY3LsklwjX
L8ecFjlGgm4PDpkrVVigtrompHm2BVafFokBluzR2AtHmP2WoLq/7XuecC+c
cHJLZRUnv88htUx6kyF4v7ve2VvWCYM+HuEfGtZAA/OY1r6gGE7WhR+tmSFr
8zp/8vVsEnygku48lR8K1Jp0Io111aDDFzPZPUACqTPwbFA8CelW7w2oXP8G
p21CXt3sIMH56FGXueQ6xCGwZJ4g1giTOXcatK1JwM3O3zg62Y8eG0irbBq2
g8/3e5JS19chRU37+m+TaSS6Zdn8drYH2BPv3TcsXAF2d/mPjyWWkOJmi9SX
b33QtV5/eE+L7HG5HWbP2HFIpkXH8l51D2wT7Sz3yX5hYTfWd9kXhxBR2lxL
tgO0brR+0B/Gwtq7RUeBjCU0ofXZXO5fI6TEf75S0kOA+7Xb1UpLI8j82KFD
V2ZLASnfpD/4cw1YfnNfbmX+Bok6uhRzl83hoqhGl08vCQIGMo4eUZwHvv28
wUvpWYhjgaU+klw3eH7EpAd24aDzxiuQXypA/TscWvlPcSCI0NLOASIIG9za
4afPQTG/DYEStwRMGjEHjFvxsM0kPtbjlIx0dt6eP2+MBcljvxYLMjBAMi1O
XNILR9jFUof+/+7rk+BeswiaR4zG431bfY+BmXh5U8NoBRhsXu84iBORsOD6
9PsiDcQ465vRUrUEE1ccacaZFtGTnOa0jDfu6IBjvKfQ82XwDDzqmxQ8CJoH
ZYJOHvJBhS2nHxsmrENHrs7CtggerlALWPNTusEPOl4raTocePa3RKaJYGDH
tFbXLTIajuYd8zQZIMCUp6c4b1k/3F4LySt8GQ8lWxHqIvPrED3wSMOIIwkc
LlLe9HX2A9ZLwVldZJ73llE4unk7BPU6vWc+cUsUPRC7WvnrHwkSRldvlP8o
QvUb7pPKcQZoX+FhQe8KCUT3u6kdktvRE83ebryEHLTM6G9MmJFg5CENkf/J
OOoquWty4ZobtFNUKZyIWoM2xzcnDukson/kJDp9PwyCvWWYvkotw1ZNucyQ
AQ6JneZPkboYC39O+yfuTOFgtDBZRCUCjz67LoQ+CvsCjCUDig1xWAgpxPR6
+WGRrCplXkVoLPz40yzPm4EHWlFTHVXNaYQb29FIMIoGTW5KK0zBKtwbxDh4
/HFBr1cE0K5uCDx1oSosJb8Xd9EK2lSZhr5fn1NTJ4xgVPzFiZulq3C11sqL
XxoHrlQfXpyffodyKMZ/UhzGQ/2dwBib40QYVXw8KH7RBYUGmjgx45cg5Pn3
vPBrBDAVfv9kQ9MZqdGMyjLPY+AftQe7jSEWuq47tZn8sEVPuph2fvTiQUtW
OtUtdg4tSNtcisF6w7+plI3vg2Sue8nqcISFiFpow2XyvVPgnGqZX+DIEvSW
qsiN3FlC/ac/j3S9yoCQOdNFVWciOc59KL/e6wRPzlP3fzhlIn4WfVyUMgno
DGOc1A1xEK+fkWdG14RkIt23ZslxjnlQy1VehgEL4VciU8IdyGHY0dHlMx7m
9G8FafINg+waTTXdQBPaX8YSrX6T9+sd16e9mSyQevXiysHiErTCmM0rO0MC
ypddCXpSqSgvLt9ika0EOb8jprQtkiDnTjv/g6JuxFq6ciItvxH137k34Dyy
DsYVdGGeRyfQVE8kb4JIG6LJKt2VnFsFSbfslperC2iTm6flcX07umryTnq9
lQjZ5cy6D8LJ+6ts7Vq634p6YnXOSq7ggNo2x887E4fG+T23FNmakMFBgrI4
Kw4k2845Yj5gUNYJvupVzRrkl066sfuIAOonfcQ+WE2ikeFbS4enspABMfDn
NY41mG/5t2IS8xTxJSUJmQq4Q3kAxULWPgn6GC4+VHebAnH5Pyr3k9JB9Kts
INX0KpknVUS+TJLrNqPyOdv9TBjjUnAvuY+HFy3FVl79BKDfcrInDqTAKR33
wuqLGBB1DDqIvUSAc7+uP+vpi4Z1FondD2QvcRdk7vypjoVb+pNfD0n6QMHp
P750s3gIOVF13/P1NIpIxsT/lQgDwxPpG6ZZq8CrOuH+25aA6HAPmk2iS4BC
q47q8wcM7DsvGc7WY9CjrXdcaoy18E9Tqq6bhQBvvQpphzeD0Azl1Y/n20PQ
wLo98dceCc6IvksXiV0EN5tHtxky+tEzeZ8/X3MIkLHknVvvT+47A14HT1dP
oCNTN9jOkutwfb85A73GBNyQSfGgE59GWjbTl7c7iNBz/q6WDyuCghTaTPUz
4+h4UpeRv9EaFLueo3bNL0bviDI1f5NH0cOfPaGcY2tQde+EYFDpIFJZ4uAL
3ppAmkkLbNIVK9D/7aFVmtAC6rTQa/jFMYmiWLQIz5PxUIOgv9t6CXEmtbB3
qY4hPBsDzXwkDrJ+g+LQf/Mfe4w3m6YH0fhN55vMnniQeztYU2Iwj9jVh5Ue
FnUge4lZ4Z3qZag9l6bH1k72nIIVFif6MrRw8rtrRPM60Kbui15jqgOvukyh
rxRJkD6kL1LZSPbZV/cmKJ/MwnvCNO5DRBVkf21VPbS3Ao70cvYT7VhQPyOl
nUeoAcn4bMceITxccnnURFAmAKuG5eNrWeVAq0HS0E3HgEwewwPZADKf3KdJ
r83Pg9d77+JSI7FQyfjH4uNbsq+qBui0jXyFyWUdNf5oAiRr+hXejxtD0Ttu
Ohsno+FOJpVMRc0aTEzOZwUfwaO0R/VTx/lrQT7c/2wZAQvrllrnH9lhEe6t
YXpWfTtkO9K7nCDnRZjhiKCw0SDKDQ/V9o2uA6l/QhlvLdah/EUAb8rPIXDO
NXvFn9ONeFKtK5kD1uB51fJ2VdAs3FKNnr24O4e0DzDxiHDh4cBWxcCPq2Mg
PusJquYYZM80GZT8DQsaKlSOWVNNZJ4XP7bfj0Wxl+0C6+bJ+XjI++xv90IU
PsXi056FRZJitdoC9mTfvGNo++a/c/Va9UMv8jCI1vEsDW8PDlba+ghDqVOo
VP5LbqbTAvra9uuj5y8cnBZIU62+O4n4UuzUv0qMoPPb5kqZQitwp8e6/haZ
Q0oeyFfp3W5FRhlLI/z662Rv/W3qLfsGfb/66IOElCWSOTjRgyHnr+z6/Rqx
/UGgTprTVXKuh6/c7y49UCZzy7vRthCBBRj7XsT8sbkN7vrqhSGdZShtqf1Q
H4yFBeXZ83ocbXDTX0MMt4aDr2xpV9E1cr0/+YfW36IRvOvOHhJ1+W9OzyT2
hxSOzHfctfevVIIeo5Ou1AgOTt6Zjd/LX4RTVmHPxx9lwk7J8I4qiQjGZsd8
omwGUKZ59JMmnhhYEjQ8z9O2DgFXOydsHmCQM2vFzo9vjSCqjMU63CDA0PJz
f25yXtv3RJd/7RiAgxJOm6V5OEBPxX6HL08ju4/vLYzeDoHVTMUCxdgyNDCH
FdGlliHK7Q9CWQHlgDlv++6/eJYqUruo2t8JkyE3u0Oih9Dl8+kvTSvWgDPx
y5BTeQ/Qya/EXiH34S7/lWLgI0I7v+gOhVAdFN0XogvdxiKexovjXD9xkFn8
GjFWJ6Lkh+/3OC1waInquIoD2Xc+be71B2S1oOod+2Y2OgxSeSJSfUiHADVD
Cvmz53uQ6lcqDpOD04jO9wyGdmQF/DzyJjkNKtAgvdPzALVvKPHBz78Pc0jw
i0f94730fhjRHDVVOtUFwud5tXX5yPsr3HlaMWcKVvUWtrdUBiENL3WI8+kK
sI1qJTFtLEB2b+OMytYgoNazEW8RAUIepHEN2WEg7+AHzerBfmhYmHkvdRYP
wibvY1vvYkHs6NSPpNOdcIHRVaJwGwe+DshFaXgJjM6Y9a1s1gMdlND4NRDg
/Jln+9zZc/AMs9c96lQIY9qxUd41K0CSrvv2Oa8FScVI6lm2RoCHFZxr9yHB
OWodMWHLOZQhxIlvwjfDu4930vPIvHftcbmNLP0isgn3ICZEjsKouhGf2wIe
9ETvNlD0zCBX+jTfhpgZmJmfOjzOSwDFBwNOicpDyMDS2fsL/QwEaoYdwg+T
PWJJu8OdH6E2dUo1NvkhwFFlqb28uf7f/UHXoy30IdlEznE5LBdC3l1Q++9+
yYfxl8oPNsbDtpfU5N/wejQf4Vx4tYIEH08eEzW3egsL+RSDyzda0TdUbbXj
ToKjUdEtxrIeyC53AGVxlyCTAxTOlQQSuKy97ApozIB3n49/j5ZrgLuVv7Du
uSSwu62iUGXZDo8rby0fCR4FKpNl4k3NNfD4Pk9LETkGMtS2P8/8nYYrB11S
Rv8QAbGFUXeYz0NF7EFqA9lJWPvdErHOQwCl1MWmf8ULoCT4dvD0qVEYGYpi
z1cigNtktslg0wJkMlhNBab1g6m6GoakTOatjNcet5rJ+3KqKTcZ1wzG7jVf
S26vQF7IcJhg4hi4Jktny4qWkD0wpy0qdQ2UtlJZQ+xLUVihXbV2byAcpQuL
WcaQoM0ywuV92CB6Jd1oo0rOO+6h+Tk2stcwqas+P/FmAm13p2kaG46DOSOj
eW35Mrk/u/j23xxDtz64Vtl3LgBH/lbj8RU8WGym5L74MYCaMD6mr7MwcJg6
PHq3CgdbZfd3tD+1o147Ot71ECzsXhjJaxvGwfIc8clO0jf0yTS6puk6FpRK
V6azU/HAZCYoNvQzHcUeFGVo9MMAS+yHpscuBGDyNfCkzP8Ez15aVVoJYWDG
WAi0R8j9QulL4rZhMXxbjKOQdMPA3RI2h3w7AqipURpvUDdCmcVlo7cMWOBQ
ue5wJBsPqpFipRm23RDPjRY1/mLgXbG6+yk2PHDh/HojR4egJoH5nsHzJWDM
MGgYscIDCx3vxqLpODxxU0XSjHOAN31/64kQERRMjZ00zoxDgt4nBuzpQWjp
C5GjurIKfldrbc0eDcPtL1eNWHxaIJZ79J/k9BpA1R+jKztdgKFjpki3KoYP
hXF4EV4S6J7hZEsRj0Q19rNBYUJOcJAZS40l84nIicrEGN8qVFwQKl2aXA5B
/nhhfDkJWC2Zu0OdWtDLi7MKHNaDcIhhr+CkIHm/eLhMA/9PV9cdTuX//lFW
SWQmiVJoWMmKbkqlJJWUJCOySmTLykyyI1uopJAR2d72kb33ds5zzrFOJJVR
v/O5fuev77/nj/d1nee53/drXPdzv5hxqNnJIXatdRJ+5Fie2zg6D6ynTjpq
VNYjN/sUDfsIPDzenvpwbTsJfhSIYPesq1BjPKnUCIjgLy7pJ/6Z+n68s1Lk
xwuRHLGELPqRBH5xKT9s1fGw83Nd8kuNdDTzrFsoWpsMu68Q/xhEzEJWDONo
2wln0O/fwBk+IoPCC7Hp+sez8I6c5BSQlgly3fVmEtxkaLlRK3evdxas17PG
llOK4cNT9htPxEgQcsHyVUUX9T34Xojn5qoB9aaK9RN6GOhKOapJR2IQKZTI
vznQAH9sA+74cM4C7pPQ+IGjZDghtNp1TAkHn3kfaydljEKLgcAS8fwCPPXs
zSkTbgC1yntE9vttcLpcP8ivdQmqD4juqysvgp7rTZ7LVP7+8qnOrcQRCgje
y6XfNdyBVOqEfTPmqpE0I5mppmsJ+r1js8dCRlDT0fzHgvI1yF1KNqasfwGq
zl3JYFiZQtYHFH9rtfehE6fT077tIQOFi2iW7jONahJVB4+8q0AN5qJHbaPm
YPAHW0WhLx6VLB4wV3bsQg/PpzpMHCZCmsWYpHvNJOIKnPvrsNyHSgMPFctX
kuFGUCMFk8QjPt2vvSGuRcjg2kyn/BcSmG+vkpLXwZBxYaP04Yc49LvlC9Nj
SQxkO3bJMUaPotoT19+vsDYjnLmo+05YAILuXc/TSWWw4NqnJHyrAF4xmf/a
1kCB4xmjofKFVL5EZ/1Uj/sT4pX8KCPkSgTXx1qyxXuJVAqglPw2uwpNnDn4
fILKe71LuyK/OfWitzLXdVhNilFez723YLQEYgXEnMfhQ8C/+Lw5mKcBekNq
yJtCi8DBV9rbTJyBvXWJRzhtBsG/0JFEYSBCbJ2dirkpVc92jjNpX4tHYqRA
tyWqnhXZ7v+Z352IPBnyP7Ka5KKljMxno9kE2BG73fBw+jfkHE6MmJ5JQ78l
7NrC9Cjw9ampU2jiNCT/XhfU462AnqTERJLvHFyd1B/l2iBAQKLvM7+vLYAz
LlbuvICBuuXny8MME/DPgl6r52YHOEwcrVZSnociWt6QxP/kDc0K278VoeJ6
ZMi2YrYwXVh3GboUPYjBpWtrkmPNRMT78dDSfdYnyKdSgUvTigBK8gZyM4Y4
9Fcm/LagUBgy+Lm69NKZAqOORVU77s+CYryC6LzhFbQap5lx0oUM3qynvpiJ
EkHzTyvR/W4k/MqjP6nBj4HLpd2nuwzG4VArK9PvjVQYxOHW1B4ugAMHnYKb
eSXgrAefKPq9Bh76gINurdTzaTkyErQcGWZajoxPVvZYXAcB6a/KllnFxAND
Vlk7hxURvuq5P77ASUKmDlwHw+qzgD9FpvsSCwE+L9e9es7QjazeODi1PXoJ
fKdt/ROHlqC4uzQsr2MalIMC5sxOVaBMwVsx3kZzMCZDLvfAY2D96hUTmQWH
EhXonYcSCcARVpv7lncKMn1Njm873YwebB72dN+ag+VDQuQTWvXAv81nZ/nZ
SvRBKep5jR0F2LbuLjbeVkD6in8D3nrnIwtp58PrS//lP/5/bog9LTfkNC03
JP/9j61YZzzSlGxLPt+YCTv2TF02iySBxn7/XxNcJPQi5OXnNx7l0B8lZzxP
7ScTB/kMthRH0EA6R/r9lSLo9Nzn8HnPIuzao3rkI2kQLG09KPkC9Wj/YKj8
rNYixPsLWz22x0PE/WtwitCPpIL/1EztwiDpTj7vseYpAD3pQ+l/R9FwlVet
pgkRTsUE99jv6ILn+fHXjniPIJZ6zfJlugVgvPSc9cWLaJATS825Gz+AxoUK
9uygLMJ5HQuXIuEmZP3MlUeAZwjNpkz0pwovwntafoQJLT9igZYf8V22Xjfj
yAzilee0LLXIA+47PpnLF+fgxZZInow9EfUOxjLGf26A5EcPXdclCLB1r2mv
6sYUUuHb9yNPrxkqmt0/OjyeA52LFvqmtRnw4YOHmudWOjrVOpVs/5MCZhN4
mcOtYzC0OcQcEDSEJFai1e51kcHqdx+7hcgY/D3bbdL7dgYROAtL5KYJIDIg
LPuK1AUiPbGnC20IaH0fPQO9EgZx0bxgW5wJfDGCEdsHCCigy2rvrTtEUEyL
ICdgjehnSWCo+U0C8uYbZm5QIILI2WGZ7XqDSFnSiijuOotqvLDllAgMzGj5
Ao20fIFmWr5A8SHRX/xXxxHbUcVcKa1CWOvYuUv67gKwJ8lFmGcSECfvOy3E
3QaPdS9xhXpT7/tvW2C5OYPEch246JZ6QWZe8lrjORIII8qA/9EeZA2zMwXL
7XBbzvj2l9pF4N+5z+LMh1LYTJULZxatRMcX3Y+wZVHAJdRlM7esE86vP4uF
N+Poi2X+Uy6VebAUbT3fF4iDvYbF79nfUusxWq7mSBURbkW3NblezQSTGAfG
h88xFPjhWlzNZ2p/tjRYq9hVgcT+VDxzTyKgQq9uOGJIhP6Lsv2HbVvRzRyp
opORVNyoDVHgGCVDqX72L4dnzWhKffjgQ5ce9Ljw/p37jEsgSNtLz0nbS+9C
20ufuRHoNcrTh/YKCId+nCsAjH06fu0KtT9//xYz+XsaJY0pTlnPd0GGpkVM
Fi8ZfguOfBWZmEKJm9mzpeQRMG/gSHuUToQ5us1PH8eG0L9DcfR+1hMwEVO9
6HKODBelRmM8e1rQ04IG46hrw9DyrdP9acoCONocy3fHZaHTI2Mmgkdw8Pv8
gJs49V4b+jAvb/uVCBHCbrbNop+QR4g/h9sKBQhRMaGxjjEwzH34Xkx0I+ry
jP8n/oICVdjkxLiVN3qrfdrpWUctYoy8F7s/n4rLSsz82qzeoH9/fFE17jWQ
M71lvlF50QXF5ehhgUooTS+Vaj/YBQX4/avHG5ZASCMtyI7SDawXzj3r2xyB
t9+PbzOLn4dw2p7zCNqec0/annN5xqubrG0N6KzvakpXZjYUeu8cZabqlzee
Aud3hw2i7I1jFvnU52YvVZqIC1qAnRfdHr1hG0bdTimjU18nwPGTXfEBYTJI
f0g4da2hDwlQiOm+QbMg/rmpa12YCMycrMpZRzqQzlJrpZ0OAcT/hMq/ysRg
LfCl24pyPRJ07aU3CyTApAo+5YE0ETqGFEfYP3xBuI1pJEXEQ5/IM9MaARLs
XFvh9b8egV5GiHlOXcCD/k7OXWdqSCDE8nZS4+p78OF32SBo4OHm/c6kxTIS
tMs8UQhvL4fouy0z3zvw4LjKJXSUm3pO7XfFst04WK9+xFkqToAHF8+UFGkT
wfLG00tRrN3wQUmdSfQxHpQ2DKt+7SMC6Y5m9g6bAfhz9m7137ZpwP5R6J/s
p94j2j7tfbR92pss/79PW3POZTX3ykc0kNsevrScDMIlXhIl1PfOfJLln+FW
LfrT+lS3nQ4H50K5FX6KUWCXtc3eRR4c8vG5f8nWbRi8RF/8fte8AO0h+4IU
6hoRT52faKr/DLySEtD7GUSGSitD7airtciv6FoA4z7qc8QWokvKMdiqUJjJ
3V+KNOKnUo9xkSDs6oV1xXE8dH8Vma61yEZlsXlXctjJkOB7tOgiVd92uDIv
SewNQyHOxwkfHpIh8S/nPj8qXx2SkUsIPp4AyfOv5zt0yMBTcUyPJXIWWLUc
7L1t8qFA8oADkcrDhqNSjw6p4OHWm/knN2fL4V1pg/GR+0SICbi20BFLgBbJ
md7q+DpQGw4uTJnHQ4ul/LmIeiKoBHlNGfo1wakwjdNfvkyBb5eIbEjxHOw4
y9CU+6IJNs9GJszt6Idu99xofP4iML74/33OMv+zzzmfNk/bTZunPUObp2Wb
OidaMobQs+3bT2RYdqInwhtURbkE3KFecktetUj6Z3Pp/aRRVLzNVP/+iwXQ
3XhkzgQIhf8xWqoOmkHYNme7k21kWM1muJ6pXIrwy4zmshkEJIg98NWl/j9v
7puV+87mI9HlXzlebkRE+H7qK1MWAQzs4gPrnqYhCQ07K5wdCambzFx+moEH
O9VvLBIReiiYYM1kjiOh1IR3l98BHiJX2tWmFFNBvfaYRUwsCcXVcYzau+Bh
bb7N6OvePJCvdahVa6HyULs8TtlrBGDm9eKyDyqBrO3lB4uOYmjjue9FJir/
MGo5f5chrxpet17F3boyi5aQQ4CHChlUMGEHLqtacOTteHnTeRyNs4QHftuz
ABYvG4VYeGvgE2wyVRl1o0DzbUv0L/77TucgqnEtAlyE62QvfykSqTjEfKmW
Au9pc5sytLlNuun/n9sUHdROTTnSj7x/PWJqY5hGBelXz2WvkkBzcduP2O3d
SIQ9XRIC8Ugwd8LMlIUIDxifJbC8akZdyscDJsUwNBegMNGtjkHUdH/4E0+E
gu2XJcKzMGQ1ndgIahgEbkQ7DLzKQwM7knbyUn//eWIokNUfg/R187aPjS5o
3KnAwjgDQ4dcxqzzUjG4cXjtW9OPj0AeTTiDNWPoTcEJVzZrDKR+05/cqK0E
OvMlTZjHUKo6g5zrDgwM3vxZFdLAQXae49WR1xgy0P5Zt4tEgDN1CuwXbLtg
z72ZR9XKBNTwvOheqRcG++ZMgyY6+iCt9AA5R2gGhV9/eDRThQRZfCfW3D0H
QI9+Wdx61zD667Vrh5TCPIQ+eIrr3N8NESXd2+jaG9CiRdqDIPMlWKfNByb/
z3wgkVHa7wtDP+JjQBdknk2iLodVPVtqHU6tvFije49Dsze9hJrujKAA8yMX
noQvQOSt82JE00K0KLm6yLKzCwW4nuuLxy/BWbfTZ+3do9FmMfJkVSxDjMbO
Ol0DFEiU9cQJCfkhe/tXV9/zZaDQNE7RyHUKxGz9Dtg9q44qzir4TbwoQQfP
LoxojVPg6KR3rGn5J9jukZbt9rYTyfUc1Lq4tgScSQ1ZYvKNIIoh1ey3I6jg
aLPoeBIVBy9G9KmTeoHzdY7xI+kppBEzEjBVTYZ77S5iRW/HIOqgjf+S6iRa
/ST/QmudCNXSLK9WWabBmWgwaYkbRCk/D37af5sEJaPRzD4yE+A/cLO3aLkJ
OUq4RymmzcMn2hxaPG0OjYU2h9Z9PPyUXPEX0OXeXYwXrIJf8orh9wspoGnP
FlJyrwncXLnKK+NGgDniS0FE5ALwbc+VJmPV8LdCillpfga2basoDQ0gw2Sz
ybDhV3vweyZ7e4GEhythYyeElUhgqEG/8414NSqMy+3k7pmF4KwYy7ABEqh5
qW3IX2hGZ00SDtvyTIDOyBObz7HzMM5wmyJ1ugrxEiWLs/MawVit2eCkLgUC
dQ4VFh5qhOr2S5p94jikLfFFyYyJyltmkmb1Po9DXWi9/I30fvTtx6jNotwc
SGa//7ZC7a/DLzg+WHzvQYM6XVyXSRj8u6Jx7ShxFnjvsxe0qTWgTk+G1Lsh
JHgfv5yzrWQQGMZfCs/+noE8EZ0IjmkMMtINqwx1WuHUFw0f/TkCBAtI2hZr
UXFDNo8uqjAKVn98PP1tEoMA+pWb9MYYsIeLmB7OxyGBB1+aVsMx2JSKerFK
vRepOx8cy+UYRB5tFS1PLuPhdX+uqxeeADL3nQf2XBpF23WytUhfxsHv2Gpb
wBAJArbEbzDSfUM5Z2qm+QTqIegdQTlnOwUqrhiMXT1DxVOlszn57I2oKXdn
8NGQRdibRfAJdCaA8cLLrU5CC2KKKT7B34BBBGL3WWrDYL7hEUZ/AiEVtTyV
ckEM+L40ijnu7wC4aWy/5T0OeflsXOum81AZbxjAnJkMUWwRif5jo5ArHLph
30rlybztRqkEHLLPSOW7SdXB5TvTzx6m1hW2o6feT2QM3auhu1cbOQnMCZuP
ChlJ4MdDVJeRnkXRXLwiCykjIGYcUcpO5f8q3+MIIoJT6Ii3BJct1gEMnxXD
NUPnQPyU8sEz3DUwlci/Xz0rCfGIJ+TzV1LrMHfCU9KaAOVRQQPTlTVIREvr
vYQ1EXBGwZarZiTI6D0z/4y1GAV00u/aF4qHSiezAZGqGOga8sX4R8rBJb/3
4IFuCtxUV80SDq9AD8d3LXIm1kJYdhLTAT8KGM+2swjzj6DFrEW86+52eGeq
+E5dewGICVciHwUT0Jxx4SHKjQ5gOqWrX/gIg2SxAKOVnQQku3f7SmVVA9Qs
hA/cDiHCxxAjkzr9IuRTbOA7bJAIu9Q6mw1nKWA/r6e5+xse2Ewm5w/ty0du
DloTCkCCD/McEeL/5QtZlDgzyWWiUIb4ktvFs9ClVGx8LDcfKVUIBvUN3EZb
dO73/9s/s7Swq7E2ewA5njcaf5HvB8EXJFSeLCzChjmBzDNGQFeyeKw4GRJg
vIzHyuAuEa45me9dD8KQqMITLT/RePDMeDX+/SsGlncr5V/7N6Jl/bbnQZMh
EJawsas6hAKxrn+6p67igdz3wEhN2QmdfVy+q6WcqovnMxvNqfwmhEvACqm7
Ij5nHtxfu1mYmM/ep3VrCFWQvKw0KE3opecImY11EQr9C01t9Agomi8yiDsA
h3L2ju3z3k+ErD37GmONCKjggUqJjhG1H/SSKiv8ieA2qUx/srwaBR3PJDzg
80fSyeaFNg0U8Nvomx97hIel9B9JckyfYNwwh80mhgShh62LepXIwK2Ltk5q
poHG8WuKGR9nwVS8UjTCahatJZpxm8YPIu+oO9O5IRiw5LunchybRpceVwrq
trUiEeflVgP+OVB/90f2vGwWsE/JpocWhUGGffifDaqerSGU/sSv4CHLLAgf
xlEFz7lyFAzmiGDf/vrRcjAJVHmixAx+FgDb863EDw/xwMsR4Lxa041e5ksO
LVXgUPp5sedBR5fgqrbUXbJUN4jUtwV8nKyG87yczJsxS/BLd00hXooAorm6
5xuYm8HMZlCplqpnw9Sdbh6i8v36Kw2KdHsqISCDOyJogAD5Q51rPqqjwMLz
U+v7pR5g+svkEus+D4RIy6Zbd/Aw7zjOk3OnG8qtON8+PECET5l/e/bF4EHK
tMOhYaEOzAS9oh7sJEHh9hudBYXTECdoukeairc6rysawo+TQFCj/W+5/hSs
X3ULCvJoAtk40Tcri3MwV2YYxpLeB+Zao2RxjSaI4+hSK2laBDtpfSXNB51o
+6i2VuaOGmT7OLFrP5Uf/hKWdxPKGEW2lLLGQ2m1iHWoSMeeqnfCk+7GKm1O
oXaQbfdU6kcR9K7fDv0kwTyoP3wXOoNiq0qOT3hR+aZRmW9DExmOpVXDdR88
Om/7y7OLuxv9ONPPlrWDCEHLbS8l7SaR6K+wekH2frRp0PD5UieZWtcqysNZ
BCT+68x0xqNSlHCX7ch/9W83XMZ+XgRDfsbLrDezm9FhtWt7iy9gwHDLceKX
yghyKXUqW6byghlxtdeMsQsgacTkPmxTBfqdq2uUrS/QzFdtGUrVj4UuxkE8
PkSkxuTJq2uRjzy01LEnaQT4uND2gj4NQwm+HGIBqQhdUEk4Iq2JgRhub+xs
eicqcEwM5FAsRFYSW3RuC0vwRKerT/vLCHyNyU2djmqCvpc2GxHPF+BD3NSK
+8oMiHswSwm1D0Jku3ny2ynqOdVSTy+7kFBEXqDH+Mc0xPC9sSgpEQ8am/M7
hVMwtPcKf9yexjyEl69nx4VhMMOp9iaqqQRVO3BeS6iKQrenOnF3RymwfK1A
re/XDPiUn+INVkTw68mbk+nuZPjg1HhQjYo/T0WvMhHcW8FrXm7P46sYvFDx
prBajMOOua7r91Q7gNueqOxpMQ95NJ/zyP/4nDl3ErcpdZCQc1mOp/xLfWQY
eeWchgIeelet07movHA4QMvGg80N1ZGSVZc/YXDEejN2p2gK8thVjT+w5IuY
4gVUjDYp4PTyAEvqGh5MLytm5PQ5gkXyeofqCRLsIMv5845gkCT+SXqgJxqa
9LIS480xWA/6d1ewbBRaR40WTuSkwNKOv3dKexcgNZbZ2zC+HLjrSt8MCMeC
sXLpq3lq/6+m+Zwi/+NzXtsW7GGSQkJdmbL9rvKp0Cwa+Hu3LR6OhU33BFRh
6BRVknt0foQo94DndU4YcF5xEPrWVIw0lZMYFj7eQi4mF2uuzFAg6ra9owBh
Ftp8u5jrD1YjWa2vzPY4EoxUxWteCcXg8W6tQt44HMq2rxAyXSTAoTiF9LGJ
cYhJCI1rLMShj5pVtz1y5qGL3OLJaF4LP92+/XGRrEBqJk+eaAVSQIDNRGl1
jxG6y/6zzMw9H9kr/XlFT6EAovmczv/jc4od79oz1ktEafLFUqXSeaCr2/Hg
xnkCMB4VfYObwdDAAY/Fr0WVYGFnSgriwmCaaHnYaKkDvcE33XpK1QH1of0M
RgwU+J1oNeRyfQKUr+t9l7RpRveE8rxV/eeBuRszLNXGw98OLkV6Kq95ok8U
SKfiu+jryVw970n4+LaHh4djDPFMHuvs5aDiiM/vXrehNphIzL0q/XMYyebV
prTqL0ADy52+3JhnsDDgLMr3cgCVMA2u5K0sglQdFivNhkMWr0lJ12EIIeuH
ro/YFiGP5nPep/mcczSfU9W0s/+AAoZOWKhK8KeVgO9lkdzwQQy+bxxfV4/G
kFiZJZ3tWRzsdhIIwRYI4OLU8nmP7QiqNKxqpjA2QnMk/Y2KTwvwLeMIW5lO
EwSxnw/W3qxC9Y0yatcvUWDhgL22Usc4NLYSTcVNqPrXODvhQgtVxxu33JZL
HgHFa/o6UbKzyJrxAr3PJAE0q522Dsl3wOIIi+53fwJK60zTsnXEoNX4ccVW
fxzsEFe0re4loOSbFeFOZkRw8aX/nZiLQ4a/Vcy5tAnIcEX3TPBBIky42Fwv
+DyIXk7kf84zmUV73epVEl9icJ/mc1bRfM5Wms/pK8Jvb244i2ov6aafHKHy
9CD1gjtSZOBMq7TxpuqxoSCHU4b2XXB97aGjOVWXvfacEHsoOoWuc8ZkDA73
goj4oIv0NzIofQoN/VfahFS6im0XSxsAL0S6touDyj/pGE62e9XDRw+OV0rB
VD3hu1418mcJFM7Z2aawdoLeuWlkLTuF3r30vyLqOQenv2y0vClrAKdbbJes
+QlIZbsFt6UPEZidrafZTeNg8NNXvGw4hs49s1b4nfef3ly8FZRZjXTNmWJm
7xNQpaLTBwNvIgzImc/qrbSiB74cEq7Hp9HX5qtsBO45qP4TZGnZg0PEd9NM
E9XdyFKjp6JMYgnsaD7nTZrP6UTzORsZk+YgaRyp+utgU89rIaK3Iy+KeQFW
ksPOZhyaQVOn/fTkh/qAu0JbZkmeBCb/ZjS/K04ijefBl/jTxsB3U9D23yYR
Wje2iTVH9CPjmfwRgdfjYMX/G28Kc0CqaCA6DzQgYfPMfbZMA5AQXBW4P24R
vhRFtNNxJqJw5yPdL1erQfGMlbZCLQVYE/S0pLiTQEac16jTuhjhOW5+spmi
wE6biLczIyEwKCsgNUdoRJw79O/5B1HAKPKyUs2wPwrfLhJ7+iJCHV/Pp6rU
UcDDvyOloCkU3rw3+Hbiwge4dSCSULpGgXPzClqqfdVwzCurhZWvG2pZjjFm
xi8BMjW6jF3vgXOe541vHR+F64++hfh6zkMczecMpfmcT2k+p10mUeGTbzd6
eF1LWFi1Blq/xmeW+S3B8N009mcHh9GOOzKMRpED0H2ez+mk5DzQP//6YrBz
EBkVqDaZ7ZoGdS0/85Xr1H4o8Vq2YrkH5cp99q8/jYc3C0zRu8kY9KprK7dN
tqD95ZDDaUcA2xL7jeQWDGw3FhPrC2rQmaRgzSf3CKB3o83f2IkIQyd3S2cy
5KO1rdtvGMrwMHgn1FdGmwReV2tePZhzQPfNeEwuqOJB+me0g+I3EgyUu73T
OP4JQu9EMm8Z4iFfXJzbJp0E2g7l9jMSVXCYQbA1G8ND5/5f0eGrRDDqPfrk
x75mUP0RtKf9CAHoTzFQnM8Qge90d4qVVTcQ3z0UuHwDD+FXWjKGqfe02amA
cit8AMYRH7hnT4M7pNclU/HrAM3n3E3zOelouYFqE5enKJalSEkq/cC/yiL4
IZGc8hZRYMNmxkT9TwPqd38ceU+1GxIUZ75IGC3BUMSebQVcOBRjVmizh9qP
r9708G+j6uXDQwpCZ281IJUiO4G6lVnIUasq6fUhwdi/z9enNRB66PhW2KoP
AwflFksPbgzo3jiaGHAVI9GtlTNhViRgLKiz8wzCw9lZp8YV6Uyka9Xu81OS
DH85xH40FcxC0+KOXxz+Lmizw+eUnC0ZuvnH/r61nQWWn5rWLM5p8PdWw4Lq
aTI81b2zM+fDLBz7m/ZTka8QhiOPKelTdXVirUvDM2s8mE3NaZWpVUK9oqlS
uggRJE8qL9P1EeCteWkDcUc9ZIrI0t+PpeLJz82AbhYSLPLrKr5LbQIP/dtf
J6n8VCVFt45xYQ4+ffHPzDJvArdL4Z0xyX3g7RaVuta4CN9puXXsNJ9zkeZz
/h9i75L+
     "]], {}, {}},
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"\[Phi]\"", TraditionalForm], 
    FormBox["\"T\"", TraditionalForm]},
  AxesStyle->Directive[Bold, 
    GrayLevel[0], 14],
  BoxRatios->{2, 2, 1},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.3 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm],
  PlotRange->{All, All, All},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->Directive[
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 10],
  ViewPoint->
   NCache[{Rational[-1, 2] Pi, Rational[1, 2] Pi, 1}, {-1.5707963267948966`, 
     1.5707963267948966`, 1}],
  ViewVertical->{0.2902564488994358, -0.2902564488994358, 
   0.9118675275195287}]], "Output",
 CellChangeTimes->{
  3.7954285894507513`*^9, 3.7954295981964893`*^9, 3.7954308411295013`*^9, 
   3.7954309567241087`*^9, 3.795533530960824*^9, 3.795534059694537*^9, 
   3.795589224808277*^9, 3.8010333003277273`*^9, {3.8010335296102543`*^9, 
   3.801033555471064*^9}, 3.8010336046544323`*^9, 3.801033696696185*^9, 
   3.801033737331616*^9, 3.801034007269137*^9, 3.80106749386852*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"bbf48ef7-984d-4e95-8e84-a58c92d59d64"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx0nXc41e//x5GkIrshMkKlEiqZHUVTW7SQSluioZIipWQkUpGZ0qAkCQlv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    "], {{
      {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1nXn8FdP/x+d+7p1z5n7mViQtJJKkkkqSJPuWRLKmJEkksu/7vmYLyS4k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           "]], Polygon3DBox[CompressedData["
1:eJw1nXf81tP7x9/3/R73ezS0pElDS0qEdhKSjKRsEaXsvffIJnsrGS0itCQZ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           "]], Polygon3DBox[CompressedData["
1:eJwV2HmczeUeB/Bj7GOaJlkKWZMlu6ZpSCIkZJnsSlLJkn0LyU1C9jWhbtdt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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0llSU1EUQNGLBgkqAmLfJkOgmEAyBGQCCQPQophAMgTKCSRDsPjyjwwB
Iip9QieNgDGCfbOO+di198d59e477+anXzx73pdSeo1LiM5jfiClIpfR1FWu
o6sb3MZY1rwH8pjQRS5jSle5jlnd4DZexryX5DEf81xGM+a5jm7Mcxtjg+Yv
m8eELnIZU7rKdczqBrexjaX+lHZ4F029x/t4oz/wAZb1IR/hrT7mj3inT/gU
7/UZf8KK7vBnrOouf8GaPucLrOuv/A0b+jv/wKb+yb+wpX/zH7T0X04ZzXO+
Y4FrmNEVLmFSFziHcZ3iWbsZjXmuoWNnFS5hURc4h1fZ3k9t2f2cXuAaZmKe
S5iMec5hPNu7AC0ajXmuoeOfV7iERV3gHJ7isfM/CeOhfhTGff0gjLv6Xhi3
9Z1w3B99Kxzv0zfDGNYjYQzpG2Fc09fDGNRXwxjQcXRHS/36SjhWlfm/3lhZ
6sv07vc/2FJbeg==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwNyFk2AgAYhuG/K6fTKmzIhR2UTEXtxRAyFTIPnTJkCIVkCjvqufjO855v
NFMcLyQiYsyaIxELyYgG06mIRX2pl3jFjG9ZX+sSbzjhW9EtvcpbZn1r+k6X
ec9J37p+0Btsc8q3qR/1Fp847dvWz7rCDmd8Vd3VO3zhrG9Xv+o9vjHnq+me
3uc7874D3deH/OCc70h/6mN+cd53or/1KX9Y8J3pgT7nL4u+C/2n6/znEPKc
NmU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAUhuHjyhOrsCEXltACFEKkRZlKhsyzuihjiCTJFDvwXpzn/c4/
kkyNjQ9ExKirD0YsJiJq7A9FVIcjLvWS7Ypp/7K+1iu84YRtVd/qAu84aSvq
hl7jPadsJf2g1/nIjG1DN/Umnzht29LPuswWZ2zb+kXvsM1Z265+1XvsMGvb
12/6gF3O2Q71uz5ij/O2Y/2hT/jJnO1Uf+kzfnPBdq5/9AX7zNsq+ldX+cd/
4o0/eA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAUhuGTqcm4BBty0RJaADsQkdTmhMiYMoVukjI04L04z/udfz2/
ldtMRMSG+0hGHKUj+uxldDZioGu2Id9tNdunPrZ9cdt/or/1KX9YsNX1SJ9x
zB3buZ7oBqfctV3oX33JPxZtVzpSEddMcM92o2f0LWe5b2vqOX3HeZZsLb2g
20zywHavU/qBaZZtjzqjn5jloe1ZL+oOl1ixvehl/coVVm1velV3ucZ/JdI2
Hw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzlk6AlAcxuF/yNRdpjInaRCxERctoQWwEENl2ldsg5AyF6+L87y/812c
5+QaJ/XjREQcOXPTEQ8zEWn2ZiM6qYh5/Whb4Kvtzraou7Yl9m33tox+smV5
6v6sl/ULV3hm6+nV/3e4xnNbX6/rATd4YXvTm/qdOTZtH3pLfzLPlu1Lb+tv
Fti2/egdPWSRl7aRLulflnllC/+u6AR3eW0b01U9zj3e2Cb0vk6yxlvbpD7Q
UzzkH1U5KFg=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyVk2AmAYx+HXjZMSITKE2gKNMs+pTEtw3WE5EtGikpUYLj0X33l+7/8r
PjzdP05ERMfbTkQkkhFb/OYoFVHSU7rMH37aKjqpq/zl2FbTKV3nH79sO3pa
N9idjNhl2r3HZ/8zel/P8oA9W0Yf6jke8cU2r4/1Ak/Yt2X1qV7kGV9tS/pc
53jBN9uyvtQrbHJgW9VXeo0tvtvyuq3X2eGHbUNf603ecGgr6Ftd5B3/AQHt
HME=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyVk2AmAYx+HXjeOwCkMyJRlCe3DTIGRMlKFiHVahJO1I2AhxjufiO8/v
/X/T1Xa+NRYRe15hImJmMiLPb75PRRT1rC7xh0Pbvp7TZY74YTvQCX3IX37a
jvS8rvCPX7ZjndQnfBqPOOWC+4zP/hf1uV7iBTu2ZV3VK7xk15bSNb3KK77Y
0vpar7HOni2jG3qdN3y1behbvck79m1b+l5n2eSbbVu39A7bHNh29YPO8ZH/
HFAk/A==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyGk2AgAUhuFb+eFkFdZhzlCSoiVYQM5RmcpQ5iJsg0wLMlT7wPPjnue9
3+TWdrmSiIiiq45HTKUjdvjLz4mImp7Wdf7xy7arZ/Qew//t9vWs7YAJ/487
1HO2BpP+gWvqedsRU/6hO9YLthOO+UfuVGdsLT75F3VbL/GMz7Zlfa5XeMG+
LasvdY5XfLGt6mud5w1fbWu6owvs8s22rm91kXd8t5V0T2/wnh+2Tf2gy3zk
P+2fKUE=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6AgAYRuHfRTTYhA11IWPmBukmewmZ50SmyJAFidImvBffc853pgrb
07WxiMjaTjIil46oYyIT8W27fEbbw3G/bw0+q+3jhP9jB3xOO8Sk/2tHfF47
xpQ/sBO+oJ1i2h/aGV/UzjHj/9kFz2uXOOmP7IovadfY9Zd5k6/gDb5pq7zF
1/AW37V1fsc3sI0fWoHf8yI+4KdW4o+8jE/Y0zb5M69gB7+0Lf7Cq/iK/60C
Lfo=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk2AgAcRvG/N4eTKRZgQx4socekREqjPZGhkQwZC/sQoQX4PXzn3u9u
pnLb2bmI2LLT+Yj0QsQJJhYjPq3Jd7QzXPInds4z2gUu+192yXe1Fq7439bm
Wa2Dq/7Uujyn9XDN/7E+39OuMOn/2jXPawNc9//shu9rt7jhz+yOH2j32PIL
fMgP8QHbWpE/8hI+YUc74s+8jC/Y1Sr8lVdxhD2txse8jm/Y1xr8nR/jB/4D
n800hw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyEs2AgAcRvG/mZM5Ijk2ZGAJLYAtEEJ6CPvx2oF3eSXkEdIAIY7f4Dv3
fnciMzM13RcRk3bQHzGbiNjHwYGIdzvkc9oRDvkfdsyz2gkO+592yue1Kib9
rtX4gnaGI/6XnfNF7QJH/W+75DntClP+j9X5knaNY37PGnxZu8G0/2u3fEW7
w3H/z5o8r93jlr/KH3gBH3FbK/InXsIW7mhl/szX8AV3tQp/5evYxj1tg7/x
TezgP42AOvY=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyNdZAgEQhdFZ4i4gYgeiEqQYHyiBArAaMGdQCkHtRzAjeB7m+++c5uC4
P0wi4sgt0ohRJeJNd6sRG7e0x+xdm/6oRXzYJ+xT91jCvuxT9q37LMd+7DP2
qwcsz1b2OfvTFiuwtX3BNtpmRRZZxCVLtMNKLGdfsbx2WZkV7GtW1EOWspJ9
w8raYxlL7VuW6Zzd2RX7Xqv6zB7smj3RLX1hU7tuP+q2vrInu2HPdEf/ARYs
JW8=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk6ggEYhuHPob+IBilDRYY0G1pGB5bQAliXJJJENoBVdR+81/Ned230
eP+wERFDy21GPCURWW2mIpJ0RN4fs4K2WIrt+c+sqG2WZvv+hJW0w7ZY2X9h
B9pl2+zQn7Ij7bEMO/ZfWUX7bIdV/TdW02u2y078GTvVG5Zldf+dnekty7Fz
f84u9I7l2aX/wRo6YAV25S9YU3/Zp9/yl9rWP/bld/xv7eo/W/k9/0f7ugYY
VhvW
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVyFk6AgAYheHfpbhOolRLiDTPRaYMS7AANhhNxsqeel2c5zvPm39+fXrZ
iYixne5GTBIRRS3vRST3I878N1bSCjtg5/47K2uVpVjFn7Kq1tghq/kzVtc6
S7OGP2dNbbAj1vIXrK1Ndsw6/pJ1tcUyrOd/sL62WZYN/E821A47YRf+F7vU
Lsuxkf/NrrTH8uza/2E32mcFduv/sjtds5U//v96rxu28R/8P33ULeRRITQ=

        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFdSAgEURcHnp8gmLFEwoYtQzEgQc0BUMM7gQg2AOa3F/rh1bvVoK60l
QxFRtvpwxGMmoqYLIxFj2Ygt/4k1dJHl2Lb/zHa0xMbZrt9je7rEJti+32cH
uszy7NAfsCNdYQV27L+wE11lk6zpv7JTXWNTrOW/sTNdZ9Ps3H9nF7rBZljb
/2AdLbNZdul/sivdZEV27X+xG62wOXbrf7M7rbJ5lvg/LNUH9ut3/T+913/R
3yak
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwNyFk2AgAYhuHfpdiEJRAhZAcuKhnDsYCcY85UpkRIK5RkjjV4Lr7zfucZ
2tzKlvoiYs52+iOeExHbmh2IGB6M2PXbbE9zbITt+y/sQPMsyQ79DivrPBtl
R/4rO9YCG2Mnfped6gJLsTP/jVV0kY2zqv/OznWJTbAL/4Nd6jKbZFf+J7vW
FZZmNf+L3egqm2J1/5vdapFNszv/hzV0jc2we7/HHnSdZdij/8uausFm2ZP/
x1r6D+DtLDI=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwVzr0uA1AcxuF/xUficzOhEaOSWKkL0IrBRE0s6MCmegHFBZReQHED5QbK
XPExWCTVGJvQwap9DCfP77zDyZndO948SkTEhpPoj/gciOjjD3dHIpK6qxfZ
cB8fjFjV01znky2ld/QK83y2ZXRRb/OCb7YDXdEF3vLddqbv9SUf+WG71q+6
xha/bHXd+X+b4T9tW1NP6G/O8Nf2pxf02FBEml3blM7qeeY4PBqxrA/1Gk85
advS53qfV5yznegbXeIdl2xl/aCrfGEPwFQrLA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzjkuBFAAxvFvYlDMBN1UtkRpSbSWA9gK3aCaapCgsxzAcgDLASwXwAXQ
i6GYRoIoJSi0/BQvv//7ipfXX1ufXyskmXNaislra1LkF2ulpE+nLRlhJzds
k7pHz/LefUgv6XGu8sE2rXf0Ag/4ZFvWJ3qLF2za9vS1PuIdn21n+lFf8o3v
thv9/f82C/72YXvRXfqTvfyx/eph3dGeTDDlpFvP6EEusmQb0yt6itus2Kp6
X9d5zAHbpj7Xu7ziqO1Q3+pTNvgHBtMpHw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0ug1Ecx/H/I/oYNCmbCc9gpE2sXi6gdOhYLExeQmxFYkUvoOUCVG8A
N4Ab8DJYmqgYJWXo6mM4+XzPbzg52eZBdT+JiIqTG47o5SJS/nBrNCLTSRpR
4hgPbct6Slc4x1Pbhl7Ue3x2X9Eneo0Nvtl29JU+YofvtnN9r1t8YtfW1q/6
lp/8sj3o3/+3OeRv37YPPa77nObAFiMRRV3gEpN8xKRe1bNcZ962oHd1mcec
sNX0hd7mJWdsdX2jz3jHeVtTP+prvvAPcCMoHQ==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+G3VdpEJdXNRA1GKrGqXkBVYkUHMTkmNq3E6nABbV2Aww2U
G8ANoINFQmOUVAejx/Dl+b3/6StsHqzuJyKi6qVTEZ/DERn+cGs0YlonRyLm
Oc5DW1lP6RXO8cRW0yW9x2Ve2I71+n+z697Rl7rOW77ZzvS9bvGJ77Zr/ao7
7PHL9qAH+plD/vZt+9B53WeBv7ZEOqKoc1xiMhsxqat6lhscsy3qXV1hgxO2
NX2ut9nmjO1I3+hT3nHB1tSP+oov/ANdMygk
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0ug2EYx+G72hKtSLCZvAxGH4m16gBexIwmTUyqBpuPxOrjAEoPoPQE
cAI4ASxdJIhR0nawuQxPrl/+9/Ik1f2NeiYiUm84F/GZjyiwx51ixIzODkYs
cpwHthWd6HXO89RW0cu6zlVe2k701n+zxiaP2GbH/Vw/6Cs+8912o9/0Hb/4
bXvUff3CnH/92D70hO5ymr+2gaGIBT3GMrMjEVN6Tc9xm6O2kt7TKY85advU
F3qX15y1HepbfcZ7Ltka+km3+Mo/odcnkA==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr8ug2EYh+FHfK2hTSTYTFWDsSrpWuz+7koMpmoXW5F0RWdpOQDqBNQJ
4ATK3KQVowRDJ5fhzXXn9yxv7rC+W5uIiA0vk0SMUhFZ/vAoE7Gok3TECmd5
YlvXC3qHy2zaDvSqrnOLLdu5rvw3j3ltu9Wn+oGXfGKHrxy43+t3/cgPftqe
9a/uM+VfX7ahntPfzHNsm5yKKOoZrjHJRuT0ti5wn9O2sq7pTZ5x3ranr3SV
N1yyNXRXX7DHkq2tX/Qd3/gHnMcnmQ==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0uw2EYxuGnSf81KGmCzaIYjGhi9bGr9gBaunTSWmxaiVV1Fh+D0ccJ
qBPQnkCZJYhRgsHiMry5fs89vTO1ZrmRiohNbywd8ZZEjPOb9dGIeZ1kIgqc
5L5tQ8/qMpd4ZNvRa3qPW+zaDnX1v9ngqe1St/QdO7yyPehzPeCL+0Y/63u+
88P2qH/0kBl/+7S96in9xTn+2tIjEct6gutMshF5XdKL3GbOtqqbusg2p20V
faJ3ecEF24G+1cfsccV2pvv6mk/8A4tTKJU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr8ug2EYh+GniX4dNFEJNoMUg9GfxErNUu0BtDqZWl1sVGKlnQUdOhYn
gBPQnoA6AcQooYPBZXhz3c9vehdqjVI9FRG73tRExHs6IscfHkxGLOskidjg
LI9sO3pRl7nGM1tNb+sm99ixnerqf7PBS1tXn+h7XrBne9LXeshb9m2v+kF/
8NP9rMf6hRl/+7K96Tn9zSX+2tKZiHU9wwKTbERel/Qq9zlt29KHusgW520V
3dZ13nDFdqzv9DkfuWm70gPd54h/lQcoqw==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzzsvw1Ecx+GfpO2/iS4kdJNIXIaOVGJFV0kvL6CtyaJlsbkkVmUWl8HY
6mDFGyhvAG8As0QNEk+Hk+dzvtM5s81WZWcsIjadiVTEZzpikkNuj0cs6iQT
scJp7ttKel7XuMwT25Ze13us8Nx2rBujZpsXtht9qPvs8Nb2pK/0C3vs2t71
g/7igPe2X/2qs9727f6h8/qHC/yzZZKIop7iBpNcxJyu6iU2R/+zreldXeYR
Z2x1faZbvGbBdqDv9CkfuWq71M+6yzf+A6OfKME=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+FXglbYKmWTDg6D0SHpSo0dqi5AmQyOi01JrFqzqA7GageT
BDfQ9gbKDeAGqkPjMXx5fu9/+jKlo8LhSETkvdRoxPdYxDR/eTAZsaST4xHr
nOG5bUsv6B2u8tq2rzf1Gbd5a7vSpf/mCe9sdV3WLVb4aHvXNd3lExu2T/2q
f9jms22ge3rC3774YpvVfb3IoTuRiFjTaeaYnIqY10W9wj2mbBv6VBd4yTnb
rq7qYz5w2Xahm/qGb8za7nVHN/jBP7YHKNU=
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzqtOAmAYx+HXzRNixFOTAhiMHjarYiN44AIQEhvOQ7GhblaR7DwEI0Ig
uak3oN6AeAPiDajFx/Dt+e0f3n3p0u5GbSAiCt7EYER/KGKSP6wmI+Z0Yjhi
mdM8sq3rrC5ykWe2il7Th9xi03aqd/6b+7y03epj3WGDd7Znfa3feM+W7UM/
6i++sGv71e96zN8++WCb0d86x9ERt2xLekrnmRiPyOhtvcAyU7ZVfaA3ecJZ
W0lf6D3ecN5W1219zieu2K70q26xxz/Hpyjl
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzzsvA1AcxuG/xCW0qxRbJ3ToWCRdXSZDo7VTpqZNisXmklhd5qYYjKWD
SVIGK76A9gvQL4DB0+Hk+eUdTs5Jb9UK1aGIWHdSwxHfIxFT/GUlEZHRE6MR
S5zmoW1Nz+lNLvDMtqtX9AGLvLKd6vKguceG7VYf6zYveGd70df6g/ds2Xq6
o/t846PtT3/qhLd98ck2o3/0PMfH3GVbHPxBr3KWr7aSzukdTiYjlvW+3uAJ
07ZtfanrvGHWdqQf9Dmfmbc19btusct/QAMp7g==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzr0uA2AYhuFX4idpewKtial0MFKJ1c9ikCizUFNroBYbmli1ZtF2MBZD
JwmGJp1wAjiBcgKtxGX4ct15hjff1M7BRnkkIta99GjE91hEhkOWkhE5nRyP
WGSGJ7Y1PaO3ucAL275e0ccs8MpW1Xv/zSNe21r6TD+wxlvbi27od96xbfvS
T/qHr+zYfvWHTvlbn4+2ST3Qs0xMuGXL67ReZZZd25ae10Uus2er6E19zulU
xK6u60M2OWc71ff6ks9cst3oN93mJ/8Ap8gq7w==
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzjsvg2EYx+FbQjv09QXadzE6DEaHpKvDYDBUrRKHqV1KFxuaWB1moR06
lg4mCQaJGOgXwBfAF2jFZXhy/fIf7jxjG9XVylBErHiF4YjvkYiUA1ZyEVM6
yUTMs8B927Ke0Ouc5bFtRy/qOtd4bmvorf/mLi9sLX2ouzxl2/aor3SP1+zY
PvW9/uErb22/+l2P+tsX72yp7utJ5rJu2eZ0Xi9xnE+2sp7R21zgs21Pl/QR
N/liO9M13eR0EnGgb/QJH1i0Xeo33eEH/wD/0Svm
        "],
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVzrsuA2AYx+FX4jCo3oBWYkUvoK3EqiQGi+poQBedelhsDonVYRatwVgM
JgkdmjQkuAF6A+UGHB7Dl+eX//Dmm96orO4MRcSKlx6O+ByJmOIPK+MRGT0x
GjHPFHdty3pWl5jjka2sC7rBIs9sh3rrv1njue1S7+tbnvDK1tFN/cZrtm19
/aC/+MI7269+10l/G/Deltbfeo6JMbdseT2plzjDrm1dZ/U2F9mz1fWaPuAm
n2ynuqpb3OOz7UYf60cuJCIu9Ktu84N/SXEs0Q==
        "],
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzsm/k7lG/89mWLSCUpki0tlrQoWTujUNImSVJKiyWhqISkEiqlRVkqRFRC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