(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1766094,      33496]
NotebookOptionsPosition[   1754763,      33322]
NotebookOutlinePosition[   1755084,      33336]
CellTagsIndexPosition[   1755041,      33333]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["3d qbcp", "Section",
 CellChangeTimes->{{3.7948269139390078`*^9, 
  3.794826917412561*^9}},ExpressionUUID->"f2351a50-1ba8-46cf-b205-\
608e889493c2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ham", ",", "\[Psi]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"id", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Gamma]", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]", "[", "a", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "b", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Gamma]", "[", "b", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "a", "]"}]}]}], 
     RowBox[{"2", "\[ImaginaryI]"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"dahat", "=", 
    RowBox[{"da", "/", 
     SuperscriptBox["k", "2"]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "1", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "ky"}]}], ";", " ", 
  RowBox[{
   RowBox[{"d", "[", "2", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "kz"}]}], ";", 
  RowBox[{
   RowBox[{"d", "[", "3", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kz", " ", "ky"}]}], ";", " ", 
  RowBox[{
   RowBox[{"d", "[", "4", "]"}], "=", 
   RowBox[{
    FractionBox[
     SqrtBox["3"], "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kz", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ")"}]}]}], ";", 
  RowBox[{
   RowBox[{"d", "[", "5", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["kx", "2"]}], "-", 
     SuperscriptBox["kz", "2"], "-", 
     SuperscriptBox["ky", "2"]}], "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "i", "]"}], 
      RowBox[{"\[Gamma]", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", "ham", "]"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6312382022915897`*^9, 3.631238225759459*^9}, {
   3.6312382600929537`*^9, 3.6312384017277803`*^9}, {3.631238501848529*^9, 
   3.631238514655388*^9}, {3.631238557337954*^9, 3.631238582703508*^9}, {
   3.631238697418057*^9, 3.6312387608920393`*^9}, {3.631238821822587*^9, 
   3.6312388336171837`*^9}, {3.6312388682255707`*^9, 3.63123894870654*^9}, 
   3.631241459271804*^9, 3.6312415058351183`*^9, {3.631242162714487*^9, 
   3.631242164860416*^9}, {3.631243821329649*^9, 3.6312438323099318`*^9}, {
   3.631243931067396*^9, 3.631243943321344*^9}, {3.631245485411551*^9, 
   3.631245507064893*^9}, {3.631245606183861*^9, 3.631245636233708*^9}, {
   3.631246369852314*^9, 3.631246410769082*^9}, {3.63124927017979*^9, 
   3.63124930420273*^9}, {3.631249422231785*^9, 3.631249432782104*^9}, {
   3.631249677286726*^9, 3.631249702711062*^9}, {3.631285101024441*^9, 
   3.631285106140984*^9}, {3.631285140088323*^9, 3.6312852358940573`*^9}, 
   3.631287438641325*^9, {3.631295671787744*^9, 3.631295675200363*^9}, {
   3.631296743735948*^9, 3.631296768464766*^9}, {3.631303956396132*^9, 
   3.6313039785131187`*^9}, {3.631363753884413*^9, 3.63136377298313*^9}, 
   3.631414086575067*^9, {3.631551950532612*^9, 3.631551957383226*^9}, 
   3.6315519991082993`*^9, {3.711821084066185*^9, 3.7118211139118958`*^9}, {
   3.711821392685665*^9, 3.71182150933855*^9}, {3.711821576479093*^9, 
   3.711821735961163*^9}, {3.7118217742380238`*^9, 3.711821848019948*^9}, {
   3.7118243385720043`*^9, 3.7118243649817753`*^9}, 3.793277445616826*^9, {
   3.794826944606303*^9, 3.794826969612651*^9}, {3.7948270440250483`*^9, 
   3.794827071360015*^9}, {3.795345678473947*^9, 3.795345684714752*^9}, {
   3.7962336016210012`*^9, 3.796233627001638*^9}, {3.796287905504579*^9, 
   3.796287926256215*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ca5c9fa3-7f11-4ca9-83a3-4fe055f9d930"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", "kz"}], "-", 
           SuperscriptBox["kz", "2"]}], ")"}]}], 
        RowBox[{"2", " ", "kx", " ", 
         RowBox[{"(", 
          RowBox[{"ky", "+", 
           RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{"ky", "+", 
            RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]]}], ",", "0", ",",
        "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"ky", "-", 
            RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
         RowBox[{"2", " ", "kx"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"ky", "+", 
            RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
         RowBox[{"2", " ", "kx"}]]}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["ky", "2"], "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", "kz"}], "-", 
           SuperscriptBox["kz", "2"]}], ")"}]}], 
        RowBox[{"2", " ", "kx", " ", 
         RowBox[{"(", 
          RowBox[{"ky", "+", 
           RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", "ky"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"], " ", "kz"}]}], 
         RowBox[{"2", " ", "kx"}]]}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "kx", " ", 
         RowBox[{"(", 
          RowBox[{"ky", "+", 
           RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"ky", "+", 
            RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
         RowBox[{"2", " ", "kx"}]]}], ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.801068165889596*^9, 3.801114451905085*^9, 
  3.801114627637164*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"e129d434-9c69-4ebe-b98b-b0d713eaab65"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"a6fad987-1da3-454e-9d3d-23adf1d66691"]
}, Open  ]],

Cell[CellGroupData[{

Cell["using mathematica\[CloseCurlyQuote]s eigenvectors: gives wrong ans", \
"Section",
 CellChangeTimes->{{3.795414959290254*^9, 3.795414967693398*^9}, {
  3.801114795966796*^9, 
  3.801114799100153*^9}},ExpressionUUID->"023f4ea0-f67b-40f0-815a-\
79965de7fcd5"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"45ea978e-0af2-425a-8fe4-c5a729c122dd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec1", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", "kz"}], "-", 
         SuperscriptBox["kz", "2"]}], ")"}]}], 
      RowBox[{"2", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{"ky", "+", 
         RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox["3"]}], " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"], " ", "kz"}]}], 
       RowBox[{"2", " ", "kx"}]]}], ",", "0", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec2", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{"ky", "+", 
         RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"ky", "+", 
          RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
       RowBox[{"2", " ", "kx"}]]}], ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec3", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "ky", " ", "kz"}], "-", 
         SuperscriptBox["kz", "2"]}], ")"}]}], 
      RowBox[{"2", " ", "kx", " ", 
       RowBox[{"(", 
        RowBox[{"ky", "+", 
         RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["kx", "2"]}], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "kx", " ", 
        RowBox[{"(", 
         RowBox[{"ky", "+", 
          RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}]]}], ",", "0", ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"ky", "-", 
          RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
       RowBox[{"2", " ", "kx"}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"ky", "+", 
          RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], 
       RowBox[{"2", " ", "kx"}]]}], ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Norm", "[", "vec1", "]"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
       " ", "Reals"}], " ", "&&", " ", 
      RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"n2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Norm", "[", "vec2", "]"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
       " ", "Reals"}], " ", "&&", " ", 
      RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"n3", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Norm", "[", "vec3", "]"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
       " ", "Reals"}], " ", "&&", " ", 
      RowBox[{"k", ">", "0"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"n4", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Norm", "[", "vec4", "]"}]}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
       " ", "Reals"}], " ", "&&", " ", 
      RowBox[{"k", ">", "0"}]}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.796791257491041*^9, 3.796791335703452*^9}, {
   3.796791495232538*^9, 3.796791532265929*^9}, {3.796791897479691*^9, 
   3.796791940487009*^9}, {3.796792035735546*^9, 3.7967920366999817`*^9}, {
   3.796792123708592*^9, 3.796792125639447*^9}, {3.7967922105080347`*^9, 
   3.79679223637192*^9}, {3.79679287583219*^9, 3.796792882262719*^9}, {
   3.801039711841028*^9, 3.801039798485134*^9}, 3.801039867106347*^9, {
   3.8010681804875593`*^9, 3.8010682214573603`*^9}, {3.80111449997928*^9, 
   3.801114502446312*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"94488b6c-146d-45a0-9747-8065672d3854"],

Cell[BoxData[
 FractionBox[
  RowBox[{"Abs", "[", "kx", "]"}], 
  SqrtBox[
   RowBox[{
    SuperscriptBox["kx", "2"], "+", 
    SuperscriptBox["ky", "2"], "+", 
    SuperscriptBox["kz", "2"]}]]]], "Output",
 CellChangeTimes->{
  3.801039829899123*^9, 3.8010398676654253`*^9, 3.801040171339427*^9, {
   3.8010409470955353`*^9, 3.801040947427577*^9}, 3.801046805053812*^9, 
   3.8010511860759068`*^9, 3.801052570026864*^9, 3.8010653486464453`*^9, {
   3.801067666109918*^9, 3.801067672455216*^9}, 3.8010682244384613`*^9, {
   3.801114484460352*^9, 3.8011144893924026`*^9}, 3.801114628422764*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"6b64fbca-27aa-41f5-a563-07dbcd3de8a3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["3"], " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"kx", " ", 
     RowBox[{"(", 
      RowBox[{"ky", "+", 
       RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], "]"}]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}]]]], "Output",
 CellChangeTimes->{
  3.801039829899123*^9, 3.8010398676654253`*^9, 3.801040171339427*^9, {
   3.8010409470955353`*^9, 3.801040947427577*^9}, 3.801046805053812*^9, 
   3.8010511860759068`*^9, 3.801052570026864*^9, 3.8010653486464453`*^9, {
   3.801067666109918*^9, 3.801067672455216*^9}, 3.8010682244384613`*^9, {
   3.801114484460352*^9, 3.8011144893924026`*^9}, 3.801114628653359*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"40200332-693a-450e-bc0f-1475ded67464"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["3"], " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"kx", " ", 
     RowBox[{"(", 
      RowBox[{"ky", "+", 
       RowBox[{"\[ImaginaryI]", " ", "kz"}]}], ")"}]}], "]"}]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}]]]], "Output",
 CellChangeTimes->{
  3.801039829899123*^9, 3.8010398676654253`*^9, 3.801040171339427*^9, {
   3.8010409470955353`*^9, 3.801040947427577*^9}, 3.801046805053812*^9, 
   3.8010511860759068`*^9, 3.801052570026864*^9, 3.8010653486464453`*^9, {
   3.801067666109918*^9, 3.801067672455216*^9}, 3.8010682244384613`*^9, {
   3.801114484460352*^9, 3.8011144893924026`*^9}, 3.801114628733296*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"55d421f3-86c8-4e4f-9fee-8eeb6dd8011f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"Abs", "[", "kx", "]"}], 
  SqrtBox[
   RowBox[{
    SuperscriptBox["kx", "2"], "+", 
    SuperscriptBox["ky", "2"], "+", 
    SuperscriptBox["kz", "2"]}]]]], "Output",
 CellChangeTimes->{
  3.801039829899123*^9, 3.8010398676654253`*^9, 3.801040171339427*^9, {
   3.8010409470955353`*^9, 3.801040947427577*^9}, 3.801046805053812*^9, 
   3.8010511860759068`*^9, 3.801052570026864*^9, 3.8010653486464453`*^9, {
   3.801067666109918*^9, 3.801067672455216*^9}, 3.8010682244384613`*^9, {
   3.801114484460352*^9, 3.8011144893924026`*^9}, 3.801114628800261*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"ad555449-5ac5-41e8-9a35-c88113136b8f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "a1", ",", "a2", ",", "b1", ",", "b2", ",", "v", ",", "vs", ",", "t1", ",",
     "t2", ",", "r1", ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", 
    "\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4", ",", "tamp1", 
    ",", "tamp2"}], "]"}], ";", 
  RowBox[{"v", "=", "1"}], ";", 
  RowBox[{"vs", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]1", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_"}], "]"}], "=", "vec1"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]2", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_"}], "]"}], "=", "vec2"}], " ", 
  RowBox[{"(*", 
   RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]3", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_"}], "]"}], "=", "vec3"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]4", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_"}], "]"}], "=", "vec4"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}]}], "Input",
 CellChangeTimes->{{3.79670528102269*^9, 3.796705464630663*^9}, {
   3.796705526432672*^9, 3.7967056935481358`*^9}, {3.796707962114769*^9, 
   3.796707994283738*^9}, {3.796708054044833*^9, 3.796708171272504*^9}, {
   3.796708210665228*^9, 3.796708301683206*^9}, {3.79670838433363*^9, 
   3.796708384799498*^9}, {3.796708459490511*^9, 3.796708465992154*^9}, 
   3.796708692484707*^9, {3.796710100451231*^9, 3.796710119444291*^9}, {
   3.796711170274685*^9, 3.796711251509087*^9}, {3.7967113548685713`*^9, 
   3.796711358141728*^9}, {3.796711639430203*^9, 3.796711656015417*^9}, {
   3.7967117694373627`*^9, 3.796711778947089*^9}, {3.796711915167205*^9, 
   3.796711934115939*^9}, 3.7967119644469*^9, {3.796713895826386*^9, 
   3.796713924064556*^9}, {3.796739926493165*^9, 3.796739965785242*^9}, {
   3.796740268987865*^9, 3.796740273270981*^9}, {3.7967454862940807`*^9, 
   3.796745530554534*^9}, {3.796746356722354*^9, 3.7967465301366787`*^9}, 
   3.796746621853191*^9, 3.796746926608663*^9, {3.796792073383627*^9, 
   3.796792104520322*^9}, {3.7967921445636187`*^9, 3.796792196042794*^9}, {
   3.79679224157226*^9, 3.796792250489869*^9}, {3.796792434297332*^9, 
   3.796792461297999*^9}, {3.7967933229289007`*^9, 3.796793334707513*^9}, 
   3.796793492241158*^9, 3.79679421381841*^9, {3.79679428305647*^9, 
   3.79679429547497*^9}, {3.796794350677969*^9, 3.796794423149639*^9}, {
   3.79679448511909*^9, 3.796794488684161*^9}, {3.796794821642243*^9, 
   3.796794842963223*^9}, {3.796794884705184*^9, 3.796794902905464*^9}, {
   3.796795130332955*^9, 3.796795163199203*^9}, {3.796795563728292*^9, 
   3.7967955661976643`*^9}, {3.796795639766498*^9, 3.7967956435992527`*^9}, {
   3.7967959458081217`*^9, 3.7967959709318047`*^9}, {3.79679609542278*^9, 
   3.796796098365608*^9}, {3.796796176764182*^9, 3.796796178223049*^9}, {
   3.796796366221978*^9, 3.796796380110405*^9}, {3.7968154699433537`*^9, 
   3.796815503564178*^9}, {3.796815742130782*^9, 3.796815743167439*^9}, {
   3.7968157938587637`*^9, 3.796815794517918*^9}, {3.796816877444312*^9, 
   3.796816900796276*^9}, {3.7968169339861*^9, 3.796816969189598*^9}, {
   3.801039803668646*^9, 3.801039825246994*^9}, {3.801040157902526*^9, 
   3.801040168059703*^9}, {3.8011144369699183`*^9, 3.801114445286034*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"958d2927-b156-486b-8156-16e5fb85307b"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"d507e0a6-4a7a-4520-8f49-592a8e2b343c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["en < V", "Section",
 CellChangeTimes->{{3.801041178433359*^9, 3.801041202907886*^9}, {
  3.801045454666669*^9, 3.801045462521584*^9}, {3.8010534704746*^9, 
  3.801053474569628*^9}, {3.8010653049556704`*^9, 3.8010653099476757`*^9}, {
  3.801067683009923*^9, 
  3.8010676848790817`*^9}},ExpressionUUID->"b617136e-da44-4a61-a5ec-\
f16543008b70"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "a1", ",", "a2", ",", "b1", ",", "b2", ",", "t1", ",", "t2", ",", "r1", 
    ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", "tp1"}], "]"}], ";", 
  RowBox[{"v", "=", "1"}], ";", 
  RowBox[{"vs", "=", "1"}], ";", 
  RowBox[{"L", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy1", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"\[Psi]1", "[", 
       RowBox[{"kx", ",", "ky", ",", "kz"}], "]"}], "+", 
      RowBox[{"r1", " ", 
       RowBox[{"\[Psi]1", "[", 
        RowBox[{
         RowBox[{"-", "kx"}], ",", "ky", ",", "kz"}], "]"}]}], "+", 
      RowBox[{"r2", " ", 
       RowBox[{"\[Psi]2", "[", 
        RowBox[{
         RowBox[{"-", "kx"}], ",", "ky", ",", "kz"}], "]"}], "  "}]}], "1"], 
    "-", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"\[Psi]3", "[", 
         RowBox[{"kt", ",", "ky", ",", "kz"}], "]"}]}], "+", 
       RowBox[{"a2", " ", 
        RowBox[{"\[Psi]4", "[", 
         RowBox[{"kt", ",", "ky", ",", "kz"}], "]"}]}], "+", 
       RowBox[{"b1", " ", 
        RowBox[{"\[Psi]3", "[", 
         RowBox[{
          RowBox[{"-", "kt"}], ",", "ky", ",", "kz"}], "]"}]}], "+", 
       RowBox[{"b2", "  ", 
        RowBox[{"\[Psi]4", "[", 
         RowBox[{
          RowBox[{"-", "kt"}], ",", "ky", ",", "kz"}], "]"}]}]}], ")"}], 
     "1"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy2", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a1", " ", 
          RowBox[{"\[Psi]3", "[", 
           RowBox[{"kt", ",", "ky", ",", "kz"}], "]"}]}], "+", 
         RowBox[{"a2", " ", 
          RowBox[{"\[Psi]4", "[", 
           RowBox[{"kt", ",", "ky", ",", "kz"}], "]"}]}]}], ")"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "kt"}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b1", " ", 
          RowBox[{"\[Psi]3", "[", 
           RowBox[{
            RowBox[{"-", "kt"}], ",", "ky", ",", "kz"}], "]"}]}], "+", 
         RowBox[{"b2", "  ", 
          RowBox[{"\[Psi]4", "[", 
           RowBox[{
            RowBox[{"-", "kt"}], ",", "ky", ",", "kz"}], "]"}]}]}], ")"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "kt"}]]}]}], "1"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"t1", " ", 
       RowBox[{"\[Psi]1", "[", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "]"}]}], "+", 
      RowBox[{"t2", " ", 
       RowBox[{"\[Psi]2", "[", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "]"}], "  "}]}], "1"]}]}], ";", 
  
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
      "r1", ",", "r2", ",", "t1", ",", "t2", ",", "a1", ",", "a2", ",", "b1", 
       ",", "b2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rp1", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_", ",", "kt_"}], "]"}], "=", 
   RowBox[{"r1", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rp2", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_", ",", "kt_"}], "]"}], "=", 
   RowBox[{"r2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<transmission\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tp1", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_", ",", "kt_"}], "]"}], "=", 
   RowBox[{"t1", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tp2", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "kz_", ",", "kt_"}], "]"}], "=", 
   RowBox[{"t2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8010684851576433`*^9, 3.801068504645505*^9}, {
  3.80106902642828*^9, 3.801069035072212*^9}, {3.801114458069285*^9, 
  3.801114465591392*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"377363c3-24ba-49f5-a9e0-2e655a1f51ad"],

Cell[BoxData["\<\"transmission\"\>"], "Print",
 CellChangeTimes->{3.801041446787755*^9, 3.801048959692438*^9, 
  3.801050413654477*^9, 3.8010512182911*^9, 3.801053499965169*^9, 
  3.801053618496681*^9, 3.8010654118300743`*^9, 3.801067719499504*^9, 
  3.801068285930696*^9, 3.80106854253051*^9, 3.80106907053194*^9, 
  3.8011144670079*^9, 3.801114589417715*^9, 3.801114680032117*^9},
 CellLabel->
  "During evaluation of \
In[26]:=",ExpressionUUID->"47fc3c26-9cf8-417b-ad20-6f1303e3553d"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"cb402c56-8656-405c-834e-0ca7080eab27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rp1", "[", 
   RowBox[{"kx", ",", "ky", ",", "0", ",", "kt"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.80105117635997*^9, 3.801051182174076*^9}, {
  3.801051228276959*^9, 3.801051231201716*^9}, {3.80106910851348*^9, 
  3.801069109527158*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"39a88d46-bc33-402c-88a8-83ba669a55e2"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kt", "2"], " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kt", "2"], "+", 
         SuperscriptBox["kx", "2"]}], ")"}], " ", 
       SuperscriptBox["ky", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "kt", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
     SuperscriptBox["ky", "2"], " ", 
     RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["kt", "2"], " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["kx", "2"]}], ")"}], " ", 
        SuperscriptBox["ky", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", "kt", "]"}]}]}]]}]], "Output",
 CellChangeTimes->{
  3.801051186441402*^9, {3.801051218621983*^9, 3.8010512320355387`*^9}, 
   3.8010654126019573`*^9, 3.801067720175743*^9, 3.801068288067185*^9, 
   3.801068544101851*^9, 3.801069072077016*^9, 3.801069111998431*^9, 
   3.801114473868191*^9, 3.801114593923612*^9, 3.801114680927637*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"8136a2c2-a1aa-48fc-b83f-8a754bf50e7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rp2", "[", 
     RowBox[{"kx", ",", "ky", ",", "0", ",", "kt"}], "]"}], " ", 
    RowBox[{"n1", "/", "n2"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "kx", ",", "ky", ",", "kz"}], "}"}], "\[Element]", 
     " ", "Reals"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.801051274222796*^9, 3.801051275578981*^9}, {
  3.801069116699617*^9, 3.801069117776766*^9}, {3.8011146991090918`*^9, 
  3.801114744130838*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"a7ddce29-d4eb-4191-b135-e21a43e2cdbd"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["ky", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["kt", "2"], "+", 
     SuperscriptBox["ky", "2"]}], ")"}], " ", 
   RowBox[{"Sin", "[", "kt", "]"}]}], 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
      SuperscriptBox["ky", "2"], " ", 
      RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["kt", "2"], " ", 
         SuperscriptBox["kx", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kt", "2"], "+", 
           SuperscriptBox["kx", "2"]}], ")"}], " ", 
         SuperscriptBox["ky", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.801069072954917*^9, 3.801069121142641*^9, 3.801114475638575*^9, {
   3.80111468151071*^9, 3.8011147465504417`*^9}},
 CellLabel->"Out[41]=",ExpressionUUID->"264bf232-08cb-4706-b897-2c8393f77c66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tp1", "[", 
   RowBox[{"kx", ",", "ky", ",", "0", ",", "kt"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.801051274222796*^9, 3.80105130620778*^9}, {
  3.801069127805859*^9, 3.801069128933626*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"b4164798-3d8b-46bc-ad24-3039d621adcc"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"6", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
    SuperscriptBox["ky", "2"]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
     SuperscriptBox["ky", "2"], " ", 
     RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["kt", "2"], " ", 
        SuperscriptBox["kx", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kt", "2"], "+", 
          SuperscriptBox["kx", "2"]}], ")"}], " ", 
        SuperscriptBox["ky", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", "kt", "]"}]}]}]]}]], "Output",
 CellChangeTimes->{3.8010513076058817`*^9, 3.8010654149762087`*^9, 
  3.801067722086898*^9, 3.801068291809638*^9, 3.801068350119635*^9, 
  3.801068546875532*^9, 3.8010690751412067`*^9, 3.801069131320553*^9, 
  3.801114595731778*^9, 3.801114681834489*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"d9252750-d3ff-4d9a-8134-40a4a632fb57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tp2", "[", 
   RowBox[{"kx", ",", "ky", ",", "0", ",", "kt"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.801051314675124*^9, 3.80105131508429*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"bd5a7138-fd6a-48a7-b625-f2e6ac717c96"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.801051316241848*^9, 3.8010654163874187`*^9, 
  3.801067723175527*^9, 3.801068293340098*^9, 3.801114599082181*^9, 
  3.8011146821027412`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"a4ffd1a4-f76b-4649-969d-12f5bb0db10a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"tamp", ",", "ramp1", ",", "ramp2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{
   RowBox[{"ramp1", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kt", "2"], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kt", "2"], "+", 
            SuperscriptBox["kx", "2"]}], ")"}], " ", 
          SuperscriptBox["ky", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
        SuperscriptBox["ky", "2"], " ", 
        RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["kt", "2"], " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["kt", "2"], "+", 
             SuperscriptBox["kx", "2"]}], ")"}], " ", 
           SuperscriptBox["ky", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", "kt", "]"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}], 
      "}"}]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ramp2", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["ky", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kt", "2"], "+", 
         SuperscriptBox["ky", "2"]}], ")"}], " ", 
       RowBox[{"Sin", "[", "kt", "]"}]}], 
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}], 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["kt", "2"], " ", 
             SuperscriptBox["kx", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["kt", "2"], "+", 
               SuperscriptBox["kx", "2"]}], ")"}], " ", 
             SuperscriptBox["ky", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
          RowBox[{"Sin", "[", "kt", "]"}]}]}], ")"}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}], 
      "}"}]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tamp", "[", 
    RowBox[{"\[Phi]_", ",", "rat_", ",", "V_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
       SuperscriptBox["ky", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "kt", " ", "kx", " ", 
        SuperscriptBox["ky", "2"], " ", 
        RowBox[{"Cos", "[", "kt", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["kt", "2"], " ", 
           SuperscriptBox["kx", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["kt", "2"], "+", 
             SuperscriptBox["kx", "2"]}], ")"}], " ", 
           SuperscriptBox["ky", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["ky", "4"]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", "kt", "]"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", "\[Rule]", "1"}], ",", 
       RowBox[{"kx", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"ky", "\[Rule]", 
        RowBox[{
         SqrtBox[
          RowBox[{"rat", " ", "V"}]], 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
       RowBox[{"kz", "\[Rule]", "0"}], ",", 
       RowBox[{"kt", "\[Rule]", 
        SqrtBox[
         RowBox[{"V", "-", 
          RowBox[{"rat", " ", "V"}], "-", 
          RowBox[{"rat", " ", "V", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}], ")"}], "2"]}]}]]}]}], 
      "}"}]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "tab1", ",", "tab2", ",", "tab3", ",", "tab4", ",", "tabr1", ",", "tabr2", 
    ",", "tabr3", ",", "tabr4"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"tamp", "[", 
          RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "0.1"}], "]"}], "]"}], "2"]}], 
       "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 0.1 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PolarAxes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"PolarTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "3"}]}], ",", 
            RowBox[{
             RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "6"}]}], ",", 
            RowBox[{
             RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "6"}], ",", 
            RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "3"}], ",", 
            RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"(*", "****)"}], 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
     RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.15"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0.9"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 0.1 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], "]"}]}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dTimage11.jpg\>\"", ",", "g1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dRimage11.jpg\>\"", ",", "gr1"}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "tab1", ",", "tab2", ",", "tab3", ",", "tab4", ",", "tabr1", ",", "tabr2", 
    ",", "tabr3", ",", "tabr4"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tab4", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
         SuperscriptBox["10", 
          RowBox[{"-", "6"}]]}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "1"}], "]"}], "]"}], 
          "2"], "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1.0", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "1"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", "*)"}], 
  RowBox[{"g1", "=", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PolarAxes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"PolarTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "3"}]}], ",", 
            RowBox[{
             RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "6"}]}], ",", 
            RowBox[{
             RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "6"}], ",", 
            RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "3"}], ",", 
            RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"(*", "****)"}], 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
     RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.05"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0.8"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], "]"}]}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dTimage12.jpg\>\"", ",", "g1"}], "]"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gref", "=", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PolarAxes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"PolarTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "3"}]}], ",", 
            RowBox[{
             RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "6"}]}], ",", 
            RowBox[{
             RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "6"}], ",", 
            RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "3"}], ",", 
            RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"(*", "****)"}], 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
     RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.4"}], ",", "1.4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], "]"}]}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dRimage12.jpg\>\"", ",", "gref"}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "tab1", ",", "tab2", ",", "tab3", ",", "tab4", ",", "tabr1", ",", "tabr2", 
    ",", "tabr3", ",", "tabr4"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"Chop", "[", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"tamp", "[", 
           RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.3", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.5", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"+", "0"}], 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"tamp", "[", 
            RowBox[{"\[Phi]", ",", "0.8", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}], "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabr4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp1", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}], "+", 
        RowBox[{"Chop", "[", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           RowBox[{"ramp2", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "10"}], "]"}], "]"}], "2"], 
         "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tab1", ",", "tab2", ",", "tab3", ",", "tab4"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PolarAxes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], ",", 
    RowBox[{"PolarTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{
            RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"\[Pi]", "/", "6"}]}], ",", 
           RowBox[{
            RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "6"}], ",", 
           RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], ",", 
           RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", 
           RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"(*", "****)"}], 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.06"}], ",", "0.62"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.65"}], ",", "0.65"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tabr1", ",", "tabr2", ",", "tabr3", ",", "tabr4"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PolarAxes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"PolarTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", 
             RowBox[{"\[Pi]", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"-", "90"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "3"}]}], ",", 
            RowBox[{
             RowBox[{"-", "60"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "-", 
             RowBox[{"\[Pi]", "/", "6"}]}], ",", 
            RowBox[{
             RowBox[{"-", "30"}], "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "6"}], ",", 
            RowBox[{"30", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "3"}], ",", 
            RowBox[{"60", "\[Degree]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], ",", 
            RowBox[{"90", "\[Degree]"}]}], "}"}]}], "}"}], ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"(*", "****)"}], 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", " ", "12"}], "]"}]}], ",", 
     RowBox[{"PolarGridLines", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Red", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Darker", "[", "Green", "]"}], ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.4"}], ",", "1.4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", "None"}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "12"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\)\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}]}], "]"}]}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dTimage13.jpg\>\"", ",", "g1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<3dRimage13.jpg\>\"", ",", "gr1"}], "]"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
   "******)"}]}]}], "Input",
 CellChangeTimes->{{3.795430800710774*^9, 3.795430822601384*^9}, {
   3.795536541874064*^9, 3.795536552149109*^9}, {3.795536620764089*^9, 
   3.795536744273285*^9}, {3.795536797270541*^9, 3.795536802699469*^9}, {
   3.79553683612189*^9, 3.795536895879795*^9}, {3.795537146916971*^9, 
   3.79553721567351*^9}, {3.79553728580947*^9, 3.795537291906273*^9}, {
   3.795537335423833*^9, 3.7955373696821203`*^9}, {3.795537426011786*^9, 
   3.795537552613689*^9}, {3.795537647471653*^9, 3.79553766345883*^9}, {
   3.7955377141074743`*^9, 3.795537759716449*^9}, {3.7955377985586767`*^9, 
   3.79553791021973*^9}, 3.79553803779771*^9, {3.795538078841715*^9, 
   3.795538145298633*^9}, {3.795538221195356*^9, 3.795538222939136*^9}, {
   3.795538334017047*^9, 3.7955383838265533`*^9}, {3.795538440952417*^9, 
   3.795538499483881*^9}, {3.795538534165786*^9, 3.795538602012644*^9}, {
   3.795538638700178*^9, 3.79553865904891*^9}, {3.795538694069201*^9, 
   3.7955387688538933`*^9}, {3.795538883948126*^9, 3.7955388851899*^9}, {
   3.795538968092092*^9, 3.7955390289951572`*^9}, {3.795539067334662*^9, 
   3.795539086888975*^9}, {3.795539127441719*^9, 3.795539128889134*^9}, {
   3.795637917023027*^9, 3.795637945259872*^9}, 3.795638045633629*^9, {
   3.795638179567995*^9, 3.795638192688788*^9}, {3.8009840842161417`*^9, 
   3.800984088459092*^9}, {3.8010289737954893`*^9, 3.801029622617062*^9}, {
   3.801029704134108*^9, 3.801029709321169*^9}, {3.801029781821578*^9, 
   3.8010297870448303`*^9}, {3.801029827155061*^9, 3.8010298444603*^9}, 
   3.801029883630678*^9, {3.801029976316733*^9, 3.8010299801280622`*^9}, {
   3.801030016443768*^9, 3.80103003370991*^9}, {3.801030067649184*^9, 
   3.801030069474721*^9}, {3.801031514894157*^9, 3.8010315390824966`*^9}, {
   3.801032148626533*^9, 3.801032288126339*^9}, {3.801032321453076*^9, 
   3.8010323289533863`*^9}, {3.8010508303494577`*^9, 
   3.8010508549845753`*^9}, {3.801050898593808*^9, 3.801050947702916*^9}, {
   3.801051505896928*^9, 3.8010516169613533`*^9}, {3.8010516563044443`*^9, 
   3.8010516781697483`*^9}, 3.801051716065104*^9, {3.801051845357296*^9, 
   3.801051847357127*^9}, {3.8010521605237923`*^9, 3.801052238710128*^9}, {
   3.801052270785872*^9, 3.801052271787464*^9}, {3.801052377532432*^9, 
   3.80105238678011*^9}, {3.801052453905692*^9, 3.801052466355206*^9}, {
   3.801052600841013*^9, 3.80105260544473*^9}, {3.8010526355249367`*^9, 
   3.8010526373085003`*^9}, {3.8010528023568573`*^9, 3.801052810815894*^9}, {
   3.801052863083647*^9, 3.801052900642996*^9}, {3.80106545036198*^9, 
   3.8010655083794928`*^9}, 3.8010660262908907`*^9, {3.801068324720821*^9, 
   3.801068358761862*^9}, 3.801068611757429*^9, {3.801068644212075*^9, 
   3.801068648084721*^9}, {3.801069144482566*^9, 3.801069199451922*^9}, 
   3.801114766080915*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"aafcf319-f098-4bd7-afcf-d4a5ccf5138f"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9910463815706028}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4955231907853014, -0.858271342768788}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.858271342768788, -0.4955231907853014}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9910463815706028, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.858271342768788, 0.4955231907853014}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4955231907853014, 0.858271342768788}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9910463815706028}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.19820927631412055, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.3964185526282411, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5946278289423617, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7928371052564822, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmHc8l1/Yx81EIkUUJZIfkpkRcVmVlDITJSnJppDsUVaUyFb2qhSy57H3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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9910463815706028}], 
         Scaled[{0., -0.006}, {0., -0.9910463815706028}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4955231907853014, -0.858271342768788}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.4955231907853014, -0.858271342768788}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.858271342768788, -0.4955231907853014}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.858271342768788, -0.4955231907853014}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9910463815706028, 0.}], 
         Scaled[{0.006, 0.}, {0.9910463815706028, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.858271342768788, 0.4955231907853014}], 
         Scaled[{0.005196152422706632, 0.003}, {0.858271342768788, 
          0.4955231907853014}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4955231907853014, 0.858271342768788}], 
         Scaled[{0.003, 0.005196152422706632}, {0.4955231907853014, 
          0.858271342768788}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9910463815706028}], 
         Scaled[{0., 0.006}, {0., 0.9910463815706028}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9910463815706028}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.4955231907853014, -0.858271342768788}], 
        Offset[{4, -6.928203230275509}, {
         0.4955231907853014, -0.858271342768788}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.858271342768788, -0.4955231907853014}], 
        Offset[{6.928203230275509, -4}, {
         0.858271342768788, -0.4955231907853014}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9910463815706028, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.858271342768788, 
         0.4955231907853014}], 
        Offset[{6.928203230275509, 4}, {0.858271342768788, 
         0.4955231907853014}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.4955231907853014, 
         0.858271342768788}], 
        Offset[{4, 6.928203230275509}, {0.4955231907853014, 
         0.858271342768788}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9910463815706028}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9910463815706028, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 0.1 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.801114769819035*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"c2db1324-8db0-4b8d-8af6-ba8fc1f16e0f"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -1.018045724877876}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.509022862438938, -0.8816534599583841}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8816534599583841, -0.509022862438938}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {1.018045724877876, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.8816534599583841, 0.509022862438938}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.509022862438938, 0.8816534599583841}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 1.018045724877876}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.20360914497557522, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.40721828995115045, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.6108274349267256, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.8144365799023009, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwcmnc81u/3x2VlZVRUItRHIUkqSuqgIisiq0lWpOyUkJW998y47Xnf9r64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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -1.018045724877876}], 
         Scaled[{0., -0.006}, {0., -1.018045724877876}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.509022862438938, -0.8816534599583841}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.509022862438938, -0.8816534599583841}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8816534599583841, -0.509022862438938}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.8816534599583841, -0.509022862438938}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {1.018045724877876, 0.}], 
         Scaled[{0.006, 0.}, {1.018045724877876, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.8816534599583841, 0.509022862438938}], 
         Scaled[{0.005196152422706632, 0.003}, {0.8816534599583841, 
          0.509022862438938}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.509022862438938, 0.8816534599583841}], 
         Scaled[{0.003, 0.005196152422706632}, {0.509022862438938, 
          0.8816534599583841}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 1.018045724877876}], 
         Scaled[{0., 0.006}, {0., 1.018045724877876}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -1.018045724877876}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.509022862438938, -0.8816534599583841}], 
        Offset[{4, -6.928203230275509}, {
         0.509022862438938, -0.8816534599583841}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.8816534599583841, -0.509022862438938}], 
        Offset[{6.928203230275509, -4}, {
         0.8816534599583841, -0.509022862438938}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1.018045724877876, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.8816534599583841, 
         0.509022862438938}], 
        Offset[{6.928203230275509, 4}, {0.8816534599583841, 
         0.509022862438938}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.509022862438938, 
         0.8816534599583841}], 
        Offset[{4, 6.928203230275509}, {0.509022862438938, 
         0.8816534599583841}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 1.018045724877876}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1.018045724877876, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.9, 
       FormBox["0.9`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 0.1 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.15}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.801114770354116*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"5d5d1c7b-affd-4c5d-ad14-23d8c5988891"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.9170266328061356}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4585133164030678, -0.7941683599570177}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.7941683599570177, -0.4585133164030678}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9170266328061356, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.7941683599570177, 0.4585133164030678}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4585133164030678, 0.7941683599570177}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.9170266328061356}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.18340532656122713, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.36681065312245426, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.5502159796836814, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.7336213062449085, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxkmHc41u/7/6nMMoqiUEZmJVmVuE8jlHgTMrMje1VWyUxWieyRlZHsvXLZ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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.9170266328061356}], 
         Scaled[{0., -0.006}, {0., -0.9170266328061356}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4585133164030678, -0.7941683599570177}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.4585133164030678, -0.7941683599570177}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.7941683599570177, -0.4585133164030678}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.7941683599570177, -0.4585133164030678}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9170266328061356, 0.}], 
         Scaled[{0.006, 0.}, {0.9170266328061356, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.7941683599570177, 0.4585133164030678}], 
         Scaled[{0.005196152422706632, 0.003}, {0.7941683599570177, 
          0.4585133164030678}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4585133164030678, 0.7941683599570177}], 
         Scaled[{0.003, 0.005196152422706632}, {0.4585133164030678, 
          0.7941683599570177}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.9170266328061356}], 
         Scaled[{0., 0.006}, {0., 0.9170266328061356}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.9170266328061356}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.4585133164030678, -0.7941683599570177}], 
        Offset[{4, -6.928203230275509}, {
         0.4585133164030678, -0.7941683599570177}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.7941683599570177, -0.4585133164030678}], 
        Offset[{6.928203230275509, -4}, {
         0.7941683599570177, -0.4585133164030678}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.9170266328061356, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.7941683599570177, 
         0.4585133164030678}], 
        Offset[{6.928203230275509, 4}, {0.7941683599570177, 
         0.4585133164030678}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.4585133164030678, 
         0.7941683599570177}], 
        Offset[{4, 6.928203230275509}, {0.4585133164030678, 
         0.7941683599570177}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.9170266328061356}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.9170266328061356, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.05}, {-1.1, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.8011147708219976`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"38e50e0d-44d3-4d84-a469-ed2b11515dbf"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -1.1638421943883257`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.5819210971941629, -1.0079169063365168`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {1.0079169063365168`, -0.5819210971941629}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {1.1638421943883257`, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {1.0079169063365168`, 0.5819210971941629}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.5819210971941629, 1.0079169063365168`}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 1.1638421943883257`}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.23276843887766516, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.4655368777553303, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.6983053166329954, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.9310737555106606, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJztm/c/1v/3+BFJiIQoKWVnJKnMU/aWVZkphVBWVkgkWSG0yJaV7L0e5mWP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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large], LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.0055000000000000005`], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], \
{{}, {}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -1.1638421943883257`}], 
         Scaled[{0., -0.006}, {0., -1.1638421943883257`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.5819210971941629, -1.0079169063365168`}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.5819210971941629, -1.0079169063365168`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {1.0079169063365168`, -0.5819210971941629}], 
         Scaled[{0.005196152422706632, -0.003}, {
          1.0079169063365168`, -0.5819210971941629}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {1.1638421943883257`, 0.}], 
         Scaled[{0.006, 0.}, {1.1638421943883257`, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {1.0079169063365168`, 0.5819210971941629}], 
         Scaled[{0.005196152422706632, 0.003}, {1.0079169063365168`, 
          0.5819210971941629}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.5819210971941629, 1.0079169063365168`}], 
         Scaled[{0.003, 0.005196152422706632}, {0.5819210971941629, 
          1.0079169063365168`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 1.1638421943883257`}], 
         Scaled[{0., 0.006}, {0., 1.1638421943883257`}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -1.1638421943883257}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.5819210971941629, -1.0079169063365168`}], 
        Offset[{4, -6.928203230275509}, {
         0.5819210971941629, -1.0079169063365168`}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         1.0079169063365168`, -0.5819210971941629}], 
        Offset[{6.928203230275509, -4}, {
         1.0079169063365168`, -0.5819210971941629}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1.1638421943883257, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {1.0079169063365168`, 
         0.5819210971941629}], 
        Offset[{6.928203230275509, 4}, {1.0079169063365168`, 
         0.5819210971941629}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.5819210971941629, 
         1.0079169063365168`}], 
        Offset[{4, 6.928203230275509}, {0.5819210971941629, 
         1.0079169063365168`}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 1.1638421943883257}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1.1638421943883257, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.4}, {-1.4, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.801114771425295*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"84e51b04-70db-47f9-8e2c-adaec7818d5a"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -0.5252528982476043}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.2626264491238022, -0.4548823532938282}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4548823532938282, -0.2626264491238022}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.5252528982476043, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.4548823532938282, 0.2626264491238022}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.2626264491238022, 0.4548823532938282}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 0.5252528982476043}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.10505057964952087, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.21010115929904175, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.31515173894856263, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.4202023185980835, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJxk2GVQls/3MHBAUhpBQfCLIAgCCiggeR9QGqRTpEO6G6UbKZGU7pIOyaU7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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -0.5252528982476043}], 
         Scaled[{0., -0.006}, {0., -0.5252528982476043}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.2626264491238022, -0.4548823532938282}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.2626264491238022, -0.4548823532938282}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4548823532938282, -0.2626264491238022}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.4548823532938282, -0.2626264491238022}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.5252528982476043, 0.}], 
         Scaled[{0.006, 0.}, {0.5252528982476043, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.4548823532938282, 0.2626264491238022}], 
         Scaled[{0.005196152422706632, 0.003}, {0.4548823532938282, 
          0.2626264491238022}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.2626264491238022, 0.4548823532938282}], 
         Scaled[{0.003, 0.005196152422706632}, {0.2626264491238022, 
          0.4548823532938282}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 0.5252528982476043}], 
         Scaled[{0., 0.006}, {0., 0.5252528982476043}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -0.5252528982476043}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.2626264491238022, -0.4548823532938282}], 
        Offset[{4, -6.928203230275509}, {
         0.2626264491238022, -0.4548823532938282}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.4548823532938282, -0.2626264491238022}], 
        Offset[{6.928203230275509, -4}, {
         0.4548823532938282, -0.2626264491238022}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {0.5252528982476043, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.4548823532938282, 
         0.2626264491238022}], 
        Offset[{6.928203230275509, 4}, {0.4548823532938282, 
         0.2626264491238022}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.2626264491238022, 
         0.4548823532938282}], 
        Offset[{4, 6.928203230275509}, {0.2626264491238022, 
         0.4548823532938282}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 0.5252528982476043}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 0.5252528982476043, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {0.5, 
       FormBox["0.5`", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.06, 0.62}, {-0.65, 0.65}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.8011147719324627`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"86dc42a1-3f10-451b-8e66-7d2b10c6c1da"],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., -1.124118693010598}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.562059346505299, -0.9735153450161385}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9735153450161385, -0.562059346505299}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {1.124118693010598, 0.}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.9735153450161385, 0.562059346505299}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0.562059346505299, 0.9735153450161385}}]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      LineBox[{{0, 0}, {0., 1.124118693010598}}]}}, {
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0., NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.2248237386021196, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.4496474772042392, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.6744712158063588, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], Opacity[0.4], 
      CircleBox[{0, 0}, 0.8992949544084784, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}}}, {}, {{}, 
    GraphicsComplexBox[CompressedData["
1:eJwkWnc81d//J6tQJCRChEgqGmZeqRAlFEnJlqIkJclIIg0pe5VRVCIaQsSx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     "], {{{}, {}, 
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwl1GecCAQYBvDb5xZ37s4NN9ziptt37kpoCQ2daFldoaG7lkrIbC+Voh0q
VEZRZBXtstohs10oSinE/359+D/v5+fD82Y1Njc0BQYEBJwgWm4QwYQQShjh
tCKCSKKIJobWtCGWONoSTwKJtCOJZFJIpT1ppJNBJh3IIpsccsmjI53Ip4BC
iiimhM6UUkY5FVRSRTU11NKFOupbunIiXTmJbnSnBydzCqdyGqfTkzPoRW/6
cCZncTbn0JdzaaAf59GfAZzPBVzIRVzMQAYxmCEM5RIauZTLGMZwRnA5V3Al
VzGSq2mimWu4luu4nhsYxY3cxM2M5hbGMJZx3Mp4JjCRSUxmCrdxO3dwJ3dx
N/dwL/dxPw8wlQd5iIeZxiM8ynRm8BiP8wRP8hRP8wzPMpNZzOY5nucF5jCX
ebzIS7zMfBawkEW8wqssZgmv8TpLWcYbLGcFK1nFat7kLdawlrd5h3d5j/f5
gA/5iI9Zx3o2sJFNfMKnfMbnfMGXfMXXbGYLW/mGbWxnBzvZxW6+5Tu+5wd+
5Cd+5hd+ZQ972cdv/M5+DvAHf3KQv/ibQ/zDvxzmCEf5j2O0jD+QIIIJIZQw
wmlFBJFEEU0MrWlDLHG0JZ4EEmlHEsmkkEp70kgng0w6kEU2OeSSR0c6kU8B
hRRRTAmdKaWMciqopIpqaqilC3XUB/7/644DLsaIlg==
         "]]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large], LineBox[CompressedData["
1:eJwVz2eADgQAgOHvKKOkQktJlwiplPaddXvvvQd33L7jLqWJMktpUIqKhlmE
iHaJaFlFtGlHKFry9ON5/7/BZfVpdUGBQCBEQhnIIAYzhKGEEU4EkUQRTQyx
xBFPAokkkUwKqaSRTgaZZJFNDrnkkU8BhRRRTAmllFHOMIZTQSUjGEkV1dRQ
y/9D9TTQSBOjGE0zLdzIGG7iZsZyC7dyG7dzB3cyjvFM4C7uZiKTmMwUpjKN
e7iX6dzH/czgAR7kIR5mJrN4hEeZzWM8zhzm8gRP8hTzmM/TPMOzPMcCFrKI
xSxhKc/zAstYzousYCWreInVrOFl1rKOV3iV13idN3iTt3ibd1jPu2xgI++x
ic28zwd8yEd8zBa2so3t7OATPmUnu/iM3ezhc77gS77ia77hW/ayj+/4nh/4
kZ/4mV/4lf0c4DcOcojD/M4fHOEof/IXf/MP/3KM/wi0CgSCaEVrTuBE2tCW
drTnJE6mA6fQkVM5jdPpRGe6cAZnchZncw5dOZfz6Mb5dOcCgrmQHlxET3px
Mb3pQ18uoR+XchmX058ruJIBXMXVXMO1XMf13EAIoQxkEIMZwlDCCCeCSKKI
JoZY4ogngUSSSCaFVNJIJ4NMssgmh1zyyKeAQooopoRSyihnGMOpoJIRjKSK
amqopY56GmikiVGMppkWjgPRdZel
         "]]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANDvTkNJVqVBZlntzansNHFFUhqaMq4kNzncPnfnuOHu3Ll9
xu2GliYlGqJkpGGEyGiYUb0f73UaFxY6OSgQCIQoPDgQiCCSKKKJYToziGUm
s5hNHPEkkEgSyaSQyhzSSCeDuWQyj/lkkU0OuSwgj3wKWEghRSyimBJKKaOc
CiqpYjFLWMoyqqmhljrqaaCR13idN3iT5bzF27zDu7zHCt7nAz7kIz7mE1ay
ik/5jNV8zhrW8gVf8hVfs45vWM8GvuU7NvI9m9jMFrbyA9v4kZ/4mV/Yzg52
sotf2c0e9vIb+9jP7xzgIIc4zB/8yV/8zRGOcozjnOAk/3CK0/zLfwSaBAJB
BNOEMziTszibppzDuTTjPJpzPi1oSSta04YLuJCLaMvFXMKlXEY72nM5HehI
JzrTha5cwZV0ozs96EkvruJqruFaruN6buBGbuJmbuFWbqM3fQihL7dzB3fS
j/4MYCCDGMwQ7mIod3MP93If9/MAwxjOCEJ5kIcYySgeZjSPMIZHeYyxPM4T
PMlTjONpnuFZnuN5XmA8LzKBiUxiMmG8xMtM4RWm8irTCCeCSKKIJobpzCCW
mcxiNnHEk0AiSSSTQipzSCOdDOaSyTzmk0U2OeSygDzyKWAhhRSxiGJKKKWM
ciqopIrFLGEpy6imhlrqqKeBRv4HQ22mtA==
         "]]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[Large], 
        LineBox[CompressedData["
1:eJwNxGeADgQAANBPrpKmaNC8lhEtIl0llUoqXDSk1BVp3SkkpaE0yKrshk1L
484N69x259ydO7fccntblUjz/XgvOCwiNLxNIBAIUWTbQCCKjUQTQyxxbGIz
W9jKNuLZTgKJJJFMCqmksYN0MthJJrvIIpscdpNLHnvIp4BCiihmLyWUUkY5
FeyjkiqqqaGWOuppoJEmmmmhlf0c4CCHOMyv/MbvHOEPjnKMPznOX/zNP/zL
fwSCAoE2nEBbgjiRkziZdpxCe07lNE7nDM7kLDpwNh3pxDmcy3mcT2e6cAEX
chEXcwmXEsxlXM4VXMlVdKUb3enB1fSkF9dwLddxPTfQmz7cSF/6cRP9uZkQ
buFWbmMAtzOQO7iTuxjE3dzDvQzmPoZwPw/wIEMZxnBCeYgRjORhHuFRHmMU
jzOaJ3iSMTzF04TxDM8ylnE8x3ie5wVe5CVeJpwIJvAKrzKRSUzmNabwOlN5
gzeZxlu8zTu8y3Te431m8AEf8hEfM5NZfMJs5jCXecznUz7jcxawkEUsZglL
WcYXfMlXfM1yVrCSVaxmDWtZx3q+4Vu+43t+YAM/8hM/8wuRRLGRaGKIJY5N
bGYLW9lGPNtJIJEkkkkhlTR2kE4GO8lkF1lkk8NucsljD/kUUEgRxeylhFLK
KKeCfVRSRTU11FJHPQ000kQzLbTyP4SQtcM=
         "]]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[
         NCache[
          Rational[2, 3], 0.6666666666666666], 0, 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 
         NCache[
          Rational[2, 3], 0.6666666666666666], 0], PointSize[
        0.004583333333333334], Thickness[Large]}, 
       {RGBColor[1, 0, 1], PointSize[0.004583333333333334], Thickness[Large]}, 
       {RGBColor[0, 0, 1], PointSize[0.004583333333333334], Thickness[
        Large]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}], {{}, \
{}}}, {}, {}, {}, {{{
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., -1.124118693010598}], 
         Scaled[{0., -0.006}, {0., -1.124118693010598}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.562059346505299, -0.9735153450161385}], 
         Scaled[{0.003, -0.005196152422706632}, {
          0.562059346505299, -0.9735153450161385}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9735153450161385, -0.562059346505299}], 
         Scaled[{0.005196152422706632, -0.003}, {
          0.9735153450161385, -0.562059346505299}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {1.124118693010598, 0.}], 
         Scaled[{0.006, 0.}, {1.124118693010598, 0.}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.9735153450161385, 0.562059346505299}], 
         Scaled[{0.005196152422706632, 0.003}, {0.9735153450161385, 
          0.562059346505299}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0.562059346505299, 0.9735153450161385}], 
         Scaled[{0.003, 0.005196152422706632}, {0.562059346505299, 
          0.9735153450161385}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold], 
      StyleBox[
       LineBox[{
        Scaled[{0, 0}, {0., 1.124118693010598}], 
         Scaled[{0., 0.006}, {0., 1.124118693010598}]}],
       StripOnInput->False,
       FontSize->12,
       FontWeight->Bold]}, 
     StyleBox[LineBox[{}],
      StripOnInput->False,
      FontSize->12,
      FontWeight->Bold], {InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "90"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, -8}, {0., -1.124118693010598}], 
       ImageScaled[{Rational[1, 2], 1}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "60"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, (-4) 3^Rational[1, 2]}, {
         0.562059346505299, -0.9735153450161385}], 
        Offset[{4, -6.928203230275509}, {
         0.562059346505299, -0.9735153450161385}]], 
       ImageScaled[{
        Rational[1, 4], Rational[1, 2] (1 + Rational[1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{
         RowBox[{"-", "30"}], " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], -4}, {
         0.9735153450161385, -0.562059346505299}], 
        Offset[{6.928203230275509, -4}, {
         0.9735153450161385, -0.562059346505299}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         3, 4]}],
       Background->Automatic], InsetBox[
       StyleBox["0",
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{8, 0}, {1.124118693010598, 0.}], 
       ImageScaled[{0, Rational[1, 2]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"30", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4 3^Rational[1, 2], 4}, {0.9735153450161385, 
         0.562059346505299}], 
        Offset[{6.928203230275509, 4}, {0.9735153450161385, 
         0.562059346505299}]], 
       ImageScaled[{
        Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2]), Rational[
         1, 4]}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"60", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], NCache[
       Offset[{4, 4 3^Rational[1, 2]}, {0.562059346505299, 
         0.9735153450161385}], 
        Offset[{4, 6.928203230275509}, {0.562059346505299, 
         0.9735153450161385}]], 
       ImageScaled[{
        Rational[1, 4], 
         Rational[1, 2] (1 + Rational[-1, 2] 3^Rational[1, 2])}],
       Background->Automatic], InsetBox[
       StyleBox[
        RowBox[{"90", " ", "\[Degree]"}],
        StripOnInput->False,
        FontSize->12,
        FontWeight->Bold], Offset[{0, 8}, {0., 1.124118693010598}], 
       ImageScaled[{Rational[1, 2], 0}],
       Background->Automatic]}, 
     CircleBox[{0, 0}, 1.124118693010598, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, {}}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& ), "CopiedValueFunction" -> ({
      Sqrt[Part[#, 1]^2 + Part[#, 2]^2], 
      Mod[
       ArcTan[
        Part[#, 1], 
        Part[#, 2]], 2 Pi]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{None, None}, {{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Directive[Bold, 
    GrayLevel[0], 12],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  LabelStyle->Directive[Bold, 
    RGBColor[
    0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 12],
  Method->{"OptimizePlotMarkers" -> False, "OptimizePlotMarkers" -> False},
  PlotLabel->FormBox[
   "\"\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\)\"", TraditionalForm],
  PlotRange->{{-0.1, 1.4}, {-1.4, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[Bold, 12]]], "Output",
 CellChangeTimes->{
  3.8010509867770042`*^9, 3.801051339589036*^9, 3.801051383387866*^9, 
   3.801051627071453*^9, 3.8010516802050657`*^9, 3.8010517584482307`*^9, 
   3.801051851818214*^9, 3.8010522883584347`*^9, 3.801052482031951*^9, 
   3.8010525162994747`*^9, 3.801052572235606*^9, 3.801052639814756*^9, 
   3.801052813837912*^9, 3.801052871526463*^9, 3.801052907822789*^9, 
   3.8010655330539093`*^9, 3.801067846758278*^9, 3.801068362244329*^9, {
   3.801068592437648*^9, 3.801068614786269*^9}, 3.8010686588377743`*^9, 
   3.801069202487351*^9, 3.801114772446529*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"6439a098-487d-4ea7-8ebd-6a263e61185b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["tabr1"], "Input",
 CellLabel->
  "In[414]:=",ExpressionUUID->"c9cafc74-540d-48f6-9fa3-4e927a7c8c21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5707953267948966`"}], ",", "0.781250000001372`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5607953267948966`"}], ",", "0.78138724497811`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5507953267948966`"}], ",", "0.7817987673992502`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5407953267948966`"}], ",", "0.7824840932270081`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5307953267948966`"}], ",", "0.7834424283710107`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5207953267948966`"}], ",", "0.7846726526657977`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5107953267948966`"}], ",", "0.7861733115397437`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5007953267948966`"}], ",", "0.7879426054768899`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4907953267948966`"}], ",", "0.7899783774037837`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4807953267948966`"}], ",", "0.7922780981651404`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4707953267948966`"}], ",", "0.7948388502850141`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4607953267948965`"}], ",", "0.797657310244276`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4507953267948968`"}], ",", "0.8007297295404484`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4407953267948965`"}], ",", "0.8040519148321155`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4307953267948967`"}], ",", "0.807619207506998`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4207953267948967`"}], ",", "0.8114264630497514`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4107953267948967`"}], ",", "0.8154680306221617`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4007953267948967`"}], ",", "0.8197377333038592`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3907953267948967`"}], ",", "0.8242288494749751`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3807953267948967`"}], ",", "0.8289340958524491`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3707953267948967`"}], ",", "0.8338456127174895`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3607953267948967`"}], ",", "0.8389549518920019`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3507953267948967`"}], ",", "0.84425306803487`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3407953267948967`"}], ",", "0.8497303138336367`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3307953267948966`"}], ",", "0.8553764396616317`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3207953267948966`"}], ",", "0.8611805982537539`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3107953267948966`"}], ",", "0.8671313549243788`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3007953267948966`"}], ",", "0.873216703807227`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2907953267948966`"}], ",", "0.8794240905386228`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2807953267948966`"}], ",", "0.885740441731786`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2707953267948966`"}], ",", "0.8921522015006718`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2607953267948966`"}], ",", "0.8986453751876834`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2507953267948966`"}], ",", "0.9052055803314207`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2407953267948966`"}], ",", "0.9118181047800417`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2307953267948966`"}], ",", "0.9184679717150266`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2207953267948966`"}], ",", "0.9251400112020117`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2107953267948965`"}], ",", "0.9318189377333516`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2007953267948968`"}], ",", "0.9384894330751516`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1907953267948965`"}], ",", "0.9451362335840281`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1807953267948967`"}], ",", "0.9517442210204224`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1707953267948965`"}], ",", "0.9582985157607428`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1607953267948967`"}], ",", "0.9647845712044418`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1507953267948967`"}], ",", "0.971188268088733`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1407953267948967`"}], ",", "0.9774960073667784`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1307953267948967`"}], ",", "0.9836948002779423`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1207953267948967`"}], ",", "0.9897723542431335`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1107953267948967`"}], ",", "0.9957171532556227`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1007953267948967`"}], ",", "1.0015185315078035`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0907953267948967`"}], ",", "1.0071667390960262`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0807953267948966`"}], ",", "1.0126529987763995`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0707953267948966`"}], ",", "1.017969552900841`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0607953267948966`"}], ",", "1.02310969984011`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0507953267948966`"}], ",", "1.0280678193939374`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0407953267948966`"}], ",", "1.0328393868917187`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0307953267948966`"}], ",", "1.0374209758946373`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0207953267948966`"}], ",", "1.0418102496152444`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0107953267948966`"}], ",", "1.0460059413677123`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0007953267948966`"}], ",", "1.0500078245456905`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9907953267948967`"}], ",", "1.053816672790254`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9807953267948967`"}], ",", "1.0574342111540607`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9707953267948967`"}], ",", "1.0608630591864618`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9607953267948967`"}], ",", "1.0641066669563368`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9507953267948966`"}], ",", "1.067169245093793`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9407953267948966`"}], ",", "1.0700556899689855`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9307953267948966`"}], ",", "1.0727715051371165`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9207953267948966`"}], ",", "1.0753227201650861`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9107953267948966`"}], ",", "1.0777158079199345`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9007953267948966`"}], ",", "1.0799576013449679`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8907953267948966`"}], ",", "1.0820552106797594`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8807953267948966`"}], ",", "1.0840159419984987`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8707953267948966`"}], ",", "1.0858472178509249`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8607953267948967`"}], ",", "1.0875565006947274`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8507953267948967`"}], ",", "1.0891512197108444`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8407953267948967`"}], ",", "1.0906387014966337`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8307953267948966`"}], ",", "1.092026105038506`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8207953267948966`"}], ",", "1.0933203612776794`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8107953267948966`"}], ",", "1.09452811750166`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8007953267948966`"}], ",", "1.0956556867210825`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7907953267948966`"}], ",", "1.096709002127512`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7807953267948966`"}], ",", "1.0976935766730054`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7707953267948966`"}], ",", "1.0986144677668985`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7607953267948966`"}], ",", "1.0994762470489188`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7507953267948966`"}], ",", "1.100282975170157`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7407953267948966`"}], ",", "1.1010381814937655`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7307953267948967`"}], ",", "1.101744848614611`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7207953267948967`"}], ",", "1.1024054015907891`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7107953267948967`"}], ",", "1.1030217017784403`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7007953267948966`"}], ",", "1.1035950451639596`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6907953267948966`"}], ",", "1.1041261650931011`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6807953267948966`"}], ",", "1.10461523930354`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6707953267948966`"}], ",", "1.10506190117511`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6607953267948966`"}], ",", "1.1054652551191002`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6507953267948966`"}], ",", "1.1058238960335198`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6407953267948966`"}], ",", "1.1061359327544449`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6307953267948966`"}], ",", "1.106399015433283`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6207953267948966`"}], ",", "1.1066103667655591`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6107953267948967`"}], ",", "1.1067668169878386`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6007953267948967`"}], ",", "1.1068648425452445`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5907953267948967`"}], ",", "1.1069006083124124`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5807953267948966`"}], ",", "1.1068700132253801`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5707953267948966`"}], ",", "1.106768739150983`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5607953267948966`"}], ",", "1.1065923027839992`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5507953267948966`"}], ",", "1.1063361103209746`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5407953267948966`"}], ",", "1.1059955146140839`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5307953267948966`"}], ",", "1.1055658744593497`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5207953267948966`"}], ",", "1.1050426156222595`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5107953267948966`"}], ",", "1.1044212931513961`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5007953267948966`"}], ",", "1.1036976544788835`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.49079532679489657`"}], ",", "1.1028677027566167`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.48079532679489656`"}], ",", "1.1019277598312776`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.47079532679489655`"}], ",", "1.100874528220854`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.46079532679489654`"}], ",", "1.0997051514225387`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.45079532679489653`"}], ",", "1.098417271858185`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4407953267948965`"}], ",", "1.0970090857507553`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4307953267948965`"}], ",", "1.0954793942245218`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4207953267948965`"}], ",", "1.0938276499346107`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4107953267948967`"}], ",", "1.092053998558379`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4007953267948967`"}], ",", "1.0901593145225312`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3907953267948967`"}], ",", "1.0881452303958825`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3807953267948967`"}], ",", "1.0860141594474046`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3707953267948967`"}], ",", "1.08376931095208`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3607953267948967`"}], ",", "1.0814146979210724`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.35079532679489667`"}], ",", "1.078955137036452`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.34079532679489666`"}], ",", "1.076396240681319`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.33079532679489665`"}], ",", "1.0737444010713628`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.32079532679489664`"}], ",", "1.0710067666106846`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.31079532679489663`"}], ",", "1.0681912107100535`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3007953267948966`"}], ",", "1.0653062934168145`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2907953267948966`"}], ",", "1.0623612163094351`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2807953267948966`"}], ",", "1.0593657712035618`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2707953267948966`"}], ",", "1.0563302832982027`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2607953267948966`"}], ",", "1.053265549458171`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2507953267948966`"}], ",", "1.0501827723810433`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.24079532679489657`"}], ",", "1.0470934914324805`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.23079532679489656`"}], ",", "1.0440095109525906`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.22079532679489655`"}], ",", "1.0409428268382797`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.21079532679489654`"}], ",", "1.037905552192856`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.20079532679489653`"}], ",", "1.0349098428058723`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.19079532679489652`"}], ",", "1.0319678231846037`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.18079532679489652`"}], ",", "1.0290915138059926`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1707953267948965`"}], ",", "1.0262927601960303`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.16079532679489672`"}], ",", "1.02358316437505`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1507953267948967`"}], ",", "1.0209740191344754`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1407953267948967`"}], ",", "1.0184762455354688`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1307953267948967`"}], ",", "1.0161003339450554`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.12079532679489668`"}], ",", "1.0138562888525577`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.11079532679489668`"}], ",", "1.0117535776404578`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.10079532679489667`"}], ",", "1.0098010834206634`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.09079532679489666`"}], ",", "1.0080070619908794`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08079532679489665`"}], ",", "1.0063791029172595`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.07079532679489664`"}], ",", "1.0049240947095552`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.06079532679489663`"}], ",", "1.0036481940236808`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.05079532679489662`"}], ",", "1.0025567988043789`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.040795326794896614`"}], ",", "1.0016545252669005`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.030795326794896605`"}], ",", "1.000945188611229`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.020795326794896596`"}], ",", "1.0004317873644744`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.010795326794896587`"}], ",", "1.0001164912558587`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0007953267948965781`"}], ",", "1.0000006325433015`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00920467320510343`", ",", "1.0000847007297375`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.01920467320510344`", ",", "1.0003683406298156`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.02920467320510345`", ",", "1.000850353772275`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03920467320510346`", ",", "1.0015287031486928`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.049204673205103466`", ",", "1.0024005213441156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.059204673205103475`", ",", "1.0034621221080704`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06920467320510348`", ",", "1.004709015444184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07920467320510349`", ",", "1.006135926312015`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0892046732051035`", ",", "1.0077368170444927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09920467320510329`", ",", "1.0095049135876186`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.1092046732051033`", ",", "1.0114327356648536`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1192046732051033`", ",", "1.0135121309563297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.12920467320510332`", ",", "1.0157343133620382`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.13920467320510332`", ",", "1.0180899053883936`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.14920467320510333`", ",", "1.0205689846589063`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.15920467320510334`", ",", "1.0231611345025415`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.16920467320510335`", ",", "1.0258554985182031`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.17920467320510336`", ",", "1.0286408389517117`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.18920467320510337`", ",", "1.0315055986536472`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.19920467320510338`", ",", "1.034437966314288`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2092046732051034`", ",", "1.0374259445971248`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2192046732051034`", ",", "1.0404574207173276`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2292046732051034`", ",", "1.0435202389380054`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2392046732051034`", ",", "1.046602274387823`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.24920467320510342`", ",", "1.0496915075404325`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.25920467320510343`", ",", "1.0527760986419734`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.26920467320510344`", ",", "1.055844461329439`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.27920467320510345`", ",", "1.0588853346522211`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.28920467320510346`", ",", "1.061887852692989`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29920467320510347`", ",", "1.0648416109838015`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.3092046732051035`", ",", "1.0677367289294424`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3192046732051035`", ",", "1.070563907483001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3292046732051035`", ",", "1.073314481368152`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3392046732051035`", ",", "1.075980465207835`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3492046732051033`", ",", "1.0785545929985585`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3592046732051033`", ",", "1.0810303504616967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3692046732051033`", ",", "1.0834019999055062`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3792046732051033`", ",", "1.0856645973416348`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3892046732051033`", ",", "1.08781400171481`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39920467320510333`", ",", "1.0898468762210998`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.40920467320510334`", ",", "1.0917606818058074`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.41920467320510335`", ",", "1.0935536630436062`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.42920467320510336`", ",", "1.0952248267084248`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.4392046732051036`", ",", "1.0967739134363987`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4492046732051034`", ",", "1.098201362969836`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4592046732051036`", ",", "1.0995082735421269`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4692046732051034`", ",", "1.1006963560217768`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4792046732051032`", ",", "1.1017678834773896`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4892046732051034`", ",", "1.1027256368547755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4992046732051032`", ",", "1.1035728474722297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5092046732051034`", ",", "1.104313137041547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5192046732051032`", ",", "1.1049504559113843`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5292046732051034`", ",", "1.1054890202074856`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5392046732051032`", ",", "1.1059332485128748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5492046732051035`", ",", "1.1062876986918075`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5592046732051033`", ",", "1.1065570054161338`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5692046732051035`", ",", "1.1067458189034056`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5792046732051033`", ",", "1.1068587453243923`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5892046732051035`", ",", "1.1069002892852973`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5992046732051033`", ",", "1.106874798738371`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6092046732051035`", ",", "1.1067864126251716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6192046732051033`", ",", "1.106639011510518`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6292046732051035`", ",", "1.1064361714231497`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6392046732051033`", ",", "1.1061811210819488`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6492046732051036`", ",", "1.1058767026547671`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6592046732051033`", ",", "1.1055253361706787`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6692046732051036`", ",", "1.1051289876859314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6792046732051034`", ",", "1.10468914128889`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6892046732051036`", ",", "1.104206775019467`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6992046732051034`", ",", "1.103682340773572`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7092046732051036`", ",", "1.1031157482622984`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7192046732051034`", ",", "1.1025063530982084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7292046732051036`", ",", "1.1018529490863391`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7392046732051034`", ",", "1.1011537648045282`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7492046732051032`", ",", "1.1004064645652467`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7592046732051034`", ",", "1.0996081538584317`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7692046732051032`", ",", "1.098755389380522`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7792046732051034`", ",", "1.097844193758044`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7892046732051032`", ",", "1.096870075073423`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7992046732051035`", ",", "1.0958280512951544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8092046732051033`", ",", "1.094712679702921`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8192046732051035`", ",", "1.0935180913798095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8292046732051033`", ",", "1.0922380308174175`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8392046732051035`", ",", "1.0908659006447983`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8492046732051033`", ",", "1.0893948114482934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8592046732051035`", ",", "1.0878176365959589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8692046732051033`", ",", "1.0861270719177767`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8792046732051035`", ",", "1.08431570002121`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8892046732051033`", ",", "1.0823760589418339`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8992046732051036`", ",", "1.0803007147418409`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9092046732051033`", ",", "1.0780823375765767`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9192046732051036`", ",", "1.0757137806531496`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9292046732051034`", ",", "1.073188161407661`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9392046732051036`", ",", "1.0704989441317416`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9492046732051034`", ",", "1.0676400231877865`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9592046732051036`", ",", "1.064605805868979`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9692046732051034`", ",", "1.0613912938883632`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9792046732051036`", ",", "1.057992162424272`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9892046732051034`", ",", "1.0544048356108748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9992046732051032`", ",", "1.0506265573453588`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0092046732051034`", ",", "1.0466554562900783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0192046732051032`", ",", "1.0424906039808042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0292046732051034`", ",", "1.0381320650122159`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0392046732051032`", ",", "1.0335809383594303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0492046732051035`", ",", "1.028839389008853`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0592046732051033`", ",", "1.0239106692114932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0692046732051035`", ",", "1.0187991288340776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0792046732051033`", ",", "1.0135102144645922`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0892046732051035`", ",", "1.0080504571240927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0992046732051033`", ",", "1.002427448641026`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1092046732051035`", ",", "0.9966498069517024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1192046732051033`", ",", "0.9907271307949741`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1292046732051035`", ",", "0.9846699444645388`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1392046732051033`", ",", "0.9784896334626484`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1492046732051036`", ",", "0.9721983720590578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1592046732051033`", ",", "0.9658090438941697`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1692046732051036`", ",", "0.9593351568717483`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1792046732051034`", ",", "0.9527907536619119`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1892046732051036`", ",", "0.9461903191775899`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1992046732051034`", ",", "0.9395486863973407`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2092046732051036`", ",", "0.9328809418850655`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2192046732051034`", ",", "0.9262023323048322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2292046732051036`", ",", "0.9195281731495748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2392046732051034`", ",", "0.9128737607996743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2492046732051032`", ",", "0.9062542889054016`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2592046732051034`", ",", "0.8996847699507418`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2692046732051032`", ",", "0.8931799627097365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2792046732051034`", ",", "0.8867543061549479`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2892046732051032`", ",", "0.8804218602254086`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2992046732051035`", ",", "0.8741962537123972`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3092046732051033`", ",", "0.8680906393792834`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3192046732051035`", ",", "0.8621176562992169`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3292046732051033`", ",", "0.8562893992742782`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3392046732051035`", ",", "0.8506173950931242`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3492046732051033`", ",", "0.8451125852926699`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3592046732051035`", ",", "0.8397853150130538`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3692046732051033`", ",", "0.8346453274743552`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3792046732051035`", ",", "0.8297017635575502`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3892046732051033`", ",", "0.8249631659403822`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3992046732051036`", ",", "0.8204374872199198`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4092046732051033`", ",", "0.8161321014464857`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4192046732051036`", ",", "0.8120538184966473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4292046732051034`", ",", "0.8082089007249378`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4392046732051036`", ",", "0.8046030813530987`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4492046732051034`", ",", "0.8012415840807536`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4592046732051036`", ",", "0.7981291434310019`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4692046732051034`", ",", "0.7952700253773761`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4792046732051036`", ",", "0.7926680478337257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4892046732051034`", ",", "0.7903266006251217`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4992046732051036`", ",", "0.7882486645947884`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5092046732051034`", ",", "0.7864368295390306`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5192046732051032`", ",", "0.7848933106984027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5292046732051034`", ",", "0.7836199635687873`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5392046732051032`", ",", "0.7826182968303427`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5492046732051035`", ",", "0.7818894832253752`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5592046732051033`", ",", "0.781434368248055`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5692046732051035`", ",", "0.7812534765396881`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8010656003576736`*^9, 3.80106785660071*^9, 
  3.801068379405231*^9, 3.801068701559821*^9, 3.8010692154248257`*^9},
 CellLabel->
  "Out[414]=",ExpressionUUID->"cfb6665a-1057-408f-98e3-620e9eff259b"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"59672d29-dccf-41bf-8d1f-2d8d5e25a885"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "r1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r1", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rate_", ",", "V_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt", ",", 
       RowBox[{"L", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"kx", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"ky", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"kz", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], "  ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "<", "0"}],
         ",", 
        RowBox[{"kt", "=", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Im", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}], ",", 
        RowBox[{"kt", "=", 
         RowBox[{
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Re", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Chop", "[", 
       RowBox[{"rp1", "[", 
        RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt"}], "]"}], "]"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "r2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r2", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rate_", ",", "V_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt", ",", 
       RowBox[{"L", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"kx", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"ky", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"kz", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], "  ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "<", "0"}],
         ",", 
        RowBox[{"kt", "=", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Im", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}], ",", 
        RowBox[{"kt", "=", 
         RowBox[{
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Re", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Chop", "[", 
       RowBox[{"rp2", "[", 
        RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt"}], "]"}], "]"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "t1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t1", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_", ",", "rate_", ",", "V_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt", ",", 
       RowBox[{"L", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"kx", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"ky", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ";", 
      RowBox[{"kz", "=", 
       RowBox[{
        SqrtBox[
         RowBox[{"rate", " ", "V"}]], " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SqrtBox["rate"], "  ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}], "<", "0"}],
         ",", 
        RowBox[{"kt", "=", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Im", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}], ",", 
        RowBox[{"kt", "=", 
         RowBox[{
          SqrtBox["V"], 
          RowBox[{"Abs", "[", 
           RowBox[{"Re", "[", 
            SqrtBox[
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"rate", "-", "1"}], "  ", "]"}], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SqrtBox["rate"], "  ", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "2"]}]], "]"}],
            "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Chop", "[", 
       RowBox[{"tp1", "[", 
        RowBox[{"kx", ",", "ky", ",", "kz", ",", "kt"}], "]"}], "]"}]}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7961973891226273`*^9, 3.796197472105633*^9}, {
   3.796198284289423*^9, 3.796198312292204*^9}, 3.796199333850669*^9, {
   3.7962124510082207`*^9, 3.796212457575987*^9}, {3.7962275154792423`*^9, 
   3.796227611552404*^9}, {3.7962277422708607`*^9, 3.7962277496345577`*^9}, {
   3.796227808920418*^9, 3.7962278101403522`*^9}, {3.796227873943416*^9, 
   3.796227877844861*^9}, {3.796227934716772*^9, 3.796227935694875*^9}, {
   3.796233908098174*^9, 3.7962339127331123`*^9}, {3.796274682439995*^9, 
   3.79627468616908*^9}, {3.7962782443174543`*^9, 3.796278268149461*^9}, {
   3.801040252381048*^9, 3.8010403620377417`*^9}, {3.801040415073368*^9, 
   3.801040443047524*^9}, {3.8010408749243917`*^9, 3.8010408784795856`*^9}, {
   3.801042738925599*^9, 3.801042808935896*^9}, {3.8010470032999277`*^9, 
   3.801047078973702*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"310d7052-98ab-4f7c-aa95-8083df4833c0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x1", "=", 
   RowBox[{"r1", "[", 
    RowBox[{"2.7", ",", 
     RowBox[{"-", "0.7"}], ",", "0.5", ",", "20"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x2", "=", 
   RowBox[{"r2", "[", 
    RowBox[{"2.7", ",", 
     RowBox[{"-", "0.7"}], ",", "0.5", ",", "20"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x3", "=", 
   RowBox[{"t1", "[", 
    RowBox[{"2.7", ",", 
     RowBox[{"-", "0.7"}], ",", "0.5", ",", "20"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Abs", "[", "x1", "]"}], "^", "2"}], "+", 
  RowBox[{
   RowBox[{"Abs", "[", "x2", "]"}], "^", "2"}], "+", 
  RowBox[{
   RowBox[{"Abs", "[", "x3", "]"}], "^", "2"}]}]}], "Input",
 CellChangeTimes->{{3.79622783836546*^9, 3.796227851144784*^9}, {
  3.796286899592469*^9, 3.796286967502963*^9}, {3.79628699926248*^9, 
  3.7962870005761013`*^9}, {3.796360062808713*^9, 3.796360093125021*^9}, {
  3.801040330052462*^9, 3.8010403365433807`*^9}, {3.801040754832526*^9, 
  3.8010408118952847`*^9}, {3.801040894324078*^9, 3.8010408986851683`*^9}, {
  3.801041003641024*^9, 3.8010410039946737`*^9}, {3.801041640816826*^9, 
  3.801041651710766*^9}, {3.801042945577766*^9, 3.801043027816371*^9}, {
  3.801043062166375*^9, 3.801043072573823*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"bf6b9b7b-269c-4b41-b7cd-dc6f23e4972f"],

Cell[BoxData["1.0000000000000018`"], "Output",
 CellChangeTimes->{
  3.8010414472444687`*^9, 3.801041652432403*^9, {3.8010430499362907`*^9, 
   3.8010430732869377`*^9}, 3.8010489600375633`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"cff8aec8-d098-4b0b-abcc-3d38e6f33d91"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"37fc9660-9991-4003-9831-d120e55adefd"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   RowBox[{"tab1", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"t1", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
          "]"}], "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", 
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.801042119177602*^9, 3.801042156620036*^9}, {
  3.8010428652066803`*^9, 3.801042869303441*^9}, {3.8010434333376226`*^9, 
  3.801043434273975*^9}, {3.8010435038208838`*^9, 3.801043507442246*^9}, {
  3.801049265233343*^9, 3.801049268983706*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"dc80e2bf-c156-4fb2-9b93-33f3211c6f61"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListDensityPlot", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"tab1", ",", "1"}], "]"}], ",", " ", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}],
      ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", " ", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<T for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}]}], 
  RowBox[{"(*", 
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"tab1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<T\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", " ", 
       RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}], 
     ",", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], 
     RowBox[{"(*", 
      RowBox[{",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<DarkMesh\>\""}]}], "*)"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", 
        RowBox[{"Darker", "[", "Gray", "]"}], ",", "12"}], "]"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2 m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d1.jpg\>\"", ",", "p1"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8010434528884993`*^9, 3.801043456343238*^9}, {
  3.80104410032917*^9, 3.8010441400640697`*^9}, {3.801044749348618*^9, 
  3.80104476083072*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"f71620ef-52a3-4e0b-b4b4-a229baa9ffac"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd1l0IJWUdx/HNnjNnBBH1IrwwchcRogy7WCwSTukKhUhSroGRmBWUiYIU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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxdnHe8z+X7x9+jr6hE2YSKY++DZFYcO9mbCtmblJ3skT3LqOxNVghli+ys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           "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["

1:eJx8m2k01P8f9kmWiFaSkLTLkjVEl0ShlBRpE1FCEclWZE8SpWwl2aKFiDB2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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 18],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"T for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.3 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.101}, {-1.5707963267948966`, 
      1.5292036732051035`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwtlnk4Vev7xmUopXBCUVHRIJEGVMItCYmUI1SKRJpDitMxhyIl6iREFIqE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              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -180.}, {7.5, 180.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -180.}, 
                    Offset[{4., 0}, {7.5, -180.}]}, {{
                    7.5, -110.90211132437621`}, 
                    Offset[{4., 0}, {7.5, -110.90211132437621`}]}, {{
                    7.5, -41.8042226487524}, 
                    Offset[{4., 0}, {7.5, -41.8042226487524}]}, {{7.5, 
                    27.2936660268714}, 
                    Offset[{4., 0}, {7.5, 27.2936660268714}]}, {{7.5, 
                    96.3915547024952}, 
                    Offset[{4., 0}, {7.5, 96.3915547024952}]}, {{7.5, 
                    165.489443378119}, 
                    Offset[{4., 0}, {7.5, 165.489443378119}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -166.18042226487523`}, 
                    Offset[{2.5, 0.}, {7.5, -166.18042226487523`}]}, {{
                    7.5, -152.36084452975047`}, 
                    Offset[{2.5, 0.}, {7.5, -152.36084452975047`}]}, {{
                    7.5, -138.54126679462573`}, 
                    Offset[{2.5, 0.}, {7.5, -138.54126679462573`}]}, {{
                    7.5, -124.72168905950096`}, 
                    Offset[{2.5, 0.}, {7.5, -124.72168905950096`}]}, {{
                    7.5, -97.08253358925145}, 
                    Offset[{2.5, 0.}, {7.5, -97.08253358925145}]}, {{
                    7.5, -83.26295585412667}, 
                    Offset[{2.5, 0.}, {7.5, -83.26295585412667}]}, {{
                    7.5, -69.44337811900192}, 
                    Offset[{2.5, 0.}, {7.5, -69.44337811900192}]}, {{
                    7.5, -55.62380038387717}, 
                    Offset[{2.5, 0.}, {7.5, -55.62380038387717}]}, {{
                    7.5, -27.984644913627637`}, 
                    Offset[{2.5, 0.}, {7.5, -27.984644913627637`}]}, {{
                    7.5, -14.165067178502898`}, 
                    Offset[{2.5, 0.}, {7.5, -14.165067178502898`}]}, {{
                    7.5, -0.34548944337810483`}, 
                    Offset[{2.5, 0.}, {7.5, -0.34548944337810483`}]}, {{7.5, 
                    13.47408829174666}, 
                    Offset[{2.5, 0.}, {7.5, 13.47408829174666}]}, {{7.5, 
                    41.113243761996166`}, 
                    Offset[{2.5, 0.}, {7.5, 41.113243761996166`}]}, {{7.5, 
                    54.932821497120926`}, 
                    Offset[{2.5, 0.}, {7.5, 54.932821497120926`}]}, {{7.5, 
                    68.75239923224566}, 
                    Offset[{2.5, 0.}, {7.5, 68.75239923224566}]}, {{7.5, 
                    82.57197696737046}, 
                    Offset[{2.5, 0.}, {7.5, 82.57197696737046}]}, {{7.5, 
                    110.21113243761994`}, 
                    Offset[{2.5, 0.}, {7.5, 110.21113243761994`}]}, {{7.5, 
                    124.03071017274473`}, 
                    Offset[{2.5, 0.}, {7.5, 124.03071017274473`}]}, {{7.5, 
                    137.85028790786947`}, 
                    Offset[{2.5, 0.}, {7.5, 137.85028790786947`}]}, {{7.5, 
                    151.6698656429942}, 
                    Offset[{2.5, 0.}, {7.5, 151.6698656429942}]}, {{7.5, 
                    179.3090211132438}, 
                    Offset[{2.5, 0.}, {7.5, 179.3090211132438}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -180.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -110.90211132437621`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -41.8042226487524}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.3\"", 0.3, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 27.2936660268714}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.4\"", 0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 96.3915547024952}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 165.489443378119}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           18], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.5209348046868849`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "18"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.801043865252387*^9, 3.80104414092715*^9, {3.801044822126978*^9, 
   3.801044842784287*^9}, 3.8010492571128683`*^9, 3.8010499711403112`*^9, 
   3.801050135844681*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"3bc70d0b-73f7-47c9-ac40-088eeeb48ff2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{"tab2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "10"}], "]"}], 
         "]"}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p2", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"tab1", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<T for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.5 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d2.jpg\>\"", ",", "p2"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8010421816418743`*^9, 3.8010422043659782`*^9}, {
   3.801042460985865*^9, 3.8010424617883883`*^9}, 3.8010431431177673`*^9, 
   3.80104321640735*^9, {3.801043585127363*^9, 3.801043609286953*^9}, {
   3.8010441953727283`*^9, 3.801044204728451*^9}, {3.801044315342732*^9, 
   3.801044318637746*^9}, 3.801044428303883*^9, {3.801044726991111*^9, 
   3.801044732572226*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"99b0847e-0c31-4672-8f10-5c736c197586"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 163, 34, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049280120481*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"9ef3612d-1f11-4492-bdc2-bc658bd75f1b"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 163, 35, 
   23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049280286579*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"b4f6b262-c0a9-49b4-b7c7-601b1d952cf8"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 163, 36, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049280303906*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"08576f99-c6db-4a6c-a655-942a708b7804"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 163, 37, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8010492803120403`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"9b834bf6-8525-4e3b-b4ee-72b7c70f321a"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Power\\\", \\\"::\\\", \
\\\"infy\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 163, 38, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8010492803211927`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"a7671698-b930-4d40-a9af-e6aecae63a57"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 163, 39, 
   23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049280329897*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"f121a48c-4500-4b01-8939-d6b4cb55727d"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 163, 40, 
   23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8010492804398212`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"dc515130-0769-4a2b-9bd8-cf670978216d"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Infinity\\\", \
\\\"::\\\", \\\"indet\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 163, 41, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049280537203*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"bc791873-e0e8-49d6-ba20-654d0ffa8fc6"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd2H+MROtd1/HrM895zkOC0DaREFIjvSKJURT+aJDYZGt7MZqGiMJFg4FU
1ASxAUPUWyMhFo1cJCQQQP7gl5AQ4EKINoixraUJSMAotghILb2su6w705md
3dk958yZmTMzBnLez+a8/5p8cpLv89f7j3m95eu+6W/8/fDCCy+87zNfeOEP
foef3vzGl33dl1989he89JWHt+x+kf2ud7/y7X/u5b7sb/3e1z7wd17dlv3+
X/nk3fd9sCv7ZveGt/zquv3F6b1W9xrde9K9R93b6N5G9x7KHj7/5X/yS2+4
L/vvftcHP/GnX7kr+9ee3vKO7/7ksuwv/OpXf6p756fK/rcfWX/G17w2171b
3bvRvWvdu9K9y7L7L3vtU//6La+X/cuf88p/+or1/yn7u2/f+a8+94P/u+x3
//wb/vrdt/9m2X/2fZ/84x/4yo+V/fCDX/lbf/Sd/73sV9+6/saf/N3/Wvbb
f+Qz3/htqw+X/S8+9o6X/uOfeH/ZH3nT73zyx971/c/fP/dvv/w9tz98Ue5/
35988T/85Z8v+/IL37v98Hd8pOy3/8DrX/OnHn6l7J86vvTL3/lV/6Ps/P6X
/9g/e/1jZb/t5tW/8rNv/K2y/9Fnf+if/95Lv1P2v3vX/c+96b2fKPt3vvXF
qy/9mdfLjh9/7d+87f6y7B/65pc+77dfvSr7L3z66//lm178/bI/+hOv/M1P
+9BN2e+5eOPmx1++1b358/t/eO9TurfSvTvduy/7297z8pf+yCsPZX/5l7z4
pn/40qbsN6f717/4jY9lz3/jgz8TX3/ev/Cjr773Y6896V6je63udbrX6d5W
9/qLT33+F+WfffNrpXc2vbPpnU3vbHqf3mt1r9G9J9171L2N7m1076FsemfT
O5ve2fTOpvfpvVvdu9G9a9270r3LsumdTe9semfTO5ve2fTOpnc2vbPpnU3v
5fvYe7k/9s6m93J/7J1N72x6Z9M7m97Z9M6mdza9s+mdTe9semfT+/Te/Pn9
sffpvZXu3enefdn0zqZ3Nr2z6Z1N79N7je61utfpXqd7W93rL97x7puPvviJ
/1x6Z9M7m97Z9M6m9+m9Vvca3XvSvUfd2+jeRvceyqZ3Nr2z6Z1N72x6n967
1b0b3bvWvSvduyyb3tn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9F6+j72X+2PvbHov
98fe2fTOpnc2vbPpnU3vbHpn0zub3tn0zqZ3Nr1P782f3x97n95b6d6d7t2X
Te9semfTO5ve2fQ+vdfoXqt7ne51urfVvf7i1c/6+K9vv+KXSu9semfTO5ve
2fQ+vdfqXqN7T7r3qHsb3dvo3kPZ9M6mdza9s+mdTe/Te7e6d6N717p3pXuX
ZdM7m97Z9M6mdza9s+mdTe9semfTO5vey/ex93J/7J1N7+X+2Dub3tn0zqZ3
Nr2z6Z1N72x6Z9M7m97Z9M6m9+m9+fP7Y+/Teyvdu9O9+7LpnU3vbHpn0zub
3qf3Gt1rda/TvU73trrXX6y/5eKtX/uBXyu9s+mdTe9semfT+/Req3uN7j3p
3qPubXRvo3sPZdM7m97Z9M6mdza9T+/d6t6N7l3r3pXuXZZN72x6Z9M7m97Z
9M6mdza9s+mdTe9sei/fx97L/bF3Nr2X+2PvbHpn0zub3tn0zqZ3Nr2z6Z1N
72x6Z9M7m96n9+bP74+9T++tdO9O9+7Lpnc2vbPpnU3vbHqf3mt0r9W9Tvc6
3dvqXn/x2h/8nX/DR0vvbHpn0zub3tn0Pr3X6l6je0+696h7G93b6N5D2fTO
pnc2vbPpnU3v03u3uneje9e6d6V7l2XTO5ve2fTOpnc2vbPpnU3vbHpn0zub
3sv3sfdyf+ydTe/l/tg7m97Z9M6mdza9s+mdTe9semfTO5ve2fTOpvfpvfnz
+2Pv03sr3bvTvfuy6Z1N72x6Z9M7m96n9xrda3Wv071O97a611+8/nnpfd//
zv9VemfTO5ve2fTOpvfpvVb3Gt170r1H3dvo3kb3Hsqmdza9s+mdTe9sep/e
u9W9G9271r0r3bssm97Z9M6mdza9s+mdTe9semfTO5ve2fRevo+9l/tj72x6
L/fH3tn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9M6mdza9T+/Nn98fe5/eW+nene7d
l03vbHpn0zub3tn0Pr3X6F6re53udbq31b3+4o1/60t+/lf/6W+X3tn0zqZ3
Nr2z6X16r9W9RveedO9R9za6t9G9h7LpnU3vbHpn0zub3qf3bnXvRveude9K
9y7Lpnc2vbPpnU3vbHpn0zub3tn0zqZ3Nr2X72Pv5f7YO5vey/2xdza9s+md
Te9semfTO5ve2fTOpnc2vbPpnU3v03vz5/fH3qf3Vrp3p3v3ZdM7m97Z9M6m
dza9T+81utfqXqd7ne5tda+/eOk733N7+OmPl97Z9M6mdza9s+l9eq/VvUb3
nnTvUfc2urfRvYey6Z1N72x6Z9M7m96n925170b3rnXvSvcuy6Z3Nr2z6Z1N
72x6Z9M7m97Z9M6mdza9l+9j7+X+2Dub3sv9sXc2vbPpnU3vbHpn0zub3tn0
zqZ3Nr2z6Z1N79N78+f3x96n91a6d6d792XTO5ve2fTOpnc2vU/vNbrX6l6n
e53ubXWvv3jlwz/6OX/+k79bemfTO5ve2fTOpvfpvVb3Gt170r1H3dvo3kb3
Hsqmdza9s+mdTe9sep/eu9W9G9271r0r3bssm97Z9M6mdza9s+mdTe9semfT
O5ve2fRevo+9l/tj72x6L/fH3tn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9M6mdza9
T+/Nn98fe5/eW+nene7dl03vbHpn0zub3tn0Pr3X6F6re53udbq31b3+4rfe
u/j8L8qXpXc2vbPpnU3vbHqf3mt1r9G9J9171L2N7m1076FsemfTO5ve2fTO
pvfpvVvdu9G9a9270r3LsumdTe9semfTO5ve2fTOpnc2vbPpnU3v5fvYe7k/
9s6m93J/7J1N72x6Z9M7m97Z9M6mdza9s+mdTe9semfT+/Te/Pn9sffpvZXu
3enefdn0zqZ3Nr2z6Z1N79N7je61utfpXqd7W93rL77pTf/yI//tx/5v6Z1N
72x6Z9M7m96n91rda3TvSfcedW+jexvdeyib3tn0zqZ3Nr2z6X1671b3bnTv
WveudO+ybHpn0zub3tn0zqZ3Nr2z6Z1N72x6Z9N7+T72Xu6PvbPpvdwfe2fT
O5ve2fTOpnc2vbPpnU3vbHpn0zub3tn0Pr03f35/7H16b6V7d7p3Xza9s+md
Te9semfT+/Reo3ut7nW61+neVvf6i0/72Td/9d/7i9eldza9s+mdTe9sep/e
a3Wv0b0n3XvUvY3ubXTvoWx6Z9M7m97Z9M6m9+m9W9270b1r3bvSvcuy6Z1N
72x6Z9M7m97Z9M6mdza9s+mdTe/l+9h7uT/2zqb3cn/snU3vbHpn0zub3tn0
zqZ3Nr2z6Z1N72x6Z9P79N78+f2x9+m9le7d6d592fTOpnc2vbPpnU3v03uN
7rW61+lep3tb3esvfvxLf+Hp+Ju/X3pn0zub3tn0zqb36b1W9xrde9K9R93b
6N5G9x7Kpnc2vbPpnU3vbHqf3rvVvRvdu9a9K927LJve2fTOpnc2vbPpnU3v
bHpn0zub3tn0Xr6PvZf7Y+9sei/3x97Z9M6mdza9s+mdTe9semfTO5ve2fTO
pnc2vU/vzZ/fH3uf3lvp3p3u3ZdN72x6Z9M7m97Z9D691+heq3ud7nW6t9W9
/uJtv/fXvusHvvH/ld7Z9M6mdza9s+l9eq/VvUb3nnTvUfc2urfRvYey6Z1N
72x6Z9M7m96n925170b3rnXvSvcuy6Z3Nr2z6Z1N72x6Z9M7m97Z9M6mdza9
l+9j7+X+2Dub3sv9sXc2vbPpnU3vbHpn0zub3tn0zqZ3Nr2z6Z1N79N78+f3
x96n91a6d6d792XTO5ve2fTOpnc2vU/vNbrX6l6ne53ubXUPr5vL6+byurm8
bi6vm8vr5vK6ubxuLq+by+vm8rq5vG4ur5vL6+byurm8bi6vm8vr5vK6ubxu
Lq+by+vm8rq5vG4ur5vL6+byurm8bi6vm8vr5vK6ubxuLq+by+vm8rq5vG4u
r5vL6+byurm8bi6vm8vr5vK6ubxuLq+by+vm8rq5vG4ur5vL6+byurm8bi6v
m8vr5vK6ubxuLq+by+vm8rq5vG4ur5vL6+byurm8biGvW8jrFvK6hbxuIa9b
yOsW8rqFvG4hr1vI6xbyuoW8biGvW8jrFvK6hbxuIa9byOsW8rqFvG4hr1vI
6xbyuoW8biGvW8jrFvK6hbxuIa9byOsW8rqFvG4hr1vI6xbyuoW8biGvW8jr
FvK6hbxuIa9byOsW8rqFvG4hr1vI6xbyuoW8biGvW8jrFvK6hbxuIa9byOsW
8rqFvG4hr1vI6xbyuoW8biGvW8jrFvK6pbxuKa9byuuW8rqlvG4pr1vK65by
uqW8bimvW8rrlvK6pbxuKa9byuuW8rqlvG4pr1vK65byuqW8bimvW8rrlvK6
pbxuKa9byuuW8rqlvG4pr1vK65byuqW8bimvW8rrlvK6pbxuKa9byuuW8rql
vG4pr1vK65byuqW8bimvW8rrlvK6pbxuKa9byuuW8rqlvG4pr1vK65byuqW8
bimvW8rrlvK6pbxuKa9byutW8rqVvG4lr1vJ61byupW8biWvW8nrVvK6lbxu
Ja9byetW8rqVvG4lr1vJ61byupW8biWvW8nrVvK6lbxuJa9byetW8rqVvG4l
r1vJ61byupW8biWvW8nrVvK6lbxuJa9byetW8rqVvG4lr1vJ61byupW8biWv
W8nrVvK6lbxuJa9byetW8rqVvG4lr1vJ61byupW8biWvW8nrVvK6lbxuJa9b
yetW8rqVvG4lr1vL69byurW8bi2vW8vr1vK6tbxuLa9by+vW8rq1vG4tr1vL
69byurW8bi2vW8vr1vK6tbxuLa9by+vW8rq1vG4tr1vL69byurW8bi2vW8vr
1vK6tbxuLa9by+vW8rq1vG4tr1vL69byurW8bi2vW8vr1vK6tbxuLa9by+vW
8rq1vG4tr1vL69byurW8bi2vW8vr1vK6tbxuLa9by+vW8rq1vG4tr1vL69by
unXp/Rs+9I+/97PjQ+mdTe9semfTO5vep/da3Wt070n3HnVvo3sb3Xsom97Z
9M6mdza9s+l9eu9W925071r3rnTvsmx6Z9M7m97Z9M6mdza9s+mdTe9semfT
e/k+9l7uj72z6b3cH3tn0zub3tn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9D69N39+
f+x9em+le3e6d182vbPpnU3vbHpn0/v0XqN7re51utfp3lb3+osv/o6/9O6b
jz73zqZ3Nr2z6Z1N79N7re41uveke4+6t9G9je49lE3vbHpn0zub3tn0Pr13
q3s3unete1e6d1k2vbPpnU3vbHpn0zub3tn0zqZ3Nr2z6b18H3sv98fe2fRe
7o+9s+mdTe9semfTO5ve2fTOpnc2vbPpnU3vbHqf3ps/vz/2Pr230r073bsv
m97Z9M6mdza9s+l9eq/RvVb3Ot3rdG+re/1F/KrP+IL3//Cm9M6mdza9s+md
Te/Te63uNbr3pHuPurfRvY3uPZRN72x6Z9M7m97Z9D69d6t7N7p3rXtXundZ
Nr2z6Z1N72x6Z9M7m97Z9M6mdza9s+m9fB97L/fH3tn0Xu6PvbPpnU3vbHpn
0zub3tn0zqZ3Nr2z6Z1N72x6n96bP78/9j69t9K9O927L5ve2fTOpnc2vbPp
fXqv0b1W9zrd63Rvq3v9xcde/MTuW7/hsfTOpnc2vbPpnU3v03ut7jW696R7
j7q30b2N7j2UTe9semfTO5ve2fQ+vXereze6d617V7p3WTa9s+mdTe9semfT
O5ve2fTOpnc2vbPpvXwfey/3x97Z9F7uj72z6Z1N72x6Z9M7m97Z9M6mdza9
s+mdTe9sep/emz+/P/Y+vbfSvTvduy+b3tn0zqZ3Nr2z6X16r9G9Vvc63et0
b6t7/cWP3P/kr7zri59K72x6Z9M7m97Z9D691+peo3tPuveoexvd2+jeQ9n0
zqZ3Nr2z6Z1N79N7t7p3o3vXunele5dl0zub3tn0zqZ3Nr2z6Z1N72x6Z9M7
m97L97H3cn/snU3v5f7YO5ve2fTOpnc2vbPpnU3vbHpn0zub3tn0zqb36b35
8/tj79N7K9270737sumdTe9semfTO5vep/ca3Wt1r9O9Tve2uofXNfK6Rl7X
yOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsa
eV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0j
r2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vk
dY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28
rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHX
NfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6
Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7XyOsaeV0jr2vkdY28rpHXNfK6Rl7X
yOsaeV0jr2vkda28rpXXtfK6Vl7XyutaeV0rr2vlda28rpXXtfK6Vl7Xyuta
eV0rr2vlda28rpXXtfK6Vl7XyutaeV0rr2vlda28rpXXtfK6Vl7XyutaeV0r
r2vlda28rpXXtfK6Vl7XyutaeV0rr2vlda28rpXXtfK6Vl7XyutaeV0rr2vl
da28rpXXtfK6Vl7XyutaeV0rr2vlda28rpXXtfK6Vl7XyutaeV0rr+vkdZ28
rpPXdfK6Tl7Xyes6eV0nr+vkdZ28rpPXdfK6Tl7Xyes6eV0nr+vkdZ28rpPX
dfK6Tl7Xyes6eV0nr+vkdZ28rpPXdfK6Tl7Xyes6eV0nr+vkdZ28rpPXdfK6
Tl7Xyes6eV0nr+vkdZ28rpPXdfK6Tl7Xyes6eV0nr+vkdZ28rpPXdfK6Tl7X
yes6eV0nr+vkdZ28rpPXdfK6Tl7Xyes6ed1WXreV123ldVt53VZet5XXbeV1
W3ndVl63lddt5XVbed1WXreV123ldVt53VZet5XXbeV1W3ndVl63lddt5XVb
ed1WXreV123ldVt53VZet5XXbeV1W3ndVl63lddt5XVbed1WXreV123ldVt5
3VZet5XXbeV1W3ndVl63lddt5XVbed1WXreV123ldVt53VZet5XXbeV1W3nd
Vl63lddt5XVbed1WXreV123ldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX
9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6
Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7X
y+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6
eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0v
r+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vl
db28rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6eV0vr+vldb28
rpfX9fK6Xl7Xy+t6eV0vr+vldb28rpfX9fK6Xl7Xy+t6ed1OXreT1+3kdTt5
3U5et5PX7eR1O3ndTl63k9ft5HU7ed1OXreT1+3kdTt53U5et5PX7eR1O3nd
Tl63k9ft5HU7ed1OXreT1+3kdTt53U5et5PX7eR1O3ndTl63k9ft5HU7ed1O
XreT1+3kdTt53U5et5PX7eR1O3ndTl63k9ft5HU7ed1OXreT1+3kdTt53U5e
t5PX7eR1O3ndTl63k9ft5HU7ed1OXreT1+3kdXt53V5et5fX7eV1e3ndXl63
l9ft5XV7ed1eXreX1+3ldXt53V5et5fX7eV1e3ndXl63l9ft5XV7ed1eXreX
1+3ldXt53V5et5fX7eV1e3ndXl63l9ft5XV7ed1eXreX1+3ldXt53V5et5fX
7eV1e3ndXl63l9ft5XV7ed1eXreX1+3ldXt53V5et5fX7eV1e3ndXl63l9ft
5XV7ed1eXreX1+3ldXt53V5et5fXHeR1B3ndQV53kNcd5HUHed1BXneQ1x3k
dQd53UFed5DXHeR1B3ndQV53kNcd5HUHed1BXneQ1x3kdQd53UFed5DXHeR1
B3ndQV53kNcd5HUHed1BXneQ1x3kdQd53UFed5DXHeR1B3ndQV53kNcd5HUH
ed1BXneQ1x3kdQd53UFed5DXHeR1B3ndQV53kNcd5HUHed1BXneQ1x3kdQd5
3UFed5DXHeR1B3ndQV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvk
dYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8
bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDX
DfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6
QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43
yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsG
ed0grxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXDfK6QV43yOsGed0g
rxvkdYO8bpDXDfK6QV43yOsGed0grxvkdYO8bpDXHeV1R3ndUV53lNcd5XVH
ed1RXneU1x3ldUd53VFed5TXHeV1R3ndUV53lNcd5XVHed1RXneU1x3ldUd5
3VFed5TXHeV1R3ndUV53lNcd5XVHed1RXneU1x3ldUd53VFed5TXHeV1R3nd
UV53lNcd5XVHed1RXneU1x3ldUd53VFed5TXHeV1R3ndUV53lNcd5XVHed1R
XneU1x3ldUd53VFed5TXHeV1R3ndUV53kted5HUned1JXneS153kdSd53Ule
d5LXneR1J3ndSV53kted5HUned1JXneS153kdSd53Uled5LXneR1J3ndSV53
kted5HUned1JXneS153kdSd53Uled5LXneR1J3ndSV53kted5HUned1JXneS
153kdSd53Uled5LXneR1J3ndSV53kted5HUned1JXneS153kdSd53Uled5LX
neR1J3ndSV53kted5HUned1ZXneW153ldWd53Vled5bXneV1Z3ndWV53lted
5XVned1ZXneW153ldWd53Vled5bXneV1Z3ndWV53lted5XVned1ZXneW153l
dWd53Vled5bXneV1Z3ndWV53lted5XVned1ZXneW153ldWd53Vled5bXneV1
Z3ndWV53lted5XVned1ZXneW153ldWd53Vled5bXneV1Z3ndWV53lted5XVn
ed1ZXneW151L72/92g/81U8PL7yd3tn0zqZ3Nr2z6X16r9W9RveedO9R9za6
t9G9h7LpnU3vbHpn0zub3qf3bnXvRveude9K9y7Lpnc2vbPpnU3vbHpn0zub
3tn0zqZ3Nr2X72Pv5f7YO5vey/2xdza9s+mdTe9semfTO5ve2fTOpnc2vbPp
nU3v03vz5/fH3qf3Vrp3p3v3ZdM7m97Z9M6mdza9T+81utfqXqd7ne5tda+/
+KFf/tx//81f/9w7m97Z9M6mdza9T++1utfo3pPuPereRvc2uvdQNr2z6Z1N
72x6Z9P79N6t7t3o3rXuXeneZdn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9M6m9/J9
7L3cH3tn03u5P/bOpnc2vbPpnU3vbHpn0zub3tn0zqZ3Nr2z6X16b/78/tj7
9N5K9+50775semfTO5ve2fTOpvfpvUb3Wt3rdK/Tva3u9Rfhz3z7Z3381597
Z9M7m97Z9M6m9+m9Vvca3XvSvUfd2+jeRvceyqZ3Nr2z6Z1N72x6n9671b0b
3bvWvSvduyyb3tn0zqZ3Nr2z6Z1N72x6Z9M7m97Z9F6+j72X+2PvbHov98fe
2fTOpnc2vbPpnU3vbHpn0zub3tn0zqZ3Nr1P782f3x97n95b6d6d7t2XTe9s
emfTO5ve2fQ+vdfoXqt7ne51urfVvf7i67/n7lsu3vpHSu9semfTO5ve2fQ+
vdfqXqN7T7r3qHsb3dvo3kPZ9M6mdza9s+mdTe/Te7e6d6N717p3pXuXZdM7
m97Z9M6mdza9s+mdTe9semfTO5vey/ex93J/7J1N7+X+2Dub3tn0zqZ3Nr2z
6Z1N72x6Z9M7m97Z9M6m9+m9+fP7Y+/Teyvdu9O9+7LpnU3vbHpn0zub3qf3
Gt1rda/TvU73trrXX/zP7Vdc/8QPPvfOpnc2vbPpnU3v03ut7jW696R7j7q3
0b2N7j2UTe9semfTO5ve2fQ+vXereze6d617V7p3WTa9s+mdTe9semfTO5ve
2fTOpnc2vbPpvXwfey/3x97Z9F7uj72z6Z1N72x6Z9M7m97Z9M6mdza9s+md
Te9sep/emz+/P/Y+vbfSvTvduy+b3tn0zqZ3Nr2z6X16r9G9Vvc63et0b6t7
eF2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcFeV2Q1wV5XZDXBXldkNcF
eV2Q1wV5XZDXBXldkNcFeV2Q1wV53XPv/+AP/8/PSu9semfTO5ve2fQ+vdfq
XqN7T7r3qHsb3dvo3kPZ9M6mdza9s+mdTe/Te7e6d6N717p3pXuXZdM7m97Z
9M6mdza9s+mdTe9semfTO5vey/ex93J/7J1N7+X+2Dub3tn0zqZ3Nr2z6Z1N
72x6Z9M7m97Z9M6m9+m9+fP7Y+/Teyvdu9O9+7LpnU3vbHpn0zub3qf3Gt1r
da/TvU73trqH183kdTN53UxeN5PXzeR1M3ndTF43k9fN5HUzed1MXjeT183k
dTN53UxeN5PXzeR1M3ndTF43k9fN5HUzed1MXjeT183kdTN53UxeN5PXzeR1
M3ndTF43k9fN5HUzed1MXjeT183kdTN53UxeN5PXzeR1M3ndTF43k9fN5HUz
ed1MXjeT183kdTN53UxeN5PXzeR1M3ndTF43k9fN5HUzed1MXjeT183kdTN5
3UxeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XVRXhfl
dVFeF+V1UV4X5XVRXhfldVFeF+V1UV4X5XWVvK6S11XyukpeV8nrKnldJa+r
5HWVvK6S11XyukpeV8nrKnldJa+r5HWVvK6S11XyukpeV8nrKnldJa+r5HWV
vK6S11XyukpeV8nrKnldJa+r5HWVvK6S11XyukpeV8nrKnldJa+r5HWVvK6S
11XyukpeV8nrKnldJa+r5HWVvK6S11XyukpeV8nrKnldJa+r5HWVvK6S11Xy
ukpeV8nrKnldJa+r5HWVvK6S11XyukpeV8nrKnldJa+r5HWVvK6S11Xyukpe
V8nrKnldJa+r5HWVvK6S11XyukpeV8nrKnldJa+r5HWVvK6S11XyukpeV8nr
KnldJa+r5HWVvK6S11XyukpeV8nrnntnT72uktdV8rpKXlfJ6yp5XSWvq+R1
lbyuktdV8rpKXlfJ6yp5XSWvq+R1lbyuktdV8rpKXlfJ6yp5XSWvq+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X
5HVJXpfkdUlel+R1SV6X5HVJXpfkdUle99w7e+p1SV6X5HVJXpfkdUlel+R1
SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1
SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1
SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1
SV733Dt76nVJXpfkdUlel+R1SV6X5HVJXpfkdUlel+R1SV6X5HVJXpfkdUle
l+R1SV6X5HVJXpfkdUlel+R1SV5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tq
eV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0t
r6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vl
dbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8
rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX
1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6
Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbX1fK6Wl5X
y+tqeV0tr6vldbW8rpbX1fK6Wl5Xy+tqeV0tr6vldbW8rpbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W12V5XZbXZXldltdleV2W
12V5XZbXZXldltc99/7/AZuhO9U=
     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxMnXX4VdXWtnfHD6TEAkFKpEtCursbpUFKQrq7uxtpEOnuRkAUMLGx4Cgq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           "]]}]}, {}, {}, {}, {}}}, 
     VertexColors -> CompressedData["
1:eJx8l3c41f8f942iVIhKGipKCyVURE8rKpUyWkS+hRIKGZG9M7KJRISSZG/H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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 18],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"T for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.5 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.101}, {-1.5707963267948966`, 
      1.5292036732051035`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwtlnk4Vev7xmUopXBCUVHRIJEGVMItCYmUI1SKRJpDitMxhyIl6iREFIqE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              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -180.}, {7.5, 180.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -180.}, 
                    Offset[{4., 0}, {7.5, -180.}]}, {{
                    7.5, -110.90211132437621`}, 
                    Offset[{4., 0}, {7.5, -110.90211132437621`}]}, {{
                    7.5, -41.8042226487524}, 
                    Offset[{4., 0}, {7.5, -41.8042226487524}]}, {{7.5, 
                    27.2936660268714}, 
                    Offset[{4., 0}, {7.5, 27.2936660268714}]}, {{7.5, 
                    96.3915547024952}, 
                    Offset[{4., 0}, {7.5, 96.3915547024952}]}, {{7.5, 
                    165.489443378119}, 
                    Offset[{4., 0}, {7.5, 165.489443378119}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -166.18042226487523`}, 
                    Offset[{2.5, 0.}, {7.5, -166.18042226487523`}]}, {{
                    7.5, -152.36084452975047`}, 
                    Offset[{2.5, 0.}, {7.5, -152.36084452975047`}]}, {{
                    7.5, -138.54126679462573`}, 
                    Offset[{2.5, 0.}, {7.5, -138.54126679462573`}]}, {{
                    7.5, -124.72168905950096`}, 
                    Offset[{2.5, 0.}, {7.5, -124.72168905950096`}]}, {{
                    7.5, -97.08253358925145}, 
                    Offset[{2.5, 0.}, {7.5, -97.08253358925145}]}, {{
                    7.5, -83.26295585412667}, 
                    Offset[{2.5, 0.}, {7.5, -83.26295585412667}]}, {{
                    7.5, -69.44337811900192}, 
                    Offset[{2.5, 0.}, {7.5, -69.44337811900192}]}, {{
                    7.5, -55.62380038387717}, 
                    Offset[{2.5, 0.}, {7.5, -55.62380038387717}]}, {{
                    7.5, -27.984644913627637`}, 
                    Offset[{2.5, 0.}, {7.5, -27.984644913627637`}]}, {{
                    7.5, -14.165067178502898`}, 
                    Offset[{2.5, 0.}, {7.5, -14.165067178502898`}]}, {{
                    7.5, -0.34548944337810483`}, 
                    Offset[{2.5, 0.}, {7.5, -0.34548944337810483`}]}, {{7.5, 
                    13.47408829174666}, 
                    Offset[{2.5, 0.}, {7.5, 13.47408829174666}]}, {{7.5, 
                    41.113243761996166`}, 
                    Offset[{2.5, 0.}, {7.5, 41.113243761996166`}]}, {{7.5, 
                    54.932821497120926`}, 
                    Offset[{2.5, 0.}, {7.5, 54.932821497120926`}]}, {{7.5, 
                    68.75239923224566}, 
                    Offset[{2.5, 0.}, {7.5, 68.75239923224566}]}, {{7.5, 
                    82.57197696737046}, 
                    Offset[{2.5, 0.}, {7.5, 82.57197696737046}]}, {{7.5, 
                    110.21113243761994`}, 
                    Offset[{2.5, 0.}, {7.5, 110.21113243761994`}]}, {{7.5, 
                    124.03071017274473`}, 
                    Offset[{2.5, 0.}, {7.5, 124.03071017274473`}]}, {{7.5, 
                    137.85028790786947`}, 
                    Offset[{2.5, 0.}, {7.5, 137.85028790786947`}]}, {{7.5, 
                    151.6698656429942}, 
                    Offset[{2.5, 0.}, {7.5, 151.6698656429942}]}, {{7.5, 
                    179.3090211132438}, 
                    Offset[{2.5, 0.}, {7.5, 179.3090211132438}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -180.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -110.90211132437621`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -41.8042226487524}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.3\"", 0.3, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 27.2936660268714}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.4\"", 0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 96.3915547024952}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 165.489443378119}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           18], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.5209474203657334`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "18"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.801042473513174*^9, 3.801044275205131*^9, 
  3.801044410981679*^9, 3.801044819955965*^9, 3.801049353507002*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"a5fb6703-f962-42e4-a03e-9fb56fed5026"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{"tab3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.95", ",", "1"}], "]"}], 
         "]"}], "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p3", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"tab3", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<T for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.95 \!\(\*SubscriptBox[\(V\), \
\(0\)]\)\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d3.jpg\>\"", ",", "p3"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8010421816418743`*^9, 3.8010422043659782`*^9}, {
   3.801042460985865*^9, 3.8010424617883883`*^9}, 3.8010431431177673`*^9, 
   3.80104321640735*^9, {3.801043585127363*^9, 3.801043609286953*^9}, {
   3.8010441953727283`*^9, 3.801044204728451*^9}, {3.801044315342732*^9, 
   3.801044318637746*^9}, 3.801044428303883*^9, {3.801044726991111*^9, 
   3.801044732572226*^9}, {3.801045272687851*^9, 3.801045295958667*^9}, {
   3.801045344145753*^9, 3.80104535732318*^9}, {3.801045489564788*^9, 
   3.8010454994054728`*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"9c11b939-dd5f-4280-98dc-814f488f91e8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd1l0IJWUdx/HNnjNnBBH1IrwwchcRogy7WCwSTukKhUhSroGRmBWUiYIU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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxdnHe8z+X7x9+jr6hE2YSKY++DZFYcO9mbCtmblJ3skT3LqOxNVghli+ys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           "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["

1:eJx8l/c/1f8bxmWXipCUSJKUVUqTrlApaVBRSopIWkJUEiGjkKxElMoeFdl7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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 18],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"T for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.95 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.101}, {-1.5707963267948966`, 
      1.5292036732051035`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwtlnk4Vev7xmUopXBCUVHRIJEGVMItCYmUI1SKRJpDitMxhyIl6iREFIqE
ZCZlnqKMm23bey3btAcyJ1O//b2u3x/v9bx/rLXe672f9Xzue6P9TXNHAT4+
vlreWsRb/9sfOFnitEnvC1Jyz6uv9PCHe0CL/2qvTkROi+rv/VWCAJudYidD
wyEY0eQlnt2JsRjbDcZpJcjuzhBIoEXhyavvHks5nTiGzDmb8yVwzVjteWdV
AmQ/NNzil6cipYev8+aqEixztrrzUicJKYX1N2atqRAKOpHjX/8Zr3dGOpdd
TIFGTe3liTAq7La9Dv/P9zM0R9uvDD7+gLK2aoehKiqKv41df6f+GWzrh7vv
d2XCjFlp2z9PxWrnQ8ZF7GKo73+vGv0zC10j5acZal24JfFsS+OrYvjJ1Ct/
EMjBpYXSkx1Xu9CY28tPWhSj4Td729fVeZgQ+Xq86XUXlE6rM8aXFkOGumxr
y/YC3nslR+s6uxA0H1i0+EsRHAuVNvWjCKJbiw3KxWkg49sjZdyK8DHaeOPv
vz8jWq3wYLEhDVr6W92UtxVh4e4VueWXvmCrXr5WjjcNLwbcj4NeiCSVykdi
JV/xySx3b3oODRMhNcrmTwtRL3tyuUxNKXTPZu9+y6XBbIfMUkejQoyu6AuR
by7DtytZKvEK3XjfdLnPfb4AqxfclirTynHKI1Mx6nQ3Ft8uLA3JKoD2sOAD
9f4K9AemK0SEd8NeWiQu1qkAF+jPFmOkEq5P0+Qe1nSjpOjM3cx1BQhu3BRo
NFOFhfhUmYA/3ZCxTbMsb8pHRkm2gLlgDR6mv5P00qDDjX9+d3tQPtrS9f3P
iNZCujhZ7M51On4kmYqxDuRjNq6Vz1G6Dom1ictuJtKhfCSOMzuSh41hDj43
5Ouxi/Ja6FIXHfe5w9WiyXkw9JmYd1f+hs+98XznVzLADEPixjN5uHEzwNNP
owHGY3Gzp44woLPnia+aeB6e2UrOhug2ov3PyylzXwai2wkbw8pc5Jsl/vPM
+DsurIgZPZrHwNQ/u/afvpuLn+vXzB1T+oGRNVFc/WEGTsj6S11XzQW/tH3R
3xk/oPOsfjxuJYG0r82jPr05kBJPvWut1gTBGGOXtTsICDsoNEZE5UBReGz/
2YIm1CfUDkceIZDUK9YXFpGDUpdpRROVZhR+NB2ctyZA/m0s4/8hB7KSdNXM
F83QMWh9ZW1PQK48wNStJgceueUakoItKKOetvp0lcDp3V/8LjJz0Gqdou1x
swWGN0lR0dsEIhN+51gv5GDn7GN9GrUF9QKXqi55E2gVV2Mby+QiNNbtqK5B
K8xeDHuV3ycg7ntDTlstF4M4bZ74sRUtyrfV5cIJmP58Z65qlgv9HpwSlm2D
Veks1yOaQPA5ZtDGK7l4FbDZ7tqDNtBO+ie2vCFQ1SBbJBGYi9ktIk4/xttg
xxa22fGBgIC29U+h+FxY1o5cV7NtR693mERwLgGkRShMF+Yi62q724u6dlyS
WFXP/ELAc22DFbstF6Kixf/OqVPAffvSX6eWQEHIklDaSC6uZCb42yVQ4KKl
oBnVTGDy98GvjSJ5qDS/H1yxvAOTP1JGx7sI7L7sOfF1C+//mbz2RNGjA/84
7kw51kfgZkeu4qeDefCKNI8MZXZg/neuXcowgfeGozZJNnno3L8vbuRYJ/we
a0sLThMYzN0eHumeBzWabJJFYSeEFCq+n1tEYtOWi5XBEXl44i2Qlr+ZipA8
4/sFy0ic/y/+978f8sDdwMpaF06FqEmTjqQkiTjBLpUbNXkwKm8s8J2jIoKw
mrohS4J6S8rejpmHRMfsr71OXVh1m/6hdguJ1Uyz5+YLeeATjq42aulC9FJH
x007SViYh9Tpy+TjdKpPY5oODXJxnHU++0k8Ka1Y0FDLR66JY5t4Kg1vdru2
duqRaNj5Z/c2s3ys/GlMc5Pqxtbq6YdqJiSWxe93WnslHzfCdzI7fHlcOONz
KOwkCQMxt5gVgfmo27OKrcXthuqI0CzrHIl73unf/7zKx5b22ZF4Kzo+BYRm
6V8i8WVoUGCsMB/+HuQvwXI69slIXHnlQmLORmFfb1s+utdUL1zawUDxh6iN
M3dJ7P929lr7SD72f04TaohiQFdvQ6dFAInL1xfp1KsXQMj23Y7kGQZc9lm2
Tzwg4e3qblzZWADqn4EGNQUCc6Psc+t5zz91H7L84lSIXT/+DVjFm6v7730G
jviQeOd54UIBXxEexIsdmL5BYKWjpLMb79xiv86bn6KKQHd+M9r5jECsXMp0
3G0STUFmnh928/h/cO+7okICih3afrXOJPofVj54W1+M0L/qz8USBD6FNy+d
uEpi9smB/xIcPoNJnpPyWUxC56hThJwTCfHnHxNi5nm+kzVWb6dMolZwbs0R
exKbY7am//e8BOH+Qf565rz+lTx5c+ssCc342MIw1S8YNF+zf5MHCYb7ZuU4
axJmSRLVwTVfAIX0n0JxJK7sKsyu+ZvE7rYKVunOr3g+fjB5oJzEJPuY9vgx
3r0of37qeH3FUHmbTS2LhG8is1LWmIQhVXOqqPYr9J9dlngv1gORcx7HjA6T
aKbdntu3qhQxDvO1oeo9eL56BcVVl4QNI5M/174UY2rhvjfO9GBDU4Jt7AGe
DiRHeE9GKYyENu897teD9yEag9UaJJx7t4hlzpbiVVv+0K63PdDQr3ce28XT
p/+8lIpRGaaSTBIlGnpQOm/7e50KiUDWy7Wpz8pgeoc4PTnWA5O8CT9DRZ5u
XMrGrWQZEg3c/qJIM0FxDl7mqkAienilYqJKOWZXCdfk6zBhryT39KUcT89R
0x0b75bDfCDGO9qBiSFm1tpqGRIZ4w/U4qrKkZKnqu4ZwoRHrGHiKG/uNKfK
NddKVIDvQTnnbCYTAlY05XXiJCqmF3Rf2FbAytrqNdqZeCzukmMgwtN/dr+h
VFoF0hU51hvnmJCpE9Jx4fWZOu9mGjFdAaHf3mIC8r1IvBddFcPjwAW+zL/F
DlfiTO3Kql7DXqhqq5pVzREY5uecCg2vRFZUsmfV9V4UTpVTRn4R8BDaYreU
XomlVzT3vHvai8OZ1nZrxwnwC5+/GKRUBTvNRlZwQS9+XB4aPMzj0qNlL68J
uFchb5l9/FVGL84o+Ls4swg8ENz49KpoNYxDvBWcZ3qRZ6tzaheNgP9CUkFL
UjVoS2OS3aT6IPFyRneskcfVaSXigHYNbgbnbftnZx9u/I+DpQTcxzIWJ7bW
YNHS1jSvo32ok7wl7pZNwJWrprL8Wi2ePRhR9b/Yhy0nVKfV3hK41l/wt5tA
HbYIr/gU5NcH/0ccxmQUgYuEzl1adB0K7m/TePiyD/Tat9W5oQTOU8vj9XfX
w2SJQUFYXh80FztkuPsQsGk1qk6rrQc9yF7rWXMf/tPbELnPlYBlY8OQ5Plv
cFns8+XFUB9GvWnevx0IHK8xl/Sa/gaBoBi9WOF+mBa9uFhoReBoGUWzL6wB
z4XyKxMU+pHyy+LYv8YEDIptzptubYRiYKtRsk4/hNT+0tDSJqCbS97PKWlE
keBofeqpftg5N8jOqxLQzLyYLmv5HaYBK8wy3PpRnBYsVCLP85FUTmvg0Hcw
BJSaP4X1Q5p1eMhbisAq8/z5O3o/4HrP4GR+aj/cNvO3QZiAxPcZ8e2Pf0BQ
4EJHcWU/4ss9/1k0xYC4ifYmRucPRPr7nCkl+mGtNWl0r4sB0VqfvU83N0GJ
/yW9crYfYjnXpYVKGRAxKDM2dGnicSv/fN2qAVSr9A8EJTMgXC54bra4CWaL
2nobdw3AO/lcnnAoA4t1DV0yhJtB+o46tZgMQGM9JSjEhQGBz8EBFyya4cYn
yqE4DWA40sxyuRUDfJrfIlfHN2Oxr9INmv8AksRrNj/WYmA+V/R9PacZUX8M
RonYAZwN1p0Uk2dgZs+JEp+9LVD2ueDWlz8AKf6CivAlDExnPm3ac68FJQs+
v1gtA/h2d9cziSE6JlXaewcaW3DC++Xd4eEBBIynXPivmY6xVOnpmDWtYM7n
z48tHYTWNfk9q/PpGNl6RuT4xVbc8Wrz/bVpEOO90fxRsXQMJcbKCWa1Qnh+
VGCOl1Len5VoXnOPDvZGYlf+fCtiPEXv850ZhH37w4SXl+hQX/S82u5iG1Ss
szy/Og/i9dqhmfkjdLwND4y7192GEjJqO/3eIDZX68mYbaNDWv727WSLdhy/
6kedfT6Id64v9sYL0xGc5WBSW98OcuJSsEzqILbLDZ8cHejGjJ6FAlePglve
x/ft/TyI9NpDbnrV3bjWcmhGtJACIeF9AxY/BrHrdlTE0+RudF/Y07RrVwee
h69/7socRPaGn5m9gd04OiH/zuJdB7auXXL4ydQg9n3T/67u2I3igJU+7us7
UZA4PP5hKQtF7tFDQfrd2CHFbxn9vBPGO9pf169j8fxhRKSDl+dfJY0qf15B
BS3v8wmWKgtljYeVtgl0Q1yDFCACqLhxMIlvySEWDt+NMbrbQ4Nf1Q8qPy9/
/KkLzdhkyULN5tGL9aU0jFl+/bj5VhfCLdzO6V1m4WiTQeC6BBocBjIeGLG7
IE8/s8LOk4VGz5dvrvvS0Ob+yvbqeRqynQ4Ve4WxcEJxrLTElgYD4TCNxx28
Oqp0NeY1C60thoQYaMh74b3io1k3KHdXrinIYcHaJ3bBTo4GxW03eluqunFZ
cKamvYaFLqXxdVnzvLxTcLZoSpuOmUek+0QXC+fajQ4IdHdBxNg0QiaHjtDV
tVtW/mSB9Is7ZVHcBU+q1mUtZQZkEzLbVPnZcFCZcE+K6cLwFWVd2zcMZCi9
CDCVYmOg48jzqbtdyJh/JHJwBYGD2T57riqycSXgVbbh6S4MVgq5NxsRaNZ2
6nlwgI1h1cnmF/u7sOGxV8+FAAIO1cfCk4+x4dJlPMqS7sIpy0nTSV5unTyu
oVtxno2JoP8FD16+k7teEDTLyyVU2Z+kGxvuu6dUQilU1PX3bpLeS0LaQSju
z302ZrqPmnTnUiGQYfMkxZVE6hDXRDaGDa/ghCs7nlOh5d46q5lO/n9lg0/9
1wOf21S4wcTpG8/vG/iKU61L2QggTN7+sKDiw5KK5rObe2Ab8ubUnVY2Foe+
rtyoRsW1tAqt7Zd7YLNsvedwHxvTcjv2D0vyvr+M8sb5cw/U3MsC106wUeG7
2erjdCdWXGIty/2LCZFexzAjfg6e9Ky77UbrBA9SLrOOTPQcXxp1W5yDM/qS
T/d+7US6gminbiETBZ/TXr+W42BrssjHmTed8PHboBsk2osnSsfTvitzML5E
4Pvn+504ztj9tt6+F06R4zlzmhx8uTzD9b3aiQ3ah0X/yuuFjmDkl21HOAip
H12mb9aJ0Wir25YifZBy0ay1tOLAUoWluGRPJ8qmL9NibPsw1N3dfM+RA/kw
wqBuVSciLD0PkZ/6UGHsR8u8xcHwCMXh0UwHLmQ/Tt3C84+YvE393X4cFJp/
9z9O74DayoS/rtn0w3VTzc9lTzgIzK6KlyjrgKDzJ4+Pmf04En719944Dk6s
KilpT+pAW0MlY0pwABsWRAUc0ziQ9cihRQV3IHl7h4HWqQH8upK1PKKQA1Zn
2ozN9Q7cCWZ/8PswgEbKyVVfajjIPpAoveFEBwwH5iSrFw0iSf/3em47B76x
MRpMtQ5IHxbzXG45CK+PL7fJ9HFg8ifCIlm6A4OvNzJP8HhkIae7x2CcA+nz
Ia6X5ygo4FMzjlzgceohU+vWIi6YZX5PlAkKQs4ZfKSZs8A/HWQQL8ZFxqZ/
0n+WU3C62Fpa/i0LnQ5Kxxtkufg3yPlb1lsKtq+56uM0y0JmU8Opme1cGA46
sW8/pGDO3as/zYyN+zouF7ZqcrHS2FZ4/00K6trCTMfesHHuveR1CyMuGO8t
t8yZUxCz53X23mk21KXz7/hZcvF+xTH9LxoUXAvPXutlwsHywDO+6Q5c3Ll5
2N5/DQVaP6v8y+I5YI4uBHe5cqHXpOV7eKEdoqadrCWTvD6de/1U2I8L0T1q
ccI97aCnco6bHuEiov5wrHoYF9Rn24vrK9uRLryQFxHLxeV9rGR7Xk2ekqc+
TmmH70Xx9R2jXOgmhWaGvefCxXrN9IlHPO5XyAfJGgxh9cqdhcUFXGgX/rVK
yqUd/wfpBaax
              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -179.99999999999997`}, {7.5, 
                 179.99999999999997`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -179.99999999999997`}, 
                    Offset[{4., 0}, {7.5, -179.99999999999997`}]}, {{
                    7.5, -106.68024439918533`}, 
                    Offset[{4., 0}, {7.5, -106.68024439918533`}]}, {{
                    7.5, -33.36048879837066}, 
                    Offset[{4., 0}, {7.5, -33.36048879837066}]}, {{7.5, 
                    39.959266802444}, 
                    Offset[{4., 0}, {7.5, 39.959266802444}]}, {{7.5, 
                    113.27902240325867`}, 
                    Offset[{4., 0}, {7.5, 113.27902240325867`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -161.67006109979633`}, 
                    Offset[{2.5, 0.}, {7.5, -161.67006109979633`}]}, {{
                    7.5, -143.34012219959266`}, 
                    Offset[{2.5, 0.}, {7.5, -143.34012219959266`}]}, {{
                    7.5, -125.01018329938898`}, 
                    Offset[{2.5, 0.}, {7.5, -125.01018329938898`}]}, {{
                    7.5, -88.35030549898165}, 
                    Offset[{2.5, 0.}, {7.5, -88.35030549898165}]}, {{
                    7.5, -70.020366598778}, 
                    Offset[{2.5, 0.}, {7.5, -70.020366598778}]}, {{
                    7.5, -51.69042769857434}, 
                    Offset[{2.5, 0.}, {7.5, -51.69042769857434}]}, {{
                    7.5, -15.030549898166996`}, 
                    Offset[{2.5, 0.}, {7.5, -15.030549898166996`}]}, {{7.5, 
                    3.299389002036669}, 
                    Offset[{2.5, 0.}, {7.5, 3.299389002036669}]}, {{7.5, 
                    21.629327902240362`}, 
                    Offset[{2.5, 0.}, {7.5, 21.629327902240362`}]}, {{7.5, 
                    58.28920570264766}, 
                    Offset[{2.5, 0.}, {7.5, 58.28920570264766}]}, {{7.5, 
                    76.6191446028513}, 
                    Offset[{2.5, 0.}, {7.5, 76.6191446028513}]}, {{7.5, 
                    94.949083503055}, 
                    Offset[{2.5, 0.}, {7.5, 94.949083503055}]}, {{7.5, 
                    131.60896130346234`}, 
                    Offset[{2.5, 0.}, {7.5, 131.60896130346234`}]}, {{7.5, 
                    149.93890020366598`}, 
                    Offset[{2.5, 0.}, {7.5, 149.93890020366598`}]}, {{7.5, 
                    168.26883910386965`}, 
                    Offset[{2.5, 0.}, {7.5, 168.26883910386965`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -179.99999999999997`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -106.68024439918533`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.4\"", 0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -33.36048879837066}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.6\"", 0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 39.959266802444}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.8\"", 0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 113.27902240325867`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           18], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU
lGVSQuI9+/bsQtbH87av9/A2pCJrfm/O+f1xz/2cez5/3HvOPXfj6YuOviQp
KallEvhK8N+976dKvy0HqpBN9jJRCYtFaFx3rOblAXxI8dhgl1OJQmYe6Snj
IW4/6QiTFw0ge0hq4KJGJRQCTvz2yCoT2aWtF+Zd6PDUe5Z0L7oCFpN9/vxb
r1Db2+gz1kCHZsB3dmXCcpiYvzT8Z6IAg++pJ9nGg2gn85YTTuVomxXqVWtS
8GlltUPns0HEL14pk60qg2+p/pYRlEFxe7ktVZmB/Tbbgw30yvAl3F931a9V
2H6geH9RJAOfEpoMHO+WonXdT6u0m2pg7Va4518xAy87zwyHLpZA80uwvAGD
Ctew/B0PTzJxWmtl6mO/Eniz/pbF+3oE3c3RvdHEhLZHjjO1sxh5lYUkR+km
3Mh9rnbZlIV3mfZKgn3FmE/tkfLVakFGc4bCxQwWrorHGxWzKDgU9Wkx1OAt
KnhpUl4qbFgZ3Y42Vqbgbw+1+QTrdvQtPZp2jGZj+vfd5ifDyZhYv2bhe/13
eL/modhmnI2c6q7JKF4R1JVfhLsYd0I6xS5Q52sOMnlKw4l3ilATOLPj2K4u
lL625y+6cKBLjbMPbipCGJlqqibdjVr6yRNvznJw/+lskcuXInwzf8uGQe9G
K+nXhl8jOVCOvqBraUwGHycdM173oNsgxEQ3iYPr7tz4jf5kPInb6nnuWi8Y
P8VmdKdzQLJ0mZBJI8O5+f15Y48+8CITVa+TOYjQaTsh7CVDUbH8jwUTGsT/
Poq1auZgavbb6vaVFNQ7Xr1et6ofU++yJz8OcnCxn7zjzbcUXL7veP8mtx+L
s2TP7HEO+OSdSfdDKTBmrMt0Kh2AzOa6DvdlBLzupc3+8YoC8QZBwdokOhSP
dVqpqRGgX1I/7cmlIMO3sJrnNwiNENar5m0EnBwTWmy0i3HyRVR7jhUDuqmi
tVHmBNq+Wdqjd7wYKhN2jGB1JrY3ztwwPkbAVik4ZfWVYrQYaQj3i5kwfC8z
L3AnUDXGJ30oLUZsGPFZmsrCXm1V/yeBBMzfup3re18M84ocmbaHbFgf2DDg
FEcgMijUrr69BPSl0TbjzRwsTArd10v05xHe3iVSZbiWprRv5gIHKr5qAcHh
BDrjj0e82iPp/7dmz8tKOdjRbxnTHEBg/va+e099KsAl3NWjZAlYHfW7o+tH
YGvK9tx7yZVIio2PPeAoyVl5O/2SG4HjmaqN15uqgM25EzKpBPx3lxY2/Uig
nLY0YXW5GmPU3p+bBQSiM7j16+wIdDFCFvZq1CDFZ7H5pskQkjVX04KsCYwQ
IjmjvBocltlq5hAzhJcJpvxGU4mfES/1XYdrMZ15LEO1bQg1ix6za3cRUBbT
Nm4napFhG/wVTYsLWsB1haDNEp+T9l9vDKfCcTQl8h8fLsa4BTqN2gQspqkW
Oqp1kLpGFbnlc0E6wTBYqyzxP29+SD2nDrk7RC4bF7jQbpGxCpTk9pbK/1Hp
YD1ONas08A7xYGhpeLxhgYMwmW2e8qx6yPtbGD2/y8PBfBdPnY8c/KXw6Bwp
tAEUhdNpZ9k8nNocGxgg4CD2S2ZJd2YjGPIpWcHqw1B9NGf9oZ2D0A95shk9
TVgm35Nz+egwWtQuKQcXcnBupOTHYFILtsmtfhMfM4zYv0TsqYcceNGpaTZ7
WnFshW1JImUYFrI+eaFRHDi3t42peb1FoGxU1YOxYUxGMiJnfTg4WkuzGE5s
Q7JMcf3TzSPI/uz0/R92HFiTiatFle0ok55sfeE6As+AtnWLhhzseSHquTLW
ATZJv+tN4gi0BAfHItU5UO2YU9556x2kSd795fUjSKNG/L5smg3F5iizu1s7
ob/8Eat+fgRKRee1ZGrYkKNKu8+Xd+L4sl5e++5RRGa5U+RuskGquB7n7dSF
YClFEc1vFOP3jzuvOsHGIlnxZauoCw+XbCc5j0fhdt16SmkTGzP5dzuN/uxG
5Zeoz4LuUbwN3/236hgLH15ozaSs6QF3sXjxgzwf+89tMtIsZmEs47GudEEP
5BYnSQuSVXnpptq15k8WTJYlN3r+0otdLgUR1QF8PNMZm1s8woLWppCQLKc+
OJyNoc8n8/E86IFZmhwLcwecNosP0HAp0mGvWQUfuc3fBR9oZILpbdS5e3c/
kpPWJwdx+SjcMJHPu8JEeZxKVOj6AZRkjH98JS9AWeg/Y/E2TDzJnDSoWE0H
g1Lxg8BQgNr2g/p6JCZiGt7Rly/QsdRyM2+LswBNWyd/aa1hwGc079ph4SA2
sU6t9owQoD3iUfr5aAZs5RJNb/VLeFL/bMozAXq6D3GUwMAOvQu87gYmzkjP
NfU1CTCo/3FtweIgVtrZ39EuYuGmZvM2lQkBiJhUV6fyQYz7G1h7pLORp/8g
zl5diNH+I8nT4YPg18uEdh3moMvSb+jaPiHGDae6HpgPwtV5yn6qSrKjDqbW
dV5CfIr/b0DoaBnhbdEyI6DlI5O6dFWIOebRY0wyHftDe+Ytcon/sxBSJp+v
RYXQ8WpFXZfb1iF4JKS7/tYjhOzNZ/UbjSX/CrT0gIohGIfWXtH5JERd9NYT
r2cGIClT4LwvF0MO8g9DlEU4ZaN216x6AFExG6zjFXm4re+Q02EgwscVpI6K
qwPYYHlQ8SsKD1bS96v0joiQ0DqpYHN8ALUzZxgpHsMYYzK7/vQVYVMix7ZF
YwDehbdebJMbQQplywgzRoRSx45YB1Y/pAPehL3OH8GRpLOzZqki/KBRWdmX
2Y+snf22+11H8dm/YNWdUhEEAzlzP5/vx6HRBbXGZXxk2syuF/eJEP04xZRr
3A/+s43cH17w4aRrbWT7UQQtr4SgMws0JLjbvmY4CrB8Jt42TUmMvC2/505Q
adi55myU37wA+Z1trnM7xTjE9xOG3KChpTfR/kO6EO4v1c47HRaD/dJ524Ij
DeeSCnUuHxNh1ZVT0bk+Yvx28eDp2DU0KNoPCFZMSfK4P7srFyOGopFxqtxQ
H3LlvlDuPBbjzF5B1mkJZ01vot/KlvS+blP8OtsxaKp8U1peIoZl6Vca6oF9
+B+3fOBp
                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.982303717466173`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "18"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.801045582932678*^9, 3.801049464386204*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"6788a7d8-2dce-4863-b24a-d120ba798be9"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"19842af4-90ba-4dc8-a540-a25d1e89bfcc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{"tabr1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r1", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
          "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r2", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}], 
          "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.795421465666741*^9, 3.795421466035664*^9}, {
   3.7954215364978333`*^9, 3.795421537453836*^9}, {3.795421625984447*^9, 
   3.79542164472902*^9}, {3.795425652784513*^9, 3.795425726098669*^9}, {
   3.795425758789545*^9, 3.795425774190296*^9}, {3.7954258333647003`*^9, 
   3.7954258685311937`*^9}, {3.795425920873761*^9, 3.7954259297513447`*^9}, {
   3.795426037708872*^9, 3.795426104854391*^9}, {3.79542616329585*^9, 
   3.795426234595022*^9}, {3.795426336796217*^9, 3.795426377106432*^9}, {
   3.795426807472982*^9, 3.79542682091676*^9}, {3.795426884511804*^9, 
   3.7954269331217527`*^9}, {3.795427076232342*^9, 3.795427086538158*^9}, {
   3.79542832703578*^9, 3.795428354518651*^9}, {3.795429513366081*^9, 
   3.795429592745058*^9}, {3.7954308304701157`*^9, 3.7954308349068832`*^9}, {
   3.7954309431983*^9, 3.795430947373246*^9}, {3.79553348574975*^9, 
   3.795533522270814*^9}, {3.7955340551678267`*^9, 3.7955340561764793`*^9}, 
   3.795539325514901*^9, {3.795589157271555*^9, 3.795589169302174*^9}, {
   3.795636144165728*^9, 3.79563614512151*^9}, {3.8010323832215633`*^9, 
   3.801032546324602*^9}, {3.80103265042903*^9, 3.80103265113846*^9}, {
   3.801032717576054*^9, 3.801032719713833*^9}, {3.801032961315099*^9, 
   3.8010329622884817`*^9}, {3.8010330514588118`*^9, 
   3.8010330629662933`*^9}, {3.8010330979308853`*^9, 3.801033217443677*^9}, {
   3.8010332902265863`*^9, 3.801033356662648*^9}, {3.80103353518967*^9, 
   3.801033539918291*^9}, {3.801033595361967*^9, 3.801033598359577*^9}, {
   3.8010336651013327`*^9, 3.801033730645124*^9}, {3.801033785829723*^9, 
   3.8010337876777287`*^9}, {3.801033855587998*^9, 3.801033911760269*^9}, {
   3.80104157570658*^9, 3.80104163382664*^9}, {3.801041673163889*^9, 
   3.801041720457693*^9}, {3.801042070563847*^9, 3.801042080807064*^9}, {
   3.80104215003592*^9, 3.801042166125441*^9}, {3.8010423832246513`*^9, 
   3.801042391853533*^9}, {3.801042822985042*^9, 3.801042848053705*^9}, 
   3.801043149871189*^9, {3.801044272012916*^9, 3.801044275659533*^9}, {
   3.8010444436730957`*^9, 3.8010444642114553`*^9}, {3.8010446566616592`*^9, 
   3.801044658170041*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"2f1b0255-4eaa-48fa-8fac-036f549f6eb5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"p1r", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"tabr1", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<R for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d1r.jpg\>\"", ",", "p1r"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.8010446681783133`*^9, {3.801044704595813*^9, 3.8010447099666433`*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"c3c72455-8bf1-4843-9eff-1ef62c4cdab9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd1l0IJWUdx/HNnjNnBBH1IrwwchcRogy7WCwSTukKhUhSroGRmBWUiYIU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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxdnHe8z+X7x9+jr6hE2YSKY++DZFYcO9mbCtmblJ3skT3LqOxNVghli+ys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           "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["

1:eJx0mnk4lP///SuSLBUhJEUoilSoUKdUEiqSpV0RilLWUiIhqaTsshYtimQZ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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 18],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"R for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.3 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.101}, {-1.5707963267948966`, 
      1.5292036732051035`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwtlnk4Vev7xmUopXBCUVHRIJEGVMItCYmUI1SKRJpDitMxhyIl6iREFIqE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              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -180.00000000000006`}, {7.5, 
                 179.99999999999994`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -165.48944337811906`}, 
                    Offset[{4., 0}, {7.5, -165.48944337811906`}]}, {{
                    7.5, -96.39155470249526}, 
                    Offset[{4., 0}, {7.5, -96.39155470249526}]}, {{
                    7.5, -27.29366602687151}, 
                    Offset[{4., 0}, {7.5, -27.29366602687151}]}, {{7.5, 
                    41.804222648752344`}, 
                    Offset[{4., 0}, {7.5, 41.804222648752344`}]}, {{7.5, 
                    110.90211132437615`}, 
                    Offset[{4., 0}, {7.5, 110.90211132437615`}]}, {{7.5, 
                    179.99999999999994`}, 
                    Offset[{4., 0}, {7.5, 179.99999999999994`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -179.30902111324386`}, 
                    Offset[{2.5, 0.}, {7.5, -179.30902111324386`}]}, {{
                    7.5, -151.66986564299427`}, 
                    Offset[{2.5, 0.}, {7.5, -151.66986564299427`}]}, {{
                    7.5, -137.85028790786953`}, 
                    Offset[{2.5, 0.}, {7.5, -137.85028790786953`}]}, {{
                    7.5, -124.03071017274473`}, 
                    Offset[{2.5, 0.}, {7.5, -124.03071017274473`}]}, {{
                    7.5, -110.21113243762005`}, 
                    Offset[{2.5, 0.}, {7.5, -110.21113243762005`}]}, {{
                    7.5, -82.57197696737052}, 
                    Offset[{2.5, 0.}, {7.5, -82.57197696737052}]}, {{
                    7.5, -68.75239923224572}, 
                    Offset[{2.5, 0.}, {7.5, -68.75239923224572}]}, {{
                    7.5, -54.932821497120926`}, 
                    Offset[{2.5, 0.}, {7.5, -54.932821497120926`}]}, {{
                    7.5, -41.113243761996195`}, 
                    Offset[{2.5, 0.}, {7.5, -41.113243761996195`}]}, {{
                    7.5, -13.474088291746716`}, 
                    Offset[{2.5, 0.}, {7.5, -13.474088291746716`}]}, {{7.5, 
                    0.345489443378023}, 
                    Offset[{2.5, 0.}, {7.5, 0.345489443378023}]}, {{7.5, 
                    14.16506717850287}, 
                    Offset[{2.5, 0.}, {7.5, 14.16506717850287}]}, {{7.5, 
                    27.98464491362761}, 
                    Offset[{2.5, 0.}, {7.5, 27.98464491362761}]}, {{7.5, 
                    55.62380038387708}, 
                    Offset[{2.5, 0.}, {7.5, 55.62380038387708}]}, {{7.5, 
                    69.44337811900182}, 
                    Offset[{2.5, 0.}, {7.5, 69.44337811900182}]}, {{7.5, 
                    83.26295585412667}, 
                    Offset[{2.5, 0.}, {7.5, 83.26295585412667}]}, {{7.5, 
                    97.08253358925141}, 
                    Offset[{2.5, 0.}, {7.5, 97.08253358925141}]}, {{7.5, 
                    124.72168905950089`}, 
                    Offset[{2.5, 0.}, {7.5, 124.72168905950089`}]}, {{7.5, 
                    138.5412667946256}, 
                    Offset[{2.5, 0.}, {7.5, 138.5412667946256}]}, {{7.5, 
                    152.36084452975035`}, 
                    Offset[{2.5, 0.}, {7.5, 152.36084452975035`}]}, {{7.5, 
                    166.1804222648752}, 
                    Offset[{2.5, 0.}, {7.5, 166.1804222648752}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -165.48944337811906`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.6\"", 0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -96.39155470249526}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.7\"", 0.7, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -27.29366602687151}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.8\"", 0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 41.804222648752344`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.9\"", 0.9, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 110.90211132437615`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 179.99999999999994`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           18], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.47906519531311537`", ",", "1.0000000000000187`"}],
                  "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "18"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8010446686972733`*^9, 3.8010447147092876`*^9, {3.801044821032844*^9, 
   3.801044835241661*^9}, 3.801049604528098*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"2afe39a2-057c-47f5-b67d-184217670507"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"r1", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}],
             "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"r2", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}],
             "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"t1", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.3", ",", "1"}], "]"}],
             "]"}], "2"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.5"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", "0.5"}], "}"}]}], "]"}], ",", 
     "1"}], "]"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\[Theta]\>\"", ",", "14", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\[Phi]\>\"", ",", "14", ",", "Bold"}], "]"}]}], "}"}]}], 
   ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", " ", 
     RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", 
      RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<R for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.3 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8010448918569202`*^9, 3.80104490378234*^9}, {
  3.801044955725066*^9, 3.801044958616365*^9}, {3.801044991324967*^9, 
  3.801045018953309*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"42ba3c6f-461d-49b6-88e9-ed090ece06ed"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxdzbFLAmEcxvHj+A1v4NR0m9zSFnhD80neEhJEBEFDg+Di4iJ4Y6O7/0BL
oAQOgksd9C/oQVMQ0ZSD2LvIGzqYw/OD9xkeHr7TJ251r9thEATJ/w6/G9vy
snWVRqfZzTb+e/PbatfuBqNN41v7YXGezapT7cfmenKcf6To+VP/9qhYaf+U
r8/yuUnf8+VJYr7U89tqw0PDQ8NDw0PD6xS9YSS/6vltteGh4aHhoeGhfc+R
58hz5DnyHHmOPKfe2f3LRSUM6vD8ttrw0PDQ8NDw0L4n5Al5Qp6QJ+QJeUKe
Ic+QZ8gz5BnyDHlGvT2UjWSb
     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          
          PolygonBox[{{11, 17, 18}, {8, 2, 1}, {9, 2, 8}, {3, 2, 9}, {3, 9, 
           10}, {10, 11, 4}, {9, 8, 15}, {6, 12, 13}, {3, 10, 4}, {16, 17, 
           10}, {9, 15, 16}, {11, 12, 5}, {6, 5, 12}, {17, 11, 10}, {4, 11, 
           5}, {16, 15, 22}, {9, 16, 10}, {13, 7, 6}, {20, 14, 13}, {23, 22, 
           29}, {48, 42, 41}, {11, 18, 12}, {16, 22, 23}, {18, 19, 12}, {13, 
           14, 7}, {18, 24, 25}, {13, 12, 19}, {23, 24, 17}, {20, 21, 14}, {
           30, 29, 36}, {18, 25, 19}, {23, 30, 24}, {13, 19, 20}, {24, 18, 
           17}, {23, 29, 30}, {25, 26, 19}, {20, 19, 26}, {30, 31, 24}, {20, 
           26, 27}, {27, 21, 20}, {28, 34, 35}, {28, 21, 27}, {32, 25, 31}, {
           37, 36, 43}, {25, 32, 26}, {30, 37, 31}, {30, 36, 37}, {32, 33, 
           26}, {27, 26, 33}, {38, 32, 31}, {37, 38, 31}, {27, 33, 34}, {31, 
           25, 24}, {34, 28, 27}, {32, 38, 39}, {37, 44, 38}, {37, 43, 44}, {
           39, 40, 33}, {34, 33, 40}, {44, 45, 38}, {32, 39, 33}, {45, 39, 
           38}, {34, 40, 41}, {41, 42, 35}, {39, 45, 46}, {39, 46, 40}, {16, 
           23, 17}, {46, 47, 40}, {41, 47, 48}, {41, 35, 34}, {41, 40, 47}, {
           42, 48, 49}}]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJyVk/9PzHEcx+/q5FQT4TJcvnWrLomU6aInSU2jEik3k5pKvl1tprBWU7ks
IzPp5MsqffMlhE+6uHLj6Lh7q9yFtI/chs7FChnKvP+BT5sfXr8899rj9X49
X8/33GRFbIodj8dbTMueVnCcJs0jtBX1TFKga/YRZBV0HXHLeY0CU4JWdOIz
LoYV5DYpbHCRZoqVgm7oorIniDYwEB4YcTvvYYL/zROWueXvkFTcG+KntUG+
aDCiuMoG6VMSHnnBjPFZaQMNonv4uap0XGLAW+Q+upGgWtaHmEfzjorDB+Dm
ukh9v9mGFerJommZZnQu/RuWslqLwZ2Worv69/BuNMfs8u2D4KTiq6ySQbRH
2S6HJwSyHfb9dh0sJsc23Q6+wiBv/5/h8isEWRu+t81/xsI9oOULv5GBpLpd
zj9J4BeXXqx4zOL3GaMy/zwDlYtwf2wPgX9p/9kAEwtBg08qj/K1AvtQM+Xf
OaTs8aV8O6ft+pgKBuKa1U/X6Ak8NFNuN1D9e2HJtzdlDLpEjDX6E8HbUWmb
pZuFU1JgaUINg4Vbp65Jv0dQTpp7Rg0sHEwOnueq6Nw+0TZPLYG81xrEf8Fi
wkjfxyXVDDI00kPZ9wl4K6PKXhpZCLM7tWsvMwhZae5uaiWwqrYl5xEWE9M3
vVtQx+BUwoNj1lsEupmqiJrnY3C2iNYVUM6zxN28TxqCjPw3ijjKEcrkJg3V
43N53tOp/mPP5hwp1R17JZn7KGekt7WyroWg0FtfXW/k5nPt63jper6F9k8T
W78J1QQlIw/bNtJ+ZwHfX1hLfVN3aX7dJfA57ivIMXDPdcwbdHan/IrlubOC
mglEH1YYvYzcfK73OIUenH2a6urD9XtVTQRzmgP7Ow1j8Dl0Lr6zrigsh+5l
+zXqIr9DsDRRMttzDL7z/Ad1BqqHl4eUtjMENZW3hmsN3Hf5b9/+03+uf+Rq
1r2SXGXQOBSt2lpLcPynZThLz2Jq8Axl5DWah5KgHeurCLyU0bKKdprPoknx
Q5QvCPJKUjcSrPIXyzpoPh2YyJsvaf4l/GtH4x8SsLrUCDPh9ucfBWVP3A==

      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 14, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 14, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 10],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"R for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 1.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.3 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.001}, {-1.5707963267948966`, 
      1.4292036732051034`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwdlmk4ldv/xmUoTTgZoqKiQSINqIRbEhKRIxTRQNKIiNORKSlSok5ChFCk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              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.500037725680409, -179.99883589329022`}, {
                 7.500037725680409, 179.99883589329022`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.500037725680409, -127.57091888978711`}, 
                    
                    Offset[{4., 0}, {
                    7.500037725680409, -127.57091888978711`}]}, {{
                    7.500037725680409, -57.67070870385341}, 
                    
                    Offset[{4., 0}, {
                    7.500037725680409, -57.67070870385341}]}, {{
                    7.500037725680409, 12.229501482080302`}, 
                    
                    Offset[{4., 0}, {7.500037725680409, 
                    12.229501482080302`}]}, {{7.500037725680409, 
                    82.14074912422527}, 
                    
                    Offset[{4., 0}, {7.500037725680409, 
                    82.14074912422527}]}, {{7.500037725680409, 
                    152.04095931015897`}, 
                    
                    Offset[{4., 0}, {7.500037725680409, 
                    152.04095931015897`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.500037725680409, -179.99883589329022`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -179.99883589329022`}]}, {{
                    7.500037725680409, -162.52102398275397`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -162.52102398275397`}]}, {{
                    7.500037725680409, -145.04873080032334`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -145.04873080032334`}]}, {{
                    7.500037725680409, -110.09310697925086`}, 
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -110.09310697925086`}]}, {{
                    7.500037725680409, -92.61529506871463}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -92.61529506871463}]}, {{
                    7.500037725680409, -75.14852061438965}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -75.14852061438965}]}, {{
                    7.500037725680409, -40.19289679331716}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -40.19289679331716}]}, {{
                    7.500037725680409, -22.71508488278092}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -22.71508488278092}]}, {{
                    7.500037725680409, -5.237272972244678}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500037725680409, -5.237272972244678}]}, {{
                    7.500037725680409, 29.707313392616545`}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    29.707313392616545`}]}, {{7.500037725680409, 
                    47.18512530315279}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    47.18512530315279}]}, {{7.500037725680409, 
                    64.66293721368903}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    64.66293721368903}]}, {{7.500037725680409, 
                    99.60752357855024}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    99.60752357855024}]}, {{7.500037725680409, 
                    117.08533548908649`}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    117.08533548908649`}]}, {{7.500037725680409, 
                    134.56314739962272`}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    134.56314739962272`}]}, {{7.500037725680409, 
                    169.5187712206952}, 
                    
                    Offset[{2.5, 0.}, {7.500037725680409, 
                    169.5187712206952}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500037725680409, -127.57091888978711`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.500037725680409, -57.67070870385341}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500037725680409, 
                    12.229501482080302`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.500037725680409, 82.14074912422527}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500037725680409, 
                    152.04095931015897`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 10]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           10], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.9999999999984874`", ",", "1.0000000000087717`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.801044953780552*^9, 3.801044967736711*^9}, {
   3.801045008259481*^9, 3.801045027821347*^9}, 3.801049615765913*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"6e17c831-1a37-4f3b-98fc-f77f15a7b8d1"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"c9dfd95c-1ee3-4be9-ae3c-d1270b04d5c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{"tabr2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r1", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "10"}], "]"}], 
          "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r2", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.5", ",", "10"}], "]"}], 
          "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p2r", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"tabr2", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<R for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 10.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.5 \!\(\*SubscriptBox[\(V\), \(0\)]\
\)\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d2r.jpg\>\"", ",", "p2r"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.80104508184394*^9, 3.801045200684741*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"52191c32-61df-41df-b502-27572f571687"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 173, 42, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656329646*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"4cdf3bf4-a98d-4357-954b-ce7d4999b6c7"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 173, 43, 
   23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8010496563901*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"91146c74-1321-435c-8b77-42cc6b6b9c0f"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 173, 44, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656430722*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"c0029739-8dd1-469e-adb0-077ca752b470"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\"}]\\) encountered.\"", 2, 173, 45, 
   23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656456253*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"18a4aaf2-1349-452e-8b13-95167e733967"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}]]\\) encountered.\"",
    2, 173, 46, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656653964*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"545fca09-98e6-46ec-9a63-befef3f9b5b8"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Power\\\", \\\"::\\\", \
\\\"infy\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 173, 47, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8010496566977987`*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"219109e8-8f4f-4e9a-8a49-04b1bd44f659"],

Cell[BoxData[
 TemplateBox[{
  "Infinity", "indet", 
   "\"Indeterminate expression \\!\\(\\*RowBox[{RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \\\"+\\\", \
RowBox[{\\\"0.`\\\", \\\" \\\", \\\"\[ImaginaryI]\\\"}]}], \\\")\\\"}], \\\" \
\\\", \\\"ComplexInfinity\\\", \\\" \\\", \\\"ComplexInfinity\\\"}]\\) \
encountered.\"", 2, 173, 48, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656720809*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"816127a0-1081-47e7-85c5-ce34042c1924"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Infinity\\\", \
\\\"::\\\", \\\"indet\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 173, 49, 23341588913307657646, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801049656735113*^9},
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"23248c9d-8df2-4d7d-ba9b-c2012ddd1c93"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd1l0IJWUdx/Ftfc6cEUTUi/DCyF1EiDLsQiwSjukKhUhSroGRmBWUiYIU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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNnHfcz2X7xj8DKSOSVfaeRSI7e28RRSJ7JjMre28Syc4Ikb3nbe8iSRpK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           "]]}]}, {}, {}, {}, {}}}, 
     VertexColors -> CompressedData["
1:eJx8mnc4lf//x0so0jIaKqWQ1SAk4hmlkKyWtJdKZUZWVkJGSkpGQlIhUfYm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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 1, 
     AxesOrigin -> {Automatic, Automatic}, AxesStyle -> Directive[Bold, 
       GrayLevel[0], 14], DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{
        FormBox[
         StyleBox["\"\[Phi]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}, {
        FormBox[
         StyleBox["\"\[Theta]\"", 24, Bold, StripOnInput -> False], 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, LabelStyle -> 
     Directive[Bold, 
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 18],
      Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotLabel -> 
     FormBox["\"R for \\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\) = 10.0 \
\[Times]\\!\\(\\*FractionBox[SuperscriptBox[\\(\[HBar]\\), \\(2\\)], \\(2  \
m\\\\ \\*SuperscriptBox[\\(L\\), \\(2\\)]\\)]\\), E = 0.5 \
\\!\\(\\*SubscriptBox[\\(V\\), \\(0\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0.001, 3.101}, {-1.5707963267948966`, 
      1.5292036732051035`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
     Directive[
       RGBColor[
       0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
       10]}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJwtlnk4Vev7xmUopXBCUVHRIJEGVMItCYmUI1SKRJpDitMxhyIl6iREFIqE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              "], {{
                Rational[-15, 2], -180}, {
                Rational[15, 2], 180}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -180}, {
                  Rational[-15, 2], -180}, {
                  Rational[-15, 2], 180}, {
                  Rational[15, 2], 180}, {
                  Rational[15, 2], -180}}, {{
                 7.5, -180}, {-7.5, -180}, {-7.5, 180}, {7.5, 180}, {
                 7.5, -180}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -179.99999999999994`}, {7.5, 
                 180.00000000000003`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -120.00000000000004`}, 
                    Offset[{4., 0}, {7.5, -120.00000000000004`}]}, {{
                    7.5, -19.999999999999968`}, 
                    Offset[{4., 0}, {7.5, -19.999999999999968`}]}, {{7.5, 
                    80.00000000000003}, 
                    Offset[{4., 0}, {7.5, 80.00000000000003}]}, {{7.5, 
                    180.00000000000003`}, 
                    Offset[{4., 0}, {7.5, 180.00000000000003`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -179.99999999999994`}, 
                    Offset[{2.5, 0.}, {7.5, -179.99999999999994`}]}, {{
                    7.5, -159.9999999999999}, 
                    Offset[{2.5, 0.}, {7.5, -159.9999999999999}]}, {{
                    7.5, -139.99999999999994`}, 
                    Offset[{2.5, 0.}, {7.5, -139.99999999999994`}]}, {{
                    7.5, -100.}, 
                    Offset[{2.5, 0.}, {7.5, -100.}]}, {{
                    7.5, -80.00000000000003}, 
                    Offset[{2.5, 0.}, {7.5, -80.00000000000003}]}, {{
                    7.5, -59.9999999999999}, 
                    Offset[{2.5, 0.}, {7.5, -59.9999999999999}]}, {{
                    7.5, -39.999999999999936`}, 
                    Offset[{2.5, 0.}, {7.5, -39.999999999999936`}]}, {{7.5, 
                    0.}, 
                    Offset[{2.5, 0.}, {7.5, 0.}]}, {{7.5, 
                    19.999999999999968`}, 
                    Offset[{2.5, 0.}, {7.5, 19.999999999999968`}]}, {{7.5, 
                    40.00000000000009}, 
                    Offset[{2.5, 0.}, {7.5, 40.00000000000009}]}, {{7.5, 
                    60.000000000000064`}, 
                    Offset[{2.5, 0.}, {7.5, 60.000000000000064`}]}, {{7.5, 
                    100.}, 
                    Offset[{2.5, 0.}, {7.5, 100.}]}, {{7.5, 
                    119.99999999999996`}, 
                    Offset[{2.5, 0.}, {7.5, 119.99999999999996`}]}, {{7.5, 
                    139.99999999999994`}, 
                    Offset[{2.5, 0.}, {7.5, 139.99999999999994`}]}, {{7.5, 
                    160.00000000000006`}, 
                    Offset[{2.5, 0.}, {7.5, 160.00000000000006`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.7\"", 0.7, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -120.00000000000004`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.8\"", 0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -19.999999999999968`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.9\"", 0.9, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 80.00000000000003}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 180.00000000000003`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 18]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 360}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, 
           RGBColor[
           0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`], 
           18], FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"BlueGreenYellow\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJwtVHk01YkfVQ+hwtiltC+kMWWL4ppGKmUyxogaWxiTNsQwRraRSk1Sk2qU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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Gradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "BlueGreenYellow", "Gradients", {0, 1}, Blend[
                    "BlueGreenYellow", #]& ], Selectable -> False, Editable -> 
                    False, SelectWithContents -> True], "[", "#1", "]"}], 
                 "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.6399720485718955`", ",", "1.0000026538036735`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.22222222222222227`, 0.22222222222222227`, 
                    0.22222222222222227`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.33333333333333337`", ",", "0.33333333333333337`", ",", 
                    "0.33333333333333337`"}], "]"}], NumberMarks -> False]], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.33333333333333337`, 0.33333333333333337`, 
                    0.33333333333333337`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[
                  0.33333333333333337`, 0.33333333333333337`, 
                   0.33333333333333337`], Editable -> False, Selectable -> 
                  False], ",", "18"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "360"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.801045305144794*^9, 3.80104974990422*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"947a3a72-1688-4b39-8988-cd3d435e63d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
  RowBox[{"tabr3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r1", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.95", ",", "1"}], "]"}], 
          "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"r2", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]", ",", "0.95", ",", "1"}], "]"}], 
          "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.001", ",", "\[Pi]", ",", "0.1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p3r", "=", 
  RowBox[{"ListDensityPlot", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"tabr3", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<BlueGreenYellow\>\""}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "24", ",", "Bold"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Phi]\>\"", ",", "24", ",", "Bold"}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "Black", ",", "14"}], "]"}]}], ",", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", " ", 
      RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", 
       RowBox[{"Darker", "[", "Gray", "]"}], ",", "18"}], "]"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<R for \!\(\*SubscriptBox[\(V\), \(0\)]\) = 1.0 \
\[Times]\!\(\*FractionBox[SuperscriptBox[\(\[HBar]\), \(2\)], \(2  m\\\ \
\*SuperscriptBox[\(L\), \(2\)]\)]\), E = 0.95 \!\(\*SubscriptBox[\(V\), \
\(0\)]\)\>\""}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<3d3r.jpg\>\"", ",", "p3r"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.80104508184394*^9, 3.801045200684741*^9}, {
  3.801045391963429*^9, 3.801045418837063*^9}, {3.801045570415699*^9, 
  3.80104558094046*^9}, {3.801048900831959*^9, 3.801048901419532*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"7ee51900-ecaa-4ed0-ae6e-15575062aa0c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJxd1l0IJWUdx/HNnjNnBBH1IrwwchcRogy7WCwSTukKhUhSroGRmBWUiYIU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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxdnHe8z+X7x9+jr6hE2YSKY++DZFYcO9mbCtmblJ3skT3LqOxNVghli+ys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           "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["

1:eJx8m3k4lO//xUWWUKHsQlJpJVGWcpDQKipLSsqSCkVkKbIla0koKkVUKCH7
vlVCdrNYZyxjmVFIpUi/x3X9/v18/ePyGmae577Pfd7nGNaev2Jix85GfCxl
Y+MgPh2slQteoz8BESGl4tIiFlAsKCLsQoJWrIjtIs+nuucu8udnvdcucvbM
g/+kCO622f/FIndo1963yCc9aywXOYnj351F3uTN773Iu0R4/CQJLhjIY7PI
j1i9rVnkTWLdbhIEzxwW2bXI3/CprBEhOOdWmp44wdPMZtgXuXvXysBFHtGj
Pi9K8D7HjIYSgq8iK04tcqFxttciBI9YdzV6kbvdVbIRJXhOU+VJYYI//Bhq
scgXJEM6FvmTvL9CqwmuYK+1bpEvWfFOW4zgPbkPWEIEl2ssmCom+Nr9pi8W
OZuA5ldBgl/M+PpxkTMuRc0u8o1uYnKLvKvtYcoiX2P3a484wa3/HY8SIHhr
kFDEIrcJaHZa5K79hVqLPEvb3HeRV37YGLrIr7KHKS3yKq8fNxY55eJo5CKP
CTSzX+SNTuy3FznvevqNRb63Yb53kZt0yMUv8gP1n48v8uDe99GL1/NvTWjB
Ime1aIou8pTIQz6L91Ud/a9vkR/e8rxu8fqV752PWUVwd53p5Yvr0H1D8vIi
nyH1Ny6uTycCdRf5bLkd+yI/oXhUYnGd9wsleC9y4ccZ0YvrmfDZ4srivqg1
zL5f5A5HbGUXeUWNS7kYwZfsNmMtcv0wyazF/Tphqv5ncX8Lh93XLu6vd9Qh
/UX+xlhMZFEnt712GS/yzvKtI4s6UTlfzrWoK/eSbK9FznoYGrfIB/mjqxf5
L/2D8Ys8+n682SIXKhPTXdQthbc8c5HP7OrbusiLFzT8Fvn5mh1Fi/zHIX6x
Rf5f+t/azZ/YqT2BMeqQEbWQhdV1ZiJdriTwTdn83r1jAgcFOEhq+Syk3zRM
EvYkwfSfRes30Qmsf7BaYjabBXMrWbO7fiR4qFwqE/jJQojZOs/9b1jI0N7X
PxJOnJfYUySeLyxskSy8bZXKwgYvl8hX8STcJBc03U1k4WVU24rIpyzIVb44
p5FGQmf9hv2RjizYCV9+vC6WBfn53h9zRSTQrrG/5lcnzluvXoFXBAuG4gOM
vQ0kqO0Um5LiYuHCC96do4GEzvm1Dxr1kKB5PuB4ZScTW4bX3/1wg4WSu3rt
gSxiXyytC8hpTDR1GmSed2NBN0D+jMYcCQprvyUIBjFR9FZ2gduZhbwlz18N
cJNxcL1XVrcdEy29c0u+OxDrfKNJgV2IjJuRyqfNjjHh9Gujwwk7FlSMTUZ3
i5ORzHwqYKzHRIft15ijNiy81b1sizVkLGTfddPQZSJaMe7lzHkWnvwZuzNN
cD/7TPWNB5nE42oTB2yJ+4Nz0UFJMpKujd1vtGTChdO1XecCC1pipGXnhMlg
qbtpB15nwj/ZanflZRbi638HOPGTkd/9wORwPBOxBtOqCS6EDr88j/7ARsbs
v2MPKdVMWPNHOj70ZOF110QodZqEwHynr9FTTJzaPJJ7zY+FulDxTTsGSeC/
ttH77ToWvu3WO0MPYeHT16c7L7SRoDQylrTDjNhHGosafp/QCVuzkHwVCW3+
7C+FwljY83rbsEQCCwkeh5+IZpFwZ5mHoW4xCwIpS3+rJrPQHNS0fvoZCRqq
oQ0fh1ng4D3AHpLGwhcp9w1n7pPgPG2m18o7Aa+1v9fWvGOBrXCk5HsQCa8f
xfG2byR80ua0YUouC2ECvjc0b5Dg7dU0GaU5gbPPsq7+LCCu3+DukkQ3EoLG
1GeU908gfkOuXiyhc4m3n97ZEDo/+v/6F/1//Wv9v/5XbmqTdCJ0nrBE6aMO
ofPKRNN2DkLnGuQD3FdmCH2QaDv/ZbBgqSpMvhZBwqoZsZ790YTPMgw5bz5m
oUVAf6f5WxJM9v0+PbCShaGknrmI24S/3ZGVXEYlYdf0rndJ14h9iRyQ1yP2
i1zr8tp2OaGrMxHxlNpxUH5FqvYeYaEo4MefHwZkCP2pPX6KbxzyT+UU0rYT
unq4qmNNMBl3fX8+4DYaQ5LmL825FcT5cC6+ovaB0KFDaafzw1GcEj/WLTbJ
xOgh/4dl7BTkptzwCmCOYII5sm1bOxNfmAs2FnsoCOM3Om5nPIILTa9dtIuY
OJt12+vvFQqcXb+qHWpioGqNX5byCybq9B/eZz6mYEePrNFFewa8xK2liu4z
kXjCpay4nIKtQ15bpqQYWCb3eO+Z20zY7HvFbUGmAE88VgnNDCN9TbSCjy+h
d3aVZXzDFKSf+3BxnjWMnvf6god9mJh0u11zaYR4Xe27bkPcDDzwoVS3+TOx
W9Yzx76PAspxk1F2PQZCivrzv4UzYdbT+lSnngIBhc1T0c8Y6AvqrjR9zMSs
RoHOgwwKjvCW1DaJjoDW6eMd9Y4JSYdBtwOBFLRtvLVy4vUIxMJ7On5/YkKk
5xxnmgkFeZo65XJHR/HE3t6udpCJFf26MkckKQhacIh9u2QMexZ+b5tdwsIO
uljlun4ylPmOB7BKx9AzJZXrsZaFGw9+Rtk9J2Pp1uwjYZ7j2P81Q5Fbh4WL
+tSHd86RETd8iqt8K/F6YaPWZmdZ8PnQm7R+PRlby0/NJLUS5y6BqrSa8KWz
VxNlhydIuCLgo55IfN8FhmDST0JfB57HXjEuJ8HOtPhbfzMLOQP2nRTCP1Nq
v4+9f0SCcc5fz1apCbQ5cBrX5xDz4vC6BKYvCUe2uc7c1iX0P7+EV47QOVsi
ffcB1//Wf9bD6w8ixCaQ5JztKUQ8T5isSosF4ecv/SPX0YjroHKs+x1L6Nz4
Ooe/PKHzGDM3/boyJn4sVT1d5kHMhTP3xsJnSLjrp9ke8XIc8WtFImoNWWh8
sLtZyoSM3cXcA2FnxtDMbrDbUZAF2QIZP8tKMtQVOWKiZkZwrdRS9n0HE3a/
JJKPqVPwbFPviJUPA+ZCBh2xsUxcN8/RWVZAgVpJiJM/zzBuNz1v6zFl4iTv
jMSfnVRcuPXp2d2UQXwquXZsXoLw6aJrrcig4poNXbvhzABkXBnJS4fGYVNF
/1Mm1oXZj39vhUXSEeqi4172Yhwq7Dkrr9zpwhUh6g7NQRqki3dwiziNo7ZN
N4U21AVN+paGv2do4Bq89++47jj4j+g4zG3rRmPHa7bXbDSkf5PXsZYfh0Df
I8Ud57qR9uOyoERCP26a1Ba3rBpHy/O5JH+fbpzXy+7SCenHqYPfSr8LjMNE
rpdqH9CNj8s888Qb+zHjLeJLkhyH+7Vt2vVXuqFi2JiprEzDo0F56KuMw75m
2yN2/W7ce7UqUOYVDUUrE343WIxDc1b9fDdnNxTfmBo469LRKxA9mRw+jnKR
kvmUrC603VBVe8o2gBm2/bwZdeMwfN/855BhF+afOfvdEBtE91CTgiMHE1O5
nxIUu6g4q9bDluoyhE1auZtv7mUi985hhTv2VJjnL5lcQx/GXl7S5OEbxP63
kkdsmRQ4KJvHaFuMgA1/P0QXM/GtJibU0okCplV7kHb9KOKXGpmkzhLP066s
lz9FxpHNvywq5Ij1vRua+EiZhb+bvy4x8CVDV2bFhnping5N2xRcIOZp3OhT
F0FiniasM+JT28fCnJfCK8W7LJiSpiI6P5GwfW61hj6TBaV7eTVu6URO9lEI
v32PhNISDwVlrQnclOTMukDkmUMDEo6l1/5b/9G2EWTdXyzwcQj99CRyy22z
K0f8idyyhz/Fy4XQK6+9gkwL4edxyfVWgRQS/Fc+F3jzahzb00t7ZwidS+6+
fK/UmAzKIeadmc5RbG2WOPr0DxObbrmdqp8gQ8WN6rdQykDY286cA8+Z6Fvx
4W5BEgX3LiQLL/gMIU+JnXkPTOicLfxqc56KZoZBUO3eARzcvf73wR5iPpya
uFC+oQvTF45u7MqkIf/Aw0n90+MY3/+x5umSbghNbFwddL0Pzk/NnbiHx/BP
gPTo1pduZB28FRvU3Y07Dx6ELfEew8wj7ifeQT0YNrA1nn5MhV72c7lXa8Yw
fU2sxlquFxG0NVU81WT4bxMOetI6Cm6Wg4tNSi98ZIe6jpwgYWr2T/JE3Cj8
DVWCC3n68Jy74mGmaSfm5P5VaDqPYpVj0tHDR/tQce582BijA5XFPnU9JqO4
n+c8+vBqH87uI2ulkjvwvqj7x8Ujo3DV9Er55t6HmNm64ErBToSXq9duOD+K
2+b53+LP9UEgKus1b28nkDBfXR84ikB5HcOrm/pQrN4y4idFRpaDttTyglEk
LLQ9amzthcPbFdd5ifkQ1Oz0c3ZuFNtXuFv+tOzFvnupMydoXbDh3lv43ngM
y0IHjtp87oFK0XIRkmkvVvGrxPTlj+FK8lGNy1I94Hq3i81QgAYp08NDNpvG
sdp/OiDRvBtRT0QOWMXSMRk47KNN+JwUIyR1XWAXqvSPxy0JH4TnE92FdyJM
+N6Yedz8noo9R8WLEluGUdQ1HxTsycR6lwc8rEkKvs57NJn+HUHtm9i5rSQm
JBpqf5zdRUEMt3f/x8kxfPTWylbaTPjwtFAk5z0i1yV+nYgMZcKYUqQ+Q+RS
RX+GCD8XkQObOTq2EPnJW2+blOkzwufPys1kpBJ951DtXlu1CTRtLil2InKR
vvr08Uz3/9Z/e5qM/q8mFtr3r8zJJuZLmg4vbQmRz2fSMgevEjlz/uRT2TIi
t7xckEm/RuTM9w3LapStxzB0wDu2jzgfQTf2vvOoIMNzhbluUjkDE6uF5KMI
nTuyLPduIXT+R/4+h8znQTimtTDk1jIRc1jX6F8iFVeEG6nvt9ChpH+g0ixo
HE7Bj6zXlHWh6byaWgZfH5qVeEIG2sfQmh3o1DzejYGHcClYoCKE1qrtt20M
WqLPthty96JmWZJc5TEiJ5bNpFsS+hQP9hTNWdaHbXsr10q0tkMmK0Cu4NsI
dCosk1pa+8B9qT0wfHUbjn1zn1pB5CCDmKM8tk79UF4yF3jsTQse6DdL3mph
4CvD9L0bsx8xH01bI3Y248+vG4ZBzgywpp/vrF1Pg/aNCJfdxV+wQv6kkOIW
Bj6tGXD6pE+DXse/RFFWIw68If2252Lgj9AhvhZzGi6+HulNqmtEl8dmyVVs
DARGjmDckoY3vM51RUZfIBW6wm67GAOqdRV3xI7RMDwXlV3r34TNvptZ9UeJ
HMThymmiSkPuZHtqlmILzkouZedMYeDF9eekED4aXjuMnbB0awUjMOHZIJGD
3tzRkb2W2o8Qv5KDMivacTPTfN3a9BH48h/O4Bfpx+qqh6vc/nRA3DVSlmQx
isc0vz1VF/ug5rEqbP4iBeNF6bb3WKP4mi2tdux6L+IDFUXiTXpwOyiaJRU5
hk7jvWnNNj3Y2/6G6adHw8ydFokNGuM4w9Zt/0uzGw57jHS/+Q/AKrjtr9j4
ODguctUn8Xeh8o8a1/OwYRjpTOtVOjJxScTlgDUPFSfHqUu+nByFhC7PzRXD
THQllceXiFEQZ9Snn/hmHBqCWb2fD7DgdHS9/upjZLRE+v11sSD65ibJJhbR
RyxtJabPV5LwPKiH15zI82FXFzS0iDy/JMZpgNfzv/WvzPFA3zyJ6NUH/Vdx
En10qYWT0aHXRK+0T2+Q/TwOLrUfj2OPsqCQP5AWrE8mcltcC+/vEfBH509d
I/pld8b1iJbdFJRMvl3+0H8IHU6e5M3aTNwx6jiheI5K3F9Yn+Q2Opzl2w0b
CJ3X2ryhmJV2QSl43W2h8R4oBDpMX0olfLhH/q2ORg+KY7bs/P2eDMc3h7+f
ah5FpWYRS+t1L7RdLVXt8trRd6S5qn14BD2xw5SA7j70jl/g9mZvxWblK5vx
jQElrenbR770w+VfjflL6y+YeJUWuFOSgeslB72fHqVhNrE8NSrwM6rbGH65
l4YxsEVfa0MqDff8rLkrXD7iXEpOa3PPEMxHA15/GKNhtEHeR0nvAwZ8FS5e
NxhC1i4r2455Gk4az+daXq/Feyu18tv0QXgP8TmTltHhMHzmlTVXLagSAasE
0gcxXp8jOS5A+GZAnvD67zXw4938PPT5IDy+Ptm3VoiOS2H6Wh57alHV+a6C
WjuIXemfeG8tp6NjTKZXaLAWQ06mjmdEhzD7+duDX+x0rD7c9CBi9AN6i3/z
9T4awrB7zWGXaeK+rNyF8+XqENUwFlW2ZRirOA7u4KyloXzZw51cbxuwf8mo
o8cX4n7zzh0odiPm6KqN59MWmuHQmFtZHc2AouFegX+raHDpLbLMCGvDefXQ
rbtvjEDqWZztcr1+qJjk+sy97ISr3rOd0jdGEcqbStZT6wNNfsLtXW4XVi1f
oOUcHIP6TuvY0509+Lq13FiVl4ZNzNY/VzeOQynvaNB3y25serLrz7rvAyj5
OC0k/3ccfkLzpBwGFefb9VrPPmSgbvJGyg+ix1+cP/LCJJOCs5vXq5wrGIOb
nNX3EFkWlrfVb9BJJqM+fnVl1D8mDto0aDYFsCCjJzbj10fC1RjD1aabJnCP
673NMNGXL7wbrC/y/m/9R+3kFzS4yoLntXvLa2NZ2EiZtywtJOEwdfqNtuA4
ApzC1F8pEvlI2qN0XRAZ16VM0jsDGdBfHaf0Jo4Jf46jH/tyKTh