(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    331544,       9090]
NotebookOptionsPosition[    314376,       8830]
NotebookOutlinePosition[    314697,       8844]
CellTagsIndexPosition[    314654,       8841]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]1", "=", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
   RowBox[{"\[Sigma]2", "=", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", "\[ImaginaryI]"}]},
       {"\[ImaginaryI]", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
   RowBox[{"\[Sigma]3", "=", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
   RowBox[{"\[Sigma]0", "=", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"id", "=", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0", "0", "0"},
        {"0", "1", "0", "0"},
        {"0", "0", "1", "0"},
        {"0", "0", "0", "1"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "<", "6"}], ",", 
      RowBox[{"i", "++"}], ",", 
      RowBox[{"Print", "[", 
       RowBox[{
        RowBox[{"\[Gamma]", "[", "i", "]"}], "//", "MatrixForm"}], "]"}]}], 
     "]"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Gamma]", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]", "[", "a", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "b", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Gamma]", "[", "b", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "a", "]"}]}]}], 
     RowBox[{"2", "\[ImaginaryI]"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"dahat", "=", 
    RowBox[{"da", "/", 
     SuperscriptBox["k", "2"]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"d", "[", "1", "]"}], "=", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["3"]}], "kz", " ", "ky"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"d", "[", "2", "]"}], "=", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["3"]}], "kx", " ", "kz"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "3", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["3"]}], "kx", " ", "ky"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "4", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SqrtBox["3"], "2"]}], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "5", "]"}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["kz", "2"]}], "-", 
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jx", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      SqrtBox["3"], "2"], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"1", ",", "5"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"1", ",", "4"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jy", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox["3"], "2"]}], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"2", ",", "5"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"2", ",", "4"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jz", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"3", ",", "4"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"\[Gamma]", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "/", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"heliop", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"kx", " ", "jx"}], "+", 
     RowBox[{"ky", " ", "jy"}], "+", 
     RowBox[{"kz", " ", "jz"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]]]}], ";", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ConjugateTranspose", "[", "heliop", "]"}], "\[Equal]", 
     "heliop"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
      "Reals"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "i", "]"}], 
      RowBox[{"\[Gamma]", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", "H", "]"}], "\[Equal]", "H"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kx", ",", "ky", ",", "kz", ",", "hbar", ",", "m"}], "}"}], " ",
      "\[Element]", " ", "Reals"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H", "//", "MatrixForm"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"hev", ",", "hvec"}], "}"}], "=", 
   RowBox[{
    RowBox[{"Eigensystem", "[", "H", "]"}], "//", "FullSimplify"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6312382022915897`*^9, 3.631238225759459*^9}, {
   3.6312382600929537`*^9, 3.6312384017277803`*^9}, {3.631238501848529*^9, 
   3.631238514655388*^9}, {3.631238557337954*^9, 3.631238582703508*^9}, {
   3.631238697418057*^9, 3.6312387608920393`*^9}, {3.631238821822587*^9, 
   3.6312388336171837`*^9}, {3.6312388682255707`*^9, 3.63123894870654*^9}, 
   3.631241459271804*^9, 3.6312415058351183`*^9, {3.631242162714487*^9, 
   3.631242164860416*^9}, {3.631243821329649*^9, 3.6312438323099318`*^9}, {
   3.631243931067396*^9, 3.631243943321344*^9}, {3.631245485411551*^9, 
   3.631245507064893*^9}, {3.631245606183861*^9, 3.631245636233708*^9}, {
   3.631246369852314*^9, 3.631246410769082*^9}, {3.63124927017979*^9, 
   3.63124930420273*^9}, {3.631249422231785*^9, 3.631249432782104*^9}, {
   3.631249677286726*^9, 3.631249702711062*^9}, {3.631285101024441*^9, 
   3.631285106140984*^9}, {3.631285140088323*^9, 3.6312852358940573`*^9}, 
   3.631287438641325*^9, {3.631295671787744*^9, 3.631295675200363*^9}, {
   3.631296743735948*^9, 3.631296768464766*^9}, {3.631303956396132*^9, 
   3.6313039785131187`*^9}, {3.631363753884413*^9, 3.63136377298313*^9}, 
   3.631414086575067*^9, {3.631551950532612*^9, 3.631551957383226*^9}, 
   3.6315519991082993`*^9, {3.711821084066185*^9, 3.7118211139118958`*^9}, {
   3.711821392685665*^9, 3.71182150933855*^9}, {3.711821576479093*^9, 
   3.711821735961163*^9}, {3.7118217742380238`*^9, 3.711821848019948*^9}, {
   3.7118243385720043`*^9, 3.7118243649817753`*^9}, {3.791635199064434*^9, 
   3.7916351998898697`*^9}, {3.791635240893931*^9, 3.791635271070931*^9}, {
   3.7916989554337587`*^9, 3.791699011694659*^9}, {3.791699220344425*^9, 
   3.7916992243495007`*^9}, {3.793285310917283*^9, 3.793285382214959*^9}, 
   3.7932854170599613`*^9, {3.793289452492737*^9, 3.793289484441792*^9}, {
   3.7932896660812807`*^9, 3.793289841998481*^9}, {3.793289891379719*^9, 
   3.793289892417851*^9}, {3.793290351027391*^9, 3.793290355405057*^9}, {
   3.793291130069296*^9, 3.7932911431580067`*^9}, {3.793292961739395*^9, 
   3.793292967199719*^9}, {3.793293074589245*^9, 3.79329307482631*^9}, {
   3.793294461752306*^9, 3.793294467116612*^9}, {3.793294918344966*^9, 
   3.793294919689682*^9}, {3.7932956341748857`*^9, 3.793295727384449*^9}, {
   3.79329737851399*^9, 3.793297433974655*^9}, {3.7932975077334547`*^9, 
   3.793297538349098*^9}, {3.7932998205378847`*^9, 3.793299848528409*^9}, 
   3.793299889094743*^9, {3.793674231270626*^9, 3.7936742450962887`*^9}, {
   3.7937817920044327`*^9, 3.793781795642913*^9}, 3.795526912956121*^9},
 CellLabel->
  "In[198]:=",ExpressionUUID->"67e2fc9a-96ed-4e72-a98f-6596d95f32cf"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.791635224093143*^9, 3.7916352718181877`*^9}, 
   3.7916990172325773`*^9, 3.7916992248987293`*^9, 3.79170214336018*^9, 
   3.7918990737325373`*^9, 3.7918992160210667`*^9, {3.791961843697666*^9, 
   3.7919618441791153`*^9}, 3.791963591972145*^9, 3.7920485010103827`*^9, {
   3.793285367265944*^9, 3.793285383128933*^9}, 3.7932854175960073`*^9, 
   3.793289542015047*^9, 3.793289843639975*^9, 3.793289893509777*^9, 
   3.79329038845033*^9, 3.793291144286193*^9, 3.793292968086597*^9, 
   3.793293075802154*^9, 3.793294468261157*^9, 3.7932949209317904`*^9, {
   3.793295666798345*^9, 3.7932956714986343`*^9}, {3.793295701881929*^9, 
   3.793295728409088*^9}, 3.7932973957959957`*^9, 3.793297539787835*^9, {
   3.7932998517078876`*^9, 3.793299852231291*^9}, 3.793299891626095*^9, 
   3.7933093561304607`*^9, 3.793338570690497*^9, {3.79351692439898*^9, 
   3.79351692497712*^9}, {3.793521058139284*^9, 3.793521058781296*^9}, 
   3.793523614564328*^9, 3.793597823378051*^9, {3.7936742505621853`*^9, 
   3.793674254288794*^9}, {3.793709828920711*^9, 3.793709832709374*^9}, {
   3.793781768039331*^9, 3.793781796370191*^9}, 3.7955264305374193`*^9, 
   3.7955266417980843`*^9, 3.795526916624502*^9, 3.795527434576364*^9},
 CellLabel->
  "Out[214]=",ExpressionUUID->"ca5f070b-f03e-4647-aba2-0a2a4ee5c4e5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.791635224093143*^9, 3.7916352718181877`*^9}, 
   3.7916990172325773`*^9, 3.7916992248987293`*^9, 3.79170214336018*^9, 
   3.7918990737325373`*^9, 3.7918992160210667`*^9, {3.791961843697666*^9, 
   3.7919618441791153`*^9}, 3.791963591972145*^9, 3.7920485010103827`*^9, {
   3.793285367265944*^9, 3.793285383128933*^9}, 3.7932854175960073`*^9, 
   3.793289542015047*^9, 3.793289843639975*^9, 3.793289893509777*^9, 
   3.79329038845033*^9, 3.793291144286193*^9, 3.793292968086597*^9, 
   3.793293075802154*^9, 3.793294468261157*^9, 3.7932949209317904`*^9, {
   3.793295666798345*^9, 3.7932956714986343`*^9}, {3.793295701881929*^9, 
   3.793295728409088*^9}, 3.7932973957959957`*^9, 3.793297539787835*^9, {
   3.7932998517078876`*^9, 3.793299852231291*^9}, 3.793299891626095*^9, 
   3.7933093561304607`*^9, 3.793338570690497*^9, {3.79351692439898*^9, 
   3.79351692497712*^9}, {3.793521058139284*^9, 3.793521058781296*^9}, 
   3.793523614564328*^9, 3.793597823378051*^9, {3.7936742505621853`*^9, 
   3.793674254288794*^9}, {3.793709828920711*^9, 3.793709832709374*^9}, {
   3.793781768039331*^9, 3.793781796370191*^9}, 3.7955264305374193`*^9, 
   3.7955266417980843`*^9, 3.795526916624502*^9, 3.7955274346494827`*^9},
 CellLabel->
  "Out[216]=",ExpressionUUID->"c4f1e460-a5bc-49ff-b683-239a9fb3549d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}]}], 
        RowBox[{"2", " ", "kz"}]], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["kz", "2"]}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
         "kz"}]], ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"2", " ", "kz"}]], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}], 
        RowBox[{"2", " ", "kz"}]], ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"2", " ", "kz"}]], ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.791635224093143*^9, 3.7916352718181877`*^9}, 
   3.7916990172325773`*^9, 3.7916992248987293`*^9, 3.79170214336018*^9, 
   3.7918990737325373`*^9, 3.7918992160210667`*^9, {3.791961843697666*^9, 
   3.7919618441791153`*^9}, 3.791963591972145*^9, 3.7920485010103827`*^9, {
   3.793285367265944*^9, 3.793285383128933*^9}, 3.7932854175960073`*^9, 
   3.793289542015047*^9, 3.793289843639975*^9, 3.793289893509777*^9, 
   3.79329038845033*^9, 3.793291144286193*^9, 3.793292968086597*^9, 
   3.793293075802154*^9, 3.793294468261157*^9, 3.7932949209317904`*^9, {
   3.793295666798345*^9, 3.7932956714986343`*^9}, {3.793295701881929*^9, 
   3.793295728409088*^9}, 3.7932973957959957`*^9, 3.793297539787835*^9, {
   3.7932998517078876`*^9, 3.793299852231291*^9}, 3.793299891626095*^9, 
   3.7933093561304607`*^9, 3.793338570690497*^9, {3.79351692439898*^9, 
   3.79351692497712*^9}, {3.793521058139284*^9, 3.793521058781296*^9}, 
   3.793523614564328*^9, 3.793597823378051*^9, {3.7936742505621853`*^9, 
   3.793674254288794*^9}, {3.793709828920711*^9, 3.793709832709374*^9}, {
   3.793781768039331*^9, 3.793781796370191*^9}, 3.7955264305374193`*^9, 
   3.7955266417980843`*^9, 3.795526916624502*^9, 3.795527434795075*^9},
 CellLabel->
  "Out[218]=",ExpressionUUID->"44dce660-ea57-4115-8313-a7e544b15587"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7935169382954617`*^9, 3.793516942280922*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"69221881-ed58-4125-8ff6-def120d1a2bb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "ky"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], "0"},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}]},
     {"0", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "ky"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.793516942904583*^9, 3.795526642043789*^9, 
  3.7955274348562107`*^9},
 CellLabel->
  "Out[219]//MatrixForm=",ExpressionUUID->"3f0cc762-a040-4c40-acc2-\
32fdae1d4a07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{
   RowBox[{"Eigensystem", "[", "heliop", "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", "vals", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ex", "=", 
   RowBox[{
    RowBox[{"Conjugate", "[", 
     RowBox[{"vecs", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], ".", 
    RowBox[{"vecs", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ex", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
     "Reals"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.793285424070766*^9, 3.7932854324713993`*^9}, {
   3.793289902726655*^9, 3.793289905683298*^9}, {3.793297068357245*^9, 
   3.7932971804481153`*^9}, {3.7932975774961567`*^9, 3.793297577896965*^9}, {
   3.793297786906384*^9, 3.7932978337101088`*^9}, 3.793338567554357*^9},
 CellLabel->
  "In[220]:=",ExpressionUUID->"39df0fd4-b3b8-44d3-a9a8-017fd111a02e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["kz", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["kx", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["ky", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kz", "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"kz", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "kz"}], "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "-", 
            RowBox[{"2", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{"kz", "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"kx", "-", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "kz"}], "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"2", " ", "kz", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "kz"}], "+", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["kx", "2"], "+", 
                 SuperscriptBox["ky", "2"], "+", 
                 SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"kx", "-", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["kx", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["ky", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["kz", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "kz"}], "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["kx", "2"], "+", 
              SuperscriptBox["ky", "2"], "+", 
              SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", "1"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.793294892415533*^9, 3.793294933044524*^9, 3.793295784914626*^9, {
   3.7932971169155197`*^9, 3.793297146070938*^9}, 3.793297182065576*^9, 
   3.793297579421938*^9, 3.793297789466765*^9, 3.793297835195006*^9, 
   3.793299863264146*^9, 3.7933385722513866`*^9, 3.793674276749305*^9, 
   3.7955266428965063`*^9, 3.795527435450001*^9},
 CellLabel->
  "Out[220]=",ExpressionUUID->"48a7ea34-09d7-4fda-bd7b-994b25ed3452"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "2"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.793294892415533*^9, 3.793294933044524*^9, 3.793295784914626*^9, {
   3.7932971169155197`*^9, 3.793297146070938*^9}, 3.793297182065576*^9, 
   3.793297579421938*^9, 3.793297789466765*^9, 3.793297835195006*^9, 
   3.793299863264146*^9, 3.7933385722513866`*^9, 3.793674276749305*^9, 
   3.7955266428965063`*^9, 3.795527435454197*^9},
 CellLabel->
  "Out[221]=",ExpressionUUID->"8b9dffcf-a448-4872-bb64-c691bbf584e7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.793294892415533*^9, 3.793294933044524*^9, 3.793295784914626*^9, {
   3.7932971169155197`*^9, 3.793297146070938*^9}, 3.793297182065576*^9, 
   3.793297579421938*^9, 3.793297789466765*^9, 3.793297835195006*^9, 
   3.793299863264146*^9, 3.7933385722513866`*^9, 3.793674276749305*^9, 
   3.7955266428965063`*^9, 3.795527435517427*^9},
 CellLabel->
  "Out[223]=",ExpressionUUID->"56a6de23-09df-4897-b240-08cd2376047c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H", ".", "heliop"}], "==", 
    RowBox[{"heliop", ".", "H"}]}], "//", "FullSimplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7932889322699127`*^9, 3.793288983335696*^9}, {
  3.7932911766810303`*^9, 3.793291191985404*^9}, {3.7932951442665043`*^9, 
  3.793295150211667*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"07584aa9-ce83-4086-98a9-459d23e620fe"],

Cell[BoxData[
 TagBox["True",
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7932937115129757`*^9, 3.793294472355369*^9, 
  3.793294949610053*^9, 3.7932951511393957`*^9, 3.793299865105338*^9, 
  3.7936742808987713`*^9, 3.795526643232432*^9, 3.795527435678411*^9},
 CellLabel->
  "Out[224]//MatrixForm=",ExpressionUUID->"9d8cf0d1-2ea0-4dc6-84c7-\
2c24d8a68cf8"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"e516813a-fa9c-4550-acaf-5f6c146b820a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"a", ",", "b", ",", "ev", ",", "exp", ",", "sol"}], "]"}], ";", 
   RowBox[{"heli32", "=", 
    RowBox[{
     RowBox[{"b", " ", 
      RowBox[{"hvec", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "+", 
     RowBox[{"hvec", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"we", " ", "need", " ", 
     RowBox[{"heliop", ".", "heli32"}]}], "=", 
    RowBox[{"\[Lambda]", " ", "heli32"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H", ".", "heli32"}], " ", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}], ")"}]}], "heli32"}]}], " ", "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"heliop", ".", "heli32"}], "-", 
      RowBox[{"ev", " ", "heli32"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
       "Reals"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "//", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"exp", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "  ", "&&", " ", 
      RowBox[{
       RowBox[{"exp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "ev"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.793293136585647*^9, 3.793293336219116*^9}, {
   3.79329343929108*^9, 3.793293444003962*^9}, {3.793293580223236*^9, 
   3.79329358257761*^9}, {3.793293700868144*^9, 3.793293707251787*^9}, {
   3.793293765885274*^9, 3.793293766901696*^9}, {3.793293811010453*^9, 
   3.793293830965603*^9}, {3.793293877118586*^9, 3.793293887788439*^9}, {
   3.7932940194771967`*^9, 3.793294055996015*^9}, 3.793294109772057*^9, {
   3.793294489217806*^9, 3.793294499394248*^9}, {3.793294670076448*^9, 
   3.793294682168158*^9}, 3.793294732837225*^9, {3.793294798237919*^9, 
   3.7932948558552847`*^9}, 3.793295086324093*^9, 3.793295117256835*^9, {
   3.7932958099610157`*^9, 3.7932958301254883`*^9}, {3.79329587001764*^9, 
   3.793295872365869*^9}, {3.793295914736003*^9, 3.7932959221904287`*^9}, {
   3.7932959962952414`*^9, 3.793296014598578*^9}, {3.793296567127432*^9, 
   3.793296568950618*^9}, {3.793296676471569*^9, 3.793296718708149*^9}, {
   3.793296779303957*^9, 3.79329678969697*^9}, {3.793299904631576*^9, 
   3.793299953155703*^9}, {3.793299998111871*^9, 3.793300009913322*^9}, {
   3.7933000449541483`*^9, 3.793300050750515*^9}, 3.793674286872213*^9, 
   3.7955269286372633`*^9},
 CellLabel->
  "In[225]:=",ExpressionUUID->"189bf48e-9aaa-476a-813a-90250ceb1d01"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.793296703623495*^9, 3.793296720011943*^9}, 
   3.7932967912481403`*^9, {3.793299923810137*^9, 3.7932999537812557`*^9}, 
   3.79330001051882*^9, 3.793300077856134*^9, 3.793300569421637*^9, 
   3.793674288759212*^9, 3.795526643332551*^9, 3.795526929283009*^9, 
   3.795527435740444*^9},
 CellLabel->
  "Out[226]=",ExpressionUUID->"08990089-c69b-42ea-a5c6-5f8dcbbc8110"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], ",", 
     RowBox[{"ev", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], ",", 
     RowBox[{"ev", "\[Rule]", 
      FractionBox["3", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.793296703623495*^9, 3.793296720011943*^9}, 
   3.7932967912481403`*^9, {3.793299923810137*^9, 3.7932999537812557`*^9}, 
   3.79330001051882*^9, 3.793300077856134*^9, 3.793300569421637*^9, 
   3.793674288759212*^9, 3.795526643332551*^9, 3.795526929283009*^9, 
   3.795527436884714*^9},
 CellLabel->
  "Out[229]=",ExpressionUUID->"c2b6aaf1-91f7-4152-a208-7cb707dbb257"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "check", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"a", ",", "b", ",", "ev", ",", "exp1", ",", "heli32"}], "]"}], 
    ";", 
    RowBox[{"exp1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"hvec", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "+", 
        RowBox[{"hvec", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "//", "FullSimplify"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"heliop", ".", "exp1"}], "-", 
       RowBox[{"ev", " ", "exp1"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
        "Reals"}]}]}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**"}], "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"a", ",", "b", ",", "ev", ",", "exp2"}], "]"}], ";", 
    RowBox[{"exp2", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"hvec", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "+", 
        RowBox[{"hvec", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "//", "FullSimplify"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"heliop", ".", "exp2"}], "-", 
       RowBox[{"ev", " ", "exp2"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
        "Reals"}]}]}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"**", "**", " ", "are"}], " ", "they", " ", 
     RowBox[{"orthogonal", " ", "?"}]}], " ", "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp2"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
       "Reals"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.793296838822146*^9, 3.793296892760311*^9}, {
  3.793297848101389*^9, 3.793297907103842*^9}, {3.7933000266637173`*^9, 
  3.793300159081195*^9}},
 CellLabel->
  "In[230]:=",ExpressionUUID->"1d426b98-b384-4b0a-91c6-1b964c87ce93"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"kz", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "kz"}], "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], 
    RowBox[{"kx", "+", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        RowBox[{"2", " ", "kz", " ", 
         RowBox[{"(", 
          RowBox[{"kz", "-", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.793297909380443*^9, 3.793300067619437*^9, {3.793300136505172*^9, 
   3.793300159807178*^9}, {3.793300556113772*^9, 3.793300572474334*^9}, 
   3.793674303852929*^9, 3.7955266461198883`*^9, 3.795527437083302*^9},
 CellLabel->
  "Out[230]=",ExpressionUUID->"07755171-4880-4704-8937-1b718e542444"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.793297909380443*^9, 3.793300067619437*^9, {3.793300136505172*^9, 
   3.793300159807178*^9}, {3.793300556113772*^9, 3.793300572474334*^9}, 
   3.793674303852929*^9, 3.7955266461198883`*^9, 3.795527438110168*^9},
 CellLabel->
  "Out[231]=",ExpressionUUID->"c8ecc29f-3771-484a-b691-af65d5f6ec4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"kz", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}], 
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        RowBox[{"2", " ", "kz", " ", 
         RowBox[{"(", 
          RowBox[{"kz", "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.793297909380443*^9, 3.793300067619437*^9, {3.793300136505172*^9, 
   3.793300159807178*^9}, {3.793300556113772*^9, 3.793300572474334*^9}, 
   3.793674303852929*^9, 3.7955266461198883`*^9, 3.795527438237007*^9},
 CellLabel->
  "Out[232]=",ExpressionUUID->"27e6b293-194e-40ef-a01d-008a0b2e8dc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.793297909380443*^9, 3.793300067619437*^9, {3.793300136505172*^9, 
   3.793300159807178*^9}, {3.793300556113772*^9, 3.793300572474334*^9}, 
   3.793674303852929*^9, 3.7955266461198883`*^9, 3.795527438912545*^9},
 CellLabel->
  "Out[233]=",ExpressionUUID->"d6885ac3-5020-479e-aba0-5c3783e184be"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.793297909380443*^9, 3.793300067619437*^9, {3.793300136505172*^9, 
   3.793300159807178*^9}, {3.793300556113772*^9, 3.793300572474334*^9}, 
   3.793674303852929*^9, 3.7955266461198883`*^9, 3.79552743899373*^9},
 CellLabel->
  "Out[234]=",ExpressionUUID->"d42c803d-3a70-430b-9bac-e3d999860851"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"a55ed502-0753-4548-9e06-7d034a4dac8c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a", ",", "b", ",", "ev", ",", "exp", ",", "sol"}], "]"}], ";", 
  RowBox[{"heli12", "=", " ", 
   RowBox[{
    RowBox[{"hvec", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"hvec", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H", ".", "heli12"}], " ", "\[Equal]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}], "heli12"}]}], " ", "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"heliop", ".", "heli12"}], "-", 
      RowBox[{"ev", " ", "heli12"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
       "Reals"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "//", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"exp", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "  ", "&&", " ", 
      RowBox[{
       RowBox[{"exp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "ev"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.793293136585647*^9, 3.793293336219116*^9}, {
   3.79329343929108*^9, 3.793293444003962*^9}, {3.793293580223236*^9, 
   3.79329358257761*^9}, {3.793293700868144*^9, 3.793293707251787*^9}, {
   3.793293765885274*^9, 3.793293766901696*^9}, {3.793293811010453*^9, 
   3.793293830965603*^9}, {3.793293877118586*^9, 3.793293887788439*^9}, {
   3.7932940194771967`*^9, 3.793294055996015*^9}, 3.793294109772057*^9, {
   3.793294489217806*^9, 3.793294499394248*^9}, {3.793294670076448*^9, 
   3.793294682168158*^9}, 3.793294732837225*^9, {3.793294798237919*^9, 
   3.7932948558552847`*^9}, 3.793295086324093*^9, 3.793295117256835*^9, {
   3.7932958099610157`*^9, 3.7932958301254883`*^9}, {3.79329587001764*^9, 
   3.793295872365869*^9}, {3.793295914736003*^9, 3.7932959221904287`*^9}, {
   3.7932959962952414`*^9, 3.793296014598578*^9}, {3.793296567127432*^9, 
   3.793296568950618*^9}, {3.793300169281537*^9, 3.793300279226246*^9}, 
   3.7936743118076572`*^9, 3.795526936539445*^9},
 CellLabel->
  "In[235]:=",ExpressionUUID->"a9a4d3b1-f858-44f7-8882-496a0389374c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.793293298752849*^9, 3.793293301766059*^9}, 
   3.7932933658411303`*^9, 3.7932934467339067`*^9, 3.7932935843319063`*^9, 
   3.79329376826694*^9, {3.793293812544054*^9, 3.793293832125759*^9}, 
   3.7932938890041313`*^9, {3.7932940465533457`*^9, 3.793294057177031*^9}, 
   3.7932941113853273`*^9, 3.793294500486977*^9, {3.793294675144635*^9, 
   3.7932946829929934`*^9}, 3.793294733914151*^9, {3.793294799631422*^9, 
   3.793294857774742*^9}, 3.7932949632734327`*^9, {3.793295088202825*^9, 
   3.793295118182934*^9}, 3.793295831506424*^9, 3.7932958736505404`*^9, 
   3.793295922973815*^9, {3.793295997467339*^9, 3.7932960154915113`*^9}, {
   3.7933002135071*^9, 3.7933002799945383`*^9}, 3.793300353567379*^9, 
   3.793300575340385*^9, 3.793674312988741*^9, 3.795526647573009*^9, 
   3.795526937259056*^9, 3.7955274391887913`*^9},
 CellLabel->
  "Out[236]=",ExpressionUUID->"41edf5e3-e5e3-4950-b785-cea8cc5173bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "-", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], ",", 
     RowBox[{"ev", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "kz"}], "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["kx", "2"], "+", 
                SuperscriptBox["ky", "2"], "+", 
                SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], ",", 
     RowBox[{"ev", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.793293298752849*^9, 3.793293301766059*^9}, 
   3.7932933658411303`*^9, 3.7932934467339067`*^9, 3.7932935843319063`*^9, 
   3.79329376826694*^9, {3.793293812544054*^9, 3.793293832125759*^9}, 
   3.7932938890041313`*^9, {3.7932940465533457`*^9, 3.793294057177031*^9}, 
   3.7932941113853273`*^9, 3.793294500486977*^9, {3.793294675144635*^9, 
   3.7932946829929934`*^9}, 3.793294733914151*^9, {3.793294799631422*^9, 
   3.793294857774742*^9}, 3.7932949632734327`*^9, {3.793295088202825*^9, 
   3.793295118182934*^9}, 3.793295831506424*^9, 3.7932958736505404`*^9, 
   3.793295922973815*^9, {3.793295997467339*^9, 3.7932960154915113`*^9}, {
   3.7933002135071*^9, 3.7933002799945383`*^9}, 3.793300353567379*^9, 
   3.793300575340385*^9, 3.793674312988741*^9, 3.795526647573009*^9, 
   3.795526937259056*^9, 3.795527440955204*^9},
 CellLabel->
  "Out[239]=",ExpressionUUID->"3902a325-8542-4459-929e-c1697409e368"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "check", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"a", ",", "b", ",", "ev", ",", "heli32"}], "]"}], ";", 
    RowBox[{"exp3", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"hvec", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"hvec", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}]}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "//", "FullSimplify"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"heliop", ".", "exp3"}], "-", 
       RowBox[{"ev", " ", "exp3"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
        "Reals"}]}]}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**"}], "******)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"a", ",", "b", ",", "ev"}], "]"}], ";", 
    RowBox[{"exp4", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"hvec", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"hvec", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}]}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "//", "FullSimplify"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"heliop", ".", "exp4"}], "-", 
       RowBox[{"ev", " ", "exp4"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
        "Reals"}]}]}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"**", "**", " ", "are"}], " ", "they", " ", 
     RowBox[{"orthogonal", " ", "?"}]}], " ", "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Conjugate", "[", "exp3", "]"}], ".", "exp4"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
       "Reals"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.793296060395856*^9, 3.79329633064319*^9}, {
   3.793296415464381*^9, 3.793296537148425*^9}, 3.793297928679721*^9, {
   3.7933002903961678`*^9, 3.793300332352191*^9}, {3.793300379885304*^9, 
   3.79330038001159*^9}, {3.7933005401558867`*^9, 3.793300551503701*^9}, {
   3.7933005945907917`*^9, 3.793300614343726*^9}},
 CellLabel->
  "In[240]:=",ExpressionUUID->"d0580710-3d62-4ab3-94a1-77f1141f9bca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"kz", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "-", 
        RowBox[{"2", " ", "kz", " ", 
         RowBox[{"(", 
          RowBox[{"kz", "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", "1"}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.793296127131197*^9, {3.79329615741784*^9, 3.793296187241503*^9}, {
   3.793296297120534*^9, 3.79329633149979*^9}, {3.7932964279448347`*^9, 
   3.793296464907084*^9}, {3.7932964971194277`*^9, 3.793296539764348*^9}, 
   3.793297930094433*^9, {3.79330033703623*^9, 3.793300380838456*^9}, 
   3.793300578079681*^9, 3.793300615282452*^9, 3.7936743204990788`*^9, {
   3.795526635893744*^9, 3.7955266503723907`*^9}, 3.795527441145405*^9},
 CellLabel->
  "Out[240]=",ExpressionUUID->"21cfc5f9-ecd1-409a-ae4b-e42dc6e1ea05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.793296127131197*^9, {3.79329615741784*^9, 3.793296187241503*^9}, {
   3.793296297120534*^9, 3.79329633149979*^9}, {3.7932964279448347`*^9, 
   3.793296464907084*^9}, {3.7932964971194277`*^9, 3.793296539764348*^9}, 
   3.793297930094433*^9, {3.79330033703623*^9, 3.793300380838456*^9}, 
   3.793300578079681*^9, 3.793300615282452*^9, 3.7936743204990788`*^9, {
   3.795526635893744*^9, 3.7955266503723907`*^9}, 3.79552744188571*^9},
 CellLabel->
  "Out[241]=",ExpressionUUID->"0c9c4593-d871-47db-b9ea-0b54ae878fae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "kz"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        RowBox[{"2", " ", "kz", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "kz"}], "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kx", "2"], "+", 
             SuperscriptBox["ky", "2"], "+", 
             SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", "1"}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.793296127131197*^9, {3.79329615741784*^9, 3.793296187241503*^9}, {
   3.793296297120534*^9, 3.79329633149979*^9}, {3.7932964279448347`*^9, 
   3.793296464907084*^9}, {3.7932964971194277`*^9, 3.793296539764348*^9}, 
   3.793297930094433*^9, {3.79330033703623*^9, 3.793300380838456*^9}, 
   3.793300578079681*^9, 3.793300615282452*^9, 3.7936743204990788`*^9, {
   3.795526635893744*^9, 3.7955266503723907`*^9}, 3.795527441959045*^9},
 CellLabel->
  "Out[242]=",ExpressionUUID->"ff23242d-4ac2-4693-848d-4cbdd26f2bba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.793296127131197*^9, {3.79329615741784*^9, 3.793296187241503*^9}, {
   3.793296297120534*^9, 3.79329633149979*^9}, {3.7932964279448347`*^9, 
   3.793296464907084*^9}, {3.7932964971194277`*^9, 3.793296539764348*^9}, 
   3.793297930094433*^9, {3.79330033703623*^9, 3.793300380838456*^9}, 
   3.793300578079681*^9, 3.793300615282452*^9, 3.7936743204990788`*^9, {
   3.795526635893744*^9, 3.7955266503723907`*^9}, 3.795527442659923*^9},
 CellLabel->
  "Out[243]=",ExpressionUUID->"753fdfa4-36ec-4a63-9648-8b359f906757"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.793296127131197*^9, {3.79329615741784*^9, 3.793296187241503*^9}, {
   3.793296297120534*^9, 3.79329633149979*^9}, {3.7932964279448347`*^9, 
   3.793296464907084*^9}, {3.7932964971194277`*^9, 3.793296539764348*^9}, 
   3.793297930094433*^9, {3.79330033703623*^9, 3.793300380838456*^9}, 
   3.793300578079681*^9, 3.793300615282452*^9, 3.7936743204990788`*^9, {
   3.795526635893744*^9, 3.7955266503723907`*^9}, 3.7955274427556343`*^9},
 CellLabel->
  "Out[244]=",ExpressionUUID->"02bba716-db13-485b-b24e-d7bcab7bec99"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"b3ff730d-d206-4c30-a706-d8b8c9f1ce72"],

Cell[CellGroupData[{

Cell["ORTHOGONAL eigenvectors", "Section",
 CellChangeTimes->{{3.79198869646707*^9, 3.7919886987400312`*^9}, {
  3.795527017643969*^9, 
  3.7955270233652782`*^9}},ExpressionUUID->"9f947e13-a59d-4f3a-acf2-\
8af9b24f640d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"exp1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp2", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"kz", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp4", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"H", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}], "id"}]}], ")"}], ".", "exp1"}], "//",
   "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"H", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}], "id"}]}], ")"}], ".", "exp2"}], "//",
   "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"H", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}], "id"}]}], ")"}], ".", "exp3"}], "//",
   "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"H", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}], ")"}], "id"}]}], ")"}], ".", "exp4"}], "//",
   "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.79552642106962*^9, 3.795526425309301*^9}, {
  3.7955266708454113`*^9, 3.795526698805237*^9}, {3.7955270381409273`*^9, 
  3.795527078756143*^9}, {3.795527141709333*^9, 3.79552718242925*^9}},
 CellLabel->
  "In[245]:=",ExpressionUUID->"179b570a-dc9a-4c88-b790-a24a1c6de411"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.795527042661063*^9, {3.795527082153432*^9, 3.795527085786924*^9}, 
   3.795527170211238*^9, 3.795527442872155*^9},
 CellLabel->
  "Out[249]=",ExpressionUUID->"29f25724-750d-4bb8-8f0c-7d0de2fd4b07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795527042661063*^9, {3.795527082153432*^9, 3.795527085786924*^9}, 
   3.795527170211238*^9, 3.795527442874095*^9},
 CellLabel->
  "Out[250]=",ExpressionUUID->"af7e420f-c3e4-47a2-8139-f1f38f822c32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795527042661063*^9, {3.795527082153432*^9, 3.795527085786924*^9}, 
   3.795527170211238*^9, 3.79552744287608*^9},
 CellLabel->
  "Out[251]=",ExpressionUUID->"36dbe8d1-3f3e-4f1f-a039-cc163f5f713e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.795527042661063*^9, {3.795527082153432*^9, 3.795527085786924*^9}, 
   3.795527170211238*^9, 3.795527442920154*^9},
 CellLabel->
  "Out[252]=",ExpressionUUID->"582c57ec-515b-4b18-81af-9f2c3528a7da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp1", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp2", "]"}], ".", "exp3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp2", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", "exp3", "]"}], ".", "exp4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"kx", ",", "ky", ",", "kz"}], "}"}], " ", "\[Element]", " ", 
    "Reals"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7955264340908957`*^9, 3.7955264670475063`*^9}, {
  3.795526731519496*^9, 3.795526742098755*^9}, {3.795526787182971*^9, 
  3.7955268047562943`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"31ce50fc-1431-42eb-8a3c-9baa3a89b045"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055850677`*^9}},
 CellLabel->
  "Out[127]=",ExpressionUUID->"7617bdd3-7b58-40d5-bcdd-b4c17bcf12a5"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.7955268055874357`*^9}},
 CellLabel->
  "Out[128]=",ExpressionUUID->"4c706f98-2ee9-4322-93ef-93ba66eef420"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.795526805590002*^9}},
 CellLabel->
  "Out[129]=",ExpressionUUID->"02b8d011-9609-4d78-806a-98f6a9b5ee63"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.795526805656871*^9}},
 CellLabel->
  "Out[130]=",ExpressionUUID->"f3ad5e03-cecd-4bc8-9160-5fb6b7ac1908"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.79552680571126*^9}},
 CellLabel->
  "Out[131]=",ExpressionUUID->"05d9d4e5-7c73-4e1a-bcb5-c6643310f2c2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7955264414238453`*^9, 3.795526652026074*^9, {3.795526778907249*^9, 
   3.795526805779623*^9}},
 CellLabel->
  "Out[132]=",ExpressionUUID->"3f9946b0-0780-49e7-8536-f9c4815df551"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"en", " ", "<", " ", "V"}], ";", " ", 
    RowBox[{"prthogonal", " ", "basis"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "a1", ",", "a2", ",", "b1", ",", "b2", ",", "v", ",", "vs", ",", "t1", 
      ",", "t2", ",", "r1", ",", "r2", ",", "a1", ",", "a2", ",", "sol", ",", 
      "\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3", ",", "\[Psi]4"}], "]"}], ";", 
    RowBox[{"v", "=", "1"}], ";", 
    RowBox[{"vs", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]1", "[", "kx_", "]"}], "=", "exp3"}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]2", "[", "kx_", "]"}], "=", "exp4"}], 
    RowBox[{"(*", 
     RowBox[{"plus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]3", "[", "kx_", "]"}], "=", "exp1"}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]4", "[", "kx_", "]"}], "=", "exp2"}], 
    RowBox[{"(*", 
     RowBox[{"minus", " ", "en"}], " ", "*)"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy1", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"\[Psi]1", "[", "kx", "]"}], "+", 
         RowBox[{"r1", " ", 
          RowBox[{"\[Psi]1", "[", 
           RowBox[{"-", "kx"}], "]"}]}], "+", 
         RowBox[{"r2", " ", 
          RowBox[{"\[Psi]2", "[", 
           RowBox[{"-", "kx"}], "]"}], "  "}]}], 
        SqrtBox["v"]], "-", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a1", " ", 
           RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
          RowBox[{"a2", " ", 
           RowBox[{"\[Psi]4", "[", "kt", "]"}]}], "+", 
          RowBox[{"b1", " ", 
           RowBox[{"\[Psi]3", "[", 
            RowBox[{"-", "kt"}], "]"}]}], "+", 
          RowBox[{"b2", "  ", 
           RowBox[{"\[Psi]4", "[", 
            RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
        SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"bdy2", "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a1", " ", 
             RowBox[{"\[Psi]3", "[", "kt", "]"}]}], "+", 
            RowBox[{"a2", " ", 
             RowBox[{"\[Psi]4", "[", "kt", "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b1", " ", 
             RowBox[{"\[Psi]3", "[", 
              RowBox[{"-", "kt"}], "]"}]}], "+", 
            RowBox[{"b2", "  ", 
             RowBox[{"\[Psi]4", "[", 
              RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
        SqrtBox["vs"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"t1", " ", 
          RowBox[{"\[Psi]1", "[", "kx", "]"}]}], "+", 
         RowBox[{"t2", " ", 
          RowBox[{"\[Psi]2", "[", "kx", "]"}], "  "}]}], 
        SqrtBox["v"]]}], "//", "Simplify"}]}], ";", 
    RowBox[{"sol", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy1", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"bdy2", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
        "r1", ",", "r2", ",", "t1", ",", "t2", ",", "a1", ",", "a2", ",", 
         "b1", ",", "b2"}], "}"}]}], "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.795345711778309*^9, 3.79534571771926*^9}, {
  3.7954117189360027`*^9, 3.795411750253563*^9}, {3.7954117899241962`*^9, 
  3.795411962019146*^9}, {3.795411995669647*^9, 3.7954121376450768`*^9}, {
  3.7954122123419123`*^9, 3.795412219416184*^9}, {3.795412315463717*^9, 
  3.795412345296678*^9}, {3.7954131552222033`*^9, 3.795413156056336*^9}, {
  3.795413839984623*^9, 3.795413856544154*^9}, {3.795414047428824*^9, 
  3.795414060985321*^9}, {3.7954141482175303`*^9, 3.7954141756907673`*^9}, {
  3.795527198039268*^9, 3.795527244524557*^9}, {3.795527470481882*^9, 
  3.795527470734079*^9}, {3.7955283422388287`*^9, 3.7955283463804827`*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"cbc4e99c-00a1-4079-b5f0-a0e48c75efd9"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r1", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", "kx", " ", "kz"}], "-", 
                 RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
                  SqrtBox[
                   RowBox[{
                    SuperscriptBox["kx", "2"], "+", 
                    SuperscriptBox["ky", "2"], "+", 
                    SuperscriptBox["kz", "2"]}]]}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"kx", "-", 
                   RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["kx", "2"], "+", 
                   SuperscriptBox["ky", "2"], "+", 
                   SuperscriptBox["kz", "2"]}]]}]]}], "-", 
              FractionBox[
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"]], "+", 
              FractionBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", 
                    TemplateBox[{"5"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], 
                   RowBox[{"kt", "-", 
                    RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], "-", 
                  FractionBox[
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   RowBox[{"kt", "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}], " ", 
                RowBox[{"(", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], ")"}]}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}]]}]}], ",", 
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"b2", "\[Rule]", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 278, 23305409684262670996, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 278, 23305409684262670996, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{77., {0., 15.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 278, 23305409684262670996, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{137., {0., 15.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23305409684262670996 === $SessionID, 
   Out[278], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.7955273065401287`*^9, 3.795527525336753*^9, 
  3.7955284131760197`*^9},
 CellLabel->
  "Out[278]=",ExpressionUUID->"82165433-efe3-40e1-9aa9-31b8ad11736f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"t1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"tp2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"t2", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", "sol", "]"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "\[Rule]", "1"}], ",", 
      RowBox[{"vs", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "1"}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.7955274094093*^9, 3.795527415096715*^9}, {
  3.795527609897428*^9, 3.7955276127918262`*^9}, {3.795528199448922*^9, 
  3.7955282555021877`*^9}, {3.795528323816104*^9, 3.795528331046586*^9}, {
  3.795528426564168*^9, 3.7955284368602257`*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"9499f5b3-5f08-4065-91e4-7bb22e6ab9db"],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "kt"}]], " ", "kt", " ", "kx", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}], ")"}]}], 
  RowBox[{
   RowBox[{"6", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", "kt", 
    " ", "kx", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
    SuperscriptBox["kt", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["kx", "2"]}], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}], ")"}]}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{
  3.795527453476103*^9, 3.795527606481181*^9, 3.7955281800730257`*^9, {
   3.795528233149029*^9, 3.795528256904291*^9}, 3.7955283320043507`*^9, 
   3.7955284201303577`*^9, 3.795528636283792*^9, 3.795528870617135*^9},
 CellLabel->
  "Out[283]=",ExpressionUUID->"7e90695d-7716-4cff-8e06-06ebd2f7e7c6"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"", 2, 284, 10, 23305409684262670996, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7955291719043293`*^9},
 CellLabel->
  "During evaluation of \
In[283]:=",ExpressionUUID->"4b73ff31-0eb3-471a-b81a-9009a8c09e9f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.795527453476103*^9, 3.795527606481181*^9, 3.7955281800730257`*^9, {
   3.795528233149029*^9, 3.795528256904291*^9}, 3.7955283320043507`*^9, 
   3.7955284201303577`*^9, 3.795528636283792*^9, 3.7955293508237467`*^9},
 CellLabel->
  "Out[284]=",ExpressionUUID->"4d5c8949-7e0b-4fd5-a3a2-10e8395960a2"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"2edf90d8-39fb-41f2-ac49-6d3df2907b41"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mode matching: QBT", "Section",
 CellChangeTimes->{{3.7935210876629*^9, 
  3.7935210923727903`*^9}},ExpressionUUID->"2f440a01-0ad7-4199-bda8-\
dcfd75705115"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["hbar", "2"], 
      RowBox[{"2", "m"}]], "2", " ", "kl"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"kl", ">", "0"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]phalf", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]mhalf", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[Psi]phalf", "[", "kl", "]"}], "+", 
       RowBox[{"rphalf", " ", 
        RowBox[{"\[Psi]phalf", "[", 
         RowBox[{"-", "kl"}], "]"}]}], "+", 
       RowBox[{"rmhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", 
         RowBox[{"-", "kl"}], "]"}], " "}]}], 
      SqrtBox["v"]], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Alpha]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", "ktilde", "]"}]}], "+", 
       RowBox[{"\[Beta]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", 
         RowBox[{"-", "ktilde"}], "]"}]}], "+", 
       RowBox[{"\[Alpha]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", "ktilde", "]"}]}], "+", 
       RowBox[{"\[Beta]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", 
         RowBox[{"-", "ktilde"}], "]"}]}]}], ")"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]phalf", " ", 
      RowBox[{"\[Psi]phalf", "[", "ktilde", "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Beta]phalf", " ", 
      RowBox[{"\[Psi]phalf", "[", 
       RowBox[{"-", "ktilde"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Alpha]mhalf", " ", 
      RowBox[{"\[Psi]mhalf", "[", "ktilde", "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Beta]mhalf", " ", 
      RowBox[{"\[Psi]mhalf", "[", 
       RowBox[{"-", "ktilde"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "ktilde", " ", "L"}]]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"tphalf", " ", 
        RowBox[{"\[Psi]phalf", "[", "kl", "]"}]}], "+", 
       RowBox[{"tmhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", "kl", "]"}], " "}]}], 
      SqrtBox["v"]]}], "//", "Simplify"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7935211369396677`*^9, 3.7935211764413357`*^9}, {
  3.793521393412196*^9, 3.793521617445672*^9}, {3.793521653436118*^9, 
  3.7935218128799763`*^9}, {3.793522088322768*^9, 3.79352213185317*^9}, {
  3.793522258335759*^9, 3.793522268194682*^9}, {3.79352248609834*^9, 
  3.793522524736121*^9}, {3.793528067730501*^9, 3.79352808340485*^9}, {
  3.7936744745607*^9, 3.793674483797949*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"d7722e1d-1af9-4e24-b0d6-c0139e68652f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "sol", "]"}], ";", 
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
      "rphalf", ",", "rmhalf", ",", "tphalf", ",", "tmhalf", ",", 
       "\[Alpha]phalf", ",", "\[Alpha]mhalf", ",", "\[Beta]phalf", ",", 
       "\[Beta]mhalf"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7935217879778757`*^9, 3.7935217916051188`*^9}, {
  3.793521827833681*^9, 3.7935220055162077`*^9}, {3.793522140102068*^9, 
  3.79352214204574*^9}, {3.793522204105152*^9, 3.793522235501789*^9}, {
  3.793522362442573*^9, 3.7935223744966*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"3e0d44c9-ba64-49f2-923b-20b18fd532c8"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           TemplateBox[{"1"},
            "OutputSizeLimit`Skeleton"], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 118, 23305409684262670996, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 118, 23305409684262670996, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 118, 23305409684262670996, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23305409684262670996 === $SessionID, 
   Out[118], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{{3.79352179212108*^9, 3.793521816001759*^9}, 
   3.793522029980693*^9, 3.793522184836801*^9, 3.793522255326559*^9, 
   3.7935222980298843`*^9, {3.793522371757786*^9, 3.793522394468349*^9}, 
   3.793522569035327*^9, 3.79367455719004*^9, 3.7955266962250566`*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"e670b68a-6626-49f6-8880-5999d45b1f87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", "sol", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7935223155232267`*^9, 3.7935223394519787`*^9}, {
   3.79352238425718*^9, 3.793522402136668*^9}, 3.793522653661982*^9},
 CellLabel->
  "In[119]:=",ExpressionUUID->"bd6824e0-4688-494d-9de3-ba3ff0a326c5"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{{3.7935223275110292`*^9, 3.793522345088601*^9}, 
   3.79352240710684*^9, 3.793522651009643*^9, 3.793674713550076*^9, 
   3.79552677464465*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"09b0a24c-1cd5-4220-8179-0f6b02cf2445"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Flatten", "[", "sol", "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Flatten", "[", "sol", "]"}], "[", 
   RowBox[{"[", "3", "]"}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Flatten", "[", "sol", "]"}], "[", 
   RowBox[{"[", "4", "]"}], "]"}], "//", "Simplify"}]}], "Input",ExpressionUUI\
D->"6c78ea87-803f-41d9-a6e7-4b4ccfae2e42"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"8d6eeb8e-0d7d-43f0-91d7-aa7e7ac830ad"],

Cell[CellGroupData[{

Cell[" large V limit -- trial", "Subsubsection",
 CellChangeTimes->{
  3.7935309351860027`*^9, {3.793620529449806*^9, 
   3.793620532985181*^9}},ExpressionUUID->"35f12838-3059-408a-b3e3-\
9e50af461167"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]phalf", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]mhalf", "[", "kz_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]phalfp", "[", "kl_", "]"}], "=", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"\[Psi]phalf", "[", "kl", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"kl", ",", "\[Infinity]", ",", "0"}], "}"}]}], "]"}], "//", 
   "Normal"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]mhalfp", "[", "kl_", "]"}], "=", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"\[Psi]mhalf", "[", "kl", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"kl", ",", "\[Infinity]", ",", "0"}], "}"}]}], "]"}], "//", 
   "Normal"}]}]}], "Input",
 CellChangeTimes->{{3.793524116733781*^9, 3.793524216205345*^9}, {
  3.79352424769384*^9, 3.793524261329213*^9}, {3.7935243875917673`*^9, 
  3.7935243883437653`*^9}, {3.793525209389654*^9, 3.793525210954156*^9}, {
  3.7937105054612293`*^9, 3.79371050626867*^9}, {3.793710833782002*^9, 
  3.793710839355153*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"0a01d31b-218f-4495-9bbd-6cbe25364bca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl"}], 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}]}], 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7935241327095203`*^9, 3.793524217769154*^9}, 
   3.793524268655246*^9, 3.793524388754013*^9, 3.793525212774076*^9, 
   3.79352674735816*^9, 3.79371026902697*^9, 3.7937105071483183`*^9, 
   3.7937108400382032`*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"a36c21d4-e875-4ee5-b5e4-4835bc36c5b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "kl", " ", 
      RowBox[{"(", 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
   FractionBox[
    RowBox[{"4", " ", "\[ImaginaryI]", " ", "kl"}], 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"4", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["kl", "2"]}], 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]], ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7935241327095203`*^9, 3.793524217769154*^9}, 
   3.793524268655246*^9, 3.793524388754013*^9, 3.793525212774076*^9, 
   3.79352674735816*^9, 3.79371026902697*^9, 3.7937105071483183`*^9, 
   3.793710840134029*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"36f71baa-4cec-487c-802d-7b04d5d310f4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{
    "kl", ",", "v", ",", "bdy1", ",", "bdy2", ",", "\[Psi]mhalf", ",", 
     "\[Psi]phalf", ",", "rphalf", ",", "rmhalf", ",", "tphalf", ",", 
     "tmhalf", ",", "en"}], "]"}], ";", 
   RowBox[{"v", "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["hbar", "2"], 
      RowBox[{"2", "m"}]], "2", "kl"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"kl", ">", "0"}], ";", 
    RowBox[{"en", "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["ktilde", "2"]}]]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]phalf", "[", "kt_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kt"}], "+", " ", "en"}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kt"}], "+", "en"}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kt", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kt"}], "+", "en"}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]mhalf", "[", "kt_", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kt", "+", "en"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kt"}], "+", "en"}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kt", " ", 
           RowBox[{"(", 
            RowBox[{"kt", "+", "en"}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[Psi]phalfp", "[", "kl", "]"}], "+", 
       RowBox[{"rphalf", " ", 
        RowBox[{"\[Psi]phalfp", "[", 
         RowBox[{"-", "kl"}], "]"}]}], "+", 
       RowBox[{"rmhalf", " ", 
        RowBox[{"\[Psi]mhalfp", "[", 
         RowBox[{"-", "kl"}], "]"}], " "}]}], 
      SqrtBox["v"]], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Alpha]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", "ktilde", "]"}]}], "+", 
       RowBox[{"\[Beta]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", 
         RowBox[{"-", "ktilde"}], "]"}]}], "+", 
       RowBox[{"\[Alpha]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", "ktilde", "]"}]}], "+", 
       RowBox[{"\[Beta]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", 
         RowBox[{"-", "ktilde"}], "]"}]}]}], ")"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]phalf", " ", 
      RowBox[{"\[Psi]phalf", "[", "ktilde", "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Beta]phalf", " ", 
      RowBox[{"\[Psi]phalf", "[", 
       RowBox[{"-", "ktilde"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Alpha]mhalf", " ", 
      RowBox[{"\[Psi]mhalf", "[", "ktilde", "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "ktilde", " ", "L"}]]}], "+", 
     RowBox[{"\[Beta]mhalf", " ", 
      RowBox[{"\[Psi]mhalf", "[", 
       RowBox[{"-", "ktilde"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "ktilde", " ", "L"}]]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"tphalf", " ", 
        RowBox[{"\[Psi]phalfp", "[", "kl", "]"}]}], "+", 
       RowBox[{"tmhalf", " ", 
        RowBox[{"\[Psi]mhalfp", "[", "kl", "]"}], " "}]}], 
      SqrtBox["v"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "sol", "]"}], ";", 
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
      "rphalf", ",", "rmhalf", ",", "tphalf", ",", "tmhalf", ",", 
       "\[Alpha]phalf", ",", "\[Alpha]mhalf", ",", "\[Beta]phalf", ",", 
       "\[Beta]mhalf"}], "}"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7935211369396677`*^9, 3.7935211764413357`*^9}, {
   3.793521393412196*^9, 3.793521617445672*^9}, {3.793521653436118*^9, 
   3.7935218128799763`*^9}, {3.793522088322768*^9, 3.79352213185317*^9}, {
   3.793522258335759*^9, 3.793522268194682*^9}, {3.79352248609834*^9, 
   3.793522524736121*^9}, {3.7935228700697393`*^9, 3.793522882664461*^9}, {
   3.7935230156108837`*^9, 3.793523035583123*^9}, {3.793523119484791*^9, 
   3.7935231365447607`*^9}, {3.7935231668997097`*^9, 3.793523167446725*^9}, {
   3.793523213972283*^9, 3.793523229144774*^9}, {3.793523291543355*^9, 
   3.793523293068071*^9}, {3.7935233564667177`*^9, 3.7935234192396507`*^9}, {
   3.793523458590178*^9, 3.793523472470004*^9}, {3.793523662597546*^9, 
   3.793523666176537*^9}, 3.793524237114353*^9, {3.7935246095566874`*^9, 
   3.793524614166627*^9}, 3.793524802038905*^9, {3.793525058255578*^9, 
   3.7935251205083647`*^9}, {3.79352522311998*^9, 3.7935252286345367`*^9}, 
   3.7935252658754063`*^9, {3.793525343327956*^9, 3.7935253837321243`*^9}, {
   3.7935267664805*^9, 3.79352676728741*^9}, {3.793528093653798*^9, 
   3.79352810589198*^9}, {3.793529209953288*^9, 3.793529224974988*^9}, 
   3.7935292569338512`*^9, 3.793529504321842*^9, {3.793530793636044*^9, 
   3.7935307986193647`*^9}, 3.79353082895615*^9, {3.793654561229932*^9, 
   3.7936545639205523`*^9}, {3.7936745243455067`*^9, 
   3.793674540438076*^9}},ExpressionUUID->"c5bc8bdf-20dd-49a6-924a-\
37253e265aa4"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"fa9699cd-6683-4040-9867-6b9aec782c35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" large V limit", "Subsubsection",
 CellChangeTimes->{
  3.7935309351860027`*^9},ExpressionUUID->"ac328492-e02a-4440-a4d0-\
de2ae3304cce"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{
    "kl", ",", "v", ",", "bdy1", ",", "bdy2", ",", "\[Psi]mhalf", ",", 
     "\[Psi]phalf", ",", "rphalf", ",", "rmhalf", ",", "tphalf", ",", 
     "tmhalf", ",", "en"}], "]"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"kl", ">", "0"}], ";", " ", 
    RowBox[{"eVgate", " ", "=", " ", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kt", "2"]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]phalf", "[", "kt_", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "kt"}], "+", " ", "en"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "kt"}], "+", "en"}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"2", " ", "kt", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "kt"}], "+", "en"}], " ", ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
      "1"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], "\[Rule]", 
      RowBox[{"eVgate", " ", "-", 
       SuperscriptBox["kt", "2"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]mhalf", "[", "kt_", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"kt", "+", "en"}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "kt"}], "+", "en"}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "-", 
           RowBox[{"2", " ", "kt", " ", 
            RowBox[{"(", 
             RowBox[{"kt", "+", "en"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
      "1"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], "\[Rule]", 
      RowBox[{"eVgate", "   ", "-", 
       SuperscriptBox["kt", "2"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]phalfp", "[", "kz_", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "kz"}], "+", 
          SqrtBox[
           RowBox[{" ", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["kt", "2"]}], "+", 
             SuperscriptBox["kz", "2"]}]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "kz"}], "+", 
           SqrtBox[
            RowBox[{" ", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["kt", "2"]}], "+", 
              SuperscriptBox["kz", "2"]}]}]]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["kt", "2"]}], "+", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "kz"}], "+", 
              SqrtBox[
               RowBox[{" ", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["kt", "2"]}], "+", 
                 SuperscriptBox["kz", "2"]}]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
      "1"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], "\[Rule]", 
      RowBox[{"eVgate", "  ", "-", 
       SuperscriptBox["kt", "2"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]mhalfp", "[", "kz_", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"kz", "+", 
           SqrtBox[
            RowBox[{" ", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["kt", "2"]}], "+", 
              SuperscriptBox["kz", "2"]}]}]]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{" ", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["kt", "2"]}], "+", 
             SuperscriptBox["kz", "2"]}]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["kt", "2"]}], "-", 
           RowBox[{"2", " ", "kz", " ", 
            RowBox[{"(", 
             RowBox[{"kz", "+", 
              SqrtBox[
               RowBox[{" ", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["kt", "2"]}], "+", 
                 SuperscriptBox["kz", "2"]}]}]]}], ")"}]}]}], ")"}]}], 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
      "1"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], "\[Rule]", 
      RowBox[{"eVgate", "  ", "-", 
       SuperscriptBox["kt", "2"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy1", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[Psi]phalfp", "[", "kl", "]"}], "+", 
       RowBox[{"rphalf", " ", 
        RowBox[{"\[Psi]phalfp", "[", 
         RowBox[{"-", "kl"}], "]"}]}], "+", 
       RowBox[{"rmhalf", " ", 
        RowBox[{"\[Psi]mhalfp", "[", 
         RowBox[{"-", "kl"}], "]"}], " "}]}], 
      SqrtBox["v"]], "-", 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Alpha]phalf", " ", 
         RowBox[{"\[Psi]phalf", "[", "kt", "]"}]}], "+", 
        RowBox[{"\[Beta]phalf", " ", 
         RowBox[{"\[Psi]phalf", "[", 
          RowBox[{"-", "kt"}], "]"}]}], "+", 
        RowBox[{"\[Alpha]mhalf", " ", 
         RowBox[{"\[Psi]mhalf", "[", "kt", "]"}]}], "+", 
        RowBox[{"\[Beta]mhalf", " ", 
         RowBox[{"\[Psi]mhalf", "[", 
          RowBox[{"-", "kt"}], "]"}]}]}], ")"}], 
      SqrtBox["vs"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bdy2", "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"\[Alpha]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", "kt", "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"\[Beta]phalf", " ", 
        RowBox[{"\[Psi]phalf", "[", 
         RowBox[{"-", "kt"}], "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"\[Alpha]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", "kt", "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "kt", " ", "L"}]]}], "+", 
       RowBox[{"\[Beta]mhalf", " ", 
        RowBox[{"\[Psi]mhalf", "[", 
         RowBox[{"-", "kt"}], "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "kt", " ", "L"}]]}]}], 
      SqrtBox["vs"]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"tphalf", " ", 
        RowBox[{"\[Psi]phalfp", "[", "kl", "]"}]}], "+", 
       RowBox[{"tmhalf", " ", 
        RowBox[{"\[Psi]mhalfp", "[", "kl", "]"}], " "}]}], 
      SqrtBox["v"]]}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "sol", "]"}], ";", 
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy1", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"bdy2", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
      "rphalf", ",", "rmhalf", ",", "tphalf", ",", "tmhalf", ",", 
       "\[Alpha]phalf", ",", "\[Alpha]mhalf", ",", "\[Beta]phalf", ",", 
       "\[Beta]mhalf"}], "}"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.7935211369396677`*^9, 3.7935211764413357`*^9}, {
   3.793521393412196*^9, 3.793521617445672*^9}, {3.793521653436118*^9, 
   3.7935218128799763`*^9}, {3.793522088322768*^9, 3.79352213185317*^9}, {
   3.793522258335759*^9, 3.793522268194682*^9}, {3.79352248609834*^9, 
   3.793522524736121*^9}, {3.7935228700697393`*^9, 3.793522882664461*^9}, {
   3.7935230156108837`*^9, 3.793523035583123*^9}, {3.793523119484791*^9, 
   3.7935231365447607`*^9}, {3.7935231668997097`*^9, 3.793523167446725*^9}, {
   3.793523213972283*^9, 3.793523229144774*^9}, {3.793523291543355*^9, 
   3.793523293068071*^9}, {3.7935233564667177`*^9, 3.7935234192396507`*^9}, {
   3.793523458590178*^9, 3.793523472470004*^9}, {3.793523662597546*^9, 
   3.793523666176537*^9}, 3.793524237114353*^9, {3.7935246095566874`*^9, 
   3.793524614166627*^9}, 3.793524802038905*^9, {3.793525058255578*^9, 
   3.7935251205083647`*^9}, {3.79352522311998*^9, 3.7935252286345367`*^9}, 
   3.7935252658754063`*^9, {3.793525343327956*^9, 3.7935253837321243`*^9}, {
   3.7935267664805*^9, 3.79352676728741*^9}, {3.793528093653798*^9, 
   3.79352810589198*^9}, {3.793529209953288*^9, 3.793529224974988*^9}, 
   3.7935292569338512`*^9, 3.793529504321842*^9, {3.793530793636044*^9, 
   3.7935307986193647`*^9}, 3.79353082895615*^9, 3.7935310148877087`*^9, {
   3.793531047807145*^9, 3.79353106322229*^9}, {3.7935311580382013`*^9, 
   3.793531175750307*^9}, {3.793620117297827*^9, 3.793620136360978*^9}, {
   3.7936201736408777`*^9, 3.793620206746098*^9}, {3.7936203773720512`*^9, 
   3.793620389605823*^9}, {3.793621350113545*^9, 3.7936215705826483`*^9}, {
   3.793621601071423*^9, 3.793621695652463*^9}, {3.7936545307418823`*^9, 
   3.7936545315114727`*^9}, {3.7936546621226063`*^9, 3.79365467109663*^9}, 
   3.79365478563091*^9, 3.793674561437591*^9, {3.793851902078676*^9, 
   3.793851915195469*^9}, {3.793851964700206*^9, 3.793852049941128*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7fca446f-5c53-4f08-9f15-8cb8ba541db4"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"rphalf", "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], "+", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}]]}]}], ",", 
            TemplateBox[{"6"},
             "OutputSizeLimit`Skeleton"], ",", 
            RowBox[{"\[Beta]mhalf", "\[Rule]", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 7, 23294436639731831671, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 7, 23294436639731831671, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 7, 23294436639731831671, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[23294436639731831671 === $SessionID, 
   Out[7], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{
  3.793523427099766*^9, 3.793523525815446*^9, 3.793523641557296*^9, 
   3.793523729956868*^9, 3.793524290508027*^9, 3.793524425102036*^9, 
   3.793524656856262*^9, 3.793524844757284*^9, 3.793525176689794*^9, {
   3.793525262649087*^9, 3.7935252841728287`*^9}, 3.7935254794434233`*^9, 
   3.7935267830306053`*^9, 3.7935281231038237`*^9, 3.793529280884233*^9, 
   3.793529520195169*^9, 3.793530799954183*^9, 3.793530844595413*^9, 
   3.793531110079316*^9, 3.793531166992711*^9, 3.7935312039522963`*^9, 
   3.793531663618156*^9, 3.7935316962768087`*^9, 3.793532349773079*^9, 
   3.793547004309493*^9, 3.7935998103458557`*^9, 3.793620253287737*^9, 
   3.7936204170160637`*^9, {3.793621563366399*^9, 3.793621565978829*^9}, {
   3.7936215985489683`*^9, 3.79362161476338*^9}, 3.793621689944787*^9, 
   3.7936217332717457`*^9, 3.793654568858077*^9, 3.7936546228387814`*^9, 
   3.793654690487557*^9, 3.793654819726983*^9, 3.793654876217901*^9, 
   3.7936747418289747`*^9, 3.793852085053936*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"3d2570fe-97a3-40b1-80db-3bab64be946f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rp", "=", 
   RowBox[{"rphalf", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rm", "=", 
   RowBox[{"rmhalf", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tp", "=", 
   RowBox[{"tphalf", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tm", "=", 
   RowBox[{"tmhalf", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "sol", "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.793523534482424*^9, 3.7935235356628313`*^9}, {
   3.7935235689728603`*^9, 3.793523569957925*^9}, 3.793524318263425*^9, {
   3.793524449853507*^9, 3.793524450556334*^9}, {3.793524508085389*^9, 
   3.793524508836461*^9}, {3.79352533974837*^9, 3.793525373931916*^9}, {
   3.793525408699276*^9, 3.7935254550182858`*^9}, {3.793525509303555*^9, 
   3.793525539844427*^9}, {3.793527948179009*^9, 3.7935280055333767`*^9}, {
   3.793528122969574*^9, 3.7935281317605257`*^9}, {3.7935281659238577`*^9, 
   3.793528243789031*^9}, {3.793528299857045*^9, 3.793528308639216*^9}, {
   3.793528342849107*^9, 3.793528361874902*^9}, {3.79352847771202*^9, 
   3.793528485891415*^9}, {3.793528586503644*^9, 3.793528593151586*^9}, {
   3.793529299641528*^9, 3.793529327001726*^9}, {3.79353110312422*^9, 
   3.7935311199906797`*^9}, {3.7935312568949537`*^9, 3.79353125760907*^9}, {
   3.793531552902069*^9, 3.793531600228292*^9}, 3.793531667484289*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"74816ee9-f565-4d0d-ad07-2c38aeb29a4b"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"888fc188-15c1-4dfa-ae51-9ff838b2a05c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rp", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Limit", "[", 
     RowBox[{"rp", ",", 
      RowBox[{"en", "\[Rule]", "0"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}], "\[Rule]", " ", 
      RowBox[{"-", 
       SuperscriptBox["kt", "2"]}]}], "}"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.793531327787593*^9, 3.793531338959978*^9}, {
   3.7935314081353416`*^9, 3.7935314097608*^9}, {3.793531893333651*^9, 
   3.793531895183321*^9}, {3.793532014147414*^9, 3.793532152576208*^9}, {
   3.793532233487649*^9, 3.793532241706629*^9}, 3.793599854441535*^9, {
   3.793620436572912*^9, 3.7936204647574787`*^9}, {3.7936217231546803`*^9, 
   3.793621759323284*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"b05c111a-36af-4908-b688-87b6c54a03ed"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kt", "2"], "+", 
      RowBox[{"kl", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kl"}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"kl", "-", "kt"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"kl", "+", "kt"}], ")"}]}]]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], 
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kl", "2"], "+", 
       SuperscriptBox["kt", "2"]}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"kt", " ", "L"}], "]"}]}]}]]}]], "Output",
 CellChangeTimes->{
  3.7935998879725513`*^9, 3.7936203369108543`*^9, 3.793620428258828*^9, {
   3.793620458901479*^9, 3.7936204657916603`*^9}, 3.7936217676651373`*^9, 
   3.793654627464589*^9, 3.7936548229929*^9, 3.793654879310646*^9, 
   3.793674749310093*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"355e71b7-01ee-4179-a3aa-5546d956c7ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rp", "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["kt", "2"], "+", 
        RowBox[{"kl", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "kl"}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"kl", "-", "kt"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"kl", "+", "kt"}], ")"}]}]]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"kt", " ", "L"}], "]"}]}], 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kl", "2"], "+", 
         SuperscriptBox["kt", "2"]}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"kt", " ", "L"}], "]"}]}]}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rpp", "=", 
  RowBox[{
   RowBox[{"rp", "/.", 
    RowBox[{"kt", "\[Rule]", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]]}], "W"]}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "exp", "]"}], ";", 
  RowBox[{"exp", "=", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{"rpp", ",", 
      RowBox[{"{", 
       RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "FullSimplify"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["nx", "2"], "+", 
      SuperscriptBox["ny", "2"]}]], " ", "=", 
    RowBox[{
     SqrtBox["eV"], 
     FractionBox["W", "\[Pi]"]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Normal", "[", "exp", "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{"kl", "\[Rule]", " ", 
       SqrtBox[
        RowBox[{
         FractionBox[
          RowBox[{"2", "m", " ", "eV"}], 
          SuperscriptBox["hbar", "2"]], "-", 
         RowBox[{"0", 
          FractionBox[
           RowBox[{" ", 
            RowBox[{
             SuperscriptBox["\[Pi]", "2"], 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}]}]}], 
           SuperscriptBox["W", "2"]]}]}]]}], "}"}]}], "//", "FullSimplify"}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{"eV", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eV", ",", "m", ",", "hbar"}], "}"}], " ", "\[Element]", " ", 
      "Reals"}], " ", "&&", " ", 
     RowBox[{"eV", ">", "0"}], " ", "&&", " ", 
     RowBox[{"m", ">", "0"}], " ", "&&", " ", 
     RowBox[{"hbar", ">", "0"}]}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.793622032411417*^9, 3.7936221701213284`*^9}, {
  3.793680783609436*^9, 3.7936807961588173`*^9}, {3.7936847919129143`*^9, 
  3.793684808789091*^9}, {3.793712724528536*^9, 3.79371274914545*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"7351be3c-c949-4536-b00d-26866e24744a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "+", 
      RowBox[{"kl", " ", 
       RowBox[{"(", 
        RowBox[{"kl", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kl", "2"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}], " ", 
             SuperscriptBox["\[Pi]", "2"]}], 
            SuperscriptBox["W", "2"]]}]]}], ")"}], " ", 
       SuperscriptBox["W", "2"]}]}], ")"}], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox[
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "kl", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", "W", " ", 
     RowBox[{"Cosh", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}], ")"}], " ", 
        SuperscriptBox["\[Pi]", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["kl", "2"], " ", 
        SuperscriptBox["W", "2"]}]}], ")"}], " ", 
     RowBox[{"Sinh", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], 
      "]"}]}]}]]}]], "Output",
 CellChangeTimes->{{3.793622091905086*^9, 3.793622103801045*^9}, {
   3.793622134868539*^9, 3.7936221709525757`*^9}, 3.793654629061195*^9, 
   3.7936548231885567`*^9, 3.793654881116234*^9, 3.793674751799704*^9, {
   3.7936807870166187`*^9, 3.793680796876214*^9}, 3.793684815366808*^9, {
   3.793712732190845*^9, 3.793712751358942*^9}},
 CellLabel->
  "Out[180]=",ExpressionUUID->"f0de3fbb-af8b-4754-8e24-ab5fd03e93b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}], ")"}], " ", 
         SuperscriptBox["\[Pi]", "2"]}], "+", 
        RowBox[{"kl", " ", 
         RowBox[{"(", 
          RowBox[{"kl", "-", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["kl", "2"], "+", 
             FractionBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["nx", "2"], "+", 
                 SuperscriptBox["ny", "2"]}], ")"}], " ", 
               SuperscriptBox["\[Pi]", "2"]}], 
              SuperscriptBox["W", "2"]]}]]}], ")"}], " ", 
         SuperscriptBox["W", "2"]}]}], ")"}], " ", "L"}], 
     RowBox[{"2", " ", "kl", " ", 
      SuperscriptBox["W", "2"]}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {((Complex[0, 
        Rational[-1, 
         2]]/$CellContext`kl) $CellContext`W^(-2)) (($CellContext`nx^2 + \
$CellContext`ny^2) 
      Pi^2 + ($CellContext`kl ($CellContext`kl - ($CellContext`kl^2 + \
(($CellContext`nx^2 + $CellContext`ny^2) Pi^2) $CellContext`W^(-2))^
        Rational[1, 2])) $CellContext`W^2)}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793622091905086*^9, 3.793622103801045*^9}, {
   3.793622134868539*^9, 3.7936221709525757`*^9}, 3.793654629061195*^9, 
   3.7936548231885567`*^9, 3.793654881116234*^9, 3.793674751799704*^9, {
   3.7936807870166187`*^9, 3.793680796876214*^9}, 3.793684815366808*^9, {
   3.793712732190845*^9, 3.793712751553344*^9}},
 CellLabel->
  "Out[181]=",ExpressionUUID->"fa47f91c-dfa0-445a-a3f4-36102be519be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "hbar", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SqrtBox[
       FractionBox["1", "eV"]]}], 
     RowBox[{"4", " ", 
      SqrtBox["2"], " ", 
      SqrtBox["m"], " ", 
      SuperscriptBox["W", "2"]}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "eV"], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`eV, 
     DirectedInfinity[1], {}, 1, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`eV, 
   DirectedInfinity[1], {((((((Complex[0, 
            Rational[-1, 4]] 
          2^Rational[-1, 
             2]) $CellContext`hbar) $CellContext`L) $CellContext`m^
        Rational[-1, 2]) ($CellContext`nx^2 + $CellContext`ny^2)) 
     Pi^2) $CellContext`W^(-2)}, 1, 3, 2],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793622091905086*^9, 3.793622103801045*^9}, {
   3.793622134868539*^9, 3.7936221709525757`*^9}, 3.793654629061195*^9, 
   3.7936548231885567`*^9, 3.793654881116234*^9, 3.793674751799704*^9, {
   3.7936807870166187`*^9, 3.793680796876214*^9}, 3.793684815366808*^9, {
   3.793712732190845*^9, 3.793712754244886*^9}},
 CellLabel->
  "Out[183]=",ExpressionUUID->"748879c7-dfba-4e9d-b25d-41724bfe9894"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rpp", "=", 
    RowBox[{
     RowBox[{"rp", "/.", 
      RowBox[{"kt", "\[Rule]", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Pi]", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}]]}], "W"]}]}], "//", "FullSimplify"}]}],
    ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "taking", " ", "limits", " ", "in", " ", "oposite", " ", "sequence"}], " ",
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["nx", "2"], "+", 
      SuperscriptBox["ny", "2"]}]], " ", "=", 
    RowBox[{
     SqrtBox["eV"], 
     FractionBox["W", "\[Pi]"]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"rpp", "/.", 
     RowBox[{"{", 
      RowBox[{"kl", "\[Rule]", " ", 
       SqrtBox[
        RowBox[{
         FractionBox[
          RowBox[{"2", "m", " ", "eV"}], 
          SuperscriptBox["hbar", "2"]], "-", 
         FractionBox[
          RowBox[{" ", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}], ")"}]}]}], 
          SuperscriptBox["W", "2"]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   ";", 
   RowBox[{"Clear", "[", "exp", "]"}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"exp", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{"%", ",", 
      RowBox[{"{", 
       RowBox[{"eV", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eV", ",", "m", ",", "hbar"}], "}"}], " ", "\[Element]", " ", 
       "Reals"}], " ", "&&", " ", 
      RowBox[{"eV", ">", "0"}], " ", "&&", " ", 
      RowBox[{"m", ">", "0"}], " ", "&&", " ", 
      RowBox[{"hbar", ">", "0"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Normal", "[", "exp", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.793629402964159*^9, 3.79362942712768*^9}, {
   3.7936294681952887`*^9, 3.7936295044771767`*^9}, {3.793629581557049*^9, 
   3.7936296810679493`*^9}, {3.793629955084656*^9, 3.793629975076632*^9}, {
   3.7936300985877943`*^9, 3.793630099819643*^9}, {3.793630469175199*^9, 
   3.79363048346132*^9}, {3.793654819246911*^9, 3.793654828684092*^9}, {
   3.793674763072727*^9, 3.793674781577158*^9}, 3.793680831546574*^9, {
   3.7936848205084763`*^9, 3.793684853340046*^9}, {3.793684963635952*^9, 
   3.793684986688116*^9}, 3.793685045771903*^9, {3.79368507595508*^9, 
   3.79368508055173*^9}, {3.793685283269806*^9, 3.793685310997765*^9}, {
   3.7936853734476*^9, 3.7936854125283403`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"0a601e81-b2f5-4059-abeb-914e370862de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["hbar", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"]}], 
    RowBox[{"4", " ", "m", " ", 
     SuperscriptBox["W", "2"], " ", "eV"}]], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["hbar", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], "m"], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["\[Pi]", "3"], " ", 
     RowBox[{"Coth", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "eV"], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["W", "3"]}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["hbar", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], ")"}], "2"], " ", 
     SuperscriptBox["\[Pi]", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"Csch", "[", 
          FractionBox[
           RowBox[{"L", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], 
         "2"]}]}], ")"}]}], 
    RowBox[{"32", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["W", "4"]}], ")"}], " ", 
     SuperscriptBox["eV", "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "eV"], "]"}], 
     RowBox[{"5", "/", "2"}]],
    SeriesData[$CellContext`eV, 
     DirectedInfinity[1], {}, 2, 5, 2],
    Editable->False]}],
  SeriesData[$CellContext`eV, 
   DirectedInfinity[
   1], {((((Rational[
         1, 4] $CellContext`hbar^2)/$CellContext`m) ($CellContext`nx^2 + \
$CellContext`ny^2)) Pi^2) $CellContext`W^(-2), (((((Complex[0, 
           Rational[-1, 2]] 
         2^Rational[-1, 
            2]) $CellContext`hbar^3) ($CellContext`m^(-1) ($CellContext`nx^2 + \
$CellContext`ny^2))^Rational[3, 2]) Pi^3) $CellContext`W^(-3)) 
    Coth[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[1, 2]) (
       Pi/$CellContext`W)], (((((
         Rational[-1, 
           32] $CellContext`hbar^4) $CellContext`m^(-2)) ($CellContext`nx^2 + \
$CellContext`ny^2)^2) Pi^4) $CellContext`W^(-4)) (7 + 
     16 Csch[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
           Rational[1, 2]) (Pi/$CellContext`W)]^2)}, 2, 5, 2],
  Editable->False]], "Output",
 CellChangeTimes->{{3.7936294174317913`*^9, 3.793629431604157*^9}, {
   3.793629500680882*^9, 3.7936295050909643`*^9}, {3.793629958103858*^9, 
   3.793629975870776*^9}, 3.793630510091403*^9, 3.793654633196865*^9, 
   3.793654830450728*^9, 3.793654886126081*^9, 3.793674789168796*^9, 
   3.793680834441308*^9, 3.7936849875522337`*^9, {3.7936850525383387`*^9, 
   3.793685081186076*^9}, 3.7936853156279707`*^9, {3.793685379028758*^9, 
   3.7936854152265882`*^9}},
 CellLabel->
  "Out[321]=",ExpressionUUID->"29327809-77b1-4630-9c8f-95c4567f6576"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["hbar", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["eV", "2"], " ", 
        SuperscriptBox["m", "2"], " ", 
        SuperscriptBox["W", "2"]}], ")"}], " ", 
      SuperscriptBox["L", "2"]}]]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["hbar", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], "m"], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["\[Pi]", "2"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["eV", 
      RowBox[{"3", "/", "2"}]], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", 
     SuperscriptBox["W", "2"], " ", "L"}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", 
        SuperscriptBox["hbar", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}], ")"}], " ", 
        SuperscriptBox["\[Pi]", "4"]}], "+", 
       RowBox[{"24", " ", "eV", " ", 
        SuperscriptBox["hbar", "2"], " ", "m", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["W", "2"]}]}], ")"}]}], 
    RowBox[{"96", " ", 
     SuperscriptBox["eV", "2"], " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["W", "4"]}]], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["hbar", "3"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], "m"], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["\[Pi]", "4"], " ", "L"}], 
    RowBox[{"6", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["eV", 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["W", "4"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, -2, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 
   0, {(((((Rational[-1, 
           2] $CellContext`eV^(-2)) $CellContext`hbar^4) $CellContext`m^(-2)) \
($CellContext`nx^2 + $CellContext`ny^2)) 
     Pi^2) $CellContext`W^(-2), ((((((Complex[0, 
            Rational[-1, 2]] 2^Rational[-1, 2]) $CellContext`eV^
          Rational[-3, 
            2]) $CellContext`hbar^3) ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[-1, 
          2]) ($CellContext`m^(-1) ($CellContext`nx^2 + $CellContext`ny^2))^
       Rational[3, 2]) 
     Pi^2) $CellContext`W^(-2), ((((
        Rational[
         1, 96] $CellContext`eV^(-2)) $CellContext`m^(-2)) ($CellContext`nx^2 + \
$CellContext`ny^2)) $CellContext`W^(-4)) ((((-5) $CellContext`hbar^4) \
($CellContext`nx^2 + $CellContext`ny^2)) 
      Pi^4 + ((((24 $CellContext`eV) $CellContext`hbar^2) $CellContext`m) 
       Pi^2) $CellContext`W^2), ((((((Complex[0, 
            Rational[-1, 6]] 2^Rational[-1, 2]) $CellContext`eV^
          Rational[-3, 
            2]) $CellContext`hbar^3) ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[
         1, 2]) ($CellContext`m^(-1) ($CellContext`nx^2 + $CellContext`ny^2))^
       Rational[3, 2]) Pi^4) $CellContext`W^(-4)}, -2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.7936294174317913`*^9, 3.793629431604157*^9}, {
   3.793629500680882*^9, 3.7936295050909643`*^9}, {3.793629958103858*^9, 
   3.793629975870776*^9}, 3.793630510091403*^9, 3.793654633196865*^9, 
   3.793654830450728*^9, 3.793654886126081*^9, 3.793674789168796*^9, 
   3.793680834441308*^9, 3.7936849875522337`*^9, {3.7936850525383387`*^9, 
   3.793685081186076*^9}, 3.7936853156279707`*^9, {3.793685379028758*^9, 
   3.793685415685792*^9}},
 CellLabel->
  "Out[322]=",ExpressionUUID->"bfb2185d-03a2-4ab3-a040-81bb94071fa0"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"9b9ed1bd-41ff-49dd-a880-10b3771df003"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tp", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Limit", "[", 
       RowBox[{"tp", ",", 
        RowBox[{"en", "\[Rule]", "0"}]}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"]}], "\[Rule]", " ", 
        RowBox[{"-", 
         SuperscriptBox["kt", "2"]}]}], "}"}]}], ")"}], "//", 
    "FullSimplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.793531479381139*^9, 3.793531485092567*^9}, {
   3.7935315172124653`*^9, 3.7935315195349627`*^9}, 3.793531608193138*^9, {
   3.7935317902961283`*^9, 3.7935318051833363`*^9}, {3.793531845437372*^9, 
   3.793531847672665*^9}, {3.793531883502527*^9, 3.7935318842023582`*^9}, {
   3.793531946727448*^9, 3.793531947373258*^9}, {3.793532183914825*^9, 
   3.793532185398368*^9}, {3.793532269393299*^9, 3.793532298187498*^9}, {
   3.793532331827086*^9, 3.793532336779743*^9}, {3.79353237204219*^9, 
   3.793532420049821*^9}, {3.793532482050268*^9, 3.793532482661565*^9}, {
   3.7935325285433693`*^9, 3.793532531081973*^9}, {3.7935481719563227`*^9, 
   3.7935481727687683`*^9}, {3.7936206469036093`*^9, 3.793620652746546*^9}, {
   3.7936217843743887`*^9, 3.793621787644423*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"14552245-31e6-49df-8c8e-cd77d98063e7"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt"}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kl", "2"], "+", 
      SuperscriptBox["kt", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.7935314853966227`*^9, 3.793531545771902*^9, 3.7935316281606817`*^9, 
   3.7935317340322742`*^9, 3.793531805671568*^9, 3.793531848368424*^9, 
   3.793531884870103*^9, 3.7935319487328663`*^9, {3.793532300369052*^9, 
   3.793532316267139*^9}, {3.7935323517433147`*^9, 3.7935324266780243`*^9}, {
   3.7935325091338873`*^9, 3.793532531915379*^9}, 3.793547977127515*^9, 
   3.79354817350893*^9, 3.7936207602546597`*^9, 3.793621210957275*^9, 
   3.79362181851752*^9, 3.7936546353802767`*^9, 3.793654836670211*^9, 
   3.793654893440278*^9, 3.79367483898691*^9, 3.7936750215889387`*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"f4ed0b4f-c423-4408-b0ab-5beb732312f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"for", " ", 
    FractionBox["L", "W"], " ", 
    RowBox[{
     RowBox[{"<<", " ", "1"}], "/", 
     SqrtBox["eV"]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tp", "=", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt"}], 
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kl", "2"], "+", 
          SuperscriptBox["kt", "2"]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}]}]]}], ";", 
    RowBox[{"Clear", "[", "tpp", "]"}], ";", 
    RowBox[{"tpp", "=", 
     RowBox[{
      RowBox[{"tp", "/.", 
       RowBox[{"kt", "\[Rule]", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}]]}], "W"]}]}], "//", 
      "FullSimplify"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "exp", "]"}], ";", 
    RowBox[{"exp", "=", 
     RowBox[{
      RowBox[{"Series", "[", 
       RowBox[{"tpp", ",", 
        RowBox[{"{", 
         RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
      "FullSimplify"}]}]}], 
   RowBox[{"(*", " ", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", "=", 
     RowBox[{
      SqrtBox["eV"], 
      FractionBox["W", "\[Pi]"]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", "exp", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{"kl", "\[Rule]", " ", 
        SqrtBox[
         RowBox[{
          FractionBox[
           RowBox[{"2", "m", " ", "eV"}], 
           SuperscriptBox["hbar", "2"]], "-", 
          RowBox[{"0", 
           FractionBox[
            RowBox[{" ", 
             RowBox[{
              SuperscriptBox["\[Pi]", "2"], 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["nx", "2"], "+", 
                SuperscriptBox["ny", "2"]}], ")"}]}]}], 
            SuperscriptBox["W", "2"]]}]}]]}], "}"}]}], "//", "FullSimplify"}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{"%", ",", 
       RowBox[{"{", 
        RowBox[{"eV", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eV", ",", "m", ",", "hbar"}], "}"}], " ", "\[Element]", " ",
         "Reals"}], " ", "&&", " ", 
       RowBox[{"eV", ">", "0"}], " ", "&&", " ", 
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"hbar", ">", "0"}]}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"ans", " ", "for", " ", "rp", " ", "is", " ", 
     InterpretationBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "hbar", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}], ")"}], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SqrtBox[
           FractionBox["1", "eV"]]}], 
         RowBox[{"4", " ", 
          SqrtBox["2"], " ", 
          SqrtBox["m"], " ", 
          SuperscriptBox["W", "2"]}]]}], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          FractionBox["1", "eV"], "]"}], 
         RowBox[{"3", "/", "2"}]],
        SeriesData[$CellContext`eV, 
         DirectedInfinity[1], {}, 1, 3, 2],
        Editable->False]}],
      SeriesData[$CellContext`eV, 
       DirectedInfinity[1], {((((((Complex[0, 
                Rational[-1, 4]] 
              2^Rational[-1, 
                 2]) $CellContext`hbar) $CellContext`L) $CellContext`m^
            Rational[-1, 2]) ($CellContext`nx^2 + $CellContext`ny^2)) 
         Pi^2) $CellContext`W^(-2)}, 1, 3, 2],
      Editable->False]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.793629705626709*^9, 3.793629741520585*^9}, {
   3.793629781525565*^9, 3.793629782634802*^9}, 3.793629948657954*^9, {
   3.793630032470293*^9, 3.793630059111602*^9}, 3.793630575087413*^9, {
   3.793654907544774*^9, 3.7936549125795717`*^9}, 3.793674854602541*^9, {
   3.7936804034922667`*^9, 3.793680521701888*^9}, {3.79368628805179*^9, 
   3.793686351874153*^9}, 3.793686397504018*^9, {3.793687055579331*^9, 
   3.7936870766234627`*^9}, 3.793687144839019*^9, 3.7936872111219378`*^9, {
   3.793712789564488*^9, 3.793712803663876*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"6300f3cd-889c-483a-af80-1e0c5e6ed3c1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "kl", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["nx", "2"], "+", 
     SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", "W"}], 
  RowBox[{
   RowBox[{"2", " ", "kl", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["nx", "2"], "+", 
      SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", "W", " ", 
    RowBox[{"Cosh", "[", 
     FractionBox[
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["kl", "2"], " ", 
       SuperscriptBox["W", "2"]}]}], ")"}], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox[
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], 
     "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.793629708304983*^9, 3.7936297421261683`*^9}, 
   3.7936297838942223`*^9, 3.793629950901494*^9, 3.79363005989697*^9, 
   3.793630579856634*^9, 3.793654914041153*^9, 3.793674861370358*^9, 
   3.7936749205845737`*^9, 3.793675008388466*^9, 3.793675041171257*^9, {
   3.7936804332211037`*^9, 3.793680457487509*^9}, {3.793680499618226*^9, 
   3.79368052240407*^9}, {3.79368630681185*^9, 3.793686331672639*^9}, 
   3.793686367917469*^9, 3.793712804935913*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"d2d53b53-179d-4118-a146-407526c0b2cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kl", "2"], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}], ")"}], " ", 
         SuperscriptBox["\[Pi]", "2"]}], 
        SuperscriptBox["W", "2"]]}], ")"}], " ", "L"}], 
    RowBox[{"2", " ", "kl"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {1, (Complex[0, 
       Rational[
       1, 2]]/$CellContext`kl) ($CellContext`kl^2 - (($CellContext`nx^2 + \
$CellContext`ny^2) Pi^2) $CellContext`W^(-2))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793629708304983*^9, 3.7936297421261683`*^9}, 
   3.7936297838942223`*^9, 3.793629950901494*^9, 3.79363005989697*^9, 
   3.793630579856634*^9, 3.793654914041153*^9, 3.793674861370358*^9, 
   3.7936749205845737`*^9, 3.793675008388466*^9, 3.793675041171257*^9, {
   3.7936804332211037`*^9, 3.793680457487509*^9}, {3.793680499618226*^9, 
   3.79368052240407*^9}, {3.79368630681185*^9, 3.793686331672639*^9}, 
   3.793686367917469*^9, 3.793712805032732*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"d3804824-ac2a-4093-ba6b-786d54d7746b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "L", " ", 
     SqrtBox["m"], " ", 
     SqrtBox["eV"]}], 
    RowBox[{
     SqrtBox["2"], " ", "hbar"}]], "+", "1", "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "hbar", " ", "L", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SqrtBox[
      FractionBox["1", "eV"]]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     SqrtBox["m"], " ", 
     SuperscriptBox["W", "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "eV"], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`eV, 
     DirectedInfinity[1], {}, -1, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`eV, 
   DirectedInfinity[
   1], {(((Complex[0, 1] 
       2^Rational[-1, 2])/$CellContext`hbar) $CellContext`L) $CellContext`m^
     Rational[1, 2], 1, ((((((Complex[0, 
            Rational[-1, 2]] 
          2^Rational[-1, 
             2]) $CellContext`hbar) $CellContext`L) $CellContext`m^
        Rational[-1, 2]) ($CellContext`nx^2 + $CellContext`ny^2)) 
     Pi^2) $CellContext`W^(-2)}, -1, 3, 2],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793629708304983*^9, 3.7936297421261683`*^9}, 
   3.7936297838942223`*^9, 3.793629950901494*^9, 3.79363005989697*^9, 
   3.793630579856634*^9, 3.793654914041153*^9, 3.793674861370358*^9, 
   3.7936749205845737`*^9, 3.793675008388466*^9, 3.793675041171257*^9, {
   3.7936804332211037`*^9, 3.793680457487509*^9}, {3.793680499618226*^9, 
   3.79368052240407*^9}, {3.79368630681185*^9, 3.793686331672639*^9}, 
   3.793686367917469*^9, 3.793712806275935*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"4c60350c-6310-4fc9-b649-e676a6b6a3c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", 
     FractionBox["L", "W"]}], " ", ">>", " ", 
    RowBox[{"1", "/", 
     SqrtBox["eV"]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "tpp", "]"}], ";", 
    RowBox[{"tpp", "=", 
     RowBox[{
      RowBox[{"tp", "/.", 
       RowBox[{"kt", "\[Rule]", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}]]}], "W"]}]}], "//", 
      "FullSimplify"}]}], ";"}], 
   RowBox[{"(*", " ", 
    RowBox[{
    "taking", " ", "limits", " ", "in", " ", "oposite", " ", "sequence"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", "=", 
     RowBox[{
      SqrtBox["eV"], 
      FractionBox["W", "\[Pi]"]}]}], "*)"}], 
   RowBox[{
    RowBox[{
     RowBox[{"tpp", "/.", 
      RowBox[{"{", 
       RowBox[{"kl", "\[Rule]", " ", 
        SqrtBox[
         RowBox[{
          FractionBox[
           RowBox[{"2", "m", " ", "eV"}], 
           SuperscriptBox["hbar", "2"]], "-", 
          FractionBox[
           RowBox[{" ", 
            RowBox[{
             SuperscriptBox["\[Pi]", "2"], 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}]}]}], 
           SuperscriptBox["W", "2"]]}]]}], "}"}]}], "//", "FullSimplify"}], 
    ";", 
    RowBox[{"Clear", "[", "exp", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"exp", "=", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Series", "[", 
       RowBox[{"%", ",", 
        RowBox[{"{", 
         RowBox[{"eV", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eV", ",", "m", ",", "hbar"}], "}"}], " ", "\[Element]", 
         " ", "Reals"}], " ", "&&", " ", 
        RowBox[{"eV", ">", "0"}], " ", "&&", " ", 
        RowBox[{"m", ">", "0"}], " ", "&&", " ", 
        RowBox[{"hbar", ">", "0"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Normal", "[", "exp", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "FullSimplify", 
    RowBox[{"(*", " ", 
     RowBox[{"ans", " ", "for", " ", "rp", " ", "is", " ", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["hbar", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["nx", "2"], "+", 
             SuperscriptBox["ny", "2"]}], ")"}], " ", 
           SuperscriptBox["\[Pi]", "2"]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["eV", "2"], " ", 
             SuperscriptBox["m", "2"], " ", 
             SuperscriptBox["W", "2"]}], ")"}], " ", 
           SuperscriptBox["L", "2"]}]]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["hbar", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}], "m"], ")"}], 
           RowBox[{"3", "/", "2"}]], " ", 
          SuperscriptBox["\[Pi]", "2"]}], 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SuperscriptBox["eV", 
           RowBox[{"3", "/", "2"}]], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}]], " ", 
          SuperscriptBox["W", "2"], " ", "L"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", 
             SuperscriptBox["hbar", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}], " ", 
             SuperscriptBox["\[Pi]", "4"]}], "+", 
            RowBox[{"24", " ", "eV", " ", 
             SuperscriptBox["hbar", "2"], " ", "m", " ", 
             SuperscriptBox["\[Pi]", "2"], " ", 
             SuperscriptBox["W", "2"]}]}], ")"}]}], 
         RowBox[{"96", " ", 
          SuperscriptBox["eV", "2"], " ", 
          SuperscriptBox["m", "2"], " ", 
          SuperscriptBox["W", "4"]}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["hbar", "3"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}], "m"], ")"}], 
           RowBox[{"3", "/", "2"}]], " ", 
          SuperscriptBox["\[Pi]", "4"], " ", "L"}], 
         RowBox[{"6", " ", 
          SqrtBox["2"], " ", 
          SuperscriptBox["eV", 
           RowBox[{"3", "/", "2"}]], " ", 
          SuperscriptBox["W", "4"]}]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "L", "]"}], "2"],
         SeriesData[$CellContext`L, 0, {}, -2, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`L, 
        0, {(((((
              Rational[-1, 
                2] $CellContext`eV^(-2)) $CellContext`hbar^4) \
$CellContext`m^(-2)) ($CellContext`nx^2 + $CellContext`ny^2)) 
          Pi^2) $CellContext`W^(-2), ((((((Complex[0, 
                 Rational[-1, 2]] 2^Rational[-1, 2]) $CellContext`eV^
               Rational[-3, 
                 2]) $CellContext`hbar^3) ($CellContext`nx^2 + \
$CellContext`ny^2)^
             Rational[-1, 
               2]) ($CellContext`m^(-1) ($CellContext`nx^2 + \
$CellContext`ny^2))^Rational[3, 2]) 
          Pi^2) $CellContext`W^(-2), ((((
             Rational[
              1, 96] $CellContext`eV^(-2)) $CellContext`m^(-2)) \
($CellContext`nx^2 + $CellContext`ny^2)) $CellContext`W^(-4)) ((((-5) \
$CellContext`hbar^4) ($CellContext`nx^2 + $CellContext`ny^2)) 
           Pi^4 + ((((24 $CellContext`eV) $CellContext`hbar^2) $CellContext`m)
              Pi^2) $CellContext`W^2), ((((((Complex[0, 
                 Rational[-1, 6]] 2^Rational[-1, 2]) $CellContext`eV^
               Rational[-3, 
                 2]) $CellContext`hbar^3) ($CellContext`nx^2 + \
$CellContext`ny^2)^
             Rational[
              1, 2]) ($CellContext`m^(-1) ($CellContext`nx^2 + \
$CellContext`ny^2))^Rational[3, 2]) Pi^4) $CellContext`W^(-4)}, -2, 2, 1],
       Editable->False]}], "*)"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7936859015042887`*^9, 3.793685907717332*^9}, {
   3.7936861021644897`*^9, 3.793686102831274*^9}, {3.793686193461254*^9, 
   3.793686199823735*^9}, 3.793686403911693*^9, {3.793687086744832*^9, 
   3.793687093294385*^9}, 3.7936871521542397`*^9, {3.793687186295846*^9, 
   3.793687187498597*^9}},ExpressionUUID->"b9a5d34f-edd4-4897-94e1-\
443545f2d5af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", "hbar", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], "m"]], " ", "\[Pi]", " ", 
     RowBox[{"Csch", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], " ", 
     SqrtBox[
      FractionBox["1", "eV"]]}], "W"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["hbar", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Coth", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], " ", 
     RowBox[{"Csch", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], 
    RowBox[{"m", " ", 
     SuperscriptBox["W", "2"], " ", "eV"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "eV"], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`eV, 
     DirectedInfinity[1], {}, 1, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`eV, 
   DirectedInfinity[
   1], {(((((Complex[0, 1] 
         2^Rational[
           1, 2]) $CellContext`hbar) ($CellContext`m^(-1) ($CellContext`nx^2 + \
$CellContext`ny^2))^Rational[1, 2]) Pi)/$CellContext`W) 
    Csch[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[1, 2]) (
       Pi/$CellContext`W)], ((((((
          2 $CellContext`hbar^2)/$CellContext`m) ($CellContext`nx^2 + \
$CellContext`ny^2)) Pi^2) $CellContext`W^(-2)) 
     Coth[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
         Rational[1, 2]) (Pi/$CellContext`W)]) 
    Csch[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[1, 2]) (Pi/$CellContext`W)]}, 1, 3, 2],
  Editable->False]], "Output",
 CellChangeTimes->{3.7936859236984243`*^9, 3.793686107724101*^9, 
  3.793686415661978*^9},
 CellLabel->
  "Out[342]=",ExpressionUUID->"8644e1f1-ffe0-4b79-b4e9-82fe2838266d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["hbar", "2"]}], 
    RowBox[{"eV", " ", "m", " ", 
     SuperscriptBox["L", "2"]}]], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", "hbar", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], "m"]]}], 
    RowBox[{
     SqrtBox["eV"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", "L"}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["hbar", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"]}], 
    RowBox[{"3", " ", "eV", " ", "m", " ", 
     SuperscriptBox["W", "2"]}]], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "hbar", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", 
     SqrtBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}], "m"]], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", "L"}], 
    RowBox[{"3", " ", 
     SqrtBox["2"], " ", 
     SqrtBox["eV"], " ", 
     SuperscriptBox["W", "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, -2, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 
   0, {(2/$CellContext`eV) ($CellContext`hbar^2/$CellContext`m), ((((
        Complex[0, 1] 2^Rational[1, 2]) $CellContext`eV^
        Rational[-1, 
          2]) $CellContext`hbar) ($CellContext`nx^2 + $CellContext`ny^2)^
      Rational[-1, 
        2]) ($CellContext`m^(-1) ($CellContext`nx^2 + $CellContext`ny^2))^
     Rational[1, 
       2], (((((
         Rational[
          1, 
           3]/$CellContext`eV) $CellContext`hbar^2)/$CellContext`m) \
($CellContext`nx^2 + $CellContext`ny^2)) 
     Pi^2) $CellContext`W^(-2), ((((((Complex[0, 
            Rational[-1, 3]] 2^Rational[-1, 2]) $CellContext`eV^
          Rational[-1, 
            2]) $CellContext`hbar) ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[
         1, 2]) ($CellContext`m^(-1) ($CellContext`nx^2 + $CellContext`ny^2))^
       Rational[1, 2]) Pi^2) $CellContext`W^(-2)}, -2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.7936859236984243`*^9, 3.793686107724101*^9, 
  3.7936864159075737`*^9},
 CellLabel->
  "Out[343]=",ExpressionUUID->"d698f3d2-2d4f-4663-9e76-49971e107633"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"4500058b-fc95-405f-915e-373e21e7ab46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rm", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Limit", "[", 
       RowBox[{"rm", ",", 
        RowBox[{"en", "\[Rule]", "0"}]}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"]}], "\[Rule]", " ", 
        RowBox[{"-", 
         SuperscriptBox["kt", "2"]}]}], "}"}]}], ")"}], "//", 
    "FullSimplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.793531479381139*^9, 3.793531485092567*^9}, {
   3.7935315172124653`*^9, 3.7935315195349627`*^9}, 3.793531608193138*^9, {
   3.7935317902961283`*^9, 3.7935318051833363`*^9}, {3.793531845437372*^9, 
   3.793531847672665*^9}, {3.793531883502527*^9, 3.7935318842023582`*^9}, {
   3.793531946727448*^9, 3.793531947373258*^9}, {3.793532183914825*^9, 
   3.793532185398368*^9}, {3.793532269393299*^9, 3.793532298187498*^9}, {
   3.793532331827086*^9, 3.793532336779743*^9}, {3.79353237204219*^9, 
   3.793532420049821*^9}, {3.793532482050268*^9, 3.793532482661565*^9}, {
   3.7935325285433693`*^9, 3.793532531081973*^9}, {3.7935481719563227`*^9, 
   3.7935481727687683`*^9}, {3.7936206469036093`*^9, 3.793620652746546*^9}, {
   3.79362069365484*^9, 3.79362069937215*^9}, {3.793621847576285*^9, 
   3.793621850868578*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"aa9d2c92-1879-43da-96a1-352e7882c722"],

Cell[BoxData[
 FractionBox[
  RowBox[{"kl", " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"kl", "-", "kt"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"kl", "+", "kt"}], ")"}]}]], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"kt", " ", "L"}], "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kl", "2"], "+", 
      SuperscriptBox["kt", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.7936210298918333`*^9, 3.793621208048566*^9, 
  3.793621447881626*^9, 3.793621865069466*^9, 3.793654929683473*^9, 
  3.793675600430464*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"9855daee-889f-4c40-9cef-b9cf8d1ba991"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"rm", ",", 
   RowBox[{"{", 
    RowBox[{"kl", ",", "\[Infinity]", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.793620797630499*^9, 3.793620798070957*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"06ef85dd-272d-492b-9ead-4ed631a9c581"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "kt", " ", 
     RowBox[{"Cot", "[", 
      RowBox[{"kt", " ", "L"}], "]"}]}], "kl"], "+", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      SuperscriptBox["kt", "2"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["kt", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cot", "[", 
        RowBox[{"kt", " ", "L"}], "]"}], "2"]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["kl", "2"]}]], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["kt", "3"], " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["kt", "3"], " ", 
        SuperscriptBox[
         RowBox[{"Cot", "[", 
          RowBox[{"kt", " ", "L"}], "]"}], "3"]}]}], ")"}]}], 
    SuperscriptBox["kl", "3"]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"11", " ", 
      SuperscriptBox["kt", "4"]}], "+", 
     RowBox[{"112", " ", 
      SuperscriptBox["kt", "4"], " ", 
      SuperscriptBox[
       RowBox[{"Cot", "[", 
        RowBox[{"kt", " ", "L"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["kt", "4"], " ", 
      SuperscriptBox[
       RowBox[{"Cot", "[", 
        RowBox[{"kt", " ", "L"}], "]"}], "4"]}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox["kl", "4"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "kl"], "]"}], "5"],
    SeriesData[$CellContext`kl, 
     DirectedInfinity[1], {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`kl, 
   DirectedInfinity[1], {
   1, (Complex[0, -2] $CellContext`kt) Cot[$CellContext`kt $CellContext`L], 
    Rational[1, 2] ((-3) $CellContext`kt^2 - (8 $CellContext`kt^2) 
     Cot[$CellContext`kt $CellContext`L]^2), 
    Complex[0, 1] ((5 $CellContext`kt^3) 
      Cot[$CellContext`kt $CellContext`L] + (8 $CellContext`kt^3) 
      Cot[$CellContext`kt $CellContext`L]^3), 
    Rational[1, 8] (
     11 $CellContext`kt^4 + (112 $CellContext`kt^4) 
      Cot[$CellContext`kt $CellContext`L]^2 + (128 $CellContext`kt^4) 
      Cot[$CellContext`kt $CellContext`L]^4)}, 0, 5, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.7936214528295813`*^9, {3.793621865234941*^9, 3.79362187146428*^9}, 
   3.793654929814695*^9, 3.793675600620317*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"86ad0e6f-74ed-413c-a6dd-497dff0834b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"rmp", "=", 
  RowBox[{
   RowBox[{"rm", "/.", 
    RowBox[{"kt", "\[Rule]", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]]}], "W"]}]}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{"rmp", ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.793622325566744*^9, 3.793622337327132*^9}, 
   3.793629215178524*^9, {3.7936306609567947`*^9, 3.793630661425643*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"3137ed13-e361-4491-b750-8d9ec012d404"],

Cell[BoxData[
 FractionBox[
  RowBox[{"kl", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["kl", "2"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Pi]", "2"]}], 
      SuperscriptBox["W", "2"]]}]], " ", 
   SuperscriptBox["W", "2"], " ", 
   RowBox[{"Sinh", "[", 
    FractionBox[
     RowBox[{"L", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["nx", "2"], "+", 
        SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["nx", "2"], "+", 
      SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", "W", " ", 
    RowBox[{"Cosh", "[", 
     FractionBox[
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["kl", "2"], " ", 
       SuperscriptBox["W", "2"]}]}], ")"}], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox[
      RowBox[{"L", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["nx", "2"], "+", 
         SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], 
     "]"}]}]}]]], "Output",
 CellChangeTimes->{3.7936223393861628`*^9, 3.793630663776698*^9, 
  3.793654933309333*^9, 3.7936756018259706`*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"3448ea6a-be2d-4328-8875-72c3f1f70894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kl", "2"], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}], ")"}], " ", 
         SuperscriptBox["\[Pi]", "2"]}], 
        SuperscriptBox["W", "2"]]}]], " ", "L"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {Complex[0, 
      Rational[-1, 
       2]] ($CellContext`kl^2 + (($CellContext`nx^2 + $CellContext`ny^2) 
        Pi^2) $CellContext`W^(-2))^Rational[1, 2]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.7936223393861628`*^9, 3.793630663776698*^9, 
  3.793654933309333*^9, 3.793675601913974*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"91f1bced-b66f-4632-aa48-225954d546a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["nx", "2"], "+", 
      SuperscriptBox["ny", "2"]}]], " ", "=", 
    RowBox[{
     SqrtBox["eV"], 
     FractionBox["W", "\[Pi]"]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "exp", "]"}], ";", 
    RowBox[{"exp", "=", 
     RowBox[{
      RowBox[{"rmp", "/.", 
       RowBox[{"{", 
        RowBox[{"kl", "\[Rule]", 
         SqrtBox[
          RowBox[{
           FractionBox[
            RowBox[{"2", "m", " ", "eV"}], 
            SuperscriptBox["hbar", "2"]], "-", 
           FractionBox[
            RowBox[{" ", 
             RowBox[{
              SuperscriptBox["\[Pi]", "2"], 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["nx", "2"], "+", 
                SuperscriptBox["ny", "2"]}], ")"}]}]}], 
            SuperscriptBox["W", "2"]]}]]}], " ", "}"}]}], "//", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{"exp", ",", 
      RowBox[{"{", 
       RowBox[{"eV", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["2"], " ", 
         SqrtBox["eV"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", 
         RowBox[{"Coth", "[", 
          FractionBox[
           RowBox[{"L", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], 
         "hbar"}], 
        RowBox[{"eV", 
         SqrtBox[
          RowBox[{" ", "m"}]], " ", "W"}]]}], ",", 
      RowBox[{"{", 
       RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.793630137965097*^9, 3.7936301383635893`*^9}, {
   3.79363019031472*^9, 3.7936302002513514`*^9}, 3.7936306287119493`*^9, 
   3.793630668336522*^9, {3.793654944549074*^9, 3.793654948735751*^9}, {
   3.793675615433641*^9, 3.793675637925281*^9}, {3.793675693658004*^9, 
   3.793675708910912*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"f519a1fc-e9d2-4213-b549-599430b3fe45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     SqrtBox["eV"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}]], " ", "\[Pi]", " ", 
     RowBox[{"Coth", "[", 
      FractionBox[
       RowBox[{"L", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], " ", 
     SqrtBox[
      FractionBox["1", "eV"]]}], 
    RowBox[{
     SqrtBox[
      FractionBox[
       RowBox[{"eV", " ", "m"}], 
       SuperscriptBox["hbar", "2"]]], " ", "W"}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["hbar", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"Csch", "[", 
          FractionBox[
           RowBox[{"L", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}]], " ", "\[Pi]"}], "W"], "]"}], 
         "2"]}]}], ")"}]}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"m", " ", 
       SuperscriptBox["W", "2"]}], ")"}], " ", "eV"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "eV"], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`eV, 
     DirectedInfinity[1], {}, 0, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`eV, 
   DirectedInfinity[1], {
   1, ((((((Complex[0, -1] 2^Rational[1, 2]) $CellContext`eV^
          Rational[
           1, 2]) (($CellContext`eV $CellContext`hbar^(-2)) $CellContext`m)^
         Rational[-1, 2]) ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[1, 2]) Pi)/$CellContext`W) 
    Coth[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
        Rational[1, 2]) (
       Pi/$CellContext`W)], (((((
         Rational[-1, 
           4] $CellContext`hbar^2)/$CellContext`m) ($CellContext`nx^2 + \
$CellContext`ny^2)) Pi^2) $CellContext`W^(-2)) (5 + 
     8 Csch[($CellContext`L ($CellContext`nx^2 + $CellContext`ny^2)^
           Rational[1, 2]) (Pi/$CellContext`W)]^2)}, 0, 3, 2],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.79363014122092*^9, 3.793630200972381*^9, 3.7936306765317793`*^9, 
   3.793654950275429*^9, {3.793675626279377*^9, 3.793675639497017*^9}, 
   3.7936757106201*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"0b543b48-37f1-46cf-b03c-f6f4066a0811"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"], " ", "hbar"}], 
     RowBox[{
      SqrtBox["eV"], " ", 
      SqrtBox["m"], " ", "L"}]]}], "+", "1", "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", "hbar", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["nx", "2"], "+", 
       SuperscriptBox["ny", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", "L"}], 
    RowBox[{"3", " ", 
     SqrtBox["eV"], " ", 
     SqrtBox["m"], " ", 
     SuperscriptBox["W", "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 
   0, {(((Complex[0, -1] 2^Rational[1, 2]) $CellContext`eV^
       Rational[-1, 2]) $CellContext`hbar) $CellContext`m^Rational[-1, 2], 
    1, ((((((Complex[0, 
            Rational[-1, 3]] 2^Rational[1, 2]) $CellContext`eV^
          Rational[-1, 2]) $CellContext`hbar) $CellContext`m^
        Rational[-1, 2]) ($CellContext`nx^2 + $CellContext`ny^2)) 
     Pi^2) $CellContext`W^(-2)}, -1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.79363014122092*^9, 3.793630200972381*^9, 3.7936306765317793`*^9, 
   3.793654950275429*^9, {3.793675626279377*^9, 3.793675639497017*^9}, 
   3.793675710799185*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"5ba85d80-5c27-46d8-a252-8d27f3e1a0a3"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 3},ExpressionUUID->"910366d5-d701-4c0d-b1b6-6331d93788d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tm", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{"tm", ",", 
       RowBox[{"en", "\[Rule]", "0"}]}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}], "\[Rule]", " ", 
       RowBox[{"-", 
        SuperscriptBox["kt", "2"]}]}], "}"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7935315081790447`*^9, 3.793531534682472*^9}, 
   3.793531619043791*^9, {3.793620708680895*^9, 3.793620715877343*^9}, {
   3.7936210572342453`*^9, 3.7936211011277723`*^9}, {3.7936218773842583`*^9, 
   3.7936218808910093`*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"143bb381-6dd2-45ab-b674-3e82190eb0d8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7935315126073933`*^9, 3.793531630730225*^9, 3.79353176784595*^9, 
   3.793532884452765*^9, 3.793620831069229*^9, {3.7936210912738943`*^9, 
   3.7936211017042294`*^9}, 3.793621905726521*^9, 3.7936551739406033`*^9, 
   3.7936757214603443`*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"c9c70f88-19c7-4f17-ac66-c7b961ab4190"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["G and F", "Section",
 CellChangeTimes->{{3.793597382974214*^9, 
  3.79359738545455*^9}},ExpressionUUID->"afaf60a8-fcfc-40ba-b8b0-\
faf32b2bb0df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", "m"}], 
       SuperscriptBox["hbar", "2"]], "eV"}], "=", 
     RowBox[{
      SuperscriptBox["kl", "2"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["nx", "2"], "+", 
          SuperscriptBox["ny", "2"]}], ")"}], " ", 
        SuperscriptBox["\[Pi]", "2"]}], 
       SuperscriptBox["W", "2"]]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"tp", "\[IndentingNewLine]", 
   RowBox[{"stp", "=", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{"tp", ",", 
       RowBox[{"{", 
        RowBox[{"L", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
     "FullSimplify"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", "stp", ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["kt", "2"], "\[Rule]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["nx", "2"], "+", 
             SuperscriptBox["ny", "2"]}], ")"}], " ", 
           SuperscriptBox["\[Pi]", "2"]}], 
          SuperscriptBox["W", "2"]]}]}], ",", 
       RowBox[{"kl", "\[Rule]", 
        SqrtBox[
         RowBox[{
          FractionBox[
           RowBox[{"2", "m", " ", "eV"}], 
           SuperscriptBox["hbar", "2"]], "-", 
          FractionBox[
           RowBox[{" ", 
            RowBox[{
             SuperscriptBox["\[Pi]", "2"], 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}]}]}], 
           SuperscriptBox["W", "2"]]}]]}]}], " ", "}"}]}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "eV", " ", "m"}], 
          SuperscriptBox["hbar", "2"]], "-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["nx", "2"], "+", 
             SuperscriptBox["ny", "2"]}], ")"}], " ", 
           SuperscriptBox["\[Pi]", "2"]}], 
          SuperscriptBox["W", "2"]]}], ")"}], " ", "L"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "eV", " ", "m"}], 
          SuperscriptBox["hbar", "2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["nx", "2"], "+", 
             SuperscriptBox["ny", "2"]}], ")"}], " ", 
           SuperscriptBox["\[Pi]", "2"]}], 
          SuperscriptBox["W", "2"]]}]]}]], "\[Equal]", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "L"}], "2"], 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "eV", " ", "m"}], 
           SuperscriptBox["hbar", "2"]], "-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["nx", "2"], "+", 
              SuperscriptBox["ny", "2"]}], ")"}], " ", 
            SuperscriptBox["\[Pi]", "2"]}], 
           SuperscriptBox["W", "2"]]}]], " ", "-", 
        FractionBox[
         RowBox[{" ", 
          FractionBox[
           RowBox[{" ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["nx", "2"], "+", 
               SuperscriptBox["ny", "2"]}], ")"}], " ", 
             SuperscriptBox["\[Pi]", "2"]}]}], 
           SuperscriptBox["W", "2"]]}], 
         RowBox[{" ", 
          SqrtBox[
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "eV", " ", "m"}], 
             SuperscriptBox["hbar", "2"]], "-", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["nx", "2"], "+", 
                SuperscriptBox["ny", "2"]}], ")"}], " ", 
              SuperscriptBox["\[Pi]", "2"]}], 
             SuperscriptBox["W", "2"]]}]]}]]}], ")"}]}]}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.7936286175445004`*^9, 3.793628646471891*^9}, {
  3.793628727786745*^9, 3.793628814557249*^9}, {3.793629179025015*^9, 
  3.793629235430375*^9}, {3.7936293577028913`*^9, 3.793629375472864*^9}, {
  3.793675865765498*^9, 3.793675914445476*^9}, {3.793676044188149*^9, 
  3.793676049251196*^9}, {3.793676081533061*^9, 3.793676167402322*^9}, {
  3.7936763553445473`*^9, 3.793676355584877*^9}, {3.793678693236553*^9, 
  3.7936787036419*^9}, {3.7936788142768927`*^9, 3.7936788905126467`*^9}, {
  3.7936789371369123`*^9, 3.793678970981423*^9}},
 CellLabel->
  "In[246]:=",ExpressionUUID->"25178480-4c02-4ee6-a686-7ac3e676729c"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt"}], 
  RowBox[{
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "kl", " ", "kt", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kl", "2"], "+", 
      SuperscriptBox["kt", "2"]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"kt", " ", "L"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.793675870917881*^9, 3.7936758790984917`*^9}, 
   3.793676001989233*^9, 3.793676049901992*^9, {3.793676083207571*^9, 
   3.793676106134265*^9}, {3.7936761463119097`*^9, 3.793676167857562*^9}, 
   3.7936763561886187`*^9, 3.79367870427153*^9, {3.793678886697568*^9, 
   3.793678891092388*^9}, 3.793678971953024*^9},
 CellLabel->
  "Out[246]=",ExpressionUUID->"4414da9c-2120-4888-8ea4-e78a2ae3fd20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["kl", "2"], "+", 
       SuperscriptBox["kt", "2"]}], ")"}], " ", "L"}], 
    RowBox[{"2", " ", "kl"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {1, (Complex[0, 
       Rational[
       1, 2]]/$CellContext`kl) ($CellContext`kl^2 + $CellContext`kt^2)}, 0, 2,
    1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793675870917881*^9, 3.7936758790984917`*^9}, 
   3.793676001989233*^9, 3.793676049901992*^9, {3.793676083207571*^9, 
   3.793676106134265*^9}, {3.7936761463119097`*^9, 3.793676167857562*^9}, 
   3.7936763561886187`*^9, 3.79367870427153*^9, {3.793678886697568*^9, 
   3.793678891092388*^9}, 3.793678971955863*^9},
 CellLabel->
  "Out[247]=",ExpressionUUID->"a4d984d6-fa02-481f-bc3f-9ab7205f61f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "eV", " ", "m"}], 
        SuperscriptBox["hbar", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}], ")"}], " ", 
         SuperscriptBox["\[Pi]", "2"]}], 
        SuperscriptBox["W", "2"]]}], ")"}], " ", "L"}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "eV", " ", "m"}], 
        SuperscriptBox["hbar", "2"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["nx", "2"], "+", 
           SuperscriptBox["ny", "2"]}], ")"}], " ", 
         SuperscriptBox["\[Pi]", "2"]}], 
        SuperscriptBox["W", "2"]]}]]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "2"],
    SeriesData[$CellContext`L, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {1, (Complex[0, 
       Rational[
       1, 2]] (((
         2 $CellContext`eV) $CellContext`hbar^(-2)) $CellContext`m - ((
        2 ($CellContext`nx^2 + $CellContext`ny^2)) 
       Pi^2) $CellContext`W^(-2))) (((
         2 $CellContext`eV) $CellContext`hbar^(-2)) $CellContext`m - \
(($CellContext`nx^2 + $CellContext`ny^2) Pi^2) $CellContext`W^(-2))^
     Rational[-1, 2]}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.793675870917881*^9, 3.7936758790984917`*^9}, 
   3.793676001989233*^9, 3.793676049901992*^9, {3.793676083207571*^9, 
   3.793676106134265*^9}, {3.7936761463119097`*^9, 3.793676167857562*^9}, 
   3.7936763561886187`*^9, 3.79367870427153*^9, {3.793678886697568*^9, 
   3.793678891092388*^9}, 3.7936789719591427`*^9},
 CellLabel->
  "Out[248]=",ExpressionUUID->"f24ec95f-9a62-4633-9510-6b6d0b82eac2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.793675870917881*^9, 3.7936758790984917`*^9}, 
   3.793676001989233*^9, 3.793676049901992*^9, {3.793676083207571*^9, 
   3.793676106134265*^9}, {3.7936761463119097`*^9, 3.793676167857562*^9}, 
   3.7936763561886187`*^9, 3.79367870427153*^9, {3.793678886697568*^9, 
   3.793678891092388*^9}, 3.793678972032338*^9},
 CellLabel->
  "Out[249]=",ExpressionUUID->"da462a4f-f8a2-487e-837a-a3a35a221e81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ans", "=", 
  RowBox[{
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "eV", " ", "m"}], 
         SuperscriptBox["hbar", "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}], ")"}], " ", 
          SuperscriptBox["\[Pi]", "2"]}], 
         SuperscriptBox["W", "2"]]}], ")"}], " ", "L"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "eV", " ", "m"}], 
         SuperscriptBox["hbar", "2"]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["nx", "2"], "+", 
            SuperscriptBox["ny", "2"]}], ")"}], " ", 
          SuperscriptBox["\[Pi]", "2"]}], 
         SuperscriptBox["W", "2"]]}]]}]]}], "/.", 
   RowBox[{
    RowBox[{
     SuperscriptBox["nx", "2"], "+", 
     SuperscriptBox["ny", "2"]}], "\[Rule]", " ", 
    SuperscriptBox["n", "2"]}]}]}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "1", 
    RowBox[{
     FractionBox["W", "\[Pi]"], 
     FractionBox[
      RowBox[{
       SqrtBox["2"], 
       SqrtBox["m"]}], "hbar"], 
     SqrtBox["eV"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{" ", "L"}], "2"], ")"}], "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "eV", " ", "m"}], 
             SuperscriptBox["hbar", "2"]], "-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SuperscriptBox["\[Pi]", "2"]}], 
             SuperscriptBox["W", "2"]]}]], " ", "-", 
          FractionBox[
           RowBox[{" ", 
            FractionBox[
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SuperscriptBox["\[Pi]", "2"]}], 
             SuperscriptBox["W", "2"]]}], 
           RowBox[{" ", 
            SqrtBox[
             RowBox[{
              FractionBox[
               RowBox[{"2", " ", "eV", " ", "m"}], 
               SuperscriptBox["hbar", "2"]], "-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["n", "2"], 
                SuperscriptBox["\[Pi]", "2"]}], 
               SuperscriptBox["W", "2"]]}]]}]]}], ")"}], "2"]}]}], ")"}], "n", 
    RowBox[{"\[DifferentialD]", "n"}]}]}], 
  RowBox[{"2", "\[Pi]"}]]}], "Input",
 CellChangeTimes->{{3.793676207922977*^9, 3.793676209586575*^9}, 
   3.793676241766485*^9, {3.7936764125581293`*^9, 3.793676420913103*^9}, {
   3.7936764584527197`*^9, 3.79367651326549*^9}, {3.793676548063952*^9, 
   3.7936765797004128`*^9}, {3.793676637166956*^9, 3.79367663864554*^9}, {
   3.7936790044615927`*^9, 3.793679025207987*^9}, {3.7936790568154488`*^9, 
   3.793679081753812*^9}},
 CellLabel->
  "In[254]:=",ExpressionUUID->"052dacdc-7125-473d-8780-0ca2f8d6fa75"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "L", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "eV", " ", "m"}], 
       SuperscriptBox["hbar", "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["n", "2"], " ", 
        SuperscriptBox["\[Pi]", "2"]}], 
       SuperscriptBox["W", "2"]]}], ")"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "eV", " ", "m"}], 
       SuperscriptBox["hbar", "2"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["n", "2"], " ", 
        SuperscriptBox["\[Pi]", "2"]}], 
       SuperscriptBox["W", "2"]]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.793676465295992*^9, 3.793676513989993*^9, 3.7936765807779713`*^9, 
   3.793676639433571*^9, 3.793679026362495*^9, {3.79367906291499*^9, 
   3.7936790824982023`*^9}},
 CellLabel->
  "Out[254]=",ExpressionUUID->"384c8edc-4a76-43bf-ab1b-089fc3df751f"],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"32", " ", 
      SuperscriptBox["hbar", "4"], " ", 
      SuperscriptBox["\[Pi]", "3"]}]], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["hbar", "2"], " ", 
           SuperscriptBox["\[Pi]", "2"]}], "-", 
          RowBox[{"2", " ", "eV", " ", "m", " ", 
           SuperscriptBox["W", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "eV", " ", 
           SuperscriptBox["L", "2"], " ", "m", " ", 
           SuperscriptBox["W", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["hbar", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["L", "2"], " ", 
              SuperscriptBox["\[Pi]", "2"]}], "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["W", "2"]}]}], ")"}]}]}], ")"}]}], 
       SuperscriptBox["W", "2"]], "+", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["W", "2"]], 
       RowBox[{
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["hbar", "4"], " ", 
           SuperscriptBox["\[Pi]", "4"]}], "+", 
          RowBox[{"4", " ", "eV", " ", 
           SuperscriptBox["hbar", "2"], " ", "m", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["W", "2"]}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["eV", "2"], " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox["W", "4"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["eV", "2"], " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox["W", "4"], " ", 
           RowBox[{"Log", "[", "2", "]"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["eV", "2"], " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox["W", "4"], " ", 
           RowBox[{"Log", "[", 
            RowBox[{"eV", " ", "m"}], "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["eV", "2"], " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox["W", "4"], " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["hbar", "2"]}], " ", 
              SuperscriptBox["\[Pi]", "2"]}], "+", 
             RowBox[{"2", " ", "eV", " ", "m", " ", 
              SuperscriptBox["W", "2"]}]}], "]"}]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["eV", "2"], " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox["W", "4"], " ", 
           RowBox[{"Log", "[", 
            RowBox[{"Abs", "[", "W", "]"}], "]"}]}]}], ")"}]}]}]}], ")"}]}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "eV", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "hbar", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "m", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "W", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["hbar", "2"], " ", 
       SuperscriptBox["\[Pi]", "2"]}], 
      RowBox[{"m", " ", 
       SuperscriptBox["W", "2"]}]], "<", 
     RowBox[{"2", " ", 
      RowBox[{"Re", "[", "eV", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "m", "]"}], ">", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", "hbar", "]"}], "<", "0"}], "&&", 
        RowBox[{
         RowBox[{"Re", "[", "W", "]"}], "<", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", "hbar", "]"}], ">", "0"}], "&&", 
        RowBox[{
         RowBox[{"Re", "[", "W", "]"}], ">", "0"}]}], ")"}]}], ")"}]}]}], 
  "]"}]], "Output",
 CellChangeTimes->{3.793676465295992*^9, 3.793676513989993*^9, 
  3.7936765807779713`*^9, 3.793676639433571*^9, 3.793679026362495*^9, 
  3.79367906291499*^9, 3.793679152693494*^9},
 CellLabel->
  "Out[255]=",ExpressionUUID->"3c635e2a-5712-4c78-9a27-b2d73e5161ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"int", "[", "n_", "]"}], "=", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{" ", "L"}], "2"], ")"}], "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "eV", " ", "m"}], 
             SuperscriptBox["hbar", "2"]], "-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SuperscriptBox["\[Pi]", "2"]}], 
             SuperscriptBox["W", "2"]]}]], " ", "-", 
          FractionBox[
           RowBox[{" ", 
            FractionBox[
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SuperscriptBox["\[Pi]", "2"]}], 
             SuperscriptBox["W", "2"]]}], 
           RowBox[{" ", 
            SqrtBox[
             RowBox[{
              FractionBox[
               RowBox[{"2", " ", "eV", " ", "m"}], 
               SuperscriptBox["hbar", "2"]], "-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["n", "2"], 
                SuperscriptBox["\[Pi]", "2"]}], 
               SuperscriptBox["W", "2"]]}]]}]]}], ")"}], "2"]}]}], ")"}], "n", 
    RowBox[{"\[DifferentialD]", "n"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int", "[", "n_", "]"}], "=", 
  RowBox[{
   FractionBox[
    SuperscriptBox["n", "2"], "2"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox["n", "4"], " ", 
     SuperscriptBox["\[Pi]", "2"]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["W", "2"]}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["eV", "2"], " ", 
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["W", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["hbar", "2"]}], " ", 
        SuperscriptBox["n", "2"], " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"2", " ", "eV", " ", "m", " ", 
        SuperscriptBox["W", "2"]}]}], "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["hbar", "4"], " ", 
     SuperscriptBox["\[Pi]", "2"]}]]}]}]}], "Input",
 CellChangeTimes->{{3.79367706310713*^9, 3.7936770661536694`*^9}, {
   3.793677107987179*^9, 3.7936771199262877`*^9}, 3.793677373537737*^9, {
   3.793677446633778*^9, 3.793677477532304*^9}, 3.79367919720638*^9, 
   3.793679370900939*^9},
 CellLabel->
  "In[258]:=",ExpressionUUID->"3a662799-a6dd-486e-9e8d-d6894bd03697"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["n", "2"], "2"]], "Output",
 CellChangeTimes->{3.79367707216529*^9, 3.79367712365307*^9, 
  3.793677374421995*^9, 3.793677447484022*^9, 3.793677478377141*^9, 
  3.793679198298365*^9, 3.793679371599216*^9},
 CellLabel->
  "Out[258]=",ExpressionUUID->"c5e183e9-9625-4f7b-b7c6-e0324fd6d241"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["n", "2"], "2"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["L", "2"], " ", 
    SuperscriptBox["n", "4"], " ", 
    SuperscriptBox["\[Pi]", "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["W", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["eV", "2"], " ", 
    SuperscriptBox["L", "2"], " ", 
    SuperscriptBox["m", "2"], " ", 
    SuperscriptBox["W", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["hbar", "2"]}], " ", 
       SuperscriptBox["n", "2"], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "+", 
      RowBox[{"2", " ", "eV", " ", "m", " ", 
       SuperscriptBox["W", "2"]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["hbar", "4"], " ", 
    SuperscriptBox["\[Pi]", "2"]}]]}]], "Output",
 CellChangeTimes->{3.79367707216529*^9, 3.79367712365307*^9, 
  3.793677374421995*^9, 3.793677447484022*^9, 3.793677478377141*^9, 
  3.793679198298365*^9, 3.793679371603654*^9},
 CellLabel->
  "Out[259]=",ExpressionUUID->"73e95821-ab44-4c7b-b477-6b1dc65800d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"int", "[", 
    RowBox[{
     RowBox[{
      FractionBox["W", "\[Pi]"], 
      FractionBox[
       RowBox[{
        SqrtBox["2"], 
        SqrtBox["m"]}], "hbar"], 
      SqrtBox["eV"]}], "-", "\[Delta]"}], "]"}], "-", 
   RowBox[{"int", "[", "1", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.793677127926942*^9, 3.7936771469727182`*^9}, {
  3.7936771842482233`*^9, 3.793677202851082*^9}, {3.793677525267542*^9, 
  3.793677545143258*^9}},
 CellLabel->
  "In[233]:=",ExpressionUUID->"456c8b52-a8c4-4906-a83c-909e4bfe5d0d"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["hbar", "4"], " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox["W", "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["hbar", "4"], " ", 
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox["\[Pi]", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["hbar", "4"], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["W", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["hbar", "2"], " ", 
     SuperscriptBox["W", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["eV"], " ", 
         SqrtBox["m"], " ", "W"}], "-", 
        RowBox[{"hbar", " ", "\[Pi]", " ", "\[Delta]"}]}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["eV"], " ", 
         SqrtBox["m"], " ", "W"}], "-", 
        RowBox[{"hbar", " ", "\[Pi]", " ", "\[Delta]"}]}], ")"}], "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["eV", "2"], " ", 
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["W", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["hbar", "2"]}], " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"2", " ", "eV", " ", "m", " ", 
        SuperscriptBox["W", "2"]}]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["eV", "2"], " ", 
     SuperscriptBox["L", "2"], " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["W", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"hbar", " ", "\[Pi]", " ", "\[Delta]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox["eV"], " ", 
          SqrtBox["m"], " ", "W"}], "-", 
         RowBox[{"hbar", " ", "\[Pi]", " ", "\[Delta]"}]}], ")"}]}], 
      "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.793677147815178*^9, {3.7936771848323603`*^9, 3.793677203314929*^9}, 
   3.793677480606975*^9, {3.793677532226768*^9, 3.7936775486296988`*^9}},
 CellLabel->
  "Out[233]=",ExpressionUUID->"c3be85a9-f4ca-4065-b257-b410b63ab204"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "0"}], ")"}], "n"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", 
     RowBox[{
      RowBox[{
       FractionBox["W", "\[Pi]"], 
       FractionBox[
        RowBox[{
         SqrtBox["2"], 
         SqrtBox["m"]}], "hbar"], 
       SqrtBox["eV"]}], "-", "\[Delta]"}]}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eV", ",", "m", ",", " ", "hbar", ",", "W", ",", "\[Delta]"}], 
       "}"}], " ", "\[Element]", " ", "reals"}], " ", "&&", " ", 
     RowBox[{"eV", ">", "0"}], " ", "&&", " ", 
     RowBox[{"m", ">", "0"}], " ", "&&", " ", 
     RowBox[{"hbar", ">", "0"}], " ", "&&", " ", 
     RowBox[{"W", ">", "0"}], " ", "&&", 
     RowBox[{"\[Delta]", ">", "0"}], " ", "&&", " ", 
     RowBox[{
      SqrtBox[
       FractionBox[
        RowBox[{"2", "m", " ", "eV"}], "hbar"]], ">", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{"\[Pi]", " ", "n"}]}], "W"]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.79367686462702*^9, 3.793677041104166*^9}, {
   3.7936775672411127`*^9, 3.793677590228321*^9}, 3.793680083340169*^9},
 CellLabel->
  "In[260]:=",ExpressionUUID->"9dae1ca8-a552-4a97-82dc-06843f85eb36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox["eV"], " ", 
        SqrtBox["m"], " ", "W"}], 
       RowBox[{"hbar", " ", "\[Pi]"}]], "-", "\[Delta]"}], ")"}], 
    "2"]}]}]], "Output",
 CellChangeTimes->{
  3.793676465295992*^9, 3.793676513989993*^9, 3.7936765807779713`*^9, {
   3.79367684294937*^9, 3.793676871570071*^9}, 3.793677070767515*^9, 
   3.793677631763871*^9, 3.793680084169629*^9},
 CellLabel->
  "Out[260]=",ExpressionUUID->"94925125-50e9-4b7a-88cc-be80275361f1"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"abb66ac8-8058-491d-8c34-f4d6f7c8027e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Emil\[CloseCurlyQuote]s case: double Weyl in arXiv:1606.06941", \
"Section",
 CellChangeTimes->{{3.793276760468227*^9, 3.79327676405161*^9}, {
  3.793276994712627*^9, 
  3.7932769988378057`*^9}},ExpressionUUID->"34ad89c1-3d19-4a42-8c61-\
28f80ad4bd6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Emil", "'"}], "s", " ", "case"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "mat", "]"}], ";", 
    RowBox[{"mat", "=", 
     RowBox[{
      RowBox[{"kx", " ", "\[Sigma]1"}], "+", 
      RowBox[{"ky", " ", "\[Sigma]2"}], "+", 
      RowBox[{"kz", " ", "\[Sigma]3"}]}]}], ";", 
    RowBox[{"mat", "//", "MatrixForm"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", " ", 
       RowBox[{"mat", "-", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], "//", 
      "FullSimplify"}], "//", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], "\[Sigma]0"}], ")"}]}], ")"}], 
     ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"kz", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"kz", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", "\"\<***********************\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "mat", "]"}], ";", 
    RowBox[{"mat", "=", 
     RowBox[{
      RowBox[{"kx", " ", "\[Sigma]1"}], "-", 
      RowBox[{"ky", " ", "\[Sigma]2"}], "-", 
      RowBox[{"kz", " ", "\[Sigma]3"}]}]}], ";", 
    RowBox[{
     RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], "\[Sigma]0"}], ")"}]}], ")"}], 
     ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{
         RowBox[{"-", "kz"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "ky"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "ky"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", "\"\<***********************\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "mat", "]"}], ";", 
    RowBox[{"mat", "=", 
     RowBox[{
      RowBox[{"kx", " ", "\[Sigma]1"}], "-", 
      RowBox[{"ky", " ", "\[Sigma]2"}], "+", 
      RowBox[{"kz", " ", "\[Sigma]3"}]}]}], ";", 
    RowBox[{
     RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "+", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"kz", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{"kz", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", "\"\<***********************\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "mat", "]"}], ";", 
    RowBox[{"mat", "=", 
     RowBox[{
      RowBox[{"kx", " ", "\[Sigma]1"}], "+", 
      RowBox[{"ky", " ", "\[Sigma]2"}], "-", 
      RowBox[{"kz", " ", "\[Sigma]3"}]}]}], ";", 
    RowBox[{
     RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "+", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{
         RowBox[{"-", "kz"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "ky"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]], "\[Sigma]0"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}]]}], "}"}]}], "//", "FullSimplify", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "ky"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], 
      "=", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}]}], " ", "*)"}]}]}]}]], "Input",
 CellChangeTimes->{{3.791971570492*^9, 3.791971622538183*^9}, {
   3.791971657548932*^9, 3.7919716878964787`*^9}, {3.7919718575747747`*^9, 
   3.791971937817568*^9}, {3.791972008145213*^9, 3.791972024484685*^9}, {
   3.791972063285337*^9, 3.791972064657084*^9}, {3.79197230635651*^9, 
   3.791972320253578*^9}, {3.791972518873138*^9, 3.79197256060771*^9}, {
   3.791972594858273*^9, 3.791972674178191*^9}, {3.791972705173695*^9, 
   3.791972709613027*^9}, {3.7919727511644583`*^9, 3.791972855839168*^9}, {
   3.791972908150527*^9, 3.7919729106045237`*^9}, 3.791972949155271*^9, {
   3.791973005328298*^9, 3.791973013548932*^9}, {3.7919733275474977`*^9, 
   3.7919733803241777`*^9}, 3.79197424991002*^9, {3.791974776835096*^9, 
   3.791975044868967*^9}, {3.791975087154799*^9, 3.7919751642763968`*^9}, {
   3.791975222817049*^9, 3.79197537012363*^9}, {3.7919754164566593`*^9, 
   3.791975518303699*^9}, {3.791975554114766*^9, 3.791975663088871*^9}, {
   3.791975701993959*^9, 3.791975792937275*^9}, {3.7919772707188063`*^9, 
   3.791977306200761*^9}, {3.791977475748704*^9, 3.791977535252067*^9}, 
   3.791984746014956*^9},
 CellLabel->
  "In[761]:=",ExpressionUUID->"99985d56-4dc4-4403-90c2-ac7d324c2853"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"kz", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]},
     {
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
      RowBox[{"-", "kz"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249385806*^9},
 CellLabel->
  "Out[761]//MatrixForm=",ExpressionUUID->"d9656fd0-a388-46a2-8de6-\
c1155f8f4ccb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kz", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kz", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249475255*^9},
 CellLabel->
  "Out[763]=",ExpressionUUID->"b8aa2324-f63c-45fb-9674-1d81130a83f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.79198724948671*^9},
 CellLabel->
  "Out[764]=",ExpressionUUID->"36d3a1f5-9155-4076-b016-36baefc624ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249494318*^9},
 CellLabel->
  "Out[765]=",ExpressionUUID->"aeb45d71-5d99-4500-8bab-b0cf9c010521"],

Cell[BoxData["\<\"***********************\"\>"], "Print",
 CellChangeTimes->{{3.791975733208046*^9, 3.791975759320828*^9}, 
   3.791975793860511*^9, 3.79197727691508*^9, 3.7919773069294243`*^9, 
   3.791977487631791*^9, 3.791977535781775*^9, 3.791987249502858*^9},
 CellLabel->
  "During evaluation of \
In[761]:=",ExpressionUUID->"6b1e1318-2ee5-492a-9b96-106a4b6fd9ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.7919872495084553`*^9},
 CellLabel->
  "Out[767]=",ExpressionUUID->"3d8512fa-1087-4d6e-80a7-c344a5f9fd9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249515006*^9},
 CellLabel->
  "Out[768]=",ExpressionUUID->"74b798e7-31c8-4c6c-8a8e-cbb0d8dbcc3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249521921*^9},
 CellLabel->
  "Out[769]=",ExpressionUUID->"88ad949e-517c-4692-9d0b-f6351eadb07d"],

Cell[BoxData["\<\"***********************\"\>"], "Print",
 CellChangeTimes->{{3.791975733208046*^9, 3.791975759320828*^9}, 
   3.791975793860511*^9, 3.79197727691508*^9, 3.7919773069294243`*^9, 
   3.791977487631791*^9, 3.791977535781775*^9, 3.791987249528411*^9},
 CellLabel->
  "During evaluation of \
In[761]:=",ExpressionUUID->"dafdbc50-93c4-42df-8201-121e5566250e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kz", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kz", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249533969*^9},
 CellLabel->
  "Out[771]=",ExpressionUUID->"6f296014-19a7-43f4-97dc-6584d20527f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.7919872495404*^9},
 CellLabel->
  "Out[772]=",ExpressionUUID->"de51e508-c351-454b-b205-31d247134beb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249547619*^9},
 CellLabel->
  "Out[773]=",ExpressionUUID->"ec13ae5f-d76f-4e0d-800e-6a70fbe0759c"],

Cell[BoxData["\<\"***********************\"\>"], "Print",
 CellChangeTimes->{{3.791975733208046*^9, 3.791975759320828*^9}, 
   3.791975793860511*^9, 3.79197727691508*^9, 3.7919773069294243`*^9, 
   3.791977487631791*^9, 3.791977535781775*^9, 3.79198724955482*^9},
 CellLabel->
  "During evaluation of \
In[761]:=",ExpressionUUID->"87a124f4-0710-4dcf-ba7a-0a8e928ce5d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"], "+", 
        SuperscriptBox["kz", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249560763*^9},
 CellLabel->
  "Out[775]=",ExpressionUUID->"c3329b25-e149-495c-ad35-c7aa66795fa0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249567316*^9},
 CellLabel->
  "Out[776]=",ExpressionUUID->"975fc89e-3025-4b4a-8805-a90b21950bde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7919716088747253`*^9, 3.7919716230143347`*^9}, {
   3.791971683477543*^9, 3.79197168868188*^9}, 3.791971938655818*^9, {
   3.791972017486836*^9, 3.791972024967039*^9}, 3.791972065463336*^9, {
   3.791972308259444*^9, 3.791972321022421*^9}, {3.791972525865507*^9, 
   3.791972535099036*^9}, {3.7919725673887672`*^9, 3.791972640774663*^9}, 
   3.791972674786747*^9, 3.791972710165387*^9, {3.791972755651412*^9, 
   3.791972832553652*^9}, 3.7919729117164707`*^9, 3.7919729496946983`*^9, 
   3.791973014110011*^9, {3.7919733311363907`*^9, 3.791973381330988*^9}, 
   3.791974250395344*^9, 3.791974805521937*^9, {3.7919748393795652`*^9, 
   3.7919749972938547`*^9}, {3.791975028068359*^9, 3.791975137422736*^9}, 
   3.79197516842957*^9, {3.7919752235972443`*^9, 3.791975245053931*^9}, 
   3.791975285845456*^9, {3.7919755951255217`*^9, 3.791975606955718*^9}, 
   3.791975663867262*^9, {3.791975733181176*^9, 3.791975759290625*^9}, 
   3.7919757938284492`*^9, 3.791977276868318*^9, 3.791977306890892*^9, 
   3.7919774875959578`*^9, 3.791977535727043*^9, 3.791987249573977*^9},
 CellLabel->
  "Out[777]=",ExpressionUUID->"f01e4557-c330-4c0b-b41b-d0f10c730e00"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"c8f5017d-f39f-4091-a25e-48349712fcc8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bennakker\[CloseCurlyQuote]s case", "Section",
 CellChangeTimes->{{3.793276846697825*^9, 
  3.793276857276849*^9}},ExpressionUUID->"25cab080-2b94-43a4-ae18-\
1d55b0da58f9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", " ", "kx"}], "+", 
  RowBox[{"\[Sigma]2", " ", "ky"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", " ", "kx"}], "-", 
  RowBox[{"\[Sigma]2", " ", "ky"}]}]}], "Input",
 CellChangeTimes->{{3.7942969350773706`*^9, 3.79429695379503*^9}, {
  3.794296990195592*^9, 3.7942969947174177`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"8f3079a8-3b1b-4fcd-b089-1ad77659be3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"kx", "-", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.79429694879325*^9, 3.794296954040306*^9}, 
   3.7942969953782187`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"05a3786a-8e1b-4c15-bcda-0254ef32f2a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"kx", "-", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.79429694879325*^9, 3.794296954040306*^9}, 
   3.794296995382489*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"c46abecc-021f-48cf-834b-f4a6d25f55ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Bennakker", "'"}], "s", " ", "case"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "mat", "]"}], ";", 
    RowBox[{"mat", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0", ",", "0"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0"}], "}"}]}], 
      "}"}]}], ";", 
    RowBox[{"mat", "//", "MatrixForm"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"]}]]}], "id"}], ")"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"]}]]]}], ",", "1"}], "}"}]}], "//", 
    "FullSimplify"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "+", 
       SuperscriptBox["kz", "2"]}]]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{"mat", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]], "id"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1"}], "}"}]}], "//", "   ", 
    "FullSimplify", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Emil", "'"}], "s", " ", "case", " ", "with", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "ky"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "kz"}]}]], " ", "and", " ", "en"}], 
      "=", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}]}], " ", "*)"}]}]}]}]], "Input",
 CellChangeTimes->{{3.791987319954084*^9, 3.791987321602982*^9}, {
  3.791987398437667*^9, 3.7919874954766006`*^9}, {3.791987569861979*^9, 
  3.79198781900072*^9}, {3.791987852613893*^9, 3.791987888065783*^9}, {
  3.791987945739768*^9, 
  3.79198794623952*^9}},ExpressionUUID->"f442b6e4-2325-4af0-9c53-\
57bd57b27410"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0", "0"},
     {
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0", "0", "0"},
     {"0", "0", "0", 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]},
     {"0", "0", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.791987807082087*^9, 3.791987819751165*^9}, 
   3.79198789006126*^9},
 CellLabel->
  "Out[800]//MatrixForm=",ExpressionUUID->"26ace0ce-40a1-45e9-b8d2-\
cdc833105599"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}]], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"]}]]]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "kx"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1", ",", "0", ",", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.791987807082087*^9, 3.791987819751165*^9}, 
   3.791987890207397*^9},
 CellLabel->
  "Out[801]=",ExpressionUUID->"f6ed1dc6-5e93-4e06-8611-01deddee0efb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.791987807082087*^9, 3.791987819751165*^9}, 
   3.7919878902220507`*^9},
 CellLabel->
  "Out[802]=",ExpressionUUID->"d338d1f5-7171-47f6-9914-1701b0797a2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.791987807082087*^9, 3.791987819751165*^9}, 
   3.791987890232883*^9},
 CellLabel->
  "Out[803]=",ExpressionUUID->"1afdf093-dd75-47ff-a3d2-448def20e1f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"kx", "+", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"]}]]], 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]], ",", "1", ",", "0", ",", "0"}], 
    "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.79429856703308*^9, 3.794298609211784*^9}, {
  3.795608954908833*^9, 3.795608985793488*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"2732ba75-b40f-435c-bf52-1e026fffefa2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox[
    RowBox[{"kx", "+", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"]}]]], ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.795608986865499*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"afc85383-228e-4927-b1ec-27e08521c0f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "mat", "]"}], ";", 
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"kx", "-", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ",", "0"}], "}"}]}], "}"}]}], 
  ";", 
  RowBox[{"mat", "//", "MatrixForm"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eigensystem", "[", "mat", "]"}], "//", "FullSimplify"}]}], "Input",\

 CellChangeTimes->{{3.795608604738236*^9, 3.7956086200376053`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"43db4beb-d36c-47a9-81d7-132eb5f4c98e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0", "0"},
     {
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0", "0", "0"},
     {"0", "0", "0", 
      RowBox[{"kx", "-", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]},
     {"0", "0", 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.795608628314369*^9},
 CellLabel->
  "Out[1]//MatrixForm=",ExpressionUUID->"20318ecf-eb67-41dd-a87a-\
7e3a02d72f88"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]}], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}]], ",", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "kx"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"]}]]]}], ",", "1", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"]}]]], ",", "1", ",", "0", ",", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.795608628415847*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"eacace7d-b2be-4b1b-999c-3795a8490956"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "kx"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"]}]]], 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "kx"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["kx", "2"], "+", 
        SuperscriptBox["ky", "2"]}]]], ",", "1"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.795608778081153*^9, 3.7956087875231857`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"70c6792c-2e7d-4896-9390-0af864585fc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"kx", "+", 
      RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"]}]]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.795608788069366*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"7558b335-a1a3-4d62-a21f-e8def393c8dd"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"db4f76d9-0e70-4ac9-89be-2661c7445a8d"]
}, Open  ]]
},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1df06eb7-e1af-40fa-8db9-ed1de053dbf5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 12570, 347, 887, "Input",ExpressionUUID->"67e2fc9a-96ed-4e72-a98f-6596d95f32cf",
 InitializationCell->True],
Cell[13153, 371, 1348, 19, 34, "Output",ExpressionUUID->"ca5f070b-f03e-4647-aba2-0a2a4ee5c4e5"],
Cell[14504, 392, 1350, 19, 34, "Output",ExpressionUUID->"c4f1e460-a5bc-49ff-b683-239a9fb3549d"],
Cell[15857, 413, 4626, 123, 142, "Output",ExpressionUUID->"44dce660-ea57-4115-8313-a7e544b15587"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20520, 541, 210, 4, 30, "Input",ExpressionUUID->"69221881-ed58-4125-8ff6-def120d1a2bb"],
Cell[20733, 547, 3802, 120, 130, "Output",ExpressionUUID->"3f0cc762-a040-4c40-acc2-32fdae1d4a07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24572, 672, 1094, 27, 94, "Input",ExpressionUUID->"39df0fd4-b3b8-44d3-a9a8-017fd111a02e"],
Cell[25669, 701, 9525, 279, 449, "Output",ExpressionUUID->"48a7ea34-09d7-4fda-bd7b-994b25ed3452"],
Cell[35197, 982, 659, 16, 49, "Output",ExpressionUUID->"8b9dffcf-a448-4872-bb64-c691bbf584e7"],
Cell[35859, 1000, 466, 8, 34, "Output",ExpressionUUID->"56a6de23-09df-4897-b240-08cd2376047c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36362, 1013, 435, 11, 30, "Input",ExpressionUUID->"07584aa9-ce83-4086-98a9-459d23e620fe"],
Cell[36800, 1026, 398, 9, 45, "Output",ExpressionUUID->"9d8cf0d1-2ea0-4dc6-84c7-2c24d8a68cf8"]
}, Open  ]],
Cell[37213, 1038, 331, 10, 6, "Text",ExpressionUUID->"e516813a-fa9c-4550-acaf-5f6c146b820a"],
Cell[CellGroupData[{
Cell[37569, 1052, 3064, 74, 138, "Input",ExpressionUUID->"189bf48e-9aaa-476a-813a-90250ceb1d01"],
Cell[40636, 1128, 421, 7, 34, "Output",ExpressionUUID->"08990089-c69b-42ea-a5c6-5f8dcbbc8110"],
Cell[41060, 1137, 2194, 62, 123, "Output",ExpressionUUID->"c2b6aaf1-91f7-4152-a208-7cb707dbb257"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43291, 1204, 2830, 81, 199, "Input",ExpressionUUID->"1d426b98-b384-4b0a-91c6-1b964c87ce93"],
Cell[46124, 1287, 1775, 55, 123, "Output",ExpressionUUID->"07755171-4880-4704-8937-1b718e542444"],
Cell[47902, 1344, 411, 8, 34, "Output",ExpressionUUID->"c8ecc29f-3771-484a-b691-af65d5f6ec4c"],
Cell[48316, 1354, 1772, 55, 123, "Output",ExpressionUUID->"27e6b293-194e-40ef-a01d-008a0b2e8dc7"],
Cell[50091, 1411, 411, 8, 34, "Output",ExpressionUUID->"d6885ac3-5020-479e-aba0-5c3783e184be"],
Cell[50505, 1421, 345, 6, 34, "Output",ExpressionUUID->"d42c803d-3a70-430b-9bac-e3d999860851"]
}, Open  ]],
Cell[50865, 1430, 331, 10, 6, "Text",ExpressionUUID->"a55ed502-0753-4548-9e06-7d034a4dac8c"],
Cell[CellGroupData[{
Cell[51221, 1444, 2653, 64, 117, "Input",ExpressionUUID->"a9a4d3b1-f858-44f7-8882-496a0389374c"],
Cell[53877, 1510, 963, 14, 34, "Output",ExpressionUUID->"41edf5e3-e5e3-4950-b785-cea8cc5173bd"],
Cell[54843, 1526, 2764, 70, 123, "Output",ExpressionUUID->"3902a325-8542-4459-929e-c1697409e368"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57644, 1601, 2976, 82, 178, "Input",ExpressionUUID->"d0580710-3d62-4ab3-94a1-77f1141f9bca"],
Cell[60623, 1685, 2219, 65, 122, "Output",ExpressionUUID->"21cfc5f9-ecd1-409a-ae4b-e42dc6e1ea05"],
Cell[62845, 1752, 631, 11, 34, "Output",ExpressionUUID->"0c9c4593-d871-47db-b9ea-0b54ae878fae"],
Cell[63479, 1765, 2293, 68, 122, "Output",ExpressionUUID->"ff23242d-4ac2-4693-848d-4cbdd26f2bba"],
Cell[65775, 1835, 632, 11, 34, "Output",ExpressionUUID->"753fdfa4-36ec-4a63-9648-8b359f906757"],
Cell[66410, 1848, 569, 9, 34, "Output",ExpressionUUID->"02bba716-db13-485b-b24e-d7bcab7bec99"]
}, Open  ]],
Cell[66994, 1860, 329, 10, 8, "Text",ExpressionUUID->"b3ff730d-d206-4c30-a706-d8b8c9f1ce72"],
Cell[CellGroupData[{
Cell[67348, 1874, 220, 4, 67, "Section",ExpressionUUID->"9f947e13-a59d-4f3a-acf2-8af9b24f640d"],
Cell[CellGroupData[{
Cell[67593, 1882, 8521, 270, 603, "Input",ExpressionUUID->"179b570a-dc9a-4c88-b790-a24a1c6de411"],
Cell[76117, 2154, 257, 5, 34, "Output",ExpressionUUID->"29f25724-750d-4bb8-8f0c-7d0de2fd4b07"],
Cell[76377, 2161, 315, 7, 34, "Output",ExpressionUUID->"af7e420f-c3e4-47a2-8139-f1f38f822c32"],
Cell[76695, 2170, 314, 7, 34, "Output",ExpressionUUID->"36dbe8d1-3f3e-4f1f-a039-cc163f5f713e"],
Cell[77012, 2179, 315, 7, 34, "Output",ExpressionUUID->"582c57ec-515b-4b18-81af-9f2c3528a7da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77364, 2191, 1892, 53, 136, "Input",ExpressionUUID->"31ce50fc-1431-42eb-8a3c-9baa3a89b045"],
Cell[79259, 2246, 232, 5, 34, "Output",ExpressionUUID->"7617bdd3-7b58-40d5-bcdd-b4c17bcf12a5"],
Cell[79494, 2253, 232, 5, 34, "Output",ExpressionUUID->"4c706f98-2ee9-4322-93ef-93ba66eef420"],
Cell[79729, 2260, 230, 5, 34, "Output",ExpressionUUID->"02b8d011-9609-4d78-806a-98f6a9b5ee63"],
Cell[79962, 2267, 230, 5, 34, "Output",ExpressionUUID->"f3ad5e03-cecd-4bc8-9160-5fb6b7ac1908"],
Cell[80195, 2274, 229, 5, 34, "Output",ExpressionUUID->"05d9d4e5-7c73-4e1a-bcb5-c6643310f2c2"],
Cell[80427, 2281, 230, 5, 34, "Output",ExpressionUUID->"3f9946b0-0780-49e7-8536-f9c4815df551"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80694, 2291, 5479, 144, 413, "Input",ExpressionUUID->"cbc4e99c-00a1-4079-b5f0-a0e48c75efd9"],
Cell[86176, 2437, 12050, 310, 156, "Output",ExpressionUUID->"82165433-efe3-40e1-9aa9-31b8ad11736f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98263, 2752, 1201, 34, 52, "Input",ExpressionUUID->"9499f5b3-5f08-4065-91e4-7bb22e6ab9db"],
Cell[99467, 2788, 1893, 56, 61, "Output",ExpressionUUID->"7e90695d-7716-4cff-8e06-06ebd2f7e7c6"],
Cell[101363, 2846, 511, 11, 46, "Message",ExpressionUUID->"4b73ff31-0eb3-471a-b81a-9009a8c09e9f"],
Cell[101877, 2859, 350, 6, 34, "Output",ExpressionUUID->"4d5c8949-7e0b-4fd5-a3a2-10e8395960a2"]
}, Open  ]],
Cell[102242, 2868, 329, 10, 8, "Text",ExpressionUUID->"2edf90d8-39fb-41f2-ac49-6d3df2907b41"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102608, 2883, 163, 3, 67, "Section",ExpressionUUID->"2f440a01-0ad7-4199-bda8-dcfd75705115"],
Cell[102774, 2888, 6737, 196, 484, "Input",ExpressionUUID->"d7722e1d-1af9-4e24-b0d6-c0139e68652f"],
Cell[CellGroupData[{
Cell[109536, 3088, 1668, 41, 94, "Input",ExpressionUUID->"3e0d44c9-ba64-49f2-923b-20b18fd532c8"],
Cell[111207, 3131, 8996, 232, 97, "Output",ExpressionUUID->"e670b68a-6626-49f6-8880-5999d45b1f87"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120240, 3368, 412, 10, 52, "Input",ExpressionUUID->"bd6824e0-4688-494d-9de3-ba3ff0a326c5"],
Cell[120655, 3380, 280, 5, 34, "Output",ExpressionUUID->"09b0a24c-1cd5-4220-8179-0f6b02cf2445"]
}, Open  ]],
Cell[120950, 3388, 505, 15, 73, "Input",ExpressionUUID->"6c78ea87-803f-41d9-a6e7-4b4ccfae2e42"],
Cell[121458, 3405, 329, 10, 8, "Text",ExpressionUUID->"8d6eeb8e-0d7d-43f0-91d7-aa7e7ac830ad"],
Cell[CellGroupData[{
Cell[121812, 3419, 202, 4, 45, "Subsubsection",ExpressionUUID->"35f12838-3059-408a-b3e3-9e50af461167"],
Cell[CellGroupData[{
Cell[122039, 3427, 4822, 146, 301, "Input",ExpressionUUID->"0a01d31b-218f-4495-9bbd-6cbe25364bca"],
Cell[126864, 3575, 921, 27, 56, "Output",ExpressionUUID->"a36c21d4-e875-4ee5-b5e4-4835bc36c5b8"],
Cell[127788, 3604, 1182, 35, 58, "Output",ExpressionUUID->"36f71baa-4cec-487c-802d-7b04d5d310f4"]
}, Open  ]],
Cell[128985, 3642, 8450, 227, 474, "Input",ExpressionUUID->"c5bc8bdf-20dd-49a6-924a-37253e265aa4"],
Cell[137438, 3871, 329, 10, 8, "Text",ExpressionUUID->"fa9699cd-6683-4040-9867-6b9aec782c35"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137804, 3886, 143, 3, 45, "Subsubsection",ExpressionUUID->"ac328492-e02a-4440-a4d0-de2ae3304cce"],
Cell[CellGroupData[{
Cell[137972, 3893, 14000, 389, 825, "Input",ExpressionUUID->"7fca446f-5c53-4f08-9f15-8cb8ba541db4"],
Cell[151975, 4284, 12483, 311, 151, "Output",ExpressionUUID->"3d2570fe-97a3-40b1-80db-3bab64be946f"]
}, Open  ]],
Cell[164473, 4598, 1919, 42, 94, "Input",ExpressionUUID->"74816ee9-f565-4d0d-ad07-2c38aeb29a4b"],
Cell[166395, 4642, 331, 10, 6, "Text",ExpressionUUID->"888fc188-15c1-4dfa-ae51-9ff838b2a05c"],
Cell[CellGroupData[{
Cell[166751, 4656, 881, 22, 33, "Input",ExpressionUUID->"b05c111a-36af-4908-b688-87b6c54a03ed"],
Cell[167635, 4680, 1223, 36, 62, "Output",ExpressionUUID->"355e71b7-01ee-4179-a3aa-5546d956c7ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168895, 4721, 3359, 104, 240, "Input",ExpressionUUID->"7351be3c-c949-4536-b00d-26866e24744a"],
Cell[172257, 4827, 2469, 74, 93, "Output",ExpressionUUID->"f0de3fbb-af8b-4754-8e24-ab5fd03e93b8"],
Cell[174729, 4903, 1942, 50, 79, "Output",ExpressionUUID->"fa47f91c-dfa0-445a-a3f4-36102be519be"],
Cell[176674, 4955, 1465, 39, 69, "Output",ExpressionUUID->"748879c7-dfba-4e9d-b25d-41724bfe9894"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178176, 4999, 3001, 83, 202, "Input",ExpressionUUID->"0a601e81-b2f5-4059-abeb-914e370862de"],
Cell[181180, 5084, 3587, 99, 141, "Output",ExpressionUUID->"29327809-77b1-4630-9c8f-95c4567f6576"],
Cell[184770, 5185, 4492, 121, 186, "Output",ExpressionUUID->"bfb2185d-03a2-4ab3-a040-81bb94071fa0"]
}, Open  ]],
Cell[189277, 5309, 331, 10, 6, "Text",ExpressionUUID->"9b9ed1bd-41ff-49dd-a880-10b3771df003"],
Cell[CellGroupData[{
Cell[189633, 5323, 1369, 29, 54, "Input",ExpressionUUID->"14552245-31e6-49df-8c8e-cd77d98063e7"],
Cell[191005, 5354, 1132, 24, 57, "Output",ExpressionUUID->"f4ed0b4f-c423-4408-b0ab-5beb732312f0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192174, 5383, 4889, 134, 375, "Input",ExpressionUUID->"6300f3cd-889c-483a-af80-1e0c5e6ed3c1"],
Cell[197066, 5519, 1734, 48, 72, "Output",ExpressionUUID->"d2d53b53-179d-4118-a146-407526c0b2cb"],
Cell[198803, 5569, 1435, 35, 74, "Output",ExpressionUUID->"d3804824-ac2a-4093-ba6b-786d54d7746b"],
Cell[200241, 5606, 1870, 49, 69, "Output",ExpressionUUID->"4c60350c-6310-4fc9-b649-e676a6b6a3c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202148, 5660, 7479, 201, 362, "Input",ExpressionUUID->"b9a5d34f-edd4-4897-94e1-443545f2d5af"],
Cell[209630, 5863, 2496, 71, 130, "Output",ExpressionUUID->"8644e1f1-ffe0-4b79-b4e9-82fe2838266d"],
Cell[212129, 5936, 2641, 77, 77, "Output",ExpressionUUID->"d698f3d2-2d4f-4663-9e76-49971e107633"]
}, Open  ]],
Cell[214785, 6016, 331, 10, 6, "Text",ExpressionUUID->"4500058b-fc95-405f-915e-373e21e7ab46"],
Cell[CellGroupData[{
Cell[215141, 6030, 1415, 30, 54, "Input",ExpressionUUID->"aa9d2c92-1879-43da-96a1-352e7882c722"],
Cell[216559, 6062, 872, 26, 60, "Output",ExpressionUUID->"9855daee-889f-4c40-9cef-b9cf8d1ba991"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217468, 6093, 302, 7, 30, "Input",ExpressionUUID->"06ef85dd-272d-492b-9ead-4ed631a9c581"],
Cell[217773, 6102, 2566, 73, 103, "Output",ExpressionUUID->"86ad0e6f-74ed-413c-a6dd-497dff0834b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220376, 6180, 740, 21, 79, "Input",ExpressionUUID->"3137ed13-e361-4491-b750-8d9ec012d404"],
Cell[221119, 6203, 1791, 58, 88, "Output",ExpressionUUID->"3448ea6a-be2d-4328-8875-72c3f1f70894"],
Cell[222913, 6263, 1058, 30, 60, "Output",ExpressionUUID->"91f1bced-b66f-4632-aa48-225954d546a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224008, 6298, 2417, 72, 208, "Input",ExpressionUUID->"f519a1fc-e9d2-4213-b549-599430b3fe45"],
Cell[226428, 6372, 2693, 78, 153, "Output",ExpressionUUID->"0b543b48-37f1-46cf-b03c-f6f4066a0811"],
Cell[229124, 6452, 1502, 41, 60, "Output",ExpressionUUID->"5ba85d80-5c27-46d8-a252-8d27f3e1a0a3"]
}, Open  ]],
Cell[230641, 6496, 331, 10, 6, "Text",ExpressionUUID->"910366d5-d701-4c0d-b1b6-6331d93788d7"],
Cell[CellGroupData[{
Cell[230997, 6510, 776, 21, 33, "Input",ExpressionUUID->"143bb381-6dd2-45ab-b674-3e82190eb0d8"],
Cell[231776, 6533, 377, 7, 34, "Output",ExpressionUUID->"c9c70f88-19c7-4f17-ac66-c7b961ab4190"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[232214, 6547, 151, 3, 67, "Section",ExpressionUUID->"afaf60a8-fcfc-40ba-b8b0-faf32b2bb0df"],
Cell[CellGroupData[{
Cell[232390, 6554, 4905, 143, 274, "Input",ExpressionUUID->"25178480-4c02-4ee6-a686-7ac3e676729c"],
Cell[237298, 6699, 865, 20, 57, "Output",ExpressionUUID->"4414da9c-2120-4888-8ea4-e78a2ae3fd20"],
Cell[238166, 6721, 1029, 26, 55, "Output",ExpressionUUID->"a4d984d6-fa02-481f-bc3f-9ab7205f61f4"],
Cell[239198, 6749, 1985, 53, 97, "Output",ExpressionUUID->"f24ec95f-9a62-4633-9510-6b6d0b82eac2"],
Cell[241186, 6804, 449, 7, 34, "Output",ExpressionUUID->"da462a4f-f8a2-487e-837a-a3a35a221e81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241672, 6816, 3220, 96, 203, "Input",ExpressionUUID->"052dacdc-7125-473d-8780-0ca2f8d6fa75"],
Cell[244895, 6914, 999, 30, 81, "Output",ExpressionUUID->"384c8edc-4a76-43bf-ab1b-089fc3df751f"],
Cell[245897, 6946, 4307, 121, 240, "Output",ExpressionUUID->"3c635e2a-5712-4c78-9a27-b2d73e5161ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250241, 7072, 2668, 79, 143, "Input",ExpressionUUID->"3a662799-a6dd-486e-9e8d-d6894bd03697"],
Cell[252912, 7153, 333, 7, 52, "Output",ExpressionUUID->"c5e183e9-9625-4f7b-b7c6-e0324fd6d241"],
Cell[253248, 7162, 1117, 33, 57, "Output",ExpressionUUID->"73e95821-ab44-4c7b-b477-6b1dc65800d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[254402, 7200, 588, 17, 53, "Input",ExpressionUUID->"456c8b52-a8c4-4906-a83c-909e4bfe5d0d"],
Cell[254993, 7219, 2366, 70, 102, "Output",ExpressionUUID->"c3be85a9-f4ca-4065-b257-b410b63ab204"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257396, 7294, 1312, 37, 128, "Input",ExpressionUUID->"9dae1ca8-a552-4a97-82dc-06843f85eb36"],
Cell[258711, 7333, 679, 21, 58, "Output",ExpressionUUID->"94925125-50e9-4b7a-88cc-be80275361f1"]
}, Open  ]],
Cell[259405, 7357, 329, 10, 8, "Text",ExpressionUUID->"abb66ac8-8058-491d-8c34-f4d6f7c8027e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259771, 7372, 258, 5, 67, "Section",ExpressionUUID->"34ad89c1-3d19-4a42-8c61-28f80ad4bd6b"],
Cell[CellGroupData[{
Cell[260054, 7381, 13413, 383, 906, "Input",ExpressionUUID->"99985d56-4dc4-4403-90c2-ac7d324c2853"],
Cell[273470, 7766, 1833, 38, 62, "Output",ExpressionUUID->"d9656fd0-a388-46a2-8de6-c1155f8f4ccb"],
Cell[275306, 7806, 2349, 57, 58, "Output",ExpressionUUID->"b8aa2324-f63c-45fb-9674-1d81130a83f5"],
Cell[277658, 7865, 1247, 19, 34, "Output",ExpressionUUID->"36d3a1f5-9155-4076-b016-36baefc624ac"],
Cell[278908, 7886, 1248, 19, 34, "Output",ExpressionUUID->"aeb45d71-5d99-4500-8bab-b0cf9c010521"],
Cell[280159, 7907, 370, 6, 24, "Print",ExpressionUUID->"6b1e1318-2ee5-492a-9b96-106a4b6fd9ef"],
Cell[280532, 7915, 2408, 59, 88, "Output",ExpressionUUID->"3d8512fa-1087-4d6e-80a7-c344a5f9fd9a"],
Cell[282943, 7976, 1248, 19, 34, "Output",ExpressionUUID->"74b798e7-31c8-4c6c-8a8e-cbb0d8dbcc3b"],
Cell[284194, 7997, 1248, 19, 34, "Output",ExpressionUUID->"88ad949e-517c-4692-9d0b-f6351eadb07d"],
Cell[285445, 8018, 370, 6, 24, "Print",ExpressionUUID->"dafdbc50-93c4-42df-8201-121e5566250e"],
Cell[285818, 8026, 2349, 57, 58, "Output",ExpressionUUID->"6f296014-19a7-43f4-97dc-6584d20527f1"],
Cell[288170, 8085, 1246, 19, 34, "Output",ExpressionUUID->"de51e508-c351-454b-b205-31d247134beb"],
Cell[289419, 8106, 1248, 19, 34, "Output",ExpressionUUID->"ec13ae5f-d76f-4e0d-800e-6a70fbe0759c"],
Cell[290670, 8127, 369, 6, 24, "Print",ExpressionUUID->"87a124f4-0710-4dcf-ba7a-0a8e928ce5d2"],
Cell[291042, 8135, 2406, 59, 88, "Output",ExpressionUUID->"c3329b25-e149-495c-ad35-c7aa66795fa0"],
Cell[293451, 8196, 1248, 19, 34, "Output",ExpressionUUID->"975fc89e-3025-4b4a-8805-a90b21950bde"],
Cell[294702, 8217, 1248, 19, 34, "Output",ExpressionUUID->"f01e4557-c330-4c0b-b41b-d0f10c730e00"]
}, Open  ]],
Cell[295965, 8239, 329, 10, 8, "Text",ExpressionUUID->"c8f5017d-f39f-4091-a25e-48349712fcc8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[296331, 8254, 178, 3, 67, "Section",ExpressionUUID->"25cab080-2b94-43a4-ae18-1d55b0da58f9"],
Cell[CellGroupData[{
Cell[296534, 8261, 2734, 73, 89, "Input",ExpressionUUID->"8f3079a8-3b1b-4fcd-b089-1ad77659be3a"],
Cell[299271, 8336, 480, 14, 34, "Output",ExpressionUUID->"05a3786a-8e1b-4c15-bcda-0254ef32f2a2"],
Cell[299754, 8352, 478, 14, 34, "Output",ExpressionUUID->"c46abecc-021f-48cf-834b-f4a6d25f55ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300269, 8371, 3683, 109, 269, "Input",ExpressionUUID->"f442b6e4-2325-4af0-9c53-57bd57b27410"],
Cell[303955, 8482, 1020, 30, 98, "Output",ExpressionUUID->"26ace0ce-40a1-45e9-b8d2-cdc833105599"],
Cell[304978, 8514, 2057, 68, 107, "Output",ExpressionUUID->"f6ed1dc6-5e93-4e06-8611-01deddee0efb"],
Cell[307038, 8584, 270, 6, 34, "Output",ExpressionUUID->"d338d1f5-7171-47f6-9914-1701b0797a2e"],
Cell[307311, 8592, 268, 6, 34, "Output",ExpressionUUID->"1afdf093-dd75-47ff-a3d2-448def20e1f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307616, 8603, 729, 22, 58, "Input",ExpressionUUID->"2732ba75-b40f-435c-bf52-1e026fffefa2"],
Cell[308348, 8627, 398, 11, 58, "Output",ExpressionUUID->"afc85383-228e-4927-b1ec-27e08521c0f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[308783, 8643, 1067, 30, 94, "Input",ExpressionUUID->"43db4beb-d36c-47a9-81d7-132eb5f4c98e"],
Cell[309853, 8675, 969, 29, 98, "Output",ExpressionUUID->"20318ecf-eb67-41dd-a87a-7e3a02d72f88"],
Cell[310825, 8706, 2002, 66, 107, "Output",ExpressionUUID->"eacace7d-b2be-4b1b-999c-3795a8490956"]
}, Open  ]],
Cell[CellGroupData[{
Cell[312864, 8777, 725, 23, 58, "Input",ExpressionUUID->"70c6792c-2e7d-4896-9390-0af864585fc4"],
Cell[313592, 8802, 424, 12, 58, "Output",ExpressionUUID->"7558b335-a1a3-4d62-a21f-e8def393c8dd"]
}, Open  ]],
Cell[314031, 8817, 329, 10, 8, "Text",ExpressionUUID->"db4f76d9-0e70-4ac9-89be-2661c7445a8d"]
}, Open  ]]
}
]
*)

