(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50362,       1491]
NotebookOptionsPosition[     48501,       1456]
NotebookOutlinePosition[     48822,       1470]
CellTagsIndexPosition[     48779,       1467]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ham", ",", "\[Psi]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"id", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Gamma]", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]", "[", "a", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "b", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Gamma]", "[", "b", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "a", "]"}]}]}], 
     RowBox[{"2", "\[ImaginaryI]"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"dahat", "=", 
    RowBox[{"da", "/", 
     SuperscriptBox["k", "2"]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "1", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kz", " ", "ky"}]}], ";", " ", 
  RowBox[{"d1hat", "=", 
   RowBox[{"d1", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "2", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "kz"}]}], ";", " ", 
  RowBox[{"d2hat", "=", 
   RowBox[{"d2", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "3", "]"}], "=", 
   RowBox[{
    SqrtBox["3"], "kx", " ", "ky"}]}], ";", " ", 
  RowBox[{"d3hat", "=", 
   RowBox[{"d3", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "4", "]"}], "=", 
   RowBox[{
    FractionBox[
     SqrtBox["3"], "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ")"}]}]}], ";", 
  RowBox[{"d4hat", "=", 
   RowBox[{"d4", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "5", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["kz", "2"]}], "-", 
     SuperscriptBox["kx", "2"], "-", 
     SuperscriptBox["ky", "2"]}], "2"]}], ";", 
  RowBox[{"d5hat", "=", 
   RowBox[{"d5", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "i", "]"}], 
      RowBox[{"\[Gamma]", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "ham", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", "ham", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6312382022915897`*^9, 3.631238225759459*^9}, {
   3.6312382600929537`*^9, 3.6312384017277803`*^9}, {3.631238501848529*^9, 
   3.631238514655388*^9}, {3.631238557337954*^9, 3.631238582703508*^9}, {
   3.631238697418057*^9, 3.6312387608920393`*^9}, {3.631238821822587*^9, 
   3.6312388336171837`*^9}, {3.6312388682255707`*^9, 3.63123894870654*^9}, 
   3.631241459271804*^9, 3.6312415058351183`*^9, {3.631242162714487*^9, 
   3.631242164860416*^9}, {3.631243821329649*^9, 3.6312438323099318`*^9}, {
   3.631243931067396*^9, 3.631243943321344*^9}, {3.631245485411551*^9, 
   3.631245507064893*^9}, {3.631245606183861*^9, 3.631245636233708*^9}, {
   3.631246369852314*^9, 3.631246410769082*^9}, {3.63124927017979*^9, 
   3.63124930420273*^9}, {3.631249422231785*^9, 3.631249432782104*^9}, {
   3.631249677286726*^9, 3.631249702711062*^9}, {3.631285101024441*^9, 
   3.631285106140984*^9}, {3.631285140088323*^9, 3.6312852358940573`*^9}, 
   3.631287438641325*^9, {3.631295671787744*^9, 3.631295675200363*^9}, {
   3.631296743735948*^9, 3.631296768464766*^9}, {3.631303956396132*^9, 
   3.6313039785131187`*^9}, {3.631363753884413*^9, 3.63136377298313*^9}, 
   3.631414086575067*^9, {3.631551950532612*^9, 3.631551957383226*^9}, 
   3.6315519991082993`*^9, {3.711821084066185*^9, 3.7118211139118958`*^9}, {
   3.711821392685665*^9, 3.71182150933855*^9}, {3.711821576479093*^9, 
   3.711821735961163*^9}, {3.7118217742380238`*^9, 3.711821848019948*^9}, {
   3.7118243385720043`*^9, 3.7118243649817753`*^9}, 3.793277445616826*^9, {
   3.794826944606303*^9, 3.794826969612651*^9}, {3.7948270440250483`*^9, 
   3.794827071360015*^9}, {3.795345678473947*^9, 3.795345684714752*^9}, {
   3.828232944156448*^9, 3.828232956289496*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"53ae6267-8c75-4418-bf17-47dc27885083"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], "0"},
     {
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "ky"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], "0", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "ky"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}]},
     {"0", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "kz"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.828232945075822*^9, 3.8282329567358923`*^9}, {
   3.828233069477543*^9, 3.828233079272254*^9}, 3.828236428303549*^9},
 CellLabel->
  "Out[16]//MatrixForm=",ExpressionUUID->"83c7301b-5610-4c28-a7d9-\
2168c0b8cfb5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["kz", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]], ",", 
       "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], 
           ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "kx", " ", "ky"}], "-", 
          SuperscriptBox["ky", "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["3"], " ", "kx"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"], " ", "ky"}]}], ")"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["kz", "2"]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]]}], 
       ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "kx"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], 
         RowBox[{"2", " ", "kz"}]]}], ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.828232945075822*^9, 3.8282329567358923`*^9}, {
   3.828233069477543*^9, 3.828233079272254*^9}, 3.828236428364015*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"c64a3e7e-149c-474a-a89f-772970701561"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"81cada91-34c7-44db-a261-0e079d4291e6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ham2", ",", "\[Psi]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {"1", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "\[ImaginaryI]"}]},
      {"\[ImaginaryI]", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"\[Sigma]0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "1", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "2", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "3", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]2", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "4", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]1", ",", "\[Sigma]0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "5", "]"}], "=", 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[Sigma]3", ",", "\[Sigma]3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"id", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Gamma]", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]", "[", "a", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "b", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Gamma]", "[", "b", "]"}], ".", 
       RowBox[{"\[Gamma]", "[", "a", "]"}]}]}], 
     RowBox[{"2", "\[ImaginaryI]"}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"dahat", "=", 
    RowBox[{"da", "/", 
     SuperscriptBox["k", "2"]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["3"]}], "kz", " ", "ky"}]}], ";", " ", 
  RowBox[{"d1hat", "=", 
   RowBox[{"d1", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "2", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["3"]}], "kx", " ", "kz"}]}], ";", " ", 
  RowBox[{"d2hat", "=", 
   RowBox[{"d2", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "3", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["3"]}], "kx", " ", "ky"}]}], ";", " ", 
  RowBox[{"d3hat", "=", 
   RowBox[{"d3", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "4", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SqrtBox["3"], "2"]}], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], ")"}]}]}], ";", 
  RowBox[{"d4hat", "=", 
   RowBox[{"d4", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "5", "]"}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["kz", "2"]}], "-", 
      SuperscriptBox["kx", "2"], "-", 
      SuperscriptBox["ky", "2"]}], "2"]}]}], ";", 
  RowBox[{"d5hat", "=", 
   RowBox[{"d5", "/", 
    SuperscriptBox["k", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ham2", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "[", "i", "]"}], 
      RowBox[{"\[Gamma]", "[", "i", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "ham2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", "ham2", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6312382022915897`*^9, 3.631238225759459*^9}, {
   3.6312382600929537`*^9, 3.6312384017277803`*^9}, {3.631238501848529*^9, 
   3.631238514655388*^9}, {3.631238557337954*^9, 3.631238582703508*^9}, {
   3.631238697418057*^9, 3.6312387608920393`*^9}, {3.631238821822587*^9, 
   3.6312388336171837`*^9}, {3.6312388682255707`*^9, 3.63123894870654*^9}, 
   3.631241459271804*^9, 3.6312415058351183`*^9, {3.631242162714487*^9, 
   3.631242164860416*^9}, {3.631243821329649*^9, 3.6312438323099318`*^9}, {
   3.631243931067396*^9, 3.631243943321344*^9}, {3.631245485411551*^9, 
   3.631245507064893*^9}, {3.631245606183861*^9, 3.631245636233708*^9}, {
   3.631246369852314*^9, 3.631246410769082*^9}, {3.63124927017979*^9, 
   3.63124930420273*^9}, {3.631249422231785*^9, 3.631249432782104*^9}, {
   3.631249677286726*^9, 3.631249702711062*^9}, {3.631285101024441*^9, 
   3.631285106140984*^9}, {3.631285140088323*^9, 3.6312852358940573`*^9}, 
   3.631287438641325*^9, {3.631295671787744*^9, 3.631295675200363*^9}, {
   3.631296743735948*^9, 3.631296768464766*^9}, {3.631303956396132*^9, 
   3.6313039785131187`*^9}, {3.631363753884413*^9, 3.63136377298313*^9}, 
   3.631414086575067*^9, {3.631551950532612*^9, 3.631551957383226*^9}, 
   3.6315519991082993`*^9, {3.711821084066185*^9, 3.7118211139118958`*^9}, {
   3.711821392685665*^9, 3.71182150933855*^9}, {3.711821576479093*^9, 
   3.711821735961163*^9}, {3.7118217742380238`*^9, 3.711821848019948*^9}, {
   3.7118243385720043`*^9, 3.7118243649817753`*^9}, 3.793277445616826*^9, {
   3.794826944606303*^9, 3.794826969612651*^9}, {3.7948270440250483`*^9, 
   3.794827071360015*^9}, {3.795345678473947*^9, 3.795345684714752*^9}, {
   3.828232944156448*^9, 3.8282330756215267`*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"3f3953c2-eb6f-40c5-898f-a8a76873a10c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "kz"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], "0"},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["3"]}], " ", "kx", " ", "kz"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["kx", "2"]}], "-", 
         SuperscriptBox["ky", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "kz"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "ky", " ", "kz"}]}]},
     {"0", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["3"], " ", "kx", " ", "ky"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "-", 
          SuperscriptBox["ky", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        SqrtBox["3"], " ", "kx", " ", "kz"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"], " ", "ky", " ", "kz"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["kz", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.828233010368915*^9, 3.828233027207841*^9}, {
  3.828233062287162*^9, 3.828233075891342*^9}},
 CellLabel->
  "Out[129]//MatrixForm=",ExpressionUUID->"0abd5496-ea1e-493d-ac66-\
ce5fba4b32d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["kx", "2"]}], "-", 
      SuperscriptBox["ky", "2"], "-", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}], ",", 
     RowBox[{
      SuperscriptBox["kx", "2"], "+", 
      SuperscriptBox["ky", "2"], "+", 
      SuperscriptBox["kz", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "0", ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], " ", 
           SuperscriptBox["kx", "2"]}], "-", 
          RowBox[{
           SqrtBox["3"], " ", 
           SuperscriptBox["ky", "2"]}], "-", 
          RowBox[{"4", " ", 
           SqrtBox["3"], " ", 
           SuperscriptBox["kz", "2"]}]}], 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"kx", "+", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
       FractionBox[
        RowBox[{"2", " ", "kz"}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", "0"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["kz", "2"]}]}], 
         RowBox[{
          SqrtBox["3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"kx", "+", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
       "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}], 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", 
       FractionBox[
        RowBox[{"2", " ", "kz"}], 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.828233010368915*^9, 3.828233027207841*^9}, {
  3.828233062287162*^9, 3.828233075939398*^9}},
 CellLabel->
  "Out[130]=",ExpressionUUID->"35cb4727-0895-47e9-9c44-cfc9d1651e3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ham", "\[Equal]", "ham2"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.828233082189269*^9, 3.8282330888180923`*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"a637685f-9306-43be-95aa-df861e4db6f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["kx", "2"]}], "-", 
       SuperscriptBox["ky", "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          SuperscriptBox["kx", "2"]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky", " ", 
          RowBox[{"(", 
           RowBox[{"ky", "-", 
            RowBox[{"2", " ", "kz"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "kx", " ", 
          RowBox[{"(", 
           RowBox[{"ky", "+", "kz"}], ")"}]}]}], ")"}]}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
          " ", "kz"}]}], ")"}]}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"kx", "-", 
             RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", "kz"}]}], 
        ")"}]}], ",", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}], ",", "0", ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
          " ", "kz"}]}], ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
          "kz"}]}], ")"}]}], ",", "0", ",", 
      RowBox[{
       SuperscriptBox["kx", "2"], "+", 
       SuperscriptBox["ky", "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
          "kz"}]}], ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "+", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "kx"}], "+", "ky"}], ")"}], " ", 
          "kz"}]}], ")"}]}], ",", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"kx", "-", 
            RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "kx"}], "+", "ky"}], ")"}], 
          " ", "kz"}]}], ")"}]}], ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["kx", "2"]}], "-", 
       SuperscriptBox["ky", "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["kz", "2"]}]}]}], "}"}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]], "Output",\

 CellChangeTimes->{{3.828233084456958*^9, 3.8282330893587723`*^9}},
 CellLabel->
  "Out[149]=",ExpressionUUID->"b69ed33b-2f89-46dd-8726-966f9cc64bea"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"exp1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "kz"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["kx", "2"], "+", 
         SuperscriptBox["ky", "2"], "+", 
         SuperscriptBox["kz", "2"]}]]}], 
      RowBox[{"kx", "+", 
       RowBox[{"\[ImaginaryI]", " ", "ky"}]}]], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp2", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"kz", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          SuperscriptBox["kz", "2"]}]]}], 
       RowBox[{"kx", "+", 
        RowBox[{"\[ImaginaryI]", " ", "ky"}]}]]}], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "+", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"kx", "+", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"kz", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]]}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "-", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{"kz", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp4", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kx", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "kz"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["kx", "2"], "+", 
           SuperscriptBox["ky", "2"], "+", 
           SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"kx", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "kz"}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["kx", "2"], "+", 
            SuperscriptBox["ky", "2"], "+", 
            SuperscriptBox["kz", "2"]}]]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"(", 
         RowBox[{"kx", "-", 
          RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["kx", "2"], "+", 
          SuperscriptBox["ky", "2"], "+", 
          RowBox[{"2", " ", "kz", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "kz"}], "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["kx", "2"], "+", 
               SuperscriptBox["ky", "2"], "+", 
               SuperscriptBox["kz", "2"]}]]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"kx", "-", 
           RowBox[{"\[ImaginaryI]", " ", "ky"}]}], ")"}], "2"]}]]}], ",", 
     "1"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"ade7e2c6-a987-4405-9c13-a430c45bb02f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"try", "=", 
   RowBox[{"ham", ".", "exp1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox["try", 
    RowBox[{
     SuperscriptBox["kx", "2"], "+", 
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}]], "\[Equal]", "exp1"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"try", "=", 
   RowBox[{"ham", ".", "exp2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox["try", 
    RowBox[{
     SuperscriptBox["kx", "2"], "+", 
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}]], "\[Equal]", "exp2"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"try", "=", 
   RowBox[{"ham", ".", "exp3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"-", "try"}], 
    RowBox[{
     SuperscriptBox["kx", "2"], "+", 
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}]], "\[Equal]", "exp3"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"try", "=", 
   RowBox[{"ham", ".", "exp4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"-", "try"}], 
    RowBox[{
     SuperscriptBox["kx", "2"], "+", 
     SuperscriptBox["ky", "2"], "+", 
     SuperscriptBox["kz", "2"]}]], "\[Equal]", "exp4"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.828233231061977*^9, 3.82823336035249*^9}, {
  3.828236456049576*^9, 3.8282365172167063`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"188b3c48-9900-4644-b47e-e813d0bf5563"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.82823323586586*^9, 3.828233361043852*^9}, {
   3.828236459046924*^9, 3.828236484057358*^9}, 3.828236517663629*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"85739d58-c45b-4e8b-9cc9-f316ed850082"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.82823323586586*^9, 3.828233361043852*^9}, {
   3.828236459046924*^9, 3.828236484057358*^9}, 3.8282365176652937`*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"d71f99fa-fc32-47ce-aec2-662469ba1a02"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.82823323586586*^9, 3.828233361043852*^9}, {
   3.828236459046924*^9, 3.828236484057358*^9}, 3.828236517699149*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"ee9dcdd1-44fe-4d6f-a2a2-4979bc246521"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.82823323586586*^9, 3.828233361043852*^9}, {
   3.828236459046924*^9, 3.828236484057358*^9}, 3.828236517740782*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"257dc713-5fdf-44b8-b7de-81aed18c4d9c"]
}, Open  ]],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 4},ExpressionUUID->"620fecbc-17ae-4729-a285-b91d53ac4d92"]
},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (January 26, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"568cca61-d5ed-4c4b-b4ae-d12d338b87f4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 8238, 220, 540, "Input",ExpressionUUID->"53ae6267-8c75-4418-bf17-47dc27885083"],
Cell[8821, 244, 3850, 120, 130, "Output",ExpressionUUID->"83c7301b-5610-4c28-a7d9-2168c0b8cfb5"],
Cell[12674, 366, 3941, 119, 145, "Output",ExpressionUUID->"c64a3e7e-149c-474a-a89f-772970701561"]
}, Open  ]],
Cell[16630, 488, 329, 10, 8, "Text",ExpressionUUID->"81cada91-34c7-44db-a261-0e079d4291e6"],
Cell[CellGroupData[{
Cell[16984, 502, 8359, 226, 540, "Input",ExpressionUUID->"3f3953c2-eb6f-40c5-898f-a8a76873a10c"],
Cell[25346, 730, 3826, 120, 130, "Output",ExpressionUUID->"0abd5496-ea1e-493d-ac66-ce5fba4b32d6"],
Cell[29175, 852, 3660, 114, 139, "Output",ExpressionUUID->"35cb4727-0895-47e9-9c44-cfc9d1651e3e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32872, 971, 247, 5, 30, "Input",ExpressionUUID->"a637685f-9306-43be-95aa-df861e4db6f9"],
Cell[33122, 978, 5368, 165, 215, "Output",ExpressionUUID->"b69ed33b-2f89-46dd-8726-966f9cc64bea"]
}, Open  ]],
Cell[38505, 1146, 7025, 222, 506, "Input",ExpressionUUID->"ade7e2c6-a987-4405-9c13-a430c45bb02f"],
Cell[CellGroupData[{
Cell[45555, 1372, 1596, 49, 276, "Input",ExpressionUUID->"188b3c48-9900-4644-b47e-e813d0bf5563"],
Cell[47154, 1423, 247, 3, 34, "Output",ExpressionUUID->"85739d58-c45b-4e8b-9cc9-f316ed850082"],
Cell[47404, 1428, 249, 3, 34, "Output",ExpressionUUID->"d71f99fa-fc32-47ce-aec2-662469ba1a02"],
Cell[47656, 1433, 247, 3, 34, "Output",ExpressionUUID->"ee9dcdd1-44fe-4d6f-a2a2-4979bc246521"],
Cell[47906, 1438, 247, 3, 34, "Output",ExpressionUUID->"257dc713-5fdf-44b8-b7de-81aed18c4d9c"]
}, Open  ]],
Cell[48168, 1444, 329, 10, 8, "Text",ExpressionUUID->"620fecbc-17ae-4729-a285-b91d53ac4d92"]
}
]
*)

