(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     28046,        841]
NotebookOptionsPosition[     19837,        684]
NotebookOutlinePosition[     21716,        727]
CellTagsIndexPosition[     21673,        724]
WindowTitle->EOSPotassium
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM GUIDE", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "Related Guides",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }]],
         TextCell[
          Row[{"Related Guides", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassiumFunctions\"\>":>
       Documentation`HelpLookup[
        If[
         StringMatchQ[
          StringReplace[{
            FrontEnd`FileName[{
              ParentDirectory[], "ReferencePages", "Symbols"}, 
             "EOSPotassiumFunctions.nb", CharacterEncoding -> "UTF-8"], None},
            "paclet:" :> ""], "paclet*"], 
         Part[
          Part[{{"EOSPotassiumFunctions", 
             StringReplace[{
               FrontEnd`FileName[{
                 ParentDirectory[], "ReferencePages", "Symbols"}, 
                "EOSPotassiumFunctions.nb", CharacterEncoding -> "UTF-8"], 
               None}, "paclet:" :> ""]}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"EOSPotassiumFunctions", 
              StringReplace[{
                FrontEnd`FileName[{
                  ParentDirectory[], "ReferencePages", "Symbols"}, 
                 "EOSPotassiumFunctions.nb", CharacterEncoding -> "UTF-8"], 
                None}, "paclet:" :> ""]}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"GuideMoreAbout"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }]],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/guide/EOSPotassium\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/guide/EOSPotassium"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/guide/\
EOSPotassium.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$7103], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/guide/EOSPotassium", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["EOSPotassium", "GuideTitle",
 CellID->942062912],

Cell["\<\
Equations of State of the Dynamic Viscosity and Self-Diffusion Coefficient \
for the gaseous phase of Potassium and along the atmospheric isobar in the \
liquid phase. In addition, the program allows the calculation of various \
thermodynamic equations of state such as density or pressure along the \
saturated vapor pressure curve and along the atmospheric isobar in the liquid \
phase.\
\>", "GuideAbstract",
 CellID->273739838],

Cell[TextData[{
 StyleBox["Most of the equations of state are functions of T and \[Rho] such \
that T must be in Kelvin and \[Rho] in g/",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "."
}], "GuideAbstract",
 CellID->824002956],

Cell["Code for loading the package", "ExampleText",
 CellID->71887481],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->496469109]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]]],
 "Reference"
}], "GuideReferenceSection",
 WholeCellGroupOpener->True],

Cell["", "SectionHeaderSpacer"],

Cell[CellGroupData[{

Cell["Characteristic parameters of potassium", "GuideFunctionsSubsection",
 CellID->69685069],

Cell[TextData[{
 Cell[TextData[ButtonBox["MK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "MK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Molar mass"
}], "GuideText",
 CellID->529256898],

Cell[TextData[{
 Cell[TextData[ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "TmpK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Melting point temperature at atmospheric pressure"
}], "GuideText",
 CellID->587190265],

Cell[TextData[{
 Cell[TextData[ButtonBox["TcK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "TcK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Critical point temperature"
}], "GuideText",
 CellID->32048059],

Cell[TextData[{
 Cell[TextData[ButtonBox["rhocK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "rhocK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Critical point density"
}], "GuideText",
 CellID->646576807],

Cell[TextData[{
 Cell[TextData[ButtonBox["PcK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "PcK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Critical point pressure"
}], "GuideText",
 CellID->343715793],

Cell[TextData[{
 Cell[TextData[ButtonBox["K0K",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "K0K.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Characteristic elastic constant value"
}], "GuideText",
 CellID->310303647]
}, Open  ]],

Cell["\t", "GuideDelimiterSubsection",
 CellID->160652093],

Cell[CellGroupData[{

Cell["Thermodynamic equations of state", "GuideFunctionsSubsection",
 CellID->270013522],

Cell[TextData[{
 Cell[TextData[ButtonBox["PsatK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "PsatK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Pressure of potassium along the coexistence curve ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox[
    SubscriptBox["P", "\[Sigma]"],
    FontSlant->"Italic"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->60053704],

Cell[TextData[{
 Cell[TextData[ButtonBox["RhoSatVapK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "RhoSatVapK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Density of potassium along the vapor coexistence curve"
}], "GuideText",
 CellID->485256157],

Cell[TextData[{
 Cell[TextData[ButtonBox["RhoSatLiqK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "RhoSatLiqK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Density of potassium along the liquid coexistence curve"
}], "GuideText",
 CellID->47824222],

Cell[TextData[{
 Cell[TextData[ButtonBox["LvK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "LvK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Latent of heat of vaporisation of potassium"
}], "GuideText",
 CellID->68823102],

Cell[TextData[{
 Cell[TextData[ButtonBox["zK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "zK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Compressibility factor of gaseous potassium "
}], "GuideText",
 CellID->46374622],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rho1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "Rho1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Density of potassium  along the atmospheric isobar in the liquid phase"
}], "GuideText",
 CellID->105694700]
}, Open  ]],

Cell["\t", "GuideDelimiterSubsection",
 CellID->571687710],

Cell[CellGroupData[{

Cell["Equilibrium properties", "GuideFunctionsSubsection",
 CellID->18075572],

Cell[TextData[{
 Cell[TextData[ButtonBox["qc0K",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "qc0K.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Characteristic cut-off wave-vector modulus (",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q",
    FontSlant->"Italic"], "c0"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->353891389],

Cell[TextData[{
 Cell[TextData[ButtonBox["TtransVapK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "TtransVapK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Transition temperature ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox[
    SubscriptBox["T", "t"],
    FontSlant->"Italic"]}]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->262485370],

Cell[TextData[{
 Cell[TextData[ButtonBox["NdNtcVapK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "NdNtcVapK.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Reduced coherence length (",
 StyleBox["N)",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->97224393],

Cell[TextData[{
 Cell[TextData[ButtonBox["fqc",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "fqc.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Non-dimensional function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula"],
 " which represents the excess variations of the cut-off wave-vector modulus ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q",
    FontSlant->"Italic"], "c0"]], "InlineFormula"],
 " for gaseous potassium only"
}], "GuideText",
 CellID->109825607],

Cell[TextData[{
 Cell[TextData[ButtonBox["fqc1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "fqc1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Non-dimensional function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula"],
 " which represents the excess variations of the cut-off wave-vector modulus ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q",
    FontSlant->"Italic"], "c0"]], "InlineFormula"],
 " along the atmospheric isobar in the liquid phase"
}], "GuideText",
 CellID->185379098]
}, Open  ]],

Cell["\t", "GuideDelimiterSubsection",
 CellID->517675917],

Cell[CellGroupData[{

Cell["\<\
Potassium viscosity equations of state along the atmospheric isobar in the \
liquid phase\
\>", "GuideFunctionsSubsection",
 CellID->186643139],

Cell[TextData[{
 Cell[TextData[ButtonBox["etalK1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etalK1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity ",
 StyleBox["liquid",
  FontVariations->{"Underline"->True}],
 " term (",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->221262627],

Cell[TextData[{
 Cell[TextData[ButtonBox["etaKnuK1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etaKnuK1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity ",
 StyleBox["Knudsen",
  FontVariations->{"Underline"->True}],
 " term (",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "Knu"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->96803951],

Cell[TextData[{
 Cell[TextData[ButtonBox["etaK1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etaK1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity equation of state (\[Eta])"
}], "GuideText",
 CellID->1122292]
}, Open  ]],

Cell["\t", "GuideDelimiterSubsection",
 CellID->397009857],

Cell[CellGroupData[{

Cell["\<\
Potassium viscosity equations of state for the gaseous phase only\
\>", "GuideFunctionsSubsection",
 CellID->96111611],

Cell[TextData[{
 Cell[TextData[ButtonBox["etalKVap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etalKVap.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity ",
 StyleBox["liquid",
  FontVariations->{"Underline"->True}],
 " term (",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->638983552],

Cell[TextData[{
 Cell[TextData[ButtonBox["etaKnuKVap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etaKnuKVap.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity ",
 StyleBox["Knudsen",
  FontVariations->{"Underline"->True}],
 " term (",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "Knu"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->480802739],

Cell[TextData[{
 Cell[TextData[ButtonBox["etaKVap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "etaKVap.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Viscosity equation of state (\[Eta])"
}], "GuideText",
 CellID->68993859]
}, Open  ]],

Cell["\t", "GuideDelimiterSubsection",
 CellID->3829839],

Cell[CellGroupData[{

Cell["Potassium self-diffusion coefficient equations of state", \
"GuideFunctionsSubsection",
 CellID->52843913],

Cell[TextData[{
 Cell[TextData[ButtonBox["DtK1atm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "DtK1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " self-diffusion coefficient (",
 Cell[BoxData[
  SubscriptBox["D", "t"]], "InlineFormula",
  FontSlant->"Italic"],
 ") along the atmospheric isobar in the liquid phase"
}], "GuideText",
 CellID->167266833],

Cell[TextData[{
 Cell[TextData[ButtonBox["DtKVap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "DtKVap.nb", 
     CharacterEncoding -> "UTF-8"], None}]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " self-diffusion coefficient (",
 Cell[BoxData[
  SubscriptBox["D", "t"]], "InlineFormula",
  FontSlant->"Italic"],
 ") for the gaseous phase only"
}], "GuideText",
 CellID->397100528]
}, Open  ]],

Cell[CellGroupData[{

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 ButtonBox["u2lVap",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "u2lVap.nb", 
     CharacterEncoding -> "UTF-8"], None}],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["RhoKnuVap ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "RhoKnuVap.nb", 
     CharacterEncoding -> "UTF-8"], None}],
 ". ",
 ButtonBox["RhoKnu1atm ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    FrontEnd`FileName[{
      ParentDirectory[], "ReferencePages", "Symbols"}, "RhoKnu1atm.nb", 
     CharacterEncoding -> "UTF-8"], None}],
 "."
}], "InlineGuideFunctionListing",
 CellID->423003460]
}, Open  ]],

Cell["", "SectionFooterSpacer"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]]],
 "Related Guides"
}], "GuideMoreAboutSection",
 WholeCellGroupOpener->True,
 CellID->23220180],

Cell["", "SectionHeaderSpacer"],

Cell[TextData[ButtonBox["EOSPotassiumFunctions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   FrontEnd`FileName[{
     ParentDirectory[], "ReferencePages", "Symbols"}, 
    "EOSPotassiumFunctions.nb", CharacterEncoding -> "UTF-8"], 
   None}]], "GuideMoreAbout",
 CellID->208356608]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EOSPotassium",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "GuideColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "Wolfram Language", ButtonData -> "paclet:guide/WolframRoot", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "ExampleCounter" -> 1, "NeedPlatMsgIn" -> None, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 7.3272992}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Guide", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Equations of State of the Dynamic Viscosity and Self-Diffusion \
Coefficient for the gaseous phase of Potassium and along the atmospheric \
isobar in the liquid phase. In addition, the program allows the calculation \
of various thermodynamic equations of state such as density or pressure along \
the saturated vapor pressure curve and along the atmospheric isobar in the \
liquid phase.", "synonyms" -> {}, "tabletags" -> 
    DocumentationBuild`Make`Private`tabletaggingrules$6954, "title" -> 
    "EOSPotassium", "titlemodifier" -> "", "windowtitle" -> "EOSPotassium", 
    "type" -> "Guide", "uri" -> "EOSPotassium/guide/EOSPotassium"}},
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 3998, 96, 70, "AnchorBarGrid",ExpressionUUID->"1faa692e-5630-43ca-b297-3741506a1618",
 CellID->1],
Cell[CellGroupData[{
Cell[4607, 121, 54, 1, 70, "GuideTitle",ExpressionUUID->"5d97596f-2a3c-4f66-884d-53ad0452a962",
 CellID->942062912],
Cell[4664, 124, 441, 8, 70, "GuideAbstract",ExpressionUUID->"6009b8c6-102f-42d8-9cbe-faf6f9ce1992",
 CellID->273739838],
Cell[5108, 134, 338, 11, 70, "GuideAbstract",ExpressionUUID->"0053b631-1ed4-4250-afeb-43c950ef3fb1",
 CellID->824002956],
Cell[5449, 147, 70, 1, 70, "ExampleText",ExpressionUUID->"c39c5cda-cd2a-447d-a0ff-4d87a028ee31",
 CellID->71887481],
Cell[5522, 150, 121, 3, 70, "Input",ExpressionUUID->"621ebe09-c0ae-4048-855c-f27a05687db3",
 CellID->496469109]
}, Open  ]],
Cell[CellGroupData[{
Cell[5680, 158, 137, 6, 70, "GuideReferenceSection",ExpressionUUID->"87976443-1665-4bae-b6ff-8502eee8fbac"],
Cell[5820, 166, 31, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"6c1d0e6e-6d6f-443a-8f0c-2f40e70482d4"],
Cell[CellGroupData[{
Cell[5876, 170, 93, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"8b9e5904-ef5f-40fc-afec-faed0e66f971",
 CellID->69685069],
Cell[5972, 173, 344, 11, 70, "GuideText",ExpressionUUID->"694122fd-0b90-4458-87ab-565137ac1f46",
 CellID->529256898],
Cell[6319, 186, 387, 11, 70, "GuideText",ExpressionUUID->"1008599a-302b-4950-b179-033086722894",
 CellID->587190265],
Cell[6709, 199, 361, 11, 70, "GuideText",ExpressionUUID->"2d4f3878-653d-4656-9ab5-0ef946876c3d",
 CellID->32048059],
Cell[7073, 212, 362, 11, 70, "GuideText",ExpressionUUID->"89b6811b-4286-49db-9d66-b45d53a299f5",
 CellID->646576807],
Cell[7438, 225, 359, 11, 70, "GuideText",ExpressionUUID->"b6cda6a3-4fea-446b-8cc7-498a208e259b",
 CellID->343715793],
Cell[7800, 238, 373, 11, 70, "GuideText",ExpressionUUID->"0700d685-4309-4648-a620-b7fc9c871a08",
 CellID->310303647]
}, Open  ]],
Cell[8188, 252, 58, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"75219797-f3c6-4260-9f98-523587fc6cf4",
 CellID->160652093],
Cell[CellGroupData[{
Cell[8271, 257, 88, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"c034d132-7499-4579-b5cf-346e76398d0b",
 CellID->270013522],
Cell[8362, 260, 521, 17, 70, "GuideText",ExpressionUUID->"d12f8f4d-1f4c-49a1-9385-e2010afb54d2",
 CellID->60053704],
Cell[8886, 279, 404, 11, 70, "GuideText",ExpressionUUID->"0f1df678-edd1-43cb-a24f-2356710e3bbd",
 CellID->485256157],
Cell[9293, 292, 404, 11, 70, "GuideText",ExpressionUUID->"a53074fc-b96d-4d3f-8af1-583a8efc3ba1",
 CellID->47824222],
Cell[9700, 305, 378, 11, 70, "GuideText",ExpressionUUID->"c2fa5195-378d-424c-9bc4-c8fc24cbcba4",
 CellID->68823102],
Cell[10081, 318, 377, 11, 70, "GuideText",ExpressionUUID->"cefc86de-addd-4617-9dbe-1e61c8edab3b",
 CellID->46374622],
Cell[10461, 331, 414, 11, 70, "GuideText",ExpressionUUID->"b487755f-dcb4-4e13-9c9e-a58c0e22781f",
 CellID->105694700]
}, Open  ]],
Cell[10890, 345, 58, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"e515177d-b1db-41e1-9b31-773f5b1dc0f2",
 CellID->571687710],
Cell[CellGroupData[{
Cell[10973, 350, 77, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"910b825e-ce7e-4368-a60f-da9ffef9e4c3",
 CellID->18075572],
Cell[11053, 353, 488, 16, 70, "GuideText",ExpressionUUID->"51c741d7-5227-448b-8125-fdda8c8c95ed",
 CellID->353891389],
Cell[11544, 371, 498, 17, 70, "GuideText",ExpressionUUID->"9d3531c8-7153-400d-9442-7e00590d5cd1",
 CellID->262485370],
Cell[12045, 390, 413, 13, 70, "GuideText",ExpressionUUID->"def39d6f-7c1b-4341-a88b-d0dd5f8390c6",
 CellID->97224393],
Cell[12461, 405, 695, 22, 70, "GuideText",ExpressionUUID->"c9054040-e199-4eb7-954f-f6d8032b926f",
 CellID->109825607],
Cell[13159, 429, 725, 22, 70, "GuideText",ExpressionUUID->"43d8bbae-9236-4e86-b415-f74c5e07a6a5",
 CellID->185379098]
}, Open  ]],
Cell[13899, 454, 58, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"33eb3bb2-5c00-4a01-95f4-51b3a56963e9",
 CellID->517675917],
Cell[CellGroupData[{
Cell[13982, 459, 153, 4, 70, "GuideFunctionsSubsection",ExpressionUUID->"d0baea53-580c-495b-be09-1cab97c14c21",
 CellID->186643139],
Cell[14138, 465, 501, 17, 70, "GuideText",ExpressionUUID->"ed6a1665-fa96-43ff-a4aa-f32e0e0d6622",
 CellID->221262627],
Cell[14642, 484, 507, 17, 70, "GuideText",ExpressionUUID->"dee1b352-04bd-4a2a-951f-7f17c6b69880",
 CellID->96803951],
Cell[15152, 503, 380, 11, 70, "GuideText",ExpressionUUID->"19a33bf4-9c02-44e3-b8e1-03653ec136eb",
 CellID->1122292]
}, Open  ]],
Cell[15547, 517, 58, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"d97fdd42-fb46-4451-90de-f17695239cbd",
 CellID->397009857],
Cell[CellGroupData[{
Cell[15630, 522, 128, 3, 70, "GuideFunctionsSubsection",ExpressionUUID->"537fc212-c1eb-4091-95a9-a7ce693f54b9",
 CellID->96111611],
Cell[15761, 527, 499, 17, 70, "GuideText",ExpressionUUID->"dbd6189f-4a10-45a9-8f9a-04934b2cf303",
 CellID->638983552],
Cell[16263, 546, 506, 17, 70, "GuideText",ExpressionUUID->"5393eada-b01b-4e1f-a5c1-86bd95b12953",
 CellID->480802739],
Cell[16772, 565, 379, 11, 70, "GuideText",ExpressionUUID->"e3c0ffe3-53a7-44c8-9b69-d773c15a9e7c",
 CellID->68993859]
}, Open  ]],
Cell[17166, 579, 56, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"0313a9ea-71b2-4c04-bd29-8a8892192435",
 CellID->3829839],
Cell[CellGroupData[{
Cell[17247, 584, 112, 2, 70, "GuideFunctionsSubsection",ExpressionUUID->"35360c7d-27cb-4230-957c-b861abb03d00",
 CellID->52843913],
Cell[17362, 588, 510, 15, 70, "GuideText",ExpressionUUID->"6c9be1eb-64c7-478f-8d61-e687a6be01b2",
 CellID->167266833],
Cell[17875, 605, 486, 15, 70, "GuideText",ExpressionUUID->"29accf10-0d17-4c92-981b-36f58f0dc7f9",
 CellID->397100528]
}, Open  ]],
Cell[CellGroupData[{
Cell[18398, 625, 48, 1, 70, "GuideDelimiter",ExpressionUUID->"f5e20a2d-2bd3-4766-8563-1b1a212399da",
 CellID->311258892],
Cell[18449, 628, 785, 25, 70, "InlineGuideFunctionListing",ExpressionUUID->"78fd8e40-8bbc-4190-b862-d911e5d9cbb0",
 CellID->423003460]
}, Open  ]],
Cell[19249, 656, 31, 0, 70, "SectionFooterSpacer",ExpressionUUID->"fb2eec85-29da-48da-ab2f-8d6407f933c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19317, 661, 161, 7, 70, "GuideMoreAboutSection",ExpressionUUID->"ccd25841-05f3-4a39-a47d-ee048244ba9e",
 CellID->23220180],
Cell[19481, 670, 31, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"f0b927cd-0396-43bf-91a4-6c63b1958161"],
Cell[19515, 672, 280, 7, 70, "GuideMoreAbout",ExpressionUUID->"818a1eb5-a8c3-4e8b-a02a-deaada2127e4",
 CellID->208356608]
}, Open  ]],
Cell[19810, 682, 23, 0, 70, "FooterCell",ExpressionUUID->"20ab8130-dada-4202-aec7-f239963b3c27"]
}
]
*)

(* End of internal cache information *)
