(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52103,       1181]
NotebookOptionsPosition[     46681,       1059]
NotebookOutlinePosition[     49089,       1120]
CellTagsIndexPosition[     49003,       1115]
WindowTitle->CoefK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "ccc4bd28-0167-4b5a-996f-c0e598a98e8e"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"8f5e7e4f-4ddf-457e-9d93-b97dfeaf8807"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"K0K\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"K0K.nb", None}, "paclet*"], 
         Part[
          Part[{{"K0K", {"K0K.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"K0K", {"K0K.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b97d7fa6-e0b5-4966-a24e-5f91eadd7fcb"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"4f1bd0d6-d8ba-463b-bc78-cd202a7cd30f"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/CoefK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/CoefK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/CoefK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$16800], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/CoefK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "2239d4b9-e084-4789-a895-8e4a6093ce91"]
    }], "AnchorBar",ExpressionUUID->"5c811c8e-d8d5-4f60-8c1b-32fea2eb5bce"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"fc498aed-4c91-4e3c-aca6-6048c75518fd"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["CoefK", "ObjectName",ExpressionUUID->
  "f5814aae-a06e-48a2-8cfb-2d4286c3eea4"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"129185cb-3eec-4861-8e0d-94eeb5cad05c"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "f94f9cff-4bdc-4cd4-aa0c-46a7a5530d52"]
}], "ObjectNameGrid",ExpressionUUID->"2afff4c3-011b-4d45-a226-073c1afdcf85"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
     "CoefK"], "InlineFormula",ExpressionUUID->
      "2f29fac3-0c12-435b-bcb0-4feaf0177868"],
     " \[LineSeparator]CoefK is an option for ",
     ButtonBox["TtransVapK",
      BaseStyle->"Hyperlink",
      ButtonData->{"TtransVapK.nb", None}],
     ", ",
     ButtonBox["etalK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalK1atm.nb", None}],
     ", ",
     ButtonBox["etaK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaK1atm.nb", None}],
     ", ",
     ButtonBox["DtK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     ", ",
     ButtonBox["etalKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalKVap.nb", None}],
     ",  ",
     ButtonBox["etaKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaKVap.nb", None}],
     ", ",
     ButtonBox["DtKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     " and ",
     ButtonBox["u2lVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"u2lVap.nb", None}],
     " functions that allows the elastic parameter ",
     StyleBox["K",
      FontSlant->"Italic"],
     " to be multiplied by a numeric constant. "
    }],ExpressionUUID->"46027888-9580-49f3-b044-a5fa21e1b4be"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"45249a91-2c6c-4536-a95a-92955f793b19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"f2c3668b-89ff-4925-8335-172f3b6b0672"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"2dce1bac-9cd3-44bf-8124-bda406a94c8b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"25900c04-d3de-41de-a949-0c02a7e22210"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->147267105,ExpressionUUID->"e7a971eb-be25-42f1-bacb-2cc1e797ba56"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"f6195140-d4ba-4710-aba4-ca2c3e296255"],

Cell["By default CoefK = 1", "Notes",
 CellID->396847190,ExpressionUUID->"21d0c288-f234-4999-b8f6-08d5627e5135"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"223c9842-3a9d-4b81-97c2-e58cc519ef2d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "11b63904-9091-43d7-a746-0ed3f9e70562"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->671483843,ExpressionUUID->"675869ef-8b28-4201-b95a-a71da80be020"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8c1fb935-937d-48cf-a61b-74baa883e30c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->13613904,ExpressionUUID->"a2cbaac2-4615-407f-9eaa-011fdd2ed5dc"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"045c3149-bc5d-4149-8a50-8441d059bf2c"],

Cell[TextData[{
 "Increasing ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is equivalent to increasing cohesion and therefore viscosity as shown in \
the example below"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"88e5ddf5-750e-4e41-9090-de52615b4069"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaK1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"TmpK", ",", 
   RowBox[{"CoefK", "->", "1.21108"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->614342864,ExpressionUUID->"7fcf76b1-7f98-4f74-9124-a38bd1b1beb7"],

Cell[BoxData["0.5389191503225945`"], "Output",
 CellLabel->"Out[2]=",
 CellID->116617506,ExpressionUUID->"66838cb7-5084-4391-b741-314a5829ddc5"],

Cell[BoxData["0.565566169057726`"], "Output",
 CellLabel->"Out[2]=",
 CellID->429221721,ExpressionUUID->"4e8cd3a7-a667-4735-9aba-9a090a1b8107"]
}, Open  ]],

Cell["\<\
Plot of the the self-diffusion coefficient from the melting point to the \
boiling point along the atmospheric isobar for two different values of the \
CoefK\
\>", "ExampleText",
 CellID->168920797,ExpressionUUID->"49a1f7e5-49ab-4714-b65e-97160b5c1f71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
     RowBox[{"DtK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"CoefK", "->", "1.21108"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CoefK = 1\>\"", ",", "\"\<CoefK = 1.21108\>\""}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->562653754,ExpressionUUID->"fa63f89a-7b49-40b9-b835-8b823cd8482b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVyX0w1AkYwHHhbCxtrtjNS3qh0tW5dCTn7nm8XpGSlt1C4bLUelmylkWs
ZVl+a3/jZpqGIvJWtHtScXTnpebUEQq9KSO57coqx6i9wbruj+98/vhujEwI
jNLV0dHx/9z/brR053OM+DhfteRpwmBC1R8VKf0mfCzRVWqqNjDBNkkrcDbl
4/cmD2b22jNh2/12oQGDjzdS265yXZnwtcA5u9aOj6VZbPexUCa4Dn1VpEI+
enaeer5cyQRmkXklR8BHd8X1gd07g0CyMNXHmeRjQLrCjf1jMIRVBvN+G0zB
+1XgZ3CbDRfVqQ2nrwlQHD9FH7AMgfKSoLY7ealozs6nOIjDwFT7z9ozvDRs
O9oeybMIh+lVPpQ0PyHW9hzcNMOJgO/+Ouo94pKOjPP0cwGjkeBnvo31cmMG
6rW+eVkWdBLuqq/puC1kYJaH44cT3VGgLJibn1Fl4k0KkyBCokHvz5mcxe6z
eH1lO31JFQMMTv3r5tIsXNfkNzguOA2Dr2n3wj2yMXaM8GS5xsK+6K3vSpTZ
OOxKt+mfjoO0B+sdZ+xEGFhckTD7OAGoEXM/bS4VYa3xnFH6JA8O91x+JTLI
QRuxJvnRcCIErP42j5qRg3W2n1hJE0mgv+NScufbHFxwP9AgVp2BxO1q6aVw
MbpyFZoIQz5AsJk0eESMQ6KgxSmHFOhiWgzv8cjFrNGumjhfASw6LXt5teYi
tVLq25GbCuq3HSsytuQhqejf5duUBm69YfXSkjycOW6joo0JwVs+mtxNkaB+
KfXX89szQG+Lk2wLX4ITurtHbTmZIKyI7705JcGl9TWp9K6zEOiTN2cRno9v
aOkTGuNsGOsQRDf05aPy8ooItjIbNlv5roj2KECLau1QR7gIrP00Kv9fCrB2
og49KTkgqBPfMrKS4v0Bs5JVDTlQqHrfMEtK0c/fe9IqTAyBGqfpL7RSVDx4
47BPLxeG1KFMr+RC7Hia9GRXSy4Y3jhBUUwUogHXfb77eB5U1EP19MEiLPmh
bi9fVwLvs5Y57LtFaLDSc9GhWQKz9mX897sI7Bkq2+/EygflLfOrynoCjdT6
RoOUAujjJdzzsZahsEXX+UNzAZQvXXY0LJRhTcpD+/1HpGAf19r9cVmGmdYM
oUIrhVPK+nJafDEOxL7gsi4WgqFNyknts2J8NUHv/HlPEUQmbg5gHJLjpyN9
xbEvi4B3rjE/7LYcm7mPaHdSCJhsaUr0/l2O70bCLsamEcB+ditkZ6ccPc2P
0cwzCECrLoelO3KM76+8FCMiYHXVyJMLvXI0SmalGhMENF3Tbn3xXI5O5o0L
BysJmL0bcO/Yv3KUVDw90NFLAEcVdN1jQY6zXpToqH4CRikhF7YvyZHWKI+i
PiQgssbRJVOHxHbfBhrrMQG+f7sZ++uT2DK5SJ8eJ8Ai/vANNZXEZ8H5mjUf
CRjWHrkybkxiXAyV3aohoFgeXD5sQmK56XhZ6AIBuk0hBbdpJFK/TBus1pHB
u7moUGINiXZJIdO7qTKozo05nL2WRNPRoIQnJjI4bsb1STYj0WvgwohwtQwe
OfO+CaWTWBy36lCXmQyIniS7AAaJV2xdIk8yZODD5lt4rSMxXNR4lGIpA523
ApqLxedvwnW6ai2DtjSh/g5LEl8xz8wf2CCD/wD8UDeD
          "]]}, Annotation[#, "Charting`Private`Tag$9392#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVxXs0VAkcAGCvGoUmEbMTK0cKvYmwjt8viyZSyKtQY8ojbRlyTTPeY2au
973ZXotMRaUoeSRHSqRllx5bnDayWxM2wrGksjJ294/vfKa8GN9wNRUVFa//
/L/pim1ExGICaxVrm+PEHLj0szzhiQ6BBPnZaC6fA6vilAI7XQITYmdUsos4
YPHLXdFCFoHqm7ftq6jjwAaBXdoVcwKpk6Ec7b844Phibc4QEnjSd7rdfecO
8MsxuBghIFD1vMmyYpYHyGY/dEUMEIhLGKp3Gjwh9GIA/96zBOxxYDoncHfD
+dETFdE3BOgeVXRJJPSBkgL/xofSExgYEyYv37kHdJV/6x/nC3GTl7HydIg/
jC1xZwg9RTgdV8j1DQ2E7wb3uvXYJ6KFWbK3s3wveBpYBPabJmGYQUFTy1gw
tI3eUHGaTcIiiT1j3HI/VGVOTU8MJWOPaXW+ayAX1H+dEH9tTUGF1kqtKSoM
WBHl72oLU5HRvN/gn8c8ePaO2cF1ScMV1unU4S2HgBO5ZqSgKg3nG15f66fC
Qfj4W+sJ83RcqaX73NQwErTCpg6aFabjqbIfbI5fiQKf9tK36QvFeEGvtr7G
Ihq8l26RaiWJ0WPXk/GB3iOgse5C/INhMZ5m/kSTKUch1mo06wI3A0M7HLse
+cUABCzPCujJwBqbz1MT5/jQ4sfu3uoiQdtGw1vrUmLhq+28q2uDBOXWDg3V
yXEwOtysmrRaijqe15WCuOPg1BlanlUgxfvD1UR/ZDy4UX3xrQwZdm87oF8p
IEB9tW3eakKGlbxKD11RAojkxzpvf5DhvdIKec0ZAfi6S6fYXBIrNOMHzGpO
wB/NgsiKLhKrmG2t5D0hmBl5qEa6ZGLjcGftRoUIjD2/DHndykQ3Dk9n33Qi
CK5m1C82ykKWsOkpoZEM2UPjFZN0Fkq2ZgRdWZsCvl9sxxYos9B5kvKkIRVe
jIb4ucZn49tBuHzANg0W1R1g3FRko6veVcnQgzSQl0PZ2K4cXHbaOC9sRzqM
p85HBLXl4KebbNHw63SYtCwixjfnYkx0jp0yXAxV9QbXq8pz0fRbq5zmGTF0
8WM63I3zsPf996zBrAwomSu1XpSdh93JBesJpgQsjza0fprPQ8cSzSX2cgkc
riovYR7Lx8rnlo+4q6SwyCThkPJVPrbVHdJXXJYCL9bMm7Wbwr5zA8UbN8uA
f6aSDG2i8HdHRaFajQwG7lTHut2n0HCxwAnqZBD0qj54/QMKx2ZY7Yn1MkCj
lo1zDyncXpB49mOjDJZe6nlZ3Enhk8DUVYMPZVB9Q7nmdS+FwtulYy09Mphs
8+7YN0Ph287m9dEzMogY8q9xmaXQLUoxWjorgz5GcLHVHIV6JU9P9c/JgHfZ
2j5ZhUYzharcW40Ej/dO2l4aNC7j5RfbapHAPuZTN6pFY4gV7ThrREK3cs+1
N9o0/hbIl9qYkJBPBZR069DI/HO24YgpCWrVwZlNTBrf+Ov09pmTMDIVHpKr
R+PBsgH1uxtIKJNE+aTp06gXOPLj5CYS9i8/4h6/nMbt9rnaVjYkPLfjbwox
pNFk4fk757aSkNseZ+7NolHdTnPkqQMJ7kEE2/UbGh3YmgsYTiSoDAuY9mwa
d7ws1HR2JqFRKNJYt4LGswX3P8YjCf8COAgzjw==
          "]]}, Annotation[#, "Charting`Private`Tag$9392#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \\\"t\\\"],FontSlant->\\\
\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)/s)\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{336.65, 1030.793}, {0., 0.014221764793925508`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"CoefK = 1\"", "\"CoefK = 1.21108\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->494509410,ExpressionUUID->"bae4a8a2-3e5a-40c8-b09a-af2ac8041e04"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "279350e8-31af-41f4-be2e-4b9e8a63bc8e"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"cf477d6a-6d4e-4053-a276-9ef17dbf2697"],

Cell["\<\
It is possible to combine several coefficients in the same function\
\>", "ExampleText",
 CellID->12431897,ExpressionUUID->"21791096-3632-40ca-8ba2-ae07a5a46b28"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
     RowBox[{"DtK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"Coefd", "->", "5"}], ",", 
       RowBox[{"CoefN", "->", "0.054"}], ",", 
       RowBox[{"CoefK", "->", "1.21108"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Coefd = 1, CoefN = 1, CoefK = 1\>\"", ",", 
        "\"\<Coefd = 5, CoefN = 0.054, CoefK = 1.21108\>\""}], "}"}], ",", 
      "Above"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135717584,ExpressionUUID->"254755eb-ef9a-4cfe-90ba-dd1677552ad9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVzns0lAkcxvGRKZXEO3dvtFkrXdislpWUX1ZziiNCVsmyKtraNMrbGLcw
xhi3edM51aFGCeuyw2pLpYsftYtcVqiOpVRik0ui2rbJzM7+8Zzv+fz3WEUc
9t83h8Fg+Oj3f62WbKIiF1IwfbQkWt5FYvEfRcc6TShoWpbv291J4hdHtGJn
ggKm7lylZQeJK1pvxM8TUOAi0XRcaSXxS7FzSpkNBY/chU1jTSS69qzOHgEK
Lj5NsYm+QmJgNu9CpJiCwxXRhm0FJGZoxtojX1CQ2NcveBRJYuiFINGtrmNg
b7Dnpzsaczw3Hld1QC2GzuDq+y/PmaMqf0f9HVkczCawbUeF5kho33COiiRw
HF3qYicEOLFYaCTxjofHrtLqeSoBrh/eufmBSwLcSk5I6vYWoDdvxXePrRKB
uvqqltby8e64muGmSYT4ay33na/zsSZz5t3USBKYDfn6XRDx0fDeVNqnpmT4
3ejbkMVr+CiILB/6reA4DJyxIwqneNg1ZNoS7pECfOaY5FI1D7dE2b7Kr0mB
wubQ1c1HeCjpWOo4ZZMKKscMbdRaHhr/MLPHuiAVhtmjUvV7Lm5vvvgsdV4a
9BWoO7wauOhn9rXMODENdq3caiFP5yLT7nwsjqbBuqDi8MFtXIxZNa44Hy6F
wn+KuUweF92DuIqgB1J4N6CwTRrkYGMg2fuNRzpUGPeealFz8JOTztPzWjoc
WLvRwV7CwfHRBoPE5TLo8ZyJ37KVg25toeWKfBkk9AVMJi/h4GZlf2yTUQb0
hK16YjPGRsPlTrnLqQxQlRe82drAxvii6LYrYxnwsLS12PoEG/2FshkyXA5v
zXfUbdjHxicN4qiqdjlYO/jw8jaw0drCyyDKIxPKThbvfM5mo6X3hxGfXzNB
7fOwYtMkC8U/S+sWWiigoHVQkX2PhVkjk1XTtALYZyI28kpZ6P/BaWKuVgGl
B4lhfykLe8Z3B3rGZoHVybPOmjAWLrgcZlT9PAvMKicDlgELi8rdSya2ZYPk
Y2vqaysWTh7XRQbfzQa7HHms7xwWTq8spCa/yoHzpvOnOocJrKnjVdaU50By
t9Rd00xgu+hwi9AyF+Y+6425XkWgavai44KsXIg4FNK4IZ/AlYeuNb3X5cIJ
cflpmZjAH2vKVabReTAgK3q9N4zABZ8d26vtywOLkPbBuC0ERsRY+wl8lSB1
EkGEA4GiU7/IQ28q4XpgjLaAJPDF1dqYzbeV0JHYvn693sF9dSH2qASd8UdZ
vzmBYNG4ZvaOEj7/sxEs9DYrfvDobJsSDPn1vio+gbVqre3AX0q4bW9wv4RD
4PRdv5Zd/yoheF3ZthuLCYwc2XHJQ6OEhQZuVqF69xuFnF01q4S4fj+GzkT/
r9TRJYlBQ618YshDb6+Xbot8mDSEWlRBmzGBZPT2y+PGNGSv++TzZD6BvdqA
iqeLaOAO+/2doneeMkjVa0KDaFSTY633nNqQzJumNLi+8Jrdb0Tgq5l9u3PY
NKjNM2LeziWwJH3/9hQODQE64aHTen/PPSiM5dKwxtKLctW721nksJtPw9LZ
RZUpTAJzmo/Y+AloKLzd/NBab2EwRXqa08C7Wm/abEggY1Rs6kLS0BU1FHhA
73pJPNNuCQ2V/u5lJnr/B8aIQmk=
          "]]}, Annotation[#, "Charting`Private`Tag$14785#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVzns0lAkYBvBR1oSKCkl9c/EpJMTmstHpbVa27bLRYlyjQm02RpkmTAwy
LkPzLWqPskjtmmialIhNXmpDtKtQ6aJIU2qUWGVrsNMfz3nO75/nPOydMdsi
ZtBotC2afGn24nX8SD0+rAlJUm9Wklh2s+Tg33P48KAt4JzfCxIt9k8JnOfx
4Qx9VnnYIIlWbX8m6JjyYXOTtZA/QKKdwFn0x1I+9HucLi3rI3F1l41ECXx4
4vSyUu8+iT4Sk1ORAj5k9W0sNmwlUfz5TUfkIB+mG9a+e11BYsgpP15D50EI
j7UXmcWQ+JvqUOVeuQAeJLJmj68msTjPt/56+iGgF9Vk9uqROG/qvdEBXjzQ
++oiinrNcXiuJz1+UwIU3L2ZaXTeHN1eBKzvcU2E/IqLWi4p5rjJxIr7hC2E
whawdOWa4w2VnOb+WQiLeOynMgdzVGSOjY8oD4OgILBSqGeOM2+NpKqbk8Dq
ODfO5SUbTSNlzy+dSIahwbkX6v9iY+dzg9YwjgjGC7gBSWVs3LDb8nWeQgSW
dm0OualsjL/NcBxZmgKVNJ2tj8PYqL9jbBd5IgVa5ZI+GbDRu+V0f4pOKoTz
bP2CSTZ6Ga5K1xemQkqa6DJXm43aK0rjcCgVpPY1vkavWBi7XJVVGpYGnPSB
DvtbLFzrZ5zl15MG6vx1H3+Rs7DJx6zbhXMETBuFe8T5LFQ7TXt4XDkCNjva
aqcFLFQNNWoJl6VDSqHrPxPbWejeHiLLykuHiuTQvPnfsXC99FFcM10M4Ra/
qh/bsnDmMqfcZXwxrPzUYKu9kIUJJdHtl9+IwYp27cDUJBO3eaaPmYVlwD67
2n7fTib2NQp2V3ZkgLywhTQpZyK5ZKPWbk4mOJwa/OZ2IhOJTRPKLRcyQf79
mlUNPkwUlKfV6C3Jgq9pT90V9kzMVr6tHKWyQC5gGt+bpdmfcBr+aioLRhOl
BvdeMLBLFezjEZcNiR4DH52bGKhbHUo/P5AN56OSJa6lDCyRrT0z/IMEMkqT
Cz6IGPg2eTrS/4YEEmu8b7uFMXDU+iT/rUMOZOS+OdbIYaCixqRCIcsBqPjU
85JkYAcvptWTyIUOfZ1Zl3QYWDx52lE3OxeUl5rcQlUEWu+70vxhOhdO6lbd
b+kk8CeFrNgg+igYHhq596yWQF3mwfCp3qNQqGW7362UwJ2xpJfpVinYFA6X
RWQQyDt+LiPkqhSMklar/+UROFhbFbv+mhTcuMf88zT2760JskUp/Dwvqtle
Y1jSZD95XQoXNwiv7Y0h0LCs535RuxSybw5x+/cRWCWfsnz8UArtnPw5d/YS
OHrDqzXwPynwunxi68MJjFT6XuR8lsKGki5BgMaP6EFFyyel4C8RSCZ2af79
7uh6mEbBqIvFQ2eNN75yn71FmwLrVS1G1TsINIv2rlbpUzC255X6wnYCu6d+
PPtsNgUPViR1e2l8VOpX3D2HghBbg7qREAJnVAVlXjWgQJxqenalxq/HIoJz
FlBwZzzZoiqIwDNH9niLjCg4O798l7fG242jPOOMKaivq1a8DyTwrjNvZfBC
Cj4ExEc7apzTsn+plykFUXY2/XcDCPT055t5LKLg1rd1YQc0pg0JDFzNKAjU
ZQ8v0Lg+PkF7xWIKFr4LFVf7E/g/mjhLdg==
          "]]}, Annotation[#, "Charting`Private`Tag$14785#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
     AxesOrigin -> {336.65, -9.949806108880347}, FrameTicks -> {{Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "ClippingRange" -> {{{336.65001416618367`, 
        1030.7929858338161`}, {-9.949806108880347, -4.25298175584309}}, {{
        336.65001416618367`, 
        1030.7929858338161`}, {-9.949806108880347, -4.25298175584309}}}}, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, -9.949806108880347}, 
     CoordinatesToolOptions -> {"DisplayFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& )}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \\\"t\\\"],FontSlant->\\\
\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)/s)\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, PlotRange -> {{336.65, 
      1030.793}, {-9.949806108880347, -4.25298175584309}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Coefd = 1, CoefN = 1, CoefK = 1\"", 
       "\"Coefd = 5, CoefN = 0.054, CoefK = 1.21108\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {2, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Above"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[1]=",
 CellID->331201215,ExpressionUUID->"c0800ff5-026a-4772-9452-f1914440b94a"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"781adf7d-65fc-4c6c-9f99-77b96a230cca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"bdc9f9a1-31c9-4ea9-8923-96a7036c0507"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"bc731593-61ad-4fc3-a126-10e6b187588a"],

Cell[TextData[StyleBox[ButtonBox["K0K",
 BaseStyle->"Hyperlink",
 ButtonData->{"K0K.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"d9fdfc57-7836-4dc7-9267-e74411298307"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"ccd059e1-b909-4630-bf75-a7fc1fcb4838"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 11.2202997}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "CoefK CoefK is an option for TtransVapK, etalK1atm, etaK1atm, DtK1atm, \
etalKVap, etaKVap, DtKVap and u2lVap functions that allows the elastic \
parameter K to be multiplied by a numeric constant. ", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "CoefK", "titlemodifier" -> "", 
    "windowtitle" -> "CoefK", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/CoefK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"33a26700-0d2b-4e96-ac80-dbab36fd8419"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7203, 200, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"675869ef-8b28-4201-b95a-a71da80be020",
   CellTags->"PrimaryExamplesSection",
   CellID->671483843]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48805, 1108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 3608, 83, 53, "AnchorBarGrid",ExpressionUUID->"fc498aed-4c91-4e3c-aca6-6048c75518fd",
 CellID->1],
Cell[CellGroupData[{
Cell[4210, 108, 390, 9, 54, "ObjectNameGrid",ExpressionUUID->"2afff4c3-011b-4d45-a226-073c1afdcf85"],
Cell[4603, 119, 1467, 45, 134, "Usage",ExpressionUUID->"45249a91-2c6c-4536-a95a-92955f793b19",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6107, 169, 855, 21, 37, "NotesSection",ExpressionUUID->"e7a971eb-be25-42f1-bacb-2cc1e797ba56",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->147267105],
Cell[6965, 192, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"f6195140-d4ba-4710-aba4-ca2c3e296255"],
Cell[7054, 194, 112, 1, 70, "Notes",ExpressionUUID->"21d0c288-f234-4999-b8f6-08d5627e5135",
 CellID->396847190]
}, Closed]],
Cell[CellGroupData[{
Cell[7203, 200, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"675869ef-8b28-4201-b95a-a71da80be020",
 CellTags->"PrimaryExamplesSection",
 CellID->671483843],
Cell[CellGroupData[{
Cell[7663, 215, 307, 7, 30, "ExampleSection",ExpressionUUID->"a2cbaac2-4615-407f-9eaa-011fdd2ed5dc",
 CellID->13613904],
Cell[7973, 224, 175, 3, 27, "Input",ExpressionUUID->"045c3149-bc5d-4149-8a50-8441d059bf2c",
 CellID->87419684],
Cell[8151, 229, 261, 7, 57, "ExampleText",ExpressionUUID->"88e5ddf5-750e-4e41-9090-de52615b4069",
 CellID->119396994],
Cell[CellGroupData[{
Cell[8437, 240, 287, 6, 44, "Input",ExpressionUUID->"7fcf76b1-7f98-4f74-9124-a38bd1b1beb7",
 CellID->614342864],
Cell[8727, 248, 144, 2, 36, "Output",ExpressionUUID->"66838cb7-5084-4391-b741-314a5829ddc5",
 CellID->116617506],
Cell[8874, 252, 143, 2, 36, "Output",ExpressionUUID->"4e8cd3a7-a667-4735-9aba-9a090a1b8107",
 CellID->429221721]
}, Open  ]],
Cell[9032, 257, 263, 5, 57, "ExampleText",ExpressionUUID->"49a1f7e5-49ab-4714-b65e-97160b5c1f71",
 CellID->168920797],
Cell[CellGroupData[{
Cell[9320, 266, 964, 24, 67, "Input",ExpressionUUID->"fa63f89a-7b49-40b9-b835-8b823cd8482b",
 CellID->562653754],
Cell[10287, 292, 15988, 324, 250, "Output",ExpressionUUID->"bae4a8a2-3e5a-40c8-b09a-af2ac8041e04",
 CellID->494509410]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26324, 622, 323, 7, 70, "ExampleSection",ExpressionUUID->"cf477d6a-6d4e-4053-a276-9ef17dbf2697",
 CellID->1020263627],
Cell[26650, 631, 172, 3, 70, "ExampleText",ExpressionUUID->"21791096-3632-40ca-8ba2-ae07a5a46b28",
 CellID->12431897],
Cell[CellGroupData[{
Cell[26847, 638, 1195, 30, 70, "Input",ExpressionUUID->"254755eb-ef9a-4cfe-90ba-dd1677552ad9",
 CellID->135717584],
Cell[28045, 670, 17918, 362, 301, "Output",ExpressionUUID->"c0800ff5-026a-4772-9452-f1914440b94a",
 CellID->331201215]
}, Open  ]]
}, Closed]],
Cell[45990, 1036, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"781adf7d-65fc-4c6c-9f99-77b96a230cca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46113, 1041, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"bc731593-61ad-4fc3-a126-10e6b187588a",
 CellID->1255426704],
Cell[46376, 1050, 208, 4, 70, "SeeAlso",ExpressionUUID->"d9fdfc57-7836-4dc7-9267-e74411298307",
 CellID->234329647]
}, Open  ]],
Cell[46599, 1057, 78, 0, 70, "FooterCell",ExpressionUUID->"ccd059e1-b909-4630-bf75-a7fc1fcb4838"]
}
]
*)

(* End of internal cache information *)

