(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32225,        762]
NotebookOptionsPosition[     27356,        652]
NotebookOutlinePosition[     29762,        713]
CellTagsIndexPosition[     29677,        708]
WindowTitle->CoefN
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "a57a3d3f-1de2-43c3-8cc2-0c022d0b4751"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"cf6685bf-713e-44c0-94ec-28a70cf23891"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"Coefd\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"Coefd.nb", None}, "paclet*"], 
         Part[
          Part[{{"Coefd", {"Coefd.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"Coefd", {"Coefd.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ab8c31b3-d71d-41d0-aa7e-5f8d642cfc11"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"2e58da1c-7254-4d53-bde2-0bc32f7c88f3"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/CoefN\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/CoefN"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/CoefN.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$17198], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/CoefN", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "54f00fc5-38a5-4165-852f-86762dca1f33"]
    }], "AnchorBar",ExpressionUUID->"ee2eff78-20d2-40c4-a359-3222778799af"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"0d8e521c-0ec8-4b8a-8f1f-2d8dcac6807a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["CoefN", "ObjectName",ExpressionUUID->
  "18e954ec-a411-471d-9e69-d5b0ed0fdb46"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"69fadd8e-2885-4d15-b0e9-e066e220154d"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "70ca9a04-abdf-4652-a76e-2640a11f590d"]
}], "ObjectNameGrid",ExpressionUUID->"08b24f92-c203-4fe5-9f62-d21c18735b55"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
     "CoefN"], "InlineFormula",ExpressionUUID->
      "76a48d8f-f67d-4078-beac-86281793ce41"],
     " \[LineSeparator]CoefN is an option for ",
     ButtonBox["NdNtcVapK",
      BaseStyle->"Hyperlink",
      ButtonData->{"NdNtcVapK.nb", None}],
     ",  ",
     ButtonBox["etalK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalK1atm.nb", None}],
     ", ",
     ButtonBox["etaK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaK1atm.nb", None}],
     ", ",
     ButtonBox["DtK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     ", ",
     ButtonBox["etalKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalKVap.nb", None}],
     ",  ",
     ButtonBox["etaKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaKVap.nb", None}],
     ", ",
     ButtonBox["DtKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     " and ",
     ButtonBox["u2lVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"u2lVap.nb", None}],
     ButtonBox[" ",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalH2O.nb", None}],
     "functions that allows the fluctuative distance ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["d", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "46dbfa48-7240-4cd4-bd8a-ca30af5c6b68"],
     " to be multiplied by a numeric constant."
    }],ExpressionUUID->"9302bc44-6383-4030-88b2-e1f47277c4da"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"217e11a3-6ed8-4721-8d55-c26504b212f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"48d6d29b-7696-4758-a112-9981a6975439"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"3336bb96-a5aa-48e6-8b3f-c8dbba82708d"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"7db6f35d-a8f4-4d72-abe3-3022d524da83"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->578811129,ExpressionUUID->"1804f6d2-82d6-455d-8930-ea7bbf99b004"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a1bbd0b5-e974-4f58-889f-d908c43b2077"],

Cell["By default CoefN = 1", "Notes",
 CellID->289210655,ExpressionUUID->"ee26f871-0107-4e80-b7eb-e25f53592448"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"1c49ac2e-ca56-4137-aa78-47a9981f699d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6f1d418c-e309-4b5e-9a5e-d0387b17d87a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->917247,ExpressionUUID->"99a75f86-e3aa-4de5-97fe-4314c1bb6c18"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "dd30e85d-72de-4904-8b37-cb1a290e16e9"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->40633417,ExpressionUUID->"61005741-533e-42a2-9b09-5c34cd9ed275"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"f42c94e6-b542-45cc-b0f1-979463971456"],

Cell[TextData[{
 "Decreasing ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "340c41aa-c38e-4c70-ae7e-ed46385c11ba"],
 " is equivalent to decreasing the coherence length therefore the viscosity \
increases as shown in the example below"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"5d398954-836b-4ad9-9178-d28500fae884"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaK1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"TmpK", ",", 
   RowBox[{"CoefN", "->", "0.8"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->614342864,ExpressionUUID->"ded96740-180f-4399-a6e1-460167caf492"],

Cell[BoxData["0.5389191503225945`"], "Output",
 CellLabel->"Out[2]=",
 CellID->121531674,ExpressionUUID->"a7df8a4c-4f26-4fe5-bee8-3643f328e9f4"],

Cell[BoxData["0.5481702454639559`"], "Output",
 CellLabel->"Out[2]=",
 CellID->386301945,ExpressionUUID->"e1401253-3e1e-40d8-a3a4-cd4a69a2c91e"]
}, Open  ]],

Cell["\<\
Plot of the the self-diffusion coefficient from the melting point to the \
boiling point along the atmospheric isobar for two different values of the \
CoefN\
\>", "ExampleText",
 CellID->168920797,ExpressionUUID->"9943dbce-2180-4c11-b2ab-16d2b118117a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
     RowBox[{"DtK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"CoefN", "->", "0.8"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CoefN = 1\>\"", ",", "\"\<CoefN = 0.8\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->562653754,ExpressionUUID->"bbd3e906-921b-43d6-bc05-2f6c7529693c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVyX0w1AkYwHHhbCxtrtjNS3qh0tW5dCTn7nm8XpGSlt1C4bLUelmylkWs
ZVl+a3/jZpqGIvJWtHtScXTnpebUEQq9KSO57coqx6i9wbruj+98/vhujEwI
jNLV0dHx/9z/brR053OM+DhfteRpwmBC1R8VKf0mfCzRVWqqNjDBNkkrcDbl
4/cmD2b22jNh2/12oQGDjzdS265yXZnwtcA5u9aOj6VZbPexUCa4Dn1VpEI+
enaeer5cyQRmkXklR8BHd8X1gd07g0CyMNXHmeRjQLrCjf1jMIRVBvN+G0zB
+1XgZ3CbDRfVqQ2nrwlQHD9FH7AMgfKSoLY7ealozs6nOIjDwFT7z9ozvDRs
O9oeybMIh+lVPpQ0PyHW9hzcNMOJgO/+Ouo94pKOjPP0cwGjkeBnvo31cmMG
6rW+eVkWdBLuqq/puC1kYJaH44cT3VGgLJibn1Fl4k0KkyBCokHvz5mcxe6z
eH1lO31JFQMMTv3r5tIsXNfkNzguOA2Dr2n3wj2yMXaM8GS5xsK+6K3vSpTZ
OOxKt+mfjoO0B+sdZ+xEGFhckTD7OAGoEXM/bS4VYa3xnFH6JA8O91x+JTLI
QRuxJvnRcCIErP42j5qRg3W2n1hJE0mgv+NScufbHFxwP9AgVp2BxO1q6aVw
MbpyFZoIQz5AsJk0eESMQ6KgxSmHFOhiWgzv8cjFrNGumjhfASw6LXt5teYi
tVLq25GbCuq3HSsytuQhqejf5duUBm69YfXSkjycOW6joo0JwVs+mtxNkaB+
KfXX89szQG+Lk2wLX4ITurtHbTmZIKyI7705JcGl9TWp9K6zEOiTN2cRno9v
aOkTGuNsGOsQRDf05aPy8ooItjIbNlv5roj2KECLau1QR7gIrP00Kv9fCrB2
og49KTkgqBPfMrKS4v0Bs5JVDTlQqHrfMEtK0c/fe9IqTAyBGqfpL7RSVDx4
47BPLxeG1KFMr+RC7Hia9GRXSy4Y3jhBUUwUogHXfb77eB5U1EP19MEiLPmh
bi9fVwLvs5Y57LtFaLDSc9GhWQKz9mX897sI7Bkq2+/EygflLfOrynoCjdT6
RoOUAujjJdzzsZahsEXX+UNzAZQvXXY0LJRhTcpD+/1HpGAf19r9cVmGmdYM
oUIrhVPK+nJafDEOxL7gsi4WgqFNyknts2J8NUHv/HlPEUQmbg5gHJLjpyN9
xbEvi4B3rjE/7LYcm7mPaHdSCJhsaUr0/l2O70bCLsamEcB+ditkZ6ccPc2P
0cwzCECrLoelO3KM76+8FCMiYHXVyJMLvXI0SmalGhMENF3Tbn3xXI5O5o0L
BysJmL0bcO/Yv3KUVDw90NFLAEcVdN1jQY6zXpToqH4CRikhF7YvyZHWKI+i
PiQgssbRJVOHxHbfBhrrMQG+f7sZ++uT2DK5SJ8eJ8Ai/vANNZXEZ8H5mjUf
CRjWHrkybkxiXAyV3aohoFgeXD5sQmK56XhZ6AIBuk0hBbdpJFK/TBus1pHB
u7moUGINiXZJIdO7qTKozo05nL2WRNPRoIQnJjI4bsb1STYj0WvgwohwtQwe
OfO+CaWTWBy36lCXmQyIniS7AAaJV2xdIk8yZODD5lt4rSMxXNR4lGIpA523
ApqLxedvwnW6ai2DtjSh/g5LEl8xz8wf2CCD/wD8UDeD
          "]]}, Annotation[#, "Charting`Private`Tag$11214#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVxXk01AkcAPBRyjpK3jpHOlaRokOxNrP7/TaOF5IxjlTkiFEpZvAzzmaM
mfkZ1+/3PPUq5a41a62j0qFUKFLRll6HtKXMi5Blc0Ts7h+f91kdFsONWMBg
MDz/8/+rTXcQPC0CF3B9T7IFHCi7V5zQuYTAwGnLQodEDqyJnRPa6xFokjdZ
sknEgXX3G5MXGxO4c9agZlUuBzYK7cUX1hJ4ycj6yVIlB7Y/3ZCtQgIjmV6m
pu844JttWMoTEqhh+JUx7u0N8plPD3kfCDy2LV290J4LQaX+/JuPE3Dntc3K
F1t94dxQYtWRaiGGWfr1vl7pD0X5ftdbZIl4+vaHnFa9ANCb+1s/jp+Eaec0
F2bDPhhe6qqR5JGMnVXdz1fsDQTH/r0uzxxScLPmCmqs/gB4GK7b07s6Fa9a
1rYvyw6B1qFqBmsmFVNezeqfrwuFmszxL6OqNNRiFfQzZsNgYceoZLb5OI6V
9+7e6hgOxrzK9xfPiLChJK6j8XgEPH6v2x7CFqPAp/6A3SAPdkZaDubXiJEl
jlSTux2CpEcrbEfXpmPNCesIg+7DoB06ftD8TDraphToN0VEgXdb+bv0xRKs
deqQBA8cBc6ybTLtVAkidbfa5mw0qFuXxN8ekKCJzbWW5pV8EKwfUpSEZGDV
NlYpS0sA4G+g8H+WgWTwkTsVkwK448vs/pEtxab5z1E+PbEwazfv7HxViuyc
iV+KXsTB0MAttVQLGXbbHJ5p64gH1oOgSkW+DLe+Pchh3iTAheqJb9aQ4+cy
vZ6Z9gRYaGGXa0HIUVkteGLRJoTk4ugHlz/JsSA6X1TwJhG4rrJxZgiJg32f
Rt3+SYI3t4SRVQ9JdL47+9e96WQwX+6uFsnOROOQ2tN8o1Qw85hSedZmYmW5
i1RhngbCXzMatJYrsF6Jz7dvOA5ZqpGqMVqBbYZHRK/cRMCdshteNKfAUs+I
pMr1Yng6FOjrHJ+FvKwrjTGNYtC8FKzxR18WXmm6n+nMTofiSqgY3p2NXs3U
rum76TAimucFtGZjsTt5wdJXAmNWhcTIlhx0SHqkx3whgZoGw99qKnPwix6l
sOJlwEN+TLurWS7e7GJVF45mQNG3clvNrFzs0/mado8vBatjV5sn5nPR7ZGt
svirFA7XVBbpRuehSnsy8KdkGWiuTAife5mHTPtwcJqQQZjAnGPsRWFOYPv7
shQ58E/+TgbdoPCUWX/n2IQcPlypE7g0UThVcVllOC2HgJcN+21uU2jgs/fj
9hk54PI7m761UHjxpZFSMi+HZWXPnp99QKHodegqve9IqKues3z9isIfbtT2
W5mQMNbKad83TaG+4/U2d0cSeCq/evYMhe9sR4yP/kxCj8b+s+u/Ucgr6/fJ
BRLCzts6pDFoXOxhRnY5keD+kaXjqU5jeG1FH3cXCcxo70tD2jT62d065hdE
Qvecj/KtDo2Jp2b3EcEk5FH+Rd1LaMySTm45EUrCgrr9mTd0aWwpX3OuO4KE
wfGIwJzvaYya4h7iRpNQIT3kLdansSM/rlzAJ+GAQZRrvAGNedZe7XQsCU/s
+ZsDjWgs2mjf1ZlAQk5b7FqOMY2E2o664UQSXAMIprMJjUuVi9J0UkhgDAh1
HZg0xvRm2G5II+F6UrK6tSmNXXsa/3QTkfAvGV0+HQ==
          "]]}, Annotation[#, "Charting`Private`Tag$11214#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \\\"t\\\"],FontSlant->\\\
\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)/s)\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{336.65, 1030.793}, {0., 0.014221764793925508`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"CoefN = 1\"", "\"CoefN = 0.8\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->572984060,ExpressionUUID->"086484e4-5cbf-4ee4-be2d-2d33a5ed9fc6"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"09c95082-0f86-4e32-970d-65a4574d74f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"1d10fc00-ba83-41c4-ad5e-947b0cac8bf8"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"210ad9f1-2654-48a5-ac8c-2065d07cb20b"],

Cell[TextData[StyleBox[ButtonBox["Coefd",
 BaseStyle->"Hyperlink",
 ButtonData->{"Coefd.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->139279649,ExpressionUUID->"b348f4cd-1321-4173-b2d2-69559a405a5a"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"6420d2d0-a7cb-4827-a248-ef7b5e3dc9c5"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefN",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 13.3843005}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "CoefN CoefN is an option for NdNtcVapK, etalK1atm, etaK1atm, DtK1atm, \
etalKVap, etaKVap, DtKVap and u2lVap functions that allows the fluctuative \
distance dN to be multiplied by a numeric constant.", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "CoefN", "titlemodifier" -> "", 
    "windowtitle" -> "CoefN", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/CoefN", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"927b57f4-3f2c-4d95-92a3-3eedde8620b4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7435, 206, 432, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"99a75f86-e3aa-4de5-97fe-4314c1bb6c18",
   CellTags->"PrimaryExamplesSection",
   CellID->917247]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29482, 701}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 3620, 83, 53, "AnchorBarGrid",ExpressionUUID->"0d8e521c-0ec8-4b8a-8f1f-2d8dcac6807a",
 CellID->1],
Cell[CellGroupData[{
Cell[4222, 108, 390, 9, 54, "ObjectNameGrid",ExpressionUUID->"08b24f92-c203-4fe5-9f62-d21c18735b55"],
Cell[4615, 119, 1687, 51, 134, "Usage",ExpressionUUID->"217e11a3-6ed8-4721-8d55-c26504b212f9",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6339, 175, 855, 21, 37, "NotesSection",ExpressionUUID->"1804f6d2-82d6-455d-8930-ea7bbf99b004",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->578811129],
Cell[7197, 198, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a1bbd0b5-e974-4f58-889f-d908c43b2077"],
Cell[7286, 200, 112, 1, 70, "Notes",ExpressionUUID->"ee26f871-0107-4e80-b7eb-e25f53592448",
 CellID->289210655]
}, Closed]],
Cell[CellGroupData[{
Cell[7435, 206, 432, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"99a75f86-e3aa-4de5-97fe-4314c1bb6c18",
 CellTags->"PrimaryExamplesSection",
 CellID->917247],
Cell[CellGroupData[{
Cell[7892, 221, 307, 7, 30, "ExampleSection",ExpressionUUID->"61005741-533e-42a2-9b09-5c34cd9ed275",
 CellID->40633417],
Cell[8202, 230, 175, 3, 27, "Input",ExpressionUUID->"f42c94e6-b542-45cc-b0f1-979463971456",
 CellID->87419684],
Cell[8380, 235, 400, 10, 57, "ExampleText",ExpressionUUID->"5d398954-836b-4ad9-9178-d28500fae884",
 CellID->119396994],
Cell[CellGroupData[{
Cell[8805, 249, 283, 6, 44, "Input",ExpressionUUID->"ded96740-180f-4399-a6e1-460167caf492",
 CellID->614342864],
Cell[9091, 257, 144, 2, 36, "Output",ExpressionUUID->"a7df8a4c-4f26-4fe5-bee8-3643f328e9f4",
 CellID->121531674],
Cell[9238, 261, 144, 2, 36, "Output",ExpressionUUID->"e1401253-3e1e-40d8-a3a4-cd4a69a2c91e",
 CellID->386301945]
}, Open  ]],
Cell[9397, 266, 263, 5, 57, "ExampleText",ExpressionUUID->"9943dbce-2180-4c11-b2ab-16d2b118117a",
 CellID->168920797],
Cell[CellGroupData[{
Cell[9685, 275, 956, 24, 67, "Input",ExpressionUUID->"bbd3e906-921b-43d6-bc05-2f6c7529693c",
 CellID->562653754],
Cell[10644, 301, 15990, 324, 250, "Output",ExpressionUUID->"086484e4-5cbf-4ee4-be2d-2d33a5ed9fc6",
 CellID->572984060]
}, Open  ]]
}, Open  ]],
Cell[26661, 629, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"09c95082-0f86-4e32-970d-65a4574d74f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26784, 634, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"210ad9f1-2654-48a5-ac8c-2065d07cb20b",
 CellID->1255426704],
Cell[27047, 643, 212, 4, 70, "SeeAlso",ExpressionUUID->"b348f4cd-1321-4173-b2d2-69559a405a5a",
 CellID->139279649]
}, Open  ]],
Cell[27274, 650, 78, 0, 70, "FooterCell",ExpressionUUID->"6420d2d0-a7cb-4827-a248-ef7b5e3dc9c5"]
}
]
*)

(* End of internal cache information *)

