(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50180,       1144]
NotebookOptionsPosition[     44760,       1022]
NotebookOutlinePosition[     47169,       1083]
CellTagsIndexPosition[     47083,       1078]
WindowTitle->Coefd
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "3fa3f5c7-5474-4d2c-bc9c-b5f73236d922"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"792a24ee-368f-4b5e-9f33-ce3ab956be85"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"CoefN\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"CoefN.nb", None}, "paclet*"], 
         Part[
          Part[{{"CoefN", {"CoefN.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"CoefN", {"CoefN.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ec5956fd-225c-4e08-a034-1499fde383f5"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"4b7ed3c3-0c1d-4bd4-a24e-83f0781d5365"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/Coefd\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/Coefd"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/Coefd.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$16388], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/Coefd", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f07b6420-83fe-4262-8987-66e738f20e03"]
    }], "AnchorBar",ExpressionUUID->"d2f33fd8-d886-4035-bd2f-45d50728e518"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"a3eaebcc-0e4c-4553-b992-2a8babe18ead"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["Coefd", "ObjectName",ExpressionUUID->
  "8eb7d45f-fd62-45cb-9735-c2e88eae7f10"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"47d11bf5-e80a-4be1-91fb-756198166367"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "bfece355-a00d-4afa-966a-21945427f3d1"]
}], "ObjectNameGrid",ExpressionUUID->"f0178903-dfbb-4795-8934-42d0c2e1c26a"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
     "Coefd"], "InlineFormula",ExpressionUUID->
      "e166cd9c-81ad-482c-a986-91525f702782"],
     " \[LineSeparator]Coefd is an option for ",
     ButtonBox["NdNtcVapK",
      BaseStyle->"Hyperlink",
      ButtonData->{"NdNtcVapK.nb", None}],
     ",  ",
     ButtonBox["etalK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalK1atm.nb", None}],
     ", ",
     ButtonBox["etaK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaK1atm.nb", None}],
     ", ",
     ButtonBox["DtK1atm",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     ", ",
     ButtonBox["etalKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalKVap.nb", None}],
     ",  ",
     ButtonBox["etaKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"etaKVap.nb", None}],
     ", ",
     ButtonBox["DtKVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"DtK1atm.nb", None}],
     " and ",
     ButtonBox["u2lVap",
      BaseStyle->"Hyperlink",
      ButtonData->{"u2lVap.nb", None}],
     ButtonBox[" ",
      BaseStyle->"Hyperlink",
      ButtonData->{"etalH2O.nb", None}],
     ButtonBox[" ",
      BaseStyle->"Hyperlink",
      ButtonData->{"KN.nb", None}],
     "functions that allows the dissipative distance ",
     StyleBox["d",
      FontSlant->"Italic"],
     " to be multiplied by a numeric constant. "
    }],ExpressionUUID->"4d9a42fc-9a10-4e7e-9d49-3c4c94e4dc7b"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"80d7b67d-78cf-430d-86c7-4c7e276f22de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"31c191ea-f6cc-4b61-bfba-2147061aac67"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"c02be60a-0989-4986-86d3-2c8a761f45aa"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"fcdb951b-6375-4dbf-bd17-d1630139d151"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->336287749,ExpressionUUID->"c9483b0c-d171-408d-8174-e8ec25d76cbe"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"30286011-1699-442b-9278-b0ae2cd379ff"],

Cell["By default Coefd = 1", "Notes",
 CellID->544296333,ExpressionUUID->"129f4073-7293-4579-bae4-4ce1814b146b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b0089c72-7b27-474f-80ec-655ee51912b0"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "181073df-470e-4fb1-aaff-97d067613ee5"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->362203934,ExpressionUUID->"f922b09c-d0a3-4120-be54-bbbd0f47b38d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9810349e-fbc7-420f-993b-9c83c538e85c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->27923865,ExpressionUUID->"5f64954c-b613-400e-a1dd-62b306d9eabb"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"d95d0baa-9974-4454-930c-09862ff1bbd4"],

Cell[TextData[{
 "Increasing ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is equivalent to increasing the viscosity as shown in the example below"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"c4a2e8cb-17f0-4904-91b8-235d9cc7ba56"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaK1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"TmpK", ",", 
   RowBox[{"Coefd", "->", "5"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->614342864,ExpressionUUID->"191a0cf6-59e9-4f52-84b5-428c327d02d7"],

Cell[BoxData["0.5389191503225945`"], "Output",
 CellLabel->"Out[2]=",
 CellID->760889583,ExpressionUUID->"3c5f8344-2c31-482b-b554-c7c6a0be5f1b"],

Cell[BoxData["0.5462903567438031`"], "Output",
 CellLabel->"Out[2]=",
 CellID->48277805,ExpressionUUID->"844cddac-1f1a-46c0-9c35-331ffc5d7212"]
}, Open  ]],

Cell["\<\
Plot of the the self-diffusion coefficient from the melting point to the \
boiling point along the atmospheric isobar for two different values of the \
Coefd\
\>", "ExampleText",
 CellID->168920797,ExpressionUUID->"c3d356bf-469a-4978-a7b3-0bbd6bcb05b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
     RowBox[{"DtK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"Coefd", "->", "5"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Coefd = 1\>\"", ",", "\"\<Coefd = 5\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->562653754,ExpressionUUID->"3f043913-dec2-45d7-afab-e9f5e41a8b02"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVyX0w1AkYwHHhbCxtrtjNS3qh0tW5dCTn7nm8XpGSlt1C4bLUelmylkWs
ZVl+a3/jZpqGIvJWtHtScXTnpebUEQq9KSO57coqx6i9wbruj+98/vhujEwI
jNLV0dHx/9z/brR053OM+DhfteRpwmBC1R8VKf0mfCzRVWqqNjDBNkkrcDbl
4/cmD2b22jNh2/12oQGDjzdS265yXZnwtcA5u9aOj6VZbPexUCa4Dn1VpEI+
enaeer5cyQRmkXklR8BHd8X1gd07g0CyMNXHmeRjQLrCjf1jMIRVBvN+G0zB
+1XgZ3CbDRfVqQ2nrwlQHD9FH7AMgfKSoLY7ealozs6nOIjDwFT7z9ozvDRs
O9oeybMIh+lVPpQ0PyHW9hzcNMOJgO/+Ouo94pKOjPP0cwGjkeBnvo31cmMG
6rW+eVkWdBLuqq/puC1kYJaH44cT3VGgLJibn1Fl4k0KkyBCokHvz5mcxe6z
eH1lO31JFQMMTv3r5tIsXNfkNzguOA2Dr2n3wj2yMXaM8GS5xsK+6K3vSpTZ
OOxKt+mfjoO0B+sdZ+xEGFhckTD7OAGoEXM/bS4VYa3xnFH6JA8O91x+JTLI
QRuxJvnRcCIErP42j5qRg3W2n1hJE0mgv+NScufbHFxwP9AgVp2BxO1q6aVw
MbpyFZoIQz5AsJk0eESMQ6KgxSmHFOhiWgzv8cjFrNGumjhfASw6LXt5teYi
tVLq25GbCuq3HSsytuQhqejf5duUBm69YfXSkjycOW6joo0JwVs+mtxNkaB+
KfXX89szQG+Lk2wLX4ITurtHbTmZIKyI7705JcGl9TWp9K6zEOiTN2cRno9v
aOkTGuNsGOsQRDf05aPy8ooItjIbNlv5roj2KECLau1QR7gIrP00Kv9fCrB2
og49KTkgqBPfMrKS4v0Bs5JVDTlQqHrfMEtK0c/fe9IqTAyBGqfpL7RSVDx4
47BPLxeG1KFMr+RC7Hia9GRXSy4Y3jhBUUwUogHXfb77eB5U1EP19MEiLPmh
bi9fVwLvs5Y57LtFaLDSc9GhWQKz9mX897sI7Bkq2+/EygflLfOrynoCjdT6
RoOUAujjJdzzsZahsEXX+UNzAZQvXXY0LJRhTcpD+/1HpGAf19r9cVmGmdYM
oUIrhVPK+nJafDEOxL7gsi4WgqFNyknts2J8NUHv/HlPEUQmbg5gHJLjpyN9
xbEvi4B3rjE/7LYcm7mPaHdSCJhsaUr0/l2O70bCLsamEcB+ditkZ6ccPc2P
0cwzCECrLoelO3KM76+8FCMiYHXVyJMLvXI0SmalGhMENF3Tbn3xXI5O5o0L
BysJmL0bcO/Yv3KUVDw90NFLAEcVdN1jQY6zXpToqH4CRikhF7YvyZHWKI+i
PiQgssbRJVOHxHbfBhrrMQG+f7sZ++uT2DK5SJ8eJ8Ai/vANNZXEZ8H5mjUf
CRjWHrkybkxiXAyV3aohoFgeXD5sQmK56XhZ6AIBuk0hBbdpJFK/TBus1pHB
u7moUGINiXZJIdO7qTKozo05nL2WRNPRoIQnJjI4bsb1STYj0WvgwohwtQwe
OfO+CaWTWBy36lCXmQyIniS7AAaJV2xdIk8yZODD5lt4rSMxXNR4lGIpA523
ApqLxedvwnW6ai2DtjSh/g5LEl8xz8wf2CCD/wD8UDeD
          "]]}, Annotation[#, "Charting`Private`Tag$12171#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVxX041AccAPALJUmoiIuaXaRoDSlPtO+XcambdXd5q3NlyimW7uTnOGfO
y+Huh/vt1lqPjHLoqkms1CTlZV5yNZXeaGuqeUrHvPSiedv2x+f5OEQd5kYb
0Gi0oP/8v8NyX0KwgMAdDs6e2sUcKGsrTbptRqC7PrDqEJ0DqxJmxBstCSwK
zSI2fMwB586rknk2BNrryt7+6saBT8QbZZWOBKakrbkwwebA5nsu5AAS2HHM
QF+s4kAwaX1KICawJTku+akZF3ImX+sELwisn3whCli0E/inQoXXupOwc/+o
WyMrBH7UJ5+LrRLjhmGeWWVyGJSoQ+pb5MlIL05qOHN+F1jOjC49IkzB/rAR
hp9LBAwtYhqnsCR4+rTHlX/Ue8D7r10B971S8e6tCkMfTSSwrJ3DfneQYs/Y
/Nd8wyho1VfRfCal2F3aeVkTtg+q88bfjgyk4UONlc+SB/vB8OZI5lTzN2h8
J9+FHSgAG4H2+c9F6ehCT+/1vBED3c/NOyL9ZNjfYxPrGnMQAmNWD6qrZfhb
Oa3zW1ocpNxa4T7imIGOZvMa3+m+BtOvxvcxijKQZ3np0OayeOC0a/oz5mVi
i/3g1tseQmBbbJCbSjNRM63t4bmLwMj1ZOKNV5nYaXl0rb1zAojW6hUnI7Mw
6uzeDC/vIwChVorQ+1louqzRyIybCE3B9J5Nftl4wN720WU+AVOes/7+V7KR
7/53W3tuEuhfXZ8jdZLjXMaD7LkVYvDp4msVajl6VtbG1jUnQ4CqL7HZOAf1
+wJCHsykgKGTZ4ETkYMeW4ZTLFxSQVIa33XpdQ7Saa1lIkIKXKZ8nB6Zi6PF
t83tGtPgj+vimHO6XCxlh715Mv4NMOy2z4nxy0NW4Lb3WxkysGdNDARdyMOm
ygTXiGYZiE9n1S2wUyAlbu9/sycDlAPD58YoBR6Xv9/JNskE7oTn0NwZBY4m
CqQHtZlwTx8R7J+oxBWfL6rvDM4Ck4t7jc8/U6Ike/2U8G0WlGqhfOhLElMt
tqFEnQ3D6bOC8FYS02hB2+195DC25gQx7JaPU1bpH2key6G6zvpstTYfj1so
/YOzckAnPNzBtC/AJOtyt5vOuVAyrXE3URZg6tCJ8/Obc2HNoSvN72YL0DvO
VjMoyIOD1doS8/hCrJE2sH6YzQOTlUn7Zx4XYoDv1bgFRxUQJWKwbXaokN2b
StR4KEF47KdcfoMKdcxcE267El5crhEFNKpQ+72B97NOJYQ/ruOtu6FCUZst
N0GnBLRrWj/dosJNBVZu6jtKsCi7/7C4S4XXWMtqu/uUUFM1s/pJrwr5c4Yb
A0eUMNbK7tj9QYUFteoPq2xJEAyE1PpNqrDou7K+muUk9BnzitdOq/CpeKXm
sxUkRFW4e6XRKCQe7X4WxiBh+0ufhUFGFM461Too1pFAj+dc1JtSWLTul7IB
XxJ6Znae+XMhhdH3JnpF/iQUqkJLesworAqnJqaYJBjU8PIazCnsetn0fPEX
JAyOR0fkL6GQbDGVbAkloTz7AEe2lMKJqYEn7eEk7LGKYyZaUYjzLRy5PBLu
bhR+GrGMwpeVzGhBJAn57QmObBsKxW0c/kgUCcxwgu5vS6Gsu2KzJJoE2iux
uRedwsOFvtOGB0ioT5EYuS6n0LqLUVEQS8K/CVQ2eA==
          "]]}, Annotation[#, "Charting`Private`Tag$12171#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \\\"t\\\"],FontSlant->\\\
\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)/s)\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{336.65, 1030.793}, {0., 0.014221764793925508`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Coefd = 1\"", "\"Coefd = 5\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->459637248,ExpressionUUID->"342cea27-9ca2-4143-845d-0e533b835d60"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fe8e31a5-91e1-4776-b4a0-3a9b3a0b74ef"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"943597b8-388d-4865-8ed4-a828a283c4d2"],

Cell["\<\
It is possible to combine several coefficients in the same function\
\>", "ExampleText",
 CellID->12431897,ExpressionUUID->"d6ccf73d-ca9c-4b0f-b6ef-62b263a08ef0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
     RowBox[{"DtK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"Coefd", "->", "5"}], ",", 
       RowBox[{"CoefN", "->", "0.8"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Coefd = 1, CoefN = 1\>\"", ",", "\"\<Coefd = 5, CoefN = 0.8\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135717584,ExpressionUUID->"13c81913-4808-4fde-9ba0-b3d9fdd7dfb7"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVyX0w1AkYwHHhbCxtrtjNS3qh0tW5dCTn7nm8XpGSlt1C4bLUelmylkWs
ZVl+a3/jZpqGIvJWtHtScXTnpebUEQq9KSO57coqx6i9wbruj+98/vhujEwI
jNLV0dHx/9z/brR053OM+DhfteRpwmBC1R8VKf0mfCzRVWqqNjDBNkkrcDbl
4/cmD2b22jNh2/12oQGDjzdS265yXZnwtcA5u9aOj6VZbPexUCa4Dn1VpEI+
enaeer5cyQRmkXklR8BHd8X1gd07g0CyMNXHmeRjQLrCjf1jMIRVBvN+G0zB
+1XgZ3CbDRfVqQ2nrwlQHD9FH7AMgfKSoLY7ealozs6nOIjDwFT7z9ozvDRs
O9oeybMIh+lVPpQ0PyHW9hzcNMOJgO/+Ouo94pKOjPP0cwGjkeBnvo31cmMG
6rW+eVkWdBLuqq/puC1kYJaH44cT3VGgLJibn1Fl4k0KkyBCokHvz5mcxe6z
eH1lO31JFQMMTv3r5tIsXNfkNzguOA2Dr2n3wj2yMXaM8GS5xsK+6K3vSpTZ
OOxKt+mfjoO0B+sdZ+xEGFhckTD7OAGoEXM/bS4VYa3xnFH6JA8O91x+JTLI
QRuxJvnRcCIErP42j5qRg3W2n1hJE0mgv+NScufbHFxwP9AgVp2BxO1q6aVw
MbpyFZoIQz5AsJk0eESMQ6KgxSmHFOhiWgzv8cjFrNGumjhfASw6LXt5teYi
tVLq25GbCuq3HSsytuQhqejf5duUBm69YfXSkjycOW6joo0JwVs+mtxNkaB+
KfXX89szQG+Lk2wLX4ITurtHbTmZIKyI7705JcGl9TWp9K6zEOiTN2cRno9v
aOkTGuNsGOsQRDf05aPy8ooItjIbNlv5roj2KECLau1QR7gIrP00Kv9fCrB2
og49KTkgqBPfMrKS4v0Bs5JVDTlQqHrfMEtK0c/fe9IqTAyBGqfpL7RSVDx4
47BPLxeG1KFMr+RC7Hia9GRXSy4Y3jhBUUwUogHXfb77eB5U1EP19MEiLPmh
bi9fVwLvs5Y57LtFaLDSc9GhWQKz9mX897sI7Bkq2+/EygflLfOrynoCjdT6
RoOUAujjJdzzsZahsEXX+UNzAZQvXXY0LJRhTcpD+/1HpGAf19r9cVmGmdYM
oUIrhVPK+nJafDEOxL7gsi4WgqFNyknts2J8NUHv/HlPEUQmbg5gHJLjpyN9
xbEvi4B3rjE/7LYcm7mPaHdSCJhsaUr0/l2O70bCLsamEcB+ditkZ6ccPc2P
0cwzCECrLoelO3KM76+8FCMiYHXVyJMLvXI0SmalGhMENF3Tbn3xXI5O5o0L
BysJmL0bcO/Yv3KUVDw90NFLAEcVdN1jQY6zXpToqH4CRikhF7YvyZHWKI+i
PiQgssbRJVOHxHbfBhrrMQG+f7sZ++uT2DK5SJ8eJ8Ai/vANNZXEZ8H5mjUf
CRjWHrkybkxiXAyV3aohoFgeXD5sQmK56XhZ6AIBuk0hBbdpJFK/TBus1pHB
u7moUGINiXZJIdO7qTKozo05nL2WRNPRoIQnJjI4bsb1STYj0WvgwohwtQwe
OfO+CaWTWBy36lCXmQyIniS7AAaJV2xdIk8yZODD5lt4rSMxXNR4lGIpA523
ApqLxedvwnW6ai2DtjSh/g5LEl8xz8wf2CCD/wD8UDeD
          "]]}, Annotation[#, "Charting`Private`Tag$12924#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVxX08lAccAPAjL6Fctlw6b58656Wkl8+SlfX7TdiW95ekeU05JerI4xDh
3PO4Oy/3fGy1XoRCO7N2UxHpzUuxSRGmF5qSkzoy0jRv2/74fr6rIo74Rqoz
GAyP//z/KuMvCZ4ugaepLn7nuBtcuFec+GApgbdquT/EzrmBRfy8wN6AQEe7
8W49XXew/q0+RcuIQL666oQnxx3sBPYZF7kEyndkW47ucoetXWtzlEigMK/V
Lb/eHfxzWOd5AgJbSGOtMLEHUDNv7/NeEWjXZBhvZ+0FIecD+Dc7EtG5Ij3r
6X4fOKdKqoy+JEBLc5/yYSs/KCrYdb2JTMIh5iSXNeEPBvN/LT/KT8bHk4xa
7lQAjOq7aie7pWCrhi5n5XAgbBva49LjcAzzuTwxmxUEbizr3f2rUvFsRbrW
Nq8QaFZdYjjOpOJu3yssTSIMFOLJqXFlGq6fen9677twWPT7uHC28TjG3oy5
5seOACOefPDKmXRU9N9a3PLNPugYZLaGO2Xg3YPHyq2K98PXUVZvChQZyN0b
eo4ciYTkdrNN49xM5LzePvtPcBTo7Z3cxzmTiWHTiWPi3gPg01L6IlNLiKH8
npbPXaLBe9lnpF6qEIdLIkwf/HkINGxLEu6MCPGs+alwi5hYiFujkpSEZ2Hi
VzWmjVZHAAIMJQE9WUiI1RgVCXxo8Gd3b3ESYayNIjnaPQ5mNy84O9eK8J5Y
ISlzjAfVyG21VEsSpU0Wa4Wrj4JjW4hcUkCiLKmhq3pxArjIniU0alMopEYL
orQJWGS5Oc+SoLBdk2G04yMBKcWH26rfUtjY3/4yfJEAfF3JSXZ4NpZ3zHEM
lyTB89uCqMr72RjVe/kRpZkMHJOdalFOYhzjixaAlQKmbtNKj1/FqBo4oIhi
HQPBj1k1uiYS3KOIiZZ8kgpS5VjlBC3Bq32hzW0WaeA7vXlUc16Cumze7mGL
49ClCvZ3TpCifOaPuqCt6aBzNUz7l5dSzB/T6iLMMqBYDmWjnjn4MG6jqrMw
A8bSF3iBzTlodjKyx5ObCRM2Z4mxjbn4uq7BWLcsExQ1rJ8U8lxsEmR65dkK
4T7/SKuraR7mpOkoL1YJoWiudJOONA+r14fNvLHNApvY2sYPC3k45WKiL63K
goMKeRHzcD4WtsToB9iKQMc8cf/8k3yUOHjb15eKICKO423kJcOD0jqb1RYk
8E/+nB1yQ4YdWnp1fWdIeHWtKs7llgw3HF2RqCokIfBJTdC6OzI0EA2ZzhaR
gCYN6+eaZFgw2LDOuJSEZRd6egvbZBhqFOQZWElC1aV5q76nMvyijVnwoJ6E
iWbv1m8/ynC6vM24so8EnnLXZacZGSqVA3a1z0l4ph1UuGZOhn/3fG97d4CE
iPJNDmkMGq2ru4efvyJh52vHJR4aNG7nnwoxGCWBfdjnqkqPRi+Bn0v8HAnd
834VA0tovN7Zp3Z8gYR8WUBR91IaxVum5BI1CtSrgsQ3mDSu2/ewpkSTgjeT
kcG5n9LIt2N2ti+loEx0wCdjOY0n2j+8eMykINTwkGuCIY3qBrz+QQMKHtnz
NwSvoFEy1PvdR0MKclviud5GNEZWPPbUMKLANZBgO6+kEQUh7/XZFDBGBEwH
No02hyJFK00ouJ6comFrTKPPhXfzHDMK/gUa0jhs
          "]]}, Annotation[#, "Charting`Private`Tag$12924#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \\\"t\\\"],FontSlant->\\\
\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)/s)\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{336.65, 1030.793}, {0., 0.014221764793925508`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Coefd = 1, CoefN = 1\"", "\"Coefd = 5, CoefN = 0.8\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[1]=",
 CellID->21036076,ExpressionUUID->"b5e51310-7fae-4931-8d61-3e1ee38262e4"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"0251d5bd-b480-44d0-9c9a-2198908a7587"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"e9d92928-fbb5-4f8b-a47f-0b88f0aaddee"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"34621fde-e4a6-4a52-a896-56e6b0288f27"],

Cell[TextData[StyleBox[ButtonBox["CoefN",
 BaseStyle->"Hyperlink",
 ButtonData->{"CoefN.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->139279649,ExpressionUUID->"5a5e86ec-21e7-4439-b4af-b7c9256d6d11"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"0e5c57c2-e347-42e0-b46f-d01a7765b93a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coefd",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 8.9212984}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Coefd Coefd is an option for NdNtcVapK, etalK1atm, etaK1atm, DtK1atm, \
etalKVap, etaKVap, DtKVap and u2lVap functions that allows the dissipative \
distance d to be multiplied by a numeric constant. ", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "Coefd", "titlemodifier" -> "", 
    "windowtitle" -> "Coefd", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/Coefd", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"b55efa39-8594-48b1-a705-db1834b7d546"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7393, 206, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f922b09c-d0a3-4120-be54-bbbd0f47b38d",
   CellTags->"PrimaryExamplesSection",
   CellID->362203934]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46885, 1071}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 3620, 83, 53, "AnchorBarGrid",ExpressionUUID->"a3eaebcc-0e4c-4553-b992-2a8babe18ead",
 CellID->1],
Cell[CellGroupData[{
Cell[4222, 108, 390, 9, 54, "ObjectNameGrid",ExpressionUUID->"f0178903-dfbb-4795-8934-42d0c2e1c26a"],
Cell[4615, 119, 1645, 51, 134, "Usage",ExpressionUUID->"80d7b67d-78cf-430d-86c7-4c7e276f22de",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6297, 175, 855, 21, 37, "NotesSection",ExpressionUUID->"c9483b0c-d171-408d-8174-e8ec25d76cbe",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->336287749],
Cell[7155, 198, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"30286011-1699-442b-9278-b0ae2cd379ff"],
Cell[7244, 200, 112, 1, 70, "Notes",ExpressionUUID->"129f4073-7293-4579-bae4-4ce1814b146b",
 CellID->544296333]
}, Closed]],
Cell[CellGroupData[{
Cell[7393, 206, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f922b09c-d0a3-4120-be54-bbbd0f47b38d",
 CellTags->"PrimaryExamplesSection",
 CellID->362203934],
Cell[CellGroupData[{
Cell[7853, 221, 307, 7, 30, "ExampleSection",ExpressionUUID->"5f64954c-b613-400e-a1dd-62b306d9eabb",
 CellID->27923865],
Cell[8163, 230, 175, 3, 27, "Input",ExpressionUUID->"d95d0baa-9974-4454-930c-09862ff1bbd4",
 CellID->87419684],
Cell[8341, 235, 240, 6, 38, "ExampleText",ExpressionUUID->"c4a2e8cb-17f0-4904-91b8-235d9cc7ba56",
 CellID->119396994],
Cell[CellGroupData[{
Cell[8606, 245, 281, 6, 44, "Input",ExpressionUUID->"191a0cf6-59e9-4f52-84b5-428c327d02d7",
 CellID->614342864],
Cell[8890, 253, 144, 2, 36, "Output",ExpressionUUID->"3c5f8344-2c31-482b-b554-c7c6a0be5f1b",
 CellID->760889583],
Cell[9037, 257, 143, 2, 36, "Output",ExpressionUUID->"844cddac-1f1a-46c0-9c35-331ffc5d7212",
 CellID->48277805]
}, Open  ]],
Cell[9195, 262, 263, 5, 57, "ExampleText",ExpressionUUID->"c3d356bf-469a-4978-a7b3-0bbd6bcb05b5",
 CellID->168920797],
Cell[CellGroupData[{
Cell[9483, 271, 952, 24, 67, "Input",ExpressionUUID->"3f043913-dec2-45d7-afab-e9f5e41a8b02",
 CellID->562653754],
Cell[10438, 297, 15988, 324, 250, "Output",ExpressionUUID->"342cea27-9ca2-4143-845d-0e533b835d60",
 CellID->459637248]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26475, 627, 323, 7, 70, "ExampleSection",ExpressionUUID->"943597b8-388d-4865-8ed4-a828a283c4d2",
 CellID->1020263627],
Cell[26801, 636, 172, 3, 70, "ExampleText",ExpressionUUID->"d6ccf73d-ca9c-4b0f-b6ef-62b263a08ef0",
 CellID->12431897],
Cell[CellGroupData[{
Cell[26998, 643, 1030, 26, 70, "Input",ExpressionUUID->"13c81913-4808-4fde-9ba0-b3d9fdd7dfb7",
 CellID->135717584],
Cell[28031, 671, 16007, 324, 247, "Output",ExpressionUUID->"b5e51310-7fae-4931-8d61-3e1ee38262e4",
 CellID->21036076]
}, Open  ]]
}, Closed]],
Cell[44065, 999, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"0251d5bd-b480-44d0-9c9a-2198908a7587"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44188, 1004, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"34621fde-e4a6-4a52-a896-56e6b0288f27",
 CellID->1255426704],
Cell[44451, 1013, 212, 4, 70, "SeeAlso",ExpressionUUID->"5a5e86ec-21e7-4439-b4af-b7c9256d6d11",
 CellID->139279649]
}, Open  ]],
Cell[44678, 1020, 78, 0, 70, "FooterCell",ExpressionUUID->"0e5c57c2-e347-42e0-b46f-d01a7765b93a"]
}
]
*)

(* End of internal cache information *)

