(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     47024,       1234]
NotebookOptionsPosition[     37626,       1033]
NotebookOutlinePosition[     40203,       1098]
CellTagsIndexPosition[     40086,       1092]
WindowTitle->DtK1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "9e92b5f2-e5e8-454e-aab0-64a266a838db"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"3a9ef27a-22f0-461f-8570-ee27c667a6ea"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaK1atm\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaK1atm.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4eefc0a3-a115-4ad5-9f2e-7e161a3c6005"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"7da6798c-2356-4457-928a-e48612eb64d9"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/DtK1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/DtK1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
DtK1atm.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$17636], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/DtK1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9ac01e46-89b1-49ef-885c-da435b83f3d9"]
    }], "AnchorBar",ExpressionUUID->"861982cb-03c4-4c9b-99f5-bd382ca3897e"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"f15ae83d-5d88-4c3d-b7c6-0269c304ae7c"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DtK1atm", "ObjectName",ExpressionUUID->
  "abda6747-514c-4a4a-b588-c4e5b29cfae1"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"b5472a07-705b-4993-94df-32c745105d32"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "e4af4712-a7bf-4d13-8526-457902ba8bad"]
}], "ObjectNameGrid",ExpressionUUID->"749f8b45-9215-421b-a220-5a8268fc019e"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DtK1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "19cdefde-64c6-4849-aa5d-9314a8118956"],
     " \[LineSeparator]Potassium self-diffusion coefficient equation of state \
",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["D", "t"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "68e4d1c9-f77c-4eec-ab2f-5ade38219491"],
     "(",
     StyleBox["T",
      FontSlant->"Italic"],
     ") as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"9e447989-a7c4-4832-8a15-1beea81fd7a4"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"f5887242-af24-4e47-aef4-f06afe22d3f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"c7f7420a-d0c9-4a32-8091-ac5c3f1c88f9"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"dc3c63f8-a674-4c44-8223-f8f1e7b666c0"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"737f5f60-c9c6-4f7f-8453-d6f0a4544c1d"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->2464170,ExpressionUUID->"a3d0319e-c122-4ff3-8cb7-c0609e430d27"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a038f88a-6de3-43a5-9809-9ff4f29b6ae7"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
 "1030.793"], "InlineFormula",ExpressionUUID->
  "ac38c29e-a3ec-4a03-a346-25242a30c5eb"],
 " K"
}], "Notes",
 CellID->206839001,ExpressionUUID->"4f063720-69fb-4569-b5fd-690bec6029fd"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->893946030,ExpressionUUID->"fea54703-0fc8-46dd-870e-408dee4f0a74"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["D", "t"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "c5473c35-79a6-494c-81dc-c6e4bced5ced"],
 " is ",
 Cell[BoxData[
  SuperscriptBox["cm", "2"]], "InlineFormula",ExpressionUUID->
  "178ad11d-2040-441c-a50a-fc69e5e9b4ed"],
 "/s but it can be changed by modifying the following option: "
}], "Notes",
 CellID->7613595,ExpressionUUID->"a3b84eea-c537-4e70-b585-8634a0bb46b6"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "a895120f-400d-4f62-93d5-2fe3f7cdffac"], 
    ButtonBox[
     ButtonBox["DtK1atmDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
DtK1atmDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], 
    RowBox[{" ", 
     RowBox[{
      SuperscriptBox["Centimeters", "2"], "\n", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", "\n", "  ", "Seconds"}]}]}]}]}]}]}]}], Cell[
    "Default unit for self-diffusion equation of state", "TableText",
     ExpressionUUID->"0c5f30c7-0874-44e0-b9e9-f32e3d5df477"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->426451392,ExpressionUUID->"598adc79-4491-44e3-ad48-4b748e50d685"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"381bb063-6628-4a24-b2bc-41fd2f26ea42"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "99b6e215-78f9-4115-b087-1476cd601c84"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "1d4bdfda-c8ce-407d-80cf-19b0f5243923"]
    }], "TableText",ExpressionUUID->"d9cee8d8-5d7b-4c89-bcb2-38899daf210d"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "baccdb6e-cc1d-45e6-a2ab-7ed7f114e2b9"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"67c74eea-e8a3-40da-b60a-362fc9ec7b02"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "2dd0fde0-169a-444c-b566-041175f07fa1"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "7b57b9f8-264c-4800-a65b-8e692f14fa44"]
    }], "TableText",ExpressionUUID->"8eed4c64-06d3-440d-a65f-a73fc6fbc700"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"b4709007-9729-4799-b107-4ed42682a931"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"f50fe1c9-17af-4a3c-9675-c3248fe029f7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"0f555e7e-3e39-4fbc-8198-a553cbcb4131"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "e40854db-a732-43fa-bcad-027b0451bab1"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->126698263,ExpressionUUID->"6175b75d-50db-4e4c-b736-deb190459e50"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6913e16b-8a6e-47a3-8a17-60f200ff0c76"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->169885752,ExpressionUUID->"6f9689d2-7ace-4fd7-8fbe-1808f58aadb4"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"0c73e8f6-0464-4648-ad7f-6c67ced1c61e"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"8769e804-9368-427a-8c92-4ae8c7c8f67e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DtK1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"TmpK", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"e6411165-05f1-44f6-ac2e-8a245fb4c60c"],

Cell[BoxData["0.0012264373892843536`"], "Output",
 CellLabel->"Out[2]=",
 CellID->262767065,ExpressionUUID->"7f9c8394-d317-488a-b749-bf009e34fc24"],

Cell[BoxData[
 TemplateBox[{"0.0012264373892843536`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->7676531,ExpressionUUID->"ef68e65b-8898-466c-a0f3-aa4a7fe59b7a"],

Cell[BoxData[
 TemplateBox[{"0.0012264373892843536`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->54437051,ExpressionUUID->"5ef04eec-c9f3-4604-9e90-d8df5b98d383"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.0012264373892843536`", ",", 
     FractionBox[
      SuperscriptBox["\"\<Centimeters\>\"", "2"], "\"\<Seconds\>\""]}], "]"}],
    ",", 
   FractionBox[
    SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""]}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->652464796,ExpressionUUID->"cdb743ce-a4a6-4b1e-9e9b-df00ce8bccc2"],

Cell[BoxData[
 TemplateBox[{"1.2264373892843535`*^-7", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->64100444,ExpressionUUID->"0584a3b8-1d91-43af-ada9-a02e55be18c5"]
}, Open  ]],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["D", "t"],
   FontSlant->"Italic"]],ExpressionUUID->
  "4ca14329-2ecc-4b24-b8ff-3fe6d6ff4a1a"],
 " from the melting point to the boiling point along the atmospheric isobar"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"c0b0b51b-0b5c-4bc5-8c90-c394b661e88f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"DtK1atm", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->562653754,ExpressionUUID->"f7d45ed4-8c89-4ed3-9de5-668ab908ef71"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVyX0w1AkYwHHhbCxtrtjNS3qh0tW5dCTn7nm8XpGSlt1C4bLUelmylkWs
ZVl+a3/jZpqGIvJWtHtScXTnpebUEQq9KSO57coqx6i9wbruj+98/vhujEwI
jNLV0dHx/9z/brR053OM+DhfteRpwmBC1R8VKf0mfCzRVWqqNjDBNkkrcDbl
4/cmD2b22jNh2/12oQGDjzdS265yXZnwtcA5u9aOj6VZbPexUCa4Dn1VpEI+
enaeer5cyQRmkXklR8BHd8X1gd07g0CyMNXHmeRjQLrCjf1jMIRVBvN+G0zB
+1XgZ3CbDRfVqQ2nrwlQHD9FH7AMgfKSoLY7ealozs6nOIjDwFT7z9ozvDRs
O9oeybMIh+lVPpQ0PyHW9hzcNMOJgO/+Ouo94pKOjPP0cwGjkeBnvo31cmMG
6rW+eVkWdBLuqq/puC1kYJaH44cT3VGgLJibn1Fl4k0KkyBCokHvz5mcxe6z
eH1lO31JFQMMTv3r5tIsXNfkNzguOA2Dr2n3wj2yMXaM8GS5xsK+6K3vSpTZ
OOxKt+mfjoO0B+sdZ+xEGFhckTD7OAGoEXM/bS4VYa3xnFH6JA8O91x+JTLI
QRuxJvnRcCIErP42j5qRg3W2n1hJE0mgv+NScufbHFxwP9AgVp2BxO1q6aVw
MbpyFZoIQz5AsJk0eESMQ6KgxSmHFOhiWgzv8cjFrNGumjhfASw6LXt5teYi
tVLq25GbCuq3HSsytuQhqejf5duUBm69YfXSkjycOW6joo0JwVs+mtxNkaB+
KfXX89szQG+Lk2wLX4ITurtHbTmZIKyI7705JcGl9TWp9K6zEOiTN2cRno9v
aOkTGuNsGOsQRDf05aPy8ooItjIbNlv5roj2KECLau1QR7gIrP00Kv9fCrB2
og49KTkgqBPfMrKS4v0Bs5JVDTlQqHrfMEtK0c/fe9IqTAyBGqfpL7RSVDx4
47BPLxeG1KFMr+RC7Hia9GRXSy4Y3jhBUUwUogHXfb77eB5U1EP19MEiLPmh
bi9fVwLvs5Y57LtFaLDSc9GhWQKz9mX897sI7Bkq2+/EygflLfOrynoCjdT6
RoOUAujjJdzzsZahsEXX+UNzAZQvXXY0LJRhTcpD+/1HpGAf19r9cVmGmdYM
oUIrhVPK+nJafDEOxL7gsi4WgqFNyknts2J8NUHv/HlPEUQmbg5gHJLjpyN9
xbEvi4B3rjE/7LYcm7mPaHdSCJhsaUr0/l2O70bCLsamEcB+ditkZ6ccPc2P
0cwzCECrLoelO3KM76+8FCMiYHXVyJMLvXI0SmalGhMENF3Tbn3xXI5O5o0L
BysJmL0bcO/Yv3KUVDw90NFLAEcVdN1jQY6zXpToqH4CRikhF7YvyZHWKI+i
PiQgssbRJVOHxHbfBhrrMQG+f7sZ++uT2DK5SJ8eJ8Ai/vANNZXEZ8H5mjUf
CRjWHrkybkxiXAyV3aohoFgeXD5sQmK56XhZ6AIBuk0hBbdpJFK/TBus1pHB
u7moUGINiXZJIdO7qTKozo05nL2WRNPRoIQnJjI4bsb1STYj0WvgwohwtQwe
OfO+CaWTWBy36lCXmQyIniS7AAaJV2xdIk8yZODD5lt4rSMxXNR4lGIpA523
ApqLxedvwnW6ai2DtjSh/g5LEl8xz8wf2CCD/wD8UDeD
       "]]},
     Annotation[#, "Charting`Private`Tag$11692#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \
\\\"t\\\"],FontSlant->\\\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \
\\(2\\)]\\)/s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {0., 0.014221764793925508`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->575577821,ExpressionUUID->"856a2482-cabd-49c6-b843-2863fb2779d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "538a2e36-4d6a-4b95-8b9a-4ed244142a28"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"69da432f-6451-42e5-949a-2d57a4776a9e"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["D", "t"],
   FontSlant->"Italic"]],ExpressionUUID->
  "c545d63f-da75-4e36-b295-8f21a6545e57"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "6af3d23a-7974-4fd1-bc2f-7c5c81dabbf3"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"0db79a45-9f62-4b8c-8aef-abafc26f96be"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DtK1atm", "[", 
   RowBox[{"Quantity", "[", 
    RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"With", " ", 
    RowBox[{"Hsieh", "'"}], "s", " ", "parameters"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Coefd", "->", "5"}], ",", 
   RowBox[{"CoefN", "->", "0.0540234"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"7156ee39-9087-4407-879d-3f96a418db4f"],

Cell[BoxData[
 TemplateBox[{"0.0012264373892843536`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->218184096,ExpressionUUID->"014251f4-0f5b-431a-9f12-6851f6dc30bc"],

Cell[BoxData[
 TemplateBox[{"0.00007564366544589707`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->10482446,ExpressionUUID->"9d909d8d-cc5c-42c4-980b-7864748c60e4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "472c39db-d841-48c2-8aff-ada62725de56"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"a0812f27-7144-45b1-bb8e-541ab45daf71"],

Cell[CellGroupData[{

Cell[TextData[{
 "DtK1atmDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6de9270d-4770-4325-a3dc-b166221a9e1a"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->250107433,ExpressionUUID->"8cc40ff9-7c5b-4639-8dc7-08f69ae5c1ff"],

Cell["\<\
It is possible to change the self-diffusion coefficient default unit by \
setting a new unit to the option parameter \"DtK1atmDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"4f8f47ef-7ac9-4e26-9bb1-c14bc716fd3d"],

Cell["Individually:", "ExampleText",
 CellID->269922393,ExpressionUUID->"5fb81750-fa33-4540-9c78-3e2bdfdfa654"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DtK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"DtK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      FractionBox[
       SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138036825,ExpressionUUID->"8d4cfc08-7729-46c6-b866-891cf58d3250"],

Cell[BoxData[
 TemplateBox[{"0.0012264373892843536`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->500353726,ExpressionUUID->"0b95b912-bb5f-4f43-85f0-3b4d3510c038"],

Cell[BoxData[
 TemplateBox[{"1.2264373892843535`*^-7", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->291952055,ExpressionUUID->"0e71c09c-132e-4ec8-be36-88369e1903ea"]
}, Open  ]],

Cell["Globally by using SetOptions:", "ExampleText",
 CellID->195019342,ExpressionUUID->"007d953a-b7ae-4b5d-8e58-ec070d665981"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DtK1atm", ",", 
    RowBox[{"DtK1atmDefaultUnit", "->", 
     RowBox[{"QuantityUnit", "[", 
      RowBox[{"Quantity", "[", 
       FractionBox[
        SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""], "]"}], 
      "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"TmpK", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->110075696,ExpressionUUID->"a662d9a8-2d24-4554-993a-af086664f0da"],

Cell[BoxData["1.2264373892843535`*^-7"], "Output",
 CellLabel->"Out[2]=",
 CellID->114332878,ExpressionUUID->"5e34a509-9c1e-40a5-84a9-455956c671bf"],

Cell[BoxData[
 TemplateBox[{"1.2264373892843535`*^-7", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->458085432,ExpressionUUID->"3faf9e74-cf1f-49a4-bf4b-a0f5a4d13de5"],

Cell[BoxData[
 TemplateBox[{"1.2264373892843535`*^-7", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->497080554,ExpressionUUID->"66c153d3-16f9-41b8-82da-3b177ca7cca2"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2aba677f-7786-4253-aacb-895f12ca4efa"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"9f772af6-c1ac-45ea-b52d-82fb467872d8"],

Cell["\<\
Comparison of Hsieh's data (black points) with the theoretical model (blue \
curve) along the atmospheric isobar\
\>", "ExampleText",
 CellID->101130033,ExpressionUUID->"b57dd21e-1b4a-45e9-8b1a-9b0f9bc5341a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"elf", "-", 
    RowBox[{
    "diffusion", " ", "Coefficient", " ", "data", " ", "from", " ", "Hiseh", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "5"}]], 
       RowBox[{
        RowBox[{"cm", "^", "2"}], "/", "s"}]}], ")"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"TabDtHsieh", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"342.93", ",", "4.8546"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"376.79", ",", "5.1751"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"374.99", ",", "5.7092"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"412.8", ",", "6.0297"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"420.92", ",", "6.1365"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"419.31", ",", "6.8843"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"472.45", ",", "9.0208"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"471.02", ",", "9.7685"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"520.19", ",", "10.623"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"518.89", ",", "11.264"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"514.96", ",", "11.905"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"518.89", ",", "12.226"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"597.71", ",", "17.46"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"598.84", ",", "16.926"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"687.27", ",", "22.481"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"775.22", ",", "32.309"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"776.09", ",", "29.958"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"776.09", ",", "28.57"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"864.4", ",", "38.825"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"865.19", ",", "38.077"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"865.97", ",", "36.902"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"345.38", ",", "4.0587"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"345.73", ",", "4.4297"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"345.73", ",", "4.5343"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"376.37", ",", "5.2153"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"376.37", ",", "5.3696"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"417.98", ",", "6.5089"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"418.49", ",", "6.3219"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"420.02", ",", "6.8596"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"455.03", ",", "8.0292"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"471.88`", ",", "9.62`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"472.53", ",", "9.1282"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"517.29", ",", "11.526"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"521.21", ",", "10.685"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"522.", ",", "12.29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"598.26", ",", "17.336"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"598.26", ",", "17.745"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"689.38", ",", "20.77"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"774.77", ",", "28.791"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"774.77", ",", "30.52"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"774.77", ",", "32.164"}], "}"}]}], "}"}]}], ";"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50387751,ExpressionUUID->"5f0fb1a1-a0e3-48be-91b9-1311151f2f79"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Coefqc", "=", "0.793522"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["10", "5"], "Coefqc", "*", 
    RowBox[{"DtK1atm", "[", 
     RowBox[{"T", ",", 
      RowBox[{"Coefd", "->", "5"}], ",", 
      RowBox[{"CoefN", "->", "0.0540234"}], ",", 
      RowBox[{"CoefK", "->", "1.21108"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "900"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SuperscriptBox[\(10\), \(5\)]\) \!\(\*StyleBox[SubscriptBox[\
\"D\", \"t\"],FontSlant->\"Italic\"]\) (\!\(\*SuperscriptBox[\(cm\), \
\(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"Point", "[", "TabDtHsieh", "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->354445143,ExpressionUUID->"371512a6-c786-49d8-a619-da65f583ec42"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVkWs4lAkARiMtwowalVnk1kyKFTFEhtfMl0YXIiW3XUuhXKNp0LiNcRnf
p20r2Z5VTKsUKZEKDZ6QFMu28SiJNjbVZrNRLlu2/XGe8+P8PMYhsd77lBcs
WLD9C/9b5dSh+LDFQrDZb4a7d9DAlwSx1moJMRmpcfliIA2SGLf+t3Qhjt2u
XJsZQcO8m66zcJkQ/T7Vrtx0GmY/NqhLjYQoLQn4re0qDe/8FsrldkLsIwe2
mdHpGDQ43v00RAhqRh5l3U3HjfNXLXY2CBGmNh7IKtdGjUH4FeMjh3Fy8PGc
T8BSsI6nujhaiqBa/ENk6ScGPrPL47sHRfBeY65xonQZTFZ5R7sVJWKrSVJF
RcoKNBj4i1Q9knB6zzdl1wgmitOeCcppycgmyZQa6OG1kuh2x4NkOHcEO3Xw
DFCeHutiIz6CLIXrRn8rQ9SGj8hSN4rRE+FVfaHCCJytdS8Y42KccXrskHDd
GPqe54ZYZ1Lw4ODtsZgmE3g0qP7CDEjF3L2G6SuvTDFl2iX01UzDW17Brx5q
LLycpGmLOtOwxJ/dGCFgwyhh/QUZkQ6nSxr8DGo1VA9odYqL0pHUPLr6UYsZ
dAou9A7PpcNBb/nEJcO1CGj8+89XPhko89R1ZcaYo13v40BobQaWqIbX+r6w
QLhMzURfR4Izrad3jgdagjfVEZsUJQGidn2wa18HXoG7fHOnBFXm9KfJlVZI
sUl6Us/KRKzlp2eMWGu8eV69NyolE35PgsVF1uuR1lr+8OjTTGRHt5g8UbfB
9vPegt0cKeSKe+J9/TZwrb8lP1oghfnodBtXYYuIIbNtiyaleJ7Wklh/joP7
yu6fjbZlgVHmcLZfbAcv/9UnKyuy0BRzf1VetD0YVbXWQyrZWN97arTPawPU
lnsYeQZmI2K0ZX+TrQNMq0r/WdeQjcu6uf76lo5IFFR01jJysHfiUl8YcyPe
68TlXU7IQY/nV5kzXzvh4tCIp6ArB2F652wztLj4sT40zISVC5+bFb0D/3JR
3FESHC3NxXVdxcNXSi4Y68sPCRrMBc2iyL3wgwt26zoIGrky3FFUX/myBdP7
x1ODimRo0unw0l7oikd1OxXySRmiZ7ua1qS4oo8rGtrtk4dC2WtOlhIPS5u3
qF+rzMORKfuTE2IeJN5mUvdFJGbanY7VTvGwgtn6h/deEnc3HGoKTuTj5SDd
XUlBIiEx687IBB/akt/5+Y0k4lec9VGe5MORXejMbCZx78bWQcMPfFAxK22t
W0jsYHs+9J/lw2rewvD7DhJjbb5bepQJJBttmWruJaGyWBJdxyCgGSqVp4+T
mE+L9JNyCHBUBUWa70gERXjVlNgT+LZCo/CnCRJuZXoLFQ4Eqt4fp6omSbwZ
3Cyd4hLYJZWLhmdJFHcd0AxzI3D2fON2qFKoi3Fdt8mXQLu7RNCpRmGz9eRI
sB+Bd2838fcspiBPsj8mDiDAt+vaEKf1pdMD2mu+IzB2d8C0hEGhVTfnpnEE
gSWRxSstllHIb7Zkcg8QcKSHMm8tp/CXkXPcnigClO9rWg+TwvBA2uejcQRq
5yrVA/UoWLEvcsrjCTwrPqgypk8hSG1VSNshAmoEZz5hJQW/jPHM4cMErMem
Z+YNKTifUP55LpHAf1ksIQw=
       "]]},
     Annotation[#, "Charting`Private`Tag$19076#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0},
  DisplayFunction->Identity,
  Epilog->PointBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQXS2yzv1hXqlD1VIdZ5lsYYdCW67ri3vKHfzlxLJ8
N4s4LCkACuSXO3z1imyzuCbmcPYMCFQ6nDrstDZTTsJBvvV14A6/KodNc98v
P9Yt4aAZ03/oq0mVg0tm/ofWTmkHYxBor3Wobtb3Wcal5LBDDqihoNZh2+e/
Vyo6lR3eBAJFHBscnl5Quv3TTtUBZJyceYPDLk8eJu12NQePh1Ui68QbHICm
asScV4fLHzy10HVbsQZEfm2TwzcNoMWlhhD3bGtymCzBEsb31sAB5ByNqlYH
pwSgDdVmEHWWHQ4p1vf9e9UdIOodOhwyJr6tsf9qC+cHgRw60QbifuZuh1kz
gSDTGeJezm4HkHG3OZ0h5vF3O/yqy9pTUuzkAAzNKpFppQ7nJANvSdsIQNw3
u9QhJfaOG/MOQTj/HhNnl7yyEMSe1nKHjQHZs8rviMD5XBlKORVVohD18lUO
l/c8FpHllILEh3qVQ2JIkPoCT0lIeDpUOTBMrPttVSDtAIrOqoIaB1D0feZT
gLinrtYBFK0FtsoQ+Y5ahyMb9fIWO0LjQ6vBIQoUILzqEPs8GyDhEKfqwAAC
AQ0QfVM0IOZtanLYUwIKYUM4H6x+n6EDyBau7lZIPB01gYS/WYfDRWD01p2y
gfPB8q12cP4iV2CKEHFwAAD5fBqb
    "]],
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(5\\)]\\) \
\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \
\\\"t\\\"],FontSlant->\\\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \
\\(2\\)]\\)/s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 900}, {0., 40.94517839074841}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[2]=",
 CellID->301265295,ExpressionUUID->"62f9bdcc-cd40-43ea-8676-cc7ce9d15ad9"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"86f1f1f3-7a6a-48a9-a25f-ef88adf81d9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"3b43fba2-dd42-4ce2-9d48-a5050c0d212c"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"18dbb8bf-d6db-4dc2-8bb0-f7caab9219fd"],

Cell[TextData[StyleBox[ButtonBox["etaK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->139279649,ExpressionUUID->"95184189-5708-45a6-9ac4-bac35788cf0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"10ff4d00-d330-4b4e-9647-600e5e8f9c6d"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"770424b1-1239-4f64-a249-6ff2d60c8f07"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"95ebd513-7207-47e9-b978-9080b3fc7289"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "adb80655-cb13-40c6-964e-192bc076a0d6"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"55b9ea6b-4d01-4d14-a2a1-be782c6e7abf"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"9939ea5a-609e-4a8b-aee5-571233c3e1cb"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DtK1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 15.1362993}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "DtK1atm[T] Potassium self-diffusion coefficient equation of state Dt(T) \
as a function of temperature T along the atmospheric isobar in the liquid \
phase", "synonyms" -> {}, "tabletags" -> {}, "title" -> "DtK1atm", 
    "titlemodifier" -> "", "windowtitle" -> "DtK1atm", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/DtK1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"839527db-e866-40e0-9f26-ad7f01406930"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10903, 298, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6175b75d-50db-4e4c-b736-deb190459e50",
   CellTags->"PrimaryExamplesSection",
   CellID->126698263]},
 "DefaultUnit"->{
  Cell[22188, 613, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"8cc40ff9-7c5b-4639-8dc7-08f69ae5c1ff",
   CellTags->"DefaultUnit",
   CellID->250107433]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39710, 1081},
 {"DefaultUnit", 39904, 1085}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 3645, 83, 53, "AnchorBarGrid",ExpressionUUID->"f15ae83d-5d88-4c3d-b7c6-0269c304ae7c",
 CellID->1],
Cell[CellGroupData[{
Cell[4249, 108, 392, 9, 54, "ObjectNameGrid",ExpressionUUID->"749f8b45-9215-421b-a220-5a8268fc019e"],
Cell[4644, 119, 935, 25, 134, "Usage",ExpressionUUID->"f5887242-af24-4e47-aef4-f06afe22d3f5",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5616, 149, 853, 21, 37, "NotesSection",ExpressionUUID->"a3d0319e-c122-4ff3-8cb7-c0609e430d27",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->2464170],
Cell[6472, 172, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a038f88a-6de3-43a5-9809-9ff4f29b6ae7"],
Cell[6561, 174, 407, 14, 70, "Notes",ExpressionUUID->"4f063720-69fb-4569-b5fd-690bec6029fd",
 CellID->206839001],
Cell[6971, 190, 193, 6, 70, "Notes",ExpressionUUID->"fea54703-0fc8-46dd-870e-408dee4f0a74",
 CellID->893946030],
Cell[7167, 198, 479, 13, 70, "Notes",ExpressionUUID->"a3b84eea-c537-4e70-b585-8634a0bb46b6",
 CellID->7613595],
Cell[7649, 213, 993, 26, 70, "3ColumnTableMod",ExpressionUUID->"598adc79-4491-44e3-ad48-4b748e50d685",
 CellID->426451392],
Cell[8645, 241, 127, 1, 70, "Notes",ExpressionUUID->"381bb063-6628-4a24-b2bc-41fd2f26ea42",
 CellID->46888620],
Cell[8775, 244, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"b4709007-9729-4799-b107-4ed42682a931",
 CellID->505732368],
Cell[10780, 293, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"f50fe1c9-17af-4a3c-9675-c3248fe029f7"]
}, Closed]],
Cell[CellGroupData[{
Cell[10903, 298, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6175b75d-50db-4e4c-b736-deb190459e50",
 CellTags->"PrimaryExamplesSection",
 CellID->126698263],
Cell[CellGroupData[{
Cell[11363, 313, 308, 7, 30, "ExampleSection",ExpressionUUID->"6f9689d2-7ace-4fd7-8fbe-1808f58aadb4",
 CellID->169885752],
Cell[11674, 322, 175, 3, 27, "Input",ExpressionUUID->"0c73e8f6-0464-4648-ad7f-6c67ced1c61e",
 CellID->87419684],
Cell[11852, 327, 298, 5, 57, "ExampleText",ExpressionUUID->"8769e804-9368-427a-8c92-4ae8c7c8f67e",
 CellID->544149791],
Cell[CellGroupData[{
Cell[12175, 336, 480, 12, 60, "Input",ExpressionUUID->"e6411165-05f1-44f6-ac2e-8a245fb4c60c",
 CellID->218515404],
Cell[12658, 350, 147, 2, 36, "Output",ExpressionUUID->"7f9c8394-d317-488a-b749-bf009e34fc24",
 CellID->262767065],
Cell[12808, 354, 409, 9, 48, "Output",ExpressionUUID->"ef68e65b-8898-466c-a0f3-aa4a7fe59b7a",
 CellID->7676531],
Cell[13220, 365, 410, 9, 48, "Output",ExpressionUUID->"5ef04eec-c9f3-4604-9e90-d8df5b98d383",
 CellID->54437051]
}, Open  ]],
Cell[CellGroupData[{
Cell[13667, 379, 454, 13, 47, "Input",ExpressionUUID->"cdb743ce-a4a6-4b1e-9e9b-df00ce8bccc2",
 CellID->652464796],
Cell[14124, 394, 400, 9, 48, "Output",ExpressionUUID->"0584a3b8-1d91-43af-ada9-a02e55be18c5",
 CellID->64100444]
}, Open  ]],
Cell[14539, 406, 338, 9, 38, "ExampleText",ExpressionUUID->"c0b0b51b-0b5c-4bc5-8c90-c394b661e88f",
 CellID->119396994],
Cell[CellGroupData[{
Cell[14902, 419, 668, 15, 70, "Input",ExpressionUUID->"f7d45ed4-8c89-4ed3-9de5-668ab908ef71",
 CellID->562653754],
Cell[15573, 436, 3730, 83, 243, "Output",ExpressionUUID->"856a2482-cabd-49c6-b843-2863fb2779d1",
 CellID->575577821]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19352, 525, 323, 7, 70, "ExampleSection",ExpressionUUID->"69da432f-6451-42e5-949a-2d57a4776a9e",
 CellID->1020263627],
Cell[19678, 534, 657, 19, 70, "ExampleText",ExpressionUUID->"0db79a45-9f62-4b8c-8aef-abafc26f96be",
 CellID->111367501],
Cell[CellGroupData[{
Cell[20360, 557, 624, 17, 70, "Input",ExpressionUUID->"7156ee39-9087-4407-879d-3f96a418db4f",
 CellID->138125379],
Cell[20987, 576, 411, 9, 48, "Output",ExpressionUUID->"014251f4-0f5b-431a-9f12-6851f6dc30bc",
 CellID->218184096],
Cell[21401, 587, 411, 9, 48, "Output",ExpressionUUID->"9d909d8d-cc5c-42c4-980b-7864748c60e4",
 CellID->10482446]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21861, 602, 302, 7, 70, "ExampleSection",ExpressionUUID->"a0812f27-7144-45b1-bb8e-541ab45daf71",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[22188, 613, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"8cc40ff9-7c5b-4639-8dc7-08f69ae5c1ff",
 CellTags->"DefaultUnit",
 CellID->250107433],
Cell[22535, 623, 246, 4, 70, "ExampleText",ExpressionUUID->"4f8f47ef-7ac9-4e26-9bb1-c14bc716fd3d",
 CellID->300166705],
Cell[22784, 629, 111, 1, 70, "ExampleText",ExpressionUUID->"5fb81750-fa33-4540-9c78-3e2bdfdfa654",
 CellID->269922393],
Cell[CellGroupData[{
Cell[22920, 634, 609, 16, 70, "Input",ExpressionUUID->"8d4cfc08-7729-46c6-b866-891cf58d3250",
 CellID->138036825],
Cell[23532, 652, 411, 9, 48, "Output",ExpressionUUID->"0b95b912-bb5f-4f43-85f0-3b4d3510c038",
 CellID->500353726],
Cell[23946, 663, 401, 9, 48, "Output",ExpressionUUID->"0e71c09c-132e-4ec8-be36-88369e1903ea",
 CellID->291952055]
}, Open  ]],
Cell[24362, 675, 127, 1, 70, "ExampleText",ExpressionUUID->"007d953a-b7ae-4b5d-8e58-ec070d665981",
 CellID->195019342],
Cell[CellGroupData[{
Cell[24514, 680, 806, 21, 70, "Input",ExpressionUUID->"a662d9a8-2d24-4554-993a-af086664f0da",
 CellID->110075696],
Cell[25323, 703, 148, 2, 36, "Output",ExpressionUUID->"5e34a509-9c1e-40a5-84a9-455956c671bf",
 CellID->114332878],
Cell[25474, 707, 401, 9, 48, "Output",ExpressionUUID->"3faf9e74-cf1f-49a4-bf4b-a0f5a4d13de5",
 CellID->458085432],
Cell[25878, 718, 401, 9, 48, "Output",ExpressionUUID->"66c153d3-16f9-41b8-82da-3b177ca7cca2",
 CellID->497080554]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26340, 734, 306, 7, 70, "ExampleSection",ExpressionUUID->"9f772af6-c1ac-45ea-b52d-82fb467872d8",
 CellID->258228157],
Cell[26649, 743, 218, 4, 70, "ExampleText",ExpressionUUID->"b57dd21e-1b4a-45e9-8b1a-9b0f9bc5341a",
 CellID->101130033],
Cell[26870, 749, 3635, 101, 70, "Input",ExpressionUUID->"5f0fb1a1-a0e3-48be-91b9-1311151f2f79",
 CellID->50387751],
Cell[CellGroupData[{
Cell[30530, 854, 1086, 26, 70, "Input",ExpressionUUID->"371512a6-c786-49d8-a619-da65f583ec42",
 CellID->354445143],
Cell[31619, 882, 4496, 98, 251, "Output",ExpressionUUID->"62f9bdcc-cd40-43ea-8676-cc7ce9d15ad9",
 CellID->301265295]
}, Open  ]]
}, Closed]],
Cell[36142, 984, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"86f1f1f3-7a6a-48a9-a25f-ef88adf81d9d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36265, 989, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"18dbb8bf-d6db-4dc2-8bb0-f7caab9219fd",
 CellID->1255426704],
Cell[36528, 998, 218, 4, 70, "SeeAlso",ExpressionUUID->"95184189-5708-45a6-9ac4-bac35788cf0b",
 CellID->139279649]
}, Open  ]],
Cell[CellGroupData[{
Cell[36783, 1007, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"770424b1-1239-4f64-a249-6ff2d60c8f07",
 CellID->1584193535],
Cell[37056, 1016, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"95ebd513-7207-47e9-b978-9080b3fc7289"],
Cell[37145, 1018, 384, 10, 70, "RelatedLinks",ExpressionUUID->"55b9ea6b-4d01-4d14-a2a1-be782c6e7abf",
 CellID->426751138]
}, Open  ]],
Cell[37544, 1031, 78, 0, 70, "FooterCell",ExpressionUUID->"9939ea5a-609e-4a8b-aee5-571233c3e1cb"]
}
]
*)

(* End of internal cache information *)

