(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    266533,       4920]
NotebookOptionsPosition[    256583,       4709]
NotebookOutlinePosition[    259391,       4779]
CellTagsIndexPosition[    259235,       4772]
WindowTitle->DtKVap
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "444fca5f-5e30-41d8-9eaa-1f49752231bc"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"2e42dcc9-f8fd-4b30-af03-dd7dedf8f464"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaKVap\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaKVap.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4187f8fc-4d1e-4104-a263-bd3f9accef1b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"1ba14fd8-9857-4ede-b03b-3014cc9033c0"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/DtKVap\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/DtKVap"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
DtKVap.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$18086], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/DtKVap", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "bc22a18f-228f-4dca-8a3f-2d0976bc09a6"]
    }], "AnchorBar",ExpressionUUID->"15ea8c8c-60cc-485a-9895-aa7cf0c28317"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"62ef913b-45db-4b80-8671-f450d18dbdc5"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["DtKVap", "ObjectName",ExpressionUUID->
  "1da47487-6c81-411c-afb2-8336c6ddd0bc"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"bbdc08a6-2e5f-4b98-9b3f-50d45516fd94"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "b93c34e4-1aef-4bad-bb7f-7ba3a849b898"]
}], "ObjectNameGrid",ExpressionUUID->"118e3de5-6aad-4483-8634-c67dac99910a"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DtKVap", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", 
        StyleBox["\[Rho]",
         FontSlant->"Italic"]}], "]"}]], "InlineFormula",ExpressionUUID->
      "0daa18cd-f3e1-41ac-aced-1bb765ec6953"],
     " \[LineSeparator]Potassium self-diffusion coefficient equation of state \
",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["D", "t"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "1a3b01d3-cb08-4b7c-b9d5-e4dc5f6da6a5"],
     "(",
     StyleBox["T",
      FontSlant->"Italic"],
     ",\[Rho]) as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " and density ",
     StyleBox["\[Rho]",
      FontSlant->"Italic"],
     " for the gaseous phase only"
    }],ExpressionUUID->"36dc7fae-b4a6-4f26-8072-3ac8ff31afb6"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"aea32eba-dff6-4542-b627-65f3fdcec100"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"2442a610-1fc1-4671-bd8f-0047688a7ede"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"a6851647-6294-45fc-bc4b-f33ea6a8b52e"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"490c5e73-be50-4101-8d43-771c10437284"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->19351694,ExpressionUUID->"86412d95-814b-465e-b44b-bc2225ed9412"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"2da65b73-5032-4b5e-b24e-b1721f17c764"],

Cell[TextData[{
 "The function is defined only for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "fc8a2bc8-cff8-4208-b374-ac3ea7337509"]
}], "Notes",
 CellID->206839001,ExpressionUUID->"e44213d3-de8a-4373-9bb8-25dd162d2107"],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "e4e2da2c-ff89-447c-84f4-08f25a4dbc5c"],
 " and the the function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "745e8c2a-4474-4813-90a5-f4b9777be786"],
 " are calculated using their dilute-gas limit forms: ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "8547b3c8-0de0-483e-a1c7-9cc70ea37437"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "K0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "3"]}]], "InlineFormula",
  ExpressionUUID->"3282ca91-7541-414b-ad4c-fba488283f18"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "5f4a5bff-3c0c-4b41-b90b-bd9a620951a3"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "N0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "2"]}]], "InlineFormula",
  ExpressionUUID->"5afa6f9a-d298-40c7-8507-1caf443c4224"],
 " "
}], "Notes",
 CellID->42089447,ExpressionUUID->"038e3582-e721-40d5-b52d-443133ef4311"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin and the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "b54fba72-a16a-44cc-9aeb-71bd5c6c3d33"]
}], "Notes",
 CellID->893946030,ExpressionUUID->"fffd19c9-4508-4ea9-bc4b-6f89aa7bda3b"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["D", "t"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "9a6ee394-a5a6-4889-a296-a2c3ded8a037"],
 " is ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["cm", "2"], "/", "s"}]], "InlineFormula",ExpressionUUID->
  "0d524c6f-daf6-499f-977c-c3587895c7bb"],
 " but it can be changed by modifying the following option: "
}], "Notes",
 CellID->7613595,ExpressionUUID->"f70ab8bb-46cd-4cf4-a22f-ccd955a1a5a7"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "7a13e657-fa21-4944-826e-73e538c32dbf"], 
    ButtonBox[
     ButtonBox["DtKVapDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
DtKVapDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], 
    RowBox[{" ", 
     RowBox[{
      SuperscriptBox["Centimeters", "2"], "\n", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", "\n", "  ", "Seconds"}]}]}]}]}]}]}]}], Cell[
    "Default unit for self-diffusion equation of state", "TableText",
     ExpressionUUID->"54161651-8306-43e9-b3dc-6a2cddedfe72"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->426451392,ExpressionUUID->"e82a445e-4e7e-4437-826a-4078e01b40e1"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"80bf13db-ce19-438d-b7ad-5b32daa96015"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "b2e149ca-8338-4f3b-a448-0ab524cd27a2"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "dbc22f76-6e20-4f7f-b49a-0068f968cfc5"]
    }], "TableText",ExpressionUUID->"077efd98-8a3f-43b1-b05c-01d2d8ca70e0"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "ab4f5cda-3230-4b73-b5f0-65e0c8184f91"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"a4e90871-bc53-47d2-909a-597f61b5d194"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "8b3e4547-0f58-4bd5-81af-cf6b02c86a1f"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "9c397679-c53a-49f3-a440-d80836413121"]
    }], "TableText",ExpressionUUID->"f2214dcf-45a3-4ad8-81fe-3674395d0046"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"394bcf32-985d-4927-b3fc-843134ac0608"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"8201542f-6368-4b94-adce-64c41b080286"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c9fd3898-dc94-4c7e-a43e-b137de1cfcf9"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "cb8a4a51-ce2a-492a-9678-7874cd334311"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->6566483,ExpressionUUID->"0a053543-8c30-4394-9ac5-41f9e0a1d22f"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "935e1d1a-497b-4469-99c7-2142f19bc23c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->97575074,ExpressionUUID->"74dd3b59-de23-45f2-ac0a-f2af4dcba432"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"09511132-8426-4196-a324-0cb6e649b98d"],

Cell["\<\
If no unit is entered then the equation of state returns a number with the \
default units and otherwise it is possible to obtain a number with dimensions \
if units are given to the temperature variable and/or to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"80642222-8082-4123-8bd7-2b3b9bd74632"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DtKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"71562385-e28d-47e7-8859-80afd6db830c"],

Cell[BoxData["1.129677028393981`"], "Output",
 CellLabel->"Out[2]=",
 CellID->628741231,ExpressionUUID->"f15d664a-9f8a-46a4-b86f-a62599bc51cb"],

Cell[BoxData[
 TemplateBox[{"1.129677028393981`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->27659941,ExpressionUUID->"36eddc80-cc19-4791-8acf-7f99705aedaf"],

Cell[BoxData[
 TemplateBox[{"1.129677028393981`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->147220221,ExpressionUUID->"6aee1b06-d2dd-4e51-ae11-28006456dd69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1.129677028393981`", ",", 
     FractionBox[
      SuperscriptBox["\"\<Centimeters\>\"", "2"], "\"\<Seconds\>\""]}], "]"}],
    ",", 
   FractionBox[
    SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""]}], 
  "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->12124132,ExpressionUUID->"e3ac74a3-cb3b-4b72-9804-4a34cb5fd20c"],

Cell[BoxData[
 TemplateBox[{"0.00011296770283939811`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->14441687,ExpressionUUID->"7fd6db9c-ec1b-4754-b559-81d8b7462f13"]
}, Open  ]],

Cell["\<\
3D plot of the self-diffusion coefficient variation in gaseous potassium. The \
thick red line represents the vapor coexistence line.\
\>", "ExampleText",
 CellID->20254794,ExpressionUUID->"89635705-fa8e-46df-8dec-ffb8cf395537"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tmin", "=", "900"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tmax", "=", "1600"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"DtKVap", "[", 
        RowBox[{"T", ",", "\[Rho]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", 
         RowBox[{"RhoSatVapK", "[", "Tmin", "]"}], ",", 
         RowBox[{"RhoSatVapK", "[", "Tmax", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
          RowBox[{"y", "\[LessEqual]", 
           RowBox[{"RhoSatVapK", "[", "x", "]"}]}]}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
          "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
           "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\
\"]\) (\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\"", ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Bold", ",", "16", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
         "]"}]}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T", ",", 
         RowBox[{"RhoSatVapK", "[", "T", "]"}], ",", 
         RowBox[{"DtKVap", "[", 
          RowBox[{"T", ",", 
           RowBox[{"RhoSatVapK", "[", "T", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Red"}], 
         "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "Large"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->801374019,ExpressionUUID->"707f4713-c51d-4864-95da-ef188bdb13fd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQlYVdX+/69f7+1vdi1NSwYRQVBxQDS7Xm/WVWkwUMIc8agoTogxCIpT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    "], {{0, 396.5}, {576., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{576., 396.5},
  PlotRange->{{0, 576.}, {0, 396.5}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->92303612,ExpressionUUID->"706a7314-8408-48c0-b3fc-61639dfac122"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "801969e0-55d5-445c-9716-4c30501f5e80"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"6a34d9e4-727a-437b-ae73-4ec5afb37436"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["D", "t"],
   FontSlant->"Italic"]],ExpressionUUID->
  "b1d5e572-e740-4d16-bb64-5ab0032183d0"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "9a2763ff-55aa-4803-8e96-3bb84d13f6d8"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"3a590ff1-46d2-4d8f-a2de-d0176406b2b1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DtKVap", "[", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
    RowBox[{"Quantity", "[", 
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
      RowBox[{"\"\<Grams\>\"", "/", 
       SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"With", " ", 
    RowBox[{"Hsieh", "'"}], "s", " ", "parameters"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"Coefd", "->", "5"}], ",", 
   RowBox[{"CoefN", "->", "0.0540234"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"189ba5fb-ef2f-428e-92c6-f6ceca94b02e"],

Cell[BoxData[
 TemplateBox[{"1.129677028393981`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->279810609,ExpressionUUID->"e0393f81-4e5a-4e14-af38-a0a19a977396"],

Cell[BoxData[
 TemplateBox[{"0.06102899398751648`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->590811260,ExpressionUUID->"d1d0e4bb-5f25-4fc2-bf0b-70d12bd1a5ce"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "85677f39-1952-428a-9a41-eac55d855bee"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"518de5a2-b5c8-4f48-a364-9e3e6c3ee0a2"],

Cell[CellGroupData[{

Cell[TextData[{
 "DtKVapDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e6cee7b6-0370-4da7-b622-3e12ac9588af"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->250107433,ExpressionUUID->"02006572-c6e9-4fbd-85ad-dbc1c0feaee3"],

Cell["\<\
It is possible to change the self-diffusion coefficient default unit by \
setting a new unit to the option parameter \"DtKVapDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"a4c02248-f7aa-4f8c-99d9-1e5495010a29"],

Cell["Individually:", "ExampleText",
 CellID->269922393,ExpressionUUID->"42b36cb4-11ff-4229-97ad-51584e1a1bba"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"DtKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      FractionBox[
       SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138036825,ExpressionUUID->"7ecae9df-2858-42b0-aeaa-6b912d08c01e"],

Cell[BoxData[
 TemplateBox[{"1.129677028393981`", 
   RowBox[{
     SuperscriptBox["\"cm\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "centimeters squared per second", 
   FractionBox[
    SuperscriptBox["\"Centimeters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->9608894,ExpressionUUID->"0256d34d-7dd2-4783-83b6-861e428e2162"],

Cell[BoxData[
 TemplateBox[{"0.00011296770283939811`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->150476841,ExpressionUUID->"1f3a8577-bfff-428e-bbc7-edd497db1e39"]
}, Open  ]],

Cell["Globally by using SetOptions:", "ExampleText",
 CellID->195019342,ExpressionUUID->"34ee6d93-572e-46ac-860b-acf4a3dd2bd0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DtKVap", ",", 
    RowBox[{"DtKVapDefaultUnit", "->", 
     RowBox[{"QuantityUnit", "[", 
      RowBox[{"Quantity", "[", 
       FractionBox[
        SuperscriptBox["\"\<Meters\>\"", "2"], "\"\<Seconds\>\""], "]"}], 
      "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DtKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->110075696,ExpressionUUID->"8a210786-6ed3-45e6-adb7-54bbfe1d4f90"],

Cell[BoxData["0.00011296770283939811`"], "Output",
 CellLabel->"Out[2]=",
 CellID->483421313,ExpressionUUID->"1f7f0054-f11f-4a75-8902-9822a932cb6d"],

Cell[BoxData[
 TemplateBox[{"0.00011296770283939811`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->347754736,ExpressionUUID->"5fc0ddd7-ab99-420f-8023-b94b9b0ff94f"],

Cell[BoxData[
 TemplateBox[{"0.00011296770283939811`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}], "meters squared per second", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->15328696,ExpressionUUID->"b4de8d19-38f0-468d-a2e4-0cbc0cc955c7"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "b115a85c-c5bb-4ca6-8484-bc07fefcad5c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"1b05d8ba-f906-4cce-950c-9acc74f027df"],

Cell["\<\
Comparison of Stefanov's data (blue points) with the theoretical model (red \
curve) on the 981Pa isobar.\
\>", "ExampleText",
 CellID->101130033,ExpressionUUID->"51dea065-c968-419a-9265-c6ed538812ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Thermal", " ", "diffusion", " ", "coefficients", " ", "deduced", " ", 
    "from", " ", "thermal", " ", "conductivity", " ", "data", " ", "of", " ", 
    RowBox[{"Stefanov", "[", "1966", "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"TabDthStefanov", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"700", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"80.394", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"76.657", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"900", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"91.132", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"110.09", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1100", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"132.31", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"156.57", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1300", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"181.99", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"211.21", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1500", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"242.61", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"20", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}], ";"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2686536,ExpressionUUID->"07be7143-40b3-4a8d-8f88-3a77012cf842"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", "9.81*^-3"}], ";"}], 
  RowBox[{"(*", "bar", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RhoStefanov", "[", "T_", "]"}], ":=", 
    RowBox[{
     FractionBox[
      RowBox[{"P", "*", "MK"}], 
      RowBox[{"8.314", "*", "T"}]], 
     SuperscriptBox["10", 
      RowBox[{"-", "1"}]]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Perfect", " ", "gas", " ", "equation", " ", "of", " ", "state"}], 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"TabDthStefanov", ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", " ", "Medium"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"DtKVap", "[", 
      RowBox[{"T", ",", 
       RowBox[{"RhoStefanov", "[", "T", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "600", ",", "1600"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "->", "Medium"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"D\", \"t\"],FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s)\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", "14", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->3154932,ExpressionUUID->"3db6d732-fc1f-45f9-b540-6325c301aa90"],

Cell[BoxData[
 GraphicsBox[{{{{
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{700., 64.3152}, {700., 80.394}}], 
          LineBox[{{700., 80.394}, {700., 96.4728}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{800., 61.325599999999994`}, {800., 76.657}}], 
          LineBox[{{800., 76.657}, {800., 91.9884}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{900., 72.9056}, {900., 91.132}}], 
          LineBox[{{900., 91.132}, {900., 109.3584}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1000., 88.072}, {1000., 110.09}}], 
          LineBox[{{1000., 110.09}, {1000., 132.108}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1100., 105.848}, {1100., 132.31}}], 
          LineBox[{{1100., 132.31}, {1100., 158.772}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1200., 125.256}, {1200., 156.57}}], 
          LineBox[{{1200., 156.57}, {1200., 187.884}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1300., 145.592}, {1300., 181.99}}], 
          LineBox[{{1300., 181.99}, {1300., 218.388}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {
          LineBox[{{1400., 168.96800000000002`}, {1400., 211.21}}], 
          LineBox[{{1400., 211.21}, {1400., 253.452}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {
          LineBox[{{1500., 194.08800000000002`}, {1500., 242.61}}], 
          LineBox[{{1500., 242.61}, {1500., 291.132}}]}},
        Antialiasing->False]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{700., 96.4728}, Offset[{3, 0}, {700., 96.4728}]}, {{700.,
              96.4728}, Offset[{-3, 0}, {700., 96.4728}]}, {{700., 64.3152}, 
             Offset[{3, 0}, {700., 64.3152}]}, {{700., 64.3152}, 
             Offset[{-3, 0}, {700., 64.3152}]}}], {{{1., 0.}, {0., 1.}}, {0., 
           0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{800., 91.9884}, Offset[{3, 0}, {800., 91.9884}]}, {{800.,
              91.9884}, Offset[{-3, 0}, {800., 91.9884}]}, {{800., 
             61.325599999999994`}, 
             Offset[{3, 0}, {800., 61.325599999999994`}]}, {{800., 
             61.325599999999994`}, 
             Offset[{-3, 0}, {800., 61.325599999999994`}]}}], {{{1., 0.}, {0.,
            1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{900., 109.3584}, Offset[{3, 0}, {900., 109.3584}]}, {{
             900., 109.3584}, Offset[{-3, 0}, {900., 109.3584}]}, {{900., 
             72.9056}, Offset[{3, 0}, {900., 72.9056}]}, {{900., 72.9056}, 
             Offset[{-3, 0}, {900., 72.9056}]}}], {{{1., 0.}, {0., 1.}}, {0., 
           0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1000., 132.108}, Offset[{3, 0}, {1000., 132.108}]}, {{
             1000., 132.108}, Offset[{-3, 0}, {1000., 132.108}]}, {{1000., 
             88.072}, Offset[{3, 0}, {1000., 88.072}]}, {{1000., 88.072}, 
             Offset[{-3, 0}, {1000., 88.072}]}}], {{{1., 0.}, {0., 1.}}, {0., 
           0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1100., 158.772}, Offset[{3, 0}, {1100., 158.772}]}, {{
             1100., 158.772}, Offset[{-3, 0}, {1100., 158.772}]}, {{1100., 
             105.848}, Offset[{3, 0}, {1100., 105.848}]}, {{1100., 105.848}, 
             Offset[{-3, 0}, {1100., 105.848}]}}], {{{1., 0.}, {0., 1.}}, {0.,
            0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1200., 187.884}, Offset[{3, 0}, {1200., 187.884}]}, {{
             1200., 187.884}, Offset[{-3, 0}, {1200., 187.884}]}, {{1200., 
             125.256}, Offset[{3, 0}, {1200., 125.256}]}, {{1200., 125.256}, 
             Offset[{-3, 0}, {1200., 125.256}]}}], {{{1., 0.}, {0., 1.}}, {0.,
            0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1300., 218.388}, Offset[{3, 0}, {1300., 218.388}]}, {{
             1300., 218.388}, Offset[{-3, 0}, {1300., 218.388}]}, {{1300., 
             145.592}, Offset[{3, 0}, {1300., 145.592}]}, {{1300., 145.592}, 
             Offset[{-3, 0}, {1300., 145.592}]}}], {{{1., 0.}, {0., 1.}}, {0.,
            0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1400., 253.452}, Offset[{3, 0}, {1400., 253.452}]}, {{
             1400., 253.452}, Offset[{-3, 0}, {1400., 253.452}]}, {{1400., 
             168.96800000000002`}, 
             Offset[{3, 0}, {1400., 168.96800000000002`}]}, {{1400., 
             168.96800000000002`}, 
             Offset[{-3, 0}, {1400., 168.96800000000002`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1500., 291.132}, Offset[{3, 0}, {1500., 291.132}]}, {{
             1500., 291.132}, Offset[{-3, 0}, {1500., 291.132}]}, {{1500., 
             194.08800000000002`}, 
             Offset[{3, 0}, {1500., 194.08800000000002`}]}, {{1500., 
             194.08800000000002`}, 
             Offset[{-3, 0}, {1500., 194.08800000000002`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[10]], {{{700., 
      80.394}}, {{800., 76.657}}, {{900., 91.132}}, {{1000., 110.09}}, {{
      1100., 132.31}}, {{1200., 156.57}}, {{1300., 181.99}}, {{1400., 
      211.21}}, {{1500., 242.61}}}]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVknk41AkAhicNI9VKdK0rHZJom8i12T4j1paWMYs0rmYcU/kRD9WKYtyl
GWNm9JMOFYpie3Y6lJqmdEoJu+WKVSyLLmIyyqz++J73ef98n+cz48T4hGtQ
KJQtU/tG86UyHYqCj76UsaI6IyZsYzIt4u/y8eppNlO4mAlGTYB7/z0+rheH
tLOWMRHCovCfP+ZDKJ7Y0bGKCTJty3hxMx/SmPrwQScmZvT09bn08SGRZ0ZT
ApgYKjG6n/ZdGpJ2VSVMlzLxp3nmQVpQGjpr7Mt9ZvnAwLHaeyMtHe6Lnpfe
0GGBHqNp6FiWDqcJj4p1H1ngLfihQpeRAYNEvYXFdb8h/tk1qeFgBkwXWViN
VPhifTk7sSs7E/982TBfGeOHtvzgmhabLHBsewKb7Pwheud8R9aehf42I+/L
A/6gRjso3PdlozF/eqNuxlZ4fhEZ6i7JgbWxz6pJkwB4V2ntFipyQOi8C6SV
BIBo8s/5yD6EXrNk1TTTbQjV1FZnUw/DaZY8/PSpbdANbCZaTh/Gf/9eLHgy
nw3xna8OQZ654HVoXbYtYoNeSH1cO5KLTR4JSR7LAnFIYu7zWngEgwk3UhdV
BuL6yXP2do4C3CbyZUrPIJytd53PeCnA4kjLWJu3QeDO2MBM4wtxMFRtJyoN
hkngYQvWvDy88bWrUnBCwLtPLVVw83C3y+PCyZmhML5a2fCoOg/jtugoJEJx
yaFnzEpbBHtX03VhD0Ph9SmbouEnQnBvbGK00XYE2AdVx1aIsCbXOjUofjtc
Zt2Och4XwTZjwMvi7nZIeN4NZ3/NR1wvtTt5LgefvnoZ7D+TD4l17NhwMAf0
5a98qz7kYw4nRO1axkFrc6FbkpsYJVe3yjLGOAgx6KGXScSY7dNCNfiZi+Ej
xykur8UY6Cna1H+Ciw+C9OQ9dhKMajEkrrQwPDFTjdEyJDiR+rk6IiEMeutP
mdi2SbAm5aL2clUY1vU3Mm6ulKK5sbd1Oj8cEU/jfrmyV4o0JfnjXL0IaDi5
TnrUSyGZiHNgXonAfofTfzgYFkCSe2DfT76RCJGv1q3dXYDoXStejtB48E62
ZMrvFcBvo7Nmag0Pps9kwnn6R7G59vbZzvAd2FoWlUTjHUWWeTvF2WwnYubI
wn2vHQWtTuMDp2knxLJIuoEmiZnbUho/p+7Cks7NF4gAEukNgtJ4RhSEx26Z
LT0/5TtG3sqVUeh0NpPyy0kInLsfDqqisLo7Xft1BYn398/cWjgZhfoVnu+L
K0m0Gnt8iaMS0LnSdtNERiKBXlJroUcgs0Hp/72cRHmfIKLQksAB6lqB3l8k
Zrjp+AuCCDw7J50W+zeJ9vNWB+ShBIw3j8c/f0Giq3mp/B2XwE2Rgi1sJeHG
tcz22klAZeK1cnYXiUMUucvcvQT2OEbd0x4gcXJTo83xPAIPOhrseYMkmGFD
7U/FBOal2Fx4OERitdbaInUBgcsPVKLM9ySs1PXB3BMEhlk5IdRREpEUG+Wq
CgIM5VATd4yc+p3IN7iSgOiYt3utkoR+jWNd3iUCa7oXWPNVJBL9hkdHrxI4
mL6/uHuCBH300UWLG1M9K7r0Xb6SeKOf8Dv7FgGTJ4ys4kkSOnta2QIFASK6
TKVWk3gx0cK6U0vgfy0EPRM=
        "]]},
      Annotation[#, "Charting`Private`Tag$8622#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{683.3333333333334, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"D\\\", \
\\\"t\\\"],FontSlant->\\\"Italic\\\"]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \
\\(2\\)]\\)/s)\"", TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImageSize->Medium,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], Bold, 14, FontFamily -> "Times New Roman"],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{683.3333333333334, 1500.}, {0, 291.132}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[2]=",
 CellID->343692639,ExpressionUUID->"ea37251d-7f1c-4b8c-99c2-5376e06ee387"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"fb12d2bf-3647-4c22-8f80-bb2817507dff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"854fb235-01e9-4d64-a73e-3180a6b7543e"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"63f42022-b969-4b5f-a3ac-c40492a1bca7"],

Cell[TextData[StyleBox[ButtonBox["etaKVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->139279649,ExpressionUUID->"dbe44c7f-87c5-462f-ada6-d281e053029f"],

Cell[TextData[StyleBox[ButtonBox["u2lVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"u2lVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->247517249,ExpressionUUID->"c35a68db-92f7-4a24-8aa4-5d80c66e59fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c7f84b2c-03c5-48ba-9588-8a94622e55f2"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"76e03128-b213-4776-8761-9baacec7ccca"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"40d8a1d3-d725-4e3f-9ee1-3af94f9307c6"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "1bc9c574-4ac5-42bd-8ef5-451debe5b722"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"0968beae-3817-49e3-a75a-df695776c1c5"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"9fe376ce-5f0a-4e6c-b23a-74090ca484c2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DtKVap",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 17.7773000}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "DtKVap[T, \\[Rho]] Potassium self-diffusion coefficient equation of \
state Dt(T,\\[Rho]) as a function of temperature T and density \\[Rho] for \
the gaseous phase only", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "DtKVap", "titlemodifier" -> "", "windowtitle" -> "DtKVap", "type" -> 
    "Symbol", "uri" -> "EOSPotassium/ref/DtKVap", "WorkflowDockedCell" -> ""},
   "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"9c43e62d-a6ae-4be0-a828-416f1c9a8575"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12679, 360, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0a053543-8c30-4394-9ac5-41f9e0a1d22f",
   CellTags->"PrimaryExamplesSection",
   CellID->6566483]},
 "RasterizedOutput"->{
  Cell[19739, 559, 210122, 3450, 391, "Output",ExpressionUUID->"706a7314-8408-48c0-b3fc-61639dfac122",
   CellTags->"RasterizedOutput",
   CellID->92303612]},
 "DefaultUnit"->{
  Cell[233171, 4114, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"02006572-c6e9-4fbd-85ad-dbc1c0feaee3",
   CellTags->"DefaultUnit",
   CellID->250107433]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 258677, 4757},
 {"RasterizedOutput", 258874, 4761},
 {"DefaultUnit", 259051, 4765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[578, 21, 3635, 83, 53, "AnchorBarGrid",ExpressionUUID->"62ef913b-45db-4b80-8671-f450d18dbdc5",
 CellID->1],
Cell[CellGroupData[{
Cell[4238, 108, 391, 9, 54, "ObjectNameGrid",ExpressionUUID->"118e3de5-6aad-4483-8634-c67dac99910a"],
Cell[4632, 119, 1077, 31, 134, "Usage",ExpressionUUID->"aea32eba-dff6-4542-b627-65f3fdcec100",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5746, 155, 854, 21, 37, "NotesSection",ExpressionUUID->"86412d95-814b-465e-b44b-bc2225ed9412",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->19351694],
Cell[6603, 178, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"2da65b73-5032-4b5e-b24e-b1721f17c764"],
Cell[6692, 180, 354, 11, 70, "Notes",ExpressionUUID->"e44213d3-de8a-4373-9bb8-25dd162d2107",
 CellID->206839001],
Cell[7049, 193, 1516, 53, 70, "Notes",ExpressionUUID->"038e3582-e721-40d5-b52d-443133ef4311",
 CellID->42089447],
Cell[8568, 248, 352, 9, 70, "Notes",ExpressionUUID->"fffd19c9-4508-4ea9-bc4b-6f89aa7bda3b",
 CellID->893946030],
Cell[8923, 259, 501, 14, 70, "Notes",ExpressionUUID->"f70ab8bb-46cd-4cf4-a22f-ccd955a1a5a7",
 CellID->7613595],
Cell[9427, 275, 991, 26, 70, "3ColumnTableMod",ExpressionUUID->"e82a445e-4e7e-4437-826a-4078e01b40e1",
 CellID->426451392],
Cell[10421, 303, 127, 1, 70, "Notes",ExpressionUUID->"80bf13db-ce19-438d-b7ad-5b32daa96015",
 CellID->46888620],
Cell[10551, 306, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"394bcf32-985d-4927-b3fc-843134ac0608",
 CellID->505732368],
Cell[12556, 355, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"8201542f-6368-4b94-adce-64c41b080286"]
}, Closed]],
Cell[CellGroupData[{
Cell[12679, 360, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0a053543-8c30-4394-9ac5-41f9e0a1d22f",
 CellTags->"PrimaryExamplesSection",
 CellID->6566483],
Cell[CellGroupData[{
Cell[13137, 375, 307, 7, 30, "ExampleSection",ExpressionUUID->"74dd3b59-de23-45f2-ac0a-f2af4dcba432",
 CellID->97575074],
Cell[13447, 384, 175, 3, 27, "Input",ExpressionUUID->"09511132-8426-4196-a324-0cb6e649b98d",
 CellID->87419684],
Cell[13625, 389, 341, 5, 76, "ExampleText",ExpressionUUID->"80642222-8082-4123-8bd7-2b3b9bd74632",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13991, 398, 962, 27, 97, "Input",ExpressionUUID->"71562385-e28d-47e7-8859-80afd6db830c",
 CellID->218515404],
Cell[14956, 427, 143, 2, 36, "Output",ExpressionUUID->"f15d664a-9f8a-46a4-b86f-a62599bc51cb",
 CellID->628741231],
Cell[15102, 431, 406, 9, 48, "Output",ExpressionUUID->"36eddc80-cc19-4791-8acf-7f99705aedaf",
 CellID->27659941],
Cell[15511, 442, 407, 9, 48, "Output",ExpressionUUID->"6aee1b06-d2dd-4e51-ae11-28006456dd69",
 CellID->147220221]
}, Open  ]],
Cell[CellGroupData[{
Cell[15955, 456, 449, 13, 47, "Input",ExpressionUUID->"e3ac74a3-cb3b-4b72-9804-4a34cb5fd20c",
 CellID->12124132],
Cell[16407, 471, 400, 9, 48, "Output",ExpressionUUID->"7fd6db9c-ec1b-4754-b559-81d8b7462f13",
 CellID->14441687]
}, Open  ]],
Cell[16822, 483, 238, 4, 70, "ExampleText",ExpressionUUID->"89635705-fa8e-46df-8dec-ffb8cf395537",
 CellID->20254794],
Cell[CellGroupData[{
Cell[17085, 491, 2651, 66, 70, "Input",ExpressionUUID->"707f4713-c51d-4864-95da-ef188bdb13fd",
 CellID->801374019],
Cell[19739, 559, 210122, 3450, 391, "Output",ExpressionUUID->"706a7314-8408-48c0-b3fc-61639dfac122",
 CellTags->"RasterizedOutput",
 CellID->92303612]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229910, 4015, 323, 7, 70, "ExampleSection",ExpressionUUID->"6a34d9e4-727a-437b-ae73-4ec5afb37436",
 CellID->1020263627],
Cell[230236, 4024, 657, 19, 70, "ExampleText",ExpressionUUID->"3a590ff1-46d2-4d8f-a2de-d0176406b2b1",
 CellID->111367501],
Cell[CellGroupData[{
Cell[230918, 4047, 1055, 28, 70, "Input",ExpressionUUID->"189ba5fb-ef2f-428e-92c6-f6ceca94b02e",
 CellID->138125379],
Cell[231976, 4077, 407, 9, 48, "Output",ExpressionUUID->"e0393f81-4e5a-4e14-af38-a0a19a977396",
 CellID->279810609],
Cell[232386, 4088, 409, 9, 48, "Output",ExpressionUUID->"d1d0e4bb-5f25-4fc2-bf0b-70d12bd1a5ce",
 CellID->590811260]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[232844, 4103, 302, 7, 70, "ExampleSection",ExpressionUUID->"518de5a2-b5c8-4f48-a364-9e3e6c3ee0a2",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[233171, 4114, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"02006572-c6e9-4fbd-85ad-dbc1c0feaee3",
 CellTags->"DefaultUnit",
 CellID->250107433],
Cell[233517, 4124, 245, 4, 70, "ExampleText",ExpressionUUID->"a4c02248-f7aa-4f8c-99d9-1e5495010a29",
 CellID->300166705],
Cell[233765, 4130, 111, 1, 70, "ExampleText",ExpressionUUID->"42b36cb4-11ff-4229-97ad-51584e1a1bba",
 CellID->269922393],
Cell[CellGroupData[{
Cell[233901, 4135, 1033, 27, 70, "Input",ExpressionUUID->"7ecae9df-2858-42b0-aeaa-6b912d08c01e",
 CellID->138036825],
Cell[234937, 4164, 405, 9, 48, "Output",ExpressionUUID->"0256d34d-7dd2-4783-83b6-861e428e2162",
 CellID->9608894],
Cell[235345, 4175, 401, 9, 48, "Output",ExpressionUUID->"1f3a8577-bfff-428e-bbc7-edd497db1e39",
 CellID->150476841]
}, Open  ]],
Cell[235761, 4187, 127, 1, 70, "ExampleText",ExpressionUUID->"34ee6d93-572e-46ac-860b-acf4a3dd2bd0",
 CellID->195019342],
Cell[CellGroupData[{
Cell[235913, 4192, 1324, 37, 70, "Input",ExpressionUUID->"8a210786-6ed3-45e6-adb7-54bbfe1d4f90",
 CellID->110075696],
Cell[237240, 4231, 148, 2, 35, "Output",ExpressionUUID->"1f7f0054-f11f-4a75-8902-9822a932cb6d",
 CellID->483421313],
Cell[237391, 4235, 401, 9, 48, "Output",ExpressionUUID->"5fc0ddd7-ab99-420f-8023-b94b9b0ff94f",
 CellID->347754736],
Cell[237795, 4246, 400, 9, 48, "Output",ExpressionUUID->"b4de8d19-38f0-468d-a2e4-0cbc0cc955c7",
 CellID->15328696]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[238256, 4262, 306, 7, 70, "ExampleSection",ExpressionUUID->"1b05d8ba-f906-4cce-950c-9acc74f027df",
 CellID->258228157],
Cell[238565, 4271, 211, 4, 70, "ExampleText",ExpressionUUID->"51dea065-c968-419a-9265-c6ed538812ab",
 CellID->101130033],
Cell[238779, 4277, 3026, 84, 70, "Input",ExpressionUUID->"07be7143-40b3-4a8d-8f88-3a77012cf842",
 CellID->2686536],
Cell[CellGroupData[{
Cell[241830, 4365, 1761, 47, 70, "Input",ExpressionUUID->"3db6d732-fc1f-45f9-b540-6325c301aa90",
 CellID->3154932],
Cell[243594, 4414, 11263, 236, 257, "Output",ExpressionUUID->"ea37251d-7f1c-4b8c-99c2-5376e06ee387",
 CellID->343692639]
}, Open  ]]
}, Closed]],
Cell[254884, 4654, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"fb12d2bf-3647-4c22-8f80-bb2817507dff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[255007, 4659, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"63f42022-b969-4b5f-a3ac-c40492a1bca7",
 CellID->1255426704],
Cell[255270, 4668, 216, 4, 70, "SeeAlso",ExpressionUUID->"dbe44c7f-87c5-462f-ada6-d281e053029f",
 CellID->139279649],
Cell[255489, 4674, 214, 4, 70, "SeeAlso",ExpressionUUID->"c35a68db-92f7-4a24-8aa4-5d80c66e59fe",
 CellID->247517249]
}, Open  ]],
Cell[CellGroupData[{
Cell[255740, 4683, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"76e03128-b213-4776-8761-9baacec7ccca",
 CellID->1584193535],
Cell[256013, 4692, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"40d8a1d3-d725-4e3f-9ee1-3af94f9307c6"],
Cell[256102, 4694, 384, 10, 70, "RelatedLinks",ExpressionUUID->"0968beae-3817-49e3-a75a-df695776c1c5",
 CellID->426751138]
}, Open  ]],
Cell[256501, 4707, 78, 0, 70, "FooterCell",ExpressionUUID->"9fe376ce-5f0a-4e6c-b23a-74090ca484c2"]
}
]
*)

(* End of internal cache information *)

