(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     43060,       1071]
NotebookOptionsPosition[     37906,        957]
NotebookOutlinePosition[     40568,       1022]
CellTagsIndexPosition[     40421,       1016]
WindowTitle->EOSPotassiumFunctions
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "a65d1eb3-5b84-4cf4-a969-7efa11fd9d22"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox[
       InterpretationBox[Cell[TextData[{
         "URL",
         StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
          StripOnInput->False]
        }],ExpressionUUID->"53e33d7d-b044-4c71-a86e-9719669f87e2"],
        TextCell[
         Row[{"URL", 
           Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
       StripOnInput->
        False], {"\<\"EOSPotassium/ref/EOSPotassiumFunctions\"\>":>
      None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["EOSPotassium/ref/EOSPotassiumFunctions"]}, Visible -> 
           False]]; SelectionMove[
        DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/language/EOSPotassium/ref/\
EOSPotassiumFunctions.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
            If[
             TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$18489], 
             "http://reference.wolfram.com/system-modeler/", 
             "http://reference.wolfram.com/language/"], 
            "EOSPotassium/ref/EOSPotassiumFunctions", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic,
      MenuStyle->"URLMenu"]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "760a526f-8f9b-4522-8fc1-e3fd2c9685ba"]], "AnchorBar",ExpressionUUID->
     "7333497a-d0b5-417f-8827-c14f2108e54d"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"ba7fb41c-8608-434d-b45f-3a6ce130b038"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["EOSPotassiumFunctions", "ObjectName",ExpressionUUID->
  "f4c59f86-9858-408f-ab9a-daaba2210292"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"415ba32a-e6b6-48cc-b123-d9db417cc9f5"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "c0f1383a-145c-4532-ae46-d912748cfe92"]
}], "ObjectNameGrid",ExpressionUUID->"c349553c-1b1a-49b6-ae5d-a1c3f42f5da6"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EOSPotassiumFunctions", "[", "]"}]], "InlineFormula",
      ExpressionUUID->"fbba4c0c-0f0e-4cd8-94dd-804e863fb2ae"],
     " \[LineSeparator]List of public functions and parameters for the \
package \"EOSPotassium\""
    }],ExpressionUUID->"57c084e2-37c9-44cc-a71f-b7058f3930be"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"6a4f92a7-767d-41a0-ab98-1256a017a433"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"f19c0ffe-3806-4b7e-b294-c8040914e2e2"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "4b5e40b8-a81e-4cd8-ab24-ba58174591e5"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->852254883,ExpressionUUID->"bd026344-84fb-4aad-ad8d-17e16c1154c0"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a0ffa2b7-187e-4f14-a415-1d689859a790"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->67572922,ExpressionUUID->"a61a3499-a233-40f8-8cbb-dc43d821cbc9"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->496469109,ExpressionUUID->"a03478c4-1c4e-4471-ba12-4c436b5935fe"],

Cell["List of all public functions and parameters", "ExampleText",
 CellID->299615588,ExpressionUUID->"c8d20291-0a8b-4ef5-a54c-481312daa9b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EOSPotassiumFunctions", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52331864,ExpressionUUID->"04f828da-2e0d-48f1-991d-6bf7457071c4"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["EOSPotassium`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], " ", 
              StyleBox["EOSPotassium`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["DtK1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "DtK1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["fqc1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "fqc1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["rhocK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "rhocK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DtKVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "DtKVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["K0K", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "K0K", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RhoKnu1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "RhoKnu1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["EOSPotassiumFunctions", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "EOSPotassiumFunctions", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["K0star1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "K0star1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RhoKnuVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "RhoKnuVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etaK1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etaK1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["LvK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "LvK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RhoSatLiqK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "RhoSatLiqK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etaKnuK1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etaKnuK1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["MK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "MK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RhoSatVapK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "RhoSatVapK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etaKnuKVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etaKnuKVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["nBK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "nBK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TcK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "TcK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etaKVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etaKVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NdNtcVapK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "NdNtcVapK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TmpK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "TmpK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etalK1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etalK1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["PcK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "PcK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TtransVapK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "TtransVapK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["etalKVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "etalKVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["PsatK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "PsatK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["u2lVap", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "u2lVap", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["fN1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "fN1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["qc0K", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "qc0K", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["zK", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "zK", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["fqc", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "fqc", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["Rho1atm", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", {
                   "Rho1atm", "EOSPotassium`"}, False},
                 ButtonNote->"EOSPotassium`",
                 Evaluator->Automatic], ""}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.31666666666666665`]}}}],
             ImageMargins->{{10, 0}, {0, 2}}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellLabel->"Out[2]=",
 CellID->134890732,ExpressionUUID->"846a5501-7522-4bce-ba43-3a9a68246524"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Potassium viscosity equation of state for gaseous \
phase only (cP)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"etaKVap", "[", 
                    RowBox[{
                    RowBox[{"EOSPotassium`Private`T_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumberQ", "[", "#1", "]"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"QuantityQ", "[", "#1", "]"}], "&&", 
                    RowBox[{"CompatibleUnitQ", "[", 
                    RowBox[{"#1", ",", "\"Kelvins\""}], "]"}]}], ")"}]}], 
                    "&"}], ")"}]}], ",", 
                    RowBox[{"EOSPotassium`Private`\[Rho]_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumberQ", "[", "#1", "]"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"QuantityQ", "[", "#1", "]"}], "&&", 
                    RowBox[{"CompatibleUnitQ", "[", 
                    RowBox[{"#1", ",", 
                    FractionBox["\"Grams\"", 
                    SuperscriptBox["\"Centimeters\"", "3"]]}], "]"}]}], 
                    ")"}]}], "&"}], ")"}]}], ",", 
                    RowBox[{"EOSPotassium`Private`opts", ":", 
                    RowBox[{"OptionsPattern", "[", 
                    RowBox[{"{", 
                    RowBox[{"TtransVapK", ",", "NdNtcVapK", ",", "etaKVap"}], 
                    "}"}], "]"}]}]}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"etalKVap", "[", 
                    
                    RowBox[{
                    "EOSPotassium`Private`T", ",", 
                    "EOSPotassium`Private`\[Rho]", ",", 
                    "EOSPotassium`Private`opts"}], "]"}], "+", 
                    RowBox[{"etaKnuKVap", "[", 
                    
                    RowBox[{
                    "EOSPotassium`Private`T", ",", 
                    "EOSPotassium`Private`\[Rho]", ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "EOSPotassium`Private`opts", "}"}], ",", 
                    RowBox[{"Options", "[", "etaKVap", "]"}]}], "]"}]}], 
                    "]"}]}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{
                   "EOSPotassium`Private`etaKVapDefaultUnit", 
                    "\[Rule]", "\<\"Centipoise\"\>"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"EOSPotassium`etaKVap\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Potassium viscosity equation of state for gaseous \
phase only (cP)\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Potassium viscosity equation of state for gaseous phase only (cP)", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, EOSPotassium`etaKVap, {EOSPotassium`etaKVap[
         PatternTest[
          Pattern[EOSPotassium`Private`T, 
           Blank[]], Or[
           NumberQ[#], 
           And[
            QuantityQ[#], 
            CompatibleUnitQ[#, "Kelvins"]]]& ], 
         PatternTest[
          Pattern[EOSPotassium`Private`\[Rho], 
           Blank[]], Or[
           NumberQ[#], 
           And[
            QuantityQ[#], 
            CompatibleUnitQ[#, "Grams"/"Centimeters"^3]]]& ], 
         Pattern[EOSPotassium`Private`opts, 
          
          OptionsPattern[{
           EOSPotassium`TtransVapK, EOSPotassium`NdNtcVapK, 
            EOSPotassium`etaKVap}]]] :> 
       EOSPotassium`etalKVap[
         EOSPotassium`Private`T, EOSPotassium`Private`\[Rho], 
          EOSPotassium`Private`opts] + 
        EOSPotassium`etaKnuKVap[
         EOSPotassium`Private`T, EOSPotassium`Private`\[Rho], 
          FilterRules[{EOSPotassium`Private`opts}, 
           Options[EOSPotassium`etaKVap]]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {EOSPotassium`Private`etaKVapDefaultUnit -> "Centipoise"}, 
    "Attributes" -> {}, "FullName" -> "EOSPotassium`etaKVap"], 
   False]]], "Print",
 CellTags->"Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0",
 CellID->142792662,ExpressionUUID->"ab37514f-4326-428c-a421-0f1b5dece839"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8bd2a6a3-a2a6-4c30-8727-f1c6e3d630df"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265,ExpressionUUID->"a7f993f4-d265-410a-b93c-c7e258220d0a"],

Cell["List of public constants", "ExampleText",
 CellID->119396994,ExpressionUUID->"49dc6f48-6d33-4192-8d56-8f0ec27248a4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"EoSnames", " ", "=", " ", 
   RowBox[{"Names", "[", "\"\<EOSPotassium`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Select", "[", 
  RowBox[{"EoSnames", " ", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "Constant"}], "]"}], 
    "&"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Select", "[", 
  RowBox[{"EoSnames", " ", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], "]"}], 
    "&"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->73625607,ExpressionUUID->"bb8ee9ff-669e-47c1-92f7-432c199b2567"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"fN1atm\"\>", ",", "\<\"K0K\"\>", ",", "\<\"K0star1atm\"\>", 
   ",", "\<\"MK\"\>", ",", "\<\"nBK\"\>", ",", "\<\"PcK\"\>", 
   ",", "\<\"rhocK\"\>", ",", "\<\"TcK\"\>", ",", "\<\"TmpK\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->7776651,ExpressionUUID->"7236a8cb-6893-44ad-9822-550866bb9017"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"LvK\"\>", ",", "\<\"PsatK\"\>", ",", "\<\"Rho1atm\"\>", 
   ",", "\<\"RhoSatLiqK\"\>", ",", "\<\"RhoSatVapK\"\>", ",", "\<\"zK\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->649635590,ExpressionUUID->"b73d0819-a74d-4348-8ced-3ebc374af7b6"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"98dd2e8b-f1c3-467d-985f-c0d55180607d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"fe7d2929-b809-4335-9171-cda038c4661f"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"f36972e6-5f22-483c-938b-cebc58500343"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"2577891f-70e8-4160-bcb2-655a0a9c675f"],

Cell[TextData[ButtonBox["EOSPotassium package",
 BaseStyle->"Hyperlink",
 ButtonData->{
   FrontEnd`FileName[{
     ParentDirectory[
      ParentDirectory[]], "Guides"}, "EOSPotassium.nb", CharacterEncoding -> 
    "UTF-8"], None}]], "RelatedLinks",
 CellID->358645181,ExpressionUUID->"4e0d7611-cc55-47a1-aa42-ff416d64be99"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"3ad66b90-9a4f-4d77-84f5-6cae494b3da7"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EOSPotassiumFunctions",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 20.8283000}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "EOSPotassiumFunctions[] List of public functions and parameters for the \
package \"EOSPotassium\"", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "EOSPotassiumFunctions", "titlemodifier" -> "", "windowtitle" -> 
    "EOSPotassiumFunctions", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/EOSPotassiumFunctions", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"a79bbac9-cd75-44fe-90ce-51dd0f9bbd86"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4262, 110, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bd026344-84fb-4aad-ad8d-17e16c1154c0",
   CellTags->"PrimaryExamplesSection",
   CellID->852254883]},
 "Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0"->{
  Cell[21807, 539, 13307, 329, 88, "Print",ExpressionUUID->"ab37514f-4326-428c-a421-0f1b5dece839",
   CellTags->"Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0",
   CellID->142792662]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39994, 1005},
 {"Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0", 40217, 1009}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[593, 21, 2662, 58, 53, "AnchorBarGrid",ExpressionUUID->"ba7fb41c-8608-434d-b45f-3a6ce130b038",
 CellID->1],
Cell[CellGroupData[{
Cell[3280, 83, 406, 9, 54, "ObjectNameGrid",ExpressionUUID->"c349553c-1b1a-49b6-ae5d-a1c3f42f5da6"],
Cell[3689, 94, 536, 11, 112, "Usage",ExpressionUUID->"6a4f92a7-767d-41a0-ab98-1256a017a433",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4262, 110, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bd026344-84fb-4aad-ad8d-17e16c1154c0",
 CellTags->"PrimaryExamplesSection",
 CellID->852254883],
Cell[CellGroupData[{
Cell[4722, 125, 307, 7, 30, "ExampleSection",ExpressionUUID->"a61a3499-a233-40f8-8cbb-dc43d821cbc9",
 CellID->67572922],
Cell[5032, 134, 176, 3, 27, "Input",ExpressionUUID->"a03478c4-1c4e-4471-ba12-4c436b5935fe",
 CellID->496469109],
Cell[5211, 139, 141, 1, 38, "ExampleText",ExpressionUUID->"c8d20291-0a8b-4ef5-a54c-481312daa9b2",
 CellID->299615588],
Cell[CellGroupData[{
Cell[5377, 144, 166, 3, 27, "Input",ExpressionUUID->"04f828da-2e0d-48f1-991d-6bf7457071c4",
 CellID->52331864],
Cell[5546, 149, 16258, 388, 315, "Output",ExpressionUUID->"846a5501-7522-4bce-ba43-3a9a68246524",
 CellID->134890732],
Cell[21807, 539, 13307, 329, 88, "Print",ExpressionUUID->"ab37514f-4326-428c-a421-0f1b5dece839",
 CellTags->"Info-3644de5e-9dd6-45c5-af4a-15202b53e0a0",
 CellID->142792662]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35163, 874, 300, 7, 70, "ExampleSection",ExpressionUUID->"a7f993f4-d265-410a-b93c-c7e258220d0a",
 CellID->1293636265],
Cell[35466, 883, 122, 1, 70, "ExampleText",ExpressionUUID->"49dc6f48-6d33-4192-8d56-8f0ec27248a4",
 CellID->119396994],
Cell[CellGroupData[{
Cell[35613, 888, 705, 20, 70, "Input",ExpressionUUID->"bb8ee9ff-669e-47c1-92f7-432c199b2567",
 CellID->73625607],
Cell[36321, 910, 352, 7, 35, "Output",ExpressionUUID->"7236a8cb-6893-44ad-9822-550866bb9017",
 CellID->7776651],
Cell[36676, 919, 297, 6, 35, "Output",ExpressionUUID->"b73d0819-a74d-4348-8ced-3ebc374af7b6",
 CellID->649635590]
}, Open  ]]
}, Closed]],
Cell[37000, 929, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"98dd2e8b-f1c3-467d-985f-c0d55180607d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37123, 934, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"f36972e6-5f22-483c-938b-cebc58500343",
 CellID->1584193535],
Cell[37396, 943, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"2577891f-70e8-4160-bcb2-655a0a9c675f"],
Cell[37485, 945, 324, 7, 70, "RelatedLinks",ExpressionUUID->"4e0d7611-cc55-47a1-aa42-ff416d64be99",
 CellID->358645181]
}, Open  ]],
Cell[37824, 955, 78, 0, 70, "FooterCell",ExpressionUUID->"3ad66b90-9a4f-4d77-84f5-6cae494b3da7"]
}
]
*)

(* End of internal cache information *)

