(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19319,        529]
NotebookOptionsPosition[     13322,        395]
NotebookOutlinePosition[     15569,        454]
CellTagsIndexPosition[     15484,        449]
WindowTitle->K0K
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "9d08ea8e-9335-4b28-9559-2eed2fe2fdd7"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"bba85221-f5f6-4e96-a982-53b2497c9dc3"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"TcK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"TcK.nb", None}, "paclet*"], 
         Part[
          Part[{{"TcK", {"TcK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"TcK", {"TcK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "fd37198f-3197-43e6-8435-3a0d28289721"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"c5cd7a83-c63f-487a-ae14-ba136f57576f"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/K0K\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/K0K"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/K0K.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22186], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/K0K", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b853219a-7e44-45de-b322-9c83fdfd9069"]
    }], "AnchorBar",ExpressionUUID->"d88ee072-c77b-4fc0-b099-05c03ef5c06c"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"2f02ceb0-5e3a-4b03-b1fc-d7bd3beb3abe"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["K0K", "ObjectName",ExpressionUUID->
  "28ba2c26-4504-448d-b755-3e5ab3fc0099"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"57ce4020-01d1-444a-a83f-97f04546d300"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "78bf743a-b925-43ac-a0e0-f616a4fbeb7a"]
}], "ObjectNameGrid",ExpressionUUID->"2fdca59a-f07b-41ee-9d07-1d2dfd26fd93"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "Characteristic elastic constant ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "0"]],ExpressionUUID->
      "f7ddc2d8-9954-4176-b3d5-20023ec165ed"],
     " (dyne/",
     Cell[BoxData[
      SuperscriptBox["cm", "2"]], "InlineFormula",ExpressionUUID->
      "3d07b3b5-dd08-4121-8a9d-f3f440377f0e"],
     ")"
    }],ExpressionUUID->"cc4eb3a3-222f-4b20-9f65-399bf6b57f63"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"3b04dae5-706e-4694-8355-bb98ba7a27d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"d5b00701-9527-40b6-b529-79e5155daec8"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"1c5a265e-7779-4c4e-96df-707ae6de45c9"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c9646d6b-55d0-4199-8334-c7558b444803"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->23741556,ExpressionUUID->"3fe0abd7-5fcb-460b-b508-ca59d000c0fa"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"dc1f85dc-ed3c-46ba-9954-fe008959bdba"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  SubscriptBox[
   StyleBox["K",
    FontSlant->"Italic"], "0"], "=", 
  RowBox[{
   FractionBox[
    RowBox[{"12", " ", 
     SuperscriptBox["\[Pi]", "2"]}], "nB"], 
   FractionBox[
    RowBox[{"R", " ", "Tc"}], 
    RowBox[{
    "M", "/", 
     "rhoc"}]]}]}]],ExpressionUUID->"3e51dbda-290c-4195-ba13-884cc1ec24b4"]], \
"Notes",
 CellID->151172198,ExpressionUUID->"e795c9ec-5a4c-4bfe-946f-a423fad14df3"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"3ffe25ea-352c-492b-aac4-4f3d6a8cddd1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"96f1f1c3-ee5a-452c-9512-2bdbee2ad6f4"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "0e12f6cc-1e98-400a-a757-0aa806514d44"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->530030185,ExpressionUUID->"49140407-c5cc-4916-80ad-2423ef135744"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8827914d-c6fb-4582-b47a-cae7a947d43c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->432420875,ExpressionUUID->"3422cd62-4df3-41b8-bbe7-64446ebcc314"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80955877,ExpressionUUID->"5750ec0e-b093-4d9a-9eb1-2ca430c5d1bd"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"b2995c27-3d97-4112-8900-fe6097638f76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"K0K", ",", 
   RowBox[{"\"\<Dynes\>\"", "/", 
    SuperscriptBox["\"\<Centimeters\>\"", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"ee9c9e44-2ed6-41f4-b848-e453315b322e"],

Cell[BoxData[
 TemplateBox[{"5.4309`*^10", 
   RowBox[{"\"dynes\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "2"]}], "dynes per centimeter squared", 
   FractionBox["\"Dynes\"", 
    SuperscriptBox["\"Centimeters\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->684714056,ExpressionUUID->"df5f4d48-38ff-4f14-b549-a068de0caafd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"5.4309`*^10", ",", 
     FractionBox["\"\<Dynes\>\"", 
      SuperscriptBox["\"\<Centimeters\>\"", "2"]]}], "]"}], ",", 
   "\"\<Gigapascals\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->159318302,ExpressionUUID->"710213a8-f2f6-4ab9-8af9-10344af088e0"],

Cell[BoxData[
 TemplateBox[{"5.4309`", "\"GPa\"", "gigapascals", "\"Gigapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->428847643,ExpressionUUID->"9d8c6a86-0ff9-4bf8-98de-7cf34c77f796"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5dcd3a1a-ebfd-4111-8d8d-e71db5703b69"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265,ExpressionUUID->"bab0b57c-1748-4d03-8209-42c7d3642620"],

Cell[TextData[{
 "Using the theoretical formula for calculating ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["K",
    FontSlant->"Italic"], "0"]], "InlineFormula",ExpressionUUID->
  "3ead4455-5fea-40c6-a800-c2b182b172f2"]
}], "ExampleText",
 CellID->31510039,ExpressionUUID->"e1957636-c707-44fa-9309-1b532f80ae20"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Rcgs", "=", "8.3145192448*^7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"12", " ", 
      SuperscriptBox["\[Pi]", "2"]}], "nBK"], 
    FractionBox[
     RowBox[{"Rcgs", " ", "TcK"}], 
     RowBox[{"MK", "/", "rhocK"}]]}], ",", 
   RowBox[{"\"\<Dynes\>\"", "/", 
    SuperscriptBox["\"\<Centimeters\>\"", "2"]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->584630418,ExpressionUUID->"eaab2fe2-23c1-4e5b-9408-2662037f8ba4"],

Cell[BoxData[
 TemplateBox[{"5.430895629686778`*^10", 
   RowBox[{"\"dynes\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "2"]}], "dynes per centimeter squared", 
   FractionBox["\"Dynes\"", 
    SuperscriptBox["\"Centimeters\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->408702684,ExpressionUUID->"61334a91-2417-477a-89fd-222b21b3e044"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"5.4309`*^10", ",", 
    FractionBox["\"\<Dynes\>\"", 
     SuperscriptBox["\"\<Centimeters\>\"", "2"]]}], "]"}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[2]:=",
 CellID->75643728,ExpressionUUID->"baac27b3-6627-4dd5-8c2a-f1a2aa4c0977"],

Cell[BoxData[
 TemplateBox[{"5.4309`", "\"GPa\"", "gigapascals", "\"Gigapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->502754686,ExpressionUUID->"d2d9230e-f8b1-41b0-a4c4-d88cffb60702"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"00d6be9d-6a00-4652-844e-59afcfb0a73c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"a6e41e91-4944-4b34-84e9-b07fbcfd80a3"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"2edfc6da-8464-48f0-be0e-b6242f965bc7"],

Cell[TextData[StyleBox[ButtonBox["TcK",
 BaseStyle->"Hyperlink",
 ButtonData->{"TcK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->137559089,ExpressionUUID->"b74e6351-d7ac-43a0-af24-b0977dd5e7bb"],

Cell[TextData[StyleBox[ButtonBox["rhocK",
 BaseStyle->"Hyperlink",
 ButtonData->{"rhocK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->244008291,ExpressionUUID->"a8334ed6-d5d5-461c-bcc8-a55990454611"],

Cell[TextData[StyleBox[ButtonBox["MK",
 BaseStyle->"Hyperlink",
 ButtonData->{"MK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->193111846,ExpressionUUID->"2d2bc552-b232-4733-9188-1f18822f3b52"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"5def4188-8fe5-4ff6-b119-ca6a200375ea"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"9dcf49e6-df04-4432-a3d7-88449f6d2fa7"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"7fa7a931-bf41-4ccd-90f2-c50eadeab5c3"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "1eefa29f-d9d8-4580-8fcc-2ee4982a5cc9"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"e715464c-168c-40d3-9066-5b3de9758d98"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"2e5f177c-915c-4943-b563-f87f7de93180"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"K0K",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 40.5602981}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Characteristic elastic constant K0 (dyne/cm^2)", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "K0K", "titlemodifier" -> "", "windowtitle" -> 
    "K0K", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/K0K", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"d03a33be-0ea8-4787-aae9-41d1d17ba2b2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6788, 188, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"49140407-c5cc-4916-80ad-2423ef135744",
   CellTags->"PrimaryExamplesSection",
   CellID->530030185]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15286, 442}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 3600, 83, 53, "AnchorBarGrid",ExpressionUUID->"2f02ceb0-5e3a-4b03-b1fc-d7bd3beb3abe",
 CellID->1],
Cell[CellGroupData[{
Cell[4200, 108, 388, 9, 54, "ObjectNameGrid",ExpressionUUID->"2fdca59a-f07b-41ee-9d07-1d2dfd26fd93"],
Cell[4591, 119, 645, 17, 90, "Usage",ExpressionUUID->"3b04dae5-706e-4694-8355-bb98ba7a27d1",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5273, 141, 854, 21, 37, "NotesSection",ExpressionUUID->"3fe0abd7-5fcb-460b-b508-ca59d000c0fa",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->23741556],
Cell[6130, 164, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"dc1f85dc-ed3c-46ba-9954-fe008959bdba"],
Cell[6219, 166, 443, 15, 70, "Notes",ExpressionUUID->"e795c9ec-5a4c-4bfe-946f-a423fad14df3",
 CellID->151172198],
Cell[6665, 183, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"3ffe25ea-352c-492b-aac4-4f3d6a8cddd1"]
}, Closed]],
Cell[CellGroupData[{
Cell[6788, 188, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"49140407-c5cc-4916-80ad-2423ef135744",
 CellTags->"PrimaryExamplesSection",
 CellID->530030185],
Cell[CellGroupData[{
Cell[7248, 203, 308, 7, 30, "ExampleSection",ExpressionUUID->"3422cd62-4df3-41b8-bbe7-64446ebcc314",
 CellID->432420875],
Cell[7559, 212, 175, 3, 27, "Input",ExpressionUUID->"5750ec0e-b093-4d9a-9eb1-2ca430c5d1bd",
 CellID->80955877],
Cell[7737, 217, 139, 1, 38, "ExampleText",ExpressionUUID->"b2995c27-3d97-4112-8900-fe6097638f76",
 CellID->886239600],
Cell[CellGroupData[{
Cell[7901, 222, 263, 6, 31, "Input",ExpressionUUID->"ee9c9e44-2ed6-41f4-b848-e453315b322e",
 CellID->21488140],
Cell[8167, 230, 389, 8, 50, "Output",ExpressionUUID->"df5f4d48-38ff-4f14-b549-a068de0caafd",
 CellID->684714056]
}, Open  ]],
Cell[CellGroupData[{
Cell[8593, 243, 381, 10, 45, "Input",ExpressionUUID->"710213a8-f2f6-4ab9-8af9-10344af088e0",
 CellID->159318302],
Cell[8977, 255, 208, 4, 43, "Output",ExpressionUUID->"9d8c6a86-0ff9-4bf8-98de-7cf34c77f796",
 CellID->428847643]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9234, 265, 300, 7, 30, "ExampleSection",ExpressionUUID->"bab0b57c-1748-4d03-8209-42c7d3642620",
 CellID->1293636265],
Cell[9537, 274, 315, 8, 70, "ExampleText",ExpressionUUID->"e1957636-c707-44fa-9309-1b532f80ae20",
 CellID->31510039],
Cell[CellGroupData[{
Cell[9877, 286, 537, 15, 70, "Input",ExpressionUUID->"eaab2fe2-23c1-4e5b-9408-2662037f8ba4",
 CellID->584630418],
Cell[10417, 303, 400, 8, 50, "Output",ExpressionUUID->"61334a91-2417-477a-89fd-222b21b3e044",
 CellID->408702684]
}, Open  ]],
Cell[CellGroupData[{
Cell[10854, 316, 332, 8, 70, "Input",ExpressionUUID->"baac27b3-6627-4dd5-8c2a-f1a2aa4c0977",
 CellID->75643728],
Cell[11189, 326, 208, 4, 43, "Output",ExpressionUUID->"d2d9230e-f8b1-41b0-a4c4-d88cffb60702",
 CellID->502754686]
}, Open  ]]
}, Closed]],
Cell[11424, 334, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"00d6be9d-6a00-4652-844e-59afcfb0a73c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11547, 339, 260, 7, 73, "SeeAlsoSection",ExpressionUUID->"2edfc6da-8464-48f0-be0e-b6242f965bc7",
 CellID->1255426704],
Cell[11810, 348, 208, 4, 24, "SeeAlso",ExpressionUUID->"b74e6351-d7ac-43a0-af24-b0977dd5e7bb",
 CellID->137559089],
Cell[12021, 354, 212, 4, 24, "SeeAlso",ExpressionUUID->"a8334ed6-d5d5-461c-bcc8-a55990454611",
 CellID->244008291],
Cell[12236, 360, 206, 4, 24, "SeeAlso",ExpressionUUID->"2d2bc552-b232-4733-9188-1f18822f3b52",
 CellID->193111846]
}, Open  ]],
Cell[CellGroupData[{
Cell[12479, 369, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"9dcf49e6-df04-4432-a3d7-88449f6d2fa7",
 CellID->1584193535],
Cell[12752, 378, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"7fa7a931-bf41-4ccd-90f2-c50eadeab5c3"],
Cell[12841, 380, 384, 10, 70, "RelatedLinks",ExpressionUUID->"e715464c-168c-40d3-9066-5b3de9758d98",
 CellID->426751138]
}, Open  ]],
Cell[13240, 393, 78, 0, 70, "FooterCell",ExpressionUUID->"2e5f177c-915c-4943-b563-f87f7de93180"]
}
]
*)

(* End of internal cache information *)

