(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39421,        927]
NotebookOptionsPosition[     33418,        795]
NotebookOutlinePosition[     35703,        854]
CellTagsIndexPosition[     35618,        849]
WindowTitle->LvK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "ee1969b9-bd63-411e-b6be-dfb7bc4660d6"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"92efc68a-6370-415d-b99a-a975bf68fb94"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"K0K\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"K0K.nb", None}, "paclet*"], 
         Part[
          Part[{{"K0K", {"K0K.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"K0K", {"K0K.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "564256b0-d47e-49d4-9fae-c93ddb64d00c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"4ae92215-cbb2-490a-ab5d-0c9e91b81c57"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/LvK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/LvK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/LvK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22567], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/LvK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "aaad1c0a-d7aa-409b-b09f-8d731037042f"]
    }], "AnchorBar",ExpressionUUID->"8909e54e-f1a1-488a-a097-e26760a27432"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"c16cedb6-329b-44fe-b4ef-7b8fc2c5554e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["LvK", "ObjectName",ExpressionUUID->
  "fa24aa32-f0c3-4f04-af91-b96200d2c71b"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"3507a364-96c4-4eb4-926d-dafb6fe1f2e8"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "87ec1b39-4a09-43e2-9409-d7497e73374e"]
}], "ObjectNameGrid",ExpressionUUID->"dfb68ce6-0f9d-4eee-9640-ce4495332f83"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LvK", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "e3378785-9029-445a-9a05-938c66159104"],
     " \[LineSeparator]Latent heat of vaporisation (kJ/mole) of potassium as \
a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"]
    }],ExpressionUUID->"f6520ebb-8e7d-4a0a-b92d-0cbd6644e2b4"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"ab3a7bda-853e-4d0a-be27-0b3e4b9468cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"17afe04d-b221-446f-a40e-2cd7b18d3e72"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"26c55004-5beb-409c-aba4-6640abd66a13"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"98ef49ff-bca6-46d5-bc1e-2d0173e51054"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->574048245,ExpressionUUID->"f6632696-6048-43f0-a08b-ec9b14f655b6"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"9708fcad-4eb5-4cad-b4be-afb5210fd7d1"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "3179aafe-2d19-4026-8310-bea3eecfb946"]
}], "Notes",
 CellID->34465061,ExpressionUUID->"422b8796-003c-4e57-af12-a8b782237a88"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->61130633,ExpressionUUID->"4605cdf5-621f-47c7-9951-0e35da44ee44"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"d09e60fd-a349-493b-877a-1d6f5d2df1fa"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"49426755-6855-474d-be0c-c0822657d768"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "38e7f008-74e5-49ab-96f1-5c702ff01116"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->71608616,ExpressionUUID->"6eaa8a09-a5e1-4a6f-bd9b-cff763d338d2"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "57b069da-31bb-42d0-b98f-f1c5dc3cdb57"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->118719792,ExpressionUUID->"eb96bc1c-64c0-4eae-bef7-1d42aab54455"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"de413f2f-79e6-4262-9951-afa11f9c8bac"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"e867b8cc-4b7c-437b-ad7b-47ec560950d1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LvK", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"LvK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LvK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"4ba0ed5e-e9ae-438a-9202-0e344d27eb84"],

Cell[BoxData["76.93000366203853`"], "Output",
 CellLabel->"Out[2]=",
 CellID->268843409,ExpressionUUID->"c37eae2e-580c-4263-a112-6f809bc03b2d"],

Cell[BoxData[
 TemplateBox[{"76.93000366203853`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "kilojoules per mole", 
   FractionBox["\"Kilojoules\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->24799328,ExpressionUUID->"ac98366f-3d7d-4377-95fc-d8f824ba12ea"],

Cell[BoxData[
 TemplateBox[{"76.93000366203853`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "kilojoules per mole", 
   FractionBox["\"Kilojoules\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->78833533,ExpressionUUID->"b757f579-e33e-4f82-9531-29c2578f008f"]
}, Open  ]],

Cell[TextData[{
 "Plot of the latent heat of vaporisation from TmpK K to ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "f943130a-7dda-4ac5-ac8f-092419fd9580"]
}], "Notes",
 CellID->562280440,ExpressionUUID->"fccdbe83-79df-41e1-9ca7-b3ccc4f1e22e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LvK", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"L\", \"v\"],FontSlant->\"Italic\"]\) \
(kJ/mole)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"TcK", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C.P.\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2100", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118189269,ExpressionUUID->"5a03eb43-2cde-4c6a-ba83-df3b7ebdff92"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k8lF0UB3CqNxIpUZISUYoiikT8lH3L8mRtQQoVQtZZDGYQkq3IOkNK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       "]]},
     Annotation[#, "Charting`Private`Tag$20612#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65003849693875`, 0},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[Large], 
    PointBox[{2223, 0}], 
    InsetBox[
     FormBox["\"C.P.\"", TraditionalForm], {2100, 1}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"L\\\", \
\\\"v\\\"],FontSlant->\\\"Italic\\\"]\\) (kJ/mole)\"", TraditionalForm], 
     None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->172588200,ExpressionUUID->"189d4b91-64ad-4abf-a4c4-23d48403827c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3817e6f8-b96f-439c-ae3d-7c8a157f7272"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"e7e8cecb-c11f-464f-8ecf-8ea1caa303de"],

Cell[TextData[{
 "Comparison of the latent heat of vaporisation with the elastic constant ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["K",
    FontSlant->"Italic"], "0"]], "InlineFormula",ExpressionUUID->
  "be7986d9-2d1b-407f-914b-7d5cbc3158c4"]
}], "Notes",
 CellID->599359993,ExpressionUUID->"e5f0d2af-4745-4a57-a6bf-360dfba37463"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LvK", "[", "T", "]"}], "*", 
    RowBox[{
     RowBox[{"RhoSatLiqK", "[", "T", "]"}], "/", "MK"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"L\", \"v\"],FontSlant->\"Italic\"]\) \
(kJ/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5.4309"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[StyleBox[\"K\",FontSlant->\"Italic\"], \
\"0\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"100", ",", "5.4"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16595954,ExpressionUUID->"871daad1-3401-48ae-ade4-cf8d50a7d503"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk8VdsXAHAUoqcQFZWpPLwGFK9QrVWhFPHEVTRIVFQIdzY9mXqRMZni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       "]]},
     Annotation[#, "Charting`Private`Tag$25966#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[Large], 
    PointBox[{0, 5.4309}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"K\\\",FontSlant->\\\"Italic\\\"], \
\\\"0\\\"]\\)\"", TraditionalForm], {100, 5.4}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"L\\\", \
\\\"v\\\"],FontSlant->\\\"Italic\\\"]\\) \
(kJ/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", TraditionalForm], 
     None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, {0, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[1]=",
 CellID->283919859,ExpressionUUID->"6d79d8e9-3454-4494-a8a0-8d36cb96d08a"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"8c61d8ea-23ff-47da-8249-2d52335327ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"245e1543-444a-4c64-a23e-81ed97f45aa9"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"639c7061-d5bb-4ce9-9a09-60cf9d761dbc"],

Cell[TextData[StyleBox[ButtonBox["K0K",
 BaseStyle->"Hyperlink",
 ButtonData->{"K0K.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"93e0ea9c-ab34-4a02-b188-6a11a363d8d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"d8decae5-53ba-4ca3-b871-f0af90a362d7"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"bda09cfd-d1bb-4df2-8f84-888961428358"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"5e93a197-8aa3-480d-9a50-e934f92f3762"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "3c8a872e-ebd8-423c-92cc-8277d17c6391"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"066e2479-4064-41bd-ad09-3fd806216d3e"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"6ad7f295-3c3c-4b2d-a071-29b44dbf3a4a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LvK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 42.2412988}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "LvK[T] Latent heat of vaporisation (kJ/mole) of potassium as a function \
of temperature T", "synonyms" -> {}, "tabletags" -> {}, "title" -> "LvK", 
    "titlemodifier" -> "", "windowtitle" -> "LvK", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/LvK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"96c5b6ec-d45a-4754-90a5-db4556203446"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6971, 194, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6eaa8a09-a5e1-4a6f-bd9b-cff763d338d2",
   CellTags->"PrimaryExamplesSection",
   CellID->71608616]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35421, 842}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 3600, 83, 53, "AnchorBarGrid",ExpressionUUID->"c16cedb6-329b-44fe-b4ef-7b8fc2c5554e",
 CellID->1],
Cell[CellGroupData[{
Cell[4200, 108, 388, 9, 54, "ObjectNameGrid",ExpressionUUID->"dfb68ce6-0f9d-4eee-9640-ce4495332f83"],
Cell[4591, 119, 625, 15, 112, "Usage",ExpressionUUID->"ab3a7bda-853e-4d0a-be27-0b3e4b9468cc",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5253, 139, 855, 21, 37, "NotesSection",ExpressionUUID->"f6632696-6048-43f0-a08b-ec9b14f655b6",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->574048245],
Cell[6111, 162, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"9708fcad-4eb5-4cad-b4be-afb5210fd7d1"],
Cell[6200, 164, 450, 15, 70, "Notes",ExpressionUUID->"422b8796-003c-4e57-af12-a8b782237a88",
 CellID->34465061],
Cell[6653, 181, 192, 6, 70, "Notes",ExpressionUUID->"4605cdf5-621f-47c7-9951-0e35da44ee44",
 CellID->61130633],
Cell[6848, 189, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"d09e60fd-a349-493b-877a-1d6f5d2df1fa"]
}, Closed]],
Cell[CellGroupData[{
Cell[6971, 194, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"6eaa8a09-a5e1-4a6f-bd9b-cff763d338d2",
 CellTags->"PrimaryExamplesSection",
 CellID->71608616],
Cell[CellGroupData[{
Cell[7430, 209, 308, 7, 30, "ExampleSection",ExpressionUUID->"eb96bc1c-64c0-4eae-bef7-1d42aab54455",
 CellID->118719792],
Cell[7741, 218, 175, 3, 27, "Input",ExpressionUUID->"de413f2f-79e6-4262-9951-afa11f9c8bac",
 CellID->87419684],
Cell[7919, 223, 298, 5, 57, "ExampleText",ExpressionUUID->"e867b8cc-4b7c-437b-ad7b-47ec560950d1",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8242, 232, 481, 12, 60, "Input",ExpressionUUID->"4ba0ed5e-e9ae-438a-9202-0e344d27eb84",
 CellID->419134748],
Cell[8726, 246, 143, 2, 36, "Output",ExpressionUUID->"c37eae2e-580c-4263-a112-6f809bc03b2d",
 CellID->268843409],
Cell[8872, 250, 339, 8, 45, "Output",ExpressionUUID->"ac98366f-3d7d-4377-95fc-d8f824ba12ea",
 CellID->24799328],
Cell[9214, 260, 339, 8, 45, "Output",ExpressionUUID->"b757f579-e33e-4f82-9531-29c2578f008f",
 CellID->78833533]
}, Open  ]],
Cell[9568, 271, 318, 8, 36, "Notes",ExpressionUUID->"fccdbe83-79df-41e1-9ca7-b3ccc4f1e22e",
 CellID->562280440],
Cell[CellGroupData[{
Cell[9911, 283, 1068, 28, 60, "Input",ExpressionUUID->"5a03eb43-2cde-4c6a-ba83-df3b7ebdff92",
 CellID->118189269],
Cell[10982, 313, 12156, 226, 258, "Output",ExpressionUUID->"189d4b91-64ad-4abf-a4c4-23d48403827c",
 CellID->172588200]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23187, 545, 306, 7, 70, "ExampleSection",ExpressionUUID->"e7e8cecb-c11f-464f-8ecf-8ea1caa303de",
 CellID->258228157],
Cell[23496, 554, 336, 8, 70, "Notes",ExpressionUUID->"e5f0d2af-4745-4a57-a6bf-360dfba37463",
 CellID->599359993],
Cell[CellGroupData[{
Cell[23857, 566, 1473, 40, 70, "Input",ExpressionUUID->"871daad1-3401-48ae-ade4-cf8d50a7d503",
 CellID->16595954],
Cell[25333, 608, 6584, 134, 261, "Output",ExpressionUUID->"6d79d8e9-3454-4494-a8a0-8d36cb96d08a",
 CellID->283919859]
}, Open  ]]
}, Closed]],
Cell[31944, 746, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"8c61d8ea-23ff-47da-8249-2d52335327ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32067, 751, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"639c7061-d5bb-4ce9-9a09-60cf9d761dbc",
 CellID->1255426704],
Cell[32330, 760, 208, 4, 70, "SeeAlso",ExpressionUUID->"93e0ea9c-ab34-4a02-b188-6a11a363d8d9",
 CellID->234329647]
}, Open  ]],
Cell[CellGroupData[{
Cell[32575, 769, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"bda09cfd-d1bb-4df2-8f84-888961428358",
 CellID->1584193535],
Cell[32848, 778, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"5e93a197-8aa3-480d-9a50-e934f92f3762"],
Cell[32937, 780, 384, 10, 70, "RelatedLinks",ExpressionUUID->"066e2479-4064-41bd-ad09-3fd806216d3e",
 CellID->426751138]
}, Open  ]],
Cell[33336, 793, 78, 0, 70, "FooterCell",ExpressionUUID->"6ad7f295-3c3c-4b2d-a071-29b44dbf3a4a"]
}
]
*)

(* End of internal cache information *)

