(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     51679,       1133]
NotebookOptionsPosition[     47010,       1027]
NotebookOutlinePosition[     49234,       1085]
CellTagsIndexPosition[     49148,       1080]
WindowTitle->MK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "1f013c4f-2a6b-402b-bb40-3e5ac243b49a"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox[
       InterpretationBox[Cell[TextData[{
         "URL",
         StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
          StripOnInput->False]
        }],ExpressionUUID->"953336df-6284-4f0b-8a11-c0f9aace4ba4"],
        TextCell[
         Row[{"URL", 
           Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
       StripOnInput->False], {"\<\"EOSPotassium/ref/MK\"\>":>
      None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["EOSPotassium/ref/MK"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/language/EOSPotassium/ref/MK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
           False]]; SelectionMove[
        DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
            If[
             TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$22950], 
             "http://reference.wolfram.com/system-modeler/", 
             "http://reference.wolfram.com/language/"], "EOSPotassium/ref/MK",
             ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic,
      MenuStyle->"URLMenu"]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "dff09287-4462-4383-a420-a70213b43679"]], "AnchorBar",ExpressionUUID->
     "bcfb381e-9cb3-4764-8589-2057d13fe039"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"95925e84-8291-4392-bb6d-9000c6c727c0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["MK", "ObjectName",ExpressionUUID->
  "287a27d4-378d-469a-978c-4c30b8d0f1ec"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"1f4d5c11-7a6d-404d-bc63-25ae68286f8c"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "d9fe5367-9271-4fcf-88ec-49f1332baed6"]
}], "ObjectNameGrid",ExpressionUUID->"038ed276-dbd4-4dc2-973a-38a0c777a523"],

Cell["Molar mass of Potassium (g/mole)", "Usage",
 CellID->982511436,ExpressionUUID->"34f89280-9959-4779-9e74-2d5a8a779821"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"67644344-a492-48cf-8a95-25487dc6138d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3a3e912c-5a6b-41be-8a99-ba51c04a5212"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->127574241,ExpressionUUID->"0e3dab49-ac91-4d57-9784-dcd32ea3b920"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "57e31412-0190-4b3e-b999-27e7b5127511"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->35623928,ExpressionUUID->"9732cbb2-39f6-47c2-be34-b8743ebea673"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80955877,ExpressionUUID->"04251a32-b039-4360-8324-c2a6c48a8a07"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"acc518e0-7aa3-4153-8c0e-d6c425103c00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"MK", ",", "\"\<g/mol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"e7018f12-ccd0-49b2-a78a-8207992443d0"],

Cell[BoxData[
 TemplateBox[{"39.0983`", 
   RowBox[{
    "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "grams per mole", 
   FractionBox["\"Grams\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->99177784,ExpressionUUID->"5cf0c4ee-cde0-4f75-937a-4bde1ab16c9c"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->169290125,ExpressionUUID->"3b215892-4d87-4027-bcca-723c5b965c7e"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "molar mass of potassium", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Entity[\"Chemical\", \"Potassium\"][EntityProperty[\"Chemical\", \
\"MolarMass\"]]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {
        "Entity[\"Chemical\", \"Potassium\"][EntityProperty[\"Chemical\", \
\"MolarMass\"]]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Potassium"}, 
                    "SRString" :> $CellContext`GeneralData[
                    ChemicalData, "Potassium", "SpokenName"]]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"molar mass\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ChemicalData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"PubChem"}], "\n   "}], 
       XMLElement[
       "minput", {}, {
        "Entity[\"Chemical\", \"Potassium\"][EntityProperty[\"Chemical\", \
\"MolarMass\"]]"}], 
       XMLElement["moutput", {}, {"Quantity[39.0983, \"Grams\"/\"Moles\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["39.0983", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "39.0983", "SRString" -> "39.0983"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"grams per mole\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversion", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.0390983", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "0.0390983", "SRString" -> "0.0390983"]],
                     "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilograms per mole\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons", "scanner" -> "Unit", "id" -> 
     "ComparisonAsMolarMass", "position" -> "400", "error" -> "false", 
     "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox["\"( \"", {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               
               TemplateBox[{"\"\"", "0", "\".\"", "0", "5", "4"}, 
                "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "18", "\" ) \""}, 
                 "RowDefault"], {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molar mass of fullerene\"", FontFamily -> "Helvetica", 
                FontSize -> Smaller, StripOnInput -> False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["721", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "721", "SRString" -> "721"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox["\"( \"", {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               TemplateBox[{"\"\"", "0", "\".\"", "2"}, "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "5", "\" ) \""}, 
                 "RowDefault"], {
                 GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}], 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molar mass of caffeine\"", FontFamily -> "Helvetica", 
                FontSize -> Smaller, StripOnInput -> False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["194", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "194", "SRString" -> "194"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "6", "7"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molar mass of sodium chloride\"", FontFamily -> "Helvetica",
                 FontSize -> Smaller, StripOnInput -> False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["58", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "58", "SRString" -> "58"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Corresponding quantities", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "2"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Mass of a molecule ", 
                    Cell[
                    BoxData[
                    FormBox["m", TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"m", "\[LongEqual]", 
                    
                    RowBox[{"M", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SubscriptBox["N", "A"]}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Mass of a molecule ", 
                    $CellContext`CalculateSymbol["m"], " from ", 
                    $CellContext`InlineForm[
                    "m \[LongEqual] M/Subscript[N, A]"], ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"6.5", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-23"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.5", "\[Times]", 
                    SuperscriptBox["10", "-23"]}], "SRString" -> 
                    "6.5 times 10 to the negative 23"], SyntaxForm -> 
                    CenterDot], "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"grams\"", {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"6.5", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-26"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.5", "\[Times]", 
                    SuperscriptBox["10", "-26"]}], "SRString" -> 
                    "6.5 times 10 to the negative 26"], SyntaxForm -> 
                    CenterDot], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"kg\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["39", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "39", "SRString" -> "39"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"u\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unified atomic mass units\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["39", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "39", "SRString" -> "39"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Da\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"daltons\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Relative molecular mass ", 
                    Cell[
                    BoxData[
                    FormBox[
                    SubscriptBox["M", "r"], TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{
                    SubscriptBox["M", "r"], "\[LongEqual]", 
                    RowBox[{
                    SubscriptBox["M", "u"], "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "M"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Relative molecular mass ", 
                    $CellContext`CalculateSymbol[
                    Subscript["M", "r"]], " from ", 
                    $CellContext`InlineForm[
                    "Subscript[M, r] \[LongEqual] Subscript[M, u]/M "], 
                    ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["39", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "39", "SRString" -> "39"]]}], 
                    Identity], #& , SyntaxForm -> Dot], "Unit", SyntaxForm -> 
                    Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "2"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False, False, False}, True}, 
   Typeset`aux5$$ = {True, False, {False, False}, True}, 
   Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["assumptions", {"count" -> "1"}, {
      XMLElement[
      "assumption", {
       "type" -> "Clash", "word" -> "potassium", "template" -> 
        "Assuming \"potassium\" is a chemical compound${separator}Use as \
${desc} instead", "count" -> "2", "pulldown" -> "false", "default" -> 
        "{\"C\", \"potassium\"} -> {\"Chemical\", \"dflt\"}"}, {
        XMLElement[
        "value", {
         "name" -> "Chemical", "desc" -> "a chemical compound", "input" -> 
          "{\"C\", \"potassium\"} -> {\"Chemical\"}"}, {}], 
        XMLElement[
        "value", {
         "name" -> "ChemicalIntermediate", "desc" -> "an ion", "input" -> 
          "{\"C\", \"potassium\"} -> {\"ChemicalIntermediate\"}"}, {}]}]}], 
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www5b.wolframalpha.com/sources/\
ChemicalDataSourceInformationNotes.html", "text" -> "Chemical data"}, {}]}]}, 
   Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True], 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "5", "datatypes" -> "Chemical", "timedout" -> "", 
    "timedoutpods" -> "", "timing" -> "1.669", "parsetiming" -> "0.648", 
    "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP2721145g2hgcg01g70b600002c5gab14eg7eba6h", "host" -> 
    "https://www5b.wolframalpha.com", "server" -> "51", "related" -> 
    "https://www5b.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa2722145g2hgcg01g70b6000033ac5b887ca61dgg5606516680789693320", "version" -> 
    "2.6", "inputstring" -> "molar mass of potassium"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2021, 10, 22, 12, 36, 8.5666448`8.685385727400593}, "Line" -> 
    2, "SessionID" -> 30611214936435106855}, Typeset`showpods$$ = {1, 2, 3, 4,
    5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Entity[\"Chemical\", \"Potassium\"][EntityProperty[\"Chemical\", \
\"MolarMass\"]]"}, Typeset`open$$ = True, Typeset`newq$$ = 
   "molar mass of potassium"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{32.220703125, {6.09765625, 8.279296875}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[9]:=",
 CellID->331515729,ExpressionUUID->"6280b42b-15ce-4637-89ec-984e40256a22"],

Cell[BoxData[
 TemplateBox[{"39.0983`6.", 
   RowBox[{
    "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "grams per mole", 
   FractionBox["\"Grams\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[9]=",
 CellID->311652563,ExpressionUUID->"51ad738e-7405-4498-97a3-e2ee2aeb1c90"]
}, Open  ]],

Cell["Without WolframAlpha", "ExampleText",
 CellID->441700581,ExpressionUUID->"71662d67-80a8-44ce-95b5-9544aab1fba4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Potassium\>\"", ",", "\"\<MolarMass\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->485811775,ExpressionUUID->"620eda29-d95d-46a9-a743-38bfbf1b5a81"],

Cell[BoxData[
 TemplateBox[{"39.0983`6.", 
   RowBox[{
    "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "grams per mole", 
   FractionBox["\"Grams\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->447888171,ExpressionUUID->"d32c9de5-2533-4f80-a276-561eaccf3643"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"7604468a-152a-40dc-9415-4e04e9c8a546"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"88e8a69e-5797-4429-9b51-11ee71424192"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"58816cfa-6c05-48dd-be03-b510b64f525d"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"be044b45-83b9-49c6-a95f-52ded43ef636"],

Cell[TextData[Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "0db3b016-d6d5-4656-82a7-1fa15774331b"]],ExpressionUUID->"07902ffe-e809-\
4fc0-a8a1-e5719a5fdc48"]], "RelatedLinks",
 CellID->1038487239,ExpressionUUID->"f9b0d332-790f-4eb3-b7c6-75caa380821e"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"cede0e37-0567-413f-be2f-a045000f99c8"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 43.9333022}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> "Molar mass of Potassium (g/mole)", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "MK", "titlemodifier" -> 
    "", "windowtitle" -> "MK", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/MK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"d2e68a4f-aab5-4f5f-89c9-594a2af954b2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3713, 98, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0e3dab49-ac91-4d57-9784-dcd32ea3b920",
   CellTags->"PrimaryExamplesSection",
   CellID->127574241]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48951, 1073}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 2563, 56, 53, "AnchorBarGrid",ExpressionUUID->"95925e84-8291-4392-bb6d-9000c6c727c0",
 CellID->1],
Cell[CellGroupData[{
Cell[3162, 81, 387, 9, 54, "ObjectNameGrid",ExpressionUUID->"038ed276-dbd4-4dc2-973a-38a0c777a523"],
Cell[3552, 92, 124, 1, 41, "Usage",ExpressionUUID->"34f89280-9959-4779-9e74-2d5a8a779821",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3713, 98, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0e3dab49-ac91-4d57-9784-dcd32ea3b920",
 CellTags->"PrimaryExamplesSection",
 CellID->127574241],
Cell[CellGroupData[{
Cell[4173, 113, 307, 7, 30, "ExampleSection",ExpressionUUID->"9732cbb2-39f6-47c2-be34-b8743ebea673",
 CellID->35623928],
Cell[4483, 122, 175, 3, 27, "Input",ExpressionUUID->"04251a32-b039-4360-8324-c2a6c48a8a07",
 CellID->80955877],
Cell[4661, 127, 139, 1, 38, "ExampleText",ExpressionUUID->"acc518e0-7aa3-4153-8c0e-d6c425103c00",
 CellID->886239600],
Cell[CellGroupData[{
Cell[4825, 132, 194, 4, 27, "Input",ExpressionUUID->"e7018f12-ccd0-49b2-a78a-8207992443d0",
 CellID->21488140],
Cell[5022, 138, 318, 8, 47, "Output",ExpressionUUID->"5cf0c4ee-cde0-4f75-937a-4bde1ab16c9c",
 CellID->99177784]
}, Open  ]],
Cell[5355, 149, 116, 1, 38, "ExampleText",ExpressionUUID->"3b215892-4d87-4027-bcca-723c5b965c7e",
 CellID->169290125],
Cell[CellGroupData[{
Cell[5496, 154, 39423, 805, 35, "WolframAlphaShortInput",ExpressionUUID->"6280b42b-15ce-4637-89ec-984e40256a22",
 CellID->331515729],
Cell[44922, 961, 321, 8, 47, "Output",ExpressionUUID->"51ad738e-7405-4498-97a3-e2ee2aeb1c90",
 CellID->311652563]
}, Open  ]],
Cell[45258, 972, 118, 1, 38, "ExampleText",ExpressionUUID->"71662d67-80a8-44ce-95b5-9544aab1fba4",
 CellID->441700581],
Cell[CellGroupData[{
Cell[45401, 977, 218, 4, 27, "Input",ExpressionUUID->"620eda29-d95d-46a9-a743-38bfbf1b5a81",
 CellID->485811775],
Cell[45622, 983, 321, 8, 47, "Output",ExpressionUUID->"d32c9de5-2533-4f80-a276-561eaccf3643",
 CellID->447888171]
}, Open  ]]
}, Open  ]],
Cell[45970, 995, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"7604468a-152a-40dc-9415-4e04e9c8a546"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46093, 1000, 270, 7, 73, "RelatedLinksSection",ExpressionUUID->"58816cfa-6c05-48dd-be03-b510b64f525d",
 CellID->1584193535],
Cell[46366, 1009, 86, 0, 14, "SectionHeaderSpacer",ExpressionUUID->"be044b45-83b9-49c6-a95f-52ded43ef636"],
Cell[46455, 1011, 458, 11, 26, "RelatedLinks",ExpressionUUID->"f9b0d332-790f-4eb3-b7c6-75caa380821e",
 CellID->1038487239]
}, Open  ]],
Cell[46928, 1025, 78, 0, 70, "FooterCell",ExpressionUUID->"cede0e37-0567-413f-be2f-a045000f99c8"]
}
]
*)

(* End of internal cache information *)

