(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39457,        863]
NotebookOptionsPosition[     32987,        723]
NotebookOutlinePosition[     35503,        787]
CellTagsIndexPosition[     35383,        781]
WindowTitle->NdNtcVapK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "ec50576f-618a-421b-8b13-c5965c0a9d93"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox[
       InterpretationBox[Cell[TextData[{
         "URL",
         StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
          StripOnInput->False]
        }],ExpressionUUID->"13fb11c2-2bf8-46ec-a612-6fa62ced3d30"],
        TextCell[
         Row[{"URL", 
           Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
       StripOnInput->False], {"\<\"EOSPotassium/ref/NdNtcVapK\"\>":>
      None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["EOSPotassium/ref/NdNtcVapK"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/language/EOSPotassium/ref/\
NdNtcVapK.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
            Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
            If[
             TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$23341], 
             "http://reference.wolfram.com/system-modeler/", 
             "http://reference.wolfram.com/language/"], 
            "EOSPotassium/ref/NdNtcVapK", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic,
      MenuStyle->"URLMenu"]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "a3895faf-fdcc-4f40-9fea-c148981d59cc"]], "AnchorBar",ExpressionUUID->
     "0d588841-0f07-4166-b54e-d4b0e6238173"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"0235aa5e-955e-40d5-a82c-928d6dc1f339"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["NdNtcVapK", "ObjectName",ExpressionUUID->
  "1bfece5a-e4f8-438e-b7df-a11c948da924"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"9e154444-0265-4556-87c1-e5bf6af3cf4c"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "5c945677-c89f-45d1-ad09-e8357f1db925"]
}], "ObjectNameGrid",ExpressionUUID->"0b95d061-6dc3-4141-8ef2-177804082fce"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NdNtcVapK", "[", "\[Rho]", "]"}]], "InlineFormula",
      ExpressionUUID->"3ce2c7b0-fd51-4d28-815b-fd1112b54eb2"],
     " \[LineSeparator]Reduced coherence length ",
     StyleBox["N",
      FontSlant->"Italic"],
     " as a function of density \[Rho]"
    }],ExpressionUUID->"ad36bc80-b670-4360-a1fc-7d0c7a63eb06"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"e8734391-95d7-44d3-8e67-bc937c18e461"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"950b4dc2-f1c5-4167-a8dd-e729a6d3a6b9"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"a7219186-4293-4c53-b851-c02862cba251"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"1bf0d825-0182-4b03-809c-98b9527b9559"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->164994888,ExpressionUUID->"d107d2db-3fc3-4f73-a526-d436a6093afd"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"2078c8af-7121-4bfa-a619-d8a1536e1292"],

Cell["\<\
The function is only valid for densities corresponding to the gaseous states \
of potassium.\
\>", "Notes",
 CellID->275640577,ExpressionUUID->"9b3f738c-1f40-4f02-a846-6c743bfbba70"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "5fd3d80b-d098-462f-94ab-dc70bd25f704"],
 " is calculated using its dilute-gas limit form: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "56fc7296-5390-4b77-8f43-402c61a8d5c7"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "N0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "2"]}]], "InlineFormula",
  ExpressionUUID->"ad51836a-8c50-4ad2-8fcd-ea317a3c9dcc"],
 " "
}], "Notes",
 CellID->819145981,ExpressionUUID->"4b77a620-fb37-4b90-83d3-9d6be35e3883"],

Cell[TextData[{
 "By default the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "2da7bed7-c9c7-4334-9dff-fef4578d978e"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"78ffe401-2830-42ac-98e3-a9ffff9f79c6"],

Cell["The following options can be given: ", "Notes",
 CellID->179552320,ExpressionUUID->"fa249ada-b47f-471c-997b-b4355e8e4f30"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "d4b36cbb-4ecd-41e7-a106-09edbcb88609"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "db10a02e-cda7-4f09-a788-f456fa2672aa"]
    }], "TableText",ExpressionUUID->"7f3327ac-2d70-4d72-bfee-843dcbff2938"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "2f41fa46-2aff-4f27-976f-9e2a5f10811e"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"bfb736e5-97f5-442c-902d-0339369f65e7"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->22767193,ExpressionUUID->"c4273376-23f0-40ed-ba77-c1229930e41c"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"bd98fbe0-7a54-42b4-9be9-8eb7bdc4c808"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"cfa4a322-4061-4203-8b89-66d5955e8cf5"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "6e9fa374-249b-4b43-94c5-ab8f9d20120b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->395535899,ExpressionUUID->"0e8aeb79-7290-4cdc-b454-1f82b54e9e81"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "d67b0518-0d8b-4990-a876-ef30f6d0c3cf"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->777823342,ExpressionUUID->"377fc0a4-4d63-4449-b3d2-acc95cf92b8d"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"8251de84-5c75-4e2e-9d99-ffd6cb39875d"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"883b2df0-8b4a-4ffd-879e-78826bc613af"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NdNtcVapK", "[", 
  RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NdNtcVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
    RowBox[{"\"\<Grams\>\"", "/", 
     SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"NdNtcVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
    "\"\<kg/m^3\>\""}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"2e4aa6b5-eeee-4353-8112-6660eb54a074"],

Cell[BoxData["4.092751219613019`"], "Output",
 CellLabel->"Out[2]=",
 CellID->329213206,ExpressionUUID->"c9005097-030c-43b3-a85e-47ed3a7e07d7"],

Cell[BoxData["4.092751219613019`"], "Output",
 CellLabel->"Out[2]=",
 CellID->480995427,ExpressionUUID->"9b97e01a-7053-4bfc-8421-59e8caa03c9f"],

Cell[BoxData["4.092751219613019`"], "Output",
 CellLabel->"Out[2]=",
 CellID->437951646,ExpressionUUID->"e6e265f8-2edc-4168-8d74-431e5b116423"]
}, Open  ]],

Cell["\<\
Plot of NdNtcVapK along the vapor coexistence curve from the melting point to \
the critical one\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"2ef3e7f8-ef1a-4c0a-bf95-b16c74d77fdf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"NdNtcVapK", "[", 
    RowBox[{"RhoSatVapK", "[", "T", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"N\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58108706,ExpressionUUID->"78126afd-c409-4781-9681-1a5037c647ec"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3dtbFNf+5/E9MzdzOf/C/BdzO5dz+5tnLpPsZCfmsEOSbdK/7GSzk3jA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    "], {{0, 226.5}, {360., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{360., 226.5},
  PlotRange->{{0, 360.}, {0, 226.5}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->215694931,ExpressionUUID->"afe5706c-0d5b-42c3-8ad1-7e0802ba1c27"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a94d014a-360c-4ff4-b4f0-1c818cb6d473"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"477c66fb-a853-4ddb-9f2c-a177a9a36f57"],

Cell[TextData[{
 "Considering that ",
 StyleBox["N",
  FontSlant->"Italic"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "0f351556-a4b2-4fec-9c16-4ab2abbc03d2"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"3985c406-cf35-4f3f-921e-ef8bc2c0aad5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NdNtcVapK", "[", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"With", " ", 
    RowBox[{"Hsieh", "'"}], "s", " ", "parameters"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"NdNtcVapK", "[", 
  RowBox[{
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
   RowBox[{"Coefd", "->", "5"}], ",", 
   RowBox[{"CoefN", "->", "0.0540234"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"3ca4c759-6259-42b4-b4c4-0d17c2a43df8"],

Cell[BoxData["4.092751219613019`"], "Output",
 CellLabel->"Out[1]=",
 CellID->2481387,ExpressionUUID->"98bdfceb-e739-420e-82ec-8ef4393b110b"],

Cell[BoxData["1.8354046811882099`"], "Output",
 CellLabel->"Out[1]=",
 CellID->4487770,ExpressionUUID->"9f637e95-5f55-42c1-bb2d-b2b276012cad"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"9da338c2-84ff-4690-a094-4cf82f96bff9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"44385454-2f5b-4929-b1eb-8a7ee1641823"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"8e170d7a-3ac3-41ed-8638-e5c93a57f9e6"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d5625250-f4b3-42b4-9bc7-a5a24849f3ac"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "1d46a9e8-68fc-4ee9-820c-bb35866adb56"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"6e7aca61-5ad1-4765-9774-e57203c963d8"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"592b82e7-e757-4389-9ea1-67d349c6a419"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NdNtcVapK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 46.9832997}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "NdNtcVapK[\\[Rho]] Reduced coherence length N as a function of density \
\\[Rho]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "NdNtcVapK", 
    "titlemodifier" -> "", "windowtitle" -> "NdNtcVapK", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/NdNtcVapK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"7baf3b0c-3655-44fe-97b2-fd279b1b1246"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8075, 221, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0e8aeb79-7290-4cdc-b454-1f82b54e9e81",
   CellTags->"PrimaryExamplesSection",
   CellID->395535899]},
 "RasterizedOutput"->{
  Cell[11341, 316, 18848, 315, 248, "Output",ExpressionUUID->"afe5706c-0d5b-42c3-8ad1-7e0802ba1c27",
   CellTags->"RasterizedOutput",
   CellID->215694931]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35004, 770},
 {"RasterizedOutput", 35202, 774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[581, 21, 2590, 56, 53, "AnchorBarGrid",ExpressionUUID->"0235aa5e-955e-40d5-a82c-928d6dc1f339",
 CellID->1],
Cell[CellGroupData[{
Cell[3196, 81, 394, 9, 54, "ObjectNameGrid",ExpressionUUID->"0b95d061-6dc3-4141-8ef2-177804082fce"],
Cell[3593, 92, 573, 13, 112, "Usage",ExpressionUUID->"e8734391-95d7-44d3-8e67-bc937c18e461",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4203, 110, 855, 21, 37, "NotesSection",ExpressionUUID->"d107d2db-3fc3-4f73-a526-d436a6093afd",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->164994888],
Cell[5061, 133, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"2078c8af-7121-4bfa-a619-d8a1536e1292"],
Cell[5150, 135, 192, 4, 70, "Notes",ExpressionUUID->"9b3f738c-1f40-4f02-a846-6c743bfbba70",
 CellID->275640577],
Cell[5345, 141, 825, 28, 70, "Notes",ExpressionUUID->"4b77a620-fb37-4b90-83d3-9d6be35e3883",
 CellID->819145981],
Cell[6173, 171, 273, 6, 70, "Notes",ExpressionUUID->"78ffe401-2830-42ac-98e3-a9ffff9f79c6",
 CellID->1067943069],
Cell[6449, 179, 128, 1, 70, "Notes",ExpressionUUID->"fa249ada-b47f-471c-997b-b4355e8e4f30",
 CellID->179552320],
Cell[6580, 182, 1369, 32, 70, "3ColumnTableMod",ExpressionUUID->"c4273376-23f0-40ed-ba77-c1229930e41c",
 CellID->22767193],
Cell[7952, 216, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"bd98fbe0-7a54-42b4-9be9-8eb7bdc4c808"]
}, Closed]],
Cell[CellGroupData[{
Cell[8075, 221, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"0e8aeb79-7290-4cdc-b454-1f82b54e9e81",
 CellTags->"PrimaryExamplesSection",
 CellID->395535899],
Cell[CellGroupData[{
Cell[8535, 236, 308, 7, 30, "ExampleSection",ExpressionUUID->"377fc0a4-4d63-4449-b3d2-acc95cf92b8d",
 CellID->777823342],
Cell[8846, 245, 175, 3, 27, "Input",ExpressionUUID->"8251de84-5c75-4e2e-9d99-ffd6cb39875d",
 CellID->87419684],
Cell[9024, 250, 294, 5, 57, "ExampleText",ExpressionUUID->"883b2df0-8b4a-4ffd-879e-78826bc613af",
 CellID->544149791],
Cell[CellGroupData[{
Cell[9343, 259, 674, 17, 63, "Input",ExpressionUUID->"2e4aa6b5-eeee-4353-8112-6660eb54a074",
 CellID->218515404],
Cell[10020, 278, 143, 2, 36, "Output",ExpressionUUID->"c9005097-030c-43b3-a85e-47ed3a7e07d7",
 CellID->329213206],
Cell[10166, 282, 143, 2, 36, "Output",ExpressionUUID->"9b97e01a-7053-4bfc-8421-59e8caa03c9f",
 CellID->480995427],
Cell[10312, 286, 143, 2, 36, "Output",ExpressionUUID->"e6e265f8-2edc-4168-8d74-431e5b116423",
 CellID->437951646]
}, Open  ]],
Cell[10470, 291, 202, 4, 38, "ExampleText",ExpressionUUID->"2ef3e7f8-ef1a-4c0a-bf95-b16c74d77fdf",
 CellID->119396994],
Cell[CellGroupData[{
Cell[10697, 299, 641, 15, 44, "Input",ExpressionUUID->"78126afd-c409-4781-9681-1a5037c647ec",
 CellID->58108706],
Cell[11341, 316, 18848, 315, 248, "Output",ExpressionUUID->"afe5706c-0d5b-42c3-8ad1-7e0802ba1c27",
 CellTags->"RasterizedOutput",
 CellID->215694931]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30238, 637, 323, 7, 70, "ExampleSection",ExpressionUUID->"477c66fb-a853-4ddb-9f2c-a177a9a36f57",
 CellID->1020263627],
Cell[30564, 646, 557, 16, 70, "ExampleText",ExpressionUUID->"3985c406-cf35-4f3f-921e-ef8bc2c0aad5",
 CellID->111367501],
Cell[CellGroupData[{
Cell[31146, 666, 559, 14, 70, "Input",ExpressionUUID->"3ca4c759-6259-42b4-b4c4-0d17c2a43df8",
 CellID->138125379],
Cell[31708, 682, 141, 2, 35, "Output",ExpressionUUID->"98bdfceb-e739-420e-82ec-8ef4393b110b",
 CellID->2481387],
Cell[31852, 686, 142, 2, 35, "Output",ExpressionUUID->"9f637e95-5f55-42c1-bb2d-b2b276012cad",
 CellID->4487770]
}, Open  ]]
}, Closed]],
Cell[32021, 692, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"9da338c2-84ff-4690-a094-4cf82f96bff9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32144, 697, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"8e170d7a-3ac3-41ed-8638-e5c93a57f9e6",
 CellID->1584193535],
Cell[32417, 706, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d5625250-f4b3-42b4-9bc7-a5a24849f3ac"],
Cell[32506, 708, 384, 10, 70, "RelatedLinks",ExpressionUUID->"6e7aca61-5ad1-4765-9774-e57203c963d8",
 CellID->426751138]
}, Open  ]],
Cell[32905, 721, 78, 0, 70, "FooterCell",ExpressionUUID->"592b82e7-e757-4389-9ea1-67d349c6a419"]
}
]
*)

(* End of internal cache information *)

