(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     59537,       1294]
NotebookOptionsPosition[     54952,       1189]
NotebookOutlinePosition[     57193,       1248]
CellTagsIndexPosition[     57107,       1243]
WindowTitle->PcK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "cf25ae9c-b881-4dc3-bf85-f93f31b7332c"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"3e5e17f9-64f0-4283-897c-6b67f2f9858a"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"rhocK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"rhocK.nb", None}, "paclet*"], 
         Part[
          Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "920e02e8-dccc-45b8-af76-d3f5ea449ea1"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"b06661e1-4a7a-43f9-8a33-5429954039d9"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/PcK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/PcK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/PcK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$23714], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/PcK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0a925b28-9b81-4e8d-bfdb-b5636444a531"]
    }], "AnchorBar",ExpressionUUID->"a3382593-eee6-47f0-abb4-15d08436236a"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"10ba7f39-61c9-4b85-b022-4212a8f0a12a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["PcK", "ObjectName",ExpressionUUID->
  "938b0fd3-76fa-410d-b751-1c1f814e7119"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"ccde39c4-48a5-4c44-b069-c9bf7f09dc0b"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "8b9b14a2-1e66-41d3-a202-6939cb70e2c0"]
}], "ObjectNameGrid",ExpressionUUID->"4321c299-9e22-46c7-b411-d5fe140b097a"],

Cell["Potassium critical point pressure (bar)", "Usage",
 CellID->982511436,ExpressionUUID->"a90a7d62-a0cb-4efd-ae40-a6be59d830ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"19b8a1d5-54b0-497c-8bf0-0b0b3d8f9b6d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a78b896d-f576-429e-9706-580d684d0343"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->158996900,ExpressionUUID->"917ec756-d30b-4ea4-a185-c9159e78a623"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a03572eb-f740-440e-a1c7-3d078d70ed68"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->421510623,ExpressionUUID->"dae24956-fa26-4c63-ba86-39d6802af5ce"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"43c50f17-bade-4832-b0d2-299056f831f5"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"95429cfb-b75b-4500-87a6-357939ff6ac5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"PcK", ",", "\"\<Bars\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"0f0d8033-e766-471a-8d93-fd1d19b693c2"],

Cell[BoxData[
 TemplateBox[{"162.12`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->360039028,ExpressionUUID->"076b8d40-1d94-4e84-8366-2785c4a921f0"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"fa7d4c2b-3c56-462d-b8fe-e62cfc1902f4"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Critical pressure of Potassium", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Result", 1, 1, "Output", "Quantity[16., \"Megapascals\"]"}, 
      "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "Input", "numsubpods" -> "1", 
     "position" -> "100", "scanner" -> "Identity", "title" -> 
     "Input interpretation"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {
        "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"CriticalPressure\"]]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Potassium"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"critical pressure\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "Result", "numsubpods" -> "1", 
     "position" -> "200", "primary" -> "true", "scanner" -> "Data", "title" -> 
     "Result"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ElementData"}], "\n   "}], 
       XMLElement["moutput", {}, {"Quantity[16., \"Megapascals\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["16", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "16", "SRString" -> "16"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"MPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"megapascals\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {
                 StyleBox[
                  
                  RowBox[{
                   "\"(\"", "\[NoBreak]", 
                    "\"value estimated based on extrapolation\"", 
                    "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}}, GridBoxAlignment -> {
                "Columns" -> {Left}, "Rows" -> {{Baseline}}}, AutoDelete -> 
               False, GridBoxBackground -> {"Columns" -> {{None}}}, 
               GridBoxFrame -> {"Columns" -> None, "Rows" -> None}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, FrameStyle -> 
               GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "UnitConversion", "numsubpods" -> "5", 
     "position" -> "300", "scanner" -> "Unit", "title" -> 
     "Unit conversions"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.016", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "0.016", "SRString" -> "0.016"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"GPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"gigapascals\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"1.6", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "7"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"1.6", "\[Times]", 
                    SuperscriptBox["10", "7"]}], "SRString" -> 
                    "1.6 times 10 to the 7"], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"pascals\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"1.6", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "7"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"1.6", "\[Times]", 
                    SuperscriptBox["10", "7"]}], "SRString" -> 
                    "1.6 times 10 to the 7"], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"N\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"newtons per square meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1600", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1600", "SRString" -> "1600"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"tf\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"metric tons\[Hyphen]force per square meter\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["160", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "160", "SRString" -> "160"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"atmospheres\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                 LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0,
                  ZeroWidthTimes -> False]}, {
                TemplateBox[{"\" \"", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unit officially deprecated\"", 
                    "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{0}}}], "Column"], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "5"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "UnitConversion__More"}, {}]}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "ComparisonAsCriticalPressure", 
     "numsubpods" -> "3", "position" -> "400", "scanner" -> "Unit", "title" -> 
     "Comparisons as pressure"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "8"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"pressure of a typical aluminum scuba tank\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "20", "SRString" -> "20"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"MPa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox[
               "\"water pressure in the core of a nuclear reactor\"", 
                FontFamily -> "Helvetica", FontSize -> Smaller, StripOnInput -> 
                False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"1.6", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "7"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"1.6", "\[Times]", 
                    SuperscriptBox["10", "7"]}], "SRString" -> 
                    "1.6 times 10 to the 7"], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "1", "\".\"", "3"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"bite pressure of a hippopotamus\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               TemplateBox[{"\" \"", 
                 StyleBox[
                  RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"\[MediumSpace]\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1800", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1800", "SRString" -> "1800"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"psi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}, "RowDefault"]}, "RowDefault"], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"error" -> "false", "id" -> "CorrespondingQuantity", "numsubpods" -> 
     "1", "position" -> "500", "scanner" -> "Unit", "title" -> 
     "Corresponding quantity"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Depth of water ", 
                    Cell[
                    BoxData[
                    FormBox["d", TraditionalForm]]], 
                    " giving gauge pressure ", 
                    Cell[
                    BoxData[
                    FormBox[
                    SubscriptBox["p", "e"], TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{
                    SubscriptBox["p", "e"], "\[LongEqual]", 
                    RowBox[{
                    SubscriptBox["\[Rho]", 
                    RowBox[{
                    SubscriptBox[
                    StyleBox["H", Plain, StripOnInput -> False], 
                    TagBox["2", HoldForm]], "\[InvisibleSpace]", 
                    "\[InvisibleSpace]", "\[InvisibleSpace]", 
                    StyleBox["O", Plain, StripOnInput -> False]}]], 
                    "\[InvisibleSpace]", "g", "\[InvisibleSpace]", "h"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Depth of water ", 
                    $CellContext`CalculateSymbol["d"], 
                    " giving gauge pressure ", 
                    $CellContext`CalculateSymbol[
                    Subscript["p", "e"]], " from ", 
                    $CellContext`InlineForm[
                    "Subscript[p, e] \[LongEqual] Subscript[\[Rho], \
Row[{Subscript[Style[H, Plain], 2], Style[O, Plain]}]] g h"], ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.6", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1.6", "SRString" -> "1.6"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"km\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilometers\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1", "SRString" -> "1"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"mile\"", {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["5353", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "5353", "SRString" -> "5353"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"feet\"", {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {"", 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"assuming conventional water density \[TildeTilde] \"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1000", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1000", "SRString" -> "1000"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, "RowDefault"], "\[NoBreak]",
                     "\")\""}], {FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  AutoDelete -> False, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, Typeset`aux4$$ = {
   True, False, {False, False, False}, True}, Typeset`aux5$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www5a.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True], 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "5", "datatypes" -> "Element", "timedout" -> "", 
    "timedoutpods" -> "", "timing" -> "1.609", "parsetiming" -> "0.496", 
    "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP32361idc99hb534ga0gc00002d95h0574dcbf65a", "host" -> 
    "https://www5a.wolframalpha.com", "server" -> "14", "related" -> 
    "https://www5a.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa32371idc99hb534ga0gc00003hb98aei0h850f329125245285920578042", "version" -> 
    "2.6", "inputstring" -> "Critical pressure of Potassium"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2021, 10, 22, 16, 52, 34.8996277`9.295395690469139}, "Line" -> 
    10, "SessionID" -> 30611313738972297531}, Typeset`showpods$$ = {1, 2, 3, 
   4, 5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Output", "Quantity[16., \"Megapascals\"]"}, 
   Typeset`open$$ = True, Typeset`newq$$ = "Critical pressure of Potassium"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{32.220703125, {6.09765625, 8.279296875}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[10]:=",
 CellID->27521301,ExpressionUUID->"7c9bf4cb-ab76-436e-b116-be3b4eeeab39"],

Cell[BoxData[
 TemplateBox[{"16.`", "\"MPa\"", "megapascals", "\"Megapascals\""},
  "Quantity"]], "Output",
 CellLabel->"Out[10]=",
 CellID->386399991,ExpressionUUID->"797f8e22-fa23-44d8-bfbf-07025e8af76d"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"bc606f84-e709-43ea-a5e2-bcf8d6723692"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"a10bb484-7822-4dff-a104-6f7cef464fe9"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"f8949d9e-f2ee-4388-973d-b80a8fcfe8e1"],

Cell[TextData[StyleBox[ButtonBox["rhocK",
 BaseStyle->"Hyperlink",
 ButtonData->{"rhocK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->205382791,ExpressionUUID->"4a18eebb-44a7-48cf-9838-5283d001f52b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"f722d05f-8431-4f11-9a63-619852deb4de"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"0ef351a7-b272-46f3-9008-520be53b3f86"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"f6378913-6e3a-4f0f-9758-bf9eccd62740"],

Cell[TextData[Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "6408aac0-20b1-4de0-a263-11c3f9b44c87"]],ExpressionUUID->"8b3f2790-d7f4-\
47b8-9e75-4b50edb723e4"]], "RelatedLinks",
 CellID->1038487239,ExpressionUUID->"8f222690-19b9-4a59-8444-ea86a343abaa"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"233f7b83-97a8-4c86-abb1-aba86d165ab1"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PcK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 48.8242981}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Potassium critical point pressure (bar)", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "PcK", "titlemodifier" -> "", "windowtitle" -> 
    "PcK", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/PcK", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"31139809-70db-448e-8814-ee32770ac847"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4771, 125, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"917ec756-d30b-4ea4-a185-c9159e78a623",
   CellTags->"PrimaryExamplesSection",
   CellID->158996900]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56909, 1236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 3612, 83, 53, "AnchorBarGrid",ExpressionUUID->"10ba7f39-61c9-4b85-b022-4212a8f0a12a",
 CellID->1],
Cell[CellGroupData[{
Cell[4212, 108, 388, 9, 54, "ObjectNameGrid",ExpressionUUID->"4321c299-9e22-46c7-b411-d5fe140b097a"],
Cell[4603, 119, 131, 1, 41, "Usage",ExpressionUUID->"a90a7d62-a0cb-4efd-ae40-a6be59d830ad",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4771, 125, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"917ec756-d30b-4ea4-a185-c9159e78a623",
 CellTags->"PrimaryExamplesSection",
 CellID->158996900],
Cell[CellGroupData[{
Cell[5231, 140, 308, 7, 30, "ExampleSection",ExpressionUUID->"dae24956-fa26-4c63-ba86-39d6802af5ce",
 CellID->421510623],
Cell[5542, 149, 175, 3, 27, "Input",ExpressionUUID->"43c50f17-bade-4832-b0d2-299056f831f5",
 CellID->87419684],
Cell[5720, 154, 139, 1, 38, "ExampleText",ExpressionUUID->"95429cfb-b75b-4500-87a6-357939ff6ac5",
 CellID->886239600],
Cell[CellGroupData[{
Cell[5884, 159, 194, 4, 27, "Input",ExpressionUUID->"0f0d8033-e766-471a-8d93-fd1d19b693c2",
 CellID->21488140],
Cell[6081, 165, 194, 4, 44, "Output",ExpressionUUID->"076b8d40-1d94-4e84-8366-2785c4a921f0",
 CellID->360039028]
}, Open  ]],
Cell[6290, 172, 116, 1, 38, "ExampleText",ExpressionUUID->"fa7d4c2b-3c56-462d-b8fe-e62cfc1902f4",
 CellID->351008126],
Cell[CellGroupData[{
Cell[6431, 177, 46733, 952, 35, "WolframAlphaShortInput",ExpressionUUID->"7c9bf4cb-ab76-436e-b116-be3b4eeeab39",
 CellID->27521301],
Cell[53167, 1131, 206, 4, 43, "Output",ExpressionUUID->"797f8e22-fa23-44d8-bfbf-07025e8af76d",
 CellID->386399991]
}, Open  ]]
}, Open  ]],
Cell[53400, 1139, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"bc606f84-e709-43ea-a5e2-bcf8d6723692"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53523, 1144, 260, 7, 73, "SeeAlsoSection",ExpressionUUID->"f8949d9e-f2ee-4388-973d-b80a8fcfe8e1",
 CellID->1255426704],
Cell[53786, 1153, 212, 4, 24, "SeeAlso",ExpressionUUID->"4a18eebb-44a7-48cf-9838-5283d001f52b",
 CellID->205382791]
}, Open  ]],
Cell[CellGroupData[{
Cell[54035, 1162, 270, 7, 73, "RelatedLinksSection",ExpressionUUID->"0ef351a7-b272-46f3-9008-520be53b3f86",
 CellID->1584193535],
Cell[54308, 1171, 86, 0, 14, "SectionHeaderSpacer",ExpressionUUID->"f6378913-6e3a-4f0f-9758-bf9eccd62740"],
Cell[54397, 1173, 458, 11, 26, "RelatedLinks",ExpressionUUID->"8f222690-19b9-4a59-8444-ea86a343abaa",
 CellID->1038487239]
}, Open  ]],
Cell[54870, 1187, 78, 0, 41, "FooterCell",ExpressionUUID->"233f7b83-97a8-4c86-abb1-aba86d165ab1"]
}
]
*)

(* End of internal cache information *)

