(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     46517,       1032]
NotebookOptionsPosition[     40489,        900]
NotebookOutlinePosition[     42790,        959]
CellTagsIndexPosition[     42705,        954]
WindowTitle->PsatK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "dc772e0f-5d05-42e9-8afe-25d538f3e711"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"8d5cfddb-e9dd-453b-8253-0ecbc675bbb1"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"PcK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"PcK.nb", None}, "paclet*"], 
         Part[
          Part[{{"PcK", {"PcK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"PcK", {"PcK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e6988078-09dc-4c1b-b687-5b417289a1de"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"270fa90d-81d3-414f-b86f-f68f052f40cc"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/PsatK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/PsatK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/PsatK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$24081], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/PsatK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a252a56c-9191-4991-8d5c-54d6a3a35856"]
    }], "AnchorBar",ExpressionUUID->"057759c1-ae93-474c-a7ce-c1efe366b8bf"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"0f92bd91-c77d-4b50-8bfe-b18266fd0311"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["PsatK", "ObjectName",ExpressionUUID->
  "7b1799b0-f816-4c96-adcb-812061e04cdb"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"29aa1f84-8e01-4bae-a0ee-4c009b63872f"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "4e834fcb-6038-46c2-a9d6-3c2129bff11c"]
}], "ObjectNameGrid",ExpressionUUID->"918e4d5b-3760-432b-9a52-f7a821619a2e"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PsatK", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "1fc160c7-148b-408f-8d34-f0bf2f2ea3bb"],
     " \[LineSeparator]Pressure (bar) of potassium along the coexistence \
curve  as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"]
    }],ExpressionUUID->"f74d2468-0985-41e6-8492-fd0728f7c5c9"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"a06c44cc-6412-41bc-ae7f-4cd1479eff7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"e1a8cb19-6f94-438f-89ff-567b396bb782"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"b74f481b-cabd-417c-9380-4dfb2af1a64b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"88adba94-12ec-4495-a8a6-5cc71e9e631d"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->231024891,ExpressionUUID->"fa12f420-32d2-46f9-87fd-21873c21bf4c"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a43454c1-dbd7-476b-8e9d-16f15b88ccb0"],

Cell[TextData[{
 "The function is defined only for 298.15 K \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "2fc264d6-c65b-457c-b8bb-c77b101eaf14"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"0e0afef9-1253-4e26-944a-a50e2ee79673"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->61130633,ExpressionUUID->"8dcb9cea-8eac-4b00-85d3-389efc848491"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"5dbe541e-2e96-4986-ba1f-9a7f417034c6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"74c2bb51-62ab-4182-9b33-d7a35d52e3ff"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "9bbb9a58-d238-4c7a-bc04-1af9e4187b1d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->490873714,ExpressionUUID->"55a9e969-9912-42be-a720-6565e4d29636"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "39affc44-4ee1-477b-82e8-ea80efcbcebe"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->775357254,ExpressionUUID->"5c3860c0-1ca0-4a84-9ce9-b0ad572a42ed"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"7c685bdf-7a91-4460-a295-380814907296"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"613bf34f-ae69-4cc5-bdd2-b76cbc67e680"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PsatK", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"PsatK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"PsatK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"22d6ffb3-e63f-4a69-97c6-45fda29bd8dd"],

Cell[BoxData["1.0132478776940865`"], "Output",
 CellLabel->"Out[2]=",
 CellID->190248927,ExpressionUUID->"38bba21e-6e06-4b58-a191-6e96af620476"],

Cell[BoxData[
 TemplateBox[{"1.0132478776940865`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->83405652,ExpressionUUID->"55608e20-8ba5-42d3-b8ce-a828f12ebf16"],

Cell[BoxData[
 TemplateBox[{"1.0132478776940865`", "\"bar\"", "bars", "\"Bars\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->36496978,ExpressionUUID->"d85eaea5-0697-4c11-9ca3-fbe66294e348"]
}, Open  ]],

Cell[TextData[{
 "Plot of the saturated vapor pressure from 298.15 K to ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "5e893e20-8254-402c-ad34-b7fe1e24c537"]
}], "Notes",
 CellID->34465061,ExpressionUUID->"2702efce-911e-4781-87a6-906a934422f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PsatK", "[", "T", "]"}], "/", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "298.15", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"P\", \
\"\[Sigma]\"],FontSlant->\"Italic\"]\) (MPa)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"TcK", ",", 
         RowBox[{"PcK", "/", "10"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C.P.\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2100", ",", "16"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118189269,ExpressionUUID->"a960e697-a488-443c-9e4b-3e80c474f987"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlnc0Fv4XxxGylZXKJioZIaM8n88tQlIJSaHwzaiU9djrMR57PCQz47ET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       "]]},
     Annotation[#, "Charting`Private`Tag$19542#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{298.15003928265304`, 0},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[Large], 
    PointBox[{2223, 16.212}], 
    InsetBox[
     FormBox["\"C.P.\"", TraditionalForm], {2100, 16}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"P\\\", \
\\\"\[Sigma]\\\"],FontSlant->\\\"Italic\\\"]\\) (MPa)\"", TraditionalForm], 
     None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->26835359,ExpressionUUID->"934439a1-b881-4417-a39f-b5b9ffeaba2c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "14d50ac3-6f68-4ebe-890a-2063b51aef37"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"58d57c73-28ca-4539-a49a-6501f770a821"],

Cell[TextData[{
 "Comparison with Caldwell ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 " [1966] equation of state"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"9e06850a-6057-4ce0-9bb4-040140b316c4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PsatCaldwell", "[", "T_", "]"}], ":=", 
    RowBox[{"0.0689475729317831", "*", 
     FractionBox["1.9714*^7", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"T", "*", "1.8"}], ")"}], "0.53299"]], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       FractionBox["18717.22", 
        RowBox[{"(", 
         RowBox[{"T", "*", "1.8"}], ")"}]]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"100", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"PsatCaldwell", "[", "T", "]"}], "-", 
        RowBox[{"PsatK", "[", "T", "]"}]}], ")"}], "/", 
      RowBox[{"PsatK", "[", "T", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "298.15", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<Deviation (%)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->163625766,ExpressionUUID->"f02243a5-ef18-4018-9bff-3e8ce501ac8a"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlnk4lN8bxiUVUiFZItlKIVmyL+eRLElIaLHmqyyp7FtIEWVnxjIztpFU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       "]]},
     Annotation[#, "Charting`Private`Tag$62511#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{298.15003928265304`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Deviation (%)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[1]=",
 CellID->241213823,ExpressionUUID->"f6b83d14-b528-43cd-8347-8fcf44a488c9"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"a6140e06-e91a-4dcb-a75b-4332cd964a54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"d111aaca-3a54-4ca0-ac38-b3e945c7e7c9"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"d14e4dc3-6445-47d1-bcdb-22831d50d6a6"],

Cell[TextData[StyleBox[ButtonBox["PcK",
 BaseStyle->"Hyperlink",
 ButtonData->{"PcK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"b014f9fc-1667-48a3-9781-394fe2a26211"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ad850703-12e7-41a0-bb63-5bca22b116dc"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"2db8dd54-7dc7-413c-acaa-40448364795b"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"460a04fb-0576-47b4-beed-510f69ccc128"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "a9d4dcc5-fd37-49a3-849b-080834e98369"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"0ddd8461-e523-4bcd-816b-2b2d9e56f65a"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"e9514402-ad0f-49c3-8206-cd41c7f33b99"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PsatK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 51.4563001}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "PsatK[T] Pressure (bar) of potassium along the coexistence curve as a \
function of temperature T", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "PsatK", "titlemodifier" -> "", "windowtitle" -> "PsatK", "type" -> 
    "Symbol", "uri" -> "EOSPotassium/ref/PsatK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"2f2f9ab6-9d32-41b4-b398-f2e7fddd78c6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6917, 190, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"55a9e969-9912-42be-a720-6565e4d29636",
   CellTags->"PrimaryExamplesSection",
   CellID->490873714]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42507, 947}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 3608, 83, 53, "AnchorBarGrid",ExpressionUUID->"0f92bd91-c77d-4b50-8bfe-b18266fd0311",
 CellID->1],
Cell[CellGroupData[{
Cell[4210, 108, 390, 9, 54, "ObjectNameGrid",ExpressionUUID->"918e4d5b-3760-432b-9a52-f7a821619a2e"],
Cell[4603, 119, 633, 15, 112, "Usage",ExpressionUUID->"a06c44cc-6412-41bc-ae7f-4cd1479eff7a",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5273, 139, 855, 21, 37, "NotesSection",ExpressionUUID->"fa12f420-32d2-46f9-87fd-21873c21bf4c",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->231024891],
Cell[6131, 162, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a43454c1-dbd7-476b-8e9d-16f15b88ccb0"],
Cell[6220, 164, 376, 11, 70, "Notes",ExpressionUUID->"0e0afef9-1253-4e26-944a-a50e2ee79673",
 CellID->1067943069],
Cell[6599, 177, 192, 6, 70, "Notes",ExpressionUUID->"8dcb9cea-8eac-4b00-85d3-389efc848491",
 CellID->61130633],
Cell[6794, 185, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"5dbe541e-2e96-4986-ba1f-9a7f417034c6"]
}, Closed]],
Cell[CellGroupData[{
Cell[6917, 190, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"55a9e969-9912-42be-a720-6565e4d29636",
 CellTags->"PrimaryExamplesSection",
 CellID->490873714],
Cell[CellGroupData[{
Cell[7377, 205, 308, 7, 30, "ExampleSection",ExpressionUUID->"5c3860c0-1ca0-4a84-9ce9-b0ad572a42ed",
 CellID->775357254],
Cell[7688, 214, 175, 3, 27, "Input",ExpressionUUID->"7c685bdf-7a91-4460-a295-380814907296",
 CellID->87419684],
Cell[7866, 219, 298, 5, 57, "ExampleText",ExpressionUUID->"613bf34f-ae69-4cc5-bdd2-b76cbc67e680",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8189, 228, 487, 12, 60, "Input",ExpressionUUID->"22d6ffb3-e63f-4a69-97c6-45fda29bd8dd",
 CellID->419134748],
Cell[8679, 242, 144, 2, 36, "Output",ExpressionUUID->"38bba21e-6e06-4b58-a191-6e96af620476",
 CellID->190248927],
Cell[8826, 246, 205, 4, 44, "Output",ExpressionUUID->"55608e20-8ba5-42d3-b8ce-a828f12ebf16",
 CellID->83405652],
Cell[9034, 252, 205, 4, 44, "Output",ExpressionUUID->"d85eaea5-0697-4c11-9ca3-fbe66294e348",
 CellID->36496978]
}, Open  ]],
Cell[9254, 259, 316, 8, 36, "Notes",ExpressionUUID->"2702efce-911e-4781-87a6-906a934422f5",
 CellID->34465061],
Cell[CellGroupData[{
Cell[9595, 271, 1135, 30, 60, "Input",ExpressionUUID->"a960e697-a488-443c-9e4b-3e80c474f987",
 CellID->118189269],
Cell[10733, 303, 13453, 247, 258, "Output",ExpressionUUID->"934439a1-b881-4417-a39f-b5b9ffeaba2c",
 CellID->26835359]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24235, 556, 306, 7, 70, "ExampleSection",ExpressionUUID->"58d57c73-28ca-4539-a49a-6501f770a821",
 CellID->258228157],
Cell[24544, 565, 212, 6, 70, "ExampleText",ExpressionUUID->"9e06850a-6057-4ce0-9bb4-040140b316c4",
 CellID->119396994],
Cell[CellGroupData[{
Cell[24781, 575, 1308, 37, 70, "Input",ExpressionUUID->"f02243a5-ef18-4018-9bff-3e8ce501ac8a",
 CellID->163625766],
Cell[26092, 614, 12896, 233, 255, "Output",ExpressionUUID->"f6b83d14-b528-43cd-8347-8fcf44a488c9",
 CellID->241213823]
}, Open  ]]
}, Closed]],
Cell[39015, 851, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"a6140e06-e91a-4dcb-a75b-4332cd964a54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39138, 856, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"d14e4dc3-6445-47d1-bcdb-22831d50d6a6",
 CellID->1255426704],
Cell[39401, 865, 208, 4, 70, "SeeAlso",ExpressionUUID->"b014f9fc-1667-48a3-9781-394fe2a26211",
 CellID->234329647]
}, Open  ]],
Cell[CellGroupData[{
Cell[39646, 874, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"2db8dd54-7dc7-413c-acaa-40448364795b",
 CellID->1584193535],
Cell[39919, 883, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"460a04fb-0576-47b4-beed-510f69ccc128"],
Cell[40008, 885, 384, 10, 70, "RelatedLinks",ExpressionUUID->"0ddd8461-e523-4bcd-816b-2b2d9e56f65a",
 CellID->426751138]
}, Open  ]],
Cell[40407, 898, 78, 0, 70, "FooterCell",ExpressionUUID->"e9514402-ad0f-49c3-8206-cd41c7f33b99"]
}
]
*)

(* End of internal cache information *)

