(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     53217,       1206]
NotebookOptionsPosition[     47140,       1073]
NotebookOutlinePosition[     49466,       1133]
CellTagsIndexPosition[     49380,       1128]
WindowTitle->Rho1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "b64354e9-35c1-4c24-a157-a0ab08e95c7a"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"f6d3553f-77d3-4939-8895-c4de010f2ac6"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"TmpK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"TmpK.nb", None}, "paclet*"], 
         Part[
          Part[{{"TmpK", {"TmpK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"TmpK", {"TmpK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b6c9a85e-6fcf-4daa-9ad9-5d9c2ae9080f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"25d60dc6-b48e-426c-9529-a7a5f2502d88"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/Rho1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/Rho1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
Rho1atm.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$24841], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/Rho1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0bc3d684-527c-405f-be0b-b78b60eda279"]
    }], "AnchorBar",ExpressionUUID->"833b3fa5-4361-4ecb-a66f-6ba74ddfd674"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"082c4582-9d8a-4444-98d4-3790ca1299e4"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["Rho1atm", "ObjectName",ExpressionUUID->
  "dff47947-272f-4b79-921d-2a09fffc7e82"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"ad03b59d-4d03-4594-97ff-b77016fc128a"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "7329445a-817b-44b6-b5be-aeae1e18de56"]
}], "ObjectNameGrid",ExpressionUUID->"7310a59c-9c5d-402b-a88d-bcaa3eb2162d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Rho1atm", "[", "T", "]"}]], "InlineFormula",ExpressionUUID->
      "642c77b0-ca20-4b86-9a3c-fc717359b001"],
     " \[LineSeparator]Liquid density (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]],ExpressionUUID->
      "7c770704-afbb-47a7-9fc5-17f7f72bd9a0"],
     ") of potassium along the atmospheric isobar as a function of \
temperature ",
     StyleBox["T",
      FontSlant->"Italic"]
    }],ExpressionUUID->"e6e7bb1c-2628-489e-afbe-176d268cad2a"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"0d03fd45-e4f5-4799-80c7-0167a7751c36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"51637945-737f-472b-8503-93e506415769"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"95a2909a-cc7e-40f2-b731-961a31116531"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"bc2eb634-5bfe-4b13-8dd3-37603a4f2243"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->244297655,ExpressionUUID->"83762d52-27dd-461d-b7e2-bed520dfea6d"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"21589475-9648-4af0-837b-ab14291c10a2"],

Cell[TextData[{
 "The function is defined only for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] 1030.793 K"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"b48f461f-8f92-46fd-ad75-a16c5b2a741e"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->61130633,ExpressionUUID->"ae6af757-9da9-4793-8df8-050e5664f3af"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"797e15ce-8df0-4096-a222-f45b2390bb39"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"5b1745dc-c892-4819-9de6-c374d09f3d06"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "995964b4-51a5-42a4-8d21-5ed99e7c0299"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->15225064,ExpressionUUID->"d242b4d1-aa32-4d42-8c28-0348563bcb3d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1ad4e94b-53c8-4f35-be73-4ea015f62fc9"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->53177730,ExpressionUUID->"03faba37-e80b-4049-aea4-a53f8ca74a5a"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"9ba5767e-27af-4561-82c8-ae5e6bd7529c"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"4bd69e15-f79e-41c2-b3b2-cc57e4d56dff"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rho1atm", "[", "TmpK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Rho1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Rho1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"TmpK", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"1b737e21-33f4-4496-b43b-b5554f7e4a22"],

Cell[BoxData["0.8294796499860027`"], "Output",
 CellLabel->"Out[2]=",
 CellID->85568859,ExpressionUUID->"f660371f-c86d-4a18-a336-3b7a93a6799c"],

Cell[BoxData[
 TemplateBox[{"0.8294796499860027`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->150952849,ExpressionUUID->"81a8aa15-331a-4b7a-9718-0dcb4d281445"],

Cell[BoxData[
 TemplateBox[{"0.8294796499860027`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->238978826,ExpressionUUID->"ccade6bd-ac1a-4208-81ec-03ea2bdbc4cb"]
}, Open  ]],

Cell[BoxData[Cell["Using WolframAlpha", "ExampleText",ExpressionUUID->
  "f5e2be0e-2a3d-454a-9e87-bca8f366d68a"]], "ExampleText",
 CellID->56548053,ExpressionUUID->"3753e947-bab9-41f7-8570-25578efe1cb2"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "melting density of liquid potassium", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Entity[\"Element\", \"Potassium\"][{EntityProperty[\"Element\", \
\"MeltingPoint\"], EntityProperty[\"Element\", \"LiquidDensity\"]}]"}, 
      "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {
        "Entity[\"Element\", \"Potassium\"][{EntityProperty[\"Element\", \
\"MeltingPoint\"], EntityProperty[\"Element\", \"LiquidDensity\"]}]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                FormBox[
                 TagBox[
                  GridBox[{{
                    PaneBox[
                    StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Potassium"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"melting point\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                    BaselinePosition -> Center]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   ColumnsEqual -> False, RowsEqual -> False, 
                   GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                   AllowScriptLevelChange -> False], 
                  $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                 TraditionalForm], 
                StyleBox[
                 RowBox[{"\[NoBreak]", 
                   PaneBox[
                   "\"  |  \"", BaselinePosition -> Baseline, BaseStyle -> 
                    GrayLevel[0.6]]}], AutoSpacing -> True], 
                FormBox[
                 TagBox[
                  GridBox[{{
                    PaneBox[
                    StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Potassium"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"liquid density\"", Identity]}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                    BaselinePosition -> Center]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   ColumnsEqual -> False, RowsEqual -> False, 
                   GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                   AllowScriptLevelChange -> False], 
                  $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                 TraditionalForm]}], 
              PolynomialForm[#, TraditionalOrder -> False]& ], 
             LinebreakAdjustments -> {1, 10, 0, 0, 100}, LineIndent -> 0], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext,minput"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Results", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ElementData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"WebElements"}], "\n    ", 
         XMLElement["datasource", {}, {"TheWikimediaFoundationIncWikipedia"}],
          "\n   "}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    PaneBox[
                    "\"melting point\"", 
                    BaseStyle -> {{
                    BaselinePosition -> 1, FontColor -> GrayLevel[0.3]}, 
                    LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["63.38", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "63.38", "SRString" -> "63.38"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    TagBox[
                    PaneBox[
                    TagBox["\"liquid density\"", Identity], 
                    BaseStyle -> {{
                    BaselinePosition -> 1, FontColor -> GrayLevel[0.3]}, 
                    LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.828", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "0.828", "SRString" -> "0.828"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"grams per cubic centimeter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {None, None}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www4c.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True], 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "2", "datatypes" -> "Element", "timedout" -> "", 
    "timedoutpods" -> "", "timing" -> "1.166", "parsetiming" -> "0.617", 
    "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP106824b4cb45175ci61i00005e4a8ag00e8cfg1h", "host" -> 
    "https://www4c.wolframalpha.com", "server" -> "31", "related" -> 
    "https://www4c.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa106924b4cb45175ci61i00001f13e90ehadc3ifd6777138041576913757", "version" -> 
    "2.6", "inputstring" -> "melting density of liquid potassium"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2021, 10, 25, 15, 19, 26.3327134`9.17307053063287}, "Line" -> 
    81, "SessionID" -> 30612887221050297712}, Typeset`showpods$$ = {1, 2}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Entity[\"Element\", \"Potassium\"][{EntityProperty[\"Element\", \
\"MeltingPoint\"], EntityProperty[\"Element\", \"LiquidDensity\"]}]"}, 
   Typeset`open$$ = True, Typeset`newq$$ = 
   "melting density of liquid potassium"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$}, {Typeset`aux1$$, Typeset`aux2$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{32.220703125, {6.09765625, 8.279296875}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellID->34619400,ExpressionUUID->"514d9aa2-53c4-49a2-9528-6ca5908f0889"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{
    "63.38`4.", "\"\[Degree]C\"", "degrees Celsius", "\"DegreesCelsius\""},
    "Quantity"], ",", 
   TemplateBox[{"0.828`3.", 
     RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
       SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
     FractionBox["\"Grams\"", 
      SuperscriptBox["\"Centimeters\"", "3"]]},
    "Quantity"]}], "}"}]], "Output",
 CellLabel->"Out[80]=",
 CellID->366336402,ExpressionUUID->"b2b162fd-1717-4165-9dfa-cc68d7d9929b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6755928f-76df-470f-9bf7-98db83f9a692"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"70892b97-8038-4ee4-b296-6d16229fd0f0"],

Cell[TextData[{
 "Comparison with Ewing ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 " [1965] equation of state"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"736faa2e-15c1-4ad8-8cd2-7bdd9f61dd2a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RhoLiqEwing", "[", "T_", "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tFahr", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"T", "-", "273.15"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"9", "/", "5"}], ")"}]}], "+", "32"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"52.768", "-", 
         RowBox[{"7.4975*^-3", "*", "tFahr"}], "-", 
         RowBox[{"5.255*^-7", "*", 
          RowBox[{"tFahr", "^", "2"}]}], "+", 
         RowBox[{"4.98*^-11", "*", 
          RowBox[{"tFahr", "^", "3"}]}]}], ")"}], "*", "0.016"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rho1atm", "[", "T", "]"}], ",", 
     RowBox[{"RhoLiqEwing", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<Density (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87157141,ExpressionUUID->"f16e83ce-1ac2-4a2d-870f-c376a61f63a2"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVzn081AccB/BTSheGHnQ41IRYhfOQyvp+p+PVkuYQKslDTjXzUH53kXTO
43nobnqpzRpRySazHkYjycOiTtvFWbXLpoff7x4ck2u97CVn9sfn9Xm9//i8
Xp818amhiQtoNFrwfP7vNTafENylBJ7M8qUYpRqou1/D+9WUwLdpSwLrSzSw
9pie72NBoIG8vdFz3usetGctZhBYldBfvFukgY18H0G9I4EK/72i/CINbBn6
qJRCAn8fjLn0Jk8D4aWWtVw+gZNd9p6ybA0UzowNcF8T6OncJKxO0cCB2oi0
DhkPmR0NrLUhGvhWe6LxaBMfc6QyV7qXBqor9rT1FJzAZNZfgVKGBiz0b1Yc
T8vEl8/D2ytm1DD+QaBRZlAWCh4cHjk/qoat5N6AYd+TWDKiENb3qCHIcl3k
yJpsjONJBXlX1dCrbaL5zWSjtFS+93S5GpqLdf9MUqdQMc1xzk9Xw8KHk8L3
3TnIZDLZ5yPVwOA2vLpZdRozxhvPRm5Tg+yVWX+svwB1xzsZtg5q2JHkrKlo
FqCd0fawp3Q1ZD6yY0065uKyDtP8ygkVGMfpEhyqcvEQaXJ0YkgFnL5LL3IX
C/HeyO1E53YVhJh7FRhnC1FgmPp11EUVGK6/mHFPLcRoc/rSmCIVpLtqRRdj
83BxXUpdWLIKIGKlKGI4DyvJhNR+jgq6wq3lm/zzsVLfEmawWQXvvefY7Nv5
aP4456y1nQq06k6DbKcC7A5/+GTCUAV+0gMNoooC9Lj7iOmuVUKAWJHRbVSI
8e7xdvBYCQudvMudiELURKc907cqIasmRfrTWCG6Leh7mn1BCaGBBTrr2CI8
+WVxFSdXCX928pMaB4qwjV6/WpakBAfmToMk/2KkjyyZ0gUpwTZomgr+sRhN
XVudOjyUwL+a17KUKcJWi3PB8lVKKKEmGqckIsydcfMkZigInfYeX6QXYYva
mNk2SsGQNjqcnVGCeraHLr2HAvqtg0Y/vCzB5MRfNg5cpaCmAS6P7y5FW/u5
2IQyCiZOz3GjekuRSxia7EqhYMrlG2LCowyrzE0sFRwKmlssv29uKMNrTvv+
rmFRMJCW2h9oW45u0g09hcspqJ69xKKXlGNm7W+1Nu9IcPnidve7uXJM+rTP
8e4wCUeaG6rNUs7gOV7YfYtWEuj2vEP6Z2eQ2DjIK/+KhPh0hxDGZ2L0prsn
a3kkpJ27VnTgjhhHKU4cPZKE163X0wPuitF91Op5ZgQJUc9a9m+4J8aW0J5d
mj0kILPLbbZHjJv33TKThpNgXjf85IJUjLKplzZloSRcb9I7P/9DjK47lu0y
2U3CVG9I/75/xVh47GfaogASuNSeG/4zYty2+opXBpsEhdH+C66zYrwzCzGv
ts//u8LyPUWToFyfXdHlT8JOlZ9JsKEE/axUOaeQBOsUzi2tsQR7r33I1W0l
Qa4P+27URILhPey3cfM+I46olptKcOr1e75sCwkLru8vvmMmQRuaS2zTZhI0
usTosuUSnK5k3+RuIuFy/mGOYIUEqw3HxuU+JMSs/DwwY+X8fszabvu8B33S
3KNXSfCEwvygvTcJZX3HHEMYElzWOZRa7kVCYBRhzbaS4PpBK96MJwk0Nd/M
11qCWcIX6Ufm3ZaZZbjeRoI3PnZJeMIi4T8PbVWX
          "]]}, Annotation[#, "Charting`Private`Tag$30850#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVznk41Akcx/Fxh0JPkhxdGkoH2hxh9/s1DSprzUgSYx1ltDqcY3KUyeSc
zPzy9Hh2rUXRZptQrabLkqNjl5Wi03ag32/mN0aX2HqKdvaPz/N+Xv99lsYn
hyboMhiMYO3+71JbPwHfRIB8mOxYm66GkzdrMvvmCHBCYp/Um6aG5WkzQo+5
AhRVMeYmab3iz2vZhtYCTHP5N/JUqhrWCj1EvzIF2ME8/dw2RQ3eA6skFAqQ
U2VzdtY+NYRJrE7whQLMnTjGHearofDTWC//pQD1eIP90kg1RJ8IT/mjPxOf
x8UP3AA1/KI5IE9qFKLPys3TjY5qqC7fdrWr4ABmN7kkMMzUMHfmrWV6ShYy
QyNimRM0jJsFGGUFZeO8Cs8WxhMafMgd/ve9crBHcldP3kZDkNWK7U+X5mKd
lbi1rY6Gbk0jw/dTLsaTBjrSUhqaiycm31AHkZX++KNTMg16f73J/9x5CDPX
T64SbaPBmt8w+ntlHlpKy5YF+tLQP2p+O5YlQkM959bBJTRsSnRSlzeLMGo8
J5VpREPW34vWvWEeRgW1PX3DmApM4yZ2OlQexmc3snOv3VEB91bd8GHDfGRL
HogNFCrgWKwvMM3Nx7t9wy/MKlWgv7o24zqdjz6ivddH8lSQ6qwpqY0VY8Hz
R11pO1UA4fNLwu+L8dLll7z0QBV0hNkMerKOoJCb47ZxjQo+u39hsy8fQYlu
SFyPhQo0dLtOrmMBbqjQ8WVOKcG3J7qhpLwAR1npkvdDSvCXDWV0GhVic2tB
7YF2Jeg5upc5CgqRN/m65169ErJr9vdcHCvEBawVvc+KlBAaUDBhE1uEdx6k
y2P2KOFZuzBR3luEGrsa42scJTjYbdFJZBVjE723u/srJdgHfaCCzxXj8KFN
bLm1EoSnxQoTuxJcJDVxNZ2hoJR6JX9HlGAX6elmNUxB6Af3cYOZEmyMuWCp
e5OCAQ0vjJ1RinKhd3RFAwXGLTFGTSOluKU86cqcMgpqGqB+/DsJzlq4XM5I
o+BV3hd+RLcErXedU/4YRsG7lT8LXrkdxcUjitXWGyhoVlidaW7Q+u4yN29b
CnpTkm8H2JdhX9NT3sNpEqqn69YZl5ZhGO9tXswICSv3Xe6c+lKGqoHK3UXd
JPzQ3FBtvl+K6qkhTlUDCcaLM3fNPJZi6IfYVNcyEuJTHTjWITK0jZRJ4pJJ
SKk4WxTdKsPjgbrfireS8PLS+VT/Nhn+pMpsM9Q64rEias11GRrSSpfSUBLQ
rsNlukuGDl+3mx/jkmBx8v7Dqh4ZDp1id1WHkHC+ccbpnycyrLRUfLwSRMK7
bs7tyI8yDGIR9a83ksCntl1gfZJhnfjMVJrWQ0ZRVc7TMnza2xk4xdL+O7XO
6yCDQKOz49RnPxK2qHxnB+sTWGOxdqEJkmCzn9uiMSXQ3SwheLkvCYMzW397
MZvAgwZ82WkfEqSy8OrBOQSOPkrod9Za93xUcas5gUs2x4e4eZOgnkjgHZ1H
YFtniN83XiTUH9nNFVkSuM9sc06HJwnfz98TkDGfwOhavxa21vc8Ulx5CwjU
73V1CPIg4eitNCbHmkB/kdOOPncSAiIENuyFBA4220u5WjNoobmXDYHvE+d1
Dq4n4WpWtv5qWwLHLs6a3K71f7WfUq4=
          "]]}, Annotation[#, "Charting`Private`Tag$30850#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65001416618367`, 0.6624562203159512}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {336.65001416618367`, 0.6624562203159512}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Density (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"Rho1atm", "(", 
         TagBox["T", HoldForm], ")"}], 
       RowBox[{"RhoLiqEwing", "(", 
         TagBox["T", HoldForm], ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[1]=",
 CellID->46161223,ExpressionUUID->"71f43098-4bba-4faa-9517-1b19183f0572"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"68c0e826-280a-47f7-8674-2be922988208"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"79c4f541-b61f-4348-b622-2677dd0f1b8e"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"30f7979f-1699-475a-9edb-e6ff15e86f0b"],

Cell[TextData[StyleBox[ButtonBox["TmpK",
 BaseStyle->"Hyperlink",
 ButtonData->{"TmpK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"df2bad51-fa24-49d4-bd42-639112361804"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"a53b444f-84e6-491d-89cb-e1ae53e3a33e"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"9b37fca9-0bb7-4f10-a337-63c144b3ea99"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"b2e4cbae-993b-4a0c-9ee8-6b958f0e9158"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "b1cdaca5-c93d-4928-9065-998823dcce76"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"1c6e203c-cbf4-4fe3-a325-38438285f563"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"33694e92-f0cd-4ba9-850e-c090bfa424d6"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rho1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 54.9363000}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Rho1atm[T] Liquid density (g/cm^3) of potassium along the atmospheric \
isobar as a function of temperature T", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "Rho1atm", "titlemodifier" -> "", "windowtitle" -> "Rho1atm", 
    "type" -> "Symbol", "uri" -> "EOSPotassium/ref/Rho1atm", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"d0750715-2640-4bfc-b7db-c5fba067e832"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6852, 187, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d242b4d1-aa32-4d42-8c28-0348563bcb3d",
   CellTags->"PrimaryExamplesSection",
   CellID->15225064]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49183, 1121}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 3621, 83, 53, "AnchorBarGrid",ExpressionUUID->"082c4582-9d8a-4444-98d4-3790ca1299e4",
 CellID->1],
Cell[CellGroupData[{
Cell[4225, 108, 392, 9, 54, "ObjectNameGrid",ExpressionUUID->"7310a59c-9c5d-402b-a88d-bcaa3eb2162d"],
Cell[4620, 119, 718, 17, 112, "Usage",ExpressionUUID->"0d03fd45-e4f5-4799-80c7-0167a7751c36",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5375, 141, 855, 21, 37, "NotesSection",ExpressionUUID->"83762d52-27dd-461d-b7e2-bed520dfea6d",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->244297655],
Cell[6233, 164, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"21589475-9648-4af0-837b-ab14291c10a2"],
Cell[6322, 166, 209, 6, 70, "Notes",ExpressionUUID->"b48f461f-8f92-46fd-ad75-a16c5b2a741e",
 CellID->1067943069],
Cell[6534, 174, 192, 6, 70, "Notes",ExpressionUUID->"ae6af757-9da9-4793-8df8-050e5664f3af",
 CellID->61130633],
Cell[6729, 182, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"797e15ce-8df0-4096-a222-f45b2390bb39"]
}, Closed]],
Cell[CellGroupData[{
Cell[6852, 187, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d242b4d1-aa32-4d42-8c28-0348563bcb3d",
 CellTags->"PrimaryExamplesSection",
 CellID->15225064],
Cell[CellGroupData[{
Cell[7311, 202, 307, 7, 30, "ExampleSection",ExpressionUUID->"03faba37-e80b-4049-aea4-a53f8ca74a5a",
 CellID->53177730],
Cell[7621, 211, 175, 3, 27, "Input",ExpressionUUID->"9ba5767e-27af-4561-82c8-ae5e6bd7529c",
 CellID->87419684],
Cell[7799, 216, 298, 5, 57, "ExampleText",ExpressionUUID->"4bd69e15-f79e-41c2-b3b2-cc57e4d56dff",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8122, 225, 480, 12, 60, "Input",ExpressionUUID->"1b737e21-33f4-4496-b43b-b5554f7e4a22",
 CellID->419134748],
Cell[8605, 239, 143, 2, 36, "Output",ExpressionUUID->"f660371f-c86d-4a18-a336-3b7a93a6799c",
 CellID->85568859],
Cell[8751, 243, 391, 8, 50, "Output",ExpressionUUID->"81a8aa15-331a-4b7a-9718-0dcb4d281445",
 CellID->150952849],
Cell[9145, 253, 391, 8, 50, "Output",ExpressionUUID->"ccade6bd-ac1a-4208-81ec-03ea2bdbc4cb",
 CellID->238978826]
}, Open  ]],
Cell[9551, 264, 203, 2, 40, "ExampleText",ExpressionUUID->"3753e947-bab9-41f7-8570-25578efe1cb2",
 CellID->56548053],
Cell[CellGroupData[{
Cell[9779, 270, 17072, 338, 35, "WolframAlphaShortInput",ExpressionUUID->"514d9aa2-53c4-49a2-9528-6ca5908f0889",
 CellID->34619400],
Cell[26854, 610, 544, 13, 50, "Output",ExpressionUUID->"b2b162fd-1717-4165-9dfa-cc68d7d9929b",
 CellID->366336402]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27447, 629, 306, 7, 70, "ExampleSection",ExpressionUUID->"70892b97-8038-4ee4-b296-6d16229fd0f0",
 CellID->258228157],
Cell[27756, 638, 209, 6, 70, "ExampleText",ExpressionUUID->"736faa2e-15c1-4ad8-8cd2-7bdd9f61dd2a",
 CellID->119396994],
Cell[CellGroupData[{
Cell[27990, 648, 1587, 44, 70, "Input",ExpressionUUID->"f16e83ce-1ac2-4a2d-870f-c376a61f63a2",
 CellID->87157141],
Cell[29580, 694, 16057, 326, 251, "Output",ExpressionUUID->"71f43098-4bba-4faa-9517-1b19183f0572",
 CellID->46161223]
}, Open  ]]
}, Closed]],
Cell[45664, 1024, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"68c0e826-280a-47f7-8674-2be922988208"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45787, 1029, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"30f7979f-1699-475a-9edb-e6ff15e86f0b",
 CellID->1255426704],
Cell[46050, 1038, 210, 4, 70, "SeeAlso",ExpressionUUID->"df2bad51-fa24-49d4-bd42-639112361804",
 CellID->234329647]
}, Open  ]],
Cell[CellGroupData[{
Cell[46297, 1047, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"9b37fca9-0bb7-4f10-a337-63c144b3ea99",
 CellID->1584193535],
Cell[46570, 1056, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"b2e4cbae-993b-4a0c-9ee8-6b958f0e9158"],
Cell[46659, 1058, 384, 10, 70, "RelatedLinks",ExpressionUUID->"1c6e203c-cbf4-4fe3-a325-38438285f563",
 CellID->426751138]
}, Open  ]],
Cell[47058, 1071, 78, 0, 70, "FooterCell",ExpressionUUID->"33694e92-f0cd-4ba9-850e-c090bfa424d6"]
}
]
*)

(* End of internal cache information *)

