(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     42976,       1016]
NotebookOptionsPosition[     36869,        883]
NotebookOutlinePosition[     39249,        943]
CellTagsIndexPosition[     39164,        938]
WindowTitle->RhoKnu1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "6a7f7db4-dc36-4e1d-8f37-acd65346bbc0"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"6ac42048-d05c-4f23-87f7-b5f5adc1ebb1"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaKnuK1atm\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaKnuK1atm.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaKnuK1atm", {"etaKnuK1atm.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaKnuK1atm", {"etaKnuK1atm.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c7302f6d-f288-47ee-8bf8-27ac90482ddf"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"f56f1990-77ee-44e0-9ba1-0b559353451f"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/RhoKnu1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/RhoKnu1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
RhoKnu1atm.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$25592], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/RhoKnu1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b8a0959c-8709-46ab-8dbb-254fc8166040"]
    }], "AnchorBar",ExpressionUUID->"235c2c94-a794-4f41-86ac-e700d1675bd0"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"568d39b9-cdba-4c11-863f-46a457f8dc1d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["RhoKnu1atm", "ObjectName",ExpressionUUID->
  "efb8a227-9709-407b-94f5-bfaf81279fae"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"625f1849-46fc-4115-819f-1692ba01093a"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "5b616a25-133d-4ed2-a02a-23f0755a7d4c"]
}], "ObjectNameGrid",ExpressionUUID->"20d0f819-6b11-4ce0-b2eb-04193c12df71"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoKnu1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "7e6ce092-e214-4bce-b808-77c36c311ca4"],
     " \[LineSeparator]Released gas density ",
     Cell[BoxData[
      SubscriptBox[
       OverscriptBox["\[Rho]", "~"], "Knu"]], "InlineFormula",ExpressionUUID->
      "6e5fe090-9829-4407-b326-40c994503693"],
     " (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
      "abecbe8b-d7be-49f3-9559-6e332f8fbfeb"],
     ") as a function of temperature ",
     StyleBox["T ",
      FontSlant->"Italic"],
     "along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"26f5540c-1b27-4b74-b8e2-1550811afb0a"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"01e8b616-593b-4c6b-b61c-d76583d7af75"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"e652458b-790f-48c7-a803-2df3d62f26d6"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"4e19f04d-eff3-47ea-99b1-6b45c69b30e3"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"f74d6bb8-19ba-4364-a759-f62dbba1c9af"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->566558363,ExpressionUUID->"f35f5ab3-520b-49c8-91a6-39f972ced494"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"d346238c-757a-47cf-b6e7-44063d1271bc"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
 "1030.793"], "InlineFormula",ExpressionUUID->
  "db8287c8-254f-4b7a-b796-076720fff428"],
 " K"
}], "Notes",
 CellID->206839001,ExpressionUUID->"71a44414-a9af-44c3-bb79-684c9623223b"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   OverscriptBox["\[Rho]", "~"], "Knu"]], "InlineFormula",ExpressionUUID->
  "e773531f-543f-4666-8690-3f8974107905"],
 " is calculated by using the parameters adapted for Chiong's data "
}], "Notes",
 CellID->59778839,ExpressionUUID->"63690823-a7d6-42bf-a836-1530dc681661"],

Cell[TextData[{
 "The units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->393170804,ExpressionUUID->"60b54681-3f7d-45ae-a10f-0b72727e748f"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"7886ec57-06a0-4f88-a162-19041b5e738c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ee67ea14-ae0e-4821-afd8-9c05065b9e7e"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "6e0fc3f4-02bc-44a1-9938-1e855145e74d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->71486159,ExpressionUUID->"d20d76bc-9ce2-48bc-b77b-ad0bbbb4d535"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "430b3f62-9c14-4879-9b17-557d356c4ce4"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->6134579,ExpressionUUID->"ce78be05-10ff-46dd-a1c4-e6b3cc9190f6"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"e4bf25a0-6b32-4603-bd16-a48de4c3876d"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   SubscriptBox[
    OverscriptBox["\[Rho]", "~"], 
    StyleBox["Knu",
     FontSlant->"Plain"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "4490f799-a35e-4d2d-accc-0d314b86e490"],
 " is a dimensional function but temperature variable must be given as a \
numbers without unit"
}], "ExampleText",
 CellID->48819395,ExpressionUUID->"b796e990-9821-46c2-9bc7-fc0173b84ee7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RhoKnu1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RhoKnu1atm", "[", 
  RowBox[{"QuantityMagnitude", "@", 
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->422395267,ExpressionUUID->"e108f840-06f8-4ea7-8ec3-77d2e9648a19"],

Cell[BoxData["0.2852587359118316`"], "Output",
 CellLabel->"Out[2]=",
 CellID->98060000,ExpressionUUID->"2d220434-cbfb-4543-948c-99826cc11fcf"],

Cell[BoxData["0.2852587359118316`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1653682,ExpressionUUID->"e5e3a8bb-f27c-4298-bb00-35039036b55f"]
}, Open  ]],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox[
    OverscriptBox["\[Rho]", "~"], 
    StyleBox["Knu",
     FontSlant->"Plain"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "3ce421ad-bb60-49a7-8e27-c7c4b0d5c439"],
 " from the melting point to the boiling point along the atmospheric isobar"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"b18028fa-0f5c-445a-ad43-9bca664d0104"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"RhoKnu1atm", "[", "T", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[OverscriptBox[\(\[Rho]\), \(~\)], \(Knu\)]\) \
(g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->562653754,ExpressionUUID->"5b7afdbc-f6d9-4640-901d-b7b054d9c5ad"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzns41IkeBnBKRptLNmR1kYokRULtrs73i3GJpSEizbRamqTcym+mcciQ
+23mOLFtcksrhZBCLrVoSWxrfzPYSCEJDcdcOJXbcf54n/f5PO8/r95PIe5n
VsnJyQWs5P+tt8maYH5FYK7dbtsErVm41ZbPeqlCYE+z3/YGyizsvLjEtlQn
sLJhxOPf8zIo3sLg5Gms7Abei9QZGRh2NEQoahN4XZZTFPVeBvfCdSKDNxG4
c9J7lfaADPZs40T1biXwwelzr5e6ZbCPbckt1icwVDWIGd0kg8rtWTGquwnc
69OdqPRQBvtfSmNZxgS68Ncn1N+Tgbl+Vbz9AQIHLeUkSddl8J1gT+oYErhe
LbAphpBB45WUNFcqgTnjGn8uXJDBYaOJ9BoHAgWn1e3S/WWAMcX8BFcCaxgf
/5g4JgMHE71sAzqBdea/Z7APyMAjVauQySZQqW3fvPusFHotiVsvIwh0Sv9e
qX1KCl4jgiLLKwRqHTscYj8mBZ9v/1WsGE8gc62/JrNPCr4f1pUVZxIoMqdZ
6NVLIchWvnasnMAhzhMlzxgpJMx/7GKOEjirlLN0TVMKW4s5u7THCWwO7JtK
UJXCIxoltuMjgY5ZWSZcihRGf91+0FhK4LWor22TPkvAmnaiUCzPwugDjvKi
QQks3G4jInVZWNn0pXP6jgQuuhZuzfRhoUVleoI/SoBReDy0qZuFEr+k/1hz
xZBiZKtvKmShmJHVPxEhhtpqk/5bfSzcNu7mmEWIQb1NiZr0hoV0w2+y5wLF
8Ptk/cZjIha2WRcwRzzFsNdc9+k4hY0BkYIwH2MxLLZ9UNEANmqoJy+WDsxA
ruhyaWA5Gz209gx8sZmBvEzP+tb4y2ggH+4VFDAN6ktijUuhHIz8lPnXGT8R
TKnaUzjOETjupr/wuWYSvn9/wq7n0D/R6XRH2AbtCXDWMvQa1IvEZKccvaDS
D/BMVC5nNR+JdGrtkMPlMahIks7OjEXhUI4Z/aHTe1j9YiZ2oeUK3qt/cdPB
eRS0mSXvqm9EI6sp6Ugh8x10v1N77mvDRQUblVyXuBFwPLtrMrOCi45lBzGs
dRg4f2w1m9GPwV5D03NHFYZh3Wmp344bMXhhhyRj2XsI3NqLhmMUY9F10U/Y
lvYWaOvN49dFxqL2RFljQ8AbUDAuCP9tIhYpDRtotOBBCDMSJRf4XkXN1xgy
Gv4a4Lhm8vGeqyj6WVfR9NoANHvoCA/axGF461zdZ7IfFiyWqdS6ONRJ1ZoT
qPeDaOKpfKRBPJLXs+cTz78Cq05GSXJmPOZzFR9nCP8GO95AeAslAR3vV7wz
PPw3rDawSDcgEhCC209k1PdBRH5w56OPCSiLflB5/2AfuNvHS3V8E5GR/238
luZeePOUfba0KxGDC4/U3fXphR2bneTP2iTh7cEzVo+lPbDF+dOYS2US+oVQ
N1Tf6AH2nas1X21OxjW696+mHOmBlLHpUgk/GcUdj1y7/isE908WU2uWkvHJ
B/+y1VVCEIjoHtTwFGzuUJ/tPCeEtQ9/pNwfScF09cOFmsZCyC+B21Ouqahz
vn1To1QA09HLTO9nqcgwFDMm6wUg2Z1DTO9PQ0rRtrsFyQKoqNG6V1GShpLQ
6usLXgLoCg15br8lHa3yOA3tRgLIWywyW5uSjm+nck0TVwtgd1Bdy9xyOl7Q
Ktg/OUDCuYqSPLXgDLxzXsWE+5iEtbos/6VXGdhV5X5j+RcSfgrbQdM+ysMI
5X4z/QgSQrPLEhmNPLzkPed76RQJo7VVYXZPeEinpUnmGSR4v6o5ufc3HvZP
nSyJWzFubjZZbOWh1zKHm00nYf2tnr6bnTzUzwsZbvAhoap8adfrfh7+mPIP
uooXCZJntOc+n3l45dT2sRdHSWCOeT6wmedht/LwuNeKBygnbxot8tDjTYjq
e9eVf7+aHYqS42Nr7V/Nyy4kOI1bKbso8HG0POy55Q8k6AS7PRSt42OWZopz
qSMJwqVjd4eU+UgW7GR9t+IM3vE8oQofxfuGWjocSFhVdTKpUY2PXyvzWsbt
SZiUnqGnbeBjRV7uCUM7Em7HBbhxNfjouaB+rY5KwinN8/bhmnxM2+M247hi
0jLUlL6Rj3lGa1QDbUlIa7+oT9PmY9Av/n9+sSHB3pvQoX7Dx+qN/g9SVyw3
wVY7pMPHt4ufajavuJ4ToWC8iY+zd7QHy61J+B/jWi2p
       "]]},
     Annotation[#, "Charting`Private`Tag$11272#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0.28525873748242186`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SubscriptBox[OverscriptBox[\\(\[Rho]\\), \\(~\\)], \
\\(Knu\\)]\\) (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
      TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {0.28525873748242186`, 1.317999136303434}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->250710054,ExpressionUUID->"5daeca2d-8d54-41be-9151-c162a2adc8dc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "197d654a-b42e-4fe1-83d3-ea059128da9c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"a357fb05-cc38-4136-9870-178c7fe83dd8"],

Cell[TextData[{
 "Comparison of the variations of the \"real\" value of the released gas \
density ",
 Cell[BoxData[
  SubscriptBox["\[Rho]", 
   StyleBox["Knu",
    FontSlant->"Plain"]]],ExpressionUUID->
  "579c8798-901c-4a14-bdc3-99a9b18dc435"],
 " with that of the liquid  along the atmospheric isobar from the melting \
point to the boiling point"
}], "ExampleText",
 CellID->298031396,ExpressionUUID->"ad053075-19e2-46dd-85a7-1c6cf923b190"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Delta]", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["10", "5"], 
      RowBox[{"RhoKnu1atm", "[", "T", "]"}], 
      FractionBox[
       RowBox[{"2", "\[Pi]"}], 
       RowBox[{
        RowBox[{"qc0K", "[", "rhocK", "]"}], "*", "\[Delta]"}]]}], ",", 
     RowBox[{"Rho1atm", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SuperscriptBox[\(10\), \(5\)]\) \
\!\(\*SubscriptBox[\(\[Rho]\), \(Knu\)]\) (g/\!\(\*SuperscriptBox[\(cm\), \(3\
\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->272200197,ExpressionUUID->"a9a3a250-07a5-4570-bbc6-81255cf05436"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVx3s41PkewPEhxTQkUssk16JanVorTXL6fhKjlAmhcilHrbabW35mZ0KG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          "]]}, Annotation[#, "Charting`Private`Tag$15425#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVy3081AccwPEjMQ9NXkWel/Lcg9gyK736duO2iDyTh5Jyaj2gOdcZy+Od
47jfvNZeZSWqSaSbLZdX4Ztj3XWHOHd0v9MjKeHmaaoJa398Xu+/PnYJySGJ
2hQKJeBj/2tntYtBN2CAT8cc20Mjxsv3L6V3r2BA2Kx1YMykGO1PLTI9TRjw
V8AW7fxpMTo/uJuha86A6So3d+WcGDczPbOrHRjQ/fqTuvQlMW7r21A8AgzI
GH5lIlwpwbBisyo6kwHtcyyp4+cSZM+PddKHGaDcvknVw5RgXFVESktPOrRX
y660GD7Ai+On676rZ8K6RG87/PkBVpSF32kvOA28KneXNZZSNFmcWv19CgsM
lh2m3rkuxYlPaXos/wwoi39qO7pZhttf7vNVev0AuifMNxxqlaG/mXPkY7tM
OB9Uas/y68SO8XqK93wmLA+8F8Xt7ERB4cw/kyNZoGn34VP2deEy6WTuB9GP
oDJ27heou9CcXjP0Z/kZyB3mdafHdGPPkLEknpoNe22aDOUvu/HbJKc3ZYJs
SHjlSWulP0RWl63HpEMOKLTa/qVPP0TDgzOH1pfngFHljTnRjh4MFl95nqOb
C9fHjlW2ZfVg0MovCgwzc+H5jj3237T3oM7GyrR7o7mgGswqD9HpxVTXcW5l
fB4wJM1Jev69uDPClBuhzIO86dqhu0QvtoVZKr6k5gN7/8MZE3kvfti65OPT
lA+zP0UdDLCQ4/goamU6FkDTrfD+7bFy9JbF1XDLCuCxvvfsngo5+vLVaSI9
Nkjv+9hzR+S4zHFriSODDaW1a1M5rn2YcemkrHGMDbrHtd+PpfVhCK1gxjKe
A0/nytfdbe3DJ8hMquvkQI6L34lQHQWut/bTSqIWQsnxaDtBkAJt/N+NBPxe
CDFzaUz1OQUyr+UJDay58Gw8kpPzTIFFI5q6aYILoX1vh0PclBjybuvE8kUu
uNg+qdGwlNg3Hhvmk1YEXdVm+Ss6lah/64DezRdF0FgRuvmdRT9eqtl5dSKw
GNQBUtuzSf2oObNEj+oohoaj0nnPln6cdvmVoXHnwdHbNc3EpwMoEJrVCmp4
oJ/YYBB3ZAA7U5IlNJsSOGtxk+MrGsCKhSse+kUlsNudeV685hG6nGgSzS2V
wKp1u7QOpD/Co4KaCuOTpWCe0RLJ7nmE+p+lH15UlYIptbVa6KrChNT1QeZ7
+TCkaKytL1Vhyi83OHHNfPCwoizoaVQ4fLsh1beVD91DU8nCv1UYpRLGbLrH
hx3yEqPEKRWCdZvbQvvHf/KFSDSrwpWXlQMXZHwYsyHts+dV2FC/6DRI8iHy
WmuHtj6J0x1Bkuj3fHA2uVbrZE8ifST8D+o8Hw4rBg+qHUhU68VccF3gg7ZV
49d8JxITfvPwyqIQYJB9nPPWlUS/195GAToElC/1GkvdSbQ8GXxr3JCAc93h
G5g7SVQshl5/ZkSAWhNPbNpFYik/okKxgoBkb97aYSqJ2g0xhc3GBOyeSBAF
00h8M5MYy1tFgHvLhJFbAIlX848EZ68mYDBqQDYSSOJ+02O0NFMCoiPXCiuC
SJR7pmyJXUNAu+ukkXEYiTzxKYcgcwK2qdgscTiJtCiGpY8FAWcvXjDJjiSR
Mso09rIkwDnpK6XXPhLvsDJ0NloRQHVM7JiKJvE/Ms5/ig==
          "]]}, Annotation[#, "Charting`Private`Tag$15425#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
     AxesOrigin -> {336.65, -0.9107176848460736}, FrameTicks -> {{Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "ClippingRange" -> {{{336.65001416618367`, 
        1030.7929858338161`}, {-0.9107176848460736, 0.6197557556708329}}, {{
        336.65001416618367`, 1030.7929858338161`}, {-0.9107176848460736, 
        0.6197557556708329}}}}, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {336.65, 0}, 
     CoordinatesToolOptions -> {"DisplayFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Part[#, 1], 
         Exp[
          Part[#, 2]]}& )}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(5\\)]\\) \
\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(Knu\\)]\\) (g/\\!\\(\\*SuperscriptBox[\
\\(cm\\), \\(3\\)]\\))\"", TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, PlotRange -> {{336.65, 1030.793}, {-0.9107176848460736, 
      0.6197557556708329}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FractionBox[
        RowBox[{
          SuperscriptBox["10", "5"], " ", 
          RowBox[{"RhoKnu1atm", "(", "T", ")"}], " ", 
          RowBox[{"(", 
            RowBox[{"2", " ", "\[Pi]"}], ")"}]}], 
        RowBox[{
          RowBox[{"qc0K", "(", "rhocK", ")"}], " ", "\[Delta]"}]], 
       RowBox[{"Rho1atm", "(", "T", ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[1]=",
 CellID->23549408,ExpressionUUID->"258f4b8b-6be6-47e9-8559-8a263e6b0e66"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"ef707333-2739-4822-81ad-c474337ed37d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"90f5f97a-3677-42a9-b2de-982ab165eae4"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"a2570abd-d7bf-48d3-b425-9789ad6e2e36"],

Cell[TextData[StyleBox[ButtonBox["etaKnuK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKnuK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->374249698,ExpressionUUID->"4cf4b02d-3d0a-4f72-946e-e9a2eb43fd55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b8210b5c-a6d9-43be-b09d-1291e5f2bd9a"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"1d49f5bd-d3d1-4c58-97fa-39b787224f98"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"399728a2-e4ca-4156-857d-0efdcadf0bad"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "ca3ff086-0f53-4373-b736-d701034f965d"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"548602c8-cdee-430a-a598-35de50f1cf5d"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"b2ea2fca-601f-4d8a-8d1c-b82c7f773658"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoKnu1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 59.2613012}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "RhoKnu1atm[T] Released gas density OverscriptBox[\\[Rho], ~] Knu \
(g/cm^3) as a function of temperature T along the atmospheric isobar in the \
liquid phase", "synonyms" -> {}, "tabletags" -> {}, "title" -> "RhoKnu1atm", 
    "titlemodifier" -> "", "windowtitle" -> "RhoKnu1atm", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/RhoKnu1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"8070e747-0a55-4cac-ac7b-e1d2e592025b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7687, 211, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d20d76bc-9ce2-48bc-b77b-ad0bbbb4d535",
   CellTags->"PrimaryExamplesSection",
   CellID->71486159]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38967, 931}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 3677, 83, 53, "AnchorBarGrid",ExpressionUUID->"568d39b9-cdba-4c11-863f-46a457f8dc1d",
 CellID->1],
Cell[CellGroupData[{
Cell[4284, 108, 395, 9, 54, "ObjectNameGrid",ExpressionUUID->"20d0f819-6b11-4ce0-b2eb-04193c12df71"],
Cell[4682, 119, 980, 24, 134, "Usage",ExpressionUUID->"01e8b616-593b-4c6b-b61c-d76583d7af75",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5699, 148, 855, 21, 37, "NotesSection",ExpressionUUID->"f35f5ab3-520b-49c8-91a6-39f972ced494",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->566558363],
Cell[6557, 171, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"d346238c-757a-47cf-b6e7-44063d1271bc"],
Cell[6646, 173, 407, 14, 70, "Notes",ExpressionUUID->"71a44414-a9af-44c3-bb79-684c9623223b",
 CellID->206839001],
Cell[7056, 189, 320, 7, 70, "Notes",ExpressionUUID->"63690823-a7d6-42bf-a836-1530dc681661",
 CellID->59778839],
Cell[7379, 198, 182, 6, 70, "Notes",ExpressionUUID->"60b54681-3f7d-45ae-a10f-0b72727e748f",
 CellID->393170804],
Cell[7564, 206, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"7886ec57-06a0-4f88-a162-19041b5e738c"]
}, Closed]],
Cell[CellGroupData[{
Cell[7687, 211, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d20d76bc-9ce2-48bc-b77b-ad0bbbb4d535",
 CellTags->"PrimaryExamplesSection",
 CellID->71486159],
Cell[CellGroupData[{
Cell[8146, 226, 306, 7, 30, "ExampleSection",ExpressionUUID->"ce78be05-10ff-46dd-a1c4-e6b3cc9190f6",
 CellID->6134579],
Cell[8455, 235, 175, 3, 27, "Input",ExpressionUUID->"e4bf25a0-6b32-4603-bd16-a48de4c3876d",
 CellID->87419684],
Cell[8633, 240, 433, 12, 38, "ExampleText",ExpressionUUID->"b796e990-9821-46c2-9bc7-fc0173b84ee7",
 CellID->48819395],
Cell[CellGroupData[{
Cell[9091, 256, 355, 7, 44, "Input",ExpressionUUID->"e108f840-06f8-4ea7-8ec3-77d2e9648a19",
 CellID->422395267],
Cell[9449, 265, 143, 2, 36, "Output",ExpressionUUID->"2d220434-cbfb-4543-948c-99826cc11fcf",
 CellID->98060000],
Cell[9595, 269, 142, 2, 36, "Output",ExpressionUUID->"e5e3a8bb-f27c-4298-bb00-35039036b55f",
 CellID->1653682]
}, Open  ]],
Cell[9752, 274, 427, 12, 38, "ExampleText",ExpressionUUID->"b18028fa-0f5c-445a-ad43-9bca664d0104",
 CellID->119396994],
Cell[CellGroupData[{
Cell[10204, 290, 693, 16, 49, "Input",ExpressionUUID->"5b7afdbc-f6d9-4640-901d-b7b054d9c5ad",
 CellID->562653754],
Cell[10900, 308, 4308, 92, 254, "Output",ExpressionUUID->"5daeca2d-8d54-41be-9151-c162a2adc8dc",
 CellID->250710054]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15257, 406, 306, 7, 70, "ExampleSection",ExpressionUUID->"a357fb05-cc38-4136-9870-178c7fe83dd8",
 CellID->258228157],
Cell[15566, 415, 445, 11, 70, "ExampleText",ExpressionUUID->"ad053075-19e2-46dd-85a7-1c6cf923b190",
 CellID->298031396],
Cell[CellGroupData[{
Cell[16036, 430, 1112, 29, 70, "Input",ExpressionUUID->"a9a3a250-07a5-4570-bbc6-81255cf05436",
 CellID->272200197],
Cell[17151, 461, 18201, 369, 250, "Output",ExpressionUUID->"258f4b8b-6be6-47e9-8559-8a263e6b0e66",
 CellID->23549408]
}, Open  ]]
}, Closed]],
Cell[35379, 834, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"ef707333-2739-4822-81ad-c474337ed37d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35502, 839, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"a2570abd-d7bf-48d3-b425-9789ad6e2e36",
 CellID->1255426704],
Cell[35765, 848, 224, 4, 70, "SeeAlso",ExpressionUUID->"4cf4b02d-3d0a-4f72-946e-e9a2eb43fd55",
 CellID->374249698]
}, Open  ]],
Cell[CellGroupData[{
Cell[36026, 857, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"1d49f5bd-d3d1-4c58-97fa-39b787224f98",
 CellID->1584193535],
Cell[36299, 866, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"399728a2-e4ca-4156-857d-0efdcadf0bad"],
Cell[36388, 868, 384, 10, 70, "RelatedLinks",ExpressionUUID->"548602c8-cdee-430a-a598-35de50f1cf5d",
 CellID->426751138]
}, Open  ]],
Cell[36787, 881, 78, 0, 70, "FooterCell",ExpressionUUID->"b2ea2fca-601f-4d8a-8d1c-b82c7f773658"]
}
]
*)

(* End of internal cache information *)

