(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     76571,       1572]
NotebookOptionsPosition[     70244,       1433]
NotebookOutlinePosition[     72800,       1498]
CellTagsIndexPosition[     72678,       1492]
WindowTitle->RhoSatLiqK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "ef60f356-d9ba-4e5d-979c-b3a163b226b9"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"5b85b07e-26fa-429c-b128-9a4d6581b541"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"rhocK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"rhocK.nb", None}, "paclet*"], 
         Part[
          Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d7b4999c-a436-44f8-aa3d-33eb88594c26"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"4402edcd-9992-4adf-8ac1-3e25b32b9b48"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/RhoSatLiqK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/RhoSatLiqK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
RhoSatLiqK.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$26339], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/RhoSatLiqK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4f9b939c-fb6c-4d15-859a-b40616768d4b"]
    }], "AnchorBar",ExpressionUUID->"894cac1f-2acf-4b9f-a949-7e39196ada00"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"d9f14174-458b-4d74-ba19-7601267ebacf"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["RhoSatLiqK", "ObjectName",ExpressionUUID->
  "431afd3e-a02d-4390-a7f7-fea5e0400ceb"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"95f6547b-5bb0-4f86-a7e8-dff95fd382ae"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "410f4ca0-c1ea-4df5-ae08-b1013c79e4db"]
}], "ObjectNameGrid",ExpressionUUID->"6e274edf-40cd-4539-8592-fd0a0458be30"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoSatLiqK", "[", "T", "]"}]], "InlineFormula",ExpressionUUID->
      "27fc77d1-5832-4f9b-80f6-98772989a0d8"],
     " \[LineSeparator]Density (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]],ExpressionUUID->
      "4caa6fa6-9af7-4c31-8ec1-520fdc2e09ba"],
     ") of potassium along the liquid coexistence curve  as a function of \
temperature ",
     StyleBox["T",
      FontSlant->"Italic"]
    }],ExpressionUUID->"f364b12b-d1f8-4094-8db3-036f43ac6022"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"b96c14ee-fd34-4c66-92cf-98ab93deaa8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"6e8296e8-4ff0-41ea-b179-68ce9cd4cac2"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"fd70e51f-1e9a-4ad1-adde-1731296aea61"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"6977b338-bf79-4562-a991-760ab913dc49"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->386941996,ExpressionUUID->"3d8f8e9e-014d-486a-9bd3-b7edcef81e7e"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"c0cc5ba3-a93e-4ddc-ab35-77f0dedabe3a"],

Cell[TextData[{
 "The function is defined only for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "a5928c2c-9297-42aa-a5e8-c50c372985b7"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"41898662-553e-40a5-990d-575b1efc0af7"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->61130633,ExpressionUUID->"b2d8a0f9-a371-4bea-937a-7b500e0229b5"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"849152bd-bd47-44f9-ba13-76be1bc88f98"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"fa745c7c-b475-4994-aa2e-13873b11a11a"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "640b3f79-730e-4544-b085-8f83cb53d2f4"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->65634905,ExpressionUUID->"315f2c13-1eaf-4dc5-aa1b-01753061daff"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ab11188e-66c0-4b55-abf4-37a4eeb2f24f"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->76727668,ExpressionUUID->"8fa82f22-8fe9-42b2-aaef-7073c5f22fea"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"f763a2f9-ef66-4cff-9614-973eb58fe3f5"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"176397ee-c6ec-4396-b317-101413b0d7a1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RhoSatLiqK", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RhoSatLiqK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RhoSatLiqK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"66e07c6a-671e-48f2-9628-baada655edc9"],

Cell[BoxData["0.6621746654341361`"], "Output",
 CellLabel->"Out[2]=",
 CellID->50580883,ExpressionUUID->"1945a74f-ea80-4b3d-b538-6875dc1c2a85"],

Cell[BoxData[
 TemplateBox[{"0.6621746654341361`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->779146631,ExpressionUUID->"875ee779-2139-4d89-bafd-5deb0add5171"],

Cell[BoxData[
 TemplateBox[{"0.6621746654341361`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->21503734,ExpressionUUID->"4913858e-1d33-4942-b095-736d7b6fb637"]
}, Open  ]],

Cell[TextData[{
 "Comparison with Caldwell ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 " [1966] equation of state"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"0c14990c-3f9f-4ca3-b2a9-76191fc0d236"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RhoSatLiqCaldwell", "[", "T_", "]"}], ":=", 
    RowBox[{"0.016", 
     RowBox[{"(", 
      RowBox[{"56.099", "-", 
       RowBox[{"6.9828", "*", 
        FractionBox[
         RowBox[{"T", "*", "1.8"}], "1000"]}], "-", 
       RowBox[{"0.5942", "*", 
        RowBox[{
         RowBox[{"(", 
          FractionBox[
           RowBox[{"T", "*", "1.8"}], "1000"], ")"}], "^", "2"}]}], "+", 
       RowBox[{"0.0498", 
        RowBox[{
         RowBox[{"(", 
          FractionBox[
           RowBox[{"T", "*", "1.8"}], "1000"], ")"}], "^", "3"}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RhoSatLiqK", "[", "T", "]"}], ",", 
     RowBox[{"RhoSatLiqCaldwell", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<Density (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->163625766,ExpressionUUID->"b7f0393b-d561-4e6f-8394-1d36e3f9f7aa"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVkHk81Akfx2lbREJh1zzOttWhchSlw/dryVlImnG2ZClKCkOSY4kUMe5j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          "]]}, Annotation[#, "Charting`Private`Tag$43083#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVj3040wkcwJdzEyVLSRxNL+Kpq3YiJ5fvty4iicKSl0qF4yFH5q02IitZ
ZbaQl/iJy3np0rPUhLp06g6lnN+Ql7HZbCqu9nhWyl33x+f5PJ8/PyuPxu4P
06FQKF5f+N+yA48vhRuwsHJ5aiacVEOrnhirl7CwyyoR7ePVUHS3/p3KgoU/
19E0tnFq8DEtYMZsYuEH1zVgHKuGZjJyRYIfCw08Bo7Lo9Qg9De6eeYaC7nt
NlPco2pw8w3sKrFLxGcHU3X/2KeGmr3TC3oCk5AqzgmyZqghxW9n2NKhFJzx
0Jo9VKjgJkNi0m5/GtVdnbZlhAr+Lp/xEKVz0JHvucorRAXzaPR657R0tNuo
802BsQo6to4d6a0+g/e67eJ8OifALEaccXAyAwPyfKP4aRNwRMVUzNqcRerU
2sOVmydgoFvAYnpnYVVgb4TPayX0PZDHF1/m4qpWd96Ja0rQN+8tLmw6hxfr
bwmd/ZWwuTWHKho5j6bO/juohkoYjWSOiC0voLO+/XpGqwIepT+UJbnlYD11
jrIxQQE2ZS5Mq/M8XBQTWnNqtQKy9DINlG0XsXbXOUlHzzgsexWuDlNfQt+1
LRlLssfBJGhTiXJpLgpOtZUWO46D09zHAO2vuZivS5dtmJQDvap7D8eTj1zq
7j2aAjnMi8sOXaLmIz17el+fqxzY7xbzdDl56GJ9MkehlcH9pMo3USsEGD/b
FmNZJYO829SwDSIBCg9pwy8zZRBuvOfznJsQNT7Gnagvg0+s4k5XhRAnlz94
svjOGKy/3NQwkXoFfXVbEpzCx8CiTtZFschHz9tnD6fQxkD/7ZSBbVM+ls5M
NFKaRyF3vCOk1qsASzSJVdroUeiXNiivvynAOavY5K9MR6GZH3FOm1GIp42E
Fbx2KRRHUNyDTa4iZ9WtR8lJUvhh+3VwEF3F2JSJuoSVUkjsNvGKci9CjVhj
rV8xAvHH8vhLVUXY8WHdLz++H4b5dcOT5mnF2H84g9bqPQxFZosiGMYlOEzr
d7D+bQjeXthldr+hBNn0BaeqKUMw2OAzSriV4rDVgUW5IYPAGzwm/awsRfZd
19VX6l7B998GUiK51xAT1zmUzg0A5zurLQzzMtzNWW26LngAuFunK6KbvvT9
v54P1faD4NOTPB3bcsyeZVNt9foh9ET2cWZcOT41elpdGNYHtLHnL+QPy9Ff
0JeyrVECPMacx8oFBLq8z9/JN5bAi/mPHkcvJJBdYBTaaCSBZaNZcM+QQOp+
BvvVQgmU8w0dvGkE3gqKF1nrSUD0zsKKbUKg+2c7etMsCUMi55k+OoGFAcnK
MTkJG51SKnLtCXz7U8U++7sknFy8zXLQgUBmpHXEQREJ91SUQhtHAisNBac5
DSTsKDp/sdWJwFLBlhtPa0lgzhYkv3YhcKK7bza4nIS0lsa97h4E6k0HVWZl
k/D4Suqfgt0EVvyeIa7hkmBwwmXniCeBavadZ88zSRCuaHdK3Pvlb/6uD2Yc
EqrTetdU+hLYUebnfTOehDcHrpZN+RHYpmMS1hNLgh0jxNyZSeDL9/+kaqNJ
aJbKjV4GECh9oX9jRwQJ88TVFywDCWxSurdEHCfBjR/9dWQQgUFDdT28UBJy
IhnpomAC7Z84qhsOkdC9XfPx3xACa8STFEkQCf8BGoFYMg==
          "]]}, Annotation[#, "Charting`Private`Tag$43083#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {336.65003849693875`, 0.19403919535814954`}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {336.65003849693875`, 0.19403919535814954`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Density (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
         TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
         TraditionalForm], None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"RhoSatLiqK", "(", 
         TagBox["T", HoldForm], ")"}], 
       RowBox[{"RhoSatLiqCaldwell", "(", 
         TagBox["T", HoldForm], ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->80369264,ExpressionUUID->"29bb63eb-deb9-44d3-a8a9-e7aaca5ecada"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9abc9526-159a-4ce7-b1a7-51c0c82e3fc6"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265,ExpressionUUID->"37022cdc-e816-4ad6-9381-46281ea7bce0"],

Cell[TextData[{
 "Representation of the thermodynamic diagram (",
 StyleBox["T-",
  FontSlant->"Italic"],
 "\[Rho])"
}], "ExampleText",
 CellID->642064293,ExpressionUUID->"dce8bca2-217a-43db-a95a-a1232098ebd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RhoSatLiqK", "[", "x", "]"}], ",", 
       RowBox[{"u", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"rhocK", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"TmpK", ",", "2300"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"AspectRatio", "->", "1"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RhoSatVapK", "[", "x", "]"}], ",", 
       RowBox[{"u", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "rhocK"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"TmpK", ",", "2300"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"AspectRatio", "->", "1"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"TmpK", ",", "2500"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Density (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<Temperature (K)\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"rhocK", ",", "TcK"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"rhocK", ",", "TcK"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C.P.\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.23", ",", "2280"}], "}"}]}], "]"}], ",", "Black", ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<BIPHASE\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.3", ",", "1200"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58309389,ExpressionUUID->"a023bf92-f4aa-439d-9b9d-c08cf5f8e536"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvVlwG1e651kx8zJPd+77zJ2489h978ONuC/T0zER3U99u186pic6bsQ8
TNkul1wum/JKu2zTrrIkaqU2i5K1kNqondohcQN3EqS4gqREkRK17xKt3ZYs
a5sPOBIKBkDwEMjMk3nw+8XPDAgEk9An5Hf+Ppl58n9/64P/Nut/+M1vfvPJ
/yRf/tubn//Hjz9+84v/52/lD/999ifvvjP792//59mf/v6d33/8f7z1P8qT
LfLaIfkv9vglAAAAAAAAAAAAAAAA+IxoNFoVJxQKTUxMpHw3EolUpSGvTH7N
5OSkPKOel8cZf0s4HJYXVFdXp/8KAAAAsBjJBiUlJbOSKCoqSskSZWVls9Io
LS1NvEACifxU8hbkmeQtSMBI+S2SOjz6GwIAAIBpJDbI6F9VVaUmJRLJITkw
SFQoLi6O/JpoNKq+K1miKI76EbUFIXmWQ4UNlTES2SMlkwAAAICVSGaQcb+s
rCz5SYkB8mR5eXnimZTZjBQqKirkBeFwOPGMPFYZJvmP8rLECySKZN8mAAAA
WIOM+9XV1enzDMlhQGWSRHhIR01WpDxZVFQkz6vHKpCk/BZ1jGaqMz0AAADA
biYmJpInPUKhkJq+SJw1mjiSosg4U6EO06Q/TiDb4ZAKAABAwVJeXi5JIHHK
qAoGxcXFyWd7Jo62qHAyVd5Q16Gon015gdpsyompAAAAUAio2YzEoZCXr5ND
WVmZCg/RaFQdQFHnY6iTPabKG2r6QkWUlBeovJHlMA0AAABYiQobRUVFyetj
SGZIuXZ1cnJSXcMiD9zIG+nX3gIAAIA+zsQCd0iEjZTTMzKijrlInHDjeIqr
hWLjGTcYrHfOxi3euNvbZ+NsnI2bReWHkpISzZU/k8/2zJI30h9n3EIKwf1X
CNbGyRts3Icbd3v7bJyNs3GDJMJG+tWp8oy6JiXleXU1q5oJkR8sKipKeUH6
9bAp0yZZrocN7r9CsDZO3mDjPty429tn42ycjZtCzTNkDBuK9MVC1YKixcXF
6o9TrfeVWOBrqvW+ks9KTSa4/wrB2jh5g437cONub5+Ns3E2bgR19oWEB7W8
RsblyhOBRB1qkW+p61MSAWOq9cyTD81kXM88OaIk48NCWYlneQMyQs2NQNm9
h5p7jw9rrrJERpJPyVAzGMmknOcpf8x+vzZJLykreGS5X5sPC2Ul5A2zUHMj
UHbvoebe48OaqzvIZyQlUUxMTEhCyHI3eQfvR+/DQlkJecMs1NwIlN17qLn3
UHNNKJQ3kDfMQs2NQNm9h5p7DzXXhEJ5A3UGALAS2rsmFMobqDMAgJXQ3jWh
UN5AnQEArIT2rgmF8gbqDABgJbR3TSiUN1BnAAArob1rQqG8gToDAFgJ7V0T
CuUN1BkAwEpo75pQKG+gzgAAVkJ714RCeQN1BgCwEtq7JhTKG6gzAICV0N41
oVDeQJ0BAKyE9q4JhfIG6gwAYCW0d00olDdQZwAAK6G9a0KhvIE6AwBYCe1d
EwrlDdQZAMBKaO+aUChvoM4AAFZCe9eEQnkDdQYAsBLauyYUyhuoMwCAldDe
NaFQ3kCdAQCshPauCYXyBuoMAGAltHdNZv0a02/HWqgtAIA1MHTmAIXyBuoM
AGAltHdNKJQ3UGcAACuhvWtCobyBOgMAWAntXRMK5Q3UGQDASmjvmlAob6DO
AABWQnvXhEJ5A3UGALAS2rsmFMobqDMAgJXQ3jWhUN5AnQEArIT2rgmF8gbq
DABgJbR3TSiUN1BnAAArob1rQqG8gToDAFgJ7V0TCuUN1BkAwEpo75pQKG+g
zgAAVkJ714RCeQN1BgCwEtq7JhTKG6gzAICV0N41oVDeQJ0BAKyE9q4JhfIG
6gwAYCW0d00olDdQZwAAK6G9a0KhvIE6AwBYCe1dEwrlDdQZAMBKaO+aUChv
oM4AAFZCe9eEQnkDdQYAsBLauyYUyhuoMwCAldDeNaFQ3kCdAQCshPauCYXy
BuoMAGAltHdNKJQ3TFPnvXtjhsNa25KXqdcnq/mzAADgKAyjmlAob8hc54GB
l//6ry//5m9e/uY3r5THn3wyzbb+/b//6+uT1flZAABwFIZRTSiUN2Soczj8
KmlI5KisjM1RLF/+8h/+4dUzWVB5Q14j6SJhIrcQOQAAPIRhVJNZv8b027GW
1NpeuvQqHkjMSEHFiW+/nXJb6gXpPygBRs1yAACAmzB05gCF8obUOn/yyZRz
EQMDsW/93d9Nua2p8oagpkcyfgsAAFyAYVQTCuUNqXWWOCHB4NKlqV6d7bBI
lryR5VsAAOACDKOaUChv+FWd1QzGP/xDjtuaKlSozYoAAOAVDKOaUChv+FWd
JSpIKpDYkBuJEzySr4eVP6o5E/5BAQA8hGFUEwrlDc7njYz+y7848m4BAEAT
hlFNKJQ3/KrO6kKSPPNGyvWwy5fHjqcAAIC3MIxqQqG8IbXO2S9czZ4cOCkU
AMA3MIxqQqG8IbXO//Iv2TKD+u5US5STNwAAfAPDqCYUyhtS66xO4ch4icq0
y3aRNwAAfAPDqCYUyhsy1Plf//XVWRzJR08kRah1RysrXz0j35Unk1+jmTfS
fxAAAJyGYVQTCuUNmeusIoea6JAUoS5olbyxfPlfX5O+Eqlm3siyhCkAADgE
w6gmFMobpqxzOByLBBIhxH/5l9gyGikzEpI95FvJCUQ2Jc9MewP69B8EAACn
YRjVhEJ5A3UGALAS2rsmFMobqDMAgJXQ3jWhUK4Tjb7ctGn3v/t38jX2GAAA
LIJhVBMK5SItLS//6Z9SlxyXZ0gdAAC2wDCqCYVyi+XLX/7t3055o5NNm0y/
PwAAcACGUU0olCtEo9nChrKlxfS7BACAfGEY1YRCucJ/+A/ThA3x7//e9LsE
AIB8YRjVhEI5TzQ6fdhQnj9v+r0CAEBeMIxqQqF0ePrs+U+Pf7n38Odbd3+6
cuvh+Wv3T1+6M3ruh+ipmz2j1zqHrzQPXGzoOX+k88z+1tM9xQs088adOQvu
Pvz5xYsXpv9+AACQIwyjmswCp4ld+qqXNw7/8z+bfrMAAJAvpkfyYGB3oX55
+nz84u2mvgs7Gk6u3D3w1dqO3y+o+/++PTpT35xX8/b8uj8sbni/LPzh8qbi
Va2fr2mTrf15Q+fcTV0Lth5bsq1n2a7+7/YMrNkfbfhiuWbeOPh/v/fu4oap
fuk7C+vnb+7eXn+yc/jKrbuPTNcSAAAyYPcw6iD2FerC9XstA5c2Hjn+9bqO
jOP4HxY1fL66TUKCZIMtR09sqxvd1The3Tx+oO30kciZ2u5z4b4Lzf0X24cu
d5+41nvy+uCpm9HTM3Ck/7Rm3pioOiCvHzx9MzJ8paH3/MG20zvqT36/P/pt
ZeT9peGUt11c3lp5eKRj6PKtuz+ZrjEAALzCvmHUJewo1O37j9ujl2Wkfr8s
bZhe1bq4qmf9waHdjWN1x873jF6bUXjIzSf/y99NGzYe/Zt/zL4RCSESgdYd
HJ5T2TXr19MyJes69jSOj124bbrwAACFjh3DqAcEulC37vxU03X228pI8lg8
e1nj/M3dlaHjRyJn+8eue5Au0p2oOjBt3ji3ZvOMtll37FxFaET+sm/P/2v2
+OOShopDw4Onbpr+pwAAKFACPYx6SUAL1R69PH9Ld2LYfau09tuKzo1HRhr7
LhgJGOlKnMgSNi4uXJnPxg+2T6zc1f/Ryua/nuyxqH7DoeHhiVum/2UAAAqL
gA6j3hOsk2xv3vlpR8PJPy55ddDkjbk1pZu79zSND566YTxgpDt+qCn9wMqj
f/OPM53ZyGK498LaA0OfrmpJBI8PlzftDI9dvH7f9L8VAIC1BGvo9AlBKdSl
G/crQyOJUfVPq9uqakf7DB0umZETVQeOF315+J//ecd/fkcSyEj/aTd+S1P/
xbX7hz5c0ZQokSSxloFLT589N/1PBwBgM0EZRo3j/0LdefB4S82JxDC6YMux
mq6zxlPEjDzUflrq/ObcWg9+15HImaU7+hLneLyzsH5b3aikNdP/jAAAduL/
YdQn+LxQRyNn35hbo4bOj1c2N/f75fQM3+YN5cCpG9vqR79a257Iact29kU5
rRQAwGl8Poz6B98Wavzi7W/WdyYODYR7A5k0TOWNhLXHzpVt731jbq2q5Nfr
O1oHL5n+twUAsAffDqN+w5+F2tt86vWcRtO+FldOeCiQvKHsPn51/cGhorLG
11Vtqek69+w5920BAMgXfw6jPsRvhbp196dFVT1qWFxVPWA8KtiRNxJuqxst
XtWqyvt+WePhjjO/POWEUgCA3PHbMOpbfFWokTOTRUsb40Nh+EDbhPHR2b68
oaxuHv/y9akdf1zSIKmDuQ4AgNzw1TDqZ/xTqJaBi2oE/LYy0n3iqvFB2eK8
oTzQdqrk9S1mJObVdZ8z/REAAAge/hlGfY5PChXqOKMGvu/2WHIMxf95Q7m/
7XTJ67mO4lUtbZxNCgAwE3wyjPofPxQqcXZoZei48fG30PKGck/T+GflrxYp
/bYiMnSaK2cBALTwwzAaCIwXan/LaTXMVdWNGh92CzZvKKtqT8xe1pSYaLp0
44HZzwYAgP8xPowGBbOFOtp1Vo1uOxpOGh9tyRvKdQeH3ip9tV7HzoaTT355
ZvATAgDgc8gbmhgsVHv0svUzG9EA5g2xc+RK2Y5e9a8ze1ljW/SyqQ8JAIDP
IW9oYqpQo+cm1XBWcXjY+PDqtoHLG8qarrNfv76AZfG2nnNX7xn5qAAA+Bny
hiZGCnX7/mP5v2YZxVbs7jc+qnpgQPOGsqpu9N1FDSp17Gka9/7TAgDgZ8gb
mhgp1JJtsbn6v1R0Gh9MvTHQeUPsOXlt2a5+FTk+X93Gfd8AABKQNzTxvlDV
zeNqBdHIyBXjI6k3Bj1vKEOdZz5f06ZSx8bQ8Uc/P/X4kwMA4EPIG5p4XKiR
M7fUgHWgNfB3YdPXjryhXH9wSP0LfrC8qfvENS8/PAAAPoS8oYmXhXr+/MXn
q2P/g7x636DxcdNLbcobYmPfxW/WvzqPdMOh4Z8e/+LZRwgAwG+QNzTxslDb
60/GTgBY02p8xPRYy/KGck5l12/nvJro6D153bNPEQCAryBvaOJZocYv3lb/
R1zTfc74WOmxVuYNsan/4jcbOtU/65aaEy9ecJNZACg4yBuaeFaoeZu6ZFRa
VV1YR1KUtuYN5fpDr87o+HJt+9iF2958nAAAfAJ5QxNvCiX/Ixy76fmyxsFT
5sdH77U7b4h1x85/trpVpY5D7RMefKIAAHwCeUMTDwr1y9Pns5c2Wn+TlCxa
nzeUK3e/WqNj6Y6+H+49cvtzBQDgB8gbmnhQqH0tsdvNl6xtNz4gmrJA8oa4
t/nUu4vD8s/93pJw7yhXywKA/ZA3NHG7UPd/fPLWvNjNRg91nDE+GpqycPJG
NH6vt7kbu9REx+5G1j8HAMshb2jidqF2hcdk3JlbGTE+Dhq0oPKGMrEs2KKq
nkmOrQCAvZA3NHG1UPce/vzG3JrYNbBdZ42PgAYtwLwR+1t3nCkqe3VsZZBb
rgCApZA3NJn1a5zdeHVT7FYpczZ2GR/7DI+8BZk3xO4T1xLHVrhuBQCswdWh
01bcK9STp8/fWVgvA82RzsI9c0NZsHlD+f2+qIocq/cNPvnlmUufNwAAI5A3
NHGvUDVdZ2OXpazrMD7eGbfA84a4p3n87QV16vNw4fp9lz5yAADeQ97QxL1C
Fa9qkfGlunnc+GBnXPKG2Nx/4fP4mmBvldYe48ayAGAL5A1NXCpU7+g1GVk+
WtFkfJjzg+SNhIuqejidAwBsgryhiUuFKtveK2NKZWjE+ADnB8kbySYulZUH
bnz2AAC8hLyhiRuFunLroYwmb8ytOXbiqvHRzQ+SN1Lc3Tj25rzYhdLztxy7
ff+x459AAADPIG9o4kah9jTGLoNdvK3H+LjmE8kb6dYdO/fhiqb4Qbfm05fu
OP4hBADwBvKGJm4U6sPlTVwGmyx5I6PdJ67+eUNEPiq/nXO0mzNIASCYkDc0
cbxQA+M3ZAT5eGWz8eHMP5I3sli2o1edzlHTddbZjyIAgAeQNzRxvFBr4os7
rT84ZHwg84/kjeyuPfDqDNIdDSed/TQCALgNeUMTZwv1+Mmz386JDRxt0cvG
RzH/SN6Y1m11oypyfL8/6uAHEgDAbcgbmjhbqPahy6wpmi55Q8eDbafVGqSL
qnp+fPSLgx9LAAD3IG9o4myhlu3sk/FiS80J44OXryRvaFrfc352/GTjkrXt
13/40cFPJgCAS5A3NHGwUPL/pGpKvOs4y278SvKGvu1Dl/+0pk0+RR8ubzpz
+a5TH04AAJcgb2jiYKHao7GDKV9v6DQ+ZvlN8saM7B+/8W1Fp3yW3p5fNzxx
06nPJwCAG5A3NHGwUCt29XMwJaPkjRxcuPXVnVa6j1916iMKAOA45A1NnCrU
02fP35gbW6G6Y5grU1Ilb+Tm8l19KnK0DFxy5FMKAOA45A1NnCpU/1hsma8v
1rQZH6R8KHkjZ1fvG1SRo677nCMfVAAAZyFvaOJUoSpDIyzzNZXkjXzccGiY
W9gDgG8hb2jiVKHUPVMaes8bH558KHkjT7ccPa4ix56mcUc+rgAATuHbvBEO
h8vKymbFKS4urqiomJycTHlNVVWVfEu9QB6nb2TaF8hvKSkpkRcUFRWVl5en
/4oEjhTq7NW7MhYULW00PjD5U/JG/m6vP6kihzzI/xMLAOAU/swboVBIZQCJ
GZITSktL5Y8SDJLzgEoj8q3EC+SZ5I1M+4Lq6upEFJGwoR5PFTkcKdThjjMy
EJRt7zU+KvlT8oYj7m4cU5Fja82J/D+0AACO4MO8ISO+JI2UoV/lAUkI6o8q
kMiTKS+IRCKaL5iYmEjJMOpHMk6DvHSoUPM3d8fmuptPGR+S/Cl5wyn3Np9S
kWNjaCT/zy0AQP74MG9Eo1E1s5H8pKQCNVmh/qjmLiQzJF6g8kNiBmPaF6jJ
DckYyb9FQo786ozvKv9C/fzLMzUE9IxeMz4e+VPyhoMeaDv92zmxK68rDg/n
+dEFAMgfH+aNqUjOG2oCJOUFJSUlibQw7QvSA4kgIUeelMCT8bfn+f4Hx7kS
dhrJG856sH3izXmxyLHhEJEDAAwTlLyhDnYkJj2Ss0cCdZKG5guSHyeoqqpK
PuaSTP6FUifyrd43aHwY8q3kDedL2nHmrdJa+eCtOzCU5wcYACAfApE3Jicn
1WUmajpC8kCWOBGJk/0FL+N/8anyRsZTOPIv1DfrY7e6kP5vfAzyreQNNwx1
nPldPHKsP0jkAABj+D9vSNhQl6wmThYNYt548NMTafhvzq0ZPGV+APKt5A2X
DHUmIgcHVgDADD7PG4mwkXyliam8kRHNv0jf2HXp9iXrOowPPX6WvOGeh18f
WOH0UQBwmzxHTO+JRqMqbKRcq/IygOdvbK8blVb//b6o8XHHz5I3XFUix5tz
Y1dIbT56PJ8PMwBADvg2b6irYtMvWVXItySKpDyZcn1K9heo61NSVvdy7/qU
P2+In7zRyckb2SRvuO3B9gl1kWxV7Wg+n2cAgJniz7yRPWy8DNr6G4+fPFUr
b/SPXTc+4vhZ8oYH7m99tRTYzvBYzh9pAICZ4s+8oQ6jTBU2Xk69fGjiR6Z9
wVTriyb/SDL5FGrkzC1p75+vbjU+1vhc8oY3Vr9efVQe5PypBgCYET7MG4mb
p5SmkXwihzoBI8vtUaZ9gTpbw4P7pxxoOy29feXuAeMDjc8lb3jm7sZxFTkO
d5zJ+YMNAKCPD/OGGvozknwKqASD7Ld/nfYFL+PZxoP7wy7Z1qNuEW58lPG5
5A0v3RY/h1msO3Yu5882AIAmPswb/iSfQv1hUYN09fahy8aHGJ9L3vDYTUeP
q8jROnjJwZ0FACAd8oYmORfq8s0H0s/fLwsbH1z8L3nDe9cfGlKRo/v4VWd3
GQCAZMgbmuRcqLbBS9LM523qNj6y+F/yhhFX7xtUkWPo9E1n9xoAgATkDU1y
LtTmoyekk1ceHjE+rPhf8oYpV+zul0/p70prT1+64+yOAwCgIG9oknOh/rIh
Ip08xEpfGpI3DLqoKnZWc9HSxiu3Hjq77wAAvCRvaJNboZ49f6GWc+xlpS8N
yRtmnbuxSz6rf1rTdvfBY8f3IAAocMgbmuRWqDNX7koD/3hFs/GhJBCSN8w6
eOrGV2vb5RMrwePps+eO70QAUMiQNzTJrVBN/Reley/c2mN8KAmE5A3jdp+4
9snKZvnQLtvZ5/hOBACFDHlDk9wKtTE0Iq17Y+i48XEkEJI3/GDLwMX3ysLy
ud1wiDvXA4BjkDc0ya1Q6rawRyKcLKolecMn1nSdfXNerXx0d3FPNwBwCPKG
JjkU6sWLF2/MjZ0s2jN6zfgIEgjJG/5x3+t7ukn2cGOHAoBCg7yhSQ6Funj9
vrTrD5c1GR87giJ5w1duq311g5XI8BU39ikAKCjIG5rkUKjO4SusLDojyRt+
c93BV6udj577wY3dCgAKB/KGJjkUakf9SWnUaw8MGR81giJ5w4cu29knH+M/
LgmzDhgA5AN5Q5McCqUWbNzXetr4kBEUyRv+dO6m2DpgX61t/+nxL27sXABQ
CJA3NMmhUEVLG6VLt0UvGR8vgiJ5w58OnLrx+Zo2+TCXbe91Y+cCgEKAvKHJ
TAt19+HP0p9nLagzPlgESPKGb22PXn4/vihH5eERl3YxALAb8oYmMy3U8bOT
0py/WNNmfKQIkOQNP1vTde6N+M2ADrSddmkvAwCLIW9oMtNC1R07H5t/3tFr
fJgIkOQNn7u7cVxdrtI+dNmlHQ0AbIW8oclMC1UZX8l801FWMp+B5A3/W3F4
REWOk+e5QhYAZgB5Q5OZFmpOZeyU/lAHK5nPQPJGIFy2q18+27OXNd66+8il
3Q0A7IO8ocmsXzPt699ZVB9bmHHkivHRIUCSN4LiXyoj8vGes7HLg10PAILL
TIdOeDnDYPbDvUfSjf+wuMH4uBAsyRtBsefktY9Xtqjl7Nzb6QDAJsgbmsyo
UCNnbqn1kYyPC8GSvBEgw70X3p5fJ5/z/a1crgIA00Pe0GRGhao7do6LU3KQ
vBEsq1te3UO2g8tVAGA6yBuazKhQm44cj12ccmTE+IgQLMkbgbMi9OpylYnL
d93b+wDAAsgbmsyoUPM3d0sHPtQ+YXw4CJbkjSBatiN2Q7dPv2u5/+MT93ZA
AAg65A1NZlQodeeU9uhl42NBsCRvBNSv13VwdxUAyA55QxP9Qv346BfpvW+X
cueUGUveCKidw5ffi99dZVvdSVd3QwAILuQNTfQLNXH5Tmx6eVWr8VEgcJI3
gmuo84w6kaOp76KreyIABBTyhib6heoYuixdd96mLuNDQOAkbwTarbUnVOQY
PcdS5wCQCnlDE/1C7W2OXSS4Zn/UeP8PnOSNoLtid2yp849XNt99+LOr+yMA
BA7yhib6hSqvHpCWu6NhzHjzD5zkDQv8Zn2nfP6XcO4oAPwa8oYm+oX6en3s
XP26Y+eNd/7ASd6wwMjwFXXu6I56zh0FgL9C3tBEv1C/XxBb5Ln7xFXjnT9w
kjfs8FDHq3NH26KsOwoAryBvaKJZqDsPHsfu1Lao3njPD6LkDWvcdPS4ihxn
r7DuKADEIG9oolmosQs/SI/9fE2b8YYfRMkbNlm2vVf2hS+/b3/yyzO3d08A
8D/kDU00C9UWjV0Mu2DrMePdPoiSNyzzT6vbZHdYvXfQ7d0TAPwPeUMTzULt
aRqXBrt2/5DxVh9EyRuW2TRwUd2zPtR5xu09FAB8DnlDE81Cle8dlO66k4th
c5K8YZ+7G8fUiRxDE7fc3kkBwM+QNzTRLNSfN8QWH6jtPme8zwdR8oaVro6H
8NnLmu7cf+z2fgoAvoW8oYlmof6wqEFaa2TkivEmH0TJG7b6l4pYDl+6g0XA
AAoX8oYmOoV6dWfY+dwZNkfJG7aaWASsumncg70VAHwIeUMTnUKdu3pPOuon
37UYb+8BlbxhsQfbTqsTOfpOXvdghwUAv0He0ESnUD0nrkk7nVMZMd7bAyp5
w27XHxySHeTdxQ237j7yYJ8FAF9B3tBEp1BHI2elna7c1W+8sQdU8ob1zt3U
JfvI4qoeD/ZZAPAV5A1NdAq1Ob6G86ajx4139YBK3rDe7hNXi+Incuxp5EQO
gMKCvKGJTqGWbOuRRrq/9ZTxrh5QyRuF4MH2CU7kAChAyBua6BTqs/JW6aKN
fReNt/SASt4oENfFT+R4b0n4h3usyAFQKJA3NNEp1FvzaqWL9o5dN97PAyp5
o3CcuzF2IkfZdlbkACgUyBuazPo16S+4++Bn7kSfp+SNwrHr+NXfzq2JH388
7f3uDADeMO3QCelMW6jTl+5I8/ysvNV4Jw+u5I2CUpKGOpFjmFurABQA5A1N
pi1U9/Gr0jnnbuoy3saDK3mj0Fy9L3ZrlY9WNP/46BdvdmQAMAV5Q5NpCxXq
PBNbfGPPgPEeHlzJGwXo1+s7ZMdZvXfQmx0ZAExB3tBk2kJtPnqCxTfylLxR
gLYMXvr9gnrZd+qOnfNmXwYAI5A3NJm2UEt39ErP3NfM4hu5S94oTHeGx9SJ
HGeu3PVmdwYA7yFvaDJtob78vl0aZkPPeePdO7iSNwrWZTv7Zff5Zn2nN7sz
AHgPeUOTaQv1zqLYnHD3iWvGW3dwJW8UssWrYsvlVdWe8GaPBgCPIW9okr1Q
Pz7+RVrl2/PrjDftQEveKGRru86poyrHTlzzbL8GAM8gb2iSvVCXbjyIXda3
stl40w605I0Ct+LwsOxHf1zScOcB65wD2AZ5Q5PshRo6fVP65NcbOo137EBL
3sA5lbF1zlfu7vds1wYAbyBvaJK9UE39F6VJLtnWY7xdB1ryBnYOX1GnQtV2
c3ksgFWQNzTJXqjqpnHpkGsPDBlv14GWvIHirsZxdSLHuav3PNvBAcBtyBua
ZC+Uur/2trpR47060JI3ULl0R5/sUN9WRDzbwQHAbcgbmmQv1MKtx6Q9Huo4
Y7xRB1ryBioHT938eGWL7FO7wmOe7eMA4CrkDU2yF0otHdDcf9F4ow605A1M
qG5IJMpjz3ZzAHAP8oYm2Qv19vw6aYy9J68b79KBlryBya7dHztM+emq1sdP
nnq2pwOAS5A3NMlSqAc/PZGu+PsFLPaVr+QNTLFkbew2ARWHhr3c2QHADcgb
mmQp1MUb96UlfsxiX3lL3sAUw70XfjunRvavzuErXu7vAOA45A1NshRKLfb1
zfoO48056JI3MN1NR4/L/vXu4obb9x95ucsDgLOQNzTJUqiWgUvSDxdX9Rjv
zEGXvIEZnbsxtujod3sGvNzlAcBZyBuaZCnUgdbT0gxX74sab8tBl7yBGW0f
uvz7BbFTsht7L3i51wOAg5A3NMlSqI2hEemEW46eMN6Wgy55A6dye/2o7GVv
zau99sOPXu74AOAU5A1NshRKrYW4t+W08Z4cdMkbmMUF8VX1yrb3ebnjA4BT
kDc0yVKor9d3SBusP3bOeEMOuuQNzGLXiat/XByWfa2m66yX+z4AOAJ5Q5Ms
hXq/LNYDO0euGG/IQZe8gdnd3TimFh29eOO+l7s/AOQPeUOTqQr17Nlz6X6/
nVNjvBVbIHkDp3XJth7Z4xZuPeZxBwCAPCFvaDJVoX6490i633tLwsb7sAWS
N3Ba+05en720UXa6UOcZj5sAAOQDeUOTqQp15spdaX3Fq1qM92ELJG+gjnub
T6mjKuev3fO4DwBAzpA3NJn1axLP949dl773l8qI8SZsgeQN1FRdFDZ/c7fB
ngAA0zLV0AlZmKpQjX0X4tfo9RrvwBZI3kBN+8ZuzF7eJLve4Q6OqgAEA/KG
JlMVal9LbHHR71lc1AnJG6jvPo6qAAQK8oYmUxWqUi0uWsPiog5I3sAZuXRH
b+yoyhauVQEIAOQNTaYqlOp4+1pOGe+9FkjewBnZP36jKH6typFOVgAD8Dvk
DU2mKtQ36zul3dUdO2+891ogeQNnauJalUs3HnjcEwBgRpA3NJmqUB8si520
1j7E4qIOSN7AHCzbHptjXFTV43FPAIAZQd7QZKpCvTG3RnrdwKkbxruuBZI3
MAd7Tl57L35Pgbrucx63BQDQh7yhScZCXbn1ULrcOwvrjbdcOyRvYG6q+6pI
+L/O3eoB/IojeSMSiVRVVVVUVJTGKS8vlz+Gw+H8t+wfMhbq8s0H0uU+WtFs
vN/aIXkDc3bR1th9VZbv7Pe+OQCADvnkjYmJCYkWRUVFs6ZGXiBpxME3bIqM
hTp+dlJa3Fdr2403Wzskb2DOdh2/+s7Cetkfm/ovet8fAGBacssbk5OTEiRU
oigpKVGzGZIrJIG8jE93CNXV1WVlZSqNlJaWqm8Fl4yFioxciV/+32282doh
eQPzcXv9qOyPsxbWn7161/sWAQDZySFvSJaQFFFcXCyJQidFhEIhyRvyi+T1
Ob1HX5CxUDVd56S/rdjdb7zT2iF5A/N03qZu2SVX7x30vkUAQHZyyBsSGyRC
zPSnJKVUVFTM9Kf8Q8ZC7QrHzlJbf3DYeJu1Q/IG5mlb9NJbpbWyV0ZGrnjf
JQAgC1yfoknGQq07MCSdbVv9qPE2a4fkDczfTUdjtxiYvazx0c9PvW8UADAV
OeSNyclJ/RdHo9GZbt+fZCzUkvhCQ/tbWczcGckb6Ihq1d/NR4973ygAYCpy
yBtVVVU6x1MkaahTSXN6X74jY6FeL2Z+zniDtUPyBjpiQ+95tcj50Omb3vcK
AMhIbnlDfip75KiurlZXptidNz5czmLmTkreQKdcGz/W+eX37d73CgDISA55
IxwOqyyRMXJMTk6WlZWpS2XlwYwOvviZjIV6M76Yef84i5k7I3kDHbR4VYvs
nnubT3nfLgAgndzOF41Goxkjh7pUVp6Xr9avL/rw0RPpZr9fwGLmjkneQAc9
3HFGHVU5e4XlOADMk/P1KemRo6Kiwr5pjQTphbo2Gbt5ygfLmoz3VWskb6Cz
Lt/VJzvpgi3HjDQNAEgmn+th1Rmh6iQN9cC+aY0E6YU6dfG2tLIv1rCYuWOS
N9BZe0avvx+/dWz9sfMm2gYA/JU819+YnJxUScPWaY0E6YXqG7shfWxOZZfx
pmqN5A103F2N47Kfvj2/bvLeIyOtAwAU+a/3lYgcOSw6GiDSC9XUf1H62JJt
PcY7qjWSN9ANSzfHFjlfs8+StYAAAooj64smbt8mX/Pfmj9JL9TBtonYnRr2
DRpvp9ZI3kA3bItefnNe7FKyntFrRroHALzM9X5tVZlQp4+WlZUlP2nHzehf
ZipUVW3sZpQbQ8eNt1NrJG+gS1aGjsve+umqlmfPXxhpIACQ83pfmli83tfq
fYPSwXaGx4z3Umskb6B7frGmXXbYXeExIw0EAHLIGxMTExFtdG5YHwjSC7Vw
6zFpXwfbJ4w3Umskb6B7Hu06q5bjmLh8x0gPAShw3L5fmyM/6AfSC1WytkN6
V0PPeeON1BrJG+iqK3f3yz47f0u3kR4CUODkdjyloqJipuGhurq6rKxspr/L
P6QcJ5JnPnh185TLxruoNZI30FX7x2++X9You22497zpjgJQEKQPnTNCLfNV
VFRUXl4+7e3m5QUSToriBHopsPRCvVVaG7t5yhg3T3FM8ga67a7wmOy27yys
v/fwZyOdBKBgyfl62MQdYIuLiyV4qEtREsgf5Un5loo08jjQB1NephXq9v3H
ahEh4/3TJskb6IFzK7tk591waNhUMwEoTPJZf0MiRCgUSqwvmo7kDQkedpwy
mlKoW3d+kpZVtLTRePO0SfIGemDTwAV14ujQ6Zum+glAAeLUel8pi3KEw2E7
YkaClEKdvXJX+tVnq1qNN0+bJG+gN649MCT7b8m6DlP9BKAAcSRvFAIphRqe
uCX96usNncY7p02SN9AzP/muRXbhwx1nTLUUgEKDvKFJSqE6h6/E7nO99Zjx
tmmT5A30zP1tp9VRlRu3fzTVVQAKCvKGJimFqjt2XjrV8l19xtumTZI30EvV
kn2rqgdMdRWAgoK8oUlKoaqbYze5Xrt/yHjPtEnyBnppx/BldVV738nrphoL
QOFA3tAkpVCbjsRu/7T5KDdrc1LyBnps5eER2ZE/X91mqrEAFA7kDU1SClW+
N3aztl2N48Ybpk2SN9B7P1vdKvvyvpZTpnoLQIFA3tAkpVALt/ZIjzrUwc3a
nJS8gd57uOOMOnH06q2HptoLQCHgSN6IRqPl5eVquVG10Ghpaal8zX/L/iGl
UCXrYjdrq+dmbY5K3kAjLtnWK7vzd3s4cRTARfLPG+FwOLGaqMob1dXV6plQ
KOTIm/QDKYX6aEVz7GZtUW7W5qTkDTRi58iVt+fXyR7dO8qJowBukWfemJyc
LCoqKikpUTduU3lDHkQiETXdYc0qoymFmrWgXrpTz+g1463SJskbaMqNodgZ
4J+Vt5rqMADWk2feCIVCsoXEoZNE3ngZjxzyx+rq6nzfoj9ILtQvT59Ja3pz
bo3xJmmZ5A00qDpxdH/raYN9BsBi8swbki6St5CcN9L/GGiS/5p3HsRuDvuH
xQ3GO6RlkjfQoIfaJ9SJo9d+YMVRAOfJM2+oUzUSB02SA4Y8aev8xpVbD6Up
fbSiyXiHtEzyBpp1cVUPK44CuESeeSMajcoWysrKEltL5A15Uv6ozuuwgORC
jV+8LU3pT6vbjLdHyyRvoFkTK44OjN8w2G0ArCT/61PKy8tlI6WlperYivyx
urpaXasijx15k34guVDSi6Qj/aWCm8M6LHkDjVtxeFj27i+/bzfYbQCsxJH1
NyoqKmalIU9OTk7mv/GX8VNP0zc1MTERSSN9OkW9LMtlMrLljD+YQnKh2ocu
S0dauLXHeG+0TPIG+sFP47eqD3Vyq3oAJ3FqfVEZ0EOhUFWc6upqBy+DVet7
pK8epuZVUigtLU1+S/LH5G+lvCtJGslJqbi4OMsaZcmFqus+J+1oBTeHdVry
BvrBfa2xW9W/Na/2h3uPHGpjAODA+Rvp47iDyPbVOh7pSUB+r3yr6tckVhiT
LFFSUpJY71Qd65FnkregEktZWZm8QH6wKM5Uf5fkQu1rOSXt6Pv9UeON0TLJ
G+gTSzd3yT6+/uCQo/0MoKBx5HpYp46bpJBYNCxj3kiZzUhBXTiTfHWMeiYR
SFLOdE08M9U5J8mF2lp7QnrRpiMjxruiZZI30Cc2D1xU18aOnvshh94FAOk4
ez2sg6gjHZI31HUuKXlDXWwrr5nqx9WRlOQgJI+TI4pKSuFwOPmn1JRIxg0m
P792/5A0oh0NJ413Rcskb6B/XLMvKrv53I1dObQvAEgn//XMZQSXYVoGbmdT
hzr8IdtXwSAlb6iTOkKhkDrbM+PsR8rRk5evQ0jy45SZmYy/K7HBxOOlO3rj
6xCeMt4SLZO8gb6yaFmj7OlN/Rdz7mMAkMCR4ylZyHl90cShkIwZQD1ZVlaW
OOAiD5JP3sh4tCU5Y2Scysg46aFIfrH8L490oaNdZ433Q8skb6Cv3FF/Uvb0
98vCj588y62PAUCCPPOGDPGlWcn/FrEZ84Y6yFJcXCzbl29JOFHBQ/06deuW
qfKG2pRKKRl/V8aMlPziP61ui/1fT99F4/3QMskb6De/Wd8RO3hafzLPPgYA
eeYND8iYNyRgSORIPhqizvaU1PHStbyREeP90CbJG+g3a+IXv4sXr993pKEB
FAJTjZim39c0ZDmnIoXEmaUqe0yVN9TSXmo+JOPvynjPl+QXvz2/TvpP78nr
xpuhZZI30Icu29EXW29nd/+MmxcAJBHQ4ynTvjJL3kh/rPO7Ei/+5enz2M3o
53Ezeuclb6AP7Tp+9e3S2P9i9I1dn2n7AoAEvj1fNOVXJGcAdU1K+lmdav0u
9criOCkvSH5SvTjlmpqMTyoShbr38OfYzegX1Rtvg/ZJ3kB/WhEa4aYqAHni
xvEUtbZ58gUj+ZBxzkGdLJr8jIQQeUadv/HydXJIvitKynJe8t7SD53Ij6en
lMRvVA+uTcZuRv/hMm5G77zkDfStn8RvqlLTdS6/fgZQuLh3/oYa0PNflCNj
3lBxIhEeJGyoZxLTKeqUUbWCx8uk5c0T25Fn1ALmiUySsoUUEoWauHxH2s7n
5a3GG6B9kjfQt+6N38Vg1sL6Bz89ybOnARQmrp4v6tLxlJdJ+aG4uFjdSGVW
2lLkiRVKEy9Imc1Qi4apMz1kO7N+vbx5+t9FPRg5c0vaztfrO4w3QPskb6Cf
nVMZW3hna82JPHsaQGHiXt5QS47nnzfUKakZ7xcv35KEIN+VrxmP3UhKkRAi
L5CvGc8ClTcpsSTLFhIkCtUzek16zrxNXca7n32SN9DPNvScV9fGnr16L6dm
BlDQuJQ31H1jZ02xVmcQSRSquT92I6cl23qNdz/7JG+gz12+K3Zt7LKdfWbb
EUAQcfX6lCz3bw0ciULVdMXW/1m5Z8B467NP8gb63GMnrs1aWK+W3zHbkQAC
h0vrb5SVlVVXV7t0n3ojJApV3Rw7bWztgSHjrc8+yRvofyu5NhYgJ/y/vqhP
SBRqa80J6TYbj4wY73v2Sd7AQKiuja3t5tpYgBmQZ96IRCJZzgiVb9l3/sa6
g0PSarbXjxpvevZJ3sBAuKdpPL7oX8OPj38x25cAAoQj529k2Xj+16f4hMRf
c8Wufmk11c2njDc9+yRvYFD8tiIS+/+OulGzfQkgQOSQNyKRSOI8DbVsRcZT
ONT6GBnvfRZEEoVasOWY9JlDHWeMdzz7JG9gUKw99uq+sZducN9YAC1ym99Q
17pOS2J5TwtIFOqbDZ3SZOqPnTPe8eyTvIEBcunO2LWxq6oHzLYmgKDg6vEU
m0j8NYtXxU4Vaxm4aLzd2Sd5AwNkZPjKm/NqpBsMnb5ptjsBBAJXzxe1iUSh
3i8LS4fpHLlivN3ZJ3kDg6U6e/zbygxrFwNACq7OTkxMTGRchzyIJAr1u9Ja
6TB9J68b73X2Sd7AwFm0tFEaQuvgJbMNCsD/5J83JFGoU0MzYs3shyrUs+cv
pLe8MbfGeJezUvIGBs7t9SelJ3y0ounFixemuxSAr8kzb6i7uqtTQxPXqqgH
QkVFhWXzGw8f/aLuSW28y1kpeQOD6Bfft0tbONg2YbpLAfia/NczT1z0qm7v
rgKGfJUcInnDmXfpA1ShJu8+ksbyflnYeIuzUvIGBtGD7RPSFt6cV3PnwWPT
jQrAvzhyfYq66FW+Ji+4oaLIxIQlmV8V6tKNB9JYPl7RbLzFWSl5AwNq6aYu
6Qybjx433agA/Iuz18MWFRUln7Bh33pfpy7elq7yp9VtxvublZI3MKCGey+o
5b8iw1dM9yoAn+LI8ZTEJIZaWTR545adLzo8cUtaytcbOo33Nyslb2BwXb4r
tvzXit39pnsVgE/JM29I0pAtlJeXq0MqFRUViVM4qqur7Zvf6DlxTVrKvE3d
xpublZI3MLh2Hb/6dmkdy38BTEX+18NK2EjMY6j4oS5Xka9FRUWWnb/RFr0s
/WTxth7jzc1KyRsYaNfHl/+aU9llul0B+BFH1vuqrq5OXPcaDofV9bDyNRKx
Z9k9Vaj6Y+elnyzb2W+8s1kpeQODrlr+S/7HxHTHAvAd+a+/YVOoyIIq1KH4
hW+r9w0ab2tWSt7AoLutblRaxCfftZjuWAC+w5HzRa1Z1CsLKeumGm9rVkre
QAv805o2iRyhzjOmmxaAeVKGznw2VWj3h91ac0I6yaajx433NCslb6AF7m89
pVYhfvjoiem+BeAj8r8/rE0XoWRBFWrdgdj5YDsaThrvaVZK3kA7/LYyEmsU
9SdN9y0AH5F/3igtLVUXpJSXl1elYc3ZHapQ3+0ZkDayp3nceEOzUvIG2mFt
9zm1/Ne1H3403boA/IIjx1OyYNl6X4u39cRuzNQ+YbyhWSl5A61x0bZj0ivW
HRwy3boA/EL+631FsmLZ+htzN8buknC066zxbmal5A20xtb4Wj3iqYu3TXcv
AF9QIGd75o8q1FdrYzeebug9b7ybWSl5A21yVXXs8OvSHX2muxeAL3Akb0xO
ToZCobKystLSUnkQjUarqqrUCufWoAr16aoWaSCtg5eMtzIrJW+gTfaMXpu1
sF46xsD4DdMNDMA8+ecNSRdqQdHECRvqzilFRUU2rcuhCvV+WTh2C8iRq8Zb
mZWSN9AyNxwalo7xbYUlp80D5EP+eaOkpESihWQMdfMUNbOhziOV562Z5VCF
mrUg9n8r8r8txvuYlZI30D5nL2uSptE+xArnUOjkmTfC4bBsIRQKJbaWuCBF
zXIkvhV0VKHUCWCDpjuYrZI30D6r4iucF69qMd3DAAzj7PqiKRfAWnY97M9P
nknfeKuU0dAtyRtopZ+Vt0rrqO0+Z7qNAZjEkbyROGiSHDDkScvyxv0ff5am
8c7CeuPty1bJG2il1c3j0jreWxL++clT050MwBiOrGeeCBXJj1UUsWl90cm7
j6RpFC1tNN6+bJW8gbb6zfpO6R57m0+Z7mQAxnDkfFEVMxLZIxqNlpeXq0XO
HXmTfkD+OlduPZSO8dGKJuO9y1bJG2irhzvOSPd4Y27NnQePTTczADPknzcm
JydV5EhBnrRmcdGX8UKdvXJXOsZn5a3Ge5etkjfQYks3xVYn3lp7wnQzAzCD
U+uLhkKh8vLy0jhlZWXWXJaSQAp18vwP0i6+XNtmvHHZKnkDLbah57y6wO3q
rYem+xmAAVjPXBMp1NDpm9Ir/rwhYrxx2Sp5A+12SfyGj+sOcBM3KEScyhvR
aLS6ulrdg16t/eXIZv2DFKpn9Lr0inmbuo13LVslb6Ddtr2+idvE5bumWxqA
1zhy/kZpaWn6+Rvl5eXWLC76Ml6ojqEr0igWbu0x3rVslbyB1vvdnthN3Jbv
6jfd0gC8xqnrU9Sd2tQ96OWBSiBlZWWOvEk/IH+dpr6L0ijKdvQZb1m2St5A
6+0+ce13pbXSSYYnbpnuagCe4sh65uXl5enfUpfEWnPLNvm71HSdky6xYne/
8ZZlq+QNLATXHhiSTjJ/S7fprgbgKc6uL5qMfeuLHmybkC6xet+g8X5lq+QN
LAQHT914d3HsTtPb60+abmwA3pFn3lA3ZSuQvLGnMbYo8fqDQ8b7la2SN7BA
3HhkRJrJNxs6TTc2AO/IM29MTEwUFRVlPJ6ioog1F6rI32Vb3UlpERtDx403
K1slb2Dh+GH8PvVtg5dM9zYAj8g/b1RUVKjzRcPhcOQ16uQN+RpJItDZQ/46
G0Mj8eUBR413Klslb2DhuC1+n/rPyltN9zYAj3Dk/A1NAn1sRd7/9/uj0h92
NJw03qlslbyBBeWnq1qkpTT0nDfd3gC8IM+8EYlEqrQJ9L1ipVDf7Y5dOF/d
NG68TdkqeQMLyt2NY9JSZi9rev7ihekOB+A6rGeuSWw5ke290hz2t54y3qZs
lbyBheaX37dLVzncccZ0hwNwHQfzRiQTgT5nI5mUY0PG25SVkjew0DzQdlry
xh8WNTz6+anpJgfgPClDZ55bC4VCRUVFVp6zkYz8Xb6tiEhnqO06Z7xH2Sp5
AwvQP2+IqAO1ppscgLvkmTei0ajKFaVTYM2N6eXv+NXa2MxnQ+954w3KVskb
WIAe6TwjjeWNuTV3H/5sus8BuIgj16cE+kRQTeSv+Vl5q7SFpv4LxhuUrZI3
sDCdt6krttxo3ajpPgfgIo7kDafejJ+Rv+aHy2Pr87RHLxvvTrZK3sDCtP7Y
eXWf+pu3fzLd6gDcwpHjKQUyv/FeWeyWB13HrxrvTrZK3sCCdeHWHmkvm44c
N93qANwi/9mJ8vLykpKScDjsyPvxLVKo3y+ok4bQM3rNeGuyVfIGFqxNfRfV
FMflmw9MdzsAV8g/b0QiEVvXFE1G/i5vzK2RbjAwft14a7JV8gYWsmqFn3UH
hkx3OwBXyDNvTExMqFxRUlJi/fUpsXPI59QYb0oWS97AQrY1eklNcZy9etd0
wwNwnjzzhroJrDWhIgsqb/yulKHQRckbWOCu2N0vfaa8etB0wwNwHq5P0UTl
jXcW1hvvSBZL3sACt3PkyhtzYsdtT126Y7rnAThMnmkhHA7LFqxZtDwLKm+8
tyRsvCNZLHkDcVX1oLSaZTv7TPc8AIfJf3aitLS0pKTE+sih8sbsZU3G25HF
kjcQu09cfbu0VrrNiXM/mG57AE6SZ94IhUISNtQpo0VFRdafL/rRCvKGi5I3
EMW1+4ek2yze1mO67QE4iSPnbxTI9bDSAT5d1WK8F1kseQNR7Dt5fdbCemk4
Q6dvmu58AI5RIGd75o/KG39a02a8F1kseQNRuf7gsDSc+Zu7TXc+AMcgb2ii
8sZXa9uNNyKLJW8gKgdP3Xh3UYP0nL6x66abH4AzOJI3JicnQ6FQWVmZOmEj
Go1WVVXJk/lv2T+ovPH1hk7jjchiyRuICSsPj0jPmVPZZbr5AThD/nlD0kVx
cXHyCRtqEbCioiL5liNv0g+ovPFtZcR4F7JY8gZisuoekd3Hr5rufwAOkH/e
KCkpkWghGUOtba5mNtR5pPK8NbMcKm/M29RtvAVZLHkDMdlNR49L2/lmfafp
/gfgAI6s95W46DX5ghTLljpXeWPB1mPGW5DFOpg3WnvHN+48nOLuw83prww1
9cq35GuWHxTl+ZQfVM9n/O1qm+k/kv7rplK9bKpXyl8k45vM8tfEgDp7WZN0
ns7hK6ZbIEC+OLueecoFsPZdD7u4qsd4/7FYB/OGDLu/ycT/+r/9/aoN25Nf
+UHx1/K8fM3+g8L/+X/9x+ShXD2Z8berbWZMI//2H/9JviVfs7xz9Zrk95x4
e0p5J1O9SfU+jf9TolNurT2hzlQ33QIB8sWRvJE4aJIcMORJ+/LG0h19xvuP
xTqeN2TklZE64X/6L/9VjcjJSSBj3lBDfLIqA/zN//y3iVmLHPKGxBW1cfma
cRZCspDarLxV9Xv/+//7hvxSeeZ3f/gg8TKVN+RbKW9SuXD5OuP/lOigH62I
TXFsOMh96iHY5Jk3IpFIcqhIfqyiiLwg37foD1TeWLm733jzsVjH80bKtIAo
Y7EazRPPZMwbGacIVFz5as4S9ccc8oZkBnlevQdJC+k/mDGKSMJRzyeOrai8
MdXRHLTMbXWj0ny+WMMUBwQbR84XVTEjkT2i0Wh5ebk8lm858ib9gMobq6oH
jTcfi/Ugb0TjOSE5TujnDTX5kPhWDnlDYoOoHiRPlUz13hJKREk+mkPeKDQ/
+a5F+k/LwCXTjRAgd/LPG5OTk4lbqCRj2U3cVN5Ysy9qvPNYrAd5Qz2fPLeg
nzdSvjXTvKHiijoskpjoSPlBCSEZc0iK5I1Cc0f9Sek/xataTTdCgNxxan3R
UChUXl6u7tFWVlZmzWUpCVTeWHtgyHjnsVjH84bkiuQLN2R8VxMLyRd96OcN
2VryKxOngqSrXpmSB9STao5CnciR/ltUDpE3+dWcJVkuM1F5Q16jeSkNWuCn
q1qlBTX2XTDdCwFyhPXMNVF5o+LwsPG2Y7EeXJ+SPquQMW/823/8p+QRfNWG
7SotJGeVqbafIDlvSAaQn1UHU5TqBNT0y11V5FDIj/yn//JfJVekRIjs16cw
72Glu8Jj0oI++a7FdC8EyJEc8oZlJ4JqknK0yHjzsVK3r09JXOuRfJxF/3pY
+dnkoVw9mfEKkfTjHeoc0eRrTCRFpDyTUEKIfDc5VMivTo5J2a9PmXZxDwyo
n5XHpjgaepjigMCQMnTO9McLNm/Inr6l5oTxnmOxHpy/oeYZkicWNK+HTZ80
UEkg429PP38j/QiISiDyZqb9i6ipleQNcv5GYbq7cVy60Mcrm023Q4BcIG9o
ovJGVd2o8Z5jsd5cn6IOWCS+pX/+Ror6eUOyTZbDH4n1x9TSphnPvlCTIYnL
eMkbBevnq2NTHHXHzpvuiAAzhryhicobO+pPGm84FutN3kgJGB7kjcShk5QT
O9XLEilC/TFl+dPkX5d4V+SNgnVPU2yK48PlTaY7IsCMyTlvVFdXRzSw5pJY
lTd2NXLmv4t6kzfU4YnE6RAe5I2U1boSphzcURfMZlzqPOUyXvJGIfvFmnbp
RTVdZ003RYCZkXPe0MSy9cyrm08Z7zYW63bekPFdJYHkNS7czhvq0tepbpiS
co1t4u4qkj3UO5SvEo1ULGG9LxT3tpySXjR7aeOLFy9M90WAGZBz3igvL6/S
wJrDLipv7G8lb7ioN9fDytidfMzC7byhThdJrIKe8X0mrpOVdJHxWteM16dk
wfg/JbrqF9/HpjiORpjigCDB+RuaqLxxsG3CeKuxWAfzxu7DzTIop6jWskg5
rqGWCk+M5uoHM16mmqLaZsZvJS8/Lr9UHmdZg0u9IHl1Lwkh8gaS33PKjye+
O5XG/ynRVfe1nJZ29H5Z43OmOCA4kDc0UXnjcMcZ463GYh3MG4h2++Xa2BTH
EaY4IDiQNzRReeNo11njfcZiyRuImu5rVVMc4WfPmeKAYEDe0ETljdruc8b7
jMWSNxD1/So+xRHqPGO6OwJokUPemJiYkLAxOTnpxvvxLSpv1PecN95kLJa8
gajv/tbYhSrvLQk/ffbcdIMEmB7u16aJyhvh3gvGm4zFkjcQZ2QJUxwQHMgb
mqi80TRw0XiHsVjyBuKM3Bef4vgjUxwQBMgbmqi80Tp4yXiHsVjyBuJMfXUW
RwdTHOB3yBuaqLzRPnTFeHuxWPIG4kxNnMXxy1OmOMDXkDc0UXkjMkzecFHy
BmIOcqEKBALyhiYqb3Qdv2q8t1gseQMxB/e3xdbieK+MKQ7wNeQNTVTe6Bm9
Zry3WCx5AzE3v1rbwRQH+BzyhiYqb/SevG68sVgseQMxN1+dxVHGhSrgX8gb
mqi80Td2w3hjsVjyBmLOfsUdVcDfkDc0UXlj8JT5rmKx5A3EnFVTHLE7qjDF
Ab6EvKHDixcvpFC/nXPUeEuxW/IGYj6qKY6jTHGALyFv6PD02fPYODivxng/
sVvyBmI+7muJ3zR2aePzF9w0FnwHeUOHJ788k0L9rrTOeD+xW/IGYp5+yRQH
+BXyhg6Pfn4qhXp7PnnDXckbiHm6rzl2FkfR0kZmOMBvkDd0+PHRL1KoWQvI
G+5K3kDM3y++j01x1HQxxQH+gryhw/0fn0ih/rCo3ngnsVvyBmL+7o1Pccxe
1mi6cQL8CvKGDncePJZCvbs4bLyT2C15A9ERv1gTm+Ko7T5nuncC/BXyhg4/
3Hs069cY7ydWSt5AdMTq5nHJGx8ubzLdO6HQSRk6Tb+dAHDrbixvFJUxv+Gu
5A1Ep/x8TZtEjvpj5023T4BXkDd0uH77RynU7OVNxnuI3ZI3EJ2yuik2xfHx
ymbT7RPgFeQNHa5NPpRCfbC82XgPsVvyBqKDfra6VSJHQ8950x0UIAZ5Q4fL
Nx9IoeT/FIw3ELslbyA66O7wmOSNT1a2mO6gADHIGzpcuH6fvOGB5A1EZ/2s
PDbF0dh3wXQTBSBvaHH+2j0p1KerWo13D7slbyA66674FEfxqhbTTRSAvKHF
2St3pVDyfwrGu4fdkjcQHffTVS0SOZr7L5ruo1DokDd0OBPPG5+vJm+4K3kD
0XF3NJyUvPF5eavpPgqFDnlDh1MXb0uhvljTbrx12C15A9ENP/kuNsXROnjJ
dCuFgoa8ocPYhVje+PJ78oa7kjcQ3XB7/ajkjbfm1ZpupVDQkDd0GD33gxSq
ZC15w13JG4gu+fHKZokcHUOXTXdTKFzIGzocPzsZyxvrOow3DbslbyC6ZFVd
bIrjy+/bTXdTKFzIGzoMT9ySQn2zodN407Bb8gaie364okkiR+fwFdMNFQoU
8oYOQ/G88WfyhsuSNxDdc2vtCckbX6/rMN1QoUAhb+gQPXVTCvWXCvKGu5I3
EF119vLYFEf38aumeyoUIuQNHfrHb0ihvq2MGG8XdkveQHTVzUePS97484ZO
0z0VChHyhg59Y7G8MZe84bLkDUS3LSoLS+TY0XDSdFuFgoO8oUPP6DUp1LxN
3cZ7hd2SNxDddtOR2BTH3I1dptsqFBzkDR2OnYjljdJNXcZ7hd2SNxA98L0l
DRI5+seum+6sUFiQN3ToOn5VCjV/C/Mb7kreQPTAylBsiqN0c7fpzgqFhf/z
xuTkZGlpaTQaTf9WJBIpLy+X78pXeZzDCyYmJioqKuQFZWVloVBoqvcQGbki
hVpA3nBZ8gaiBw6euvnuotgUx+CpG/k0Z4AZ4f+8IUlA3mR6Wqiurpbni4qK
JC3IV3ksz8zoBbJN9by8oLi4WB7I78r4HjqGLst3F27tMd4o7Ja8geiNGw4P
S95YuPWYs+0aIAs+zxvl5eWz4qTkDfljbIHxkpLJycmX8TkQeSzPTExMaL5A
nimKk5g5Ub8r4yxHezSWNxZV9RjvEnZL3kD0xoHx67MW1kvkONh22r0GDpCM
b/OGBIPS0lI1QZGeN1Q2SD7IIo/lGXle8wWSK9JnPOR3FRcXp7+Z1sFL8uLF
23qMdwm7JW8geua6g7EpDmlrTjVtgOz4Nm+omFEVJz1vSCqQF6T8SHEczRek
B5LEk4k5kAQtA7G8sYS84bLkDUTP7Dt5/fcLYlMcx89O5tmuAXTwbd6QYBAO
h+VBxryhTrpI+RE1H6L5guTHCTL+LqGp72Ls7I4dvcZbhN2SNxC99Pt9Uckb
0tnyaNUAuvg2b6jzLl5mygDqyMhUcSIaJ/sLXr6eP0l5gfpdKQdZXpI3vJK8
geilPaPXfldaK5Fj7MLt/Js2QHZ8mzcSpOcNdS7oVHEiEif7C17G/+JT5Q35
mvJ8uPe8PL9sZ7/x/mC35A1Ej129d1Dyxopd/c70a4CpIW+k/670vFHfc37W
FBhvFzZJ3kD02O4T196cVyOR4/SlO860bIDXI2w6pt/XNKTnjcnJySxxYjJO
9hfIY3V5bMbfpc4bSab+WCxvLN/VZ7w52C15A9F7V1UPSN6Qr860bIApCGLe
eOn5+aJ13efk+RW7OZ7iruQNRO+NjFz57dzYFMfZq/fy6dUA2Qlo3kieqVCk
zGlM+4KMUxkZJz2E2njeWLl7wHhnsFvyBqIRV+7ul7yxeu+gU30bIJ2A5g21
VnnyhSQpz0z7AnUNS/IC5unPJDgaOSvf+m4PecNdyRuIRmwfuix5Qzx/7b6D
3RsgmYDmjcnJSXXHE/mufEu9JrF6uc4LXr6+M4t8lReEQqGU5c2TOdJ5Rl65
qnrQeFuwW/IGoimX7YpNcaw7MORqP4dCJqB542V8OkIdNFHI45R1Qad9gWSP
xP1ZBMknGe8hK4Re5Q3mN9yVvIFoytboqymOyzcfONvDART+zxsSEiQGJM9L
pH83fQVy/RfIluUFGac1EhzuiOWNcvKGy5I3EA1atqNX8kbF4WH9/gygj//z
hh841D4hhVq9l+Mp7kreQDRoy8BFNcVxbfJH000XLIS8ocNBlTf2kTfclbyB
aNYl23okb2wMjZhuumAh5A0dDraRN7yQvIFo1qa+V1McN27/ZLrvgm2QN3TY
3xobB7/fFzXeDeyWvIFo3IVbY1McW2pOmO67YBvkDR1e5Y395A13JW8gGreh
97ya4vjh3iPTrResgryhw97mU1KotQeGjLcCuyVvIPrB+Vu6JW9sqxs13XrB
KsgbOlQ3jUuh1h0cNt4H7Ja8gegH646dU1Mcd+4/Nt19wR7IGzpUx+c31h1k
fsNdyRuIPrF0U5fkjZ0NJ013X7AH8oYOexpj8xvryRsuS95A9Im1XbEpjjfm
1tz/8YnpBgyWQN7QYTd5wxPJG4j+ce7G2BSH/N+W6QYMlkDe0GF341gsbxzi
/A13JW8g+scjXWclb/yutPbHx7+Y7sFgA+QNHXY2nJRCVRweMd4B7Ja8gegr
/1IZkcixv/W06R4MNkDe0GFnODa/URkib7greQPRVx7uOCN5Y9bC+sdPnppu
wxB4yBs67GwYi89vcDzFXckbiH7zm/WdEjkOtk95i20ATcgbOmyvjx1PqeR4
isuSNxD9piQNyRvvLm548vSZ6U4MwYa8ocP2utH48ZTjxvd9uyVvIPrQr9d1
SOQIdZwx3Ykh2JA3dNgWzxsbyRsuS95A9KHrDgxJ3nhvSfjZ8xemmzEEGPKG
DlW1sbyx6QjHU9yVvIHoT2ctrJfIcTRy1nQzhgBD3tDh9fwGecNdyRuI/nRf
y2nJG7OXNr5ghgNyhbyhA/Mb3kjeQPStX6xpl8hR133OdD+GoELe0GFr7YlY
3jjK+RvuSt5A9K3Vzackb3y0otl0P4agQt7QYUtNLG8kY3zft1LyBqKf/Xx1
q0SO+p7zplsyBIaUodP02wkAW47G8sZm5jdclryB6Ge/2zMgeeOT71pMt2QI
JOQNHSRpSKEkdRjf3+2WvIHoc4tXtUjkaOy7aLorQ/Agb+iwOT6/sYX5DZcl
byD63F3hMckbxataTXdlCB7kDR1ezW/UML/hruQNRP/7aXyKo7mfKQ6YGeQN
HTYdIW94IXkD0f/uaDgpeeOzcqY4YGaQN3TYGBqRQm2tJW+4K3kDMRB+sjI2
xdE2eNl0b4YgQd7Q4XXeGDW+m9steQMxEC7Z1it544vv2033ZggS5A0dNoZi
x1Oq6sgb7kreQAyKH69slsjRHmWKA3Qhb+hQGZ/fqGJ+w2XJG4hBsaruhOSN
L5niAG3IGzqQN7yRvIEYID9aEZvi6By+YrpDQzAgb+hQcZi84YXkDcQAWVU3
KnmjZF2H6Q4NwYC8oUPFoWHO3/BA8gZisPxwWZNEjsgIUxwwPeQNHV7Pb3A9
rLuSNxCD5eKqHskb36zvNN2kIQCQN3RQeWMb8xsuS95ADJyz41McXcevmu7T
4HfIGzpsiB9PIW+4LXkDMXBuOXo8PsXBWRwwDeQNHV7ljXryhruSNxCDaNHS
Rokc3UxxQFbIGzowv+GN5A3EILo5PsXx5w2cxQHZIG/osP7gkBRqe/1J4/u1
3ZI3EAOqmuI4duKa6W4N/oW8ocP6g8PxvMH8hruSNxADqpri+EsFUxwwJeQN
Hcgb3kjeQAyuaoqjZ5QpDsgMeUOHdep4SgPHU9yVvIEYXDcdGZG88W1lxHTD
Bp9C3tDhVd5gfsNlyRuIgfb9sjBTHDAV5A0d1h2I5Y0dnC/qsuQNxED7aoqj
gikOyAB5QwfyhjeSNxCD7qspDi5UgTTIGzq8yhsNY8b3ZbslbyAG3U1H1IUq
THFAKuQNHdYyv+GJ5A1EC+QsDsgIeUMH8oY3kjcQLZCzOCAj5A0dVN5Ixvge
baXkDUQ7LCpjuVGIkTJ0mn47AeD7/VEp1E7O33BZ8gaiHW46ylkckAp5Q4e1
+9X5ohxPcVfyBqI1vrppLFMc8Bryhg7kDW8kbyBa4+ajJ7hpLCRD3tCBvOGN
5A1Em1RTHF0jV023cPAF5A0dXp2/Eeb8DXclbyDa5Jb4FMfX6ztMt3DwBeQN
HThf1BvJG4iWOXtZbIojMnLFdBcH85A3dCBveCN5A9Eyt9TEpjhK1jHFAeQN
Lcgb3kjeQLTPD5Y3S+ToGLpsupGDYcgbOpA3vJG8gWifVXWjkje+XNtuupGD
YcgbOqzZF8sbuzhf1GXJG4hW+tHK2BRHW5QpjoKGvKEDecMbyRuIVrotPsXx
xRqmOAoa8oYO5A1vJG8g2uon37VI5GgZuGi6nYMxyBs6kDe8kbyBaKtLtvdK
3visvNV0OwdjkDd0IG94I3kD0WI/XdUqkaOxjymOAoW8oQN5wxvJG4gWu7tx
XPLGxyubTXd0MAN5QwfyhjeSNxDt9rPVsSmOumPnTDd1MAB5QwfyhjeSNxDt
tropNsXxwfKmF6a7OngPeUMH8oY3kjcQrfeLNe0SOY52nTXd18FryBs6kDe8
kbyBaL17W05L3nivLPzL0+emWzt4CnlDB/KGN5I3EAvBr9bGpjgOtU+Ybu3g
KeQNHcgb3kjeQCwED7TFpjjeWVj/6Oenprs7eAd5QwfyhjeSNxALxD9v6JTI
sbf5lOnuDt5B3tCBvOGN5A3EAvFwxxnJG2/Nq3nw0xPTDR48gryhw+q9g7G8
0ThufCe1W/IGYuE4d2OXRI6dDWOmGzx4BHlDB/KGN5I3EAvH2q5zkjfEH+49
Mt3jwQvIGzqQN7yRvIFYUM7f0i15Y2vtCdM9HryAvKEDecMbyRuIBWVD7wU1
xXHth4em2zy4DnlDB/KGN5I3EAvNxdt6JG9UHh4x3ebBdcgbOqi8kYzxndRK
yRuIhWbzwEU1xXHh+n3TnR6cJ2XoNP12AgDzG95I3kAsQJft7Je8sWZf1HSn
B3chb+hA3vBG8gZiAdo+dPm3c2JTHKcv3THd7MFFyBs6kDe8kbyBWJiuqh6Q
vLFsZ5/pZg8uQt7QgbzhjeQNxMK0+8TVt0vrJHKMnLllut+DW5A3dCBveCN5
A7FgXXtgSPLGwq3HTPd7cAvyhg7kDW8kbyAWrL1j1/+wuEEiR9/YddMtH1yB
vKEDecMbyRuIhWxl6LjkjT9v6DTd8sEVyBs6kDe8kbyBWOC+ObdGIkf70GXT
XR+ch7yhA3nDG8kbiAXuttpRyRufr24z3fXBecgbOpA3vJG8gYifrmqRyFHf
c9504weHIW/oUB7PG7sbx4zviXZL3kBE6bSSN2YvbXz+/IXp3g9OQt7Q4VXe
CJM33JW8gYjiV2vbJXIcbJsw3fvBScgbOpA3vJG8gYjiwfYJyRtvz6978NMT
0+0fHIO8oQN5wxvJG4io/LYyIpFjR/1J0+0fHIO8oQN5wxvJG4iorOk+p+5T
f+P2T6ZHAHAG8oYO5A1vJG8gYsJFVT2SNyoOj5geAcAZyBs6kDe8kbyBiAmb
By6qKY5zV++ZHgTAAcgbOpA3vJG8gYjJrtzdL3ljxa5+04MAOAB5QwfyhjeS
NxAx2a7jV98qrZXIMTzBfeoDD3lDB/KGN5I3EDFFdZ/6eZu6TI8DkC/kDR3I
G95I3kDEFAdP33yvLCyRIzJyxfRQAHlB3tCBvOGN5A1ETHdLzQnJG1+s4SZu
wYa8oQN5wxvJG4iY0U+/i9/E7dh506MB5A55QwfyhjeSNxAxo9/FL1R5b0n4
5ydPTQ8IkCPkDR3IG95I3kDEqfx6fYdEjuqmcdMDAuQIeUMH8oY3kjcQcSqP
RM6o5b8m7z4yPSZALpA3dCBveCN5AxGzuGBLt+SNyhArnAcS8oYO5A1vJG8g
Yhab+y+oKY4zV+6aHhZgxpA3dFB5Ixnj+52VkjcQMbsr4ieOLtvZZ3pYAC1S
hk7TbycAML/hjeQNRMxu9/Grb8+vk8jRP3bD9MgAM4O8oQN5wxvJG4g4rRWH
hyVv/HlDp+mRAWYGeUMH8oY3kjcQUccPljdJ5Gjqu2h6cIAZQN7QgbzhjeQN
RNRxR8NJyRsfLGv65elz0+MD6ELe0IG84Y3kDUTU9Ku17RI59racMj0+gC7k
DR3IG95I3kBETQ93vFr+69adn0wPEaAFeUMH8oY3kjcQUd8FW49J3thwaNj0
EAFakDd0IG94I3kDEfVtGbikpjjGLtw2PUrA9JA3dCBveCN5AxFnZHn1gOSN
hVt7TI8SMD3kDR3IG95I3kDEGdk/duPdxWGJHJGRK6YHCpgG8oYO5A1vJG8g
4kzdUnNC8kbxqlbTAwVMA3lDB/KGN5I3EDEHP1vdKpHjUPuE6bECskHe0IG8
4Y3kDUTMwQNtpyRvvDmv5va9R6aHC5gS8oYO5A1vJG8gYm7O29wlkaPi8Ijp
4QKmhLyhA3nDG8kbiJibzf0X1LWx41wb61fIGzqQN7yRvIGIObuqejB+bewx
0yMGZIa8oQN5wxvJG4iYs/3jN/4Yvza2feiy6UEDMkDe0IG84Y3kDUTMx6q6
UckbH61ofv7ihelxA1Ihb+hA3vBG8gYi5umX33fE7hvbzH1jfUdw88bExEQk
jWg0mvFl8nWq7UxOTmb8wWTIG95I3kDEPA29vm/stcmHzgw24BDBzRvl5eWz
0igtLU28QDKG/DH5WympQ5JGRUVF4gXFxcUSPDL/LvKGJ5I3EDF/F23rkbwh
fdvdQQhmSHDzhuSHoqKiql8TCoXUdyVLlJSUyN9OnpQUIV/lsTyTvAWVWMrK
yuQF8oNFcTLOhJA3vJG8gYj52z50+c25NRI5BsdveDEagR7BzRspsxkpVFdX
ywvka8oziUASjUZV2Ei8QD0jISR9a+QNbyRvIKIjbjg0LHmjZF2Hc2MO5EtA
88bExIS884qKiqleoI6kTE5OJp6Rx8kRRc14hMPh5J9SUyLpWyNveCN5AxGd
8uOVzRI5jkbOOjTsQL4ENG9ITlCTFepsz/TzLtKPnrx8HUKSHycHkpevQ0j6
1sgb3kjeQESn3Nscu6nK70pr7zx47Oj4AzkS0LyhgkFZWVlRUZE621MeJJ+8
kfFoS3LGyDiVkXHS4yV5wyvJG4jooPM2d0vk2HBo2J2BCGZGQPOGJA11RYlk
jEgkUl1drYKHihzyTJa8oaYvVEpJeYHKG/I15XnyhjeSNxDRQZsHLqprY4+f
nXwJpglo3pCAIZEj+WiIOttTUsdL8kZgJW8gorN+vy8qeePbisxrHYCXBDRv
ZERNeqjFu7LkDbW0l5oPSXmByhvJV7UoVN7IiPG9ySbJG4jouB8sa5LIUXfs
vGuDD6Qy1Yhp+n05RvLZnlnyRvrjjFtIhvkNbyRvIKLj7m4ck7zx+/l1dx/+
7M7gA1oEMW+oa1IynNUZX79LpYXiOCkvSH5SvThlda+MT74kb3gleQMR3XDO
xi6JHBWcOGqUIOaNl/G3nRInJITIM+r8jZevk0PyXVFSlvMKhULph07kx9NT
ykvyhleSNxDRDZv7L3DiqHECmjdUnEiEBwkb6pnEqZ7qlNGSkhJ1TmliefPE
sRJ5Ri1gnsgkKVv41a8jb3gieQMRXXLt/iHJG3/hxFFzBDRvJPJDcXGxupHK
rLSlyNW92ORbiRekzGaoRcPUmR6ynVm/Xt48GfKGN5I3ENE9P1rRxIqjBglo
3lCEQiFJCJIW5Gtisa9kIpGIhBB5gXzNeO/XiYkJiSVZtqAgb3gjeQMR3bO6
Jbbi6Jvzam7d/cnJoQj0CHTe8AzyhjeSNxDRVRdsOSaRY82+6PR9H5yGvKED
ecMbyRuI6Krt0ctvzovdqr7v5HXTA0vBQd7QgbzhjeQNRHTbisMjkjc+K281
PbAUHOQNHcgb3kjeQEQP/HxNm0SO6qZx02NLYUHe0IG84Y3kDUT0wFDnWbUc
x4Xr900PLwUEeUMH8oY3kjcQ0RuX7eiTvLF4W4/p4aWAIG/oQN7wRvIGInpj
z8lr7y5ukMjR1H/R9AhTKJA3dCBveCN5AxE9c0f9Sckb7yysv8d93DyBvKED
ecMbyRuI6KVzKiMSOTZwHzdPIG/oQN7wRvIGInpp88DF386JnTjaP3bD9Dhj
P+QNHcgb3kjeQESPXX9oWPLG56tZjsN1yBs6kDe8kbyBiN77p/hyHLsbx0wP
NZZD3tCBvOGN5A1E9N4jkVfLcZy+dMf0aGMz5A0dyBveSN5ARCN+t2dA8sbc
jV2mRxubIW/oQN7wRvIGIhpx8NTND5Y1SeQIdZ4xPeBYC3lDB/KGN5I3ENGU
+5pPqaMql289ND3m2Al5QwfyhjeSNxDRoIureiRvLNnea3rMsRPyhg7kDW8k
byCiQY+duPru4rBEjnDvBdPDjoWQN3Qgb3gjeQMRzbqjIbbI+e9Ka2/d/cn0
yGMb5A0dyBveSN5AROOWbu6WyLFqz4Dpkcc2yBs6kDe8kbyBiMbtHL7y9vw6
iRxtg5dMDz5WQd7QQeWNZIzvEVZK3kBEP7it9tWtY+8+4NaxeZEydJp+OwGA
+Q1vJG8gok+cG7917Jp9UdPjjz2QN3Qgb3gjeQMRfWJb9PLvSmslcrRHL5se
giyBvKEDecMbyRuI6B+31JyQvPHu4oa7Dzmq4gDkDR3IG95I3kBEXzmnsksi
x+q9g6ZHIRsgb+hA3vBG8gYi+srW6KW3OKriEOQNHcgb3kjeQES/qY6q/GFR
w+37j02PRcGGvKEDecMbyRuI6EPnbmIFMAcgb+hA3vBG8gYi+tD2octvL4it
ANbcf9H0cBRgyBs6kDe8kbyBiP50W92ouq/Kjds/mh6Rggp5QwfyhjeSNxDR
ty7Yckwix9IdfaZHpKBC3tCBvOGNKXmDdeO9l5pT9gIxh5p3H7/2h8UNEjlq
u8+ZHpQCCXlDB/KGN5I3jEvNKXuBmFvNdzeOSd4QL1y/Z3pcCh7kDR3IG95I
3jAuNafsBWLONS/b3it5Y96mbtPjUvAgb+jgdt5wtdsEaONe5g02zsb9s302
HqCN943d+GBZk0SOfS2nphoyXB1Y2bjdkDe82Th5g437c+OBfvNs3PGNH2g7
rY6qjJ6bzDhkBHfUDu7GrYG84c3GyRts3J8bD/SbZ+NubHxV9aDkjT+taXv2
/EX6kBHcUTu4G7cG8oY3GydvsHF/bjzQb56Nu7RxCRsSOTYfPZ4+ZAR31A7u
xq1B5Q0AAADIGdODeQCQvCE5lutT3PZQe+yoKOt9IWIg/HxNK4ucAwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOgTjUbLysrUAmjyQP447Y9U
VVUVFxfL6+WrPPbgTVrG5ORkeXl5UVGR1LCkpCQcDk/7+oqKClVzobS0NBKJ
ePNWbSLnz+3ExIT8Y0nZ3XtvtiKfbfmES82lgPKZl09y9tf//+2dMXLjuhJF
d+tsQmVOnU3oUJlDhQonnlgL8BJmEXq3fMtd/QESAkFTsvnPCVQSRBIgCHZf
Ag1QG8Rl6twFCpaa9GyOqPOVqLZVjT32ecDz/nRcOWpjxw/c5Non7iqS7ZVZ
0Kfr6m4F3gG6l21OdV+HaT2dTo3tbbFd53GZzufzPYv901nTbmPfTUu4P9Sq
Q92ptft725flpu7LpJS7FXgHDJj0yTpHcgwQtvqm3hi4TDtAt7/ONE5TX9rP
cfJxdpSRYjPC43Y/rrFQC26iqva5G1xGoBAkvkziHsXdBWvarZ7Qo1tpyzLu
jff398Jz+So0epbqpm6lh7TuZ71Jr68C9BBio8ewLL1MO8ASK7e066cdnhNa
vv1lSSLFVoUujn7UrtTYcopv+bkb3FekUCOSxMi8fobbrapd14v+jQHcuVFI
BZvZuV0OH+SUSRsFcwyYdKuLbEn0HZO+FD2VxPj4Tcs8cJl2wKRB8NPcnO+r
feX1ozuOZ+1OJluanNrSG7y2EtBguN3qorjrCb2xlFrjXT918qRR9a1BPNga
Bky6LUkOIfP2ulLblnVfeHBEBrnHMg9cph0wWTMWt3N3/aTV9ZDfVqXcF3PV
u9SdOeqDMdZOxtpttgDojaVMVm/DGru29VcOMZXXo5H3M2DSHQste+K99Gkd
vuMH7S2Qura07tEbA5dpB9ggTJ71pGmd+2vyODCJW9qk3ujXbJbHdDJ3MtZu
PZISe6E3ljLZpOfaf/zli+JQauJFl7LUpBsHDzx9gthYQ4/eGLtMPx30xv1Z
rzcc7HEzzh+CsXbroPEYDti3KdiCMb1R9DN7UHvHD31fy4AjiyhHazxXuFKK
gTDoBL0xB3rj/qzUGxYbPIAsYqDdepc8lrpvU7AFY3qj6M1w5AxdHJ0MODLv
kjWejQytfQz0xhzEb9yfNfEbvl6HwwGxsZRF7dYLpBQ+bt+mYAuWxm/MSRE/
fW9Vyn2x1KTPybnJWF/ogfiNORwGUCxueXN+St04mZ/Sj4Pwi9jvnvkp0c/J
MMoAi9qtb/w5UB2d2GdNzuOeFMyu9npahEOjNyzojlhq0ueeqZn+Nkz//JRF
nncHsP7GQ1i6/sYVsbGaRe1Wf71VPH2uk8naU50sXX/Dqru4NZiJvIilJp3+
jS+nR2/8f66/cZ1Z5axeqSCYW6cRI9zP5PqijbvbuhexsYb17Ravt5S59UUb
86p8UbLwxrwsZalJr+M37A1p7WN0dg0tvUz7wP1pjVXc68gWp/D+lGE80fJp
/v0pxUC2N5DdfqnYtxj+Wtrt9mawFhZ4gNwvNPn+lCKmtHhVUFyyR5T9p7LU
pMdkWN0OcZmISB9mUm/UsUk3L9Ne0Yk33lJX6438AkfeDzuGHv0a74fNjdMP
iXMwwNpPu92iNzZCD86N98MWeuP6v+8qxbyMsdSkZ3Pky8RIyjCdeuN66zIB
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAfBXn8/npk5eX
l0cXBwAAAPbG6+urZMbfv3/98/DBY4sEAAAAO0NiQ5Ijfkp4KOV8Pj+wSAAA
ALBv3t/fpTfe3t4eXRAAAADYLe7fQG8AAADARrhzg/gNAAAA2IiYoiLV8eiy
AAAAbM75fH6peH19Vfq/f//uXBhlfTwe46cKcDqdVh7z7e0tH7N/r5hFsh2e
GxsRpDrf379/3yFfAACAOyPH+jTD4XC4XC73LEyxJMWvX79WrlDhAImlZ+GR
jvv4fc+QjV4OXQ5V+/2VHgAAwKZYbxQhi3LQetBWujz+PX2fXHzWButXxHp+
fs7zTzs5nU7Kek2+/bj+Q2+otlXnRJACAMDOmNQbxpLjgb5vpd7waMVAN8Xv
D4bznWNyNopOsNA2Ekh3lnkAAABb09AbHlaQ7ysStbHDPI7HYw53vFwuSpSX
V6Kcpr7La9eLWSlF6f73dDplxxrxG44qce4+pg9YeGF5cCX++fNn8tT0VzH7
wwEhLrzOQj+PHxQ7KtMcN5ILnPPSjpZDccw4ndhF2xQnmCWQK7+oImWhxPWB
KwAAAN+Hht64fvrHGOPQF/lipTw/P4ceCHfp53eny9HrizfODt3hCv5Xn/4e
Hjk6NGq94TGOwjUXwQ8Zi6Ui+lTFjtx9Fj6RvGMR8pGLUZxOHMT/+nQkM1yq
SNEGdYW356fogMVeAAAAP5q23sjv+3BogYjHc/lKuVSl2GnaU+dnc++iFCsK
OXF75Di+VURsXwyg5J/WD8UwRyOg1IMpuTvC5xJqQQe0/CiOoKqILh1XTp4/
4l2sRkJv+Oz0GQoqVETRodGJ92JIBQAAdkNbb/hfu8vJHobc+W+9UTyYy7/H
EeoABrnURoBo8bPwws567uUjzrc4eDG8Eh0yOTGHmFpfZb/vTC1aXJ4saVxd
eSjEKXMjPnPkagcAANgBbb2R1YLDR+VM/ybsf+2y7b6L+SDZdUZ3hyM36mmq
bb3hLosQGO6vmOsEKOIw51YOL7LQ0SIL96jU/SfFUEseEKl1Qrt655iM6wAA
APi59MRv2IH6+yRZbxSHKlywnLUHHYy+5+3besNiIIZUJF0ac1079UYRv2H5
lIeHGlKhnlryVXrDxWBWLAAA7Ia2Q8zRF6E9avzI36M3jLY/nU7uMMkxFW29
cf3sY1F57JEb4xSdeqOIAFFJYjxosrumkcXkyaI3AAAArk2H6PGL6E/w+EXh
4t/f32PS6029oU9tnIdRYoTFP2/qjYjZ8CIVjfMqgj0cqlqIB3eY5CwOh0Oe
0lKHo/jIPt/t9MZY1AcAAMC3Zc4hxtTX8J6T0ZXucOjUGxYwxQae4eLvN/XG
9aNHQpnqs/1WlNr156k0eZtiCkz28sV04DjHHC/aznSN3iBeFAAAdkP43LdE
PdJhnO4lttxZkXsAbuqN6M3w29B0kGIJ01pvSCRoyywS3LPxdOutKPWqWU7R
ASV7dEyHwuYcLYdyAKp7RbzGiHbR0TxjxeXZTm94rY9FuwAAAHxn5t7XZr9c
bx9uOpx1OOjOeNEcd1q8K6TQGx7BKY7pXIqZrTVFcKnRGVmrhIrIOXpF0OI4
yi4HuEpcFfNTGid7HdUbdckBAAB+NHpUr+M/Jxe9zExuJhdfJ/r4xazVyLQ+
bNFroZ9Fokc9epb7npswm7POnn1y9fW5YkRifV45R6fcrM/MzVBYAAAA2Jri
haoN3BMSEiLiPAP3b3y3N5VI9tzsvQEAAIAtuFwuUhrusuh/xbw0RoSXePjj
eDy6f8Prln+3N7HWMasAAABwTyKCol8hyH1LUdh9a69iyTL9bAed3h+/BvfR
pQAAAAAA2D//AdYDqWI=
    "], {{0, 351.5}, {360., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{360., 351.5},
  PlotRange->{{0, 360.}, {0, 351.5}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[1]=",
 CellID->370580698,ExpressionUUID->"9f254b80-ff87-47a0-aaed-2cc1cf17cad4"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e4467ff2-6207-4a95-bf21-4838a3ea83a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"244e4fc8-4362-4809-a238-02652ec08443"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"1123112f-7e03-4e41-99f1-f706b5b228c7"],

Cell[TextData[StyleBox[ButtonBox["rhocK",
 BaseStyle->"Hyperlink",
 ButtonData->{"rhocK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"d2143685-9e9b-4100-a8b8-8be4c935f229"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"d37c78f1-23eb-4316-9e9b-507db1755ff4"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"5ef2a981-cf2d-4d45-8f5c-7c60b611d98c"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"95b317ad-c5bc-4383-8a16-968b8811e78b"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "f7dd8d40-cc82-4b1f-8b7d-f5b33f3604cd"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"2e786384-abd5-4c59-aec7-6674209f0554"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"0e459a67-ade1-4acb-bf8d-aabbf02b183d"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatLiqK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 2, 3.5422985}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "RhoSatLiqK[T] Density (g/cm^3) of potassium along the liquid coexistence \
curve as a function of temperature T", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "RhoSatLiqK", "titlemodifier" -> "", "windowtitle" -> 
    "RhoSatLiqK", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/RhoSatLiqK", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"57dfca7b-4b66-43f1-a88d-af4e83c7bcda"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7027, 192, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"315f2c13-1eaf-4dc5-aa1b-01753061daff",
   CellTags->"PrimaryExamplesSection",
   CellID->65634905]},
 "RasterizedOutput"->{
  Cell[31579, 765, 37160, 615, 373, "Output",ExpressionUUID->"9f254b80-ff87-47a0-aaed-2cc1cf17cad4",
   CellTags->"RasterizedOutput",
   CellID->370580698]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72300, 1481},
 {"RasterizedOutput", 72497, 1485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 3641, 83, 53, "AnchorBarGrid",ExpressionUUID->"d9f14174-458b-4d74-ba19-7601267ebacf",
 CellID->1],
Cell[CellGroupData[{
Cell[4248, 108, 395, 9, 54, "ObjectNameGrid",ExpressionUUID->"6e274edf-40cd-4539-8592-fd0a0458be30"],
Cell[4646, 119, 721, 17, 112, "Usage",ExpressionUUID->"b96c14ee-fd34-4c66-92cf-98ab93deaa8b",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5404, 141, 855, 21, 37, "NotesSection",ExpressionUUID->"3d8f8e9e-014d-486a-9bd3-b7edcef81e7e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->386941996],
Cell[6262, 164, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"c0cc5ba3-a93e-4ddc-ab35-77f0dedabe3a"],
Cell[6351, 166, 355, 11, 70, "Notes",ExpressionUUID->"41898662-553e-40a5-990d-575b1efc0af7",
 CellID->1067943069],
Cell[6709, 179, 192, 6, 70, "Notes",ExpressionUUID->"b2d8a0f9-a371-4bea-937a-7b500e0229b5",
 CellID->61130633],
Cell[6904, 187, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"849152bd-bd47-44f9-ba13-76be1bc88f98"]
}, Closed]],
Cell[CellGroupData[{
Cell[7027, 192, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"315f2c13-1eaf-4dc5-aa1b-01753061daff",
 CellTags->"PrimaryExamplesSection",
 CellID->65634905],
Cell[CellGroupData[{
Cell[7486, 207, 307, 7, 30, "ExampleSection",ExpressionUUID->"8fa82f22-8fe9-42b2-aaef-7073c5f22fea",
 CellID->76727668],
Cell[7796, 216, 175, 3, 27, "Input",ExpressionUUID->"f763a2f9-ef66-4cff-9614-973eb58fe3f5",
 CellID->87419684],
Cell[7974, 221, 298, 5, 57, "ExampleText",ExpressionUUID->"176397ee-c6ec-4396-b317-101413b0d7a1",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8297, 230, 502, 12, 60, "Input",ExpressionUUID->"66e07c6a-671e-48f2-9628-baada655edc9",
 CellID->419134748],
Cell[8802, 244, 143, 2, 36, "Output",ExpressionUUID->"1945a74f-ea80-4b3d-b538-6875dc1c2a85",
 CellID->50580883],
Cell[8948, 248, 391, 8, 50, "Output",ExpressionUUID->"875ee779-2139-4d89-bafd-5deb0add5171",
 CellID->779146631],
Cell[9342, 258, 390, 8, 50, "Output",ExpressionUUID->"4913858e-1d33-4942-b095-736d7b6fb637",
 CellID->21503734]
}, Open  ]],
Cell[9747, 269, 212, 6, 38, "ExampleText",ExpressionUUID->"0c14990c-3f9f-4ca3-b2a9-76191fc0d236",
 CellID->119396994],
Cell[CellGroupData[{
Cell[9984, 279, 1498, 42, 130, "Input",ExpressionUUID->"b7f0393b-d561-4e6f-8394-1d36e3f9f7aa",
 CellID->163625766],
Cell[11485, 323, 16755, 338, 255, "Output",ExpressionUUID->"29bb63eb-deb9-44d3-a8a9-e7aaca5ecada",
 CellID->80369264]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28289, 667, 300, 7, 70, "ExampleSection",ExpressionUUID->"37022cdc-e816-4ad6-9381-46281ea7bce0",
 CellID->1293636265],
Cell[28592, 676, 210, 6, 70, "ExampleText",ExpressionUUID->"dce8bca2-217a-43db-a95a-a1232098ebd7",
 CellID->642064293],
Cell[CellGroupData[{
Cell[28827, 686, 2749, 77, 70, "Input",ExpressionUUID->"a023bf92-f4aa-439d-9b9d-c08cf5f8e536",
 CellID->58309389],
Cell[31579, 765, 37160, 615, 373, "Output",ExpressionUUID->"9f254b80-ff87-47a0-aaed-2cc1cf17cad4",
 CellTags->"RasterizedOutput",
 CellID->370580698]
}, Open  ]]
}, Closed]],
Cell[68766, 1384, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"e4467ff2-6207-4a95-bf21-4838a3ea83a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68889, 1389, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"1123112f-7e03-4e41-99f1-f706b5b228c7",
 CellID->1255426704],
Cell[69152, 1398, 212, 4, 70, "SeeAlso",ExpressionUUID->"d2143685-9e9b-4100-a8b8-8be4c935f229",
 CellID->234329647]
}, Open  ]],
Cell[CellGroupData[{
Cell[69401, 1407, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"5ef2a981-cf2d-4d45-8f5c-7c60b611d98c",
 CellID->1584193535],
Cell[69674, 1416, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"95b317ad-c5bc-4383-8a16-968b8811e78b"],
Cell[69763, 1418, 384, 10, 70, "RelatedLinks",ExpressionUUID->"2e786384-abd5-4c59-aec7-6674209f0554",
 CellID->426751138]
}, Open  ]],
Cell[70162, 1431, 78, 0, 70, "FooterCell",ExpressionUUID->"0e459a67-ade1-4acb-bf8d-aabbf02b183d"]
}
]
*)

(* End of internal cache information *)

