(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     86709,       1679]
NotebookOptionsPosition[     80197,       1536]
NotebookOutlinePosition[     82908,       1604]
CellTagsIndexPosition[     82786,       1598]
WindowTitle->RhoSatVapK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "cbd06da5-e401-4065-8dbf-074025c70521"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"178198b0-6579-433a-a997-ef9ca42c2366"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"rhocK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"rhocK.nb", None}, "paclet*"], 
         Part[
          Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ffea6ac3-4d03-4ef1-bd22-99da64889c14"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"acf1c073-c6c7-4983-9abe-5a84960e7795"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/RhoSatVapK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/RhoSatVapK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
RhoSatVapK.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$26716], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/RhoSatVapK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f78b0ca1-b90a-4b12-8f5f-6dfb3d88d530"]
    }], "AnchorBar",ExpressionUUID->"d1012c9d-dfa2-40ce-92e0-db4b49c10c4e"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"fbc9493a-033b-4569-92e0-c93f20fc56a2"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["RhoSatVapK", "ObjectName",ExpressionUUID->
  "fb325d51-2594-40bb-8d72-64c2ae1c6dde"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"da397123-536b-40e4-9805-10d828f37dc6"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "e92c4840-f80e-4c89-9fad-6eac9aa3ddd5"]
}], "ObjectNameGrid",ExpressionUUID->"11da1273-aa9b-4562-8181-d9f779792b56"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RhoSatVapK", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "efaf3813-35e6-4cf1-ad0c-623426c99ac3"],
     " \[LineSeparator]Density (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]],ExpressionUUID->
      "0c9d1846-4ad0-4487-9195-fd2d2043af33"],
     ") of potassium along the vapor coexistence curve as a function of \
temperature ",
     StyleBox["T",
      FontSlant->"Italic"]
    }],ExpressionUUID->"01a1b632-a374-47a8-baca-e23c588cfaac"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"eb258047-5a68-48e9-a23c-bf4eabd9b478"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"0a8c7082-a5f6-441f-ac3b-a067408cfed6"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"bccfe8ce-1bd2-4847-a2a5-30f1477d4441"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"3d2076bb-7e25-4906-bf95-4f1b34a1c98c"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1396069,ExpressionUUID->"f4bc8224-bd77-4932-8969-617cf6b6d3ba"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"3a2925c5-69a1-4e2e-a394-c64a51dfac3b"],

Cell[TextData[{
 "The function is defined only for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "a59000ad-a240-44e1-b1ea-b3746b3d3e0c"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"1ca763a7-fe50-4a72-bf0b-fa4eb724f5bc"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->61130633,ExpressionUUID->"dcc6f411-0f06-4a3b-bcc4-c9d468c70121"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"320f3d3c-876a-4336-8289-b23a3218f721"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"3bdc33dd-73f3-41dc-8ba2-dbab2337df01"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "45f9f817-617e-4786-b889-62613bb640b8"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->101737335,ExpressionUUID->"731b8b7e-6126-4cc8-9817-1104fb851ea6"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "87f8129c-3f21-4a9e-bc0f-625de511cf82"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->6706609,ExpressionUUID->"aa390dfe-2974-4890-becc-12891e3980b6"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"ef871a78-c300-4127-a453-d1cdf3f1709f"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"21c71065-1b6e-4ecc-96cd-f95794afeaee"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RhoSatVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RhoSatVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"29323a6e-0af5-401f-94ee-dd4b25c8332d"],

Cell[BoxData["0.0005000848648988557`"], "Output",
 CellLabel->"Out[2]=",
 CellID->140584096,ExpressionUUID->"70ba7bdd-06e0-4c94-91f8-8194ae7d9bfa"],

Cell[BoxData[
 TemplateBox[{"0.0005000848648988557`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->905370324,ExpressionUUID->"f5b63fb7-ef69-4af7-9ef2-408bc6a812f2"],

Cell[BoxData[
 TemplateBox[{"0.0005000848648988557`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->211808615,ExpressionUUID->"5c74b401-54f6-40d0-8777-174728cc8228"]
}, Open  ]],

Cell["Comparison with the perfect gas equation of state", "ExampleText",
 CellID->119396994,ExpressionUUID->"c33ea7a8-8068-4168-abef-d810a9f43d55"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RhoPG", "[", "T_", "]"}], ":=", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"PsatK", "[", "T", "]"}], "*", "MK"}], 
      RowBox[{"8.314", "*", "T"}]], 
     SuperscriptBox["10", 
      RowBox[{"-", "1"}]]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "T", "]"}], ",", 
     RowBox[{"RhoPG", "[", "T", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<Density (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "\"\<Expressions\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->163625766,ExpressionUUID->"cdec1987-cccd-425e-b138-92a844ef05da"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3fl/W8dh93vfe3+5P978CfflpE/6tLnd3Cdp06TZnrhZ2iZpErdpvcSO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    "], {{0, 232.}, {491., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491., 232.},
  PlotRange->{{0, 491.}, {0, 232.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->59412081,ExpressionUUID->"2b80e711-51a5-4c10-adee-595d7bdfb792"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "faea403e-8f2a-4a8b-b34e-f5c3422806e1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1293636265,ExpressionUUID->"b1ebbcf8-61b8-47e0-a106-995a2d9b45b0"],

Cell[TextData[{
 "Representation of the thermodynamic diagram (",
 StyleBox["T-V",
  FontSlant->"Italic"],
 ")"
}], "ExampleText",
 CellID->642064293,ExpressionUUID->"cb01d6ff-2ee6-4f69-8c30-635ac359e4f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"RhoSatLiqK", "[", "x", "]"}]}], ",", 
       RowBox[{"u", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "rhocK"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"TmpK", ",", "2300"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"AspectRatio", "->", "1"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"RhoSatVapK", "[", "x", "]"}]}], ",", 
       RowBox[{"u", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "rhocK"}], ",", "50"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"TmpK", ",", "2300"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"AspectRatio", "->", "1"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "50"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"TmpK", ",", "2500"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Specific volume (\!\(\*SuperscriptBox[\(cm\), \(3\)]\)/g)\>\"", 
      ",", "\"\<Temperature (K)\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "rhocK"}], ",", "TcK"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "rhocK"}], ",", "TcK"}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<C.P.\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"5.15", ",", "2280"}], "}"}]}], "]"}], ",", "Black", ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<BIPHASE\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"25", ",", "1200"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78326360,ExpressionUUID->"69040f03-2140-4eb8-b834-a9acf8421b29"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvVlwVNe653mi+6Wfqu979+2ofqyq+3Aj6qWrKzqi6qluV0dURVRHxY3u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    "], {{0, 353.}, {360., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{360., 353.},
  PlotRange->{{0, 360.}, {0, 353.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[1]=",
 CellID->40021127,ExpressionUUID->"a38ef67d-e64e-4ebd-afef-d719712e6e30"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"6acc776d-68ba-45a3-897c-8c4112eb3031"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"4ef18a58-8e2a-46d5-b0f8-4d5b3cd11370"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"0554d0a8-a8bd-4c72-8e05-3a628a3db2de"],

Cell[TextData[StyleBox[ButtonBox["rhocK",
 BaseStyle->"Hyperlink",
 ButtonData->{"rhocK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"03a4f2f7-7e5a-4d86-9b43-0ed91bfce6cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"ebdca78b-bd82-4403-bd22-fa7995b153c7"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"9737974f-f70f-4d88-828b-5e02fc05a8e7"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"865eb698-7fa0-46c6-beae-ac8c5f01ff16"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "6122c246-a2fc-4580-9478-5bb3a68315ca"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"174944e7-b499-4b3e-be7c-39f194e129b6"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"f99a5a38-5c19-4de1-8504-da8dfd1f3972"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RhoSatVapK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 2, 8.5212993}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "RhoSatVapK[T] Density (g/cm^3) of potassium along the vapor coexistence \
curve as a function of temperature T", "synonyms" -> {}, "tabletags" -> {}, 
    "title" -> "RhoSatVapK", "titlemodifier" -> "", "windowtitle" -> 
    "RhoSatVapK", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/RhoSatVapK", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"fd61b9c3-e859-47da-8395-505194489d9f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7070, 194, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"731b8b7e-6126-4cc8-9817-1104fb851ea6",
   CellTags->"PrimaryExamplesSection",
   CellID->101737335]},
 "RasterizedOutput"->{
  Cell[11128, 311, 29344, 487, 253, "Output",ExpressionUUID->"2b80e711-51a5-4c10-adee-595d7bdfb792",
   CellTags->"RasterizedOutput",
   CellID->59412081],
  Cell[43992, 908, 34700, 575, 374, "Output",ExpressionUUID->"a38ef67d-e64e-4ebd-afef-d719712e6e30",
   CellTags->"RasterizedOutput",
   CellID->40021127]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 82252, 1584},
 {"RasterizedOutput", 82450, 1588}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 3641, 83, 53, "AnchorBarGrid",ExpressionUUID->"fbc9493a-033b-4569-92e0-c93f20fc56a2",
 CellID->1],
Cell[CellGroupData[{
Cell[4248, 108, 395, 9, 54, "ObjectNameGrid",ExpressionUUID->"11da1273-aa9b-4562-8181-d9f779792b56"],
Cell[4646, 119, 766, 19, 112, "Usage",ExpressionUUID->"eb258047-5a68-48e9-a23c-bf4eabd9b478",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5449, 143, 853, 21, 37, "NotesSection",ExpressionUUID->"f4bc8224-bd77-4932-8969-617cf6b6d3ba",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1396069],
Cell[6305, 166, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"3a2925c5-69a1-4e2e-a394-c64a51dfac3b"],
Cell[6394, 168, 355, 11, 70, "Notes",ExpressionUUID->"1ca763a7-fe50-4a72-bf0b-fa4eb724f5bc",
 CellID->1067943069],
Cell[6752, 181, 192, 6, 70, "Notes",ExpressionUUID->"dcc6f411-0f06-4a3b-bcc4-c9d468c70121",
 CellID->61130633],
Cell[6947, 189, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"320f3d3c-876a-4336-8289-b23a3218f721"]
}, Closed]],
Cell[CellGroupData[{
Cell[7070, 194, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"731b8b7e-6126-4cc8-9817-1104fb851ea6",
 CellTags->"PrimaryExamplesSection",
 CellID->101737335],
Cell[CellGroupData[{
Cell[7530, 209, 306, 7, 30, "ExampleSection",ExpressionUUID->"aa390dfe-2974-4890-becc-12891e3980b6",
 CellID->6706609],
Cell[7839, 218, 175, 3, 27, "Input",ExpressionUUID->"ef871a78-c300-4127-a453-d1cdf3f1709f",
 CellID->87419684],
Cell[8017, 223, 298, 5, 57, "ExampleText",ExpressionUUID->"21c71065-1b6e-4ecc-96cd-f95794afeaee",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8340, 232, 502, 12, 60, "Input",ExpressionUUID->"29323a6e-0af5-401f-94ee-dd4b25c8332d",
 CellID->419134748],
Cell[8845, 246, 147, 2, 36, "Output",ExpressionUUID->"70ba7bdd-06e0-4c94-91f8-8194ae7d9bfa",
 CellID->140584096],
Cell[8995, 250, 394, 8, 50, "Output",ExpressionUUID->"f5b63fb7-ef69-4af7-9ef2-408bc6a812f2",
 CellID->905370324],
Cell[9392, 260, 394, 8, 50, "Output",ExpressionUUID->"5c74b401-54f6-40d0-8777-174728cc8228",
 CellID->211808615]
}, Open  ]],
Cell[9801, 271, 147, 1, 38, "ExampleText",ExpressionUUID->"c33ea7a8-8068-4168-abef-d810a9f43d55",
 CellID->119396994],
Cell[CellGroupData[{
Cell[9973, 276, 1152, 33, 115, "Input",ExpressionUUID->"cdec1987-cccd-425e-b138-92a844ef05da",
 CellID->163625766],
Cell[11128, 311, 29344, 487, 253, "Output",ExpressionUUID->"2b80e711-51a5-4c10-adee-595d7bdfb792",
 CellTags->"RasterizedOutput",
 CellID->59412081]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40521, 804, 300, 7, 70, "ExampleSection",ExpressionUUID->"b1ebbcf8-61b8-47e0-a106-995a2d9b45b0",
 CellID->1293636265],
Cell[40824, 813, 205, 6, 70, "ExampleText",ExpressionUUID->"cb01d6ff-2ee6-4f69-8c30-635ac359e4f4",
 CellID->642064293],
Cell[CellGroupData[{
Cell[41054, 823, 2935, 83, 70, "Input",ExpressionUUID->"69040f03-2140-4eb8-b834-a9acf8421b29",
 CellID->78326360],
Cell[43992, 908, 34700, 575, 374, "Output",ExpressionUUID->"a38ef67d-e64e-4ebd-afef-d719712e6e30",
 CellTags->"RasterizedOutput",
 CellID->40021127]
}, Open  ]]
}, Closed]],
Cell[78719, 1487, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"6acc776d-68ba-45a3-897c-8c4112eb3031"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78842, 1492, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"0554d0a8-a8bd-4c72-8e05-3a628a3db2de",
 CellID->1255426704],
Cell[79105, 1501, 212, 4, 70, "SeeAlso",ExpressionUUID->"03a4f2f7-7e5a-4d86-9b43-0ed91bfce6cf",
 CellID->234329647]
}, Open  ]],
Cell[CellGroupData[{
Cell[79354, 1510, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"9737974f-f70f-4d88-828b-5e02fc05a8e7",
 CellID->1584193535],
Cell[79627, 1519, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"865eb698-7fa0-46c6-beae-ac8c5f01ff16"],
Cell[79716, 1521, 384, 10, 70, "RelatedLinks",ExpressionUUID->"174944e7-b499-4b3e-be7c-39f194e129b6",
 CellID->426751138]
}, Open  ]],
Cell[80115, 1534, 78, 0, 70, "FooterCell",ExpressionUUID->"f99a5a38-5c19-4de1-8504-da8dfd1f3972"]
}
]
*)

(* End of internal cache information *)

