(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57649,       1261]
NotebookOptionsPosition[     52943,       1154]
NotebookOutlinePosition[     55190,       1213]
CellTagsIndexPosition[     55104,       1208]
WindowTitle->TcK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "2911e57b-d7d1-479c-bb6c-5a2bfc607da9"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"65478991-1c40-4d44-8eb8-5dae1553cabd"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"rhocK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"rhocK.nb", None}, "paclet*"], 
         Part[
          Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"rhocK", {"rhocK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "2748e172-4119-4bf3-a32d-00a363961dd8"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"98201e0a-44ec-4c2e-92ce-b44b44c4b9a2"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/TcK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/TcK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/TcK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$27093], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/TcK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "6be3c2ce-8fb8-4321-968f-876f289f3e2b"]
    }], "AnchorBar",ExpressionUUID->"52f1a30c-3d24-4d13-b6be-9fc04a71b632"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"1abb415f-92eb-4852-8519-87623155b113"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["TcK", "ObjectName",ExpressionUUID->
  "a191a3dc-2588-4e0a-a63b-9c6f89ae70b4"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"1d752713-4a54-4ada-8e5c-70f019d15555"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "9db1bcbb-7bcd-4d83-975e-be445fc00daf"]
}], "ObjectNameGrid",ExpressionUUID->"c6022144-8d51-4b99-aa30-d4aa7ec713e6"],

Cell["Potassium critical point temperature (Kelvin)", "Usage",
 CellID->982511436,ExpressionUUID->"f158651b-a82b-4c4c-88f1-a4d80264de11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"7dcabc2a-4aed-467f-82b6-c0d4c4b49319"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c52c10bc-6a22-4c1a-b9cf-9293c0de10b6"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->515616445,ExpressionUUID->"cb60ac63-f4ab-4e8c-9fe6-456b68767fd5"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "298942d1-43a8-47fd-a565-03f573a65880"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->70720248,ExpressionUUID->"70f9fd78-7768-46e3-808f-658c9f32a21f"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"5fc5def4-a026-4d82-945d-5ed8ca641cc9"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"93f75a75-b6e5-42f4-9200-5d0024daa36e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"TcK", ",", "\"\<Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"7fa966f0-2350-49de-9f38-1ba86a2c8363"],

Cell[BoxData[
 TemplateBox[{"2223", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->231856639,ExpressionUUID->"41ed2cc8-99b1-4c3d-813d-39e25651a50b"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"9fb3bbe8-0057-4f6a-944a-e50877e30499"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Critical temperature of Potassium", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"CriticalTemperature\"]]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {
        "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"CriticalTemperature\"]]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Potassium"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"critical temperature\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ElementData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"WebElements"}], "\n   "}], 
       XMLElement["moutput", {}, {"Quantity[2223., \"Kelvins\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 StyleBox[
                  TagBox[
                   RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["2223", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "2223", "SRString" -> "2223"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kelvins\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}, {
                 StyleBox[
                  
                  RowBox[{
                   "\"(\"", "\[NoBreak]", 
                    "\"value estimated based on extrapolation\"", 
                    "\[NoBreak]", "\")\""}], {
                  FontFamily -> "Verdana", FontSize -> 10, 
                   GrayLevel[0.5], 
                   LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                   0}]}}, GridBoxAlignment -> {
                "Columns" -> {Left}, "Rows" -> {{Baseline}}}, AutoDelete -> 
               False, GridBoxBackground -> {"Columns" -> {{None}}}, 
               GridBoxFrame -> {"Columns" -> None, "Rows" -> None}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, FrameStyle -> 
               GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1950", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1950", "SRString" -> "1950"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["3542", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "3542", "SRString" -> "3542"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]F\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Fahrenheit\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["4001", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "4001", "SRString" -> "4001"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Rankine\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1560", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1560", "SRString" -> "1560"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[EAcute]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[EAcute]aumur\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1031", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "1031", "SRString" -> "1031"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[OSlash]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[OSlash]mer\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "5"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparison as temperature", "scanner" -> "Unit", "id" -> 
     "ComparisonAsCriticalTemperature", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 TemplateBox[{
                   StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["100", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "100", "SRString" -> "100"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\" below \"", 
                   StyleBox[
                   "\"temperature of a hydrogen flame\"", FontFamily -> 
                    "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
                   "\" \"", 
                   StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["2320", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "2320", "SRString" -> "2320"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], TraditionalForm]]], 
              TextCell[
               $CellContext`RowTemplate["`1` below `2` `3`", {
                 Quantity[97.`1.581544936806307, 
                  $CellContext`Unit[$CellContext`Kelvins], "Short" -> True], 
                 Style[
                 "temperature of a hydrogen flame", FontFamily -> "Helvetica",
                   FontSize -> Smaller], 
                 $CellContext`GrayComment[
                  Quantity[2320.`3., 
                   $CellContext`Unit[$CellContext`Kelvins], "Short" -> True], 
                  BaseStyle -> "Caption"]}]]], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Corresponding quantities", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Thermodynamic energy ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    StyleBox["\"E\"", Italic, StripOnInput -> False], 
                    TraditionalForm], TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{
                    FormBox[
                    StyleBox["\"E\"", Italic, StripOnInput -> False], 
                    TraditionalForm], "\[LongEqual]", 
                    RowBox[{"k", "\[InvisibleSpace]", "T"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  
                  Row[{"Thermodynamic energy ", $CellContext`capitalE, 
                    " from ", 
                    $CellContext`InlineForm["capitalE \[LongEqual] k T"], 
                    ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["19", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "19", "SRString" -> "19"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"ceV\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"centielectronvolts\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Blackbody energy flux \[CapitalPhi] from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"\[CapitalPhi]", "\[LongEqual]", 
                    RowBox[{"\[Sigma]", "\[InvisibleSpace]", 
                    SuperscriptBox["T", "4"]}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Blackbody energy flux \[CapitalPhi] from ", 
                    $CellContext`InlineForm[
                    "\[CapitalPhi] \[LongEqual] \[Sigma] T^4"], ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"1.385", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "6"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"1.385", "\[Times]", 
                    SuperscriptBox["10", "6"]}], "SRString" -> 
                    "1.385 times 10 to the 6"], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"W\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"watts per square meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  
                  TextData[{
                   "Approximate luminous exitance from a planar blackbody \
radiator perpendicular to its surface:"}]], 
                 TextCell[
                  
                  Row[{"Approximate luminous exitance from a planar blackbody \
radiator perpendicular to its surface:"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"5.074", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "6"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"5.074", "\[Times]", 
                    SuperscriptBox["10", "6"]}], "SRString" -> 
                    "5.074 times 10 to the 6"], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"lx\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"lux\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False, False}, True}, Typeset`aux4$$ = {
   True, False, {False}, True}, Typeset`aux5$$ = {
   True, False, {False, False, False}, True}, Typeset`asyncpods$$ = {}, 
   Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www4f.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True], 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "5", "datatypes" -> "Element", "timedout" -> "", 
    "timedoutpods" -> "", "timing" -> "1.747", "parsetiming" -> "0.549", 
    "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP128314b51735a829ed9b000012edf46734a9i423", "host" -> 
    "https://www4f.wolframalpha.com", "server" -> "43", "related" -> 
    "https://www4f.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa128414b51735a829ed9b00005gcg0g41450i4edd6130104515743660768", "version" -> 
    "2.6", "inputstring" -> "Critical temperature of Potassium"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2021, 10, 22, 13, 54, 13.6655385`8.888201703742496}, "Line" -> 
    2, "SessionID" -> 30611245457547571513}, Typeset`showpods$$ = {1, 2, 3, 4,
    5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"CriticalTemperature\"]]"}, Typeset`open$$ = True, Typeset`newq$$ = 
   "Critical temperature of Potassium"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{32.220703125, {6.09765625, 8.279296875}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellID->205676980,ExpressionUUID->"a85597a6-103b-4cd9-b315-2ea7465a7c97"],

Cell[BoxData[
 TemplateBox[{"2223.`4.", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->820774290,ExpressionUUID->"8082558a-d0b4-4156-9eb5-fbcbe267fe5b"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e76e5be4-1854-4c72-a6b9-c52006fee554"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"60dfd51f-7a91-4ffc-b5c8-5558dede0881"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"ea433ed8-1fca-45ae-8fcd-06be1ddf36b5"],

Cell[TextData[StyleBox[ButtonBox["rhocK",
 BaseStyle->"Hyperlink",
 ButtonData->{"rhocK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->205382791,ExpressionUUID->"fb62d625-b2cf-47fc-8eb5-c37f47aeff5b"],

Cell[TextData[StyleBox[ButtonBox["PcK",
 BaseStyle->"Hyperlink",
 ButtonData->{"PcK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->291524538,ExpressionUUID->"df13ad8f-09b4-4d73-9881-0de56b2c86ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b2733103-8092-4ae6-bb89-05819a46a356"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"b9f03d23-5e6a-4fab-bf9d-a4c9f4284717"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"09ec2c6c-b259-448f-80ec-411ce0f12156"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "9f63d457-869c-4b7c-bf4f-57fae27e1fce"]], "RelatedLinks",
 CellID->74637808,ExpressionUUID->"77f8a9f1-6c16-4717-8402-2ab895c92bb2"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"f02eb6c8-ec0f-45b6-85ad-05fa9c4181f6"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TcK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 2, 12.7002987}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Potassium critical point temperature (Kelvin)", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "TcK", "titlemodifier" -> "", "windowtitle" -> 
    "TcK", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/TcK", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"aceca542-ca8b-4ee1-9c8a-4116847edca8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4777, 125, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"cb60ac63-f4ab-4e8c-9fe6-456b68767fd5",
   CellTags->"PrimaryExamplesSection",
   CellID->515616445]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54906, 1201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 3612, 83, 53, "AnchorBarGrid",ExpressionUUID->"1abb415f-92eb-4852-8519-87623155b113",
 CellID->1],
Cell[CellGroupData[{
Cell[4212, 108, 388, 9, 54, "ObjectNameGrid",ExpressionUUID->"c6022144-8d51-4b99-aa30-d4aa7ec713e6"],
Cell[4603, 119, 137, 1, 41, "Usage",ExpressionUUID->"f158651b-a82b-4c4c-88f1-a4d80264de11",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4777, 125, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"cb60ac63-f4ab-4e8c-9fe6-456b68767fd5",
 CellTags->"PrimaryExamplesSection",
 CellID->515616445],
Cell[CellGroupData[{
Cell[5237, 140, 307, 7, 30, "ExampleSection",ExpressionUUID->"70f9fd78-7768-46e3-808f-658c9f32a21f",
 CellID->70720248],
Cell[5547, 149, 175, 3, 27, "Input",ExpressionUUID->"5fc5def4-a026-4d82-945d-5ed8ca641cc9",
 CellID->87419684],
Cell[5725, 154, 139, 1, 38, "ExampleText",ExpressionUUID->"93f75a75-b6e5-42f4-9200-5d0024daa36e",
 CellID->886239600],
Cell[CellGroupData[{
Cell[5889, 159, 197, 4, 27, "Input",ExpressionUUID->"7fa966f0-2350-49de-9f38-1ba86a2c8363",
 CellID->21488140],
Cell[6089, 165, 195, 4, 43, "Output",ExpressionUUID->"41ed2cc8-99b1-4c3d-813d-39e25651a50b",
 CellID->231856639]
}, Open  ]],
Cell[6299, 172, 116, 1, 38, "ExampleText",ExpressionUUID->"9fb3bbe8-0057-4f6a-944a-e50877e30499",
 CellID->351008126],
Cell[CellGroupData[{
Cell[6440, 177, 44586, 912, 35, "WolframAlphaShortInput",ExpressionUUID->"a85597a6-103b-4cd9-b315-2ea7465a7c97",
 CellID->205676980],
Cell[51029, 1091, 199, 4, 43, "Output",ExpressionUUID->"8082558a-d0b4-4156-9eb5-fbcbe267fe5b",
 CellID->820774290]
}, Open  ]]
}, Open  ]],
Cell[51255, 1099, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"e76e5be4-1854-4c72-a6b9-c52006fee554"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51378, 1104, 260, 7, 73, "SeeAlsoSection",ExpressionUUID->"ea433ed8-1fca-45ae-8fcd-06be1ddf36b5",
 CellID->1255426704],
Cell[51641, 1113, 212, 4, 24, "SeeAlso",ExpressionUUID->"fb62d625-b2cf-47fc-8eb5-c37f47aeff5b",
 CellID->205382791],
Cell[51856, 1119, 208, 4, 24, "SeeAlso",ExpressionUUID->"df13ad8f-09b4-4d73-9881-0de56b2c86ae",
 CellID->291524538]
}, Open  ]],
Cell[CellGroupData[{
Cell[52101, 1128, 270, 7, 73, "RelatedLinksSection",ExpressionUUID->"b9f03d23-5e6a-4fab-bf9d-a4c9f4284717",
 CellID->1584193535],
Cell[52374, 1137, 86, 0, 14, "SectionHeaderSpacer",ExpressionUUID->"09ec2c6c-b259-448f-80ec-411ce0f12156"],
Cell[52463, 1139, 383, 10, 26, "RelatedLinks",ExpressionUUID->"77f8a9f1-6c16-4717-8402-2ab895c92bb2",
 CellID->74637808]
}, Open  ]],
Cell[52861, 1152, 78, 0, 70, "FooterCell",ExpressionUUID->"f02eb6c8-ec0f-45b6-85ad-05fa9c4181f6"]
}
]
*)

(* End of internal cache information *)

