(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79829,       1694]
NotebookOptionsPosition[     75489,       1595]
NotebookOutlinePosition[     77762,       1654]
CellTagsIndexPosition[     77676,       1649]
WindowTitle->TmpK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "ec474821-c8c2-414d-a83e-239a6d3b55d5"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox[
       InterpretationBox[Cell[TextData[{
         "URL",
         StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
          StripOnInput->False]
        }],ExpressionUUID->"579f6301-f1ef-4d07-8bbd-653454c1f6af"],
        TextCell[
         Row[{"URL", 
           Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
       StripOnInput->False], {"\<\"EOSPotassium/ref/TmpK\"\>":>
      None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["EOSPotassium/ref/TmpK"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/language/EOSPotassium/ref/TmpK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
           False]]; SelectionMove[
        DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
            If[
             TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$27478], 
             "http://reference.wolfram.com/system-modeler/", 
             "http://reference.wolfram.com/language/"], 
            "EOSPotassium/ref/TmpK", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic,
      MenuStyle->"URLMenu"]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "44b638f6-20fe-45ca-87ea-622e17f7dd6c"]], "AnchorBar",ExpressionUUID->
     "2cd5e4cd-f428-42ff-b358-beb01b2b7424"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"65b106e0-fa22-4961-9d90-1a090764e165"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["TmpK", "ObjectName",ExpressionUUID->
  "44af75c0-1e98-48c6-bc96-3ce98e1fcd5f"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"3e46b82b-c8a0-470c-a571-1d48fcc87b82"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "ad09f458-2539-490c-833e-12440df72039"]
}], "ObjectNameGrid",ExpressionUUID->"716d33c1-aed3-4af4-89a7-767ec94f987f"],

Cell[BoxData[GridBox[{
   {"", Cell["\<\
Potassium Melting point temperature at atmospheric pressure (Kelvin)\
\>",ExpressionUUID->"6e2e6b81-f1d4-44f3-894f-220dd293301f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"24830409-dd58-431a-8f25-a15b1d7f5c1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"065cd113-76ff-47f2-972a-d075fa3a54d1"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7d2b2b0a-742f-4055-b5ca-6188f09c00d8"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->34729559,ExpressionUUID->"a3918d06-5d32-451a-ae7b-5cfa9fbf3e25"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c6c59666-9cf0-42e4-9412-401a6508936d"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->267655211,ExpressionUUID->"2f3795c1-5317-493d-a7be-225722932731"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"431a1f65-1d33-459d-bfc2-4de0c375ebd0"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"a3b2aaa0-60f0-4abc-abce-ccf74ccd6218"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"TmpK", ",", "\"\<Kelvins\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"ec63a395-168a-4371-9915-12d48a2736d5"],

Cell[BoxData[
 TemplateBox[{"336.65`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->636676416,ExpressionUUID->"4efdf723-75d5-4461-86e1-fa4ca281101a"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->351008126,ExpressionUUID->"4e77a54c-09a4-44d1-8ad3-7f488211b12a"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Melting temperature of potassium", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"MeltingPoint\"]]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {
        "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"MeltingPoint\"]]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"potassium\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Potassium"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"melting point\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"ElementData"}], "\n   "}], 
       XMLElement["datasources", {}, {"\n    ", 
         XMLElement["datasource", {}, {"WebElements"}], "\n   "}], 
       XMLElement["moutput", {}, {"Quantity[63.38, \"DegreesCelsius\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["63.38", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "63.38", "SRString" -> "63.38"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Celsius\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["336.53", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "336.53", "SRString" -> "336.53"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kelvins\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["146.1", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "146.1", "SRString" -> "146.1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]F\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Fahrenheit\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["605.8", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "605.8", "SRString" -> "605.8"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees Rankine\"", "\[NoBreak]", 
                   "\")\""}], {FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["50.7", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "50.7", "SRString" -> "50.7"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[EAcute]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[EAcute]aumur\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["40.77", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "40.77", "SRString" -> "40.77"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]R\[OSlash]\"", FontFamily -> "Helvetica", 
                    FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"degrees R\[OSlash]mer\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily -> "Helvetica", FontSize -> Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}]}], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "5"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons as temperature", "scanner" -> "Unit", "id" -> 
     "ComparisonAsMeltingTemperature", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 TemplateBox[{
                   StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["36.6", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "36.6", "SRString" -> "36.6"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\" below \"", 
                   StyleBox[
                   "\"temperature at which water boils at standard \
pressure\"", FontFamily -> "Helvetica", FontSize -> Smaller, StripOnInput -> 
                    False], "\" \"", 
                   StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["99.9839", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "99.9839", "SRString" -> "99.9839"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], TraditionalForm]]], 
              TextCell[
               $CellContext`RowTemplate["`1` below `2` `3`", {
                 Quantity[36.6039`3.754777473935112, 
                  $CellContext`Unit[$CellContext`DegreesCelsius], "Short" -> 
                  True], 
                 Style[
                 "temperature at which water boils at standard pressure", 
                  FontFamily -> "Helvetica", FontSize -> Smaller], 
                 $CellContext`GrayComment[
                  Quantity[99.9839`6., 
                   $CellContext`Unit[$CellContext`DegreesCelsius], "Short" -> 
                   True], BaseStyle -> "Caption"]}]]], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 TemplateBox[{
                   StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["43", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "43", "SRString" -> "43"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\" above \"", 
                   StyleBox[
                   "\"conventional US room temperature\"", FontFamily -> 
                    "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
                   "\" \"", 
                   StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["68", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "68", "SRString" -> "68"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]F\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], TraditionalForm]]], 
              TextCell[
               $CellContext`RowTemplate["`1` above `2` `3`", {
                 Quantity[43.38`2.05282740124954, 
                  $CellContext`Unit[$CellContext`DegreesCelsius], "Short" -> 
                  True], 
                 Style[
                 "conventional US room temperature", FontFamily -> 
                  "Helvetica", FontSize -> Smaller], 
                 $CellContext`GrayComment[
                  Quantity[68.`2., 
                   $CellContext`Unit[$CellContext`DegreesFahrenheit], "Short" -> 
                   True], BaseStyle -> "Caption"]}]]], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 TemplateBox[{
                   StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["43.38", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "43.38", "SRString" -> "43.38"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\" above \"", 
                   StyleBox[
                   "\"temperature at standard temperature and pressure using \
the National Institute of Standards and Technology convention\"", FontFamily -> 
                    "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
                   "\" \"", 
                   StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "20", "SRString" -> "20"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], TraditionalForm]]], 
              TextCell[
               $CellContext`RowTemplate["`1` above `2` `3`", {
                 Quantity[43.38`3.835337312823895, 
                  $CellContext`Unit[$CellContext`DegreesCelsius], "Short" -> 
                  True], 
                 Style[
                 "temperature at standard temperature and pressure using the \
National Institute of Standards and Technology convention", FontFamily -> 
                  "Helvetica", FontSize -> Smaller], 
                 $CellContext`GrayComment[
                  Quantity[20, 
                   $CellContext`Unit[$CellContext`DegreesCelsius], "Short" -> 
                   True], BaseStyle -> "Caption"]}]]], TraditionalForm], 
            TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Corresponding quantities", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Thermodynamic energy ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    StyleBox["\"E\"", Italic, StripOnInput -> False], 
                    TraditionalForm], TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{
                    FormBox[
                    StyleBox["\"E\"", Italic, StripOnInput -> False], 
                    TraditionalForm], "\[LongEqual]", 
                    RowBox[{"k", "\[InvisibleSpace]", "T"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  
                  Row[{"Thermodynamic energy ", $CellContext`capitalE, 
                    " from ", 
                    $CellContext`InlineForm["capitalE \[LongEqual] k T"], 
                    ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["29", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "29", "SRString" -> "29"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"meV\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"millielectronvolts\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Blackbody energy flux \[CapitalPhi] from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"\[CapitalPhi]", "\[LongEqual]", 
                    RowBox[{"\[Sigma]", "\[InvisibleSpace]", 
                    SuperscriptBox["T", "4"]}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Blackbody energy flux \[CapitalPhi] from ", 
                    $CellContext`InlineForm[
                    "\[CapitalPhi] \[LongEqual] \[Sigma] T^4"], ":"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["727", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "727", "SRString" -> "727"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"W\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "2"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "  ", 
                    StyleBox[
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"watts per square meter\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  
                  TextData[{
                   "Approximate luminous exitance from a planar blackbody \
radiator perpendicular to its surface:"}]], 
                 TextCell[
                  
                  Row[{"Approximate luminous exitance from a planar blackbody \
radiator perpendicular to its surface:"}]]]}, {
                TagBox[
                 GridBox[{{"", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"2.5", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-18"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"2.5", "\[Times]", 
                    SuperscriptBox["10", "-18"]}], "SRString" -> 
                    "2.5 times 10 to the negative 18"], SyntaxForm -> 
                    CenterDot], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"lx\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"lux\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily -> "Helvetica", FontSize -> Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{1}}, "Rows" -> {{Automatic}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "3"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n   ", 
       XMLElement["expressiontype", {"name" -> "Default"}, {}], "\n  "}]}], 
   Typeset`pod6$$ = XMLElement[
   "pod", {"title" -> "Thermodynamic properties", "scanner" -> "Data", "id" -> 
     "Thermodynamics:ElementData", "position" -> "600", "error" -> "false", 
     "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n   ", 
         XMLElement["microsource", {}, {"ElementData"}], "\n  "}], 
       XMLElement["datasources", {}, {"\n   ", 
         XMLElement["datasource", {}, {"WebElements"}], "\n  "}], 
       XMLElement[
       "minput", {}, {
        "Dataset[EntityValue[Entity[\"Element\", \"Potassium\"], \
{EntityProperty[\"Element\", \"Phase\"]}, \"PropertyAssociation\"]]"}], 
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    PaneBox[
                    TagBox["\"phase at STP\"", Identity], 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    FormBox[
                    TagBox[
                    TagBox["\"solid\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {"MatterPhase", "Solid"}]], Identity], 
                    TraditionalForm]}, {
                    TagBox[
                    PaneBox[
                    TagBox["\"melting point\"", Identity], 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    StyleBox[
                    TemplateBox[{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["63.38", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "63.38", "SRString" -> "63.38"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"  \"", 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    TemplateBox[{"\"rank: \"", 
                    TagBox[
                    SuperscriptBox["85", "\"th\""], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"85", "\"th\""}]]]}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], LineIndent -> 0]}, {
                    TagBox[
                    PaneBox[
                    TagBox["\"boiling point\"", Identity], 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    StyleBox[
                    TemplateBox[{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["759", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "759", "SRString" -> "759"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"  \"", 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    TemplateBox[{"\"rank: \"", 
                    TagBox[
                    SuperscriptBox["74", "\"th\""], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"74", "\"th\""}]]]}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}, "RowDefault"], LineIndent -> 0]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {None, None}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False]}, {
                PaneBox[
                 TagBox[
                  Cell[
                   TextData[{
                    StyleBox[
                    Cell[
                    BoxData[
                    FormBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", 
                    "\"properties at standard conditions\"", "\[NoBreak]", 
                    "\")\""}], TraditionalForm]]], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}]}]], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 BaseStyle -> {LineIndent -> 0}]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              AllowScriptLevelChange -> False, DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n  ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n "}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> 
         "Thermodynamics:ElementData__More"}, {}]}]}], Typeset`pod7$$ = 
   XMLElement[
   "pod", {"title" -> "Nearest corresponding gas marks", "scanner" -> 
     "UnitInformation", "id" -> "GasMark:QuantityData", "position" -> "700", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["microsources", {}, {"\n    ", 
         XMLElement["microsource", {}, {"GasMark"}], "\n   "}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                StyleBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    PaneBox[
                    "\"\"", 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Center}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    TagBox[
                    PaneBox[
                    "\"temperature\"", 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Center}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]], 
                    TagBox[
                    PaneBox[
                    "\"usage\"", 
                    BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Center}, BaselinePosition -> Baseline], 
                    $CellContext`TagBoxWrapper["Label"]]}, {
                    TagBox[
                    TagBox["\"thermostat 2\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {"GasMark", "French2"}]], Identity], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["60", 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> "60", "SRString" -> "60"]], "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 
                    FormBox[
                    TagBox[
                    TagBox["\"France\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {CountryData, "France"}]], Identity], 
                    TraditionalForm]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Right, Left}, "Rows" -> {{Baseline}}, 
                    "ItemsIndexed" -> {{1, 1} -> {Center, Baseline}, {1, 
                    2} -> {Center, Baseline}, {1, 3} -> {Center, Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {
                    "Columns" -> {{None}}, "Rows" -> {None, None}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False]}, {
                PaneBox[
                 TagBox[
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"actual measurements may vary\"",
                     "\[NoBreak]", "\")\""}], {
                   FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 BaseStyle -> {LineIndent -> 0}]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
              "Column", 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "Column"], TraditionalForm]], "Output", {
          Background -> None, 
           GraphicsBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics"}, 
             DefaultAxesStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsAxes"], DefaultFrameStyle -> Directive[
               GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], FontOpacity -> 
               1, "GraphicsFrame"], DefaultFrameTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsFrameTicks"], 
             DefaultTicksStyle -> 
             Directive[
              FontFamily -> "Times", FontSize -> 10, "GraphicsTicks"]}, 
           Graphics3DBoxOptions -> {
            DefaultBaseStyle -> {FontFamily -> "Times", "Graphics3D"}}}, 
          NumberPoint -> ".", CellSize -> {550, Automatic}, 
          AutoStyleOptions -> {"HighlightFormattingErrors" -> False}, 
          RenderingOptions -> {
           "3DRenderingMethod" -> "BSPTreeOrDepthBuffer"}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["expressiontypes", {"count" -> "1"}, {"\n   ", 
       XMLElement["expressiontype", {"name" -> "Grid"}, {}], "\n  "}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "Show non-metric", "input" -> 
         "GasMark:QuantityData__Show non-metric"}, {}]}]}], Typeset`aux1$$ = {
   True, False, {False}, True}, Typeset`aux2$$ = {True, False, {False}, True},
    Typeset`aux3$$ = {True, False, {False, False, False, False, False}, True},
    Typeset`aux4$$ = {True, False, {False, False, False}, True}, 
   Typeset`aux5$$ = {True, False, {False, False, False}, True}, 
   Typeset`aux6$$ = {True, False, {False}, True}, Typeset`aux7$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "2"}, {
      XMLElement[
      "source", {
       "url" -> 
        "https://www5a.wolframalpha.com/sources/GasMarkSourceInformationNotes.\
html", "text" -> "Gas mark"}, {}], 
      XMLElement[
      "source", {
       "url" -> 
        "https://www5a.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True], 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> 
    "false", {"http://www.w3.org/XML/1998/namespace", "space"} -> "preserve", 
    "numpods" -> "7", "datatypes" -> "Element,GasMark", "timedout" -> "", 
    "timedoutpods" -> "", "timing" -> "2.286", "parsetiming" -> "0.53", 
    "parsetimedout" -> "false", "recalculate" -> "", "id" -> 
    "MSP159621e46ah1a19e92e1000044be0b4b8b21bee6", "host" -> 
    "https://www5a.wolframalpha.com", "server" -> "43", "related" -> 
    "https://www5a.wolframalpha.com/api/v1/relatedQueries.jsp?id=\
MSPa159721e46ah1a19e92e100002d59i117i84gc1ef6763155028757663219", "version" -> 
    "2.6", "inputstring" -> "Melting temperature of potassium"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 2., 
    "Date" -> {2021, 10, 22, 17, 53, 9.1979092`8.716264082599325}, "Line" -> 
    21, "SessionID" -> 30611336211953551426}, Typeset`showpods$$ = {1, 2, 3, 
   4, 5, 6, 7}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Entity[\"Element\", \"Potassium\"][EntityProperty[\"Element\", \
\"MeltingPoint\"]]"}, Typeset`open$$ = True, Typeset`newq$$ = 
   "Melting temperature of potassium"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$, Typeset`aux6$$, Typeset`aux7$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{32.220703125, {6.09765625, 8.279296875}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     And[
      Not[Typeset`initdone$$ === True], 
      Not[Typeset`initdone$$ === FrontEnd`SuppressEvaluationHash[True]]], 
     Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = FrontEnd`SuppressEvaluationHash[True]],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellID->65503397,ExpressionUUID->"ce8f246f-e2a0-4f12-8d25-040115129736"],

Cell[BoxData[
 TemplateBox[{
  "63.38`4.", "\"\[Degree]C\"", "degrees Celsius", "\"DegreesCelsius\""},
  "Quantity"]], "Output",
 CellLabel->"Out[20]=",
 CellID->163646763,ExpressionUUID->"c2d239e5-b02c-4beb-ae10-ad5a055e628a"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"f2fce9b0-77c7-4dfe-be11-231a6089cad7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"45164f39-487e-42e2-accb-784c688d2aed"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"dc2ec999-5c50-4f3d-80ee-1a4ecfbe59cf"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"8fafc19e-b495-48f5-910a-db926ef018c9"],

Cell[TextData[Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "1fd72601-dd70-4f80-8afb-01abdc6a31fc"]],ExpressionUUID->"b10bf820-c7e3-\
4393-a8d5-fbd2bfc4ce79"]], "RelatedLinks",
 CellID->1038487239,ExpressionUUID->"ead6aff1-e46a-4f6b-b995-edae44bdf5c8"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"4882c111-aefb-47a1-ba6e-57522c15f856"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TmpK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 2, 15.4472981}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Potassium Melting point temperature at atmospheric pressure (Kelvin)", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "TmpK", "titlemodifier" -> 
    "", "windowtitle" -> "TmpK", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/TmpK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"fb39f1a8-f5a0-45da-851e-cc8a3be5becb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3948, 104, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"a3918d06-5d32-451a-ae7b-5cfa9fbf3e25",
   CellTags->"PrimaryExamplesSection",
   CellID->34729559]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 77479, 1642}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[576, 21, 2571, 56, 53, "AnchorBarGrid",ExpressionUUID->"65b106e0-fa22-4961-9d90-1a090764e165",
 CellID->1],
Cell[CellGroupData[{
Cell[3172, 81, 389, 9, 54, "ObjectNameGrid",ExpressionUUID->"716d33c1-aed3-4af4-89a7-767ec94f987f"],
Cell[3564, 92, 347, 7, 90, "Usage",ExpressionUUID->"24830409-dd58-431a-8f25-a15b1d7f5c1f",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3948, 104, 434, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"a3918d06-5d32-451a-ae7b-5cfa9fbf3e25",
 CellTags->"PrimaryExamplesSection",
 CellID->34729559],
Cell[CellGroupData[{
Cell[4407, 119, 308, 7, 30, "ExampleSection",ExpressionUUID->"2f3795c1-5317-493d-a7be-225722932731",
 CellID->267655211],
Cell[4718, 128, 175, 3, 27, "Input",ExpressionUUID->"431a1f65-1d33-459d-bfc2-4de0c375ebd0",
 CellID->87419684],
Cell[4896, 133, 139, 1, 38, "ExampleText",ExpressionUUID->"a3b2aaa0-60f0-4abc-abce-ccf74ccd6218",
 CellID->886239600],
Cell[CellGroupData[{
Cell[5060, 138, 198, 4, 27, "Input",ExpressionUUID->"ec63a395-168a-4371-9915-12d48a2736d5",
 CellID->21488140],
Cell[5261, 144, 198, 4, 43, "Output",ExpressionUUID->"4efdf723-75d5-4461-86e1-fa4ca281101a",
 CellID->636676416]
}, Open  ]],
Cell[5474, 151, 116, 1, 38, "ExampleText",ExpressionUUID->"4e77a54c-09a4-44d1-8ad3-7f488211b12a",
 CellID->351008126],
Cell[CellGroupData[{
Cell[5615, 156, 68577, 1396, 35, "WolframAlphaShortInput",ExpressionUUID->"ce8f246f-e2a0-4f12-8d25-040115129736",
 CellID->65503397],
Cell[74195, 1554, 227, 5, 44, "Output",ExpressionUUID->"c2d239e5-b02c-4beb-ae10-ad5a055e628a",
 CellID->163646763]
}, Open  ]]
}, Open  ]],
Cell[74449, 1563, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"f2fce9b0-77c7-4dfe-be11-231a6089cad7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74572, 1568, 270, 7, 73, "RelatedLinksSection",ExpressionUUID->"dc2ec999-5c50-4f3d-80ee-1a4ecfbe59cf",
 CellID->1584193535],
Cell[74845, 1577, 86, 0, 14, "SectionHeaderSpacer",ExpressionUUID->"8fafc19e-b495-48f5-910a-db926ef018c9"],
Cell[74934, 1579, 458, 11, 26, "RelatedLinks",ExpressionUUID->"ead6aff1-e46a-4f6b-b995-edae44bdf5c8",
 CellID->1038487239]
}, Open  ]],
Cell[75407, 1593, 78, 0, 41, "FooterCell",ExpressionUUID->"4882c111-aefb-47a1-ba6e-57522c15f856"]
}
]
*)

(* End of internal cache information *)

