(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32909,        839]
NotebookOptionsPosition[     26512,        700]
NotebookOutlinePosition[     28828,        760]
CellTagsIndexPosition[     28743,        755]
WindowTitle->TtransVapK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "168d5f46-ebb4-4e01-8dcd-3ef26039d414"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox[
       InterpretationBox[Cell[TextData[{
         "URL",
         StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
          StripOnInput->False]
        }],ExpressionUUID->"7bcffb78-7254-4869-b8c1-f34ecc7fdcac"],
        TextCell[
         Row[{"URL", 
           Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
       StripOnInput->False], {"\<\"EOSPotassium/ref/TtransVapK\"\>":>
      None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["EOSPotassium/ref/TtransVapK"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web URL\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/language/EOSPotassium/ref/\
TtransVapK.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
            If[
             TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$27858], 
             "http://reference.wolfram.com/system-modeler/", 
             "http://reference.wolfram.com/language/"], 
            "EOSPotassium/ref/TtransVapK", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic,
      MenuStyle->"URLMenu"]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "35f59a9a-1090-4aad-b11f-8fbe1425513d"]], "AnchorBar",ExpressionUUID->
     "63ed7885-4a5a-4930-af6d-4ae94907b42c"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"6bf9c98b-d084-4aef-bedb-4660a59e0d1f"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["TtransVapK", "ObjectName",ExpressionUUID->
  "680c9799-077d-4280-86a5-5894f8b5d4f3"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"ae4706a1-b584-40f8-95b4-26dbd80c810b"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "dc8ceaad-2e35-4454-92e8-26554fd502bb"]
}], "ObjectNameGrid",ExpressionUUID->"943bd621-378d-46f6-b446-78c7c3ba1f23"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TtransVapK", "[", 
       StyleBox["\[Rho]",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "b1fd3c5f-0725-4a77-9d53-964b2e6e050e"],
     " \[LineSeparator]Transition temperature ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["T", "t"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "be453d89-c70e-4304-88bd-4de0bca9e8f5"],
     " (Kelvin) as a function of density ",
     StyleBox["\[Rho]",
      FontSlant->"Italic"]
    }],ExpressionUUID->"70d6f6fe-9fbe-4a9b-9326-364fbe679dab"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"b3ddfef5-39c8-4319-a0bd-cc6e80ad2184"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"0820aa9d-021a-4f62-a878-16709dd0fa5e"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"d8377042-f3fb-4663-84f0-961765aef164"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"98fafdad-6358-447b-8a26-41f08b2ee648"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->117735415,ExpressionUUID->"e5e8f3b7-0a11-47b2-b3d8-b87608ec90d2"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"b1de90b3-b34a-482b-b410-1945e78145ca"],

Cell["\<\
The function is only valid for densities corresponding to the gaseous states \
of potassium.\
\>", "Notes",
 CellID->275640577,ExpressionUUID->"37ee2028-dd1f-4ef0-9509-059b7430ba6b"],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  SuperscriptBox["K", "*"]], "InlineFormula",
  FontSlant->"Italic",ExpressionUUID->"2ab590a0-a465-4de0-a031-0dac2b3a80e3"],
 " is calculated using its dilute-gas limit form: ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "9ba656f5-a681-48a2-bc54-d3a2ffdbe9c0"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "K0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "3"]}]], "InlineFormula",
  ExpressionUUID->"5a5fe81c-807d-46ba-8075-c884c0d6ca31"],
 " "
}], "Notes",
 CellID->819145981,ExpressionUUID->"22c7a3c0-ad88-4820-8950-2f9b96e7befe"],

Cell[TextData[{
 "By default the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "48c83634-f52a-44c4-99f3-84e1e4261d70"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"efb7a6a5-033a-482c-9c38-6b9e1b4a3570"],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox[
     SubsuperscriptBox["T", "t", "*"],
     FontSlant->"Italic"], "=", 
    RowBox[{
     SuperscriptBox[
      StyleBox["K",
       FontSlant->"Italic"], "*"], 
     StyleBox[
      FractionBox[
       SubscriptBox["\[Rho]", "c"], "\[Rho]"],
      FontSlant->"Italic"]}]}], 
   StyleBox[",",
    FontSlant->"Italic"]}]], "InlineFormula",ExpressionUUID->
  "5e33ee2b-f0c8-4e95-b7e3-6a396c734494"],
 " the following options can be given: "
}], "Notes",
 CellID->118785808,ExpressionUUID->"d4d482f5-dc5d-4fcd-b2ca-11a60566e443"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "0c634721-75dc-483f-a6b9-8b3f4c3d4f6b"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "1192de96-ecba-4b1a-92de-276c4b114a40"]
    }], "TableText",ExpressionUUID->"e7c2c389-5fcb-45cd-871f-45806cd9a978"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->459389538,ExpressionUUID->"42cdbe21-7c63-49ad-aded-c761a6f2305e"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"9d3fae76-7eee-44e4-8a57-b4b5725cdf84"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"f0eb25a3-2d95-4796-946d-aee8b37f6706"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "e6d937d2-0bf6-42c8-ba65-6eb4c2343d79"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->3419710,ExpressionUUID->"bcad0f4a-b029-44df-b71b-ce773ecd4e26"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f216f667-28a4-4557-acbe-8d445aee6388"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->44236379,ExpressionUUID->"cb53cb7b-214a-44fe-a71a-5150d7bdca22"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"9b750da3-bc30-410d-9edb-ecfcffff1e9e"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"27aedb3d-b131-4f2f-a237-f12221d6090e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TtransVapK", "[", 
  RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"TtransVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
    RowBox[{"\"\<Grams\>\"", "/", 
     SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"TtransVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
    "\"\<kg/m^3\>\""}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"e6176b39-b8a0-4ca4-9395-ff6f12fd48dd"],

Cell[BoxData["1.4993031957182497`*^-6"], "Output",
 CellLabel->"Out[2]=",
 CellID->37231294,ExpressionUUID->"06990cd9-1d48-4954-9b02-fbf258bba730"],

Cell[BoxData[
 TemplateBox[{"1.4993031957182497`*^-6", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->571284454,ExpressionUUID->"c9f1a6f2-be85-45a5-817b-94c9360f5059"],

Cell[BoxData[
 TemplateBox[{"1.4993031957182497`*^-6", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->815519381,ExpressionUUID->"572564b9-b3dd-4021-80c8-1abc703a7cf6"]
}, Open  ]],

Cell["\<\
Logarithmic plot of TtransVapK along the vapor coexistence curve from the \
melting point to the critical one\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"32c6da87-953f-4ec1-82c9-bfe837c31b5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"TtransVapK", "[", 
    RowBox[{"RhoSatVapK", "[", "T", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"T\", \"t\"],FontSlant->\"Italic\"]\) \
(K)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58108706,ExpressionUUID->"b0ea2540-6b74-4f3e-9ae9-85211c0c5ed3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVUHk81AkfHiN3Y4wrV65cRYUNodW33iEjRzFGSdeG4k2XHYMOV+4UQ65x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       "]]},
     Annotation[#, "Charting`Private`Tag$15750#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, -51.91020193273818},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"T\\\", \
\\\"t\\\"],FontSlant->\\\"Italic\\\"]\\) (K)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Automatic, Automatic}}, {{{{-52.95945713886305, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "23"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-41.44653167389282, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "18"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "13"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"100.000\"", ShowStringCharacters -> False], 100., 
           AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-50.65687204586901, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-48.35428695287496, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-46.051701859880914`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-43.74911676688687, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-39.14394658089878, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-36.841361487904734`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-34.538776394910684`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.328436022934504`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-52.95945713886305, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-41.44653167389282, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-50.65687204586901, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-48.35428695287496, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-46.051701859880914`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-43.74911676688687, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-39.14394658089878, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-36.841361487904734`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-34.538776394910684`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.328436022934504`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{336.65, 2223}, {-51.91020193273818, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellLabel->"Out[3]=",
 CellID->386953125,ExpressionUUID->"b19f1c75-7afa-4769-8637-517a3ff33a86"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "195d2591-36b0-4c72-8a5a-94547d425cac"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"1dbcee16-9cfa-46f2-8dc1-8fd834ffaced"],

Cell[CellGroupData[{

Cell[TextData[{
 "CoefK",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "d22e6988-a7a4-4ef2-bfc2-16ff23f95af8"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->133604641,ExpressionUUID->"705e9ac9-0360-4112-9d68-26c2473ae636"],

Cell[TextData[{
 "For example, in the case of tracers, it must be possible to potentially \
modify the value of the elastic constant, which can be done here by playing \
on the value of the parameter CoefK which multiplies ",
 StyleBox["K",
  FontSlant->"Italic"],
 "*"
}], "ExampleText",
 CellID->72796763,ExpressionUUID->"f2a1384c-5a79-48fc-8602-eb3dd44ec7da"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TtransVapK", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
    RowBox[{"\"\<Grams\>\"", "/", 
     SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"TtransVapK", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"CoefK", "\[Rule]", "1.21108"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->266018537,ExpressionUUID->"40f01dd9-ffd3-493a-9990-5065b634b3c2"],

Cell[BoxData[
 TemplateBox[{"1.4993031957182497`*^-6", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->142255294,ExpressionUUID->"6ff79c6b-1a27-41aa-af42-2ddd5bdad043"],

Cell[BoxData[
 TemplateBox[{"1.8157761142704576`*^-6", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->203892959,ExpressionUUID->"554ee24e-ff68-420f-bada-7854e6f58fd6"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"81ca4262-63bf-4c25-8aad-8d53e93c6ec0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c4939b96-c1a5-4224-b846-c8ab6d852710"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"1fac9c98-2577-4934-b6b2-551cc06f7b00"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"3dff32e1-2114-4f2f-aa8d-28a11247dad8"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "a4935b20-3741-4377-8c41-0248c531135c"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"a828c620-c1a0-480b-a75d-4b36291fc379"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"5747feae-fca4-429a-acc0-625dca4e4e0c"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TtransVapK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 2, 17.9592990}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "TtransVapK[\\[Rho]] Transition temperature Tt (Kelvin) as a function of \
density \\[Rho]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "TtransVapK", "titlemodifier" -> "", "windowtitle" -> "TtransVapK", 
    "type" -> "Symbol", "uri" -> "EOSPotassium/ref/TtransVapK", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"0bc99b0a-073b-492e-aa8c-d47aed20e609"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8278, 234, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bcad0f4a-b029-44df-b71b-ce773ecd4e26",
   CellTags->"PrimaryExamplesSection",
   CellID->3419710]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28547, 748}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 2596, 56, 53, "AnchorBarGrid",ExpressionUUID->"6bf9c98b-d084-4aef-bedb-4660a59e0d1f",
 CellID->1],
Cell[CellGroupData[{
Cell[3203, 81, 395, 9, 54, "ObjectNameGrid",ExpressionUUID->"943bd621-378d-46f6-b446-78c7c3ba1f23"],
Cell[3601, 92, 803, 20, 112, "Usage",ExpressionUUID->"b3ddfef5-39c8-4319-a0bd-cc6e80ad2184",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4441, 117, 855, 21, 37, "NotesSection",ExpressionUUID->"e5e8f3b7-0a11-47b2-b3d8-b87608ec90d2",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->117735415],
Cell[5299, 140, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"b1de90b3-b34a-482b-b410-1945e78145ca"],
Cell[5388, 142, 192, 4, 70, "Notes",ExpressionUUID->"37ee2028-dd1f-4ef0-9509-059b7430ba6b",
 CellID->275640577],
Cell[5583, 148, 812, 26, 70, "Notes",ExpressionUUID->"22c7a3c0-ad88-4820-8950-2f9b96e7befe",
 CellID->819145981],
Cell[6398, 176, 273, 6, 70, "Notes",ExpressionUUID->"efb7a6a5-033a-482c-9c38-6b9e1b4a3570",
 CellID->1067943069],
Cell[6674, 184, 602, 21, 70, "Notes",ExpressionUUID->"d4d482f5-dc5d-4fcd-b2ca-11a60566e443",
 CellID->118785808],
Cell[7279, 207, 873, 20, 70, "3ColumnTableMod",ExpressionUUID->"42cdbe21-7c63-49ad-aded-c761a6f2305e",
 CellID->459389538],
Cell[8155, 229, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"9d3fae76-7eee-44e4-8a57-b4b5725cdf84"]
}, Closed]],
Cell[CellGroupData[{
Cell[8278, 234, 433, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"bcad0f4a-b029-44df-b71b-ce773ecd4e26",
 CellTags->"PrimaryExamplesSection",
 CellID->3419710],
Cell[CellGroupData[{
Cell[8736, 249, 307, 7, 30, "ExampleSection",ExpressionUUID->"cb53cb7b-214a-44fe-a71a-5150d7bdca22",
 CellID->44236379],
Cell[9046, 258, 175, 3, 27, "Input",ExpressionUUID->"9b750da3-bc30-410d-9edb-ecfcffff1e9e",
 CellID->87419684],
Cell[9224, 263, 294, 5, 57, "ExampleText",ExpressionUUID->"27aedb3d-b131-4f2f-a237-f12221d6090e",
 CellID->544149791],
Cell[CellGroupData[{
Cell[9543, 272, 677, 17, 63, "Input",ExpressionUUID->"e6176b39-b8a0-4ca4-9395-ff6f12fd48dd",
 CellID->218515404],
Cell[10223, 291, 147, 2, 38, "Output",ExpressionUUID->"06990cd9-1d48-4954-9b02-fbf258bba730",
 CellID->37231294],
Cell[10373, 295, 214, 4, 47, "Output",ExpressionUUID->"c9f1a6f2-be85-45a5-817b-94c9360f5059",
 CellID->571284454],
Cell[10590, 301, 214, 4, 47, "Output",ExpressionUUID->"572564b9-b3dd-4021-80c8-1abc703a7cf6",
 CellID->815519381]
}, Open  ]],
Cell[10819, 308, 215, 4, 57, "ExampleText",ExpressionUUID->"32c6da87-953f-4ec1-82c9-bfe837c31b5b",
 CellID->119396994],
Cell[CellGroupData[{
Cell[11059, 316, 669, 16, 44, "Input",ExpressionUUID->"b0ea2540-6b74-4f3e-9ae9-85211c0c5ed3",
 CellID->58108706],
Cell[11731, 334, 11599, 263, 246, "Output",ExpressionUUID->"b19f1c75-7afa-4769-8637-517a3ff33a86",
 CellID->386953125]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23379, 603, 302, 7, 70, "ExampleSection",ExpressionUUID->"1dbcee16-9cfa-46f2-8dc1-8fd834ffaced",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[23706, 614, 305, 7, 70, "ExampleSubsection",ExpressionUUID->"705e9ac9-0360-4112-9d68-26c2473ae636",
 CellID->133604641],
Cell[24014, 623, 362, 8, 70, "ExampleText",ExpressionUUID->"f2a1384c-5a79-48fc-8602-eb3dd44ec7da",
 CellID->72796763],
Cell[CellGroupData[{
Cell[24401, 635, 672, 17, 70, "Input",ExpressionUUID->"40f01dd9-ffd3-493a-9990-5065b634b3c2",
 CellID->266018537],
Cell[25076, 654, 214, 4, 47, "Output",ExpressionUUID->"6ff79c6b-1a27-41aa-af42-2ddd5bdad043",
 CellID->142255294],
Cell[25293, 660, 214, 4, 47, "Output",ExpressionUUID->"554ee24e-ff68-420f-bada-7854e6f58fd6",
 CellID->203892959]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[25546, 669, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"81ca4262-63bf-4c25-8aad-8d53e93c6ec0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25669, 674, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"1fac9c98-2577-4934-b6b2-551cc06f7b00",
 CellID->1584193535],
Cell[25942, 683, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"3dff32e1-2114-4f2f-aa8d-28a11247dad8"],
Cell[26031, 685, 384, 10, 70, "RelatedLinks",ExpressionUUID->"a828c620-c1a0-480b-a75d-4b36291fc379",
 CellID->426751138]
}, Open  ]],
Cell[26430, 698, 78, 0, 70, "FooterCell",ExpressionUUID->"5747feae-fca4-429a-acc0-625dca4e4e0c"]
}
]
*)

(* End of internal cache information *)

