(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     62350,       1503]
NotebookOptionsPosition[     52607,       1296]
NotebookOutlinePosition[     55179,       1361]
CellTagsIndexPosition[     55062,       1355]
WindowTitle->etaK1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "8546211f-627e-4ae5-84ce-37af1e0ff3e1"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"56df2c3d-f2d4-4cb1-80bc-fe0bfbe82cf4"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etalK1atm\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etalK1atm.nb", None}, "paclet*"], 
         Part[
          Part[{{"etalK1atm", {"etalK1atm.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etalK1atm", {"etalK1atm.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "14889b52-23e4-47a0-962c-970cb9e4a12f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"2b087cc4-e6d1-4b1a-ab41-913a5a1113e0"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etaK1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etaK1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etaK1atm.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$18916], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etaK1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "054f52f2-ce3e-4729-b6d4-6cb06becfd31"]
    }], "AnchorBar",ExpressionUUID->"1467e4f7-23c6-4452-bf74-904657cc15ae"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"b1c543aa-f6d0-4506-a124-836328d0cb12"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etaK1atm", "ObjectName",ExpressionUUID->
  "d4839d30-ccaf-4646-a71c-78d381072d13"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"d57f4b7e-5f72-43f5-b425-401fe00c1449"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "1ddebc7c-1887-493a-bc73-1230e88cbe87"]
}], "ObjectNameGrid",ExpressionUUID->"86aa54d8-00f6-4ad9-be4c-43c9367bebb6"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etaK1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "a30c3545-e9a0-4288-a204-eee912780c6b"],
     " \[LineSeparator]Potassium viscosity equation of state \[Eta](",
     StyleBox["T",
      FontSlant->"Italic"],
     ") as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"79a4b1dd-6632-4d91-91c7-98d46445e4d1"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"58463306-6117-45c9-8883-eb71523cbc56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"ccfe47e7-f197-4ca5-8bfe-0598a9891c76"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"080d21bd-f56d-4dca-b647-fe0f6660fabe"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"406e4843-f8ca-4678-8f8f-7a05a791729e"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->47208591,ExpressionUUID->"fab4ffa7-39b8-4b22-bca7-7587b3c786b5"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"ed738256-3e24-4106-b01e-bcdba6a922c4"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
 "1030.793"], "InlineFormula",ExpressionUUID->
  "edf587ca-1b4b-4064-b272-2021dbdd4bb1"],
 " K"
}], "Notes",
 CellID->206839001,ExpressionUUID->"a89445e0-d7ee-45f4-b901-5dbb89afcc49"],

Cell[TextData[{
 "The parameter ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is considered as a contant and ",
 Cell[BoxData[
  SubscriptBox[
   OverscriptBox["\[Rho]", "~"], "Knu"]], "InlineFormula",ExpressionUUID->
  "ee046632-5b1d-4ee2-bde1-8b08cdee4343"],
 " is calculated by using the parameters adapted for Chiong's data "
}], "Notes",
 CellID->819145981,ExpressionUUID->"99b662d9-e01b-4d09-9170-4f5fb809ee07"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin "
}], "Notes",
 CellID->186809512,ExpressionUUID->"d6285bab-8602-45fe-b5cb-8580b41d3915"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
 "\[Eta]"], "InlineFormula",ExpressionUUID->
  "dbbddb98-9720-48d0-a348-50cb7a54c1f3"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"21f67af9-f113-49d7-ab6a-f3e3721bd045"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "9e6eb4ea-51e6-4e2d-842d-30646aedcd8d"], 
    ButtonBox[
     ButtonBox["etaK1atmDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaK1atmDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"12e0d80e-c027-475f-97b5-a37bbce5072b"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"6ffcd4b2-0d9d-49b7-a798-c375822af9d4"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"b7d27038-a1e7-49da-b709-99abc2967167"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "c76a105d-7f70-4446-a628-1aa542078b27"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "f466aa70-468d-416d-84f7-4b29d7d9fe57"]
    }], "TableText",ExpressionUUID->"1ae70179-4bee-4c9d-b8a8-87042099c02e"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "8c185e10-453a-4c61-b369-a908fa49d651"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"d63b5a6a-bdb1-49bd-8ec8-942a283879c0"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "765d25b0-872f-4c83-ac04-fe636f6f99d7"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "7a61b016-668f-4b93-b1e3-c488f89dd009"]
    }], "TableText",ExpressionUUID->"c9d50451-4409-4947-ab2a-0707bef70c58"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"2d950577-1a5f-4c52-aab1-6bd1329341aa"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"2034e359-2915-43f1-b843-656e690054e4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"30fdce36-2095-4a89-8e04-28cc70b1b4f8"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "52dedff3-06ce-416c-bcf6-76ff600a6b20"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->141149389,ExpressionUUID->"e8e516ba-1947-4e22-94f5-ffc35abd8590"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "90e72672-4ae5-4daa-b490-39394c1d7d2a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->389262647,ExpressionUUID->"8779db4c-596e-49de-8c11-2434a6c4de50"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"e4fb1399-c5f2-4768-bbfd-fdf0ef92e72f"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"96ffaa37-e3e9-41ff-9c4e-07489335946d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaK1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"d678653f-ef49-4243-8e6d-a91be53cfd68"],

Cell[BoxData["0.20251013251311237`"], "Output",
 CellLabel->"Out[2]=",
 CellID->23502568,ExpressionUUID->"9140ae9d-e474-4eff-b381-e6eb07627618"],

Cell[BoxData[
 TemplateBox[{
  "0.20251013251311237`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->84552309,ExpressionUUID->"a22dfabc-525b-47a2-a782-34dfbaf1e138"],

Cell[BoxData[
 TemplateBox[{
  "0.20251013251311237`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->515632769,ExpressionUUID->"91e8a77d-b733-4915-9a21-562ff40e3fd5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.20251013251311237`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"39c731b3-3985-4444-8a8d-2a38df7c47de"],

Cell[BoxData[
 TemplateBox[{"0.20251013251311237`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->31224671,ExpressionUUID->"ec107e15-cdad-44ce-8ffa-5ed3b0b187c7"]
}, Open  ]],

Cell["\<\
Plot from the melting point to the boiling point along the atmospheric isobar\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"660b1c15-a9a9-4701-8767-b5a816d92b4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"etaK1atm", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\[Eta] (mPa.s)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->562653754,ExpressionUUID->"f08b1d04-cd11-4881-bcb0-c85691b84001"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk41NsbAHBrkkKSZCtCSG7WkHvPm0SSJdFiKeoXXSmJsUWW7DPz/U6U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       "]]},
     Annotation[#, "Charting`Private`Tag$8185#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0.2023141692485263},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"\[Eta] (mPa.s)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {0.2023141692485263, 0.538918831991992}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->159643950,ExpressionUUID->"87e3e793-2971-4e90-abab-f9c66f3cddbd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ded43647-e1a3-4621-b74c-e8efb00eb713"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"992dc71b-f82b-4f4f-904e-96b913275809"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
 "\[Eta]"],ExpressionUUID->"df598037-33a5-4175-b206-eface2ad2859"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "cb671b1a-1dcb-4dc3-8442-a03ffe90f487"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"3239af8c-2df0-4417-ba27-325df3c1a4c3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"etaK1atm", "[", 
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"With", " ", 
    RowBox[{"Chiong", "'"}], "s", " ", "parameters"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Coefd", "\[Rule]", "0.9525"}], ",", 
   RowBox[{"CoefN", "\[Rule]", "0.986928"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"5d25b621-6eea-426f-8da8-f2a8a0cd0e6c"],

Cell[BoxData[
 TemplateBox[{
  "0.20251013251311237`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->110722579,ExpressionUUID->"8531dab2-bb46-4a25-9f40-16307fc83795"],

Cell[BoxData[
 TemplateBox[{
  "0.20266466220179974`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->381654323,ExpressionUUID->"b5a5032b-1f13-49be-810c-3e4404d167c7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2a142620-7bdf-4e4b-879e-64f1d0af2728"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"f5e3bdfa-bfa4-464b-a50d-655ef85a443b"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaK1atmDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "0be29ef7-bab1-4813-aaf3-3084f009bc0b"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"8fd3ccf4-8d95-43a2-bc99-3148c5699694"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaK1atmDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"e866a4a1-2080-4b92-b089-37a04c7e3a22"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaK1atm", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"473eb400-c704-425e-8c08-e08e5e32bfbd"],

Cell[BoxData["202.51013251311238`"], "Output",
 CellLabel->"Out[1]=",
 CellID->87333212,ExpressionUUID->"9d9a4b87-5195-4cda-a75a-10d9239cb72b"],

Cell[BoxData[
 TemplateBox[{"202.51013251311238`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->207663138,ExpressionUUID->"3156fdc4-464c-420f-9b9c-1dbfc168dfd7"],

Cell[BoxData[
 TemplateBox[{"202.51013251311238`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->34508484,ExpressionUUID->"2f6a955e-2c5d-42a4-8eee-454830f80f0e"]
}, Open  ]],

Cell["Globally by using SetOptions:", "ExampleText",
 CellID->195019342,ExpressionUUID->"c9e05cb0-bcf7-42f3-a591-f09f30f41791"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"etaK1atm", ",", 
    RowBox[{"etaK1atmDefaultUnit", "->", 
     RowBox[{"QuantityUnit", "[", 
      RowBox[{"Quantity", "[", 
       RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
      "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->110075696,ExpressionUUID->"c534be3f-e701-4c05-a213-68e286083f2f"],

Cell[BoxData["202.51013251311238`"], "Output",
 CellLabel->"Out[2]=",
 CellID->250675801,ExpressionUUID->"58bee1e6-4f56-4540-9858-79b1f7f03b3a"],

Cell[BoxData[
 TemplateBox[{"202.51013251311238`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->48599331,ExpressionUUID->"35f93395-70a5-4380-9ac4-c7a4b6037982"],

Cell[BoxData[
 TemplateBox[{"202.51013251311238`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->264411041,ExpressionUUID->"a132f589-66a6-4270-bd57-6fe608dbc6eb"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f8781285-3859-4d9c-9f35-0d032758d4af"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"60dcbd64-c71b-4c51-a6eb-4430d499f2fc"],

Cell["\<\
Comparison of Chiong's data (blue points) with the theoretical model (red \
curve) along the atmospheric isobar\
\>", "ExampleText",
 CellID->101130033,ExpressionUUID->"307efb11-de4c-4186-a497-4fb03f9873ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Viscosity", " ", "data", " ", "from", " ", "Chiong"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"TabviscoChiong", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"337.5", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.5535", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"340.15", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.5256", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"341.05", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.523", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"352.55", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.493", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"372.65", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.454", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"392.75", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.4188", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"428.65", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.3707", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"448.65", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.353", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"480.85", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.3249", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"555.65", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.275", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"625.65", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.2457", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"0.7", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}], ";"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177054281,ExpressionUUID->"a21c57d9-c199-4e5c-b238-5636ac96f86b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"TabviscoChiong", ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<OpenMarkers\>\"", ",", " ", "Medium"}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"etaK1atm", "[", 
      RowBox[{"T", ",", 
       RowBox[{"Coefd", "\[Rule]", "0.9525"}], ",", 
       RowBox[{"CoefN", "\[Rule]", "0.986928"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "->", "Medium"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\[Eta] (mPa.s)\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", "14", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], "]"}]}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685668221,ExpressionUUID->"d04c8cd5-caf5-46df-8016-c19f9aa5e94e"],

Cell[BoxData[
 GraphicsBox[{{{{
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{337.5, 0.5496255}, {337.5, 0.5535}}], 
          LineBox[{{337.5, 0.5535}, {337.5, 0.5573745}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{340.15, 0.5219208}, {340.15, 0.5256}}], 
          LineBox[{{340.15, 0.5256}, {340.15, 0.5292792}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{341.05, 0.519339}, {341.05, 0.523}}], 
          LineBox[{{341.05, 0.523}, {341.05, 0.526661}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{352.55, 0.489549}, {352.55, 0.493}}], 
          LineBox[{{352.55, 0.493}, {352.55, 0.496451}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{372.65, 0.450822}, {372.65, 0.454}}], 
          LineBox[{{372.65, 0.454}, {372.65, 0.45717800000000003`}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{392.75, 0.4158684}, {392.75, 0.4188}}], 
          LineBox[{{392.75, 0.4188}, {392.75, 0.4217316}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {
          LineBox[{{428.65, 0.36810509999999996`}, {428.65, 0.3707}}], 
          LineBox[{{428.65, 0.3707}, {428.65, 0.3732949}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{448.65, 0.350529}, {448.65, 0.353}}], 
          LineBox[{{448.65, 0.353}, {448.65, 0.355471}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{480.85, 0.3226257}, {480.85, 0.3249}}], 
          LineBox[{{480.85, 0.3249}, {480.85, 0.32717430000000003`}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{555.65, 0.273075}, {555.65, 0.275}}], 
          LineBox[{{555.65, 0.275}, {555.65, 0.27692500000000003`}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{625.65, 0.2439801}, {625.65, 0.2457}}], 
          LineBox[{{625.65, 0.2457}, {625.65, 0.2474199}}]}},
        Antialiasing->False]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{337.5, 0.5573745}, 
             Offset[{3, 0}, {337.5, 0.5573745}]}, {{337.5, 0.5573745}, 
             Offset[{-3, 0}, {337.5, 0.5573745}]}, {{337.5, 0.5496255}, 
             Offset[{3, 0}, {337.5, 0.5496255}]}, {{337.5, 0.5496255}, 
             Offset[{-3, 0}, {337.5, 0.5496255}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{340.15, 0.5292792}, 
             Offset[{3, 0}, {340.15, 0.5292792}]}, {{340.15, 0.5292792}, 
             Offset[{-3, 0}, {340.15, 0.5292792}]}, {{340.15, 0.5219208}, 
             Offset[{3, 0}, {340.15, 0.5219208}]}, {{340.15, 0.5219208}, 
             Offset[{-3, 0}, {340.15, 0.5219208}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{341.05, 0.526661}, 
             Offset[{3, 0}, {341.05, 0.526661}]}, {{341.05, 0.526661}, 
             Offset[{-3, 0}, {341.05, 0.526661}]}, {{341.05, 0.519339}, 
             Offset[{3, 0}, {341.05, 0.519339}]}, {{341.05, 0.519339}, 
             Offset[{-3, 0}, {341.05, 0.519339}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{352.55, 0.496451}, 
             Offset[{3, 0}, {352.55, 0.496451}]}, {{352.55, 0.496451}, 
             Offset[{-3, 0}, {352.55, 0.496451}]}, {{352.55, 0.489549}, 
             Offset[{3, 0}, {352.55, 0.489549}]}, {{352.55, 0.489549}, 
             Offset[{-3, 0}, {352.55, 0.489549}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{372.65, 0.45717800000000003`}, 
             Offset[{3, 0}, {372.65, 0.45717800000000003`}]}, {{372.65, 
             0.45717800000000003`}, 
             Offset[{-3, 0}, {372.65, 0.45717800000000003`}]}, {{372.65, 
             0.450822}, Offset[{3, 0}, {372.65, 0.450822}]}, {{372.65, 
             0.450822}, Offset[{-3, 0}, {372.65, 0.450822}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{392.75, 0.4217316}, 
             Offset[{3, 0}, {392.75, 0.4217316}]}, {{392.75, 0.4217316}, 
             Offset[{-3, 0}, {392.75, 0.4217316}]}, {{392.75, 0.4158684}, 
             Offset[{3, 0}, {392.75, 0.4158684}]}, {{392.75, 0.4158684}, 
             Offset[{-3, 0}, {392.75, 0.4158684}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{428.65, 0.3732949}, 
             Offset[{3, 0}, {428.65, 0.3732949}]}, {{428.65, 0.3732949}, 
             Offset[{-3, 0}, {428.65, 0.3732949}]}, {{428.65, 
             0.36810509999999996`}, 
             Offset[{3, 0}, {428.65, 0.36810509999999996`}]}, {{428.65, 
             0.36810509999999996`}, 
             Offset[{-3, 0}, {428.65, 0.36810509999999996`}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{448.65, 0.355471}, 
             Offset[{3, 0}, {448.65, 0.355471}]}, {{448.65, 0.355471}, 
             Offset[{-3, 0}, {448.65, 0.355471}]}, {{448.65, 0.350529}, 
             Offset[{3, 0}, {448.65, 0.350529}]}, {{448.65, 0.350529}, 
             Offset[{-3, 0}, {448.65, 0.350529}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{480.85, 0.32717430000000003`}, 
             Offset[{3, 0}, {480.85, 0.32717430000000003`}]}, {{480.85, 
             0.32717430000000003`}, 
             Offset[{-3, 0}, {480.85, 0.32717430000000003`}]}, {{480.85, 
             0.3226257}, Offset[{3, 0}, {480.85, 0.3226257}]}, {{480.85, 
             0.3226257}, Offset[{-3, 0}, {480.85, 0.3226257}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{555.65, 0.27692500000000003`}, 
             Offset[{3, 0}, {555.65, 0.27692500000000003`}]}, {{555.65, 
             0.27692500000000003`}, 
             Offset[{-3, 0}, {555.65, 0.27692500000000003`}]}, {{555.65, 
             0.273075}, Offset[{3, 0}, {555.65, 0.273075}]}, {{555.65, 
             0.273075}, Offset[{-3, 0}, {555.65, 0.273075}]}}], {{{1., 0.}, {
           0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{625.65, 0.2474199}, 
             Offset[{3, 0}, {625.65, 0.2474199}]}, {{625.65, 0.2474199}, 
             Offset[{-3, 0}, {625.65, 0.2474199}]}, {{625.65, 0.2439801}, 
             Offset[{3, 0}, {625.65, 0.2439801}]}, {{625.65, 0.2439801}, 
             Offset[{-3, 0}, {625.65, 0.2439801}]}}], {{{1., 0.}, {0., 1.}}, {
           0., 0.}}]},
        Antialiasing->False]}}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[{
           {GrayLevel[1], DiskBox[{0, 0}, Offset[{3., 3.}, {0., 0.}]]}, 
           {AbsoluteThickness[1.5], Dashing[{}], 
            CircleBox[{0, 0}, Offset[{3., 3.}, {0., 0.}]]}}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Scaled[9.75]], {{{337.5, 
      0.5535}}, {{340.15, 0.5256}}, {{341.05, 0.523}}, {{352.55, 0.493}}, {{
      372.65, 0.454}}, {{392.75, 0.4188}}, {{428.65, 0.3707}}, {{448.65, 
      0.353}}, {{480.85, 0.3249}}, {{555.65, 0.275}}, {{625.65, 
      0.2457}}}]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1nk4lVsXAPCDkGRIuOaSuQxFplR7hVQqITQh1UXX/UzlmEKIMpzzvidF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        "]]},
      Annotation[#, "Charting`Private`Tag$15961#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{331.49687500000005`, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
     TraditionalForm], 
    FormBox["\"\[Eta] (mPa.s)\"", TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Medium,
  LabelStyle->Directive[
    GrayLevel[0], Bold, 14, FontFamily -> "Times New Roman"],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[2]=",
 CellID->241020963,ExpressionUUID->"ed22fe43-c389-4eda-a958-43f623efe41c"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"88de9936-ba4e-42b8-99e8-9a44bb6e4d28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"af4ae973-acd1-49d7-9d3e-abe531e844a8"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"4004e50e-fbd0-46b0-90bd-5baf497d96d5"],

Cell[TextData[StyleBox[ButtonBox["etalK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etalK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"cd542bb4-0d05-4bec-aaf2-adbbb71a191f"],

Cell[TextData[StyleBox[ButtonBox["etaKnuK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKnuK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->229631036,ExpressionUUID->"9b4785db-c3d9-413b-9d68-414f5759666c"],

Cell[TextData[StyleBox[ButtonBox["DtK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"DtK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->181507426,ExpressionUUID->"aed4c1ff-849e-4067-983b-bed5b4501940"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"46d23e7f-ba3c-4bfc-9afa-48978f379026"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"bf5bedec-97f0-44db-9917-5cdded6781d3"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"59c23463-d42b-4584-92c2-3e888de29c25"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "3f4d6d9a-2368-405b-bf31-263dbd55e8f7"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"b831d1ad-32ce-4906-9cc4-db91ab677fe8"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"108984fe-6185-48bc-8466-b0c5bc24916f"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etaK1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 22.5002997}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etaK1atm[T] Potassium viscosity equation of state \\[Eta](T) as a \
function of temperature T along the atmospheric isobar in the liquid phase", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "etaK1atm", 
    "titlemodifier" -> "", "windowtitle" -> "etaK1atm", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/etaK1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"e57f628c-4837-4e96-96c3-caeffdf91256"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10792, 292, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e8e516ba-1947-4e22-94f5-ffc35abd8590",
   CellTags->"PrimaryExamplesSection",
   CellID->141149389]},
 "DefaultUnit"->{
  Cell[24224, 627, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"8fd3ccf4-8d95-43a2-bc99-3148c5699694",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54687, 1344},
 {"DefaultUnit", 54881, 1348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 3655, 83, 53, "AnchorBarGrid",ExpressionUUID->"b1c543aa-f6d0-4506-a124-836328d0cb12",
 CellID->1],
Cell[CellGroupData[{
Cell[4260, 108, 393, 9, 54, "ObjectNameGrid",ExpressionUUID->"86aa54d8-00f6-4ad9-be4c-43c9367bebb6"],
Cell[4656, 119, 738, 18, 134, "Usage",ExpressionUUID->"58463306-6117-45c9-8883-eb71523cbc56",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5431, 142, 854, 21, 37, "NotesSection",ExpressionUUID->"fab4ffa7-39b8-4b22-bca7-7587b3c786b5",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->47208591],
Cell[6288, 165, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"ed738256-3e24-4106-b01e-bcdba6a922c4"],
Cell[6377, 167, 407, 14, 70, "Notes",ExpressionUUID->"a89445e0-d7ee-45f4-b901-5dbb89afcc49",
 CellID->206839001],
Cell[6787, 183, 416, 11, 70, "Notes",ExpressionUUID->"99b662d9-e01b-4d09-9170-4f5fb809ee07",
 CellID->819145981],
Cell[7206, 196, 194, 6, 70, "Notes",ExpressionUUID->"d6285bab-8602-45fe-b5cb-8580b41d3915",
 CellID->186809512],
Cell[7403, 204, 381, 10, 70, "Notes",ExpressionUUID->"21f67af9-f113-49d7-ab6a-f3e3721bd045",
 CellID->487713575],
Cell[7787, 216, 744, 17, 70, "3ColumnTableMod",ExpressionUUID->"6ffcd4b2-0d9d-49b7-a798-c375822af9d4",
 CellID->716128471],
Cell[8534, 235, 127, 1, 70, "Notes",ExpressionUUID->"b7d27038-a1e7-49da-b709-99abc2967167",
 CellID->46888620],
Cell[8664, 238, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"2d950577-1a5f-4c52-aab1-6bd1329341aa",
 CellID->505732368],
Cell[10669, 287, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"2034e359-2915-43f1-b843-656e690054e4"]
}, Closed]],
Cell[CellGroupData[{
Cell[10792, 292, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"e8e516ba-1947-4e22-94f5-ffc35abd8590",
 CellTags->"PrimaryExamplesSection",
 CellID->141149389],
Cell[CellGroupData[{
Cell[11252, 307, 308, 7, 30, "ExampleSection",ExpressionUUID->"8779db4c-596e-49de-8c11-2434a6c4de50",
 CellID->389262647],
Cell[11563, 316, 175, 3, 27, "Input",ExpressionUUID->"e4fb1399-c5f2-4768-bbfd-fdf0ef92e72f",
 CellID->87419684],
Cell[11741, 321, 298, 5, 57, "ExampleText",ExpressionUUID->"96ffaa37-e3e9-41ff-9c4e-07489335946d",
 CellID->544149791],
Cell[CellGroupData[{
Cell[12064, 330, 496, 12, 60, "Input",ExpressionUUID->"d678653f-ef49-4243-8e6d-a91be53cfd68",
 CellID->218515404],
Cell[12563, 344, 144, 2, 36, "Output",ExpressionUUID->"9140ae9d-e474-4eff-b381-e6eb07627618",
 CellID->23502568],
Cell[12710, 348, 220, 5, 43, "Output",ExpressionUUID->"a22dfabc-525b-47a2-a782-34dfbaf1e138",
 CellID->84552309],
Cell[12933, 355, 221, 5, 43, "Output",ExpressionUUID->"91e8a77d-b733-4915-9a21-562ff40e3fd5",
 CellID->515632769]
}, Open  ]],
Cell[CellGroupData[{
Cell[13191, 365, 360, 8, 27, "Input",ExpressionUUID->"39c731b3-3985-4444-8a8d-2a38df7c47de",
 CellID->273227049],
Cell[13554, 375, 302, 6, 43, "Output",ExpressionUUID->"ec107e15-cdad-44ce-8ffa-5ed3b0b187c7",
 CellID->31224671]
}, Open  ]],
Cell[13871, 384, 183, 3, 38, "ExampleText",ExpressionUUID->"660b1c15-a9a9-4701-8767-b5a816d92b4a",
 CellID->119396994],
Cell[CellGroupData[{
Cell[14079, 391, 573, 14, 44, "Input",ExpressionUUID->"f08b1d04-cd11-4881-bcb0-c85691b84001",
 CellID->562653754],
Cell[14655, 407, 7095, 137, 251, "Output",ExpressionUUID->"87e3e793-2971-4e90-abab-f9c66f3cddbd",
 CellID->159643950]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21799, 550, 323, 7, 70, "ExampleSection",ExpressionUUID->"992dc71b-f82b-4f4f-904e-96b913275809",
 CellID->1020263627],
Cell[22125, 559, 601, 16, 70, "ExampleText",ExpressionUUID->"3239af8c-2df0-4417-ba27-325df3c1a4c3",
 CellID->111367501],
Cell[CellGroupData[{
Cell[22751, 579, 649, 17, 70, "Input",ExpressionUUID->"5d25b621-6eea-426f-8da8-f2a8a0cd0e6c",
 CellID->138125379],
Cell[23403, 598, 221, 5, 43, "Output",ExpressionUUID->"8531dab2-bb46-4a25-9f40-16307fc83795",
 CellID->110722579],
Cell[23627, 605, 221, 5, 43, "Output",ExpressionUUID->"b5a5032b-1f13-49be-810c-3e4404d167c7",
 CellID->381654323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23897, 616, 302, 7, 70, "ExampleSection",ExpressionUUID->"f5e3bdfa-bfa4-464b-a50d-655ef85a443b",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[24224, 627, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"8fd3ccf4-8d95-43a2-bc99-3148c5699694",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[24571, 637, 230, 4, 70, "ExampleText",ExpressionUUID->"e866a4a1-2080-4b92-b089-37a04c7e3a22",
 CellID->300166705],
Cell[CellGroupData[{
Cell[24826, 645, 1132, 29, 70, "Input",ExpressionUUID->"473eb400-c704-425e-8c08-e08e5e32bfbd",
 CellID->643121792],
Cell[25961, 676, 143, 2, 35, "Output",ExpressionUUID->"9d9a4b87-5195-4cda-a75a-10d9239cb72b",
 CellID->87333212],
Cell[26107, 680, 306, 6, 45, "Output",ExpressionUUID->"3156fdc4-464c-420f-9b9c-1dbfc168dfd7",
 CellID->207663138],
Cell[26416, 688, 305, 6, 45, "Output",ExpressionUUID->"2f6a955e-2c5d-42a4-8eee-454830f80f0e",
 CellID->34508484]
}, Open  ]],
Cell[26736, 697, 127, 1, 70, "ExampleText",ExpressionUUID->"c9e05cb0-bcf7-42f3-a591-f09f30f41791",
 CellID->195019342],
Cell[CellGroupData[{
Cell[26888, 702, 802, 20, 70, "Input",ExpressionUUID->"c534be3f-e701-4c05-a213-68e286083f2f",
 CellID->110075696],
Cell[27693, 724, 144, 2, 35, "Output",ExpressionUUID->"58bee1e6-4f56-4540-9858-79b1f7f03b3a",
 CellID->250675801],
Cell[27840, 728, 305, 6, 45, "Output",ExpressionUUID->"35f93395-70a5-4380-9ac4-c7a4b6037982",
 CellID->48599331],
Cell[28148, 736, 306, 6, 45, "Output",ExpressionUUID->"a132f589-66a6-4270-bd57-6fe608dbc6eb",
 CellID->264411041]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28515, 749, 306, 7, 70, "ExampleSection",ExpressionUUID->"60dcbd64-c71b-4c51-a6eb-4430d499f2fc",
 CellID->258228157],
Cell[28824, 758, 217, 4, 70, "ExampleText",ExpressionUUID->"307efb11-de4c-4186-a497-4fb03f9873ff",
 CellID->101130033],
Cell[29044, 764, 3482, 98, 70, "Input",ExpressionUUID->"a21c57d9-c199-4e5c-b238-5636ac96f86b",
 CellID->177054281],
Cell[CellGroupData[{
Cell[32551, 866, 1312, 33, 70, "Input",ExpressionUUID->"d04c8cd5-caf5-46df-8016-c19f9aa5e94e",
 CellID->685668221],
Cell[33866, 901, 16782, 330, 257, "Output",ExpressionUUID->"ed22fe43-c389-4eda-a958-43f623efe41c",
 CellID->241020963]
}, Open  ]]
}, Closed]],
Cell[50675, 1235, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"88de9936-ba4e-42b8-99e8-9a44bb6e4d28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50798, 1240, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"4004e50e-fbd0-46b0-90bd-5baf497d96d5",
 CellID->1255426704],
Cell[51061, 1249, 220, 4, 70, "SeeAlso",ExpressionUUID->"cd542bb4-0d05-4bec-aaf2-adbbb71a191f",
 CellID->234329647],
Cell[51284, 1255, 224, 4, 70, "SeeAlso",ExpressionUUID->"9b4785db-c3d9-413b-9d68-414f5759666c",
 CellID->229631036],
Cell[51511, 1261, 216, 4, 70, "SeeAlso",ExpressionUUID->"aed4c1ff-849e-4067-983b-bed5b4501940",
 CellID->181507426]
}, Open  ]],
Cell[CellGroupData[{
Cell[51764, 1270, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"bf5bedec-97f0-44db-9917-5cdded6781d3",
 CellID->1584193535],
Cell[52037, 1279, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"59c23463-d42b-4584-92c2-3e888de29c25"],
Cell[52126, 1281, 384, 10, 70, "RelatedLinks",ExpressionUUID->"b831d1ad-32ce-4906-9cc4-db91ab677fe8",
 CellID->426751138]
}, Open  ]],
Cell[52525, 1294, 78, 0, 70, "FooterCell",ExpressionUUID->"108984fe-6185-48bc-8466-b0c5bc24916f"]
}
]
*)

(* End of internal cache information *)

