(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    167391,       3305]
NotebookOptionsPosition[    157443,       3094]
NotebookOutlinePosition[    160248,       3164]
CellTagsIndexPosition[    160092,       3157]
WindowTitle->etaKVap
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "b4e16761-2afa-4802-9633-5a544deb6dc6"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"3531dbd5-0791-4e7a-93de-26adac407966"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etalKVap\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etalKVap.nb", None}, "paclet*"], 
         Part[
          Part[{{"etalKVap", {"etalKVap.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etalKVap", {"etalKVap.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "63a58960-1a64-4619-a199-1bb510a30d2c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"95448e35-c46a-40bd-a337-9d129a9b1a5d"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etaKVap\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etaKVap"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etaKVap.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$20173], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etaKVap", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a55c0f58-74ad-4f18-8785-1109c3bdacf7"]
    }], "AnchorBar",ExpressionUUID->"21943d2a-2ed6-4e0a-8420-a6e48cdf3f74"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"816bb3fe-3c94-4b56-a69c-e6dc49322fd7"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etaKVap", "ObjectName",ExpressionUUID->
  "1d7bdfd6-73ce-4664-939f-a6c2aae28293"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"e89f0632-88d1-47a8-bf05-b1bc77b4087d"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "af9e638e-8684-4e7e-8474-19676ba618fb"]
}], "ObjectNameGrid",ExpressionUUID->"e1ebd587-a201-4bf8-9624-5c1df2f2126a"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etaKVap", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", 
        StyleBox["\[Rho]",
         FontSlant->"Italic"]}], "]"}]], "InlineFormula",ExpressionUUID->
      "e43e5f8d-c42b-4547-87c9-e0e461f2c925"],
     " \[LineSeparator]Potassium viscosity equation of state \[Eta](",
     StyleBox["T",
      FontSlant->"Italic"],
     ",\[Rho]) as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " and density ",
     StyleBox["\[Rho] ",
      FontSlant->"Italic"],
     "for the gaseous phase only"
    }],ExpressionUUID->"4deaeadd-daed-44f8-9afb-82c13a4a5586"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"f022bb68-b892-4ae7-ac8a-a90c1247e80d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"592ac584-d801-4520-868d-97eeab28a2a7"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"313763a9-b752-402d-83e9-0cae04658bfe"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c262c4dd-a1f1-49e0-b3bf-63e6af15185c"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->91271344,ExpressionUUID->"2b0301ed-7913-40ee-8db9-5753427b51e4"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"ec342330-5319-420c-bcab-784c254f6e31"],

Cell[TextData[{
 "The function is defined for 900 \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] 1600 K but it can be extrapolated to lower temperatures"
}], "Notes",
 CellID->78345116,ExpressionUUID->"70718879-fc87-45d5-ad0f-b00baa92bcd8"],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "40d0860e-ce7d-486f-8ad1-909f888f12c5"],
 " and the the function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "52a67049-aabc-46a2-ab64-5563e0e75cd6"],
 " are calculated using their dilute-gas limit forms: ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "89ab5b90-e0b2-4ed3-90b1-d4fff14cd5f7"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "K0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "3"]}]], "InlineFormula",
  ExpressionUUID->"74c2af21-4d6b-453c-90d7-440814f0f7cf"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "735cea91-9c1e-462c-9515-1d178a712403"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "N0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "2"]}]], "InlineFormula",
  ExpressionUUID->"d2407add-b8d4-4b9f-9719-eb810acdde86"],
 " "
}], "Notes",
 CellID->819145981,ExpressionUUID->"1547ac17-52cc-4f2f-b84e-fae94bbc8497"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin and the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "db89cfa6-7d40-4dfe-bc67-086b456d786f"]
}], "Notes",
 CellID->186809512,ExpressionUUID->"4d1be774-1303-4e43-82cd-9d16ba00f02d"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
 "\[Eta]"], "InlineFormula",ExpressionUUID->
  "aaef9042-3abd-4792-9ca0-b7126b5349c9"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"8787349b-e5b4-4c49-b18b-160fe22d275f"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "692a7e60-06f4-4d21-afbe-365bfb690406"], 
    ButtonBox[
     ButtonBox["etaKVapDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaKVapDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"657ca1c5-88c9-436c-bf13-4b6e497d0a7f"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"32454fe9-46c8-42cd-81eb-4004d5fe27c0"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"5dbd4580-b74a-4d5e-ace3-848873beef26"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "ecd87138-e804-4546-9bb9-9722adb90534"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "15f9f737-2d56-49a4-811b-35743542eb03"]
    }], "TableText",ExpressionUUID->"e7ca904b-feeb-4dc2-96af-441ccdb7c9f5"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "b9868c16-f0ca-43ad-9854-ed56cbe73969"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"b64c09b3-11cb-4282-9ed8-847fb3f9dc51"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "981c2216-97b0-49df-a6ca-39935ab93a01"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "1ef5be26-da0c-47ea-9876-0809b0115a56"]
    }], "TableText",ExpressionUUID->"294ef2f7-1148-4aa1-b379-9ad9019caa21"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"6094ae00-9f2f-4c09-b277-c6fc9290f633"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"3d126378-8527-40e3-8d0c-9c32448d1ceb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"160663d3-a08e-4883-9e3e-eb5396cc3870"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "ec84363b-12a1-4006-8360-c491a8af967a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->106024383,ExpressionUUID->"9f91f4c5-f59d-47f8-90f1-eaa06e8893fc"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2fecb222-4f60-4305-8485-f42fcf0c8e6c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->257715155,ExpressionUUID->"0f6f72f6-128c-4e33-a44e-922ba90e72a0"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"864b69c8-c28d-41ea-ae15-e3225b2941aa"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable and/or to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"1808cd1a-31bb-4849-8304-41e44dd63e22"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"991e4ba4-1c1b-4602-8551-2e0ad88fc531"],

Cell[BoxData["0.016855018903405933`"], "Output",
 CellLabel->"Out[2]=",
 CellID->111090836,ExpressionUUID->"ef0140c5-f4d5-402e-8a4d-7b722f0fc36e"],

Cell[BoxData[
 TemplateBox[{
  "0.016855018903405933`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->622232654,ExpressionUUID->"6f46e1fa-257f-4059-82c5-bba4a2c8fe4a"],

Cell[BoxData[
 TemplateBox[{
  "0.016855018903405933`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->49547472,ExpressionUUID->"a4e22377-9461-461a-8525-7ca1b4a46b5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.016855018903405933`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"984d9298-e5d3-45e8-83d6-2abb6be13106"],

Cell[BoxData[
 TemplateBox[{"0.016855018903405933`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->583835131,ExpressionUUID->"d12dfa9a-fef5-4783-9021-b7c36cb06197"]
}, Open  ]],

Cell["\<\
3D plot of the viscosity variation in gaseous potassium. The thick red line \
represents the vapor coexistence line and the horizontal surface represents \
the level of the liquid-like term.\
\>", "ExampleText",
 CellID->20254794,ExpressionUUID->"0656515d-fdd1-4381-8353-1cb02ba28b30"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tmin", "=", "900"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tmax", "=", "1600"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"etaKVap", "[", 
        RowBox[{"T", ",", "\[Rho]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", 
         RowBox[{"RhoSatVapK", "[", "Tmin", "]"}], ",", 
         RowBox[{"RhoSatVapK", "[", "Tmax", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
          RowBox[{"y", "\[LessEqual]", 
           RowBox[{"RhoSatVapK", "[", "x", "]"}]}]}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
          "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"\[Eta]\",FontSlant->\"Italic\"]\) \
(mPa.s)\>\"", ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Bold", ",", "16", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
         "]"}]}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"etaKVap", "[", 
        RowBox[{"T", ",", "\[Rho]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", 
         RowBox[{"RhoSatVapK", "[", "Tmin", "]"}], ",", 
         RowBox[{"RhoSatVapK", "[", "Tmax", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
          RowBox[{"y", ">", 
           RowBox[{"RhoSatVapK", "[", "x", "]"}]}]}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
          "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"\[Eta]\",FontSlant->\"Italic\"]\) \
(mPa.s)\>\"", ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Bold", ",", "16", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
         "]"}]}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
       RowBox[{"Mesh", "->", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
          RowBox[{"Lighter", "@", "Orange"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"etalKVap", "[", 
        RowBox[{"T", ",", "\[Rho]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", 
         RowBox[{"RhoSatVapK", "[", "Tmin", "]"}], ",", 
         RowBox[{"RhoSatVapK", "[", "Tmax", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Bold", ",", "16", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
         "]"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Lighter", "@", "Gray"}]}], ",", 
       RowBox[{"Mesh", "->", "None"}]}], "]"}], ",", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T", ",", 
         RowBox[{"RhoSatVapK", "[", "T", "]"}], ",", 
         RowBox[{"etaKVap", "[", 
          RowBox[{"T", ",", 
           RowBox[{"RhoSatVapK", "[", "T", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Red"}], 
         "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "Large"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->801374019,ExpressionUUID->"fe762040-c531-4902-8591-a62dcd1a0876"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvVtwXdd558mLR56qllMTyTXEARPhKD2EnDTgiDiiu6djSvKUulJ2OlMR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    "], {{0, 379.}, {556., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{556., 379.},
  PlotRange->{{0, 556.}, {0, 379.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->127237934,ExpressionUUID->"2a102669-344d-43d0-b063-971d97f9708b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "30d41ee4-6c42-46f9-9f70-c7535a5ad47f"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"480fa00a-d62d-4c3b-9b41-5c6dcbf021e8"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
 "\[Eta]"],ExpressionUUID->"2b1de6b1-45c9-48b3-86aa-cd462918151a"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "82d85f07-bc18-4c7a-b2a5-fd26bc1b51c7"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"ab14e25a-8614-42c6-b761-3c2d7dc652d3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"Coefd", "\[Rule]", "0.9"}], ",", 
   RowBox[{"CoefN", "\[Rule]", "0.9"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"14af51de-e763-4709-9212-5a4241cdebfe"],

Cell[BoxData[
 TemplateBox[{
  "0.016855018903405933`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->303219662,ExpressionUUID->"2bb38594-87ac-4611-8ffb-b3a716e5c43d"],

Cell[BoxData[
 TemplateBox[{
  "0.01710188773102255`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->433461320,ExpressionUUID->"4bc82b9d-fd24-487a-b7a1-b75d04906afe"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1212dc02-bb5a-41c7-9aa3-9b5235f69d19"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"332dd187-d5a9-497d-83e8-6ac584e3ef48"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaKVapDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "819c2978-be55-4bcd-9dc0-9e824caca68d"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"044ce6d7-8c49-44ab-b405-60a913dc170d"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaKVapDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"85606272-51fe-414e-9d76-0ff8bfa828f9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"9d8d844b-a0e9-4c26-bbfd-7604bd4f39b6"],

Cell[BoxData["16.855018903405934`"], "Output",
 CellLabel->"Out[1]=",
 CellID->83254926,ExpressionUUID->"e341b737-57da-4609-8cf5-cce93aa8546b"],

Cell[BoxData[
 TemplateBox[{"16.855018903405934`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->885708294,ExpressionUUID->"e84e4261-2860-44f5-a680-446e7e43c700"],

Cell[BoxData[
 TemplateBox[{"16.855018903405934`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->47424278,ExpressionUUID->"b272be56-2195-4848-a830-9f479ff80d9d"]
}, Open  ]],

Cell["Globally by using SetOptions:", "ExampleText",
 CellID->195019342,ExpressionUUID->"c9eda9b4-3ec7-4755-ae8a-b9483550cd4d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"etaKVap", ",", 
    RowBox[{"etaKVapDefaultUnit", "->", 
     RowBox[{"QuantityUnit", "[", 
      RowBox[{"Quantity", "[", 
       RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
      "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->110075696,ExpressionUUID->"4745f20e-8e5c-43c3-8ef5-3c39b5884dbc"],

Cell[BoxData["16.855018903405934`"], "Output",
 CellLabel->"Out[2]=",
 CellID->378804468,ExpressionUUID->"94e64e4b-3b56-4d97-863b-1f0077c1ae22"],

Cell[BoxData[
 TemplateBox[{"16.855018903405934`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->299114135,ExpressionUUID->"2baa3e85-0018-4cfa-96e1-4ebc8ec08a62"],

Cell[BoxData[
 TemplateBox[{"16.855018903405934`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->189938923,ExpressionUUID->"6f76e8b2-9197-4954-b02d-f6f41272310a"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1763de99-296c-4b12-a651-de25df71175b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"d1af4d80-bd25-4f3a-9e08-517fcbf963ca"],

Cell[TextData[{
 "Comparison of Lee ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 "'s",
 " data (blue points) with the theoretical model (red curve) on the 1.06 atm \
isobar."
}], "ExampleText",
 CellID->101130033,ExpressionUUID->"bca6b0d7-190f-4c27-8c5b-1b40c47769c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Table", " ", "of", " ", "viscosity", " ", "data", " ", "from", " ", "Lee",
     " ", 
    StyleBox["et",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    RowBox[{
     StyleBox["al",
      FontSlant->"Italic"], ".", " ", 
     RowBox[{"[", "1968", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"TabEtaLee", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1045.4", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.017271", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1052.7", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.017523", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1057.3", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.017385", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1082.9", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.017959", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1084.2", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.018096", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1088.3", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.017821", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1102.5", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.018211", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1116.2", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.018716", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1140.9", ",", 
        RowBox[{"Around", "[", 
         RowBox[{"0.019289", ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"Quantity", "[", 
            RowBox[{"1.5", ",", "\"\<Percent\>\""}], "]"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}], ";"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146313261,ExpressionUUID->"c2a001b2-84f2-42af-be60-0a27c22684ad"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"temps", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"T", ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "1045", ",", "1141"}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", "1.07405"}], ";"}], 
  RowBox[{"(*", "bar", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Calculation", " ", "of", " ", "densities", " ", "from", " ", "the", " ", 
    "compressibility", " ", "factor"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RhoLee", "[", "T_", "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{"sol", "=", 
        RowBox[{"x", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{
            FractionBox[
             RowBox[{"0.1", "*", "P", "*", "x"}], 
             RowBox[{"8.314", "*", "T"}]], "==", 
            RowBox[{"zK", "[", 
             RowBox[{"T", ",", "x"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "50000", ",", "100000"}], "}"}]}], "]"}]}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"MK", "/", "sol"}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"g", "/", 
    RowBox[{"cm", "^", "3"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TabEtaTheo", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"etaKVap", "[", 
          RowBox[{"#", ",", 
           RowBox[{"RhoLee", "[", "#", "]"}]}], "]"}]}], "}"}], "&"}], ",", 
      "temps"}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Theoretical", " ", "results"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"TabEtaLee", ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", " ", "Medium"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"TabEtaTheo", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "->", "Medium"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\[Eta] (mPa.s)\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", "14", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->69869692,ExpressionUUID->"3a3a0ef0-2e51-4826-9a18-1f0b1fa6ddb9"],

Cell[BoxData[
 GraphicsBox[{{{{
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {
          LineBox[{{1045.4, 0.017011935000000002`}, {1045.4, 0.017271}}], 
          LineBox[{{1045.4, 0.017271}, {1045.4, 0.017530065}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1052.7, 0.017260155}, {1052.7, 0.017523}}], 
          LineBox[{{1052.7, 0.017523}, {1052.7, 0.017785845}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1057.3, 0.017124225}, {1057.3, 0.017385}}], 
          LineBox[{{1057.3, 0.017385}, {1057.3, 0.017645775000000002`}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1082.9, 0.017689615}, {1082.9, 0.017959}}], 
          LineBox[{{1082.9, 0.017959}, {1082.9, 0.018228385}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1084.2, 0.01782456}, {1084.2, 0.018096}}], 
          LineBox[{{1084.2, 0.018096}, {1084.2, 0.018367440000000002`}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1088.3, 0.017553685}, {1088.3, 0.017821}}], 
          LineBox[{{1088.3, 0.017821}, {1088.3, 0.018088315}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {
          LineBox[{{1102.5, 0.017937835000000003`}, {1102.5, 0.018211}}], 
          LineBox[{{1102.5, 0.018211}, {1102.5, 0.018484165}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1116.2, 0.01843526}, {1116.2, 0.018716}}], 
          LineBox[{{1116.2, 0.018716}, {1116.2, 0.01899674}}]}},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{{}, {LineBox[{{1140.9, 0.018999665}, {1140.9, 0.019289}}], 
          LineBox[{{1140.9, 0.019289}, {1140.9, 0.019578335000000002`}}]}},
        Antialiasing->False]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1045.4, 0.017530065}, 
             Offset[{3, 0}, {1045.4, 0.017530065}]}, {{1045.4, 0.017530065}, 
             Offset[{-3, 0}, {1045.4, 0.017530065}]}, {{1045.4, 
             0.017011935000000002`}, 
             Offset[{3, 0}, {1045.4, 0.017011935000000002`}]}, {{1045.4, 
             0.017011935000000002`}, 
             Offset[{-3, 0}, {1045.4, 0.017011935000000002`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1052.7, 0.017785845}, 
             Offset[{3, 0}, {1052.7, 0.017785845}]}, {{1052.7, 0.017785845}, 
             Offset[{-3, 0}, {1052.7, 0.017785845}]}, {{1052.7, 0.017260155}, 
             Offset[{3, 0}, {1052.7, 0.017260155}]}, {{1052.7, 0.017260155}, 
             Offset[{-3, 0}, {1052.7, 0.017260155}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1057.3, 0.017645775000000002`}, 
             Offset[{3, 0}, {1057.3, 0.017645775000000002`}]}, {{1057.3, 
             0.017645775000000002`}, 
             Offset[{-3, 0}, {1057.3, 0.017645775000000002`}]}, {{1057.3, 
             0.017124225}, Offset[{3, 0}, {1057.3, 0.017124225}]}, {{1057.3, 
             0.017124225}, Offset[{-3, 0}, {1057.3, 0.017124225}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1082.9, 0.018228385}, 
             Offset[{3, 0}, {1082.9, 0.018228385}]}, {{1082.9, 0.018228385}, 
             Offset[{-3, 0}, {1082.9, 0.018228385}]}, {{1082.9, 0.017689615}, 
             Offset[{3, 0}, {1082.9, 0.017689615}]}, {{1082.9, 0.017689615}, 
             Offset[{-3, 0}, {1082.9, 0.017689615}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1084.2, 0.018367440000000002`}, 
             Offset[{3, 0}, {1084.2, 0.018367440000000002`}]}, {{1084.2, 
             0.018367440000000002`}, 
             Offset[{-3, 0}, {1084.2, 0.018367440000000002`}]}, {{1084.2, 
             0.01782456}, Offset[{3, 0}, {1084.2, 0.01782456}]}, {{1084.2, 
             0.01782456}, Offset[{-3, 0}, {1084.2, 0.01782456}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1088.3, 0.018088315}, 
             Offset[{3, 0}, {1088.3, 0.018088315}]}, {{1088.3, 0.018088315}, 
             Offset[{-3, 0}, {1088.3, 0.018088315}]}, {{1088.3, 0.017553685}, 
             Offset[{3, 0}, {1088.3, 0.017553685}]}, {{1088.3, 0.017553685}, 
             Offset[{-3, 0}, {1088.3, 0.017553685}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1102.5, 0.018484165}, 
             Offset[{3, 0}, {1102.5, 0.018484165}]}, {{1102.5, 0.018484165}, 
             Offset[{-3, 0}, {1102.5, 0.018484165}]}, {{1102.5, 
             0.017937835000000003`}, 
             Offset[{3, 0}, {1102.5, 0.017937835000000003`}]}, {{1102.5, 
             0.017937835000000003`}, 
             Offset[{-3, 0}, {1102.5, 0.017937835000000003`}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1116.2, 0.01899674}, 
             Offset[{3, 0}, {1116.2, 0.01899674}]}, {{1116.2, 0.01899674}, 
             Offset[{-3, 0}, {1116.2, 0.01899674}]}, {{1116.2, 0.01843526}, 
             Offset[{3, 0}, {1116.2, 0.01843526}]}, {{1116.2, 0.01843526}, 
             Offset[{-3, 0}, {1116.2, 0.01843526}]}}], {{{1., 0.}, {0., 
           1.}}, {0., 0.}}]},
        Antialiasing->False]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], 
       StyleBox[{
         GeometricTransformationBox[
          LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
         GeometricTransformationBox[
          LineBox[{{{1140.9, 0.019578335000000002`}, 
             Offset[{3, 0}, {1140.9, 0.019578335000000002`}]}, {{1140.9, 
             0.019578335000000002`}, 
             Offset[{-3, 0}, {1140.9, 0.019578335000000002`}]}, {{1140.9, 
             0.018999665}, Offset[{3, 0}, {1140.9, 0.018999665}]}, {{1140.9, 
             0.018999665}, Offset[{-3, 0}, {1140.9, 0.018999665}]}}], {{{1., 
           0.}, {0., 1.}}, {0., 0.}}]},
        Antialiasing->False]}}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[0.012833333333333334`], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[10]], {{{1045.4, 
      0.017271}}, {{1052.7, 0.017523}}, {{1057.3, 0.017385}}, {{1082.9, 
      0.017959}}, {{1084.2, 0.018096}}, {{1088.3, 0.017821}}, {{1102.5, 
      0.018211}}, {{1116.2, 0.018716}}, {{1140.9, 
      0.019289}}}]}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJwt0g8w1nccB/DnrFxOIn86nX/hWUwW7WrDwqd62jSZTjLC8idjcTIiF5PG
3FMa3w8yQ090/l20eSSx/KsoTDfquXK72p6pnHb+tJaRm91+q/f37nvfe933
vv/en69t1OGAGB2ZTBYp9f/HVy1QkFqmHWgsZO9XDhZU5W8bVn0GDhNUv707
q7QCjhCUOTDhml8NHxRU/vlg8vF6OE7QmuBiRcpFOEGQKiup7rNLcJIgbUF+
WUgHfETQWsNVFrt74HRBm2PXbfTqhzMFLZt+OuryE5wtyPGZ0LUdhXMFUb/H
8Or7sFJQyYi+vc5D+LQgf+Gg/3wcFoKc65pzf5+ESwQ1aQcKR2bgMkFTO9i5
5wVcKejf1U6hFxfhKkHjd1osKmRFr10j6M2wjxKVunCD9J6xVXtTV8JNgtqG
rYYijeFmQW/bldz1M4dbBbm8VXDY3RpuFzRa5aCSy+FOQR90ZhwwdIJ7BXk4
1l566QL3CdI16i5/tAUeEPS1ndb09vvwsKBbpXK7tm3wiDTvWnNd9SGsERSs
OPp3nh88Jmjw6uWuxL3wA0HWa4+aB4XAWkEmGXd0PQ/AjwUpqn5V2sfAk1L+
f6hVevHwlHT/qCif2ST4mZRPx/I8TRr8QpCen/qTjkx4QdCmDce6zn4F/yPI
1zj1ygklLGPySm3bGVMAL2PK+TIgzqcEXsG03yDcZkM5vJJp6drTQwZVsBFT
65y+72wtbMo0dO1ez0gjbM4UJwsfVKthS6ZDH6tji67A65gMDCbKk7tgOZMq
2iA64AbsyLRA7r2bBmFnJrPwjBajn2FXpniPJ+6zGngz0z4HZdDtX2A3pjDv
1BWNWngrU1pCl79yAiamd+O+cI6ZghVMc53Vqm3PYR+myZuf1lktwLuZnC63
73i5BO9h6jrVk6Z5o/i1A5mUNjneP+jBwUxutiaqk4ZwmLTe9HhRtBkcwUSB
9yw9LeCDTFfNHD3X2MJxTPMxOX/NrIcTmN5znve+5QwnMYU4Fdmdewc+Ip2/
FFWR5ganM01bp1/w84IzmfY8/s1froCzmW5kN+Qv7oJzmeyXa8NH/GEl02hE
yc3affBpJsuou/3HQmHBNNN2IdQ/Ei5h8px2UNrHwmVMnBLsO58AVzKd/G5X
7VAyXMUUIFaUnk2Ha6T9489bJWXBDUzf2Mi3bs+Fm6R65ZX/aXIKbpb+x35j
ryeFcCtTqmeZbdsZuJ0pRe1WmVcBdzIpbGTfB1XDvUxyzWLQ+nq4j+mczpZv
55rgAabx6z8m9rXAw1I+JmUPi9rhEak+98ceRXTDGqbzD5QnNvYVe/8H2ALp
TQ==
       "]]}}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1043.4104166666668`, 0.016869357222222447`},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
     TraditionalForm], 
    FormBox["\"\[Eta] (mPa.s)\"", TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Medium,
  LabelStyle->Directive[
    GrayLevel[0], Bold, 14, FontFamily -> "Times New Roman"],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{1043.4104166666668`, 1140.9}, {0.016869357222222447`, 
   0.019578335000000002`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[2]=",
 CellID->205562396,ExpressionUUID->"eb7c2372-7260-45f7-b475-8af626e50a4b"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"21d3a1da-54da-4243-9edd-e0f0962d943d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"caf51473-4804-4c7e-ad27-37558399659d"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"5948a68a-5b8b-475d-9489-7265af20f077"],

Cell[TextData[StyleBox[ButtonBox["etalKVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"etalKVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->234329647,ExpressionUUID->"794f872d-4914-453f-9a67-44ceaad1f98f"],

Cell[TextData[StyleBox[ButtonBox["etaKnuKVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKnuKVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->229631036,ExpressionUUID->"6b12243f-9535-4eb5-8c72-7205da67dd35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"a24a2ff0-acf3-4172-b7e1-0a61df0f2bc6"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"0a7efaad-c0c9-415f-9773-f64bb7fa46c1"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"dbfa4947-50b5-457a-92a5-ee91e379cb18"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "78fcaab5-aa4a-457f-aaeb-df369e7b5830"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"52b958ef-d6e8-49ba-995a-ed3236792fe1"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"16c7da36-ba86-48f5-b7fd-9baf88e9e654"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etaKVap",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 29.3142997}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etaKVap[T, \\[Rho]] Potassium viscosity equation of state \
\\[Eta](T,\\[Rho]) as a function of temperature T and density \\[Rho] for the \
gaseous phase only", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "etaKVap", "titlemodifier" -> "", "windowtitle" -> "etaKVap", "type" -> 
    "Symbol", "uri" -> "EOSPotassium/ref/etaKVap", "WorkflowDockedCell" -> 
    ""}, "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"199f3d77-09af-474f-8fad-ece99665a34b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12035, 335, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"9f91f4c5-f59d-47f8-90f1-eaa06e8893fc",
   CellTags->"PrimaryExamplesSection",
   CellID->106024383]},
 "RasterizedOutput"->{
  Cell[21066, 578, 108588, 1786, 387, "Output",ExpressionUUID->"2a102669-344d-43d0-b063-971d97f9708b",
   CellTags->"RasterizedOutput",
   CellID->127237934]},
 "DefaultUnit"->{
  Cell[132390, 2453, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"044ce6d7-8c49-44ab-b405-60a913dc170d",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 159532, 3142},
 {"RasterizedOutput", 159731, 3146},
 {"DefaultUnit", 159909, 3150}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 3645, 83, 53, "AnchorBarGrid",ExpressionUUID->"816bb3fe-3c94-4b56-a69c-e6dc49322fd7",
 CellID->1],
Cell[CellGroupData[{
Cell[4249, 108, 392, 9, 54, "ObjectNameGrid",ExpressionUUID->"e1ebd587-a201-4bf8-9624-5c1df2f2126a"],
Cell[4644, 119, 880, 24, 134, "Usage",ExpressionUUID->"f022bb68-b892-4ae7-ac8a-a90c1247e80d",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5561, 148, 854, 21, 37, "NotesSection",ExpressionUUID->"2b0301ed-7913-40ee-8db9-5753427b51e4",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->91271344],
Cell[6418, 171, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"ec342330-5319-420c-bcab-784c254f6e31"],
Cell[6507, 173, 263, 6, 70, "Notes",ExpressionUUID->"70718879-fc87-45d5-ad0f-b00baa92bcd8",
 CellID->78345116],
Cell[6773, 181, 1517, 53, 70, "Notes",ExpressionUUID->"1547ac17-52cc-4f2f-b84e-fae94bbc8497",
 CellID->819145981],
Cell[8293, 236, 352, 9, 70, "Notes",ExpressionUUID->"4d1be774-1303-4e43-82cd-9d16ba00f02d",
 CellID->186809512],
Cell[8648, 247, 381, 10, 70, "Notes",ExpressionUUID->"8787349b-e5b4-4c49-b18b-160fe22d275f",
 CellID->487713575],
Cell[9032, 259, 742, 17, 70, "3ColumnTableMod",ExpressionUUID->"32454fe9-46c8-42cd-81eb-4004d5fe27c0",
 CellID->716128471],
Cell[9777, 278, 127, 1, 70, "Notes",ExpressionUUID->"5dbd4580-b74a-4d5e-ace3-848873beef26",
 CellID->46888620],
Cell[9907, 281, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"6094ae00-9f2f-4c09-b277-c6fc9290f633",
 CellID->505732368],
Cell[11912, 330, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"3d126378-8527-40e3-8d0c-9c32448d1ceb"]
}, Closed]],
Cell[CellGroupData[{
Cell[12035, 335, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"9f91f4c5-f59d-47f8-90f1-eaa06e8893fc",
 CellTags->"PrimaryExamplesSection",
 CellID->106024383],
Cell[CellGroupData[{
Cell[12495, 350, 308, 7, 30, "ExampleSection",ExpressionUUID->"0f6f72f6-128c-4e33-a44e-922ba90e72a0",
 CellID->257715155],
Cell[12806, 359, 175, 3, 27, "Input",ExpressionUUID->"864b69c8-c28d-41ea-ae15-e3225b2941aa",
 CellID->87419684],
Cell[12984, 364, 329, 5, 76, "ExampleText",ExpressionUUID->"1808cd1a-31bb-4849-8304-41e44dd63e22",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13338, 373, 965, 27, 97, "Input",ExpressionUUID->"991e4ba4-1c1b-4602-8551-2e0ad88fc531",
 CellID->218515404],
Cell[14306, 402, 146, 2, 36, "Output",ExpressionUUID->"ef0140c5-f4d5-402e-8a4d-7b722f0fc36e",
 CellID->111090836],
Cell[14455, 406, 222, 5, 43, "Output",ExpressionUUID->"6f46e1fa-257f-4059-82c5-bba4a2c8fe4a",
 CellID->622232654],
Cell[14680, 413, 221, 5, 43, "Output",ExpressionUUID->"a4e22377-9461-461a-8525-7ca1b4a46b5a",
 CellID->49547472]
}, Open  ]],
Cell[CellGroupData[{
Cell[14938, 423, 361, 8, 27, "Input",ExpressionUUID->"984d9298-e5d3-45e8-83d6-2abb6be13106",
 CellID->273227049],
Cell[15302, 433, 304, 6, 43, "Output",ExpressionUUID->"d12dfa9a-fef5-4783-9021-b7c36cb06197",
 CellID->583835131]
}, Open  ]],
Cell[15621, 442, 295, 5, 70, "ExampleText",ExpressionUUID->"0656515d-fdd1-4381-8353-1cb02ba28b30",
 CellID->20254794],
Cell[CellGroupData[{
Cell[15941, 451, 5122, 125, 70, "Input",ExpressionUUID->"fe762040-c531-4902-8591-a62dcd1a0876",
 CellID->801374019],
Cell[21066, 578, 108588, 1786, 387, "Output",ExpressionUUID->"2a102669-344d-43d0-b063-971d97f9708b",
 CellTags->"RasterizedOutput",
 CellID->127237934]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129703, 2370, 323, 7, 70, "ExampleSection",ExpressionUUID->"480fa00a-d62d-4c3b-9b41-5c6dcbf021e8",
 CellID->1020263627],
Cell[130029, 2379, 601, 16, 70, "ExampleText",ExpressionUUID->"ab14e25a-8614-42c6-b761-3c2d7dc652d3",
 CellID->111367501],
Cell[CellGroupData[{
Cell[130655, 2399, 910, 23, 70, "Input",ExpressionUUID->"14af51de-e763-4709-9212-5a4241cdebfe",
 CellID->138125379],
Cell[131568, 2424, 222, 5, 43, "Output",ExpressionUUID->"2bb38594-87ac-4611-8ffb-b3a716e5c43d",
 CellID->303219662],
Cell[131793, 2431, 221, 5, 43, "Output",ExpressionUUID->"4bc82b9d-fd24-487a-b7a1-b75d04906afe",
 CellID->433461320]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[132063, 2442, 302, 7, 70, "ExampleSection",ExpressionUUID->"332dd187-d5a9-497d-83e8-6ac584e3ef48",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[132390, 2453, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"044ce6d7-8c49-44ab-b405-60a913dc170d",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[132736, 2463, 229, 4, 70, "ExampleText",ExpressionUUID->"85606272-51fe-414e-9d76-0ff8bfa828f9",
 CellID->300166705],
Cell[CellGroupData[{
Cell[132990, 2471, 1550, 40, 70, "Input",ExpressionUUID->"9d8d844b-a0e9-4c26-bbfd-7604bd4f39b6",
 CellID->643121792],
Cell[134543, 2513, 143, 2, 35, "Output",ExpressionUUID->"e341b737-57da-4609-8cf5-cce93aa8546b",
 CellID->83254926],
Cell[134689, 2517, 306, 6, 45, "Output",ExpressionUUID->"e84e4261-2860-44f5-a680-446e7e43c700",
 CellID->885708294],
Cell[134998, 2525, 305, 6, 45, "Output",ExpressionUUID->"b272be56-2195-4848-a830-9f479ff80d9d",
 CellID->47424278]
}, Open  ]],
Cell[135318, 2534, 127, 1, 70, "ExampleText",ExpressionUUID->"c9eda9b4-3ec7-4755-ae8a-b9483550cd4d",
 CellID->195019342],
Cell[CellGroupData[{
Cell[135470, 2539, 1269, 35, 70, "Input",ExpressionUUID->"4745f20e-8e5c-43c3-8ef5-3c39b5884dbc",
 CellID->110075696],
Cell[136742, 2576, 144, 2, 35, "Output",ExpressionUUID->"94e64e4b-3b56-4d97-863b-1f0077c1ae22",
 CellID->378804468],
Cell[136889, 2580, 306, 6, 45, "Output",ExpressionUUID->"2baa3e85-0018-4cfa-96e1-4ebc8ec08a62",
 CellID->299114135],
Cell[137198, 2588, 306, 6, 45, "Output",ExpressionUUID->"6f76e8b2-9197-4954-b02d-f6f41272310a",
 CellID->189938923]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[137565, 2601, 306, 7, 70, "ExampleSection",ExpressionUUID->"d1af4d80-bd25-4f3a-9e08-517fcbf963ca",
 CellID->258228157],
Cell[137874, 2610, 271, 8, 70, "ExampleText",ExpressionUUID->"bca6b0d7-190f-4c27-8c5b-1b40c47769c9",
 CellID->101130033],
Cell[138148, 2620, 3163, 91, 70, "Input",ExpressionUUID->"c2a001b2-84f2-42af-be60-0a27c22684ad",
 CellID->146313261],
Cell[CellGroupData[{
Cell[141336, 2715, 2767, 80, 70, "Input",ExpressionUUID->"3a3a0ef0-2e51-4826-9a18-1f0b1fa6ddb9",
 CellID->69869692],
Cell[144106, 2797, 11601, 238, 241, "Output",ExpressionUUID->"eb7c2372-7260-45f7-b475-8af626e50a4b",
 CellID->205562396]
}, Open  ]]
}, Closed]],
Cell[155734, 3039, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"21d3a1da-54da-4243-9edd-e0f0962d943d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155857, 3044, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"5948a68a-5b8b-475d-9489-7265af20f077",
 CellID->1255426704],
Cell[156120, 3053, 218, 4, 70, "SeeAlso",ExpressionUUID->"794f872d-4914-453f-9a67-44ceaad1f98f",
 CellID->234329647],
Cell[156341, 3059, 222, 4, 70, "SeeAlso",ExpressionUUID->"6b12243f-9535-4eb5-8c72-7205da67dd35",
 CellID->229631036]
}, Open  ]],
Cell[CellGroupData[{
Cell[156600, 3068, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"0a7efaad-c0c9-415f-9773-f64bb7fa46c1",
 CellID->1584193535],
Cell[156873, 3077, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"dbfa4947-50b5-457a-92a5-ee91e379cb18"],
Cell[156962, 3079, 384, 10, 70, "RelatedLinks",ExpressionUUID->"52b958ef-d6e8-49ba-995a-ed3236792fe1",
 CellID->426751138]
}, Open  ]],
Cell[157361, 3092, 78, 0, 70, "FooterCell",ExpressionUUID->"16c7da36-ba86-48f5-b7fd-9baf88e9e654"]
}
]
*)

(* End of internal cache information *)

