(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32313,        806]
NotebookOptionsPosition[     24863,        645]
NotebookOutlinePosition[     27442,        710]
CellTagsIndexPosition[     27327,        704]
WindowTitle->etaKnuK1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "1e9ae280-0f36-4d4b-a363-3385c641fae0"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"bfb627d0-9d45-450f-8e62-af5182be6559"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaK1atm\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaK1atm.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "e1c35ead-d131-4fa6-a28d-62cbbd9e46bd"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"aa52e754-2a85-45ce-9957-2fcbd3f103fc"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etaKnuK1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etaKnuK1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etaKnuK1atm.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$19334], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etaKnuK1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "7ccb8fd2-98be-4297-a90d-4174a32acb46"]
    }], "AnchorBar",ExpressionUUID->"7db87502-ffad-458d-9c5d-10a56e61315a"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"5cde7a4e-4667-4f1a-949f-e205df4b2a56"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etaKnuK1atm", "ObjectName",ExpressionUUID->
  "867f0fa2-3e2b-4efe-8d89-97e98882530e"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"9cf3d246-68ad-4fe2-8ca6-03e67e45d76f"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "c62ccfe9-a43e-4a2f-8920-e48edc20f4c4"]
}], "ObjectNameGrid",ExpressionUUID->"2f939dce-b977-409c-8f5a-dd092b76cfd7"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etaKnuK1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "a409847d-13c7-47d4-9f8e-8b77549c25af"],
     " \[LineSeparator]Potassium viscosity Knudsen term ",
     Cell[BoxData[
      SubscriptBox["\[Eta]", "Knu"]],ExpressionUUID->
      "618b76d7-b3af-47c7-a17b-6de529fc589a"],
     " as a function of temperature ",
     StyleBox["T ",
      FontSlant->"Italic"],
     "along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"e59486aa-72f8-415a-9e7f-eb7d5d25bc7f"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"adabcee8-ef23-407f-a2d9-a7d28aac490e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"eaef926f-ac90-4ae3-97a6-67c9261b6be7"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"40f73e94-19b8-4eb2-af08-44ca9e5d272b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"b31f1c30-44df-4d07-b034-36062ebf3eda"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->273002233,ExpressionUUID->"4ab63b7e-ac8f-4a8c-a02c-da172e19b76e"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"9b70836a-d2d8-45e6-89db-833619bb7d3e"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
 "1030.793"], "InlineFormula",ExpressionUUID->
  "f5827086-2a5e-4734-aceb-c1ffc2cda102"],
 " K"
}], "Notes",
 CellID->206839001,ExpressionUUID->"139955a0-9a80-42d1-b93a-fae859b08b4d"],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   OverscriptBox["\[Rho]", "~"], "Knu"]], "InlineFormula",ExpressionUUID->
  "4d54f768-74ce-45b0-a693-5103cb9e6ec0"],
 " is calculated by using the parameters adapted for Chiong's data "
}], "Notes",
 CellID->251951018,ExpressionUUID->"2828ca10-ee7e-46e9-ba3d-acbf2939f179"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin"
}], "Notes",
 CellID->186809512,ExpressionUUID->"12fb4ba8-eb4d-4619-a032-4ebe251645f8"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "Knu"]], "InlineFormula",ExpressionUUID->
  "5f7f54c3-22df-4147-ad56-3cbded459b82"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"0f31304c-db4b-4371-9b7b-a19c4065a377"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "eed79b2b-7874-4b60-8146-72f493fa6314"], 
    ButtonBox[
     ButtonBox["etaK1atmDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaK1atmDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"83860148-db5e-4e46-a69a-5721b3026a0a"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"7ba7aeeb-e443-4d1a-83a7-a1148febad40"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"d45da5c0-5e81-4029-901e-a5c341777186"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"5b19eca7-612b-4297-85d4-6cdeb9d8511d"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "7b6760d0-99ad-4595-8212-3adfe51f8799"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->282695136,ExpressionUUID->"79c6e8ac-c9e0-44df-a7ff-f975cf6fdc1a"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "b5930ca7-0d55-4e59-a98d-fdb5d0e91805"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->857000038,ExpressionUUID->"ef5a131b-08a1-465e-945a-99226a079111"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"eaac6aa5-eda5-4470-b517-4ad0d8a80965"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"901f0d20-2d89-4685-b775-67b4302376e2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKnuK1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"6964fe5a-e5be-4ea0-8c89-7dc1a3b0cb5f"],

Cell[BoxData["0.18832401168549745`"], "Output",
 CellLabel->"Out[2]=",
 CellID->501404,ExpressionUUID->"59c7eaf4-3113-44be-b641-baa613ce37ea"],

Cell[BoxData[
 TemplateBox[{
  "0.18832401168549745`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->864373004,ExpressionUUID->"a2d83192-0c10-4648-925b-3564b9cb4e4b"],

Cell[BoxData[
 TemplateBox[{
  "0.18832401168549745`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->213005815,ExpressionUUID->"6cfa01bb-c971-4a7b-a449-12b29835b348"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.18832401168549745`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"676421ce-92c7-43c8-a28e-219cf07989e4"],

Cell[BoxData[
 TemplateBox[{"0.18832401168549745`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->220551168,ExpressionUUID->"7737ac97-8fdf-4806-b403-c413cd5e711a"]
}, Open  ]],

Cell["\<\
Plot of the Knudsen viscosity term from the melting point to the boiling \
point along the atmospheric isobar\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"ba4c8025-c5c8-4a03-bdce-c9d2bcd8ce0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"etaKnuK1atm", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(\[Eta]\), \(Knu\)]\) (mPa.s)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->562653754,ExpressionUUID->"2c38cbea-3285-4921-8fe2-ec7fa1ef3989"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk4VV0XAHBTCqEyZB6KQvKVMVF7kRQSGRpMiZIkQ7lEZhnvPedeKqJM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       "]]},
     Annotation[#, "Charting`Private`Tag$22259#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0.18772746973245993`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(\[Eta]\\), \\(Knu\\)]\\) (mPa.s)\"", 
      TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {0.18772746973245993`, 0.4972622119366044}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->9826913,ExpressionUUID->"72967e18-1654-4e53-b931-67c0faa800c8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2dd22ff6-18ca-448f-ae0e-4fef9bd323d6"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"630083d5-4c85-48fc-bd91-08f02a947714"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaK1atmDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "d9afea14-6141-4c94-be16-172a0a496c4f"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"153844f9-1ac2-411d-b4dc-d08c3065ace2"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaK1atmDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"d54d84b2-70c5-43e0-9e27-e934160c0856"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKnuK1atm", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"6a9f455f-5a3e-49d0-9110-2fca172e6d43"],

Cell[BoxData["188.32401168549745`"], "Output",
 CellLabel->"Out[1]=",
 CellID->88100096,ExpressionUUID->"9f334e18-8b6f-44c8-9b00-fe65eb659397"],

Cell[BoxData[
 TemplateBox[{"188.32401168549745`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->31430912,ExpressionUUID->"48f1d864-d0ab-4fc0-96b8-49086aec7b36"],

Cell[BoxData[
 TemplateBox[{"188.32401168549745`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->95888699,ExpressionUUID->"8ce60ff9-80fc-4f8a-9cde-b1c8b95be56a"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"fe75fc47-3bcd-4d32-99c9-61d053df44e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"11d0c7dc-158f-455c-8a9c-1d6470827332"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"d4eac30f-5cb8-4906-9e60-17cf2787c9b7"],

Cell[TextData[StyleBox[ButtonBox["etaK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->366041956,ExpressionUUID->"91464e64-fa07-4f62-a816-8a24651cff1e"],

Cell[TextData[StyleBox[ButtonBox["RhoKnu1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"RhoKnu1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->207443811,ExpressionUUID->"1a2d84ad-97b3-43e9-bfa0-c45fdf11065d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"50fa94a5-c14d-4f23-a2e8-b8f455472d3c"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"1e61850a-0631-4086-b641-69fdc01e2f89"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"12847264-3b63-4a9b-98b2-046cbf8dae1c"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "4fed8120-3470-48fd-8d7d-da76b51377b0"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"12592b40-7cc5-4e75-bc81-8eb017c9cd17"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"bc0928d9-6dea-4d23-8e1d-a78204dc3edc"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etaKnuK1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 25.1582975}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etaKnuK1atm[T] Potassium viscosity Knudsen term \\[Eta]Knu as a function \
of temperature T along the atmospheric isobar in the liquid phase", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "etaKnuK1atm", 
    "titlemodifier" -> "", "windowtitle" -> "etaKnuK1atm", "type" -> "Symbol",
     "uri" -> "EOSPotassium/ref/etaKnuK1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"731c0f8c-c813-4b93-acce-4f10f0ab64e2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8661, 237, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"79c6e8ac-c9e0-44df-a7ff-f975cf6fdc1a",
   CellTags->"PrimaryExamplesSection",
   CellID->282695136]},
 "DefaultUnit"->{
  Cell[20610, 518, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"153844f9-1ac2-411d-b4dc-d08c3065ace2",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26953, 693},
 {"DefaultUnit", 27146, 697}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[583, 21, 3663, 83, 53, "AnchorBarGrid",ExpressionUUID->"5cde7a4e-4667-4f1a-949f-e205df4b2a56",
 CellID->1],
Cell[CellGroupData[{
Cell[4271, 108, 396, 9, 54, "ObjectNameGrid",ExpressionUUID->"2f939dce-b977-409c-8f5a-dd092b76cfd7"],
Cell[4670, 119, 801, 19, 134, "Usage",ExpressionUUID->"adabcee8-ef23-407f-a2d9-a7d28aac490e",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5508, 143, 855, 21, 37, "NotesSection",ExpressionUUID->"4ab63b7e-ac8f-4a8c-a02c-da172e19b76e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->273002233],
Cell[6366, 166, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"9b70836a-d2d8-45e6-89db-833619bb7d3e"],
Cell[6455, 168, 407, 14, 70, "Notes",ExpressionUUID->"139955a0-9a80-42d1-b93a-fae859b08b4d",
 CellID->206839001],
Cell[6865, 184, 321, 7, 70, "Notes",ExpressionUUID->"2828ca10-ee7e-46e9-ba3d-acbf2939f179",
 CellID->251951018],
Cell[7189, 193, 193, 6, 70, "Notes",ExpressionUUID->"12fb4ba8-eb4d-4619-a032-4ebe251645f8",
 CellID->186809512],
Cell[7385, 201, 403, 10, 70, "Notes",ExpressionUUID->"0f31304c-db4b-4371-9b7b-a19c4065a377",
 CellID->487713575],
Cell[7791, 213, 744, 17, 70, "3ColumnTableMod",ExpressionUUID->"7ba7aeeb-e443-4d1a-83a7-a1148febad40",
 CellID->716128471],
Cell[8538, 232, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"d45da5c0-5e81-4029-901e-a5c341777186"]
}, Closed]],
Cell[CellGroupData[{
Cell[8661, 237, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"79c6e8ac-c9e0-44df-a7ff-f975cf6fdc1a",
 CellTags->"PrimaryExamplesSection",
 CellID->282695136],
Cell[CellGroupData[{
Cell[9121, 252, 308, 7, 30, "ExampleSection",ExpressionUUID->"ef5a131b-08a1-465e-945a-99226a079111",
 CellID->857000038],
Cell[9432, 261, 175, 3, 27, "Input",ExpressionUUID->"eaac6aa5-eda5-4470-b517-4ad0d8a80965",
 CellID->87419684],
Cell[9610, 266, 298, 5, 57, "ExampleText",ExpressionUUID->"901f0d20-2d89-4685-b775-67b4302376e2",
 CellID->544149791],
Cell[CellGroupData[{
Cell[9933, 275, 505, 12, 60, "Input",ExpressionUUID->"6964fe5a-e5be-4ea0-8c89-7dc1a3b0cb5f",
 CellID->218515404],
Cell[10441, 289, 142, 2, 36, "Output",ExpressionUUID->"59c7eaf4-3113-44be-b641-baa613ce37ea",
 CellID->501404],
Cell[10586, 293, 221, 5, 43, "Output",ExpressionUUID->"a2d83192-0c10-4648-925b-3564b9cb4e4b",
 CellID->864373004],
Cell[10810, 300, 221, 5, 43, "Output",ExpressionUUID->"6cfa01bb-c971-4a7b-a449-12b29835b348",
 CellID->213005815]
}, Open  ]],
Cell[CellGroupData[{
Cell[11068, 310, 360, 8, 27, "Input",ExpressionUUID->"676421ce-92c7-43c8-a28e-219cf07989e4",
 CellID->273227049],
Cell[11431, 320, 303, 6, 43, "Output",ExpressionUUID->"7737ac97-8fdf-4806-b403-c413cd5e711a",
 CellID->220551168]
}, Open  ]],
Cell[11749, 329, 215, 4, 57, "ExampleText",ExpressionUUID->"ba4c8025-c5c8-4a03-bdce-c9d2bcd8ce0e",
 CellID->119396994],
Cell[CellGroupData[{
Cell[11989, 337, 615, 15, 70, "Input",ExpressionUUID->"2c38cbea-3285-4921-8fe2-ec7fa1ef3989",
 CellID->562653754],
Cell[12607, 354, 7627, 147, 249, "Output",ExpressionUUID->"72967e18-1654-4e53-b931-67c0faa800c8",
 CellID->9826913]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20283, 507, 302, 7, 70, "ExampleSection",ExpressionUUID->"630083d5-4c85-48fc-bd91-08f02a947714",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[20610, 518, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"153844f9-1ac2-411d-b4dc-d08c3065ace2",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[20957, 528, 230, 4, 70, "ExampleText",ExpressionUUID->"d54d84b2-70c5-43e0-9e27-e934160c0856",
 CellID->300166705],
Cell[CellGroupData[{
Cell[21212, 536, 1141, 29, 70, "Input",ExpressionUUID->"6a9f455f-5a3e-49d0-9110-2fca172e6d43",
 CellID->643121792],
Cell[22356, 567, 143, 2, 35, "Output",ExpressionUUID->"9f334e18-8b6f-44c8-9b00-fe65eb659397",
 CellID->88100096],
Cell[22502, 571, 305, 6, 45, "Output",ExpressionUUID->"48f1d864-d0ab-4fc0-96b8-49086aec7b36",
 CellID->31430912],
Cell[22810, 579, 305, 6, 45, "Output",ExpressionUUID->"8ce60ff9-80fc-4f8a-9cde-b1c8b95be56a",
 CellID->95888699]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[23154, 590, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"fe75fc47-3bcd-4d32-99c9-61d053df44e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23277, 595, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"d4eac30f-5cb8-4906-9e60-17cf2787c9b7",
 CellID->1255426704],
Cell[23540, 604, 218, 4, 70, "SeeAlso",ExpressionUUID->"91464e64-fa07-4f62-a816-8a24651cff1e",
 CellID->366041956],
Cell[23761, 610, 222, 4, 70, "SeeAlso",ExpressionUUID->"1a2d84ad-97b3-43e9-bfa0-c45fdf11065d",
 CellID->207443811]
}, Open  ]],
Cell[CellGroupData[{
Cell[24020, 619, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"1e61850a-0631-4086-b641-69fdc01e2f89",
 CellID->1584193535],
Cell[24293, 628, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"12847264-3b63-4a9b-98b2-046cbf8dae1c"],
Cell[24382, 630, 384, 10, 70, "RelatedLinks",ExpressionUUID->"12592b40-7cc5-4e75-bc81-8eb017c9cd17",
 CellID->426751138]
}, Open  ]],
Cell[24781, 643, 78, 0, 70, "FooterCell",ExpressionUUID->"bc0928d9-6dea-4d23-8e1d-a78204dc3edc"]
}
]
*)

(* End of internal cache information *)

