(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31877,        806]
NotebookOptionsPosition[     24560,        647]
NotebookOutlinePosition[     27114,        712]
CellTagsIndexPosition[     26999,        706]
WindowTitle->etaKnuKVap
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "9fe71551-77eb-4071-8875-de5d58a17450"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"a9df9eae-36e5-4a04-aa5a-658171d466a7"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaKVap\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaKVap.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f5afee1a-d8f6-435a-8c6c-cb3b0826b67f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"31c6ac2b-a437-4003-b16d-f6f908a342f7"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etaKnuKVap\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etaKnuKVap"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etaKnuKVap.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$19736], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etaKnuKVap", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1f73d717-47c6-4947-8a25-c0c9640cfc55"]
    }], "AnchorBar",ExpressionUUID->"4d93668e-1849-445a-9067-ee27f809fcf2"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"9871c2ba-6d07-4273-80e1-9c967d49332b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etaKnuKVap", "ObjectName",ExpressionUUID->
  "80565d76-d429-41d5-bc83-178aec782dd0"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"b13bf560-0792-418c-94bf-80c4ec0466f1"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "2de6ba62-4baf-4980-871f-4134a7ea398f"]
}], "ObjectNameGrid",ExpressionUUID->"8b5f26a4-3d74-415c-903e-6b1181669ecd"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etaKnuKVap", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", 
        StyleBox["\[Rho]",
         FontSlant->"Italic"]}], "]"}]], "InlineFormula",ExpressionUUID->
      "2d8d07ad-bd3f-422b-b524-f89de8890ad5"],
     " \[LineSeparator]Potassium viscosity Knudsen term ",
     Cell[BoxData[
      SubscriptBox["\[Eta]", "Knu"]],ExpressionUUID->
      "7f97e017-0968-41b6-a7c8-b5fb81384e18"],
     " as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " and density ",
     StyleBox["\[Rho]",
      FontSlant->"Italic"]
    }],ExpressionUUID->"e62c51cf-6e51-436b-bd19-6da8b552defc"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"e41cabea-77cc-4ac3-9224-79f7ee97f187"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"48117eb5-ce27-4241-88d2-520602bb7208"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"22ee8fd5-e446-484c-9ae2-c0cced85fdf0"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"414d2243-abb5-46b7-a58e-8832924c1b5e"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->131161472,ExpressionUUID->"e3b5d97d-b53b-4be6-aa32-a108c5cfecc7"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a9fe82a5-9b42-4953-a00d-2da6d6a85828"],

Cell[TextData[{
 "The function is defined for 900 \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] 1600 K but it can be extrapolated to lower temperatures"
}], "Notes",
 CellID->448466880,ExpressionUUID->"d03777e6-51ee-4d62-8d3c-cacc9d8d5e6f"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin and the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "deeb853a-10e2-4666-8a6c-5c0767000e2f"]
}], "Notes",
 CellID->186809512,ExpressionUUID->"a554a7ef-b527-4c58-811c-cf1f8fe8ce8a"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "Knu"]], "InlineFormula",ExpressionUUID->
  "89589a51-15e3-4447-928c-3f8c5eb57ae1"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"0b85bf3a-5948-465f-8086-4031f628e804"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "17282ab2-7276-4522-ab7c-d831bed05247"], 
    ButtonBox[
     ButtonBox["etaKVapDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaKVapDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"6334e958-0f2c-4dcb-80b7-93a88b53b1c2"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"048870e8-d1b3-46d4-9e44-70fb47796a0f"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"d19f9ec0-6ce0-4d01-a825-daf44f35df1a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c60e5b02-8276-4e97-b961-e2f76c9f8185"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "9e1afb28-2ac4-4bf7-b7d8-d020f04c51f0"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->102210005,ExpressionUUID->"13cbe898-0592-4437-98a5-966ad0d0fd38"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e7cc47ae-c314-4345-b257-f2bbedc055a5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->555462661,ExpressionUUID->"121912e3-ad24-471d-874f-6cb47299e5cf"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"0ae7c0ab-a236-4ca9-8a73-bd83d9ca0bce"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable and/or to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"9f9be40e-ca73-4df7-99f5-ed4e78f7a2d0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"f4006a4c-9b91-48a4-98d7-0493f87623c1"],

Cell[BoxData["0.014633199453967825`"], "Output",
 CellLabel->"Out[2]=",
 CellID->605555496,ExpressionUUID->"1282c79e-37c1-4f53-919d-e1320e44cf3a"],

Cell[BoxData[
 TemplateBox[{
  "0.014633199453967825`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->85297070,ExpressionUUID->"ba968794-b6bf-4e3e-8456-14025eec0224"],

Cell[BoxData[
 TemplateBox[{
  "0.014633199453967825`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->178814348,ExpressionUUID->"fa2474f2-9ba4-4fb2-b2d7-33a8f8d506cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.014633199453967825`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"55416153-89bc-454e-9993-10241c9ef1bb"],

Cell[BoxData[
 TemplateBox[{"0.014633199453967825`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->163234876,ExpressionUUID->"7a94a854-a8d7-48a5-b7b8-aa00efa0d340"]
}, Open  ]],

Cell["\<\
Plot of the Knudsen viscosity term using densities calculated along the vapor \
coexistence curve\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"af0d841a-542b-42a7-a82f-cf2b5ae06dbc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"etaKnuKVap", "[", 
    RowBox[{"T", ",", 
     RowBox[{"RhoSatVapK", "[", "T", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "900", ",", "1600"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(\[Eta]\), \(Knu\)]\) (mPa.s)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->448865624,ExpressionUUID->"4c5a3469-11ff-4f41-85fc-f53aecbbdb00"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk0Vd8XAHBD4RdJEaVQyVRkimTobAqFShGZGmRIpZKMpcG3EM/83r2n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       "]]},
     Annotation[#, "Charting`Private`Tag$9314#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{900., 0.012022876534025236`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(\[Eta]\\), \\(Knu\\)]\\) (mPa.s)\"", 
      TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{900, 1600}, {0.012022876534025236`, 0.021831566777152353`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->250035031,ExpressionUUID->"a27bb6c5-b30e-47aa-9ea2-c04b7158b06c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "bc021afb-913e-4253-8c27-137494a0fc57"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"69913e0b-71bd-47e3-b967-22fa6b796bfd"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaKVapDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fbe84102-016c-4087-b53d-f1fe5cafbf9d"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"8d9b67d4-19aa-43cd-8505-ce41b96e736b"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaKVapDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"ba98bbe6-7537-440c-879c-300a17bd1fa5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etaKnuKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"8ed52a55-8b99-4a14-b08e-9444defe2f47"],

Cell[BoxData["14.633199453967825`"], "Output",
 CellLabel->"Out[1]=",
 CellID->54101791,ExpressionUUID->"14534d2f-0f6b-4c8a-a53d-255e56b0e7d3"],

Cell[BoxData[
 TemplateBox[{"14.633199453967825`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->708741855,ExpressionUUID->"13fd3c34-3721-4560-9fa5-3e8546734371"],

Cell[BoxData[
 TemplateBox[{"14.633199453967825`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->180793428,ExpressionUUID->"6eb75544-72aa-4b43-b43e-02b516d5e1c4"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"aafaa0de-1f95-4b4b-b4b7-6a8f1e47dac1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"eab6e7ac-f99f-442c-8d3a-59d1003cc073"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"4eaf3a73-4250-46aa-880d-2f24c271bdc4"],

Cell[TextData[StyleBox[ButtonBox["etaKVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->366041956,ExpressionUUID->"b3eb4b87-de4d-47b6-b3e5-585d2cc7e22d"],

Cell[TextData[StyleBox[ButtonBox["RhoKnuVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"RhoKnuVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->207443811,ExpressionUUID->"43539282-4a7b-49d0-be9e-7095f2667b63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"bd1daa3c-bcee-401c-8730-9c73cced6a4a"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"c18f72c3-e364-41cf-950d-796052283a3c"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"662be463-6137-4cab-9f2b-f4ccd4b73d43"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "7c52b697-d10c-4c54-95ef-fd6be8231bef"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"06ce12ed-2745-4403-9a9c-344b276fe1b3"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"6dbc75e8-2cb7-4f2b-9910-aa4b7d334434"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etaKnuKVap",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 27.0892993}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etaKnuKVap[T, \\[Rho]] Potassium viscosity Knudsen term \\[Eta]Knu as a \
function of temperature T and density \\[Rho]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "etaKnuKVap", "titlemodifier" -> "", 
    "windowtitle" -> "etaKnuKVap", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/etaKnuKVap", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"14296d77-c5a8-4052-a540-d75d2dca1467"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8438, 228, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"13cbe898-0592-4437-98a5-966ad0d0fd38",
   CellTags->"PrimaryExamplesSection",
   CellID->102210005]},
 "DefaultUnit"->{
  Cell[19893, 509, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"8d9b67d4-19aa-43cd-8505-ce41b96e736b",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26625, 695},
 {"DefaultUnit", 26818, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 3653, 83, 53, "AnchorBarGrid",ExpressionUUID->"9871c2ba-6d07-4273-80e1-9c967d49332b",
 CellID->1],
Cell[CellGroupData[{
Cell[4260, 108, 395, 9, 54, "ObjectNameGrid",ExpressionUUID->"8b5f26a4-3d74-415c-903e-6b1181669ecd"],
Cell[4658, 119, 900, 24, 112, "Usage",ExpressionUUID->"e41cabea-77cc-4ac3-9224-79f7ee97f187",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5595, 148, 855, 21, 37, "NotesSection",ExpressionUUID->"e3b5d97d-b53b-4be6-aa32-a108c5cfecc7",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->131161472],
Cell[6453, 171, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a9fe82a5-9b42-4953-a00d-2da6d6a85828"],
Cell[6542, 173, 264, 6, 70, "Notes",ExpressionUUID->"d03777e6-51ee-4d62-8d3c-cacc9d8d5e6f",
 CellID->448466880],
Cell[6809, 181, 352, 9, 70, "Notes",ExpressionUUID->"a554a7ef-b527-4c58-811c-cf1f8fe8ce8a",
 CellID->186809512],
Cell[7164, 192, 403, 10, 70, "Notes",ExpressionUUID->"0b85bf3a-5948-465f-8086-4031f628e804",
 CellID->487713575],
Cell[7570, 204, 742, 17, 70, "3ColumnTableMod",ExpressionUUID->"048870e8-d1b3-46d4-9e44-70fb47796a0f",
 CellID->716128471],
Cell[8315, 223, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"d19f9ec0-6ce0-4d01-a825-daf44f35df1a"]
}, Closed]],
Cell[CellGroupData[{
Cell[8438, 228, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"13cbe898-0592-4437-98a5-966ad0d0fd38",
 CellTags->"PrimaryExamplesSection",
 CellID->102210005],
Cell[CellGroupData[{
Cell[8898, 243, 308, 7, 30, "ExampleSection",ExpressionUUID->"121912e3-ad24-471d-874f-6cb47299e5cf",
 CellID->555462661],
Cell[9209, 252, 175, 3, 27, "Input",ExpressionUUID->"0ae7c0ab-a236-4ca9-8a73-bd83d9ca0bce",
 CellID->87419684],
Cell[9387, 257, 329, 5, 76, "ExampleText",ExpressionUUID->"9f9be40e-ca73-4df7-99f5-ed4e78f7a2d0",
 CellID->544149791],
Cell[CellGroupData[{
Cell[9741, 266, 974, 27, 97, "Input",ExpressionUUID->"f4006a4c-9b91-48a4-98d7-0493f87623c1",
 CellID->218515404],
Cell[10718, 295, 146, 2, 36, "Output",ExpressionUUID->"1282c79e-37c1-4f53-919d-e1320e44cf3a",
 CellID->605555496],
Cell[10867, 299, 221, 5, 43, "Output",ExpressionUUID->"ba968794-b6bf-4e3e-8456-14025eec0224",
 CellID->85297070],
Cell[11091, 306, 222, 5, 43, "Output",ExpressionUUID->"fa2474f2-9ba4-4fb2-b2d7-33a8f8d506cb",
 CellID->178814348]
}, Open  ]],
Cell[CellGroupData[{
Cell[11350, 316, 361, 8, 27, "Input",ExpressionUUID->"55416153-89bc-454e-9993-10241c9ef1bb",
 CellID->273227049],
Cell[11714, 326, 304, 6, 43, "Output",ExpressionUUID->"7a94a854-a8d7-48a5-b7b8-aa00efa0d340",
 CellID->163234876]
}, Open  ]],
Cell[12033, 335, 203, 4, 38, "ExampleText",ExpressionUUID->"af0d841a-542b-42a7-a82f-cf2b5ae06dbc",
 CellID->119396994],
Cell[CellGroupData[{
Cell[12261, 343, 674, 17, 70, "Input",ExpressionUUID->"4c5a3469-11ff-4f41-85fc-f53aecbbdb00",
 CellID->448865624],
Cell[12938, 362, 6579, 130, 243, "Output",ExpressionUUID->"a27bb6c5-b30e-47aa-9ea2-c04b7158b06c",
 CellID->250035031]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19566, 498, 302, 7, 70, "ExampleSection",ExpressionUUID->"69913e0b-71bd-47e3-b967-22fa6b796bfd",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[19893, 509, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"8d9b67d4-19aa-43cd-8505-ce41b96e736b",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[20239, 519, 229, 4, 70, "ExampleText",ExpressionUUID->"ba98bbe6-7537-440c-879c-300a17bd1fa5",
 CellID->300166705],
Cell[CellGroupData[{
Cell[20493, 527, 1559, 40, 70, "Input",ExpressionUUID->"8ed52a55-8b99-4a14-b08e-9444defe2f47",
 CellID->643121792],
Cell[22055, 569, 143, 2, 35, "Output",ExpressionUUID->"14534d2f-0f6b-4c8a-a53d-255e56b0e7d3",
 CellID->54101791],
Cell[22201, 573, 306, 6, 45, "Output",ExpressionUUID->"13fd3c34-3721-4560-9fa5-3e8546734371",
 CellID->708741855],
Cell[22510, 581, 306, 6, 45, "Output",ExpressionUUID->"6eb75544-72aa-4b43-b43e-02b516d5e1c4",
 CellID->180793428]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[22855, 592, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"aafaa0de-1f95-4b4b-b4b7-6a8f1e47dac1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22978, 597, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"4eaf3a73-4250-46aa-880d-2f24c271bdc4",
 CellID->1255426704],
Cell[23241, 606, 216, 4, 70, "SeeAlso",ExpressionUUID->"b3eb4b87-de4d-47b6-b3e5-585d2cc7e22d",
 CellID->366041956],
Cell[23460, 612, 220, 4, 70, "SeeAlso",ExpressionUUID->"43539282-4a7b-49d0-be9e-7095f2667b63",
 CellID->207443811]
}, Open  ]],
Cell[CellGroupData[{
Cell[23717, 621, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"c18f72c3-e364-41cf-950d-796052283a3c",
 CellID->1584193535],
Cell[23990, 630, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"662be463-6137-4cab-9f2b-f4ccd4b73d43"],
Cell[24079, 632, 384, 10, 70, "RelatedLinks",ExpressionUUID->"06ce12ed-2745-4403-9a9c-344b276fe1b3",
 CellID->426751138]
}, Open  ]],
Cell[24478, 645, 78, 0, 70, "FooterCell",ExpressionUUID->"6dbc75e8-2cb7-4f2b-9910-aa4b7d334434"]
}
]
*)

(* End of internal cache information *)

