(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     33446,        884]
NotebookOptionsPosition[     25205,        707]
NotebookOutlinePosition[     27790,        772]
CellTagsIndexPosition[     27675,        766]
WindowTitle->etalK1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "db4994b1-f61a-471e-bed0-f50670ac6d2d"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"5bc40523-a436-4c59-9c42-cf2222c3b439"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaK1atm\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaK1atm.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaK1atm", {"etaK1atm.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "18b1b547-8fab-4f6c-ac41-d18064f8927b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"89fc6889-209a-4d7f-9085-57272c3346dc"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etalK1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etalK1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etalK1atm.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]},
             Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$20619], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etalK1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "60716c67-db6b-4017-8943-2e56d90f80f2"]
    }], "AnchorBar",ExpressionUUID->"822087a8-7d4b-4960-b783-396a5f6ee22c"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"771de359-9024-40fd-872d-4bb61a69e68f"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etalK1atm", "ObjectName",ExpressionUUID->
  "5a9a9796-3879-4c54-a801-b7dc7c0b5211"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"3882533d-716b-4415-8fef-b326296b40f1"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "02a16520-de4c-4e9b-9230-373a8296e4dd"]
}], "ObjectNameGrid",ExpressionUUID->"fb31699c-dd4a-4ea4-b9ce-b01a173ce34b"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etalK1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "19dd67d7-6cf3-462f-8022-25ba00858528"],
     " \[LineSeparator]Potassium viscosity liquid term ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox["\[Eta]", "l"], "=", 
       RowBox[{
        FractionBox[
         StyleBox["K",
          FontSlant->"Italic"], 
         RowBox[{
          StyleBox[
           SubscriptBox["H", "N"],
           FontSlant->"Italic"], 
          RowBox[{"(", 
           StyleBox["v",
            FontSlant->"Italic"], ")"}]}]], 
        StyleBox["\[Tau]",
         FontSlant->"Italic"]}]}]], "InlineFormula",ExpressionUUID->
      "66106978-4343-4bee-b148-70243a897e9c"],
     " as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"9c09c42f-afee-46b2-95a5-d6ce2a52c243"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"5d1204fc-85f9-425a-bd02-3a69de677f81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"df9c0e8a-a496-4b3d-a046-8e7e29340779"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"1b226473-8f35-4ca2-9d19-ae0c807d3bd1"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"d139f5a7-7185-495d-9c57-0b1550c7105f"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->183344392,ExpressionUUID->"ad0bd174-f9b0-428c-b566-2e7574df5823"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"378db298-9f3b-4060-82e2-9acd0d156fc9"],

Cell[TextData[{
 "The function is defined only for ",
 ButtonBox["TmpK",
  BaseStyle->"Hyperlink",
  ButtonData->{"TmpK.nb", None}],
 " \[LessEqual]",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
 "1030.793"], "InlineFormula",ExpressionUUID->
  "ceea0db0-fdf3-4b22-8fdb-b508255734a8"],
 " K"
}], "Notes",
 CellID->206839001,ExpressionUUID->"794921e9-ecec-4823-8424-d841bda448e5"],

Cell[TextData[{
 "The parameter ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is considered as a contant"
}], "Notes",
 CellID->819145981,ExpressionUUID->"10f552bc-8531-4777-973b-8ea5113355a6"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin "
}], "Notes",
 CellID->186809512,ExpressionUUID->"fd705213-431e-4ac5-b6cd-261a44465405"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]], "InlineFormula",ExpressionUUID->
  "2e690b8d-4526-413f-a1bd-848a5f73c677"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"317cd8c7-9e11-472e-b62f-824022164386"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "6ed8f659-c72d-4875-8044-2f02ae1633c5"], 
    ButtonBox[
     ButtonBox["etaK1atmDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaK1atmDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"e270446c-2e0d-47d0-a605-60944911769d"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"ce11ce67-6ce6-4c23-b925-d38f5fa04085"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"29a24cf5-9c8c-4391-a9fa-ca76c3a21295"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "6de0b658-7789-40b9-820f-b06990f9b049"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "fde30772-067f-4850-a3ac-8ed3163e33c1"]
    }], "TableText",ExpressionUUID->"2cfa6baf-5635-4ab2-a8d5-140493f699fc"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "8a8953f1-f50e-4632-a67f-45e764553883"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"d789bb7c-09ab-4858-91e3-936ea3c75b70"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "fb6ca848-8e65-4110-8463-bf472d61dbf1"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "bb5c68fd-e6bd-4ee3-95f9-4a09501e79a5"]
    }], "TableText",ExpressionUUID->"0ab164a9-28ce-4bf0-964d-ac7831c01ff8"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"6d819fc7-51b4-4f12-904e-3ce16bd8cac1"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"5adc620f-a19d-4dc4-ab13-6084f3fdb244"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"60fc27f9-37fa-4820-a76c-7b30300d07f6"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "6f337337-0913-478b-9bcf-31af4d7bcdd1"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->239674073,ExpressionUUID->"f8337d32-a9a0-4081-9af5-82990b4871c3"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4a62482e-0c62-4287-97ec-0c177a135995"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->63164442,ExpressionUUID->"5f8c8f3d-24ec-4e04-9b95-70ca4e5390e3"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"dd48c34b-3b9d-4c0a-8ed5-b0e5fe503f2a"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"12ded9bd-b221-446c-8dcc-1f361e98ec4c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etalK1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalK1atm", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
   "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"aa5475ac-e961-4a0e-a3ee-c8bc728eda59"],

Cell[BoxData["0.014186120827614926`"], "Output",
 CellLabel->"Out[2]=",
 CellID->158964864,ExpressionUUID->"b6514b92-0a44-4da4-8398-117f0d2b2c1a"],

Cell[BoxData[
 TemplateBox[{
  "0.014186120827614926`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->50325791,ExpressionUUID->"3ffdbbb5-443f-4161-b320-5c7e342f2a2d"],

Cell[BoxData[
 TemplateBox[{
  "0.014186120827614926`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->56760005,ExpressionUUID->"bafc12bf-ad3a-4587-a130-b0d33bb54f19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.014186120827614926`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"ea39affb-daec-4c40-8bdc-b32b8e1ebcd3"],

Cell[BoxData[
 TemplateBox[{"0.014186120827614926`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->660966690,ExpressionUUID->"5de1c1dc-6169-487c-8641-1cb9315ba32f"]
}, Open  ]],

Cell["\<\
Plot of the viscosity of the liquid term from the melting point to the \
boiling point along the atmospheric isobar\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"1d72f30b-19b4-4191-bc26-0fcd16d1e9d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"etalK1atm", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(\[Eta]\), \(l\)]\) (mPa.s)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->562653754,ExpressionUUID->"2f268bb7-48d0-4d63-877f-f356dd7f8da3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVznk41HkcwPEJUU2Z5MjZPh53aDdSwu7nYx6kZkUaOhDbMTo2GRmDNeUa
xvGd388oRZNc085mkWolXRKbQql42tKxjnSQxLaRhm3/eD+vf9/m2w8E7lJj
MBh+X/tfcxNPAW+eAGtFhas1uAoo+/NU3N0FAnSk49mwXgGWMdPClToCdKtg
TIh8FWB7+3KipqEAt8irQzS/V8Ay4crk01YCVDe5p2RbK8DtoX3OIApQz18/
hTdZAdwcg1KeUICabEsL77IKyJgaaucNCDCumO93SVUOYaXB0Vc74zBJqW07
p7EMTg7HV+6tEqIgubvjyfVSKJYFNdwUxyPftr7xXH8J6Ex/0DsYnYCjZ6Vh
BTol8E7bRyuBk4jK+peOzNZicH+5xbvb9RcU2MX2zE84CRwD203PzJPwzIoY
TvxGOTQPVzE8ppIQ164Kl4SegBrJ+MfRQRFizKIJ9b1FoH5nNPVL0yG84wNM
Z3khGPKU/eeLDqNZQ8SYb/9x6OxntUawk1E0+eyqu/1x8I20eSurScZjcTrG
P5BjkNCxxGnUKgXNy9dUu78vAOZP4zssilIwcfmLjxoRBbDhVnlvimYqXh7K
TxvtPwoBC1eImUmp+D6y0L+UdxQ0HEpiG9+k4pQ1yz118gjwlw5nlUSkoVIk
2/Yp+whAsH5WcHca8pPbPidaHYEbXOOuVex0LDUSvkxtz4cvLjNeXvXp2CJ3
f13Hz4fhN9dnJVmLMfhhx/4O83zwaAtTZsnEyOV31pc9koE31RPbpJWBd160
0vE5MlC3diHWggycU3w6xsRXBomnotr+GMrAQmd9xQM1GQT6iMeNIzLxwr2+
njVNefD8ujCysj0T5/2onT4uyQML03WzItkS3OOYbF/tlwdmnIlBv7MSZFbN
bus1zAPhr2l180yz0Dmu8Tj3FQ3ZgyOVY3QWdjb0dT47T0PghMu72dNZmNd4
XvxcTMPD4VCuV2w27uhexmMF0zD3QrhWdV82uuQ0f3C1p+GUEirerc/Bf7YG
et9To2Hk8Axvc3MOBnEH/vKppWDM7oRgZHku1t89kHFoFwU1dQZnapS5KPG/
RoUbUNAefaDVx4zgiResgNw2KRSryp3mZhNEN9sQK4kU7PbXN/07Q9Bz/VOD
DE8p7KlRFrOipOjgPPyoZZYU5n4Tt3P6sRS367b0rGghsJ1vEWDoT2G5Y5Fz
tphAdMHvmWFXKGwwEO4b4xAYuFjL975G4ZedZYs/riOw+XFdiGMjhfcbng58
WksATW98q7pJ4TbP8D7VGgILy7ofydsovFR0YzfTi0Bt1bTN0ycUbnR0kjt4
EBhrDmjdOklhAf0hMtOBAG8w6Bx7isKyujk2UnsCPVoh8qUqCq9FrdY8uvTr
n8LJVcSgcUZ027LclsC61x7z/TRo5Kju9zZaEjCO2nBhmEnjwbefuWpmBLqm
N/7293wa3VztFjFNCUip4OKuBTRaNk2O6JoQUKsNkVxh0RimvlPL2ojA2/Fd
obm6NMpV0nMcfQIV6bs3JOvRuKWP8XOQHoFt+vt8YvVprHR44hWuS+DByujv
QhfT+KpGwT2oQyD3VoxVgCGNSX5ZOaKFBHw2C4y9jGhsMLrYm8kiwHgjZLka
07iq3WaTTJtAQ0KihoMJjYVLuobkCwj8B30aOgk=
       "]]},
     Annotation[#, "Charting`Private`Tag$41147#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0.014186120936315038`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(\[Eta]\\), \\(l\\)]\\) (mPa.s)\"", 
      TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {0.014186120936315038`, 
   0.04165662005538751}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->136369219,ExpressionUUID->"a08ca16e-ad40-4d9a-804f-8c89059786a7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a4282259-763a-45b8-bb43-8852c179f031"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"ed381658-137a-4ad2-b617-17d75ed51867"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]],ExpressionUUID->
  "8ef168e1-2aab-4f39-b019-1f27cd30fb0b"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "266992a8-d0a9-4bf1-aafa-5977381bcd63"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"62ac6485-cc76-4631-9ccc-bfc07fb4d966"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"etalK1atm", "[", 
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"With", " ", 
    RowBox[{"Chiong", "'"}], "s", " ", "parameters"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"etalK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Coefd", "\[Rule]", "0.9525"}], ",", 
   RowBox[{"CoefN", "\[Rule]", "0.986928"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"8096e57b-4f8c-46ae-bf8f-e809f6743ecd"],

Cell[BoxData[
 TemplateBox[{
  "0.014186120827614926`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->60141852,ExpressionUUID->"cb34d9c3-a5ef-48a1-9753-434517b58ef6"],

Cell[BoxData[
 TemplateBox[{
  "0.014340650516302293`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->702115466,ExpressionUUID->"47901c21-dfa4-40b7-9f6e-8af879449f75"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6cc90647-8737-4ebe-bcc9-776d8a50f652"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"72bf17b2-5802-4695-90d5-88ee2155b6b8"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaK1atmDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8e5e19f2-d7d8-4821-9e91-81c89f763f59"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"76456553-8adf-44c1-a44b-a7aafaf51136"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaK1atmDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"2e7ab8f4-c8e1-484f-b66b-acd3444e2ca3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etalK1atm", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalK1atm", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"etaK1atmDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"05543c8e-6a44-403b-8851-49270d497722"],

Cell[BoxData["14.186120827614927`"], "Output",
 CellLabel->"Out[1]=",
 CellID->75361631,ExpressionUUID->"34d18835-f52e-44ea-bc3c-08c068b004fa"],

Cell[BoxData[
 TemplateBox[{"14.186120827614927`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->109600787,ExpressionUUID->"0059c385-bfbf-453a-81fc-3d45b3d47ca5"],

Cell[BoxData[
 TemplateBox[{"14.186120827614927`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->85232158,ExpressionUUID->"4cd416dd-2991-4514-a9ad-56091c4846b9"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"10576b72-5398-4fbf-bf1c-84afdac84e2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"b522ea3d-2585-4eeb-9e8c-8da281d33463"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"402dad73-3c71-4d21-944c-b9ea3db45109"],

Cell[TextData[StyleBox[ButtonBox["etaK1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaK1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->366041956,ExpressionUUID->"8533de35-31f9-4ef7-a184-fec12f8dc31d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"7cf2bb28-b8d7-44e3-ba0f-57d2fd2823d8"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"cc5f04c4-9633-4eb6-a774-f04836f13e36"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"bfd1c4fb-7bcb-4666-8012-7575f0716571"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "9eeb52ba-8ead-4124-898a-81f03f6bebe0"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"19cf9cbd-062a-4d67-8ac8-f12cc4fec843"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"c0133e1e-8f55-4f03-b744-b6ff668ffea3"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etalK1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 32.4203016}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etalK1atm[T] Potassium viscosity liquid term \\[Eta]l = K/(HN (v)) \
\\[Tau] as a function of temperature T along the atmospheric isobar in the \
liquid phase", "synonyms" -> {}, "tabletags" -> {}, "title" -> "etalK1atm", 
    "titlemodifier" -> "", "windowtitle" -> "etalK1atm", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/etalK1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"6014b582-c72f-4fb1-bf5e-fea13a8aa201"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11042, 302, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f8337d32-a9a0-4081-9af5-82990b4871c3",
   CellTags->"PrimaryExamplesSection",
   CellID->239674073]},
 "DefaultUnit"->{
  Cell[21182, 586, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"76456553-8adf-44c1-a44b-a7aafaf51136",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27300, 755},
 {"DefaultUnit", 27494, 759}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[581, 21, 3653, 83, 53, "AnchorBarGrid",ExpressionUUID->"771de359-9024-40fd-872d-4bb61a69e68f",
 CellID->1],
Cell[CellGroupData[{
Cell[4259, 108, 394, 9, 54, "ObjectNameGrid",ExpressionUUID->"fb31699c-dd4a-4ea4-b9ce-b01a173ce34b"],
Cell[4656, 119, 1191, 33, 142, "Usage",ExpressionUUID->"5d1204fc-85f9-425a-bd02-3a69de677f81",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5884, 157, 855, 21, 37, "NotesSection",ExpressionUUID->"ad0bd174-f9b0-428c-b566-2e7574df5823",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->183344392],
Cell[6742, 180, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"378db298-9f3b-4060-82e2-9acd0d156fc9"],
Cell[6831, 182, 407, 14, 70, "Notes",ExpressionUUID->"794921e9-ecec-4823-8424-d841bda448e5",
 CellID->206839001],
Cell[7241, 198, 192, 6, 70, "Notes",ExpressionUUID->"10f552bc-8531-4777-973b-8ea5113355a6",
 CellID->819145981],
Cell[7436, 206, 194, 6, 70, "Notes",ExpressionUUID->"fd705213-431e-4ac5-b6cd-261a44465405",
 CellID->186809512],
Cell[7633, 214, 401, 10, 70, "Notes",ExpressionUUID->"317cd8c7-9e11-472e-b62f-824022164386",
 CellID->487713575],
Cell[8037, 226, 744, 17, 70, "3ColumnTableMod",ExpressionUUID->"ce11ce67-6ce6-4c23-b925-d38f5fa04085",
 CellID->716128471],
Cell[8784, 245, 127, 1, 70, "Notes",ExpressionUUID->"29a24cf5-9c8c-4391-a9fa-ca76c3a21295",
 CellID->46888620],
Cell[8914, 248, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"6d819fc7-51b4-4f12-904e-3ce16bd8cac1",
 CellID->505732368],
Cell[10919, 297, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"5adc620f-a19d-4dc4-ab13-6084f3fdb244"]
}, Closed]],
Cell[CellGroupData[{
Cell[11042, 302, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"f8337d32-a9a0-4081-9af5-82990b4871c3",
 CellTags->"PrimaryExamplesSection",
 CellID->239674073],
Cell[CellGroupData[{
Cell[11502, 317, 307, 7, 30, "ExampleSection",ExpressionUUID->"5f8c8f3d-24ec-4e04-9b95-70ca4e5390e3",
 CellID->63164442],
Cell[11812, 326, 175, 3, 27, "Input",ExpressionUUID->"dd48c34b-3b9d-4c0a-8ed5-b0e5fe503f2a",
 CellID->87419684],
Cell[11990, 331, 298, 5, 57, "ExampleText",ExpressionUUID->"12ded9bd-b221-446c-8dcc-1f361e98ec4c",
 CellID->544149791],
Cell[CellGroupData[{
Cell[12313, 340, 499, 12, 60, "Input",ExpressionUUID->"aa5475ac-e961-4a0e-a3ee-c8bc728eda59",
 CellID->218515404],
Cell[12815, 354, 146, 2, 36, "Output",ExpressionUUID->"b6514b92-0a44-4da4-8398-117f0d2b2c1a",
 CellID->158964864],
Cell[12964, 358, 221, 5, 43, "Output",ExpressionUUID->"3ffdbbb5-443f-4161-b320-5c7e342f2a2d",
 CellID->50325791],
Cell[13188, 365, 221, 5, 43, "Output",ExpressionUUID->"bafc12bf-ad3a-4587-a130-b0d33bb54f19",
 CellID->56760005]
}, Open  ]],
Cell[CellGroupData[{
Cell[13446, 375, 361, 8, 27, "Input",ExpressionUUID->"ea39affb-daec-4c40-8bdc-b32b8e1ebcd3",
 CellID->273227049],
Cell[13810, 385, 304, 6, 43, "Output",ExpressionUUID->"5de1c1dc-6169-487c-8641-1cb9315ba32f",
 CellID->660966690]
}, Open  ]],
Cell[14129, 394, 221, 4, 57, "ExampleText",ExpressionUUID->"1d72f30b-19b4-4191-bc26-0fcd16d1e9d9",
 CellID->119396994],
Cell[CellGroupData[{
Cell[14375, 402, 611, 15, 70, "Input",ExpressionUUID->"2f268bb7-48d0-4d63-877f-f356dd7f8da3",
 CellID->562653754],
Cell[14989, 419, 3693, 83, 246, "Output",ExpressionUUID->"a08ca16e-ad40-4d9a-804f-8c89059786a7",
 CellID->136369219]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18731, 508, 323, 7, 70, "ExampleSection",ExpressionUUID->"ed381658-137a-4ad2-b617-17d75ed51867",
 CellID->1020263627],
Cell[19057, 517, 624, 17, 70, "ExampleText",ExpressionUUID->"62ac6485-cc76-4631-9ccc-bfc07fb4d966",
 CellID->111367501],
Cell[CellGroupData[{
Cell[19706, 538, 651, 17, 70, "Input",ExpressionUUID->"8096e57b-4f8c-46ae-bf8f-e809f6743ecd",
 CellID->138125379],
Cell[20360, 557, 221, 5, 43, "Output",ExpressionUUID->"cb34d9c3-a5ef-48a1-9753-434517b58ef6",
 CellID->60141852],
Cell[20584, 564, 222, 5, 43, "Output",ExpressionUUID->"47901c21-dfa4-40b7-9f6e-8af879449f75",
 CellID->702115466]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20855, 575, 302, 7, 70, "ExampleSection",ExpressionUUID->"72bf17b2-5802-4695-90d5-88ee2155b6b8",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[21182, 586, 344, 8, 70, "ExampleSubsection",ExpressionUUID->"76456553-8adf-44c1-a44b-a7aafaf51136",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[21529, 596, 230, 4, 70, "ExampleText",ExpressionUUID->"2e7ab8f4-c8e1-484f-b66b-acd3444e2ca3",
 CellID->300166705],
Cell[CellGroupData[{
Cell[21784, 604, 1135, 29, 70, "Input",ExpressionUUID->"05543c8e-6a44-403b-8851-49270d497722",
 CellID->643121792],
Cell[22922, 635, 143, 2, 35, "Output",ExpressionUUID->"34d18835-f52e-44ea-bc3c-08c068b004fa",
 CellID->75361631],
Cell[23068, 639, 306, 6, 45, "Output",ExpressionUUID->"0059c385-bfbf-453a-81fc-3d45b3d47ca5",
 CellID->109600787],
Cell[23377, 647, 305, 6, 45, "Output",ExpressionUUID->"4cd416dd-2991-4514-a9ad-56091c4846b9",
 CellID->85232158]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[23721, 658, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"10576b72-5398-4fbf-bf1c-84afdac84e2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23844, 663, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"402dad73-3c71-4d21-944c-b9ea3db45109",
 CellID->1255426704],
Cell[24107, 672, 218, 4, 70, "SeeAlso",ExpressionUUID->"8533de35-31f9-4ef7-a184-fec12f8dc31d",
 CellID->366041956]
}, Open  ]],
Cell[CellGroupData[{
Cell[24362, 681, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"cc5f04c4-9633-4eb6-a774-f04836f13e36",
 CellID->1584193535],
Cell[24635, 690, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"bfd1c4fb-7bcb-4666-8012-7575f0716571"],
Cell[24724, 692, 384, 10, 70, "RelatedLinks",ExpressionUUID->"19cf9cbd-062a-4d67-8ac8-f12cc4fec843",
 CellID->426751138]
}, Open  ]],
Cell[25123, 705, 78, 0, 70, "FooterCell",ExpressionUUID->"c0133e1e-8f55-4f03-b744-b6ff668ffea3"]
}
]
*)

(* End of internal cache information *)

