(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30063,        810]
NotebookOptionsPosition[     22317,        643]
NotebookOutlinePosition[     24906,        708]
CellTagsIndexPosition[     24791,        702]
WindowTitle->etalKVap
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "98d43864-1470-48db-9d67-a17c081bff41"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"ccf0b869-1c73-4187-9c1f-0d0a1ef20fad"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"etaKVap\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"etaKVap.nb", None}, "paclet*"], 
         Part[
          Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"etaKVap", {"etaKVap.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9565bb60-5cf2-4ee3-a859-4134e3619487"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"3754153c-3030-475f-b899-7f22d4198e8d"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/etalKVap\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/etalKVap"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
etalKVap.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$21056], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/etalKVap", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f0968e32-b175-40a4-90c7-60b7c2fb1839"]
    }], "AnchorBar",ExpressionUUID->"ba4a2181-3e28-431b-a1bf-4282ca2f6e76"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"0258c0da-0a02-498d-a29c-8de98c7256e0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["etalKVap", "ObjectName",ExpressionUUID->
  "fb04aa6c-ebaa-494b-b297-336e65f8ae1c"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"de497ad9-7a52-4a03-ab54-464bcce2f0d8"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "7aa89dd0-7a7e-4446-ab91-db5d56f4c482"]
}], "ObjectNameGrid",ExpressionUUID->"ebfd2221-f56c-45f4-b026-59611f29250c"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"etalKVap", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", 
        StyleBox["\[Rho]",
         FontSlant->"Italic"]}], "]"}]], "InlineFormula",ExpressionUUID->
      "037fa5ff-1207-48e2-b558-5a6e95825053"],
     " \[LineSeparator]Potassium viscosity liquid term ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox["\[Eta]", "l"], "=", 
       RowBox[{
        FractionBox[
         StyleBox["K",
          FontSlant->"Italic"], 
         RowBox[{
          StyleBox[
           SubscriptBox["H", "N"],
           FontSlant->"Italic"], 
          RowBox[{"(", 
           StyleBox["v",
            FontSlant->"Italic"], ")"}]}]], 
        StyleBox["\[Tau]",
         FontSlant->"Italic"]}]}]], "InlineFormula",ExpressionUUID->
      "8d2135c7-dd7a-43c9-b879-b452107ba5a9"],
     " as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " and density ",
     StyleBox["\[Rho] ",
      FontSlant->"Italic"],
     "for the gaseous phase only"
    }],ExpressionUUID->"f333cf41-8ea6-439d-959e-517fc7103856"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"41478fd6-586a-45f9-99f6-ab8570083c3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"16b82e67-61a3-471d-9f5d-52a1371a6004"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"e96464ef-4e1b-4715-b571-03c1b797f668"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"02a4d5ac-7ce7-44f0-bd99-9fa8dd2f66f1"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->477287848,ExpressionUUID->"4807c766-5981-450a-b26a-5b73a98c6f6d"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"f1cca5d3-bfcf-4cf2-815e-9871ef7c2df5"],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "45f4fef5-aa60-46c4-8148-462fd2ca270f"],
 " is calculated using its dilute-gas limit form: ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["K", "*"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "17ba72f6-bb6b-4ab3-876f-c736d4740a7f"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["c", "K0"],
    FontSlant->"Italic"], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Rho]", 
      SubscriptBox["\[Rho]", "c"]], ")"}], "3"]}]], "InlineFormula",
  ExpressionUUID->"1b732935-a932-45f4-adbb-2d3a054d29c8"],
 " "
}], "Notes",
 CellID->819145981,ExpressionUUID->"c3b130f8-0812-4e2f-9f7e-e356adb9ab9a"],

Cell[TextData[{
 "By default the units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin and the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "6d32396e-280b-4fac-b6ce-f467a487d0fd"]
}], "Notes",
 CellID->186809512,ExpressionUUID->"1d027cec-3b52-449d-bb68-2e060bd8a861"],

Cell[TextData[{
 "By default the unit of ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]], "InlineFormula",ExpressionUUID->
  "636bac82-4f0c-4b22-928c-46f2f5e4abb7"],
 " is ",
 StyleBox["centipoise",
  FontVariations->{"Underline"->True}],
 " (i.e. mPa.s) but it can be changed by modifying the following option:"
}], "Notes",
 CellID->487713575,ExpressionUUID->"8f54a41a-7c92-41d1-a7d1-7b905065ce25"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "014918c6-bdd3-4736-adf8-caff51b19372"], 
    ButtonBox[
     ButtonBox["etaKVapDefaultUnit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`\
etaKVapDefaultUnit"],
     BaseStyle->"Hyperlink",
     ButtonData->"DefaultUnit"], "Centipoise", Cell[
    "Default unit for viscosity equations of state", "TableText",
     ExpressionUUID->"a45d5f55-acb2-47de-a9b3-9b0137ff179c"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->716128471,ExpressionUUID->"739170ea-a1dc-4774-80fe-586931391213"],

Cell["The following options can be given: ", "Notes",
 CellID->46888620,ExpressionUUID->"9445fe78-4dbc-49a7-8f5a-9b17b37c2b32"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "5d044f10-aa80-45a6-9737-f69b40672357"], 
    ButtonBox[
     ButtonBox["CoefN",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefN"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefN.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", "N"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "30dc9a06-7c6e-4d55-8798-4dba0ac0e584"]
    }], "TableText",ExpressionUUID->"faa7b7ee-d021-4aa0-bdec-98a93e03e9bc"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "ac6c9e0b-e052-4218-8b8c-4efec9be0ca2"], 
    ButtonBox[
     ButtonBox["Coefd",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`Coefd"],
     BaseStyle->"Hyperlink",
     ButtonData->{"Coefd.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     StyleBox["d",
      FontSlant->"Italic"]
    }], "TableText",ExpressionUUID->"e2496eb7-1c6b-4101-aae5-04d71c972e18"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "c70d9014-5089-4341-bdde-88392a9819e1"], 
    ButtonBox[
     ButtonBox["CoefK",
      BaseStyle->"Link",
      ButtonData->"paclet:EOSPotassiumPrivate/ref/EOSPotassium`Private`CoefK"],
     BaseStyle->"Hyperlink",
     ButtonData->{"CoefK.nb", None}], "1", Cell[TextData[{
     "Constant that multiplies ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["K",
        FontSlant->"Italic"], "*"]], "InlineFormula",ExpressionUUID->
      "8516eb23-8339-4a15-b602-9cd620200665"]
    }], "TableText",ExpressionUUID->"6f08783c-616a-4f2d-b20d-6e9dc27a0125"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->505732368,ExpressionUUID->"3c214a97-6c46-45b6-a867-cdbe46ca91e0"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"50c2f432-ac88-4bff-b8db-cdb8f9031f27"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"70fb8ea4-cb91-443b-85c5-92ccc7063365"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "f112baa7-49e3-4392-bd5d-838f94ba1627"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->165531056,ExpressionUUID->"d9167f0c-0b99-4064-bf21-fb010e7d20c8"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7996290d-19d6-493a-90d8-28774168b5f4"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->216286435,ExpressionUUID->"1683dbfe-58a6-4149-a919-506bc422ba92"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"7f22f736-b5b9-4ff8-9bd0-b50658cadf83"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the temperature variable and/or to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"9aba8719-0aca-48ec-b606-92a6e2ae60b4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etalKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->218515404,ExpressionUUID->"27cf4e7d-3f3c-4385-ae5a-09fc59afa739"],

Cell[BoxData["0.002221819449438109`"], "Output",
 CellLabel->"Out[2]=",
 CellID->1742963,ExpressionUUID->"dc3a8346-bb4a-4d60-b637-6de912793656"],

Cell[BoxData[
 TemplateBox[{
  "0.002221819449438109`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->451514081,ExpressionUUID->"d661c8ff-2d44-4a02-bc5a-e19669399f79"],

Cell[BoxData[
 TemplateBox[{
  "0.002221819449438109`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->238817850,ExpressionUUID->"320006b7-0adb-4a20-954d-0d07a62bd6ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"0.002221819449438109`", ",", "\"\<Centipoise\>\""}], "]"}], ",", 
   RowBox[{"\"\<Millipascals\>\"", " ", "\"\<Seconds\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->273227049,ExpressionUUID->"6997a25a-a556-47ce-91c9-e367bc3fd6ba"],

Cell[BoxData[
 TemplateBox[{"0.002221819449438109`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"mPa\""}], "second millipascals", 
   RowBox[{"\"Millipascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->112653448,ExpressionUUID->"d2a22167-9ba8-4194-8b42-1db60cd2e907"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generalizations & Extensions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8dee78ad-e164-416d-8e4d-9bd8eede6c50"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627,ExpressionUUID->"a7e8f90f-e378-4d99-8208-31a43c8dd8a6"],

Cell[TextData[{
 "Considering that ",
 Cell[BoxData[
  SubscriptBox["\[Eta]", "l"]],ExpressionUUID->
  "4b84839f-60ec-403e-a2fc-56ca82666fce"],
 " contains the geometric parameters ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["d", "N"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "d72159e2-552e-4f41-a351-a3aa88b28b12"],
 " of the experiment, it is necessary to be able to multiply these two \
parameters with two constants that are respectively Coefd and CoefN"
}], "ExampleText",
 CellID->111367501,ExpressionUUID->"8deb7b6e-bae0-44de-9a86-d1b4394ca630"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"Coefd", "\[Rule]", "0.9"}], ",", 
   RowBox[{"CoefN", "\[Rule]", "0.9"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->138125379,ExpressionUUID->"f9a8bb7a-db90-4b5c-a317-c5a82ffb6939"],

Cell[BoxData[
 TemplateBox[{
  "0.002221819449438109`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->163790040,ExpressionUUID->"7bdea2a1-9114-4ce8-90b8-aade7388c1c9"],

Cell[BoxData[
 TemplateBox[{
  "0.0024686882770547283`", "\"cP\"", "centipoise", "\"Centipoise\""},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->17095546,ExpressionUUID->"98cb362b-137c-4059-9513-93a154be14d3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "80c0dcf3-0a65-4bce-b4d9-34428ba718de"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341,ExpressionUUID->"4661288d-b7dc-4055-a1a1-ec71b12bd0dc"],

Cell[CellGroupData[{

Cell[TextData[{
 "etaKVapDefaultUnit",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2522bbe0-32f9-4c1c-97b1-785649e3d921"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellTags->"DefaultUnit",
 CellID->13917458,ExpressionUUID->"6846ed4b-b7f8-47d1-8c9f-eb12624c3ebb"],

Cell["\<\
It is possible to change the viscosity default unit by setting a new unit to \
the option parameter \"etaKVapDefaultUnit\":\
\>", "ExampleText",
 CellID->300166705,ExpressionUUID->"deb61a07-89bf-42b6-96d2-b32a6cf52dd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etalKVap", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
     RowBox[{"\"\<Grams\>\"", "/", 
      SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"etalKVap", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"1030.793", "-", "273.15"}], ",", "\"\<DegreesCelsius\>\""}], 
    "]"}], ",", 
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], "*", "1000"}], ",", 
     "\"\<kg/m^3\>\""}], "]"}], ",", 
   RowBox[{"etaKVapDefaultUnit", "->", 
    RowBox[{"QuantityUnit", "[", 
     RowBox[{"Quantity", "[", 
      RowBox[{"\"\<Micropascals\>\"", " ", "\"\<Seconds\>\""}], "]"}], 
     "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->643121792,ExpressionUUID->"7eb20854-2190-4c0f-9461-effbf94931b8"],

Cell[BoxData["2.221819449438109`"], "Output",
 CellLabel->"Out[1]=",
 CellID->445308540,ExpressionUUID->"7598e983-744e-4d80-a095-91ed39ae284a"],

Cell[BoxData[
 TemplateBox[{"2.221819449438109`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->236109,ExpressionUUID->"8c6d2a21-3475-4d53-997a-bd031fa81385"],

Cell[BoxData[
 TemplateBox[{"2.221819449438109`", 
   RowBox[{"\"s\"", "\[ThinSpace]", "\"\[Mu]Pa\""}], "second micropascals", 
   RowBox[{"\"Micropascals\"", " ", "\"Seconds\""}]},
  "Quantity"]], "Output",
 CellLabel->"Out[1]=",
 CellID->167565899,ExpressionUUID->"7e8af7ed-5a13-473d-99b7-20cb0cc33ef3"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"edc8d1f8-9556-44bf-a034-532c439dc83c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"2b630b9d-db47-44b1-baa2-1ee0be02e2db"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"85f86422-5988-4050-ad91-859bc688bb11"],

Cell[TextData[StyleBox[ButtonBox["etaKVap",
 BaseStyle->"Hyperlink",
 ButtonData->{"etaKVap.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->366041956,ExpressionUUID->"8b671cbb-6863-4fd9-a32e-3d7177b15313"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"3afc1075-050c-43e5-9cb1-cafe7ab8a703"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"e8bad266-ad00-40e0-bf3b-b3aa5d82ae7f"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"22704ac4-47a5-4578-a8b7-19df2962091a"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "cfff2adc-6a45-484d-89f1-a2fa1069df41"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"5afcea86-b036-48ef-b461-fb286ab3295a"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"bafdfcb8-c104-4e87-b173-8a0679a710b0"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"etalKVap",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 34.7593012}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "etalKVap[T, \\[Rho]] Potassium viscosity liquid term \\[Eta]l = K/(HN \
(v)) \\[Tau] as a function of temperature T and density \\[Rho] for the \
gaseous phase only", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "etalKVap", "titlemodifier" -> "", "windowtitle" -> "etalKVap", "type" -> 
    "Symbol", "uri" -> "EOSPotassium/ref/etalKVap", "WorkflowDockedCell" -> 
    ""}, "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"4b2cfb12-c76d-48ed-835c-499d4f6fb9f0"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11549, 317, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d9167f0c-0b99-4064-bf21-fb010e7d20c8",
   CellTags->"PrimaryExamplesSection",
   CellID->165531056]},
 "DefaultUnit"->{
  Cell[17884, 511, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"6846ed4b-b7f8-47d1-8c9f-eb12624c3ebb",
   CellTags->"DefaultUnit",
   CellID->13917458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24416, 691},
 {"DefaultUnit", 24610, 695}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 3643, 83, 53, "AnchorBarGrid",ExpressionUUID->"0258c0da-0a02-498d-a29c-8de98c7256e0",
 CellID->1],
Cell[CellGroupData[{
Cell[4248, 108, 393, 9, 54, "ObjectNameGrid",ExpressionUUID->"ebfd2221-f56c-45f4-b026-59611f29250c"],
Cell[4644, 119, 1326, 39, 142, "Usage",ExpressionUUID->"41478fd6-586a-45f9-99f6-ab8570083c3e",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6007, 163, 855, 21, 37, "NotesSection",ExpressionUUID->"4807c766-5981-450a-b26a-5b73a98c6f6d",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->477287848],
Cell[6865, 186, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"f1cca5d3-bfcf-4cf2-815e-9871ef7c2df5"],
Cell[6954, 188, 830, 28, 70, "Notes",ExpressionUUID->"c3b130f8-0812-4e2f-9f7e-e356adb9ab9a",
 CellID->819145981],
Cell[7787, 218, 352, 9, 70, "Notes",ExpressionUUID->"1d027cec-3b52-449d-bb68-2e060bd8a861",
 CellID->186809512],
Cell[8142, 229, 401, 10, 70, "Notes",ExpressionUUID->"8f54a41a-7c92-41d1-a7d1-7b905065ce25",
 CellID->487713575],
Cell[8546, 241, 742, 17, 70, "3ColumnTableMod",ExpressionUUID->"739170ea-a1dc-4774-80fe-586931391213",
 CellID->716128471],
Cell[9291, 260, 127, 1, 70, "Notes",ExpressionUUID->"9445fe78-4dbc-49a7-8f5a-9b17b37c2b32",
 CellID->46888620],
Cell[9421, 263, 2002, 47, 70, "3ColumnTableMod",ExpressionUUID->"3c214a97-6c46-45b6-a867-cdbe46ca91e0",
 CellID->505732368],
Cell[11426, 312, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"50c2f432-ac88-4bff-b8db-cdb8f9031f27"]
}, Closed]],
Cell[CellGroupData[{
Cell[11549, 317, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d9167f0c-0b99-4064-bf21-fb010e7d20c8",
 CellTags->"PrimaryExamplesSection",
 CellID->165531056],
Cell[CellGroupData[{
Cell[12009, 332, 308, 7, 30, "ExampleSection",ExpressionUUID->"1683dbfe-58a6-4149-a919-506bc422ba92",
 CellID->216286435],
Cell[12320, 341, 175, 3, 27, "Input",ExpressionUUID->"7f22f736-b5b9-4ff8-9bd0-b50658cadf83",
 CellID->87419684],
Cell[12498, 346, 329, 5, 76, "ExampleText",ExpressionUUID->"9aba8719-0aca-48ec-b606-92a6e2ae60b4",
 CellID->544149791],
Cell[CellGroupData[{
Cell[12852, 355, 968, 27, 97, "Input",ExpressionUUID->"27cf4e7d-3f3c-4385-ae5a-09fc59afa739",
 CellID->218515404],
Cell[13823, 384, 144, 2, 36, "Output",ExpressionUUID->"dc3a8346-bb4a-4d60-b637-6de912793656",
 CellID->1742963],
Cell[13970, 388, 222, 5, 43, "Output",ExpressionUUID->"d661c8ff-2d44-4a02-bc5a-e19669399f79",
 CellID->451514081],
Cell[14195, 395, 222, 5, 43, "Output",ExpressionUUID->"320006b7-0adb-4a20-954d-0d07a62bd6ed",
 CellID->238817850]
}, Open  ]],
Cell[CellGroupData[{
Cell[14454, 405, 361, 8, 27, "Input",ExpressionUUID->"6997a25a-a556-47ce-91c9-e367bc3fd6ba",
 CellID->273227049],
Cell[14818, 415, 304, 6, 43, "Output",ExpressionUUID->"d2a22167-9ba8-4194-8b42-1db60cd2e907",
 CellID->112653448]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15171, 427, 323, 7, 70, "ExampleSection",ExpressionUUID->"a7e8f90f-e378-4d99-8208-31a43c8dd8a6",
 CellID->1020263627],
Cell[15497, 436, 624, 17, 70, "ExampleText",ExpressionUUID->"8deb7b6e-bae0-44de-9a86-d1b4394ca630",
 CellID->111367501],
Cell[CellGroupData[{
Cell[16146, 457, 912, 23, 70, "Input",ExpressionUUID->"f9a8bb7a-db90-4b5c-a317-c5a82ffb6939",
 CellID->138125379],
Cell[17061, 482, 222, 5, 43, "Output",ExpressionUUID->"7bdea2a1-9114-4ce8-90b8-aade7388c1c9",
 CellID->163790040],
Cell[17286, 489, 222, 5, 43, "Output",ExpressionUUID->"98cb362b-137c-4059-9513-93a154be14d3",
 CellID->17095546]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17557, 500, 302, 7, 70, "ExampleSection",ExpressionUUID->"4661288d-b7dc-4055-a1a1-ec71b12bd0dc",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[17884, 511, 343, 8, 70, "ExampleSubsection",ExpressionUUID->"6846ed4b-b7f8-47d1-8c9f-eb12624c3ebb",
 CellTags->"DefaultUnit",
 CellID->13917458],
Cell[18230, 521, 229, 4, 70, "ExampleText",ExpressionUUID->"deb61a07-89bf-42b6-96d2-b32a6cf52dd8",
 CellID->300166705],
Cell[CellGroupData[{
Cell[18484, 529, 1553, 40, 70, "Input",ExpressionUUID->"7eb20854-2190-4c0f-9461-effbf94931b8",
 CellID->643121792],
Cell[20040, 571, 143, 2, 35, "Output",ExpressionUUID->"7598e983-744e-4d80-a095-91ed39ae284a",
 CellID->445308540],
Cell[20186, 575, 302, 6, 45, "Output",ExpressionUUID->"8c6d2a21-3475-4d53-997a-bd031fa81385",
 CellID->236109],
Cell[20491, 583, 305, 6, 45, "Output",ExpressionUUID->"7e8af7ed-5a13-473d-99b7-20cb0cc33ef3",
 CellID->167565899]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[20835, 594, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"edc8d1f8-9556-44bf-a034-532c439dc83c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20958, 599, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"85f86422-5988-4050-ad91-859bc688bb11",
 CellID->1255426704],
Cell[21221, 608, 216, 4, 70, "SeeAlso",ExpressionUUID->"8b671cbb-6863-4fd9-a32e-3d7177b15313",
 CellID->366041956]
}, Open  ]],
Cell[CellGroupData[{
Cell[21474, 617, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"e8bad266-ad00-40e0-bf3b-b3aa5d82ae7f",
 CellID->1584193535],
Cell[21747, 626, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"22704ac4-47a5-4578-a8b7-19df2962091a"],
Cell[21836, 628, 384, 10, 70, "RelatedLinks",ExpressionUUID->"5afcea86-b036-48ef-b461-fb286ab3295a",
 CellID->426751138]
}, Open  ]],
Cell[22235, 641, 78, 0, 70, "FooterCell",ExpressionUUID->"bafdfcb8-c104-4e87-b173-8a0679a710b0"]
}
]
*)

(* End of internal cache information *)

