(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    151678,       2818]
NotebookOptionsPosition[    145281,       2678]
NotebookOutlinePosition[    147894,       2744]
CellTagsIndexPosition[    147770,       2738]
WindowTitle->fqc
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "157d23f6-edb7-4a7e-b5c5-4bd372d8638e"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"d6829467-8690-42d6-970d-b8a595a28a55"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"qc0K\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"qc0K.nb", None}, "paclet*"], 
         Part[
          Part[{{"qc0K", {"qc0K.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"qc0K", {"qc0K.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d1fe0ce4-a12b-4b21-bfbf-ab8bbde453a5"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"0c1929e7-05e2-4e61-a144-4ec29c7d8641"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/fqc\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/fqc"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/fqc.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$21805], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/fqc", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3f5d0f91-31a1-4441-849c-74e89963b724"]
    }], "AnchorBar",ExpressionUUID->"6f793cd8-87b7-4cda-9cdf-392489953615"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"92261cd1-0ce3-46fb-8f80-d0fbff9dc1ac"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["fqc", "ObjectName",ExpressionUUID->
  "31509b93-c23e-499a-bf65-de5ed481a543"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"3eed840c-fb99-419d-ad29-7f4f0ce6f988"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "a1312740-d63d-43af-99e5-169ea5a09649"]
}], "ObjectNameGrid",ExpressionUUID->"534537d2-e2b4-4263-812e-3875cce9ebe8"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"fqc", "[", 
       RowBox[{
        StyleBox["T",
         FontSlant->"Italic"], ",", " ", "\[Rho]"}], "]"}]], "InlineFormula",
      ExpressionUUID->"f315e8c4-ab81-4dc5-a5c9-a9f672922bed"],
     " \[LineSeparator]Non-dimensional function ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", 
        SubscriptBox["q", "c"]],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "2f15885e-abe1-4112-8af3-4fcaa452fbfc"],
     " which represents the excess variations of the cut-off wave-vector \
modulus ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["q", "c0"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "23affbd2-51bb-43dd-8a0f-98c97df7fb8b"],
     " as a function of temperature ",
     StyleBox["T ",
      FontSlant->"Italic"],
     "and density ",
     StyleBox["\[Rho]",
      FontSlant->"Italic"]
    }],ExpressionUUID->"1c0879c0-be47-4b00-b3c0-63c4ada8d1db"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"795c949d-e703-47e8-bb3d-7629587c2415"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"fd6c91cc-7b72-4ecd-b088-8317eb2ec5d1"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"8d44a209-208e-4936-a1c1-1ec105b05350"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"dd2e3122-8ad8-420c-86be-223083df14d4"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->533351692,ExpressionUUID->"cfe53d6c-2347-47fd-a0f0-0f8943aeb7ad"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"dd2dc5c2-554f-48e2-872a-10a78d91bbb2"],

Cell[TextData[{
 "This function is valid only for the gaseous phase of potassium such that ",
 StyleBox["T \[LessEqual]",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["T", "c"],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "f5166dc7-0202-41b3-8e42-bbd86bc5449e"],
 "."
}], "Notes",
 CellID->393170804,ExpressionUUID->"06fef707-430d-45dc-a730-3b01d6940cd2"],

Cell[TextData[{
 "The units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin and the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "cafcb09f-bfd6-4a69-bc66-70b7713ed3a0"]
}], "Notes",
 CellID->368776926,ExpressionUUID->"e9956954-ee12-458b-8821-16e923c4caf6"],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox[
     SubscriptBox["q", "c"],
     FontSlant->"Italic"], 
    StyleBox["[",
     FontSlant->"Italic"], 
    RowBox[{
     StyleBox["T",
      FontSlant->"Plain"], 
     StyleBox[",",
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontSlant->"Italic"], 
     StyleBox["\[Rho]",
      FontSlant->"Italic"]}], 
    StyleBox["]",
     FontSlant->"Italic"]}], "=", 
   RowBox[{
    RowBox[{
     StyleBox[
      SubscriptBox["f", 
       SubscriptBox["q", "c"]],
      FontSlant->"Italic"], "[", 
     RowBox[{
      StyleBox["T",
       FontSlant->"Italic"], ",", " ", "\[Rho]"}], "]"}], "\[Times]", 
    RowBox[{
     SubscriptBox[
      StyleBox["q",
       FontSlant->"Italic"], "c0"], "[", "\[Rho]", "]"}]}]}]], 
  "InlineFormula",ExpressionUUID->"a7f31db5-7e2c-455b-923c-c9867c312626"]
}], "Notes",
 CellID->105518218,ExpressionUUID->"2fc5adea-5b7d-4d67-b88a-3c62f8617e6a"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"5a7af070-249b-4894-b48c-88cc0de0c47f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6a697535-5e08-44ba-ae32-ead8dd7caccd"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "77a9502a-757e-44c9-b91b-d1c128d5bcae"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->259005379,ExpressionUUID->"8978f25b-a964-47ff-aaf3-57344562e3a4"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3033981d-2114-4b7f-a8de-19cb1b6b7085"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->742112932,ExpressionUUID->"4f67c8d2-5bcf-4646-a762-9825de0dbbac"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"e0709fc5-8e0d-4dfa-9511-0650e660d5ef"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "3cc99d75-a6ab-4c6a-9ba4-acdbbe545bfe"],
 " is a non-dimensional function but temperature and density variables must \
be given as  numbers without unit"
}], "ExampleText",
 CellID->48819395,ExpressionUUID->"64e2cd6c-f2b7-48f3-ad03-09f9c1ee9619"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"fqc", "[", 
  RowBox[{"1030.793", ",", 
   RowBox[{"RhoSatVapK", "[", "1030.793", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"fqc", "[", 
  RowBox[{
   RowBox[{"QuantityMagnitude", "@", 
    RowBox[{"Quantity", "[", 
     RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}]}], ",", 
   RowBox[{"QuantityMagnitude", "@", 
    RowBox[{"Quantity", "[", 
     RowBox[{
      RowBox[{"RhoSatVapK", "[", "1030.793", "]"}], ",", 
      RowBox[{"\"\<Grams\>\"", "/", 
       SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->422395267,ExpressionUUID->"d19e66e3-de2d-4898-a34d-1d59a3e8f046"],

Cell[BoxData["189.93053280829884`"], "Output",
 CellLabel->"Out[2]=",
 CellID->38421988,ExpressionUUID->"9229c1cf-ebd3-4cdb-8ec1-bc4fdd98bd8d"],

Cell[BoxData["189.93053280829884`"], "Output",
 CellLabel->"Out[2]=",
 CellID->660745594,ExpressionUUID->"7a3536bf-705b-4e4c-a5ae-dc77a4ae818e"]
}, Open  ]],

Cell[TextData[{
 "Logarithmic plot of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "a51a2b10-25da-4e11-87b4-f4347a7fd5d7"],
 " along the vapor coexistence curve"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"64e1b429-eba4-4dbf-8d68-4dd7b0e6e9dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"fqc", "[", 
    RowBox[{"T", ",", 
     RowBox[{"RhoSatVapK", "[", "T", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "TcK"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"f\", SubscriptBox[\"q\", \
\"c\"]],FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58108706,ExpressionUUID->"389bcf27-b1c3-451a-856b-6b6a81afbeab"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVkWk41IsbhokkKmSpZE/JvmVn3jcnk4iSIlOdKBRZKo2JTkiRImXJMiPz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       "]]},
     Annotation[#, "Charting`Private`Tag$11308#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"f\\\", SubscriptBox[\\\"q\\\", \
\\\"c\\\"]],FontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Automatic, Automatic}}, {{{{6.907755278982137, 
        FormBox["1000", TraditionalForm], {0.01, 0.}}, {16.11809565095832, 
        FormBox[
         TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 0.}}, {
       25.328436022934504`, 
        FormBox[
         TemplateBox[{"10", "11"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       18.420680743952367`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       29.933606208922594`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       34.538776394910684`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       34.94424150301885, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       35.23192357547063, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       35.45506712678484, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       16.11809565095832, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       25.328436022934504`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       11.512925464970229`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       13.815510557964274`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       18.420680743952367`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       20.72326583694641, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       23.025850929940457`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       27.631021115928547`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       29.933606208922594`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       32.23619130191664, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       34.538776394910684`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       34.94424150301885, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       35.23192357547063, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       35.45506712678484, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{336.65, 2223}, {0., 31.436952941843792`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellLabel->"Out[3]=",
 CellID->34552817,ExpressionUUID->"6f3b982f-74b8-4bb3-af79-fcd36a03ca6d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "45ebd455-1d84-414e-8f14-ddd0ae187576"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"30a0b963-4802-4f28-b97e-77f59c69630a"],

Cell[TextData[{
 "3D plot of the function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]],ExpressionUUID->
  "2e11f3bd-fde9-452e-90ac-3b1d998e9b61"],
 " in gaseous potassium. The thick red line represents the vapor coexistence \
curve."
}], "ExampleText",
 CellID->20254794,ExpressionUUID->"e13ae566-1d7e-42fa-973a-a0a74494fabc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tmin", "=", "900"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tmax", "=", "1600"}], ";"}], 
  RowBox[{"(*", "K", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Log", "@", 
        RowBox[{"fqc", "[", 
         RowBox[{"T", ",", "\[Rho]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", 
         RowBox[{"RhoSatVapK", "[", "Tmin", "]"}], ",", 
         RowBox[{"RhoSatVapK", "[", "Tmax", "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
          RowBox[{"y", "\[LessEqual]", 
           RowBox[{"RhoSatVapK", "[", "x", "]"}]}]}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
          "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(log\), \
\(10\)]\)(\!\(\*StyleBox[SubscriptBox[\"f\", SubscriptBox[\"q\", \
\"c\"]],FontSlant->\"Italic\"]\))\>\"", ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "Bold", ",", "16", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Times New Roman\>\""}]}], 
         "]"}]}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "10"}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T", ",", 
         RowBox[{"RhoSatVapK", "[", "T", "]"}], ",", 
         RowBox[{"Log", "@", 
          RowBox[{"fqc", "[", 
           RowBox[{"T", ",", 
            RowBox[{"RhoSatVapK", "[", "T", "]"}]}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Red"}], 
         "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "->", "Large"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->801374019,ExpressionUUID->"ab537270-25a3-4775-ab35-9cc16a865234"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvfl3XVeV72s/MqAe9VyXelBJiGNZR43VGCnh+r1XRf3yZKBSzcgvtwLp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    "], {{0, 417.}, {576., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{576., 417.},
  PlotRange->{{0, 576.}, {0, 417.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[1]=",
 CellID->13645610,ExpressionUUID->"373b6565-e5d7-4312-b907-359de19529f3"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"e9c211b4-41a2-4217-b4e0-b2d5dc0c14c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"4a615f18-ad4d-4b5d-abb6-4ee6ad5ecece"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"62d9f534-c6a2-4b6f-9490-87e1d5ba548d"],

Cell[TextData[StyleBox[ButtonBox["qc0K",
 BaseStyle->"Hyperlink",
 ButtonData->{"qc0K.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->125236253,ExpressionUUID->"8579f99f-4d3d-4119-8b8b-a3aeb99b0076"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6a4730a7-15cf-4c4d-be97-e830d3ee2c9a"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"6567be88-71e9-4a17-9218-1f15e618df35"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"a87ff20b-9f7b-4a7c-bce7-a0e356e5b53f"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "d94f27e4-8741-4fca-ad29-ecb20f9ee03f"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"fa3ff0ec-3e33-49c7-aa91-5c7c767276c0"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"465bd402-13d4-4296-95ea-c85c262c6a9e"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"fqc",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 38.4122992}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "fqc[T, \\[Rho]] Non-dimensional function f Subscript[q, c] which \
represents the excess variations of the cut-off wave-vector modulus qc0 as a \
function of temperature T and density \\[Rho]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "fqc", "titlemodifier" -> "", "windowtitle" -> 
    "fqc", "type" -> "Symbol", "uri" -> "EOSPotassium/ref/fqc", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> "", "NewStyles" -> 
  False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"c6422a83-8cae-47b7-808a-28b63aaf9588"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8596, 249, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"8978f25b-a964-47ff-aaf3-57344562e3a4",
   CellTags->"PrimaryExamplesSection",
   CellID->259005379]},
 "RasterizedOutput"->{
  Cell[25541, 681, 118237, 1944, 410, "Output",ExpressionUUID->"373b6565-e5d7-4312-b907-359de19529f3",
   CellTags->"RasterizedOutput",
   CellID->13645610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 147390, 2727},
 {"RasterizedOutput", 147588, 2731}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[575, 21, 3606, 83, 53, "AnchorBarGrid",ExpressionUUID->"92261cd1-0ce3-46fb-8f80-d0fbff9dc1ac",
 CellID->1],
Cell[CellGroupData[{
Cell[4206, 108, 388, 9, 54, "ObjectNameGrid",ExpressionUUID->"534537d2-e2b4-4263-812e-3875cce9ebe8"],
Cell[4597, 119, 1188, 32, 138, "Usage",ExpressionUUID->"795c949d-e703-47e8-bb3d-7629587c2415",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5822, 156, 855, 21, 37, "NotesSection",ExpressionUUID->"cfe53d6c-2347-47fd-a0f0-0f8943aeb7ad",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->533351692],
Cell[6680, 179, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"dd2dc5c2-554f-48e2-872a-10a78d91bbb2"],
Cell[6769, 181, 400, 12, 70, "Notes",ExpressionUUID->"06fef707-430d-45dc-a730-3b01d6940cd2",
 CellID->393170804],
Cell[7172, 195, 341, 9, 70, "Notes",ExpressionUUID->"e9956954-ee12-458b-8821-16e923c4caf6",
 CellID->368776926],
Cell[7516, 206, 954, 36, 70, "Notes",ExpressionUUID->"2fc5adea-5b7d-4d67-b88a-3c62f8617e6a",
 CellID->105518218],
Cell[8473, 244, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"5a7af070-249b-4894-b48c-88cc0de0c47f"]
}, Closed]],
Cell[CellGroupData[{
Cell[8596, 249, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"8978f25b-a964-47ff-aaf3-57344562e3a4",
 CellTags->"PrimaryExamplesSection",
 CellID->259005379],
Cell[CellGroupData[{
Cell[9056, 264, 308, 7, 30, "ExampleSection",ExpressionUUID->"4f67c8d2-5bcf-4646-a762-9825de0dbbac",
 CellID->742112932],
Cell[9367, 273, 175, 3, 27, "Input",ExpressionUUID->"e0709fc5-8e0d-4dfa-9511-0650e660d5ef",
 CellID->87419684],
Cell[9545, 278, 401, 10, 61, "ExampleText",ExpressionUUID->"64e2cd6c-f2b7-48f3-ad03-09f9c1ee9619",
 CellID->48819395],
Cell[CellGroupData[{
Cell[9971, 292, 678, 18, 65, "Input",ExpressionUUID->"d19e66e3-de2d-4898-a34d-1d59a3e8f046",
 CellID->422395267],
Cell[10652, 312, 143, 2, 36, "Output",ExpressionUUID->"9229c1cf-ebd3-4cdb-8ec1-bc4fdd98bd8d",
 CellID->38421988],
Cell[10798, 316, 144, 2, 36, "Output",ExpressionUUID->"7a3536bf-705b-4e4c-a5ae-dc77a4ae818e",
 CellID->660745594]
}, Open  ]],
Cell[10957, 321, 352, 10, 42, "ExampleText",ExpressionUUID->"64e1b429-eba4-4dbf-8d68-4dd7b0e6e9dc",
 CellID->119396994],
Cell[CellGroupData[{
Cell[11334, 335, 705, 17, 49, "Input",ExpressionUUID->"389bcf27-b1c3-451a-856b-6b6a81afbeab",
 CellID->58108706],
Cell[12042, 354, 9994, 226, 247, "Output",ExpressionUUID->"6f3b982f-74b8-4bb3-af79-fcd36a03ca6d",
 CellID->34552817]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22085, 586, 306, 7, 70, "ExampleSection",ExpressionUUID->"30a0b963-4802-4f28-b97e-77f59c69630a",
 CellID->258228157],
Cell[22394, 595, 387, 11, 70, "ExampleText",ExpressionUUID->"e13ae566-1d7e-42fa-973a-a0a74494fabc",
 CellID->20254794],
Cell[CellGroupData[{
Cell[22806, 610, 2732, 69, 70, "Input",ExpressionUUID->"ab537270-25a3-4775-ab35-9cc16a865234",
 CellID->801374019],
Cell[25541, 681, 118237, 1944, 410, "Output",ExpressionUUID->"373b6565-e5d7-4312-b907-359de19529f3",
 CellTags->"RasterizedOutput",
 CellID->13645610]
}, Open  ]]
}, Closed]],
Cell[143805, 2629, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"e9c211b4-41a2-4217-b4e0-b2d5dc0c14c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143928, 2634, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"62d9f534-c6a2-4b6f-9490-87e1d5ba548d",
 CellID->1255426704],
Cell[144191, 2643, 210, 4, 70, "SeeAlso",ExpressionUUID->"8579f99f-4d3d-4119-8b8b-a3aeb99b0076",
 CellID->125236253]
}, Open  ]],
Cell[CellGroupData[{
Cell[144438, 2652, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"6567be88-71e9-4a17-9218-1f15e618df35",
 CellID->1584193535],
Cell[144711, 2661, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"a87ff20b-9f7b-4a7c-bce7-a0e356e5b53f"],
Cell[144800, 2663, 384, 10, 70, "RelatedLinks",ExpressionUUID->"fa3ff0ec-3e33-49c7-aa91-5c7c767276c0",
 CellID->426751138]
}, Open  ]],
Cell[145199, 2676, 78, 0, 70, "FooterCell",ExpressionUUID->"465bd402-13d4-4296-95ea-c85c262c6a9e"]
}
]
*)

(* End of internal cache information *)

