(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23316,        593]
NotebookOptionsPosition[     17808,        473]
NotebookOutlinePosition[     20240,        534]
CellTagsIndexPosition[     20155,        529]
WindowTitle->fqc1atm
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "61c90b97-cfe3-408f-ba8c-3b8b9541ee3c"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"abe8266c-8bf3-48de-bc88-3cbfb88a72e3"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"qc0K\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"qc0K.nb", None}, "paclet*"], 
         Part[
          Part[{{"qc0K", {"qc0K.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"qc0K", {"qc0K.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "66d8b141-842c-4daa-83ed-93f81e4ae77f"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"c29f7869-755e-460c-a68e-f6b97dc04699"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/fqc1atm\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/fqc1atm"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/\
fqc1atm.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
            Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$21437], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/fqc1atm", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b8472e31-c950-4ffb-b825-b0c7c0409ec1"]
    }], "AnchorBar",ExpressionUUID->"1b551f61-2712-46a2-a81d-7ce7613bf4b3"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"bbe43dc0-822a-4dc7-a0bd-758ae74a969b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["fqc1atm", "ObjectName",ExpressionUUID->
  "906aa82c-c45e-43da-bf6f-0bb6607045ce"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"0f98c2f7-e19a-4ea9-a88c-0205f3800088"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "df7a56f9-a025-4904-b8e5-b5c2bd37e757"]
}], "ObjectNameGrid",ExpressionUUID->"8c322f28-e288-43dc-bcf5-d322f79495ca"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"fqc1atm", "[", 
       StyleBox["T",
        FontSlant->"Italic"], "]"}]], "InlineFormula",ExpressionUUID->
      "6906560e-01d2-44a7-8460-d311a8c1b3d9"],
     " \[LineSeparator]Non-dimensional function ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["f", 
        SubscriptBox["q", "c"]],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "e5281052-1f3a-443c-a3e2-b4535b5dc764"],
     " which represents the excess variations of the cut-off wave-vector \
modulus ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["q", "c0"],
       FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
      "9708df03-8b2e-4e87-abe1-048e25e2e789"],
     " as a function of temperature ",
     StyleBox["T",
      FontSlant->"Italic"],
     " along the atmospheric isobar in the liquid phase"
    }],ExpressionUUID->"f9348dff-25e0-4c32-974a-12c3e0753f95"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"7ef8e534-3035-4a91-b496-d4869ab84916"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"5201548e-9d06-4d1b-9c3d-21c1c0c84f9b"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"980e35b4-1e32-45f2-ba03-4f7b01872c4d"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c98a9777-052a-4421-8988-f3e6971fe970"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->670682242,ExpressionUUID->"3b273507-d6a6-4cb8-8848-20b62affaded"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"bd4fa03c-de2d-4b01-830f-9f40acb0fc9e"],

Cell[TextData[{
 "The units of ",
 StyleBox["T",
  FontSlant->"Italic"],
 " must be in Kelvin."
}], "Notes",
 CellID->368776926,ExpressionUUID->"1e66649a-4c89-42ed-b174-5d848c59f83d"],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     SubscriptBox["q", "c"], "[", 
     RowBox[{"T", ",", " ", "\[Rho]"}], "]"}],
    FontSlant->"Italic"], "=", 
   RowBox[{
    RowBox[{
     StyleBox[
      SubscriptBox["f", 
       SubscriptBox["q", "c"]],
      FontSlant->"Italic"], "[", 
     StyleBox["T",
      FontSlant->"Italic"], "]"}], "\[Times]", 
    RowBox[{
     SubscriptBox[
      StyleBox["q",
       FontSlant->"Italic"], "c0"], "[", "\[Rho]", "]"}]}]}]], 
  "InlineFormula",ExpressionUUID->"cb42bcf7-77fd-4389-8d8c-208bed8e2472"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"3aee0ef5-6316-42c4-a2ce-b3902e3d2fdf"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"953be2a2-7c11-407a-aef1-8833998ff788"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"6f04ec2c-adfd-4991-8e5e-25905318ee37"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8f74a8be-89a4-4d7e-9fd0-29f2ed9c04a1"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->165928543,ExpressionUUID->"38b0f6ef-f4db-4532-aaf7-7c4583bec716"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "bdb0e2c1-695a-4d4d-a6da-a56ddc4fda93"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2702936,ExpressionUUID->"20fa60f1-c7a2-49a8-9a20-dd83ef08b9a5"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"6fbec887-5a55-48b5-a152-46c6a474fcf4"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "76afb440-3809-43db-af85-59b16684ea13"],
 " is a non-dimensional function but temperature and density variables must \
be given as  numbers without unit"
}], "ExampleText",
 CellID->48819395,ExpressionUUID->"7d07b697-1801-4a3c-921f-d16305ef6dbf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"fqc1atm", "[", "1030.793", "]"}], "\[IndentingNewLine]", 
 RowBox[{"fqc1atm", "[", 
  RowBox[{"QuantityMagnitude", "@", 
   RowBox[{"Quantity", "[", 
    RowBox[{"1030.793", ",", "\"\<Kelvins\>\""}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->422395267,ExpressionUUID->"0566b1a0-683f-4d80-bfe3-2cb4268cb6eb"],

Cell[BoxData["1.3900947099367262`"], "Output",
 CellLabel->"Out[2]=",
 CellID->279140319,ExpressionUUID->"31c9afd0-6e3f-4de7-8b47-ea0ecd55a33a"],

Cell[BoxData["1.3900947099367262`"], "Output",
 CellLabel->"Out[2]=",
 CellID->153277984,ExpressionUUID->"f14a5db8-7d71-4314-b049-719d7caf3bdc"]
}, Open  ]],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["f", 
    SubscriptBox["q", "c"]],
   FontSlant->"Italic"]], "InlineFormula",ExpressionUUID->
  "a1d2cee3-94fa-4198-b98f-57e051cef2d8"],
 " along the atmospheric isobar for the liquid phase"
}], "ExampleText",
 CellID->119396994,ExpressionUUID->"03e37fba-2db3-4418-8989-344f52e9ca82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fqc1atm", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"f\", SubscriptBox[\"q\", \
\"c\"]],FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58108706,ExpressionUUID->"4f2bc2d9-ef8d-4324-b161-a1c237634421"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1As8VFkcB3AkjxTaKOSRd0Q0Mb1w/pVU3iyKQqtFVKLcOzNGDBmvZCZb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       "]]},
     Annotation[#, "Charting`Private`Tag$23242#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 1.0000000000000002`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"f\\\", SubscriptBox[\\\"q\\\", \
\\\"c\\\"]],FontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {1.0000000000000002`, 1.390094707578693}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->399046671,ExpressionUUID->"261ba0b9-5b52-4127-ad55-ef1471cd8053"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"bc9f1b01-285e-4406-ad90-b742620b8454"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"7669d565-cfd7-403a-b83b-c4bce9217665"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"970603a1-03ef-4feb-a685-e4cc7bc44100"],

Cell[TextData[StyleBox[ButtonBox["qc0K",
 BaseStyle->"Hyperlink",
 ButtonData->{"qc0K.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->125236253,ExpressionUUID->"c9e82c36-d854-48e9-bb1a-3228af93d48f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"2b73cf8d-20d6-42c1-a80d-75de9a2449ce"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"349958c4-3f66-466d-be03-21fe842f4478"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"0b082bf6-0736-4baf-91a8-3bf1bf9612bd"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "09437df5-f07a-4856-842b-7f493da5df67"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"6bb6039e-0924-4f12-a19f-872713e2830b"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"659e63d7-3011-4171-9b6c-609981c86fa5"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"fqc1atm",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 36.7832997}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "fqc1atm[T] Non-dimensional function f Subscript[q, c] which represents \
the excess variations of the cut-off wave-vector modulus qc0 as a function of \
temperature T along the atmospheric isobar in the liquid phase", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "fqc1atm", 
    "titlemodifier" -> "", "windowtitle" -> "fqc1atm", "type" -> "Symbol", 
    "uri" -> "EOSPotassium/ref/fqc1atm", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"71bc2ba0-2531-41d4-99f7-5fa990e27e3b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7716, 216, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"38b0f6ef-f4db-4532-aaf7-7c4583bec716",
   CellTags->"PrimaryExamplesSection",
   CellID->165928543]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19957, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[579, 21, 3621, 83, 53, "AnchorBarGrid",ExpressionUUID->"bbe43dc0-822a-4dc7-a0bd-758ae74a969b",
 CellID->1],
Cell[CellGroupData[{
Cell[4225, 108, 392, 9, 54, "ObjectNameGrid",ExpressionUUID->"8c322f28-e288-43dc-bcf5-d322f79495ca"],
Cell[4620, 119, 1136, 29, 138, "Usage",ExpressionUUID->"7ef8e534-3035-4a91-b496-d4869ab84916",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5793, 153, 855, 21, 37, "NotesSection",ExpressionUUID->"3b273507-d6a6-4cb8-8848-20b62affaded",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->670682242],
Cell[6651, 176, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"bd4fa03c-de2d-4b01-830f-9f40acb0fc9e"],
Cell[6740, 178, 183, 6, 70, "Notes",ExpressionUUID->"1e66649a-4c89-42ed-b174-5d848c59f83d",
 CellID->368776926],
Cell[6926, 186, 664, 23, 70, "Notes",ExpressionUUID->"3aee0ef5-6316-42c4-a2ce-b3902e3d2fdf",
 CellID->1067943069],
Cell[7593, 211, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"953be2a2-7c11-407a-aef1-8833998ff788"]
}, Closed]],
Cell[CellGroupData[{
Cell[7716, 216, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"38b0f6ef-f4db-4532-aaf7-7c4583bec716",
 CellTags->"PrimaryExamplesSection",
 CellID->165928543],
Cell[CellGroupData[{
Cell[8176, 231, 306, 7, 30, "ExampleSection",ExpressionUUID->"20fa60f1-c7a2-49a8-9a20-dd83ef08b9a5",
 CellID->2702936],
Cell[8485, 240, 175, 3, 27, "Input",ExpressionUUID->"6fbec887-5a55-48b5-a152-46c6a474fcf4",
 CellID->87419684],
Cell[8663, 245, 401, 10, 61, "ExampleText",ExpressionUUID->"7d07b697-1801-4a3c-921f-d16305ef6dbf",
 CellID->48819395],
Cell[CellGroupData[{
Cell[9089, 259, 349, 7, 44, "Input",ExpressionUUID->"0566b1a0-683f-4d80-bfe3-2cb4268cb6eb",
 CellID->422395267],
Cell[9441, 268, 144, 2, 36, "Output",ExpressionUUID->"31c9afd0-6e3f-4de7-8b47-ea0ecd55a33a",
 CellID->279140319],
Cell[9588, 272, 144, 2, 36, "Output",ExpressionUUID->"f14a5db8-7d71-4314-b049-719d7caf3bdc",
 CellID->153277984]
}, Open  ]],
Cell[9747, 277, 356, 10, 42, "ExampleText",ExpressionUUID->"03e37fba-2db3-4418-8989-344f52e9ca82",
 CellID->119396994],
Cell[CellGroupData[{
Cell[10128, 291, 646, 15, 49, "Input",ExpressionUUID->"4f2bc2d9-ef8d-4324-b161-a1c237634421",
 CellID->58108706],
Cell[10777, 308, 5528, 112, 255, "Output",ExpressionUUID->"261ba0b9-5b52-4127-ad55-ef1471cd8053",
 CellID->399046671]
}, Open  ]]
}, Open  ]],
Cell[16332, 424, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"bc9f1b01-285e-4406-ad90-b742620b8454"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16455, 429, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"970603a1-03ef-4feb-a685-e4cc7bc44100",
 CellID->1255426704],
Cell[16718, 438, 210, 4, 70, "SeeAlso",ExpressionUUID->"c9e82c36-d854-48e9-bb1a-3228af93d48f",
 CellID->125236253]
}, Open  ]],
Cell[CellGroupData[{
Cell[16965, 447, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"349958c4-3f66-466d-be03-21fe842f4478",
 CellID->1584193535],
Cell[17238, 456, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"0b082bf6-0736-4baf-91a8-3bf1bf9612bd"],
Cell[17327, 458, 384, 10, 70, "RelatedLinks",ExpressionUUID->"6bb6039e-0924-4f12-a19f-872713e2830b",
 CellID->426751138]
}, Open  ]],
Cell[17726, 471, 78, 0, 70, "FooterCell",ExpressionUUID->"659e63d7-3011-4171-9b6c-609981c86fa5"]
}
]
*)

(* End of internal cache information *)

