(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     21483,        549]
NotebookOptionsPosition[     15992,        429]
NotebookOutlinePosition[     18293,        488]
CellTagsIndexPosition[     18208,        483]
WindowTitle->qc0K
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "6af7cc35-8626-4a5d-9a23-ee5fdacadcda"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"db33343d-56d2-4571-9bfa-242e23b89a76"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"fqc\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"fqc.nb", None}, "paclet*"], 
         Part[
          Part[{{"fqc", {"fqc.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"fqc", {"fqc.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "262062f6-d39f-410f-ab87-9d8130450475"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"016e703c-dc02-4632-97ab-2042719a9f05"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/qc0K\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/qc0K"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/qc0K.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$24457], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/qc0K", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "454f57dc-63d6-4ce2-ba43-03e91156c810"]
    }], "AnchorBar",ExpressionUUID->"a37ace98-333f-46e8-8011-bccce4c23b84"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"ddce266d-642f-4a01-82ed-7786a65ae545"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["qc0K", "ObjectName",ExpressionUUID->
  "7f51daa7-d35c-4501-a2c6-331459e5506d"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"bb335ab8-039d-4330-b366-163ae0fb14d9"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "f201121e-1797-4e85-bba1-ec9d47139f39"]
}], "ObjectNameGrid",ExpressionUUID->"433b5991-d04e-464c-a883-0c097e2221e9"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"qc0K", "[", "\[Rho]", "]"}]], "InlineFormula",ExpressionUUID->
      "ce656337-fe33-4965-89bf-a490836d9bb4"],
     " \[LineSeparator]Characteristic cut-off wave-vector modulus ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["q",
        FontSlant->"Italic"], "c0"]], "InlineFormula",ExpressionUUID->
      "77669c15-7fa3-4474-991a-fb5c5b95f9ae"],
     " (",
     Cell[BoxData[
      SuperscriptBox["cm", 
       RowBox[{"-", "1"}]]], "InlineFormula",ExpressionUUID->
      "140e8c33-66bd-4c35-b3e9-e48540484b96"],
     ") as function of density \[Rho]"
    }],ExpressionUUID->"09d0af05-00ea-400f-82fe-df335c83a729"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"f14cf51d-3267-434c-ada8-b4fbf1af158d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    TemplateBox[{6},
     "Spacer1"]],ExpressionUUID->"29b26003-6c5c-420d-98e7-b92bbfbcbcd4"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"f72976bf-234a-486d-8558-85af9cab4c09"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"abc9da93-6e75-490c-91f2-12ed73d31b48"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->244658846,ExpressionUUID->"3c4a6903-1609-4b08-9e8b-bb48d864b028"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"ddb36d78-e424-42d1-8c07-69b9216e09b2"],

Cell[TextData[{
 "By default the units of \[Rho] must be in g/",
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
  "dfbcad88-bf34-4dfe-acca-367f43d08bbe"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"f7a3cc68-5425-4cb6-b779-2ec705cb7b04"],

Cell["", "SectionFooterSpacer",ExpressionUUID->"6d727170-f59f-4009-a3eb-a900c3f7dfe7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c887cb3e-faa1-418f-8496-20c7b36a730c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "eff67fd7-4400-49b7-89a6-5189e363960e"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->662501583,ExpressionUUID->"d9138bcb-009b-491d-a05a-298b0c94be51"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "54803c28-5b71-4fc0-981d-78a4887376ba"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->360119495,ExpressionUUID->"8ce08d57-ee59-4901-80b1-ebb7f3d3d651"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"ad73ce32-8690-4e29-bedd-a9e0f81ac3fd"],

Cell["\<\
If no unit is entered then the function returns a number with the default \
units. Otherwise it is possible to obtain a number with dimensions if units \
are given to the density variable.\
\>", "ExampleText",
 CellID->544149791,ExpressionUUID->"e5000030-c5f1-411d-8de2-f0534ed67c87"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"qc0K", "[", "rhocK", "]"}], "\[IndentingNewLine]", 
 RowBox[{"qc0K", "[", 
  RowBox[{"Quantity", "[", 
   RowBox[{"rhocK", ",", 
    FractionBox["\"\<Grams\>\"", 
     SuperscriptBox["\"\<Centimeters\>\"", "3"]]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"qc0K", "[", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"rhocK", ",", 
      FractionBox["\"\<Grams\>\"", 
       SuperscriptBox["\"\<Centimeters\>\"", "3"]]}], "]"}], ",", 
    FractionBox["\"\<Kilograms\>\"", 
     SuperscriptBox["\"\<Meters\>\"", "3"]]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->419134748,ExpressionUUID->"7c00b2e0-5f67-436c-82a6-d453d478ac67"],

Cell[BoxData["4.4559313286014184`*^7"], "Output",
 CellLabel->"Out[2]=",
 CellID->95044175,ExpressionUUID->"0fb2624f-5724-4367-9018-2effc35721dc"],

Cell[BoxData[
 TemplateBox[{"4.4559313286014184`*^7", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"cm\""}], "reciprocal centimeters", 
   FractionBox["1", "\"Centimeters\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->848703404,ExpressionUUID->"918e0032-7604-4fbb-9240-87e2f2737cd4"],

Cell[BoxData[
 TemplateBox[{"4.4559313286014184`*^7", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"cm\""}], "reciprocal centimeters", 
   FractionBox["1", "\"Centimeters\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->292712496,ExpressionUUID->"8ab9626c-3d6a-48b2-a04a-54a49c19073f"]
}, Open  ]],

Cell["\<\
Variation of qc0K along the atmospheric isobar for the liquid phase\
\>", "ExampleText",
 CellID->119396994,ExpressionUUID->"42885ed3-e8c2-4951-b104-48d16ad3bbf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"qc0K", "[", 
     RowBox[{"Rho1atm", "[", "T", "]"}], "]"}], "*", "1*^-7"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "TmpK", ",", "1030.793"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", ",", 
      "\"\<\!\(\*SuperscriptBox[\(10\), \(-7\)]\) \!\(\*SubscriptBox[\(q\), \
\(c0\)]\) (\!\(\*SuperscriptBox[\(cm\), \(-1\)]\))\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58108706,ExpressionUUID->"50edb4e3-cd30-45da-aa15-cddeba24449b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzns0lHkYB/AREarRltj3/amVSNfddW+z9SXNWlKUS9Yla7dx2zQuk0sj
GuM6mHfndLYWkVI7tiRtLpVKiFp0CEeJym1QOORsp5bYd/94zvd8zvOc73kM
A48dOLKIw+G4sPN/GtJ2Qr6WEJ33ztS2TxBcaCw8/mSZEH4h3bSC9frI+Rir
FUIE9tbFnmRt+vhOvLq+EJ9V5VlvZr0txirpsjF7L3J+LBkn+KZjs1QJIeSG
HrY2bwncpauL+DFC2FQU+J8fJUidfdvCHxJCFh6aJBwk8CvyFNxtOw7v7yQP
PJ8RnBuPvRJaGoMdOr7vlz0hKJB73K5PiUXLnaNcbgPBivnpVVGCOJjOuoj3
3SKYWM7TiHOOh/+vHf3eZQQ7hr33dNmcgFe7zrriYgLn1aZefYYiiEr2a5nn
EjSMl3JsZ0XQVZXmShiCsvSZf6aUCfBIvl64MpVA9e8p8VzdSSRXXTcLEBHo
8xWDf+UmotEi3WokkqBtkPsowD4JKhESlZJgAsegDW/kZUm4aTAy+sVhgrjW
NWZTxqcwN7jJpt2dQPvHmZ+Mck9B+brHuMKJwK3pYv8pdTFcBZrXHO0IXHUs
UrRFYlxoGw3jWhOobTkfXTsmxqLW2KXirQQRm8Yzzgckw9+rO9HIiGCXp26G
Z1cyvN5H8Sb1CR64U53W9hJoci3NA7gEc5YLDg7VEpzNKdf7qEYwPnZfRWSS
gp5+o++tZmnYNvspMuQp+La0Xu/MNI09shfRdRqpcPS6VKk7QkPVxDLbRJgK
df5Qn2UfjfjC8OaKt+w+WpP88pTGAV7KDBWQBnEgd31NE42X92OCrrSkQfNV
gsnVuzSMiJNKkH06tEbqVC/foGHg/EHpcj0d1nm9p3cqaMT8kVypRTKwcKPS
f/IcjUzl5JV3TAZsavvDcuVs/wfLicXzGeD1mhUNp9HoGPd1d4jORMedumuG
IhqaNw9rXBvIROtDjnxOQKNQsat4Yp8Uvw+krxg5QmMycYF/qEGKkN2Np8u9
abzbmCec/DoLziNTwQb7aJRVrv6zTJEFNY/dhj52NFoExx7xDLJxMDWxPdeC
RsGni2aamdmgOQ+bE01pbDxaXfd+IRuvdKXPDGkaIWWKAm54DtTComShy9l/
1h7/ef55DgbWRP1bpUIjMMLIVX+/DJJGO5WrMxQEv11N86uRod7a7/5eJYWh
qvKIPfdkGJtbFaHD+tDzSp+ttTLEVSQYdA5TAHnw5ad6GTY4+vN9WOtc6OrO
b5YhYMCuOmSIQnnp/IbeHhny9Op8UgYovGtwffTDRxmeHKPzql9S4Cs9btjP
ylAqX1d0gvULDZ/8TZ9k6L5VU7STdeAlM5sEDoMgt8vyhj4KTqO2S13UGNTy
LMzbeilQ4W43x7UZmGsHhyt7KHTOHyx5vZTBjMc2gxLWOTLPgs5lDPSyYhvD
WC8q90mv4TLYPn16yfRzCm9mjvhmrWRQpd/hNPuMQrEk2C1pFQP17QWtd1n7
64bxonUZNJUNOyWxfmol+MpXj0F857DFYtZZTZHGrvoMDPLzi5q6KfAOCSmH
zxmcnWheksmaMxbDtaEYSLsiQ/eyvh0Xr7aFZpAQwDQuZ/0frqomqQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$13517#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{336.65, 6.710017302095477},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-7\\)]\\) \\!\\(\\*SubscriptBox[\
\\(q\\), \\(c0\\)]\\) (\\!\\(\\*SuperscriptBox[\\(cm\\), \\(-1\\)]\\))\"", 
      TraditionalForm], None}, {
     FormBox[
     "\"\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{336.65, 1030.793}, {6.710017302095477, 7.232245454084211}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->265915998,ExpressionUUID->"288c6d69-35b3-43e7-9762-a080eef77ed1"]
}, Open  ]]
}, Open  ]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"09c8ebac-b2c0-496a-a76f-8ecf2cb598ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"9aec1596-afe7-4fee-aacb-49ed94852837"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"ef28a829-16fa-44cb-86fa-78e45481e41c"],

Cell[TextData[StyleBox[ButtonBox["fqc",
 BaseStyle->"Hyperlink",
 ButtonData->{"fqc.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->717804418,ExpressionUUID->"2d5abdc1-c24f-4ccb-b65d-7ace9b1a0346"],

Cell[TextData[StyleBox[ButtonBox["fqc1atm",
 BaseStyle->"Hyperlink",
 ButtonData->{"fqc1atm.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->806991890,ExpressionUUID->"a4b06a1e-d263-4438-ac7f-acba772125a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"5dc98cb2-6f0e-4bb8-98f2-7c1e476c93aa"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"1b23621e-08a7-4eb5-93a5-e967920f24cf"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"9322ee41-e4a7-4d9e-9421-6f6f656fef0f"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "b0a9fd00-f8df-4fcd-8603-038c255340ac"]], "RelatedLinks",
 CellID->426751138,ExpressionUUID->"92223dcb-c6bb-470d-977f-9b3ce6b13fd7"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"baa2687d-71ab-4bf8-a1eb-9c60e6b47286"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"qc0K",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 53.2202972}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "qc0K[\\[Rho]] Characteristic cut-off wave-vector modulus qc0 (cm -1) as \
function of density \\[Rho]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "qc0K", "titlemodifier" -> "", "windowtitle" -> "qc0K", "type" -> 
    "Symbol", "uri" -> "EOSPotassium/ref/qc0K", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"e63f0f93-f25e-4942-8ce4-d2c07172e4a3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6863, 183, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d9138bcb-009b-491d-a05a-298b0c94be51",
   CellTags->"PrimaryExamplesSection",
   CellID->662501583]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18010, 476}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[576, 21, 3604, 83, 53, "AnchorBarGrid",ExpressionUUID->"ddce266d-642f-4a01-82ed-7786a65ae545",
 CellID->1],
Cell[CellGroupData[{
Cell[4205, 108, 389, 9, 54, "ObjectNameGrid",ExpressionUUID->"433b5991-d04e-464c-a883-0c097e2221e9"],
Cell[4597, 119, 883, 21, 112, "Usage",ExpressionUUID->"f14cf51d-3267-434c-ada8-b4fbf1af158d",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5517, 145, 855, 21, 37, "NotesSection",ExpressionUUID->"3c4a6903-1609-4b08-9e8b-bb48d864b028",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->244658846],
Cell[6375, 168, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"ddb36d78-e424-42d1-8c07-69b9216e09b2"],
Cell[6464, 170, 273, 6, 70, "Notes",ExpressionUUID->"f7a3cc68-5425-4cb6-b779-2ec705cb7b04",
 CellID->1067943069],
Cell[6740, 178, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"6d727170-f59f-4009-a3eb-a900c3f7dfe7"]
}, Closed]],
Cell[CellGroupData[{
Cell[6863, 183, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"d9138bcb-009b-491d-a05a-298b0c94be51",
 CellTags->"PrimaryExamplesSection",
 CellID->662501583],
Cell[CellGroupData[{
Cell[7323, 198, 308, 7, 30, "ExampleSection",ExpressionUUID->"8ce08d57-ee59-4901-80b1-ebb7f3d3d651",
 CellID->360119495],
Cell[7634, 207, 175, 3, 27, "Input",ExpressionUUID->"ad73ce32-8690-4e29-bedd-a9e0f81ac3fd",
 CellID->87419684],
Cell[7812, 212, 294, 5, 57, "ExampleText",ExpressionUUID->"e5000030-c5f1-411d-8de2-f0534ed67c87",
 CellID->544149791],
Cell[CellGroupData[{
Cell[8131, 221, 715, 18, 95, "Input",ExpressionUUID->"7c00b2e0-5f67-436c-82a6-d453d478ac67",
 CellID->419134748],
Cell[8849, 241, 146, 2, 38, "Output",ExpressionUUID->"0fb2624f-5724-4367-9018-2effc35721dc",
 CellID->95044175],
Cell[8998, 245, 299, 6, 48, "Output",ExpressionUUID->"918e0032-7604-4fbb-9240-87e2f2737cd4",
 CellID->848703404],
Cell[9300, 253, 299, 6, 48, "Output",ExpressionUUID->"8ab9626c-3d6a-48b2-a04a-54a49c19073f",
 CellID->292712496]
}, Open  ]],
Cell[9614, 262, 173, 3, 38, "ExampleText",ExpressionUUID->"42885ed3-e8c2-4951-b104-48d16ad3bbf5",
 CellID->119396994],
Cell[CellGroupData[{
Cell[9812, 269, 737, 17, 49, "Input",ExpressionUUID->"50edb4e3-cd30-45da-aa15-cddeba24449b",
 CellID->58108706],
Cell[10552, 288, 3720, 82, 250, "Output",ExpressionUUID->"288c6d69-35b3-43e7-9762-a080eef77ed1",
 CellID->265915998]
}, Open  ]]
}, Open  ]],
Cell[14299, 374, 86, 0, 70, "SectionFooterSpacer",ExpressionUUID->"09c8ebac-b2c0-496a-a76f-8ecf2cb598ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14422, 379, 260, 7, 70, "SeeAlsoSection",ExpressionUUID->"ef28a829-16fa-44cb-86fa-78e45481e41c",
 CellID->1255426704],
Cell[14685, 388, 208, 4, 70, "SeeAlso",ExpressionUUID->"2d5abdc1-c24f-4ccb-b65d-7ace9b1a0346",
 CellID->717804418],
Cell[14896, 394, 216, 4, 70, "SeeAlso",ExpressionUUID->"a4b06a1e-d263-4438-ac7f-acba772125a8",
 CellID->806991890]
}, Open  ]],
Cell[CellGroupData[{
Cell[15149, 403, 270, 7, 70, "RelatedLinksSection",ExpressionUUID->"1b23621e-08a7-4eb5-93a5-e967920f24cf",
 CellID->1584193535],
Cell[15422, 412, 86, 0, 70, "SectionHeaderSpacer",ExpressionUUID->"9322ee41-e4a7-4d9e-9421-6f6f656fef0f"],
Cell[15511, 414, 384, 10, 70, "RelatedLinks",ExpressionUUID->"92223dcb-c6bb-470d-977f-9b3ce6b13fd7",
 CellID->426751138]
}, Open  ]],
Cell[15910, 427, 78, 0, 70, "FooterCell",ExpressionUUID->"baa2687d-71ab-4bf8-a1eb-9c60e6b47286"]
}
]
*)

(* End of internal cache information *)

