(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     14326,        386]
NotebookOptionsPosition[      9501,        275]
NotebookOutlinePosition[     11751,        334]
CellTagsIndexPosition[     11666,        329]
WindowTitle->rhocK
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {Cell["E O S POTASSIUM SYMBOL", "PacletNameCell",ExpressionUUID->
     "91d4563c-385f-4145-9690-8a2d7f090c31"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "See Also",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"a15b43f9-f7d4-44d1-aeca-56471304e671"],
         TextCell[
          Row[{"See Also", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"TcK\"\>":>Documentation`HelpLookup[
        If[
         StringMatchQ[{"TcK.nb", None}, "paclet*"], 
         Part[
          Part[{{"TcK", {"TcK.nb", None}}}, 1], 2], 
         StringJoin["paclet:", 
          Part[
           Part[{{"TcK", {"TcK.nb", None}}}, 1], 2]]]]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlso"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "860734b2-becf-4fd7-910a-6cbc2ace509b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox[
        InterpretationBox[Cell[TextData[{
          "URL",
          StyleBox[" \[FilledDownTriangle]", "AnchorBarArrow",
           StripOnInput->False]
         }],ExpressionUUID->"87d653bd-e7ea-428f-ba36-204a42ede9ed"],
         TextCell[
          Row[{"URL", 
            Style[" \[FilledDownTriangle]", "AnchorBarArrow"]}]]],
        StripOnInput->False], {"\<\"EOSPotassium/ref/rhocK\"\>":>
       None, "\<\"Copy Wolfram Documentation Center URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["EOSPotassium/ref/rhocK"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/language/EOSPotassium/ref/rhocK.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
             If[
              TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$25216], 
              "http://reference.wolfram.com/system-modeler/", 
              "http://reference.wolfram.com/language/"], 
             "EOSPotassium/ref/rhocK", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "dc0dea08-f17b-4c73-a201-7f1e97aad6f8"]
    }], "AnchorBar",ExpressionUUID->"a8691c7b-52db-4325-8489-e49eda538492"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"e147f280-e622-4600-b6ec-54bcee68671a"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell["rhocK", "ObjectName",ExpressionUUID->
  "cb0919fd-ed74-4d42-8aa3-70976aaf5dbe"],
 Cell[BoxData[
  TemplateBox[{8},
   "Spacer1"]],ExpressionUUID->"1f338eb2-b1a7-46e1-983a-4f59004d9618"],
 Cell[BoxData[
 ""], "ObjectNameTranslation",ExpressionUUID->
  "9092f24f-aab3-4b7d-b148-ee899a8be77e"]
}], "ObjectNameGrid",ExpressionUUID->"ef718b82-c7bc-4e41-93db-6c44a49a4c5d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "Potassium critical point density (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",ExpressionUUID->
      "edf391b5-d7d7-43dd-9471-dc0f989b46a4"],
     ")"
    }],ExpressionUUID->"9ba43171-7757-4c3c-9ce7-edbee199b1f0"]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{None}}}},
 CellID->982511436,ExpressionUUID->"71316627-bc24-40f7-b789-3873604a0a61"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"c8fe90e1-026a-4f4d-8d12-edac95f3e05e"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "ce2bcf0a-fcc6-4944-8f5d-384f3fe46d0d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellTags->"PrimaryExamplesSection",
 CellID->205101970,ExpressionUUID->"2603d958-78a9-42f9-bd6c-1dc1327739b6"],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "08f163e7-787e-40fd-b69c-b0a148674cd2"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->308809529,ExpressionUUID->"041622b7-2857-4690-8f92-11d2314542cb"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<EOSPotassium`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"23288d6b-e617-46fb-8834-1aa85ef81842"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"d38137c4-bd4f-4a70-9cc9-21d1ed7611d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"rhocK", ",", "\"\<g/cm^3\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"40171586-cae0-4bd9-8a15-78245c8b19a0"],

Cell[BoxData[
 TemplateBox[{"0.194`", 
   RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
     SuperscriptBox["\"cm\"", "3"]}], "grams per centimeter cubed", 
   FractionBox["\"Grams\"", 
    SuperscriptBox["\"Centimeters\"", "3"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->148988035,ExpressionUUID->"715280db-886c-4aba-a2f0-8ff014f6d88e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "fabc8c34-c503-4337-9ec8-41f734a49123"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->258228157,ExpressionUUID->"5b8412d9-db4b-4c58-8020-b06ec8f3dcf7"],

Cell["Calculation of the critical compressibility factor", "ExampleText",
 CellID->88502512,ExpressionUUID->"8d241607-6a9e-4945-9832-af257efe14a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zc", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"PcK", "*", "MK"}], 
    RowBox[{"8.3145", "*", "TcK", "*", "rhocK"}]], 
   SuperscriptBox["10", 
    RowBox[{"-", "1"}]]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845394692,ExpressionUUID->"f560477e-4c2e-4ca2-a8ad-7832ca978a40"],

Cell[BoxData["0.17677349131170095`"], "Output",
 CellLabel->"Out[1]=",
 CellID->853808,ExpressionUUID->"df2960d3-c1cd-4757-9094-ff3ed4774151"]
}, Open  ]]
}, Closed]],

Cell["", "SectionFooterSpacer",ExpressionUUID->"404b7387-cf71-4a6e-bc24-84d48e0634ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"17f86e15-7b61-42ff-bcb9-8cc1cf4f77fe"],
 "See Also"
}], "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellID->1255426704,ExpressionUUID->"1e3118bd-a414-4fd0-bd90-835e38abb88f"],

Cell[TextData[StyleBox[ButtonBox["TcK",
 BaseStyle->"Hyperlink",
 ButtonData->{"TcK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->325096921,ExpressionUUID->"f56b995a-b20f-4654-8a0a-647cb1b677dc"],

Cell[TextData[StyleBox[ButtonBox["PcK",
 BaseStyle->"Hyperlink",
 ButtonData->{"PcK.nb", None}],
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->291524538,ExpressionUUID->"23bf9cb8-9d19-4726-9fc3-9d366aed8289"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{6},
   "Spacer1"]],ExpressionUUID->"1fbc81b3-a75f-4179-9224-cba29cca9a6d"],
 "Related Links"
}], "RelatedLinksSection",
 WholeCellGroupOpener->True,
 CellID->1584193535,ExpressionUUID->"30b2d7f1-c752-42d6-afa5-1717b2717490"],

Cell["", "SectionHeaderSpacer",ExpressionUUID->"de0eeb38-f2d5-4c78-b1ae-c9609ee71016"],

Cell[BoxData[Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
      RowBox[{
        RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
    "paclet:guide/Units"},
   "RefLink",
   BaseStyle->"RelatedLinks"]], "InlineFormula",ExpressionUUID->
  "2638982e-a820-492b-99c3-5e90df8e9838"]], "RelatedLinks",
 CellID->1038487239,ExpressionUUID->"5e1ee838-6368-47b8-b938-eb2f8e99bd05"]
}, Open  ]],

Cell[" ", "FooterCell",ExpressionUUID->"90a7819d-9a64-4ea6-a023-242e9753d45a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"rhocK",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "EOSPotassium", ButtonData -> 
         "paclet:EOSPotassium/guide/EOSPotassium", 
         BaseStyle -> {"Link", "DockedLinkTrail"}]}]}}, ColumnAlignments -> 
    Left], "HasOptions" -> False, "ExampleCounter" -> 1, "NeedPlatMsgIn" -> 
  None, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2021, 11, 21, 16, 1, 57.7652985}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "EOSPotassium`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "E O S Potassium Symbol", "language" -> "en", "paclet" -> "EOSPotassium", 
    "status" -> "None", "summary" -> 
    "Potassium critical point density (g/cm^3)", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "rhocK", "titlemodifier" -> "", 
    "windowtitle" -> "rhocK", "type" -> "Symbol", "uri" -> 
    "EOSPotassium/ref/rhocK", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> "", "NewStyles" -> False},
CellContext->"Global`",
FrontEndVersion->"12.3 pour Microsoft Windows (64-bit) (June 19, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  TaggingRules -> Association["NewStyles" -> False], FrontEndVersion -> 
  "12.3 pour Microsoft Windows (64-bit) (June 19, 2021)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"c40bea0b-1a0f-4a24-97f5-a2fce2aa0393"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5113, 135, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2603d958-78a9-42f9-bd6c-1dc1327739b6",
   CellTags->"PrimaryExamplesSection",
   CellID->205101970]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11468, 322}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[577, 21, 3608, 83, 53, "AnchorBarGrid",ExpressionUUID->"e147f280-e622-4600-b6ec-54bcee68671a",
 CellID->1],
Cell[CellGroupData[{
Cell[4210, 108, 390, 9, 54, "ObjectNameGrid",ExpressionUUID->"ef718b82-c7bc-4e41-93db-6c44a49a4c5d"],
Cell[4603, 119, 473, 11, 90, "Usage",ExpressionUUID->"71316627-bc24-40f7-b789-3873604a0a61",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5113, 135, 435, 11, 35, "PrimaryExamplesSection",ExpressionUUID->"2603d958-78a9-42f9-bd6c-1dc1327739b6",
 CellTags->"PrimaryExamplesSection",
 CellID->205101970],
Cell[CellGroupData[{
Cell[5573, 150, 308, 7, 30, "ExampleSection",ExpressionUUID->"041622b7-2857-4690-8f92-11d2314542cb",
 CellID->308809529],
Cell[5884, 159, 175, 3, 27, "Input",ExpressionUUID->"23288d6b-e617-46fb-8834-1aa85ef81842",
 CellID->87419684],
Cell[6062, 164, 139, 1, 38, "ExampleText",ExpressionUUID->"d38137c4-bd4f-4a70-9cc9-21d1ed7611d2",
 CellID->886239600],
Cell[CellGroupData[{
Cell[6226, 169, 198, 4, 27, "Input",ExpressionUUID->"40171586-cae0-4bd9-8a15-78245c8b19a0",
 CellID->21488140],
Cell[6427, 175, 378, 8, 50, "Output",ExpressionUUID->"715280db-886c-4aba-a2f0-8ff014f6d88e",
 CellID->148988035]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6854, 189, 306, 7, 30, "ExampleSection",ExpressionUUID->"5b8412d9-db4b-4c58-8020-b06ec8f3dcf7",
 CellID->258228157],
Cell[7163, 198, 147, 1, 70, "ExampleText",ExpressionUUID->"8d241607-6a9e-4945-9832-af257efe14a3",
 CellID->88502512],
Cell[CellGroupData[{
Cell[7335, 203, 308, 9, 70, "Input",ExpressionUUID->"f560477e-4c2e-4ca2-a8ad-7832ca978a40",
 CellID->845394692],
Cell[7646, 214, 142, 2, 35, "Output",ExpressionUUID->"df2960d3-c1cd-4757-9094-ff3ed4774151",
 CellID->853808]
}, Open  ]]
}, Closed]],
Cell[7815, 220, 86, 0, 29, "SectionFooterSpacer",ExpressionUUID->"404b7387-cf71-4a6e-bc24-84d48e0634ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7938, 225, 260, 7, 73, "SeeAlsoSection",ExpressionUUID->"1e3118bd-a414-4fd0-bd90-835e38abb88f",
 CellID->1255426704],
Cell[8201, 234, 208, 4, 24, "SeeAlso",ExpressionUUID->"f56b995a-b20f-4654-8a0a-647cb1b677dc",
 CellID->325096921],
Cell[8412, 240, 208, 4, 24, "SeeAlso",ExpressionUUID->"23bf9cb8-9d19-4726-9fc3-9d366aed8289",
 CellID->291524538]
}, Open  ]],
Cell[CellGroupData[{
Cell[8657, 249, 270, 7, 73, "RelatedLinksSection",ExpressionUUID->"30b2d7f1-c752-42d6-afa5-1717b2717490",
 CellID->1584193535],
Cell[8930, 258, 86, 0, 14, "SectionHeaderSpacer",ExpressionUUID->"de0eeb38-f2d5-4c78-b1ae-c9609ee71016"],
Cell[9019, 260, 385, 10, 26, "RelatedLinks",ExpressionUUID->"5e1ee838-6368-47b8-b938-eb2f8e99bd05",
 CellID->1038487239]
}, Open  ]],
Cell[9419, 273, 78, 0, 41, "FooterCell",ExpressionUUID->"90a7819d-9a64-4ea6-a023-242e9753d45a"]
}
]
*)

(* End of internal cache information *)

