(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     58419,       1596]
NotebookOptionsPosition[     49203,       1429]
NotebookOutlinePosition[     51672,       1481]
CellTagsIndexPosition[     51629,       1478]
WindowTitle->NewEoSArgon Package
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON GUIDE", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "0573e4ea-da82-42ef-adbf-37ac6d69fc41"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "c03841a7-e131-4e3c-82d6-3f60a8627d27"],
        Background->RGBColor[0.85098, 0.396078, 0],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Functions",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "2d4691f7-d20b-4d55-9164-d1e58442cf12"]
         }],ExpressionUUID->"8ae33752-ca5d-4460-b230-38ffc2cb48d1"],
         StripOnInput->False],{
        "\"CeleriteSonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CeleriteSonNv"], 
         "\"CoefDilatationThermiqueNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefDilatationThermiqueNv"], 
         "\"CoefExpansionAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefExpansionAdimNv"], 
         "\"CoefJouleThomsonAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv"], 
         "\"CompressibiliteKSNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKSNv"], 
         "\"CompressibiliteKTNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKTNv"], "\"CpAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CpAdimNv"], 
         "\"CVAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CVAdimNv"], 
         "\"d2FtotalAdimNvdT2\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2"],
          "\"dFtotalAdimNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dFtotalAdimNvdT"], 
         "\"dPArgonNvdRho\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdRho"], 
         "\"dPArgonNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdT"], 
         "\"dZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNv"], 
         "\"dZtotalNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dZtotalNvdT"], 
         "\"FtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/FtotalAdimNv"], 
         "\"HtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/HtotalAdimNv"], 
         "\"LvapAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/LvapAdimNv"], 
         "\"M\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/M"], 
         "\"Na\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/Na"], 
         "\"PArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PArgonNv"], 
         "\"pc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/pc"], 
         "\"pcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/pcNv"], 
         "\"PFusionArgon\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PFusionArgon"], 
         "\"PRhoSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PRhoSat"], 
         "\"PRhoSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PRhoSatNIST"], 
         "\"ptr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptr"], 
         "\"ptrNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ptrNv"], 
         "\"PTSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PTSat"], 
         "\"PTSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/PTSatNIST"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"rhoc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhoc"], 
         "\"rhocNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhocNv"], 
         "\"rhomaxRonc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhomaxRonc"], 
         "\"RhoSatLiqFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatLiqFromT"], 
         "\"RhoSatLiqNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT"], "\"RhoSatVapFromT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoSatVapFromT"], 
         "\"RhoSatVapNISTFromT\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT"], "\"rhotrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgaz"], 
         "\"rhotrgazNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrgazNv"], 
         "\"rhotrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliq"], 
         "\"rhotrliqNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/rhotrliqNv"], 
         "\"RR\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/RR"], 
         "\"StotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/StotalAdimNv"], 
         "\"tc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/tc"], 
         "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], "\"Tdiv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/Tdiv"], 
         "\"tmaxRonc\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tmaxRonc"], 
         "\"TRhoSat\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TRhoSat"], 
         "\"TSatNIST\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/TSatNIST"], 
         "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"UtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/UtotalAdimNv"], 
         "\"zc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/zc"], 
         "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"GuideFunction"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "f14e0ac3-3c1a-4fb0-8a6f-38d29c4d3764"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1f2e1da6-cb5f-4666-9b90-c23949e28d9a"]
         }],ExpressionUUID->"0da8b8a1-5e11-417e-99da-656421a2633f"],
         StripOnInput->False],{
        "\"NewEoSArgonFunctions\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/NewEoSArgonFunctions"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"GuideMoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c9a03d43-7c55-4a93-a53b-832355f2a125"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "faa898ce-b8b1-4f80-9f46-f0af06be4b08"]
         }],ExpressionUUID->"fe6441f5-59dd-4fd7-abf0-755be99200f9"],
         StripOnInput->False],{
        "\"NewEoSArgon/guide/NewEoSArgon\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/guide/NewEoSArgon"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/guide/\
NewEoSArgon.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$5149], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/guide/NewEoSArgon" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "37eb71c8-1b52-4ff0-88ff-979b1e429616"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "8b6d607f-d3ec-4ba5-a48b-6da33bf15f50"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"d8460b06-8ac2-4d0e-9134-738ed56980de"],

Cell[CellGroupData[{

Cell["NewEoSArgon Package", "GuideTitle",
 CellID->942062912,ExpressionUUID->"de63829e-a383-4d16-8304-ed5603af32d7"],

Cell[TextData[{
 "EQUATIONS D'ETAT DE l'ARGON FLUIDE FAVORISANT LES DATA RONCHI \
(mod\[EGrave]le non-extensif)\nLe nouveau mod\[EGrave]le est en accord avec \
les data du ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST"]], "http://webbook.nist.gov/chemistry/fluid"},
   "WebLink",
   BaseStyle->{"GuideAbstract"}]],ExpressionUUID->
  "48145e9e-6f6a-4a19-a1f3-e17a0849c477"],
 " et avec les data de ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["Ronchi"]], "http://dx.doi.org/10.1016/0022-3115(81)90575-4"},
   "WebLink",
   BaseStyle->{"GuideAbstract"}]],ExpressionUUID->
  "33523b4a-9e46-4313-9be4-de5fefed2c96"],
 " (J. Nucl.Mater. 96,1981) jusqu'\[AGrave] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2e3fb6e7-6ad9-4070-997b-52d5c65e4a12"],
 " et \[Rho] = ",
 Cell[BoxData[
  SubscriptBox["\[Rho]", 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d91d2298-8ed4-48e0-bfe2-7a5cf3ba73f2"],
 ".\nLes quantit\[EAcute]s thermostatiques fondamentales du mod\[EGrave]le \
non-extensif se terminent toutes par Nv.\nLes \[EAcute]quations \
d'\[EAcute]tat fondamentales ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "f22d3e63-0d7d-4c2f-8e19-9fd799095b76"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["StotalAdimNv"]], "paclet:NewEoSArgon/ref/StotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "1ba72fcf-e6c2-4ab5-b599-2b095fef645e"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "edba2c9a-686e-42b9-99a7-d95f27b39844"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b8545812-dbc2-4f15-84de-8bfed990b115"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "0a276a61-0c5a-4aa0-b46c-1b6dfd060af5"],
 " et ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CVAdimNv"]], "paclet:NewEoSArgon/ref/CVAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "d47eaad7-9c2b-4208-aeb2-44996bf8d88d"],
 " sont toutes calculables telles que ",
 StyleBox["T",
  FontSlant->"Italic"],
 " > 0 et \[Rho] \[GreaterEqual] 0. En revanche, toutes les autres \
\[EAcute]quations d'\[EAcute]tat sont calculables uniquement dans le domaine \
fluide, soient pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], "triple"]],ExpressionUUID->
  "0873e687-0424-44be-a6ff-2d8f74800a46"],
 " et \[Rho] \[GreaterEqual] 0.\n",
 StyleBox["La plupart des \[EAcute]quations d'\[EAcute]tat d\[EAcute]pendent \
de T et de \[Rho] de telle sorte que T doit \[EHat]tre en Kelvin et \[Rho] en \
g/",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",
  FontFamily->"Source Sans Pro",
  FontWeight->"Bold",
  FontSlant->"Italic",ExpressionUUID->"312bb484-1de1-4946-a4f1-7d57995ee6a6"],
 "."
}], "GuideAbstract",
 CellID->2001916300,ExpressionUUID->"428efbfe-6afd-4bd5-9588-722c407c8ffc"],

Cell[TextData[{
 "[***************************************************************************\
**********************************************\nEQUATIONS OF STATE OF FLUID \
ARGON FAVORING RONCHI'S DATA (non-extensive model)\nThe new model agrees with \
",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST"]], "http://webbook.nist.gov/chemistry/fluid"},
   "WebLink",
   BaseStyle->{"GuideAbstract"}]],ExpressionUUID->
  "6a970e6b-5177-49da-9f79-484c38469ab0"],
 " data and with Ronchi's data (J. Nucl.Mater. 96,1981) up to ",
 StyleBox["T",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], 
   RowBox[{"max", ",", "Ronc"}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2c968664-5b33-4be2-8341-224c18af27ed"],
 " and \[Rho] = ",
 Cell[BoxData[
  SubscriptBox["\[Rho]", 
   RowBox[{"max", ",", "Ronc"}]]],ExpressionUUID->
  "2909abd0-31ae-4458-8f8c-62fc5a7e00d7"],
 ".\nThe fundamental thermostatic quantities of the non-extensive model all \
end in Nv.\nThe basic equations of state ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "aac57870-7bf9-4bca-b50b-02e3052294fa"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["StotalAdimNv"]], "paclet:NewEoSArgon/ref/StotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "6a61c683-3cbc-4933-aa01-265098c08cc7"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "5c726fff-2501-4951-97b8-7d8989a5b2af"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "9b5d340f-d369-46e0-9e86-7df4b025efae"],
 ", ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "c6446f21-eef1-4d08-ad4a-f55881851619"],
 " and ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CVAdimNv"]], "paclet:NewEoSArgon/ref/CVAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "66f96208-6c33-4399-ad6a-c9242aa3b00f"],
 " equations are all computable such that ",
 StyleBox["T",
  FontSlant->"Italic"],
 " > 0 and \[Rho] \[GreaterEqual] 0. In contrast, all other equations of \
state are calculable only in the fluid domain for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T",
    FontSlant->"Italic"], "triple"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "3ddd1ada-97a9-41ed-bc68-f5b363bade12"],
 " and \[Rho] \[GreaterEqual] 0.\n",
 StyleBox["Most of the equations of state are functions of T and \[Rho] such \
that T must be in Kelvin and \[Rho] in g/",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  SuperscriptBox["cm", "3"]], "InlineFormula",
  FontFamily->"Source Sans Pro",
  FontWeight->"Bold",
  FontSlant->"Italic",ExpressionUUID->"a1ce14ed-c9de-4650-8296-83ea42603ff7"],
 ".\n*************************************************************************\
************************************************]"
}], "GuideAbstract",
 CellID->426863843,ExpressionUUID->"bead78e3-a2f0-4b61-ba61-41afc46b0271"],

Cell["Code for loading the package", "ExampleText",
 CellID->71887481,ExpressionUUID->"f136fcc2-66a6-4a64-87a9-7b209c8b9b2c"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->496469109,ExpressionUUID->"085694cc-f3e0-47ea-9064-44f3faf1953b"],

Cell["\t", "GuideDelimiterSubsection",ExpressionUUID->"954ab08d-4966-41f1-9290-fff7216af339"],

Cell[CellGroupData[{

Cell["Universal constants", "GuideFunctionsSubsection",
 CellID->173109221,ExpressionUUID->"f2ee0a9c-4601-498f-af3c-fbcf98a578f4"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RR"]], "paclet:NewEoSArgon/ref/RR", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "11e09c7e-4ca2-4f0c-bece-784678d3983d"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Universal gas constant"
}], "GuideText",
 CellID->203374175,ExpressionUUID->"350487ed-1e03-4c10-bbd1-a5772e6fcf78"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["Na"]], "paclet:NewEoSArgon/ref/Na", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "609202d1-ef7a-422a-b4c1-c38efa886cc6"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Avogradro constant"
}], "GuideText",
 CellID->1463276848,ExpressionUUID->"07ea87e2-990f-48bc-9698-5781892ad734"],

Cell["\t", "GuideDelimiterSubsection",
 CellID->5487872,ExpressionUUID->"e2d3bc31-8e4d-467a-b67a-e99c0c4df290"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Characteristic parameters of argon", "GuideFunctionsSubsection",
 CellID->69685069,ExpressionUUID->"41317112-363f-401e-b0a2-61860317017a"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["M"]], "paclet:NewEoSArgon/ref/M", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "52279dc7-8c4a-4b6d-8c6c-223a716aab64"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Molar mass"
}], "GuideText",
 CellID->578584540,ExpressionUUID->"af567f7a-ff0e-4620-b901-b17f61950f43"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tmaxRonc"]], "paclet:NewEoSArgon/ref/tmaxRonc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "122be74e-eebf-4f3c-9f3c-f78b1fe3fa53"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Maximum temperature of Ronchi's data"
}], "GuideText",
 CellID->187963972,ExpressionUUID->"f334140e-98a4-4f80-824c-72f1a25f17b6"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhomaxRonc"]], "paclet:NewEoSArgon/ref/rhomaxRonc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b41e60b4-83d9-4d53-9989-396214a01d06"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Maximum density of Ronchi's data"
}], "GuideText",
 CellID->55115155,ExpressionUUID->"f494f7d2-e8b1-4c49-8db6-04b1c8170bf9"],

Cell[TextData[StyleBox["From NIST database",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "GuideText",
 CellID->82385213,ExpressionUUID->"c39b326d-af6c-4bf0-be69-7cc5982ad9f2"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tc"]], "paclet:NewEoSArgon/ref/tc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "70729b5d-814a-4edb-bccf-a4582c889d39"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["pc"]], "paclet:NewEoSArgon/ref/pc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "488adbfe-a034-45c6-bd31-05c79f257fd8"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhoc"]], "paclet:NewEoSArgon/ref/rhoc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "754d24fc-f5cc-48ff-bd29-43d82594d596"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["zc"]], "paclet:NewEoSArgon/ref/zc", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "bdd1a714-8ff3-4668-a086-116999402b85"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ptr"]], "paclet:NewEoSArgon/ref/ptr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "11b2c1f2-735e-436c-afe0-38885ae4a869"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "c68096ef-cb11-4434-a4c3-a6700fa54586"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhotrgaz"]], "paclet:NewEoSArgon/ref/rhotrgaz", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "3832cec8-c3fe-4c6c-b942-f64ca9103321"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhotrliq"]], "paclet:NewEoSArgon/ref/rhotrliq", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "71c9d014-60c6-477c-ab21-6cef9d2b2b75"],
 " "
}], "InlineGuideFunctionListing",
 CellID->22915301,ExpressionUUID->"419254a0-9e4b-4378-a744-396598417a87"],

Cell[TextData[StyleBox["From Maxwell relations",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "GuideText",
 CellID->94642243,ExpressionUUID->"73abe161-2297-401f-b273-dbac1223ed0a"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "88777ba1-6e18-4386-b9d6-c3fcf94d4082"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["pcNv"]], "paclet:NewEoSArgon/ref/pcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "3eac6dd3-479b-4948-b2e6-e53b76005ac4"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhocNv"]], "paclet:NewEoSArgon/ref/rhocNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "f4dbc2a7-ed15-4275-ad85-7e7407ee5cb9"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ptrNv"]], "paclet:NewEoSArgon/ref/ptrNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "92594e2e-6eb5-43ef-a198-1f2326b0c1ca"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhotrgazNv"]], "paclet:NewEoSArgon/ref/rhotrgazNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "f0a35fa2-ca2c-4f1a-a169-c047fc846ac1"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["rhotrliqNv"]], "paclet:NewEoSArgon/ref/rhotrliqNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "e3a297a2-eddd-4f1e-9b8b-99223be273ef"]
}], "InlineGuideFunctionListing",
 CellID->33644326,ExpressionUUID->"b4d052f5-a0ba-462c-9d6b-b3338e438ab8"],

Cell["\t", "GuideDelimiterSubsection",
 CellID->195981991,ExpressionUUID->"4cb3f7e1-0454-4015-bbbe-053d78049b2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Melting line of argon", "GuideFunctionsSubsection",
 CellID->316269750,ExpressionUUID->"767e6ffa-fe61-49b8-9f59-4f26692c6eeb"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PFusionArgon"]], "paclet:NewEoSArgon/ref/PFusionArgon", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "3be7c84b-322b-4413-856e-26dc0652aa50"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Melting line pressure versus temperature"
}], "GuideText",
 CellID->602870068,ExpressionUUID->"fbfc6044-579e-46dc-b9d7-94dbaa21bcbe"],

Cell["\t", "GuideDelimiterSubsection",
 CellID->43669263,ExpressionUUID->"5efd6a28-e178-4689-8d61-f8e726eb0e19"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Saturation properties of argon", "GuideFunctionsSubsection",
 CellID->293011473,ExpressionUUID->"3866f208-8177-47a0-b458-155cce3607ca"],

Cell[TextData[StyleBox["From NIST database",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "GuideText",
 CellID->103015840,ExpressionUUID->"20233fc1-84a5-4975-a383-8f8be1660ce1"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["TSatNIST"]], "paclet:NewEoSArgon/ref/TSatNIST", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b91d528f-a95e-4c17-a20c-52c02c9cd7d1"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PTSatNIST"]], "paclet:NewEoSArgon/ref/PTSatNIST", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "9b310b85-e917-4a31-98ba-531e428c82d7"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PRhoSatNIST"]], "paclet:NewEoSArgon/ref/PRhoSatNIST", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "8dee1eed-7092-4b2b-ac14-312fcde67b24"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RhoSatLiqNISTFromT"]], 
    "paclet:NewEoSArgon/ref/RhoSatLiqNISTFromT", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "8cef2116-bb3a-4636-a69f-1bd62c9497c9"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RhoSatVapNISTFromT"]], 
    "paclet:NewEoSArgon/ref/RhoSatVapNISTFromT", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b4b0ecc2-e81c-41fc-a084-36d682c6cfb9"],
 " "
}], "InlineGuideFunctionListing",
 CellID->32738630,ExpressionUUID->"19a3d4d0-ca40-40bf-9cdb-9d2f4511f172"],

Cell[TextData[StyleBox["From Maxwell relations",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "GuideText",
 CellID->72557618,ExpressionUUID->"d0fc9b67-abc1-41f7-b696-f2f908f4d1e5"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["LvapAdimNv"]], "paclet:NewEoSArgon/ref/LvapAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "e35d690f-9d34-41c9-a378-7bdc6a91c5cb"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Non-dimensionnal latent heat of vaporization ",
 StyleBox["Lv",
  FontSlant->"Italic"],
 "/",
 StyleBox["RT",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->19781450,ExpressionUUID->"a113947d-638c-4783-a745-dc70deb1c0f6"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["TRhoSat"]], "paclet:NewEoSArgon/ref/TRhoSat", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "64ce05c1-90aa-4bd0-9784-9fe20152cb9c"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PTSat"]], "paclet:NewEoSArgon/ref/PTSat", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "9e183e60-2d99-4372-8c08-6e1d9f29c408"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PRhoSat"]], "paclet:NewEoSArgon/ref/PRhoSat", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "192cda1a-9634-4481-98c1-922363534943"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RhoSatLiqFromT"]], "paclet:NewEoSArgon/ref/RhoSatLiqFromT", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "eb732b54-880f-4212-af1a-d05ccd366aa0"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RhoSatVapFromT"]], "paclet:NewEoSArgon/ref/RhoSatVapFromT", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b8fde937-a2dd-4030-b2b8-7d8b8b6bc83f"]
}], "InlineGuideFunctionListing",
 CellID->201114666,ExpressionUUID->"54c146d3-3c8c-4957-9e3f-7245a1e31a0d"],

Cell["\t", "GuideDelimiterSubsection",
 CellID->322062381,ExpressionUUID->"e02f4246-8072-4a72-8ed9-3cccebeec28b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Non-dimensionnal equations of state of argon", \
"GuideFunctionsSubsection",
 CellID->177270227,ExpressionUUID->"87722c8a-f860-40d8-b45f-64ec829bf282"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "dfc4c7bf-f233-4603-8a9f-12f36909b61b"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Internal energy ",
 StyleBox["U",
  FontSlant->"Italic"],
 "/",
 StyleBox["RT",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->297206461,ExpressionUUID->"95f5003d-e458-4917-a6e3-4a1be5298dae"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["StotalAdimNv"]], "paclet:NewEoSArgon/ref/StotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "32cc65f5-db94-4442-916c-eea9d24bcb8d"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Entropy ",
 StyleBox["S",
  FontSlant->"Italic"],
 "/",
 StyleBox["R",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->713823354,ExpressionUUID->"a5711f70-d4ea-4a1d-9d2b-bfa74e8d473d"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "c62f1d2c-96a0-4212-84b4-53ef0412c6e2"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Enthalpy ",
 StyleBox["H",
  FontSlant->"Italic"],
 "/",
 StyleBox["RT",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->192496419,ExpressionUUID->"19df803c-0bff-42b3-8823-eb990477d19a"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["FtotalAdimNv"]], "paclet:NewEoSArgon/ref/FtotalAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "9c4683a9-c04c-4bce-8a52-8fe374831615"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Free energy ",
 StyleBox["F",
  FontSlant->"Italic"],
 "/",
 StyleBox["RT",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->9828727,ExpressionUUID->"ebf2e687-904b-4d68-81ac-1ee5e2319534"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "b3007335-1812-49f3-8996-da740ab79088"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Compressibility factor ",
 StyleBox["P",
  FontSlant->"Italic"],
 "/",
 "\[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->83312786,ExpressionUUID->"2db62c75-2228-409e-a778-a3bfc78c6da9"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CVAdimNv"]], "paclet:NewEoSArgon/ref/CVAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "d078e007-42ac-4e91-8f76-ec06648d8fca"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isochoric heat capacity ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "V"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "cf9084d8-2b4a-4add-93d4-7f4079977f1b"],
 "/",
 StyleBox["R",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->353554744,ExpressionUUID->"dbf6082d-0b6b-4f82-8642-d475af060e5c"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CpAdimNv"]], "paclet:NewEoSArgon/ref/CpAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "649412e3-d2f1-41c1-b9c7-ae28a27d54eb"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isobaric heat capacity ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "P"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d8a78a29-6fad-4848-82b2-52a5f99288f5"],
 "/",
 StyleBox["R",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->71445533,ExpressionUUID->"7de63536-c073-4c3a-87b4-f2a0c74e1081"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CoefJouleThomsonAdimNv"]], 
    "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "07298615-c239-460d-8ec1-8dd8e8950c04"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Joule-Thomson coefficient \[Mu]",
 StyleBox["R",
  FontSlant->"Italic"],
 "\[Rho]"
}], "GuideText",
 CellID->644329110,ExpressionUUID->"4e653cc1-ad09-420b-beff-99d521bd9e43"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CoefExpansionAdimNv"]], 
    "paclet:NewEoSArgon/ref/CoefExpansionAdimNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "a21439d6-d70d-4249-a9d7-95100937b47e"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isothermal throttling coefficient ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", "T"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "c38b0d3a-1937-429a-920d-29b680be4d45"],
 "\[Rho]"
}], "GuideText",
 CellID->766209303,ExpressionUUID->"1feb6f11-9c62-4da0-91f0-9077fbd230d5"],

Cell["\t", "GuideDelimiter",
 CellID->227831175,ExpressionUUID->"451355a1-6ef6-4b55-96f5-b2883e77da55"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["dFtotalAdimNvdT"]], "paclet:NewEoSArgon/ref/dFtotalAdimNvdT", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "34149f99-d43a-4dcc-af67-41687c36158b"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["d2FtotalAdimNvdT2"]], 
    "paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2", "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "9f6218a3-3082-4663-a9ed-250c4daaaf63"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["dZtotalNvdT"]], "paclet:NewEoSArgon/ref/dZtotalNvdT", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "c8b60e51-d6ba-4092-95c6-ab6bfacab402"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["dZtotalNv"]], "paclet:NewEoSArgon/ref/dZtotalNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "e1ce701b-f7cd-40ef-be19-bf191fc01fa1"]
}], "InlineGuideFunctionListing",
 CellID->81636293,ExpressionUUID->"8d051a81-0ec2-476f-ad70-f4fed6776c38"],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892,ExpressionUUID->"eb353685-b089-484c-aeef-97ab71049c1d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dimensionnal equations of state of argon", "GuideFunctionsSubsection",
 CellID->502727947,ExpressionUUID->"ad042db9-d16f-4f3b-b967-09f6969f8818"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["Tdiv"]], "paclet:NewEoSArgon/ref/Tdiv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "6b8d08c4-de27-44ef-a790-cf12cd29f6de"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Divergence temperature curve of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "V"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "04aa8b29-a3a8-4e49-b1c6-453b267838b0"],
 " versus \[Rho]"
}], "GuideText",
 CellID->425910848,ExpressionUUID->"08826eff-490b-413c-b889-a019ffa5bed0"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CoefDilatationThermiqueNv"]], 
    "paclet:NewEoSArgon/ref/CoefDilatationThermiqueNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "10251aa1-0a4d-45cb-8311-65ff337263c5"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isobaric thermal expansion coefficient \[Beta] = ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "V"], 
   SubscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"\[PartialD]", "V"}], 
      RowBox[{"\[PartialD]", "T"}]], ")"}], "P"]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2dfaa8c6-3613-48b7-b70e-5ba156b02e12"]
}], "GuideText",
 CellID->146361161,ExpressionUUID->"1ed129d8-6278-47f1-8ca2-bd33cbac2d1f"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CompressibiliteKTNv"]], 
    "paclet:NewEoSArgon/ref/CompressibiliteKTNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "d5d1b2ba-628d-4825-bbb1-48f82cbc03ef"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isothermal compressibility coefficient ",
 Cell[BoxData[
  SubscriptBox["K", "T"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "7c9dcc10-4f65-4e2d-ad76-e80375b52f59"],
 " = -",
 Cell[BoxData[
  FractionBox["1", "V"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "de00bfc1-e186-48a0-be33-534849bf9564"],
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"\[PartialD]", "V"}], 
     RowBox[{"\[PartialD]", "P"}]], ")"}], "T"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "80571b0c-be41-4966-bae2-165b2166aa4c"]
}], "GuideText",
 CellID->510141,ExpressionUUID->"0f23e7e0-4afd-40b2-9c90-4cb711373512"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CompressibiliteKSNv"]], 
    "paclet:NewEoSArgon/ref/CompressibiliteKSNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "f4435415-48bc-4315-a0bf-07d669801a3e"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Isentropic compressibility coefficient ",
 Cell[BoxData[
  SubscriptBox["K", "S"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5f997805-b1ce-48bd-af37-43e8834751e8"],
 " = -",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "V"], 
   SubscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"\[PartialD]", "V"}], 
      RowBox[{"\[PartialD]", "P"}]], ")"}], "S"]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ece887a5-fbe4-454b-ae5b-708babdd9008"]
}], "GuideText",
 CellID->242473379,ExpressionUUID->"2e96a96e-63b2-40b4-9097-2f4d2422e288"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["CeleriteSonNv"]], "paclet:NewEoSArgon/ref/CeleriteSonNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "f0bdb9b3-b652-40b5-b1ab-8d01946d59c2"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Sound velocity ",
 StyleBox["c",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->14959100,ExpressionUUID->"9bff37da-efa0-43ca-9169-0d97cd72befb"],

Cell["\t", "GuideDelimiter",
 CellID->161328236,ExpressionUUID->"586744e5-15e3-4c53-95dd-38b5546506c7"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["PArgonNv"]], "paclet:NewEoSArgon/ref/PArgonNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "4d67beb0-4aec-4348-acfb-c41f0e62339f"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "7a48e7e2-baf6-42c4-ac84-a242d226d593"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["dPArgonNvdT"]], "paclet:NewEoSArgon/ref/dPArgonNvdT", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "27c64523-cbc6-4ae0-9b4e-c68c3c4f5904"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["dPArgonNvdRho"]], "paclet:NewEoSArgon/ref/dPArgonNvdRho", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFunctionSans"]], "InlineFunctionSans",ExpressionUUID->
  "d13cbf47-e6dc-444b-882e-9ca98fb9920f"]
}], "InlineGuideFunctionListing",
 CellID->96585471,ExpressionUUID->"d73a4af4-a89d-4292-af5f-58456baf783a"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "GuideMoreAboutSection"]},
      {
       RowBox[{
       "\[FilledVerySmallSquare]", Cell[BoxData[Cell[TextData[Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData["NewEoSArgonFunctions"]], 
            "paclet:NewEoSArgon/ref/NewEoSArgonFunctions", 
            "NewEoSArgon Package Symbol"},
           "PackageLink",
           BaseStyle->"GuideMoreAbout"]],ExpressionUUID->
          "34c80370-7fd0-45b7-a730-1dc4d05a400b"]], "InlineFunctionSans",
          ExpressionUUID->"129cafa1-586c-4c11-b6fa-76479abe023c"]], 
         "GuideMoreAbout",ExpressionUUID->
         "dd231927-e452-4ba2-a8e3-2ebbc6668505"]}]}
     }]}
  }]], "GuideMoreAboutSection",ExpressionUUID->"0eef7cf9-df0d-4e87-8a03-\
3066bcb8a45d"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "GuideRelatedLinksSection"]}]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"GuideRelatedLinks"}]],ExpressionUUID->
          "5445c8c1-c356-46e0-b5c3-3d513c98720d"]}]],ExpressionUUID->
        "707fdec1-afac-4844-a1b5-71f5fa6da181"]], "RelatedLinks",
        ExpressionUUID->"98f3cbb0-20bd-44ab-ab0e-877d6479a67d"]}
     }]}
  }]], "GuideRelatedLinksSection",ExpressionUUID->"bc53d362-42e8-4578-95b2-\
41c3519a0ec7"],

Cell[" ", "FooterCell",ExpressionUUID->"ed3c536b-9ef3-48c9-9374-06206357be96"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NewEoSArgon Package",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> {$Failed, ""}, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 12.9918907}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Guide", "language" -> "en", "paclet" -> "NewEoSArgon", 
    "status" -> "None", "summary" -> 
    "EQUATIONS D'ETAT DE l'ARGON FLUIDE FAVORISANT LES DATA RONCHI (mod\
\[EGrave]le non-extensif) Le nouveau mod\[EGrave]le est en accord avec les \
data du NIST et avec les data de Ronchi (J. Nucl.Mater. 96,1981) jusqu'\
\[AGrave] T = T_max,Ronc et \\[Rho] = \\[Rho]_max,Ronc. Les quantit\[EAcute]s \
thermostatiques fondamentales du mod\[EGrave]le non-extensif se terminent \
toutes par Nv. Les \[EAcute]quations d'\[EAcute]tat fondamentales \
UtotalAdimNv, StotalAdimNv, HtotalAdimNv, FtotalAdimNv, ZtotalNv et CVAdimNv \
sont toutes calculables telles que T > 0 et \\[Rho] >= 0. En revanche, toutes \
les autres \[EAcute]quations d'\[EAcute]tat sont calculables uniquement dans \
le domaine fluide, soient pour T >= T_triple et \\[Rho] >= 0. La plupart des \
\[EAcute]quations d'\[EAcute]tat d\[EAcute]pendent de T et de \\[Rho] de \
telle sorte que T doit \[EHat]tre en Kelvin et \\[Rho] en g/cm^3.", 
    "synonyms" -> {}, "tabletags" -> 
    DocumentationBuild`Make`Private`tabletaggingrules$5047, "title" -> 
    "NewEoSArgon Package", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "NewEoSArgon Package", "type" -> "Guide", "uri" -> 
    "NewEoSArgon/guide/NewEoSArgon"}},
CacheGraphics->False,
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"663bdd55-755d-4109-ba55-6aa215a4cc05"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 10523, 228, 70, "AnchorBarGrid",ExpressionUUID->"d8460b06-8ac2-4d0e-9134-738ed56980de",
 CellID->1],
Cell[CellGroupData[{
Cell[11139, 253, 116, 1, 70, "GuideTitle",ExpressionUUID->"de63829e-a383-4d16-8304-ed5603af32d7",
 CellID->942062912],
Cell[11258, 256, 4066, 119, 70, "GuideAbstract",ExpressionUUID->"428efbfe-6afd-4bd5-9588-722c407c8ffc",
 CellID->2001916300],
Cell[15327, 377, 3909, 110, 70, "GuideAbstract",ExpressionUUID->"bead78e3-a2f0-4b61-ba61-41afc46b0271",
 CellID->426863843],
Cell[19239, 489, 125, 1, 70, "ExampleText",ExpressionUUID->"f136fcc2-66a6-4a64-87a9-7b209c8b9b2c",
 CellID->71887481],
Cell[19367, 492, 268, 5, 70, "Input",ExpressionUUID->"085694cc-f3e0-47ea-9064-44f3faf1953b",
 CellID->496469109],
Cell[19638, 499, 93, 0, 70, "GuideDelimiterSubsection",ExpressionUUID->"954ab08d-4966-41f1-9290-fff7216af339"],
Cell[CellGroupData[{
Cell[19756, 503, 130, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"f2ee0a9c-4601-498f-af3c-fbcf98a578f4",
 CellID->173109221],
Cell[19889, 506, 446, 13, 70, "GuideText",ExpressionUUID->"350487ed-1e03-4c10-bbd1-a5772e6fcf78",
 CellID->203374175],
Cell[20338, 521, 443, 13, 70, "GuideText",ExpressionUUID->"07ea87e2-990f-48bc-9698-5781892ad734",
 CellID->1463276848],
Cell[20784, 536, 111, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"e2d3bc31-8e4d-467a-b67a-e99c0c4df290",
 CellID->5487872]
}, Open  ]],
Cell[CellGroupData[{
Cell[20932, 542, 144, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"41317112-363f-401e-b0a2-61860317017a",
 CellID->69685069],
Cell[21079, 545, 432, 13, 70, "GuideText",ExpressionUUID->"af567f7a-ff0e-4620-b901-b17f61950f43",
 CellID->578584540],
Cell[21514, 560, 472, 13, 70, "GuideText",ExpressionUUID->"f334140e-98a4-4f80-824c-72f1a25f17b6",
 CellID->187963972],
Cell[21989, 575, 471, 13, 70, "GuideText",ExpressionUUID->"f494f7d2-e8b1-4c49-8db6-04b1c8170bf9",
 CellID->55115155],
Cell[22463, 590, 176, 3, 70, "GuideText",ExpressionUUID->"c39b326d-af6c-4bf0-be69-7cc5982ad9f2",
 CellID->82385213],
Cell[22642, 595, 2896, 88, 70, "InlineGuideFunctionListing",ExpressionUUID->"419254a0-9e4b-4378-a744-396598417a87",
 CellID->22915301],
Cell[25541, 685, 180, 3, 70, "GuideText",ExpressionUUID->"73abe161-2297-401f-b273-dbac1223ed0a",
 CellID->94642243],
Cell[25724, 690, 2206, 65, 70, "InlineGuideFunctionListing",ExpressionUUID->"b4d052f5-a0ba-462c-9d6b-b3338e438ab8",
 CellID->33644326],
Cell[27933, 757, 113, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"4cb3f7e1-0454-4015-bbbe-053d78049b2b",
 CellID->195981991]
}, Open  ]],
Cell[CellGroupData[{
Cell[28083, 763, 132, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"767e6ffa-fe61-49b8-9f59-4f26692c6eeb",
 CellID->316269750],
Cell[28218, 766, 484, 13, 70, "GuideText",ExpressionUUID->"fbfc6044-579e-46dc-b9d7-94dbaa21bcbe",
 CellID->602870068],
Cell[28705, 781, 112, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"5efd6a28-e178-4689-8d61-f8e726eb0e19",
 CellID->43669263]
}, Open  ]],
Cell[CellGroupData[{
Cell[28854, 787, 141, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"3866f208-8177-47a0-b458-155cce3607ca",
 CellID->293011473],
Cell[28998, 790, 177, 3, 70, "GuideText",ExpressionUUID->"20233fc1-84a5-4975-a383-8f8be1660ce1",
 CellID->103015840],
Cell[29178, 795, 1913, 55, 70, "InlineGuideFunctionListing",ExpressionUUID->"19a3d4d0-ca40-40bf-9cdb-9d2f4511f172",
 CellID->32738630],
Cell[31094, 852, 180, 3, 70, "GuideText",ExpressionUUID->"d0fc9b67-abc1-41f7-b696-f2f908f4d1e5",
 CellID->72557618],
Cell[31277, 857, 570, 18, 70, "GuideText",ExpressionUUID->"a113947d-638c-4783-a745-dc70deb1c0f6",
 CellID->19781450],
Cell[31850, 877, 1874, 54, 70, "InlineGuideFunctionListing",ExpressionUUID->"54c146d3-3c8c-4957-9e3f-7245a1e31a0d",
 CellID->201114666],
Cell[33727, 933, 113, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"e02f4246-8072-4a72-8ed9-3cccebeec28b",
 CellID->322062381]
}, Open  ]],
Cell[CellGroupData[{
Cell[33877, 939, 157, 2, 70, "GuideFunctionsSubsection",ExpressionUUID->"87722c8a-f860-40d8-b45f-64ec829bf282",
 CellID->177270227],
Cell[34037, 943, 545, 18, 70, "GuideText",ExpressionUUID->"95f5003d-e458-4917-a6e3-4a1be5298dae",
 CellID->297206461],
Cell[34585, 963, 536, 18, 70, "GuideText",ExpressionUUID->"a5711f70-d4ea-4a1d-9d2b-bfa74e8d473d",
 CellID->713823354],
Cell[35124, 983, 538, 18, 70, "GuideText",ExpressionUUID->"19df803c-0bff-42b3-8823-eb990477d19a",
 CellID->192496419],
Cell[35665, 1003, 539, 18, 70, "GuideText",ExpressionUUID->"ebf2e687-904b-4d68-81ac-1ee5e2319534",
 CellID->9828727],
Cell[36207, 1023, 554, 19, 70, "GuideText",ExpressionUUID->"2db62c75-2228-409e-a778-a3bfc78c6da9",
 CellID->83312786],
Cell[36764, 1044, 694, 22, 70, "GuideText",ExpressionUUID->"dbf6082d-0b6b-4f82-8642-d475af060e5c",
 CellID->353554744],
Cell[37461, 1068, 692, 22, 70, "GuideText",ExpressionUUID->"7de63536-c073-4c3a-87b4-f2a0c74e1081",
 CellID->71445533],
Cell[38156, 1092, 550, 17, 70, "GuideText",ExpressionUUID->"4e653cc1-ad09-420b-beff-99d521bd9e43",
 CellID->644329110],
Cell[38709, 1111, 666, 19, 70, "GuideText",ExpressionUUID->"1feb6f11-9c62-4da0-91f0-9077fbd230d5",
 CellID->766209303],
Cell[39378, 1132, 103, 1, 70, "GuideDelimiter",ExpressionUUID->"451355a1-6ef6-4b55-96f5-b2883e77da55",
 CellID->227831175],
Cell[39484, 1135, 1534, 43, 70, "InlineGuideFunctionListing",ExpressionUUID->"8d051a81-0ec2-476f-ad70-f4fed6776c38",
 CellID->81636293],
Cell[41021, 1180, 113, 1, 70, "GuideDelimiterSubsection",ExpressionUUID->"eb353685-b089-484c-aeef-97ab71049c1d",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[41171, 1186, 151, 1, 70, "GuideFunctionsSubsection",ExpressionUUID->"ad042db9-d16f-4f3b-b967-09f6969f8818",
 CellID->502727947],
Cell[41325, 1189, 668, 20, 70, "GuideText",ExpressionUUID->"08826eff-490b-413c-b889-a019ffa5bed0",
 CellID->425910848],
Cell[41996, 1211, 829, 24, 70, "GuideText",ExpressionUUID->"1ed129d8-6278-47f1-8ca2-bd33cbac2d1f",
 CellID->146361161],
Cell[42828, 1237, 1069, 31, 70, "GuideText",ExpressionUUID->"0f23e7e0-4afd-40b2-9c90-4cb711373512",
 CellID->510141],
Cell[43900, 1270, 967, 29, 70, "GuideText",ExpressionUUID->"2e96a96e-63b2-40b4-9097-2f4d2422e288",
 CellID->242473379],
Cell[44870, 1301, 499, 15, 70, "GuideText",ExpressionUUID->"9bff37da-efa0-43ca-9169-0d97cd72befb",
 CellID->14959100],
Cell[45372, 1318, 103, 1, 70, "GuideDelimiter",ExpressionUUID->"586744e5-15e3-4c53-95dd-38b5546506c7",
 CellID->161328236],
Cell[45478, 1321, 1514, 43, 70, "InlineGuideFunctionListing",ExpressionUUID->"d73a4af4-a89d-4292-af5f-58456baf783a",
 CellID->96585471]
}, Open  ]]
}, Open  ]],
Cell[47019, 1368, 1006, 24, 70, "GuideMoreAboutSection",ExpressionUUID->"0eef7cf9-df0d-4e87-8a03-3066bcb8a45d"],
Cell[48028, 1394, 1090, 31, 70, "GuideRelatedLinksSection",ExpressionUUID->"bc53d362-42e8-4578-95b2-41c3519a0ec7"],
Cell[49121, 1427, 78, 0, 70, "FooterCell",ExpressionUUID->"ed3c536b-9ef3-48c9-9374-06206357be96"]
}
]
*)

(* End of internal cache information *)

