(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    237295,       4625]
NotebookOptionsPosition[    229161,       4463]
NotebookOutlinePosition[    231717,       4525]
CellTagsIndexPosition[    231593,       4519]
WindowTitle->CVAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "11964d1d-f7a9-422e-b907-78506c1caebd"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "bb86820f-7995-463e-9a97-023f0db6639e"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "6a3f300d-d01b-4214-97ac-8c8cb6e97929"]
         }],ExpressionUUID->"87ea29a6-230b-499f-afbb-8945ee885eab"],
         StripOnInput->False],{
        "\"CpAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CpAdimNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "45934943-a1d1-47f1-815e-b9af40ff48dd"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "669747a1-52fc-4fa0-94ce-e8ee99a665f1"]
         }],ExpressionUUID->"924fbf07-7f89-4dec-88f5-bacd777802ee"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a650c8ec-20e8-4f41-8cc4-1cb1702f5b5b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "0c8d203a-b166-4ef8-82d6-13ed6ab3b849"]
         }],ExpressionUUID->"32912620-4e69-4eff-84b7-f5017725d8e9"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CVAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CVAdimNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CVAdimNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$10956], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CVAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d1121228-bd67-4cce-bc06-55f668554190"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "6db43ba0-9e33-43ae-8e01-4d3f29a8725b"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"a66ed386-69bf-413f-9b46-db5eca21dc78"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"ef1d59d1-4d3e-43cc-a6cd-29028c7deee5"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CVAdimNv", "ObjectName",ExpressionUUID->
      "c6f9ccd0-e09b-4596-9190-95695f1f24ad"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"c8ef5f42-4ed5-40be-be67-77420f5d8fe7"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "786c98ba-77b8-4521-baa6-23b4dd049b05"]
    }],ExpressionUUID->"63da8f77-e43b-4aea-ac31-61bf9e3a8015"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"f05a3004-5b60-4e58-b3b3-\
a4467fa25682"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CVAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["C", "V"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "05d03bc1-6090-4add-bc33-bdb684769a66"],
     "/",
     StyleBox["R",
      FontSlant->"Italic"],
     "\nCapacit\[EAcute] calorifique isochore adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "19d650f0-051c-45a6-ab05-0dd80de25a91"],
     ")\n[Non-dimensionnal isochoric heat capacity function versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "672b86e3-49b0-4dd6-a674-d80c17dd0def"],
     ")]"
    }],ExpressionUUID->"d5bd95fd-387d-431f-a6c4-a20e11cf7f2a"]}
  }]], "Usage",ExpressionUUID->"c0511e0a-3e7d-4482-8d61-1593741874c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"7ef05bee-4e64-437a-945b-e618b524d5e9"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"56f5e904-3f05-4742-acd6-d3513c686549"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"b9d2f04a-0785-405f-87de-f3e830efd850"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c79db001-c853-4708-bcd5-e9260e2c6d9d"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->377541127,ExpressionUUID->"22616a60-679b-4c98-aa51-3b089fbbc4e1"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] 0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"0bd1b210-ab3d-4e0f-869e-148dbcd37f2b"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"76ea4dc1-01b7-467e-84a6-2d6faef3b05e"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] 0 and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->694074772,ExpressionUUID->"31275ad7-4a26-4dc0-8bc1-513520e32455"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"536ae7d4-a37b-4b6c-a664-86cf7cb78249"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"918e2ee1-74e0-4c20-b7c7-cf1de058c8c0"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "ce24357d-8c26-4383-a74a-3ba8f91670af"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->873447716,ExpressionUUID->"38a18cfc-3a9c-4c5d-b644-b2d95c41430d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"ff525413-acef-4f0c-a4c1-a92b84e08760"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"239d8d9c-e351-4bd6-8a64-763b909da51f"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "42afcd79-bd37-4e6b-943b-588e54a83d3c"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->344159173,ExpressionUUID->"6f4152af-d676-463d-a572-a63a9470ee9f"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"7d497bec-8eda-45f2-9a24-e01690665389"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox["C", "V"]], "InlineFormula",
  FontFamily->"Source Sans Pro",
  FontSlant->"Italic",ExpressionUUID->"5f65e8ef-f2c3-42b8-a008-7b07baf48324"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"56769733-e9dd-443a-bac1-1fe48d613c7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"CVAdimNv", "[", 
     RowBox[{"293.15", ",", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"N", "@", 
          RowBox[{"UnitConvert", "[", 
           RowBox[{
            TemplateBox[{"1"},
             "QuantityUnit",
             DisplayFunction->(TooltipBox[
               StyleBox[
                RowBox[{#, "\[InvisibleSpace]", 
                  StyleBox[
                   RowBox[{" ", "\"atm\""}], 
                   "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                False], "Unit: atmospheres"]& ),
             InterpretationFunction->(RowBox[{"Quantity", "[", 
                RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
            "\"\<bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
    "*", 
    RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"75d35cd1-e8eb-4def-9b07-023b069aada9"],

Cell[BoxData[
 TemplateBox[{"12.479723780683994`", 
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/(\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"], "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "kilogram meters squared per second squared kelvin mole", 
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\"", " ", 
      SuperscriptBox["\"Seconds\"", "2"]}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->631667949,ExpressionUUID->"de4e88e6-229a-4aaa-9333-cb706bdb6c41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"12.479723780683994`", ",", 
     FractionBox[
      RowBox[{"\"\<Kilograms\>\"", " ", 
       SuperscriptBox["\"\<Meters\>\"", "2"]}], 
      RowBox[{"\"\<Kelvins\>\"", " ", "\"\<Moles\>\"", " ", 
       SuperscriptBox["\"\<Seconds\>\"", "2"]}]]}], "]"}], ",", 
   "\"\<Joules/Kelvins/Moles\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->557594352,ExpressionUUID->"7d7f7777-835d-4e76-accb-2df5d1ad0a6e"],

Cell[BoxData[
 TemplateBox[{"12.479723780683994`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->277801167,ExpressionUUID->"9fbeaa54-3237-4b96-98bf-a0ac0628dabd"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"eedc5c5b-c2e7-43a8-8b80-93bd04baed20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarIsochoricHeatCapacity\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<Joules/Kelvins/Moles\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"980506d7-8bb5-46d2-b693-064856c96257"],

Cell[BoxData[
 TemplateBox[{"12.479672312155568`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->422288595,ExpressionUUID->"de93ae3e-626f-4d72-a980-3b91bed9bd8f"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->721118955,ExpressionUUID->"a7f1764d-faa2-4373-b7fd-32e0343bddf0"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Isochoric heat capacity of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Result", 1, 1, "Output", 
        "Quantity[12.48, \"Joules\"/(\"Kelvins\" \"Moles\")]"}, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}, 
      "ExtrusionOpen" -> True}}, Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods"}, Typeset`pod1$$ = 
   XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"isochoric molar heat\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center], 
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox["\"temperature\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"20\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox["\"pressure\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"1\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"atmosphere\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                    GridBoxBackground -> {
                    "Columns" -> {None, None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 
                    Automatic], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "moutput", {}, {
        "Quantity[12.48, \"Joules\"/(\"Kelvins\" \"Moles\")]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["12.48", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "12.48"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversion", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.01248", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.01248"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilojoules per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Thermodynamic properties", "scanner" -> "Data", "id" -> 
     "EntrainedTable:ThermodynamicDataRP", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                  "\"phase\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TemplateBox[{"\"gas\""}, "RowDefault"]}, {
                 TagBox[
                  PaneBox[
                  "\"temperature\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["293.2", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "293.2"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "20"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"pressure\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["101\[ThinSpace]325", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "101325"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"density\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.001662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.001662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"speed of sound\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {$CellContext`ThermodynamicDataRP, 
                    "SoundSpeed"}]], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1148", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1148"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["319", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "319"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "Show non-metric", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__Show non-metric"}, {}], 
       XMLElement[
       "state", {
        "name" -> "More", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__More"}, {}]}], 
     XMLElement["infos", {"count" -> "1"}, {
       XMLElement["info", {}, {
         XMLElement["units", {"count" -> "7"}, {
           XMLElement[
           "unit", {"short" -> "atm", "long" -> "atmospheres"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "g/cm^3", "long" -> "grams per cubic centimeter"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "kg/m^3", "long" -> "kilograms per cubic meter"}, {}], 
           XMLElement["unit", {"short" -> "K", "long" -> "kelvins"}, {}], 
           XMLElement[
           "unit", {"short" -> "km/h", "long" -> "kilometers per hour"}, {}], 
           XMLElement[
           "unit", {"short" -> "m/s", "long" -> "meters per second"}, {}], 
           XMLElement["unit", {"short" -> "Pa", "long" -> "pascals"}, {}], 
           XMLElement["cell", {"compressed" -> False, "string" -> True}, {
             Cell[
              BoxData[
               FormBox[
                StyleBox[
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"atmospheres\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"grams per cubic centimeter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilograms per cubic meter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kelvins\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilometers per hour\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"meters per second\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"pascals\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {{None}}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}}, "Rows" -> {{0.5}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False], TraditionalForm]], "Output"]}]}]}]}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Phase diagram", "scanner" -> "Data", "id" -> 
     "FeatureHighlightPhaseDiagram:ThermodynamicDataRP", "position" -> "500", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF13k4Vd3bB/BjnodKMpYUyVPSIzPdO0SDkChFOJwhVIQkP0UIj2QolYoM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               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              PolygonBox[
               
               NCache[{{-238.4420086048018, -7.00571661241373}, \
{-238.2374728110423, -6.937334987525619}, {-238.0305120492571, \
-6.868953362637509}, {-237.82108293675327`, -6.800571737749398}, \
{-237.60914104981737`, -6.7321901128612875`}, {-237.39464089229872`, \
-6.663808487973176}, {-237.17753586304892`, -6.595426863085066}, \
{-236.95777822216797`, -6.527045238196955}, {-236.73531905600626`, \
-6.458663613308845}, {-236.5101082408679, -6.390281988420734}, \
{-236.282094405359, -6.321900363532623}, {-236.05122489132137`, \
-6.253518738644512}, {-235.8174457132893, -6.185137113756402}, \
{-235.58070151640365`, -6.116755488868291}, {-235.34093553271472`, \
-6.0483738639801805`}, {-235.09808953580085`, -5.97999223909207}, \
{-234.85210379362704`, -5.911610614203959}, {-234.60291701956314`, \
-5.843228989315849}, {-234.35046632147743`, -5.774847364427737}, \
{-234.09468714881663`, -5.706465739539627}, {-233.83551323757877`, \
-5.638084114651516}, {-233.57287655308048`, -5.569702489763405}, \
{-233.30670723041496`, -5.501320864875295}, {-233.0369335124909, \
-5.432939239987184}, {-232.76348168596002`, -5.3645576150990735`}, \
{-232.48627601206837`, -5.296175990210963}, {-232.20523866038087`, \
-5.227794365322852}, {-231.9202896327782, -5.159412740434742}, \
{-231.63134668865928`, -5.091031115546631}, {-231.33832526579437`, \
-5.02264949065852}, {-231.0411383978016, -4.95426786577041}, \
{-230.7396966279538, -4.885886240882298}, {-230.43390791977174`, \
-4.8175046159941886`}, {-230.12367756257282`, -4.749122991106077}, \
{-229.80890807476095`, -4.680741366217967}, {-229.4894991007418, \
-4.612359741329856}, {-229.16534730469976`, -4.543978116441745}, \
{-228.8363462590708, -4.475596491553635}, {-228.50238632795254`, \
-4.407214866665524}, {-228.16335454545717`, -4.338833241777413}, \
{-227.81913448815828`, -4.270451616889303}, {-227.46960614185917`, \
-4.202069992001192}, {-227.11464576207402`, -4.133688367113081}, \
{-226.7541257279603, -4.065306742224971}, {-226.3879143893344, \
-3.99692511733686}, {-226.015875906406, -3.9285434924487492`}, \
{-225.63787008168018`, -3.8601618675606386`}, {-225.25375218398557`, \
-3.791780242672528}, {-224.86337276356053`, -3.723398617784417}, \
{-224.46657745823478`, -3.6550169928963063`}, {-224.06320678991565`, \
-3.5866353680081957`}, {-223.65309595087413`, -3.518253743120085}, \
{-223.23607457922824`, -3.4498721182319745`}, {-222.81196652298075`, \
-3.381490493343864}, {-222.3805895919242, -3.3131088684557533`}, \
{-221.9417552966791, -3.244727243567642}, {-221.49526857408046`, \
-3.1763456186795316`}, {-221.04092749807143`, -3.107963993791421}, \
{-220.57852297520432`, -3.0395823689033103`}, {-220.1078384237842, \
-2.9712007440151993`}, {-219.62864943562025`, -2.9028191191270887`}, \
{-219.1407234192758, -2.834437494238978}, {-218.64381922362568`, \
-2.7660558693508674`}, {-218.13768674043376`, -2.697674244462757}, \
{-217.62206648459608`, -2.629292619574646}, {-217.0966891505369, \
-2.5609109946865356`}, {-216.5612751431918, -2.492529369798425}, \
{-216.01553408184913`, -2.4241477449103144`}, {-215.45916427500205`, \
-2.3557661200222038`}, {-214.89185216421595`, -2.287384495134093}, \
{-214.31327173485698`, -2.2190028702459825`}, {-213.72308389135503`, \
-2.150621245357871}, {-213.12093579448543`, -2.0822396204697604`}, \
{-212.50646015794774`, -2.01385799558165}, {-211.87927450129575`, \
-1.9454763706935392`}, {-211.2389803560243, -1.8770947458054286`}, \
{-210.58516242135153`, -1.808713120917318}, {-209.91738766593693`, \
-1.7403314960292073`}, {-209.23520437145348`, -1.6719498711410967`}, \
{-208.5381411135735, -1.603568246252986}, {-207.82570567553884`, \
-1.5351866213648755`}, {-207.09738388905294`, -1.4668049964767649`}, \
{-206.3526383967591, -1.3984233715886543`}, {-205.59090733004558`, \
-1.3300417467005436`}, {-204.81160289534023`, -1.2616601218124321`}, \
{-204.01410986141946`, -1.1932784969243215`}, {-203.1977839395501, \
-1.124896872036211}, {-202.36195004750107`, -1.0565152471481003`}, \
{-201.50590044759292`, -0.9881336222599897}, {-200.6288927479934, \
-0.9197519973718791}, {-199.73014775539457`, -0.8513703724837685}, \
{-198.8088471660173, -0.7829887475956578}, {-197.8641310805616, \
-0.7146071227075472}, {-196.89509532724037`, -0.6462254978194366}, \
{-195.9007885753793, -0.577843872931326}, {-194.88020922021425`, \
-0.5094622480432154}, {-193.83230201744357`, -0.4410806231551039}, \
{-192.75595444376376`, -0.37269899826699326`}, {-191.64999275700143`, \
-0.30431737337888265`}, {-190.51317772651095`, -0.23593574849077203`}, \
{-189.34419999999997`, -0.16755412353428056`}, {-189.15915481427686`, \
-0.15831041463088358`}, {-188.97324025416088`, -0.1490667057274857}, \
{-188.78643614504742`, -0.13982299682408872`}, {-188.5987363198953, \
-0.13057928792069085`}, {-188.41013455938827`, -0.12133557901729386`}, \
{-188.22062459146895`, -0.11209187011389599`}, {-188.03020009086944`, \
-0.102848161210499}, {-187.8388546786391, -0.09360445230710113}, \
{-187.64658192166826`, -0.08436074340370414}, {-187.453375332208, \
-0.07511703450030627}, {-187.25922836738806`, -0.06587332559690928}, \
{-187.06413442872878`, -0.05662961669351141}, {-186.86808686165315`, \
-0.04738590779011442}, {-186.67107895499055`, -0.03814219888671655}, \
{-186.47310394048282`, -0.028898489983319564`}, {-186.27415499228226`, \
-0.01965478107992169}, {-186.07422522644833`, -0.010411072176524705`}, \
{-185.8733077004407, -0.0011673632731268313`}, {-185.6713954126098, 
                 0.008076345630270154}, {-185.46848130168198`, 
                 0.017320054533668028`}, {-185.26455824624338`, 
                 0.026563763437065013`}, {-185.05961906422064`, 
                 0.03580747234046289}, {-184.8536565123561, 
                 0.04505118124385987}, {-184.6466632856831, 
                 0.054294890147257746`}, {-184.4386320169962, 
                 0.06353859905065473}, {-184.22955527631734`, 
                 0.0727823079540526}, {-184.01942557036273`, 
                 0.08202601685744959}, {-183.80823534200258`, 
                 0.09126972576084746}, {-183.59597696972122`, 
                 0.10051343466424445`}, {-183.3826427670724, 
                 0.10975714356764232`}, {-183.1682249821323, 
                 0.11900085247103931`}, {-182.95271579695049`, 
                 0.12824456137443718`}, {-182.73610732699882`, 
                 0.13748827027783417`}, {-182.51839162061484`, 
                 0.14673197918123204`}, {-182.2995606584459, 
                 0.15597568808462903`}, {-182.0796063528906, 
                 0.1652193969880269}, {-181.8585205475365, 
                 0.1744631058914239}, {-181.63629501659568`, 
                 0.18370681479482176`}, {-181.41292146434128`, 
                 0.19295052369821875`}, {-181.18839152453754`, 
                 0.20219423260161662`}, {-180.9626967598722, 
                 0.2114379415050136}, {-180.73582866138457`, 
                 0.2206816504084106}, {-180.5077786478937, 
                 0.22992535931180846`}, {-180.27853806542356`, 
                 0.23916906821520634`}, {-180.04809818662943`, 
                 0.24841277711860332`}, {-179.81645021022052`, 
                 0.2576564860220003}, {-179.58358526038393`, 
                 0.2669001949253982}, {-179.3494943862063, 
                 0.27614390382879517`}, {-179.1141685610955, 
                 0.28538761273219304`}, {-178.87759868220388`, 
                 0.29463132163559}, {-178.63977556984742`, 
                 0.3038750305389879}, {-178.4006899669289, 
                 0.3131187394423849}, {-178.16033253835917`, 
                 0.32236244834578276`}, {-177.91869387048035`, 
                 0.33160615724917974`}, {-177.67576447048867`, 
                 0.3408498661525776}, {-177.43153476585945`, 
                 0.3500935750559746}, {-177.18599510377345`, 
                 0.3593372839593725}, {-176.93913575054418`, 
                 0.36858099286276946`}, {-176.69094689104816`, 
                 0.37782470176616734`}, {-176.44141862815718`, 
                 0.3870684106695643}, {-176.1905409821733, 
                 0.3963121195729622}, {-175.9383038902672, 
                 0.4055558284763592}, {-175.68469720591986`, 
                 0.41479953737975706`}, {-175.42971069836858`, 
                 0.42404324628315404`}, {-175.1733340520562, 
                 0.4332869551865519}, {-174.9155568660871, 
                 0.4425306640899489}, {-174.65636865368592`, 
                 0.4517743729933468}, {-174.3957588416656, 
                 0.46101808189674376`}, {-174.13371676989738`, 
                 0.47026179080014163`}, {-173.87023169079225`, 
                 0.4795054997035386}, {-173.60529276878611`, 
                 0.4887492086069365}, {-173.33888907983476`, 
                 0.4979929175103335}, {-173.07100961091825`, 
                 0.5072366264137314}, {-172.80164325955337`, 
                 0.5164803353171283}, {-172.53077883331548`, 
                 0.5257240442205262}, {-172.2584050493754, 
                 0.5349677531239232}, {-171.98451053404224`, 
                 0.5442114620273211}, {-171.70908382232227`, 
                 0.553455170930718}, {-171.43211335749163`, 
                 0.5626988798341159}, {-171.1535874906807, 
                 0.5719425887375129}, {-170.87349448047576`, 
                 0.5811862976409099}, {-170.59182249253624`, 
                 0.5904300065443078}, {-170.30855959922968`, 
                 0.5996737154477056}, {-170.02369377928412`, 
                 0.6089174243511026}, {-169.7372129174618, 
                 0.6181611332544996}, {-169.44910480425193`, 
                 0.6274048421578975}, {-169.15935713558764`, 
                 0.6366485510612954}, {-168.86795751259643`, 
                 0.6458922599646924}, {-168.57489344131264`, 
                 0.6551359688680893}, {-168.28015233255832`, 
                 0.6643796777714872}, {-167.98372150169217`, 
                 0.6736233866748842}, {-167.68558816848042`, 
                 0.6828670955782821}, {-167.38573945697675`, 
                 0.692110804481679}, {-167.08416239543652`, 
                 0.7013545133850769}, {-166.78084391626794`, 
                 0.7105982222884739}, {-166.47577085603376`, 
                 0.7198419311918718}, {-166.16892995543373`, 
                 0.7290856400952688}, {-165.86030785942773`, 
                 0.7383293489986666}, {-165.54989111732084`, 
                 0.7475730579020636}, {-165.23766618293047`, 
                 0.7568167668054615}, {-164.92361941479885`, 
                 0.7660604757088585}, {-164.6077370764563, 
                 0.7753041846122564}, {-164.29000533674179`, 
                 0.7845478935156533}, {-163.97041027018184`, 
                 0.7937916024190512}, {-163.64893785743385`, 
                 0.8030353113224482}, {-163.32557398579127`, 
                 0.8122790202258461}, {-163.00030444976363`, 
                 0.8215227291292431}, {-162.6731149517276, 
                 0.8307664380326409}, {-162.34399110265596`, 
                 0.8400101469360379}, {-162.01291842293105`, 
                 0.8492538558394358}, {-161.67988234324375`, 
                 0.8584975647428328}, {-161.34486820558635`, 
                 0.8677412736462307}, {-161.0078612643414, 
                 0.8769849825496276}, {-160.6688466874757, 
                 0.8862286914530255}, {-160.3278095578429, 
                 0.8954724003564225}, {-159.98473487459984`, 
                 0.9047161092598204}, {-159.63960755474898`, 
                 0.9139598181632174}, {-159.29241243480624`, 
                 0.9232035270666152}, {-158.9431342726096, 
                 0.9324472359700122}, {-158.59175774926754`, 
                 0.9416909448734092}, {-158.23826747126657`, 
                 0.9509346537768071}, {-157.88264797273683`, 
                 0.960178362680205}, {-157.52488371789116`, 
                 0.9694220715836019}, {-157.16495910364637`, 
                 0.9786657804869989}, {-156.8028584624368, 
                 0.9879094893903968}, {-156.43856606523218`, 
                 0.9971531982937947}, {-156.07206612477248`, 
                 1.0063969071971917`}, {-155.70334279903142`, 
                 1.0156406161005886`}, {-155.33238019492495`, 
                 1.0248843250039865`}, {-154.95916237227578`, 
                 1.0341280339073844`}, {-154.58367334805436`, 
                 1.0433717428107814`}, {-154.2058971009096, 
                 1.0526154517141784`}, {-153.82581757600974`, 
                 1.0618591606175762`}, {-153.44341869021258`, 
                 1.071102869520974}, {-153.0586843375865, 
                 1.080346578424371}, {-152.67159839530476`, 
                 1.089590287327768}, {-152.28214472994, 
                 1.098833996231166}, {-151.8903072041836, 
                 1.1080777051345638`}, {-151.49606968402225`, 
                 1.1173214140379608`}, {-151.09941604640346`, 
                 1.1265651229413578`}, {-150.70033018742473`, 
                 1.1358088318447557`}, {-150.2987960310868, 
                 1.1450525407481527`}, {-149.8947975386523, 
                 1.1542962496515505`}, {-149.48831871865647`, 
                 1.1635399585549475`}, {-149.07934363761913`, 
                 1.1727836674583454`}, {-148.66785643151223`, 
                 1.1820273763617424`}, {-148.25384131804114`, 
                 1.1912710852651403`}, {-147.83728260979865`, 
                 1.2005147941685372`}, {-147.41816472835905`, 
                 1.209758503071935}, {-146.99647221938005`, 
                 1.219002211975332}, {-146.5721897687819, 
                 1.22824592087873}, {-146.14530222008244`, 
                 1.237489629782127}, {-145.71579459296174`, 
                 1.2467333386855248`}, {-145.28365210314297`, 
                 1.2559770475889218`}, {-144.8488601836702, 
                 1.2652207564923197`}, {-144.41140450768376`, 
                 1.2744644653957167`}, {-143.9712710127866, 
                 1.2837081742991145`}, {-143.5284459271168, 
                 1.2929518832025115`}, {-143.08291579725434`, 
                 1.3021955921059094`}, {-142.63466751810367`, 
                 1.3114393010093064`}, {-142.18368836492425`, 
                 1.3206830099127043`}, {-141.72996602770982`, 
                 1.3299267188161012`}, {-141.2734886481535, 
                 1.3391704277194982`}, {-140.81424485948347`, 
                 1.348414136622896}, {-140.35222382951338`, 
                 1.357657845526294}, {-139.88741530730908`, 
                 1.366901554429691}, {-139.4198096739629, 
                 1.376145263333088}, {-138.94939799805434`, 
                 1.3853889722364858`}, {-138.47617209648632`, 
                 1.3946326811398837`}, {-138.00012460152442`, 
                 1.4038763900432807`}, {-137.52124903501982`, 
                 1.4131200989466777`}, {-137.03953989099276`, 
                 1.4223638078500755`}, {-136.55499272798664`, 
                 1.4316075167534734`}, {-136.06760427288924`, 
                 1.4408512256568704`}, {-135.57737253828117`, 
                 1.4500949345602674`}, {-135.0842969558082, 
                 1.4593386434636653`}, {-134.58837852864912`, 
                 1.4685823523670631`}, {-134.08962000684636`, 
                 1.4778260612704601`}, {-133.5880260901913, 
                 1.487069770173857}, {-133.08360366450935`, 
                 1.496313479077255}, {-132.57636207872002`, 
                 1.5055571879806529`}, {-132.06631347201105`, 
                 1.5148008968840498`}, {-131.55347316310338`, 
                 1.5240446057874468`}, {-131.03786011708274`, 
                 1.5332883146908447`}, {-130.51949751003076`, 
                 1.5425320235942417`}, {-129.99841341825362`, 
                 1.5517757324976396`}, {-129.4746416681213, 
                 1.5610194414010365`}, {-128.94822289576263`, 
                 1.5702631503044344`}, {-128.41920588539716`, 
                 1.5795068592078314`}, {-127.88764928477224`, 
                 1.5887505681112293`}, {-127.35362384320513`, 
                 1.5979942770146263`}, {-126.81721539505344`, 
                 1.6072379859180241`}, {-126.27852894692478`, 
                 1.6164816948214211`}, {-125.7376944781501, 
                 1.625725403724819}, {-125.19487557200682`, 
                 1.634969112628216}, {-124.6502831335803, 
                 1.6442128215316139`}, {-124.10419939029575`, 
                 1.6534565304350108`}, {-123.55702668989167`, 
                 1.6627002393384087`}, {-123.00941705997138`, 
                 1.6719439482418057`}, {-122.46299999999997`, 
                 1.6811876571452036`}, {2726.8469999999998`, 
                 1.6811876571544468`}, {
                 2726.8469999999998`, -2 - Log[10]^(-1) 
                  Log[101325]}}, CompressedData["
1:eJxV2Gc81W/cwPFDZVRG9mgYf4Ui/YUGLtlFSLQI5zgOZ5HR8ldZIZURCalQ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                "]]], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              PolygonBox[
               
               NCache[{{-273.15, -2 - Log[10]^(-1) 
                  Log[101325]}, {-238.4420086048018, -7.00571661241373}, \
{-238.2374728110423, -6.937334987525619}, {-238.0305120492571, \
-6.868953362637509}, {-237.82108293675327`, -6.800571737749398}, \
{-237.60914104981737`, -6.7321901128612875`}, {-237.39464089229872`, \
-6.663808487973176}, {-237.17753586304892`, -6.595426863085066}, \
{-236.95777822216797`, -6.527045238196955}, {-236.73531905600626`, \
-6.458663613308845}, {-236.5101082408679, -6.390281988420734}, \
{-236.282094405359, -6.321900363532623}, {-236.05122489132137`, \
-6.253518738644512}, {-235.8174457132893, -6.185137113756402}, \
{-235.58070151640365`, -6.116755488868291}, {-235.34093553271472`, \
-6.0483738639801805`}, {-235.09808953580085`, -5.97999223909207}, \
{-234.85210379362704`, -5.911610614203959}, {-234.60291701956314`, \
-5.843228989315849}, {-234.35046632147743`, -5.774847364427737}, \
{-234.09468714881663`, -5.706465739539627}, {-233.83551323757877`, \
-5.638084114651516}, {-233.57287655308048`, -5.569702489763405}, \
{-233.30670723041496`, -5.501320864875295}, {-233.0369335124909, \
-5.432939239987184}, {-232.76348168596002`, -5.3645576150990735`}, \
{-232.48627601206837`, -5.296175990210963}, {-232.20523866038087`, \
-5.227794365322852}, {-231.9202896327782, -5.159412740434742}, \
{-231.63134668865928`, -5.091031115546631}, {-231.33832526579437`, \
-5.02264949065852}, {-231.0411383978016, -4.95426786577041}, \
{-230.7396966279538, -4.885886240882298}, {-230.43390791977174`, \
-4.8175046159941886`}, {-230.12367756257282`, -4.749122991106077}, \
{-229.80890807476095`, -4.680741366217967}, {-229.4894991007418, \
-4.612359741329856}, {-229.16534730469976`, -4.543978116441745}, \
{-228.8363462590708, -4.475596491553635}, {-228.50238632795254`, \
-4.407214866665524}, {-228.16335454545717`, -4.338833241777413}, \
{-227.81913448815828`, -4.270451616889303}, {-227.46960614185917`, \
-4.202069992001192}, {-227.11464576207402`, -4.133688367113081}, \
{-226.7541257279603, -4.065306742224971}, {-226.3879143893344, \
-3.99692511733686}, {-226.015875906406, -3.9285434924487492`}, \
{-225.63787008168018`, -3.8601618675606386`}, {-225.25375218398557`, \
-3.791780242672528}, {-224.86337276356053`, -3.723398617784417}, \
{-224.46657745823478`, -3.6550169928963063`}, {-224.06320678991565`, \
-3.5866353680081957`}, {-223.65309595087413`, -3.518253743120085}, \
{-223.23607457922824`, -3.4498721182319745`}, {-222.81196652298075`, \
-3.381490493343864}, {-222.3805895919242, -3.3131088684557533`}, \
{-221.9417552966791, -3.244727243567642}, {-221.49526857408046`, \
-3.1763456186795316`}, {-221.04092749807143`, -3.107963993791421}, \
{-220.57852297520432`, -3.0395823689033103`}, {-220.1078384237842, \
-2.9712007440151993`}, {-219.62864943562025`, -2.9028191191270887`}, \
{-219.1407234192758, -2.834437494238978}, {-218.64381922362568`, \
-2.7660558693508674`}, {-218.13768674043376`, -2.697674244462757}, \
{-217.62206648459608`, -2.629292619574646}, {-217.0966891505369, \
-2.5609109946865356`}, {-216.5612751431918, -2.492529369798425}, \
{-216.01553408184913`, -2.4241477449103144`}, {-215.45916427500205`, \
-2.3557661200222038`}, {-214.89185216421595`, -2.287384495134093}, \
{-214.31327173485698`, -2.2190028702459825`}, {-213.72308389135503`, \
-2.150621245357871}, {-213.12093579448543`, -2.0822396204697604`}, \
{-212.50646015794774`, -2.01385799558165}, {-211.87927450129575`, \
-1.9454763706935392`}, {-211.2389803560243, -1.8770947458054286`}, \
{-210.58516242135153`, -1.808713120917318}, {-209.91738766593693`, \
-1.7403314960292073`}, {-209.23520437145348`, -1.6719498711410967`}, \
{-208.5381411135735, -1.603568246252986}, {-207.82570567553884`, \
-1.5351866213648755`}, {-207.09738388905294`, -1.4668049964767649`}, \
{-206.3526383967591, -1.3984233715886543`}, {-205.59090733004558`, \
-1.3300417467005436`}, {-204.81160289534023`, -1.2616601218124321`}, \
{-204.01410986141946`, -1.1932784969243215`}, {-203.1977839395501, \
-1.124896872036211}, {-202.36195004750107`, -1.0565152471481003`}, \
{-201.50590044759292`, -0.9881336222599897}, {-200.6288927479934, \
-0.9197519973718791}, {-199.73014775539457`, -0.8513703724837685}, \
{-198.8088471660173, -0.7829887475956578}, {-197.8641310805616, \
-0.7146071227075472}, {-196.89509532724037`, -0.6462254978194366}, \
{-195.9007885753793, -0.577843872931326}, {-194.88020922021425`, \
-0.5094622480432154}, {-193.83230201744357`, -0.4410806231551039}, \
{-192.75595444376376`, -0.37269899826699326`}, {-191.64999275700143`, \
-0.30431737337888265`}, {-190.51317772651095`, -0.23593574849077203`}, \
{-189.34419999999997`, -0.16755412353428056`}, {-189.343288536399, \
-0.14523978817194294`}, {-189.3423290240558, -0.12292545280960532`}, \
{-189.34131893041143`, -0.1006111174472677}, {-189.3402555894616, \
-0.07829678208493007}, {-189.3391361947294, -0.05598244672259245}, \
{-189.33795779186931`, -0.03366811136025483}, {-189.33671727088094`, \
-0.011353775997917204`}, {-189.3354113579148, 
                 0.010960559364420419`}, {-189.3340366066463, 
                 0.03327489472675804}, {-189.33258938919664`, 
                 0.055589230089095665`}, {-189.33106588657705`, 
                 0.07790356545143329}, {-189.32946207863034`, 
                 0.10021790081377091`}, {-189.32777373344425`, 
                 0.12253223617610765`}, {-189.32599639620898`, 
                 0.14484657153844527`}, {-189.32412537748905`, 
                 0.1671609069007829}, {-189.3221557408805, 
                 0.1894752422631205}, {-189.3200822900186, 
                 0.21178957762545814`}, {-189.31789955490572`, 
                 0.23410391298779576`}, {-189.31560177752004`, 
                 0.2564182483501334}, {-189.31318289667053`, 
                 0.278732583712471}, {-189.31063653205803`, 
                 0.3010469190748086}, {-189.30795596749954`, 
                 0.32336125443714625`}, {-189.30513413327475`, 
                 0.3456755897994839}, {-189.30216358754686`, 
                 0.3679899251618215}, {-189.29903649681103`, 
                 0.3903042605241591}, {-189.29574461531834`, 
                 0.41261859588649674`}, {-189.2922792634245, 
                 0.43493293124883436`}, {-189.28863130480406`, 
                 0.457247266611172}, {-189.28479112247499`, 
                 0.4795616019735096}, {-189.28074859356855`, 
                 0.5018759373358472}, {-189.27649306278255`, 
                 0.5241902726981849}, {-189.272013314447, 
                 0.5465046080605225}, {-189.26729754313288`, 
                 0.5688189434228601}, {-189.26233332272733`, 
                 0.5911332787851977}, {-189.25710757389663`, 
                 0.6134476141475353}, {-189.25160652985414`, 
                 0.635761949509873}, {-189.2458157003453, 
                 0.6580762848722106}, {-189.23971983375938`, 
                 0.6803906202345473}, {-189.23330287727003`, 
                 0.7027049555968858}, {-189.22654793490582`, 
                 0.7250192909592226}, {-189.21943722344247`, 
                 0.7473336263215602}, {-189.2119520260083, 
                 0.7696479616838978}, {-189.20407264328315`, 
                 0.7919622970462354}, {-189.19577834217125`, 
                 0.8142766324085731}, {-189.1870473018182, 
                 0.8365909677709107}, {-189.17785655683696`, 
                 0.8589053031332483}, {-189.1681819376032, 
                 0.8812196384955859}, {-189.15799800747124`, 
                 0.9035339738579236}, {-189.14727799675475`, 
                 0.9258483092202612}, {-189.1359937333117, 
                 0.9481626445825988}, {-189.12411556956113`, 
                 0.9704769799449364}, {-189.11161230575567`, 
                 0.992791315307274}, {-189.0984511093215, 
                 1.0151056506696117`}, {-189.08459743007143`, 
                 1.0374199860319493`}, {-189.070014911087, 
                 1.059734321394287}, {-189.05466529505486`, 
                 1.0820486567566245`}, {-189.03850832583572`, 
                 1.1043629921189622`}, {-189.02150164503053`, 
                 1.1266773274812998`}, {-189.00360068330144`, 
                 1.1489916628436374`}, {-188.98475854619247`, 
                 1.171305998205975}, {-188.96492589418358`, 
                 1.1936203335683118`}, {-188.9440508167016, 
                 1.2159346689306503`}, {-188.92207869979757`, 
                 1.238249004292987}, {-188.89895208719076`, 
                 1.2605633396553255`}, {-188.8746105343638, 
                 1.2828776750176623`}, {-188.848990455383, 
                 1.3051920103800008`}, {-188.82202496210334`, 
                 1.3275063457423375`}, {-188.79364369540463`, 
                 1.3498206811046751`}, {-188.76377264809156`, 
                 1.3721350164670127`}, {-188.73233397907651`, 
                 1.3944493518293504`}, {-188.69924581844919`, 
                 1.416763687191688}, {-188.66442206302253`, 
                 1.4390780225540256`}, {-188.62777216193206`, 
                 1.4613923579163632`}, {-188.58920089184718`, 
                 1.4837066932787009`}, {-188.548608121342, 
                 1.5060210286410385`}, {-188.50588856395626`, 
                 1.528335364003376}, {-188.46093151946408`, 
                 1.5506496993657137`}, {-188.41362060285104`, 
                 1.5729640347280514`}, {-188.36383346048967`, 
                 1.595278370090389}, {-188.31144147298627`, 
                 1.6175927054527266`}, {-188.25630944416068`, 
                 1.6399070408150642`}, {-188.1982952756064, 
                 1.6622213761774018`}, {-188.13724962626753`, 
                 1.6845357115397395`}, {-188.0730155564565, 
                 1.706850046902077}, {-188.0054281557275, 
                 1.7291643822644147`}, {-187.93431415400892`, 
                 1.7514787176267523`}, {-187.85949151539432`, 
                 1.77379305298909}, {-187.78076901397964`, 
                 1.7961073883514267`}, {-187.69794579113403`, 
                 1.8184217237137652`}, {-187.61081089358618`, 
                 1.840736059076102}, {-187.51914279170853`, 
                 1.8630503944384404`}, {-187.4227088773816, 
                 1.8853647298007772`}, {-187.32126494082635`, 
                 1.9076790651631157`}, {-187.2145546257973, 
                 1.9299934005254524`}, {-187.10230886254124`, 
                 1.952307735887791}, {-186.9842452779356, 
                 1.9746220712501277`}, {-186.86006758224013`, 
                 1.9969364066124653`}, {-186.72946493191398`, 
                 2.019250741974803}, {-186.59211126797317`, 
                 2.0415650773371405`}, {-186.447664629393, 
                 2.063879412699478}, {-186.2957664410897, 
                 2.086193748061816}, {-186.1360407760541, 
                 2.1085080834241534`}, {-185.9680935912482, 
                 2.130822418786491}, {-185.79151193692184`, 
                 2.1531367541488287`}, {-185.60586313905685`, 
                 2.1754510895111663`}, {-185.41069395469623`, 
                 2.197765424873504}, {-185.20552969997806`, 
                 2.2200797602358415`}, {-184.98987335075083`, 
                 2.242394095598179}, {-184.76320461571504`, 
                 2.264708430960516}, {-184.52497898210154`, 
                 2.2870227663228544`}, {-184.27462673396832`, 
                 2.309337101685191}, {-184.01155194326734`, 
                 2.3316514370475296`}, {-183.73513143390716`, 
                 2.3539657724098664`}, {-183.4447137191063, 
                 2.376280107772205}, {-183.1396179124038, 
                 2.3985944431345416`}, {-182.8191326127577, 
                 2.42090877849688}, {-182.48251476422718`, 
                 2.443223113859217}, {-182.1289884907835, 
                 2.4655374492215554`}, {-181.75774390684717`, 
                 2.487851784583892}, {-181.36793590417895`, 
                 2.5101661199462306`}, {-180.95868291577847`, 
                 2.5324804553085674`}, {-180.5290656574478, 
                 2.554794790670905}, {-180.078125847669, 
                 2.5771091260332426`}, {-179.60486490641114`, 
                 2.5994234613955802`}, {-179.10824263342766`, 
                 2.621737796757918}, {-178.5871758665267, 
                 2.6440521321202555`}, {-178.04053712018447`, 
                 2.666366467482593}, {-177.46715320473794`, 
                 2.6886808028449307`}, {-176.86580382621852`, 
                 2.7109951382072683`}, {-176.23522016668488`, 
                 2.733309473569606}, {-175.57408344467353`, 
                 2.7556238089319436`}, {-174.881023455108, 
                 2.777938144294281}, {-174.15461708769635`, 
                 2.800252479656619}, {-173.39338682249627`, 
                 2.8225668150189565`}, {-172.59579920094484`, 
                 2.844881150381294}, {-171.7602632702329, 
                 2.867195485743631}, {-170.88512899845264`, 
                 2.8895098211059693`}, {-169.96868565747891`, 
                 2.911824156468306}, {-169.00916017003578`, 
                 2.9341384918306446`}, {-168.00471541689157`, 
                 2.9564528271929813`}, {-166.95344849958656`, 
                 2.97876716255532}, {-165.8533889535655, 
                 3.0010814979176565`}, {-164.70249690604163`, 
                 3.023395833279995}, {-163.49866117239037`, 
                 3.045710168642332}, {-162.23969728434633`, 
                 3.0680245040046703`}, {-160.92334544278046`, 
                 3.090338839367007}, {-159.54726838735547`, 
                 3.1126531747293456`}, {-158.10904917492368`, 
                 3.1349675100916823`}, {-156.60618885812204`, 
                 3.157281845454021}, {-155.03610405527138`, 
                 3.1795961808163575`}, {-153.39612440236778`, 
                 3.2019105161786943`}, {-151.68348987770614`, 
                 3.2242248515410328`}, {-149.89534798946778`, 
                 3.2465391869033713`}, {-148.0287508164534, 
                 3.268853522265708}, {-146.08065189204905`, 
                 3.2911678576280448`}, {-144.04790292146828`, 
                 3.3134821929903833`}, {-141.9272503223137, 
                 3.335796528352722}, {-139.71533157854967`, 
                 3.3581108637150585`}, {-137.40867139806014`, 
                 3.3804251990773952`}, {-135.0036776640849, 
                 3.4027395344397338`}, {-132.49663717096152`, 
                 3.4250538698020705`}, {-129.8837111347529, 
                 3.447368205164409}, {-127.16093046951241`, 
                 3.4696825405267457`}, {-124.32419082008275`, 
                 3.4919968758890843`}, {-121.36924734249254`, 
                 3.514311211251421}, {-118.29170922313, 
                 3.5366255466137595`}, {-115.08703392799873`, 
                 3.5589398819760962`}, {-111.7505211734144, 
                 3.5812542173384347`}, {-108.27730660956021`, 
                 3.6035685527007715`}, {-104.66235520828354`, 
                 3.62588288806311}, {-100.90045434648673`, 
                 3.6481972234254467`}, {-96.98620657632529, 
                 3.6705115587877852`}, {-92.91402207328707, 
                 3.692825894150122}, {-88.67811075297556, 
                 3.7151402295124587`}, {-84.27247404716456, 
                 3.737454564874797}, {-79.69089632932764, 
                 3.7597689002371357`}, {-74.92693597946047, 
                 3.7820832355994725`}, {-69.97391607755029, 
                 3.804397570961809}, {-64.82491471454105, 
                 3.8267119063241477`}, {-59.47275490907364, 
                 3.849026241686486}, {-53.90999411766339, 
                 3.871340577048823}, {-48.12891332530759, 
                 3.8936549124111597`}, {-42.12150570282341, 
                 3.915969247773498}, {-35.87946481642899, 
                 3.9382835831358367`}, {-29.394172374311637`, 
                 3.9605979184981734`}, {-22.656685494071297`, 
                 3.98291225386051}, {-15.657723474063118`, 
                 4.005226589222849}, {-8.387654050753952, 
                 4.027540924585187}, {-0.8364791232451694, 
                 4.049855259947524}, {7.0061800748349015`, 
                 4.072169595309861}, {15.151098376902894`, 
                 4.094483930672199}, {23.609462680309605`, 
                 4.116798266034536}, {32.39288856149972, 4.139112601396873}, {
                 41.51343753347294, 4.161426936759211}, {50.983634970736375`, 
                 4.18374127212155}, {60.81648872810257, 4.206055607483886}, {
                 71.02550848089822, 4.228369942846223}, {81.62472581538287, 
                 4.250684278208562}, {92.62871509945614, 4.2729986135709}, {
                 104.05261516507699`, 4.295312948933237}, {-273.15, 
                 4.2953129489555515`}}, CompressedData["
1:eJw9mHk0VV3cgM1kVtdMaaCSosjM2Ym8lUwR0WC813WvoUj0SqKQiKRCZB5C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                "]]], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxTTMoPSmViYGDQAGIQLdB84NTCuXEHnqyJY1d99ss+5/nvlRt9lzqg88+k
trek6Qk6PAj8zx3HHOWwghnCn7HK8Z6NRrjDrv4rn3rEBR1Cmv40/k4PcTgl
rZS4mUHQYcG5oHcLDwY63Fqef/7mSwGHjIQHm5sy/BzeGO+1Zbgs4PDAUf/A
81pPh3/7udao7RFwEEg3Dtpx0MWBzydCynepgMMEP0UdLyMHB7kbSzuK+wQc
PvBz7GedY+5gkPL528xyAYcFvWZHYnz1HJw+OKQeSBBwYDA7KxjCJuMQVNN3
+ZknkP/v8N38I6/2p3DcceQ1BtrnUzO96pjCgbIpmhuMZQQcHC5PVTwYoH+g
TaFcLopVwMHidEKXzAqzAzqRnZKMd/kddiwXqH6RYnsgoFDlm+96focTrjN8
J31wPFDSuf/SrEag/Oet9b38rgemLIxa/zyY36FGOsq6QcDjwJadX7tN1Pgd
Qkrfr6/64nXgxsUJGY0/+BxC9s+xbt7je+DPS23Xc6f4HKJsxNJPmwQckGE6
rig9l89BqUNySUhd4AEbqaR/6fl8DnqBnq+DdgcdSDD6e2uLI5/Dgxs2S83f
BB9o8ZqxnVGEz0Ej9Y9ZgWDogSVJxlP8nvE6qBxbopWmHXbgSNW5gtk7eB2O
qBaE1VuFH3gxKdP3RRevwxYpAyY5+4gDPKtZtExjeR2e5bhwL7SMPKBzeD5b
kz6vQ0GVJHuKVtSBgNtWj88x8josO2iRsl8w+kDB56v7pa/wOPht/NrJ8SH6
wBTuwjkZy3gcMmYe+DbxaMyBLco8lVsreBxsgjRjV0+KPXDDenkokzePwx+O
2fsXhscd+BHsZOQvy+MAS2+w9AQAlekbtw==
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.75, 0.3499999999999999}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7986888454011729, 0.8268297455968698}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.2395303326810177, 0.7310763209393352}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVzns4lIkCx3F3urjPmBm6WWsrkmlHxAkl0mJzWdpqt5Q25vK+M6R9Np1Y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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.31258317025440335`, 0.20273972602739798`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV0Hk4lOsbB/DhlK3EQVmT5SjqcHREG25lj5CljYwZMyNUIqkcZS1SWRLR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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.40039138943248476`, 0.5505381604696677}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV0nlYTN8Dx/Fpm8a0TYxoI0tJoiitk3Pa+KFSU2mVaZm5JUy0SN8ogwoh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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.46870841487279835`, 0.9151076320939342}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{-122.46299999999997`, 1.6811876571544468`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.43992172211350244`, 0.6968297455968695}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{-189.34419999999997`, -0.16755412353428056`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041098, 0.40590998043052906`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{20., 3.3875862701648884`*^-6}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.47682974559686975`}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              PointBox[{{20., 0.}}]}, {GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, PlotRange -> 
              NCache[{{-273.15000000000003`, 226.85000000000008`}, {
                 2 - Log[10]^(-1) Log[101325], 9 - Log[10]^(-1) 
                  Log[101325]}}, {{-273.15000000000003`, 
                226.85000000000008`}, {-3.00571661241373, 3.99428338758627}}],
               Frame -> True, PlotRangeClipping -> True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{-3, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-2, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-1, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {0, 
                   FormBox["1", TraditionalForm]}, {1, 
                   FormBox["10", TraditionalForm]}, {2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {4, 
                   FormBox[
                    
                    TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}], 
     XMLElement["states", {"count" -> "3"}, {
       XMLElement[
       "state", {
        "name" -> "Use kelvins", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use kelvins"}, \
{}], 
       XMLElement[
       "state", {
        "name" -> "Use megapascals", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use \
megapascals"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Hide labels", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Hide labels"}, \
{}]}]}], Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False}, True}, Typeset`aux5$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "5", "datatypes" -> 
    "ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "1.671", "parsetiming" -> "0.465", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa6251ia1855ie15fb62800005ia1d29g537439cd", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "13", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa6261ia1855ie15fb62800001di9d0h2hfie3ecf&s=13", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 21, 16, 38, 12.6839625`8.855829905799535}, "Line" -> 
    9, "SessionID" -> 23605997882990811695}, Typeset`showpods$$ = {1, 2, 3, 4,
    5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Output", 
    "Quantity[12.48, \"Joules\"/(\"Kelvins\" \"Moles\")]"}, Typeset`open$$ = 
   True, Typeset`newq$$ = "Isochoric heat capacity of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {920., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[12]:=",
 CellID->229475022,ExpressionUUID->"84713b6a-f833-4377-838a-228be12f4eeb"],

Cell[BoxData[
 TemplateBox[{"12.48`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[12]=",
 CellID->379066981,ExpressionUUID->"fc3eac31-5f46-468f-ab01-1339eaa5f5ef"]
}, Open  ]],

Cell["Isochoric heat capacity on the saturation curve from NIST", \
"ExampleText",
 CellID->286706321,ExpressionUUID->"73775e58-06fd-44c5-8569-0a88e061db9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CVAdimNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", 
      FractionBox["3", "2"]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\)\
\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->605199954,ExpressionUUID->"a658ed20-1af3-463a-b44e-f650c1ddc2cc"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwV13k8lF8XAHAzxhbZZogSEi2UFkuJnCsRomTLlkQLRWQrKpElhFeyJDsp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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwV13k8lF8XAHAzxhbZZogSEi2UFkuJnCsRomTLlkQLRWQrKpElhFeyJDsp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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {1.5, 
           5.098695619573369}}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 1.5}, 
          "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {1.5, 
          5.098695619573369}}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 1.5}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwV13k8lF8XAHAzxhbZZogSEi2UFkuJnCsRomTLlkQLRWQrKpElhFeyJDsp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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 1.4168017335853793`}, {1.5, 
        5.098695619573369}}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 1.5}, "ImageSize" -> {450, 450/GoldenRatio},
        "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 1.5},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[SubscriptBox[\\\"C\\\", \
\\\"V\\\"],FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*StyleBox[\\\"R\\\",\
FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->450,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 1.4168017335853793`}, {1.5, 
   5.098695619573369}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->573414357,ExpressionUUID->"7e345594-9f1c-4c74-95f6-f0f5f3511f05"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"7a74adb1-2aea-487a-a623-279d0c7a2e8f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"3893a56c-669c-40b3-bb47-71cda828a511"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "708c7e2f-2fa1-410a-88e4-c3601b853ef6"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"47073259-40c2-46bf-968f-5a13c9540ee5"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"0ae02d3a-1f33-4b43-b5c1-9f3904c689a1"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "6201a02a-7b00-42cd-b249-db5dd45b02c5"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"3400707b-dfb6-4913-93d3-1a8b9f30ce21"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"3c4db1fb-cb39-403e-87b8-d0152b71250f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Cv", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "8"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RR", "*", 
       RowBox[{"CVAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", 
        RowBox[{
         FractionBox["3", "2"], "RR"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \"V\"],FontSlant->\"Italic\"]\
\) (J/mole/K)\>\"", ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7Cv"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CVAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"cd1a5b8a-5339-4b21-b261-a1221ce854e5"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3U9oXF9+5313R7/+abr1S1fABEE7E0/idNTEPVE3xcQLh1YGMe2HMbSZ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    "], {{0, 341.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 341.},
  PlotRange->{{0, 450.}, {0, 341.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->185897559,ExpressionUUID->"8530a57a-bfc0-4797-8e8b-f4eaa67d8592"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"b4571e0e-5ee6-49ed-bbb7-cb20aa88e4cd"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fcc99698-d5dc-4288-b7d3-f209bcb17df5"],
 "Possible Issues",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "9f707f1e-17f7-4d88-a2b8-7ec23f17cb8b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1305812373,ExpressionUUID->"e2551b0b-54d4-4d03-b50c-7b89cf6d0d4f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellLabel->"In[1]:=",
 CellID->13863380,ExpressionUUID->"4d59946c-c332-4be7-84d9-fc37111313a7"],

Cell[BoxData[
 RowBox[{"Manipulate", 
  StyleBox["[",
   FontSize->24], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    StyleBox["Grid",
     FontColor->RGBColor[1, 0.5, 0]], 
    StyleBox["[",
     FontColor->RGBColor[1, 0.5, 0]], 
    RowBox[{
     StyleBox["{",
      FontColor->GrayLevel[0]], 
     RowBox[{
      StyleBox["{",
       FontColor->GrayLevel[0]], 
      RowBox[{"DynamicModule", 
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        RowBox[{"{", "plt1", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Dynamic", "[", "\[IndentingNewLine]", 
         RowBox[{"Switch", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"FreeQ", "[", 
             RowBox[{"TypeRepresentation", ",", "1"}], "]"}]}], ",", "True", 
           ",", "\[IndentingNewLine]", 
           RowBox[{"plt1", "=", 
            RowBox[{"Plot", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"CVAdimNv", "[", 
                RowBox[{"Tisot", ",", "\[Rho]"}], "]"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "0", ",", "\[Rho]Max"}], "}"}], ",", 
              RowBox[{"PlotRange", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "\[Rho]Max"}], "}"}], ",", "All"}], 
                "}"}]}], ",", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", "Red", "}"}]}], ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", 
                 ",", "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\)\
\>\""}], "}"}]}], ",", 
              RowBox[{"ImageSize", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"450", ",", "375"}], "}"}]}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "_", ",", "\[IndentingNewLine]", 
           RowBox[{"plt1", "=", 
            RowBox[{"Plot", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"CVAdimNv", "[", 
                RowBox[{"T", ",", "\[Rho]isoc"}], "]"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"T", ",", "ttr", ",", "TMax"}], "}"}], ",", 
              RowBox[{"PlotRange", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"ttr", ",", "TMax"}], "}"}], ",", "All"}], "}"}]}], 
              ",", 
              RowBox[{"AxesOrigin", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"tc", ",", "Automatic"}], "}"}]}], ",", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", "Red", "}"}]}], ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", 
                 ",", "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\)\
\>\""}], "}"}]}], ",", 
              RowBox[{"ImageSize", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"450", ",", "375"}], "}"}]}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}], "]"}]}], "\[IndentingNewLine]", 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}], "\[IndentingNewLine]", "}"}], "}"}], 
    StyleBox["]",
     FontColor->RGBColor[1, 0.5, 0]]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Choisir le mode de repr\[EAcute]sentation : \>\"", ",", 
       RowBox[{"RadioButtonBar", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", "TypeRepresentation"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "\"\<Isotherme\>\""}], ",", 
           RowBox[{"2", "\[Rule]", "\"\<Isochore\>\""}]}], "}"}]}], "]"}]}], 
      "}"}], "}"}], "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Control", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Tisot", ",", "tc", ",", 
        "\"\<Temp\[EAcute]rature \
\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)(K) de l'isotherme : \>\""}], 
       "}"}], ",", "ttr", ",", "2300", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"Enabled", "\[Rule]", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"!", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"TypeRepresentation", ",", "1"}], "]"}]}]}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Control", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Rho]Max", ",", "\[Rho]trliq", ",", 
        "\"\<Masse volumique \!\(\*SubscriptBox[\(\[Rho]\), \(max\)]\) \
(g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) :\>\""}], "}"}], ",", "\[Rho]trgaz",
       ",", "\[Rho]maxRonc", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"Enabled", "\[Rule]", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"!", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"TypeRepresentation", ",", "1"}], "]"}]}]}]}]}], "}"}], 
    "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Control", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Rho]isoc", ",", "\[Rho]c", ",", 
        "\"\<Masse volumique \[Rho](g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) \
de l'isochore : \>\""}], "}"}], ",", "0", ",", "\[Rho]maxRonc", ",", "0.1", 
      ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"Enabled", "\[Rule]", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"!", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"TypeRepresentation", ",", "2"}], "]"}]}]}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Control", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"TMax", ",", 
        RowBox[{"2", "*", "tc"}], ",", 
        "\"\<Temp\[EAcute]rature \!\(\*SubscriptBox[\(T\), \(max\)]\) (K) :\>\
\""}], "}"}], ",", "ttr", ",", "tmaxRonc", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"Enabled", "\[Rule]", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"!", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"TypeRepresentation", ",", "2"}], "]"}]}]}]}]}], "}"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", "True"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<\>\"", ",", 
      RowBox[{"Column", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<Equations d'\[EAcute]tat de l'argon: \
\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)(\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho])\>\"", ",", "Red", ",", "Large"}], "]"}], ",", "\"\<\>\""}], "}"}], 
       "]"}]}], "}"}]}]}], "\[IndentingNewLine]", 
  StyleBox["]",
   FontSize->24]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellLabel->"In[1]:=",
 CellID->51383423,ExpressionUUID->"414724b1-68a1-4733-a732-871e35d555c3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Tisot$$ = 150.687, $CellContext`TMax$$ = 
    301.374, $CellContext`\[Rho]isoc$$ = 0.535599, $CellContext`\[Rho]Max$$ = 
    1.4168017335853793`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sans titre\"", Typeset`specs$$ = {{
      Hold[
       Grid[{{"Choisir le mode de repr\[EAcute]sentation : ", 
          RadioButtonBar[
           Dynamic[$CellContext`TypeRepresentation], {
           1 -> "Isotherme", 2 -> "Isochore"}]}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Tisot$$], 150.687, 
       "Temp\[EAcute]rature \!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)(K) \
de l'isotherme : "}, 83.8058, 2300, 0.1}, {{
       Hold[$CellContext`\[Rho]Max$$], 1.4168017335853793`, 
       "Masse volumique \!\(\*SubscriptBox[\(\[Rho]\), \(max\)]\) \
(g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) :"}, 0.0040546000061275735`, 
      3.356974789915966, 0.01}, {{
       Hold[$CellContext`\[Rho]isoc$$], 0.535599, 
       "Masse volumique \[Rho](g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) de \
l'isochore : "}, 0, 3.356974789915966, 0.1}, {{
       Hold[$CellContext`TMax$$], 301.374, 
       "Temp\[EAcute]rature \!\(\*SubscriptBox[\(T\), \(max\)]\) (K) :"}, 
      83.8058, 2300, 1}}, Typeset`size$$ = {
    450., {184.8544921875, 190.1455078125}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Tisot$$ = 150.687, $CellContext`TMax$$ = 
        301.374, $CellContext`\[Rho]isoc$$ = 
        0.535599, $CellContext`\[Rho]Max$$ = 1.4168017335853793`}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Grid[{{
          DynamicModule[{$CellContext`plt1}, 
           Dynamic[
            Switch[
             Not[
              FreeQ[$CellContext`TypeRepresentation, 1]], 
             True, $CellContext`plt1 = Plot[{
                
                NewEoSArgon`CVAdimNv[$CellContext`Tisot$$, \
$CellContext`\[Rho]]}, {$CellContext`\[Rho], 0, $CellContext`\[Rho]Max$$}, 
               PlotRange -> {{0, $CellContext`\[Rho]Max$$}, All}, 
               PlotStyle -> {Red}, Frame -> True, 
               FrameLabel -> {
                "\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))", 
                 "\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\)\
"}, ImageSize -> {450, 375}], 
             Blank[], $CellContext`plt1 = Plot[{
                
                NewEoSArgon`CVAdimNv[$CellContext`T, \
$CellContext`\[Rho]isoc$$]}, {$CellContext`T, 
                NewEoSArgon`ttr, $CellContext`TMax$$}, 
               PlotRange -> {{NewEoSArgon`ttr, $CellContext`TMax$$}, All}, 
               AxesOrigin -> {NewEoSArgon`tc, Automatic}, PlotStyle -> {Red}, 
               Frame -> True, 
               FrameLabel -> {
                "\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)", 
                 "\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\)\
"}, ImageSize -> {450, 375}]]]]}}], "Specifications" :> {
        Grid[{{"Choisir le mode de repr\[EAcute]sentation : ", 
           RadioButtonBar[
            Dynamic[$CellContext`TypeRepresentation], {
            1 -> "Isotherme", 2 -> "Isochore"}]}}], 
        Delimiter, {{$CellContext`Tisot$$, 150.687, 
          "Temp\[EAcute]rature \
\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)(K) de l'isotherme : "}, 83.8058,
          2300, 0.1, Appearance -> "Labeled", Enabled -> Dynamic[
           Not[
            
            FreeQ[$CellContext`TypeRepresentation, 
             1]]]}, {{$CellContext`\[Rho]Max$$, 1.4168017335853793`, 
          "Masse volumique \!\(\*SubscriptBox[\(\[Rho]\), \(max\)]\) \
(g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) :"}, 0.0040546000061275735`, 
         3.356974789915966, 0.01, Appearance -> "Labeled", Enabled -> Dynamic[
           Not[
            FreeQ[$CellContext`TypeRepresentation, 1]]]}, 
        Delimiter, {{$CellContext`\[Rho]isoc$$, 0.535599, 
          "Masse volumique \[Rho](g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\)) de \
l'isochore : "}, 0, 3.356974789915966, 0.1, Appearance -> "Labeled", Enabled -> 
         Dynamic[
           Not[
            
            FreeQ[$CellContext`TypeRepresentation, 
             2]]]}, {{$CellContext`TMax$$, 301.374, 
          "Temp\[EAcute]rature \!\(\*SubscriptBox[\(T\), \(max\)]\) (K) :"}, 
         83.8058, 2300, 1, Appearance -> "Labeled", Enabled -> Dynamic[
           Not[
            FreeQ[$CellContext`TypeRepresentation, 2]]]}}, 
      "Options" :> {TrackedSymbols :> True, FrameLabel -> {"", "", 
          Column[{
            Style[
            "Equations d'\[EAcute]tat de l'argon: \
\!\(\*StyleBox[SubscriptBox[\"C\", \
\"V\"],FontSlant->\"Italic\"]\)(\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho])", 
             RGBColor[1, 0, 0], Large], ""}]}}, "DefaultOptions" :> {}],
     ImageSizeCache->{501., {308.8544921875, 314.1455078125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`TypeRepresentation = 1; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellLabel->"Out[1]=",
 CellID->32472775,ExpressionUUID->"1d014b94-a39a-415f-8aca-21f7f2345123"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CpAdimNv"]], "paclet:NewEoSArgon/ref/CpAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "005d4ccb-3f5f-49cc-b001-890b807c8152"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "f9622ee1-4a37-4d13-92ca-7103daf446b5"]
       }], "SeeAlso",ExpressionUUID->"a43dee63-d1fb-4342-9eda-36e79d0bd5c0"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"69d23f25-229a-4bcb-a584-\
a1bbc9ac749d"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "bd276f89-4f5d-47d0-9a5b-1b724a1d26a4"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"0abe8d21-334a-44de-80c8-\
f134fe8add77"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ca7facb2-8fe9-49bf-b79e-6606fc5f2257"]], "RelatedLinks",
        ExpressionUUID->"98a202f1-3d52-48dc-a298-f566ee7c96b5"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "b64707cc-7665-44ae-89b6-a1f9dd308d9b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b737bbd2-429e-41cd-afa8-24931c119de6"]], "RelatedLinks",
        ExpressionUUID->"b8db98a0-b321-4e88-82d9-9dc2fd4b2add"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"619748ff-1620-43f1-8e52-\
a74e150432ba"],

Cell[" ", "FooterCell",ExpressionUUID->"4c370036-519d-4acb-9fe1-27bbb70bfc8c"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CVAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed, "3" -> Closed}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 29.3670881}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CVAdimNv[T, \\[Rho]] \\[Congruent] CV/R Capacit\[EAcute] calorifique \
isochore adimensionnelle en fonction de T (Kelvin) et \\[Rho] (g/cm^3) \
[Non-dimensionnal isochoric heat capacity function versus T (Kelvin) and \
\\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CVAdimNv", "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "CVAdimNv", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/CVAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"489c5d47-9e27-4801-89a7-c171e692f460"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10492, 286, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"38a18cfc-3a9c-4c5d-b644-b2d95c41430d",
   CellTags->"PrimaryExamplesSection",
   CellID->873447716]},
 "RasterizedOutput"->{
  Cell[172970, 3375, 36687, 608, 362, "Output",ExpressionUUID->"8530a57a-bfc0-4797-8e8b-f4eaa67d8592",
   CellTags->"RasterizedOutput",
   CellID->185897559]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 231210, 4508},
 {"RasterizedOutput", 231410, 4512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5290, 129, 56, "AnchorBarGrid",ExpressionUUID->"a66ed386-69bf-413f-9b46-db5eca21dc78",
 CellID->1],
Cell[5873, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"ef1d59d1-4d3e-43cc-a6cd-29028c7deee5"],
Cell[CellGroupData[{
Cell[5992, 156, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"f05a3004-5b60-4e58-b3b3-a4467fa25682"],
Cell[6546, 172, 1207, 33, 146, "Usage",ExpressionUUID->"c0511e0a-3e7d-4482-8d61-1593741874c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7790, 210, 1919, 48, 37, "NotesSection",ExpressionUUID->"22616a60-679b-4c98-aa51-3b089fbbc4e1",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->377541127],
Cell[9712, 260, 235, 6, 36, "Notes",ExpressionUUID->"0bd1b210-ab3d-4e0f-869e-148dbcd37f2b",
 CellID->1067943069],
Cell[9950, 268, 186, 4, 36, "Notes",ExpressionUUID->"76ea4dc1-01b7-467e-84a6-2d6faef3b05e",
 CellID->224665577],
Cell[10139, 274, 226, 6, 36, "Notes",ExpressionUUID->"31275ad7-4a26-4dc0-8bc1-513520e32455",
 CellID->694074772]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10492, 286, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"38a18cfc-3a9c-4c5d-b644-b2d95c41430d",
 CellTags->"PrimaryExamplesSection",
 CellID->873447716],
Cell[CellGroupData[{
Cell[11937, 327, 1398, 36, 30, "ExampleSection",ExpressionUUID->"6f4152af-d676-463d-a572-a63a9470ee9f",
 CellID->344159173],
Cell[13338, 365, 268, 5, 42, "Input",ExpressionUUID->"7d497bec-8eda-45f2-9a24-e01690665389",
 CellID->143015886],
Cell[13609, 372, 351, 8, 38, "ExampleText",ExpressionUUID->"56769733-e9dd-443a-bac1-1fe48d613c7c",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13985, 384, 1127, 28, 57, "Input",ExpressionUUID->"75d35cd1-e8eb-4def-9b07-023b069aada9",
 CellID->5710145],
Cell[15115, 414, 697, 15, 45, "Output",ExpressionUUID->"de4e88e6-229a-4aaa-9333-cb706bdb6c41",
 CellID->631667949]
}, Open  ]],
Cell[CellGroupData[{
Cell[15849, 434, 531, 13, 46, "Input",ExpressionUUID->"7d7f7777-835d-4e76-accb-2df5d1ad0a6e",
 CellID->557594352],
Cell[16383, 449, 436, 10, 43, "Output",ExpressionUUID->"9fbeaa54-3237-4b96-98bf-a0ac0628dabd",
 CellID->277801167]
}, Open  ]],
Cell[16834, 462, 154, 1, 38, "ExampleText",ExpressionUUID->"eedc5c5b-c2e7-43a8-8b80-93bd04baed20",
 CellID->361149294],
Cell[CellGroupData[{
Cell[17013, 467, 675, 15, 42, "Input",ExpressionUUID->"980506d7-8bb5-46d2-b693-064856c96257",
 CellID->375583457],
Cell[17691, 484, 436, 10, 43, "Output",ExpressionUUID->"de93ae3e-626f-4d72-a980-3b91bed9bd8f",
 CellID->422288595]
}, Open  ]],
Cell[18142, 497, 116, 1, 38, "ExampleText",ExpressionUUID->"a7f1764d-faa2-4373-b7fd-32e0343bddf0",
 CellID->721118955],
Cell[CellGroupData[{
Cell[18283, 502, 111372, 2020, 956, "WolframAlphaShortInput",ExpressionUUID->"84713b6a-f833-4377-838a-228be12f4eeb",
 CellID->229475022],
Cell[129658, 2524, 424, 10, 43, "Output",ExpressionUUID->"fc3eac31-5f46-468f-ab01-1339eaa5f5ef",
 CellID->379066981]
}, Open  ]],
Cell[130097, 2537, 157, 2, 70, "ExampleText",ExpressionUUID->"73775e58-06fd-44c5-8569-0a88e061db9e",
 CellID->286706321],
Cell[CellGroupData[{
Cell[130279, 2543, 996, 26, 70, "Input",ExpressionUUID->"a658ed20-1af3-463a-b44e-f650c1ddc2cc",
 CellID->605199954],
Cell[131278, 2571, 36533, 650, 70, "Output",ExpressionUUID->"7e345594-9f1c-4c74-95f6-f0f5f3511f05",
 CellID->573414357]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[167960, 3229, 1419, 37, 70, "ExampleSection",ExpressionUUID->"47073259-40c2-46bf-968f-5a13c9540ee5",
 CellID->258228157],
Cell[169382, 3268, 174, 3, 70, "Input",ExpressionUUID->"0ae02d3a-1f33-4b43-b5c1-9f3904c689a1",
 CellID->87419684],
Cell[169559, 3273, 401, 11, 70, "ExampleText",ExpressionUUID->"3400707b-dfb6-4913-93d3-1a8b9f30ce21",
 CellID->227520913],
Cell[169963, 3286, 464, 13, 70, "Input",ExpressionUUID->"3c4db1fb-cb39-403e-87b8-d0152b71250f",
 CellID->531122037],
Cell[CellGroupData[{
Cell[170452, 3303, 2515, 70, 70, "Input",ExpressionUUID->"cd1a5b8a-5339-4b21-b261-a1221ce854e5",
 CellID->136921489],
Cell[172970, 3375, 36687, 608, 362, "Output",ExpressionUUID->"8530a57a-bfc0-4797-8e8b-f4eaa67d8592",
 CellTags->"RasterizedOutput",
 CellID->185897559]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[209806, 3991, 1423, 37, 70, "ExampleSection",ExpressionUUID->"e2551b0b-54d4-4d03-b50c-7b89cf6d0d4f",
 CellID->1305812373],
Cell[CellGroupData[{
Cell[211254, 4032, 227, 4, 70, "Input",ExpressionUUID->"4d59946c-c332-4be7-84d9-fc37111313a7",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellID->13863380],
Cell[211484, 4038, 7541, 187, 70, "Input",ExpressionUUID->"414724b1-68a1-4733-a732-871e35d555c3",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellID->51383423],
Cell[219028, 4227, 6097, 121, 70, "Output",ExpressionUUID->"1d014b94-a39a-415f-8aca-21f7f2345123",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellID->32472775]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[225367, 4357, 1367, 36, 70, "SeeAlsoSection",ExpressionUUID->"69d23f25-229a-4bcb-a584-a1bbc9ac749d"],
Cell[226737, 4395, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"0abe8d21-334a-44de-80c8-f134fe8add77"],
Cell[227469, 4416, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"619748ff-1620-43f1-8e52-a74e150432ba"],
Cell[229079, 4461, 78, 0, 70, "FooterCell",ExpressionUUID->"4c370036-519d-4acb-9fe1-27bbb70bfc8c"]
}
]
*)

(* End of internal cache information *)

