(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    113996,       2605]
NotebookOptionsPosition[    106839,       2462]
NotebookOutlinePosition[    109156,       2519]
CellTagsIndexPosition[    109069,       2514]
WindowTitle->CeleriteSonNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "f76fd73e-0044-4c7d-b764-89a61f5dc3a0"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "86067e37-ab02-4e32-8aef-1bca123d4f3b"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c7d6a4e0-63fb-4a2e-8fd5-41985d296e9d"]
         }],ExpressionUUID->"a70377b5-3a29-4f10-9d30-c15b2a5b62c0"],
         StripOnInput->False],{
        "\"CompressibiliteKSNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKSNv"], "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a10912f8-d248-41ba-873b-118212de6c78"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "df53f6d6-b129-4257-a96a-ebba54ac6ca4"]
         }],ExpressionUUID->"fcd930c4-981b-443e-973d-5719be7cff72"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3cb8819e-b65b-4e90-bc91-e7bf38898a57"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "9845422f-8804-4304-95e7-387bfdf0f9cd"]
         }],ExpressionUUID->"b9e628e4-ce5a-4e75-bf25-b767e7d6e487"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CeleriteSonNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CeleriteSonNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CeleriteSonNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$7287], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CeleriteSonNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "45340537-e8e0-40dc-b037-b125465b3deb"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "5282d5c7-6e64-4436-8536-e3fa6dc297ae"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"d6e96b59-cdb8-4436-80c9-07adda4b1e2a"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"af1e5e58-b74a-468b-abea-d2e017da22d5"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CeleriteSonNv", "ObjectName",ExpressionUUID->
      "b9a4755a-3e90-400e-8fc7-6c30cd2fbd61"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"fb1aa499-38d2-485e-8345-477abb9a5a69"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "dc34efe6-62fa-4eb1-b5e1-e940bde0ceb0"]
    }],ExpressionUUID->"a0a7fae0-d6ea-48f6-ac73-e9d58751af27"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"9db50f4e-cdea-4b54-ba53-\
6fa2db84650f"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CeleriteSonNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["c",
      FontSlant->"Italic"],
     " (m/s)\nC\[EAcute]l\[EAcute]rit\[EAcute] du son de l'argon en fonction \
de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "dd8eb9b8-832c-4848-80e2-efa684cc59ac"],
     ") \n[Speed of sound versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "ee5f2f4e-656b-429e-856a-b22276021e9d"],
     ")]"
    }],ExpressionUUID->"e7cb5161-f963-4f0e-904d-34620b096676"]}
  }]], "Usage",ExpressionUUID->"0ca0ac6b-7569-4985-aeb1-0664ae4f7f57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"484da693-e578-4091-978a-797103a2e237"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"8356b6ac-a50f-4b72-a1a3-af11a3b3ebc1"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"f936cbe5-c47b-40b5-bd0d-10b7a0f4c00a"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"166b20e7-4002-435d-b854-e2d3c3906b59"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->384529845,ExpressionUUID->"c1b7a009-7f8b-4bbf-960a-98ea00c383fc"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "58b2edde-cfcd-4f01-989d-bd36524f34ea"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2b6cdabd-2969-4346-b781-bed8230abdb9"],

Cell[TextData[{
 "La fonction ",
 StyleBox["c",
  FontSlant->"Italic"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["c",
    FontSlant->"Italic"], "2"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5c8be906-deca-472d-9dd0-0ef044dce798"],
 " = ",
 Cell[BoxData[
  FractionBox[
   StyleBox["V",
    FontSlant->"Italic",
    FontVariations->{"Underline"->True}], 
   StyleBox[
    SubscriptBox["K", "S"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "25d5afbc-e82d-491d-ba2d-54526808c1a7"],
 " = ",
 Cell[BoxData[
  FractionBox[
   StyleBox["V",
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["K", "T"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "80263bd2-89ed-41bc-be2d-b0c4537f7c0d"],
 Cell[BoxData[
  FractionBox[
   StyleBox[
    SubscriptBox["C", "P"],
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["C", "V"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "53849dd4-0601-46c2-aba6-cfd277de5f88"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"8870c8b8-9663-4604-a9ff-4fc19e3bcf94"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"368b5eb4-c7d0-4337-bff8-0b8731c73e39"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0efae83c-5189-4073-93f9-82f34775eded"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"40fcedda-64d0-4170-87b7-40624d32c766"],

Cell[TextData[{
 "The function ",
 StyleBox["c",
  FontSlant->"Italic"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) is determined here from the following relationship: ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["c",
    FontSlant->"Italic"], "2"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1b35389d-5ff0-412d-ac50-a67b4f67c5cf"],
 " = ",
 Cell[BoxData[
  FractionBox[
   StyleBox["V",
    FontSlant->"Italic",
    FontVariations->{"Underline"->True}], 
   StyleBox[
    SubscriptBox["K", "S"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2366b208-c0b9-4bd6-9a1c-bfab5f3250dc"],
 " = ",
 Cell[BoxData[
  FractionBox[
   StyleBox["V",
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["K", "T"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "19b017cd-af08-4a4f-8dbc-5c4e62478aac"],
 Cell[BoxData[
  FractionBox[
   StyleBox[
    SubscriptBox["C", "P"],
    FontSlant->"Italic"], 
   StyleBox[
    SubscriptBox["C", "V"],
    FontSlant->"Italic"]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fba7ee3d-b0a5-47d4-8307-6f3d2dc431bc"]
}], "Notes",
 CellID->508850368,ExpressionUUID->"85c41575-a96a-462f-bc2a-f1983784fc4f"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"8c000f32-cdc8-4200-8319-5472a5deb128"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"d5e34529-876d-4ee6-81d1-1b4387d578db"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "3b26b560-f227-4fa4-a6ee-7926fe865c71"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->543689518,ExpressionUUID->"7ec3604c-e005-4857-ba01-2101f479de30"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"e5ca7391-ef80-441d-83cb-5a8611f7cd16"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"58b44e27-15e8-4740-b04c-7f4f184da2e7"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "c853b42a-d5e2-4bf3-ad1f-42a4e7f55fb0"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->56425832,ExpressionUUID->"de009dd5-56cb-4f1f-b356-61887302aacd"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"5405022e-930e-4bd0-acc2-b2966e439f58"],

Cell[TextData[{
 "Calculated value of ",
 StyleBox["c",
  FontSlant->"Italic"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"eb2e4088-a392-460a-adf4-446d953727fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"CeleriteSonNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", "\"\<m/s\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"fa2c9c81-680d-421f-961c-fec814782a5a"],

Cell[BoxData[
 TemplateBox[{"318.96066965233223`", 
   RowBox[{
    "\"m\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"s\""}], 
   "meters per second", 
   FractionBox["\"Meters\"", "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->14785721,ExpressionUUID->"81fc3cc1-ac18-458d-906b-17c8c0190fab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"318.9606696523322`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"m\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", "\"s\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: meters per second"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Meters\"", "\"Seconds\""]}], "]"}]& )], ",", 
   "\"\<km/h\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->221435891,ExpressionUUID->"e70f3728-121d-475f-93d0-80e90daaef82"],

Cell[BoxData[
 TemplateBox[{"1148.2584107483958`", 
   RowBox[{
    "\"km\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"h\""}], 
   "kilometers per hour", 
   FractionBox["\"Kilometers\"", "\"Hours\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->12656227,ExpressionUUID->"fd86d6b5-003f-416e-8f94-10cb0ef9ff8b"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"73e1f43f-4a36-401a-b14d-85937127ec86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<SoundSpeed\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<m/s\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"81c89784-9a11-459a-a939-29ebc1656836"],

Cell[BoxData[
 TemplateBox[{"318.9590594076217`", 
   RowBox[{
    "\"m\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"s\""}], 
   "meters per second", 
   FractionBox["\"Meters\"", "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->12607909,ExpressionUUID->"7df8dd80-a052-42d2-841e-017df8b7ad7c"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->23746012,ExpressionUUID->"cba26674-5b86-41e8-bc66-37a582595cd7"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "speed of sound of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "ElementData[\"Argon\", \"SoundSpeed\"]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["minput", {}, {"ElementData[\"Argon\", \"SoundSpeed\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    TagBox["\"sound speed\"", Identity]}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[319, \"Meters\"/\"Seconds\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["319", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "319"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"meters per second\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "5"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.319", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.319"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilometers per second\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["714", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "714"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mph\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"miles per hour\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["11.9", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "11.9"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"mi\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"min\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"miles per minute\"", "\[NoBreak]",
                    "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.198", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.198"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"mi\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                 Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"miles per second\"", "\[NoBreak]",
                    "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["19.1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "19.1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"min\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilometers per minute\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "More", "input" -> "UnitConversion__More"}, {}]}]}], 
   Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons as sound speed", "scanner" -> "Unit", "id" -> 
     "ComparisonAsSoundSpeed", "position" -> "400", "error" -> "false", 
     "numsubpods" -> "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "9", "3"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"speed of sound in dry air at 20 \[Degree]C and 1 atmosphere \
pressure\"", FontFamily -> "Helvetica", FontSize -> Smaller, StripOnInput -> 
                False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["343", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "343"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "9", "4"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"speed of sound in dry air at 15 \[Degree]C and 1 atmosphere \
pressure\"", FontFamily -> "Helvetica", FontSize -> Smaller, StripOnInput -> 
                False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["340", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "340"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "1", "\".\"", "2"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"speed of sound in dry air at 35000 feet\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["585", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "585"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mph\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`aux1$$ = {
   True, False, {False}, True}, Typeset`aux2$$ = {True, False, {False}, True},
    Typeset`aux3$$ = {True, False, {False, False, False, False, False}, True},
    Typeset`aux4$$ = {True, False, {False, False, False}, True}, 
   Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "4", "datatypes" -> 
    "Element", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.107", 
    "parsetiming" -> "0.408", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa43771b45h01h82c027c800001dibd5c3iefb54ge", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "40", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa43781b45h01h82c027c800005e056d05f0hbgdh2&s=40", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 14, 8, 38, 15.7791969`8.950659843776041}, "Line" -> 
    11, "SessionID" -> 23601826909997951456}, Typeset`showpods$$ = {1, 2, 3, 
   4}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "ElementData[\"Argon\", \"SoundSpeed\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "speed of sound of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$}, 
        Typeset`chosen$$, Typeset`open$$, Typeset`elements$$, Typeset`q$$, 
        Typeset`opts$$, Typeset`nonpods$$, Typeset`queryinfo$$, 
        Typeset`sessioninfo$$, Typeset`showpods$$, Typeset`failedpods$$, 
        Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {579., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$}],
        Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[89]:=",
 CellID->947043813,ExpressionUUID->"38c327b5-fbcf-45c8-92c6-be61bac922d5"],

Cell[BoxData[
 TemplateBox[{"319.`3.", 
   RowBox[{
    "\"m\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"s\""}], 
   "meters per second", 
   FractionBox["\"Meters\"", "\"Seconds\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[89]=",
 CellID->117864893,ExpressionUUID->"3cdd0cc9-9a92-4b94-a43a-e3dec84058e2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"ca8e2d72-ffe7-4a46-8ac9-bfa9095b5ffe"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"abe22384-fdec-4667-b9aa-ad5e193afc1c"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "efbd6860-8f6d-4f75-a881-ee99611e3468"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"d89f755e-3225-47dc-b291-e7a16cc53b22"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"e0598593-1ce7-4970-85d6-a4607fbc682d"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"977c44cb-199c-4929-a060-2671adb0914c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "399.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "445.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "582.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "729.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "827.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "903.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "966.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "1021.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "1070.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "1114.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "1154.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "1192.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "1227.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "1260.3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "1291.8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "1321.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "1350.9"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"m", "/", "s"}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"ebd922bb-bb7e-4801-b2b5-4a21c1c01193"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"CeleriteSonNv", "[", 
         RowBox[{"150", ",", 
          RowBox[{"RhoArgonNv", "[", 
           RowBox[{"150", ",", 
            RowBox[{
             RowBox[{"dataStreett150", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
           "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"m", "/", "s"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"data150", ",", 
    RowBox[{"{", 
     RowBox[{"300", ",", 
      RowBox[{"CeleriteSonNv", "[", 
       RowBox[{"150", ",", 
        RowBox[{"RhoArgonNv", "[", 
         RowBox[{"150", ",", 
          RowBox[{"300", "*", "1.01325"}]}], "]"}]}], "]"}]}], "}"}]}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"vson", "=", 
  RowBox[{"Interpolation", "[", "data150", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"9533757c-d88f-4081-849b-c8453efe8ae8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                    1376.4789118269227`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 400.60357340898327`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                    1376.4789118269227`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 400.60357340898327`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                   1376.4789118269227`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 400.60357340898327`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 400.60357340898327`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 400.60357340898236`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {400.60357340898236`, 
               1376.4789118269227`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                    1376.4789118269227`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 400.60357340898327`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                    1376.4789118269227`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 400.60357340898327`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVkHswFAgAxjfk0FweESFyphaddeVurrVcXx5dRhHyaLdblJJyuehOeeT2
dssu+35aVljWoo5rUMlrmew5Q+VupNxVRzpx28lzJpqc/vi+33/fzO9zO54e
ddKIQCD4r+UDDS6yBwTCEZiFKPxrzS8h9IiQdemfBOgMn84OuuTDgX76e+Wp
UyBPTww/VDIwoPgusiAtDaVCr7Ohpkz8Tco2c/I6D+ZdRWQ5hYU8Ok9qRL+A
5X0fu+fRrmBZaNuym5YFn4cX3xw7dBWOVq/XZRZn4/Fwv08HuQDUGKZOos/D
3OGCYrYlGx339Zz39B/xLOeXUZ6eDRflhdC2ZQbyOJjp+lDJx6Kdc5hIZ8Xo
21wKMbTJXf56noWRcE+/heZCmKTazOi5VzGiWrKJDC+CtosiDrZgYyZeHEIb
LkJpOy+sX8uBPe+ypzaRiwpVZ4AuoAi34sdtaS+4sL3smU29w0VPUR2VH8fD
6PqOgXdRfIiftt2eeMCDlaAwNeh3AcZyZ0kMCh9hCdj42x0hiBVHq7jX+ZC/
8mLVskS4Fxqc/JGdAMqM3a6jgWLcoD9m3c4UoDcivNfSWoL7Y8R/bz0SoM67
QKgYkuBczZ4+Ewch7PJ8LsbxpYhNGBzKChSi3tVwxokmg0t/fg8pXYilnt6f
djnKoaUstg4qhDjb2qQJm5Jj5xZf5/4eIU67Wb8sa1ZA7z292ckgxNbCotDA
jGK8CP8jg2AjwkqIY+v0XiVqJR35cj8RREb6Qy9XlShWqrZ7JYrQ+NnYe/v2
EvxaOpSgX/NYumnVFs4uhemJlOqEGyIs+n6jGtmvwslPpBPUIRGczTvZyXZl
aFuY4re8Xdt/RikJelSGDXQPPt9VjOM7PPuokmswizlj8jxYjDmd17ofEsvB
LLbZ9/O3YmxtqG6ctazAlw3j1wOlYsRu/yq5PqsCjRbtzSc6xYiOsSTmP61A
qvp8ncWrtR/Xp7/L9a9E1N5w1x2WEiifx4/kVlVisSvm4CRZgnHy0D2NsRoq
Xzn/TZIEMwcZuukkNVYiuCVkjgQiTlv3rj41dq6QmgabJBDsZw1XEqtQs0ST
pf0pgZv3yH+bBFXQpRy47G4qRdZA0mb1QhVuGrrnO3yk8DRkHz4aXQ3/FuMK
j1gp0r9wEdrcrca52kwLSr4U1qsR4wtbNHCie4ybaaQ4MLfB7wlDA3V9KZk6
KEXQtdXyJ5MamJMEk3sWpCjpZzgYf12Dbh9TVb+9DFe28eWkhhpMEXOsOAEy
DCx5EJkbtYB6unc+QQbzOObb1XQtPq/7K2WaIcP/P2nIpA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {400.60357340898236`, 
                   1376.4789118269227`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 400.60357340898327`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 400.60357340898327`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 400.60357340898236`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {400.60357340898236`, 
               1376.4789118269227`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {18}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   200., 300., 400., 600., 800., 1000., 1200., 1400., 1600., 1800., 2000., 
   2200., 2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17, 18}, {400.6034479617926, 446.9066445598727, 
    582.1680707205644, 665.423235670379, 728.8486477747606, 826.0866886059111,
     901.0828810764643, 962.3580783048972, 1014.0269024522324`, 
    1058.8842962490198`, 1099.5014501569212`, 1138.4454262147144`, 
    1177.790937358903, 1218.4946619888042`, 1260.0987180303903`, 
    1301.2026191032098`, 1340.314357960502, 1376.4789203326939`}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->4785203,ExpressionUUID->"47989872-4ede-45a0-a6fb-f7f7cb6a4734"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vson", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1400"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"c\",FontSlant->\"Italic\"]\) (m/s)\>\"", ",", 
        "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CeleriteSonNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\)\
,\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"d83a8209-ff7c-4742-b3b9-f98cc95a39fa"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwV0Hs41IkeBnBZQpROLjlIS9l1WSzaSO3prRNJR+R+F+OeyzAuDYYZ5DLC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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwV0Hs41IkeBnBZQpROLjlIS9l1WSzaSO3prRNJR+R+F+OeyzAuDYYZ5DLC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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, {0., 1400.}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {48.63, 0.}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, {0., 1400.}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {48.63, 0.}, "ImageSize" -> {450, 450/GoldenRatio},
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwV0Hs41IkeBnBZQpROLjlIS9l1WSzaSO3prRNJR+R+F+OeyzAuDYYZ5DLC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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, {0., 1400.}}, 
         "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {48.63, 0.},
          "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {48.63, 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {48.63, 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{80, 399.7}], 
        PointBox[{100, 445.4}], 
        PointBox[{200, 582.4}], 
        PointBox[{400, 729.7}], 
        PointBox[{600, 827.2}], 
        PointBox[{800, 903.3}], 
        PointBox[{1000, 966.7}], 
        PointBox[{1200, 1021.7}], 
        PointBox[{1400, 1070.4}], 
        PointBox[{1600, 1114.5}], 
        PointBox[{1800, 1154.9}], 
        PointBox[{2000, 1192.3}], 
        PointBox[{2200, 1227.3}], 
        PointBox[{2400, 1260.3}], 
        PointBox[{2600, 1291.8}], 
        PointBox[{2800, 1321.9}], 
        PointBox[{3000, 1350.9}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"c\\\",FontSlant->\\\"Italic\\\"]\\) \
(m/s)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(atm)\"", HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, {0., 1400.}}, 
     PlotRangeClipping -> True, 
     PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"STREETT (1974)\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"CeleriteSonNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"\
]\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[4]=",
 CellID->298347213,ExpressionUUID->"0e214c7a-9083-4bde-9ced-78c931f342b5"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CompressibiliteKSNv"]], 
           "paclet:NewEoSArgon/ref/CompressibiliteKSNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e58f2987-cf8d-491f-8a0e-714165dc57f8"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0de50111-9714-456f-a226-e26244388f06"]
       }], "SeeAlso",ExpressionUUID->"6e1e6530-827b-4be4-bb2a-50dacbb60070"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"a1c62501-c460-4c4f-81eb-\
2bf5abff1a69"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "0e1668fa-e284-4d76-b86e-fd4bd0da808a"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"35e8b815-ba14-4b6b-b636-\
716395b7caec"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ea243b8d-e6af-44e6-aa99-01bbb4ccd298"]], "RelatedLinks",
        ExpressionUUID->"85608ae6-ba20-47ff-a217-cac6604147aa"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "c53baa98-e7cc-4926-8215-f4e8c3b0024e"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "620f56ae-1915-403d-94f5-6ceccbda91a8"]], "RelatedLinks",
        ExpressionUUID->"27740f40-2e87-4dcb-ab18-be5324aaa9bb"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"4d84ddf3-a510-41f4-bd85-\
6a68a546b795"],

Cell[" ", "FooterCell",ExpressionUUID->"89bf2d72-4e99-45cb-8c85-b572871b0272"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CeleriteSonNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 13.8744569}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CeleriteSonNv[T, \\[Rho]] \\[Congruent] c (m/s) C\[EAcute]l\[EAcute]rit\
\[EAcute] du son de l'argon en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[Speed of sound versus T (Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "CeleriteSonNv", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "CeleriteSonNv", "type" -> 
    "Symbol", "uri" -> "NewEoSArgon/ref/CeleriteSonNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"c8e5377b-71da-4f12-8182-5004c41694ef"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13537, 398, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7ec3604c-e005-4857-ba01-2101f479de30",
   CellTags->"PrimaryExamplesSection",
   CellID->543689518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 108869, 2507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[585, 21, 5350, 130, 56, "AnchorBarGrid",ExpressionUUID->"d6e96b59-cdb8-4436-80c9-07adda4b1e2a",
 CellID->1],
Cell[5938, 153, 94, 0, 23, "ContextNameCell",ExpressionUUID->"af1e5e58-b74a-468b-abea-d2e017da22d5"],
Cell[CellGroupData[{
Cell[6057, 157, 556, 14, 56, "ObjectNameGrid",ExpressionUUID->"9db50f4e-cdea-4b54-ba53-6fa2db84650f"],
Cell[6616, 173, 963, 27, 146, "Usage",ExpressionUUID->"0ca0ac6b-7569-4985-aeb1-0664ae4f7f57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7616, 205, 1919, 48, 37, "NotesSection",ExpressionUUID->"c1b7a009-7f8b-4bbf-960a-98ea00c383fc",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->384529845],
Cell[9538, 255, 529, 16, 38, "Notes",ExpressionUUID->"2b6cdabd-2969-4346-b781-bed8230abdb9",
 CellID->1067943069],
Cell[10070, 273, 1326, 47, 41, "Notes",ExpressionUUID->"8870c8b8-9663-4604-a9ff-4fc19e3bcf94",
 CellID->524000197],
Cell[11399, 322, 186, 4, 36, "Notes",ExpressionUUID->"368b5eb4-c7d0-4337-bff8-0b8731c73e39",
 CellID->224665577],
Cell[11588, 328, 519, 16, 38, "Notes",ExpressionUUID->"40fcedda-64d0-4170-87b7-40624d32c766",
 CellID->51803587],
Cell[12110, 346, 1300, 46, 41, "Notes",ExpressionUUID->"85c41575-a96a-462f-bc2a-f1983784fc4f",
 CellID->508850368]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[13537, 398, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"7ec3604c-e005-4857-ba01-2101f479de30",
 CellTags->"PrimaryExamplesSection",
 CellID->543689518],
Cell[CellGroupData[{
Cell[14982, 439, 1397, 36, 30, "ExampleSection",ExpressionUUID->"de009dd5-56cb-4f1f-b356-61887302aacd",
 CellID->56425832],
Cell[16382, 477, 268, 5, 42, "Input",ExpressionUUID->"5405022e-930e-4bd0-acc2-b2966e439f58",
 CellID->143015886],
Cell[16653, 484, 219, 6, 38, "ExampleText",ExpressionUUID->"eb2e4088-a392-460a-adf4-446d953727fa",
 CellID->544149791],
Cell[CellGroupData[{
Cell[16897, 494, 1002, 24, 26, "Input",ExpressionUUID->"fa2c9c81-680d-421f-961c-fec814782a5a",
 CellID->254692277],
Cell[17902, 520, 333, 8, 40, "Output",ExpressionUUID->"81fc3cc1-ac18-458d-906b-17c8c0190fab",
 CellID->14785721]
}, Open  ]],
Cell[CellGroupData[{
Cell[18272, 533, 789, 21, 26, "Input",ExpressionUUID->"e70f3728-121d-475f-93d0-80e90daaef82",
 CellID->221435891],
Cell[19064, 556, 338, 8, 41, "Output",ExpressionUUID->"fd86d6b5-003f-416e-8f94-10cb0ef9ff8b",
 CellID->12656227]
}, Open  ]],
Cell[19417, 567, 154, 1, 38, "ExampleText",ExpressionUUID->"73e1f43f-4a36-401a-b14d-85937127ec86",
 CellID->361149294],
Cell[CellGroupData[{
Cell[19596, 572, 642, 15, 42, "Input",ExpressionUUID->"81c89784-9a11-459a-a939-29ebc1656836",
 CellID->375583457],
Cell[20241, 589, 332, 8, 40, "Output",ExpressionUUID->"7df8dd80-a052-42d2-841e-017df8b7ad7c",
 CellID->12607909]
}, Open  ]],
Cell[20588, 600, 115, 1, 38, "ExampleText",ExpressionUUID->"cba26674-5b86-41e8-bc66-37a582595cd7",
 CellID->23746012],
Cell[CellGroupData[{
Cell[20728, 605, 23885, 509, 615, "WolframAlphaShortInput",ExpressionUUID->"38c327b5-fbcf-45c8-92c6-be61bac922d5",
 CellID->947043813],
Cell[44616, 1116, 323, 8, 40, "Output",ExpressionUUID->"3cdd0cc9-9a92-4b94-a43a-e3dec84058e2",
 CellID->117864893]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[45088, 1132, 1419, 37, 70, "ExampleSection",ExpressionUUID->"d89f755e-3225-47dc-b291-e7a16cc53b22",
 CellID->258228157],
Cell[46510, 1171, 268, 5, 70, "Input",ExpressionUUID->"e0598593-1ce7-4970-85d6-a4607fbc682d",
 CellID->279378555],
Cell[46781, 1178, 201, 4, 70, "ExampleText",ExpressionUUID->"977c44cb-199c-4929-a060-2671adb0914c",
 CellID->227520913],
Cell[46985, 1184, 1531, 44, 70, "Input",ExpressionUUID->"ebd922bb-bb7e-4801-b2b5-4a21c1c01193",
 CellID->243734080],
Cell[CellGroupData[{
Cell[48541, 1232, 1387, 40, 70, "Input",ExpressionUUID->"9533757c-d88f-4081-849b-c8453efe8ae8",
 CellID->123312038],
Cell[49931, 1274, 29687, 571, 70, "Output",ExpressionUUID->"47989872-4ede-45a0-a6fb-f7f7cb6a4734",
 CellID->4785203]
}, Open  ]],
Cell[CellGroupData[{
Cell[79655, 1850, 2039, 56, 70, "Input",ExpressionUUID->"d83a8209-ff7c-4742-b3b9-f98cc95a39fa",
 CellID->283061935],
Cell[81697, 1908, 21072, 438, 351, "Output",ExpressionUUID->"0e214c7a-9083-4bde-9ced-78c931f342b5",
 CellID->298347213]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[103011, 2355, 1401, 37, 70, "SeeAlsoSection",ExpressionUUID->"a1c62501-c460-4c4f-81eb-2bf5abff1a69"],
Cell[104415, 2394, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"35e8b815-ba14-4b6b-b636-716395b7caec"],
Cell[105147, 2415, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"4d84ddf3-a510-41f4-bd85-6a68a546b795"],
Cell[106757, 2460, 78, 0, 70, "FooterCell",ExpressionUUID->"89bf2d72-4e99-45cb-8c85-b572871b0272"]
}
]
*)

(* End of internal cache information *)

