(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    109299,       2405]
NotebookOptionsPosition[    101537,       2252]
NotebookOutlinePosition[    104223,       2316]
CellTagsIndexPosition[    104099,       2310]
WindowTitle->CoefDilatationThermiqueNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "e5ef88b2-9db2-4f56-9bb4-eea8b6840c5d"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "2180999e-793a-46b4-b4b3-70ae5b040519"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c4c939a2-4916-4452-983b-18b3c10cba58"]
         }],ExpressionUUID->"a3058fe2-10dd-42cf-86a8-c683f615000c"],
         StripOnInput->False],{
        "\"CoefExpansionAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefExpansionAdimNv"], 
         "\"CoefJouleThomsonAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv"], "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1115ed3e-1c12-4642-8f0d-af882a537216"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c391baad-6ce8-4f81-9fab-8179b78e9a17"]
         }],ExpressionUUID->"4ae4fb2d-a55c-4407-8e05-0cede2823a72"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "b5364e59-c315-431c-8015-9feb30f5fa62"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "486f6106-dabf-4a38-a052-d6f5e1fe4f8d"]
         }],ExpressionUUID->"55de1c95-ba50-46d9-b690-4fbbc6defd07"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CoefDilatationThermiqueNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CoefDilatationThermiqueNv"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CoefDilatationThermiqueNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$7820], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CoefDilatationThermiqueNv" <> ".html"], 
              None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d0b8108e-8eed-4662-880c-e00c00b8d4f1"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "ecc9283d-c27b-42b1-a82e-cec9abbd2159"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"c45e72c7-f516-4bda-961d-c5966bff5590"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"0556895d-718d-42dd-8194-78379c948cc9"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CoefDilatationThermiqueNv", "ObjectName",ExpressionUUID->
      "a184fb7f-7eac-4591-bccb-84cc7bdd5ec9"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"93eb9de6-1563-4923-b849-2a9a4046bf07"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "9535509b-6b16-465d-931b-03a107218fdf"]
    }],ExpressionUUID->"17c7cd60-7802-4f35-a900-7599dc43d4f9"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"00e9c574-cc56-4bbf-9508-\
d2dde8142954"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CoefDilatationThermiqueNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] \[Beta] = ",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        StyleBox["V",
         FontSlant->"Italic"]], 
       SubscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"\[PartialD]", 
           StyleBox["V",
            FontSlant->"Italic"]}], 
          RowBox[{"\[PartialD]", 
           StyleBox["T",
            FontSlant->"Italic"]}]], ")"}], 
        StyleBox["P",
         FontSlant->"Italic"]]}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "7387071e-a4bd-423c-948d-46304bfa3d7c"],
     " (",
     Cell[BoxData[
      SuperscriptBox["Kelvin", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "023c8849-0a77-4d00-bd62-1e89b8f8c3d1"],
     ")\nCoefficient de dilatation thermique isobare en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a79275c0-c8e0-4e86-9d0d-7c91a8cfd315"],
     ")\n[Isobaric thermal expansion coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c9652a83-0a30-4717-bde2-d712aa414074"],
     ")]"
    }],ExpressionUUID->"35fa87fc-5cfa-489e-9313-d3b67b0e8491"]}
  }]], "Usage",ExpressionUUID->"ec7c13be-3e6b-4c34-9c2a-e0a4b0cd5e27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"d9757d15-190c-421e-b0ea-5d7c247afe2c"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"961ff0ee-c242-4c65-88a7-578c00bab06b"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"20424b36-3265-4528-8210-a18eb9e9a660"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"bac8bab5-f706-47a3-a954-594cebacaf49"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->5437725,ExpressionUUID->"70fa6307-dbf0-458f-9208-1a7603ac48a3"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0dbe8425-284e-4d0b-933e-99c4b93f29d5"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"8bb20412-f7e4-48f0-ad13-8fa440879393"],

Cell[TextData[{
 "La fonction \[Beta](",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: \[Beta] = ",
 Cell[BoxData[
  SqrtBox[
   RowBox[{
    FractionBox[
     StyleBox[
      SubscriptBox["K", "T"],
      FontSlant->"Italic"], 
     StyleBox["TV",
      FontSlant->"Italic"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox[
       SubscriptBox["C", "P"],
       FontSlant->"Italic"], "-", 
      StyleBox[
       SubscriptBox["C", "V"],
       FontSlant->"Italic"]}], ")"}]}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "dab43e20-4dd3-4fa5-82ec-8c110a2e5cc2"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"205a477a-8248-49aa-9eb9-7013a8a57d07"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"c7c24c5e-c394-4487-81f8-d397fde53db8"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ba2ae9a7-7c88-4d38-b164-21c540c1012a"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"2b6f2c38-835f-4fc9-b1ea-68c5212d8533"],

Cell[TextData[{
 "The function \[Beta](",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) is determined here from the following relationship: \[Beta] = ",
 Cell[BoxData[
  SqrtBox[
   RowBox[{
    FractionBox[
     StyleBox[
      SubscriptBox["K", "T"],
      FontSlant->"Italic"], 
     StyleBox["TV",
      FontSlant->"Italic"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox[
       SubscriptBox["C", "P"],
       FontSlant->"Italic"], "-", 
      StyleBox[
       SubscriptBox["C", "V"],
       FontSlant->"Italic"]}], ")"}]}]]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "bffeb61f-dc55-4682-95f2-d1d64a2539a8"]
}], "Notes",
 CellID->508850368,ExpressionUUID->"8282aaa8-6e4d-4670-9f84-f207f7cda408"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b8af095d-763c-49b5-a01b-4999a79b3c93"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6673a2fd-417f-4394-bf60-c6ff02f24c78"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "a3dfb967-2136-4ece-b92b-c55c926b502a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->442703945,ExpressionUUID->"86e45a2c-625b-4e03-9632-804a738da814"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f53ab3e4-b938-439f-82ba-f17f647c6b0f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c4dcc050-5d57-4351-b818-82820a3a9a32"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e60dcf73-049d-4a52-a05f-68cdd9b503b0"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->860047366,ExpressionUUID->"dc000b9e-21fd-4a85-ac50-3830ba703111"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"75bdbb3c-f8ab-4f32-9415-080d61c2623a"],

Cell["Calculated value of \[Beta] for atmospheric pressure and 20\[Degree]C", \
"ExampleText",
 CellID->544149791,ExpressionUUID->"34f941b6-6991-42ff-b32d-2156eb31523d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"CoefDilatationThermiqueNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", "\"\<Kelvins\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"ecda1c79-c26e-44cc-99b7-906e3c2ad4e1"],

Cell[BoxData[
 TemplateBox[{"0.003421961204049251`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"K\""}], "reciprocal kelvins", 
   FractionBox["1", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->648272765,ExpressionUUID->"8054f268-0f84-470e-8662-67ff9d05e958"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"10ed33a1-0f5d-4d86-a093-1315feab4d44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThermodynamicData", "[", 
  RowBox[{"\"\<Argon\>\"", ",", "\"\<VolumeExpansivity\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
     RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375583457,ExpressionUUID->"27cefc9e-5b54-463e-b9cb-ab28f0d36424"],

Cell[BoxData[
 TemplateBox[{"0.003422386767986197`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"K\""}], "reciprocal kelvins", 
   FractionBox["1", "\"Kelvins\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->165890469,ExpressionUUID->"71fc50a3-fb68-4277-803c-477f3292ada9"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"1cbd5097-65b5-4fea-b090-af7b145df175"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c3969bdb-0d78-4d82-b8f8-56e9bc1eabf8"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "89a0b2c1-2e85-444c-b8fc-a4b6b534e5a2"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"1bac8f6d-660e-456d-9446-1ee725576b51"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"52fbe76d-38c7-4ac8-98f7-223278cac568"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"9b5f0d40-12b9-432d-9697-02beef6a71f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "14.62"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "11.15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "6.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "3.98"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "3.16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "2.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "2.39"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "2.17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "1.86"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "1.75"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "1.66"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "1.57"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "1.44"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "1.38"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "1.33"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "3"], " ", 
     RowBox[{"K", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"22bf6324-fd45-45b9-ba1e-e2f5c0dd8473"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"CoefDilatationThermiqueNv", "[", 
          RowBox[{"150", ",", 
           RowBox[{"RhoArgonNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{
              RowBox[{"dataStreett150", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
            "]"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "3"], " ", 
     RowBox[{"K", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Beta]", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"data150", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"6d454ed9-2006-4ba1-a978-ba8706b14738"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                    5.856829481474033}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.1922064891285675`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                    5.856829481474033}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.1922064891285675`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                   5.856829481474033}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 1.1922064891285675`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 1.1922064891285675`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 1.1922064891285649`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {1.1922064891285649`, 
               5.856829481474033}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                    5.856829481474033}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.1922064891285675`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                    5.856829481474033}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.1922064891285675`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+M5kOr0kbkDstyS1ZG0XQOAueggb
KnFAfGgeTrnPFUB9Xo2UAl50QItpJROiVhNA+pAUtTJbd0Bi9w+zygcRQBoQ
7QFzmHpA7Iy1rIKhDkBaVYPAk8Z9QJQdDaua2gxAvc7Gif5egECygviERTIL
QB6ZdEm7+oFAPaephiRmCUDvZFxTHHuDQLypxEWDGQhA0RMjlu3zhEAjFmR3
mjcHQARpEu/GjIZA6UhejH1CBkCnvzuSRAqIQH9IuH3HXQVAm7yNS8qniUBB
LsciPosEQKCcvj3APYtAyD42z0vyA0AUfil6WriMQLpQYCWoYwNA2gW9zPxS
jkBkqQUV88gCQBCPimlD0o9ALUtdiJ9JAkBLX0AOybiQQB9CsYui3QFAlugq
hKiEkUDSyEzmnHMBQJlyMh/aQpJA3D6wW7QQAUDFT07FDxGTQHeIj4kMsABA
qS2HkJfRk0BqR6TfDmUAQBV9L3hXjpRAFo00NIobAECqH+xqG1uVQJnQmx+R
l/8/9sLFgjEalkBwIKAB5gr/P2u5s6VL6ZZAsfQc27SG/j9oIRHlnbSXQJjm
xYDtBP4/HYqLSUJymEBiCtdc4Yv9P/tFGrnqP5lAQ40E1YMM/T+RAsZN5f+Z
QOp+9V20nfw/rzDh/he8mkCth4+REzH8P/axELtOiJtA/vZkODS7+z/1M12c
10acQI47swkRTvs/HAm+iGQVnUCHw8YiT9v6P/veO5pD1p1Am7eK1CZw+j9i
JinIWpOeQAJ7NkYYB/o/8sAqAXZgn0CqcY+hw5X5Px2upK/xD6BAHmBxbRcv
+T9WJT5kqnegQL20ribUv/g/U1UPJ3/doECo4l8BmFL4P6wFb/x8PKFApUwu
rbXt9z+Z31jXfKOhQIrIuKuVh/c/4jnRxKUDokB5BGe6PSj3P+9MgcDqYaJA
Q/Man8XK9j+RibvBMciiQNw3jW1pZvY/j0aE1aEno0B/QcpIABT2PyEt1+4T
j6NAgDB78ay69T93zGEWovSjQBgXOn37YvU/Kex6UFlTpEBsrWjCshH1P281
HpASuqRAFaI/s23I9D8R/0/i9BmlQJ49w4YJhPQ/SPILOtmBpUDz39Ah7zn0
P0Oe/5/Z56VAPw9qWVDy8z+ayoEYA0emQL+ONrUwvPM/hSCOli6upkDni60c
g4HzP8z2KCeDDqdALAUzXLlK8z8JV4P5/2+nQLwtjhxHE/M/ap6sBw==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {1.1922064891285649`, 
                   5.856829481474033}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 1.1922064891285675`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 1.1922064891285675`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 1.1922064891285649`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {1.1922064891285649`, 
               5.856829481474033}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["1", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {17}, {2}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   200., 400., 600., 800., 1000., 1200., 1400., 1600., 1800., 2000., 2200., 
   2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17}, {15.373061506705282`, 11.701054496278491`, 
    6.353276043197557, 3.940301581780937, 3.0672310875031132`, 
    2.59885646830853, 2.3045188299818014`, 2.101378213298986, 
    1.949229236502821, 1.8245624688928401`, 1.7118278607446742`, 
    1.6033141438052458`, 1.4985575883875981`, 1.401730389363692, 
    1.3174040381527068`, 1.2477486877644308`, 1.1922064753842208`}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->555808719,ExpressionUUID->"80907896-10a1-4d8b-8002-0026df329d43"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "20"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"\[Beta]\",FontSlant->\"Italic\"]\) \
(\!\(\*SuperscriptBox[\(10\), \(3\)]\) \!\(\*SuperscriptBox[\(K\), \(-1\)]\))\
\>\"", ",", "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CoefDilatationThermiqueNv[\!\(\*StyleBox[\"T\",FontSlant->\
\"Italic\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"3cad380d-b70f-48b7-883e-1b6c9f7da002"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U+IHdeDH3rlxUlERr9Jz6AMXnihMCLzg3gYw/TCAZPogWD8QAuR50cc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    "], {{0, 336.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 336.},
  PlotRange->{{0, 450.}, {0, 336.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->424180555,ExpressionUUID->"134cf086-1247-49f7-ae43-c91c89b8d6f2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"15beba61-be9f-4425-888e-4756f0c649cb"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c84d4ee0-6434-442c-9d6f-f766ecb9a285"],
 "Possible Issues",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "16bad2c9-7e5e-4d62-8a6b-0c52b0d690e1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1305812373,ExpressionUUID->"9883a4c4-73ed-41f6-9148-e9e420f8d936"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->768708256,ExpressionUUID->"0a1cf547-e32b-43c9-86f7-4f0562c4ecc4"],

Cell["\<\
Corresponding properties of the Joule-Thomson inversion curve\
\>", "ExampleText",
 CellID->109328850,ExpressionUUID->"42be817c-56ff-4f8d-b23d-3bdca8fd3f0d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"\[Rho]", ",", "P"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataPT\[Rho]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]JT", "=", "\[Rho]trliq"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"T", "=", 
    RowBox[{"0.807", "*", "tc"}]}], ";"}],
  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s", "=", "0"}], ",", 
       RowBox[{"e", "=", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "@", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"CoefDilatationThermiqueNv", "[", 
              RowBox[{"T", ",", "\[Rho]"}], "]"}], "*", "T"}], "-", "1"}], 
           "\[Equal]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Rho]", ",", "1", ",", "\[Rho]trliq"}], "}"}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"s", "++"}]}], ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
       RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
       RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]JT", "=", 
   RowBox[{"\[Rho]", "/.", 
    RowBox[{"First", "@", "sol"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", 
    RowBox[{"PArgonNv", "[", 
     RowBox[{"T", ",", "\[Rho]JT"}], "]"}]}], ";"}], 
  RowBox[{"(*", "bar", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]JT", ">", "0"}], "&&", 
      RowBox[{"\[Rho]JT", "<", "2"}]}], ",", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"DataPT\[Rho]", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"P", "/", "pc"}], ",", 
         RowBox[{"T", "/", "tc"}], ",", 
         RowBox[{"\[Rho]JT", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "7"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"2", "i"}], "5"]}], ")"}], 
        FractionBox["tc", "1.4"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "=", "0"}], ",", 
           RowBox[{"e", "=", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CoefDilatationThermiqueNv", "[", 
                  RowBox[{"T", ",", "\[Rho]"}], "]"}], "*", "T"}], "-", "1"}],
                "\[Equal]", "0"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "1", ",", "\[Rho]trliq"}], "}"}], ",", 
              RowBox[{"StepMonitor", "\[RuleDelayed]", 
               RowBox[{"s", "++"}]}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
           RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
           RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]JT", "=", 
       RowBox[{"\[Rho]", "/.", 
        RowBox[{"First", "@", "sol"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"PArgonNv", "[", 
        RowBox[{"T", ",", "\[Rho]JT"}], "]"}]}], ";", 
      RowBox[{"(*", "bar", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]JT", ">", "0"}], "&&", 
         RowBox[{"\[Rho]JT", "<", "2"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"DataPT\[Rho]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"P", "/", "pc"}], ",", 
            RowBox[{"T", "/", "tc"}], ",", 
            RowBox[{"\[Rho]JT", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "8"}], ",", 
     RowBox[{"i", "\[LessEqual]", "15"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"T", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"2", "i"}], "5"]}], ")"}], 
        FractionBox["tc", "1.4"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "=", "0"}], ",", 
           RowBox[{"e", "=", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "@", 
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CoefDilatationThermiqueNv", "[", 
                  RowBox[{"T", ",", "\[Rho]"}], "]"}], "*", "T"}], "-", "1"}],
                "\[Equal]", "0"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Rho]", ",", "0.4", ",", "1"}], "}"}], ",", 
              RowBox[{"MaxIterations", "\[Rule]", "200"}], ",", 
              RowBox[{"StepMonitor", "\[RuleDelayed]", 
               RowBox[{"s", "++"}]}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}]}], ",", 
           RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
           RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]JT", "=", 
       RowBox[{"\[Rho]", "/.", 
        RowBox[{"First", "@", "sol"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"PArgonNv", "[", 
        RowBox[{"T", ",", "\[Rho]JT"}], "]"}]}], ";", 
      RowBox[{"(*", "bar", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]JT", ">", "0"}], "&&", 
         RowBox[{"\[Rho]JT", "<", "2"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"DataPT\[Rho]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"P", "/", "pc"}], ",", 
            RowBox[{"T", "/", "tc"}], ",", 
            RowBox[{"\[Rho]JT", "/", "\[Rho]c"}]}], "}"}]}], "]"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<In the following table, \!\(\*SubscriptBox[StyleBox[\"P\",FontSlant->\
\"Italic\"], \"c\"]\), \!\(\*StyleBox[SubscriptBox[\"T\", \
\"c\"],FontSlant->\"Italic\"]\) and \
\!\(\*SubscriptBox[StyleBox[\"\[Rho]\",FontSlant->\"Italic\"], \"c\"]\) are \
the values given by NIST\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"DataPT\[Rho]", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<P/\!\(\*SubscriptBox[\(P\), \(c\)]\)\>\"", ",", 
        "\"\<T/\!\(\*SubscriptBox[\(T\), \(c\)]\)\>\"", ",", 
        "\"\<\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->679652919,ExpressionUUID->"755a3d1a-965e-4b49-befa-68328ae0c887"],

Cell[BoxData["\<\"In the following table, \
\\!\\(\\*SubscriptBox[StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\), \\!\\(\\*StyleBox[SubscriptBox[\\\"T\\\", \
\\\"c\\\"],FontSlant->\\\"Italic\\\"]\\) and \
\\!\\(\\*SubscriptBox[StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"], \
\\\"c\\\"]\\) are the values given by NIST\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[75]:=",
 CellID->285024237,ExpressionUUID->"cfcfb592-0d72-4f7d-bc38-d1d1cf372834"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"P/\\!\\(\\*SubscriptBox[\\(P\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"T/\\!\\(\\*SubscriptBox[\\(T\\), \\(c\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\[Rho]/\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(c\\)]\\)\"\>",
       HoldForm]},
     {"0.28676270462885395`", "0.807`", "2.148775054059202`"},
     {"3.9846100588600004`", "1.`", "2.00076609084995`"},
     {"7.5791532069919`", "1.2857142857142858`", "1.7964014166540054`"},
     {"9.73034715596151`", "1.5714285714285718`", "1.6102650621989392`"},
     {"10.985349825628626`", "1.8571428571428574`", "1.4426111992360153`"},
     {"11.598628409740003`", "2.1428571428571432`", "1.2883873036076994`"},
     {"11.671628959902568`", "2.4285714285714284`", "1.1410357079598175`"},
     {"11.261153434477198`", "2.7142857142857144`", "0.9959439076435178`"},
     {"10.451237099532404`", "3.0000000000000004`", "0.8525991434567113`"},
     {"9.376098439833967`", "3.285714285714286`", "0.7146726867823002`"},
     {"8.171886126619935`", "3.5714285714285716`", "0.586623753327605`"},
     {"6.915095230353576`", "3.8571428571428577`", "0.46995485264742826`"},
     {"5.60799404086019`", "4.142857142857143`", "0.3624029254363555`"},
     {"4.180794891703065`", "4.42857142857143`", "0.25816690592934705`"},
     {"2.408669879287609`", "4.714285714285714`", "0.14322423336700785`"},
     {"0.26274789236078255`", "5.`", "0.015164127520956415`"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"P/\!\(\*SubscriptBox[\(P\), \(c\)]\)", 
       "T/\!\(\*SubscriptBox[\(T\), \(c\)]\)", 
       "\[Rho]/\!\(\*SubscriptBox[\(\[Rho]\), \(c\)]\)"}}]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->11308057,ExpressionUUID->"abc3dc5b-3070-478d-afb5-929bb7d2c87e"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CoefExpansionAdimNv"]], 
           "paclet:NewEoSArgon/ref/CoefExpansionAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "46cc25d5-8168-4ec6-b019-9855cd7bc34c"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CoefJouleThomsonAdimNv"]], 
           "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ed1ab4e8-a5cf-4925-b9f9-b12dcea06abd"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c98fd309-caa2-47d5-8d72-466f20ad8e6b"]
       }], "SeeAlso",ExpressionUUID->"388b3616-46ce-4a8a-bb06-63d1349cc87c"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"cd2568f7-e6f2-4f8d-aafb-\
4c8f0c23046c"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "1d07de5c-01e1-495a-96d8-84aaa5b439c0"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ed9d744d-1409-4f72-9d83-\
6e33647e8d09"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "854a35d8-744f-4232-886e-e88b81c12de9"]], "RelatedLinks",
        ExpressionUUID->"3cff9290-344f-4239-bea9-84b8d0d2d16e"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "2c6c986c-48cf-4c60-8b59-a4fede0490da"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a0374c23-6585-43c9-a1a8-1977adebba72"]], "RelatedLinks",
        ExpressionUUID->"0c9daea6-3746-4283-8968-9271d28900c5"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"21746393-0eec-446b-a98d-\
10635362c690"],

Cell[" ", "FooterCell",ExpressionUUID->"79ae5ba6-81df-4f2c-b0e2-a294f0a5ff25"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefDilatationThermiqueNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed, "3" -> Closed}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 21.2029044}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CoefDilatationThermiqueNv[T, \\[Rho]] \\[Congruent] \\[Beta] = 1/V \
(\\[PartialD]V/\\[PartialD]T) P (Kelvin -1) Coefficient de dilatation \
thermique isobare en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) [Isobaric \
thermal expansion coefficient versus T (Kelvin) and \\[Rho] (g/cm^3)]", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CoefDilatationThermiqueNv", "titlemodifier" -> "", "metadescription" -> 
    "", "windowtitle" -> "CoefDilatationThermiqueNv", "type" -> "Symbol", 
    "uri" -> "NewEoSArgon/ref/CoefDilatationThermiqueNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"d336cf8c-8e75-4ffb-a7a5-0a59def7ea7e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13375, 381, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"86e45a2c-625b-4e03-9632-804a738da814",
   CellTags->"PrimaryExamplesSection",
   CellID->442703945]},
 "RasterizedOutput"->{
  Cell[55378, 1311, 28789, 478, 357, "Output",ExpressionUUID->"134cf086-1247-49f7-ae43-c91c89b8d6f2",
   CellTags->"RasterizedOutput",
   CellID->424180555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 103717, 2299},
 {"RasterizedOutput", 103917, 2303}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[597, 21, 5551, 134, 56, "AnchorBarGrid",ExpressionUUID->"c45e72c7-f516-4bda-961d-c5966bff5590",
 CellID->1],
Cell[6151, 157, 94, 0, 23, "ContextNameCell",ExpressionUUID->"0556895d-718d-42dd-8194-78379c948cc9"],
Cell[CellGroupData[{
Cell[6270, 161, 568, 14, 56, "ObjectNameGrid",ExpressionUUID->"00e9c574-cc56-4bbf-9508-d2dde8142954"],
Cell[6841, 177, 1708, 48, 150, "Usage",ExpressionUUID->"ec7c13be-3e6b-4c34-9c2a-e0a4b0cd5e27"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8586, 230, 1917, 48, 37, "NotesSection",ExpressionUUID->"70fa6307-dbf0-458f-9208-1a7603ac48a3",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->5437725],
Cell[10506, 280, 529, 16, 38, "Notes",ExpressionUUID->"8bb20412-f7e4-48f0-ad13-8fa440879393",
 CellID->1067943069],
Cell[11038, 298, 761, 26, 46, "Notes",ExpressionUUID->"205a477a-8248-49aa-9eb9-7013a8a57d07",
 CellID->524000197],
Cell[11802, 326, 186, 4, 36, "Notes",ExpressionUUID->"c7c24c5e-c394-4487-81f8-d397fde53db8",
 CellID->224665577],
Cell[11991, 332, 519, 16, 38, "Notes",ExpressionUUID->"2b6f2c38-835f-4fc9-b1ea-68c5212d8533",
 CellID->51803587],
Cell[12513, 350, 735, 25, 46, "Notes",ExpressionUUID->"8282aaa8-6e4d-4670-9f84-f207f7cda408",
 CellID->508850368]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[13375, 381, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"86e45a2c-625b-4e03-9632-804a738da814",
 CellTags->"PrimaryExamplesSection",
 CellID->442703945],
Cell[CellGroupData[{
Cell[14820, 422, 1398, 36, 30, "ExampleSection",ExpressionUUID->"dc000b9e-21fd-4a85-ac50-3830ba703111",
 CellID->860047366],
Cell[16221, 460, 268, 5, 42, "Input",ExpressionUUID->"75bdbb3c-f8ab-4f32-9415-080d61c2623a",
 CellID->143015886],
Cell[16492, 467, 169, 2, 38, "ExampleText",ExpressionUUID->"34f941b6-6991-42ff-b32d-2156eb31523d",
 CellID->544149791],
Cell[CellGroupData[{
Cell[16686, 473, 1042, 25, 42, "Input",ExpressionUUID->"ecda1c79-c26e-44cc-99b7-906e3c2ad4e1",
 CellID->254692277],
Cell[17731, 500, 289, 6, 40, "Output",ExpressionUUID->"8054f268-0f84-470e-8662-67ff9d05e958",
 CellID->648272765]
}, Open  ]],
Cell[18035, 509, 154, 1, 38, "ExampleText",ExpressionUUID->"10ed33a1-0f5d-4d86-a093-1315feab4d44",
 CellID->361149294],
Cell[CellGroupData[{
Cell[18214, 514, 557, 13, 42, "Input",ExpressionUUID->"27cefc9e-5b54-463e-b9cb-ab28f0d36424",
 CellID->375583457],
Cell[18774, 529, 289, 6, 40, "Output",ExpressionUUID->"71fc50a3-fb68-4277-803c-477f3292ada9",
 CellID->165890469]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[19212, 543, 1419, 37, 30, "ExampleSection",ExpressionUUID->"1bac8f6d-660e-456d-9446-1ee725576b51",
 CellID->258228157],
Cell[20634, 582, 175, 3, 70, "Input",ExpressionUUID->"52fbe76d-38c7-4ac8-98f7-223278cac568",
 CellID->279378555],
Cell[20812, 587, 201, 4, 70, "ExampleText",ExpressionUUID->"9b5f0d40-12b9-432d-9697-02beef6a71f4",
 CellID->227520913],
Cell[21016, 593, 1576, 47, 70, "Input",ExpressionUUID->"22bf6324-fd45-45b9-ba1e-e2f5c0dd8473",
 CellID->243734080],
Cell[CellGroupData[{
Cell[22617, 644, 1261, 36, 70, "Input",ExpressionUUID->"6d454ed9-2006-4ba1-a978-ba8706b14738",
 CellID->123312038],
Cell[23881, 682, 29332, 565, 70, "Output",ExpressionUUID->"80907896-10a1-4d8b-8002-0026df329d43",
 CellID->555808719]
}, Open  ]],
Cell[CellGroupData[{
Cell[53250, 1252, 2125, 57, 70, "Input",ExpressionUUID->"3cad380d-b70f-48b7-883e-1b6c9f7da002",
 CellID->283061935],
Cell[55378, 1311, 28789, 478, 357, "Output",ExpressionUUID->"134cf086-1247-49f7-ae43-c91c89b8d6f2",
 CellTags->"RasterizedOutput",
 CellID->424180555]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[84316, 1797, 1423, 37, 24, "ExampleSection",ExpressionUUID->"9883a4c4-73ed-41f6-9148-e9e420f8d936",
 CellID->1305812373],
Cell[85742, 1836, 175, 3, 70, "Input",ExpressionUUID->"0a1cf547-e32b-43c9-86f7-4f0562c4ecc4",
 CellID->768708256],
Cell[85920, 1841, 167, 3, 70, "ExampleText",ExpressionUUID->"42be817c-56ff-4f8d-b23d-3bdca8fd3f0d",
 CellID->109328850],
Cell[CellGroupData[{
Cell[86112, 1848, 7996, 216, 70, "Input",ExpressionUUID->"755a3d1a-965e-4b49-befa-68328ae0c887",
 CellID->679652919],
Cell[94111, 2066, 503, 7, 70, "Print",ExpressionUUID->"cfcfb592-0d72-4f7d-bc38-d1d1cf372834",
 CellID->285024237],
Cell[94617, 2075, 2291, 46, 295, "Output",ExpressionUUID->"abc3dc5b-3070-478d-afb5-929bb7d2c87e",
 CellID->11308057]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[97150, 2130, 1960, 52, 114, "SeeAlsoSection",ExpressionUUID->"cd2568f7-e6f2-4f8d-aafb-4c8f0c23046c"],
Cell[99113, 2184, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"ed9d744d-1409-4f72-9d83-6e33647e8d09"],
Cell[99845, 2205, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"21746393-0eec-446b-a98d-10635362c690"],
Cell[101455, 2250, 78, 0, 70, "FooterCell",ExpressionUUID->"79ae5ba6-81df-4f2c-b0e2-a294f0a5ff25"]
}
]
*)

(* End of internal cache information *)

