(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     71654,       1578]
NotebookOptionsPosition[     65137,       1447]
NotebookOutlinePosition[     67814,       1511]
CellTagsIndexPosition[     67692,       1505]
WindowTitle->CoefExpansionAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "f25c9ce9-4fc7-46f2-a872-9c86e30f8d0d"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "0bdfeb3e-7a70-485a-9438-6dd4038433d9"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "fefa3925-e654-452d-b3c8-a90f67f8f42f"]
         }],ExpressionUUID->"fbcdf9b8-6bae-407a-9b17-2f28bbb4a1f3"],
         StripOnInput->False],{
        "\"CoefJouleThomsonAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv"], 
         "\"HtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/HtotalAdimNv"], 
         "\"CoefDilatationThermiqueNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefDilatationThermiqueNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "97644797-3aba-4db4-8b6a-bc2b66d0a192"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "484008b5-61da-4fda-94f4-f47f688e6fb1"]
         }],ExpressionUUID->"dda6d5fd-237c-4e9e-9ac3-fa09215c48b4"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8b3ffd0c-69d1-4fc9-8dbb-62cda1458eca"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "74a4d60f-b8ae-4f9e-bf34-96772f947f3a"]
         }],ExpressionUUID->"57638dba-465d-40c3-85e1-c2d6e0591956"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CoefExpansionAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CoefExpansionAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CoefExpansionAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$8338], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CoefExpansionAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "20f7a46c-2cb2-4543-b3cc-2b6102556bb1"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "e6c86549-c8ef-479f-8dc8-33a5b7b99abe"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"fa45fa7e-a3b0-4664-aa3b-84e5e536cc3c"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"3d0597b4-dea4-48fb-895b-ec690daacfa3"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CoefExpansionAdimNv", "ObjectName",ExpressionUUID->
      "0a31a7f4-ab3f-4c33-b8da-fb59d0824d2a"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"39d6a3fe-6769-4c6c-af04-e47ad6da81e1"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "1953f3db-3871-4709-8f81-df75b519620d"]
    }],ExpressionUUID->"ab44a7f0-74a8-4ace-8f78-ad7a53b9ab1c"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"09f8c586-556e-4e2b-87af-\
2cefce521186"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CoefExpansionAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox["\[Delta]", "T"], "\[Rho]"}]],ExpressionUUID->
      "ab40b207-395b-4dc6-ae38-2c804039d0d7"],
     "  with  ",
     Cell[BoxData[
      SubscriptBox["\[Delta]", "T"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "270db7dd-e3c2-4512-a6f6-d1afd612e147"],
     " = ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["H",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["P",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["T",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1cdd660a-f9d5-4df5-8189-1fc46a22090b"],
     " = ",
     StyleBox["V",
      FontSlant->"Italic"],
     "(1-",
     StyleBox["T",
      FontSlant->"Italic"],
     "\[Beta])\nCoefficient d'expansion isotherme adimensionnel en fonction \
de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a34626bb-ab9d-4c8f-a190-6b7d9e9407bf"],
     ") \n[Non-dimensionnal isothermal throttling coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0173b293-64e4-498d-8c12-8e99bbeb67d1"],
     ")]"
    }],ExpressionUUID->"9173f2e3-3153-4b0d-9867-a3aa2fb5a326"]}
  }]], "Usage",ExpressionUUID->"8c77dbf1-157d-4ea8-ba52-dbfa156ce478"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"7b6f04ab-e3d6-4092-a4fb-bcd1a504b330"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"cdb32b99-a46e-43eb-bdf8-99cc7ec5c57d"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"b21dc3db-8dc8-45c8-8b09-89a98f19f9ef"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"3462c658-d835-459a-84e1-87c1cd103ddd"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->222987784,ExpressionUUID->"63cd3bd4-f624-40db-b4e3-c8c2ef7d8adb"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0495d18c-082c-4f32-bb7f-40c2b4e59d0d"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"e42b0ed6-711a-45ff-9011-c9312b77dc83"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"142e275a-f5f9-4f94-be41-9b90911abda4"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fd251227-2a90-4fcb-8b9b-13ff5f91cb2d"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"c9997306-a520-456b-a2fb-b42ceebf0635"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"706536c3-1a48-42b7-84ff-cc9cca25664b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f8e723ee-80ac-4739-aff2-a78b66ebd29a"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "4d371057-8130-4ac3-a5c8-5f9d6e65e07c"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->155902303,ExpressionUUID->"b0344cbf-2f59-47ee-882c-6187f6617ed9"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"5a023c80-c15a-4beb-bbfe-be63e7e23b7b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ced5e568-6b42-4061-953f-5022c38f1e47"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "62c78f11-7aaf-4742-a54a-493851559251"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->42913648,ExpressionUUID->"eaf9e07a-469b-4f99-9320-3c2728833e8e"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"f3efdbf6-777b-4dbb-9ab9-b6ac51887364"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", "T"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "60d2ee1a-9842-4179-9d23-1aeff9122328"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"54bc886c-bb61-4f42-96f3-53c2d59bc397"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"CoefExpansionAdimNv", "[", 
     RowBox[{"293.15", ",", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"N", "@", 
          RowBox[{"UnitConvert", "[", 
           RowBox[{
            TemplateBox[{"1"},
             "QuantityUnit",
             DisplayFunction->(TooltipBox[
               StyleBox[
                RowBox[{#, "\[InvisibleSpace]", 
                  StyleBox[
                   RowBox[{" ", "\"atm\""}], 
                   "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                False], "Unit: atmospheres"]& ),
             InterpretationFunction->(RowBox[{"Quantity", "[", 
                RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
            "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
    "*", 
    RowBox[{
     RowBox[{"Quantity", "[", 
      RowBox[{"M", ",", 
       RowBox[{"\"\<Grams\>\"", "/", "\"\<Moles\>\""}]}], "]"}], "/", 
     RowBox[{"Quantity", "[", 
      RowBox[{
       RowBox[{"RhoArgonNv", "[", 
        RowBox[{"293.15", ",", 
         RowBox[{"QuantityMagnitude", "@", 
          RowBox[{"N", "@", 
           RowBox[{"UnitConvert", "[", 
            RowBox[{
             TemplateBox[{"1"},
              "QuantityUnit",
              DisplayFunction->(TooltipBox[
                StyleBox[
                 RowBox[{#, "\[InvisibleSpace]", 
                   StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                 False], "Unit: atmospheres"]& ),
              InterpretationFunction->(RowBox[{"Quantity", "[", 
                 RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
             "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}], ",", 
       RowBox[{"\"\<Grams\>\"", "/", 
        SuperscriptBox["\"\<Centimeters\>\"", "3"]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"69806bc5-20ef-427a-8fd0-c40546d149c1"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.00007567951891260629`"}], 
   RowBox[{
     SuperscriptBox["\"m\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "meters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->698492393,ExpressionUUID->"8ace21d7-b9c2-4819-a131-34fbe2e40858"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]atm", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    TemplateBox[{
      RowBox[{"-", "0.00007567951891261164`"}]},
     "QuantityUnit",
     DisplayFunction->(TooltipBox[
       StyleBox[
        RowBox[{#, "\[InvisibleSpace]", 
          StyleBox[
           RowBox[{" ", 
             RowBox[{
               SuperscriptBox["\"m\"", "3"], "\[NegativeMediumSpace]", 
               "\"/\"", "\[InvisibleSpace]", "\"mol\""}]}], 
           "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
       "Unit: meters cubed per mole"]& ),
     InterpretationFunction->(RowBox[{"Quantity", "[", 
        RowBox[{#, ",", 
          FractionBox[
           SuperscriptBox["\"Meters\"", "3"], "\"Moles\""]}], "]"}]& )], ",", 
    RowBox[{
     SuperscriptBox["\"\<Decimeters\>\"", "3"], "/", "\"\<Moles\>\""}]}], 
   "]"}]}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->56451896,ExpressionUUID->"e938c8b8-fb23-419f-a97f-c9fba192fa6d"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.07567951891261164`"}], 
   RowBox[{
     SuperscriptBox["\"dm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"mol\""}], "decimeters cubed per mole", 
   FractionBox[
    SuperscriptBox["\"Decimeters\"", "3"], "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->347422189,ExpressionUUID->"9c3e7bfa-4f73-418c-af54-ecc0739ef82f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]atm", "/", 
  RowBox[{"Quantity", "[", 
   RowBox[{"M", ",", 
    RowBox[{"\"\<Grams\>\"", "/", "\"\<Moles\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->87667351,ExpressionUUID->"e34e46ca-4a34-4bec-b77f-885e7955ac7d"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "0.0018944507588017332`"}], 
   RowBox[{
     SuperscriptBox["\"dm\"", "3"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"g\""}], "decimeters cubed per gram", 
   FractionBox[
    SuperscriptBox["\"Decimeters\"", "3"], "\"Grams\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->349369702,ExpressionUUID->"8109c4cd-debc-4989-89d0-d8dc295fd2d2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"31c183f7-2147-4248-9838-197d4573f589"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"1dd76e76-a565-4c99-860f-2e149a4bef88"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "99c50074-f43f-4e18-90bd-138b622e4c31"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"14fd95d0-69f8-497d-9adc-e23a5e7b10b1"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"2ba17fe8-f252-454a-be24-37d8c4797240"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "59824ab7-90c8-4195-8af4-aadcd9f8089a"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"dd87eb96-69fb-44a3-ba36-17c088094db6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"d1f1010c-cf84-4bcf-bb13-a3baf8baad7e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7\[Delta]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"dataNIST", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "9"}], "]"}], "]"}]}], 
        RowBox[{"dataNIST", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "11"}], "]"}], "]"}], "*", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigGaz", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["M", "x"], "*", 
       RowBox[{"CoefExpansionAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "0.3"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"\[Delta]\",FontSlant->\"\
Italic\"], \"T\"],FontSlant->\"Italic\"]\) (\!\(\*SuperscriptBox[\(cm\), \
\(3\)]\)/mol)\>\"", ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigLiq", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["M", "x"], "*", 
       RowBox[{"CoefExpansionAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.7", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"\[Delta]\",FontSlant->\"\
Italic\"], \"T\"],FontSlant->\"Italic\"]\) (\!\(\*SuperscriptBox[\(cm\), \
\(3\)]\)/mol)\>\"", ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FigGaz", ",", "FigLiq"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", "ArT150p7\[Delta]"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CoefExpansionAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"\
Italic\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"9c5c3902-85cf-4a82-8b87-06e766cb77ff"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U9oHN2e2H3NPJo7zr26D57ESRymmdHLeCGIw3jhhXMxGb1gGA3jEJP4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    "], {{0, 329.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 329.},
  PlotRange->{{0, 450.}, {0, 329.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->39382610,ExpressionUUID->"550ff479-c12f-4506-848b-e64bdbd279de"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CoefJouleThomsonAdimNv"]], 
           "paclet:NewEoSArgon/ref/CoefJouleThomsonAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ebbd663a-a4b5-4389-b032-7887415cca37"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c5d9153c-d328-4644-9619-23b115891434"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CoefDilatationThermiqueNv"]], 
           "paclet:NewEoSArgon/ref/CoefDilatationThermiqueNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0a700dd8-a5ab-46dc-a8d2-1331a58e5211"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "56e0cb40-fde6-44a4-b55f-3bdd9ff8d323"]
       }], "SeeAlso",ExpressionUUID->"81739efa-c3ff-449d-b190-5c261a32e6bb"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"309875d6-14cc-44ad-b3cd-\
7f2cac247208"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "2bf2adcb-0e75-45a6-ac7e-0f7ffa457e60"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"91d1f8ef-b949-4eff-a30d-\
c2a7763095ac"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d1b8532b-1727-4a43-9651-3ee30f4a6c81"]], "RelatedLinks",
        ExpressionUUID->"44629e72-78ec-4836-86c0-425ac97b0be3"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "d3396a59-c48d-4b71-a9a1-c7fc012f2238"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "de0c2893-67cf-41b7-a4e3-f49c553fcd1e"]], "RelatedLinks",
        ExpressionUUID->"a3acafda-abe8-4189-be48-23ce0e02f260"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"bc09d690-223d-4db7-bacf-\
22fb64d23990"],

Cell[" ", "FooterCell",ExpressionUUID->"268df43d-614d-41e8-bcc0-93dfaff4b3f8"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefExpansionAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 22.4896980}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CoefExpansionAdimNv[T, \\[Rho]] \\[Congruent] \\[Delta]T \\[Rho] with \
\\[Delta]T = (\\[PartialD]H/\\[PartialD]P) T = V(1-T\\[Beta]) Coefficient \
d'expansion isotherme adimensionnel en fonction de T (Kelvin) et de \\[Rho] \
(g/cm^3) [Non-dimensionnal isothermal throttling coefficient versus T \
(Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CoefExpansionAdimNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "CoefExpansionAdimNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/CoefExpansionAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"9b8f95a2-1221-43c5-924c-0390ab880dac"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12116, 335, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b0344cbf-2f59-47ee-882c-6187f6617ed9",
   CellTags->"PrimaryExamplesSection",
   CellID->155902303]},
 "RasterizedOutput"->{
  Cell[26927, 754, 33042, 548, 350, "Output",ExpressionUUID->"550ff479-c12f-4506-848b-e64bdbd279de",
   CellTags->"RasterizedOutput",
   CellID->39382610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67312, 1494},
 {"RasterizedOutput", 67512, 1498}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 5641, 136, 56, "AnchorBarGrid",ExpressionUUID->"fa45fa7e-a3b0-4664-aa3b-84e5e536cc3c",
 CellID->1],
Cell[6235, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"3d0597b4-dea4-48fb-895b-ec690daacfa3"],
Cell[CellGroupData[{
Cell[6354, 163, 562, 14, 56, "ObjectNameGrid",ExpressionUUID->"09f8c586-556e-4e2b-87af-2cefce521186"],
Cell[6919, 179, 1871, 55, 150, "Usage",ExpressionUUID->"8c77dbf1-157d-4ea8-ba52-dbfa156ce478"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8827, 239, 1919, 48, 37, "NotesSection",ExpressionUUID->"63cd3bd4-f624-40db-b4e3-c8c2ef7d8adb",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->222987784],
Cell[10749, 289, 529, 16, 38, "Notes",ExpressionUUID->"e42b0ed6-711a-45ff-9011-c9312b77dc83",
 CellID->1067943069],
Cell[11281, 307, 186, 4, 36, "Notes",ExpressionUUID->"142e275a-f5f9-4f94-be41-9b90911abda4",
 CellID->224665577],
Cell[11470, 313, 519, 16, 38, "Notes",ExpressionUUID->"c9997306-a520-456b-a2fb-b42ceebf0635",
 CellID->51803587]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12116, 335, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"b0344cbf-2f59-47ee-882c-6187f6617ed9",
 CellTags->"PrimaryExamplesSection",
 CellID->155902303],
Cell[CellGroupData[{
Cell[13561, 376, 1397, 36, 30, "ExampleSection",ExpressionUUID->"eaf9e07a-469b-4f99-9320-3c2728833e8e",
 CellID->42913648],
Cell[14961, 414, 268, 5, 42, "Input",ExpressionUUID->"f3efdbf6-777b-4dbb-9ab9-b6ac51887364",
 CellID->143015886],
Cell[15232, 421, 338, 8, 38, "ExampleText",ExpressionUUID->"54bc886c-bb61-4f42-96f3-53c2d59bc397",
 CellID->544149791],
Cell[CellGroupData[{
Cell[15595, 433, 2163, 53, 78, "Input",ExpressionUUID->"69806bc5-20ef-427a-8fd0-c40546d149c1",
 CellID->5710145],
Cell[17761, 488, 416, 10, 43, "Output",ExpressionUUID->"8ace21d7-b9c2-4819-a131-34fbe2e40858",
 CellID->698492393]
}, Open  ]],
Cell[CellGroupData[{
Cell[18214, 503, 999, 26, 30, "Input",ExpressionUUID->"e938c8b8-fb23-419f-a97f-c9fba192fa6d",
 CellID->56451896],
Cell[19216, 531, 422, 10, 43, "Output",ExpressionUUID->"9c3e7bfa-4f73-418c-af54-ecc0739ef82f",
 CellID->347422189]
}, Open  ]],
Cell[CellGroupData[{
Cell[19675, 546, 264, 6, 26, "Input",ExpressionUUID->"e34e46ca-4a34-4bec-b77f-885e7955ac7d",
 CellID->87667351],
Cell[19942, 554, 422, 10, 45, "Output",ExpressionUUID->"8109c4cd-debc-4989-89d0-d8dc295fd2d2",
 CellID->349369702]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[20513, 572, 1419, 37, 30, "ExampleSection",ExpressionUUID->"14fd95d0-69f8-497d-9adc-e23a5e7b10b1",
 CellID->258228157],
Cell[21935, 611, 174, 3, 26, "Input",ExpressionUUID->"2ba17fe8-f252-454a-be24-37d8c4797240",
 CellID->87419684],
Cell[22112, 616, 401, 11, 70, "ExampleText",ExpressionUUID->"dd87eb96-69fb-44a3-ba36-17c088094db6",
 CellID->227520913],
Cell[22516, 629, 464, 13, 70, "Input",ExpressionUUID->"d1f1010c-cf84-4bcf-bb13-a3baf8baad7e",
 CellID->531122037],
Cell[CellGroupData[{
Cell[23005, 646, 3919, 106, 70, "Input",ExpressionUUID->"9c5c3902-85cf-4a82-8b87-06e766cb77ff",
 CellID->136921489],
Cell[26927, 754, 33042, 548, 350, "Output",ExpressionUUID->"550ff479-c12f-4506-848b-e64bdbd279de",
 CellTags->"RasterizedOutput",
 CellID->39382610]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[60211, 1311, 2499, 66, 114, "SeeAlsoSection",ExpressionUUID->"309875d6-14cc-44ad-b3cd-7f2cac247208"],
Cell[62713, 1379, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"91d1f8ef-b949-4eff-a30d-c2a7763095ac"],
Cell[63445, 1400, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"bc09d690-223d-4db7-bacf-22fb64d23990"],
Cell[65055, 1445, 78, 0, 70, "FooterCell",ExpressionUUID->"268df43d-614d-41e8-bcc0-93dfaff4b3f8"]
}
]
*)

(* End of internal cache information *)

