(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     66844,       1470]
NotebookOptionsPosition[     60450,       1343]
NotebookOutlinePosition[     63145,       1407]
CellTagsIndexPosition[     63023,       1401]
WindowTitle->CoefJouleThomsonAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "1fab9264-f9ac-4104-ba98-c246e1f1ea65"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "c34d1c78-3553-42af-8d41-5789511a2402"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "4c996b40-ef9b-45b4-848a-2b82a37948be"]
         }],ExpressionUUID->"b666b059-57ab-448c-83aa-e64fd20deb54"],
         StripOnInput->False],{
        "\"CoefExpansionAdimNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CoefExpansionAdimNv"], "\"HtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/HtotalAdimNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0456f9bb-52d2-4f04-b7e0-c398b0612981"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "c50bc084-36ad-4a4d-9c6e-c2be75f9ae99"]
         }],ExpressionUUID->"22d3d487-7ff1-41a6-b6a8-9bdce1531443"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d1e0fed6-c914-49e9-904c-4cf46145aa59"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1f80ff4d-6a32-4285-8147-5f8e7df4ded2"]
         }],ExpressionUUID->"f69eec40-bec8-459f-9686-e5c1a18cfe63"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CoefJouleThomsonAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CoefJouleThomsonAdimNv"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CoefJouleThomsonAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$8861], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CoefJouleThomsonAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "77b28dae-8aa8-4e74-89ee-6edb3c42a1d9"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "7c76d795-968b-48ed-8f55-d235e6d2eef2"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"8a1bf611-e8e8-471c-aac7-1a22df8d9af5"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"8b5fdc81-7d32-420f-b959-415d6a9606fa"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CoefJouleThomsonAdimNv", "ObjectName",ExpressionUUID->
      "7e065f3e-c9b1-4739-b0cf-8d20c46b509a"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"f4a3d3d9-8073-4933-90a2-a27c288eaaff"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "26e18949-1f9c-4cea-aa87-2d386d590645"]
    }],ExpressionUUID->"53b92e9e-5ff0-4896-a0ba-f4aecfceb60b"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"32059096-de39-44da-810d-\
6403206c18c1"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CoefJouleThomsonAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] \[Mu] R \[Rho] with \[Mu] = ",
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["T",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["P",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["H",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6356528d-caea-4692-a762-73701d4e3afa"],
     " = -",
     Cell[BoxData[
      FractionBox["1", 
       StyleBox[
        SubscriptBox["C", "P"],
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "79972ab0-c990-4901-a1b0-79baae2cbe56"],
     Cell[BoxData[
      SubscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          StyleBox["H",
           FontSlant->"Italic"]}], 
         RowBox[{"\[PartialD]", 
          StyleBox["P",
           FontSlant->"Italic"]}]], ")"}], 
       StyleBox["T",
        FontSlant->"Italic"]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "fe3995fc-5a50-4038-b83c-a91909863e9b"],
     "\nCoefficient de Joule-Thomson adimensionnel en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "bad6ed81-8a26-469a-99c7-3c21313922dd"],
     ") \n[Non-dimensionnal Joule-Thomson coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5adda132-9db0-4f1f-8333-a4c43662b197"],
     ")]"
    }],ExpressionUUID->"a2864f85-d60e-4f15-8843-15e53d3d5cf5"]}
  }]], "Usage",ExpressionUUID->"c6ed4670-45af-410b-a7e9-4769c8d91c4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"7a76c4d1-ab81-44a9-8b17-9c38c04fb2a3"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"f4685891-56ab-4338-9fcc-3662fda44ac3"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"f481d004-8123-4676-ab5e-9c23b7039f75"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"75c4b132-3f6a-4a94-b896-a2864bd6bef3"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->148844876,ExpressionUUID->"cae88188-2865-46a9-89c2-07a6df8bad19"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "8af5f470-b298-42fc-9af1-a90da7fec82f"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2d60149d-8293-48fc-9604-11f3122340d5"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"95739707-19dc-44c2-adde-db4aab8f685f"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "caf8baf5-8aae-4982-ad10-87c67a26e13a"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"5f972735-8615-4b2e-9573-5d0053c67b48"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"37b1b3df-a064-4419-b85e-e0ed4132c911"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"9c1b9bac-2d2b-4d79-abf3-3cae6c68dc42"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "658af4d9-beb2-4484-aba4-3f2d12ccafcc"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->539645417,ExpressionUUID->"e2951a06-af56-4dbb-bd85-01a5bf8fb730"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"7ea52342-20b0-4814-97ce-4d202ddd5ffe"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"10c7625a-6aa5-4299-8131-5da492c2e33b"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8ddafc24-73f5-4297-a40e-5f29c1847f29"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->692769136,ExpressionUUID->"e7d36410-4c9b-4b81-bc64-6b40446c89d5"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"505f61a5-c427-4bf1-9c65-d26a204349e4"],

Cell["Calculated value of \[Mu] for atmospheric pressure and 20\[Degree]C", \
"ExampleText",
 CellID->544149791,ExpressionUUID->"2cae7a6f-80cc-4a75-8070-bfd73a1db78f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"CoefJouleThomsonAdimNv", "[", 
     RowBox[{"293.15", ",", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"N", "@", 
          RowBox[{"UnitConvert", "[", 
           RowBox[{
            TemplateBox[{"1"},
             "QuantityUnit",
             DisplayFunction->(TooltipBox[
               StyleBox[
                RowBox[{#, "\[InvisibleSpace]", 
                  StyleBox[
                   RowBox[{" ", "\"atm\""}], 
                   "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                False], "Unit: atmospheres"]& ),
             InterpretationFunction->(RowBox[{"Quantity", "[", 
                RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
            "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
    "*", 
    RowBox[{
     RowBox[{"Quantity", "[", 
      RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", 
       RowBox[{"Quantity", "[", 
        RowBox[{
         RowBox[{"RhoArgonNv", "[", 
          RowBox[{"293.15", ",", 
           RowBox[{"QuantityMagnitude", "@", 
            RowBox[{"N", "@", 
             RowBox[{"UnitConvert", "[", 
              RowBox[{
               TemplateBox[{"1"},
                "QuantityUnit",
                DisplayFunction->(TooltipBox[
                  StyleBox[
                   RowBox[{#, "\[InvisibleSpace]", 
                    StyleBox[
                    RowBox[{" ", "\"atm\""}], 
                    "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                   False], "Unit: atmospheres"]& ),
                InterpretationFunction->(RowBox[{"Quantity", "[", 
                   RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
               "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}], ",", 
         "\"\<g/cm^3\>\""}], "]"}]}], ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"6c6c872b-f1cf-47eb-a2e2-9697c8b19685"],

Cell[BoxData[
 TemplateBox[{"3.632188540008119`*^-6", 
   RowBox[{
    "\"K\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"Pa\""}], 
   "kelvins per pascal", 
   FractionBox["\"Kelvins\"", "\"Pascals\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->820443028,ExpressionUUID->"ae74fe45-99ca-44d2-830e-9b4a861bce76"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"86a5b3a9-f42b-429d-a09a-9e4c03164edf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{
    "\"\<Argon\>\"", ",", "\"\<IsenthalpicJouleThomsonCoefficient\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"\"\<Kelvins\>\"", "/", "\"\<Pascals\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375583457,ExpressionUUID->"0f7cb97d-d343-43d9-b3b1-ad6bac47d7a8"],

Cell[BoxData[
 TemplateBox[{"3.77550881209777`*^-6", 
   RowBox[{
    "\"K\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"Pa\""}], 
   "kelvins per pascal", 
   FractionBox["\"Kelvins\"", "\"Pascals\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->651729484,ExpressionUUID->"640f9e11-27e4-4726-9229-b95bfe440183"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"da8b423e-68d1-44de-a8de-6dc5f85450d0"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"30d9ab4a-e20f-4961-885f-c33b14615b0c"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3da0078f-ff55-4358-8f7c-65e1f819e9ec"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"84ae4a23-7d84-4104-912b-211fead37097"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"eacd8b90-bbc7-4606-a189-0cccf12b4aa8"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "cee4175a-177e-4bc9-831d-1db2b95ac728"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"18af7e92-ef4e-4858-a4d3-a1a40f3709c2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"9d7bce80-debe-4882-bd08-308296f0af2c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7\[Mu]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "11"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigGaz", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["M", 
        RowBox[{"x", "*", "RR", "*", "10"}]], "*", 
       RowBox[{"CoefJouleThomsonAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "0.3"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"\[Mu]\",FontSlant->\"Italic\"]\) (K/bar)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigLiq", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["M", 
        RowBox[{"x", "*", "RR", "*", "10"}]], "*", 
       RowBox[{"CoefJouleThomsonAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.7", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"\[Mu]\",FontSlant->\"Italic\"]\) (K/bar)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FigGaz", ",", "FigLiq"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", "ArT150p7\[Mu]"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CoefJouleThomsonAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"\
Italic\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"13b97e41-e139-4410-8155-04a49b4bea36"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U+IXFmW2P/sHlWXyqXuVtMyndMEM/rRZaiFTAtGC9EIW4aClukyFh79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    "], {{0, 340.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 340.},
  PlotRange->{{0, 450.}, {0, 340.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->50399123,ExpressionUUID->"e37854a1-9ce5-4661-b4d1-753f38e76dd0"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CoefExpansionAdimNv"]], 
           "paclet:NewEoSArgon/ref/CoefExpansionAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "df8293e2-e442-48c0-b054-fe4573c6fc25"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e8496879-1079-4c29-8de0-f7a75f2bcdfe"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "cbad2e83-6b32-47ec-af94-d1eedceca9df"]
       }], "SeeAlso",ExpressionUUID->"f5dfe470-16a2-4842-8b36-507e40263161"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"bd0071ce-47a6-45c3-a624-\
96e098a045e4"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "7ecbd20c-f422-48e7-8999-ab5aa554e3be"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ce718072-8fb5-4a60-9065-\
286bc5605d42"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "96bc24bd-88c4-4831-8bc0-fe2234314f91"]], "RelatedLinks",
        ExpressionUUID->"a36dee1d-7ad2-480e-8036-8da5773040b3"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "50bd8afb-7f66-4204-a749-5ce7e9543c98"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "1c92cab1-ac14-4ba9-b62a-629a713626fb"]], "RelatedLinks",
        ExpressionUUID->"a432706a-d31e-4fdd-a5f2-470c33183f49"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"a1870c9b-82b2-426d-b864-\
6d48d1a7ee17"],

Cell[" ", "FooterCell",ExpressionUUID->"a457312b-adc3-49e5-92d7-4eb9b13831cc"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefJouleThomsonAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 23.6227862}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CoefJouleThomsonAdimNv[T, \\[Rho]] \\[Congruent] \\[Mu] R \\[Rho] with \
\\[Mu] = (\\[PartialD]T/\\[PartialD]P) H = -1/CP(\\[PartialD]H/\\[PartialD]P) \
T Coefficient de Joule-Thomson adimensionnel en fonction de T (Kelvin) et de \
\\[Rho] (g/cm^3) [Non-dimensionnal Joule-Thomson coefficient versus T \
(Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CoefJouleThomsonAdimNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "CoefJouleThomsonAdimNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/CoefJouleThomsonAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"49b135c8-431d-47dc-8f47-7a028bea9a89"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12212, 336, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"e2951a06-af56-4dbb-bd85-01a5bf8fb730",
   CellTags->"PrimaryExamplesSection",
   CellID->539645417]},
 "RasterizedOutput"->{
  Cell[25629, 711, 30224, 502, 361, "Output",ExpressionUUID->"e37854a1-9ce5-4661-b4d1-753f38e76dd0",
   CellTags->"RasterizedOutput",
   CellID->50399123]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62643, 1390},
 {"RasterizedOutput", 62843, 1394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[594, 21, 5493, 132, 56, "AnchorBarGrid",ExpressionUUID->"8a1bf611-e8e8-471c-aac7-1a22df8d9af5",
 CellID->1],
Cell[6090, 155, 94, 0, 23, "ContextNameCell",ExpressionUUID->"8b5fdc81-7d32-420f-b959-415d6a9606fa"],
Cell[CellGroupData[{
Cell[6209, 159, 565, 14, 56, "ObjectNameGrid",ExpressionUUID->"32059096-de39-44da-810d-6403206c18c1"],
Cell[6777, 175, 2109, 60, 152, "Usage",ExpressionUUID->"c6ed4670-45af-410b-a7e9-4769c8d91c4d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8923, 240, 1919, 48, 37, "NotesSection",ExpressionUUID->"cae88188-2865-46a9-89c2-07a6df8bad19",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->148844876],
Cell[10845, 290, 529, 16, 38, "Notes",ExpressionUUID->"2d60149d-8293-48fc-9604-11f3122340d5",
 CellID->1067943069],
Cell[11377, 308, 186, 4, 36, "Notes",ExpressionUUID->"95739707-19dc-44c2-adde-db4aab8f685f",
 CellID->224665577],
Cell[11566, 314, 519, 16, 38, "Notes",ExpressionUUID->"5f972735-8615-4b2e-9573-5d0053c67b48",
 CellID->51803587]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12212, 336, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"e2951a06-af56-4dbb-bd85-01a5bf8fb730",
 CellTags->"PrimaryExamplesSection",
 CellID->539645417],
Cell[CellGroupData[{
Cell[13657, 377, 1398, 36, 30, "ExampleSection",ExpressionUUID->"e7d36410-4c9b-4b81-bc64-6b40446c89d5",
 CellID->692769136],
Cell[15058, 415, 268, 5, 42, "Input",ExpressionUUID->"505f61a5-c427-4bf1-9c65-d26a204349e4",
 CellID->143015886],
Cell[15329, 422, 167, 2, 38, "ExampleText",ExpressionUUID->"2cae7a6f-80cc-4a75-8070-bfd73a1db78f",
 CellID->544149791],
Cell[CellGroupData[{
Cell[15521, 428, 2208, 53, 72, "Input",ExpressionUUID->"6c6c872b-f1cf-47eb-a2e2-9697c8b19685",
 CellID->5710145],
Cell[17732, 483, 340, 8, 43, "Output",ExpressionUUID->"ae74fe45-99ca-44d2-830e-9b4a861bce76",
 CellID->820443028]
}, Open  ]],
Cell[18087, 494, 154, 1, 38, "ExampleText",ExpressionUUID->"86a5b3a9-f42b-429d-a09a-9e4c03164edf",
 CellID->361149294],
Cell[CellGroupData[{
Cell[18266, 499, 713, 17, 42, "Input",ExpressionUUID->"0f7cb97d-d343-43d9-b3b1-ad6bac47d7a8",
 CellID->375583457],
Cell[18982, 518, 339, 8, 43, "Output",ExpressionUUID->"640f9e11-27e4-4726-9229-b95bfe440183",
 CellID->651729484]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[19470, 534, 1419, 37, 30, "ExampleSection",ExpressionUUID->"84ae4a23-7d84-4104-912b-211fead37097",
 CellID->258228157],
Cell[20892, 573, 174, 3, 26, "Input",ExpressionUUID->"eacd8b90-bbc7-4606-a189-0cccf12b4aa8",
 CellID->87419684],
Cell[21069, 578, 401, 11, 40, "ExampleText",ExpressionUUID->"18af7e92-ef4e-4858-a4d3-a1a40f3709c2",
 CellID->227520913],
Cell[21473, 591, 464, 13, 70, "Input",ExpressionUUID->"9d7bce80-debe-4882-bd08-308296f0af2c",
 CellID->531122037],
Cell[CellGroupData[{
Cell[21962, 608, 3664, 101, 70, "Input",ExpressionUUID->"13b97e41-e139-4410-8155-04a49b4bea36",
 CellID->136921489],
Cell[25629, 711, 30224, 502, 361, "Output",ExpressionUUID->"e37854a1-9ce5-4661-b4d1-753f38e76dd0",
 CellTags->"RasterizedOutput",
 CellID->50399123]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[56095, 1222, 1928, 51, 114, "SeeAlsoSection",ExpressionUUID->"bd0071ce-47a6-45c3-a624-96e098a045e4"],
Cell[58026, 1275, 729, 19, 114, "MoreAboutSection",ExpressionUUID->"ce718072-8fb5-4a60-9065-286bc5605d42"],
Cell[58758, 1296, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"a1870c9b-82b2-426d-b864-6d48d1a7ee17"],
Cell[60368, 1341, 78, 0, 70, "FooterCell",ExpressionUUID->"a457312b-adc3-49e5-92d7-4eb9b13831cc"]
}
]
*)

(* End of internal cache information *)

