(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    101867,       2217]
NotebookOptionsPosition[     94507,       2068]
NotebookOutlinePosition[     97141,       2132]
CellTagsIndexPosition[     97019,       2126]
WindowTitle->CompressibiliteKSNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "3dbe514a-0df3-4213-9fd9-8a6c1850a9e3"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "dc25c4df-74ee-42fd-9885-8f5833c91670"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "5f58c48e-b9ed-47a7-b083-f6838986af36"]
         }],ExpressionUUID->"2bd5e5a4-8ece-4fa0-9eaf-58500766a340"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"dPArgonNvdRho\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdRho"], 
         "\"CompressibiliteKTNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKTNv"], "\"CeleriteSonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CeleriteSonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "ae47c85a-c60a-4564-9b04-8496756eccb6"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1a3b57ad-5afa-4dfb-b7aa-6cfa1c466c8b"]
         }],ExpressionUUID->"dda2b854-4d72-4514-be0a-d7cd2097711b"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "aa601226-858a-40ed-99db-9ab7d93b571b"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "00c958cf-eba5-4faa-8ae5-3899c2c9d332"]
         }],ExpressionUUID->"8cb09343-ab8d-401d-b0a1-aaf26aab9b3f"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CompressibiliteKSNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CompressibiliteKSNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CompressibiliteKSNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$9378], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CompressibiliteKSNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "3106c7d9-4d25-480d-b963-4b47ba27c098"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "4ef8d8e3-69b6-4eb8-a11f-c1e2a96935f3"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"552c4e89-7c7e-41b7-b22d-64bc93a1c703"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"2f80b056-87e1-4637-a000-331058113648"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CompressibiliteKSNv", "ObjectName",ExpressionUUID->
      "a1ddffe3-cb97-4aa9-8d55-e98666e3e668"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"c11ee7ee-a048-4f45-9b24-27dbe0d9f3a3"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "f93a018f-5dbd-400d-9a1b-b2f7d4f7db0c"]
    }],ExpressionUUID->"97445e84-0d4f-4146-9680-92ce4ee3809f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"d8aa3df5-30a5-4d48-93e3-\
8c0072b401f7"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CompressibiliteKSNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["K", "S"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5475b68e-ea4f-4e39-85d5-2798ad5e34b0"],
     " = -",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        StyleBox["V",
         FontSlant->"Italic"]], 
       SubscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"\[PartialD]", 
           StyleBox["V",
            FontSlant->"Italic"]}], 
          RowBox[{"\[PartialD]", 
           StyleBox["P",
            FontSlant->"Italic"]}]], ")"}], 
        StyleBox["S",
         FontSlant->"Italic"]]}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "8c12459c-3e69-485d-ad66-28dca6b37bf7"],
     " (",
     Cell[BoxData[
      SuperscriptBox["bar", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "dcf9bb41-38d7-410f-9518-aaaab0cf26a2"],
     ")\nCoefficient de compressibilit\[EAcute] adiabatique en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e7f1a1a0-24ee-4e95-8d86-50643390b9b7"],
     ") \n[Adiabatic compressibility coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "3aafee40-26dd-4be0-8ff1-41ddbc2b697e"],
     ")]"
    }],ExpressionUUID->"768d0b53-f8bc-4ad1-a4f0-1704b9b7086b"]}
  }]], "Usage",ExpressionUUID->"b33f28c6-8c07-48cf-8999-57917ecb4c79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"233ff1cd-71b0-4c5d-b52f-9d6e389d5f11"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"60e5f217-4939-4a60-a57a-516e0da3f0d4"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"f76080d8-7568-49cd-9bd3-1debae92f14b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"69f777b9-e06f-4350-b78d-5b033d4ad2c7"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->396785725,ExpressionUUID->"69fbe9c7-28c4-4c8a-b0f6-4a569528a5b5"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "6f5c466b-eceb-4fe2-b48d-83a68764d194"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"1a397bc5-64f0-4864-8d88-bc62ab86bbd4"],

Cell[TextData[{
 "La fonction ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "S"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d14ca1cf-ce31-466a-88ca-20c23cb03975"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "S"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "07705503-b5a0-46c0-a507-1631166f131e"],
 " = ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["K", "T"],
    FontSlant->"Italic"], 
   FractionBox[
    StyleBox[
     SubscriptBox["C", "V"],
     FontSlant->"Italic"], 
    StyleBox[
     SubscriptBox["C", "P"],
     FontSlant->"Italic"]]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f684061d-0ace-48fb-9033-7c539232be16"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"633ec17c-a6fc-4b05-8e65-38eca5351381"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"b86b0edf-1b7b-48a5-9454-724c22ac13fa"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5347bcca-c05a-448d-9d4f-2c52d09c8e6e"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"68f2888c-4fe2-42f4-8106-0f583d2d404e"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "S"],
   FontSlant->"Italic"]],ExpressionUUID->
  "44860fbb-e3b5-4fda-8e32-d764647c2e1a"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) is determined here from the following relationship: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "S"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "7815d54e-4224-4417-93e3-d5e9889f576e"],
 " = ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["K", "T"],
    FontSlant->"Italic"], 
   FractionBox[
    StyleBox[
     SubscriptBox["C", "V"],
     FontSlant->"Italic"], 
    StyleBox[
     SubscriptBox["C", "P"],
     FontSlant->"Italic"]]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1682b112-fbfb-449c-adc4-f24ab0f6aec9"]
}], "Notes",
 CellID->508850368,ExpressionUUID->"348b9a18-f953-4ea9-a9f1-98b5bf1684cc"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"1aab1266-e74d-41e3-8151-40987a8de624"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"dcbebcc3-0e96-495d-85a6-d6776cd21d25"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "61bd0393-974b-4168-b82e-246efc177db3"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->355826171,ExpressionUUID->"c2477850-668f-44f6-a111-e2dfb28947c2"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"ff9a68a0-bde5-43e3-9d63-00dc52be7233"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c926b60b-7e26-4edf-858c-55af0828cfe2"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "0c6dc5fe-9b83-4720-9e26-fca512ae70cb"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->218995428,ExpressionUUID->"1bcff0c6-4cac-4a3d-be46-4320bebc4fcb"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"19d68913-6597-42ab-9bd9-214de48b128a"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "S"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "773b983b-047d-4726-80da-dc40347318c6"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"55d3976b-1eff-4e5b-a0ed-6a7a472fd967"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"CompressibiliteKSNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", "\"\<Bars\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"5b92cac1-ab31-47c3-bf56-8c621c1a99cf"],

Cell[BoxData[
 TemplateBox[{"0.5915403916071157`", 
   RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}], "reciprocal bars", 
   FractionBox["1", "\"Bars\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->889198597,ExpressionUUID->"05c5bc9e-6ff5-4933-b8e3-7f6b80ad5175"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.5915403916071159`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: reciprocal bars"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["1", "\"Bars\""]}], "]"}]& )], ",", 
   RowBox[{"1", "/", "\"\<Atmospheres\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->33588936,ExpressionUUID->"0858c1ac-2562-428b-996c-bc3351748d8f"],

Cell[BoxData[
 TemplateBox[{"0.5993783017959102`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"atm\""}], 
   "reciprocal atmospheres", 
   FractionBox["1", "\"Atmospheres\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->225309787,ExpressionUUID->"04f62187-6c16-47e4-9206-0ab38f02a907"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.5993783017959102`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{"\"/\"", "\[InvisibleSpace]", "\"atm\""}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: reciprocal atmospheres"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["1", "\"Atmospheres\""]}], "]"}]& )], ",", 
   RowBox[{"1", "/", "\"\<MPa\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[4]:=",
 CellID->218090482,ExpressionUUID->"2e7cdf0c-5785-4a4f-b3e3-4abc2fd32cce"],

Cell[BoxData[
 TemplateBox[{"5.91540391607116`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"MPa\""}], 
   "reciprocal megapascals", 
   FractionBox["1", "\"Megapascals\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->77323823,ExpressionUUID->"9e460ac9-1fcb-4d31-b672-77e4157186e0"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"1d57c4db-7d28-441c-b9ba-f63e1738a09f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<AdiabaticCompressibility\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"1", "/", "\"\<Bars\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->375583457,ExpressionUUID->"fcdcb766-2024-4e30-ba7c-46c38e21a395"],

Cell[BoxData[
 TemplateBox[{"0.5914880250876301`", 
   RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}], "reciprocal bars", 
   FractionBox["1", "\"Bars\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->253118854,ExpressionUUID->"3675dd17-f3d4-4cf0-9480-cbf14e790371"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"68e246f5-1315-4a53-b956-477e6e7b16d3"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2f247e70-d93b-4696-81fd-8fa8596e25d5"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "937e16e6-2d46-4595-973a-1b15406fd5f3"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"01617743-bf16-4c78-88e0-23b8b5d4969d"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"96cddc27-c266-48f7-979b-dfe6ca5b482a"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"0b2ee770-2292-41f6-83d9-a3c1749c3869"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "6.874"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "5.29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "2.762"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "1.591"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "1.168"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "0.94"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "0.795"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "0.693"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "0.617"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "0.558"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "0.51"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "0.471"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "0.438"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "0.41"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "0.386"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "0.464"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "0.345"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "4"], " ", 
     RowBox[{"atm", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"17c7bedc-9bb9-4f10-92f9-58daa744a236"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["10", "4"], 
         RowBox[{
          RowBox[{"CompressibiliteKSNv", "[", 
           RowBox[{"150", ",", 
            RowBox[{"RhoArgonNv", "[", 
             RowBox[{"150", ",", 
              RowBox[{
               RowBox[{"dataStreett150", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
             "]"}]}], "]"}], "/", "1.01325"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "4"], " ", 
     RowBox[{"atm", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"KS", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"data150", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"441f953d-2dd9-4e26-995a-db5c3dec76d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                    2.3759020112512164`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0.3229556455248949}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                    2.3759020112512164`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0.3229556455248949}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                   2.3759020112512164`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 0.3229556455248949}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0.3229556455248949}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0.3229556455248942}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {0.3229556455248942, 
               2.3759020112512164`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                    2.3759020112512164`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0.3229556455248949}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                    2.3759020112512164`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0.3229556455248949}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAA+Xhcs9jVb0DHmObp2AEDQOAueggb
KnFAlblU+ZYZAkB9Xo2UAl50QHpbz/3yif8/+pAUtTJbd0BnFYFuWTD7PxoQ
7QFzmHpA7iCmYi719z9aVYPAk8Z9QDvE6JYcSfY/vc7Gif5egEDZDtPpz7n0
Px6ZdEm7+oFAGPs+AdQI8z/vZFxTHHuDQJrnIUHqz/E/0RMjlu3zhEC5aDSC
hfvwPwRpEu/GjIZAQmR/xhIV8D+nvzuSRAqIQKyRomEXfO4/m7yNS8qniUBw
CnXGye/sP6Ccvj3APYtAZc8XqCzP6z8Ufil6WriMQFafjcECwuo/2gW9zPxS
jkA7UuEVE57pPxCPimlD0o9Aad/6S6Kt6D9LX0AOybiQQGtB0Pdd4ec/lugq
hKiEkUBTIve90RjnP5lyMh/aQpJAGSqjQbpd5j/FT07FDxGTQL04MA2jp+U/
qS2HkJfRk0BObPwuixvlPxV9L3hXjpRAGN6YlzOS5D+qH+xqG1uVQFlbH6M0
/eM/9sLFgjEalkAD83yrL3vjP2u5s6VL6ZZAtskDBpoE4z9oIRHlnbSXQP10
mpQukOI/HYqLSUJymEDIFptDmCPiP/tFGrnqP5lAbS6U0Mmz4T+RAsZN5f+Z
QKNpevO8V+E/rzDh/he8mkBsCwgsgP3gP/axELtOiJtA7DPCf5Wb4D/1M12c
10acQLOpF5JyQuA/HAm+iGQVnUB++e4rctbfP/veO5pD1p1AdNt0z4wz3z9i
JinIWpOeQLc1eunYk94/8sAqAXZgn0Dt1sFnTundPx2upK/xD6BANJtW03tX
3T9WJT5kqnegQI9Pz/l1udw/U1UPJ3/doEBEbxxuUR7cP6wFb/x8PKFABr64
PJCP2z+Z31jXfKOhQNUMYebeAts/4jnRxKUDokBNZslAhX/aP+9MgcDqYaJA
KWw4p8D+2T+RibvBMciiQDFUVfttdNk/j0aE1aEno0DIVWW/LQLZPyEt1+4T
j6NAR4b6YVeG2D93zGEWovSjQLmyCFzEDNg/Kex6UFlTpEAW2uIV9ZvXP281
HpASuqRAry0Xra0y1z8R/0/i9BmlQIX57b9o0NY/SPILOtmBpUCqilvO7mXW
P0Oe/5/Z56VAmsQzdqX+1T+ayoEYA0emQMC4eZ9MrNU/hSCOli6upkDzUwfU
BVPVP8z2KCeDDqdA8B87LKr/1D8JV4P5/2+nQJ6h5SdOq9Q/YOfH2A==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {0.3229556455248942, 
                   2.3759020112512164`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 0.3229556455248949}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0.3229556455248949}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0.3229556455248942}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {0.3229556455248942, 
               2.3759020112512164`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["1", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {17}, {2}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   200., 400., 600., 800., 1000., 1200., 1400., 1600., 1800., 2000., 2200., 
   2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17}, {6.666150157704951, 5.114965143801346, 2.686766432007351,
     1.5497910985666734`, 1.1390088304354262`, 0.9188326380246912, 
    0.7799771570224708, 0.6839136653379534, 0.6128548780683187, 
    0.5569379012908087, 0.5101135610559299, 0.4688741390513142, 
    0.4316785765620139, 0.39833003459802285`, 0.36910336640080643`, 
    0.3440819885790798, 0.3229556402970182}}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->27804096,ExpressionUUID->"44aa7bc4-05d6-4d7f-8982-daf1aea594e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"KS", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "7"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[\"K\", \"S\"],FontSlant->\"Italic\"]\
\) (\!\(\*SuperscriptBox[\(10\), \(4\)]\) \!\(\*SuperscriptBox[\(atm\), \
\(-1\)]\))\>\"", ",", "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CompressibiliteKSNv[\!\(\*StyleBox[\"T\",FontSlant->\"\
Italic\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"13384089-a21a-484d-9aee-f095c95cef94"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U9oHF+f33vlGTFx8niCHhCJGUxGl8cQJfFMHNIEBwyjIYLHF7wwGV9G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    "], {{0, 339.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 339.},
  PlotRange->{{0, 450.}, {0, 339.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->796931829,ExpressionUUID->"b439c44a-5c55-4a09-905a-e84fb80148dd"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8b916556-3ad4-4d9b-906e-cdd0edb8b246"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dPArgonNvdRho"]], 
           "paclet:NewEoSArgon/ref/dPArgonNvdRho", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "fe0c29fe-237e-4913-9049-e9e6fc7d9611"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CompressibiliteKTNv"]], 
           "paclet:NewEoSArgon/ref/CompressibiliteKTNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ec5d7c16-f02b-4708-8475-eb86354c0b0d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CeleriteSonNv"]], 
           "paclet:NewEoSArgon/ref/CeleriteSonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "97aec572-a634-4630-bb8d-4c786b69d2ad"]
       }], "SeeAlso",ExpressionUUID->"425dee9c-ad55-4ddd-b5d0-08c5ca14d53e"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"89ff6062-ba87-486c-bd65-\
40c637a83461"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "775e20d9-6777-42a6-888b-2ca020607289"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"258b79b9-b10d-42b6-92d4-\
5f8d72e2cb7d"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "42c94d1a-fe71-409f-8696-ddce7b021246"]], "RelatedLinks",
        ExpressionUUID->"4fd05d76-73c1-4c3f-9115-5d6585ae3979"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "c0fe41e8-0d25-4b69-aa82-833229345d0a"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5d973540-eb0f-4536-8b3d-f2189de7c126"]], "RelatedLinks",
        ExpressionUUID->"b2d2ab7c-bdbe-4f59-b82d-aab6a2c0f7d1"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"a0298f73-4489-4191-a849-\
0254f0be5ed4"],

Cell[" ", "FooterCell",ExpressionUUID->"52977359-f213-465d-9e4b-0cf3e007eb73"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompressibiliteKSNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 24.7859459}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CompressibiliteKSNv[T, \\[Rho]] \\[Congruent] KS = -1/V \
(\\[PartialD]V/\\[PartialD]P) S (bar -1) Coefficient de compressibilit\
\[EAcute] adiabatique en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[Adiabatic compressibility coefficient versus T (Kelvin) and \\[Rho] \
(g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CompressibiliteKSNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "CompressibiliteKSNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/CompressibiliteKSNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"ec023ac9-8f2f-4cb6-8bb7-54c63dc71bb9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14064, 405, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c2477850-668f-44f6-a111-e2dfb28947c2",
   CellTags->"PrimaryExamplesSection",
   CellID->355826171]},
 "RasterizedOutput"->{
  Cell[58581, 1411, 30774, 511, 360, "Output",ExpressionUUID->"b439c44a-5c55-4a09-905a-e84fb80148dd",
   CellTags->"RasterizedOutput",
   CellID->796931829]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 96637, 2115},
 {"RasterizedOutput", 96837, 2119}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 5592, 134, 56, "AnchorBarGrid",ExpressionUUID->"552c4e89-7c7e-41b7-b22d-64bc93a1c703",
 CellID->1],
Cell[6186, 157, 94, 0, 23, "ContextNameCell",ExpressionUUID->"2f80b056-87e1-4637-a000-331058113648"],
Cell[CellGroupData[{
Cell[6305, 161, 562, 14, 56, "ObjectNameGrid",ExpressionUUID->"d8aa3df5-30a5-4d48-93e3-8c0072b401f7"],
Cell[6870, 177, 1922, 55, 150, "Usage",ExpressionUUID->"b33f28c6-8c07-48cf-8999-57917ecb4c79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8829, 237, 1919, 48, 37, "NotesSection",ExpressionUUID->"69fbe9c7-28c4-4c8a-b0f6-4a569528a5b5",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->396785725],
Cell[10751, 287, 529, 16, 38, "Notes",ExpressionUUID->"1a397bc5-64f0-4864-8d88-bc62ab86bbd4",
 CellID->1067943069],
Cell[11283, 305, 1008, 35, 41, "Notes",ExpressionUUID->"633ec17c-a6fc-4b05-8e65-38eca5351381",
 CellID->524000197],
Cell[12294, 342, 186, 4, 36, "Notes",ExpressionUUID->"b86b0edf-1b7b-48a5-9454-724c22ac13fa",
 CellID->224665577],
Cell[12483, 348, 519, 16, 38, "Notes",ExpressionUUID->"68f2888c-4fe2-42f4-8106-0f583d2d404e",
 CellID->51803587],
Cell[13005, 366, 932, 33, 41, "Notes",ExpressionUUID->"348b9a18-f953-4ea9-a9f1-98b5bf1684cc",
 CellID->508850368]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[14064, 405, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c2477850-668f-44f6-a111-e2dfb28947c2",
 CellTags->"PrimaryExamplesSection",
 CellID->355826171],
Cell[CellGroupData[{
Cell[15509, 446, 1398, 36, 30, "ExampleSection",ExpressionUUID->"1bcff0c6-4cac-4a3d-be46-4320bebc4fcb",
 CellID->218995428],
Cell[16910, 484, 268, 5, 42, "Input",ExpressionUUID->"19d68913-6597-42ab-9bd9-214de48b128a",
 CellID->143015886],
Cell[17181, 491, 369, 10, 38, "ExampleText",ExpressionUUID->"55d3976b-1eff-4e5b-a0ed-6a7a472fd967",
 CellID->544149791],
Cell[CellGroupData[{
Cell[17575, 505, 1033, 25, 42, "Input",ExpressionUUID->"5b92cac1-ab31-47c3-bf56-8c621c1a99cf",
 CellID->254692277],
Cell[18611, 532, 286, 6, 43, "Output",ExpressionUUID->"05c5bc9e-6ff5-4933-b8e3-7f6b80ad5175",
 CellID->889198597]
}, Open  ]],
Cell[CellGroupData[{
Cell[18934, 543, 749, 19, 26, "Input",ExpressionUUID->"0858c1ac-2562-428b-996c-bc3351748d8f",
 CellID->33588936],
Cell[19686, 564, 301, 7, 40, "Output",ExpressionUUID->"04f62187-6c16-47e4-9206-0ab38f02a907",
 CellID->225309787]
}, Open  ]],
Cell[CellGroupData[{
Cell[20024, 576, 725, 18, 26, "Input",ExpressionUUID->"2e7cdf0c-5785-4a4f-b3e3-4abc2fd32cce",
 CellID->218090482],
Cell[20752, 596, 298, 7, 40, "Output",ExpressionUUID->"9e460ac9-1fcb-4d31-b672-77e4157186e0",
 CellID->77323823]
}, Open  ]],
Cell[21065, 606, 154, 1, 38, "ExampleText",ExpressionUUID->"1d57c4db-7d28-441c-b9ba-f63e1738a09f",
 CellID->361149294],
Cell[CellGroupData[{
Cell[21244, 611, 681, 16, 42, "Input",ExpressionUUID->"fcdcb766-2024-4e30-ba7c-46c38e21a395",
 CellID->375583457],
Cell[21928, 629, 286, 6, 43, "Output",ExpressionUUID->"3675dd17-f3d4-4cf0-9480-cbf14e790371",
 CellID->253118854]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[22363, 643, 1419, 37, 30, "ExampleSection",ExpressionUUID->"01617743-bf16-4c78-88e0-23b8b5d4969d",
 CellID->258228157],
Cell[23785, 682, 175, 3, 70, "Input",ExpressionUUID->"96cddc27-c266-48f7-979b-dfe6ca5b482a",
 CellID->279378555],
Cell[23963, 687, 201, 4, 70, "ExampleText",ExpressionUUID->"0b2ee770-2292-41f6-83d9-a3c1749c3869",
 CellID->227520913],
Cell[24167, 693, 1595, 47, 70, "Input",ExpressionUUID->"17c7bedc-9bb9-4f10-92f9-58daa744a236",
 CellID->243734080],
Cell[CellGroupData[{
Cell[25787, 744, 1297, 37, 70, "Input",ExpressionUUID->"441f953d-2dd9-4e26-995a-db5c3dec76d2",
 CellID->123312038],
Cell[27087, 783, 29324, 564, 70, "Output",ExpressionUUID->"44aa7bc4-05d6-4d7f-8982-daf1aea594e3",
 CellID->27804096]
}, Open  ]],
Cell[CellGroupData[{
Cell[56448, 1352, 2130, 57, 70, "Input",ExpressionUUID->"13384089-a21a-484d-9aee-f095c95cef94",
 CellID->283061935],
Cell[58581, 1411, 30774, 511, 360, "Output",ExpressionUUID->"b439c44a-5c55-4a09-905a-e84fb80148dd",
 CellTags->"RasterizedOutput",
 CellID->796931829]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[89597, 1931, 2483, 67, 114, "SeeAlsoSection",ExpressionUUID->"89ff6062-ba87-486c-bd65-40c637a83461"],
Cell[92083, 2000, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"258b79b9-b10d-42b6-92d4-5f8d72e2cb7d"],
Cell[92815, 2021, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"a0298f73-4489-4191-a849-0254f0be5ed4"],
Cell[94425, 2066, 78, 0, 70, "FooterCell",ExpressionUUID->"52977359-f213-465d-9e4b-0cf3e007eb73"]
}
]
*)

(* End of internal cache information *)

