(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     97151,       2099]
NotebookOptionsPosition[     90022,       1954]
NotebookOutlinePosition[     92656,       2018]
CellTagsIndexPosition[     92534,       2012]
WindowTitle->CompressibiliteKTNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "de1aa066-cae6-42c7-9f4c-3d2149f86bcf"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "a239b479-394c-40a4-bcff-c2a5b8076345"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "803cacb6-0736-4264-9f26-ac1d43d4968c"]
         }],ExpressionUUID->"858eaaa3-b298-4b30-8470-f8ded39d0f34"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"dPArgonNvdRho\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dPArgonNvdRho"], 
         "\"CompressibiliteKSNv\"" :> 
         Documentation`HelpLookup[
          "paclet:NewEoSArgon/ref/CompressibiliteKSNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "06d16598-66f9-4e87-a59b-6b4c2c9f220d"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "29957f31-7fa1-4109-88df-34c98233e532"]
         }],ExpressionUUID->"fda02621-c8c4-449b-b780-3eb71a735d9a"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cae45bc9-0a80-468a-bed2-9b06040073bc"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "040f7b06-87dc-4c2e-8fc2-08939bd9c799"]
         }],ExpressionUUID->"fb553acb-1659-45c5-8d58-63242ec07829"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CompressibiliteKTNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CompressibiliteKTNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CompressibiliteKTNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$9904], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CompressibiliteKTNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "8c0e2962-cc13-48a1-a1ab-f226140f3cbb"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "b5ba32e2-feee-4120-a1aa-0c76a9f10290"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"b1901ab0-b269-41bc-9338-b34c90ecd314"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"6af2da7b-c141-453b-871a-6a76afa540cf"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CompressibiliteKTNv", "ObjectName",ExpressionUUID->
      "f8be0d9d-ffbe-4188-b7e5-03627e7b88ab"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"72462848-2e0f-4821-9c02-b08ff2c28da0"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "96e124d5-d083-4ffb-ba82-aaf54885e446"]
    }],ExpressionUUID->"50ed6c18-4a5a-4eb8-8e16-3a155cbfe028"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"853c1a4f-f4c1-4d1d-850b-\
2cd22103787d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CompressibiliteKTNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["K", "T"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1964c582-a454-487a-ab97-861e03e10df3"],
     " = -",
     Cell[BoxData[
      RowBox[{
       FractionBox["1", 
        StyleBox["V",
         FontSlant->"Italic"]], 
       SubscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"\[PartialD]", 
           StyleBox["V",
            FontSlant->"Italic"]}], 
          RowBox[{"\[PartialD]", 
           StyleBox["P",
            FontSlant->"Italic"]}]], ")"}], 
        StyleBox["T",
         FontSlant->"Italic"]]}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "557fce6e-d741-4946-a591-f220a6debdfb"],
     " (",
     Cell[BoxData[
      SuperscriptBox["bar", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "bc417b5f-ab2d-403d-96bb-ad9f4f2b68db"],
     ")\nCoefficient de compressibilit\[EAcute] isotherme en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a85acac1-8c1e-4b68-9b72-988bffd5b423"],
     ") \n[Isothermal compressibility coefficient versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0f531396-9c93-4ebd-8c57-93e924b4b98a"],
     ") ]"
    }],ExpressionUUID->"fe79f67e-6ec5-4c05-9b15-2e3e5fee178c"]}
  }]], "Usage",ExpressionUUID->"18e66598-aca8-4c50-8f4a-81e40b88f759"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"0133821d-0e49-4321-afcd-a51542b42d2e"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"2edb49b8-1851-4b07-89aa-f8e5382092ad"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"00bc289a-fae3-4c4b-8ab3-1ebb4c29a0a7"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"a3b9f3b0-f6c5-409b-8ce5-d87a0fe5298a"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->10295431,ExpressionUUID->"3fcecbc9-31a4-4768-898c-b0132604013c"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ba2b3429-62c3-4983-97b6-33dce4dda671"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"95652198-61e7-47b4-a183-4e727da44c87"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"49ac54a1-e487-4b6f-9a41-510ba6f6aead"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "ddea7040-e9b0-47bf-a00f-a04440f6329f"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->17987804,ExpressionUUID->"9d16c990-74da-4caf-8c02-e69d163fc634"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"2704286a-c908-408c-abeb-beeae39a8243"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"be840957-9aae-48d8-9ec4-9e843ae95347"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "1c6c7f8a-6507-4818-af7d-00c829fa92b3"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->515374379,ExpressionUUID->"1571a2b9-3985-45e2-89ad-7a42d5d66cb6"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"075a7c24-0599-4725-9cab-bcefb55b313c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"63508def-2f28-4eee-9481-52994fda8a1b"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "016cc8bf-f449-41a6-ae87-b828e3e2d930"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->489151742,ExpressionUUID->"1dfcef9e-d67e-4d3a-b4f3-aac4c7fc96fd"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"c7eb9831-6283-437d-a28b-0529194efb85"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["K", "T"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f8b3b054-ab2f-4d79-a1b2-2082ca5f47a7"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"bc2b9034-888e-4f15-b8e3-5deb0ae6d7db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"CompressibiliteKTNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"1", "/", "\"\<Bars\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254692277,ExpressionUUID->"52210a71-bd71-41ce-8b34-e3fe4d710dba"],

Cell[BoxData[
 TemplateBox[{"0.9876189406626227`", 
   RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}], "reciprocal bars", 
   FractionBox["1", "\"Bars\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->19011964,ExpressionUUID->"578b4bec-c5df-4758-bd8a-92b618e18327"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"0.9876189406626229`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: reciprocal bars"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["1", "\"Bars\""]}], "]"}]& )], ",", 
   RowBox[{"1", "/", "\"\<Atmospheres\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->241565501,ExpressionUUID->"a912eb01-2efc-4b96-8902-edacfee239af"],

Cell[BoxData[
 TemplateBox[{"1.0007048916264027`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"atm\""}], 
   "reciprocal atmospheres", 
   FractionBox["1", "\"Atmospheres\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->262642827,ExpressionUUID->"87e3e8f3-95e7-40fc-b4ac-af8aa2849bd5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"1.0007048916264027`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{"\"/\"", "\[InvisibleSpace]", "\"atm\""}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: reciprocal atmospheres"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["1", "\"Atmospheres\""]}], "]"}]& )], ",", 
   RowBox[{"1", "/", "\"\<MPa\>\""}]}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[4]:=",
 CellID->54379702,ExpressionUUID->"91c9f1f9-cc41-46f0-b2cd-06d127d3c64f"],

Cell[BoxData[
 TemplateBox[{"9.87618940662623`", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"MPa\""}], 
   "reciprocal megapascals", 
   FractionBox["1", "\"Megapascals\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->110925020,ExpressionUUID->"ea8b57ca-3eb0-4205-a66f-d341d1087282"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"b7618c30-cdb6-4a82-ba35-8b470f204a91"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<IsothermalCompressibility\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"1", "/", "\"\<Bars\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->375583457,ExpressionUUID->"aeebab94-ce91-470b-b436-e887ef215727"],

Cell[BoxData[
 TemplateBox[{"0.98760174335412`", 
   RowBox[{"\"per \"", "\[InvisibleSpace]", "\"bar\""}], "reciprocal bars", 
   FractionBox["1", "\"Bars\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[5]=",
 CellID->388501144,ExpressionUUID->"0481f9a0-cd6f-4d39-88ca-60176b40367a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"145a7e85-0040-480d-9ee9-7d34a8233cea"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"9d090f5c-e088-4020-ac87-d6218c3d1501"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6127e57d-5564-48fa-9123-fa852226e882"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"13ff8737-d6e1-4bb9-ac10-376040271499"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"31bdc8e8-3311-4a3a-bd1d-8266b33d2e23"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"fa9dd83e-0401-47ef-8fe8-142ec1120801"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "27.77"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "18.7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "7.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "3.57"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "2.39"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "1.8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "1.46"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "1.23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "1.06"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "0.93"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "0.84"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "0.76"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "0.69"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "0.64"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "0.59"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "0.55"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "0.52"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "4"], " ", 
     RowBox[{"atm", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"7f4b4112-f65d-4e55-bf13-64eb0d85e1ea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["10", "4"], 
         RowBox[{
          RowBox[{"CompressibiliteKTNv", "[", 
           RowBox[{"150", ",", 
            RowBox[{"RhoArgonNv", "[", 
             RowBox[{"150", ",", 
              RowBox[{
               RowBox[{"dataStreett150", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
             "]"}]}], "]"}], "/", "1.01325"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{
     SuperscriptBox["10", "4"], " ", 
     RowBox[{"atm", "^", 
      RowBox[{"-", "1"}]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"KT", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"data150", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"64b41197-e5b8-46a2-b625-ebdc674ce0d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                    5.16857948869654}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                    "Axes" -> {False, False}, "LabelStyle" -> {}, 
                    "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                    5.16857948869654}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                    "Axes" -> {False, False}, "LabelStyle" -> {}, 
                    "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                   5.16857948869654}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                  "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                  1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {0.47467303721301196`, 
               5.16857948869654}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                    5.16857948869654}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                    "Axes" -> {False, False}, "LabelStyle" -> {}, 
                    "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                    5.16857948869654}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                    "Axes" -> {False, False}, "LabelStyle" -> {}, 
                    "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAADUyWnOFc0CE6foZoKwUQH1ejZQC
XnRAfPgyu7WeE0D6kBS1Mlt3QB7yMTL9yQ9AGhDtAXOYekAOuoPkaYIKQFpV
g8CTxn1AV9aOkzsnCEC9zsaJ/l6AQFHjMD+X9AVAHpl0Sbv6gUD/kqkofJID
QO9kXFMce4NAvPtWqMvoAUDREyOW7fOEQEYZPTUv3ABABGkS78aMhkAwyZDK
enH/P6e/O5JECohAghr6PJhR/T+bvI1LyqeJQNVnSQohZ/s/oJy+PcA9i0D9
SamiFxT6PxR+KXpauIxARVkEW+fX+D/aBb3M/FKOQFWfCc32gPc/EI+KaUPS
j0D/Jfzv42r2P0tfQA7JuJBAvrgq91qH9T+W6CqEqISRQIHHAo32p/Q/mXIy
H9pCkkAm07ZEj9fzP8VPTsUPEZNAPbXJnRQP8z+pLYeQl9GTQDaAWoOeePI/
FX0veFeOlEBaOBrPHOXxP6of7GobW5VATQNY8hZF8T/2wsWCMRqWQHoJZsw+
uvA/a7mzpUvplkCt3dYeuT3wP2ghEeWdtJdAsQ1hyvKG7z8diotJQnKYQLf+
1GPmou4/+0Uaueo/mUCTHm0YzLjtP5ECxk3l/5lAJIR45Zn57D+vMOH+F7ya
QFim06MrPuw/9rEQu06Im0B3xpoOynLrP/UzXZzXRpxAjuQHOfO56j8cCb6I
ZBWdQGqmYMJlBuo/+947mkPWnUAQOMhtvF7pP2ImKchak55A9lTfeVy66D/y
wCoBdmCfQA7k5tQ+C+g/Ha6kr/EPoEDqyqvDmXfnP1YlPmSqd6BA6Ej3ZZrX
5j9TVQ8nf92gQLtau4yFOuY/rAVv/Hw8oUBhXUrEcarlP5nfWNd8o6FA2Doc
Rcwf5T/iOdHEpQOiQGQ6tq1bnuQ/70yBwOphokCxFBGFdh/kP5GJu8ExyKJA
HOL85nuX4z+PRoTVoSejQPY+Y3bDKuM/IS3X7hOPo0DcudSv67TiP3fMYRai
9KNAj2CPNTtB4j8p7HpQWVOkQOKJmlAB1uE/bzUekBK6pEB0rXkSl3XhPxH/
T+L0GaVAhY/2OZgb4T9I8gs62YGlQJx8DUIVuuA/Q57/n9nnpUC7tEBquVvg
P5rKgRgDR6ZAgXbcFB4T4D+FII6WLq6mQAYt4D3NiN8/zPYoJ4MOp0B5ih8r
zvXePwlXg/n/b6dAOd3HBAth3j+F7roD
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {0.47467303721301196`, 
                   5.16857948869654}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
                  "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                  1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {0.47467303721301196`, 
               5.16857948869654}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["1", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {17}, {2}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   200., 400., 600., 800., 1000., 1200., 1400., 1600., 1800., 2000., 2200., 
   2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17}, {27.626730108341857`, 18.557917925290973`, 
    7.356379579485759, 3.461440653281405, 2.3037967714458576`, 
    1.746889281738207, 1.420660125008802, 1.2066478687876852`, 
    1.0540123690570686`, 0.9365788001812403, 0.8393207167506472, 
    0.7544289622898145, 0.6791082366027757, 0.6133812030716237, 
    0.5577573674026333, 0.5119279481238191, 0.47467302799399785`}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->134200136,ExpressionUUID->"465ab169-3896-4a71-a55a-0762d76f9030"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"KT", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "30"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[\"K\", \"T\"],FontSlant->\"Italic\"]\
\) (\!\(\*SuperscriptBox[\(10\), \(4\)]\) \!\(\*SuperscriptBox[\(atm\), \
\(-1\)]\))\>\"", ",", "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CompressibiliteKTNv[\!\(\*StyleBox[\"T\",FontSlant->\"\
Italic\"]\),\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"857cbf58-999b-434b-84dc-373ae8cbc9a9"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U+IHNma3/1yv/JYM9b11B16QBiBa7gyaMa60PatRS9kXC8UXL1YC+FX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    "], {{0, 336.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 336.},
  PlotRange->{{0, 450.}, {0, 336.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[4]=",
 CellID->707949496,ExpressionUUID->"8fc8dc6c-4c73-4357-8248-7fdde399c0d9"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9397b282-1dc7-4766-a7f8-4dda3ea827e6"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dPArgonNvdRho"]], 
           "paclet:NewEoSArgon/ref/dPArgonNvdRho", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e7305c96-66fb-4f33-b460-145b29262bd4"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CompressibiliteKSNv"]], 
           "paclet:NewEoSArgon/ref/CompressibiliteKSNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "cc8ab202-e522-4f0f-b233-8d259c840ff8"]
       }], "SeeAlso",ExpressionUUID->"bceb2511-193b-4fbb-83fa-a19de6af04a8"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"485a3795-0b2c-4026-b006-\
22ce22cbb80d"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "9babfc23-a61a-4a2c-878d-9d62411bff20"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"bc3d4e93-a50e-489b-bfef-\
772ec2229389"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2c468575-e832-4a9a-a034-362d7e659498"]], "RelatedLinks",
        ExpressionUUID->"ff76f37a-52be-4ff5-a33c-f9f04a4a2d80"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "4b340e8f-e9d5-4ab7-9f79-1e64e31ec389"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6825d127-ee43-4815-8e1c-cd13788ea84d"]], "RelatedLinks",
        ExpressionUUID->"96e8c151-88e0-4ad8-84ef-dc1f0192e2e9"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"d9cbd608-841b-4c7f-a4ff-\
93d4bd8584c5"],

Cell[" ", "FooterCell",ExpressionUUID->"1e291922-8f83-4f2b-9a34-0bb81c7a51b2"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompressibiliteKTNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 26.0680161}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CompressibiliteKTNv[T, \\[Rho]] \\[Congruent] KT = -1/V \
(\\[PartialD]V/\\[PartialD]P) T (bar -1) Coefficient de compressibilit\
\[EAcute] isotherme en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[Isothermal compressibility coefficient versus T (Kelvin) and \\[Rho] \
(g/cm^3) ]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "CompressibiliteKTNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "CompressibiliteKTNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/CompressibiliteKTNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a22a0222-a858-4ae8-b612-ebc341dae233"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12018, 332, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"1571a2b9-3985-45e2-89ad-7a42d5d66cb6",
   CellTags->"PrimaryExamplesSection",
   CellID->515374379]},
 "RasterizedOutput"->{
  Cell[56174, 1337, 29237, 486, 357, "Output",ExpressionUUID->"8fc8dc6c-4c73-4357-8248-7fdde399c0d9",
   CellTags->"RasterizedOutput",
   CellID->707949496]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 92152, 2001},
 {"RasterizedOutput", 92352, 2005}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 5493, 133, 56, "AnchorBarGrid",ExpressionUUID->"b1901ab0-b269-41bc-9338-b34c90ecd314",
 CellID->1],
Cell[6087, 156, 94, 0, 23, "ContextNameCell",ExpressionUUID->"6af2da7b-c141-453b-871a-6a76afa540cf"],
Cell[CellGroupData[{
Cell[6206, 160, 562, 14, 56, "ObjectNameGrid",ExpressionUUID->"853c1a4f-f4c1-4d1d-850b-2cd22103787d"],
Cell[6771, 176, 1922, 55, 150, "Usage",ExpressionUUID->"18e66598-aca8-4c50-8f4a-81e40b88f759"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8730, 236, 1918, 48, 37, "NotesSection",ExpressionUUID->"3fcecbc9-31a4-4768-898c-b0132604013c",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->10295431],
Cell[10651, 286, 529, 16, 38, "Notes",ExpressionUUID->"95652198-61e7-47b4-a183-4e727da44c87",
 CellID->1067943069],
Cell[11183, 304, 186, 4, 36, "Notes",ExpressionUUID->"49ac54a1-e487-4b6f-9a41-510ba6f6aead",
 CellID->224665577],
Cell[11372, 310, 519, 16, 38, "Notes",ExpressionUUID->"9d16c990-74da-4caf-8c02-e69d163fc634",
 CellID->17987804]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12018, 332, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"1571a2b9-3985-45e2-89ad-7a42d5d66cb6",
 CellTags->"PrimaryExamplesSection",
 CellID->515374379],
Cell[CellGroupData[{
Cell[13463, 373, 1398, 36, 30, "ExampleSection",ExpressionUUID->"1dfcef9e-d67e-4d3a-b4f3-aac4c7fc96fd",
 CellID->489151742],
Cell[14864, 411, 268, 5, 42, "Input",ExpressionUUID->"c7eb9831-6283-437d-a28b-0529194efb85",
 CellID->143015886],
Cell[15135, 418, 369, 10, 38, "ExampleText",ExpressionUUID->"bc2b9034-888e-4f15-b8e3-5deb0ae6d7db",
 CellID->544149791],
Cell[CellGroupData[{
Cell[15529, 432, 1033, 25, 42, "Input",ExpressionUUID->"52210a71-bd71-41ce-8b34-e3fe4d710dba",
 CellID->254692277],
Cell[16565, 459, 285, 6, 43, "Output",ExpressionUUID->"578b4bec-c5df-4758-bd8a-92b618e18327",
 CellID->19011964]
}, Open  ]],
Cell[CellGroupData[{
Cell[16887, 470, 750, 19, 26, "Input",ExpressionUUID->"a912eb01-2efc-4b96-8902-edacfee239af",
 CellID->241565501],
Cell[17640, 491, 301, 7, 40, "Output",ExpressionUUID->"87e3e8f3-95e7-40fc-b4ac-af8aa2849bd5",
 CellID->262642827]
}, Open  ]],
Cell[CellGroupData[{
Cell[17978, 503, 724, 18, 26, "Input",ExpressionUUID->"91c9f1f9-cc41-46f0-b2cd-06d127d3c64f",
 CellID->54379702],
Cell[18705, 523, 299, 7, 40, "Output",ExpressionUUID->"ea8b57ca-3eb0-4205-a66f-d341d1087282",
 CellID->110925020]
}, Open  ]],
Cell[19019, 533, 154, 1, 38, "ExampleText",ExpressionUUID->"b7618c30-cdb6-4a82-ba35-8b470f204a91",
 CellID->361149294],
Cell[CellGroupData[{
Cell[19198, 538, 682, 16, 42, "Input",ExpressionUUID->"aeebab94-ce91-470b-b436-e887ef215727",
 CellID->375583457],
Cell[19883, 556, 284, 6, 43, "Output",ExpressionUUID->"0481f9a0-cd6f-4d39-88ca-60176b40367a",
 CellID->388501144]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[20316, 570, 1419, 37, 30, "ExampleSection",ExpressionUUID->"13ff8737-d6e1-4bb9-ac10-376040271499",
 CellID->258228157],
Cell[21738, 609, 175, 3, 70, "Input",ExpressionUUID->"31bdc8e8-3311-4a3a-bd1d-8266b33d2e23",
 CellID->279378555],
Cell[21916, 614, 201, 4, 70, "ExampleText",ExpressionUUID->"fa9dd83e-0401-47ef-8fe8-142ec1120801",
 CellID->227520913],
Cell[22120, 620, 1581, 47, 70, "Input",ExpressionUUID->"7f4b4112-f65d-4e55-bf13-64eb0d85e1ea",
 CellID->243734080],
Cell[CellGroupData[{
Cell[23726, 671, 1297, 37, 70, "Input",ExpressionUUID->"64b41197-e5b8-46a2-b625-ebdc674ce0d9",
 CellID->123312038],
Cell[25026, 710, 28977, 563, 70, "Output",ExpressionUUID->"465ab169-3896-4a71-a55a-0762d76f9030",
 CellID->134200136]
}, Open  ]],
Cell[CellGroupData[{
Cell[54040, 1278, 2131, 57, 70, "Input",ExpressionUUID->"857cbf58-999b-434b-84dc-373ae8cbc9a9",
 CellID->283061935],
Cell[56174, 1337, 29237, 486, 357, "Output",ExpressionUUID->"8fc8dc6c-4c73-4357-8248-7fdde399c0d9",
 CellTags->"RasterizedOutput",
 CellID->707949496]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[85653, 1832, 1942, 52, 114, "SeeAlsoSection",ExpressionUUID->"485a3795-0b2c-4026-b006-22ce22cbb80d"],
Cell[87598, 1886, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"bc3d4e93-a50e-489b-bfef-772ec2229389"],
Cell[88330, 1907, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"d9cbd608-841b-4c7f-a4ff-93d4bd8584c5"],
Cell[89940, 1952, 78, 0, 70, "FooterCell",ExpressionUUID->"1e291922-8f83-4f2b-9a34-0bb81c7a51b2"]
}
]
*)

(* End of internal cache information *)

