(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    248721,       5007]
NotebookOptionsPosition[    240522,       4844]
NotebookOutlinePosition[    243067,       4906]
CellTagsIndexPosition[    242943,       4900]
WindowTitle->CpAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "d474d1ff-534a-4863-b555-b5632ea4b19d"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "f91bc78f-0e6c-4f0b-84b5-5b5506d5c8f4"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "a294edbd-bc9a-4ac9-90d7-9b3d3dc3904d"]
         }],ExpressionUUID->"39f81594-564f-44e1-95c9-0d7738c25a34"],
         StripOnInput->False],{
        "\"CVAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/CVAdimNv"], 
         "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "96f213f1-a397-4ba7-a08d-7f981c0c8d44"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "3a90b4b1-c22d-4ccc-9a81-af80c0c76e19"]
         }],ExpressionUUID->"f7b38c77-0bd1-4080-b456-2c621ef5379b"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "36b671f0-5e34-4a2d-93eb-4b3b133a97df"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "208acfc1-c753-4f5d-b5a3-694a74f5fe1e"]
         }],ExpressionUUID->"930affc6-5340-48aa-a910-6ea95149b6ec"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/CpAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/CpAdimNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
CpAdimNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$10437], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/CpAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "78341ccc-7466-41a3-b5a2-4b7d85e410aa"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "c06d7d58-d5f6-4a86-b9a6-3dfca8d173d0"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"e723aee1-5106-4079-9eef-98ae695d894c"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"efa6faf6-38b2-4429-906e-46cb615a8268"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "CpAdimNv", "ObjectName",ExpressionUUID->
      "84ddcafb-ec44-4884-8378-9d5d899fb1c6"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"9b757b48-60a0-4abd-9d23-b3be6f88b84b"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "c35ff2ae-41fd-41f7-80d4-87ed40480e6d"]
    }],ExpressionUUID->"d8327f9d-fbe6-4793-a1ca-b3d7f049137f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"27baa914-4107-4861-8755-\
59d4e4fe34ec"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "CpAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["C", "P"],
       FontSlant->"Italic"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5d71b521-da0c-4e1f-9029-dcd5e29ae5a6"],
     "/",
     StyleBox["R",
      FontSlant->"Italic"],
     "\nCapacit\[EAcute] calorifique isobare adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "2d38fce8-5d0a-4cda-bf51-615f3f7beae5"],
     ")\n[Non-dimensionnal isobaric heat capacity versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "592bacec-1252-4c08-96b4-f37048f963ac"],
     ")]"
    }],ExpressionUUID->"208d14c9-728a-4af3-8b82-62b548dd6694"]}
  }]], "Usage",ExpressionUUID->"3d5c1e39-78b0-42aa-9e93-d209f5394df6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"367ae8c4-08cc-44c4-b754-26072bc2a537"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"90ebb0c4-731a-4f65-bec9-bcec6f1846f6"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"3460aeee-0d20-4f18-bcc8-173305fb8eff"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"1afcef61-819c-4762-98ea-f6c98e7e2726"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->117241156,ExpressionUUID->"b4dd017a-37d9-453b-9e5c-407312ab058e"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fa45d46e-5851-4c72-af54-d93614165443"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"2e9d85a0-8b0f-431b-8462-276a9ff1da2d"],

Cell[TextData[{
 "La fonction ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "P"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "6b505a52-e1cc-4f9f-abe6-764c8d8ffdf8"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "P"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "f4ba6e1d-89e6-41b0-950a-5a992bd72389"],
 " = ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["C", "V"],
    FontSlant->"Italic"], "+", 
   StyleBox[
    SubscriptBox["TVK", "T"],
    FontSlant->"Italic"]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0f6a19bc-9a57-4091-b6a8-44b6a6e73a59"],
 Cell[BoxData[
  SubsuperscriptBox[
   RowBox[{"(", 
    FractionBox[
     StyleBox[
      RowBox[{"\[PartialD]", "P"}],
      FontSlant->"Italic"], 
     StyleBox[
      RowBox[{"\[PartialD]", "T"}],
      FontSlant->"Italic"]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"], "2"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2ae52d8c-0d1f-4e26-a2da-59b4a32ac85c"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"aa63baa2-4570-460b-8745-c4c547811191"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"ae4ccd8c-0167-41a2-9210-402488ad6f7c"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "aa0b2409-23bc-476d-aa78-b2769de68b38"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"90d29489-90a9-48ac-bb22-cb5ce3faabc4"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "P"],
   FontSlant->"Italic"]],ExpressionUUID->
  "29452887-76cd-4e59-bbd7-9a73af36bd25"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) is determined here from the following relationship: ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["C", "P"],
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "a56a24db-2fd9-47e3-97c0-d2a772ff5360"],
 " = ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["C", "V"],
    FontSlant->"Italic"], "+", 
   StyleBox[
    SubscriptBox["TVK", "T"],
    FontSlant->"Italic"]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "cae42ea4-cfa6-4f8e-9637-3522311a40d4"],
 Cell[BoxData[
  SubsuperscriptBox[
   RowBox[{"(", 
    FractionBox[
     StyleBox[
      RowBox[{"\[PartialD]", "P"}],
      FontSlant->"Italic"], 
     StyleBox[
      RowBox[{"\[PartialD]", "T"}],
      FontSlant->"Italic"]], ")"}], 
   StyleBox["V",
    FontSlant->"Italic"], "2"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "b901d1bb-0f39-4c67-b8d7-066cd4f5356e"]
}], "Notes",
 CellID->508850368,ExpressionUUID->"41c63eee-9733-4bf2-b4e0-0ac6caa1e5aa"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"f9fb1a48-3184-4095-b66e-dfadaedcd35d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"61264e68-a990-4f3e-b387-ec88e07ee3ed"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "70085185-8103-49fe-85bf-2b474ca4768b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->138622761,ExpressionUUID->"739d5ee4-8db5-4579-847c-4f8b16203ad6"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"56728f95-8cc4-4b93-9885-0530e21dfb98"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"7c572428-b481-4179-9494-dc4493070ad0"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "ab419d51-0aff-41f8-907c-517f128c653d"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->26338602,ExpressionUUID->"db4df9e7-ce7a-4189-9139-8de003e45310"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"f9c999fd-c4fd-41d9-9a5b-7735307fd409"],

Cell[TextData[{
 "Calculated value of ",
 Cell[BoxData[
  SubscriptBox["C", "P"]], "InlineFormula",
  FontFamily->"Source Sans Pro",
  FontSlant->"Italic",ExpressionUUID->"d85f4515-a4c5-40a9-bd85-a834a53064ce"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"03b4c6dd-d0e3-4abb-a6dc-0bf314bb37c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "@", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"CpAdimNv", "[", 
     RowBox[{"293.15", ",", 
      RowBox[{"RhoArgonNv", "[", 
       RowBox[{"293.15", ",", 
        RowBox[{"QuantityMagnitude", "@", 
         RowBox[{"N", "@", 
          RowBox[{"UnitConvert", "[", 
           RowBox[{
            TemplateBox[{"1"},
             "QuantityUnit",
             DisplayFunction->(TooltipBox[
               StyleBox[
                RowBox[{#, "\[InvisibleSpace]", 
                  StyleBox[
                   RowBox[{" ", "\"atm\""}], 
                   "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> 
                False], "Unit: atmospheres"]& ),
             InterpretationFunction->(RowBox[{"Quantity", "[", 
                RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
            "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
    "*", 
    RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"c709137e-2a32-4809-8aa3-9fa2387a3b7d"],

Cell[BoxData[
 TemplateBox[{"20.835790344858342`", 
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/(\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"], "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "kilogram meters squared per second squared kelvin mole", 
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\"", " ", 
      SuperscriptBox["\"Seconds\"", "2"]}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->831068267,ExpressionUUID->"5e1dd099-6e78-4787-97c2-f415e6deebfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"20.835790344858342`", ",", 
     FractionBox[
      RowBox[{"\"\<Kilograms\>\"", " ", 
       SuperscriptBox["\"\<Meters\>\"", "2"]}], 
      RowBox[{"\"\<Kelvins\>\"", " ", "\"\<Moles\>\"", " ", 
       SuperscriptBox["\"\<Seconds\>\"", "2"]}]]}], "]"}], ",", 
   "\"\<Joules/Kelvins/Moles\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->537072472,ExpressionUUID->"f0c19ad1-a860-4522-a00a-03300fb899d1"],

Cell[BoxData[
 TemplateBox[{"20.835790344858342`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->230442351,ExpressionUUID->"9522b5a6-75e4-4d3b-a323-dbceae0e3cc6"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"2d79d26d-06a4-4494-8a1a-357f8773bdaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarIsobaricHeatCapacity\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<Joules/Kelvins/Moles\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"155b3734-1427-4d8c-96c2-80af3777af2c"],

Cell[BoxData[
 TemplateBox[{"20.837186230688303`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->79174414,ExpressionUUID->"6afd9833-fd87-4256-b7e0-75fbfc45b7cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "isobaric heat capacity of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Result", 1, 1, "Output", 
        "Quantity[20.84, \"Joules\"/(\"Kelvins\" \"Moles\")]"}, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}, 
      "ExtrusionOpen" -> True}}, Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods"}, Typeset`pod1$$ = 
   XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"isobaric molar heat\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center], 
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox["\"temperature\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"20\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"degrees Celsius\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox["\"pressure\"", {
                    GrayLevel[0.6]}], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{"\"1\"", "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller], HoldForm]}], Identity], #& , SyntaxForm -> Dot],
                     "  ", 
                    StyleBox[
                    
                    RowBox[{"\"(\"", "\[NoBreak]", "\"atmosphere\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                    GridBoxBackground -> {
                    "Columns" -> {None, None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {2, 2, 2}, "Rows" -> {{1}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 
                    Automatic], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "moutput", {}, {
        "Quantity[20.84, \"Joules\"/(\"Kelvins\" \"Moles\")]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["20.84", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "20.84"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversion", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.02084", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.02084"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    
                    RowBox[{
                    "\"(\"", "\[InvisibleSpace]", "\"mol\"", 
                    "\[InvisibleSpace]", "\"\[ThinSpace]\"", 
                    "\[InvisibleSpace]", "\"K\"", "\[InvisibleSpace]", 
                    "\")\""}]}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilojoules per mole kelvin\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Thermodynamic properties", "scanner" -> "Data", "id" -> 
     "EntrainedTable:ThermodynamicDataRP", "position" -> "400", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                  "\"phase\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TemplateBox[{"\"gas\""}, "RowDefault"]}, {
                 TagBox[
                  PaneBox[
                  "\"temperature\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["293.2", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "293.2"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["20", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "20"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"pressure\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["101\[ThinSpace]325", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "101325"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"density\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["0.001662", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.001662"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"speed of sound\"", 
                    $CellContext`TagBoxWrapper[
                    "Property" -> {$CellContext`ThermodynamicDataRP, 
                    "SoundSpeed"}]], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1148", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1148"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["319", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "319"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{"\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], #& , SyntaxForm -> 
                    Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "Show non-metric", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__Show non-metric"}, {}], 
       XMLElement[
       "state", {
        "name" -> "More", "input" -> 
         "EntrainedTable:ThermodynamicDataRP__More"}, {}]}], 
     XMLElement["infos", {"count" -> "1"}, {
       XMLElement["info", {}, {
         XMLElement["units", {"count" -> "7"}, {
           XMLElement[
           "unit", {"short" -> "atm", "long" -> "atmospheres"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "g/cm^3", "long" -> "grams per cubic centimeter"}, {}], 
           XMLElement[
           "unit", {
            "short" -> "kg/m^3", "long" -> "kilograms per cubic meter"}, {}], 
           XMLElement["unit", {"short" -> "K", "long" -> "kelvins"}, {}], 
           XMLElement[
           "unit", {"short" -> "km/h", "long" -> "kilometers per hour"}, {}], 
           XMLElement[
           "unit", {"short" -> "m/s", "long" -> "meters per second"}, {}], 
           XMLElement["unit", {"short" -> "Pa", "long" -> "pascals"}, {}], 
           XMLElement["cell", {"compressed" -> False, "string" -> True}, {
             Cell[
              BoxData[
               FormBox[
                StyleBox[
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"atmospheres\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"cm\"", "3"]}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"grams per cubic centimeter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SuperscriptBox["\"m\"", "3"]}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilograms per cubic meter\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"K\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kelvins\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"km\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"h\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"kilometers per hour\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    
                    RowBox[{
                    "\"m\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"s\""}], FontFamily -> "Helvetica",
                     FontSize -> Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"meters per second\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"Pa\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"pascals\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {{None}}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}}, "Rows" -> {{0.5}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False], TraditionalForm]], "Output"]}]}]}]}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Phase diagram", "scanner" -> "Data", "id" -> 
     "FeatureHighlightPhaseDiagram:ThermodynamicDataRP", "position" -> "500", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            GraphicsBox[{
              RGBColor[
              0.9921487999999999, 0.8385818666666667, 0.6927381333333333], 
              PolygonBox[CompressedData["
1:eJxF13k4Vd3bB/BjnodKMpYUyVPSIzPdO0SDkChFOJwhVIQkP0UIj2QolYoM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               "]], 
              RGBColor[0.998154, 0.933974, 0.820264], 
              PolygonBox[
               
               NCache[{{-238.4420086048018, -7.00571661241373}, \
{-238.2374728110423, -6.937334987525619}, {-238.0305120492571, \
-6.868953362637509}, {-237.82108293675327`, -6.800571737749398}, \
{-237.60914104981737`, -6.7321901128612875`}, {-237.39464089229872`, \
-6.663808487973176}, {-237.17753586304892`, -6.595426863085066}, \
{-236.95777822216797`, -6.527045238196955}, {-236.73531905600626`, \
-6.458663613308845}, {-236.5101082408679, -6.390281988420734}, \
{-236.282094405359, -6.321900363532623}, {-236.05122489132137`, \
-6.253518738644512}, {-235.8174457132893, -6.185137113756402}, \
{-235.58070151640365`, -6.116755488868291}, {-235.34093553271472`, \
-6.0483738639801805`}, {-235.09808953580085`, -5.97999223909207}, \
{-234.85210379362704`, -5.911610614203959}, {-234.60291701956314`, \
-5.843228989315849}, {-234.35046632147743`, -5.774847364427737}, \
{-234.09468714881663`, -5.706465739539627}, {-233.83551323757877`, \
-5.638084114651516}, {-233.57287655308048`, -5.569702489763405}, \
{-233.30670723041496`, -5.501320864875295}, {-233.0369335124909, \
-5.432939239987184}, {-232.76348168596002`, -5.3645576150990735`}, \
{-232.48627601206837`, -5.296175990210963}, {-232.20523866038087`, \
-5.227794365322852}, {-231.9202896327782, -5.159412740434742}, \
{-231.63134668865928`, -5.091031115546631}, {-231.33832526579437`, \
-5.02264949065852}, {-231.0411383978016, -4.95426786577041}, \
{-230.7396966279538, -4.885886240882298}, {-230.43390791977174`, \
-4.8175046159941886`}, {-230.12367756257282`, -4.749122991106077}, \
{-229.80890807476095`, -4.680741366217967}, {-229.4894991007418, \
-4.612359741329856}, {-229.16534730469976`, -4.543978116441745}, \
{-228.8363462590708, -4.475596491553635}, {-228.50238632795254`, \
-4.407214866665524}, {-228.16335454545717`, -4.338833241777413}, \
{-227.81913448815828`, -4.270451616889303}, {-227.46960614185917`, \
-4.202069992001192}, {-227.11464576207402`, -4.133688367113081}, \
{-226.7541257279603, -4.065306742224971}, {-226.3879143893344, \
-3.99692511733686}, {-226.015875906406, -3.9285434924487492`}, \
{-225.63787008168018`, -3.8601618675606386`}, {-225.25375218398557`, \
-3.791780242672528}, {-224.86337276356053`, -3.723398617784417}, \
{-224.46657745823478`, -3.6550169928963063`}, {-224.06320678991565`, \
-3.5866353680081957`}, {-223.65309595087413`, -3.518253743120085}, \
{-223.23607457922824`, -3.4498721182319745`}, {-222.81196652298075`, \
-3.381490493343864}, {-222.3805895919242, -3.3131088684557533`}, \
{-221.9417552966791, -3.244727243567642}, {-221.49526857408046`, \
-3.1763456186795316`}, {-221.04092749807143`, -3.107963993791421}, \
{-220.57852297520432`, -3.0395823689033103`}, {-220.1078384237842, \
-2.9712007440151993`}, {-219.62864943562025`, -2.9028191191270887`}, \
{-219.1407234192758, -2.834437494238978}, {-218.64381922362568`, \
-2.7660558693508674`}, {-218.13768674043376`, -2.697674244462757}, \
{-217.62206648459608`, -2.629292619574646}, {-217.0966891505369, \
-2.5609109946865356`}, {-216.5612751431918, -2.492529369798425}, \
{-216.01553408184913`, -2.4241477449103144`}, {-215.45916427500205`, \
-2.3557661200222038`}, {-214.89185216421595`, -2.287384495134093}, \
{-214.31327173485698`, -2.2190028702459825`}, {-213.72308389135503`, \
-2.150621245357871}, {-213.12093579448543`, -2.0822396204697604`}, \
{-212.50646015794774`, -2.01385799558165}, {-211.87927450129575`, \
-1.9454763706935392`}, {-211.2389803560243, -1.8770947458054286`}, \
{-210.58516242135153`, -1.808713120917318}, {-209.91738766593693`, \
-1.7403314960292073`}, {-209.23520437145348`, -1.6719498711410967`}, \
{-208.5381411135735, -1.603568246252986}, {-207.82570567553884`, \
-1.5351866213648755`}, {-207.09738388905294`, -1.4668049964767649`}, \
{-206.3526383967591, -1.3984233715886543`}, {-205.59090733004558`, \
-1.3300417467005436`}, {-204.81160289534023`, -1.2616601218124321`}, \
{-204.01410986141946`, -1.1932784969243215`}, {-203.1977839395501, \
-1.124896872036211}, {-202.36195004750107`, -1.0565152471481003`}, \
{-201.50590044759292`, -0.9881336222599897}, {-200.6288927479934, \
-0.9197519973718791}, {-199.73014775539457`, -0.8513703724837685}, \
{-198.8088471660173, -0.7829887475956578}, {-197.8641310805616, \
-0.7146071227075472}, {-196.89509532724037`, -0.6462254978194366}, \
{-195.9007885753793, -0.577843872931326}, {-194.88020922021425`, \
-0.5094622480432154}, {-193.83230201744357`, -0.4410806231551039}, \
{-192.75595444376376`, -0.37269899826699326`}, {-191.64999275700143`, \
-0.30431737337888265`}, {-190.51317772651095`, -0.23593574849077203`}, \
{-189.34419999999997`, -0.16755412353428056`}, {-189.15915481427686`, \
-0.15831041463088358`}, {-188.97324025416088`, -0.1490667057274857}, \
{-188.78643614504742`, -0.13982299682408872`}, {-188.5987363198953, \
-0.13057928792069085`}, {-188.41013455938827`, -0.12133557901729386`}, \
{-188.22062459146895`, -0.11209187011389599`}, {-188.03020009086944`, \
-0.102848161210499}, {-187.8388546786391, -0.09360445230710113}, \
{-187.64658192166826`, -0.08436074340370414}, {-187.453375332208, \
-0.07511703450030627}, {-187.25922836738806`, -0.06587332559690928}, \
{-187.06413442872878`, -0.05662961669351141}, {-186.86808686165315`, \
-0.04738590779011442}, {-186.67107895499055`, -0.03814219888671655}, \
{-186.47310394048282`, -0.028898489983319564`}, {-186.27415499228226`, \
-0.01965478107992169}, {-186.07422522644833`, -0.010411072176524705`}, \
{-185.8733077004407, -0.0011673632731268313`}, {-185.6713954126098, 
                 0.008076345630270154}, {-185.46848130168198`, 
                 0.017320054533668028`}, {-185.26455824624338`, 
                 0.026563763437065013`}, {-185.05961906422064`, 
                 0.03580747234046289}, {-184.8536565123561, 
                 0.04505118124385987}, {-184.6466632856831, 
                 0.054294890147257746`}, {-184.4386320169962, 
                 0.06353859905065473}, {-184.22955527631734`, 
                 0.0727823079540526}, {-184.01942557036273`, 
                 0.08202601685744959}, {-183.80823534200258`, 
                 0.09126972576084746}, {-183.59597696972122`, 
                 0.10051343466424445`}, {-183.3826427670724, 
                 0.10975714356764232`}, {-183.1682249821323, 
                 0.11900085247103931`}, {-182.95271579695049`, 
                 0.12824456137443718`}, {-182.73610732699882`, 
                 0.13748827027783417`}, {-182.51839162061484`, 
                 0.14673197918123204`}, {-182.2995606584459, 
                 0.15597568808462903`}, {-182.0796063528906, 
                 0.1652193969880269}, {-181.8585205475365, 
                 0.1744631058914239}, {-181.63629501659568`, 
                 0.18370681479482176`}, {-181.41292146434128`, 
                 0.19295052369821875`}, {-181.18839152453754`, 
                 0.20219423260161662`}, {-180.9626967598722, 
                 0.2114379415050136}, {-180.73582866138457`, 
                 0.2206816504084106}, {-180.5077786478937, 
                 0.22992535931180846`}, {-180.27853806542356`, 
                 0.23916906821520634`}, {-180.04809818662943`, 
                 0.24841277711860332`}, {-179.81645021022052`, 
                 0.2576564860220003}, {-179.58358526038393`, 
                 0.2669001949253982}, {-179.3494943862063, 
                 0.27614390382879517`}, {-179.1141685610955, 
                 0.28538761273219304`}, {-178.87759868220388`, 
                 0.29463132163559}, {-178.63977556984742`, 
                 0.3038750305389879}, {-178.4006899669289, 
                 0.3131187394423849}, {-178.16033253835917`, 
                 0.32236244834578276`}, {-177.91869387048035`, 
                 0.33160615724917974`}, {-177.67576447048867`, 
                 0.3408498661525776}, {-177.43153476585945`, 
                 0.3500935750559746}, {-177.18599510377345`, 
                 0.3593372839593725}, {-176.93913575054418`, 
                 0.36858099286276946`}, {-176.69094689104816`, 
                 0.37782470176616734`}, {-176.44141862815718`, 
                 0.3870684106695643}, {-176.1905409821733, 
                 0.3963121195729622}, {-175.9383038902672, 
                 0.4055558284763592}, {-175.68469720591986`, 
                 0.41479953737975706`}, {-175.42971069836858`, 
                 0.42404324628315404`}, {-175.1733340520562, 
                 0.4332869551865519}, {-174.9155568660871, 
                 0.4425306640899489}, {-174.65636865368592`, 
                 0.4517743729933468}, {-174.3957588416656, 
                 0.46101808189674376`}, {-174.13371676989738`, 
                 0.47026179080014163`}, {-173.87023169079225`, 
                 0.4795054997035386}, {-173.60529276878611`, 
                 0.4887492086069365}, {-173.33888907983476`, 
                 0.4979929175103335}, {-173.07100961091825`, 
                 0.5072366264137314}, {-172.80164325955337`, 
                 0.5164803353171283}, {-172.53077883331548`, 
                 0.5257240442205262}, {-172.2584050493754, 
                 0.5349677531239232}, {-171.98451053404224`, 
                 0.5442114620273211}, {-171.70908382232227`, 
                 0.553455170930718}, {-171.43211335749163`, 
                 0.5626988798341159}, {-171.1535874906807, 
                 0.5719425887375129}, {-170.87349448047576`, 
                 0.5811862976409099}, {-170.59182249253624`, 
                 0.5904300065443078}, {-170.30855959922968`, 
                 0.5996737154477056}, {-170.02369377928412`, 
                 0.6089174243511026}, {-169.7372129174618, 
                 0.6181611332544996}, {-169.44910480425193`, 
                 0.6274048421578975}, {-169.15935713558764`, 
                 0.6366485510612954}, {-168.86795751259643`, 
                 0.6458922599646924}, {-168.57489344131264`, 
                 0.6551359688680893}, {-168.28015233255832`, 
                 0.6643796777714872}, {-167.98372150169217`, 
                 0.6736233866748842}, {-167.68558816848042`, 
                 0.6828670955782821}, {-167.38573945697675`, 
                 0.692110804481679}, {-167.08416239543652`, 
                 0.7013545133850769}, {-166.78084391626794`, 
                 0.7105982222884739}, {-166.47577085603376`, 
                 0.7198419311918718}, {-166.16892995543373`, 
                 0.7290856400952688}, {-165.86030785942773`, 
                 0.7383293489986666}, {-165.54989111732084`, 
                 0.7475730579020636}, {-165.23766618293047`, 
                 0.7568167668054615}, {-164.92361941479885`, 
                 0.7660604757088585}, {-164.6077370764563, 
                 0.7753041846122564}, {-164.29000533674179`, 
                 0.7845478935156533}, {-163.97041027018184`, 
                 0.7937916024190512}, {-163.64893785743385`, 
                 0.8030353113224482}, {-163.32557398579127`, 
                 0.8122790202258461}, {-163.00030444976363`, 
                 0.8215227291292431}, {-162.6731149517276, 
                 0.8307664380326409}, {-162.34399110265596`, 
                 0.8400101469360379}, {-162.01291842293105`, 
                 0.8492538558394358}, {-161.67988234324375`, 
                 0.8584975647428328}, {-161.34486820558635`, 
                 0.8677412736462307}, {-161.0078612643414, 
                 0.8769849825496276}, {-160.6688466874757, 
                 0.8862286914530255}, {-160.3278095578429, 
                 0.8954724003564225}, {-159.98473487459984`, 
                 0.9047161092598204}, {-159.63960755474898`, 
                 0.9139598181632174}, {-159.29241243480624`, 
                 0.9232035270666152}, {-158.9431342726096, 
                 0.9324472359700122}, {-158.59175774926754`, 
                 0.9416909448734092}, {-158.23826747126657`, 
                 0.9509346537768071}, {-157.88264797273683`, 
                 0.960178362680205}, {-157.52488371789116`, 
                 0.9694220715836019}, {-157.16495910364637`, 
                 0.9786657804869989}, {-156.8028584624368, 
                 0.9879094893903968}, {-156.43856606523218`, 
                 0.9971531982937947}, {-156.07206612477248`, 
                 1.0063969071971917`}, {-155.70334279903142`, 
                 1.0156406161005886`}, {-155.33238019492495`, 
                 1.0248843250039865`}, {-154.95916237227578`, 
                 1.0341280339073844`}, {-154.58367334805436`, 
                 1.0433717428107814`}, {-154.2058971009096, 
                 1.0526154517141784`}, {-153.82581757600974`, 
                 1.0618591606175762`}, {-153.44341869021258`, 
                 1.071102869520974}, {-153.0586843375865, 
                 1.080346578424371}, {-152.67159839530476`, 
                 1.089590287327768}, {-152.28214472994, 
                 1.098833996231166}, {-151.8903072041836, 
                 1.1080777051345638`}, {-151.49606968402225`, 
                 1.1173214140379608`}, {-151.09941604640346`, 
                 1.1265651229413578`}, {-150.70033018742473`, 
                 1.1358088318447557`}, {-150.2987960310868, 
                 1.1450525407481527`}, {-149.8947975386523, 
                 1.1542962496515505`}, {-149.48831871865647`, 
                 1.1635399585549475`}, {-149.07934363761913`, 
                 1.1727836674583454`}, {-148.66785643151223`, 
                 1.1820273763617424`}, {-148.25384131804114`, 
                 1.1912710852651403`}, {-147.83728260979865`, 
                 1.2005147941685372`}, {-147.41816472835905`, 
                 1.209758503071935}, {-146.99647221938005`, 
                 1.219002211975332}, {-146.5721897687819, 
                 1.22824592087873}, {-146.14530222008244`, 
                 1.237489629782127}, {-145.71579459296174`, 
                 1.2467333386855248`}, {-145.28365210314297`, 
                 1.2559770475889218`}, {-144.8488601836702, 
                 1.2652207564923197`}, {-144.41140450768376`, 
                 1.2744644653957167`}, {-143.9712710127866, 
                 1.2837081742991145`}, {-143.5284459271168, 
                 1.2929518832025115`}, {-143.08291579725434`, 
                 1.3021955921059094`}, {-142.63466751810367`, 
                 1.3114393010093064`}, {-142.18368836492425`, 
                 1.3206830099127043`}, {-141.72996602770982`, 
                 1.3299267188161012`}, {-141.2734886481535, 
                 1.3391704277194982`}, {-140.81424485948347`, 
                 1.348414136622896}, {-140.35222382951338`, 
                 1.357657845526294}, {-139.88741530730908`, 
                 1.366901554429691}, {-139.4198096739629, 
                 1.376145263333088}, {-138.94939799805434`, 
                 1.3853889722364858`}, {-138.47617209648632`, 
                 1.3946326811398837`}, {-138.00012460152442`, 
                 1.4038763900432807`}, {-137.52124903501982`, 
                 1.4131200989466777`}, {-137.03953989099276`, 
                 1.4223638078500755`}, {-136.55499272798664`, 
                 1.4316075167534734`}, {-136.06760427288924`, 
                 1.4408512256568704`}, {-135.57737253828117`, 
                 1.4500949345602674`}, {-135.0842969558082, 
                 1.4593386434636653`}, {-134.58837852864912`, 
                 1.4685823523670631`}, {-134.08962000684636`, 
                 1.4778260612704601`}, {-133.5880260901913, 
                 1.487069770173857}, {-133.08360366450935`, 
                 1.496313479077255}, {-132.57636207872002`, 
                 1.5055571879806529`}, {-132.06631347201105`, 
                 1.5148008968840498`}, {-131.55347316310338`, 
                 1.5240446057874468`}, {-131.03786011708274`, 
                 1.5332883146908447`}, {-130.51949751003076`, 
                 1.5425320235942417`}, {-129.99841341825362`, 
                 1.5517757324976396`}, {-129.4746416681213, 
                 1.5610194414010365`}, {-128.94822289576263`, 
                 1.5702631503044344`}, {-128.41920588539716`, 
                 1.5795068592078314`}, {-127.88764928477224`, 
                 1.5887505681112293`}, {-127.35362384320513`, 
                 1.5979942770146263`}, {-126.81721539505344`, 
                 1.6072379859180241`}, {-126.27852894692478`, 
                 1.6164816948214211`}, {-125.7376944781501, 
                 1.625725403724819}, {-125.19487557200682`, 
                 1.634969112628216}, {-124.6502831335803, 
                 1.6442128215316139`}, {-124.10419939029575`, 
                 1.6534565304350108`}, {-123.55702668989167`, 
                 1.6627002393384087`}, {-123.00941705997138`, 
                 1.6719439482418057`}, {-122.46299999999997`, 
                 1.6811876571452036`}, {2726.8469999999998`, 
                 1.6811876571544468`}, {
                 2726.8469999999998`, -2 - Log[10]^(-1) 
                  Log[101325]}}, CompressedData["
1:eJxV2Gc81W/cwPFDZVRG9mgYf4Ui/YUGLtlFSLQI5zgOZ5HR8ldZIZURCalQ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                "]]], 
              RGBColor[0.9888385333333334, 0.7798814666666667, 0.5990192], 
              PolygonBox[
               
               NCache[{{-273.15, -2 - Log[10]^(-1) 
                  Log[101325]}, {-238.4420086048018, -7.00571661241373}, \
{-238.2374728110423, -6.937334987525619}, {-238.0305120492571, \
-6.868953362637509}, {-237.82108293675327`, -6.800571737749398}, \
{-237.60914104981737`, -6.7321901128612875`}, {-237.39464089229872`, \
-6.663808487973176}, {-237.17753586304892`, -6.595426863085066}, \
{-236.95777822216797`, -6.527045238196955}, {-236.73531905600626`, \
-6.458663613308845}, {-236.5101082408679, -6.390281988420734}, \
{-236.282094405359, -6.321900363532623}, {-236.05122489132137`, \
-6.253518738644512}, {-235.8174457132893, -6.185137113756402}, \
{-235.58070151640365`, -6.116755488868291}, {-235.34093553271472`, \
-6.0483738639801805`}, {-235.09808953580085`, -5.97999223909207}, \
{-234.85210379362704`, -5.911610614203959}, {-234.60291701956314`, \
-5.843228989315849}, {-234.35046632147743`, -5.774847364427737}, \
{-234.09468714881663`, -5.706465739539627}, {-233.83551323757877`, \
-5.638084114651516}, {-233.57287655308048`, -5.569702489763405}, \
{-233.30670723041496`, -5.501320864875295}, {-233.0369335124909, \
-5.432939239987184}, {-232.76348168596002`, -5.3645576150990735`}, \
{-232.48627601206837`, -5.296175990210963}, {-232.20523866038087`, \
-5.227794365322852}, {-231.9202896327782, -5.159412740434742}, \
{-231.63134668865928`, -5.091031115546631}, {-231.33832526579437`, \
-5.02264949065852}, {-231.0411383978016, -4.95426786577041}, \
{-230.7396966279538, -4.885886240882298}, {-230.43390791977174`, \
-4.8175046159941886`}, {-230.12367756257282`, -4.749122991106077}, \
{-229.80890807476095`, -4.680741366217967}, {-229.4894991007418, \
-4.612359741329856}, {-229.16534730469976`, -4.543978116441745}, \
{-228.8363462590708, -4.475596491553635}, {-228.50238632795254`, \
-4.407214866665524}, {-228.16335454545717`, -4.338833241777413}, \
{-227.81913448815828`, -4.270451616889303}, {-227.46960614185917`, \
-4.202069992001192}, {-227.11464576207402`, -4.133688367113081}, \
{-226.7541257279603, -4.065306742224971}, {-226.3879143893344, \
-3.99692511733686}, {-226.015875906406, -3.9285434924487492`}, \
{-225.63787008168018`, -3.8601618675606386`}, {-225.25375218398557`, \
-3.791780242672528}, {-224.86337276356053`, -3.723398617784417}, \
{-224.46657745823478`, -3.6550169928963063`}, {-224.06320678991565`, \
-3.5866353680081957`}, {-223.65309595087413`, -3.518253743120085}, \
{-223.23607457922824`, -3.4498721182319745`}, {-222.81196652298075`, \
-3.381490493343864}, {-222.3805895919242, -3.3131088684557533`}, \
{-221.9417552966791, -3.244727243567642}, {-221.49526857408046`, \
-3.1763456186795316`}, {-221.04092749807143`, -3.107963993791421}, \
{-220.57852297520432`, -3.0395823689033103`}, {-220.1078384237842, \
-2.9712007440151993`}, {-219.62864943562025`, -2.9028191191270887`}, \
{-219.1407234192758, -2.834437494238978}, {-218.64381922362568`, \
-2.7660558693508674`}, {-218.13768674043376`, -2.697674244462757}, \
{-217.62206648459608`, -2.629292619574646}, {-217.0966891505369, \
-2.5609109946865356`}, {-216.5612751431918, -2.492529369798425}, \
{-216.01553408184913`, -2.4241477449103144`}, {-215.45916427500205`, \
-2.3557661200222038`}, {-214.89185216421595`, -2.287384495134093}, \
{-214.31327173485698`, -2.2190028702459825`}, {-213.72308389135503`, \
-2.150621245357871}, {-213.12093579448543`, -2.0822396204697604`}, \
{-212.50646015794774`, -2.01385799558165}, {-211.87927450129575`, \
-1.9454763706935392`}, {-211.2389803560243, -1.8770947458054286`}, \
{-210.58516242135153`, -1.808713120917318}, {-209.91738766593693`, \
-1.7403314960292073`}, {-209.23520437145348`, -1.6719498711410967`}, \
{-208.5381411135735, -1.603568246252986}, {-207.82570567553884`, \
-1.5351866213648755`}, {-207.09738388905294`, -1.4668049964767649`}, \
{-206.3526383967591, -1.3984233715886543`}, {-205.59090733004558`, \
-1.3300417467005436`}, {-204.81160289534023`, -1.2616601218124321`}, \
{-204.01410986141946`, -1.1932784969243215`}, {-203.1977839395501, \
-1.124896872036211}, {-202.36195004750107`, -1.0565152471481003`}, \
{-201.50590044759292`, -0.9881336222599897}, {-200.6288927479934, \
-0.9197519973718791}, {-199.73014775539457`, -0.8513703724837685}, \
{-198.8088471660173, -0.7829887475956578}, {-197.8641310805616, \
-0.7146071227075472}, {-196.89509532724037`, -0.6462254978194366}, \
{-195.9007885753793, -0.577843872931326}, {-194.88020922021425`, \
-0.5094622480432154}, {-193.83230201744357`, -0.4410806231551039}, \
{-192.75595444376376`, -0.37269899826699326`}, {-191.64999275700143`, \
-0.30431737337888265`}, {-190.51317772651095`, -0.23593574849077203`}, \
{-189.34419999999997`, -0.16755412353428056`}, {-189.343288536399, \
-0.14523978817194294`}, {-189.3423290240558, -0.12292545280960532`}, \
{-189.34131893041143`, -0.1006111174472677}, {-189.3402555894616, \
-0.07829678208493007}, {-189.3391361947294, -0.05598244672259245}, \
{-189.33795779186931`, -0.03366811136025483}, {-189.33671727088094`, \
-0.011353775997917204`}, {-189.3354113579148, 
                 0.010960559364420419`}, {-189.3340366066463, 
                 0.03327489472675804}, {-189.33258938919664`, 
                 0.055589230089095665`}, {-189.33106588657705`, 
                 0.07790356545143329}, {-189.32946207863034`, 
                 0.10021790081377091`}, {-189.32777373344425`, 
                 0.12253223617610765`}, {-189.32599639620898`, 
                 0.14484657153844527`}, {-189.32412537748905`, 
                 0.1671609069007829}, {-189.3221557408805, 
                 0.1894752422631205}, {-189.3200822900186, 
                 0.21178957762545814`}, {-189.31789955490572`, 
                 0.23410391298779576`}, {-189.31560177752004`, 
                 0.2564182483501334}, {-189.31318289667053`, 
                 0.278732583712471}, {-189.31063653205803`, 
                 0.3010469190748086}, {-189.30795596749954`, 
                 0.32336125443714625`}, {-189.30513413327475`, 
                 0.3456755897994839}, {-189.30216358754686`, 
                 0.3679899251618215}, {-189.29903649681103`, 
                 0.3903042605241591}, {-189.29574461531834`, 
                 0.41261859588649674`}, {-189.2922792634245, 
                 0.43493293124883436`}, {-189.28863130480406`, 
                 0.457247266611172}, {-189.28479112247499`, 
                 0.4795616019735096}, {-189.28074859356855`, 
                 0.5018759373358472}, {-189.27649306278255`, 
                 0.5241902726981849}, {-189.272013314447, 
                 0.5465046080605225}, {-189.26729754313288`, 
                 0.5688189434228601}, {-189.26233332272733`, 
                 0.5911332787851977}, {-189.25710757389663`, 
                 0.6134476141475353}, {-189.25160652985414`, 
                 0.635761949509873}, {-189.2458157003453, 
                 0.6580762848722106}, {-189.23971983375938`, 
                 0.6803906202345473}, {-189.23330287727003`, 
                 0.7027049555968858}, {-189.22654793490582`, 
                 0.7250192909592226}, {-189.21943722344247`, 
                 0.7473336263215602}, {-189.2119520260083, 
                 0.7696479616838978}, {-189.20407264328315`, 
                 0.7919622970462354}, {-189.19577834217125`, 
                 0.8142766324085731}, {-189.1870473018182, 
                 0.8365909677709107}, {-189.17785655683696`, 
                 0.8589053031332483}, {-189.1681819376032, 
                 0.8812196384955859}, {-189.15799800747124`, 
                 0.9035339738579236}, {-189.14727799675475`, 
                 0.9258483092202612}, {-189.1359937333117, 
                 0.9481626445825988}, {-189.12411556956113`, 
                 0.9704769799449364}, {-189.11161230575567`, 
                 0.992791315307274}, {-189.0984511093215, 
                 1.0151056506696117`}, {-189.08459743007143`, 
                 1.0374199860319493`}, {-189.070014911087, 
                 1.059734321394287}, {-189.05466529505486`, 
                 1.0820486567566245`}, {-189.03850832583572`, 
                 1.1043629921189622`}, {-189.02150164503053`, 
                 1.1266773274812998`}, {-189.00360068330144`, 
                 1.1489916628436374`}, {-188.98475854619247`, 
                 1.171305998205975}, {-188.96492589418358`, 
                 1.1936203335683118`}, {-188.9440508167016, 
                 1.2159346689306503`}, {-188.92207869979757`, 
                 1.238249004292987}, {-188.89895208719076`, 
                 1.2605633396553255`}, {-188.8746105343638, 
                 1.2828776750176623`}, {-188.848990455383, 
                 1.3051920103800008`}, {-188.82202496210334`, 
                 1.3275063457423375`}, {-188.79364369540463`, 
                 1.3498206811046751`}, {-188.76377264809156`, 
                 1.3721350164670127`}, {-188.73233397907651`, 
                 1.3944493518293504`}, {-188.69924581844919`, 
                 1.416763687191688}, {-188.66442206302253`, 
                 1.4390780225540256`}, {-188.62777216193206`, 
                 1.4613923579163632`}, {-188.58920089184718`, 
                 1.4837066932787009`}, {-188.548608121342, 
                 1.5060210286410385`}, {-188.50588856395626`, 
                 1.528335364003376}, {-188.46093151946408`, 
                 1.5506496993657137`}, {-188.41362060285104`, 
                 1.5729640347280514`}, {-188.36383346048967`, 
                 1.595278370090389}, {-188.31144147298627`, 
                 1.6175927054527266`}, {-188.25630944416068`, 
                 1.6399070408150642`}, {-188.1982952756064, 
                 1.6622213761774018`}, {-188.13724962626753`, 
                 1.6845357115397395`}, {-188.0730155564565, 
                 1.706850046902077}, {-188.0054281557275, 
                 1.7291643822644147`}, {-187.93431415400892`, 
                 1.7514787176267523`}, {-187.85949151539432`, 
                 1.77379305298909}, {-187.78076901397964`, 
                 1.7961073883514267`}, {-187.69794579113403`, 
                 1.8184217237137652`}, {-187.61081089358618`, 
                 1.840736059076102}, {-187.51914279170853`, 
                 1.8630503944384404`}, {-187.4227088773816, 
                 1.8853647298007772`}, {-187.32126494082635`, 
                 1.9076790651631157`}, {-187.2145546257973, 
                 1.9299934005254524`}, {-187.10230886254124`, 
                 1.952307735887791}, {-186.9842452779356, 
                 1.9746220712501277`}, {-186.86006758224013`, 
                 1.9969364066124653`}, {-186.72946493191398`, 
                 2.019250741974803}, {-186.59211126797317`, 
                 2.0415650773371405`}, {-186.447664629393, 
                 2.063879412699478}, {-186.2957664410897, 
                 2.086193748061816}, {-186.1360407760541, 
                 2.1085080834241534`}, {-185.9680935912482, 
                 2.130822418786491}, {-185.79151193692184`, 
                 2.1531367541488287`}, {-185.60586313905685`, 
                 2.1754510895111663`}, {-185.41069395469623`, 
                 2.197765424873504}, {-185.20552969997806`, 
                 2.2200797602358415`}, {-184.98987335075083`, 
                 2.242394095598179}, {-184.76320461571504`, 
                 2.264708430960516}, {-184.52497898210154`, 
                 2.2870227663228544`}, {-184.27462673396832`, 
                 2.309337101685191}, {-184.01155194326734`, 
                 2.3316514370475296`}, {-183.73513143390716`, 
                 2.3539657724098664`}, {-183.4447137191063, 
                 2.376280107772205}, {-183.1396179124038, 
                 2.3985944431345416`}, {-182.8191326127577, 
                 2.42090877849688}, {-182.48251476422718`, 
                 2.443223113859217}, {-182.1289884907835, 
                 2.4655374492215554`}, {-181.75774390684717`, 
                 2.487851784583892}, {-181.36793590417895`, 
                 2.5101661199462306`}, {-180.95868291577847`, 
                 2.5324804553085674`}, {-180.5290656574478, 
                 2.554794790670905}, {-180.078125847669, 
                 2.5771091260332426`}, {-179.60486490641114`, 
                 2.5994234613955802`}, {-179.10824263342766`, 
                 2.621737796757918}, {-178.5871758665267, 
                 2.6440521321202555`}, {-178.04053712018447`, 
                 2.666366467482593}, {-177.46715320473794`, 
                 2.6886808028449307`}, {-176.86580382621852`, 
                 2.7109951382072683`}, {-176.23522016668488`, 
                 2.733309473569606}, {-175.57408344467353`, 
                 2.7556238089319436`}, {-174.881023455108, 
                 2.777938144294281}, {-174.15461708769635`, 
                 2.800252479656619}, {-173.39338682249627`, 
                 2.8225668150189565`}, {-172.59579920094484`, 
                 2.844881150381294}, {-171.7602632702329, 
                 2.867195485743631}, {-170.88512899845264`, 
                 2.8895098211059693`}, {-169.96868565747891`, 
                 2.911824156468306}, {-169.00916017003578`, 
                 2.9341384918306446`}, {-168.00471541689157`, 
                 2.9564528271929813`}, {-166.95344849958656`, 
                 2.97876716255532}, {-165.8533889535655, 
                 3.0010814979176565`}, {-164.70249690604163`, 
                 3.023395833279995}, {-163.49866117239037`, 
                 3.045710168642332}, {-162.23969728434633`, 
                 3.0680245040046703`}, {-160.92334544278046`, 
                 3.090338839367007}, {-159.54726838735547`, 
                 3.1126531747293456`}, {-158.10904917492368`, 
                 3.1349675100916823`}, {-156.60618885812204`, 
                 3.157281845454021}, {-155.03610405527138`, 
                 3.1795961808163575`}, {-153.39612440236778`, 
                 3.2019105161786943`}, {-151.68348987770614`, 
                 3.2242248515410328`}, {-149.89534798946778`, 
                 3.2465391869033713`}, {-148.0287508164534, 
                 3.268853522265708}, {-146.08065189204905`, 
                 3.2911678576280448`}, {-144.04790292146828`, 
                 3.3134821929903833`}, {-141.9272503223137, 
                 3.335796528352722}, {-139.71533157854967`, 
                 3.3581108637150585`}, {-137.40867139806014`, 
                 3.3804251990773952`}, {-135.0036776640849, 
                 3.4027395344397338`}, {-132.49663717096152`, 
                 3.4250538698020705`}, {-129.8837111347529, 
                 3.447368205164409}, {-127.16093046951241`, 
                 3.4696825405267457`}, {-124.32419082008275`, 
                 3.4919968758890843`}, {-121.36924734249254`, 
                 3.514311211251421}, {-118.29170922313, 
                 3.5366255466137595`}, {-115.08703392799873`, 
                 3.5589398819760962`}, {-111.7505211734144, 
                 3.5812542173384347`}, {-108.27730660956021`, 
                 3.6035685527007715`}, {-104.66235520828354`, 
                 3.62588288806311}, {-100.90045434648673`, 
                 3.6481972234254467`}, {-96.98620657632529, 
                 3.6705115587877852`}, {-92.91402207328707, 
                 3.692825894150122}, {-88.67811075297556, 
                 3.7151402295124587`}, {-84.27247404716456, 
                 3.737454564874797}, {-79.69089632932764, 
                 3.7597689002371357`}, {-74.92693597946047, 
                 3.7820832355994725`}, {-69.97391607755029, 
                 3.804397570961809}, {-64.82491471454105, 
                 3.8267119063241477`}, {-59.47275490907364, 
                 3.849026241686486}, {-53.90999411766339, 
                 3.871340577048823}, {-48.12891332530759, 
                 3.8936549124111597`}, {-42.12150570282341, 
                 3.915969247773498}, {-35.87946481642899, 
                 3.9382835831358367`}, {-29.394172374311637`, 
                 3.9605979184981734`}, {-22.656685494071297`, 
                 3.98291225386051}, {-15.657723474063118`, 
                 4.005226589222849}, {-8.387654050753952, 
                 4.027540924585187}, {-0.8364791232451694, 
                 4.049855259947524}, {7.0061800748349015`, 
                 4.072169595309861}, {15.151098376902894`, 
                 4.094483930672199}, {23.609462680309605`, 
                 4.116798266034536}, {32.39288856149972, 4.139112601396873}, {
                 41.51343753347294, 4.161426936759211}, {50.983634970736375`, 
                 4.18374127212155}, {60.81648872810257, 4.206055607483886}, {
                 71.02550848089822, 4.228369942846223}, {81.62472581538287, 
                 4.250684278208562}, {92.62871509945614, 4.2729986135709}, {
                 104.05261516507699`, 4.295312948933237}, {-273.15, 
                 4.2953129489555515`}}, CompressedData["
1:eJw9mHk0VV3cgM1kVtdMaaCSosjM2Ym8lUwR0WC813WvoUj0SqKQiKRCZB5C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                "]]], 
              RGBColor[
              0.9954590666666666, 0.8972822666666667, 0.7864570666666667], 
              PolygonBox[CompressedData["
1:eJxTTMoPSmViYGDQAGIQLdB84NTCuXEHnqyJY1d99ss+5/nvlRt9lzqg88+k
trek6Qk6PAj8zx3HHOWwghnCn7HK8Z6NRrjDrv4rn3rEBR1Cmv40/k4PcTgl
rZS4mUHQYcG5oHcLDwY63Fqef/7mSwGHjIQHm5sy/BzeGO+1Zbgs4PDAUf/A
81pPh3/7udao7RFwEEg3Dtpx0MWBzydCynepgMMEP0UdLyMHB7kbSzuK+wQc
PvBz7GedY+5gkPL528xyAYcFvWZHYnz1HJw+OKQeSBBwYDA7KxjCJuMQVNN3
+ZknkP/v8N38I6/2p3DcceQ1BtrnUzO96pjCgbIpmhuMZQQcHC5PVTwYoH+g
TaFcLopVwMHidEKXzAqzAzqRnZKMd/kddiwXqH6RYnsgoFDlm+96focTrjN8
J31wPFDSuf/SrEag/Oet9b38rgemLIxa/zyY36FGOsq6QcDjwJadX7tN1Pgd
Qkrfr6/64nXgxsUJGY0/+BxC9s+xbt7je+DPS23Xc6f4HKJsxNJPmwQckGE6
rig9l89BqUNySUhd4AEbqaR/6fl8DnqBnq+DdgcdSDD6e2uLI5/Dgxs2S83f
BB9o8ZqxnVGEz0Ej9Y9ZgWDogSVJxlP8nvE6qBxbopWmHXbgSNW5gtk7eB2O
qBaE1VuFH3gxKdP3RRevwxYpAyY5+4gDPKtZtExjeR2e5bhwL7SMPKBzeD5b
kz6vQ0GVJHuKVtSBgNtWj88x8josO2iRsl8w+kDB56v7pa/wOPht/NrJ8SH6
wBTuwjkZy3gcMmYe+DbxaMyBLco8lVsreBxsgjRjV0+KPXDDenkokzePwx+O
2fsXhscd+BHsZOQvy+MAS2+w9AQAlekbtw==
               "]], 
              RGBColor[
              0.8980593333333333, 0.8971646666666667, 0.9449146666666667], 
              PolygonBox[{}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"gas\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.75, 0.3499999999999999}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                  TagBox[
                   
                   GridBox[{{"\"supercritical\""}, {"\"region\""}}, 
                    GridBoxAlignment -> {"Columns" -> {{Center}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{0.05}}}], 
                   "Column"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.7986888454011729, 0.8268297455968698}]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"liquid\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, {FontFamily -> "Verdana", FontSize -> 10}, 
                  GrayLevel[0.5], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.2395303326810177, 0.7310763209393352}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwVzns4lIkCx3F3urjPmBm6WWsrkmlHxAkl0mJzWdpqt5Q25vK+M6R9Np1Y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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"sublimation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.31258317025440335`, 0.20273972602739798`}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV0Hk4lOsbB/DhlK3EQVmT5SjqcHREG25lj5CljYwZMyNUIqkcZS1SWRLR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               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"saturation curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.40039138943248476`, 0.5505381604696677}]], 
              GrayLevel[0.3961454], 
              Thickness[0.003], 
              LineBox[CompressedData["
1:eJwV0nlYTN8Dx/Fpm8a0TYxoI0tJoiitk3Pa+KFSU2mVaZm5JUy0SN8ogwoh
CaFUtJeKQiFzWiQiUUKpxrek7Zv2hVG/0x/zzPN6zr1zn/edzyofLpMtSiKR
6vFn4Ts11cxImE8gNd812YY3qvlMt3mPCezoN3ld1HA+fzj4/tIhbNQoHZxd
VcG/lV6yvxub1MwlW0iV8RU0NfTbFq4vytJ7llfINxlpj29aOH8S6D7GyOA3
29r41i14rk48G8byuXduljxbsECNdeJoDGjMPneoZOF+HYvN/osyAL00OjFz
4XxdJHVzWCE4HBq5LBkbyrWPRo6Wgvw02YnzC+dS4V7fcyqArr7LyhML95OX
Nlh78cHt83OXDy/0iHxVdj5fDZrEdBj7F66PWseMZb8EqQGXFPdgC4ShcRWw
HtAnDVS3LfRF1L4YVG4AodPFptrY6TOLJ1Wn3wELtV5/xYXnPytZqhnQBJ56
rEmWwNb9/Vm3qvUDMLEiPx/Jw88znt/tbtUMktWO17Vh08I1iPEHLaAzIDe3
Jm/hfdjy4le2gtcfZpgF2COTIanqFz+DzBph2RVsgX5K+YvfX4Cza0BlGHZT
cE2zi38byHhMdXfHRg8Hhkc+tYPYz0+OMbBLRuWp5y07AD3HWlQVO13XWH3N
g07wNvx4z59cAtUb6qp5yQmA0qvfkl+x4eea+1p1AiCtb+Vchl0e5mI6Hfkd
fKy6WnoRW1dhsL5G718QYdRGYWPnPjq5N2HgX0AvyjM2wVZzXtzjmdENBOpr
1stgJ09kHVnv2gOOmnSXd+Tg3iTj+UnZH2B/3X/1BdjReu/iq1/+AKSTyYbH
chb2wlK6HNkLSg+GfAfYQUcncjz0foLn2w0yJLD75OO2ag78BG3RqXvqswnE
eqBcM5HeB5RU3Wtisb/YF9tXufSDaJXRJkts+xGLzouyAyD3dNouYRbuvdwa
6P5yADR2mZIeYEOdA7MakYOAbqzA98Yub/wbM75lCPD2tTrIYusevkJH/UPg
ENc1+nEm7pVRvxuf/h9QyYiVc8dWu1+u4+YyDGhkw6qZe7jXxqZSXfYXyPWe
cUzEpg117Rqr/QXsvo7wNLBrXxof7DIbAUHcAolHd3H/NbFS65sjwHRD/2Uz
bAb73WzBxAhIen/4Az+DQDP6N+Bi+1HwUbQp1BS7TNw7NrxgFAzVGa4tScfv
p0WrsZM8Bp6rbYpSxdbOnKBb+4wB2wb3tafT8PsKfuFRUDkG0j9aFQru4P/f
Mu6uvOI4aP8lm78Vm7WE2X8sZByQonQLTqUSaHm3sm7n+3Ew06NlWJuC3+fD
H2FWGyZAvInpe+FtAiXwiivzYybAJTnKsBa2PfO4uPy/E8B12W5Ju1sEoqy2
3H3MbBLQLoXFsm/i3lHpxI7kSbBt7d7moGTcW9X6xXJiElgyCnZwb+DeK+kr
8/dMASfLWiPWddzLOsChFUyBmP9kxyyu4V5d/fth5GnwVinrkUIS7iXNjX/z
ngZAs+VZWyLubXplYlk5DSK5d7ZcuoJ7066cyls+A26VGpjpJhAok+tRLxcy
Awjj0HH+JdwL1OXC3s8Au+3bvRkXCaQi98v5m9YseMuXj8m8gHs7y1MsYmaB
2D1lp+lzBEoq4nXnfp8FXGpHsV4c7j1poyVn9hu8DnXmusYQSNpO4Uho8m9w
l+zk5ncG70tV8KR9/De47FO+di+PQGf+y5sz3/MHhA/kH9OOxnurDLbOzf8D
aJMNvT9OEEgYbxYvSxaCbxVuE9H/4P15SjaHeAvB02QbOWE47tX+oNj+XAiy
AwISncPwHoW3WObL/4L6qJ01F4Jxb4NfTk7wXzBBdf2QEoT3eXvTsMz7vyCH
V9sScwj3Bs7oh2jNgcC6gHc7DuC9mlb/03Z2Dmim52V0cHAvNb4afp8DSXsZ
qtt98X7bnBflMOaByfz4r5P7cW/+SnuZ5HmwwyK48KwH7o3ovx48Pg/qrT7X
ubgQqCfz6/DBdSRocMTp6hiTQNXx2xarOZOgfttLK0c7vLeQe1ubeSTIm940
GLaTQCc9KW4xJSTI5ukcdbcikKfVoUjjThJUYgSk/d5GIBPtj2lDUiJwNfcz
zckY75FuWJNmLAIZYstNffUINPXndi+TEIFPRbOJtRsJ1NJNopKviUBOuETp
VQ0CPWxgb6yoFoHi1wTU+yvxXkvf2B8cEYECuoL2weUEOnhbJ2TlClH4qbc8
/S2NQDank2583C0KqWoiL15TCKQZOPv07HFRaOqw6a4XCe/Z0avTKEcUJnp6
bImZ5qAekxqRoRZRmDJhudx0mINqV2uqp4mKwYqpP/xjPRyUTr34P6auGNT/
luxs0MZB0WOjgRJeYlA75l110HsO8mzbe7n8ghg0Kg4vVKvlIEb1s4eBFWLw
m5NGECjnoOX5aq0rforBVdwzq+oKOGjmytnZD3RxSLdviL1/h4Najg+onLUQ
h7cklJSHEzjoofceaBQkDl8ovBKJ5nFQws4y38FUcagwmiXjEcxBhzcrxt5p
EIfujuYVYb4cZKN4Mt9hVhwenaaqv2FykJZI9zvxdRJwqCiabmPOQZT+HaNP
nCTg9sU7Bsc2cVBvUyE9kCcBYxuM88uUcW+5vNGKEglY5H9kKEaSg+6mh3l8
6JCAcae29XiNsVF0XPvJM1Jk6NSq6Lr5Gxt5BcG7hsZkKPgelzZWy0YM16yX
AxwyTFg/lXa9kI2UILU/NYkM7b0jX9OustHMOq60QzUZisF7S5zC2ahFrkVH
fIQMZe5J/2Z6slHZtJHjE1VJaLafdnx+GxsldKWGHdgtCV0/W1F3q7FR0CvR
W6rHJWGN1li6BomNbIqJyqZsSZh+5lA2r9MPad94KzjdIglT3rhN2T3zQ5So
zeKGohRYlPamLeK6H+rjXF83oEOBIZztlEmuH6q1+7MrdR8FZmbfu1mwww9l
GrAO21+gwO6JSql4VT8UveLlFbEKCjxqMmd0etQXschajx73UmDU3AOnEzW+
iDF86UsAfREsUtrYy77qi1Rax/+oWCyCyfQHNeu8fdFMpevKJu4iqKG1VOa+
ti9qyaq0OJ26CN4TrtfomvRBZRdXcwwaFsHHec0l2c99UFJo7Ln+mUXwo/Sn
mMFoHxS0b6gwRYMKq1u3lyZZ+CAba4emPU5U2Lb6UWCciA/S3vh4XJRHhfs3
d1IKK72R9FLlZY+LqdBlUnq+O8wb9QmjTAI6qNBRh9q6ZKM3qu3p2aciJQVl
uu6orRCwUObbnafeG0lB0Hc3uOcyC0WXFWXyOFJwrj3RcweDhVgpS+q3JklB
ha49xTZv9iPGmfDBviop2BjRdp5P349UDnbIpvySgkLKbX6GixeacbTYskdV
GjKY6/cVJO5DX0xznEV3S0P/m2jqyktPVLZG+vijcGlo92DyHGXEAyVJHUnx
z5aG2VVGfnx5DxQ0/omv3CINgyIUJf203JF9u0l3o4gM7D1oJZVh7Ia0a9LI
PB0ZWKakK7oCuCLpAnGtrftkYK160N4oExfUlxhg23deBq6ty9TibNiLaiMa
g26Xy0BNttAgSN4ZZfroJdn1ykDBF0aW4ZAjOrMr+YkIXRZuctg5yHzGRKwt
f9vKzGXh6jjFTKeTDoih5DNHcGWhO0OBaNC3Ryqir1Ypp8pCJ36K6enntkjY
v8G68Q126K/iiIld6MuHBP9TM7IwUtndNJr2P1RWMXlBX0MOlo8/irooZ42S
MtyLfzrKwXrrZNvEEXMUco7/8dYpfJ5D+6fPzwzZH1k7ZVssB40aWOdVcg2Q
tts5RZEOOQibr62qstdBMWrHVrhL0KDAJvJGRJ0aCktaX6KnQoOkuZoObu0A
34/yzVxGD9vgnbwTWQUyIy819+6kwfSLBrWetpugxQhkIxYNjshR+BIphlDX
b3zq5jEaTLBbpb1rC4QrvmTFBV+iQRqhxyyvsoKyNq5Ktln4eeY66OeJnXCO
Ty3UeE6D/ixBKc/fDg7pVZqRmvHvNzKHM6ocYFsO9/3Xfhp04glP/SGc4Bvl
1d6lJHmYnG/eydB0gU8vt4zFL5OHAod5KS8xd5grFnuGs0ke/h8GAgaJ
               "]], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"melting curve\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.46870841487279835`, 0.9151076320939342}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{-122.46299999999997`, 1.6811876571544468`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"critical point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.43992172211350244`, 0.6968297455968695}]], 
              GrayLevel[0.257923], 
              PointSize[0.021], 
              PointBox[{-189.34419999999997`, -0.16755412353428056`}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"triple point\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.3004109589041098, 0.40590998043052906`}]], 
              GrayLevel[0.5343678000000001], 
              PointSize[0.021], 
              PointBox[{20., 3.3875862701648884`*^-6}], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"STP\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                  LineIndent -> 0, 
                  GrayLevel[0.6], StripOnInput -> False], TraditionalForm]], 
               Scaled[{0.5659197651663405, 0.47682974559686975`}]], 
              RGBColor[1, 0, 0], 
              PointSize[0.021], 
              Thickness[0.003], 
              PointBox[{{20., 0.}}]}, {GridLines -> Dynamic[
                Map[{{#, 
                   GrayLevel[0.7]}}& , 
                 MousePosition[{"Graphics", Graphics}, None]]], 
              Method -> {"GridLinesInFront" -> True}, AspectRatio -> 0.8, 
              ImageSize -> 300, PlotRange -> 
              NCache[{{-273.15000000000003`, 226.85000000000008`}, {
                 2 - Log[10]^(-1) Log[101325], 9 - Log[10]^(-1) 
                  Log[101325]}}, {{-273.15000000000003`, 
                226.85000000000008`}, {-3.00571661241373, 3.99428338758627}}],
               Frame -> True, PlotRangeClipping -> True, FrameLabel -> {
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"temperature\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"\[Degree]C\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm], 
                FormBox[
                 FormBox[
                  TagBox[
                   FormBox[
                    TemplateBox[{
                    TemplateBox[{
                    StyleBox[
                    "\"pressure\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily -> "Verdana", FontSize -> 10}, 
                    GrayLevel[0.5], StripOnInput -> False], "\"  \""}, 
                    "RowDefault"], 
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"atm\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}, "RowDefault"], 
                    TraditionalForm], Format[#, TraditionalForm]& ], 
                  TraditionalForm], TraditionalForm]}, FrameTicks -> {{{{-3, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-2, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {-1, 
                   FormBox[
                    TemplateBox[{"10", 
                    RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {0, 
                   FormBox["1", TraditionalForm]}, {1, 
                   FormBox["10", TraditionalForm]}, {2, 
                   FormBox[
                    
                    TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {3, 
                   FormBox[
                    
                    TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}, {4, 
                   FormBox[
                    
                    TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm]}}, None}, {
                Automatic, None}}}], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {}]}], 
     XMLElement["states", {"count" -> "3"}, {
       XMLElement[
       "state", {
        "name" -> "Use kelvins", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use kelvins"}, \
{}], 
       XMLElement[
       "state", {
        "name" -> "Use megapascals", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Use \
megapascals"}, {}], 
       XMLElement[
       "state", {
        "name" -> "Hide labels", "input" -> 
         "FeatureHighlightPhaseDiagram:ThermodynamicDataRP__Hide labels"}, \
{}]}]}], Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False}, True}, Typeset`aux5$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ThermodynamicDataRPSourceInformationNotes.html", "text" -> 
        "Thermodynamic data RP"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "5", "datatypes" -> 
    "ThermodynamicDataRP", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "1.658", "parsetiming" -> "0.45", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa322320d803754170afc500002i6agg7327a257gg", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "19", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa322420d803754170afc5000028bcibgcaf5e37d8&s=19", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 12, 10, 10, 37.0833028`9.321753295589126}, "Line" -> 
    10, "SessionID" -> 23600748279209552654}, Typeset`showpods$$ = {1, 2, 3, 
   4, 5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Output", 
    "Quantity[20.84, \"Joules\"/(\"Kelvins\" \"Moles\")]"}, Typeset`open$$ = 
   True, Typeset`newq$$ = "isobaric heat capacity of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {920., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[17]:=",
 CellID->206466879,ExpressionUUID->"291e9dce-0e4c-4b45-878a-c974d314b5c5"],

Cell[BoxData[
 TemplateBox[{"20.84`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"K\"", 
     "\[ThinSpace]", "\"mol\"", "\[InvisibleSpace]", "\")\""}], 
   "joules per kelvin mole", 
   FractionBox["\"Joules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Moles\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[17]=",
 CellID->348051249,ExpressionUUID->"20826511-832e-46be-8bc6-22444136f67b"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"90f38145-d371-4600-99dc-0d9870fca00c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b28f0cc2-2ade-4f95-9ab3-4b65e9b0a0fd"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5960b215-e2b3-4fdf-8d27-620e261e5ff5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"bf196236-b533-4876-ac7b-bb7f6b34efef"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"1d178762-2852-4d4f-982b-2f22a8480e03"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "6f83069a-4410-414d-aec5-3c9832e64441"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"dd0357ac-20c8-4782-924e-add771807e63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"5a9e2320-0135-445d-862e-2227a23478a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7Cp", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "9"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigGaz", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RR", "*", 
       RowBox[{"CpAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "0.3"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", 
        RowBox[{
         FractionBox["5", "2"], "RR"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \"P\"],FontSlant->\"Italic\"]\
\) (J/mole/K)\>\"", ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FigLiq", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RR", "*", 
       RowBox[{"CpAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.7", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", 
        RowBox[{
         FractionBox["5", "2"], "RR"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[SubscriptBox[\"C\", \"P\"],FontSlant->\"Italic\"]\
\) (J/mole/K)\>\"", ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FigGaz", ",", "FigLiq"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", "ArT150p7Cp"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<CpAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"f2f2a9cf-9b0f-4151-9f0f-32ef46f40b2f"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U9oHF+W4HvXr9xVGspV7R/jnjFTOd1q2jAexk25QdMYxlSrGUP5US4Q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    "], {{0, 338.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 338.},
  PlotRange->{{0, 450.}, {0, 338.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->249172736,ExpressionUUID->"dadf87b4-592d-41e9-8763-4dbea4b1767f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"f61d022c-8183-4571-86e8-4e26d02607a7"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6e0fd7e3-801e-4cd9-ae21-7e69e17816f0"],
 "Possible Issues",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "87192044-410c-4157-93be-ad0ab1962281"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1305812373,ExpressionUUID->"7b43a53d-9c45-40e1-8ed1-317500369f17"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"13496cc9-0846-488b-95d8-02bda07136a4"],

Cell[TextData[{
 "Comparison of the ratio ",
 StyleBox["r",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubscriptBox["C", "P"],
    FontSlant->"Italic"], "/", 
   StyleBox[
    SubscriptBox["C", "V"],
    FontSlant->"Italic"]}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "9090b834-6aff-490e-b292-8bd46492e8c0"],
 " with Streett data (Physica 76, 1974) on an isotherm close to the critical \
isotherm"
}], "ExampleText",
 CellID->267386590,ExpressionUUID->"a110b978-d9fa-4128-b2a5-e66c85c40e9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"80", ",", "4.04"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "3.54"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"200", ",", "2.72"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"400", ",", "2.24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600", ",", "2.04"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800", ",", "1.92"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "1.83"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1200", ",", "1.77"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1400", ",", "1.72"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1600", ",", "1.67"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1800", ",", "1.64"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "1.6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2200", ",", "1.58"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2400", ",", "1.55"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2600", ",", "1.53"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2800", ",", "1.51"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "1.49"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"sans", " ", "dimension"}]}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"c2e45d72-0264-4600-8994-bc6e1561f6e5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dataStreett150", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"CpAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{
                RowBox[{"dataStreett150", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
              "]"}]}], "]"}], "/", 
           RowBox[{"CVAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{
                RowBox[{"dataStreett150", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", "1.01325"}]}], 
              "]"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"130", ",", 
          RowBox[{
           RowBox[{"CpAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"130", "*", "1.01325"}]}], "]"}]}], "]"}], "/", 
           RowBox[{"CVAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"130", "*", "1.01325"}]}], "]"}]}], "]"}]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"170", ",", 
          RowBox[{
           RowBox[{"CpAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"170", "*", "1.01325"}]}], "]"}]}], "]"}], "/", 
           RowBox[{"CVAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"170", "*", "1.01325"}]}], "]"}]}], "]"}]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"300", ",", 
          RowBox[{
           RowBox[{"CpAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"300", "*", "1.01325"}]}], "]"}]}], "]"}], "/", 
           RowBox[{"CVAdimNv", "[", 
            RowBox[{"150", ",", 
             RowBox[{"RhoArgonNv", "[", 
              RowBox[{"150", ",", 
               RowBox[{"300", "*", "1.01325"}]}], "]"}]}], "]"}]}]}], "}"}]}],
        "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"sans", " ", "dimension"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"r", "=", 
  RowBox[{"Interpolation", "[", "data150", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"d66b12be-eb95-4a41-bba4-1f8355be5255"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                    2.8089274370124926`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.4697777960852494`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                    2.8089274370124926`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.4697777960852494`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                   2.8089274370124926`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 1.4697777960852494`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 1.4697777960852494`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 1.469777796085246}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {1.469777796085246, 
               2.8089274370124926`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                    2.8089274370124926`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.4697777960852494`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                    2.8089274370124926`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {0, 1.4697777960852494`}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwBsQNO/CFib1JlAgAAADoAAAACAAAAsFtU8qBrZ0AwcrbyrngGQMyXcFGH
bGxAmUsU0BMRBUDgLnoIGypxQPOa3mM78wNAfV6NlAJedEB7TBltsOsCQPqQ
FLUyW3dAqCOlPac/AkAaEO0Bc5h6QBANlUHYkgFAWlWDwJPGfUDVIT8rNxEB
QL3Oxon+XoBAefh1aHutAEAemXRJu/qBQBxfr5vbUwBA72RcUxx7g0CHTbvt
sQkAQNETI5bt84RAuiIL4qyN/z8EaRLvxoyGQKbZegYqD/8/p787kkQKiEAX
QRH4vqf+P5u8jUvKp4lAvAxOwGVC/j+gnL49wD2LQAZkCdOP5v0/FH4pelq4
jEDe/6++OJn9P9oFvcz8Uo5Ab3SO4y1N/T8Qj4ppQ9KPQJcOueHkC/0/S19A
Dsm4kEBaPvBC+Mn8P5boKoSohJFAfoln02SO/D+ZcjIf2kKSQGiRD2HOWvw/
xU9OxQ8Rk0BZVYfYTSb8P6kth5CX0ZNA0jVjMNz3+z8VfS94V46UQIAPHGa8
zPs/qh/sahtblUDiRRuWQKD7P/bCxYIxGpZAs0kZim94+z9rubOlS+mWQMXy
gR+hTvs/aCER5Z20l0DIS45l4Sb7Px2Ki0lCcphAyzSBsLIC+z/7RRq56j+Z
QOfTBeYC3Po/kQLGTeX/mUCGt6AIDbj6P68w4f4XvJpAHfJsCheV+j/2sRC7
ToibQI7Inh5cb/o/9TNdnNdGnECRMLb7J0z6PxwJvohkFZ1A30UiM6gl+j/7
3juaQ9adQEQkK728Afo/YiYpyFqTnkAjZep2lN75P/LAKgF2YJ9A+3uimoC4
+T8drqSv8Q+gQKiDp3jnlPk/ViU+ZKp3oEBxW5FInW75P1NVDyd/3aBACI4b
RnNJ+T+sBW/8fDyhQHMlf9pJJ/k/md9Y13yjoUAhZRNx8AL5P+I50cSlA6JA
s2ml3MPh+D/vTIHA6mGiQAko2YcRwvg/kYm7wTHIokDB8LU6vqD4P49GhNWh
J6NAi9cIuuSC+D8hLdfuE4+jQGt2QivMY/g/d8xhFqL0o0Cohprwmkb4Pyns
elBZU6RAkwIIEKIs+D9vNR6QErqkQGsPf5sPEvg/Ef9P4vQZpUAv9DTek/r3
P0jyCzrZgaVAHEWSB4/i9z9Dnv+f2eelQKACxi1ozPc/msqBGANHpkDBpejK
Abn3P4UgjpYurqZAzlUT9Fel9z/M9igngw6nQH0W9B9ClPc/CVeD+f9vp0Bf
K+m4NYT3P1jVwWw=
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{80., 3000.}, {1.469777796085246, 
                   2.8089274370124926`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {0, 1.4697777960852494`}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 1.4697777960852494`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 1.469777796085246}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{80., 3000.}, {1.469777796085246, 
               2.8089274370124926`}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"80.`", ",", "3000.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{80., 3000.}}, {
   5, 7, 0, {20}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{80., 100., 
   130., 170., 200., 300., 400., 600., 800., 1000., 1200., 1400., 1600., 
   1800., 2000., 2200., 2400., 2600., 2800., 3000.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17, 18, 19, 20}, {4.144330603835857, 3.6281611709086024`, 
    3.211675838477384, 2.895839852119317, 2.738004871524922, 
    2.4164703182255427`, 2.2334885369277986`, 2.0226329330257697`, 
    1.9012050828904752`, 1.8214124762731652`, 1.7643277652471305`, 
    1.7198400580236084`, 1.6816575025878866`, 1.6453605252392467`, 
    1.6090223355382134`, 1.5731803093202998`, 1.5398818813414887`, 
    1.5111142790200645`, 1.4878080373746843`, 1.4697777922610271`}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->14123630,ExpressionUUID->"9e5ece55-c4b0-4805-955c-afeb428419f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", "[", "x", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "80", ",", "3000"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"pc", ",", 
        RowBox[{"5", "/", "3"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"r\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{"{", "\"\<CpAdimNv/CVAdimNv\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"c4b9e385-1d66-4043-80d6-2696138ba4d8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwV0nk41Iv3B/DZmLGF6HItCemKQoy6t9TnnVJCj4rIHrLvM8pOWoj2SGTf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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwV0nk41Iv3B/DZmLGF6HItCemKQoy6t9TnnVJCj4rIHrLvM8pOWoj2SGTf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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, {1., 5.}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {48.63, 1.6666666666666667`}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, {1., 5.}}, 
           "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {48.63, 1.6666666666666667`}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwV0nk41Iv3B/DZmLGF6HItCemKQoy6t9TnnVJCj4rIHrLvM8pOWoj2SGTf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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, {1., 5.}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {48.63, 1.6666666666666667`}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {48.63, 1.6666666666666667`}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {48.63, 1.6666666666666667`}, 
     DisplayFunction :> Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{80, 4.04}], 
        PointBox[{100, 3.54}], 
        PointBox[{200, 2.72}], 
        PointBox[{400, 2.24}], 
        PointBox[{600, 2.04}], 
        PointBox[{800, 1.92}], 
        PointBox[{1000, 1.83}], 
        PointBox[{1200, 1.77}], 
        PointBox[{1400, 1.72}], 
        PointBox[{1600, 1.67}], 
        PointBox[{1800, 1.64}], 
        PointBox[{2000, 1.6}], 
        PointBox[{2200, 1.58}], 
        PointBox[{2400, 1.55}], 
        PointBox[{2600, 1.53}], 
        PointBox[{2800, 1.51}], 
        PointBox[{3000, 1.49}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"r\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(atm)\"", HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, {1., 5.}}, 
     PlotRangeClipping -> True, 
     PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"STREETT (1974)\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{"\"CpAdimNv/CVAdimNv\""}, "LineLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[4]=",
 CellID->88288165,ExpressionUUID->"a5f8cedd-ea05-4ef0-a3b5-54a95db47f78"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["CVAdimNv"]], "paclet:NewEoSArgon/ref/CVAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "e04ff308-e6b5-4099-ae45-6830379cbd60"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0a0b763d-76d4-47c7-aa62-fdb74d820b33"]
       }], "SeeAlso",ExpressionUUID->"79ec0920-1a05-427d-8040-ea82b39ea7f4"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"e021aa6a-725c-4a02-b9b3-\
bc89d58a1deb"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "2620127c-f224-45ec-8093-a572c355a8ea"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"1d21d7d0-3e35-41c8-99b8-\
105dfdad1ab8"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "7c4a648e-e73e-44e8-baa1-9b1cf5e15264"]], "RelatedLinks",
        ExpressionUUID->"09d44842-bfd6-43df-ad38-84a12e890ad7"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "bd9b609c-d021-4ab8-a213-4c859428e714"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "c31c077a-0854-4568-a8bf-d62b1a56b7f7"]], "RelatedLinks",
        ExpressionUUID->"e233a45c-57d8-4a40-9683-47d30a3529c3"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"7b56eb21-1a30-49e1-a655-\
c8d682d849e9"],

Cell[" ", "FooterCell",ExpressionUUID->"578b348b-a19d-49ff-a43c-6bc2e4e7819a"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CpAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed, "3" -> Closed}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 27.4252290}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "CpAdimNv[T, \\[Rho]] \\[Congruent] CP/R Capacit\[EAcute] calorifique \
isobare adimensionnelle en fonction de T (Kelvin) et \\[Rho] (g/cm^3) \
[Non-dimensionnal isobaric heat capacity versus T (Kelvin) and \\[Rho] \
(g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "CpAdimNv", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "CpAdimNv", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/CpAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"7d3388dd-1c34-4ae6-9f2c-a7c1320aacd7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13640, 398, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"739d5ee4-8db5-4579-847c-4f8b16203ad6",
   CellTags->"PrimaryExamplesSection",
   CellID->138622761]},
 "RasterizedOutput"->{
  Cell[139366, 2828, 32498, 539, 359, "Output",ExpressionUUID->"dadf87b4-592d-41e9-8763-4dbea4b1767f",
   CellTags->"RasterizedOutput",
   CellID->249172736]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 242560, 4889},
 {"RasterizedOutput", 242760, 4893}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5290, 129, 56, "AnchorBarGrid",ExpressionUUID->"e723aee1-5106-4079-9eef-98ae695d894c",
 CellID->1],
Cell[5873, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"efa6faf6-38b2-4429-906e-46cb615a8268"],
Cell[CellGroupData[{
Cell[5992, 156, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"27baa914-4107-4861-8755-59d4e4fe34ec"],
Cell[6546, 172, 1196, 33, 146, "Usage",ExpressionUUID->"3d5c1e39-78b0-42aa-9e93-d209f5394df6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7779, 210, 1919, 48, 37, "NotesSection",ExpressionUUID->"b4dd017a-37d9-453b-9e5c-407312ab058e",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->117241156],
Cell[9701, 260, 529, 16, 38, "Notes",ExpressionUUID->"2e9d85a0-8b0f-431b-8462-276a9ff1da2d",
 CellID->1067943069],
Cell[10233, 278, 1321, 45, 39, "Notes",ExpressionUUID->"aa63baa2-4570-460b-8745-c4c547811191",
 CellID->524000197],
Cell[11557, 325, 186, 4, 36, "Notes",ExpressionUUID->"ae4ccd8c-0167-41a2-9210-402488ad6f7c",
 CellID->224665577],
Cell[11746, 331, 519, 16, 38, "Notes",ExpressionUUID->"90d29489-90a9-48ac-bb22-cb5ce3faabc4",
 CellID->51803587],
Cell[12268, 349, 1245, 43, 39, "Notes",ExpressionUUID->"41c63eee-9733-4bf2-b4e0-0ac6caa1e5aa",
 CellID->508850368]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[13640, 398, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"739d5ee4-8db5-4579-847c-4f8b16203ad6",
 CellTags->"PrimaryExamplesSection",
 CellID->138622761],
Cell[CellGroupData[{
Cell[15085, 439, 1397, 36, 30, "ExampleSection",ExpressionUUID->"db4df9e7-ce7a-4189-9139-8de003e45310",
 CellID->26338602],
Cell[16485, 477, 268, 5, 42, "Input",ExpressionUUID->"f9c999fd-c4fd-41d9-9a5b-7735307fd409",
 CellID->143015886],
Cell[16756, 484, 351, 8, 38, "ExampleText",ExpressionUUID->"03b4c6dd-d0e3-4abb-a6dc-0bf314bb37c6",
 CellID->544149791],
Cell[CellGroupData[{
Cell[17132, 496, 1127, 28, 57, "Input",ExpressionUUID->"c709137e-2a32-4809-8aa3-9fa2387a3b7d",
 CellID->5710145],
Cell[18262, 526, 697, 15, 45, "Output",ExpressionUUID->"5e1dd099-6e78-4787-97c2-f415e6deebfe",
 CellID->831068267]
}, Open  ]],
Cell[CellGroupData[{
Cell[18996, 546, 531, 13, 46, "Input",ExpressionUUID->"f0c19ad1-a860-4522-a00a-03300fb899d1",
 CellID->537072472],
Cell[19530, 561, 436, 10, 43, "Output",ExpressionUUID->"9522b5a6-75e4-4d3b-a323-dbceae0e3cc6",
 CellID->230442351]
}, Open  ]],
Cell[19981, 574, 154, 1, 38, "ExampleText",ExpressionUUID->"2d79d26d-06a4-4494-8a1a-357f8773bdaa",
 CellID->361149294],
Cell[CellGroupData[{
Cell[20160, 579, 674, 15, 42, "Input",ExpressionUUID->"155b3734-1427-4d8c-96c2-80af3777af2c",
 CellID->375583457],
Cell[20837, 596, 435, 10, 43, "Output",ExpressionUUID->"6afd9833-fd87-4256-b7e0-75fbfc45b7cc",
 CellID->79174414]
}, Open  ]],
Cell[CellGroupData[{
Cell[21309, 611, 111371, 2020, 956, "WolframAlphaShortInput",ExpressionUUID->"291e9dce-0e4c-4b45-878a-c974d314b5c5",
 CellID->206466879],
Cell[132683, 2633, 424, 10, 43, "Output",ExpressionUUID->"20826511-832e-46be-8bc6-22444136f67b",
 CellID->348051249]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[133256, 2651, 1419, 37, 70, "ExampleSection",ExpressionUUID->"bf196236-b533-4876-ac7b-bb7f6b34efef",
 CellID->258228157],
Cell[134678, 2690, 174, 3, 70, "Input",ExpressionUUID->"1d178762-2852-4d4f-982b-2f22a8480e03",
 CellID->87419684],
Cell[134855, 2695, 401, 11, 70, "ExampleText",ExpressionUUID->"dd0357ac-20c8-4782-924e-add771807e63",
 CellID->227520913],
Cell[135259, 2708, 464, 13, 70, "Input",ExpressionUUID->"5a9e2320-0135-445d-862e-2227a23478a7",
 CellID->531122037],
Cell[CellGroupData[{
Cell[135748, 2725, 3615, 101, 70, "Input",ExpressionUUID->"f2f2a9cf-9b0f-4151-9f0f-32ef46f40b2f",
 CellID->136921489],
Cell[139366, 2828, 32498, 539, 359, "Output",ExpressionUUID->"dadf87b4-592d-41e9-8763-4dbea4b1767f",
 CellTags->"RasterizedOutput",
 CellID->249172736]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[172013, 3375, 1423, 37, 70, "ExampleSection",ExpressionUUID->"7b43a53d-9c45-40e1-8ed1-317500369f17",
 CellID->1305812373],
Cell[173439, 3414, 175, 3, 70, "Input",ExpressionUUID->"13496cc9-0846-488b-95d8-02bda07136a4",
 CellID->279378555],
Cell[173617, 3419, 552, 18, 70, "ExampleText",ExpressionUUID->"a110b978-d9fa-4128-b2a5-e66c85c40e9b",
 CellID->267386590],
Cell[174172, 3439, 1514, 44, 70, "Input",ExpressionUUID->"c2e45d72-0264-4600-8994-bc6e1561f6e5",
 CellID->243734080],
Cell[CellGroupData[{
Cell[175711, 3487, 3141, 85, 70, "Input",ExpressionUUID->"d66b12be-eb95-4a41-bba4-1f8355be5255",
 CellID->123312038],
Cell[178855, 3574, 29556, 572, 70, "Output",ExpressionUUID->"9e5ece55-c4b0-4805-955c-afeb428419f1",
 CellID->14123630]
}, Open  ]],
Cell[CellGroupData[{
Cell[208448, 4151, 1999, 55, 70, "Input",ExpressionUUID->"c4b9e385-1d66-4043-80d6-2696138ba4d8",
 CellID->283061935],
Cell[210450, 4208, 26036, 521, 362, "Output",ExpressionUUID->"a5f8cedd-ea05-4ef0-a3b5-54a95db47f78",
 CellID->88288165]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[236728, 4738, 1367, 36, 70, "SeeAlsoSection",ExpressionUUID->"e021aa6a-725c-4a02-b9b3-bc89d58a1deb"],
Cell[238098, 4776, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"1d21d7d0-3e35-41c8-99b8-105dfdad1ab8"],
Cell[238830, 4797, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"7b56eb21-1a30-49e1-a655-c8d682d849e9"],
Cell[240440, 4842, 78, 0, 70, "FooterCell",ExpressionUUID->"578b348b-a19d-49ff-a43c-6bc2e4e7819a"]
}
]
*)

(* End of internal cache information *)

