(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     92117,       2024]
NotebookOptionsPosition[     85856,       1898]
NotebookOutlinePosition[     88183,       1956]
CellTagsIndexPosition[     88097,       1951]
WindowTitle->FtotalAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "fe2b4e9c-0a6b-4e08-b4d9-61a2c43f07e1"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "d596c730-c550-4745-8ed7-efc2882cc215"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "5da89c45-cb6c-4526-b63f-198890b8b15e"]
         }],ExpressionUUID->"1d4b4256-2480-4ac1-aa28-7130046d00de"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"UtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/UtotalAdimNv"], 
         "\"StotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/StotalAdimNv"], 
         "\"dFtotalAdimNvdT\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/dFtotalAdimNvdT"], 
         "\"d2FtotalAdimNvdT2\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "836f05ef-c6ec-4c84-b40f-6efc3506aafb"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b80e1472-92f4-403a-92b1-0da4ee90a1e0"]
         }],ExpressionUUID->"022d459e-acb3-404e-8a72-0af8d82ce759"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1b00998c-233b-4bca-a59a-b8150ede2024"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "f40946e4-be79-4c08-b569-64c15bda5950"]
         }],ExpressionUUID->"41509b40-19ea-464e-be40-c43864ca0743"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/FtotalAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/FtotalAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
FtotalAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$14556], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/FtotalAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "797b9a7a-40d9-410c-bbcc-fc6c5ab83e94"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "26d4c963-9017-4b83-a402-d2f4c54f3e4f"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"d8933b43-8e35-4ac8-bc84-3bb81e1fa463"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"e485043e-3d1b-497d-bb29-1ae8a66fac1c"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "FtotalAdimNv", "ObjectName",ExpressionUUID->
      "1263deb6-7cc3-4bb5-b6b5-5f7353cf82c1"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"eb44383e-a48e-4efb-8640-e7ef0ddf2f65"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "61217332-e88b-49bd-a484-5913637b5cc3"]
    }],ExpressionUUID->"6fc7c87f-b94e-4beb-b8e4-7faebd78c9da"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"1b80a234-45fa-42f1-9162-\
fdaeef79e2fe"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "FtotalAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["F",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     "\nEnergie libre adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "81117dbd-8c2d-4714-a737-5c26ffb2533e"],
     ")\n[Non-dimensional Helmholtz free energy state function versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)",
     " and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "34243299-110c-4f45-a363-a1880512ec0d"],
     ")]"
    }],ExpressionUUID->"b22fbc4f-437c-477e-b176-5ed9a1887d4e"]}
  }]], "Usage",ExpressionUUID->"95c75606-a79b-4885-b0eb-0331b44f6ebd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"dd053c80-042d-47c4-adff-83fd6d3bf16f"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"27ab3547-4dc3-4b28-9605-3bcf986e0257"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"6c73391c-c96e-48db-9bb3-d24bb09ddfcd"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"4c2d8327-6e9f-4433-8407-4c589aeeefaf"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->234317055,ExpressionUUID->"4aac22f9-4f8e-4e8e-80b4-cf0b205dfb28"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"9ea45414-26ac-47ed-a7ca-15219723a698"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"b79b88c6-8f0b-4e60-9f4e-7fa4f949faf8"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->17987804,ExpressionUUID->"640fe8ce-bea5-48a8-8967-c837d50db377"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"44e06d08-2db0-4e7b-ae17-eff0cd603433"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2db6e3eb-41fd-43ec-8fed-3bd0987051db"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "4fe4ea02-4dc4-4c98-a419-074bc0625924"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->100460182,ExpressionUUID->"36593907-cb23-4051-bdf6-93f5a15ea437"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b3080c80-fe93-4ad2-ba3c-4d3f00aec782"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"80abbd21-eba7-456d-bc8a-3e90a9edcd62"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f36e178f-8914-4dc2-b7f5-246a088ea477"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->18931106,ExpressionUUID->"ea92ec57-bd53-4517-96e0-390f67d08de0"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"d6ac7615-4d7c-4474-9595-1eabaf0edafe"],

Cell[TextData[{
 "Calculated value of ",
 StyleBox["F",
  FontSlant->"Italic"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"e2c80896-015d-4a21-9a88-12a138e4888f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "[", 
  RowBox[{
   RowBox[{"FtotalAdimNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   "*", 
   RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}], "/", 
    RowBox[{"Quantity", "[", 
     RowBox[{"M", ",", 
      RowBox[{"\"\<Grams\>\"", "/", "\"\<Moles\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"9226264a-b2a3-4607-a9d1-5b70002e4365"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1.0413788902561017`*^6"}], 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"]}], "meters squared per second squared", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->342793858,ExpressionUUID->"6598f2fd-ca12-464a-9254-c7c5115dd199"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{
     RowBox[{"-", "1.0413788902561017`*^6"}], ",", 
     FractionBox[
      SuperscriptBox["\"\<Meters\>\"", "2"], 
      SuperscriptBox["\"\<Seconds\>\"", "2"]]}], "]"}], ",", 
   "\"\<Joules/kg\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->99414461,ExpressionUUID->"e90fbb6e-1292-4f0f-9201-8be1887ad27e"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1.0413788902561017`*^6"}], 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"kg\""}], 
   "joules per kilogram", 
   FractionBox["\"Joules\"", "\"Kilograms\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->125483856,ExpressionUUID->"37b205ba-16e3-4fda-9ee6-355cd2e5e08c"]
}, Open  ]],

Cell["Free energy on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"77a36428-7885-4857-82e5-5002eeb99760"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"FtotalAdimNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"F\",FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"RT\"\
,FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->605199954,ExpressionUUID->"a68b54f4-306f-496d-9a5a-6bb3f571435e"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJw92Hc81d//AHBEGpSMhmS7y6qQmVd9skopIytaKhFRtlCSMlKSkb1DiCJC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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJw92Hc81d//AHBEGpSMhmS7y6qQmVd9skopIytaKhFRtlCSMlKSkb1DiCJC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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 
           1.4168017335853793`}, {-13.32966312988528, -11.154524723232724`}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, -11.033683700640939`}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 
          1.4168017335853793`}, {-13.32966312988528, -11.154524723232724`}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, -11.033683700640939`}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJw92Hc81d//AHBEGpSMhmS7y6qQmVd9skopIytaKhFRtlCSMlKSkb1DiCJC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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 
        1.4168017335853793`}, {-13.32966312988528, -11.154524723232724`}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, -11.033683700640939`}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, -11.033683700640939`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"F\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
StyleBox[\\\"RT\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 
   1.4168017335853793`}, {-13.32966312988528, -11.154524723232724`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[4]=",
 CellID->777988572,ExpressionUUID->"af9a06b4-0a9e-4b6f-802e-fb11091ffa8c"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"2f165cf9-b475-4865-94ca-d7340cecbabc"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5ffcd6f0-b48c-4c3f-aeb8-5475d72a768d"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "6f4c2fe5-0f61-427c-87a3-8b5e5f9fd4e6"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->85045054,ExpressionUUID->"b9bfc617-4509-430d-87b0-258623ba9728"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"e0162986-9f56-4f27-99cd-a0dd7831c358"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "b1d284b8-efa4-4ddc-bc18-a67c1f74541a"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"297c6eee-1866-444b-be12-65a27c4795ca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"ff36fe25-9921-4c94-9b12-03b312c39eab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7F", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"dataNIST", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "5"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"dataNIST", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", 
         RowBox[{
          RowBox[{"dataNIST", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", "1000"}]}]}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"RR", "*", "150.7", "*", 
      RowBox[{
       RowBox[{"FtotalAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}], "/", "1000"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"F\",FontSlant->\"Italic\"]\) (kJ/mole)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7F"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<FtotalAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"883b1ea3-b866-41f2-9cbe-d40bccbab565"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwVlHk0lQsXh4VQIjQaKmXIOed9j3MOibi2qZkM0aUMkaQQEpkaDB+SIi4h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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwVlHk0lQsXh4VQIjQaKmXIOed9j3MOibi2qZkM0aUMkaQQEpkaDB+SIi4h
lUzxpSJxEdqEzJmHREiuIZJrehv4fH/stdezfuu31/PX3mnnanKWm4uLq2pl
/r+z1Bqbpku5IC7Lc8p0sxoGetqdWkdow5OF4HiJ2D2YL/i1XSrDCM6rFWYs
oTJmfpT3VyowB3Ol56nJOsrY1JkjKnfmNHDsFZetR5XwEBw7y3Kyh/P/OOfK
pihhxZOJQnUPR/jwkGdrtqMSaojcXHfQzxlSrURNBFWV8JTGBlaWthvM2bo1
jQopYfz0YM/z/Zeg6I8DQ2WjHGxPywl6dfgybJObTQ18x0FRi+tksYEXBKR1
qXpmcfCY0LGuN8besLZ33HnNHQ7eKpcKqDLzhQWBwK62yxys8Zyg11v4Q/pP
y74bVhzc6aoHE6wboD7nti1EiYNatYyNU5wA8DhjOOcvzUFrmQ1j08qBYLfz
8fE7whxM7BqMnlcNhsi8bK9bk2wsZNeeo/b9Bxz41jgf7Gdj160cjV8aIZDe
tuNZyXs2btS6PrJKOwxG6QddYl6xkZPo8JpX9yZ42+ss9Txho/GsQRT//nB4
9FjdNvU+G+9kSu0TOhwB+hW9uvHBbAwW6DsQoRAF5NLxM5xTbIzJN8q9nRUF
PKU5zs+N2ZhiVykZSb8LtjoK8Z6H2Fhe8nT6LhEN4xm2+u0qbFxy8028x/oL
kvtErC9uZqPQ9inehNy/YMB1NLtXmI1S9bauiZxYqOTZle3Dz0Z1ucN6D5Tj
4LbKnteaFAu9e7ZMpajGQ4WTEFnQz8LQkFvmaUXxYJg11eDWzcI4peWK9H0J
8JesbLBBKwvzb4/cy9RIhOST9JFz1Syc0c7Xfq6VBBbdZ/WXX7BQxSyrzlI2
GToPBFZ/CmVhJhHleeRCMgRF7l73IZCFkrxXpFVzkoGY0uCbuMpCrjw9rw0a
j+GaqxVx7DIL60QGdtYdT4FFztdnfHYstG7Y7LM3KA3CR0J+VmixsDn1t4xc
bRoENusYDmiwUNdvuElsfTrwPh5+J6jGQgX6S9mpxHSIzhPIv8Ve8Qs1aE57
mQGDIdfE5WVYGKIbvFtsKBPylta7BAmwcFHCqXV5dxbE7awbtlrNQqcZ46uT
LlnA3WO6SoebhUaPd7TVUFmQwLR9pr+oiBLLxdeuiz6FOztIyVcDivi8+HvH
V61nMHlS6vidV4o4Ea9Y8fl9DuiY8sRcdVBE+s0I15vTOdC5y0de304RHX3G
pBRFc8F+UH1RxloRhy1Sr/ia5MK1yaTaKTNF/CixhRTtyIXffXoek/sVsSFp
6Z7mh5fw6cq2Jx67FTE7udElYfgV1Ev5J45+Y+J4FF0SVudD+K/J5oyvTFQI
CK0ZlssHvu5BbqcxJqbZasuwzuVDgsrh9as/MzFpV3539Vg+DD2T77zaycSI
tCTd2akC8Kq84OtRxkSXTCdxQ6oQLJ9+7eOPZmKn5KoOI/Ei8ONVpl+OZKJm
ZFyUiVoROKV98B2OYKKwVzn/CZ8ikNuqzNUSysQc3S3zllQR5NbPB3VfZeJM
f0XrBaoYsu74EgkXmOi9SSIihCqBmFNsr/QDTBwIe3EwTLwURMtlJ27oMfHw
Lz2ecLVSqD2UYGGjw0SJz66+t31KodMuWUBOk4mvc6oc/6JKQcSQ72frHiYu
HXXfn0KVQfZHldY8OSbqaNsv9/sj9O5oEbLjZyJbPVFC/Q7COT5FwQurmSi9
p3nPvUcrefVw4WWelb6ChrNhBUJ6qIdw9DKJRSIbe97wl8O89N+rvy6QyBp4
+zI5uhw237D03jpG4o7rMg52mRWQv/hJjt1IorCPRUBZUQUk3T6m9596En9d
ikySqK8AxvotPr21JH5w+NnaOlkBNfOtm+5Ukxh3rA10ld7Cb9PoF4K40t8e
JC5b9has3Iakz+at9EuGGr60VcJ+JUar930SSR8hU/HhSih/wX10ZyKJ1ntU
e/VnK+ERf41KfTyJ5c9uj+VtrILmpSYrmTgSQx6q8gWaVQGG9WQNR5EoeuMO
bO+qAsPVC0eyQkiU19338sSHavCaF1QiPEj8c9leLXy8GqSFtn5Zcicx7HUk
lv6ohi8Zb2pa3UicUPrSJCv5DujNLduuXSQxRzZqYubUO6j6w65p6DyJ+/hG
ZCP73oGmYvv7odMkGtbevfduoAb6JTfsfWlIYknVbssTMzWg2+z48u4xEhUq
SqW/8NRCl1qGxSUDErlej2Vx764FS2a/7N6jK/eztUv+cKmF+Csq15oOkCgS
9X0gj6qFtvaYdxxNEptPGNOTxeohczaysJok0XhYpNRbrxHspvUfNa4n0WTX
27B8s0Youff23LQwiaanPU1nHBrhZtnqXxtW+MTHngmnm41gO9odZLWOxJPt
KRI2TY3AnImZpQRItK9U9t5v3gQJcVXX/uQm0TvNXEnM+T2YD/g9fzhHoCGn
ub2jthliVV35mf0Eur1Mnf7U0gyPqpaSwvoIjOZcWTfe0wwup43yP38ksJOz
XW9prBncrfic7/cSaK3knCe/tgV+WgQMifQQ6KwsEH3lSAu84DP239BOYJiK
lqF4fQv4mrk2edQRWL4vp9ayoRU81tt4hhQSyHVKLXhjRyssVhSazfxNoJZf
hWZDXyusmXuQbb3CZa/b89S/tcLXkbUlqgUEFmtQDyTE2uC0eNzxmTwCX2nq
XOr+sw1+xQ4s+r4gMEOnXcL0cxt85Enp6c8gMPzIotPRH+2w3ep2S3ccgeP1
fh8vcndAKdt7yGGFjxos60ev7QDeun915mIJXGfEx+yR6ACeUffvYit822zj
tIN6B9DdXH4ZxxAYdZp1OdC/A6S14sP7IwmM9XL0L1rqgLorbomKNwlMTumO
2M3TBevjLSRT/Qk8RWrfrVzVA94vnEJbHAh0eSOqW8vohaUA5sZHJgQ2JPh6
vGb1Qb7xnP0FHQID/Y4ab7L9BDq/PAaYSgROHTRZE/92AGI8jkzS5AnUmT9C
k6ochHtrpXM9JAnUzlzYYfphCHyi1jbuEiXQ4dp0B3f/Z7gaazkeJkDgXvMH
dmcXhiFnUEFZnmvF56iwbabgCNiUJVrlLjIw3a5+u53QPxB5Wtfv8AwD71/V
yHsvOwrscYnB2gkG/l1C8b2ijUHm+FDh8hcGym3ya/CmjUOTdkfupQEGgnuO
43fNCZASogTOf2Dg9e/sygHtr+BuKT1+v52BTp7n5oNOToKbUnbPXCMDs8Rs
E/kvTkHj/QjjgWoGCrdn/F7l+g1kD8rQ7r1hYJR+s2S3zjTks/6E0gIGEtoe
8eOV0/DTzbX69DMGuussGrjofYd9rMk9CykMjNjfNVXb9B0agrtb18QxsPik
5bdBwxlIr3TVVw5jYJm7em9b7wx80vJ8+tOLgR2JKB9g/S+8cfuRFGrPwNjm
3U8f9v8LyXNiMd8MGcgQGJOIOz8LAdOltj4qDGw3Nho/NDELvW9teLwlGXj8
gWh6x5U5YLL/4Tb5QUe/uVfxravmgd3IXXe9g44FNksT4YHzEFlnum3NCzq+
q39M3ya8AKG/g+3Cb9Bx4vBEzYWoBQhjDT6yMaJjUfvmZAWRRegptvlxUYqO
lrZJdpi4CKfaIy1d+mkoxlUTvEGKgg7dN0pVD2nIDKj8YbqdAr1LT43vP6Dh
Ee5ytzhpCqiLR/91S6JhEG+xpbgcBSbluSiRSMNZgWzlHUwKXDutrzrG0rBT
NGqYrkWBxxfy0NdbNEyUMdfTsafA5oKfW4w3DQvSTIuDHCg4s38iwuIKDVvl
jFlVjhQ0hOrL7fCioaDCEalDLhRs/T1ek+lBQ39CY9bAi4Jz6i3t+RdpK/9c
Os0ijIKRVqPaAnsa+hZISdwPp+CB/Ejo5TM0jNsrHvUxggIh+dgyth0N36uJ
+dvcpeDLN4OY/9rQUEuT1/RsIgU3u6PbYk/S0PINV11GEgXubZb6hhY09Nb6
DaMPKRgqsVEXMKdhjs48wymVgj/+2eXnbUbDhrczj7PTKRgYd65XNKXhqN63
LVNPKGBzeO6OmNCQt3rituJ/V3w3Pa1PMqbhzoOjPO7ZFFwSpPuZGNHwf+zj
Gz0=
               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.535599, -11.9663040492291}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.535599, -11.9663040492291}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwVlHk0lQsXh4VQIjQaKmXIOed9j3MOibi2qZkM0aUMkaQQEpkaDB+SIi4h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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, -11.9663040492291}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0.535599, -11.9663040492291}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.535599, -25.08723345158213}, 
     DisplayFunction :> Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{0.0000319, -25.088864999999995`}], 
        PointBox[{0.0000638, -24.221033000000002`}], 
        PointBox[{0.0000957, -23.713274}], 
        PointBox[{0.00012756, -23.351793999999998`}], 
        PointBox[{0.00015946, -23.073199}], 
        PointBox[{0.00019137, -22.844234999999998`}], 
        PointBox[{0.00022328, -22.651539000000003`}], 
        PointBox[{0.0002552, -22.484361999999997`}], 
        PointBox[{0.00028711, -22.335368999999993`}], 
        PointBox[{0.00031904, -22.20446}], 
        PointBox[{0.00063851, -21.335014}], 
        PointBox[{0.00095842, -20.827348}], 
        PointBox[{0.0012788, -20.467268}], 
        PointBox[{0.0015996, -20.187158999999998`}], 
        PointBox[{0.0019208, -19.959695}], 
        PointBox[{0.0022425, -19.765485}], 
        PointBox[{0.0025646, -19.598301}], 
        PointBox[{0.0028872, -19.450808}], 
        PointBox[{0.0032102, -19.318285}], 
        PointBox[{0.0064655, -18.450476000000002`}], 
        PointBox[{0.0097676, -17.942939999999997`}], 
        PointBox[{0.013118, -17.581882999999998`}], 
        PointBox[{0.016519, -17.302404}], 
        PointBox[{0.019972, -17.072956}], 
        PointBox[{0.023479, -16.879876}], 
        PointBox[{0.027044, -16.712715}], 
        PointBox[{0.030667, -16.563837999999997`}], 
        PointBox[{0.034351, -16.431938}], 
        PointBox[{0.0753, -15.554097999999998`}], 
        PointBox[{0.12749, -15.024529999999999`}], 
        PointBox[{0.20492, -14.614356}], 
        PointBox[{0.71774, -13.974371000000001`}], 
        PointBox[{0.8327, -13.933292199999999`}], 
        PointBox[{0.87947, -13.9168379}], 
        PointBox[{0.91145, -13.9049216}], 
        PointBox[{0.93632, -13.894972199999998`}], 
        PointBox[{0.9569, -13.8863942}], 
        PointBox[{1.0764, -13.820832100000002`}], 
        PointBox[{1.1436, -13.7672954}], 
        PointBox[{1.1924, -13.717749599999998`}], 
        PointBox[{1.2313, -13.67019}], 
        PointBox[{1.2641, -13.6240522}], 
        PointBox[{1.2925, -13.5789505}], 
        PointBox[{1.3177, -13.534663899999998`}], 
        PointBox[{1.3405, -13.491078399999997`}], 
        PointBox[{1.3612, -13.4479842}], 
        PointBox[{1.4449, -13.2386895}], 
        PointBox[{1.5084, -13.0364386}], 
        PointBox[{1.5603, -12.8392044}], 
        PointBox[{1.6046, -12.6457015}]}}, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"F\\\",FontSlant->\\\"Italic\\\"]\\) \
(kJ/mole)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
          HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150.7 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"NIST database\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"FtotalAdimNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->40361074,ExpressionUUID->"fb6c79e4-664a-4843-a2c1-06a3a44efad2"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "98735d71-0b71-4362-a461-b62ae987942a"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "094132ca-cebb-41b9-bb55-aaa79f7cf4f6"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["StotalAdimNv"]], "paclet:NewEoSArgon/ref/StotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "429d59ba-af1c-4212-b7a5-f4bfbdbfe6ec"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["dFtotalAdimNvdT"]], 
           "paclet:NewEoSArgon/ref/dFtotalAdimNvdT", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "5967a1f0-8fee-4b69-b2ac-93390d24949d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["d2FtotalAdimNvdT2"]], 
           "paclet:NewEoSArgon/ref/d2FtotalAdimNvdT2", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a91b28a7-c6fe-4bd1-aa28-4d92ac05da95"]
       }], "SeeAlso",ExpressionUUID->"ad72df5a-da7d-4615-bb61-6f6e6c8e450b"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"371ab2ea-b20d-4617-9856-\
35aa5a6b0033"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "a2d4f95b-ff56-4a72-8549-cd437a6a9f6a"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"0a0149da-6cc9-45ec-b524-\
9712b00a3589"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "193ede1d-1d3e-455f-af77-a8969c3b1a82"]], "RelatedLinks",
        ExpressionUUID->"0b36e506-1c2b-4602-ac54-e0f61ba70635"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "5962f0bc-fbe2-4761-992a-391375e8eb20"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "ff1f0869-35a4-4ffb-a57c-f5d56bfbae0c"]], "RelatedLinks",
        ExpressionUUID->"f7b42422-372c-4538-b619-eaa6043af61e"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"15ed5eed-89eb-4d8e-885d-\
77b6b0647aa2"],

Cell[" ", "FooterCell",ExpressionUUID->"58b22070-ce41-4c58-91a4-a5101c275f02"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FtotalAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 37.2607873}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "FtotalAdimNv[T, \\[Rho]] \\[Congruent] F/RT Energie libre \
adimensionnelle en fonction de T (Kelvin) et de \\[Rho] (g/cm^3) \
[Non-dimensional Helmholtz free energy state function versus T (Kelvin) and \
\\[Rho] (g/cm^3)]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "FtotalAdimNv", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "FtotalAdimNv", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/FtotalAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"c4745fe3-d4ad-4556-8eac-e0f0e31d1a3b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10678, 290, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"36593907-cb23-4051-bdf6-93f5a15ea437",
   CellTags->"PrimaryExamplesSection",
   CellID->100460182]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 87897, 1944}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 5669, 136, 56, "AnchorBarGrid",ExpressionUUID->"d8933b43-8e35-4ac8-bc84-3bb81e1fa463",
 CellID->1],
Cell[6256, 159, 94, 0, 23, "ContextNameCell",ExpressionUUID->"e485043e-3d1b-497d-bb29-1ae8a66fac1c"],
Cell[CellGroupData[{
Cell[6375, 163, 555, 14, 56, "ObjectNameGrid",ExpressionUUID->"1b80a234-45fa-42f1-9162-fdaeef79e2fe"],
Cell[6933, 179, 1037, 30, 146, "Usage",ExpressionUUID->"95c75606-a79b-4885-b0eb-0331b44f6ebd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8007, 214, 1919, 48, 37, "NotesSection",ExpressionUUID->"4aac22f9-4f8e-4e8e-80b4-cf0b205dfb28",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->234317055],
Cell[9929, 264, 220, 6, 36, "Notes",ExpressionUUID->"9ea45414-26ac-47ed-a7ca-15219723a698",
 CellID->1067943069],
Cell[10152, 272, 186, 4, 36, "Notes",ExpressionUUID->"b79b88c6-8f0b-4e60-9f4e-7fa4f949faf8",
 CellID->224665577],
Cell[10341, 278, 210, 6, 36, "Notes",ExpressionUUID->"640fe8ce-bea5-48a8-8967-c837d50db377",
 CellID->17987804]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10678, 290, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"36593907-cb23-4051-bdf6-93f5a15ea437",
 CellTags->"PrimaryExamplesSection",
 CellID->100460182],
Cell[CellGroupData[{
Cell[12123, 331, 1397, 36, 30, "ExampleSection",ExpressionUUID->"ea92ec57-bd53-4517-96e0-390f67d08de0",
 CellID->18931106],
Cell[13523, 369, 268, 5, 42, "Input",ExpressionUUID->"d6ac7615-4d7c-4474-9595-1eabaf0edafe",
 CellID->143015886],
Cell[13794, 376, 219, 6, 38, "ExampleText",ExpressionUUID->"e2c80896-015d-4a21-9a88-12a138e4888f",
 CellID->544149791],
Cell[CellGroupData[{
Cell[14038, 386, 1285, 32, 42, "Input",ExpressionUUID->"9226264a-b2a3-4607-a9d1-5b70002e4365",
 CellID->5710145],
Cell[15326, 420, 480, 12, 43, "Output",ExpressionUUID->"6598f2fd-ca12-464a-9254-c7c5115dd199",
 CellID->342793858]
}, Open  ]],
Cell[CellGroupData[{
Cell[15843, 437, 435, 12, 46, "Input",ExpressionUUID->"e90fbb6e-1292-4f0f-9201-8be1887ad27e",
 CellID->99414461],
Cell[16281, 451, 361, 9, 45, "Output",ExpressionUUID->"37b205ba-16e3-4fda-9ee6-355cd2e5e08c",
 CellID->125483856]
}, Open  ]],
Cell[16657, 463, 143, 1, 38, "ExampleText",ExpressionUUID->"77a36428-7885-4857-82e5-5002eeb99760",
 CellID->286706321],
Cell[CellGroupData[{
Cell[16825, 468, 961, 24, 46, "Input",ExpressionUUID->"a68b54f4-306f-496d-9a5a-6bb3f571435e",
 CellID->605199954],
Cell[17789, 494, 28778, 524, 274, "Output",ExpressionUUID->"af9a06b4-0a9e-4b6f-802e-fb11091ffa8c",
 CellID->777988572]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[46716, 1026, 1418, 37, 70, "ExampleSection",ExpressionUUID->"b9bfc617-4509-430d-87b0-258623ba9728",
 CellID->85045054],
Cell[48137, 1065, 174, 3, 70, "Input",ExpressionUUID->"e0162986-9f56-4f27-99cd-a0dd7831c358",
 CellID->87419684],
Cell[48314, 1070, 401, 11, 70, "ExampleText",ExpressionUUID->"297c6eee-1866-444b-be12-65a27c4795ca",
 CellID->227520913],
Cell[48718, 1083, 464, 13, 70, "Input",ExpressionUUID->"ff36fe25-9921-4c94-9b12-03b312c39eab",
 CellID->531122037],
Cell[CellGroupData[{
Cell[49207, 1100, 2790, 78, 70, "Input",ExpressionUUID->"883b1ea3-b866-41f2-9cbe-d40bccbab565",
 CellID->136921489],
Cell[52000, 1180, 28191, 559, 358, "Output",ExpressionUUID->"fb6c79e4-664a-4843-a2c1-06a3a44efad2",
 CellID->40361074]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[80433, 1748, 2996, 80, 70, "SeeAlsoSection",ExpressionUUID->"371ab2ea-b20d-4617-9856-35aa5a6b0033"],
Cell[83432, 1830, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"0a0149da-6cc9-45ec-b524-9712b00a3589"],
Cell[84164, 1851, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"15ed5eed-89eb-4d8e-885d-77b6b0647aa2"],
Cell[85774, 1896, 78, 0, 70, "FooterCell",ExpressionUUID->"58b22070-ce41-4c58-91a4-a5101c275f02"]
}
]
*)

(* End of internal cache information *)

