(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79482,       1820]
NotebookOptionsPosition[     72870,       1687]
NotebookOutlinePosition[     75171,       1744]
CellTagsIndexPosition[     75085,       1739]
WindowTitle->HtotalAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "55a3a058-e442-4453-9b53-7442869248e0"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "37ed52e3-42fa-4df1-a87a-65625383f122"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "acae845d-af35-42ac-9086-d504d97469fb"]
         }],ExpressionUUID->"579b2896-5487-470f-a740-db883d35660b"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"UtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/UtotalAdimNv"], 
         "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "d29825b9-44bd-4124-b626-7011849faf81"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "14c8e631-35f6-47ab-ab72-ef7dffdc752f"]
         }],ExpressionUUID->"050b256e-eca4-42f2-b5ee-581f24c0b7ac"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "1940316c-bc7a-497f-b01e-50da0c96d536"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "d5e27767-03fa-4951-ba26-51a22f9603bb"]
         }],ExpressionUUID->"d198487a-754e-4f7f-a50a-4199e73ed2c7"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/HtotalAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/HtotalAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
HtotalAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$15084], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/HtotalAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "a6976a8c-5eeb-4f07-b7f5-db983688cd13"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "9335bc7d-b213-497d-9fc9-16ab3354a483"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"a055fa0c-55ec-47d1-937d-d818c37d2894"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"94010be4-f554-4622-a6df-39f2fb45b328"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "HtotalAdimNv", "ObjectName",ExpressionUUID->
      "cbbaa5b0-3f19-47fb-afcc-c8d4fe4b0849"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"61c5270d-c703-41ed-b205-b44f380e1fe8"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "7547ad2a-510f-4e92-ab10-5b5898cb1882"]
    }],ExpressionUUID->"721c1e99-440f-45be-8a05-7b2173d2c7f4"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"e17cfed6-92ef-4222-b4a8-\
f6bb8db0f222"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "HtotalAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["H",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     "\nEnthalpie adimensionnelle en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5a26abc5-59f1-4bd6-80b8-ee0d3fec1b83"],
     ")\n[Non-dimensional enthapy function versus ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) and \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "601ecb1a-1223-4bcf-a65d-d6f2b7c2e032"],
     ")]"
    }],ExpressionUUID->"de46d7ec-18a6-4d8e-bd36-f0270bf83944"]}
  }]], "Usage",ExpressionUUID->"3501efb0-bd67-49ed-82fe-ef24c264a6bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"e704409c-bc15-408e-ba73-c482d5124842"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"c8f8051e-66f3-4172-aa7e-b67fae067e7e"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"9cec65a2-a452-4358-a55c-f8e7b7c2f8a5"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"50656cd1-9005-4065-b93a-9fcbca5c0dcf"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->88726249,ExpressionUUID->"aae3f8c8-f84c-45aa-aa7c-01f117fcd15d"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"dc1cd975-bf01-43d0-9c6d-972df702c70c"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"0bc6ece6-0424-4bc0-ad6c-9caea4882e24"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " >0 and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->17987804,ExpressionUUID->"1869bb21-af8d-4ec0-aa54-bf7e7505dfa4"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"a45f69ac-cca5-419d-b594-7faebeec8282"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fe99f87d-6940-49d6-99bb-f03c7f2c9d6c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "91df9ce4-1e1e-4715-904b-5312a8baaf2c"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->422017007,ExpressionUUID->"6709a9e9-b328-4352-972d-6a9b2f2e3c1b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"90beb810-50b8-4fc5-963a-11476932fc9d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"37b27242-b8fb-4f56-b9c8-e62222806f0b"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "75266c15-8af9-4301-9d0a-1268bfbd680b"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->200825432,ExpressionUUID->"2b2f08da-f344-4dc3-9a3f-dc236a0c7f25"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143015886,ExpressionUUID->"5998770c-506d-43e0-91ca-24105071bbad"],

Cell[TextData[{
 "Calculated value of ",
 StyleBox["H",
  FontSlant->"Italic"],
 " for atmospheric pressure and 20\[Degree]C"
}], "ExampleText",
 CellID->544149791,ExpressionUUID->"7a48f834-5fa7-4fd3-ad0e-9999af541da7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitSimplify", "[", 
  RowBox[{
   RowBox[{"HtotalAdimNv", "[", 
    RowBox[{"293.15", ",", 
     RowBox[{"RhoArgonNv", "[", 
      RowBox[{"293.15", ",", 
       RowBox[{"QuantityMagnitude", "@", 
        RowBox[{"N", "@", 
         RowBox[{"UnitConvert", "[", 
          RowBox[{
           TemplateBox[{"1"},
            "QuantityUnit",
            DisplayFunction->(TooltipBox[
              StyleBox[
               RowBox[{#, "\[InvisibleSpace]", 
                 StyleBox[
                  RowBox[{" ", "\"atm\""}], "QuantityUnitTraditionalLabel"]}],
                ShowStringCharacters -> False], "Unit: atmospheres"]& ),
            InterpretationFunction->(RowBox[{"Quantity", "[", 
               RowBox[{#, ",", "\"Atmospheres\""}], "]"}]& )], ",", 
           "\"\<Bars\>\""}], "]"}]}]}], ",", "\"\<G\>\""}], "]"}]}], "]"}], 
   "*", 
   RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", 
   RowBox[{
    RowBox[{"Quantity", "[", 
     RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}], "/", 
    RowBox[{"Quantity", "[", 
     RowBox[{"M", ",", 
      RowBox[{"\"\<Grams\>\"", "/", "\"\<Moles\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5710145,ExpressionUUID->"01e2e2ab-946f-40ab-8c47-353db7288361"],

Cell[BoxData[
 TemplateBox[{"152326.701247867`", 
   RowBox[{
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"]}], "meters squared per second squared", 
   FractionBox[
    SuperscriptBox["\"Meters\"", "2"], 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->35102715,ExpressionUUID->"87fd4f5d-3ceb-4a42-9834-7b2c37b06863"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Quantity", "[", 
    RowBox[{"152326.701247867`", ",", 
     FractionBox[
      SuperscriptBox["\"\<Meters\>\"", "2"], 
      SuperscriptBox["\"\<Seconds\>\"", "2"]]}], "]"}], ",", "\"\<J/kg\>\""}],
   "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->184678474,ExpressionUUID->"8fa4ae56-460e-42ba-acff-6593c1ecf9fc"],

Cell[BoxData[
 TemplateBox[{"152326.701247867`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"kg\""}], 
   "joules per kilogram", 
   FractionBox["\"Joules\"", "\"Kilograms\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->306155352,ExpressionUUID->"8e12a4ae-1f9b-441c-8360-899c7cbba02f"]
}, Open  ]],

Cell["Using ThermodynamicData package (i.e. REFPROP from NIST)", "ExampleText",
 CellID->361149294,ExpressionUUID->"8b4ea1a0-f3a1-431a-adca-0e35c77d976d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"ThermodynamicData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<Enthalpy\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Pressure\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"1", ",", "\"\<Atmospheres\>\""}], "]"}]}], ",", 
       RowBox[{"\"\<Temperature\>\"", "\[Rule]", 
        RowBox[{"Quantity", "[", 
         RowBox[{"293.15", ",", "\"\<Kelvins\>\""}], "]"}]}]}], "}"}]}], 
    "]"}], ",", "\"\<J/kg\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375583457,ExpressionUUID->"a360c254-a7a2-469c-b735-8c473942a44a"],

Cell[BoxData[
 TemplateBox[{"152325.43271917515`", 
   RowBox[{
    "\"J\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"kg\""}], 
   "joules per kilogram", 
   FractionBox["\"Joules\"", "\"Kilograms\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->621685008,ExpressionUUID->"414da63c-e7e0-4e00-9f6c-b81b83a089e0"]
}, Open  ]],

Cell["Enthalpy on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"3685dc0d-3631-42e9-8df2-b5b7db136588"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"HtotalAdimNv", "[", 
     RowBox[{
      RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Red", "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"H\",FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\"RT\"\
,FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->605199954,ExpressionUUID->"aa2d0875-711a-4fbf-bd60-0ee915223b78"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVxXk4lHkcAPCZwSoJOcrMuEKHCK2yRL5viRW1OUop5Rg2ZzSJh1wxxSRH
SEQZpIQ2RULp/dFlx5WeFpmc4z7CNL2OHLv7x+f5bHYPsPekkEgk5//8v86I
gmZGdiAoBqlHqriIYO9rmaETbkxILmgzvGEvgrmmt7Zg24PgUXaym42lCJa+
nx06URECQ8F9Lnd1RbCf2UstWEsk2C0d75wii2CeRbOvLkVfA+2yGGPDMgr2
TI5zjsOIA/LEAYUbDyjYSuQfso2W8fA+U23PUg4Fyzxeck5t/XVwdFoo23qd
gjVRPGUbsxLBK0TnN7YnBbujO2mQ4pQKtM/1IjxVCoZ5mLO3NKbCQFAC7/wm
CjaSdaenxjQN/MRuXtogTcF2ix1iD6mmg32ite2VFTLWwivs2Tt8C5KY4w7k
HjJGZruwh5hZ4KrLMtqXS8YqLngHKFtyIPz5K3cJLTLGXJARfRLLAcUIa9Pj
m8mY/pWqTKyOAx9tZ/lFVDJWkiJezzDNg+3oiNMZCTKW/6RQvvjXfMjL0Ujf
NUnCUqb6qw1V78Pyk+97fn9Kwvy8T4nazj+EDNdNbHuMhGm62WTFFD+Bw5Kv
2751rcADvFtxUPQFaB7iuWltWAJZr7d/B8q8hqhOA+2QtAUYdZQ/499VD0py
lU/7pebgkth44Cnf9xDN8lmj0C6E4phIzUorLvjYnLZ/zBbAjcM+3F/kW6Ci
SdzM1mUGpNqW3om3foSasQ+D2R2ToM0vCDav+QSRpRpcj9pRUH2ptIfH+gz8
04zHB0WHwNu4zs/fsh12v4iXnQ7qB3FVC6GhbifI9xg1vnTlQTj3Dtv5xxew
ZVm9dIv/DBbdreerB3hQdFWq7PFtLnhk6DfLfOiG0SmdQJuSajilwDB+e70X
SF27qvx6z8OniJqwEzV9MDrR+KXzdhXOdyjtXbzXDx8jFTODMj/g97oTJ6sz
BsBFaCbRlNeGs/aKGRJsPvjo3TXnGnbgjmGe1/r8BiFCELpzzPcr/sn/eeSw
+xDMpXRsNVfsx40Pfou4YzUMHiZX5aT7+Xjj1KvqRq0RWGpe/LqxahgXt7l8
V1FlFKhu+Uf1BGO4XoJ6vBxlDFaKP0tIKU/h5Khq2o6FMbgdXGoRc3YGX7EY
HqudGAeiesf2xf0CfGT6J77aPAF7Mwaf/VAT4mFHyGZn3kwCp6lqOcaawOcT
p+u9iqbgwXOZgCTmPJ6Xd5E1G/8NaqhezZIVi7jQa2TqVvg0JNjncEMdlvGs
tep6Qr0ZoKVdtfcUruKJRlYm2iUzUML01tgYS0ZznQPWxiqzcHFVv9JcWgQR
7g3zYsmzoGYe9FrlmSjivi8Mc10rAKs+730G935B8jlzqzcvC2BHBCe8PGUN
MrDZ72Q3JwDL0kgp368SaJT/j21r4HdocAsISD22Hsl+67HRHPgORntqteZ4
0kj2Uy9N/IwQymubqtQvbEBx245PoVYhXHHvnDtIkUOpfyqcNcZ+gEd3Q/29
F/KIGdWcDzU/4Hl9yKHY5o2oYe3iuJIOAWP7FnIZIlQk2eF8kqpLQOmJnekT
66no6H38nYI+Afu1qipCFamo3ewqR2o3AY7s5MSinVQ0dFHGkWRKgDWjQNXu
JBVRerbW8W0I8OkvL277i4pMnzncLvYlQG2iTrnElYaioypFH/oTkB7s4kry
o6E3h6nMggACnJYkDJ1DaMh6pOdwzkUCtBkGGduSaMhJyYeSdJkArw4eX/IV
DQVfi/a/kEBA9wtMsI5KRzUO/C7/RAK+6tjVfdCko2U1SyufZAKMyytD2fp0
xHq5ToORRkDZWJ+8ihUdpc1kdB7LJuB6hb7ytRA6aq9dsLC7S8Di9kFP31g6
oiU4lx/JJWAgN8/sWDId5W9RT7IsIGBdgwlr50M6Ghawfh4oJOCjbhyHXk5H
WmjECx4SEKe+WXsNTkd+idbtJo8I8I57ozzNpaOyU4/NjUoIiGY4E7XtdPQv
e0/Ycg==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            Line[CompressedData["
1:eJwVxXk4lHkcAPCZwSoJOcrMuEKHCK2yRL5viRW1OUop5Rg2ZzSJh1wxxSRH
SEQZpIQ2RULp/dFlx5WeFpmc4z7CNL2OHLv7x+f5bHYPsPekkEgk5//8v86I
gmZGdiAoBqlHqriIYO9rmaETbkxILmgzvGEvgrmmt7Zg24PgUXaym42lCJa+
nx06URECQ8F9Lnd1RbCf2UstWEsk2C0d75wii2CeRbOvLkVfA+2yGGPDMgr2
TI5zjsOIA/LEAYUbDyjYSuQfso2W8fA+U23PUg4Fyzxeck5t/XVwdFoo23qd
gjVRPGUbsxLBK0TnN7YnBbujO2mQ4pQKtM/1IjxVCoZ5mLO3NKbCQFAC7/wm
CjaSdaenxjQN/MRuXtogTcF2ix1iD6mmg32ite2VFTLWwivs2Tt8C5KY4w7k
HjJGZruwh5hZ4KrLMtqXS8YqLngHKFtyIPz5K3cJLTLGXJARfRLLAcUIa9Pj
m8mY/pWqTKyOAx9tZ/lFVDJWkiJezzDNg+3oiNMZCTKW/6RQvvjXfMjL0Ujf
NUnCUqb6qw1V78Pyk+97fn9Kwvy8T4nazj+EDNdNbHuMhGm62WTFFD+Bw5Kv
2751rcADvFtxUPQFaB7iuWltWAJZr7d/B8q8hqhOA+2QtAUYdZQ/499VD0py
lU/7pebgkth44Cnf9xDN8lmj0C6E4phIzUorLvjYnLZ/zBbAjcM+3F/kW6Ci
SdzM1mUGpNqW3om3foSasQ+D2R2ToM0vCDav+QSRpRpcj9pRUH2ptIfH+gz8
04zHB0WHwNu4zs/fsh12v4iXnQ7qB3FVC6GhbifI9xg1vnTlQTj3Dtv5xxew
ZVm9dIv/DBbdreerB3hQdFWq7PFtLnhk6DfLfOiG0SmdQJuSajilwDB+e70X
SF27qvx6z8OniJqwEzV9MDrR+KXzdhXOdyjtXbzXDx8jFTODMj/g97oTJ6sz
BsBFaCbRlNeGs/aKGRJsPvjo3TXnGnbgjmGe1/r8BiFCELpzzPcr/sn/eeSw
+xDMpXRsNVfsx40Pfou4YzUMHiZX5aT7+Xjj1KvqRq0RWGpe/LqxahgXt7l8
V1FlFKhu+Uf1BGO4XoJ6vBxlDFaKP0tIKU/h5Khq2o6FMbgdXGoRc3YGX7EY
HqudGAeiesf2xf0CfGT6J77aPAF7Mwaf/VAT4mFHyGZn3kwCp6lqOcaawOcT
p+u9iqbgwXOZgCTmPJ6Xd5E1G/8NaqhezZIVi7jQa2TqVvg0JNjncEMdlvGs
tep6Qr0ZoKVdtfcUruKJRlYm2iUzUML01tgYS0ZznQPWxiqzcHFVv9JcWgQR
7g3zYsmzoGYe9FrlmSjivi8Mc10rAKs+730G935B8jlzqzcvC2BHBCe8PGUN
MrDZ72Q3JwDL0kgp368SaJT/j21r4HdocAsISD22Hsl+67HRHPgORntqteZ4
0kj2Uy9N/IwQymubqtQvbEBx245PoVYhXHHvnDtIkUOpfyqcNcZ+gEd3Q/29
F/KIGdWcDzU/4Hl9yKHY5o2oYe3iuJIOAWP7FnIZIlQk2eF8kqpLQOmJnekT
66no6H38nYI+Afu1qipCFamo3ewqR2o3AY7s5MSinVQ0dFHGkWRKgDWjQNXu
JBVRerbW8W0I8OkvL277i4pMnzncLvYlQG2iTrnElYaioypFH/oTkB7s4kry
o6E3h6nMggACnJYkDJ1DaMh6pOdwzkUCtBkGGduSaMhJyYeSdJkArw4eX/IV
DQVfi/a/kEBA9wtMsI5KRzUO/C7/RAK+6tjVfdCko2U1SyufZAKMyytD2fp0
xHq5ToORRkDZWJ+8ihUdpc1kdB7LJuB6hb7ytRA6aq9dsLC7S8Di9kFP31g6
oiU4lx/JJWAgN8/sWDId5W9RT7IsIGBdgwlr50M6Ghawfh4oJOCjbhyHXk5H
WmjECx4SEKe+WXsNTkd+idbtJo8I8I57ozzNpaOyU4/NjUoIiGY4E7XtdPQv
e0/Ycg==
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0.0040546000061275735`, 
           1.4168017335853793`}, {-6.959709023846585, 2.421444878984868}}, 
          "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.535599, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0.0040546000061275735`, 
          1.4168017335853793`}, {-6.959709023846585, 2.421444878984868}}, 
         "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]], 
         Line[CompressedData["
1:eJwVxXk4lHkcAPCZwSoJOcrMuEKHCK2yRL5viRW1OUop5Rg2ZzSJh1wxxSRH
SEQZpIQ2RULp/dFlx5WeFpmc4z7CNL2OHLv7x+f5bHYPsPekkEgk5//8v86I
gmZGdiAoBqlHqriIYO9rmaETbkxILmgzvGEvgrmmt7Zg24PgUXaym42lCJa+
nx06URECQ8F9Lnd1RbCf2UstWEsk2C0d75wii2CeRbOvLkVfA+2yGGPDMgr2
TI5zjsOIA/LEAYUbDyjYSuQfso2W8fA+U23PUg4Fyzxeck5t/XVwdFoo23qd
gjVRPGUbsxLBK0TnN7YnBbujO2mQ4pQKtM/1IjxVCoZ5mLO3NKbCQFAC7/wm
CjaSdaenxjQN/MRuXtogTcF2ix1iD6mmg32ite2VFTLWwivs2Tt8C5KY4w7k
HjJGZruwh5hZ4KrLMtqXS8YqLngHKFtyIPz5K3cJLTLGXJARfRLLAcUIa9Pj
m8mY/pWqTKyOAx9tZ/lFVDJWkiJezzDNg+3oiNMZCTKW/6RQvvjXfMjL0Ujf
NUnCUqb6qw1V78Pyk+97fn9Kwvy8T4nazj+EDNdNbHuMhGm62WTFFD+Bw5Kv
2751rcADvFtxUPQFaB7iuWltWAJZr7d/B8q8hqhOA+2QtAUYdZQ/499VD0py
lU/7pebgkth44Cnf9xDN8lmj0C6E4phIzUorLvjYnLZ/zBbAjcM+3F/kW6Ci
SdzM1mUGpNqW3om3foSasQ+D2R2ToM0vCDav+QSRpRpcj9pRUH2ptIfH+gz8
04zHB0WHwNu4zs/fsh12v4iXnQ7qB3FVC6GhbifI9xg1vnTlQTj3Dtv5xxew
ZVm9dIv/DBbdreerB3hQdFWq7PFtLnhk6DfLfOiG0SmdQJuSajilwDB+e70X
SF27qvx6z8OniJqwEzV9MDrR+KXzdhXOdyjtXbzXDx8jFTODMj/g97oTJ6sz
BsBFaCbRlNeGs/aKGRJsPvjo3TXnGnbgjmGe1/r8BiFCELpzzPcr/sn/eeSw
+xDMpXRsNVfsx40Pfou4YzUMHiZX5aT7+Xjj1KvqRq0RWGpe/LqxahgXt7l8
V1FlFKhu+Uf1BGO4XoJ6vBxlDFaKP0tIKU/h5Khq2o6FMbgdXGoRc3YGX7EY
HqudGAeiesf2xf0CfGT6J77aPAF7Mwaf/VAT4mFHyGZn3kwCp6lqOcaawOcT
p+u9iqbgwXOZgCTmPJ6Xd5E1G/8NaqhezZIVi7jQa2TqVvg0JNjncEMdlvGs
tep6Qr0ZoKVdtfcUruKJRlYm2iUzUML01tgYS0ZznQPWxiqzcHFVv9JcWgQR
7g3zYsmzoGYe9FrlmSjivi8Mc10rAKs+730G935B8jlzqzcvC2BHBCe8PGUN
MrDZ72Q3JwDL0kgp368SaJT/j21r4HdocAsISD22Hsl+67HRHPgORntqteZ4
0kj2Uy9N/IwQymubqtQvbEBx245PoVYhXHHvnDtIkUOpfyqcNcZ+gEd3Q/29
F/KIGdWcDzU/4Hl9yKHY5o2oYe3iuJIOAWP7FnIZIlQk2eF8kqpLQOmJnekT
66no6H38nYI+Afu1qipCFamo3ewqR2o3AY7s5MSinVQ0dFHGkWRKgDWjQNXu
JBVRerbW8W0I8OkvL277i4pMnzncLvYlQG2iTrnElYaioypFH/oTkB7s4kry
o6E3h6nMggACnJYkDJ1DaMh6pOdwzkUCtBkGGduSaMhJyYeSdJkArw4eX/IV
DQVfi/a/kEBA9wtMsI5KRzUO/C7/RAK+6tjVfdCko2U1SyufZAKMyytD2fp0
xHq5ToORRkDZWJ+8ihUdpc1kdB7LJuB6hb7ytRA6aq9dsLC7S8Di9kFP31g6
oiU4lx/JJWAgN8/sWDId5W9RT7IsIGBdgwlr50M6Ghawfh4oJOCjbhyHXk5H
WmjECx4SEKe+WXsNTkd+idbtJo8I8I57ozzNpaOyU4/NjUoIiGY4E7XtdPQv
e0/Ycg==
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0.0040546000061275735`, 
        1.4168017335853793`}, {-6.959709023846585, 2.421444878984868}}, 
       "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.535599, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[1, 0, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.535599, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"H\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
StyleBox[\\\"RT\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
       HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0040546000061275735`, 
   1.4168017335853793`}, {-6.959709023846585, 2.421444878984868}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->62310900,ExpressionUUID->"5c60b297-c088-4d89-b481-180959160afb"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"e8d15039-4179-48e7-984d-bf535a4b8126"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"9b979276-67c4-49eb-aa8f-834a4b2231d6"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "1b663be2-80ef-4423-a7c9-2bca074ff512"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"fb582e05-e632-4d6e-accc-309d86586fe9"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"36b3c4a0-f225-4cd3-8177-a9eddca2c761"],

Cell[TextData[{
 "Comparison with ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["NIST data"]], "http://webbook.nist.gov/chemistry/fluid/"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "1e4be71b-9b79-423a-8bcc-9b990b63473c"],
 " on an isotherm close to the critical isotherm"
}], "ExampleText",
 CellID->227520913,ExpressionUUID->"e2aa84ba-d6c5-44fe-8bb9-aff533152dcd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datafile", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<NewEoSArgon\>\"", ",", "\"\<DataFiles\>\"", ",", 
      "\"\<DataCritNIST.dat\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNIST", "=", 
   RowBox[{"Import", "[", "datafile", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->531122037,ExpressionUUID->"b1f7d344-f55a-4e90-a482-ba652e34fb27"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ArT150p7H", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"dataNIST", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "6"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "51"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"RR", "*", "150.7", "*", 
      RowBox[{
       RowBox[{"HtotalAdimNv", "[", 
        RowBox[{"150.7", ",", "x"}], "]"}], "/", "1000"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.0000319`", ",", "1.6046`"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"H\",FontSlant->\"Italic\"]\) (kJ/mole)\>\"", 
        ",", "\"\<ISOTHERM 150.7 K\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "ArT150p7H"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<NIST database\>\"", "}"}]}], "]"}], ",", "Below"}],
       "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<HtotalAdimNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->136921489,ExpressionUUID->"5f35505a-f058-4d71-ad7e-3cffbe1b0e92"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwV13k0F98bB3D7nmxlDxUViRStPEOpSJGUQrKnhEQrX1lTomhBKCVElpSt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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwV13k0F98bB3D7nmxlDxUViRStPEOpSJGUQrKnhEQrX1lTomhBKCVElpSt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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.535599, 0.}, 
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.535599, 0.}, 
           "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwV13k0F98bB3D7nmxlDxUViRStPEOpSJGUQrKnhEQrX1lTomhBKCVElpSt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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.535599, 0.}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0.535599, 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0.535599, 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{0.0000319, 3.1318}], 
        PointBox[{0.0000638, 3.1316}], 
        PointBox[{0.0000957, 3.1313}], 
        PointBox[{0.00012756, 3.1311}], 
        PointBox[{0.00015946, 3.1308}], 
        PointBox[{0.00019137, 3.1306}], 
        PointBox[{0.00022328, 3.1303}], 
        PointBox[{0.0002552, 3.1301}], 
        PointBox[{0.00028711, 3.1298}], 
        PointBox[{0.00031904, 3.1296}], 
        PointBox[{0.00063851, 3.1271}], 
        PointBox[{0.00095842, 3.1246}], 
        PointBox[{0.0012788, 3.1221}], 
        PointBox[{0.0015996, 3.1196}], 
        PointBox[{0.0019208, 3.117}], 
        PointBox[{0.0022425, 3.1145}], 
        PointBox[{0.0025646, 3.112}], 
        PointBox[{0.0028872, 3.1095}], 
        PointBox[{0.0032102, 3.107}], 
        PointBox[{0.0064655, 3.0816}], 
        PointBox[{0.0097676, 3.0559}], 
        PointBox[{0.013118, 3.0298}], 
        PointBox[{0.016519, 3.0035}], 
        PointBox[{0.019972, 2.9768}], 
        PointBox[{0.023479, 2.9497}], 
        PointBox[{0.027044, 2.9223}], 
        PointBox[{0.030667, 2.8944}], 
        PointBox[{0.034351, 2.8662}], 
        PointBox[{0.0753, 2.5571}], 
        PointBox[{0.12749, 2.1761}], 
        PointBox[{0.20492, 1.6393}], 
        PointBox[{0.71774, -0.80672}], 
        PointBox[{0.8327, -1.1606}], 
        PointBox[{0.87947, -1.2872}], 
        PointBox[{0.91145, -1.3644}], 
        PointBox[{0.93632, -1.418}], 
        PointBox[{0.9569, -1.4572}], 
        PointBox[{1.0764, -1.5647}], 
        PointBox[{1.1436, -1.5039}], 
        PointBox[{1.1924, -1.3874}], 
        PointBox[{1.2313, -1.2428}], 
        PointBox[{1.2641, -1.0816}], 
        PointBox[{1.2925, -0.90945}], 
        PointBox[{1.3177, -0.72971}], 
        PointBox[{1.3405, -0.54448}], 
        PointBox[{1.3612, -0.35517}], 
        PointBox[{1.4449, 0.6263}], 
        PointBox[{1.5084, 1.6334}], 
        PointBox[{1.5603, 2.6474}], 
        PointBox[{1.6046, 3.6611}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"H\\\",FontSlant->\\\"Italic\\\"]\\) \
(kJ/mole)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\[Rho] (g/\\!\\(\\*SuperscriptBox[\\(cm\\), \\(3\\)]\\))\"", 
          HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150.7 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"NIST database\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"HtotalAdimNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\
\\),\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[3]=",
 CellID->581320164,ExpressionUUID->"0c546b92-dace-400a-b840-13f6326cc36b"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "9ef7e57b-ce6e-43b4-9872-3294ed8ee0ae"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["UtotalAdimNv"]], "paclet:NewEoSArgon/ref/UtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "74322ecc-bd7e-4b0a-a1a0-bc96b0f38519"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "8325dcc0-0f6b-4ea8-8dce-e91db7d6a5b1"]
       }], "SeeAlso",ExpressionUUID->"f3044268-426e-4497-bdb4-5a06babc85fe"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"25f09d47-ea31-47c3-a897-\
4a2b7600a1f0"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "a43c2e16-07d0-439b-a7bf-e0f72ff85ead"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"58f450a6-3a65-4864-8bd6-\
da4f52423e91"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0436c0d4-23d3-4a75-b30d-2f14874e13cf"]], "RelatedLinks",
        ExpressionUUID->"8e2b0967-9ac0-46f6-9ac7-dd2591ea2595"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "41fcede3-c42f-49fa-bb25-9d5fedc84a36"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "52bd452d-e40c-4163-b67a-4ebec5307bdf"]], "RelatedLinks",
        ExpressionUUID->"54e5b8cf-9e01-4c76-8c5e-e31c592289ce"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"5c7269c4-ed61-4d61-ab4a-\
04da18f8b303"],

Cell[" ", "FooterCell",ExpressionUUID->"6efff107-4f65-44b5-871f-b36f2b7b66d6"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HtotalAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 38.2866547}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "HtotalAdimNv[T, \\[Rho]] \\[Congruent] H/RT Enthalpie adimensionnelle en \
fonction de T (Kelvin) et de \\[Rho] (g/cm^3) [Non-dimensional enthapy \
function versus T (Kelvin) and \\[Rho] (g/cm^3)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "HtotalAdimNv", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "HtotalAdimNv", "type" -> 
    "Symbol", "uri" -> "NewEoSArgon/ref/HtotalAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"a71f594a-45fa-48a4-a5c2-52aa677eb289"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10406, 285, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6709a9e9-b328-4352-972d-6a9b2f2e3c1b",
   CellTags->"PrimaryExamplesSection",
   CellID->422017007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 74885, 1732}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 5431, 132, 56, "AnchorBarGrid",ExpressionUUID->"a055fa0c-55ec-47d1-937d-d818c37d2894",
 CellID->1],
Cell[6018, 155, 94, 0, 23, "ContextNameCell",ExpressionUUID->"94010be4-f554-4622-a6df-39f2fb45b328"],
Cell[CellGroupData[{
Cell[6137, 159, 555, 14, 56, "ObjectNameGrid",ExpressionUUID->"e17cfed6-92ef-4222-b4a8-f6bb8db0f222"],
Cell[6695, 175, 1004, 29, 146, "Usage",ExpressionUUID->"3501efb0-bd67-49ed-82fe-ef24c264a6bc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7736, 209, 1918, 48, 37, "NotesSection",ExpressionUUID->"aae3f8c8-f84c-45aa-aa7c-01f117fcd15d",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->88726249],
Cell[9657, 259, 220, 6, 36, "Notes",ExpressionUUID->"dc1cd975-bf01-43d0-9c6d-972df702c70c",
 CellID->1067943069],
Cell[9880, 267, 186, 4, 36, "Notes",ExpressionUUID->"0bc6ece6-0424-4bc0-ad6c-9caea4882e24",
 CellID->224665577],
Cell[10069, 273, 210, 6, 36, "Notes",ExpressionUUID->"1869bb21-af8d-4ec0-aa54-bf7e7505dfa4",
 CellID->17987804]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[10406, 285, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6709a9e9-b328-4352-972d-6a9b2f2e3c1b",
 CellTags->"PrimaryExamplesSection",
 CellID->422017007],
Cell[CellGroupData[{
Cell[11851, 326, 1398, 36, 30, "ExampleSection",ExpressionUUID->"2b2f08da-f344-4dc3-9a3f-dc236a0c7f25",
 CellID->200825432],
Cell[13252, 364, 268, 5, 42, "Input",ExpressionUUID->"5998770c-506d-43e0-91ca-24105071bbad",
 CellID->143015886],
Cell[13523, 371, 219, 6, 38, "ExampleText",ExpressionUUID->"7a48f834-5fa7-4fd3-ad0e-9999af541da7",
 CellID->544149791],
Cell[CellGroupData[{
Cell[13767, 381, 1285, 32, 42, "Input",ExpressionUUID->"01e2e2ab-946f-40ab-8c47-353db7288361",
 CellID->5710145],
Cell[15055, 415, 455, 11, 43, "Output",ExpressionUUID->"87fd4f5d-3ceb-4a42-9834-7b2c37b06863",
 CellID->35102715]
}, Open  ]],
Cell[CellGroupData[{
Cell[15547, 431, 404, 11, 46, "Input",ExpressionUUID->"8fa4ae56-460e-42ba-acff-6593c1ecf9fc",
 CellID->184678474],
Cell[15954, 444, 337, 8, 43, "Output",ExpressionUUID->"8e12a4ae-1f9b-441c-8360-899c7cbba02f",
 CellID->306155352]
}, Open  ]],
Cell[16306, 455, 154, 1, 38, "ExampleText",ExpressionUUID->"8b4ea1a0-f3a1-431a-adca-0e35c77d976d",
 CellID->361149294],
Cell[CellGroupData[{
Cell[16485, 460, 641, 15, 42, "Input",ExpressionUUID->"a360c254-a7a2-469c-b735-8c473942a44a",
 CellID->375583457],
Cell[17129, 477, 339, 8, 43, "Output",ExpressionUUID->"414da63c-e7e0-4e00-9f6c-b81b83a089e0",
 CellID->621685008]
}, Open  ]],
Cell[17483, 488, 140, 1, 38, "ExampleText",ExpressionUUID->"3685dc0d-3631-42e9-8df2-b5b7db136588",
 CellID->286706321],
Cell[CellGroupData[{
Cell[17648, 493, 953, 24, 46, "Input",ExpressionUUID->"aa2d0875-711a-4fbf-bd60-0ee915223b78",
 CellID->605199954],
Cell[18604, 519, 12406, 257, 283, "Output",ExpressionUUID->"5c60b297-c088-4d89-b481-180959160afb",
 CellID->62310900]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[31159, 784, 1419, 37, 70, "ExampleSection",ExpressionUUID->"fb582e05-e632-4d6e-accc-309d86586fe9",
 CellID->258228157],
Cell[32581, 823, 174, 3, 70, "Input",ExpressionUUID->"36b3c4a0-f225-4cd3-8177-a9eddca2c761",
 CellID->87419684],
Cell[32758, 828, 401, 11, 70, "ExampleText",ExpressionUUID->"e2aa84ba-d6c5-44fe-8bb9-aff533152dcd",
 CellID->227520913],
Cell[33162, 841, 464, 13, 70, "Input",ExpressionUUID->"b1f7d344-f55a-4e90-a482-ba652e34fb27",
 CellID->531122037],
Cell[CellGroupData[{
Cell[33651, 858, 2470, 68, 70, "Input",ExpressionUUID->"5f35505a-f058-4d71-ad7e-3cffbe1b0e92",
 CellID->136921489],
Cell[36124, 928, 32183, 630, 362, "Output",ExpressionUUID->"0c546b92-dace-400a-b840-13f6326cc36b",
 CellID->581320164]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[68549, 1567, 1894, 50, 70, "SeeAlsoSection",ExpressionUUID->"25f09d47-ea31-47c3-a897-4a2b7600a1f0"],
Cell[70446, 1619, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"58f450a6-3a65-4864-8bd6-da4f52423e91"],
Cell[71178, 1640, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"5c7269c4-ed61-4d61-ab4a-04da18f8b303"],
Cell[72788, 1685, 78, 0, 70, "FooterCell",ExpressionUUID->"6efff107-4f65-44b5-871f-b36f2b7b66d6"]
}
]
*)

(* End of internal cache information *)

