(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     61250,       1476]
NotebookOptionsPosition[     54785,       1346]
NotebookOutlinePosition[     57057,       1402]
CellTagsIndexPosition[     56971,       1397]
WindowTitle->LvapAdimNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "9eec973f-40c4-4357-b615-c75cb9223478"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "df93f52d-3d8b-4228-ba05-a6984fd724cf"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "837a3ef0-6be2-4f91-9b21-fb32321bf727"]
         }],ExpressionUUID->"7da90271-ca38-4e8e-ae3c-12104bbb8987"],
         StripOnInput->False],{
        "\"ttr\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/ttr"], 
         "\"tcNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/tcNv"], 
         "\"HtotalAdimNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/HtotalAdimNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4229b1c5-1083-4f1b-9767-87095877eb74"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "1bcf193b-9fe1-44cd-861e-cd6a1167a47b"]
         }],ExpressionUUID->"df5ac0f2-73a3-4e61-935e-b96876e6efde"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "52d87063-8d2c-4962-8b22-8844514392ec"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "f70e8f57-a945-48b6-a6aa-d4f0cd10c675"]
         }],ExpressionUUID->"8dbabfd7-035e-462c-a1e5-7abea783f41e"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/LvapAdimNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/LvapAdimNv"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
LvapAdimNv.html"], StandardForm]], "Input", TextClipboardType -> 
                 "PlainText"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$15595], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/LvapAdimNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "abe9ebb6-1dca-426d-8148-005de23b5d72"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "75260250-0179-4c09-88b3-6bbec7f0e413"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"1cac0704-6357-49bb-b2a3-98ec202830b4"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"cecd1953-604a-49d9-9bdc-8cb91eb918ba"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "LvapAdimNv", "ObjectName",ExpressionUUID->
      "f26ad22c-26e1-4085-b976-de6493562420"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"7f059771-e22f-449c-a12c-c918cc14722b"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "36764286-ab3d-42d5-860d-66df72948aba"]
    }],ExpressionUUID->"32a55172-7a6b-405f-a3af-0b80c66d534d"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"b1ec133c-f550-43b5-9e94-\
3566da2ba7a8"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "LvapAdimNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     "] \[Congruent] ",
     StyleBox["Lv",
      FontSlant->"Italic"],
     "/",
     StyleBox["RT",
      FontSlant->"Italic"],
     "\nChaleur latente de vaporisation adimensionnelle de l'argon en \
fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin)\n[Non-dimensional latent heat of vaporization of argon versus \
",
     StyleBox["T ",
      FontSlant->"Italic"],
     "(Kelvin)",
     "]"
    }],ExpressionUUID->"d347eb83-7ce5-4ee1-b811-21ec86d627c6"]}
  }]], "Usage",ExpressionUUID->"ce8c4619-94e4-41a8-adb0-bc9555a8d116"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"1bc3d7d8-139b-4520-869d-04f455e34749"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"e5f50096-a9bb-4200-ab2e-e4f0c81c0909"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"a5a94641-b9c9-41f4-b3ec-1b93d41570e4"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"51547640-76d2-4bbb-842e-60d39a217aa6"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->137524279,ExpressionUUID->"f663cd82-4349-4527-a67c-95f4cc48537d"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1e65b5a7-249e-4c02-b08a-5b3a6fc8b0e5"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "b0fac4dd-7e0f-42ee-a301-8affdf764c3b"]
}], "Notes",
 CellID->1067943069,ExpressionUUID->"90ddca76-5e40-4b2e-bd96-ad1028a856a4"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"b295c68a-f5a7-409e-aec5-86a8af929d2c"],

Cell[TextData[{
 "The function is defined for ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "668e674a-944a-43e0-aebe-5129de4fa805"],
 " \[LessEqual] ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[LessEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "11e0d0ea-97ed-4305-8b77-ca7ba762dd21"]
}], "Notes",
 CellID->657169447,ExpressionUUID->"ccf21d9a-29c2-47b3-8d76-22bae288b44e"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"2c0595e9-6841-4e52-984c-40750eba878b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"2fa07c81-8d85-4a88-92d6-2ac2307ed884"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f910999e-1b1e-43c9-b73e-61f3bdc80a6a"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->370058473,ExpressionUUID->"cf4e85ae-5518-4b1c-b78e-b2059b555252"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"997754b8-0f62-4bf1-83dd-ab57d91add82"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"e3e74dcf-665f-419f-aa7f-5c267eb0a779"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "b2d1ec11-598d-4749-8ac4-f8d4c6ef8413"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->619695073,ExpressionUUID->"ed69cd13-54ac-4e89-b154-33ecac7124c8"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"f1e4dd06-b70e-46ff-a08f-6f9b30b6ab48"],

Cell["Latent heat at the atmospheric boiling point temperature", "ExampleText",
 CellID->184302421,ExpressionUUID->"e130c0bc-25f2-44a7-bc5a-b2cb6bfb6cf8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalPressure", "=", 
   RowBox[{"N", "@", 
    RowBox[{"QuantityMagnitude", "@", 
     RowBox[{"UnitConvert", "[", 
      RowBox[{
       RowBox[{"Quantity", "[", 
        RowBox[{"1", ",", "\"\<atm\>\""}], "]"}], ",", "\"\<MPa\>\""}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tb", "=", 
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"x", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PTSat", "[", "x", "]"}], "==", "NormalPressure"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "85", ",", "95"}], "}"}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Secant\>\""}]}], "]"}]}], ",", 
    "\"\<Kelvins\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"LvTb", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"LvapAdimNv", "[", 
     RowBox[{"QuantityMagnitude", "@", "Tb"}], "]"}], "*", 
    RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}], "*", "Tb"}], 
   "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->223155686,ExpressionUUID->"e89add7d-7a6c-4164-8efc-7fc775e64462"],

Cell[BoxData[
 TemplateBox[{"87.2938969493787`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->254174370,ExpressionUUID->"6b99edcb-c8c4-451d-b32f-63124629ec93"],

Cell[BoxData[
 TemplateBox[{"6432.970826430233`", 
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/(\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"], "\[InvisibleSpace]", "\"mol\"", 
     "\[InvisibleSpace]", "\")\""}], 
   "kilogram meters squared per second squared mole", 
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    RowBox[{"\"Moles\"", " ", 
      SuperscriptBox["\"Seconds\"", "2"]}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->250372944,ExpressionUUID->"649ddb9a-162b-4a38-a10f-29b2680709ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{"LvTb", ",", "\"\<kiloJoules/Moles\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->81775040,ExpressionUUID->"efedd3e4-917f-4590-9195-70c621bb3868"],

Cell[BoxData[
 TemplateBox[{"6.432970826430233`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "kilojoules per mole", 
   FractionBox["\"Kilojoules\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->183549658,ExpressionUUID->"153dd898-8378-4852-8353-ee819b216a52"]
}, Open  ]],

Cell["\<\
Boiling point temperature and the corresponding Latent heat from the \
ChemicalData package\
\>", "ExampleText",
 CellID->261860218,ExpressionUUID->"979bc156-df0b-4394-904a-10f282b637c8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<BoilingPoint\>\"", ",", "#"}], "]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<Value\>\"", ",", "\"\<UnitsNotation\>\""}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UnitConvert", "[", 
   RowBox[{
    RowBox[{"First", "@", "%"}], ",", "\"\<Kelvins\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<VaporizationHeat\>\"", ",", "#"}], 
    "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<Value\>\"", ",", "\"\<Units\>\""}], "}"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->109079462,ExpressionUUID->"784ed7c7-acad-48ce-981e-0cd76fb7d734"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{
     RowBox[{"-", "185.7`"}], "\"\[Degree]C\"", "degrees Celsius", 
     "\"DegreesCelsius\""},
    "Quantity"], ",", "\<\"\[Degree]C\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->557175641,ExpressionUUID->"adffc79a-0a8c-440e-afc7-fdfde70e7c23"],

Cell[BoxData[
 TemplateBox[{"87.44999999999999`", "\"K\"", "kelvins", "\"Kelvins\""},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->197890335,ExpressionUUID->"9faadab7-6dab-4a31-be2b-8a03a38f4a9b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"6.6`", 
     RowBox[{
      "\"kJ\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
       "\"mol\""}], "kilojoules per mole", 
     FractionBox["\"Kilojoules\"", "\"Moles\""]},
    "Quantity"], ",", "\<\"KilojoulesPerMole\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->785431891,ExpressionUUID->"2b2d35f2-a311-4ec1-b3ed-0e670b0451ca"]
}, Open  ]],

Cell["\<\
Plot function versus temperature in all the temperature range\
\>", "ExampleText",
 CellID->886239600,ExpressionUUID->"29bbef69-f0d3-4b08-b0c4-baf19a39ed04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LvapAdimNv", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "ttr", ",", "tcNv"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ttr", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Temperature \!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\) (K)\>\"", 
      ",", "\"\<\!\(\*StyleBox[\"Lv\",FontSlant->\"Italic\"]\)/\!\(\*StyleBox[\
\"RT\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"12", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", 
         RowBox[{"LvapAdimNv", "[", 
          RowBox[{"QuantityMagnitude", "@", "Tb"}], "]"}]}], "}"}], "]"}], 
      ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(T\), \(b\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"QuantityMagnitude", "@", "Tb"}], ",", "8"}], "}"}]}], 
       "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->577903196,ExpressionUUID->"bf146979-6786-4cd4-a243-c043b075c161"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV03s4FHgXB/BJO6EUJrnlOq+SsrWVTRf1+yqKUuhl3GL4YZKKt4jC5rJl
pVq3SlHShQaptLoIub1bE6KWCmUzU+TeCLNujXfeP85zns9z/jjPc57vMaTB
u/3lGAxGiKz+319/+kZSh51glGWnu7CGjQDfBlHniBOirvusjKhiQyrKO7lO
4oQDxTjWWsGGqci7rmPMCekLTl+8WMZGfEcDZ4XUCQrquTWaD9mwaM8/WK/g
jKg49zb9PDZy39LMWXrOeFjIZ29PYiPyxV+SCBtn5IWcEuvsYYPVd2tuwk1n
xFCT3LCvhpBuMYqPnHBG6NNJi7IzhtBZ9ohbsYsDx6VnX7suN8TiXeSScT4H
rJUKzKhaA5zkB5mFTXNwz95aHBdsgFeb0lb0eLhgRS9De6WyAXb6Npy+/dAF
3ol1d8/660O/4p4tZ44rwm/YzCwt08PfnIS9RntdUZbDLHVQ1MO3RfJfWspc
wWrZOvCDvy7W/nr5ebuKGz6L20wrnukgUMdYQf6AG+wc44f6dXUw1O+ar17l
hn7+ofcDcQvhNx59e7uuOyhfjxxp18bsc+XKjeHuyKpb2uS1URtM3vXmdfXu
6NJWmfiep4X+kKhxgbEHqKb5v+coaWFJyffoTb94gOPOPrEuQhMO60N5La0e
sBgV6P7ZroF82xl3qs32YM1qv08J1hpwS/7ZJe3UHnCixsKSHqtjlMX1Tujc
g8HlWTZ5Buroql9R57vBE2X7CE6nLYDiAo30pCRP8LnuWncVF0Dz0nD1x15P
RCdbtoSHqiHKKdxBHV6Iy33CdO2Zj/od4o2HLnvBy8y34Mju+dj1OvqMzj9e
mAgPCp8oZ2HR7w8t7uzgQlAszhxcxUJPvMjO7xYXRTrpH5CpCrlHD54yvnPh
6ibVSVRSRe6TRkHYEm88cFZJsYlWQbU5odPO3kh4KeKsFygjwSHONDLGG+d4
u5Mcr8+DlXzl4lN3vOFR+qSu03MuCtxeOya2eiM3UHTNY4kSlg0fLPxjpg9U
UhrCeEOzcW0pc13wSh/o/a4kJz6viKrvwaO6e3ywynNLqdRaAS1Bb4ReiT44
W+6qbFo7CwrGz6TPH/mAV2iSa2rJhCgi0c5I5IOENyEDqaUzcf+AbS1LheKr
RF1eYWQGfpx4f3RkPUWK3/TVaX0GYg65Zl/eIJvHdt7fr8nAX93Nz60sKCZv
717WrMJA2LuX6uc3UmTPfmCWMYOByuKK4p9BUWlQPjn85zTZHXxDHGZNcbaI
+5K5fZqEfw4MGLenKFlodEPNTkqqGsZdpH4UZca8aWezKXLmpzWCYn+KLPnA
48GGU4STenjtfh5F62FuROS8KdLr3KfZspeCfWwyKLB7krDaP7QWBVJoPHN7
nJ05Sfz6Kjz8/0NxVLTZ2HF6gsxSiOfWR1J0b564/ujJOHm1r7oxLooikidO
bcsZJxl1UrLuF4ozJSoqfcnjZHlSuEHucYr/quV1NfHGiYv6PmF0LAXf66Z9
heo44RvZ+a7+jSLvcrtJve8Y2WHJ2puRSkGTy3lSiYScGFK9aZVGgZ0pasMd
ElJ2TVU4KHPE8R95r2olZLmcqseW8xSWY9yGLVkSwqpRtu9Pp7Ax1PJnWklI
i9Vc801XKNKnPEIKEkcJz0ZBXnSLIu4343LhjBFydUze6gyfIuOCTsOG7mHS
wpePXZNH8bQo6+mhhmFiqyg/mZhPUTW4/ntQxjAxrWV+XV0ou7dXTnTWT8Nk
eMfMdyfvU6zaFaAC528kxl6aa1JOceJ2hMOsCDHJSQi/90VmnaLg9kqOmNRW
iUtynlJsTtmgZrpaTNTMPtUbVlJIJ4X62m+/Er6m4JtWDcWYRYjVr4WDpFGY
smn2C4rRVm31AfN+MqI9x0Yg8z7rAKXAzj6i6XTCMb6WYijn2eh4Sh+hz8L8
5Opl+09p+5t39xJJvkfiRIMsPznz3VwSeohe6KK3vc0UTkUvb2xK6iJbCrM+
8t9QeNseeCM06SIBXRo9vLcUE3f8y0eqO8l919lToncUyRlGWCz+TLZu/Gr4
vo3C7PSJ1JNmn8j+sIBll95TxM9TWhtZKSLJd4VmLh8oJE1rwpZsF5E2w+Zt
Te0UCW3m6docIQmaVXKwroNiSd7h2NMX/iZpZFX4KaEsH1fPtQmj28njowUx
20QUzDxrO0WfD0Su70pazSfZ/1gK/tkq30aMjTSuxH6myPwh5pF+bQux80zO
JZ0Ud1k12ctj3pELjXElpV0UWrbC/S/Km0mpwlT1sS8UW/0dBdmkiXRYHqk3
76YQdAiiL/BfE2bk4JtRmbs2xt45+rmRLC3e+/GPHoqWdwV1VUb1xH6go/tQ
L4XR4Izi0MHnJHSx+7cVfRScHZ23CkeqyUVu0+SAzH5LLw39S/iYlF+0Y97u
p2Bku6/etpNB/ge8vWft
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV03s4FHgXB/BJO6EUJrnlOq+SsrWVTRf1+yqKUuhl3GL4YZKKt4jC5rJl
pVq3SlHShQaptLoIub1bE6KWCmUzU+TeCLNujXfeP85zns9z/jjPc57vMaTB
u/3lGAxGiKz+319/+kZSh51glGWnu7CGjQDfBlHniBOirvusjKhiQyrKO7lO
4oQDxTjWWsGGqci7rmPMCekLTl+8WMZGfEcDZ4XUCQrquTWaD9mwaM8/WK/g
jKg49zb9PDZy39LMWXrOeFjIZ29PYiPyxV+SCBtn5IWcEuvsYYPVd2tuwk1n
xFCT3LCvhpBuMYqPnHBG6NNJi7IzhtBZ9ohbsYsDx6VnX7suN8TiXeSScT4H
rJUKzKhaA5zkB5mFTXNwz95aHBdsgFeb0lb0eLhgRS9De6WyAXb6Npy+/dAF
3ol1d8/660O/4p4tZ44rwm/YzCwt08PfnIS9RntdUZbDLHVQ1MO3RfJfWspc
wWrZOvCDvy7W/nr5ebuKGz6L20wrnukgUMdYQf6AG+wc44f6dXUw1O+ar17l
hn7+ofcDcQvhNx59e7uuOyhfjxxp18bsc+XKjeHuyKpb2uS1URtM3vXmdfXu
6NJWmfiep4X+kKhxgbEHqKb5v+coaWFJyffoTb94gOPOPrEuQhMO60N5La0e
sBgV6P7ZroF82xl3qs32YM1qv08J1hpwS/7ZJe3UHnCixsKSHqtjlMX1Tujc
g8HlWTZ5Buroql9R57vBE2X7CE6nLYDiAo30pCRP8LnuWncVF0Dz0nD1x15P
RCdbtoSHqiHKKdxBHV6Iy33CdO2Zj/od4o2HLnvBy8y34Mju+dj1OvqMzj9e
mAgPCp8oZ2HR7w8t7uzgQlAszhxcxUJPvMjO7xYXRTrpH5CpCrlHD54yvnPh
6ibVSVRSRe6TRkHYEm88cFZJsYlWQbU5odPO3kh4KeKsFygjwSHONDLGG+d4
u5Mcr8+DlXzl4lN3vOFR+qSu03MuCtxeOya2eiM3UHTNY4kSlg0fLPxjpg9U
UhrCeEOzcW0pc13wSh/o/a4kJz6viKrvwaO6e3ywynNLqdRaAS1Bb4ReiT44
W+6qbFo7CwrGz6TPH/mAV2iSa2rJhCgi0c5I5IOENyEDqaUzcf+AbS1LheKr
RF1eYWQGfpx4f3RkPUWK3/TVaX0GYg65Zl/eIJvHdt7fr8nAX93Nz60sKCZv
717WrMJA2LuX6uc3UmTPfmCWMYOByuKK4p9BUWlQPjn85zTZHXxDHGZNcbaI
+5K5fZqEfw4MGLenKFlodEPNTkqqGsZdpH4UZca8aWezKXLmpzWCYn+KLPnA
48GGU4STenjtfh5F62FuROS8KdLr3KfZspeCfWwyKLB7krDaP7QWBVJoPHN7
nJ05Sfz6Kjz8/0NxVLTZ2HF6gsxSiOfWR1J0b564/ujJOHm1r7oxLooikidO
bcsZJxl1UrLuF4ozJSoqfcnjZHlSuEHucYr/quV1NfHGiYv6PmF0LAXf66Z9
heo44RvZ+a7+jSLvcrtJve8Y2WHJ2puRSkGTy3lSiYScGFK9aZVGgZ0pasMd
ElJ2TVU4KHPE8R95r2olZLmcqseW8xSWY9yGLVkSwqpRtu9Pp7Ax1PJnWklI
i9Vc801XKNKnPEIKEkcJz0ZBXnSLIu4343LhjBFydUze6gyfIuOCTsOG7mHS
wpePXZNH8bQo6+mhhmFiqyg/mZhPUTW4/ntQxjAxrWV+XV0ou7dXTnTWT8Nk
eMfMdyfvU6zaFaAC528kxl6aa1JOceJ2hMOsCDHJSQi/90VmnaLg9kqOmNRW
iUtynlJsTtmgZrpaTNTMPtUbVlJIJ4X62m+/Er6m4JtWDcWYRYjVr4WDpFGY
smn2C4rRVm31AfN+MqI9x0Yg8z7rAKXAzj6i6XTCMb6WYijn2eh4Sh+hz8L8
5Opl+09p+5t39xJJvkfiRIMsPznz3VwSeohe6KK3vc0UTkUvb2xK6iJbCrM+
8t9QeNseeCM06SIBXRo9vLcUE3f8y0eqO8l919lToncUyRlGWCz+TLZu/Gr4
vo3C7PSJ1JNmn8j+sIBll95TxM9TWhtZKSLJd4VmLh8oJE1rwpZsF5E2w+Zt
Te0UCW3m6docIQmaVXKwroNiSd7h2NMX/iZpZFX4KaEsH1fPtQmj28njowUx
20QUzDxrO0WfD0Su70pazSfZ/1gK/tkq30aMjTSuxH6myPwh5pF+bQux80zO
JZ0Ud1k12ctj3pELjXElpV0UWrbC/S/Km0mpwlT1sS8UW/0dBdmkiXRYHqk3
76YQdAiiL/BfE2bk4JtRmbs2xt45+rmRLC3e+/GPHoqWdwV1VUb1xH6go/tQ
L4XR4Izi0MHnJHSx+7cVfRScHZ23CkeqyUVu0+SAzH5LLw39S/iYlF+0Y97u
p2Bku6/etpNB/ge8vWft
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {83.8058, 0.}, 
          "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> Directive[12, FontFamily -> "Times"], "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {83.8058, 0.}, "ImageSize" -> {400, 400/GoldenRatio},
          "Axes" -> {True, True}, "LabelStyle" -> 
         Directive[12, FontFamily -> "Times"], "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV03s4FHgXB/BJO6EUJrnlOq+SsrWVTRf1+yqKUuhl3GL4YZKKt4jC5rJl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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {83.8058, 0.}, "ImageSize" -> {400, 400/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> 
       Directive[12, FontFamily -> "Times"], "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{83.8058, 0.},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], PointSize -> Medium, 
    PointBox[{87.2938969493787, 8.863260528563472}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(b\\)]\\)\"", TraditionalForm], {
     87.2938969493787, 8}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"Lv\\\",FontSlant->\\\"Italic\\\"]\\)/\\!\\(\\*\
StyleBox[\\\"RT\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"Temperature \
\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\) (K)\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->Directive[12, FontFamily -> "Times"],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[5]=",
 CellID->53432095,ExpressionUUID->"6afd2008-d243-4184-a297-de648be1a933"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->44497336,ExpressionUUID->"5a5b05f1-8619-4b4c-b26d-477878b44180"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "latent heat of vaporization of argon", 
   Typeset`opts$$ = {
   AppearanceElements -> {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Result", "Result", 1, 1, "Output", 
        "Quantity[6.5, \"Kilojoules\"/\"Moles\"]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {"Extrusion", "Warnings", "Assumptions", "Pods"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {"ElementData[\"Argon\", \"VaporizationHeat\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ElementData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"molar heat of vaporization\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[6.5, \"Kilojoules\"/\"Moles\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["6.5", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "6.5"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilojoules per mole\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "4"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["6500", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "6500"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"J\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"joules per mole\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1.6", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.6"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kcal\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", 
                   "\"thermochemical kilocalories per mole\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["1600", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1600"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"cal\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"calories per mole\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.067", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.067"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"eV\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"molar electronvolts\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {
   True, False, {False, False, False, False}, True}, Typeset`asyncpods$$ = {},
    Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ElementDataSourceInformationNotes.html", "text" -> "Element data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "3", "datatypes" -> 
    "Element", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.022", 
    "parsetiming" -> "0.42", "parsetimedout" -> "false", "recalculate" -> "", 
    "id" -> "MSPa611haa824i4c0c3434000031f44bf6g1d11141", "host" -> 
    "http://www5a.wolframalpha.com", "server" -> "61", "related" -> 
    "http://www5a.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa621haa824i4c0c343400002h12cd6ge45901b5&s=61", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 9, 15, 2, 34.2937116`9.287789387667981}, "Line" -> 15,
     "SessionID" -> 23599154686246328502}, Typeset`showpods$$ = {1, 2, 3}, 
   Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Result", "Result", 1, 1, "Output", 
    "Quantity[6.5, \"Kilojoules\"/\"Moles\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "latent heat of vaporization of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{560., {438., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[97]:=",
 CellID->324695186,ExpressionUUID->"37b39350-8d28-4176-8267-9651448c5765"],

Cell[BoxData[
 TemplateBox[{"6.5`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "kilojoules per mole", 
   FractionBox["\"Kilojoules\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[97]=",
 CellID->234625577,ExpressionUUID->"fc9e3b0c-892e-4d2f-868d-806dc91b793e"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "03f9d43e-4a8e-4d2f-8645-98140c08432d"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["tcNv"]], "paclet:NewEoSArgon/ref/tcNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "3d715e05-2bdf-4af0-9800-9402cbad840e"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["HtotalAdimNv"]], "paclet:NewEoSArgon/ref/HtotalAdimNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "a921c16c-ca76-4b77-b82e-38ab6a5f39c7"]
       }], "SeeAlso",ExpressionUUID->"1c535763-005a-4c30-ae66-2637fb83c3c7"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"675dc75f-9fd1-403e-9fec-\
114acb5ef0b2"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "a3d25fd0-0969-407f-b707-cb168e56ad7b"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ff1cb04c-ca6d-4a6a-ab35-\
ccf9b9fedcce"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0770c8d4-f9c0-49da-97fe-d29ab0a4b48c"]], "RelatedLinks",
        ExpressionUUID->"1e70a050-c291-4907-b2ce-1b02fd3d79b8"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ChemicalData"}]]]], 
             "paclet:ref/ChemicalData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "4eabe5f0-4b63-4835-93b7-00dc00e6d735"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "138bdd3e-7bd7-4cd9-82e3-8bf0f65101ad"]], "RelatedLinks",
        ExpressionUUID->"47deeba6-dcb0-4bc5-a919-c90988b8cbff"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"33256ed1-2452-4bbd-9e6f-\
fb201788346a"],

Cell[" ", "FooterCell",ExpressionUUID->"ce8aa30c-7aa5-411a-952b-b24adc907426"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LvapAdimNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}, 
    "NotesSection" -> Closed}, "NewStyles" -> True, 
  "CitationPopupData" -> $Failed, "ShowCitation" -> False, "RootCaptions" -> 
  "", "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 39.4351833}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "LvapAdimNv[T] \\[Congruent] Lv/RT Chaleur latente de vaporisation \
adimensionnelle de l'argon en fonction de T (Kelvin) [Non-dimensional latent \
heat of vaporization of argon versus T (Kelvin)]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "LvapAdimNv", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "LvapAdimNv", "type" -> 
    "Symbol", "uri" -> "NewEoSArgon/ref/LvapAdimNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"c3fdc0ab-290e-47d8-b8c0-f678a276249e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11196, 315, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"cf4e85ae-5518-4b1c-b78e-b2059b555252",
   CellTags->"PrimaryExamplesSection",
   CellID->370058473]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56771, 1390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 5391, 131, 56, "AnchorBarGrid",ExpressionUUID->"1cac0704-6357-49bb-b2a3-98ec202830b4",
 CellID->1],
Cell[5976, 154, 94, 0, 23, "ContextNameCell",ExpressionUUID->"cecd1953-604a-49d9-9bdc-8cb91eb918ba"],
Cell[CellGroupData[{
Cell[6095, 158, 553, 14, 56, "ObjectNameGrid",ExpressionUUID->"b1ec133c-f550-43b5-9e94-3566da2ba7a8"],
Cell[6651, 174, 669, 22, 146, "Usage",ExpressionUUID->"ce8c4619-94e4-41a8-adb0-bc9555a8d116"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7357, 201, 1919, 48, 37, "NotesSection",ExpressionUUID->"f663cd82-4349-4527-a67c-95f4cc48537d",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->137524279],
Cell[9279, 251, 804, 25, 38, "Notes",ExpressionUUID->"90ddca76-5e40-4b2e-bd96-ad1028a856a4",
 CellID->1067943069],
Cell[10086, 278, 186, 4, 36, "Notes",ExpressionUUID->"b295c68a-f5a7-409e-aec5-86a8af929d2c",
 CellID->224665577],
Cell[10275, 284, 794, 25, 38, "Notes",ExpressionUUID->"ccf21d9a-29c2-47b3-8d76-22bae288b44e",
 CellID->657169447]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11196, 315, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"cf4e85ae-5518-4b1c-b78e-b2059b555252",
 CellTags->"PrimaryExamplesSection",
 CellID->370058473],
Cell[CellGroupData[{
Cell[12641, 356, 1398, 36, 30, "ExampleSection",ExpressionUUID->"ed69cd13-54ac-4e89-b154-33ecac7124c8",
 CellID->619695073],
Cell[14042, 394, 267, 5, 42, "Input",ExpressionUUID->"f1e4dd06-b70e-46ff-a08f-6f9b30b6ab48",
 CellID->87419684],
Cell[14312, 401, 154, 1, 38, "ExampleText",ExpressionUUID->"e130c0bc-25f2-44a7-bc5a-b2cb6bfb6cf8",
 CellID->184302421],
Cell[CellGroupData[{
Cell[14491, 406, 1112, 30, 57, "Input",ExpressionUUID->"e89add7d-7a6c-4164-8efc-7fc775e64462",
 CellID->223155686],
Cell[15606, 438, 208, 4, 39, "Output",ExpressionUUID->"6b99edcb-c8c4-451d-b32f-63124629ec93",
 CellID->254174370],
Cell[15817, 444, 644, 15, 45, "Output",ExpressionUUID->"649ddb9a-162b-4a38-a10f-29b2680709ee",
 CellID->250372944]
}, Open  ]],
Cell[CellGroupData[{
Cell[16498, 464, 231, 5, 26, "Input",ExpressionUUID->"efedd3e4-917f-4590-9195-70c621bb3868",
 CellID->81775040],
Cell[16732, 471, 340, 8, 41, "Output",ExpressionUUID->"153dd898-8378-4852-8353-ee819b216a52",
 CellID->183549658]
}, Open  ]],
Cell[17087, 482, 197, 4, 38, "ExampleText",ExpressionUUID->"979bc156-df0b-4394-904a-10f282b637c8",
 CellID->261860218],
Cell[CellGroupData[{
Cell[17309, 490, 787, 22, 72, "Input",ExpressionUUID->"784ed7c7-acad-48ce-981e-0cd76fb7d734",
 CellID->109079462],
Cell[18099, 514, 314, 8, 43, "Output",ExpressionUUID->"adffc79a-0a8c-440e-afc7-fdfde70e7c23",
 CellID->557175641],
Cell[18416, 524, 209, 4, 39, "Output",ExpressionUUID->"9faadab7-6dab-4a31-be2b-8a03a38f4a9b",
 CellID->197890335],
Cell[18628, 530, 409, 10, 43, "Output",ExpressionUUID->"2b2d35f2-a311-4ec1-b3ed-0e670b0451ca",
 CellID->785431891]
}, Open  ]],
Cell[19052, 543, 167, 3, 70, "ExampleText",ExpressionUUID->"29bbef69-f0d3-4b08-b0c4-baf19a39ed04",
 CellID->886239600],
Cell[CellGroupData[{
Cell[19244, 550, 1602, 40, 70, "Input",ExpressionUUID->"bf146979-6786-4cd4-a243-c043b075c161",
 CellID->577903196],
Cell[20849, 592, 13892, 281, 70, "Output",ExpressionUUID->"6afd2008-d243-4184-a297-de648be1a933",
 CellID->53432095]
}, Open  ]],
Cell[34756, 876, 115, 1, 70, "ExampleText",ExpressionUUID->"5a5b05f1-8619-4b4c-b26d-477878b44180",
 CellID->44497336],
Cell[CellGroupData[{
Cell[34896, 881, 15028, 326, 70, "WolframAlphaShortInput",ExpressionUUID->"37b39350-8d28-4176-8267-9651448c5765",
 CellID->324695186],
Cell[49927, 1209, 327, 8, 41, "Output",ExpressionUUID->"fc9e3b0c-892e-4d2f-868d-806dc91b793e",
 CellID->234625577]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[50496, 1226, 1872, 50, 70, "SeeAlsoSection",ExpressionUUID->"675dc75f-9fd1-403e-9fec-114acb5ef0b2"],
Cell[52371, 1278, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"ff1cb04c-ca6d-4a6a-ab35-ccf9b9fedcce"],
Cell[53103, 1299, 1597, 43, 70, "RelatedLinksSection",ExpressionUUID->"33256ed1-2452-4bbd-9e6f-fb201788346a"],
Cell[54703, 1344, 78, 0, 70, "FooterCell",ExpressionUUID->"ce8aa30c-7aa5-411a-952b-b24adc907426"]
}
]
*)

(* End of internal cache information *)

