(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50603,       1205]
NotebookOptionsPosition[     45297,       1093]
NotebookOutlinePosition[     47382,       1147]
CellTagsIndexPosition[     47296,       1142]
WindowTitle->M
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "a2dbbfd7-120a-476a-9172-12e4a1f562aa"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "1d93b8f0-07b0-4001-b33f-25e146420970"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "cb55c450-48bb-4fed-ba32-5a3b269e8a17"]
         }],ExpressionUUID->"c9f73e2c-2619-4441-bcfd-4e49a8f99ea4"],
         StripOnInput->False],{
        "\"RR\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/RR"], 
         "\"vc\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/vc"], 
         "\"vtrgaz\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrgaz"], 
         "\"vtrliq\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/vtrliq"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "092b1b4c-ce33-4aee-b964-f35f263d4658"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "63f0ad8a-6ea9-44f4-a243-75813c0b4b5a"]
         }],ExpressionUUID->"2cf2c835-137c-4afc-9529-e12d70d1bee0"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "fe6928d0-595b-4d6a-b121-3a7c28ce2411"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "4b311374-ff03-4433-a757-c1c3345d8fdc"]
         }],ExpressionUUID->"c8c19020-d7d5-43af-96df-35ea3ca73ee4"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/M\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/M"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/M.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$16101], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/M" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "cae07c8e-74b2-428a-950e-c27fdcebcc52"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "a751cc2c-d759-407f-ba9f-28d5afb03815"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"0b3045be-00f3-4e96-832c-da0238ebb2a7"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"c3867712-226e-4805-83d4-2f1f95f1eadc"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "M", "ObjectName",ExpressionUUID->"f0370d93-ce48-46d6-a91e-5cd17b9d71d9"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"f7bd1080-8542-4f82-b3ca-e576ecf7c78e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "9f8869ad-235c-43ce-88de-5b2c7ca229d2"]
    }],ExpressionUUID->"cdc6686d-50e6-4044-9bb1-02b9e26c351f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"1f5dffe5-a2ab-4d61-b6f8-\
a4abd00fa6c5"],

Cell[BoxData[GridBox[{
   {"", Cell["\<\
M (g/mole)
Masse molaire de l'argon donn\[EAcute]e par NIST 
[Molar mass of argon from NIST]\
\>",ExpressionUUID->"e9a300e7-47cf-4254-a393-aae0ae39c857"]}
  }]], "Usage",
 CellID->982511436,ExpressionUUID->"17df3767-3257-4bd0-9606-ae95561d54a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"abc8d5f9-6746-4f6c-8a88-9096eb4c18d6"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b001dca0-493a-42e9-b191-1871ce83a81e"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "691ec075-e635-4dd2-a4e2-a82ec8bd15d4"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->941466781,ExpressionUUID->"ab99532d-29b5-48e7-b3f2-8727ee1c3d44"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"baf0fd51-8db9-4d06-ba2d-7f270dcf60c2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"114e3b06-6174-433f-be0a-090911f90f73"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "10e3859a-4014-41a0-a9fb-795e09aa128f"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->917081690,ExpressionUUID->"670f1fad-9aca-4096-a081-0c45893905d4"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"467da68b-9a66-4a54-955b-a51123dbfdea"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"68202b93-9142-4b67-be2f-f2eda1057762"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"M", ",", "\"\<g/mol\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"9db68383-8fc7-42c7-9c68-1667e035aa85"],

Cell[BoxData[
 TemplateBox[{"39.948`", 
   RowBox[{
    "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "grams per mole", 
   FractionBox["\"Grams\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->14202385,ExpressionUUID->"caa50188-32b0-48db-989a-44961d608f4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"39.948`"},
    "QuantityUnit",
    DisplayFunction->(TooltipBox[
      StyleBox[
       RowBox[{#, "\[InvisibleSpace]", 
         StyleBox[
          RowBox[{" ", 
            
            RowBox[{"\"g\"", "\[InvisibleSpace]", "\"/\"", 
              "\[InvisibleSpace]", "\"mol\""}]}], 
          "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
      "Unit: grams per mole"]& ),
    InterpretationFunction->(RowBox[{"Quantity", "[", 
       RowBox[{#, ",", 
         FractionBox["\"Grams\"", "\"Moles\""]}], "]"}]& )], ",", 
   "\"\<kg/mol\>\""}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[3]:=",
 CellID->32169695,ExpressionUUID->"26d41b47-26b3-42a9-97b7-3f9663203361"],

Cell[BoxData[
 TemplateBox[{"0.039948000000000004`", 
   RowBox[{
    "\"kg\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
   "kilograms per mole", 
   FractionBox["\"Kilograms\"", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->693119730,ExpressionUUID->"f17ff128-9f5f-4f76-9e01-c79b676eb30d"]
}, Open  ]],

Cell["M is used to calculate the specific gaz constant of Argon", \
"ExampleText",
 CellID->223004501,ExpressionUUID->"5adce96b-c30b-4728-8923-5bca3f7e05b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"RR", "/", "M"}], ",", "\"\<kiloJoules/(Kelvins kg)\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->469504721,ExpressionUUID->"a5ae5b46-5803-4d83-99ef-e35f0072a76d"],

Cell[BoxData[
 TemplateBox[{"0.20813332332031642`", 
   RowBox[{
    "\"kJ\"", "\[InvisibleSpace]", "\"/(\"", "\[InvisibleSpace]", "\"kg\"", 
     "\[ThinSpace]", "\"K\"", "\[InvisibleSpace]", "\")\""}], 
   "kilojoules per kilogram kelvin", 
   FractionBox["\"Kilojoules\"", 
    RowBox[{"\"Kelvins\"", " ", "\"Kilograms\""}]]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->127106984,ExpressionUUID->"4dd8d858-d2a8-432b-b22f-e7b16f9589d5"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->169290125,ExpressionUUID->"3a678cd3-9460-4014-8e73-767c1ee9e840"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "molar mass of argon", Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "ChemicalData[\"Argon\", \"MolecularWeight\"]"}, "ExtrusionOpen" -> 
      True, "Formats" -> {
       "cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement[
       "minput", {}, {"ChemicalData[\"Argon\", \"MolecularWeight\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"argon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {ChemicalData, "Argon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"molecular weight\""}}, GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,minput,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Result", "scanner" -> "Data", "id" -> "Result", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["moutput", {}, {"Quantity[39.948, \"Grams\"/\"Moles\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              TagBox[
               TagBox[
                RowBox[{
                  TagBox["39.948", 
                   $CellContext`TagBoxWrapper["StringBoxes" -> "39.948"]], 
                  "\[InvisibleSpace]", "  ", 
                  StyleBox[
                   
                   RowBox[{
                    "\"(\"", "\[NoBreak]", "\"grams per mole\"", "\[NoBreak]",
                     "\")\""}], {
                   FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], Identity], #& , SyntaxForm -> 
               Dot], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}]}], Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Unit conversion", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "300", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["0.039948", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "0.039948"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"kg\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                 SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilograms per mole\"", 
                   "\[NoBreak]", "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Comparisons", "scanner" -> "Unit", "id" -> 
     "Comparison", "position" -> "400", "error" -> "false", "numsubpods" -> 
     "3"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox[
               "\"( \"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               
               TemplateBox[{"\"\"", "0", "\".\"", "0", "5", "5"}, 
                "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "18", "\" ) \""}, 
                 "RowDefault"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molecular weight of fullerene\"", FontFamily -> "Helvetica",
                 FontSize -> Smaller, StripOnInput -> False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["721", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "721"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox[
               "\"( \"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               TemplateBox[{"\"\"", "0", "\".\"", "2", "1"}, "RowDefault"], 
               StyleBox[
                
                TemplateBox[{
                 "\" \[TildeTilde] \"", "\"1\"", "\"/\"", "5", "\" ) \""}, 
                 "RowDefault"], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                LineIndent -> 0, 
                GrayLevel[0.6], StripOnInput -> False], 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molecular weight of caffeine\"", FontFamily -> "Helvetica", 
                FontSize -> Smaller, StripOnInput -> False], "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["194", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "194"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               TemplateBox[{"\"\"", "0", "\".\"", "6", "8"}, "RowDefault"], 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"molecular weight of sodium chloride\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[TildeTilde]\[ThinSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["58", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "58"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    
                    RowBox[{
                    "\"g\"", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "\"mol\""}], FontFamily -> 
                    "Helvetica", FontSize -> Smaller]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`pod5$$ = 
   XMLElement[
   "pod", {"title" -> "Corresponding quantity", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Mass of a molecule ", 
                    Cell[
                    BoxData[
                    FormBox["m", TraditionalForm]]], " from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"m", "\[LongEqual]", 
                    
                    RowBox[{"mw", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", 
                    SubscriptBox["N", "A"]}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Mass of a molecule ", 
                    $CellContext`CalculateSymbol["m"], " from ", 
                    $CellContext`InlineForm[
                    "m \[LongEqual] mw/Subscript[N, A]"], ":"}]]]}, {
                TagBox[
                 GridBox[{{
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"6.6", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-23"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.6", "\[Times]", 
                    SuperscriptBox["10", "-23"]}]], SyntaxForm -> CenterDot], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"grams\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"6.6", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "-26"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.6", "\[Times]", 
                    SuperscriptBox["10", "-26"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"kg\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"kilograms\"", "\[NoBreak]", 
                    "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["40", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "40"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"u\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                    StyleBox[
                    
                    RowBox[{
                    "\"(\"", "\[NoBreak]", "\"unified atomic mass units\"", 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller, 
                    GrayLevel[0.6], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["40", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "40"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"daltons\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 0}}], "Column"], 
            TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False, False, False}, True}, 
   Typeset`aux5$$ = {True, False, {False}, True}, Typeset`asyncpods$$ = {}, 
   Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
ChemicalDataSourceInformationNotes.html", "text" -> "Chemical data"}, {}]}]}, 
   Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "5", "datatypes" -> 
    "Chemical", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.102", 
    "parsetiming" -> "0.373", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa5944220cda19efd60281000034b66g074h64d50i", "host" -> 
    "http://www4c.wolframalpha.com", "server" -> "48", "related" -> 
    "http://www4c.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa5945220cda19efd60281000057c9d34d3bc7c687&s=48", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 18, 4, 15.4513208`8.94154055767998}, "Line" -> 12, 
    "SessionID" -> 23597533757756335484}, Typeset`showpods$$ = {1, 2, 3, 4, 
   5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "ChemicalData[\"Argon\", \"MolecularWeight\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "molar mass of argon"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {591., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellLabel->"In[89]:=",
 CellID->156245183,ExpressionUUID->"e6349e5d-fa8d-47fa-838b-61831317cbc1"],

Cell[BoxData[
 TemplateBox[{
  "39.948`5.", "\"u\"", "unified atomic mass units", "\"AtomicMassUnit\""},
  "Quantity"]], "Output",
 CellLabel->"Out[89]=",
 CellID->597679440,ExpressionUUID->"826515e9-a3c1-45a2-86bb-51f5fe8b2bc9"]
}, Open  ]],

Cell["Using ChemicalData package", "ExampleText",
 CellID->441700581,ExpressionUUID->"3c3af3ab-480a-4aad-ae04-4b88629101c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"\"\<Argon\>\"", ",", "\"\<MolarMass\>\"", ",", "#"}], "]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<Value\>\"", ",", "\"\<Units\>\""}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->27299417,ExpressionUUID->"82de8c3d-2399-43ac-99ad-6bb43746760b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"39.948`5.", 
     RowBox[{
      "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", "\"mol\""}],
      "grams per mole", 
     FractionBox["\"Grams\"", "\"Moles\""]},
    "Quantity"], ",", "\<\"GramsPerMole\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->378321946,ExpressionUUID->"ed7f0239-12d2-42bc-8f8d-23129855f57f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RR"]], "paclet:NewEoSArgon/ref/RR", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0059fbc8-bf0f-4693-96ce-d1aee5436f55"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vc"]], "paclet:NewEoSArgon/ref/vc", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "03a851f9-0e09-4ffa-b37f-d27ee9ae306b"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrgaz"]], "paclet:NewEoSArgon/ref/vtrgaz", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "bd001c2c-440a-47ac-a0e7-188df59841a9"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["vtrliq"]], "paclet:NewEoSArgon/ref/vtrliq", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "2d272fe4-8da1-4d23-bd3d-2ae04c7612e2"]
       }], "SeeAlso",ExpressionUUID->"6ca2d292-9e00-4398-9b4c-d8286694deac"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"abc42ca4-766f-4ca7-9243-\
3dc7c6249101"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "60de8ff6-4d68-479f-8cd7-3877c78fa483"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"ebdcfce2-3fc1-42af-8491-\
5be11dc49079"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "0ef58aa3-e9ef-4ec2-9944-b462c217881e"]], "RelatedLinks",
        ExpressionUUID->"1194b0c8-30d8-44c3-8582-d171e31f84c8"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ChemicalData"}]]]], 
             "paclet:ref/ChemicalData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "27815fbe-605c-4fc7-96fa-c04df902e13a"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d3b74dd4-df0a-426c-855a-cf0ddd07162e"]], "RelatedLinks",
        ExpressionUUID->"7de7bf89-083b-45d3-9b68-34ba64d38504"]},
      {Cell[TextData[Cell[BoxData[
        RowBox[{
         TemplateBox[{16},
          "Spacer1"], "\[FilledVerySmallSquare]", Cell[BoxData[
          TemplateBox[{
            Cell[
             TextData[
              Cell[
               TextData[{
                 Cell[
                  BoxData[
                   TemplateBox[{2}, "Spacer1"]]], 
                 "Webbook de chimie NIST"}]]]], 
            "http://webbook.nist.gov/chemistry/fluid/"},
           "WebLink",
           BaseStyle->{"RelatedLinks"}]],ExpressionUUID->
          "b133c31b-14c8-4839-8693-a1204a8e4420"]}]],ExpressionUUID->
        "fc75c696-e60f-474f-82c9-b9dccdaf32a4"]], "RelatedLinks",
        ExpressionUUID->"ea001970-74a3-4c13-929f-571f5ec4e787"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"70cbe33c-5fc1-4880-a247-\
9df9a9d44b77"],

Cell[" ", "FooterCell",ExpressionUUID->"b9a8a0ae-d695-4e15-927c-ec9a96a191e5"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"M",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 40.7028236}", 
    "history" -> {"0.0", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Symbol", "language" -> "en", "paclet" -> "NewEoSArgon", 
    "status" -> "None", "summary" -> 
    "M (g/mole) Masse molaire de l'argon donn\[EAcute]e par NIST [Molar mass \
of argon from NIST]", "synonyms" -> {}, "tabletags" -> {}, "title" -> "M", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> "M", 
    "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/M"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"8b44b96a-ef0a-425e-8021-805684d3a185"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6954, 185, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"ab99532d-29b5-48e7-b3f2-8727ee1c3d44",
   CellTags->"PrimaryExamplesSection",
   CellID->941466781]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47097, 1135}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[573, 21, 5396, 131, 56, "AnchorBarGrid",ExpressionUUID->"0b3045be-00f3-4e96-832c-da0238ebb2a7",
 CellID->1],
Cell[5972, 154, 94, 0, 23, "ContextNameCell",ExpressionUUID->"c3867712-226e-4805-83d4-2f1f95f1eadc"],
Cell[CellGroupData[{
Cell[6091, 158, 537, 13, 56, "ObjectNameGrid",ExpressionUUID->"1f5dffe5-a2ab-4d61-b6f8-a4abd00fa6c5"],
Cell[6631, 173, 286, 7, 146, "Usage",ExpressionUUID->"17df3767-3257-4bd0-9606-ae95561d54a3",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6954, 185, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"ab99532d-29b5-48e7-b3f2-8727ee1c3d44",
 CellTags->"PrimaryExamplesSection",
 CellID->941466781],
Cell[CellGroupData[{
Cell[8399, 226, 1398, 36, 30, "ExampleSection",ExpressionUUID->"670f1fad-9aca-4096-a081-0c45893905d4",
 CellID->917081690],
Cell[9800, 264, 174, 3, 26, "Input",ExpressionUUID->"467da68b-9a66-4a54-955b-a51123dbfdea",
 CellID->87419684],
Cell[9977, 269, 139, 1, 38, "ExampleText",ExpressionUUID->"68202b93-9142-4b67-be2f-f2eda1057762",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10141, 274, 193, 4, 26, "Input",ExpressionUUID->"9db68383-8fc7-42c7-9c68-1667e035aa85",
 CellID->21488140],
Cell[10337, 280, 317, 8, 43, "Output",ExpressionUUID->"caa50188-32b0-48db-989a-44961d608f4b",
 CellID->14202385]
}, Open  ]],
Cell[CellGroupData[{
Cell[10691, 293, 775, 21, 26, "Input",ExpressionUUID->"26d41b47-26b3-42a9-97b7-3f9663203361",
 CellID->32169695],
Cell[11469, 316, 341, 8, 43, "Output",ExpressionUUID->"f17ff128-9f5f-4f76-9e01-c79b676eb30d",
 CellID->693119730]
}, Open  ]],
Cell[11825, 327, 157, 2, 38, "ExampleText",ExpressionUUID->"5adce96b-c30b-4728-8923-5bca3f7e05b9",
 CellID->223004501],
Cell[CellGroupData[{
Cell[12007, 333, 240, 6, 26, "Input",ExpressionUUID->"a5ae5b46-5803-4d83-99ef-e35f0072a76d",
 CellID->469504721],
Cell[12250, 341, 453, 10, 43, "Output",ExpressionUUID->"4dd8d858-d2a8-432b-b22f-e7b16f9589d5",
 CellID->127106984]
}, Open  ]],
Cell[12718, 354, 116, 1, 38, "ExampleText",ExpressionUUID->"3a678cd3-9460-4014-8e73-767c1ee9e840",
 CellID->169290125],
Cell[CellGroupData[{
Cell[12859, 359, 25529, 536, 627, "WolframAlphaShortInput",ExpressionUUID->"e6349e5d-fa8d-47fa-838b-61831317cbc1",
 CellID->156245183],
Cell[38391, 897, 229, 5, 39, "Output",ExpressionUUID->"826515e9-a3c1-45a2-86bb-51f5fe8b2bc9",
 CellID->597679440]
}, Open  ]],
Cell[38635, 905, 124, 1, 70, "ExampleText",ExpressionUUID->"3c3af3ab-480a-4aad-ae04-4b88629101c5",
 CellID->441700581],
Cell[CellGroupData[{
Cell[38784, 910, 343, 9, 70, "Input",ExpressionUUID->"82de8c3d-2399-43ac-99ad-6bb43746760b",
 CellID->27299417],
Cell[39130, 921, 396, 10, 43, "Output",ExpressionUUID->"ed7f0239-12d2-42bc-8f8d-23129855f57f",
 CellID->378321946]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[39768, 940, 2369, 64, 70, "SeeAlsoSection",ExpressionUUID->"abc42ca4-766f-4ca7-9243-3dc7c6249101"],
Cell[42140, 1006, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"ebdcfce2-3fc1-42af-8491-5be11dc49079"],
Cell[42872, 1027, 2340, 62, 70, "RelatedLinksSection",ExpressionUUID->"70cbe33c-5fc1-4880-a247-9df9a9d44b77"],
Cell[45215, 1091, 78, 0, 70, "FooterCell",ExpressionUUID->"b9a8a0ae-d695-4e15-927c-ec9a96a191e5"]
}
]
*)

(* End of internal cache information *)

