(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32772,        813]
NotebookOptionsPosition[     27251,        696]
NotebookOutlinePosition[     29316,        750]
CellTagsIndexPosition[     29231,        745]
WindowTitle->Na
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "125910a4-0aea-455e-8441-edbd9c30b9a6"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "e2a2f649-9560-4f7f-893d-86e12d782a65"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "fdb2bb92-bf1a-4ddd-8907-0e59dc722114"]
         }],ExpressionUUID->"69ede8a2-186d-4e9f-ac13-6dce82480181"],
         StripOnInput->False],{
        "\"RR\"" :> Documentation`HelpLookup["paclet:NewEoSArgon/ref/RR"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "af12d6cc-7e21-4fae-bc5b-48beabee8f23"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "4a37c5cf-314b-4dc3-921b-02fef5c933b4"]
         }],ExpressionUUID->"3054eb85-97df-4cda-905b-403e3c380439"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "4b46d3d4-b842-4ff2-a30e-50ab54dbe09c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "b6cf101d-3f34-48c6-a1ed-53399390cec0"]
         }],ExpressionUUID->"3d5336cf-c353-46b3-b278-5b3192ecd304"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/Na\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/Na"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/Na.\
html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, Visible -> 
               False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$16604], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/Na" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "c61660e9-448d-4e6f-8831-bcdc2bb7030e"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "b8fb3b64-a24e-4f7a-bca2-bb0ac2d52409"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"de4b80ee-f747-48d3-be10-88f9a9100913"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"cb9a9060-e118-4744-8154-11cec16b2152"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "Na", "ObjectName",ExpressionUUID->
      "ff422049-d07f-42a5-a1fa-adda6bc60e8b"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"a2d41957-324f-40b2-bb6e-f3077e8804ba"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "0b8f3868-d522-4769-8ee6-69917af7236f"]
    }],ExpressionUUID->"5297646b-d36c-454d-9249-09895cb55f9f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"56cb1ef2-9067-4ba1-8830-\
d7fa2d97f85d"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "Na (",
     Cell[BoxData[
      SuperscriptBox["mole", 
       RowBox[{"-", "1"}]]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "ba3d8cef-b53f-4041-833c-5229320878c6"],
     ")\nNombre d'Avogadro \n[Avogadro constant]"
    }],ExpressionUUID->"391e284b-90f3-457f-b98e-56683dd4753a"]}
  }]], "Usage",ExpressionUUID->"d57c5529-7337-47d5-a3dd-a400f6059986"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"22b3cfa8-8592-4af8-8f87-014bb7774747"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f297824c-7321-495a-800c-a90abc6b3eab"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "bccc5d28-31c0-49dc-b925-5c7062dfbbdc"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->239000610,ExpressionUUID->"bc06ac9a-9eac-47b0-b1f6-9651a6ddea4d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"9beb3c41-2935-4f3e-95b8-b0af69d4d618"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"a8b71704-09e7-4eb5-94ae-703f8153c464"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "10397f10-f413-4019-9e15-516e90352492"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->710611806,ExpressionUUID->"5dd39ab1-fff1-4cb2-ac5e-c89de4d1dadc"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"00a19dd0-17a0-4e8d-b875-c3fc3b552fe1"],

Cell["Give a physical dimension to the constant", "ExampleText",
 CellID->886239600,ExpressionUUID->"ec3dbb0a-c989-4184-a5b4-a7dc29abfb64"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", 
  RowBox[{"Na", ",", 
   RowBox[{"1", "/", "\"\<Moles\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21488140,ExpressionUUID->"df758d21-9562-496c-9faa-afd57df6693a"],

Cell[BoxData[
 TemplateBox[{"6.022141789999999`*^23", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"mol\""}], "reciprocal moles", 
   FractionBox["1", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[2]=",
 CellID->53329050,ExpressionUUID->"4708a324-4d8d-4eaf-b885-a8f573643540"]
}, Open  ]],

Cell[TextData[{
 "Comparison with Universal Gas Constant given by the ",
 ButtonBox["Units package",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Units"]
}], "ExampleText",
 CellID->388741439,ExpressionUUID->"f0be0cfb-9f6a-4b03-949e-9b2d0a735006"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantity", "[", "\"\<AvogadroConstant\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3891385,ExpressionUUID->"cfe17777-8811-4206-a41d-8d071e20e0bc"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox["\[InvisibleSpace]", 1], 
   SubscriptBox[
    StyleBox["\"N\"", Italic, StripOnInput -> False], 
    StyleBox["\"A\"", Italic, StripOnInput -> False]], "Avogadro constant", 
   "\"AvogadroConstant\""},
  "Quantity"]], "Output",
 CellLabel->"Out[3]=",
 CellID->375706493,ExpressionUUID->"295a1fd8-9649-44cf-82da-6611276bc74c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  TemplateBox[{"1"},
   "QuantityUnit",
   DisplayFunction->(TooltipBox[
     StyleBox[
      RowBox[{#, "\[InvisibleSpace]", 
        StyleBox[
         RowBox[{" ", "\"Avogadro constants\""}], 
         "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
     "Unit: Avogadro constants"]& ),
   InterpretationFunction->(RowBox[{"Quantity", "[", 
      RowBox[{#, ",", "\"AvogadroConstant\""}], "]"}]& )], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[4]:=",
 CellID->345203758,ExpressionUUID->"2673698f-ce9f-4ceb-9807-f2fa722c4d9d"],

Cell[BoxData[
 TemplateBox[{"602214076000000000000000", 
   RowBox[{"\"/\"", "\[InvisibleSpace]", "\"mol\""}], "reciprocal moles", 
   FractionBox["1", "\"Moles\""]},
  "Quantity"]], "Output",
 CellLabel->"Out[4]=",
 CellID->96532231,ExpressionUUID->"ac159ad4-abed-4902-894d-2ad859915d83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantityMagnitude", "[", 
  TemplateBox[{"6.0221412899999996864102`7.047357180783781*^23"},
   "QuantityUnit",
   DisplayFunction->(TooltipBox[
     StyleBox[
      RowBox[{#, "\[InvisibleSpace]", 
        StyleBox[
         RowBox[{"\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
         "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
     "Unit: reciprocal moles"]& ),
   InterpretationFunction->(RowBox[{"Quantity", "[", 
      RowBox[{#, ",", 
        FractionBox["1", "\"Moles\""]}], "]"}]& )], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[5]:=",
 CellID->213591269,ExpressionUUID->"400fb14f-5d0e-4903-9f0c-ac319e36c776"],

Cell[BoxData["6.0221412899999996864102`7.047357180783781*^23"], "Output",
 CellLabel->"Out[5]=",
 CellID->70766588,ExpressionUUID->"fc092037-9f4c-455d-a66b-801443f67e55"]
}, Open  ]],

Cell["Using WolframAlpha", "ExampleText",
 CellID->537541240,ExpressionUUID->"8cf02e33-434d-4d93-8bbf-ef00b4f1c1e9"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "Avogadro constant", Typeset`opts$$ = {
   AppearanceElements -> {
     "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
    Asynchronous -> All, 
    Method -> {
     "ExtrusionChosen" -> {
       "Fast parse", "Fast parse", 1, 0, "Input", 
        "Quantity[1, \"AvogadroConstant\"]"}, "ExtrusionOpen" -> True, 
      "Formats" -> {"cell", "minput", "moutput", "msound", "dataformats"}}}, 
   Typeset`elements$$ = {
   "Extrusion", "Warnings", "Assumptions", "Pods", "Unsuccessful"}, 
   Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["minput", {}, {"Quantity[1, \"AvogadroConstant\"]"}], 
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              TagBox[
               RowBox[{
                 StyleBox[
                 "\"Avogadro constant\"", 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                   Smaller}, StripOnInput -> False]}], Identity], 
              PolynomialForm[#, TraditionalOrder -> False]& ], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext,minput"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Value", "scanner" -> "Unit", "id" -> "Value", 
     "position" -> "200", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox[
                    RowBox[{"6.022141", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "23"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.022141", "\[Times]", 
                    SuperscriptBox["10", "23"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    SuperscriptBox["\"mol\"", 
                    RowBox[{"-", "1"}]], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"reciprocal moles\"", "\[NoBreak]",
                    "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "Comparison", "scanner" -> "Unit", "id" -> "Comparison",
      "position" -> "300", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             TemplateBox[{"\" \[TildeTilde] \"", 
               StyleBox[
               "\"Avogadro constant (Fox/Hill proposed value)\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[MediumSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"6.022", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "23"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"6.022", "\[Times]", 
                    SuperscriptBox["10", "23"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{"\"/\"", "\[InvisibleSpace]", "\"mol\""}], 
                    FontFamily -> "Helvetica", FontSize -> Smaller]}], 
                    Identity], #& , SyntaxForm -> Dot], "Unit", SyntaxForm -> 
                    Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, ZeroWidthTimes -> False], 
                    "\"\[MediumSpace]\""}, "RowDefault"], "\[NoBreak]", 
                  "\")\""}], {FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output"]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`pod4$$ = 
   XMLElement[
   "pod", {"title" -> "Interpretation", "scanner" -> "Unit", "id" -> 
     "Interpretation", "position" -> "400", "error" -> "false", "numsubpods" -> 
     "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox["\"inverse amount\"", Identity], TraditionalForm]], 
          "Output"]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Basic unit dimensions", "scanner" -> "Unit", "id" -> 
     "BasicUnitDimensions", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             TemplateBox[{"\"[amount]\"", 
               RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox], HoldForm], TraditionalForm]], "Output"]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,formuladata"}]}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False}, True}, Typeset`aux5$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, 
   Typeset`nonpods$$ = {}, Typeset`initdone$$ = True, Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "5", "datatypes" -> 
    "Quantity", "timedout" -> "", "timedoutpods" -> "", "timing" -> "1.015", 
    "parsetiming" -> "0.148", "parsetimedout" -> "false", "recalculate" -> "",
     "id" -> "MSPa7308200g6aid0aecace500002520bai08da58b71", "host" -> 
    "http://www4b.wolframalpha.com", "server" -> "64", "related" -> 
    "http://www4b.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa7309200g6aid0aecace500003ca5aicbh7b65d3b&s=64", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> 1., 
    "Date" -> {2014, 2, 6, 16, 38, 41.7556405`9.373290027152413}, "Line" -> 
    18, "SessionID" -> 23597498814303192354}, Typeset`showpods$$ = {1, 2, 3, 
   4, 5}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {
   "Fast parse", "Fast parse", 1, 0, "Input", 
    "Quantity[1, \"AvogadroConstant\"]"}, Typeset`open$$ = True, 
   Typeset`newq$$ = "Avogadro constant"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$}, Typeset`chosen$$, Typeset`open$$, 
        Typeset`elements$$, Typeset`q$$, Typeset`opts$$, Typeset`nonpods$$, 
        Typeset`queryinfo$$, Typeset`sessioninfo$$, Typeset`showpods$$, 
        Typeset`failedpods$$, Typeset`newq$$}]], StandardForm],
    ImageSizeCache->{560., {418., 19.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$}], Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "WolframAlphaShortInput",
 CellID->486607920,ExpressionUUID->"49308fa8-ea7e-4a2d-b1d3-0b171e97b7c8"],

Cell[BoxData[
 TemplateBox[{"1"},
  "QuantityUnit",
  DisplayFunction->(TooltipBox[
    StyleBox[
     RowBox[{#, "\[InvisibleSpace]", 
       StyleBox[
        RowBox[{" ", "\"Avogadro constants\""}], 
        "QuantityUnitTraditionalLabel"]}], ShowStringCharacters -> False], 
    "Unit: Avogadro constants"]& ),
  InterpretationFunction->(RowBox[{"Quantity", "[", 
     RowBox[{#, ",", "\"AvogadroConstant\""}], "]"}]& )]], "Output",
 CellLabel->"Out[17]=",
 CellID->225838921,ExpressionUUID->"5b9273cd-a66b-4d43-bf76-dc09be655a41"]
}, Open  ]],

Cell[TextData[{
 "Checking the relationship R = Na\[Cross]",
 Cell[BoxData[
  SubscriptBox["k", "B"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "7d91665b-38f0-4f77-a7f7-e076f6792340"],
 "?"
}], "ExampleText",
 CellID->564943200,ExpressionUUID->"ff50466f-3ef8-4a15-b577-b4cfd81abedf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitSimplify", "@", 
   RowBox[{"UnitConvert", "[", 
    RowBox[{
     RowBox[{"Quantity", "[", "\"\<BoltzmannConstant\>\"", "]"}], "*", 
     RowBox[{"Quantity", "[", "\"\<AvogadroConstant\>\"", "]"}]}], "]"}]}], "==", 
  RowBox[{"Quantity", "[", "\"\<MolarGasConstant\>\"", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->263083916,ExpressionUUID->"a34cc96c-5a6b-4c94-9ffa-fbd092ad760b"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[6]=",
 CellID->193146094,ExpressionUUID->"ad0dcfac-bb80-4552-8b35-d1ec564d8459"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[Cell[BoxData[
        TemplateBox[{
          Cell[
           TextData["RR"]], "paclet:NewEoSArgon/ref/RR", 
          "NewEoSArgon Package Symbol"},
         "PackageLink",
         BaseStyle->"InlineFormula"]], "InlineFormula",
        FontFamily->"Source Sans Pro",ExpressionUUID->
        "d6313609-c75b-4c9e-98ba-47aeed00d2b2"]], "SeeAlso",ExpressionUUID->
        "0b7f83b6-f087-4472-a269-01d8c22bbd2a"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"262829f3-e8d1-4581-abf7-\
444705b94985"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "9f5d8135-f85f-4d03-abc5-8c9d87605ebd"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"376b34bf-bc51-4805-9190-\
d11da8c55fc1"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "427e1787-a3e0-4654-82f5-e05aa42d1e85"]], "RelatedLinks",
        ExpressionUUID->"ec20ad4a-bbfc-4961-84ad-c987e751d8a9"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"b697572e-7c08-4258-979e-\
945507c320a4"],

Cell[" ", "FooterCell",ExpressionUUID->"a5f62bcb-7c7c-4b10-b7b2-2d7d438835a9"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Na",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, "ExampleSection" -> {"0" -> Open}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 41.7229329}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "Na (mole -1) Nombre d'Avogadro [Avogadro constant]", "synonyms" -> {}, 
    "tabletags" -> {}, "title" -> "Na", "titlemodifier" -> "", 
    "metadescription" -> "", "windowtitle" -> "Na", "type" -> "Symbol", "uri" -> 
    "NewEoSArgon/ref/Na"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"c7f494be-5a32-4b73-b4dd-ce8239b9916c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6861, 184, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"bc06ac9a-9eac-47b0-b1f6-9651a6ddea4d",
   CellTags->"PrimaryExamplesSection",
   CellID->239000610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29032, 738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[574, 21, 5141, 126, 56, "AnchorBarGrid",ExpressionUUID->"de4b80ee-f747-48d3-be10-88f9a9100913",
 CellID->1],
Cell[5718, 149, 94, 0, 23, "ContextNameCell",ExpressionUUID->"cb9a9060-e118-4744-8154-11cec16b2152"],
Cell[CellGroupData[{
Cell[5837, 153, 545, 14, 56, "ObjectNameGrid",ExpressionUUID->"56cb1ef2-9067-4ba1-8830-d7fa2d97f85d"],
Cell[6385, 169, 439, 10, 146, "Usage",ExpressionUUID->"d57c5529-7337-47d5-a3dd-a400f6059986"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6861, 184, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"bc06ac9a-9eac-47b0-b1f6-9651a6ddea4d",
 CellTags->"PrimaryExamplesSection",
 CellID->239000610],
Cell[CellGroupData[{
Cell[8306, 225, 1398, 36, 30, "ExampleSection",ExpressionUUID->"5dd39ab1-fff1-4cb2-ac5e-c89de4d1dadc",
 CellID->710611806],
Cell[9707, 263, 174, 3, 26, "Input",ExpressionUUID->"00a19dd0-17a0-4e8d-b875-c3fc3b552fe1",
 CellID->87419684],
Cell[9884, 268, 139, 1, 38, "ExampleText",ExpressionUUID->"ec3dbb0a-c989-4184-a5b4-a7dc29abfb64",
 CellID->886239600],
Cell[CellGroupData[{
Cell[10048, 273, 218, 5, 26, "Input",ExpressionUUID->"df758d21-9562-496c-9faa-afd57df6693a",
 CellID->21488140],
Cell[10269, 280, 287, 6, 43, "Output",ExpressionUUID->"4708a324-4d8d-4eaf-b885-a8f573643540",
 CellID->53329050]
}, Open  ]],
Cell[10571, 289, 251, 6, 38, "ExampleText",ExpressionUUID->"f0be0cfb-9f6a-4b03-949e-9b2d0a735006",
 CellID->388741439],
Cell[CellGroupData[{
Cell[10847, 299, 180, 3, 26, "Input",ExpressionUUID->"cfe17777-8811-4206-a41d-8d071e20e0bc",
 CellID->3891385],
Cell[11030, 304, 376, 9, 42, "Output",ExpressionUUID->"295a1fd8-9649-44cf-82da-6611276bc74c",
 CellID->375706493]
}, Open  ]],
Cell[CellGroupData[{
Cell[11443, 318, 602, 15, 26, "Input",ExpressionUUID->"2673698f-ce9f-4ceb-9807-f2fa722c4d9d",
 CellID->345203758],
Cell[12048, 335, 289, 6, 41, "Output",ExpressionUUID->"ac159ad4-abed-4902-894d-2ad859915d83",
 CellID->96532231]
}, Open  ]],
Cell[CellGroupData[{
Cell[12374, 346, 677, 16, 30, "Input",ExpressionUUID->"400fb14f-5d0e-4903-9f0c-ac319e36c776",
 CellID->213591269],
Cell[13054, 364, 170, 2, 36, "Output",ExpressionUUID->"fc092037-9f4c-455d-a66b-801443f67e55",
 CellID->70766588]
}, Open  ]],
Cell[13239, 369, 116, 1, 38, "ExampleText",ExpressionUUID->"8cf02e33-434d-4d93-8bbf-ef00b4f1c1e9",
 CellID->537541240],
Cell[CellGroupData[{
Cell[13380, 374, 9723, 198, 454, "WolframAlphaShortInput",ExpressionUUID->"49308fa8-ea7e-4a2d-b1d3-0b171e97b7c8",
 CellID->486607920],
Cell[23106, 574, 535, 13, 35, "Output",ExpressionUUID->"5b9273cd-a66b-4d43-bf76-dc09be655a41",
 CellID->225838921]
}, Open  ]],
Cell[23656, 590, 310, 8, 70, "ExampleText",ExpressionUUID->"ff50466f-3ef8-4a15-b577-b4cfd81abedf",
 CellID->564943200],
Cell[CellGroupData[{
Cell[23991, 602, 427, 9, 70, "Input",ExpressionUUID->"a34cc96c-5a6b-4c94-9ffa-fbd092ad760b",
 CellID->263083916],
Cell[24421, 613, 129, 2, 35, "Output",ExpressionUUID->"ad0dcfac-bb80-4552-8b35-d1ec564d8459",
 CellID->193146094]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[24792, 624, 814, 21, 70, "SeeAlsoSection",ExpressionUUID->"262829f3-e8d1-4581-abf7-444705b94985"],
Cell[25609, 647, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"376b34bf-bc51-4805-9190-d11da8c55fc1"],
Cell[26341, 668, 825, 24, 70, "RelatedLinksSection",ExpressionUUID->"b697572e-7c08-4258-979e-945507c320a4"],
Cell[27169, 694, 78, 0, 70, "FooterCell",ExpressionUUID->"a5f62bcb-7c7c-4b10-b7b2-2d7d438835a9"]
}
]
*)

(* End of internal cache information *)

