(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    124910,       2623]
NotebookOptionsPosition[    117774,       2481]
NotebookOutlinePosition[    120242,       2542]
CellTagsIndexPosition[    120118,       2536]
WindowTitle->PArgonNv
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["NEW EO S ARGON PACKAGE SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "ad43b5c6-ce1b-4184-8365-5676e4a7bc03"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "b064b3b4-951a-44b9-a1a2-2f8115ab9a5e"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[{
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "See Also",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "8fe9791f-82f7-40eb-9651-2880fa5894dd"]
         }],ExpressionUUID->"a78c7c18-e1d6-4d75-a596-dd9b5a601f28"],
         StripOnInput->False],{
        "\"RhoArgonNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/RhoArgonNv"], 
         "\"ZtotalNv\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/ref/ZtotalNv"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"SeeAlso"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "0f8ac474-64e1-41dc-8d40-71967d030876"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "Related Guides",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "35b94a5c-2e15-4b9a-9b90-7abebc9f2cc0"]
         }],ExpressionUUID->"b98228d8-08ac-40a9-a168-9425de4d5e37"],
         StripOnInput->False],{
        "\"NewEoSArgon Package\"" :> 
         Documentation`HelpLookup["paclet:NewEoSArgon/guide/NewEoSArgon"]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"MoreAbout"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "9cb1bfb6-7573-40f4-83f7-b3b67bc1cc4c"],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      TagBox[
       ActionMenuBox[
        FrameBox[Cell[TextData[{
          "URL",
          " ",
          Cell[BoxData[
           GraphicsBox[
            {GrayLevel[0.66667], Thickness[0.13], 
             LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
            AspectRatio->1,
            ImageSize->20,
            PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
           "82aefe6f-ca4a-4efa-8365-c2d698735d3c"]
         }],ExpressionUUID->"73638f73-5d2a-4954-8c63-ba2da364f422"],
         StripOnInput->False],{
        "\"NewEoSArgon/ref/PArgonNv\"" :> None, 
         "\"Copy Wolfram Documentation Center URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{Cell["NewEoSArgon/ref/PArgonNv"]}, Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
         "\"Copy web URL\"" :> 
         Module[{DocumentationSearch`Private`nb$}, 
           DocumentationSearch`Private`nb$ = 
            NotebookPut[
             Notebook[{
               Cell[BoxData[
                 MakeBoxes[
                  Hyperlink[
                   "http://reference.wolfram.com/language/NewEoSArgon/ref/\
PArgonNv.html"], StandardForm]], "Input", TextClipboardType -> "PlainText"]}, 
               Visible -> False]]; 
           SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
           FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
           NotebookClose[DocumentationSearch`Private`nb$]; Null], 
         "\"Go to web URL\"" :> 
         FrontEndExecute[{
           NotebookLocate[{
             URL[If[TrueQ[DocumentationBuild`Make`Private`wsmlinkQ$17530], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "NewEoSArgon/ref/PArgonNv" <> ".html"], None}]}]},
        Appearance->None,
        MenuAppearance->Automatic,
        MenuStyle->"URLMenu"],
       MouseAppearanceTag["LinkHand"]]],
      LineSpacing->{1.4, 0},ExpressionUUID->
      "43da9b96-5a5e-4329-bb74-b85870457c39"]
    }], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "3723db94-6178-4e94-af3b-45b7ae382271"]}
  }]], "AnchorBarGrid",
 CellID->1,ExpressionUUID->"8c982409-7a48-4e69-9034-b21f73267270"],

Cell["NewEoSArgon`", "ContextNameCell",ExpressionUUID->"b1b7dfa6-8983-44ad-96cb-e2d3e3d94391"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PArgonNv", "ObjectName",ExpressionUUID->
      "df95d7c1-3f95-4275-a9b4-d01acb08f158"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"12ae1a40-addb-468f-a0e7-42ab758d611e"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "2536aae2-d5c6-4cf5-b528-10d4301784ce"]
    }],ExpressionUUID->"aa60b89f-16b5-4d7f-81a8-96bde94a0101"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"fe5b7fb5-afb9-48f5-9612-\
aad0eb084500"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     "PArgonNv[",
     StyleBox["T",
      FontSlant->"Italic"],
     ", \[Rho]] \[Congruent] ",
     StyleBox["P",
      FontSlant->"Italic"],
     " (bar)\nPression de l'argon en fonction de ",
     StyleBox["T",
      FontSlant->"Italic"],
     " (Kelvin) et de \[Rho] (g/",
     Cell[BoxData[
      SuperscriptBox["cm", "3"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "7a7be4a3-3749-45d6-8563-940a40d9449c"],
     ")\n[Thermal equation of state of argon ",
     StyleBox["P",
      FontSlant->"Italic"],
     "(",
     StyleBox["T",
      FontSlant->"Italic"],
     ",\[Rho])]"
    }],ExpressionUUID->"35bb89da-4e37-49ff-8723-eb675f9a1a5a"]}
  }]], "Usage",ExpressionUUID->"fd9fbca7-8d07-4a46-b499-5d1f0b563308"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"7b46cb95-a5be-4139-a200-8d9ae6e85287"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"c3eca91c-86f8-4a00-bb4a-12a76eada125"],
   "Details and Options"
  }], "NotesFrameText",ExpressionUUID->"3a3ac21f-608a-4e50-9cbb-5e40f9021bf6"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"cc6db548-56ed-481c-a46a-0f258f39d1a3"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->883678972,ExpressionUUID->"e428873e-3072-4d9d-83be-c8884f8aecfe"],

Cell[TextData[{
 "La fonction est d\[EAcute]finie pour ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "64c94e78-7475-4376-8f6d-db9e9e4ea04a"],
 " et \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->1067943069,ExpressionUUID->"230e0a6a-8e83-4971-b4bc-dc4b78145dea"],

Cell[TextData[{
 "La fonction ",
 StyleBox["P",
  FontSlant->"Italic"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) est ici d\[EAcute]termin\[EAcute]e \[AGrave] partir de la \
relation suivante: ",
 StyleBox["P",
  FontSlant->"Italic"],
 " = \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 "\[Times]",
 StyleBox["Z",
  FontSlant->"Italic"]
}], "Notes",
 CellID->524000197,ExpressionUUID->"9cf179f1-d64b-47aa-8380-4571e8a46fcc"],

Cell["\<\
******************************************************************************\
******\
\>", "Notes",
 CellID->224665577,ExpressionUUID->"749711d9-fb83-4289-aa60-4a6b3cfed489"],

Cell[TextData[{
 "The function is defined for ",
 StyleBox["T",
  FontSlant->"Italic"],
 " \[GreaterEqual] ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["ttr"]], "paclet:NewEoSArgon/ref/ttr", 
    "NewEoSArgon Package Symbol"},
   "PackageLink",
   BaseStyle->"InlineFormula"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "5fd7c879-b5a3-4cc0-a6e6-42b787672bd2"],
 " and \[Rho] \[GreaterEqual] 0"
}], "Notes",
 CellID->51803587,ExpressionUUID->"5f98246a-f43c-4714-8941-8837c7612f29"],

Cell[TextData[{
 "The function ",
 StyleBox["P",
  FontSlant->"Italic"],
 "(",
 StyleBox["T",
  FontSlant->"Italic"],
 ", \[Rho]) is determined here from the following relationship: ",
 StyleBox["P",
  FontSlant->"Italic"],
 " = \[Rho]",
 StyleBox["RT",
  FontSlant->"Italic"],
 "\[Times]",
 StyleBox["Z",
  FontSlant->"Italic"]
}], "Notes",
 CellID->508850368,ExpressionUUID->"b19414f3-ac1c-4c74-9a89-5e336321ece2"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"3d9f0f77-6035-41d3-a0af-572710b65954"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f14edf0d-13d9-4366-be63-d33386c6d271"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "e5e8df0a-219a-4b86-b91d-917c212b0ce3"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->147787628,ExpressionUUID->"219113df-1ffa-4db9-bbb8-25bc9b405287"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"7fc0fc55-c3eb-4b54-b624-3759aa6d7f63"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"19b121fa-5a1e-4fb7-aacd-9fb65b0ffb7a"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "5f15aa85-10cf-4ffb-8eb7-9022f701a0db"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->69832724,ExpressionUUID->"1c18321b-8c5f-40ef-826b-bb2bfb2386d8"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87419684,ExpressionUUID->"35e99a34-5a60-4dea-b48d-de760fa53cc0"],

Cell["Relative error with NIST constant", "ExampleText",
 CellID->32289193,ExpressionUUID->"7871ad83-e8cc-49e2-9a20-2ad7b06ace52"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "\"\<At the triple point:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"ptr", "-", 
       RowBox[{"PArgonNv", "[", 
        RowBox[{"ttr", ",", "\[Rho]trliq"}], "]"}]}], ")"}], "/", "ptr"}]}], 
   ",", "\"\<%\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quantity", "[", 
   RowBox[{
    RowBox[{"100", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ptr", "-", 
        RowBox[{"PArgonNv", "[", 
         RowBox[{"ttr", ",", "\[Rho]trgaz"}], "]"}]}], ")"}], "/", "ptr"}]}], 
    ",", "\"\<%\>\""}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<At the critical point:\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quantity", "[", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"pc", "-", 
       RowBox[{"PArgonNv", "[", 
        RowBox[{"tc", ",", "\[Rho]c"}], "]"}]}], ")"}], "/", "pc"}]}], ",", 
   "\"\<%\>\""}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->86367826,ExpressionUUID->"7c0b9a1d-d732-4fd5-b4b9-0b8ac989d5e0"],

Cell[BoxData["\<\"At the triple point:\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[79]:=",
 CellID->191458455,ExpressionUUID->"5c55f0af-beb7-4e8a-b37f-80ffe5591c77"],

Cell[BoxData[
 TemplateBox[{"0.0003959075337078828`", "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->134042620,ExpressionUUID->"f91e5c4e-290c-4194-881e-5ece998a715e"],

Cell[BoxData[
 TemplateBox[{"0.00002549293993111627`", "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->562112683,ExpressionUUID->"a31e8770-5e92-4c66-9223-a229129e6087"],

Cell[BoxData["\<\"At the critical point:\"\>"], "Print",
 CellLabel->"Lors de l\[CloseCurlyQuote]\[EAcute]valuation de In[79]:=",
 CellID->292273912,ExpressionUUID->"9fba29c1-d54b-4970-b978-954b142d4608"],

Cell[BoxData[
 TemplateBox[{"0.0003853774160310003`", "\"%\"", "percent", "\"Percent\""},
  "QuantityPostfix"]], "Output",
 CellLabel->"Out[2]=",
 CellID->259895498,ExpressionUUID->"a0d327b2-f510-4069-864c-d653b606dbe5"]
}, Open  ]],

Cell["Pressure on the saturation curve from NIST", "ExampleText",
 CellID->286706321,ExpressionUUID->"35f0cc77-f663-4ba5-b4b4-a0c772c96a96"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PArgonNv", "[", 
      RowBox[{
       RowBox[{"TSatNIST", "[", "\[Rho]", "]"}], ",", "\[Rho]"}], "]"}], ",", 
     RowBox[{"PRhoSatNIST", "[", "\[Rho]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "\[Rho]trgaz", ",", "\[Rho]trliq"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Dashed", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Rho]c", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Rho] (g/\!\(\*SuperscriptBox[\(cm\), \(3\)]\))\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)(bar)\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{"\"\<Expressions\>\"", ",", "Below"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->605199954,ExpressionUUID->"a323a525-9eae-455b-81ab-3aa395ffaa9a"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3X9MY/t95/8PjGfG914nl2S5qZOwCbehDUlRw23JLptlt6ShW6rQlk2J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    "], {{0, 325.}, {450., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    SmoothingQuality->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{450., 325.},
  PlotRange->{{0, 450.}, {0, 325.}}]], "Output",
 CellTags->"RasterizedOutput",
 CellLabel->"Out[3]=",
 CellID->249163238,ExpressionUUID->"bae3ec2b-f73f-4b2f-bf5f-cde7eefae7b1"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"e5b47673-8462-4f9a-a63f-dca09dc8c1b0"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"0ac21f0f-22a8-4882-9e6f-488f4f16a3c6"],
 "Applications",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "eb109662-63c0-4474-85b3-f0be972e6f39"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->258228157,ExpressionUUID->"b345321c-2add-4663-a113-b7d02aa64fa0"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<NewEoSArgon`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->279378555,ExpressionUUID->"50d8033e-33ec-4cc4-9210-259009564304"],

Cell["\<\
Comparison with Streett data (Physica 76, 1974) on an isotherm close to the \
critical isotherm\
\>", "ExampleText",
 CellID->227520913,ExpressionUUID->"9cf51b5d-9f5e-4106-ae4b-b170346f8f71"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dataStreett150", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"23.1", ",", "80"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"24.17", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"27.08", ",", "200"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"29.95", ",", "400"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"31.73", ",", "600"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"33.07", ",", "800"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"34.16", ",", "1000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"35.08", ",", "1200"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"35.89", ",", "1400"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"36.61", ",", "1600"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"37.26", ",", "1800"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"37.86", ",", "2000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"38.41", ",", "2200"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"38.92", ",", "2400"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"39.4", ",", "2600"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"39.85", ",", "2800"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40.28", ",", "3000"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mol", "/", "l"}], ",", "atm"}], "*)"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243734080,ExpressionUUID->"40ba67c9-8ea5-4ae1-ae5d-b08a3351abd1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data150", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dataStreett150", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"PArgonNv", "[", 
          RowBox[{"150", ",", 
           RowBox[{
            RowBox[{"dataStreett150", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", 
            RowBox[{"M", "/", "1000"}]}]}], "]"}], "/", "1.01325"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "dataStreett150"}]}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"atm", ",", 
    RowBox[{"atm", "/", "K"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"P", "=", 
  RowBox[{"Interpolation", "[", "data150", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->123312038,ExpressionUUID->"1e4c5f31-43f2-4f91-a720-38dafda1a09f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}},
                     "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {23.10000000000005, 0}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {23.10000000000005, 0}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {23.10000000000005, 0}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {23.10000000000005, 0}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {23.1, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
              PlotRangeClipping -> True, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"23.1`", ",", "40.28`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[
             InterpretationBox[{
               TagBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
                "WolframDynamicHighlight", <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
               DynamicBox[
                (Charting`HighlightActionBox["DynamicHighlight", {}, 
                 Slot["HighlightElements"], 
                 Slot["LayoutOptions"], 
                 Slot["Meta"], 
                 Charting`HighlightActionFunction[
                 "DynamicHighlight", {{{{}, {}, 
                    Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
                  "HighlightElements" -> <|
                    "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                   "LayoutOptions" -> <|
                    "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}},
                     "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {23.10000000000005, 0}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                   "Meta" -> <|
                    "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
                 "HighlightElements" -> <|
                   "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                  "LayoutOptions" -> <|
                   "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
                    "Frame" -> {{True, True}, {True, True}}, 
                    "AxesOrigin" -> {23.10000000000005, 0}, 
                    "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                    "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                    "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                    False|>, 
                  "Meta" -> <|
                   "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                    "Function" -> Plot, "GroupHighlight" -> False|>|>]]}, 
              Annotation[{{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    Line[CompressedData["
1:eJwVxWlMEwYABlDQUSWAIJcQuUplQDaWhbFRSo+vLUGXEsNZZBAiFMcQuZQj
HAM5pGJprRWVY5Qbgh3HpMIACazVYDgkAgqIXCorJFhUjoJO2Pbj5REjE/zP
HdDS0qL+5/8zqVnSMkt3sKaN9psJgUiMLPybE+GOe5UdAcPOQViTp+gR2txx
hbfXeyuXiwKaVFKmcUezYPq0/mIwCLuv6wfoZPCqAhwMuCEwXDpSsi4g44GY
36g2CsV3+xeXNRNkBJNS58wnwzD/4wOTw/Ye0B/bSRWuhuPSoP2oLN4DQ630
zOeSsziRqVhx6vSAqfWrAqU8AmGhJ5daDlJwr7bhmw+6PLQl6VD1fSjQ695+
fJwXhbWeReKehAKLQfOkmbFzaP+25o1mgYLsPxJ1WjKiIX5Zrjvs6IkT/iod
pUMMNPJ0vcYUT3RcXSOWGMfi1EBKqanCE0GPu03MrOIg15bxw3Sp+KFBr2vX
IQFNCY8CfudSkZzP6TqvSESniWXeMykVfd6UtJ73SfB54yckvKUi+CN7PMTv
EkZUTaRhDxr6KUzugiIZ0UR3q5hcGuYvTESzXFNRxJe9PzJGg1zfODbwRRoG
SSHOomN0tFJwNiU7HesfSGvV4XTYqCodPF0zIVVPCHpldCyq5imfHH/FL3Z9
wrYNOsR3UJVmkYPubMEFGZMBZdCZJHbzZWwapj2niBiQWEp9p5/mgjNVUVv3
jIHRmjOqza08lCyPO1w7CnhJtcxcvQpwIyP5q7bvgamb5Y42wis42Fy/bR0C
yNU9XNVCIbrjTraLcwDvvf2A8MiryBolHE+sA+4e22Vw54qQryQnBwwByWKL
EWGxAKWB/Ow6NXDZRdTf7SqEfU7UaZoxEwzFTp/faxHWGXL9WTITlb5ddoej
xRiqsMtaDmPiY4R4isG9gRXh/sxGPhNyp7fxo1ESZFrGfebcZYK32Lyjm3ET
VtA8NXrChFpZtMPml0D780bJzCYT1ZyOa586b2Ej0EDX0JKFcvOHAy1ztxHq
fZ8lorKgdqM/uq1bCsKTsfNHeSy8W+CpBaFl6H9H8NLmsyD2vJ8ZUleO3uZ2
va0WFmLbR/6yNfsNX/+zUuo6yYIL+aeRnuuVkK3Spl5qWKjJIxkQtaoQH6fz
hcCGjWKOQjPnWw168epSA4uNQgm/1da6Bv5MtD6MYcNq3DxXpFOL2esOcBGz
US1ycj60XYuL6Y75B+RsiBsHIgxe1cFnt0I++4KNLxMS01LW6+Fm6nKHuM+G
sodSvqVpgJvtyKEpkhfiKT9P/mnUhH8BQPK6cA==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PlotRange" -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
                  "Frame" -> {{True, True}, {True, True}}, 
                  "AxesOrigin" -> {23.10000000000005, 0}, 
                  "ImageSize" -> {360, 360}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> ({
                    Identity[
                    Part[#, 1]], 
                    Identity[
                    Part[#, 2]]}& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> Plot, "GroupHighlight" -> False|>|>, 
               "DynamicHighlight"]], {
             DisplayFunction -> Identity, DisplayFunction -> Identity, 
              Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {23.10000000000005, 0}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {23.1, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{23.1, 40.28}, {0., 2952.3609954782796`}}, 
              PlotRangeClipping -> True, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"23.1`", ",", "40.28`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{23.1, 40.28}}, {
   5, 7, 0, {17}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{23.1, 24.17, 
   27.08, 29.95, 31.73, 33.07, 34.16, 35.08, 35.89, 36.61, 37.26, 37.86, 
   38.41, 38.92, 39.4, 39.85, 40.28}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
    14, 15, 16, 17}, {80.10412121139976, 99.71617134179691, 
    197.53918805173652`, 394.572026683496, 592.8389218638678, 
    792.4811096666475, 991.8965698798565, 1188.3679056199035`, 
    1383.9051997577003`, 1576.4451216683317`, 1766.7853383540082`, 
    1958.3961845565834`, 2149.923629441479, 2343.6373848789267`, 
    2542.2931033250197`, 2744.3519841764155`, 2952.3611414122247`}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->478321396,ExpressionUUID->"19fb3e3f-c29a-4605-89f5-4129248c1c51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Legended", "[", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P", "[", "x", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "20", ",", "45"}], "}"}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"20", ",", "0"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"All", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3500"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"\[Rho]\",FontSlant->\"Italic\"]\) (mol/l)\>\"", 
         ",", "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\) (atm)\>\"", 
         ",", "\"\<ISOTHERM 150 K\>\""}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Red", "}"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "450"}], ",", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "\[Rule]", "Medium"}], ",", 
         RowBox[{"Map", "[", 
          RowBox[{"Point", ",", "dataStreett150"}], "]"}]}], "}"}]}]}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"PointLegend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", "\"\<STREETT (1974)\>\"", "}"}]}], "]"}], ",", 
       "Below"}], "]"}], ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{
         RowBox[{"{", "Red", "}"}], ",", 
         RowBox[{
         "{", "\"\<PArgonNv[\!\(\*StyleBox[\"T\",FontSlant->\"Italic\"]\),\
\[Rho]]\>\"", "}"}]}], "]"}], ",", "Below"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283061935,ExpressionUUID->"de8bda3b-aa26-4f7c-8b85-038f13b7379a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJwBIQPe/CFib1JlAgAAADEAAAACAAAAUk+PCAAANEACZ6AkEaJFQJDy0Yb2
ATRAM+1BLiKtRUDPlRQF7QM0QDG/Qh8wuEVATNyZAdoHNEDi2M3UQs5FQEZp
pPqzDzRAFuT6W0T6RUA7g7nsZx80QNtgOEq+UUZAJLfj0M8+NEBGLIEiwf5G
QPUeOJmffTRAA89LpJ5SSEDdYJNA0AU1QLjItg7GJktA9VgEfPqENUBHiafd
MtZNQO5FvyGmATZAgPsp02lQUEArpSze4og2QJey2Pac+1FAmLqvLhkHN0Cx
L83MPL9TQEpC5ZXgjzdAu/oChRf0VUDdvmRnKRY4QLXJ7SDYfFhAn/H5zGuT
OECueBkeED5bQKaWQUk/GzlAatAxOUS5XkDc8Z5ZDJo5QBTKo64BQGFA9EFG
1FoWOkBgOj7/fmBjQFAEoGU6nTpAr0LTj7QGZkDcfA+LExs7QPuqY9fL2GhA
rGcxx32jO0BzZmnMv0ZsQF5HnW1pKTxAdJnCQiQOcEA/3R6oTqY8QIZZgUNJ
EnJAZeVS+cQtPUCnKUhDXId0QLqjnN40rD1ATf3GaZsYd0BU1JjaNTU+QA+Q
moA6MXpAz/neQLi7PkCQcj625pN9QHrVOjs0OT9ASy0R1X+JgEBpI0lMQcE/
QGqvaNsEoYJAxJO2+CMgQECN1ZcOEseEQESQbQBoXkBAe/Gld+QTh0DmxX2T
9KFAQB1SxZVRzYlAoNaY8P3gQECGRtba1JGMQHwgDdlPJUFApFdmfuPSj0DJ
ZKZ2YmhBQG3pCqKZpJFALYRK3vGmQUD3wK9UVmGTQLTcR9HJ6kFAeELetwJn
lUBSEFCOHipCQOkgyXFwbJdAYT59ADRoQkDI5Sbin4mZQJKlA/6Rq0JAOUl2
vgb+m0Db55TFbOpCQPMe8N+Mc55ARmN/GJAuQ0AejQUYVqqgQMm5dDUwbkNA
E5+f6JYgokC9Co8HkaxDQPhEP60QsKNA05QCZTrwQ0Di0AUdwImlQAH6gIxg
L0RAiUynarxrp0BRmFg/z3NEQEnUyBuXo6lAQX4CnDekREAAAAAAAFirQPbd
XXA=
             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]], 
              Line[CompressedData["
1:eJwBIQPe/CFib1JlAgAAADEAAAACAAAAUk+PCAAANEACZ6AkEaJFQJDy0Yb2
ATRAM+1BLiKtRUDPlRQF7QM0QDG/Qh8wuEVATNyZAdoHNEDi2M3UQs5FQEZp
pPqzDzRAFuT6W0T6RUA7g7nsZx80QNtgOEq+UUZAJLfj0M8+NEBGLIEiwf5G
QPUeOJmffTRAA89LpJ5SSEDdYJNA0AU1QLjItg7GJktA9VgEfPqENUBHiafd
MtZNQO5FvyGmATZAgPsp02lQUEArpSze4og2QJey2Pac+1FAmLqvLhkHN0Cx
L83MPL9TQEpC5ZXgjzdAu/oChRf0VUDdvmRnKRY4QLXJ7SDYfFhAn/H5zGuT
OECueBkeED5bQKaWQUk/GzlAatAxOUS5XkDc8Z5ZDJo5QBTKo64BQGFA9EFG
1FoWOkBgOj7/fmBjQFAEoGU6nTpAr0LTj7QGZkDcfA+LExs7QPuqY9fL2GhA
rGcxx32jO0BzZmnMv0ZsQF5HnW1pKTxAdJnCQiQOcEA/3R6oTqY8QIZZgUNJ
EnJAZeVS+cQtPUCnKUhDXId0QLqjnN40rD1ATf3GaZsYd0BU1JjaNTU+QA+Q
moA6MXpAz/neQLi7PkCQcj625pN9QHrVOjs0OT9ASy0R1X+JgEBpI0lMQcE/
QGqvaNsEoYJAxJO2+CMgQECN1ZcOEseEQESQbQBoXkBAe/Gld+QTh0DmxX2T
9KFAQB1SxZVRzYlAoNaY8P3gQECGRtba1JGMQHwgDdlPJUFApFdmfuPSj0DJ
ZKZ2YmhBQG3pCqKZpJFALYRK3vGmQUD3wK9UVmGTQLTcR9HJ6kFAeELetwJn
lUBSEFCOHipCQOkgyXFwbJdAYT59ADRoQkDI5Sbin4mZQJKlA/6Rq0JAOUl2
vgb+m0Db55TFbOpCQPMe8N+Mc55ARmN/GJAuQ0AejQUYVqqgQMm5dDUwbkNA
E5+f6JYgokC9Co8HkaxDQPhEP60QsKNA05QCZTrwQ0Di0AUdwImlQAH6gIxg
L0RAiUynarxrp0BRmFg/z3NEQEnUyBuXo6lAQX4CnDekREAAAAAAAFirQPbd
XXA=
               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, {0., 3500.}}, 
            "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {20., 0.}, "ImageSize" -> {450, 450/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, {0., 3500.}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {20., 0.},
            "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJwBIQPe/CFib1JlAgAAADEAAAACAAAAUk+PCAAANEACZ6AkEaJFQJDy0Yb2
ATRAM+1BLiKtRUDPlRQF7QM0QDG/Qh8wuEVATNyZAdoHNEDi2M3UQs5FQEZp
pPqzDzRAFuT6W0T6RUA7g7nsZx80QNtgOEq+UUZAJLfj0M8+NEBGLIEiwf5G
QPUeOJmffTRAA89LpJ5SSEDdYJNA0AU1QLjItg7GJktA9VgEfPqENUBHiafd
MtZNQO5FvyGmATZAgPsp02lQUEArpSze4og2QJey2Pac+1FAmLqvLhkHN0Cx
L83MPL9TQEpC5ZXgjzdAu/oChRf0VUDdvmRnKRY4QLXJ7SDYfFhAn/H5zGuT
OECueBkeED5bQKaWQUk/GzlAatAxOUS5XkDc8Z5ZDJo5QBTKo64BQGFA9EFG
1FoWOkBgOj7/fmBjQFAEoGU6nTpAr0LTj7QGZkDcfA+LExs7QPuqY9fL2GhA
rGcxx32jO0BzZmnMv0ZsQF5HnW1pKTxAdJnCQiQOcEA/3R6oTqY8QIZZgUNJ
EnJAZeVS+cQtPUCnKUhDXId0QLqjnN40rD1ATf3GaZsYd0BU1JjaNTU+QA+Q
moA6MXpAz/neQLi7PkCQcj625pN9QHrVOjs0OT9ASy0R1X+JgEBpI0lMQcE/
QGqvaNsEoYJAxJO2+CMgQECN1ZcOEseEQESQbQBoXkBAe/Gld+QTh0DmxX2T
9KFAQB1SxZVRzYlAoNaY8P3gQECGRtba1JGMQHwgDdlPJUFApFdmfuPSj0DJ
ZKZ2YmhBQG3pCqKZpJFALYRK3vGmQUD3wK9UVmGTQLTcR9HJ6kFAeELetwJn
lUBSEFCOHipCQOkgyXFwbJdAYT59ADRoQkDI5Sbin4mZQJKlA/6Rq0JAOUl2
vgb+m0Db55TFbOpCQPMe8N+Mc55ARmN/GJAuQ0AejQUYVqqgQMm5dDUwbkNA
E5+f6JYgokC9Co8HkaxDQPhEP60QsKNA05QCZTrwQ0Di0AUdwImlQAH6gIxg
L0RAiUynarxrp0BRmFg/z3NEQEnUyBuXo6lAQX4CnDekREAAAAAAAFirQPbd
XXA=
            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, {0., 3500.}}, 
         "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {20., 0.}, 
         "ImageSize" -> {450, 450/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {20., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {20., 0.}, DisplayFunction :> 
     Identity, Epilog -> {PointSize -> Medium, {
        PointBox[{23.1, 80}], 
        PointBox[{24.17, 100}], 
        PointBox[{27.08, 200}], 
        PointBox[{29.95, 400}], 
        PointBox[{31.73, 600}], 
        PointBox[{33.07, 800}], 
        PointBox[{34.16, 1000}], 
        PointBox[{35.08, 1200}], 
        PointBox[{35.89, 1400}], 
        PointBox[{36.61, 1600}], 
        PointBox[{37.26, 1800}], 
        PointBox[{37.86, 2000}], 
        PointBox[{38.41, 2200}], 
        PointBox[{38.92, 2400}], 
        PointBox[{39.4, 2600}], 
        PointBox[{39.85, 2800}], 
        PointBox[{40.28, 3000}]}}, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\) \
(atm)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"\[Rho]\\\",FontSlant->\\\"Italic\\\"]\\) \
(mol/l)\"", HoldForm], TraditionalForm], 
        FormBox[
         TagBox["\"ISOTHERM 150 K\"", HoldForm], TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 450, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, {0., 3500.}}, 
     PlotRangeClipping -> True, 
     PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    TemplateBox[{"\[ThinSpace]", "\" \"", 
      FormBox[
       TemplateBox[{"\"STREETT (1974)\""}, "PointLegend", 
        DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    AbsolutePointSize[6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"PointLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"AbsolutePointSize", "[", "6", "]"}]}], "]"}], 
               "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm], 
      FormBox[
       TemplateBox[{
        "\"PArgonNv[\\!\\(\\*StyleBox[\\\"T\\\",FontSlant->\\\"Italic\\\"]\\),\
\[Rho]]\""}, "LineLegend", DisplayFunction -> (FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ), 
        InterpretationFunction :> (RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               
               TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                "RGBColorSwatchTemplate"], "}"}], ",", 
             RowBox[{"{", #, "}"}]}], "]"}]& ), Editable -> True], 
       TraditionalForm]}, "RowWithSeparators"], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellLabel->"Out[4]=",
 CellID->330517326,ExpressionUUID->"2a3330ef-6c24-436b-a9d3-5489d8f99d90"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]},
      {Cell[TextData[{
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["RhoArgonNv"]], "paclet:NewEoSArgon/ref/RhoArgonNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "d6828318-e5db-4268-b766-784fa9f13f08"],
        "\[NonBreakingSpace]",
        StyleBox[
        "\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
         "InlineSeparator"],
        " ",
        Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["ZtotalNv"]], "paclet:NewEoSArgon/ref/ZtotalNv", 
           "NewEoSArgon Package Symbol"},
          "PackageLink",
          BaseStyle->"InlineFormula"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "6124fc3c-ead8-4d92-88a7-d4a67af4daf6"]
       }], "SeeAlso",ExpressionUUID->"299bd1c0-e356-4149-bf7d-1e970226ce6d"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"97766c56-4573-484a-86f6-\
ecf24952ba46"],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, "RelatedGuide.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"Related", " ", "Guides"}], "MoreAboutSection"]},
      {
       RowBox[{"\[FilledVerySmallSquare]", Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData["NewEoSArgon Package"]], 
           "paclet:NewEoSArgon/guide/NewEoSArgon"},
          "RefLinkPlain",
          BaseStyle->{"MoreAbout"}]], "MoreAbout",ExpressionUUID->
         "8ee629ee-6f7a-431c-b78f-0d3c5130adb8"]}]}
     }]}
  }]], "MoreAboutSection",ExpressionUUID->"e6d4bbae-384d-43ea-8c49-\
8cb700d1558b"],

Cell[BoxData[GridBox[{
   {
    TemplateBox[{29},
     "Spacer1"], GridBox[{
      {
       RowBox[{
        TemplateBox[{17},
         "Spacer1"], 
        StyleBox[
         RowBox[{"Related", " ", "Links"}], "RelatedLinksSection"]}]},
      {Cell[BoxData[Cell[BoxData[
         TemplateBox[{
           Cell[
            TextData[
             RowBox[{
               RowBox[{"Units", " ", "&"}], " ", "Quantities"}]]], 
           "paclet:guide/Units"},
          "RefLinkPlain",
          BaseStyle->{"RelatedLinks"}]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "835ea25a-40d2-4850-a3a4-b8d21d7e8292"]], "RelatedLinks",
        ExpressionUUID->"c1537e1d-624f-42e1-a467-e874448b235e"]},
      {Cell[BoxData[Cell[BoxData[Cell[BoxData[
          RowBox[{
           TemplateBox[{16},
            "Spacer1"], "\[FilledVerySmallSquare]", 
           TemplateBox[{
             Cell[
              TextData[
               Cell[
                TextData[{
                  Cell[
                   BoxData[
                    TemplateBox[{2}, "Spacer1"]]], "ThermodynamicData"}]]]], 
             "paclet:ref/ThermodynamicData"},
            "RefLink",
            BaseStyle->{"RelatedLinks"}]}]],ExpressionUUID->
          "8f236ce8-15d1-4385-a9dd-fa261e4c725b"]], "InlineFormula",
         FontFamily->"Source Sans Pro",ExpressionUUID->
         "b2fa458d-f634-4405-b1b4-40b16326b4a8"]], "RelatedLinks",
        ExpressionUUID->"310a095f-3b01-4990-bc74-122de933224f"]}
     }]}
  }]], "RelatedLinksSection",ExpressionUUID->"9a8c9200-454a-4d27-bf66-\
17c197df4c8a"],

Cell[" ", "FooterCell",ExpressionUUID->"3d81b6f3-93f8-474c-8aa6-2132bca399e7"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 835.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PArgonNv",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "HasOptions" -> True, "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "2" -> Closed}, "NotesSection" -> 
    Closed}, "NewStyles" -> True, "CitationPopupData" -> $Failed, 
  "ShowCitation" -> False, "RootCaptions" -> "", 
  "Metadata" -> {
   "built" -> "{2023, 11, 30, 13, 55, 43.5517118}", 
    "history" -> {"XX", "", "", ""}, "context" -> "NewEoSArgon`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "New Eo S Argon Package Symbol", "language" -> "en", "paclet" -> 
    "NewEoSArgon Package", "status" -> "None", "summary" -> 
    "PArgonNv[T, \\[Rho]] \\[Congruent] P (bar) Pression de l'argon en \
fonction de T (Kelvin) et de \\[Rho] (g/cm^3) [Thermal equation of state of \
argon P(T,\\[Rho])]", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "PArgonNv", "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PArgonNv", "type" -> "Symbol", "uri" -> "NewEoSArgon/ref/PArgonNv"}},
CellContext->"Global`",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "13.3 pour Microsoft Windows (64-bit) (July 24, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"bc5e802c-6c65-483d-abc8-55f9609e22e1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11534, 336, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"219113df-1ffa-4db9-bbb8-25bc9b405287",
   CellTags->"PrimaryExamplesSection",
   CellID->147787628]},
 "RasterizedOutput"->{
  Cell[18508, 530, 42063, 696, 346, "Output",ExpressionUUID->"bae3ec2b-f73f-4b2f-bf5f-cde7eefae7b1",
   CellTags->"RasterizedOutput",
   CellID->249163238]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 119737, 2525},
 {"RasterizedOutput", 119937, 2529}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[580, 21, 5290, 129, 56, "AnchorBarGrid",ExpressionUUID->"8c982409-7a48-4e69-9034-b21f73267270",
 CellID->1],
Cell[5873, 152, 94, 0, 23, "ContextNameCell",ExpressionUUID->"b1b7dfa6-8983-44ad-96cb-e2d3e3d94391"],
Cell[CellGroupData[{
Cell[5992, 156, 551, 14, 56, "ObjectNameGrid",ExpressionUUID->"fe5b7fb5-afb9-48f5-9612-aad0eb084500"],
Cell[6546, 172, 798, 24, 146, "Usage",ExpressionUUID->"fd9fbca7-8d07-4a46-b499-5d1f0b563308"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7381, 201, 1919, 48, 37, "NotesSection",ExpressionUUID->"e428873e-3072-4d9d-83be-c8884f8aecfe",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->883678972],
Cell[9303, 251, 529, 16, 38, "Notes",ExpressionUUID->"230e0a6a-8e83-4971-b4bc-dc4b78145dea",
 CellID->1067943069],
Cell[9835, 269, 442, 18, 36, "Notes",ExpressionUUID->"9cf179f1-d64b-47aa-8380-4571e8a46fcc",
 CellID->524000197],
Cell[10280, 289, 186, 4, 36, "Notes",ExpressionUUID->"749711d9-fb83-4289-aa60-4a6b3cfed489",
 CellID->224665577],
Cell[10469, 295, 519, 16, 38, "Notes",ExpressionUUID->"5f98246a-f43c-4714-8941-8837c7612f29",
 CellID->51803587],
Cell[10991, 313, 416, 17, 36, "Notes",ExpressionUUID->"b19414f3-ac1c-4c74-9a89-5e336321ece2",
 CellID->508850368]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11534, 336, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"219113df-1ffa-4db9-bbb8-25bc9b405287",
 CellTags->"PrimaryExamplesSection",
 CellID->147787628],
Cell[CellGroupData[{
Cell[12979, 377, 1397, 36, 30, "ExampleSection",ExpressionUUID->"1c18321b-8c5f-40ef-826b-bb2bfb2386d8",
 CellID->69832724],
Cell[14379, 415, 267, 5, 42, "Input",ExpressionUUID->"35e99a34-5a60-4dea-b48d-de760fa53cc0",
 CellID->87419684],
Cell[14649, 422, 130, 1, 38, "ExampleText",ExpressionUUID->"7871ad83-e8cc-49e2-9a20-2ad7b06ace52",
 CellID->32289193],
Cell[CellGroupData[{
Cell[14804, 427, 1194, 36, 102, "Input",ExpressionUUID->"7c0b9a1d-d732-4fd5-b4b9-0b8ac989d5e0",
 CellID->86367826],
Cell[16001, 465, 202, 2, 22, "Print",ExpressionUUID->"5c55f0af-beb7-4e8a-b37f-80ffe5591c77",
 CellID->191458455],
Cell[16206, 469, 220, 4, 40, "Output",ExpressionUUID->"f91e5c4e-290c-4194-881e-5ece998a715e",
 CellID->134042620],
Cell[16429, 475, 221, 4, 40, "Output",ExpressionUUID->"a31e8770-5e92-4c66-9223-a229129e6087",
 CellID->562112683],
Cell[16653, 481, 204, 2, 22, "Print",ExpressionUUID->"9fba29c1-d54b-4970-b978-954b142d4608",
 CellID->292273912],
Cell[16860, 485, 220, 4, 40, "Output",ExpressionUUID->"a0d327b2-f510-4069-864c-d653b606dbe5",
 CellID->259895498]
}, Open  ]],
Cell[17095, 492, 140, 1, 38, "ExampleText",ExpressionUUID->"35f0cc77-f663-4ba5-b4b4-a0c772c96a96",
 CellID->286706321],
Cell[CellGroupData[{
Cell[17260, 497, 1245, 31, 61, "Input",ExpressionUUID->"a323a525-9eae-455b-81ab-3aa395ffaa9a",
 CellID->605199954],
Cell[18508, 530, 42063, 696, 346, "Output",ExpressionUUID->"bae3ec2b-f73f-4b2f-bf5f-cde7eefae7b1",
 CellTags->"RasterizedOutput",
 CellID->249163238]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[60720, 1234, 1419, 37, 70, "ExampleSection",ExpressionUUID->"b345321c-2add-4663-a113-b7d02aa64fa0",
 CellID->258228157],
Cell[62142, 1273, 268, 5, 70, "Input",ExpressionUUID->"50d8033e-33ec-4cc4-9210-259009564304",
 CellID->279378555],
Cell[62413, 1280, 201, 4, 70, "ExampleText",ExpressionUUID->"9cf51b5d-9f5e-4106-ae4b-b170346f8f71",
 CellID->227520913],
Cell[62617, 1286, 1521, 44, 70, "Input",ExpressionUUID->"40ba67c9-8ea5-4ae1-ae5d-b08a3351abd1",
 CellID->243734080],
Cell[CellGroupData[{
Cell[64163, 1334, 1006, 29, 70, "Input",ExpressionUUID->"1e4c5f31-43f2-4f91-a720-38dafda1a09f",
 CellID->123312038],
Cell[65172, 1365, 29294, 563, 70, "Output",ExpressionUUID->"19fb3e3f-c29a-4605-89f5-4129248c1c51",
 CellID->478321396]
}, Open  ]],
Cell[CellGroupData[{
Cell[94503, 1933, 2096, 57, 70, "Input",ExpressionUUID->"de8bda3b-aa26-4f7c-8b85-038f13b7379a",
 CellID->283061935],
Cell[96602, 1992, 17136, 374, 353, "Output",ExpressionUUID->"2a3330ef-6c24-436b-a9d3-5489d8f99d90",
 CellID->330517326]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[113980, 2375, 1367, 36, 70, "SeeAlsoSection",ExpressionUUID->"97766c56-4573-484a-86f6-ecf24952ba46"],
Cell[115350, 2413, 729, 19, 70, "MoreAboutSection",ExpressionUUID->"e6d4bbae-384d-43ea-8c49-8cb700d1558b"],
Cell[116082, 2434, 1607, 43, 70, "RelatedLinksSection",ExpressionUUID->"9a8c9200-454a-4d27-bf66-17c197df4c8a"],
Cell[117692, 2479, 78, 0, 70, "FooterCell",ExpressionUUID->"3d81b6f3-93f8-474c-8aa6-2132bca399e7"]
}
]
*)

(* End of internal cache information *)

